/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.testharness;

import java.util.Arrays;
import org.fujion.annotation.WiredComponent;
import org.fujion.component.BaseComponent;
import org.fujion.highcharts.AlignHorizontal;
import org.fujion.highcharts.AlignVertical;
import org.fujion.highcharts.Axis;
import org.fujion.highcharts.Chart;
import org.fujion.highcharts.Orientation;
import org.fujion.highcharts.PlotLineOptions;
import org.fujion.highcharts.Series;
import org.fujion.testharness.BaseChartController;

public class HighchartsController
extends BaseChartController {
    @WiredComponent
    private Chart hchart;

    public void afterInitialized(BaseComponent root) {
        this.hchart.setTitle("Highcharts: Monthly Average Temperature");
        this.hchart.setSubtitle("Source: WorldClimate.com");
        Axis xAxis = this.hchart.getXAxis();
        xAxis.categories.addAll(Arrays.asList(CATEGORIES));
        Axis yAxis = this.hchart.getYAxis();
        yAxis.title.text = "Temperature (\u00b0C)";
        PlotLineOptions plo = new PlotLineOptions();
        yAxis.plotLines.add(plo);
        plo.value = 0.0;
        plo.width = 1;
        plo.color = "#808080";
        this.hchart.instance.getTooltip().valueSuffix = "\u00b0C";
        this.hchart.instance.getLegend().layout = Orientation.vertical;
        this.hchart.instance.getLegend().align = AlignHorizontal.right;
        this.hchart.instance.getLegend().verticalAlign = AlignVertical.middle;
        this.hchart.instance.getLegend().borderWidth = 0;
        this.addSeries("Tokyo", TOKYO);
        this.addSeries("New York", NEW_YORK);
        this.addSeries("Berlin", BERLIN);
        this.addSeries("London", LONDON);
        this.hchart.run();
    }

    private void addSeries(String name, double[] data) {
        Series series = this.hchart.addSeries();
        series.name = name;
        for (double value : data) {
            series.addDataPoint(value);
        }
    }
}

