/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.testharness;

import org.apache.commons.lang.math.NumberUtils;
import org.fujion.ancillary.IAutoWired;
import org.fujion.annotation.EventHandler;
import org.fujion.annotation.WiredComponent;
import org.fujion.component.BaseComponent;
import org.fujion.component.Checkbox;
import org.fujion.component.Memobox;
import org.fujion.component.Page;
import org.fujion.component.Tab;
import org.fujion.component.Tabview;
import org.fujion.event.ChangeEvent;
import org.fujion.event.Event;

public class MainController
implements IAutoWired {
    @WiredComponent
    private Tabview tabview;
    @WiredComponent
    private Memobox statusLog;
    private int logCount;

    public void afterInitialized(BaseComponent root) {
        Page page = root.getPage();
        int tabIndex = NumberUtils.toInt((String)page.getQueryParam("tab"));
        tabIndex = tabIndex < 0 ? this.tabview.getChildCount() + tabIndex : tabIndex;
        this.tabview.setSelectedTab((Tab)this.tabview.getChildAt(tabIndex));
        page.setAttribute((Object)"mainController", (Object)this);
    }

    @EventHandler(value={"click"}, target={"btnClearLog"})
    public void btnClearLogHandler() {
        this.statusLog.clear();
        this.logCount = 0;
    }

    @EventHandler(value={"change"}, target={"chkScrollLock"})
    public void chkScrollLockHandler(ChangeEvent event) {
        this.statusLog.setAutoScroll(((Checkbox)event.getTarget()).isChecked());
    }

    @EventHandler(value={"log"}, target={"^/page"})
    private void onInfo(Event event) {
        this.log((String)event.getData());
    }

    public void log(String message) {
        if (message != null && !message.isEmpty()) {
            String value = (String)this.statusLog.getValue();
            this.statusLog.setValue((Object)((value == null ? "" : value) + ++this.logCount + ". " + message + "\n\n"));
        }
    }
}

