/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.testharness;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.fujion.annotation.EventHandler;
import org.fujion.annotation.WiredComponent;
import org.fujion.component.Button;
import org.fujion.component.Checkbox;
import org.fujion.component.Radiobutton;
import org.fujion.component.Upload;
import org.fujion.event.ChangeEvent;
import org.fujion.event.ClickEvent;
import org.fujion.event.UploadEvent;
import org.fujion.testharness.BaseController;
import org.fujion.testharness.ButtonsController;

public class ButtonsController
extends BaseController {
    @WiredComponent
    private Button btnWithEvent;
    @WiredComponent
    private Checkbox chkMultiple;
    @WiredComponent
    private Upload upload;

    @EventHandler(value={"click"}, target={"@btnWithEvent"})
    private void btnEventHandler() {
        this.log("Button event handler was invoked");
    }

    public void btnEventHandler(ClickEvent event) {
        this.log("Attribute bound event handler was invoked");
    }

    @EventHandler(value={"change"}, target={"rg1", "rg2"})
    private void radiobuttonChangeHandler(ChangeEvent event) {
        Radiobutton rb = (Radiobutton)event.getValue(Radiobutton.class);
        this.log("Radiobutton '" + rb.getLabel() + "' was " + (rb.isChecked() ? "selected." : "deselected."));
    }

    @EventHandler(value={"upload"}, target={"@upload"})
    private void uploadHandler(UploadEvent event) throws Exception {
        String file = event.getFile();
        switch (1.$SwitchMap$org$fujion$event$UploadEvent$UploadState[event.getState().ordinal()]) {
            case 1: {
                String tmpdir = FileUtils.getTempDirectoryPath();
                file = tmpdir + "/" + file;
                FileOutputStream out = new FileOutputStream(file);
                IOUtils.copy((InputStream)event.getBlob(), (OutputStream)out);
                out.close();
                this.log("Uploaded contents to " + file);
                break;
            }
            case 2: {
                this.log("File too large: " + file);
                break;
            }
            case 3: {
                this.log("Upload aborted for " + file);
                break;
            }
            case 4: {
                double pct = (double)event.getLoaded() * 100.0 / (double)event.getTotal();
                this.log("Upload " + pct + "% completed for " + file);
            }
        }
    }

    @EventHandler(value={"change"}, target={"@chkMultiple"})
    private void chkMultipleChangeHandler(ChangeEvent event) {
        this.upload.setMultiple(this.chkMultiple.isChecked());
    }
}

