/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.testharness;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Calendar;
import org.apache.commons.io.IOUtils;
import org.fujion.annotation.EventHandler;
import org.fujion.annotation.WiredComponent;
import org.fujion.canvas.BaseCanvasComponent;
import org.fujion.canvas.d2.Canvas2D;
import org.fujion.canvas.d2.CanvasGradient;
import org.fujion.canvas.d2.LineCap;
import org.fujion.canvas.d2.RenderingContext2D;
import org.fujion.canvas.d2.TextAlign;
import org.fujion.canvas.d2.TextBaseline;
import org.fujion.canvas.webgl.ArrayBuffer;
import org.fujion.canvas.webgl.ArrayBufferBase;
import org.fujion.canvas.webgl.BufferBinding;
import org.fujion.canvas.webgl.BufferBitMask;
import org.fujion.canvas.webgl.BufferUsagePattern;
import org.fujion.canvas.webgl.CanvasWebGL;
import org.fujion.canvas.webgl.DrawMode;
import org.fujion.canvas.webgl.RenderingContextWebGL;
import org.fujion.canvas.webgl.ShaderType;
import org.fujion.canvas.webgl.ValueType;
import org.fujion.canvas.webgl.WebGLBuffer;
import org.fujion.canvas.webgl.WebGLProgram;
import org.fujion.canvas.webgl.WebGLShader;
import org.fujion.common.MiscUtil;
import org.fujion.common.StrUtil;
import org.fujion.component.Button;
import org.fujion.component.Doublebox;
import org.fujion.component.Timer;
import org.fujion.testharness.BaseController;

public class CanvasController
extends BaseController {
    @WiredComponent
    private Canvas2D canvas2D;
    @WiredComponent
    private Timer timer2D;
    @WiredComponent
    private Button btnRender2D;
    private RenderingContext2D d2;
    private double radius = 200.0;
    private static final int VIEWPORT_WIDTH = 500;
    private static final int VIEWPORT_HEIGHT = 500;
    @WiredComponent
    private CanvasWebGL canvasWebGL;
    @WiredComponent
    private Doublebox zoomCenterXInput;
    @WiredComponent
    private Doublebox zoomCenterYInput;
    @WiredComponent
    private Doublebox zoomOutput;
    @WiredComponent
    private Doublebox centerOffsetXOutput;
    @WiredComponent
    private Doublebox centerOffsetYOutput;
    @WiredComponent
    private Timer timerWebGL;
    @WiredComponent
    private Button btnRenderWebGL;
    private double zoom;
    private double zoomCenterX;
    private double zoomCenterY;
    private double centerOffsetX = 0.0;
    private double centerOffsetY = 0.0;
    private WebGLBuffer vertexPositionBuffer;
    private int aVertexPosition;
    private int aPlotPosition;
    private RenderingContextWebGL gl;
    double[][] baseCorners = new double[][]{{0.7, 1.2}, {-2.2, 1.2}, {0.7, -1.2}, {-2.2, -1.2}};

    @EventHandler(value={"click"}, target={"btnRender2D"})
    private void onClick$render2D() {
        if (this.timer2D.isRunning()) {
            this.timer2D.stop();
            this.btnRender2D.addClass("flavor:btn-success");
            this.log("2D rendering sequence stopped.");
        } else {
            this.init2D();
            this.timer2D.start();
            this.btnRender2D.addClass("flavor:btn-danger");
            this.log("2D rendering sequence started.");
        }
    }

    @EventHandler(value={"timer"}, target={"@timer2D"})
    private void onTimer$timer2D() {
        this.drawClock();
    }

    private void init2D() {
        this.d2 = (RenderingContext2D)this.canvas2D.newRenderingContext();
        this.radius = 200.0;
        this.d2.translate(this.radius, this.radius);
        this.radius *= 0.9;
        this.d2.setFont(this.radius * 0.15 + "px arial");
        this.d2.setTextBaseline(TextBaseline.MIDDLE);
        this.d2.setTextAlign(TextAlign.CENTER);
        this.drawClock();
    }

    private void drawClock() {
        this.drawFace();
        this.drawNumbers();
        this.drawTime();
        this.drawGlass();
    }

    private void drawFace() {
        this.d2.beginPath();
        this.d2.setFillStyle("white");
        CanvasGradient grad = this.d2.createRadialGradient(0.0, 0.0, this.radius * 0.95, 0.0, 0.0, this.radius * 1.05);
        grad.addColorStop(0.0, "#333");
        grad.addColorStop(0.5, "white");
        grad.addColorStop(1.0, "#333");
        this.d2.setStrokeStyle(grad);
        this.d2.setLineWidth(this.radius * 0.1);
        this.d2.arc(0.0, 0.0, this.radius, 0.0, Math.PI * 2);
        this.d2.fill();
        this.d2.stroke();
        this.d2.setStrokeStyle("#333");
        this.d2.beginPath();
        this.d2.setFillStyle("#333");
        this.d2.arc(0.0, 0.0, this.radius * 0.1, 0.0, Math.PI * 2);
        this.d2.fill();
    }

    private void drawNumbers() {
        for (int num = 1; num < 13; ++num) {
            double ang = (double)num * Math.PI / 6.0;
            this.d2.rotateRadians(ang);
            this.d2.translate(0.0, -this.radius * 0.85);
            this.d2.rotateRadians(-ang);
            this.d2.fillText(Integer.toString(num), 0.0, 0.0);
            this.d2.rotateRadians(ang);
            this.d2.translate(0.0, this.radius * 0.85);
            this.d2.rotateRadians(-ang);
        }
    }

    private void drawGlass() {
        CanvasGradient grad = this.d2.createRadialGradient(-0.4 * this.radius, -0.4 * this.radius, 0.0, -0.4 * this.radius, -0.4 * this.radius, 14.0 * this.radius / 12.0);
        grad.addColorStop(0.0, "rgba(255,255,255,0.8)");
        grad.addColorStop(1.0, "rgba(255,255,255,0.0)");
        this.d2.setFillStyle(grad);
        this.d2.beginPath();
        this.d2.arc(0.0, 0.0, this.radius, 0.0, Math.PI * 2);
        this.d2.fill();
    }

    private void drawTime() {
        Calendar now = Calendar.getInstance();
        double hour = now.get(10);
        double minute = now.get(12);
        double second = now.get(13);
        hour %= 12.0;
        hour = hour * Math.PI / 6.0 + minute * Math.PI / 360.0 + second * Math.PI / 21600.0;
        this.drawHand(hour, this.radius * 0.5, this.radius * 0.07);
        minute = minute * Math.PI / 30.0 + second * Math.PI / 1800.0;
        this.drawHand(minute, this.radius * 0.8, this.radius * 0.07);
        second = second * Math.PI / 30.0;
        this.drawHand(second, this.radius * 0.9, this.radius * 0.02);
    }

    private void drawHand(double pos, double length, double width) {
        this.d2.beginPath();
        this.d2.setLineWidth(width);
        this.d2.setLineCap(LineCap.ROUND);
        this.d2.moveTo(0.0, 0.0);
        this.d2.rotateRadians(pos);
        this.d2.lineTo(0.0, -length);
        this.d2.stroke();
        this.d2.rotateRadians(-pos);
    }

    @EventHandler(value={"click"}, target={"@btnRenderWebGL"})
    private void onClick$renderWebGL() {
        if (this.timerWebGL.isRunning()) {
            this.timerWebGL.stop();
            this.btnRenderWebGL.addClass("flavor:btn-success");
            this.log("WebGL rendering sequence stopped.");
        } else {
            this.initWebGL();
            this.timerWebGL.start();
            this.btnRenderWebGL.addClass("flavor:btn-danger");
            this.log("WebGL rendering sequence started.");
        }
    }

    private void initWebGL() {
        this.resetZoom();
        this.gl = (RenderingContextWebGL)this.canvasWebGL.newRenderingContext();
        this.initShaders();
        this.initBuffers();
        this.gl.clearColor(0.0, 0.0, 0.0, 1.0);
    }

    @EventHandler(value={"timer"}, target={"@timerWebGL"})
    private void onTimer$timerWebGL() {
        this.drawScene();
    }

    private void resetZoom() {
        this.zoom = 1.0;
        this.zoomCenterX = (Double)this.zoomCenterXInput.getValue();
        this.zoomCenterY = (Double)this.zoomCenterYInput.getValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WebGLShader getShader(ShaderType type, String id) {
        try (InputStream is = this.getClass().getResourceAsStream("/" + id + ".webgl");){
            String src = StrUtil.fromList((Iterable)IOUtils.readLines((InputStream)is, (Charset)StrUtil.UTF8));
            WebGLShader shader = this.gl.createShader(type);
            this.gl.shaderSource(shader, src);
            this.gl.compileShader(shader);
            WebGLShader webGLShader = shader;
            return webGLShader;
        }
        catch (IOException e) {
            throw MiscUtil.toUnchecked((Throwable)e);
        }
    }

    private void initShaders() {
        WebGLShader fragmentShader = this.getShader(ShaderType.FRAGMENT_SHADER, "shader-fs");
        WebGLShader vertexShader = this.getShader(ShaderType.VERTEX_SHADER, "shader-vs");
        WebGLProgram shaderProgram = this.gl.createProgram();
        this.gl.attachShader(shaderProgram, vertexShader);
        this.gl.attachShader(shaderProgram, fragmentShader);
        this.gl.linkProgram(shaderProgram);
        this.gl.useProgram(shaderProgram);
        this.gl.getAttribLocation(shaderProgram, "aVertexPosition", value -> {
            this.aVertexPosition = value;
            this.gl.enableVertexAttribArray(this.aVertexPosition);
        });
        this.gl.getAttribLocation(shaderProgram, "aPlotPosition", value -> {
            this.aPlotPosition = value;
            this.gl.enableVertexAttribArray(this.aPlotPosition);
        });
    }

    private void initBuffers() {
        this.vertexPositionBuffer = this.gl.createBuffer();
        this.gl.bindBuffer(BufferBinding.ARRAY_BUFFER, this.vertexPositionBuffer);
        double[] vertices = new double[]{1.0, 1.0, -1.0, 1.0, 1.0, -1.0, -1.0, -1.0};
        ArrayBuffer ary = new ArrayBuffer((BaseCanvasComponent)this.canvasWebGL, vertices);
        this.gl.bufferData(BufferBinding.ARRAY_BUFFER, (ArrayBufferBase)ary, BufferUsagePattern.STATIC_DRAW);
    }

    private void drawScene() {
        this.gl.viewport(0, 0, 500, 500);
        this.gl.clear(new BufferBitMask[]{BufferBitMask.COLOR_BUFFER_BIT, BufferBitMask.DEPTH_BUFFER_BIT});
        this.gl.bindBuffer(BufferBinding.ARRAY_BUFFER, this.vertexPositionBuffer);
        this.gl.vertexAttribPointer(this.aVertexPosition, 2, ValueType.FLOAT, false, 0, 0);
        WebGLBuffer plotPositionBuffer = this.gl.createBuffer();
        this.gl.bindBuffer(BufferBinding.ARRAY_BUFFER, plotPositionBuffer);
        double[] corners = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        int idx = 0;
        for (double[] cornerIx : this.baseCorners) {
            double x = cornerIx[0];
            double y = cornerIx[1];
            corners[idx++] = x / this.zoom + this.centerOffsetX;
            corners[idx++] = y / this.zoom + this.centerOffsetY;
        }
        ArrayBuffer ary = new ArrayBuffer((BaseCanvasComponent)this.canvasWebGL, corners);
        this.gl.bufferData(BufferBinding.ARRAY_BUFFER, (ArrayBufferBase)ary, BufferUsagePattern.STATIC_DRAW);
        this.gl.vertexAttribPointer(this.aPlotPosition, 2, ValueType.FLOAT, false, 0, 0);
        this.gl.drawArrays(DrawMode.TRIANGLE_STRIP, 0, 4);
        this.gl.deleteBuffer(plotPositionBuffer);
        this.zoom *= 1.02;
        this.zoomOutput.setValue((Object)this.zoom);
        if (this.centerOffsetX != this.zoomCenterX) {
            this.centerOffsetX += (this.zoomCenterX - this.centerOffsetX) / 20.0;
        }
        this.centerOffsetXOutput.setValue((Object)this.centerOffsetX);
        if (this.centerOffsetY != this.zoomCenterY) {
            this.centerOffsetY += (this.zoomCenterY - this.centerOffsetY) / 20.0;
        }
        this.centerOffsetYOutput.setValue((Object)this.centerOffsetY);
    }
}

