/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.testharness;

import org.fujion.annotation.WiredComponent;
import org.fujion.chartjs.Chart;
import org.fujion.chartjs.axis.BaseAxisOptions;
import org.fujion.chartjs.axis.LinearAxisOptions;
import org.fujion.chartjs.enums.CartesianAxisEnum;
import org.fujion.chartjs.enums.InteractionModeEnum;
import org.fujion.chartjs.plot.PlotLine;
import org.fujion.component.BaseComponent;
import org.fujion.testharness.BaseChartController;

public class ChartJSController
extends BaseChartController {
    @WiredComponent
    private Chart chartjs;
    private final LinearAxisOptions yaxis = new LinearAxisOptions();

    public void afterInitialized(BaseComponent root) {
        this.chartjs.setTitle("ChartJS: Monthly Average Temperature");
        this.chartjs.setSubtitle("Source: WorldClimate.com");
        this.chartjs.setLabels(CATEGORIES);
        this.yaxis.title.text = "Temperature (\u00b0C)";
        this.yaxis.title.display = true;
        this.yaxis.axis = CartesianAxisEnum.Y;
        this.chartjs.getTooltipOptions().callbacks.label = "function(item, data) {return item.formattedValue + '\u00b0C';}";
        this.chartjs.getTooltipOptions().mode = InteractionModeEnum.X;
        this.chartjs.addAxis("y", (BaseAxisOptions)this.yaxis);
        this.addSeries(TOKYO, "Tokyo");
        this.addSeries(NEW_YORK, "New York");
        this.addSeries(BERLIN, "Berlin");
        this.addSeries(LONDON, "London");
        this.chartjs.run();
    }

    private void addSeries(double[] data, String name) {
        PlotLine series = (PlotLine)this.chartjs.addSeries(PlotLine.class);
        series.data$number = data;
        series.label = name;
        series.yAxisID = "y";
    }
}

