/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.testharness;

import java.util.Comparator;
import org.fujion.annotation.EventHandler;
import org.fujion.annotation.WiredComponent;
import org.fujion.component.BaseComponent;
import org.fujion.component.Cell;
import org.fujion.component.Column;
import org.fujion.component.Grid;
import org.fujion.component.Radiobutton;
import org.fujion.component.Radiogroup;
import org.fujion.component.Row;
import org.fujion.component.Rows;
import org.fujion.model.IComponentRenderer;
import org.fujion.model.IListModel;
import org.fujion.model.ListModel;
import org.fujion.testharness.BaseController;
import org.fujion.testharness.GridsController;

public class GridsController
extends BaseController {
    private final IComponentRenderer<Row, RowModelObject> renderer = model -> {
        Row row = new Row();
        row.addChild((BaseComponent)new Cell(model.label));
        row.addChild((BaseComponent)new Cell(Integer.toString(model.value)));
        return row;
    };
    private final Comparator<RowModelObject> comp1 = (o1, o2) -> o1.label.compareToIgnoreCase(o2.label);
    private final Comparator<RowModelObject> comp2 = Comparator.comparingInt(o -> o.value);
    @WiredComponent
    private Grid grid;
    @WiredComponent
    private Rows rows;
    @WiredComponent
    private Column col1;
    @WiredComponent
    private Column col2;
    @WiredComponent
    private Radiogroup rgSelectable;
    @WiredComponent
    private Radiogroup rgSizable;

    public void afterInitialized(BaseComponent root) {
        super.afterInitialized(root);
        this.col1.setSortComparator(this.comp1);
        this.col2.setSortComparator(this.comp2);
        ListModel model = new ListModel();
        for (int i = 1; i < 101; ++i) {
            model.add((Object)new RowModelObject(i));
        }
        this.rows.setModel((IListModel)model);
        this.rows.setRenderer(this.renderer);
        this.col1.sort();
    }

    @EventHandler(value={"change"}, target={"@rgSelectable"})
    private void rgSelectableChangeHandler() {
        Radiobutton rb = this.rgSelectable.getSelected();
        if (rb != null) {
            this.grid.getRows().setSelectable(Rows.Selectable.valueOf((String)rb.getLabel()));
        }
    }

    @EventHandler(value={"change"}, target={"@rgSizable"})
    private void rgSizableChangeHandler() {
        Radiobutton rb = this.rgSizable.getSelected();
        if (rb != null) {
            boolean sizable = rb.getLabel().equals("YES");
            this.grid.setAutoSize(!sizable);
            this.col1.setSizable(sizable);
            this.col2.setSizable(sizable);
        }
    }
}

