/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.testharness;

import org.fujion.annotation.EventHandler;
import org.fujion.annotation.WiredComponent;
import org.fujion.component.BaseComponent;
import org.fujion.component.Doublebox;
import org.fujion.lmaps.LatLng;
import org.fujion.lmaps.LeafletMap;
import org.fujion.lmaps.LocateOptions;
import org.fujion.lmaps.event.LocationFoundEvent;
import org.fujion.lmaps.event.MapClickEvent;
import org.fujion.testharness.BaseController;

public class LeafletMapController
extends BaseController {
    @WiredComponent
    private LeafletMap lmap;
    @WiredComponent
    private Doublebox latitude;
    @WiredComponent
    private Doublebox longitude;

    public void afterInitialized(BaseComponent root) {
        super.afterInitialized(root);
        this.updateControls(this.lmap.getCenter());
        this.lmap.run();
    }

    private void updateControls(LatLng location) {
        this.latitude.setValue((Object)location.getLatitude());
        this.longitude.setValue((Object)location.getLongitude());
    }

    @EventHandler(value={"click"}, target={"btnPanTo"})
    private void onClick$btnPanTo() {
        this.lmap.panTo(this.currentPos());
    }

    @EventHandler(value={"click"}, target={"btnReset"})
    private void onClick$btnReset() {
        this.lmap.run();
    }

    @EventHandler(value={"click"}, target={"btnMyLocation"})
    private void onClick$btnMyLocation() {
        LocateOptions options = new LocateOptions();
        options.setView = true;
        options.maximumAge = 60000;
        this.lmap.locate(options);
    }

    @EventHandler(value={"lmap_click"}, target={"@lmap"})
    private void onClick$lmap(MapClickEvent event) {
        this.updateControls(event.getLocation());
    }

    @EventHandler(value={"lmap_locationfound"}, target={"@lmap"})
    private void onLocationFound$lmap(LocationFoundEvent event) {
        this.updateControls(event.getLocation());
    }

    private LatLng currentPos() {
        return new LatLng(((Double)this.latitude.getValue()).doubleValue(), ((Double)this.longitude.getValue()).doubleValue());
    }
}

