/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.testharness;

import org.fujion.annotation.EventHandler;
import org.fujion.annotation.OnFailure;
import org.fujion.annotation.WiredComponent;
import org.fujion.client.ClientUtil;
import org.fujion.component.BaseComponent;
import org.fujion.component.BaseLabeledComponent;
import org.fujion.component.Button;
import org.fujion.component.Caption;
import org.fujion.component.Checkbox;
import org.fujion.component.Detail;
import org.fujion.component.Div;
import org.fujion.component.Hyperlink;
import org.fujion.component.Popup;
import org.fujion.component.Radiobutton;
import org.fujion.component.Radiogroup;
import org.fujion.component.Tab;
import org.fujion.event.ChangeEvent;
import org.fujion.event.Event;
import org.fujion.event.EventUtil;
import org.fujion.page.PageUtil;
import org.fujion.servlet.DynamicResourceRegistry;
import org.fujion.testharness.BaseController;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class MiscController
extends BaseController {
    private static final String DYNAMIC_CONTENT_1 = "<button label='Dynamic Content' class='flavor:btn-danger'/>";
    private static final String DYNAMIC_CONTENT_2 = "<button label='Dynamic Resource' class='flavor:btn-success'/>";
    @WiredComponent(onFailure=OnFailure.IGNORE)
    private Div nomatch;
    @WiredComponent
    private BaseComponent dynamicContent;
    @WiredComponent
    private Popup contextMenu;
    @WiredComponent
    private Div divMaskTest;
    private boolean masked;
    @WiredComponent
    private Button btnToggleBalloon;
    @WiredComponent
    private Button btnRL;
    @WiredComponent
    private Hyperlink lnkRL;
    @WiredComponent
    private Radiobutton rbRL;
    @WiredComponent
    private Checkbox chkRL;
    @WiredComponent
    private Caption caption;
    @WiredComponent
    private Radiogroup rgPosition;
    @WiredComponent
    private Radiogroup rgAlignment;
    @WiredComponent
    private Detail detail;
    @WiredComponent
    private BaseComponent eventTestParent;

    public void afterInitialized(BaseComponent root) {
        super.afterInitialized(root);
        this.log(this.nomatch == null, "Component 'nomatch' was correctly not wired.", "Component 'nomatch' as erroneously wired.");
        PageUtil.createPageFromContent((String)DYNAMIC_CONTENT_1, (BaseComponent)this.dynamicContent);
    }

    @EventHandler(value={"change"}, target={"chkPreventClosure"})
    public void chkPreventClosureHandler(ChangeEvent event) {
        this.page.setClosable(!((Checkbox)event.getTarget()).isChecked());
    }

    @EventHandler(value={"click"}, target={"btnSaveAsFile"})
    public void btnSaveAsFileHandler() {
        ClientUtil.saveToFile((String)"This is test content", (String)"text/plain", (String)"testFile.txt");
    }

    @EventHandler(value={"click"}, target={"btnPrint"})
    public void btnPrintHandler() {
        ((Tab)this.root.getAncestor(Tab.class)).print();
    }

    @EventHandler(value={"click"}, target={"btnTestCallback"})
    public void btnTestCallbackHandler() {
        this.log("You should see \"The document url is:...\"");
        ClientUtil.invoke((String)"window.location.href", response -> this.log("The document url is: " + response), (Object[])new Object[0]);
    }

    @EventHandler(value={"click"}, target={"btnMaskTest"})
    private void btnMaskTestClickHandler() {
        this.masked = !this.masked;
        if (this.masked) {
            this.divMaskTest.addMask("Mask Test", this.contextMenu);
        } else {
            this.divMaskTest.removeMask();
        }
    }

    @EventHandler(value={"click"}, target={"@btnToggleBalloon"})
    private void btnToggleBalloonClickHandler() {
        if (this.btnToggleBalloon.getBalloon() == null) {
            this.btnToggleBalloon.setBalloon("Balloon Text");
        } else {
            this.btnToggleBalloon.setBalloon(null);
        }
    }

    @EventHandler(value={"change"}, target={"@rgPosition"})
    private void positionChangeHandler() {
        String value = this.rgPosition.getSelected().getLabel();
        BaseLabeledComponent.LabelPositionAll position = BaseLabeledComponent.LabelPositionAll.valueOf((String)value.toUpperCase());
        this.caption.setPosition(position);
        this.btnRL.setPosition(position);
        this.lnkRL.setPosition(position);
        this.rbRL.setPosition(position);
        this.chkRL.setPosition(position);
    }

    @EventHandler(value={"change"}, target={"@rgAlignment"})
    private void alignmentChangeHandler() {
        String value = this.rgAlignment.getSelected().getLabel();
        BaseLabeledComponent.LabelAlignment alignment = BaseLabeledComponent.LabelAlignment.valueOf((String)value.toUpperCase());
        this.caption.setAlignment(alignment);
    }

    @EventHandler(value={"click"}, target={"btnToggleDetail"})
    private void toggleDetailHandler(Event event) {
        this.detail.setOpen(!this.detail.isOpen());
    }

    @EventHandler(value={"click"}, target={"btnEventTest"})
    private void eventTestHandler() {
        String message = " event test successful.";
        for (Checkbox chk : this.eventTestParent.getChildren(Checkbox.class)) {
            if (!chk.isChecked()) continue;
            switch ((Integer)chk.getData()) {
                case 0: {
                    Event event = new Event("log", this.root, (Object)("Send" + message));
                    EventUtil.send((Event)event);
                    break;
                }
                case 1: {
                    Event event = new Event("log", this.root, (Object)("Post" + message));
                    EventUtil.post((Event)event);
                    break;
                }
                case 2: {
                    Event event = new Event("log", this.root, (Object)("Echo" + message));
                    EventUtil.echo((Event)event);
                }
            }
        }
    }

    static {
        DynamicResourceRegistry drr = DynamicResourceRegistry.getInstance();
        ByteArrayResource resource = new ByteArrayResource(DYNAMIC_CONTENT_2.getBytes());
        drr.registerResource("dynamic_resource.fsp", (Resource)resource);
    }
}

