/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.testharness;

import org.fujion.annotation.EventHandler;
import org.fujion.annotation.WiredComponent;
import org.fujion.component.BaseComponent;
import org.fujion.component.Checkbox;
import org.fujion.component.Treenode;
import org.fujion.component.Treeview;
import org.fujion.model.IListModel;
import org.fujion.testharness.BaseController;
import org.fujion.testharness.TreesController;

public class TreesController
extends BaseController {
    @WiredComponent
    private Treeview treeview;
    @WiredComponent
    private Treeview treeview2;
    @WiredComponent
    private Checkbox chkShowRoot;
    @WiredComponent
    private Checkbox chkShowLines;
    @WiredComponent
    private Checkbox chkShowToggles;

    public void afterInitialized(BaseComponent root) {
        super.afterInitialized(root);
        TreeModelObject rootNode = new TreeModelObject(null);
        this.addChildren(rootNode, 1);
        this.treeview2.setModel((IListModel)new TreeModel(rootNode.children));
        this.treeview2.setRenderer(model -> {
            Treenode node = new Treenode();
            node.setLabel(model.label);
            return node;
        });
    }

    private void addChildren(TreeModelObject parent, int level) {
        for (int i = 1; i < 4; ++i) {
            String label = parent.label == null ? Integer.toString(i) : parent.label + "." + i;
            TreeModelObject child = new TreeModelObject(label);
            parent.children.add(child);
            if (level >= 3) continue;
            this.addChildren(child, level + 1);
        }
    }

    @EventHandler(value={"change"}, target={"@chkShowRoot"})
    public void chkShowRootHandler() {
        this.treeview.setShowRoot(this.chkShowRoot.isChecked());
    }

    @EventHandler(value={"change"}, target={"@chkShowLines"})
    public void chkShowLinesHandler() {
        this.treeview.setShowLines(this.chkShowLines.isChecked());
    }

    @EventHandler(value={"change"}, target={"@chkShowToggles"})
    public void chkShowTogglesHandler() {
        this.treeview.setShowToggles(this.chkShowToggles.isChecked());
    }

    @EventHandler(value={"click"}, target={"btnCollapseAll"})
    public void collapseAllHandler() {
        this.treeview.collapseAll();
    }

    @EventHandler(value={"click"}, target={"btnExpandAll"})
    public void expandAllHandler() {
        this.treeview.expandAll();
    }
}

