/**
 * @license Angular v11.2.6
 * (c) 2010-2021 Google LLC. https://angular.io/
 * License: MIT
 */

(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('rxjs'), require('rxjs/operators')) :
    typeof define === 'function' && define.amd ? define('@angular/core', ['exports', 'rxjs', 'rxjs/operators'], factory) :
    (global = global || self, factory((global.ng = global.ng || {}, global.ng.core = {}), global.rxjs, global.rxjs.operators));
}(this, (function (exports, rxjs, operators) { 'use strict';

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function getClosureSafeProperty(objWithPropertyToExtract) {
        for (var key in objWithPropertyToExtract) {
            if (objWithPropertyToExtract[key] === getClosureSafeProperty) {
                return key;
            }
        }
        throw Error('Could not find renamed property on target object.');
    }
    /**
     * Sets properties on a target object from a source object, but only if
     * the property doesn't already exist on the target object.
     * @param target The target to set properties on
     * @param source The source of the property keys and values to set
     */
    function fillProperties(target, source) {
        for (var key in source) {
            if (source.hasOwnProperty(key) && !target.hasOwnProperty(key)) {
                target[key] = source[key];
            }
        }
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function stringify(token) {
        if (typeof token === 'string') {
            return token;
        }
        if (Array.isArray(token)) {
            return '[' + token.map(stringify).join(', ') + ']';
        }
        if (token == null) {
            return '' + token;
        }
        if (token.overriddenName) {
            return "" + token.overriddenName;
        }
        if (token.name) {
            return "" + token.name;
        }
        var res = token.toString();
        if (res == null) {
            return '' + res;
        }
        var newLineIndex = res.indexOf('\n');
        return newLineIndex === -1 ? res : res.substring(0, newLineIndex);
    }
    /**
     * Concatenates two strings with separator, allocating new strings only when necessary.
     *
     * @param before before string.
     * @param separator separator string.
     * @param after after string.
     * @returns concatenated string.
     */
    function concatStringsWithSpace(before, after) {
        return (before == null || before === '') ?
            (after === null ? '' : after) :
            ((after == null || after === '') ? before : before + ' ' + after);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var __forward_ref__ = getClosureSafeProperty({ __forward_ref__: getClosureSafeProperty });
    /**
     * Allows to refer to references which are not yet defined.
     *
     * For instance, `forwardRef` is used when the `token` which we need to refer to for the purposes of
     * DI is declared, but not yet defined. It is also used when the `token` which we use when creating
     * a query is not yet defined.
     *
     * @usageNotes
     * ### Example
     * {@example core/di/ts/forward_ref/forward_ref_spec.ts region='forward_ref'}
     * @publicApi
     */
    function forwardRef(forwardRefFn) {
        forwardRefFn.__forward_ref__ = forwardRef;
        forwardRefFn.toString = function () {
            return stringify(this());
        };
        return forwardRefFn;
    }
    /**
     * Lazily retrieves the reference value from a forwardRef.
     *
     * Acts as the identity function when given a non-forward-ref value.
     *
     * @usageNotes
     * ### Example
     *
     * {@example core/di/ts/forward_ref/forward_ref_spec.ts region='resolve_forward_ref'}
     *
     * @see `forwardRef`
     * @publicApi
     */
    function resolveForwardRef(type) {
        return isForwardRef(type) ? type() : type;
    }
    /** Checks whether a function is wrapped by a `forwardRef`. */
    function isForwardRef(fn) {
        return typeof fn === 'function' && fn.hasOwnProperty(__forward_ref__) &&
            fn.__forward_ref__ === forwardRef;
    }

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation.

    Permission to use, copy, modify, and/or distribute this software for any
    purpose with or without fee is hereby granted.

    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
    PERFORMANCE OF THIS SOFTWARE.
    ***************************************************************************** */
    /* global Reflect, Promise */
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b)
                if (b.hasOwnProperty(p))
                    d[p] = b[p]; };
        return extendStatics(d, b);
    };
    function __extends(d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }
    var __assign = function () {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    function __rest(s, e) {
        var t = {};
        for (var p in s)
            if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
                t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    }
    function __decorate(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }
    function __param(paramIndex, decorator) {
        return function (target, key) { decorator(target, key, paramIndex); };
    }
    function __metadata(metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(metadataKey, metadataValue);
    }
    function __awaiter(thisArg, _arguments, P, generator) {
        function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try {
                step(generator.next(value));
            }
            catch (e) {
                reject(e);
            } }
            function rejected(value) { try {
                step(generator["throw"](value));
            }
            catch (e) {
                reject(e);
            } }
            function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    }
    function __generator(thisArg, body) {
        var _ = { label: 0, sent: function () { if (t[0] & 1)
                throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function () { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f)
                throw new TypeError("Generator is already executing.");
            while (_)
                try {
                    if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
                        return t;
                    if (y = 0, t)
                        op = [op[0] & 2, t.value];
                    switch (op[0]) {
                        case 0:
                        case 1:
                            t = op;
                            break;
                        case 4:
                            _.label++;
                            return { value: op[1], done: false };
                        case 5:
                            _.label++;
                            y = op[1];
                            op = [0];
                            continue;
                        case 7:
                            op = _.ops.pop();
                            _.trys.pop();
                            continue;
                        default:
                            if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                                _ = 0;
                                continue;
                            }
                            if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                                _.label = op[1];
                                break;
                            }
                            if (op[0] === 6 && _.label < t[1]) {
                                _.label = t[1];
                                t = op;
                                break;
                            }
                            if (t && _.label < t[2]) {
                                _.label = t[2];
                                _.ops.push(op);
                                break;
                            }
                            if (t[2])
                                _.ops.pop();
                            _.trys.pop();
                            continue;
                    }
                    op = body.call(thisArg, _);
                }
                catch (e) {
                    op = [6, e];
                    y = 0;
                }
                finally {
                    f = t = 0;
                }
            if (op[0] & 5)
                throw op[1];
            return { value: op[0] ? op[1] : void 0, done: true };
        }
    }
    var __createBinding = Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        Object.defineProperty(o, k2, { enumerable: true, get: function () { return m[k]; } });
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    });
    function __exportStar(m, exports) {
        for (var p in m)
            if (p !== "default" && !exports.hasOwnProperty(p))
                __createBinding(exports, m, p);
    }
    function __values(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    }
    function __read(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    }
    function __spread() {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    }
    function __spreadArrays() {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++)
            s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    }
    ;
    function __await(v) {
        return this instanceof __await ? (this.v = v, this) : new __await(v);
    }
    function __asyncGenerator(thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), i, q = [];
        return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
        function verb(n) { if (g[n])
            i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
        function resume(n, v) { try {
            step(g[n](v));
        }
        catch (e) {
            settle(q[0][3], e);
        } }
        function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
        function fulfill(value) { resume("next", value); }
        function reject(value) { resume("throw", value); }
        function settle(f, v) { if (f(v), q.shift(), q.length)
            resume(q[0][0], q[0][1]); }
    }
    function __asyncDelegator(o) {
        var i, p;
        return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
        function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
    }
    function __asyncValues(o) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
        function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
        function settle(resolve, reject, d, v) { Promise.resolve(v).then(function (v) { resolve({ value: v, done: d }); }, reject); }
    }
    function __makeTemplateObject(cooked, raw) {
        if (Object.defineProperty) {
            Object.defineProperty(cooked, "raw", { value: raw });
        }
        else {
            cooked.raw = raw;
        }
        return cooked;
    }
    ;
    var __setModuleDefault = Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    };
    function __importStar(mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k in mod)
                if (Object.hasOwnProperty.call(mod, k))
                    __createBinding(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    }
    function __importDefault(mod) {
        return (mod && mod.__esModule) ? mod : { default: mod };
    }
    function __classPrivateFieldGet(receiver, privateMap) {
        if (!privateMap.has(receiver)) {
            throw new TypeError("attempted to get private field on non-instance");
        }
        return privateMap.get(receiver);
    }
    function __classPrivateFieldSet(receiver, privateMap, value) {
        if (!privateMap.has(receiver)) {
            throw new TypeError("attempted to set private field on non-instance");
        }
        privateMap.set(receiver, value);
        return value;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    // Base URL for the error details page.
    // Keep this value in sync with a similar const in
    // `packages/compiler-cli/src/ngtsc/diagnostics/src/error_code.ts`.
    var ERROR_DETAILS_PAGE_BASE_URL = 'https://angular.io/errors';
    var RuntimeError = /** @class */ (function (_super) {
        __extends(RuntimeError, _super);
        function RuntimeError(code, message) {
            var _this = _super.call(this, formatRuntimeError(code, message)) || this;
            _this.code = code;
            return _this;
        }
        return RuntimeError;
    }(Error));
    // Contains a set of error messages that have details guides at angular.io.
    // Full list of available error guides can be found at https://angular.io/errors
    /* tslint:disable:no-toplevel-property-access */
    var RUNTIME_ERRORS_WITH_GUIDES = new Set([
        "100" /* EXPRESSION_CHANGED_AFTER_CHECKED */,
        "200" /* CYCLIC_DI_DEPENDENCY */,
        "201" /* PROVIDER_NOT_FOUND */,
        "300" /* MULTIPLE_COMPONENTS_MATCH */,
        "301" /* EXPORT_NOT_FOUND */,
        "302" /* PIPE_NOT_FOUND */,
    ]);
    /* tslint:enable:no-toplevel-property-access */
    /** Called to format a runtime error */
    function formatRuntimeError(code, message) {
        var fullCode = code ? "NG0" + code + ": " : '';
        var errorMessage = "" + fullCode + message;
        // Some runtime errors are still thrown without `ngDevMode` (for example
        // `throwProviderNotFoundError`), so we add `ngDevMode` check here to avoid pulling
        // `RUNTIME_ERRORS_WITH_GUIDES` symbol into prod bundles.
        // TODO: revisit all instances where `RuntimeError` is thrown and see if `ngDevMode` can be added
        // there instead to tree-shake more devmode-only code (and eventually remove `ngDevMode` check
        // from this code).
        if (ngDevMode && RUNTIME_ERRORS_WITH_GUIDES.has(code)) {
            errorMessage = errorMessage + ". Find more at " + ERROR_DETAILS_PAGE_BASE_URL + "/NG0" + code;
        }
        return errorMessage;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Used for stringify render output in Ivy.
     * Important! This function is very performance-sensitive and we should
     * be extra careful not to introduce megamorphic reads in it.
     * Check `core/test/render3/perf/render_stringify` for benchmarks and alternate implementations.
     */
    function renderStringify(value) {
        if (typeof value === 'string')
            return value;
        if (value == null)
            return '';
        // Use `String` so that it invokes the `toString` method of the value. Note that this
        // appears to be faster than calling `value.toString` (see `render_stringify` benchmark).
        return String(value);
    }
    /**
     * Used to stringify a value so that it can be displayed in an error message.
     * Important! This function contains a megamorphic read and should only be
     * used for error messages.
     */
    function stringifyForError(value) {
        if (typeof value === 'function')
            return value.name || value.toString();
        if (typeof value === 'object' && value != null && typeof value.type === 'function') {
            return value.type.name || value.type.toString();
        }
        return renderStringify(value);
    }

    /** Called when directives inject each other (creating a circular dependency) */
    function throwCyclicDependencyError(token, path) {
        var depPath = path ? ". Dependency path: " + path.join(' > ') + " > " + token : '';
        throw new RuntimeError("200" /* CYCLIC_DI_DEPENDENCY */, "Circular dependency in DI detected for " + token + depPath);
    }
    function throwMixedMultiProviderError() {
        throw new Error("Cannot mix multi providers and regular providers");
    }
    function throwInvalidProviderError(ngModuleType, providers, provider) {
        var ngModuleDetail = '';
        if (ngModuleType && providers) {
            var providerDetail = providers.map(function (v) { return v == provider ? '?' + provider + '?' : '...'; });
            ngModuleDetail =
                " - only instances of Provider and Type are allowed, got: [" + providerDetail.join(', ') + "]";
        }
        throw new Error("Invalid provider for the NgModule '" + stringify(ngModuleType) + "'" + ngModuleDetail);
    }
    /** Throws an error when a token is not found in DI. */
    function throwProviderNotFoundError(token, injectorName) {
        var injectorDetails = injectorName ? " in " + injectorName : '';
        throw new RuntimeError("201" /* PROVIDER_NOT_FOUND */, "No provider for " + stringifyForError(token) + " found" + injectorDetails);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function assertNumber(actual, msg) {
        if (!(typeof actual === 'number')) {
            throwError(msg, typeof actual, 'number', '===');
        }
    }
    function assertNumberInRange(actual, minInclusive, maxInclusive) {
        assertNumber(actual, 'Expected a number');
        assertLessThanOrEqual(actual, maxInclusive, 'Expected number to be less than or equal to');
        assertGreaterThanOrEqual(actual, minInclusive, 'Expected number to be greater than or equal to');
    }
    function assertString(actual, msg) {
        if (!(typeof actual === 'string')) {
            throwError(msg, actual === null ? 'null' : typeof actual, 'string', '===');
        }
    }
    function assertFunction(actual, msg) {
        if (!(typeof actual === 'function')) {
            throwError(msg, actual === null ? 'null' : typeof actual, 'function', '===');
        }
    }
    function assertEqual(actual, expected, msg) {
        if (!(actual == expected)) {
            throwError(msg, actual, expected, '==');
        }
    }
    function assertNotEqual(actual, expected, msg) {
        if (!(actual != expected)) {
            throwError(msg, actual, expected, '!=');
        }
    }
    function assertSame(actual, expected, msg) {
        if (!(actual === expected)) {
            throwError(msg, actual, expected, '===');
        }
    }
    function assertNotSame(actual, expected, msg) {
        if (!(actual !== expected)) {
            throwError(msg, actual, expected, '!==');
        }
    }
    function assertLessThan(actual, expected, msg) {
        if (!(actual < expected)) {
            throwError(msg, actual, expected, '<');
        }
    }
    function assertLessThanOrEqual(actual, expected, msg) {
        if (!(actual <= expected)) {
            throwError(msg, actual, expected, '<=');
        }
    }
    function assertGreaterThan(actual, expected, msg) {
        if (!(actual > expected)) {
            throwError(msg, actual, expected, '>');
        }
    }
    function assertGreaterThanOrEqual(actual, expected, msg) {
        if (!(actual >= expected)) {
            throwError(msg, actual, expected, '>=');
        }
    }
    function assertNotDefined(actual, msg) {
        if (actual != null) {
            throwError(msg, actual, null, '==');
        }
    }
    function assertDefined(actual, msg) {
        if (actual == null) {
            throwError(msg, actual, null, '!=');
        }
    }
    function throwError(msg, actual, expected, comparison) {
        throw new Error("ASSERTION ERROR: " + msg +
            (comparison == null ? '' : " [Expected=> " + expected + " " + comparison + " " + actual + " <=Actual]"));
    }
    function assertDomNode(node) {
        // If we're in a worker, `Node` will not be defined.
        if (!(typeof Node !== 'undefined' && node instanceof Node) &&
            !(typeof node === 'object' && node != null &&
                node.constructor.name === 'WebWorkerRenderNode')) {
            throwError("The provided value must be an instance of a DOM Node but got " + stringify(node));
        }
    }
    function assertIndexInRange(arr, index) {
        assertDefined(arr, 'Array must be defined.');
        var maxLen = arr.length;
        if (index < 0 || index >= maxLen) {
            throwError("Index expected to be less than " + maxLen + " but got " + index);
        }
    }
    function assertOneOf(value) {
        var validValues = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            validValues[_i - 1] = arguments[_i];
        }
        if (validValues.indexOf(value) !== -1)
            return true;
        throwError("Expected value to be one of " + JSON.stringify(validValues) + " but was " + JSON.stringify(value) + ".");
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Construct an `InjectableDef` which defines how a token will be constructed by the DI system, and
     * in which injectors (if any) it will be available.
     *
     * This should be assigned to a static `ɵprov` field on a type, which will then be an
     * `InjectableType`.
     *
     * Options:
     * * `providedIn` determines which injectors will include the injectable, by either associating it
     *   with an `@NgModule` or other `InjectorType`, or by specifying that this injectable should be
     *   provided in the `'root'` injector, which will be the application-level injector in most apps.
     * * `factory` gives the zero argument function which will create an instance of the injectable.
     *   The factory can call `inject` to access the `Injector` and request injection of dependencies.
     *
     * @codeGenApi
     * @publicApi This instruction has been emitted by ViewEngine for some time and is deployed to npm.
     */
    function ɵɵdefineInjectable(opts) {
        return {
            token: opts.token,
            providedIn: opts.providedIn || null,
            factory: opts.factory,
            value: undefined,
        };
    }
    /**
     * @deprecated in v8, delete after v10. This API should be used only by generated code, and that
     * code should now use ɵɵdefineInjectable instead.
     * @publicApi
     */
    var defineInjectable = ɵɵdefineInjectable;
    /**
     * Construct an `InjectorDef` which configures an injector.
     *
     * This should be assigned to a static injector def (`ɵinj`) field on a type, which will then be an
     * `InjectorType`.
     *
     * Options:
     *
     * * `providers`: an optional array of providers to add to the injector. Each provider must
     *   either have a factory or point to a type which has a `ɵprov` static property (the
     *   type must be an `InjectableType`).
     * * `imports`: an optional array of imports of other `InjectorType`s or `InjectorTypeWithModule`s
     *   whose providers will also be added to the injector. Locally provided types will override
     *   providers from imports.
     *
     * @codeGenApi
     */
    function ɵɵdefineInjector(options) {
        return { providers: options.providers || [], imports: options.imports || [] };
    }
    /**
     * Read the injectable def (`ɵprov`) for `type` in a way which is immune to accidentally reading
     * inherited value.
     *
     * @param type A type which may have its own (non-inherited) `ɵprov`.
     */
    function getInjectableDef(type) {
        return getOwnDefinition(type, NG_PROV_DEF) || getOwnDefinition(type, NG_INJECTABLE_DEF);
    }
    /**
     * Return definition only if it is defined directly on `type` and is not inherited from a base
     * class of `type`.
     */
    function getOwnDefinition(type, field) {
        return type.hasOwnProperty(field) ? type[field] : null;
    }
    /**
     * Read the injectable def (`ɵprov`) for `type` or read the `ɵprov` from one of its ancestors.
     *
     * @param type A type which may have `ɵprov`, via inheritance.
     *
     * @deprecated Will be removed in a future version of Angular, where an error will occur in the
     *     scenario if we find the `ɵprov` on an ancestor only.
     */
    function getInheritedInjectableDef(type) {
        var def = type && (type[NG_PROV_DEF] || type[NG_INJECTABLE_DEF]);
        if (def) {
            var typeName = getTypeName(type);
            // TODO(FW-1307): Re-add ngDevMode when closure can handle it
            // ngDevMode &&
            console.warn("DEPRECATED: DI is instantiating a token \"" + typeName + "\" that inherits its @Injectable decorator but does not provide one itself.\n" +
                ("This will become an error in a future version of Angular. Please add @Injectable() to the \"" + typeName + "\" class."));
            return def;
        }
        else {
            return null;
        }
    }
    /** Gets the name of a type, accounting for some cross-browser differences. */
    function getTypeName(type) {
        // `Function.prototype.name` behaves differently between IE and other browsers. In most browsers
        // it'll always return the name of the function itself, no matter how many other functions it
        // inherits from. On IE the function doesn't have its own `name` property, but it takes it from
        // the lowest level in the prototype chain. E.g. if we have `class Foo extends Parent` most
        // browsers will evaluate `Foo.name` to `Foo` while IE will return `Parent`. We work around
        // the issue by converting the function to a string and parsing its name out that way via a regex.
        if (type.hasOwnProperty('name')) {
            return type.name;
        }
        var match = ('' + type).match(/^function\s*([^\s(]+)/);
        return match === null ? '' : match[1];
    }
    /**
     * Read the injector def type in a way which is immune to accidentally reading inherited value.
     *
     * @param type type which may have an injector def (`ɵinj`)
     */
    function getInjectorDef(type) {
        return type && (type.hasOwnProperty(NG_INJ_DEF) || type.hasOwnProperty(NG_INJECTOR_DEF)) ?
            type[NG_INJ_DEF] :
            null;
    }
    var NG_PROV_DEF = getClosureSafeProperty({ ɵprov: getClosureSafeProperty });
    var NG_INJ_DEF = getClosureSafeProperty({ ɵinj: getClosureSafeProperty });
    // We need to keep these around so we can read off old defs if new defs are unavailable
    var NG_INJECTABLE_DEF = getClosureSafeProperty({ ngInjectableDef: getClosureSafeProperty });
    var NG_INJECTOR_DEF = getClosureSafeProperty({ ngInjectorDef: getClosureSafeProperty });

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    (function (InjectFlags) {
        // TODO(alxhub): make this 'const' (and remove `InternalInjectFlags` enum) when ngc no longer
        // writes exports of it into ngfactory files.
        /** Check self and check parent injector if needed */
        InjectFlags[InjectFlags["Default"] = 0] = "Default";
        /**
         * Specifies that an injector should retrieve a dependency from any injector until reaching the
         * host element of the current component. (Only used with Element Injector)
         */
        InjectFlags[InjectFlags["Host"] = 1] = "Host";
        /** Don't ascend to ancestors of the node requesting injection. */
        InjectFlags[InjectFlags["Self"] = 2] = "Self";
        /** Skip the node that is requesting injection. */
        InjectFlags[InjectFlags["SkipSelf"] = 4] = "SkipSelf";
        /** Inject `defaultValue` instead if token not found. */
        InjectFlags[InjectFlags["Optional"] = 8] = "Optional";
    })(exports.InjectFlags || (exports.InjectFlags = {}));

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Current implementation of inject.
     *
     * By default, it is `injectInjectorOnly`, which makes it `Injector`-only aware. It can be changed
     * to `directiveInject`, which brings in the `NodeInjector` system of ivy. It is designed this
     * way for two reasons:
     *  1. `Injector` should not depend on ivy logic.
     *  2. To maintain tree shake-ability we don't want to bring in unnecessary code.
     */
    var _injectImplementation;
    function getInjectImplementation() {
        return _injectImplementation;
    }
    /**
     * Sets the current inject implementation.
     */
    function setInjectImplementation(impl) {
        var previous = _injectImplementation;
        _injectImplementation = impl;
        return previous;
    }
    /**
     * Injects `root` tokens in limp mode.
     *
     * If no injector exists, we can still inject tree-shakable providers which have `providedIn` set to
     * `"root"`. This is known as the limp mode injection. In such case the value is stored in the
     * `InjectableDef`.
     */
    function injectRootLimpMode(token, notFoundValue, flags) {
        var injectableDef = getInjectableDef(token);
        if (injectableDef && injectableDef.providedIn == 'root') {
            return injectableDef.value === undefined ? injectableDef.value = injectableDef.factory() :
                injectableDef.value;
        }
        if (flags & exports.InjectFlags.Optional)
            return null;
        if (notFoundValue !== undefined)
            return notFoundValue;
        throwProviderNotFoundError(stringify(token), 'Injector');
    }
    /**
     * Assert that `_injectImplementation` is not `fn`.
     *
     * This is useful, to prevent infinite recursion.
     *
     * @param fn Function which it should not equal to
     */
    function assertInjectImplementationNotEqual(fn) {
        ngDevMode &&
            assertNotEqual(_injectImplementation, fn, 'Calling ɵɵinject would cause infinite recursion');
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Convince closure compiler that the wrapped function has no side-effects.
     *
     * Closure compiler always assumes that `toString` has no side-effects. We use this quirk to
     * allow us to execute a function but have closure compiler mark the call as no-side-effects.
     * It is important that the return value for the `noSideEffects` function be assigned
     * to something which is retained otherwise the call to `noSideEffects` will be removed by closure
     * compiler.
     */
    function noSideEffects(fn) {
        return { toString: fn }.toString();
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    (function (ChangeDetectionStrategy) {
        /**
         * Use the `CheckOnce` strategy, meaning that automatic change detection is deactivated
         * until reactivated by setting the strategy to `Default` (`CheckAlways`).
         * Change detection can still be explicitly invoked.
         * This strategy applies to all child directives and cannot be overridden.
         */
        ChangeDetectionStrategy[ChangeDetectionStrategy["OnPush"] = 0] = "OnPush";
        /**
         * Use the default `CheckAlways` strategy, in which change detection is automatic until
         * explicitly deactivated.
         */
        ChangeDetectionStrategy[ChangeDetectionStrategy["Default"] = 1] = "Default";
    })(exports.ChangeDetectionStrategy || (exports.ChangeDetectionStrategy = {}));
    (function (ChangeDetectorStatus) {
        /**
         * A state in which, after calling `detectChanges()`, the change detector
         * state becomes `Checked`, and must be explicitly invoked or reactivated.
         */
        ChangeDetectorStatus[ChangeDetectorStatus["CheckOnce"] = 0] = "CheckOnce";
        /**
         * A state in which change detection is skipped until the change detector mode
         * becomes `CheckOnce`.
         */
        ChangeDetectorStatus[ChangeDetectorStatus["Checked"] = 1] = "Checked";
        /**
         * A state in which change detection continues automatically until explicitly
         * deactivated.
         */
        ChangeDetectorStatus[ChangeDetectorStatus["CheckAlways"] = 2] = "CheckAlways";
        /**
         * A state in which a change detector sub tree is not a part of the main tree and
         * should be skipped.
         */
        ChangeDetectorStatus[ChangeDetectorStatus["Detached"] = 3] = "Detached";
        /**
         * Indicates that the change detector encountered an error checking a binding
         * or calling a directive lifecycle method and is now in an inconsistent state. Change
         * detectors in this state do not detect changes.
         */
        ChangeDetectorStatus[ChangeDetectorStatus["Errored"] = 4] = "Errored";
        /**
         * Indicates that the change detector has been destroyed.
         */
        ChangeDetectorStatus[ChangeDetectorStatus["Destroyed"] = 5] = "Destroyed";
    })(exports.ɵChangeDetectorStatus || (exports.ɵChangeDetectorStatus = {}));
    /**
     * Reports whether a given strategy is currently the default for change detection.
     * @param changeDetectionStrategy The strategy to check.
     * @returns True if the given strategy is the current default, false otherwise.
     * @see `ChangeDetectorStatus`
     * @see `ChangeDetectorRef`
     */
    function isDefaultChangeDetectionStrategy(changeDetectionStrategy) {
        return changeDetectionStrategy == null ||
            changeDetectionStrategy === exports.ChangeDetectionStrategy.Default;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    (function (ViewEncapsulation) {
        /**
         * Emulate `Native` scoping of styles by adding an attribute containing surrogate id to the Host
         * Element and pre-processing the style rules provided via {@link Component#styles styles} or
         * {@link Component#styleUrls styleUrls}, and adding the new Host Element attribute to all
         * selectors.
         *
         * This is the default option.
         */
        ViewEncapsulation[ViewEncapsulation["Emulated"] = 0] = "Emulated";
        // Historically the 1 value was for `Native` encapsulation which has been removed as of v11.
        /**
         * Don't provide any template or style encapsulation.
         */
        ViewEncapsulation[ViewEncapsulation["None"] = 2] = "None";
        /**
         * Use Shadow DOM to encapsulate styles.
         *
         * For the DOM this means using modern [Shadow
         * DOM](https://developer.mozilla.org/en-US/docs/Web/Web_Components/Using_shadow_DOM) and
         * creating a ShadowRoot for Component's Host Element.
         */
        ViewEncapsulation[ViewEncapsulation["ShadowDom"] = 3] = "ShadowDom";
    })(exports.ViewEncapsulation || (exports.ViewEncapsulation = {}));

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var __globalThis = typeof globalThis !== 'undefined' && globalThis;
    var __window = typeof window !== 'undefined' && window;
    var __self = typeof self !== 'undefined' && typeof WorkerGlobalScope !== 'undefined' &&
        self instanceof WorkerGlobalScope && self;
    var __global = typeof global !== 'undefined' && global;
    // Always use __globalThis if available, which is the spec-defined global variable across all
    // environments, then fallback to __global first, because in Node tests both __global and
    // __window may be defined and _global should be __global in that case.
    var _global = __globalThis || __global || __window || __self;

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function ngDevModeResetPerfCounters() {
        var locationString = typeof location !== 'undefined' ? location.toString() : '';
        var newCounters = {
            namedConstructors: locationString.indexOf('ngDevMode=namedConstructors') != -1,
            firstCreatePass: 0,
            tNode: 0,
            tView: 0,
            rendererCreateTextNode: 0,
            rendererSetText: 0,
            rendererCreateElement: 0,
            rendererAddEventListener: 0,
            rendererSetAttribute: 0,
            rendererRemoveAttribute: 0,
            rendererSetProperty: 0,
            rendererSetClassName: 0,
            rendererAddClass: 0,
            rendererRemoveClass: 0,
            rendererSetStyle: 0,
            rendererRemoveStyle: 0,
            rendererDestroy: 0,
            rendererDestroyNode: 0,
            rendererMoveNode: 0,
            rendererRemoveNode: 0,
            rendererAppendChild: 0,
            rendererInsertBefore: 0,
            rendererCreateComment: 0,
        };
        // Make sure to refer to ngDevMode as ['ngDevMode'] for closure.
        var allowNgDevModeTrue = locationString.indexOf('ngDevMode=false') === -1;
        _global['ngDevMode'] = allowNgDevModeTrue && newCounters;
        return newCounters;
    }
    /**
     * This function checks to see if the `ngDevMode` has been set. If yes,
     * then we honor it, otherwise we default to dev mode with additional checks.
     *
     * The idea is that unless we are doing production build where we explicitly
     * set `ngDevMode == false` we should be helping the developer by providing
     * as much early warning and errors as possible.
     *
     * `ɵɵdefineComponent` is guaranteed to have been called before any component template functions
     * (and thus Ivy instructions), so a single initialization there is sufficient to ensure ngDevMode
     * is defined for the entire instruction set.
     *
     * When checking `ngDevMode` on toplevel, always init it before referencing it
     * (e.g. `((typeof ngDevMode === 'undefined' || ngDevMode) && initNgDevMode())`), otherwise you can
     *  get a `ReferenceError` like in https://github.com/angular/angular/issues/31595.
     *
     * Details on possible values for `ngDevMode` can be found on its docstring.
     *
     * NOTE:
     * - changes to the `ngDevMode` name must be synced with `compiler-cli/src/tooling.ts`.
     */
    function initNgDevMode() {
        // The below checks are to ensure that calling `initNgDevMode` multiple times does not
        // reset the counters.
        // If the `ngDevMode` is not an object, then it means we have not created the perf counters
        // yet.
        if (typeof ngDevMode === 'undefined' || ngDevMode) {
            if (typeof ngDevMode !== 'object') {
                ngDevModeResetPerfCounters();
            }
            return typeof ngDevMode !== 'undefined' && !!ngDevMode;
        }
        return false;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * This file contains reuseable "empty" symbols that can be used as default return values
     * in different parts of the rendering code. Because the same symbols are returned, this
     * allows for identity checks against these values to be consistently used by the framework
     * code.
     */
    var EMPTY_OBJ = {};
    var EMPTY_ARRAY = [];
    // freezing the values prevents any code from accidentally inserting new values in
    if ((typeof ngDevMode === 'undefined' || ngDevMode) && initNgDevMode()) {
        // These property accesses can be ignored because ngDevMode will be set to false
        // when optimizing code and the whole if statement will be dropped.
        // tslint:disable-next-line:no-toplevel-property-access
        Object.freeze(EMPTY_OBJ);
        // tslint:disable-next-line:no-toplevel-property-access
        Object.freeze(EMPTY_ARRAY);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * This file contains reuseable "empty" symbols that can be used as default return values
     * in different parts of the rendering code. Because the same symbols are returned, this
     * allows for identity checks against these values to be consistently used by the framework
     * code.
     */
    var EMPTY_ARRAY$1 = [];
    // freezing the values prevents any code from accidentally inserting new values in
    if ((typeof ngDevMode === 'undefined' || ngDevMode) && initNgDevMode()) {
        // These property accesses can be ignored because ngDevMode will be set to false
        // when optimizing code and the whole if statement will be dropped.
        // tslint:disable-next-line:no-toplevel-property-access
        Object.freeze(EMPTY_ARRAY$1);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var NG_COMP_DEF = getClosureSafeProperty({ ɵcmp: getClosureSafeProperty });
    var NG_DIR_DEF = getClosureSafeProperty({ ɵdir: getClosureSafeProperty });
    var NG_PIPE_DEF = getClosureSafeProperty({ ɵpipe: getClosureSafeProperty });
    var NG_MOD_DEF = getClosureSafeProperty({ ɵmod: getClosureSafeProperty });
    var NG_LOC_ID_DEF = getClosureSafeProperty({ ɵloc: getClosureSafeProperty });
    var NG_FACTORY_DEF = getClosureSafeProperty({ ɵfac: getClosureSafeProperty });
    /**
     * If a directive is diPublic, bloomAdd sets a property on the type with this constant as
     * the key and the directive's unique ID as the value. This allows us to map directives to their
     * bloom filter bit for DI.
     */
    // TODO(misko): This is wrong. The NG_ELEMENT_ID should never be minified.
    var NG_ELEMENT_ID = getClosureSafeProperty({ __NG_ELEMENT_ID__: getClosureSafeProperty });

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var _renderCompCount = 0;
    /**
     * Create a component definition object.
     *
     *
     * # Example
     * ```
     * class MyDirective {
     *   // Generated by Angular Template Compiler
     *   // [Symbol] syntax will not be supported by TypeScript until v2.7
     *   static ɵcmp = defineComponent({
     *     ...
     *   });
     * }
     * ```
     * @codeGenApi
     */
    function ɵɵdefineComponent(componentDefinition) {
        return noSideEffects(function () {
            // Initialize ngDevMode. This must be the first statement in ɵɵdefineComponent.
            // See the `initNgDevMode` docstring for more information.
            (typeof ngDevMode === 'undefined' || ngDevMode) && initNgDevMode();
            var type = componentDefinition.type;
            var declaredInputs = {};
            var def = {
                type: type,
                providersResolver: null,
                decls: componentDefinition.decls,
                vars: componentDefinition.vars,
                factory: null,
                template: componentDefinition.template || null,
                consts: componentDefinition.consts || null,
                ngContentSelectors: componentDefinition.ngContentSelectors,
                hostBindings: componentDefinition.hostBindings || null,
                hostVars: componentDefinition.hostVars || 0,
                hostAttrs: componentDefinition.hostAttrs || null,
                contentQueries: componentDefinition.contentQueries || null,
                declaredInputs: declaredInputs,
                inputs: null,
                outputs: null,
                exportAs: componentDefinition.exportAs || null,
                onPush: componentDefinition.changeDetection === exports.ChangeDetectionStrategy.OnPush,
                directiveDefs: null,
                pipeDefs: null,
                selectors: componentDefinition.selectors || EMPTY_ARRAY$1,
                viewQuery: componentDefinition.viewQuery || null,
                features: componentDefinition.features || null,
                data: componentDefinition.data || {},
                // TODO(misko): convert ViewEncapsulation into const enum so that it can be used
                // directly in the next line. Also `None` should be 0 not 2.
                encapsulation: componentDefinition.encapsulation || exports.ViewEncapsulation.Emulated,
                id: 'c',
                styles: componentDefinition.styles || EMPTY_ARRAY$1,
                _: null,
                setInput: null,
                schemas: componentDefinition.schemas || null,
                tView: null,
            };
            var directiveTypes = componentDefinition.directives;
            var feature = componentDefinition.features;
            var pipeTypes = componentDefinition.pipes;
            def.id += _renderCompCount++;
            def.inputs = invertObject(componentDefinition.inputs, declaredInputs),
                def.outputs = invertObject(componentDefinition.outputs),
                feature && feature.forEach(function (fn) { return fn(def); });
            def.directiveDefs = directiveTypes ?
                function () { return (typeof directiveTypes === 'function' ? directiveTypes() : directiveTypes)
                    .map(extractDirectiveDef); } :
                null;
            def.pipeDefs = pipeTypes ?
                function () { return (typeof pipeTypes === 'function' ? pipeTypes() : pipeTypes).map(extractPipeDef); } :
                null;
            return def;
        });
    }
    /**
     * Generated next to NgModules to monkey-patch directive and pipe references onto a component's
     * definition, when generating a direct reference in the component file would otherwise create an
     * import cycle.
     *
     * See [this explanation](https://hackmd.io/Odw80D0pR6yfsOjg_7XCJg?view) for more details.
     *
     * @codeGenApi
     */
    function ɵɵsetComponentScope(type, directives, pipes) {
        var def = type.ɵcmp;
        def.directiveDefs = function () { return directives.map(extractDirectiveDef); };
        def.pipeDefs = function () { return pipes.map(extractPipeDef); };
    }
    function extractDirectiveDef(type) {
        var def = getComponentDef(type) || getDirectiveDef(type);
        if (ngDevMode && !def) {
            throw new Error("'" + type.name + "' is neither 'ComponentType' or 'DirectiveType'.");
        }
        return def;
    }
    function extractPipeDef(type) {
        var def = getPipeDef(type);
        if (ngDevMode && !def) {
            throw new Error("'" + type.name + "' is not a 'PipeType'.");
        }
        return def;
    }
    var autoRegisterModuleById = {};
    /**
     * @codeGenApi
     */
    function ɵɵdefineNgModule(def) {
        var res = {
            type: def.type,
            bootstrap: def.bootstrap || EMPTY_ARRAY$1,
            declarations: def.declarations || EMPTY_ARRAY$1,
            imports: def.imports || EMPTY_ARRAY$1,
            exports: def.exports || EMPTY_ARRAY$1,
            transitiveCompileScopes: null,
            schemas: def.schemas || null,
            id: def.id || null,
        };
        if (def.id != null) {
            noSideEffects(function () {
                autoRegisterModuleById[def.id] = def.type;
            });
        }
        return res;
    }
    /**
     * Adds the module metadata that is necessary to compute the module's transitive scope to an
     * existing module definition.
     *
     * Scope metadata of modules is not used in production builds, so calls to this function can be
     * marked pure to tree-shake it from the bundle, allowing for all referenced declarations
     * to become eligible for tree-shaking as well.
     *
     * @codeGenApi
     */
    function ɵɵsetNgModuleScope(type, scope) {
        return noSideEffects(function () {
            var ngModuleDef = getNgModuleDef(type, true);
            ngModuleDef.declarations = scope.declarations || EMPTY_ARRAY$1;
            ngModuleDef.imports = scope.imports || EMPTY_ARRAY$1;
            ngModuleDef.exports = scope.exports || EMPTY_ARRAY$1;
        });
    }
    /**
     * Inverts an inputs or outputs lookup such that the keys, which were the
     * minified keys, are part of the values, and the values are parsed so that
     * the publicName of the property is the new key
     *
     * e.g. for
     *
     * ```
     * class Comp {
     *   @Input()
     *   propName1: string;
     *
     *   @Input('publicName2')
     *   declaredPropName2: number;
     * }
     * ```
     *
     * will be serialized as
     *
     * ```
     * {
     *   propName1: 'propName1',
     *   declaredPropName2: ['publicName2', 'declaredPropName2'],
     * }
     * ```
     *
     * which is than translated by the minifier as:
     *
     * ```
     * {
     *   minifiedPropName1: 'propName1',
     *   minifiedPropName2: ['publicName2', 'declaredPropName2'],
     * }
     * ```
     *
     * becomes: (public name => minifiedName)
     *
     * ```
     * {
     *  'propName1': 'minifiedPropName1',
     *  'publicName2': 'minifiedPropName2',
     * }
     * ```
     *
     * Optionally the function can take `secondary` which will result in: (public name => declared name)
     *
     * ```
     * {
     *  'propName1': 'propName1',
     *  'publicName2': 'declaredPropName2',
     * }
     * ```
     *

     */
    function invertObject(obj, secondary) {
        if (obj == null)
            return EMPTY_OBJ;
        var newLookup = {};
        for (var minifiedKey in obj) {
            if (obj.hasOwnProperty(minifiedKey)) {
                var publicName = obj[minifiedKey];
                var declaredName = publicName;
                if (Array.isArray(publicName)) {
                    declaredName = publicName[1];
                    publicName = publicName[0];
                }
                newLookup[publicName] = minifiedKey;
                if (secondary) {
                    (secondary[publicName] = declaredName);
                }
            }
        }
        return newLookup;
    }
    /**
     * Create a directive definition object.
     *
     * # Example
     * ```ts
     * class MyDirective {
     *   // Generated by Angular Template Compiler
     *   // [Symbol] syntax will not be supported by TypeScript until v2.7
     *   static ɵdir = ɵɵdefineDirective({
     *     ...
     *   });
     * }
     * ```
     *
     * @codeGenApi
     */
    var ɵɵdefineDirective = ɵɵdefineComponent;
    /**
     * Create a pipe definition object.
     *
     * # Example
     * ```
     * class MyPipe implements PipeTransform {
     *   // Generated by Angular Template Compiler
     *   static ɵpipe = definePipe({
     *     ...
     *   });
     * }
     * ```
     * @param pipeDef Pipe definition generated by the compiler
     *
     * @codeGenApi
     */
    function ɵɵdefinePipe(pipeDef) {
        return {
            type: pipeDef.type,
            name: pipeDef.name,
            factory: null,
            pure: pipeDef.pure !== false,
            onDestroy: pipeDef.type.prototype.ngOnDestroy || null
        };
    }
    /**
     * The following getter methods retrieve the definition from the type. Currently the retrieval
     * honors inheritance, but in the future we may change the rule to require that definitions are
     * explicit. This would require some sort of migration strategy.
     */
    function getComponentDef(type) {
        return type[NG_COMP_DEF] || null;
    }
    function getDirectiveDef(type) {
        return type[NG_DIR_DEF] || null;
    }
    function getPipeDef(type) {
        return type[NG_PIPE_DEF] || null;
    }
    function getNgModuleDef(type, throwNotFound) {
        var ngModuleDef = type[NG_MOD_DEF] || null;
        if (!ngModuleDef && throwNotFound === true) {
            throw new Error("Type " + stringify(type) + " does not have '\u0275mod' property.");
        }
        return ngModuleDef;
    }
    function getNgLocaleIdDef(type) {
        return type[NG_LOC_ID_DEF] || null;
    }

    /**
     * Special location which allows easy identification of type. If we have an array which was
     * retrieved from the `LView` and that array has `true` at `TYPE` location, we know it is
     * `LContainer`.
     */
    var TYPE = 1;
    /**
     * Below are constants for LContainer indices to help us look up LContainer members
     * without having to remember the specific indices.
     * Uglify will inline these when minifying so there shouldn't be a cost.
     */
    /**
     * Flag to signify that this `LContainer` may have transplanted views which need to be change
     * detected. (see: `LView[DECLARATION_COMPONENT_VIEW])`.
     *
     * This flag, once set, is never unset for the `LContainer`. This means that when unset we can skip
     * a lot of work in `refreshEmbeddedViews`. But when set we still need to verify
     * that the `MOVED_VIEWS` are transplanted and on-push.
     */
    var HAS_TRANSPLANTED_VIEWS = 2;
    // PARENT, NEXT, TRANSPLANTED_VIEWS_TO_REFRESH are indices 3, 4, and 5
    // As we already have these constants in LView, we don't need to re-create them.
    // T_HOST is index 6
    // We already have this constants in LView, we don't need to re-create it.
    var NATIVE = 7;
    var VIEW_REFS = 8;
    var MOVED_VIEWS = 9;
    /**
     * Size of LContainer's header. Represents the index after which all views in the
     * container will be inserted. We need to keep a record of current views so we know
     * which views are already in the DOM (and don't need to be re-added) and so we can
     * remove views from the DOM when they are no longer required.
     */
    var CONTAINER_HEADER_OFFSET = 10;
    // Note: This hack is necessary so we don't erroneously get a circular dependency
    // failure based on types.
    var unusedValueExportToPlacateAjd = 1;

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    // Below are constants for LView indices to help us look up LView members
    // without having to remember the specific indices.
    // Uglify will inline these when minifying so there shouldn't be a cost.
    var HOST = 0;
    var TVIEW = 1;
    var FLAGS = 2;
    var PARENT = 3;
    var NEXT = 4;
    var TRANSPLANTED_VIEWS_TO_REFRESH = 5;
    var T_HOST = 6;
    var CLEANUP = 7;
    var CONTEXT = 8;
    var INJECTOR = 9;
    var RENDERER_FACTORY = 10;
    var RENDERER = 11;
    var SANITIZER = 12;
    var CHILD_HEAD = 13;
    var CHILD_TAIL = 14;
    // FIXME(misko): Investigate if the three declarations aren't all same thing.
    var DECLARATION_VIEW = 15;
    var DECLARATION_COMPONENT_VIEW = 16;
    var DECLARATION_LCONTAINER = 17;
    var PREORDER_HOOK_FLAGS = 18;
    var QUERIES = 19;
    /**
     * Size of LView's header. Necessary to adjust for it when setting slots.
     *
     * IMPORTANT: `HEADER_OFFSET` should only be referred to the in the `ɵɵ*` instructions to translate
     * instruction index into `LView` index. All other indexes should be in the `LView` index space and
     * there should be no need to refer to `HEADER_OFFSET` anywhere else.
     */
    var HEADER_OFFSET = 20;
    /**
     * Converts `TViewType` into human readable text.
     * Make sure this matches with `TViewType`
     */
    var TViewTypeAsString = [
        'Root',
        'Component',
        'Embedded',
    ];
    // Note: This hack is necessary so we don't erroneously get a circular dependency
    // failure based on types.
    var unusedValueExportToPlacateAjd$1 = 1;

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * True if `value` is `LView`.
     * @param value wrapped value of `RNode`, `LView`, `LContainer`
     */
    function isLView(value) {
        return Array.isArray(value) && typeof value[TYPE] === 'object';
    }
    /**
     * True if `value` is `LContainer`.
     * @param value wrapped value of `RNode`, `LView`, `LContainer`
     */
    function isLContainer(value) {
        return Array.isArray(value) && value[TYPE] === true;
    }
    function isContentQueryHost(tNode) {
        return (tNode.flags & 8 /* hasContentQuery */) !== 0;
    }
    function isComponentHost(tNode) {
        return (tNode.flags & 2 /* isComponentHost */) === 2 /* isComponentHost */;
    }
    function isDirectiveHost(tNode) {
        return (tNode.flags & 1 /* isDirectiveHost */) === 1 /* isDirectiveHost */;
    }
    function isComponentDef(def) {
        return def.template !== null;
    }
    function isRootView(target) {
        return (target[FLAGS] & 512 /* IsRoot */) !== 0;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    // [Assert functions do not constraint type when they are guarded by a truthy
    // expression.](https://github.com/microsoft/TypeScript/issues/37295)
    function assertTNodeForLView(tNode, lView) {
        assertTNodeForTView(tNode, lView[TVIEW]);
    }
    function assertTNodeForTView(tNode, tView) {
        assertTNode(tNode);
        tNode.hasOwnProperty('tView_') &&
            assertEqual(tNode.tView_, tView, 'This TNode does not belong to this TView.');
    }
    function assertTNode(tNode) {
        assertDefined(tNode, 'TNode must be defined');
        if (!(tNode && typeof tNode === 'object' && tNode.hasOwnProperty('directiveStylingLast'))) {
            throwError('Not of type TNode, got: ' + tNode);
        }
    }
    function assertTIcu(tIcu) {
        assertDefined(tIcu, 'Expected TIcu to be defined');
        if (!(typeof tIcu.currentCaseLViewIndex === 'number')) {
            throwError('Object is not of TIcu type.');
        }
    }
    function assertComponentType(actual, msg) {
        if (msg === void 0) { msg = 'Type passed in is not ComponentType, it does not have \'ɵcmp\' property.'; }
        if (!getComponentDef(actual)) {
            throwError(msg);
        }
    }
    function assertNgModuleType(actual, msg) {
        if (msg === void 0) { msg = 'Type passed in is not NgModuleType, it does not have \'ɵmod\' property.'; }
        if (!getNgModuleDef(actual)) {
            throwError(msg);
        }
    }
    function assertCurrentTNodeIsParent(isParent) {
        assertEqual(isParent, true, 'currentTNode should be a parent');
    }
    function assertHasParent(tNode) {
        assertDefined(tNode, 'currentTNode should exist!');
        assertDefined(tNode.parent, 'currentTNode should have a parent');
    }
    function assertDataNext(lView, index, arr) {
        if (arr == null)
            arr = lView;
        assertEqual(arr.length, index, "index " + index + " expected to be at the end of arr (length " + arr.length + ")");
    }
    function assertLContainer(value) {
        assertDefined(value, 'LContainer must be defined');
        assertEqual(isLContainer(value), true, 'Expecting LContainer');
    }
    function assertLViewOrUndefined(value) {
        value && assertEqual(isLView(value), true, 'Expecting LView or undefined or null');
    }
    function assertLView(value) {
        assertDefined(value, 'LView must be defined');
        assertEqual(isLView(value), true, 'Expecting LView');
    }
    function assertFirstCreatePass(tView, errMessage) {
        assertEqual(tView.firstCreatePass, true, errMessage || 'Should only be called in first create pass.');
    }
    function assertFirstUpdatePass(tView, errMessage) {
        assertEqual(tView.firstUpdatePass, true, errMessage || 'Should only be called in first update pass.');
    }
    /**
     * This is a basic sanity check that an object is probably a directive def. DirectiveDef is
     * an interface, so we can't do a direct instanceof check.
     */
    function assertDirectiveDef(obj) {
        if (obj.type === undefined || obj.selectors == undefined || obj.inputs === undefined) {
            throwError("Expected a DirectiveDef/ComponentDef and this object does not seem to have the expected shape.");
        }
    }
    function assertIndexInDeclRange(lView, index) {
        var tView = lView[1];
        assertBetween(HEADER_OFFSET, tView.bindingStartIndex, index);
    }
    function assertIndexInVarsRange(lView, index) {
        var tView = lView[1];
        assertBetween(tView.bindingStartIndex, tView.expandoStartIndex, index);
    }
    function assertIndexInExpandoRange(lView, index) {
        var tView = lView[1];
        assertBetween(tView.expandoStartIndex, lView.length, index);
    }
    function assertBetween(lower, upper, index) {
        if (!(lower <= index && index < upper)) {
            throwError("Index out of range (expecting " + lower + " <= " + index + " < " + upper + ")");
        }
    }
    function assertProjectionSlots(lView, errMessage) {
        assertDefined(lView[DECLARATION_COMPONENT_VIEW], 'Component views should exist.');
        assertDefined(lView[DECLARATION_COMPONENT_VIEW][T_HOST].projection, errMessage ||
            'Components with projection nodes (<ng-content>) must have projection slots defined.');
    }
    function assertParentView(lView, errMessage) {
        assertDefined(lView, errMessage || 'Component views should always have a parent view (component\'s host view)');
    }
    /**
     * This is a basic sanity check that the `injectorIndex` seems to point to what looks like a
     * NodeInjector data structure.
     *
     * @param lView `LView` which should be checked.
     * @param injectorIndex index into the `LView` where the `NodeInjector` is expected.
     */
    function assertNodeInjector(lView, injectorIndex) {
        assertIndexInExpandoRange(lView, injectorIndex);
        assertIndexInExpandoRange(lView, injectorIndex + 8 /* PARENT */);
        assertNumber(lView[injectorIndex + 0], 'injectorIndex should point to a bloom filter');
        assertNumber(lView[injectorIndex + 1], 'injectorIndex should point to a bloom filter');
        assertNumber(lView[injectorIndex + 2], 'injectorIndex should point to a bloom filter');
        assertNumber(lView[injectorIndex + 3], 'injectorIndex should point to a bloom filter');
        assertNumber(lView[injectorIndex + 4], 'injectorIndex should point to a bloom filter');
        assertNumber(lView[injectorIndex + 5], 'injectorIndex should point to a bloom filter');
        assertNumber(lView[injectorIndex + 6], 'injectorIndex should point to a bloom filter');
        assertNumber(lView[injectorIndex + 7], 'injectorIndex should point to a bloom filter');
        assertNumber(lView[injectorIndex + 8 /* PARENT */], 'injectorIndex should point to parent injector');
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function getFactoryDef(type, throwNotFound) {
        var hasFactoryDef = type.hasOwnProperty(NG_FACTORY_DEF);
        if (!hasFactoryDef && throwNotFound === true && ngDevMode) {
            throw new Error("Type " + stringify(type) + " does not have '\u0275fac' property.");
        }
        return hasFactoryDef ? type[NG_FACTORY_DEF] : null;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Represents a basic change from a previous to a new value for a single
     * property on a directive instance. Passed as a value in a
     * {@link SimpleChanges} object to the `ngOnChanges` hook.
     *
     * @see `OnChanges`
     *
     * @publicApi
     */
    var SimpleChange = /** @class */ (function () {
        function SimpleChange(previousValue, currentValue, firstChange) {
            this.previousValue = previousValue;
            this.currentValue = currentValue;
            this.firstChange = firstChange;
        }
        /**
         * Check whether the new value is the first value assigned.
         */
        SimpleChange.prototype.isFirstChange = function () {
            return this.firstChange;
        };
        return SimpleChange;
    }());

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * The NgOnChangesFeature decorates a component with support for the ngOnChanges
     * lifecycle hook, so it should be included in any component that implements
     * that hook.
     *
     * If the component or directive uses inheritance, the NgOnChangesFeature MUST
     * be included as a feature AFTER {@link InheritDefinitionFeature}, otherwise
     * inherited properties will not be propagated to the ngOnChanges lifecycle
     * hook.
     *
     * Example usage:
     *
     * ```
     * static ɵcmp = defineComponent({
     *   ...
     *   inputs: {name: 'publicName'},
     *   features: [NgOnChangesFeature]
     * });
     * ```
     *
     * @codeGenApi
     */
    function ɵɵNgOnChangesFeature() {
        return NgOnChangesFeatureImpl;
    }
    function NgOnChangesFeatureImpl(definition) {
        if (definition.type.prototype.ngOnChanges) {
            definition.setInput = ngOnChangesSetInput;
        }
        return rememberChangeHistoryAndInvokeOnChangesHook;
    }
    // This option ensures that the ngOnChanges lifecycle hook will be inherited
    // from superclasses (in InheritDefinitionFeature).
    /** @nocollapse */
    // tslint:disable-next-line:no-toplevel-property-access
    ɵɵNgOnChangesFeature.ngInherit = true;
    /**
     * This is a synthetic lifecycle hook which gets inserted into `TView.preOrderHooks` to simulate
     * `ngOnChanges`.
     *
     * The hook reads the `NgSimpleChangesStore` data from the component instance and if changes are
     * found it invokes `ngOnChanges` on the component instance.
     *
     * @param this Component instance. Because this function gets inserted into `TView.preOrderHooks`,
     *     it is guaranteed to be called with component instance.
     */
    function rememberChangeHistoryAndInvokeOnChangesHook() {
        var simpleChangesStore = getSimpleChangesStore(this);
        var current = simpleChangesStore === null || simpleChangesStore === void 0 ? void 0 : simpleChangesStore.current;
        if (current) {
            var previous = simpleChangesStore.previous;
            if (previous === EMPTY_OBJ) {
                simpleChangesStore.previous = current;
            }
            else {
                // New changes are copied to the previous store, so that we don't lose history for inputs
                // which were not changed this time
                for (var key in current) {
                    previous[key] = current[key];
                }
            }
            simpleChangesStore.current = null;
            this.ngOnChanges(current);
        }
    }
    function ngOnChangesSetInput(instance, value, publicName, privateName) {
        var simpleChangesStore = getSimpleChangesStore(instance) ||
            setSimpleChangesStore(instance, { previous: EMPTY_OBJ, current: null });
        var current = simpleChangesStore.current || (simpleChangesStore.current = {});
        var previous = simpleChangesStore.previous;
        var declaredName = this.declaredInputs[publicName];
        var previousChange = previous[declaredName];
        current[declaredName] = new SimpleChange(previousChange && previousChange.currentValue, value, previous === EMPTY_OBJ);
        instance[privateName] = value;
    }
    var SIMPLE_CHANGES_STORE = '__ngSimpleChanges__';
    function getSimpleChangesStore(instance) {
        return instance[SIMPLE_CHANGES_STORE] || null;
    }
    function setSimpleChangesStore(instance, store) {
        return instance[SIMPLE_CHANGES_STORE] = store;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var SVG_NAMESPACE = 'http://www.w3.org/2000/svg';
    var MATH_ML_NAMESPACE = 'http://www.w3.org/1998/MathML/';

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * This property will be monkey-patched on elements, components and directives
     */
    var MONKEY_PATCH_KEY_NAME = '__ngContext__';

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Most of the use of `document` in Angular is from within the DI system so it is possible to simply
     * inject the `DOCUMENT` token and are done.
     *
     * Ivy is special because it does not rely upon the DI and must get hold of the document some other
     * way.
     *
     * The solution is to define `getDocument()` and `setDocument()` top-level functions for ivy.
     * Wherever ivy needs the global document, it calls `getDocument()` instead.
     *
     * When running ivy outside of a browser environment, it is necessary to call `setDocument()` to
     * tell ivy what the global `document` is.
     *
     * Angular does this for us in each of the standard platforms (`Browser`, `Server`, and `WebWorker`)
     * by calling `setDocument()` when providing the `DOCUMENT` token.
     */
    var DOCUMENT = undefined;
    /**
     * Tell ivy what the `document` is for this platform.
     *
     * It is only necessary to call this if the current platform is not a browser.
     *
     * @param document The object representing the global `document` in this environment.
     */
    function setDocument(document) {
        DOCUMENT = document;
    }
    /**
     * Access the object that represents the `document` for this platform.
     *
     * Ivy calls this whenever it needs to access the `document` object.
     * For example to create the renderer or to do sanitization.
     */
    function getDocument() {
        if (DOCUMENT !== undefined) {
            return DOCUMENT;
        }
        else if (typeof document !== 'undefined') {
            return document;
        }
        // No "document" can be found. This should only happen if we are running ivy outside Angular and
        // the current platform is not a browser. Since this is not a supported scenario at the moment
        // this should not happen in Angular apps.
        // Once we support running ivy outside of Angular we will need to publish `setDocument()` as a
        // public API. Meanwhile we just return `undefined` and let the application fail.
        return undefined;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    // TODO: cleanup once the code is merged in angular/angular
    var RendererStyleFlags3;
    (function (RendererStyleFlags3) {
        RendererStyleFlags3[RendererStyleFlags3["Important"] = 1] = "Important";
        RendererStyleFlags3[RendererStyleFlags3["DashCase"] = 2] = "DashCase";
    })(RendererStyleFlags3 || (RendererStyleFlags3 = {}));
    /** Returns whether the `renderer` is a `ProceduralRenderer3` */
    function isProceduralRenderer(renderer) {
        return !!(renderer.listen);
    }
    var ɵ0 = function (hostElement, rendererType) {
        return getDocument();
    };
    var domRendererFactory3 = {
        createRenderer: ɵ0
    };
    // Note: This hack is necessary so we don't erroneously get a circular dependency
    // failure based on types.
    var unusedValueExportToPlacateAjd$2 = 1;

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * For efficiency reasons we often put several different data types (`RNode`, `LView`, `LContainer`)
     * in same location in `LView`. This is because we don't want to pre-allocate space for it
     * because the storage is sparse. This file contains utilities for dealing with such data types.
     *
     * How do we know what is stored at a given location in `LView`.
     * - `Array.isArray(value) === false` => `RNode` (The normal storage value)
     * - `Array.isArray(value) === true` => then the `value[0]` represents the wrapped value.
     *   - `typeof value[TYPE] === 'object'` => `LView`
     *      - This happens when we have a component at a given location
     *   - `typeof value[TYPE] === true` => `LContainer`
     *      - This happens when we have `LContainer` binding at a given location.
     *
     *
     * NOTE: it is assumed that `Array.isArray` and `typeof` operations are very efficient.
     */
    /**
     * Returns `RNode`.
     * @param value wrapped value of `RNode`, `LView`, `LContainer`
     */
    function unwrapRNode(value) {
        while (Array.isArray(value)) {
            value = value[HOST];
        }
        return value;
    }
    /**
     * Returns `LView` or `null` if not found.
     * @param value wrapped value of `RNode`, `LView`, `LContainer`
     */
    function unwrapLView(value) {
        while (Array.isArray(value)) {
            // This check is same as `isLView()` but we don't call at as we don't want to call
            // `Array.isArray()` twice and give JITer more work for inlining.
            if (typeof value[TYPE] === 'object')
                return value;
            value = value[HOST];
        }
        return null;
    }
    /**
     * Returns `LContainer` or `null` if not found.
     * @param value wrapped value of `RNode`, `LView`, `LContainer`
     */
    function unwrapLContainer(value) {
        while (Array.isArray(value)) {
            // This check is same as `isLContainer()` but we don't call at as we don't want to call
            // `Array.isArray()` twice and give JITer more work for inlining.
            if (value[TYPE] === true)
                return value;
            value = value[HOST];
        }
        return null;
    }
    /**
     * Retrieves an element value from the provided `viewData`, by unwrapping
     * from any containers, component views, or style contexts.
     */
    function getNativeByIndex(index, lView) {
        ngDevMode && assertIndexInRange(lView, index);
        ngDevMode && assertGreaterThanOrEqual(index, HEADER_OFFSET, 'Expected to be past HEADER_OFFSET');
        return unwrapRNode(lView[index]);
    }
    /**
     * Retrieve an `RNode` for a given `TNode` and `LView`.
     *
     * This function guarantees in dev mode to retrieve a non-null `RNode`.
     *
     * @param tNode
     * @param lView
     */
    function getNativeByTNode(tNode, lView) {
        ngDevMode && assertTNodeForLView(tNode, lView);
        ngDevMode && assertIndexInRange(lView, tNode.index);
        var node = unwrapRNode(lView[tNode.index]);
        ngDevMode && !isProceduralRenderer(lView[RENDERER]) && assertDomNode(node);
        return node;
    }
    /**
     * Retrieve an `RNode` or `null` for a given `TNode` and `LView`.
     *
     * Some `TNode`s don't have associated `RNode`s. For example `Projection`
     *
     * @param tNode
     * @param lView
     */
    function getNativeByTNodeOrNull(tNode, lView) {
        var index = tNode === null ? -1 : tNode.index;
        if (index !== -1) {
            ngDevMode && assertTNodeForLView(tNode, lView);
            var node = unwrapRNode(lView[index]);
            ngDevMode && node !== null && !isProceduralRenderer(lView[RENDERER]) && assertDomNode(node);
            return node;
        }
        return null;
    }
    // fixme(misko): The return Type should be `TNode|null`
    function getTNode(tView, index) {
        ngDevMode && assertGreaterThan(index, -1, 'wrong index for TNode');
        ngDevMode && assertLessThan(index, tView.data.length, 'wrong index for TNode');
        var tNode = tView.data[index];
        ngDevMode && tNode !== null && assertTNode(tNode);
        return tNode;
    }
    /** Retrieves a value from any `LView` or `TData`. */
    function load(view, index) {
        ngDevMode && assertIndexInRange(view, index);
        return view[index];
    }
    function getComponentLViewByIndex(nodeIndex, hostView) {
        // Could be an LView or an LContainer. If LContainer, unwrap to find LView.
        ngDevMode && assertIndexInRange(hostView, nodeIndex);
        var slotValue = hostView[nodeIndex];
        var lView = isLView(slotValue) ? slotValue : slotValue[HOST];
        return lView;
    }
    /**
     * Returns the monkey-patch value data present on the target (which could be
     * a component, directive or a DOM node).
     */
    function readPatchedData(target) {
        ngDevMode && assertDefined(target, 'Target expected');
        return target[MONKEY_PATCH_KEY_NAME] || null;
    }
    function readPatchedLView(target) {
        var value = readPatchedData(target);
        if (value) {
            return Array.isArray(value) ? value : value.lView;
        }
        return null;
    }
    /** Checks whether a given view is in creation mode */
    function isCreationMode(view) {
        return (view[FLAGS] & 4 /* CreationMode */) === 4 /* CreationMode */;
    }
    /**
     * Returns a boolean for whether the view is attached to the change detection tree.
     *
     * Note: This determines whether a view should be checked, not whether it's inserted
     * into a container. For that, you'll want `viewAttachedToContainer` below.
     */
    function viewAttachedToChangeDetector(view) {
        return (view[FLAGS] & 128 /* Attached */) === 128 /* Attached */;
    }
    /** Returns a boolean for whether the view is attached to a container. */
    function viewAttachedToContainer(view) {
        return isLContainer(view[PARENT]);
    }
    function getConstant(consts, index) {
        if (index === null || index === undefined)
            return null;
        ngDevMode && assertIndexInRange(consts, index);
        return consts[index];
    }
    /**
     * Resets the pre-order hook flags of the view.
     * @param lView the LView on which the flags are reset
     */
    function resetPreOrderHookFlags(lView) {
        lView[PREORDER_HOOK_FLAGS] = 0;
    }
    /**
     * Updates the `TRANSPLANTED_VIEWS_TO_REFRESH` counter on the `LContainer` as well as the parents
     * whose
     *  1. counter goes from 0 to 1, indicating that there is a new child that has a view to refresh
     *  or
     *  2. counter goes from 1 to 0, indicating there are no more descendant views to refresh
     */
    function updateTransplantedViewCount(lContainer, amount) {
        lContainer[TRANSPLANTED_VIEWS_TO_REFRESH] += amount;
        var viewOrContainer = lContainer;
        var parent = lContainer[PARENT];
        while (parent !== null &&
            ((amount === 1 && viewOrContainer[TRANSPLANTED_VIEWS_TO_REFRESH] === 1) ||
                (amount === -1 && viewOrContainer[TRANSPLANTED_VIEWS_TO_REFRESH] === 0))) {
            parent[TRANSPLANTED_VIEWS_TO_REFRESH] += amount;
            viewOrContainer = parent;
            parent = parent[PARENT];
        }
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var instructionState = {
        lFrame: createLFrame(null),
        bindingsEnabled: true,
        isInCheckNoChangesMode: false,
    };
    /**
     * Returns true if the instruction state stack is empty.
     *
     * Intended to be called from tests only (tree shaken otherwise).
     */
    function specOnlyIsInstructionStateEmpty() {
        return instructionState.lFrame.parent === null;
    }
    function getElementDepthCount() {
        return instructionState.lFrame.elementDepthCount;
    }
    function increaseElementDepthCount() {
        instructionState.lFrame.elementDepthCount++;
    }
    function decreaseElementDepthCount() {
        instructionState.lFrame.elementDepthCount--;
    }
    function getBindingsEnabled() {
        return instructionState.bindingsEnabled;
    }
    /**
     * Enables directive matching on elements.
     *
     *  * Example:
     * ```
     * <my-comp my-directive>
     *   Should match component / directive.
     * </my-comp>
     * <div ngNonBindable>
     *   <!-- ɵɵdisableBindings() -->
     *   <my-comp my-directive>
     *     Should not match component / directive because we are in ngNonBindable.
     *   </my-comp>
     *   <!-- ɵɵenableBindings() -->
     * </div>
     * ```
     *
     * @codeGenApi
     */
    function ɵɵenableBindings() {
        instructionState.bindingsEnabled = true;
    }
    /**
     * Disables directive matching on element.
     *
     *  * Example:
     * ```
     * <my-comp my-directive>
     *   Should match component / directive.
     * </my-comp>
     * <div ngNonBindable>
     *   <!-- ɵɵdisableBindings() -->
     *   <my-comp my-directive>
     *     Should not match component / directive because we are in ngNonBindable.
     *   </my-comp>
     *   <!-- ɵɵenableBindings() -->
     * </div>
     * ```
     *
     * @codeGenApi
     */
    function ɵɵdisableBindings() {
        instructionState.bindingsEnabled = false;
    }
    /**
     * Return the current `LView`.
     */
    function getLView() {
        return instructionState.lFrame.lView;
    }
    /**
     * Return the current `TView`.
     */
    function getTView() {
        return instructionState.lFrame.tView;
    }
    /**
     * Restores `contextViewData` to the given OpaqueViewState instance.
     *
     * Used in conjunction with the getCurrentView() instruction to save a snapshot
     * of the current view and restore it when listeners are invoked. This allows
     * walking the declaration view tree in listeners to get vars from parent views.
     *
     * @param viewToRestore The OpaqueViewState instance to restore.
     *
     * @codeGenApi
     */
    function ɵɵrestoreView(viewToRestore) {
        instructionState.lFrame.contextLView = viewToRestore;
    }
    function getCurrentTNode() {
        var currentTNode = getCurrentTNodePlaceholderOk();
        while (currentTNode !== null && currentTNode.type === 64 /* Placeholder */) {
            currentTNode = currentTNode.parent;
        }
        return currentTNode;
    }
    function getCurrentTNodePlaceholderOk() {
        return instructionState.lFrame.currentTNode;
    }
    function getCurrentParentTNode() {
        var lFrame = instructionState.lFrame;
        var currentTNode = lFrame.currentTNode;
        return lFrame.isParent ? currentTNode : currentTNode.parent;
    }
    function setCurrentTNode(tNode, isParent) {
        ngDevMode && tNode && assertTNodeForTView(tNode, instructionState.lFrame.tView);
        var lFrame = instructionState.lFrame;
        lFrame.currentTNode = tNode;
        lFrame.isParent = isParent;
    }
    function isCurrentTNodeParent() {
        return instructionState.lFrame.isParent;
    }
    function setCurrentTNodeAsNotParent() {
        instructionState.lFrame.isParent = false;
    }
    function setCurrentTNodeAsParent() {
        instructionState.lFrame.isParent = true;
    }
    function getContextLView() {
        return instructionState.lFrame.contextLView;
    }
    function isInCheckNoChangesMode() {
        // TODO(misko): remove this from the LView since it is ngDevMode=true mode only.
        return instructionState.isInCheckNoChangesMode;
    }
    function setIsInCheckNoChangesMode(mode) {
        instructionState.isInCheckNoChangesMode = mode;
    }
    // top level variables should not be exported for performance reasons (PERF_NOTES.md)
    function getBindingRoot() {
        var lFrame = instructionState.lFrame;
        var index = lFrame.bindingRootIndex;
        if (index === -1) {
            index = lFrame.bindingRootIndex = lFrame.tView.bindingStartIndex;
        }
        return index;
    }
    function getBindingIndex() {
        return instructionState.lFrame.bindingIndex;
    }
    function setBindingIndex(value) {
        return instructionState.lFrame.bindingIndex = value;
    }
    function nextBindingIndex() {
        return instructionState.lFrame.bindingIndex++;
    }
    function incrementBindingIndex(count) {
        var lFrame = instructionState.lFrame;
        var index = lFrame.bindingIndex;
        lFrame.bindingIndex = lFrame.bindingIndex + count;
        return index;
    }
    function isInI18nBlock() {
        return instructionState.lFrame.inI18n;
    }
    function setInI18nBlock(isInI18nBlock) {
        instructionState.lFrame.inI18n = isInI18nBlock;
    }
    /**
     * Set a new binding root index so that host template functions can execute.
     *
     * Bindings inside the host template are 0 index. But because we don't know ahead of time
     * how many host bindings we have we can't pre-compute them. For this reason they are all
     * 0 index and we just shift the root so that they match next available location in the LView.
     *
     * @param bindingRootIndex Root index for `hostBindings`
     * @param currentDirectiveIndex `TData[currentDirectiveIndex]` will point to the current directive
     *        whose `hostBindings` are being processed.
     */
    function setBindingRootForHostBindings(bindingRootIndex, currentDirectiveIndex) {
        var lFrame = instructionState.lFrame;
        lFrame.bindingIndex = lFrame.bindingRootIndex = bindingRootIndex;
        setCurrentDirectiveIndex(currentDirectiveIndex);
    }
    /**
     * When host binding is executing this points to the directive index.
     * `TView.data[getCurrentDirectiveIndex()]` is `DirectiveDef`
     * `LView[getCurrentDirectiveIndex()]` is directive instance.
     */
    function getCurrentDirectiveIndex() {
        return instructionState.lFrame.currentDirectiveIndex;
    }
    /**
     * Sets an index of a directive whose `hostBindings` are being processed.
     *
     * @param currentDirectiveIndex `TData` index where current directive instance can be found.
     */
    function setCurrentDirectiveIndex(currentDirectiveIndex) {
        instructionState.lFrame.currentDirectiveIndex = currentDirectiveIndex;
    }
    /**
     * Retrieve the current `DirectiveDef` which is active when `hostBindings` instruction is being
     * executed.
     *
     * @param tData Current `TData` where the `DirectiveDef` will be looked up at.
     */
    function getCurrentDirectiveDef(tData) {
        var currentDirectiveIndex = instructionState.lFrame.currentDirectiveIndex;
        return currentDirectiveIndex === -1 ? null : tData[currentDirectiveIndex];
    }
    function getCurrentQueryIndex() {
        return instructionState.lFrame.currentQueryIndex;
    }
    function setCurrentQueryIndex(value) {
        instructionState.lFrame.currentQueryIndex = value;
    }
    /**
     * Returns a `TNode` of the location where the current `LView` is declared at.
     *
     * @param lView an `LView` that we want to find parent `TNode` for.
     */
    function getDeclarationTNode(lView) {
        var tView = lView[TVIEW];
        // Return the declaration parent for embedded views
        if (tView.type === 2 /* Embedded */) {
            ngDevMode && assertDefined(tView.declTNode, 'Embedded TNodes should have declaration parents.');
            return tView.declTNode;
        }
        // Components don't have `TView.declTNode` because each instance of component could be
        // inserted in different location, hence `TView.declTNode` is meaningless.
        // Falling back to `T_HOST` in case we cross component boundary.
        if (tView.type === 1 /* Component */) {
            return lView[T_HOST];
        }
        // Remaining TNode type is `TViewType.Root` which doesn't have a parent TNode.
        return null;
    }
    /**
     * This is a light weight version of the `enterView` which is needed by the DI system.
     *
     * @param lView `LView` location of the DI context.
     * @param tNode `TNode` for DI context
     * @param flags DI context flags. if `SkipSelf` flag is set than we walk up the declaration
     *     tree from `tNode`  until we find parent declared `TElementNode`.
     * @returns `true` if we have successfully entered DI associated with `tNode` (or with declared
     *     `TNode` if `flags` has  `SkipSelf`). Failing to enter DI implies that no associated
     *     `NodeInjector` can be found and we should instead use `ModuleInjector`.
     *     - If `true` than this call must be fallowed by `leaveDI`
     *     - If `false` than this call failed and we should NOT call `leaveDI`
     */
    function enterDI(lView, tNode, flags) {
        ngDevMode && assertLViewOrUndefined(lView);
        if (flags & exports.InjectFlags.SkipSelf) {
            ngDevMode && assertTNodeForTView(tNode, lView[TVIEW]);
            var parentTNode = tNode;
            var parentLView = lView;
            while (true) {
                ngDevMode && assertDefined(parentTNode, 'Parent TNode should be defined');
                parentTNode = parentTNode.parent;
                if (parentTNode === null && !(flags & exports.InjectFlags.Host)) {
                    parentTNode = getDeclarationTNode(parentLView);
                    if (parentTNode === null)
                        break;
                    // In this case, a parent exists and is definitely an element. So it will definitely
                    // have an existing lView as the declaration view, which is why we can assume it's defined.
                    ngDevMode && assertDefined(parentLView, 'Parent LView should be defined');
                    parentLView = parentLView[DECLARATION_VIEW];
                    // In Ivy there are Comment nodes that correspond to ngIf and NgFor embedded directives
                    // We want to skip those and look only at Elements and ElementContainers to ensure
                    // we're looking at true parent nodes, and not content or other types.
                    if (parentTNode.type & (2 /* Element */ | 8 /* ElementContainer */)) {
                        break;
                    }
                }
                else {
                    break;
                }
            }
            if (parentTNode === null) {
                // If we failed to find a parent TNode this means that we should use module injector.
                return false;
            }
            else {
                tNode = parentTNode;
                lView = parentLView;
            }
        }
        ngDevMode && assertTNodeForLView(tNode, lView);
        var lFrame = instructionState.lFrame = allocLFrame();
        lFrame.currentTNode = tNode;
        lFrame.lView = lView;
        return true;
    }
    /**
     * Swap the current lView with a new lView.
     *
     * For performance reasons we store the lView in the top level of the module.
     * This way we minimize the number of properties to read. Whenever a new view
     * is entered we have to store the lView for later, and when the view is
     * exited the state has to be restored
     *
     * @param newView New lView to become active
     * @returns the previously active lView;
     */
    function enterView(newView) {
        ngDevMode && assertNotEqual(newView[0], newView[1], '????');
        ngDevMode && assertLViewOrUndefined(newView);
        var newLFrame = allocLFrame();
        if (ngDevMode) {
            assertEqual(newLFrame.isParent, true, 'Expected clean LFrame');
            assertEqual(newLFrame.lView, null, 'Expected clean LFrame');
            assertEqual(newLFrame.tView, null, 'Expected clean LFrame');
            assertEqual(newLFrame.selectedIndex, -1, 'Expected clean LFrame');
            assertEqual(newLFrame.elementDepthCount, 0, 'Expected clean LFrame');
            assertEqual(newLFrame.currentDirectiveIndex, -1, 'Expected clean LFrame');
            assertEqual(newLFrame.currentNamespace, null, 'Expected clean LFrame');
            assertEqual(newLFrame.bindingRootIndex, -1, 'Expected clean LFrame');
            assertEqual(newLFrame.currentQueryIndex, 0, 'Expected clean LFrame');
        }
        var tView = newView[TVIEW];
        instructionState.lFrame = newLFrame;
        ngDevMode && tView.firstChild && assertTNodeForTView(tView.firstChild, tView);
        newLFrame.currentTNode = tView.firstChild;
        newLFrame.lView = newView;
        newLFrame.tView = tView;
        newLFrame.contextLView = newView;
        newLFrame.bindingIndex = tView.bindingStartIndex;
        newLFrame.inI18n = false;
    }
    /**
     * Allocates next free LFrame. This function tries to reuse the `LFrame`s to lower memory pressure.
     */
    function allocLFrame() {
        var currentLFrame = instructionState.lFrame;
        var childLFrame = currentLFrame === null ? null : currentLFrame.child;
        var newLFrame = childLFrame === null ? createLFrame(currentLFrame) : childLFrame;
        return newLFrame;
    }
    function createLFrame(parent) {
        var lFrame = {
            currentTNode: null,
            isParent: true,
            lView: null,
            tView: null,
            selectedIndex: -1,
            contextLView: null,
            elementDepthCount: 0,
            currentNamespace: null,
            currentDirectiveIndex: -1,
            bindingRootIndex: -1,
            bindingIndex: -1,
            currentQueryIndex: 0,
            parent: parent,
            child: null,
            inI18n: false,
        };
        parent !== null && (parent.child = lFrame); // link the new LFrame for reuse.
        return lFrame;
    }
    /**
     * A lightweight version of leave which is used with DI.
     *
     * This function only resets `currentTNode` and `LView` as those are the only properties
     * used with DI (`enterDI()`).
     *
     * NOTE: This function is reexported as `leaveDI`. However `leaveDI` has return type of `void` where
     * as `leaveViewLight` has `LFrame`. This is so that `leaveViewLight` can be used in `leaveView`.
     */
    function leaveViewLight() {
        var oldLFrame = instructionState.lFrame;
        instructionState.lFrame = oldLFrame.parent;
        oldLFrame.currentTNode = null;
        oldLFrame.lView = null;
        return oldLFrame;
    }
    /**
     * This is a lightweight version of the `leaveView` which is needed by the DI system.
     *
     * NOTE: this function is an alias so that we can change the type of the function to have `void`
     * return type.
     */
    var leaveDI = leaveViewLight;
    /**
     * Leave the current `LView`
     *
     * This pops the `LFrame` with the associated `LView` from the stack.
     *
     * IMPORTANT: We must zero out the `LFrame` values here otherwise they will be retained. This is
     * because for performance reasons we don't release `LFrame` but rather keep it for next use.
     */
    function leaveView() {
        var oldLFrame = leaveViewLight();
        oldLFrame.isParent = true;
        oldLFrame.tView = null;
        oldLFrame.selectedIndex = -1;
        oldLFrame.contextLView = null;
        oldLFrame.elementDepthCount = 0;
        oldLFrame.currentDirectiveIndex = -1;
        oldLFrame.currentNamespace = null;
        oldLFrame.bindingRootIndex = -1;
        oldLFrame.bindingIndex = -1;
        oldLFrame.currentQueryIndex = 0;
    }
    function nextContextImpl(level) {
        var contextLView = instructionState.lFrame.contextLView =
            walkUpViews(level, instructionState.lFrame.contextLView);
        return contextLView[CONTEXT];
    }
    function walkUpViews(nestingLevel, currentView) {
        while (nestingLevel > 0) {
            ngDevMode &&
                assertDefined(currentView[DECLARATION_VIEW], 'Declaration view should be defined if nesting level is greater than 0.');
            currentView = currentView[DECLARATION_VIEW];
            nestingLevel--;
        }
        return currentView;
    }
    /**
     * Gets the currently selected element index.
     *
     * Used with {@link property} instruction (and more in the future) to identify the index in the
     * current `LView` to act on.
     */
    function getSelectedIndex() {
        return instructionState.lFrame.selectedIndex;
    }
    /**
     * Sets the most recent index passed to {@link select}
     *
     * Used with {@link property} instruction (and more in the future) to identify the index in the
     * current `LView` to act on.
     *
     * (Note that if an "exit function" was set earlier (via `setElementExitFn()`) then that will be
     * run if and when the provided `index` value is different from the current selected index value.)
     */
    function setSelectedIndex(index) {
        ngDevMode && index !== -1 &&
            assertGreaterThanOrEqual(index, HEADER_OFFSET, 'Index must be past HEADER_OFFSET (or -1).');
        ngDevMode &&
            assertLessThan(index, instructionState.lFrame.lView.length, 'Can\'t set index passed end of LView');
        instructionState.lFrame.selectedIndex = index;
    }
    /**
     * Gets the `tNode` that represents currently selected element.
     */
    function getSelectedTNode() {
        var lFrame = instructionState.lFrame;
        return getTNode(lFrame.tView, lFrame.selectedIndex);
    }
    /**
     * Sets the namespace used to create elements to `'http://www.w3.org/2000/svg'` in global state.
     *
     * @codeGenApi
     */
    function ɵɵnamespaceSVG() {
        instructionState.lFrame.currentNamespace = SVG_NAMESPACE;
    }
    /**
     * Sets the namespace used to create elements to `'http://www.w3.org/1998/MathML/'` in global state.
     *
     * @codeGenApi
     */
    function ɵɵnamespaceMathML() {
        instructionState.lFrame.currentNamespace = MATH_ML_NAMESPACE;
    }
    /**
     * Sets the namespace used to create elements to `null`, which forces element creation to use
     * `createElement` rather than `createElementNS`.
     *
     * @codeGenApi
     */
    function ɵɵnamespaceHTML() {
        namespaceHTMLInternal();
    }
    /**
     * Sets the namespace used to create elements to `null`, which forces element creation to use
     * `createElement` rather than `createElementNS`.
     */
    function namespaceHTMLInternal() {
        instructionState.lFrame.currentNamespace = null;
    }
    function getNamespace() {
        return instructionState.lFrame.currentNamespace;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Adds all directive lifecycle hooks from the given `DirectiveDef` to the given `TView`.
     *
     * Must be run *only* on the first template pass.
     *
     * Sets up the pre-order hooks on the provided `tView`,
     * see {@link HookData} for details about the data structure.
     *
     * @param directiveIndex The index of the directive in LView
     * @param directiveDef The definition containing the hooks to setup in tView
     * @param tView The current TView
     */
    function registerPreOrderHooks(directiveIndex, directiveDef, tView) {
        ngDevMode && assertFirstCreatePass(tView);
        var _a = directiveDef.type.prototype, ngOnChanges = _a.ngOnChanges, ngOnInit = _a.ngOnInit, ngDoCheck = _a.ngDoCheck;
        if (ngOnChanges) {
            var wrappedOnChanges = NgOnChangesFeatureImpl(directiveDef);
            (tView.preOrderHooks || (tView.preOrderHooks = [])).push(directiveIndex, wrappedOnChanges);
            (tView.preOrderCheckHooks || (tView.preOrderCheckHooks = []))
                .push(directiveIndex, wrappedOnChanges);
        }
        if (ngOnInit) {
            (tView.preOrderHooks || (tView.preOrderHooks = [])).push(0 - directiveIndex, ngOnInit);
        }
        if (ngDoCheck) {
            (tView.preOrderHooks || (tView.preOrderHooks = [])).push(directiveIndex, ngDoCheck);
            (tView.preOrderCheckHooks || (tView.preOrderCheckHooks = [])).push(directiveIndex, ngDoCheck);
        }
    }
    /**
     *
     * Loops through the directives on the provided `tNode` and queues hooks to be
     * run that are not initialization hooks.
     *
     * Should be executed during `elementEnd()` and similar to
     * preserve hook execution order. Content, view, and destroy hooks for projected
     * components and directives must be called *before* their hosts.
     *
     * Sets up the content, view, and destroy hooks on the provided `tView`,
     * see {@link HookData} for details about the data structure.
     *
     * NOTE: This does not set up `onChanges`, `onInit` or `doCheck`, those are set up
     * separately at `elementStart`.
     *
     * @param tView The current TView
     * @param tNode The TNode whose directives are to be searched for hooks to queue
     */
    function registerPostOrderHooks(tView, tNode) {
        ngDevMode && assertFirstCreatePass(tView);
        // It's necessary to loop through the directives at elementEnd() (rather than processing in
        // directiveCreate) so we can preserve the current hook order. Content, view, and destroy
        // hooks for projected components and directives must be called *before* their hosts.
        for (var i = tNode.directiveStart, end = tNode.directiveEnd; i < end; i++) {
            var directiveDef = tView.data[i];
            ngDevMode && assertDefined(directiveDef, 'Expecting DirectiveDef');
            var lifecycleHooks = directiveDef.type.prototype;
            var ngAfterContentInit = lifecycleHooks.ngAfterContentInit, ngAfterContentChecked = lifecycleHooks.ngAfterContentChecked, ngAfterViewInit = lifecycleHooks.ngAfterViewInit, ngAfterViewChecked = lifecycleHooks.ngAfterViewChecked, ngOnDestroy = lifecycleHooks.ngOnDestroy;
            if (ngAfterContentInit) {
                (tView.contentHooks || (tView.contentHooks = [])).push(-i, ngAfterContentInit);
            }
            if (ngAfterContentChecked) {
                (tView.contentHooks || (tView.contentHooks = [])).push(i, ngAfterContentChecked);
                (tView.contentCheckHooks || (tView.contentCheckHooks = [])).push(i, ngAfterContentChecked);
            }
            if (ngAfterViewInit) {
                (tView.viewHooks || (tView.viewHooks = [])).push(-i, ngAfterViewInit);
            }
            if (ngAfterViewChecked) {
                (tView.viewHooks || (tView.viewHooks = [])).push(i, ngAfterViewChecked);
                (tView.viewCheckHooks || (tView.viewCheckHooks = [])).push(i, ngAfterViewChecked);
            }
            if (ngOnDestroy != null) {
                (tView.destroyHooks || (tView.destroyHooks = [])).push(i, ngOnDestroy);
            }
        }
    }
    /**
     * Executing hooks requires complex logic as we need to deal with 2 constraints.
     *
     * 1. Init hooks (ngOnInit, ngAfterContentInit, ngAfterViewInit) must all be executed once and only
     * once, across many change detection cycles. This must be true even if some hooks throw, or if
     * some recursively trigger a change detection cycle.
     * To solve that, it is required to track the state of the execution of these init hooks.
     * This is done by storing and maintaining flags in the view: the {@link InitPhaseState},
     * and the index within that phase. They can be seen as a cursor in the following structure:
     * [[onInit1, onInit2], [afterContentInit1], [afterViewInit1, afterViewInit2, afterViewInit3]]
     * They are are stored as flags in LView[FLAGS].
     *
     * 2. Pre-order hooks can be executed in batches, because of the select instruction.
     * To be able to pause and resume their execution, we also need some state about the hook's array
     * that is being processed:
     * - the index of the next hook to be executed
     * - the number of init hooks already found in the processed part of the  array
     * They are are stored as flags in LView[PREORDER_HOOK_FLAGS].
     */
    /**
     * Executes pre-order check hooks ( OnChanges, DoChanges) given a view where all the init hooks were
     * executed once. This is a light version of executeInitAndCheckPreOrderHooks where we can skip read
     * / write of the init-hooks related flags.
     * @param lView The LView where hooks are defined
     * @param hooks Hooks to be run
     * @param nodeIndex 3 cases depending on the value:
     * - undefined: all hooks from the array should be executed (post-order case)
     * - null: execute hooks only from the saved index until the end of the array (pre-order case, when
     * flushing the remaining hooks)
     * - number: execute hooks only from the saved index until that node index exclusive (pre-order
     * case, when executing select(number))
     */
    function executeCheckHooks(lView, hooks, nodeIndex) {
        callHooks(lView, hooks, 3 /* InitPhaseCompleted */, nodeIndex);
    }
    /**
     * Executes post-order init and check hooks (one of AfterContentInit, AfterContentChecked,
     * AfterViewInit, AfterViewChecked) given a view where there are pending init hooks to be executed.
     * @param lView The LView where hooks are defined
     * @param hooks Hooks to be run
     * @param initPhase A phase for which hooks should be run
     * @param nodeIndex 3 cases depending on the value:
     * - undefined: all hooks from the array should be executed (post-order case)
     * - null: execute hooks only from the saved index until the end of the array (pre-order case, when
     * flushing the remaining hooks)
     * - number: execute hooks only from the saved index until that node index exclusive (pre-order
     * case, when executing select(number))
     */
    function executeInitAndCheckHooks(lView, hooks, initPhase, nodeIndex) {
        ngDevMode &&
            assertNotEqual(initPhase, 3 /* InitPhaseCompleted */, 'Init pre-order hooks should not be called more than once');
        if ((lView[FLAGS] & 3 /* InitPhaseStateMask */) === initPhase) {
            callHooks(lView, hooks, initPhase, nodeIndex);
        }
    }
    function incrementInitPhaseFlags(lView, initPhase) {
        ngDevMode &&
            assertNotEqual(initPhase, 3 /* InitPhaseCompleted */, 'Init hooks phase should not be incremented after all init hooks have been run.');
        var flags = lView[FLAGS];
        if ((flags & 3 /* InitPhaseStateMask */) === initPhase) {
            flags &= 2047 /* IndexWithinInitPhaseReset */;
            flags += 1 /* InitPhaseStateIncrementer */;
            lView[FLAGS] = flags;
        }
    }
    /**
     * Calls lifecycle hooks with their contexts, skipping init hooks if it's not
     * the first LView pass
     *
     * @param currentView The current view
     * @param arr The array in which the hooks are found
     * @param initPhaseState the current state of the init phase
     * @param currentNodeIndex 3 cases depending on the value:
     * - undefined: all hooks from the array should be executed (post-order case)
     * - null: execute hooks only from the saved index until the end of the array (pre-order case, when
     * flushing the remaining hooks)
     * - number: execute hooks only from the saved index until that node index exclusive (pre-order
     * case, when executing select(number))
     */
    function callHooks(currentView, arr, initPhase, currentNodeIndex) {
        ngDevMode &&
            assertEqual(isInCheckNoChangesMode(), false, 'Hooks should never be run when in check no changes mode.');
        var startIndex = currentNodeIndex !== undefined ?
            (currentView[PREORDER_HOOK_FLAGS] & 65535 /* IndexOfTheNextPreOrderHookMaskMask */) :
            0;
        var nodeIndexLimit = currentNodeIndex != null ? currentNodeIndex : -1;
        var max = arr.length - 1; // Stop the loop at length - 1, because we look for the hook at i + 1
        var lastNodeIndexFound = 0;
        for (var i = startIndex; i < max; i++) {
            var hook = arr[i + 1];
            if (typeof hook === 'number') {
                lastNodeIndexFound = arr[i];
                if (currentNodeIndex != null && lastNodeIndexFound >= currentNodeIndex) {
                    break;
                }
            }
            else {
                var isInitHook = arr[i] < 0;
                if (isInitHook)
                    currentView[PREORDER_HOOK_FLAGS] += 65536 /* NumberOfInitHooksCalledIncrementer */;
                if (lastNodeIndexFound < nodeIndexLimit || nodeIndexLimit == -1) {
                    callHook(currentView, initPhase, arr, i);
                    currentView[PREORDER_HOOK_FLAGS] =
                        (currentView[PREORDER_HOOK_FLAGS] & 4294901760 /* NumberOfInitHooksCalledMask */) + i +
                            2;
                }
                i++;
            }
        }
    }
    /**
     * Execute one hook against the current `LView`.
     *
     * @param currentView The current view
     * @param initPhaseState the current state of the init phase
     * @param arr The array in which the hooks are found
     * @param i The current index within the hook data array
     */
    function callHook(currentView, initPhase, arr, i) {
        var isInitHook = arr[i] < 0;
        var hook = arr[i + 1];
        var directiveIndex = isInitHook ? -arr[i] : arr[i];
        var directive = currentView[directiveIndex];
        if (isInitHook) {
            var indexWithintInitPhase = currentView[FLAGS] >> 11 /* IndexWithinInitPhaseShift */;
            // The init phase state must be always checked here as it may have been recursively updated.
            if (indexWithintInitPhase <
                (currentView[PREORDER_HOOK_FLAGS] >> 16 /* NumberOfInitHooksCalledShift */) &&
                (currentView[FLAGS] & 3 /* InitPhaseStateMask */) === initPhase) {
                currentView[FLAGS] += 2048 /* IndexWithinInitPhaseIncrementer */;
                hook.call(directive);
            }
        }
        else {
            hook.call(directive);
        }
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var NO_PARENT_INJECTOR = -1;
    /**
     * Each injector is saved in 9 contiguous slots in `LView` and 9 contiguous slots in
     * `TView.data`. This allows us to store information about the current node's tokens (which
     * can be shared in `TView`) as well as the tokens of its ancestor nodes (which cannot be
     * shared, so they live in `LView`).
     *
     * Each of these slots (aside from the last slot) contains a bloom filter. This bloom filter
     * determines whether a directive is available on the associated node or not. This prevents us
     * from searching the directives array at this level unless it's probable the directive is in it.
     *
     * See: https://en.wikipedia.org/wiki/Bloom_filter for more about bloom filters.
     *
     * Because all injectors have been flattened into `LView` and `TViewData`, they cannot typed
     * using interfaces as they were previously. The start index of each `LInjector` and `TInjector`
     * will differ based on where it is flattened into the main array, so it's not possible to know
     * the indices ahead of time and save their types here. The interfaces are still included here
     * for documentation purposes.
     *
     * export interface LInjector extends Array<any> {
     *
     *    // Cumulative bloom for directive IDs 0-31  (IDs are % BLOOM_SIZE)
     *    [0]: number;
     *
     *    // Cumulative bloom for directive IDs 32-63
     *    [1]: number;
     *
     *    // Cumulative bloom for directive IDs 64-95
     *    [2]: number;
     *
     *    // Cumulative bloom for directive IDs 96-127
     *    [3]: number;
     *
     *    // Cumulative bloom for directive IDs 128-159
     *    [4]: number;
     *
     *    // Cumulative bloom for directive IDs 160 - 191
     *    [5]: number;
     *
     *    // Cumulative bloom for directive IDs 192 - 223
     *    [6]: number;
     *
     *    // Cumulative bloom for directive IDs 224 - 255
     *    [7]: number;
     *
     *    // We need to store a reference to the injector's parent so DI can keep looking up
     *    // the injector tree until it finds the dependency it's looking for.
     *    [PARENT_INJECTOR]: number;
     * }
     *
     * export interface TInjector extends Array<any> {
     *
     *    // Shared node bloom for directive IDs 0-31  (IDs are % BLOOM_SIZE)
     *    [0]: number;
     *
     *    // Shared node bloom for directive IDs 32-63
     *    [1]: number;
     *
     *    // Shared node bloom for directive IDs 64-95
     *    [2]: number;
     *
     *    // Shared node bloom for directive IDs 96-127
     *    [3]: number;
     *
     *    // Shared node bloom for directive IDs 128-159
     *    [4]: number;
     *
     *    // Shared node bloom for directive IDs 160 - 191
     *    [5]: number;
     *
     *    // Shared node bloom for directive IDs 192 - 223
     *    [6]: number;
     *
     *    // Shared node bloom for directive IDs 224 - 255
     *    [7]: number;
     *
     *    // Necessary to find directive indices for a particular node.
     *    [TNODE]: TElementNode|TElementContainerNode|TContainerNode;
     *  }
     */
    /**
     * Factory for creating instances of injectors in the NodeInjector.
     *
     * This factory is complicated by the fact that it can resolve `multi` factories as well.
     *
     * NOTE: Some of the fields are optional which means that this class has two hidden classes.
     * - One without `multi` support (most common)
     * - One with `multi` values, (rare).
     *
     * Since VMs can cache up to 4 inline hidden classes this is OK.
     *
     * - Single factory: Only `resolving` and `factory` is defined.
     * - `providers` factory: `componentProviders` is a number and `index = -1`.
     * - `viewProviders` factory: `componentProviders` is a number and `index` points to `providers`.
     */
    var NodeInjectorFactory = /** @class */ (function () {
        function NodeInjectorFactory(
        /**
         * Factory to invoke in order to create a new instance.
         */
        factory, 
        /**
         * Set to `true` if the token is declared in `viewProviders` (or if it is component).
         */
        isViewProvider, injectImplementation) {
            this.factory = factory;
            /**
             * Marker set to true during factory invocation to see if we get into recursive loop.
             * Recursive loop causes an error to be displayed.
             */
            this.resolving = false;
            ngDevMode && assertDefined(factory, 'Factory not specified');
            ngDevMode && assertEqual(typeof factory, 'function', 'Expected factory function.');
            this.canSeeViewProviders = isViewProvider;
            this.injectImpl = injectImplementation;
        }
        return NodeInjectorFactory;
    }());
    function isFactory(obj) {
        return obj instanceof NodeInjectorFactory;
    }
    // Note: This hack is necessary so we don't erroneously get a circular dependency
    // failure based on types.
    var unusedValueExportToPlacateAjd$3 = 1;

    /**
     * Converts `TNodeType` into human readable text.
     * Make sure this matches with `TNodeType`
     */
    function toTNodeTypeAsString(tNodeType) {
        var text = '';
        (tNodeType & 1 /* Text */) && (text += '|Text');
        (tNodeType & 2 /* Element */) && (text += '|Element');
        (tNodeType & 4 /* Container */) && (text += '|Container');
        (tNodeType & 8 /* ElementContainer */) && (text += '|ElementContainer');
        (tNodeType & 16 /* Projection */) && (text += '|Projection');
        (tNodeType & 32 /* Icu */) && (text += '|IcuContainer');
        (tNodeType & 64 /* Placeholder */) && (text += '|Placeholder');
        return text.length > 0 ? text.substring(1) : text;
    }
    // Note: This hack is necessary so we don't erroneously get a circular dependency
    // failure based on types.
    var unusedValueExportToPlacateAjd$4 = 1;
    /**
     * Returns `true` if the `TNode` has a directive which has `@Input()` for `class` binding.
     *
     * ```
     * <div my-dir [class]="exp"></div>
     * ```
     * and
     * ```
     * @Directive({
     * })
     * class MyDirective {
     *   @Input()
     *   class: string;
     * }
     * ```
     *
     * In the above case it is necessary to write the reconciled styling information into the
     * directive's input.
     *
     * @param tNode
     */
    function hasClassInput(tNode) {
        return (tNode.flags & 16 /* hasClassInput */) !== 0;
    }
    /**
     * Returns `true` if the `TNode` has a directive which has `@Input()` for `style` binding.
     *
     * ```
     * <div my-dir [style]="exp"></div>
     * ```
     * and
     * ```
     * @Directive({
     * })
     * class MyDirective {
     *   @Input()
     *   class: string;
     * }
     * ```
     *
     * In the above case it is necessary to write the reconciled styling information into the
     * directive's input.
     *
     * @param tNode
     */
    function hasStyleInput(tNode) {
        return (tNode.flags & 32 /* hasStyleInput */) !== 0;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function assertTNodeType(tNode, expectedTypes, message) {
        assertDefined(tNode, 'should be called with a TNode');
        if ((tNode.type & expectedTypes) === 0) {
            throwError(message ||
                "Expected [" + toTNodeTypeAsString(expectedTypes) + "] but got " + toTNodeTypeAsString(tNode.type) + ".");
        }
    }
    function assertPureTNodeType(type) {
        if (!(type === 2 /* Element */ || //
            type === 1 /* Text */ || //
            type === 4 /* Container */ || //
            type === 8 /* ElementContainer */ || //
            type === 32 /* Icu */ || //
            type === 16 /* Projection */ || //
            type === 64 /* Placeholder */)) {
            throwError("Expected TNodeType to have only a single type selected, but got " + toTNodeTypeAsString(type) + ".");
        }
    }

    /**
     * Assigns all attribute values to the provided element via the inferred renderer.
     *
     * This function accepts two forms of attribute entries:
     *
     * default: (key, value):
     *  attrs = [key1, value1, key2, value2]
     *
     * namespaced: (NAMESPACE_MARKER, uri, name, value)
     *  attrs = [NAMESPACE_MARKER, uri, name, value, NAMESPACE_MARKER, uri, name, value]
     *
     * The `attrs` array can contain a mix of both the default and namespaced entries.
     * The "default" values are set without a marker, but if the function comes across
     * a marker value then it will attempt to set a namespaced value. If the marker is
     * not of a namespaced value then the function will quit and return the index value
     * where it stopped during the iteration of the attrs array.
     *
     * See [AttributeMarker] to understand what the namespace marker value is.
     *
     * Note that this instruction does not support assigning style and class values to
     * an element. See `elementStart` and `elementHostAttrs` to learn how styling values
     * are applied to an element.
     * @param renderer The renderer to be used
     * @param native The element that the attributes will be assigned to
     * @param attrs The attribute array of values that will be assigned to the element
     * @returns the index value that was last accessed in the attributes array
     */
    function setUpAttributes(renderer, native, attrs) {
        var isProc = isProceduralRenderer(renderer);
        var i = 0;
        while (i < attrs.length) {
            var value = attrs[i];
            if (typeof value === 'number') {
                // only namespaces are supported. Other value types (such as style/class
                // entries) are not supported in this function.
                if (value !== 0 /* NamespaceURI */) {
                    break;
                }
                // we just landed on the marker value ... therefore
                // we should skip to the next entry
                i++;
                var namespaceURI = attrs[i++];
                var attrName = attrs[i++];
                var attrVal = attrs[i++];
                ngDevMode && ngDevMode.rendererSetAttribute++;
                isProc ?
                    renderer.setAttribute(native, attrName, attrVal, namespaceURI) :
                    native.setAttributeNS(namespaceURI, attrName, attrVal);
            }
            else {
                // attrName is string;
                var attrName = value;
                var attrVal = attrs[++i];
                // Standard attributes
                ngDevMode && ngDevMode.rendererSetAttribute++;
                if (isAnimationProp(attrName)) {
                    if (isProc) {
                        renderer.setProperty(native, attrName, attrVal);
                    }
                }
                else {
                    isProc ?
                        renderer.setAttribute(native, attrName, attrVal) :
                        native.setAttribute(attrName, attrVal);
                }
                i++;
            }
        }
        // another piece of code may iterate over the same attributes array. Therefore
        // it may be helpful to return the exact spot where the attributes array exited
        // whether by running into an unsupported marker or if all the static values were
        // iterated over.
        return i;
    }
    /**
     * Test whether the given value is a marker that indicates that the following
     * attribute values in a `TAttributes` array are only the names of attributes,
     * and not name-value pairs.
     * @param marker The attribute marker to test.
     * @returns true if the marker is a "name-only" marker (e.g. `Bindings`, `Template` or `I18n`).
     */
    function isNameOnlyAttributeMarker(marker) {
        return marker === 3 /* Bindings */ || marker === 4 /* Template */ ||
            marker === 6 /* I18n */;
    }
    function isAnimationProp(name) {
        // Perf note: accessing charCodeAt to check for the first character of a string is faster as
        // compared to accessing a character at index 0 (ex. name[0]). The main reason for this is that
        // charCodeAt doesn't allocate memory to return a substring.
        return name.charCodeAt(0) === 64 /* AT_SIGN */;
    }
    /**
     * Merges `src` `TAttributes` into `dst` `TAttributes` removing any duplicates in the process.
     *
     * This merge function keeps the order of attrs same.
     *
     * @param dst Location of where the merged `TAttributes` should end up.
     * @param src `TAttributes` which should be appended to `dst`
     */
    function mergeHostAttrs(dst, src) {
        if (src === null || src.length === 0) {
            // do nothing
        }
        else if (dst === null || dst.length === 0) {
            // We have source, but dst is empty, just make a copy.
            dst = src.slice();
        }
        else {
            var srcMarker = -1 /* ImplicitAttributes */;
            for (var i = 0; i < src.length; i++) {
                var item = src[i];
                if (typeof item === 'number') {
                    srcMarker = item;
                }
                else {
                    if (srcMarker === 0 /* NamespaceURI */) {
                        // Case where we need to consume `key1`, `key2`, `value` items.
                    }
                    else if (srcMarker === -1 /* ImplicitAttributes */ ||
                        srcMarker === 2 /* Styles */) {
                        // Case where we have to consume `key1` and `value` only.
                        mergeHostAttribute(dst, srcMarker, item, null, src[++i]);
                    }
                    else {
                        // Case where we have to consume `key1` only.
                        mergeHostAttribute(dst, srcMarker, item, null, null);
                    }
                }
            }
        }
        return dst;
    }
    /**
     * Append `key`/`value` to existing `TAttributes` taking region marker and duplicates into account.
     *
     * @param dst `TAttributes` to append to.
     * @param marker Region where the `key`/`value` should be added.
     * @param key1 Key to add to `TAttributes`
     * @param key2 Key to add to `TAttributes` (in case of `AttributeMarker.NamespaceURI`)
     * @param value Value to add or to overwrite to `TAttributes` Only used if `marker` is not Class.
     */
    function mergeHostAttribute(dst, marker, key1, key2, value) {
        var i = 0;
        // Assume that new markers will be inserted at the end.
        var markerInsertPosition = dst.length;
        // scan until correct type.
        if (marker === -1 /* ImplicitAttributes */) {
            markerInsertPosition = -1;
        }
        else {
            while (i < dst.length) {
                var dstValue = dst[i++];
                if (typeof dstValue === 'number') {
                    if (dstValue === marker) {
                        markerInsertPosition = -1;
                        break;
                    }
                    else if (dstValue > marker) {
                        // We need to save this as we want the markers to be inserted in specific order.
                        markerInsertPosition = i - 1;
                        break;
                    }
                }
            }
        }
        // search until you find place of insertion
        while (i < dst.length) {
            var item = dst[i];
            if (typeof item === 'number') {
                // since `i` started as the index after the marker, we did not find it if we are at the next
                // marker
                break;
            }
            else if (item === key1) {
                // We already have same token
                if (key2 === null) {
                    if (value !== null) {
                        dst[i + 1] = value;
                    }
                    return;
                }
                else if (key2 === dst[i + 1]) {
                    dst[i + 2] = value;
                    return;
                }
            }
            // Increment counter.
            i++;
            if (key2 !== null)
                i++;
            if (value !== null)
                i++;
        }
        // insert at location.
        if (markerInsertPosition !== -1) {
            dst.splice(markerInsertPosition, 0, marker);
            i = markerInsertPosition + 1;
        }
        dst.splice(i++, 0, key1);
        if (key2 !== null) {
            dst.splice(i++, 0, key2);
        }
        if (value !== null) {
            dst.splice(i++, 0, value);
        }
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /// Parent Injector Utils ///////////////////////////////////////////////////////////////
    function hasParentInjector(parentLocation) {
        return parentLocation !== NO_PARENT_INJECTOR;
    }
    function getParentInjectorIndex(parentLocation) {
        ngDevMode && assertNumber(parentLocation, 'Number expected');
        ngDevMode && assertNotEqual(parentLocation, -1, 'Not a valid state.');
        var parentInjectorIndex = parentLocation & 32767 /* InjectorIndexMask */;
        ngDevMode &&
            assertGreaterThan(parentInjectorIndex, HEADER_OFFSET, 'Parent injector must be pointing past HEADER_OFFSET.');
        return parentLocation & 32767 /* InjectorIndexMask */;
    }
    function getParentInjectorViewOffset(parentLocation) {
        return parentLocation >> 16 /* ViewOffsetShift */;
    }
    /**
     * Unwraps a parent injector location number to find the view offset from the current injector,
     * then walks up the declaration view tree until the view is found that contains the parent
     * injector.
     *
     * @param location The location of the parent injector, which contains the view offset
     * @param startView The LView instance from which to start walking up the view tree
     * @returns The LView instance that contains the parent injector
     */
    function getParentInjectorView(location, startView) {
        var viewOffset = getParentInjectorViewOffset(location);
        var parentView = startView;
        // For most cases, the parent injector can be found on the host node (e.g. for component
        // or container), but we must keep the loop here to support the rarer case of deeply nested
        // <ng-template> tags or inline views, where the parent injector might live many views
        // above the child injector.
        while (viewOffset > 0) {
            parentView = parentView[DECLARATION_VIEW];
            viewOffset--;
        }
        return parentView;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Defines if the call to `inject` should include `viewProviders` in its resolution.
     *
     * This is set to true when we try to instantiate a component. This value is reset in
     * `getNodeInjectable` to a value which matches the declaration location of the token about to be
     * instantiated. This is done so that if we are injecting a token which was declared outside of
     * `viewProviders` we don't accidentally pull `viewProviders` in.
     *
     * Example:
     *
     * ```
     * @Injectable()
     * class MyService {
     *   constructor(public value: String) {}
     * }
     *
     * @Component({
     *   providers: [
     *     MyService,
     *     {provide: String, value: 'providers' }
     *   ]
     *   viewProviders: [
     *     {provide: String, value: 'viewProviders'}
     *   ]
     * })
     * class MyComponent {
     *   constructor(myService: MyService, value: String) {
     *     // We expect that Component can see into `viewProviders`.
     *     expect(value).toEqual('viewProviders');
     *     // `MyService` was not declared in `viewProviders` hence it can't see it.
     *     expect(myService.value).toEqual('providers');
     *   }
     * }
     *
     * ```
     */
    var includeViewProviders = true;
    function setIncludeViewProviders(v) {
        var oldValue = includeViewProviders;
        includeViewProviders = v;
        return oldValue;
    }
    /**
     * The number of slots in each bloom filter (used by DI). The larger this number, the fewer
     * directives that will share slots, and thus, the fewer false positives when checking for
     * the existence of a directive.
     */
    var BLOOM_SIZE = 256;
    var BLOOM_MASK = BLOOM_SIZE - 1;
    /**
     * The number of bits that is represented by a single bloom bucket. JS bit operations are 32 bits,
     * so each bucket represents 32 distinct tokens which accounts for log2(32) = 5 bits of a bloom hash
     * number.
     */
    var BLOOM_BUCKET_BITS = 5;
    /** Counter used to generate unique IDs for directives. */
    var nextNgElementId = 0;
    /**
     * Registers this directive as present in its node's injector by flipping the directive's
     * corresponding bit in the injector's bloom filter.
     *
     * @param injectorIndex The index of the node injector where this token should be registered
     * @param tView The TView for the injector's bloom filters
     * @param type The directive token to register
     */
    function bloomAdd(injectorIndex, tView, type) {
        ngDevMode && assertEqual(tView.firstCreatePass, true, 'expected firstCreatePass to be true');
        var id;
        if (typeof type === 'string') {
            id = type.charCodeAt(0) || 0;
        }
        else if (type.hasOwnProperty(NG_ELEMENT_ID)) {
            id = type[NG_ELEMENT_ID];
        }
        // Set a unique ID on the directive type, so if something tries to inject the directive,
        // we can easily retrieve the ID and hash it into the bloom bit that should be checked.
        if (id == null) {
            id = type[NG_ELEMENT_ID] = nextNgElementId++;
        }
        // We only have BLOOM_SIZE (256) slots in our bloom filter (8 buckets * 32 bits each),
        // so all unique IDs must be modulo-ed into a number from 0 - 255 to fit into the filter.
        var bloomHash = id & BLOOM_MASK;
        // Create a mask that targets the specific bit associated with the directive.
        // JS bit operations are 32 bits, so this will be a number between 2^0 and 2^31, corresponding
        // to bit positions 0 - 31 in a 32 bit integer.
        var mask = 1 << bloomHash;
        // Each bloom bucket in `tData` represents `BLOOM_BUCKET_BITS` number of bits of `bloomHash`.
        // Any bits in `bloomHash` beyond `BLOOM_BUCKET_BITS` indicate the bucket offset that the mask
        // should be written to.
        tView.data[injectorIndex + (bloomHash >> BLOOM_BUCKET_BITS)] |= mask;
    }
    /**
     * Creates (or gets an existing) injector for a given element or container.
     *
     * @param tNode for which an injector should be retrieved / created.
     * @param lView View where the node is stored
     * @returns Node injector
     */
    function getOrCreateNodeInjectorForNode(tNode, lView) {
        var existingInjectorIndex = getInjectorIndex(tNode, lView);
        if (existingInjectorIndex !== -1) {
            return existingInjectorIndex;
        }
        var tView = lView[TVIEW];
        if (tView.firstCreatePass) {
            tNode.injectorIndex = lView.length;
            insertBloom(tView.data, tNode); // foundation for node bloom
            insertBloom(lView, null); // foundation for cumulative bloom
            insertBloom(tView.blueprint, null);
        }
        var parentLoc = getParentInjectorLocation(tNode, lView);
        var injectorIndex = tNode.injectorIndex;
        // If a parent injector can't be found, its location is set to -1.
        // In that case, we don't need to set up a cumulative bloom
        if (hasParentInjector(parentLoc)) {
            var parentIndex = getParentInjectorIndex(parentLoc);
            var parentLView = getParentInjectorView(parentLoc, lView);
            var parentData = parentLView[TVIEW].data;
            // Creates a cumulative bloom filter that merges the parent's bloom filter
            // and its own cumulative bloom (which contains tokens for all ancestors)
            for (var i = 0; i < 8 /* BLOOM_SIZE */; i++) {
                lView[injectorIndex + i] = parentLView[parentIndex + i] | parentData[parentIndex + i];
            }
        }
        lView[injectorIndex + 8 /* PARENT */] = parentLoc;
        return injectorIndex;
    }
    function insertBloom(arr, footer) {
        arr.push(0, 0, 0, 0, 0, 0, 0, 0, footer);
    }
    function getInjectorIndex(tNode, lView) {
        if (tNode.injectorIndex === -1 ||
            // If the injector index is the same as its parent's injector index, then the index has been
            // copied down from the parent node. No injector has been created yet on this node.
            (tNode.parent && tNode.parent.injectorIndex === tNode.injectorIndex) ||
            // After the first template pass, the injector index might exist but the parent values
            // might not have been calculated yet for this instance
            lView[tNode.injectorIndex + 8 /* PARENT */] === null) {
            return -1;
        }
        else {
            ngDevMode && assertIndexInRange(lView, tNode.injectorIndex);
            return tNode.injectorIndex;
        }
    }
    /**
     * Finds the index of the parent injector, with a view offset if applicable. Used to set the
     * parent injector initially.
     *
     * @returns Returns a number that is the combination of the number of LViews that we have to go up
     * to find the LView containing the parent inject AND the index of the injector within that LView.
     */
    function getParentInjectorLocation(tNode, lView) {
        if (tNode.parent && tNode.parent.injectorIndex !== -1) {
            // If we have a parent `TNode` and there is an injector associated with it we are done, because
            // the parent injector is within the current `LView`.
            return tNode.parent.injectorIndex; // ViewOffset is 0
        }
        // When parent injector location is computed it may be outside of the current view. (ie it could
        // be pointing to a declared parent location). This variable stores number of declaration parents
        // we need to walk up in order to find the parent injector location.
        var declarationViewOffset = 0;
        var parentTNode = null;
        var lViewCursor = lView;
        // The parent injector is not in the current `LView`. We will have to walk the declared parent
        // `LView` hierarchy and look for it. If we walk of the top, that means that there is no parent
        // `NodeInjector`.
        while (lViewCursor !== null) {
            // First determine the `parentTNode` location. The parent pointer differs based on `TView.type`.
            var tView = lViewCursor[TVIEW];
            var tViewType = tView.type;
            if (tViewType === 2 /* Embedded */) {
                ngDevMode &&
                    assertDefined(tView.declTNode, 'Embedded TNodes should have declaration parents.');
                parentTNode = tView.declTNode;
            }
            else if (tViewType === 1 /* Component */) {
                // Components don't have `TView.declTNode` because each instance of component could be
                // inserted in different location, hence `TView.declTNode` is meaningless.
                parentTNode = lViewCursor[T_HOST];
            }
            else {
                ngDevMode && assertEqual(tView.type, 0 /* Root */, 'Root type expected');
                parentTNode = null;
            }
            if (parentTNode === null) {
                // If we have no parent, than we are done.
                return NO_PARENT_INJECTOR;
            }
            ngDevMode && parentTNode && assertTNodeForLView(parentTNode, lViewCursor[DECLARATION_VIEW]);
            // Every iteration of the loop requires that we go to the declared parent.
            declarationViewOffset++;
            lViewCursor = lViewCursor[DECLARATION_VIEW];
            if (parentTNode.injectorIndex !== -1) {
                // We found a NodeInjector which points to something.
                return (parentTNode.injectorIndex |
                    (declarationViewOffset << 16 /* ViewOffsetShift */));
            }
        }
        return NO_PARENT_INJECTOR;
    }
    /**
     * Makes a type or an injection token public to the DI system by adding it to an
     * injector's bloom filter.
     *
     * @param di The node injector in which a directive will be added
     * @param token The type or the injection token to be made public
     */
    function diPublicInInjector(injectorIndex, tView, token) {
        bloomAdd(injectorIndex, tView, token);
    }
    /**
     * Inject static attribute value into directive constructor.
     *
     * This method is used with `factory` functions which are generated as part of
     * `defineDirective` or `defineComponent`. The method retrieves the static value
     * of an attribute. (Dynamic attributes are not supported since they are not resolved
     *  at the time of injection and can change over time.)
     *
     * # Example
     * Given:
     * ```
     * @Component(...)
     * class MyComponent {
     *   constructor(@Attribute('title') title: string) { ... }
     * }
     * ```
     * When instantiated with
     * ```
     * <my-component title="Hello"></my-component>
     * ```
     *
     * Then factory method generated is:
     * ```
     * MyComponent.ɵcmp = defineComponent({
     *   factory: () => new MyComponent(injectAttribute('title'))
     *   ...
     * })
     * ```
     *
     * @publicApi
     */
    function injectAttributeImpl(tNode, attrNameToInject) {
        ngDevMode && assertTNodeType(tNode, 12 /* AnyContainer */ | 3 /* AnyRNode */);
        ngDevMode && assertDefined(tNode, 'expecting tNode');
        if (attrNameToInject === 'class') {
            return tNode.classes;
        }
        if (attrNameToInject === 'style') {
            return tNode.styles;
        }
        var attrs = tNode.attrs;
        if (attrs) {
            var attrsLength = attrs.length;
            var i = 0;
            while (i < attrsLength) {
                var value = attrs[i];
                // If we hit a `Bindings` or `Template` marker then we are done.
                if (isNameOnlyAttributeMarker(value))
                    break;
                // Skip namespaced attributes
                if (value === 0 /* NamespaceURI */) {
                    // we skip the next two values
                    // as namespaced attributes looks like
                    // [..., AttributeMarker.NamespaceURI, 'http://someuri.com/test', 'test:exist',
                    // 'existValue', ...]
                    i = i + 2;
                }
                else if (typeof value === 'number') {
                    // Skip to the first value of the marked attribute.
                    i++;
                    while (i < attrsLength && typeof attrs[i] === 'string') {
                        i++;
                    }
                }
                else if (value === attrNameToInject) {
                    return attrs[i + 1];
                }
                else {
                    i = i + 2;
                }
            }
        }
        return null;
    }
    function notFoundValueOrThrow(notFoundValue, token, flags) {
        if (flags & exports.InjectFlags.Optional) {
            return notFoundValue;
        }
        else {
            throwProviderNotFoundError(token, 'NodeInjector');
        }
    }
    /**
     * Returns the value associated to the given token from the ModuleInjector or throws exception
     *
     * @param lView The `LView` that contains the `tNode`
     * @param token The token to look for
     * @param flags Injection flags
     * @param notFoundValue The value to return when the injection flags is `InjectFlags.Optional`
     * @returns the value from the injector or throws an exception
     */
    function lookupTokenUsingModuleInjector(lView, token, flags, notFoundValue) {
        if (flags & exports.InjectFlags.Optional && notFoundValue === undefined) {
            // This must be set or the NullInjector will throw for optional deps
            notFoundValue = null;
        }
        if ((flags & (exports.InjectFlags.Self | exports.InjectFlags.Host)) === 0) {
            var moduleInjector = lView[INJECTOR];
            // switch to `injectInjectorOnly` implementation for module injector, since module injector
            // should not have access to Component/Directive DI scope (that may happen through
            // `directiveInject` implementation)
            var previousInjectImplementation = setInjectImplementation(undefined);
            try {
                if (moduleInjector) {
                    return moduleInjector.get(token, notFoundValue, flags & exports.InjectFlags.Optional);
                }
                else {
                    return injectRootLimpMode(token, notFoundValue, flags & exports.InjectFlags.Optional);
                }
            }
            finally {
                setInjectImplementation(previousInjectImplementation);
            }
        }
        return notFoundValueOrThrow(notFoundValue, token, flags);
    }
    /**
     * Returns the value associated to the given token from the NodeInjectors => ModuleInjector.
     *
     * Look for the injector providing the token by walking up the node injector tree and then
     * the module injector tree.
     *
     * This function patches `token` with `__NG_ELEMENT_ID__` which contains the id for the bloom
     * filter. `-1` is reserved for injecting `Injector` (implemented by `NodeInjector`)
     *
     * @param tNode The Node where the search for the injector should start
     * @param lView The `LView` that contains the `tNode`
     * @param token The token to look for
     * @param flags Injection flags
     * @param notFoundValue The value to return when the injection flags is `InjectFlags.Optional`
     * @returns the value from the injector, `null` when not found, or `notFoundValue` if provided
     */
    function getOrCreateInjectable(tNode, lView, token, flags, notFoundValue) {
        if (flags === void 0) { flags = exports.InjectFlags.Default; }
        if (tNode !== null) {
            var bloomHash = bloomHashBitOrFactory(token);
            // If the ID stored here is a function, this is a special object like ElementRef or TemplateRef
            // so just call the factory function to create it.
            if (typeof bloomHash === 'function') {
                if (!enterDI(lView, tNode, flags)) {
                    // Failed to enter DI, try module injector instead. If a token is injected with the @Host
                    // flag, the module injector is not searched for that token in Ivy.
                    return (flags & exports.InjectFlags.Host) ?
                        notFoundValueOrThrow(notFoundValue, token, flags) :
                        lookupTokenUsingModuleInjector(lView, token, flags, notFoundValue);
                }
                try {
                    var value = bloomHash();
                    if (value == null && !(flags & exports.InjectFlags.Optional)) {
                        throwProviderNotFoundError(token);
                    }
                    else {
                        return value;
                    }
                }
                finally {
                    leaveDI();
                }
            }
            else if (typeof bloomHash === 'number') {
                // A reference to the previous injector TView that was found while climbing the element
                // injector tree. This is used to know if viewProviders can be accessed on the current
                // injector.
                var previousTView = null;
                var injectorIndex = getInjectorIndex(tNode, lView);
                var parentLocation = NO_PARENT_INJECTOR;
                var hostTElementNode = flags & exports.InjectFlags.Host ? lView[DECLARATION_COMPONENT_VIEW][T_HOST] : null;
                // If we should skip this injector, or if there is no injector on this node, start by
                // searching the parent injector.
                if (injectorIndex === -1 || flags & exports.InjectFlags.SkipSelf) {
                    parentLocation = injectorIndex === -1 ? getParentInjectorLocation(tNode, lView) :
                        lView[injectorIndex + 8 /* PARENT */];
                    if (parentLocation === NO_PARENT_INJECTOR || !shouldSearchParent(flags, false)) {
                        injectorIndex = -1;
                    }
                    else {
                        previousTView = lView[TVIEW];
                        injectorIndex = getParentInjectorIndex(parentLocation);
                        lView = getParentInjectorView(parentLocation, lView);
                    }
                }
                // Traverse up the injector tree until we find a potential match or until we know there
                // *isn't* a match.
                while (injectorIndex !== -1) {
                    ngDevMode && assertNodeInjector(lView, injectorIndex);
                    // Check the current injector. If it matches, see if it contains token.
                    var tView = lView[TVIEW];
                    ngDevMode &&
                        assertTNodeForLView(tView.data[injectorIndex + 8 /* TNODE */], lView);
                    if (bloomHasToken(bloomHash, injectorIndex, tView.data)) {
                        // At this point, we have an injector which *may* contain the token, so we step through
                        // the providers and directives associated with the injector's corresponding node to get
                        // the instance.
                        var instance = searchTokensOnInjector(injectorIndex, lView, token, previousTView, flags, hostTElementNode);
                        if (instance !== NOT_FOUND) {
                            return instance;
                        }
                    }
                    parentLocation = lView[injectorIndex + 8 /* PARENT */];
                    if (parentLocation !== NO_PARENT_INJECTOR &&
                        shouldSearchParent(flags, lView[TVIEW].data[injectorIndex + 8 /* TNODE */] === hostTElementNode) &&
                        bloomHasToken(bloomHash, injectorIndex, lView)) {
                        // The def wasn't found anywhere on this node, so it was a false positive.
                        // Traverse up the tree and continue searching.
                        previousTView = tView;
                        injectorIndex = getParentInjectorIndex(parentLocation);
                        lView = getParentInjectorView(parentLocation, lView);
                    }
                    else {
                        // If we should not search parent OR If the ancestor bloom filter value does not have the
                        // bit corresponding to the directive we can give up on traversing up to find the specific
                        // injector.
                        injectorIndex = -1;
                    }
                }
            }
        }
        return lookupTokenUsingModuleInjector(lView, token, flags, notFoundValue);
    }
    var NOT_FOUND = {};
    function createNodeInjector() {
        return new NodeInjector(getCurrentTNode(), getLView());
    }
    function searchTokensOnInjector(injectorIndex, lView, token, previousTView, flags, hostTElementNode) {
        var currentTView = lView[TVIEW];
        var tNode = currentTView.data[injectorIndex + 8 /* TNODE */];
        // First, we need to determine if view providers can be accessed by the starting element.
        // There are two possibilities
        var canAccessViewProviders = previousTView == null ?
            // 1) This is the first invocation `previousTView == null` which means that we are at the
            // `TNode` of where injector is starting to look. In such a case the only time we are allowed
            // to look into the ViewProviders is if:
            // - we are on a component
            // - AND the injector set `includeViewProviders` to true (implying that the token can see
            // ViewProviders because it is the Component or a Service which itself was declared in
            // ViewProviders)
            (isComponentHost(tNode) && includeViewProviders) :
            // 2) `previousTView != null` which means that we are now walking across the parent nodes.
            // In such a case we are only allowed to look into the ViewProviders if:
            // - We just crossed from child View to Parent View `previousTView != currentTView`
            // - AND the parent TNode is an Element.
            // This means that we just came from the Component's View and therefore are allowed to see
            // into the ViewProviders.
            (previousTView != currentTView && ((tNode.type & 3 /* AnyRNode */) !== 0));
        // This special case happens when there is a @host on the inject and when we are searching
        // on the host element node.
        var isHostSpecialCase = (flags & exports.InjectFlags.Host) && hostTElementNode === tNode;
        var injectableIdx = locateDirectiveOrProvider(tNode, currentTView, token, canAccessViewProviders, isHostSpecialCase);
        if (injectableIdx !== null) {
            return getNodeInjectable(lView, currentTView, injectableIdx, tNode);
        }
        else {
            return NOT_FOUND;
        }
    }
    /**
     * Searches for the given token among the node's directives and providers.
     *
     * @param tNode TNode on which directives are present.
     * @param tView The tView we are currently processing
     * @param token Provider token or type of a directive to look for.
     * @param canAccessViewProviders Whether view providers should be considered.
     * @param isHostSpecialCase Whether the host special case applies.
     * @returns Index of a found directive or provider, or null when none found.
     */
    function locateDirectiveOrProvider(tNode, tView, token, canAccessViewProviders, isHostSpecialCase) {
        var nodeProviderIndexes = tNode.providerIndexes;
        var tInjectables = tView.data;
        var injectablesStart = nodeProviderIndexes & 1048575 /* ProvidersStartIndexMask */;
        var directivesStart = tNode.directiveStart;
        var directiveEnd = tNode.directiveEnd;
        var cptViewProvidersCount = nodeProviderIndexes >> 20 /* CptViewProvidersCountShift */;
        var startingIndex = canAccessViewProviders ? injectablesStart : injectablesStart + cptViewProvidersCount;
        // When the host special case applies, only the viewProviders and the component are visible
        var endIndex = isHostSpecialCase ? injectablesStart + cptViewProvidersCount : directiveEnd;
        for (var i = startingIndex; i < endIndex; i++) {
            var providerTokenOrDef = tInjectables[i];
            if (i < directivesStart && token === providerTokenOrDef ||
                i >= directivesStart && providerTokenOrDef.type === token) {
                return i;
            }
        }
        if (isHostSpecialCase) {
            var dirDef = tInjectables[directivesStart];
            if (dirDef && isComponentDef(dirDef) && dirDef.type === token) {
                return directivesStart;
            }
        }
        return null;
    }
    /**
     * Retrieve or instantiate the injectable from the `LView` at particular `index`.
     *
     * This function checks to see if the value has already been instantiated and if so returns the
     * cached `injectable`. Otherwise if it detects that the value is still a factory it
     * instantiates the `injectable` and caches the value.
     */
    function getNodeInjectable(lView, tView, index, tNode) {
        var value = lView[index];
        var tData = tView.data;
        if (isFactory(value)) {
            var factory = value;
            if (factory.resolving) {
                throwCyclicDependencyError(stringifyForError(tData[index]));
            }
            var previousIncludeViewProviders = setIncludeViewProviders(factory.canSeeViewProviders);
            factory.resolving = true;
            var previousInjectImplementation = factory.injectImpl ? setInjectImplementation(factory.injectImpl) : null;
            var success = enterDI(lView, tNode, exports.InjectFlags.Default);
            ngDevMode &&
                assertEqual(success, true, 'Because flags do not contain \`SkipSelf\' we expect this to always succeed.');
            try {
                value = lView[index] = factory.factory(undefined, tData, lView, tNode);
                // This code path is hit for both directives and providers.
                // For perf reasons, we want to avoid searching for hooks on providers.
                // It does no harm to try (the hooks just won't exist), but the extra
                // checks are unnecessary and this is a hot path. So we check to see
                // if the index of the dependency is in the directive range for this
                // tNode. If it's not, we know it's a provider and skip hook registration.
                if (tView.firstCreatePass && index >= tNode.directiveStart) {
                    ngDevMode && assertDirectiveDef(tData[index]);
                    registerPreOrderHooks(index, tData[index], tView);
                }
            }
            finally {
                previousInjectImplementation !== null &&
                    setInjectImplementation(previousInjectImplementation);
                setIncludeViewProviders(previousIncludeViewProviders);
                factory.resolving = false;
                leaveDI();
            }
        }
        return value;
    }
    /**
     * Returns the bit in an injector's bloom filter that should be used to determine whether or not
     * the directive might be provided by the injector.
     *
     * When a directive is public, it is added to the bloom filter and given a unique ID that can be
     * retrieved on the Type. When the directive isn't public or the token is not a directive `null`
     * is returned as the node injector can not possibly provide that token.
     *
     * @param token the injection token
     * @returns the matching bit to check in the bloom filter or `null` if the token is not known.
     *   When the returned value is negative then it represents special values such as `Injector`.
     */
    function bloomHashBitOrFactory(token) {
        ngDevMode && assertDefined(token, 'token must be defined');
        if (typeof token === 'string') {
            return token.charCodeAt(0) || 0;
        }
        var tokenId = 
        // First check with `hasOwnProperty` so we don't get an inherited ID.
        token.hasOwnProperty(NG_ELEMENT_ID) ? token[NG_ELEMENT_ID] : undefined;
        // Negative token IDs are used for special objects such as `Injector`
        if (typeof tokenId === 'number') {
            if (tokenId >= 0) {
                return tokenId & BLOOM_MASK;
            }
            else {
                ngDevMode &&
                    assertEqual(tokenId, -1 /* Injector */, 'Expecting to get Special Injector Id');
                return createNodeInjector;
            }
        }
        else {
            return tokenId;
        }
    }
    function bloomHasToken(bloomHash, injectorIndex, injectorView) {
        // Create a mask that targets the specific bit associated with the directive we're looking for.
        // JS bit operations are 32 bits, so this will be a number between 2^0 and 2^31, corresponding
        // to bit positions 0 - 31 in a 32 bit integer.
        var mask = 1 << bloomHash;
        // Each bloom bucket in `injectorView` represents `BLOOM_BUCKET_BITS` number of bits of
        // `bloomHash`. Any bits in `bloomHash` beyond `BLOOM_BUCKET_BITS` indicate the bucket offset
        // that should be used.
        var value = injectorView[injectorIndex + (bloomHash >> BLOOM_BUCKET_BITS)];
        // If the bloom filter value has the bit corresponding to the directive's bloomBit flipped on,
        // this injector is a potential match.
        return !!(value & mask);
    }
    /** Returns true if flags prevent parent injector from being searched for tokens */
    function shouldSearchParent(flags, isFirstHostTNode) {
        return !(flags & exports.InjectFlags.Self) && !(flags & exports.InjectFlags.Host && isFirstHostTNode);
    }
    var NodeInjector = /** @class */ (function () {
        function NodeInjector(_tNode, _lView) {
            this._tNode = _tNode;
            this._lView = _lView;
        }
        NodeInjector.prototype.get = function (token, notFoundValue) {
            return getOrCreateInjectable(this._tNode, this._lView, token, undefined, notFoundValue);
        };
        return NodeInjector;
    }());
    /**
     * @codeGenApi
     */
    function ɵɵgetInheritedFactory(type) {
        return noSideEffects(function () {
            var ownConstructor = type.prototype.constructor;
            var ownFactory = ownConstructor[NG_FACTORY_DEF] || getFactoryOf(ownConstructor);
            var objectPrototype = Object.prototype;
            var parent = Object.getPrototypeOf(type.prototype).constructor;
            // Go up the prototype until we hit `Object`.
            while (parent && parent !== objectPrototype) {
                var factory = parent[NG_FACTORY_DEF] || getFactoryOf(parent);
                // If we hit something that has a factory and the factory isn't the same as the type,
                // we've found the inherited factory. Note the check that the factory isn't the type's
                // own factory is redundant in most cases, but if the user has custom decorators on the
                // class, this lookup will start one level down in the prototype chain, causing us to
                // find the own factory first and potentially triggering an infinite loop downstream.
                if (factory && factory !== ownFactory) {
                    return factory;
                }
                parent = Object.getPrototypeOf(parent);
            }
            // There is no factory defined. Either this was improper usage of inheritance
            // (no Angular decorator on the superclass) or there is no constructor at all
            // in the inheritance chain. Since the two cases cannot be distinguished, the
            // latter has to be assumed.
            return function (t) { return new t(); };
        });
    }
    function getFactoryOf(type) {
        if (isForwardRef(type)) {
            return function () {
                var factory = getFactoryOf(resolveForwardRef(type));
                return factory && factory();
            };
        }
        return getFactoryDef(type);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Facade for the attribute injection from DI.
     *
     * @codeGenApi
     */
    function ɵɵinjectAttribute(attrNameToInject) {
        return injectAttributeImpl(getCurrentTNode(), attrNameToInject);
    }

    var ANNOTATIONS = '__annotations__';
    var PARAMETERS = '__parameters__';
    var PROP_METADATA = '__prop__metadata__';
    /**
     * @suppress {globalThis}
     */
    function makeDecorator(name, props, parentClass, additionalProcessing, typeFn) {
        return noSideEffects(function () {
            var metaCtor = makeMetadataCtor(props);
            function DecoratorFactory() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                if (this instanceof DecoratorFactory) {
                    metaCtor.call.apply(metaCtor, __spread([this], args));
                    return this;
                }
                var annotationInstance = new (DecoratorFactory.bind.apply(DecoratorFactory, __spread([void 0], args)))();
                return function TypeDecorator(cls) {
                    if (typeFn)
                        typeFn.apply(void 0, __spread([cls], args));
                    // Use of Object.defineProperty is important since it creates non-enumerable property which
                    // prevents the property is copied during subclassing.
                    var annotations = cls.hasOwnProperty(ANNOTATIONS) ?
                        cls[ANNOTATIONS] :
                        Object.defineProperty(cls, ANNOTATIONS, { value: [] })[ANNOTATIONS];
                    annotations.push(annotationInstance);
                    if (additionalProcessing)
                        additionalProcessing(cls);
                    return cls;
                };
            }
            if (parentClass) {
                DecoratorFactory.prototype = Object.create(parentClass.prototype);
            }
            DecoratorFactory.prototype.ngMetadataName = name;
            DecoratorFactory.annotationCls = DecoratorFactory;
            return DecoratorFactory;
        });
    }
    function makeMetadataCtor(props) {
        return function ctor() {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            if (props) {
                var values = props.apply(void 0, __spread(args));
                for (var propName in values) {
                    this[propName] = values[propName];
                }
            }
        };
    }
    function makeParamDecorator(name, props, parentClass) {
        return noSideEffects(function () {
            var metaCtor = makeMetadataCtor(props);
            function ParamDecoratorFactory() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                if (this instanceof ParamDecoratorFactory) {
                    metaCtor.apply(this, args);
                    return this;
                }
                var annotationInstance = new (ParamDecoratorFactory.bind.apply(ParamDecoratorFactory, __spread([void 0], args)))();
                ParamDecorator.annotation = annotationInstance;
                return ParamDecorator;
                function ParamDecorator(cls, unusedKey, index) {
                    // Use of Object.defineProperty is important since it creates non-enumerable property which
                    // prevents the property is copied during subclassing.
                    var parameters = cls.hasOwnProperty(PARAMETERS) ?
                        cls[PARAMETERS] :
                        Object.defineProperty(cls, PARAMETERS, { value: [] })[PARAMETERS];
                    // there might be gaps if some in between parameters do not have annotations.
                    // we pad with nulls.
                    while (parameters.length <= index) {
                        parameters.push(null);
                    }
                    (parameters[index] = parameters[index] || []).push(annotationInstance);
                    return cls;
                }
            }
            if (parentClass) {
                ParamDecoratorFactory.prototype = Object.create(parentClass.prototype);
            }
            ParamDecoratorFactory.prototype.ngMetadataName = name;
            ParamDecoratorFactory.annotationCls = ParamDecoratorFactory;
            return ParamDecoratorFactory;
        });
    }
    function makePropDecorator(name, props, parentClass, additionalProcessing) {
        return noSideEffects(function () {
            var metaCtor = makeMetadataCtor(props);
            function PropDecoratorFactory() {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                if (this instanceof PropDecoratorFactory) {
                    metaCtor.apply(this, args);
                    return this;
                }
                var decoratorInstance = new (PropDecoratorFactory.bind.apply(PropDecoratorFactory, __spread([void 0], args)))();
                function PropDecorator(target, name) {
                    var constructor = target.constructor;
                    // Use of Object.defineProperty is important because it creates a non-enumerable property
                    // which prevents the property from being copied during subclassing.
                    var meta = constructor.hasOwnProperty(PROP_METADATA) ?
                        constructor[PROP_METADATA] :
                        Object.defineProperty(constructor, PROP_METADATA, { value: {} })[PROP_METADATA];
                    meta[name] = meta.hasOwnProperty(name) && meta[name] || [];
                    meta[name].unshift(decoratorInstance);
                    if (additionalProcessing)
                        additionalProcessing.apply(void 0, __spread([target, name], args));
                }
                return PropDecorator;
            }
            if (parentClass) {
                PropDecoratorFactory.prototype = Object.create(parentClass.prototype);
            }
            PropDecoratorFactory.prototype.ngMetadataName = name;
            PropDecoratorFactory.annotationCls = PropDecoratorFactory;
            return PropDecoratorFactory;
        });
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function CREATE_ATTRIBUTE_DECORATOR__PRE_R3__() {
        return makeParamDecorator('Attribute', function (attributeName) { return ({ attributeName: attributeName }); });
    }
    function CREATE_ATTRIBUTE_DECORATOR__POST_R3__() {
        return makeParamDecorator('Attribute', function (attributeName) { return ({ attributeName: attributeName, __NG_ELEMENT_ID__: function () { return ɵɵinjectAttribute(attributeName); } }); });
    }
    var CREATE_ATTRIBUTE_DECORATOR_IMPL = CREATE_ATTRIBUTE_DECORATOR__PRE_R3__;
    /**
     * Attribute decorator and metadata.
     *
     * @Annotation
     * @publicApi
     */
    var Attribute = CREATE_ATTRIBUTE_DECORATOR_IMPL();

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Creates a token that can be used in a DI Provider.
     *
     * Use an `InjectionToken` whenever the type you are injecting is not reified (does not have a
     * runtime representation) such as when injecting an interface, callable type, array or
     * parameterized type.
     *
     * `InjectionToken` is parameterized on `T` which is the type of object which will be returned by
     * the `Injector`. This provides additional level of type safety.
     *
     * ```
     * interface MyInterface {...}
     * var myInterface = injector.get(new InjectionToken<MyInterface>('SomeToken'));
     * // myInterface is inferred to be MyInterface.
     * ```
     *
     * When creating an `InjectionToken`, you can optionally specify a factory function which returns
     * (possibly by creating) a default value of the parameterized type `T`. This sets up the
     * `InjectionToken` using this factory as a provider as if it was defined explicitly in the
     * application's root injector. If the factory function, which takes zero arguments, needs to inject
     * dependencies, it can do so using the `inject` function. See below for an example.
     *
     * Additionally, if a `factory` is specified you can also specify the `providedIn` option, which
     * overrides the above behavior and marks the token as belonging to a particular `@NgModule`. As
     * mentioned above, `'root'` is the default value for `providedIn`.
     *
     * @usageNotes
     * ### Basic Example
     *
     * ### Plain InjectionToken
     *
     * {@example core/di/ts/injector_spec.ts region='InjectionToken'}
     *
     * ### Tree-shakable InjectionToken
     *
     * {@example core/di/ts/injector_spec.ts region='ShakableInjectionToken'}
     *
     *
     * @publicApi
     */
    var InjectionToken = /** @class */ (function () {
        function InjectionToken(_desc, options) {
            this._desc = _desc;
            /** @internal */
            this.ngMetadataName = 'InjectionToken';
            this.ɵprov = undefined;
            if (typeof options == 'number') {
                (typeof ngDevMode === 'undefined' || ngDevMode) &&
                    assertLessThan(options, 0, 'Only negative numbers are supported here');
                // This is a special hack to assign __NG_ELEMENT_ID__ to this instance.
                // See `InjectorMarkers`
                this.__NG_ELEMENT_ID__ = options;
            }
            else if (options !== undefined) {
                this.ɵprov = ɵɵdefineInjectable({
                    token: this,
                    providedIn: options.providedIn || 'root',
                    factory: options.factory,
                });
            }
        }
        InjectionToken.prototype.toString = function () {
            return "InjectionToken " + this._desc;
        };
        return InjectionToken;
    }());

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * A DI token that you can use to create a virtual [provider](guide/glossary#provider)
     * that will populate the `entryComponents` field of components and NgModules
     * based on its `useValue` property value.
     * All components that are referenced in the `useValue` value (either directly
     * or in a nested array or map) are added to the `entryComponents` property.
     *
     * @usageNotes
     *
     * The following example shows how the router can populate the `entryComponents`
     * field of an NgModule based on a router configuration that refers
     * to components.
     *
     * ```typescript
     * // helper function inside the router
     * function provideRoutes(routes) {
     *   return [
     *     {provide: ROUTES, useValue: routes},
     *     {provide: ANALYZE_FOR_ENTRY_COMPONENTS, useValue: routes, multi: true}
     *   ];
     * }
     *
     * // user code
     * let routes = [
     *   {path: '/root', component: RootComp},
     *   {path: '/teams', component: TeamsComp}
     * ];
     *
     * @NgModule({
     *   providers: [provideRoutes(routes)]
     * })
     * class ModuleWithRoutes {}
     * ```
     *
     * @publicApi
     * @deprecated Since 9.0.0. With Ivy, this property is no longer necessary.
     */
    var ANALYZE_FOR_ENTRY_COMPONENTS = new InjectionToken('AnalyzeForEntryComponents');
    // Stores the default value of `emitDistinctChangesOnly` when the `emitDistinctChangesOnly` is not
    // explicitly set. This value will be changed to `true` in v12.
    // TODO(misko): switch the default in v12 to `true`. See: packages/compiler/src/core.ts
    var emitDistinctChangesOnlyDefaultValue = false;
    /**
     * Base class for query metadata.
     *
     * @see `ContentChildren`.
     * @see `ContentChild`.
     * @see `ViewChildren`.
     * @see `ViewChild`.
     *
     * @publicApi
     */
    var Query = /** @class */ (function () {
        function Query() {
        }
        return Query;
    }());
    var ɵ0$1 = function (selector, data) {
        if (data === void 0) { data = {}; }
        return (Object.assign({ selector: selector, first: false, isViewQuery: false, descendants: false, emitDistinctChangesOnly: emitDistinctChangesOnlyDefaultValue }, data));
    };
    /**
     * ContentChildren decorator and metadata.
     *
     *
     * @Annotation
     * @publicApi
     */
    var ContentChildren = makePropDecorator('ContentChildren', ɵ0$1, Query);
    var ɵ1 = function (selector, data) {
        if (data === void 0) { data = {}; }
        return (Object.assign({ selector: selector, first: true, isViewQuery: false, descendants: true }, data));
    };
    /**
     * ContentChild decorator and metadata.
     *
     *
     * @Annotation
     *
     * @publicApi
     */
    var ContentChild = makePropDecorator('ContentChild', ɵ1, Query);
    var ɵ2 = function (selector, data) {
        if (data === void 0) { data = {}; }
        return (Object.assign({ selector: selector, first: false, isViewQuery: true, descendants: true, emitDistinctChangesOnly: emitDistinctChangesOnlyDefaultValue }, data));
    };
    /**
     * ViewChildren decorator and metadata.
     *
     * @Annotation
     * @publicApi
     */
    var ViewChildren = makePropDecorator('ViewChildren', ɵ2, Query);
    var ɵ3 = function (selector, data) { return (Object.assign({ selector: selector, first: true, isViewQuery: true, descendants: true }, data)); };
    /**
     * ViewChild decorator and metadata.
     *
     * @Annotation
     * @publicApi
     */
    var ViewChild = makePropDecorator('ViewChild', ɵ3, Query);

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var R3ResolvedDependencyType;
    (function (R3ResolvedDependencyType) {
        R3ResolvedDependencyType[R3ResolvedDependencyType["Token"] = 0] = "Token";
        R3ResolvedDependencyType[R3ResolvedDependencyType["Attribute"] = 1] = "Attribute";
        R3ResolvedDependencyType[R3ResolvedDependencyType["ChangeDetectorRef"] = 2] = "ChangeDetectorRef";
        R3ResolvedDependencyType[R3ResolvedDependencyType["Invalid"] = 3] = "Invalid";
    })(R3ResolvedDependencyType || (R3ResolvedDependencyType = {}));
    var R3FactoryTarget;
    (function (R3FactoryTarget) {
        R3FactoryTarget[R3FactoryTarget["Directive"] = 0] = "Directive";
        R3FactoryTarget[R3FactoryTarget["Component"] = 1] = "Component";
        R3FactoryTarget[R3FactoryTarget["Injectable"] = 2] = "Injectable";
        R3FactoryTarget[R3FactoryTarget["Pipe"] = 3] = "Pipe";
        R3FactoryTarget[R3FactoryTarget["NgModule"] = 4] = "NgModule";
    })(R3FactoryTarget || (R3FactoryTarget = {}));
    var ViewEncapsulation;
    (function (ViewEncapsulation) {
        ViewEncapsulation[ViewEncapsulation["Emulated"] = 0] = "Emulated";
        // Historically the 1 value was for `Native` encapsulation which has been removed as of v11.
        ViewEncapsulation[ViewEncapsulation["None"] = 2] = "None";
        ViewEncapsulation[ViewEncapsulation["ShadowDom"] = 3] = "ShadowDom";
    })(ViewEncapsulation || (ViewEncapsulation = {}));

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function getCompilerFacade() {
        var globalNg = _global['ng'];
        if (!globalNg || !globalNg.ɵcompilerFacade) {
            throw new Error("Angular JIT compilation failed: '@angular/compiler' not loaded!\n" +
                "  - JIT compilation is discouraged for production use-cases! Consider AOT mode instead.\n" +
                "  - Did you bootstrap using '@angular/platform-browser-dynamic' or '@angular/platform-server'?\n" +
                "  - Alternatively provide the compiler with 'import \"@angular/compiler\";' before bootstrapping.");
        }
        return globalNg.ɵcompilerFacade;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * @description
     *
     * Represents a type that a Component or other object is instances of.
     *
     * An example of a `Type` is `MyCustomComponent` class, which in JavaScript is represented by
     * the `MyCustomComponent` constructor function.
     *
     * @publicApi
     */
    var Type = Function;
    function isType(v) {
        return typeof v === 'function';
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Equivalent to ES6 spread, add each item to an array.
     *
     * @param items The items to add
     * @param arr The array to which you want to add the items
     */
    function addAllToArray(items, arr) {
        for (var i = 0; i < items.length; i++) {
            arr.push(items[i]);
        }
    }
    /**
     * Determines if the contents of two arrays is identical
     *
     * @param a first array
     * @param b second array
     * @param identityAccessor Optional function for extracting stable object identity from a value in
     *     the array.
     */
    function arrayEquals(a, b, identityAccessor) {
        if (a.length !== b.length)
            return false;
        for (var i = 0; i < a.length; i++) {
            var valueA = a[i];
            var valueB = b[i];
            if (identityAccessor) {
                valueA = identityAccessor(valueA);
                valueB = identityAccessor(valueB);
            }
            if (valueB !== valueA) {
                return false;
            }
        }
        return true;
    }
    /**
     * Flattens an array.
     */
    function flatten(list, dst) {
        if (dst === undefined)
            dst = list;
        for (var i = 0; i < list.length; i++) {
            var item = list[i];
            if (Array.isArray(item)) {
                // we need to inline it.
                if (dst === list) {
                    // Our assumption that the list was already flat was wrong and
                    // we need to clone flat since we need to write to it.
                    dst = list.slice(0, i);
                }
                flatten(item, dst);
            }
            else if (dst !== list) {
                dst.push(item);
            }
        }
        return dst;
    }
    function deepForEach(input, fn) {
        input.forEach(function (value) { return Array.isArray(value) ? deepForEach(value, fn) : fn(value); });
    }
    function addToArray(arr, index, value) {
        // perf: array.push is faster than array.splice!
        if (index >= arr.length) {
            arr.push(value);
        }
        else {
            arr.splice(index, 0, value);
        }
    }
    function removeFromArray(arr, index) {
        // perf: array.pop is faster than array.splice!
        if (index >= arr.length - 1) {
            return arr.pop();
        }
        else {
            return arr.splice(index, 1)[0];
        }
    }
    function newArray(size, value) {
        var list = [];
        for (var i = 0; i < size; i++) {
            list.push(value);
        }
        return list;
    }
    /**
     * Remove item from array (Same as `Array.splice()` but faster.)
     *
     * `Array.splice()` is not as fast because it has to allocate an array for the elements which were
     * removed. This causes memory pressure and slows down code when most of the time we don't
     * care about the deleted items array.
     *
     * https://jsperf.com/fast-array-splice (About 20x faster)
     *
     * @param array Array to splice
     * @param index Index of element in array to remove.
     * @param count Number of items to remove.
     */
    function arraySplice(array, index, count) {
        var length = array.length - count;
        while (index < length) {
            array[index] = array[index + count];
            index++;
        }
        while (count--) {
            array.pop(); // shrink the array
        }
    }
    /**
     * Same as `Array.splice(index, 0, value)` but faster.
     *
     * `Array.splice()` is not fast because it has to allocate an array for the elements which were
     * removed. This causes memory pressure and slows down code when most of the time we don't
     * care about the deleted items array.
     *
     * @param array Array to splice.
     * @param index Index in array where the `value` should be added.
     * @param value Value to add to array.
     */
    function arrayInsert(array, index, value) {
        ngDevMode && assertLessThanOrEqual(index, array.length, 'Can\'t insert past array end.');
        var end = array.length;
        while (end > index) {
            var previousEnd = end - 1;
            array[end] = array[previousEnd];
            end = previousEnd;
        }
        array[index] = value;
    }
    /**
     * Same as `Array.splice2(index, 0, value1, value2)` but faster.
     *
     * `Array.splice()` is not fast because it has to allocate an array for the elements which were
     * removed. This causes memory pressure and slows down code when most of the time we don't
     * care about the deleted items array.
     *
     * @param array Array to splice.
     * @param index Index in array where the `value` should be added.
     * @param value1 Value to add to array.
     * @param value2 Value to add to array.
     */
    function arrayInsert2(array, index, value1, value2) {
        ngDevMode && assertLessThanOrEqual(index, array.length, 'Can\'t insert past array end.');
        var end = array.length;
        if (end == index) {
            // inserting at the end.
            array.push(value1, value2);
        }
        else if (end === 1) {
            // corner case when we have less items in array than we have items to insert.
            array.push(value2, array[0]);
            array[0] = value1;
        }
        else {
            end--;
            array.push(array[end - 1], array[end]);
            while (end > index) {
                var previousEnd = end - 2;
                array[end] = array[previousEnd];
                end--;
            }
            array[index] = value1;
            array[index + 1] = value2;
        }
    }
    /**
     * Insert a `value` into an `array` so that the array remains sorted.
     *
     * NOTE:
     * - Duplicates are not allowed, and are ignored.
     * - This uses binary search algorithm for fast inserts.
     *
     * @param array A sorted array to insert into.
     * @param value The value to insert.
     * @returns index of the inserted value.
     */
    function arrayInsertSorted(array, value) {
        var index = arrayIndexOfSorted(array, value);
        if (index < 0) {
            // if we did not find it insert it.
            index = ~index;
            arrayInsert(array, index, value);
        }
        return index;
    }
    /**
     * Remove `value` from a sorted `array`.
     *
     * NOTE:
     * - This uses binary search algorithm for fast removals.
     *
     * @param array A sorted array to remove from.
     * @param value The value to remove.
     * @returns index of the removed value.
     *   - positive index if value found and removed.
     *   - negative index if value not found. (`~index` to get the value where it should have been
     *     inserted)
     */
    function arrayRemoveSorted(array, value) {
        var index = arrayIndexOfSorted(array, value);
        if (index >= 0) {
            arraySplice(array, index, 1);
        }
        return index;
    }
    /**
     * Get an index of an `value` in a sorted `array`.
     *
     * NOTE:
     * - This uses binary search algorithm for fast removals.
     *
     * @param array A sorted array to binary search.
     * @param value The value to look for.
     * @returns index of the value.
     *   - positive index if value found.
     *   - negative index if value not found. (`~index` to get the value where it should have been
     *     located)
     */
    function arrayIndexOfSorted(array, value) {
        return _arrayIndexOfSorted(array, value, 0);
    }
    /**
     * Set a `value` for a `key`.
     *
     * @param keyValueArray to modify.
     * @param key The key to locate or create.
     * @param value The value to set for a `key`.
     * @returns index (always even) of where the value vas set.
     */
    function keyValueArraySet(keyValueArray, key, value) {
        var index = keyValueArrayIndexOf(keyValueArray, key);
        if (index >= 0) {
            // if we found it set it.
            keyValueArray[index | 1] = value;
        }
        else {
            index = ~index;
            arrayInsert2(keyValueArray, index, key, value);
        }
        return index;
    }
    /**
     * Retrieve a `value` for a `key` (on `undefined` if not found.)
     *
     * @param keyValueArray to search.
     * @param key The key to locate.
     * @return The `value` stored at the `key` location or `undefined if not found.
     */
    function keyValueArrayGet(keyValueArray, key) {
        var index = keyValueArrayIndexOf(keyValueArray, key);
        if (index >= 0) {
            // if we found it retrieve it.
            return keyValueArray[index | 1];
        }
        return undefined;
    }
    /**
     * Retrieve a `key` index value in the array or `-1` if not found.
     *
     * @param keyValueArray to search.
     * @param key The key to locate.
     * @returns index of where the key is (or should have been.)
     *   - positive (even) index if key found.
     *   - negative index if key not found. (`~index` (even) to get the index where it should have
     *     been inserted.)
     */
    function keyValueArrayIndexOf(keyValueArray, key) {
        return _arrayIndexOfSorted(keyValueArray, key, 1);
    }
    /**
     * Delete a `key` (and `value`) from the `KeyValueArray`.
     *
     * @param keyValueArray to modify.
     * @param key The key to locate or delete (if exist).
     * @returns index of where the key was (or should have been.)
     *   - positive (even) index if key found and deleted.
     *   - negative index if key not found. (`~index` (even) to get the index where it should have
     *     been.)
     */
    function keyValueArrayDelete(keyValueArray, key) {
        var index = keyValueArrayIndexOf(keyValueArray, key);
        if (index >= 0) {
            // if we found it remove it.
            arraySplice(keyValueArray, index, 2);
        }
        return index;
    }
    /**
     * INTERNAL: Get an index of an `value` in a sorted `array` by grouping search by `shift`.
     *
     * NOTE:
     * - This uses binary search algorithm for fast removals.
     *
     * @param array A sorted array to binary search.
     * @param value The value to look for.
     * @param shift grouping shift.
     *   - `0` means look at every location
     *   - `1` means only look at every other (even) location (the odd locations are to be ignored as
     *         they are values.)
     * @returns index of the value.
     *   - positive index if value found.
     *   - negative index if value not found. (`~index` to get the value where it should have been
     * inserted)
     */
    function _arrayIndexOfSorted(array, value, shift) {
        ngDevMode && assertEqual(Array.isArray(array), true, 'Expecting an array');
        var start = 0;
        var end = array.length >> shift;
        while (end !== start) {
            var middle = start + ((end - start) >> 1); // find the middle.
            var current = array[middle << shift];
            if (value === current) {
                return (middle << shift);
            }
            else if (current > value) {
                end = middle;
            }
            else {
                start = middle + 1; // We already searched middle so make it non-inclusive by adding 1
            }
        }
        return ~(end << shift);
    }

    /*
     * #########################
     * Attention: These Regular expressions have to hold even if the code is minified!
     * ##########################
     */
    /**
     * Regular expression that detects pass-through constructors for ES5 output. This Regex
     * intends to capture the common delegation pattern emitted by TypeScript and Babel. Also
     * it intends to capture the pattern where existing constructors have been downleveled from
     * ES2015 to ES5 using TypeScript w/ downlevel iteration. e.g.
     *
     * ```
     *   function MyClass() {
     *     var _this = _super.apply(this, arguments) || this;
     * ```
     *
     * ```
     *   function MyClass() {
     *     var _this = _super.apply(this, __spread(arguments)) || this;
     * ```
     *
     * More details can be found in: https://github.com/angular/angular/issues/38453.
     */
    var ES5_DELEGATE_CTOR = /^function\s+\S+\(\)\s*{[\s\S]+\.apply\(this,\s*(arguments|[^()]+\(arguments\))\)/;
    /** Regular expression that detects ES2015 classes which extend from other classes. */
    var ES2015_INHERITED_CLASS = /^class\s+[A-Za-z\d$_]*\s*extends\s+[^{]+{/;
    /**
     * Regular expression that detects ES2015 classes which extend from other classes and
     * have an explicit constructor defined.
     */
    var ES2015_INHERITED_CLASS_WITH_CTOR = /^class\s+[A-Za-z\d$_]*\s*extends\s+[^{]+{[\s\S]*constructor\s*\(/;
    /**
     * Regular expression that detects ES2015 classes which extend from other classes
     * and inherit a constructor.
     */
    var ES2015_INHERITED_CLASS_WITH_DELEGATE_CTOR = /^class\s+[A-Za-z\d$_]*\s*extends\s+[^{]+{[\s\S]*constructor\s*\(\)\s*{\s*super\(\.\.\.arguments\)/;
    /**
     * Determine whether a stringified type is a class which delegates its constructor
     * to its parent.
     *
     * This is not trivial since compiled code can actually contain a constructor function
     * even if the original source code did not. For instance, when the child class contains
     * an initialized instance property.
     */
    function isDelegateCtor(typeStr) {
        return ES5_DELEGATE_CTOR.test(typeStr) ||
            ES2015_INHERITED_CLASS_WITH_DELEGATE_CTOR.test(typeStr) ||
            (ES2015_INHERITED_CLASS.test(typeStr) && !ES2015_INHERITED_CLASS_WITH_CTOR.test(typeStr));
    }
    var ReflectionCapabilities = /** @class */ (function () {
        function ReflectionCapabilities(reflect) {
            this._reflect = reflect || _global['Reflect'];
        }
        ReflectionCapabilities.prototype.isReflectionEnabled = function () {
            return true;
        };
        ReflectionCapabilities.prototype.factory = function (t) {
            return function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                return new (t.bind.apply(t, __spread([void 0], args)))();
            };
        };
        /** @internal */
        ReflectionCapabilities.prototype._zipTypesAndAnnotations = function (paramTypes, paramAnnotations) {
            var result;
            if (typeof paramTypes === 'undefined') {
                result = newArray(paramAnnotations.length);
            }
            else {
                result = newArray(paramTypes.length);
            }
            for (var i = 0; i < result.length; i++) {
                // TS outputs Object for parameters without types, while Traceur omits
                // the annotations. For now we preserve the Traceur behavior to aid
                // migration, but this can be revisited.
                if (typeof paramTypes === 'undefined') {
                    result[i] = [];
                }
                else if (paramTypes[i] && paramTypes[i] != Object) {
                    result[i] = [paramTypes[i]];
                }
                else {
                    result[i] = [];
                }
                if (paramAnnotations && paramAnnotations[i] != null) {
                    result[i] = result[i].concat(paramAnnotations[i]);
                }
            }
            return result;
        };
        ReflectionCapabilities.prototype._ownParameters = function (type, parentCtor) {
            var typeStr = type.toString();
            // If we have no decorators, we only have function.length as metadata.
            // In that case, to detect whether a child class declared an own constructor or not,
            // we need to look inside of that constructor to check whether it is
            // just calling the parent.
            // This also helps to work around for https://github.com/Microsoft/TypeScript/issues/12439
            // that sets 'design:paramtypes' to []
            // if a class inherits from another class but has no ctor declared itself.
            if (isDelegateCtor(typeStr)) {
                return null;
            }
            // Prefer the direct API.
            if (type.parameters && type.parameters !== parentCtor.parameters) {
                return type.parameters;
            }
            // API of tsickle for lowering decorators to properties on the class.
            var tsickleCtorParams = type.ctorParameters;
            if (tsickleCtorParams && tsickleCtorParams !== parentCtor.ctorParameters) {
                // Newer tsickle uses a function closure
                // Retain the non-function case for compatibility with older tsickle
                var ctorParameters = typeof tsickleCtorParams === 'function' ? tsickleCtorParams() : tsickleCtorParams;
                var paramTypes_1 = ctorParameters.map(function (ctorParam) { return ctorParam && ctorParam.type; });
                var paramAnnotations_1 = ctorParameters.map(function (ctorParam) { return ctorParam && convertTsickleDecoratorIntoMetadata(ctorParam.decorators); });
                return this._zipTypesAndAnnotations(paramTypes_1, paramAnnotations_1);
            }
            // API for metadata created by invoking the decorators.
            var paramAnnotations = type.hasOwnProperty(PARAMETERS) && type[PARAMETERS];
            var paramTypes = this._reflect && this._reflect.getOwnMetadata &&
                this._reflect.getOwnMetadata('design:paramtypes', type);
            if (paramTypes || paramAnnotations) {
                return this._zipTypesAndAnnotations(paramTypes, paramAnnotations);
            }
            // If a class has no decorators, at least create metadata
            // based on function.length.
            // Note: We know that this is a real constructor as we checked
            // the content of the constructor above.
            return newArray(type.length);
        };
        ReflectionCapabilities.prototype.parameters = function (type) {
            // Note: only report metadata if we have at least one class decorator
            // to stay in sync with the static reflector.
            if (!isType(type)) {
                return [];
            }
            var parentCtor = getParentCtor(type);
            var parameters = this._ownParameters(type, parentCtor);
            if (!parameters && parentCtor !== Object) {
                parameters = this.parameters(parentCtor);
            }
            return parameters || [];
        };
        ReflectionCapabilities.prototype._ownAnnotations = function (typeOrFunc, parentCtor) {
            // Prefer the direct API.
            if (typeOrFunc.annotations && typeOrFunc.annotations !== parentCtor.annotations) {
                var annotations = typeOrFunc.annotations;
                if (typeof annotations === 'function' && annotations.annotations) {
                    annotations = annotations.annotations;
                }
                return annotations;
            }
            // API of tsickle for lowering decorators to properties on the class.
            if (typeOrFunc.decorators && typeOrFunc.decorators !== parentCtor.decorators) {
                return convertTsickleDecoratorIntoMetadata(typeOrFunc.decorators);
            }
            // API for metadata created by invoking the decorators.
            if (typeOrFunc.hasOwnProperty(ANNOTATIONS)) {
                return typeOrFunc[ANNOTATIONS];
            }
            return null;
        };
        ReflectionCapabilities.prototype.annotations = function (typeOrFunc) {
            if (!isType(typeOrFunc)) {
                return [];
            }
            var parentCtor = getParentCtor(typeOrFunc);
            var ownAnnotations = this._ownAnnotations(typeOrFunc, parentCtor) || [];
            var parentAnnotations = parentCtor !== Object ? this.annotations(parentCtor) : [];
            return parentAnnotations.concat(ownAnnotations);
        };
        ReflectionCapabilities.prototype._ownPropMetadata = function (typeOrFunc, parentCtor) {
            // Prefer the direct API.
            if (typeOrFunc.propMetadata &&
                typeOrFunc.propMetadata !== parentCtor.propMetadata) {
                var propMetadata = typeOrFunc.propMetadata;
                if (typeof propMetadata === 'function' && propMetadata.propMetadata) {
                    propMetadata = propMetadata.propMetadata;
                }
                return propMetadata;
            }
            // API of tsickle for lowering decorators to properties on the class.
            if (typeOrFunc.propDecorators &&
                typeOrFunc.propDecorators !== parentCtor.propDecorators) {
                var propDecorators_1 = typeOrFunc.propDecorators;
                var propMetadata_1 = {};
                Object.keys(propDecorators_1).forEach(function (prop) {
                    propMetadata_1[prop] = convertTsickleDecoratorIntoMetadata(propDecorators_1[prop]);
                });
                return propMetadata_1;
            }
            // API for metadata created by invoking the decorators.
            if (typeOrFunc.hasOwnProperty(PROP_METADATA)) {
                return typeOrFunc[PROP_METADATA];
            }
            return null;
        };
        ReflectionCapabilities.prototype.propMetadata = function (typeOrFunc) {
            if (!isType(typeOrFunc)) {
                return {};
            }
            var parentCtor = getParentCtor(typeOrFunc);
            var propMetadata = {};
            if (parentCtor !== Object) {
                var parentPropMetadata_1 = this.propMetadata(parentCtor);
                Object.keys(parentPropMetadata_1).forEach(function (propName) {
                    propMetadata[propName] = parentPropMetadata_1[propName];
                });
            }
            var ownPropMetadata = this._ownPropMetadata(typeOrFunc, parentCtor);
            if (ownPropMetadata) {
                Object.keys(ownPropMetadata).forEach(function (propName) {
                    var decorators = [];
                    if (propMetadata.hasOwnProperty(propName)) {
                        decorators.push.apply(decorators, __spread(propMetadata[propName]));
                    }
                    decorators.push.apply(decorators, __spread(ownPropMetadata[propName]));
                    propMetadata[propName] = decorators;
                });
            }
            return propMetadata;
        };
        ReflectionCapabilities.prototype.ownPropMetadata = function (typeOrFunc) {
            if (!isType(typeOrFunc)) {
                return {};
            }
            return this._ownPropMetadata(typeOrFunc, getParentCtor(typeOrFunc)) || {};
        };
        ReflectionCapabilities.prototype.hasLifecycleHook = function (type, lcProperty) {
            return type instanceof Type && lcProperty in type.prototype;
        };
        ReflectionCapabilities.prototype.guards = function (type) {
            return {};
        };
        ReflectionCapabilities.prototype.getter = function (name) {
            return new Function('o', 'return o.' + name + ';');
        };
        ReflectionCapabilities.prototype.setter = function (name) {
            return new Function('o', 'v', 'return o.' + name + ' = v;');
        };
        ReflectionCapabilities.prototype.method = function (name) {
            var functionBody = "if (!o." + name + ") throw new Error('\"" + name + "\" is undefined');\n        return o." + name + ".apply(o, args);";
            return new Function('o', 'args', functionBody);
        };
        // There is not a concept of import uri in Js, but this is useful in developing Dart applications.
        ReflectionCapabilities.prototype.importUri = function (type) {
            // StaticSymbol
            if (typeof type === 'object' && type['filePath']) {
                return type['filePath'];
            }
            // Runtime type
            return "./" + stringify(type);
        };
        ReflectionCapabilities.prototype.resourceUri = function (type) {
            return "./" + stringify(type);
        };
        ReflectionCapabilities.prototype.resolveIdentifier = function (name, moduleUrl, members, runtime) {
            return runtime;
        };
        ReflectionCapabilities.prototype.resolveEnum = function (enumIdentifier, name) {
            return enumIdentifier[name];
        };
        return ReflectionCapabilities;
    }());
    function convertTsickleDecoratorIntoMetadata(decoratorInvocations) {
        if (!decoratorInvocations) {
            return [];
        }
        return decoratorInvocations.map(function (decoratorInvocation) {
            var decoratorType = decoratorInvocation.type;
            var annotationCls = decoratorType.annotationCls;
            var annotationArgs = decoratorInvocation.args ? decoratorInvocation.args : [];
            return new (annotationCls.bind.apply(annotationCls, __spread([void 0], annotationArgs)))();
        });
    }
    function getParentCtor(ctor) {
        var parentProto = ctor.prototype ? Object.getPrototypeOf(ctor.prototype) : null;
        var parentCtor = parentProto ? parentProto.constructor : null;
        // Note: We always use `Object` as the null value
        // to simplify checking later on.
        return parentCtor || Object;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var _THROW_IF_NOT_FOUND = {};
    var THROW_IF_NOT_FOUND = _THROW_IF_NOT_FOUND;
    /*
     * Name of a property (that we patch onto DI decorator), which is used as an annotation of which
     * InjectFlag this decorator represents. This allows to avoid direct references to the DI decorators
     * in the code, thus making them tree-shakable.
     */
    var DI_DECORATOR_FLAG = '__NG_DI_FLAG__';
    var NG_TEMP_TOKEN_PATH = 'ngTempTokenPath';
    var NG_TOKEN_PATH = 'ngTokenPath';
    var NEW_LINE = /\n/gm;
    var NO_NEW_LINE = 'ɵ';
    var SOURCE = '__source';
    var ɵ0$2 = getClosureSafeProperty;
    var USE_VALUE = getClosureSafeProperty({ provide: String, useValue: ɵ0$2 });
    /**
     * Current injector value used by `inject`.
     * - `undefined`: it is an error to call `inject`
     * - `null`: `inject` can be called but there is no injector (limp-mode).
     * - Injector instance: Use the injector for resolution.
     */
    var _currentInjector = undefined;
    function setCurrentInjector(injector) {
        var former = _currentInjector;
        _currentInjector = injector;
        return former;
    }
    function injectInjectorOnly(token, flags) {
        if (flags === void 0) { flags = exports.InjectFlags.Default; }
        if (_currentInjector === undefined) {
            throw new Error("inject() must be called from an injection context");
        }
        else if (_currentInjector === null) {
            return injectRootLimpMode(token, undefined, flags);
        }
        else {
            return _currentInjector.get(token, flags & exports.InjectFlags.Optional ? null : undefined, flags);
        }
    }
    function ɵɵinject(token, flags) {
        if (flags === void 0) { flags = exports.InjectFlags.Default; }
        return (getInjectImplementation() || injectInjectorOnly)(resolveForwardRef(token), flags);
    }
    /**
     * Throws an error indicating that a factory function could not be generated by the compiler for a
     * particular class.
     *
     * This instruction allows the actual error message to be optimized away when ngDevMode is turned
     * off, saving bytes of generated code while still providing a good experience in dev mode.
     *
     * The name of the class is not mentioned here, but will be in the generated factory function name
     * and thus in the stack trace.
     *
     * @codeGenApi
     */
    function ɵɵinvalidFactoryDep(index) {
        var msg = ngDevMode ?
            "This constructor is not compatible with Angular Dependency Injection because its dependency at index " + index + " of the parameter list is invalid.\nThis can happen if the dependency type is a primitive like a string or if an ancestor of this class is missing an Angular decorator.\n\nPlease check that 1) the type for the parameter at index " + index + " is correct and 2) the correct Angular decorators are defined for this class and its ancestors." :
            'invalid';
        throw new Error(msg);
    }
    /**
     * Injects a token from the currently active injector.
     *
     * Must be used in the context of a factory function such as one defined for an
     * `InjectionToken`. Throws an error if not called from such a context.
     *
     * Within such a factory function, using this function to request injection of a dependency
     * is faster and more type-safe than providing an additional array of dependencies
     * (as has been common with `useFactory` providers).
     *
     * @param token The injection token for the dependency to be injected.
     * @param flags Optional flags that control how injection is executed.
     * The flags correspond to injection strategies that can be specified with
     * parameter decorators `@Host`, `@Self`, `@SkipSef`, and `@Optional`.
     * @returns the injected value if injection is successful, `null` otherwise.
     *
     * @usageNotes
     *
     * ### Example
     *
     * {@example core/di/ts/injector_spec.ts region='ShakableInjectionToken'}
     *
     * @publicApi
     */
    var inject = ɵɵinject;
    function injectArgs(types) {
        var args = [];
        for (var i = 0; i < types.length; i++) {
            var arg = resolveForwardRef(types[i]);
            if (Array.isArray(arg)) {
                if (arg.length === 0) {
                    throw new Error('Arguments array must have arguments.');
                }
                var type = undefined;
                var flags = exports.InjectFlags.Default;
                for (var j = 0; j < arg.length; j++) {
                    var meta = arg[j];
                    var flag = getInjectFlag(meta);
                    if (typeof flag === 'number') {
                        // Special case when we handle @Inject decorator.
                        if (flag === -1 /* Inject */) {
                            type = meta.token;
                        }
                        else {
                            flags |= flag;
                        }
                    }
                    else {
                        type = meta;
                    }
                }
                args.push(ɵɵinject(type, flags));
            }
            else {
                args.push(ɵɵinject(arg));
            }
        }
        return args;
    }
    /**
     * Attaches a given InjectFlag to a given decorator using monkey-patching.
     * Since DI decorators can be used in providers `deps` array (when provider is configured using
     * `useFactory`) without initialization (e.g. `Host`) and as an instance (e.g. `new Host()`), we
     * attach the flag to make it available both as a static property and as a field on decorator
     * instance.
     *
     * @param decorator Provided DI decorator.
     * @param flag InjectFlag that should be applied.
     */
    function attachInjectFlag(decorator, flag) {
        decorator[DI_DECORATOR_FLAG] = flag;
        decorator.prototype[DI_DECORATOR_FLAG] = flag;
        return decorator;
    }
    /**
     * Reads monkey-patched property that contains InjectFlag attached to a decorator.
     *
     * @param token Token that may contain monkey-patched DI flags property.
     */
    function getInjectFlag(token) {
        return token[DI_DECORATOR_FLAG];
    }
    function catchInjectorError(e, token, injectorErrorName, source) {
        var tokenPath = e[NG_TEMP_TOKEN_PATH];
        if (token[SOURCE]) {
            tokenPath.unshift(token[SOURCE]);
        }
        e.message = formatError('\n' + e.message, tokenPath, injectorErrorName, source);
        e[NG_TOKEN_PATH] = tokenPath;
        e[NG_TEMP_TOKEN_PATH] = null;
        throw e;
    }
    function formatError(text, obj, injectorErrorName, source) {
        if (source === void 0) { source = null; }
        text = text && text.charAt(0) === '\n' && text.charAt(1) == NO_NEW_LINE ? text.substr(2) : text;
        var context = stringify(obj);
        if (Array.isArray(obj)) {
            context = obj.map(stringify).join(' -> ');
        }
        else if (typeof obj === 'object') {
            var parts = [];
            for (var key in obj) {
                if (obj.hasOwnProperty(key)) {
                    var value = obj[key];
                    parts.push(key + ':' + (typeof value === 'string' ? JSON.stringify(value) : stringify(value)));
                }
            }
            context = "{" + parts.join(', ') + "}";
        }
        return "" + injectorErrorName + (source ? '(' + source + ')' : '') + "[" + context + "]: " + text.replace(NEW_LINE, '\n  ');
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var ɵ0$3 = function (token) { return ({ token: token }); };
    /**
     * Inject decorator and metadata.
     *
     * @Annotation
     * @publicApi
     */
    var Inject = attachInjectFlag(
    // Disable tslint because `DecoratorFlags` is a const enum which gets inlined.
    // tslint:disable-next-line: no-toplevel-property-access
    makeParamDecorator('Inject', ɵ0$3), -1 /* Inject */);
    /**
     * Optional decorator and metadata.
     *
     * @Annotation
     * @publicApi
     */
    var Optional = 
    // Disable tslint because `InternalInjectFlags` is a const enum which gets inlined.
    // tslint:disable-next-line: no-toplevel-property-access
    attachInjectFlag(makeParamDecorator('Optional'), 8 /* Optional */);
    /**
     * Self decorator and metadata.
     *
     * @Annotation
     * @publicApi
     */
    var Self = 
    // Disable tslint because `InternalInjectFlags` is a const enum which gets inlined.
    // tslint:disable-next-line: no-toplevel-property-access
    attachInjectFlag(makeParamDecorator('Self'), 2 /* Self */);
    /**
     * `SkipSelf` decorator and metadata.
     *
     * @Annotation
     * @publicApi
     */
    var SkipSelf = 
    // Disable tslint because `InternalInjectFlags` is a const enum which gets inlined.
    // tslint:disable-next-line: no-toplevel-property-access
    attachInjectFlag(makeParamDecorator('SkipSelf'), 4 /* SkipSelf */);
    /**
     * Host decorator and metadata.
     *
     * @Annotation
     * @publicApi
     */
    var Host = 
    // Disable tslint because `InternalInjectFlags` is a const enum which gets inlined.
    // tslint:disable-next-line: no-toplevel-property-access
    attachInjectFlag(makeParamDecorator('Host'), 1 /* Host */);

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var _reflect = null;
    function getReflect() {
        return (_reflect = _reflect || new ReflectionCapabilities());
    }
    function reflectDependencies(type) {
        return convertDependencies(getReflect().parameters(type));
    }
    function convertDependencies(deps) {
        var compiler = getCompilerFacade();
        return deps.map(function (dep) { return reflectDependency(compiler, dep); });
    }
    function reflectDependency(compiler, dep) {
        var meta = {
            token: null,
            host: false,
            optional: false,
            resolved: compiler.R3ResolvedDependencyType.Token,
            self: false,
            skipSelf: false,
        };
        function setTokenAndResolvedType(token) {
            meta.resolved = compiler.R3ResolvedDependencyType.Token;
            meta.token = token;
        }
        if (Array.isArray(dep) && dep.length > 0) {
            for (var j = 0; j < dep.length; j++) {
                var param = dep[j];
                if (param === undefined) {
                    // param may be undefined if type of dep is not set by ngtsc
                    continue;
                }
                var proto = Object.getPrototypeOf(param);
                if (param instanceof Optional || proto.ngMetadataName === 'Optional') {
                    meta.optional = true;
                }
                else if (param instanceof SkipSelf || proto.ngMetadataName === 'SkipSelf') {
                    meta.skipSelf = true;
                }
                else if (param instanceof Self || proto.ngMetadataName === 'Self') {
                    meta.self = true;
                }
                else if (param instanceof Host || proto.ngMetadataName === 'Host') {
                    meta.host = true;
                }
                else if (param instanceof Inject) {
                    meta.token = param.token;
                }
                else if (param instanceof Attribute) {
                    if (param.attributeName === undefined) {
                        throw new Error("Attribute name must be defined.");
                    }
                    meta.token = param.attributeName;
                    meta.resolved = compiler.R3ResolvedDependencyType.Attribute;
                }
                else if (param.__ChangeDetectorRef__ === true) {
                    meta.token = param;
                    meta.resolved = compiler.R3ResolvedDependencyType.ChangeDetectorRef;
                }
                else {
                    setTokenAndResolvedType(param);
                }
            }
        }
        else if (dep === undefined || (Array.isArray(dep) && dep.length === 0)) {
            meta.token = undefined;
            meta.resolved = R3ResolvedDependencyType.Invalid;
        }
        else {
            setTokenAndResolvedType(dep);
        }
        return meta;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Used to resolve resource URLs on `@Component` when used with JIT compilation.
     *
     * Example:
     * ```
     * @Component({
     *   selector: 'my-comp',
     *   templateUrl: 'my-comp.html', // This requires asynchronous resolution
     * })
     * class MyComponent{
     * }
     *
     * // Calling `renderComponent` will fail because `renderComponent` is a synchronous process
     * // and `MyComponent`'s `@Component.templateUrl` needs to be resolved asynchronously.
     *
     * // Calling `resolveComponentResources()` will resolve `@Component.templateUrl` into
     * // `@Component.template`, which allows `renderComponent` to proceed in a synchronous manner.
     *
     * // Use browser's `fetch()` function as the default resource resolution strategy.
     * resolveComponentResources(fetch).then(() => {
     *   // After resolution all URLs have been converted into `template` strings.
     *   renderComponent(MyComponent);
     * });
     *
     * ```
     *
     * NOTE: In AOT the resolution happens during compilation, and so there should be no need
     * to call this method outside JIT mode.
     *
     * @param resourceResolver a function which is responsible for returning a `Promise` to the
     * contents of the resolved URL. Browser's `fetch()` method is a good default implementation.
     */
    function resolveComponentResources(resourceResolver) {
        // Store all promises which are fetching the resources.
        var componentResolved = [];
        // Cache so that we don't fetch the same resource more than once.
        var urlMap = new Map();
        function cachedResourceResolve(url) {
            var promise = urlMap.get(url);
            if (!promise) {
                var resp = resourceResolver(url);
                urlMap.set(url, promise = resp.then(unwrapResponse));
            }
            return promise;
        }
        componentResourceResolutionQueue.forEach(function (component, type) {
            var promises = [];
            if (component.templateUrl) {
                promises.push(cachedResourceResolve(component.templateUrl).then(function (template) {
                    component.template = template;
                }));
            }
            var styleUrls = component.styleUrls;
            var styles = component.styles || (component.styles = []);
            var styleOffset = component.styles.length;
            styleUrls && styleUrls.forEach(function (styleUrl, index) {
                styles.push(''); // pre-allocate array.
                promises.push(cachedResourceResolve(styleUrl).then(function (style) {
                    styles[styleOffset + index] = style;
                    styleUrls.splice(styleUrls.indexOf(styleUrl), 1);
                    if (styleUrls.length == 0) {
                        component.styleUrls = undefined;
                    }
                }));
            });
            var fullyResolved = Promise.all(promises).then(function () { return componentDefResolved(type); });
            componentResolved.push(fullyResolved);
        });
        clearResolutionOfComponentResourcesQueue();
        return Promise.all(componentResolved).then(function () { return undefined; });
    }
    var componentResourceResolutionQueue = new Map();
    // Track when existing ɵcmp for a Type is waiting on resources.
    var componentDefPendingResolution = new Set();
    function maybeQueueResolutionOfComponentResources(type, metadata) {
        if (componentNeedsResolution(metadata)) {
            componentResourceResolutionQueue.set(type, metadata);
            componentDefPendingResolution.add(type);
        }
    }
    function isComponentDefPendingResolution(type) {
        return componentDefPendingResolution.has(type);
    }
    function componentNeedsResolution(component) {
        return !!((component.templateUrl && !component.hasOwnProperty('template')) ||
            component.styleUrls && component.styleUrls.length);
    }
    function clearResolutionOfComponentResourcesQueue() {
        var old = componentResourceResolutionQueue;
        componentResourceResolutionQueue = new Map();
        return old;
    }
    function restoreComponentResolutionQueue(queue) {
        componentDefPendingResolution.clear();
        queue.forEach(function (_, type) { return componentDefPendingResolution.add(type); });
        componentResourceResolutionQueue = queue;
    }
    function isComponentResourceResolutionQueueEmpty() {
        return componentResourceResolutionQueue.size === 0;
    }
    function unwrapResponse(response) {
        return typeof response == 'string' ? response : response.text();
    }
    function componentDefResolved(type) {
        componentDefPendingResolution.delete(type);
    }

    /**
     * The Trusted Types policy, or null if Trusted Types are not
     * enabled/supported, or undefined if the policy has not been created yet.
     */
    var policy;
    /**
     * Returns the Trusted Types policy, or null if Trusted Types are not
     * enabled/supported. The first call to this function will create the policy.
     */
    function getPolicy() {
        if (policy === undefined) {
            policy = null;
            if (_global.trustedTypes) {
                try {
                    policy = _global.trustedTypes.createPolicy('angular', {
                        createHTML: function (s) { return s; },
                        createScript: function (s) { return s; },
                        createScriptURL: function (s) { return s; },
                    });
                }
                catch (_a) {
                    // trustedTypes.createPolicy throws if called with a name that is
                    // already registered, even in report-only mode. Until the API changes,
                    // catch the error not to break the applications functionally. In such
                    // cases, the code will fall back to using strings.
                }
            }
        }
        return policy;
    }
    /**
     * Unsafely promote a string to a TrustedHTML, falling back to strings when
     * Trusted Types are not available.
     * @security This is a security-sensitive function; any use of this function
     * must go through security review. In particular, it must be assured that the
     * provided string will never cause an XSS vulnerability if used in a context
     * that will be interpreted as HTML by a browser, e.g. when assigning to
     * element.innerHTML.
     */
    function trustedHTMLFromString(html) {
        var _a;
        return ((_a = getPolicy()) === null || _a === void 0 ? void 0 : _a.createHTML(html)) || html;
    }
    /**
     * Unsafely promote a string to a TrustedScript, falling back to strings when
     * Trusted Types are not available.
     * @security In particular, it must be assured that the provided string will
     * never cause an XSS vulnerability if used in a context that will be
     * interpreted and executed as a script by a browser, e.g. when calling eval.
     */
    function trustedScriptFromString(script) {
        var _a;
        return ((_a = getPolicy()) === null || _a === void 0 ? void 0 : _a.createScript(script)) || script;
    }
    /**
     * Unsafely promote a string to a TrustedScriptURL, falling back to strings
     * when Trusted Types are not available.
     * @security This is a security-sensitive function; any use of this function
     * must go through security review. In particular, it must be assured that the
     * provided string will never cause an XSS vulnerability if used in a context
     * that will cause a browser to load and execute a resource, e.g. when
     * assigning to script.src.
     */
    function trustedScriptURLFromString(url) {
        var _a;
        return ((_a = getPolicy()) === null || _a === void 0 ? void 0 : _a.createScriptURL(url)) || url;
    }
    /**
     * Unsafely call the Function constructor with the given string arguments. It
     * is only available in development mode, and should be stripped out of
     * production code.
     * @security This is a security-sensitive function; any use of this function
     * must go through security review. In particular, it must be assured that it
     * is only called from development code, as use in production code can lead to
     * XSS vulnerabilities.
     */
    function newTrustedFunctionForDev() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        if (typeof ngDevMode === 'undefined') {
            throw new Error('newTrustedFunctionForDev should never be called in production');
        }
        if (!_global.trustedTypes) {
            // In environments that don't support Trusted Types, fall back to the most
            // straightforward implementation:
            return new (Function.bind.apply(Function, __spread([void 0], args)))();
        }
        // Chrome currently does not support passing TrustedScript to the Function
        // constructor. The following implements the workaround proposed on the page
        // below, where the Chromium bug is also referenced:
        // https://github.com/w3c/webappsec-trusted-types/wiki/Trusted-Types-for-function-constructor
        var fnArgs = args.slice(0, -1).join(',');
        var fnBody = args[args.length - 1];
        var body = "(function anonymous(" + fnArgs + "\n) { " + fnBody + "\n})";
        // Using eval directly confuses the compiler and prevents this module from
        // being stripped out of JS binaries even if not used. The global['eval']
        // indirection fixes that.
        var fn = _global['eval'](trustedScriptFromString(body));
        if (fn.bind === undefined) {
            // Workaround for a browser bug that only exists in Chrome 83, where passing
            // a TrustedScript to eval just returns the TrustedScript back without
            // evaluating it. In that case, fall back to the most straightforward
            // implementation:
            return new (Function.bind.apply(Function, __spread([void 0], args)))();
        }
        // To completely mimic the behavior of calling "new Function", two more
        // things need to happen:
        // 1. Stringifying the resulting function should return its source code
        fn.toString = function () { return body; };
        // 2. When calling the resulting function, `this` should refer to `global`
        return fn.bind(_global);
        // When Trusted Types support in Function constructors is widely available,
        // the implementation of this function can be simplified to:
        // return new Function(...args.map(a => trustedScriptFromString(a)));
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * The Trusted Types policy, or null if Trusted Types are not
     * enabled/supported, or undefined if the policy has not been created yet.
     */
    var policy$1;
    /**
     * Returns the Trusted Types policy, or null if Trusted Types are not
     * enabled/supported. The first call to this function will create the policy.
     */
    function getPolicy$1() {
        if (policy$1 === undefined) {
            policy$1 = null;
            if (_global.trustedTypes) {
                try {
                    policy$1 = _global.trustedTypes
                        .createPolicy('angular#unsafe-bypass', {
                        createHTML: function (s) { return s; },
                        createScript: function (s) { return s; },
                        createScriptURL: function (s) { return s; },
                    });
                }
                catch (_a) {
                    // trustedTypes.createPolicy throws if called with a name that is
                    // already registered, even in report-only mode. Until the API changes,
                    // catch the error not to break the applications functionally. In such
                    // cases, the code will fall back to using strings.
                }
            }
        }
        return policy$1;
    }
    /**
     * Unsafely promote a string to a TrustedHTML, falling back to strings when
     * Trusted Types are not available.
     * @security This is a security-sensitive function; any use of this function
     * must go through security review. In particular, it must be assured that it
     * is only passed strings that come directly from custom sanitizers or the
     * bypassSecurityTrust* functions.
     */
    function trustedHTMLFromStringBypass(html) {
        var _a;
        return ((_a = getPolicy$1()) === null || _a === void 0 ? void 0 : _a.createHTML(html)) || html;
    }
    /**
     * Unsafely promote a string to a TrustedScript, falling back to strings when
     * Trusted Types are not available.
     * @security This is a security-sensitive function; any use of this function
     * must go through security review. In particular, it must be assured that it
     * is only passed strings that come directly from custom sanitizers or the
     * bypassSecurityTrust* functions.
     */
    function trustedScriptFromStringBypass(script) {
        var _a;
        return ((_a = getPolicy$1()) === null || _a === void 0 ? void 0 : _a.createScript(script)) || script;
    }
    /**
     * Unsafely promote a string to a TrustedScriptURL, falling back to strings
     * when Trusted Types are not available.
     * @security This is a security-sensitive function; any use of this function
     * must go through security review. In particular, it must be assured that it
     * is only passed strings that come directly from custom sanitizers or the
     * bypassSecurityTrust* functions.
     */
    function trustedScriptURLFromStringBypass(url) {
        var _a;
        return ((_a = getPolicy$1()) === null || _a === void 0 ? void 0 : _a.createScriptURL(url)) || url;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var SafeValueImpl = /** @class */ (function () {
        function SafeValueImpl(changingThisBreaksApplicationSecurity) {
            this.changingThisBreaksApplicationSecurity = changingThisBreaksApplicationSecurity;
        }
        SafeValueImpl.prototype.toString = function () {
            return "SafeValue must use [property]=binding: " + this.changingThisBreaksApplicationSecurity +
                " (see https://g.co/ng/security#xss)";
        };
        return SafeValueImpl;
    }());
    var SafeHtmlImpl = /** @class */ (function (_super) {
        __extends(SafeHtmlImpl, _super);
        function SafeHtmlImpl() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SafeHtmlImpl.prototype.getTypeName = function () {
            return "HTML" /* Html */;
        };
        return SafeHtmlImpl;
    }(SafeValueImpl));
    var SafeStyleImpl = /** @class */ (function (_super) {
        __extends(SafeStyleImpl, _super);
        function SafeStyleImpl() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SafeStyleImpl.prototype.getTypeName = function () {
            return "Style" /* Style */;
        };
        return SafeStyleImpl;
    }(SafeValueImpl));
    var SafeScriptImpl = /** @class */ (function (_super) {
        __extends(SafeScriptImpl, _super);
        function SafeScriptImpl() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SafeScriptImpl.prototype.getTypeName = function () {
            return "Script" /* Script */;
        };
        return SafeScriptImpl;
    }(SafeValueImpl));
    var SafeUrlImpl = /** @class */ (function (_super) {
        __extends(SafeUrlImpl, _super);
        function SafeUrlImpl() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SafeUrlImpl.prototype.getTypeName = function () {
            return "URL" /* Url */;
        };
        return SafeUrlImpl;
    }(SafeValueImpl));
    var SafeResourceUrlImpl = /** @class */ (function (_super) {
        __extends(SafeResourceUrlImpl, _super);
        function SafeResourceUrlImpl() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SafeResourceUrlImpl.prototype.getTypeName = function () {
            return "ResourceURL" /* ResourceUrl */;
        };
        return SafeResourceUrlImpl;
    }(SafeValueImpl));
    function unwrapSafeValue(value) {
        return value instanceof SafeValueImpl ? value.changingThisBreaksApplicationSecurity :
            value;
    }
    function allowSanitizationBypassAndThrow(value, type) {
        var actualType = getSanitizationBypassType(value);
        if (actualType != null && actualType !== type) {
            // Allow ResourceURLs in URL contexts, they are strictly more trusted.
            if (actualType === "ResourceURL" /* ResourceUrl */ && type === "URL" /* Url */)
                return true;
            throw new Error("Required a safe " + type + ", got a " + actualType + " (see https://g.co/ng/security#xss)");
        }
        return actualType === type;
    }
    function getSanitizationBypassType(value) {
        return value instanceof SafeValueImpl && value.getTypeName() || null;
    }
    /**
     * Mark `html` string as trusted.
     *
     * This function wraps the trusted string in `String` and brands it in a way which makes it
     * recognizable to {@link htmlSanitizer} to be trusted implicitly.
     *
     * @param trustedHtml `html` string which needs to be implicitly trusted.
     * @returns a `html` which has been branded to be implicitly trusted.
     */
    function bypassSanitizationTrustHtml(trustedHtml) {
        return new SafeHtmlImpl(trustedHtml);
    }
    /**
     * Mark `style` string as trusted.
     *
     * This function wraps the trusted string in `String` and brands it in a way which makes it
     * recognizable to {@link styleSanitizer} to be trusted implicitly.
     *
     * @param trustedStyle `style` string which needs to be implicitly trusted.
     * @returns a `style` hich has been branded to be implicitly trusted.
     */
    function bypassSanitizationTrustStyle(trustedStyle) {
        return new SafeStyleImpl(trustedStyle);
    }
    /**
     * Mark `script` string as trusted.
     *
     * This function wraps the trusted string in `String` and brands it in a way which makes it
     * recognizable to {@link scriptSanitizer} to be trusted implicitly.
     *
     * @param trustedScript `script` string which needs to be implicitly trusted.
     * @returns a `script` which has been branded to be implicitly trusted.
     */
    function bypassSanitizationTrustScript(trustedScript) {
        return new SafeScriptImpl(trustedScript);
    }
    /**
     * Mark `url` string as trusted.
     *
     * This function wraps the trusted string in `String` and brands it in a way which makes it
     * recognizable to {@link urlSanitizer} to be trusted implicitly.
     *
     * @param trustedUrl `url` string which needs to be implicitly trusted.
     * @returns a `url`  which has been branded to be implicitly trusted.
     */
    function bypassSanitizationTrustUrl(trustedUrl) {
        return new SafeUrlImpl(trustedUrl);
    }
    /**
     * Mark `url` string as trusted.
     *
     * This function wraps the trusted string in `String` and brands it in a way which makes it
     * recognizable to {@link resourceUrlSanitizer} to be trusted implicitly.
     *
     * @param trustedResourceUrl `url` string which needs to be implicitly trusted.
     * @returns a `url` which has been branded to be implicitly trusted.
     */
    function bypassSanitizationTrustResourceUrl(trustedResourceUrl) {
        return new SafeResourceUrlImpl(trustedResourceUrl);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * This helper is used to get hold of an inert tree of DOM elements containing dirty HTML
     * that needs sanitizing.
     * Depending upon browser support we use one of two strategies for doing this.
     * Default: DOMParser strategy
     * Fallback: InertDocument strategy
     */
    function getInertBodyHelper(defaultDoc) {
        var inertDocumentHelper = new InertDocumentHelper(defaultDoc);
        return isDOMParserAvailable() ? new DOMParserHelper(inertDocumentHelper) : inertDocumentHelper;
    }
    /**
     * Uses DOMParser to create and fill an inert body element.
     * This is the default strategy used in browsers that support it.
     */
    var DOMParserHelper = /** @class */ (function () {
        function DOMParserHelper(inertDocumentHelper) {
            this.inertDocumentHelper = inertDocumentHelper;
        }
        DOMParserHelper.prototype.getInertBodyElement = function (html) {
            // We add these extra elements to ensure that the rest of the content is parsed as expected
            // e.g. leading whitespace is maintained and tags like `<meta>` do not get hoisted to the
            // `<head>` tag. Note that the `<body>` tag is closed implicitly to prevent unclosed tags
            // in `html` from consuming the otherwise explicit `</body>` tag.
            html = '<body><remove></remove>' + html;
            try {
                var body = new window.DOMParser()
                    .parseFromString(trustedHTMLFromString(html), 'text/html')
                    .body;
                if (body === null) {
                    // In some browsers (e.g. Mozilla/5.0 iPad AppleWebKit Mobile) the `body` property only
                    // becomes available in the following tick of the JS engine. In that case we fall back to
                    // the `inertDocumentHelper` instead.
                    return this.inertDocumentHelper.getInertBodyElement(html);
                }
                body.removeChild(body.firstChild);
                return body;
            }
            catch (_a) {
                return null;
            }
        };
        return DOMParserHelper;
    }());
    /**
     * Use an HTML5 `template` element, if supported, or an inert body element created via
     * `createHtmlDocument` to create and fill an inert DOM element.
     * This is the fallback strategy if the browser does not support DOMParser.
     */
    var InertDocumentHelper = /** @class */ (function () {
        function InertDocumentHelper(defaultDoc) {
            this.defaultDoc = defaultDoc;
            this.inertDocument = this.defaultDoc.implementation.createHTMLDocument('sanitization-inert');
            if (this.inertDocument.body == null) {
                // usually there should be only one body element in the document, but IE doesn't have any, so
                // we need to create one.
                var inertHtml = this.inertDocument.createElement('html');
                this.inertDocument.appendChild(inertHtml);
                var inertBodyElement = this.inertDocument.createElement('body');
                inertHtml.appendChild(inertBodyElement);
            }
        }
        InertDocumentHelper.prototype.getInertBodyElement = function (html) {
            // Prefer using <template> element if supported.
            var templateEl = this.inertDocument.createElement('template');
            if ('content' in templateEl) {
                templateEl.innerHTML = trustedHTMLFromString(html);
                return templateEl;
            }
            // Note that previously we used to do something like `this.inertDocument.body.innerHTML = html`
            // and we returned the inert `body` node. This was changed, because IE seems to treat setting
            // `innerHTML` on an inserted element differently, compared to one that hasn't been inserted
            // yet. In particular, IE appears to split some of the text into multiple text nodes rather
            // than keeping them in a single one which ends up messing with Ivy's i18n parsing further
            // down the line. This has been worked around by creating a new inert `body` and using it as
            // the root node in which we insert the HTML.
            var inertBody = this.inertDocument.createElement('body');
            inertBody.innerHTML = trustedHTMLFromString(html);
            // Support: IE 11 only
            // strip custom-namespaced attributes on IE<=11
            if (this.defaultDoc.documentMode) {
                this.stripCustomNsAttrs(inertBody);
            }
            return inertBody;
        };
        /**
         * When IE11 comes across an unknown namespaced attribute e.g. 'xlink:foo' it adds 'xmlns:ns1'
         * attribute to declare ns1 namespace and prefixes the attribute with 'ns1' (e.g.
         * 'ns1:xlink:foo').
         *
         * This is undesirable since we don't want to allow any of these custom attributes. This method
         * strips them all.
         */
        InertDocumentHelper.prototype.stripCustomNsAttrs = function (el) {
            var elAttrs = el.attributes;
            // loop backwards so that we can support removals.
            for (var i = elAttrs.length - 1; 0 < i; i--) {
                var attrib = elAttrs.item(i);
                var attrName = attrib.name;
                if (attrName === 'xmlns:ns1' || attrName.indexOf('ns1:') === 0) {
                    el.removeAttribute(attrName);
                }
            }
            var childNode = el.firstChild;
            while (childNode) {
                if (childNode.nodeType === Node.ELEMENT_NODE)
                    this.stripCustomNsAttrs(childNode);
                childNode = childNode.nextSibling;
            }
        };
        return InertDocumentHelper;
    }());
    /**
     * We need to determine whether the DOMParser exists in the global context and
     * supports parsing HTML; HTML parsing support is not as wide as other formats, see
     * https://developer.mozilla.org/en-US/docs/Web/API/DOMParser#Browser_compatibility.
     *
     * @suppress {uselessCode}
     */
    function isDOMParserAvailable() {
        try {
            return !!new window.DOMParser().parseFromString(trustedHTMLFromString(''), 'text/html');
        }
        catch (_a) {
            return false;
        }
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * A pattern that recognizes a commonly useful subset of URLs that are safe.
     *
     * This regular expression matches a subset of URLs that will not cause script
     * execution if used in URL context within a HTML document. Specifically, this
     * regular expression matches if (comment from here on and regex copied from
     * Soy's EscapingConventions):
     * (1) Either an allowed protocol (http, https, mailto or ftp).
     * (2) or no protocol.  A protocol must be followed by a colon. The below
     *     allows that by allowing colons only after one of the characters [/?#].
     *     A colon after a hash (#) must be in the fragment.
     *     Otherwise, a colon after a (?) must be in a query.
     *     Otherwise, a colon after a single solidus (/) must be in a path.
     *     Otherwise, a colon after a double solidus (//) must be in the authority
     *     (before port).
     *
     * The pattern disallows &, used in HTML entity declarations before
     * one of the characters in [/?#]. This disallows HTML entities used in the
     * protocol name, which should never happen, e.g. "h&#116;tp" for "http".
     * It also disallows HTML entities in the first path part of a relative path,
     * e.g. "foo&lt;bar/baz".  Our existing escaping functions should not produce
     * that. More importantly, it disallows masking of a colon,
     * e.g. "javascript&#58;...".
     *
     * This regular expression was taken from the Closure sanitization library.
     */
    var SAFE_URL_PATTERN = /^(?:(?:https?|mailto|ftp|tel|file|sms):|[^&:/?#]*(?:[/?#]|$))/gi;
    /* A pattern that matches safe srcset values */
    var SAFE_SRCSET_PATTERN = /^(?:(?:https?|file):|[^&:/?#]*(?:[/?#]|$))/gi;
    /** A pattern that matches safe data URLs. Only matches image, video and audio types. */
    var DATA_URL_PATTERN = /^data:(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm)|audio\/(?:mp3|oga|ogg|opus));base64,[a-z0-9+\/]+=*$/i;
    function _sanitizeUrl(url) {
        url = String(url);
        if (url.match(SAFE_URL_PATTERN) || url.match(DATA_URL_PATTERN))
            return url;
        if (typeof ngDevMode === 'undefined' || ngDevMode) {
            console.warn("WARNING: sanitizing unsafe URL value " + url + " (see https://g.co/ng/security#xss)");
        }
        return 'unsafe:' + url;
    }
    function sanitizeSrcset(srcset) {
        srcset = String(srcset);
        return srcset.split(',').map(function (srcset) { return _sanitizeUrl(srcset.trim()); }).join(', ');
    }

    function tagSet(tags) {
        var e_1, _a;
        var res = {};
        try {
            for (var _b = __values(tags.split(',')), _c = _b.next(); !_c.done; _c = _b.next()) {
                var t = _c.value;
                res[t] = true;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return res;
    }
    function merge() {
        var e_2, _a;
        var sets = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            sets[_i] = arguments[_i];
        }
        var res = {};
        try {
            for (var sets_1 = __values(sets), sets_1_1 = sets_1.next(); !sets_1_1.done; sets_1_1 = sets_1.next()) {
                var s = sets_1_1.value;
                for (var v in s) {
                    if (s.hasOwnProperty(v))
                        res[v] = true;
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (sets_1_1 && !sets_1_1.done && (_a = sets_1.return)) _a.call(sets_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return res;
    }
    // Good source of info about elements and attributes
    // https://html.spec.whatwg.org/#semantics
    // https://simon.html5.org/html-elements
    // Safe Void Elements - HTML5
    // https://html.spec.whatwg.org/#void-elements
    var VOID_ELEMENTS = tagSet('area,br,col,hr,img,wbr');
    // Elements that you can, intentionally, leave open (and which close themselves)
    // https://html.spec.whatwg.org/#optional-tags
    var OPTIONAL_END_TAG_BLOCK_ELEMENTS = tagSet('colgroup,dd,dt,li,p,tbody,td,tfoot,th,thead,tr');
    var OPTIONAL_END_TAG_INLINE_ELEMENTS = tagSet('rp,rt');
    var OPTIONAL_END_TAG_ELEMENTS = merge(OPTIONAL_END_TAG_INLINE_ELEMENTS, OPTIONAL_END_TAG_BLOCK_ELEMENTS);
    // Safe Block Elements - HTML5
    var BLOCK_ELEMENTS = merge(OPTIONAL_END_TAG_BLOCK_ELEMENTS, tagSet('address,article,' +
        'aside,blockquote,caption,center,del,details,dialog,dir,div,dl,figure,figcaption,footer,h1,h2,h3,h4,h5,' +
        'h6,header,hgroup,hr,ins,main,map,menu,nav,ol,pre,section,summary,table,ul'));
    // Inline Elements - HTML5
    var INLINE_ELEMENTS = merge(OPTIONAL_END_TAG_INLINE_ELEMENTS, tagSet('a,abbr,acronym,audio,b,' +
        'bdi,bdo,big,br,cite,code,del,dfn,em,font,i,img,ins,kbd,label,map,mark,picture,q,ruby,rp,rt,s,' +
        'samp,small,source,span,strike,strong,sub,sup,time,track,tt,u,var,video'));
    var VALID_ELEMENTS = merge(VOID_ELEMENTS, BLOCK_ELEMENTS, INLINE_ELEMENTS, OPTIONAL_END_TAG_ELEMENTS);
    // Attributes that have href and hence need to be sanitized
    var URI_ATTRS = tagSet('background,cite,href,itemtype,longdesc,poster,src,xlink:href');
    // Attributes that have special href set hence need to be sanitized
    var SRCSET_ATTRS = tagSet('srcset');
    var HTML_ATTRS = tagSet('abbr,accesskey,align,alt,autoplay,axis,bgcolor,border,cellpadding,cellspacing,class,clear,color,cols,colspan,' +
        'compact,controls,coords,datetime,default,dir,download,face,headers,height,hidden,hreflang,hspace,' +
        'ismap,itemscope,itemprop,kind,label,lang,language,loop,media,muted,nohref,nowrap,open,preload,rel,rev,role,rows,rowspan,rules,' +
        'scope,scrolling,shape,size,sizes,span,srclang,start,summary,tabindex,target,title,translate,type,usemap,' +
        'valign,value,vspace,width');
    // Accessibility attributes as per WAI-ARIA 1.1 (W3C Working Draft 14 December 2018)
    var ARIA_ATTRS = tagSet('aria-activedescendant,aria-atomic,aria-autocomplete,aria-busy,aria-checked,aria-colcount,aria-colindex,' +
        'aria-colspan,aria-controls,aria-current,aria-describedby,aria-details,aria-disabled,aria-dropeffect,' +
        'aria-errormessage,aria-expanded,aria-flowto,aria-grabbed,aria-haspopup,aria-hidden,aria-invalid,' +
        'aria-keyshortcuts,aria-label,aria-labelledby,aria-level,aria-live,aria-modal,aria-multiline,' +
        'aria-multiselectable,aria-orientation,aria-owns,aria-placeholder,aria-posinset,aria-pressed,aria-readonly,' +
        'aria-relevant,aria-required,aria-roledescription,aria-rowcount,aria-rowindex,aria-rowspan,aria-selected,' +
        'aria-setsize,aria-sort,aria-valuemax,aria-valuemin,aria-valuenow,aria-valuetext');
    // NB: This currently consciously doesn't support SVG. SVG sanitization has had several security
    // issues in the past, so it seems safer to leave it out if possible. If support for binding SVG via
    // innerHTML is required, SVG attributes should be added here.
    // NB: Sanitization does not allow <form> elements or other active elements (<button> etc). Those
    // can be sanitized, but they increase security surface area without a legitimate use case, so they
    // are left out here.
    var VALID_ATTRS = merge(URI_ATTRS, SRCSET_ATTRS, HTML_ATTRS, ARIA_ATTRS);
    // Elements whose content should not be traversed/preserved, if the elements themselves are invalid.
    //
    // Typically, `<invalid>Some content</invalid>` would traverse (and in this case preserve)
    // `Some content`, but strip `invalid-element` opening/closing tags. For some elements, though, we
    // don't want to preserve the content, if the elements themselves are going to be removed.
    var SKIP_TRAVERSING_CONTENT_IF_INVALID_ELEMENTS = tagSet('script,style,template');
    /**
     * SanitizingHtmlSerializer serializes a DOM fragment, stripping out any unsafe elements and unsafe
     * attributes.
     */
    var SanitizingHtmlSerializer = /** @class */ (function () {
        function SanitizingHtmlSerializer() {
            // Explicitly track if something was stripped, to avoid accidentally warning of sanitization just
            // because characters were re-encoded.
            this.sanitizedSomething = false;
            this.buf = [];
        }
        SanitizingHtmlSerializer.prototype.sanitizeChildren = function (el) {
            // This cannot use a TreeWalker, as it has to run on Angular's various DOM adapters.
            // However this code never accesses properties off of `document` before deleting its contents
            // again, so it shouldn't be vulnerable to DOM clobbering.
            var current = el.firstChild;
            var traverseContent = true;
            while (current) {
                if (current.nodeType === Node.ELEMENT_NODE) {
                    traverseContent = this.startElement(current);
                }
                else if (current.nodeType === Node.TEXT_NODE) {
                    this.chars(current.nodeValue);
                }
                else {
                    // Strip non-element, non-text nodes.
                    this.sanitizedSomething = true;
                }
                if (traverseContent && current.firstChild) {
                    current = current.firstChild;
                    continue;
                }
                while (current) {
                    // Leaving the element. Walk up and to the right, closing tags as we go.
                    if (current.nodeType === Node.ELEMENT_NODE) {
                        this.endElement(current);
                    }
                    var next = this.checkClobberedElement(current, current.nextSibling);
                    if (next) {
                        current = next;
                        break;
                    }
                    current = this.checkClobberedElement(current, current.parentNode);
                }
            }
            return this.buf.join('');
        };
        /**
         * Sanitizes an opening element tag (if valid) and returns whether the element's contents should
         * be traversed. Element content must always be traversed (even if the element itself is not
         * valid/safe), unless the element is one of `SKIP_TRAVERSING_CONTENT_IF_INVALID_ELEMENTS`.
         *
         * @param element The element to sanitize.
         * @return True if the element's contents should be traversed.
         */
        SanitizingHtmlSerializer.prototype.startElement = function (element) {
            var tagName = element.nodeName.toLowerCase();
            if (!VALID_ELEMENTS.hasOwnProperty(tagName)) {
                this.sanitizedSomething = true;
                return !SKIP_TRAVERSING_CONTENT_IF_INVALID_ELEMENTS.hasOwnProperty(tagName);
            }
            this.buf.push('<');
            this.buf.push(tagName);
            var elAttrs = element.attributes;
            for (var i = 0; i < elAttrs.length; i++) {
                var elAttr = elAttrs.item(i);
                var attrName = elAttr.name;
                var lower = attrName.toLowerCase();
                if (!VALID_ATTRS.hasOwnProperty(lower)) {
                    this.sanitizedSomething = true;
                    continue;
                }
                var value = elAttr.value;
                // TODO(martinprobst): Special case image URIs for data:image/...
                if (URI_ATTRS[lower])
                    value = _sanitizeUrl(value);
                if (SRCSET_ATTRS[lower])
                    value = sanitizeSrcset(value);
                this.buf.push(' ', attrName, '="', encodeEntities(value), '"');
            }
            this.buf.push('>');
            return true;
        };
        SanitizingHtmlSerializer.prototype.endElement = function (current) {
            var tagName = current.nodeName.toLowerCase();
            if (VALID_ELEMENTS.hasOwnProperty(tagName) && !VOID_ELEMENTS.hasOwnProperty(tagName)) {
                this.buf.push('</');
                this.buf.push(tagName);
                this.buf.push('>');
            }
        };
        SanitizingHtmlSerializer.prototype.chars = function (chars) {
            this.buf.push(encodeEntities(chars));
        };
        SanitizingHtmlSerializer.prototype.checkClobberedElement = function (node, nextNode) {
            if (nextNode &&
                (node.compareDocumentPosition(nextNode) &
                    Node.DOCUMENT_POSITION_CONTAINED_BY) === Node.DOCUMENT_POSITION_CONTAINED_BY) {
                throw new Error("Failed to sanitize html because the element is clobbered: " + node.outerHTML);
            }
            return nextNode;
        };
        return SanitizingHtmlSerializer;
    }());
    // Regular Expressions for parsing tags and attributes
    var SURROGATE_PAIR_REGEXP = /[\uD800-\uDBFF][\uDC00-\uDFFF]/g;
    // ! to ~ is the ASCII range.
    var NON_ALPHANUMERIC_REGEXP = /([^\#-~ |!])/g;
    /**
     * Escapes all potentially dangerous characters, so that the
     * resulting string can be safely inserted into attribute or
     * element text.
     * @param value
     */
    function encodeEntities(value) {
        return value.replace(/&/g, '&amp;')
            .replace(SURROGATE_PAIR_REGEXP, function (match) {
            var hi = match.charCodeAt(0);
            var low = match.charCodeAt(1);
            return '&#' + (((hi - 0xD800) * 0x400) + (low - 0xDC00) + 0x10000) + ';';
        })
            .replace(NON_ALPHANUMERIC_REGEXP, function (match) {
            return '&#' + match.charCodeAt(0) + ';';
        })
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;');
    }
    var inertBodyHelper;
    /**
     * Sanitizes the given unsafe, untrusted HTML fragment, and returns HTML text that is safe to add to
     * the DOM in a browser environment.
     */
    function _sanitizeHtml(defaultDoc, unsafeHtmlInput) {
        var inertBodyElement = null;
        try {
            inertBodyHelper = inertBodyHelper || getInertBodyHelper(defaultDoc);
            // Make sure unsafeHtml is actually a string (TypeScript types are not enforced at runtime).
            var unsafeHtml = unsafeHtmlInput ? String(unsafeHtmlInput) : '';
            inertBodyElement = inertBodyHelper.getInertBodyElement(unsafeHtml);
            // mXSS protection. Repeatedly parse the document to make sure it stabilizes, so that a browser
            // trying to auto-correct incorrect HTML cannot cause formerly inert HTML to become dangerous.
            var mXSSAttempts = 5;
            var parsedHtml = unsafeHtml;
            do {
                if (mXSSAttempts === 0) {
                    throw new Error('Failed to sanitize html because the input is unstable');
                }
                mXSSAttempts--;
                unsafeHtml = parsedHtml;
                parsedHtml = inertBodyElement.innerHTML;
                inertBodyElement = inertBodyHelper.getInertBodyElement(unsafeHtml);
            } while (unsafeHtml !== parsedHtml);
            var sanitizer = new SanitizingHtmlSerializer();
            var safeHtml = sanitizer.sanitizeChildren(getTemplateContent(inertBodyElement) || inertBodyElement);
            if ((typeof ngDevMode === 'undefined' || ngDevMode) && sanitizer.sanitizedSomething) {
                console.warn('WARNING: sanitizing HTML stripped some content, see https://g.co/ng/security#xss');
            }
            return trustedHTMLFromString(safeHtml);
        }
        finally {
            // In case anything goes wrong, clear out inertElement to reset the entire DOM structure.
            if (inertBodyElement) {
                var parent = getTemplateContent(inertBodyElement) || inertBodyElement;
                while (parent.firstChild) {
                    parent.removeChild(parent.firstChild);
                }
            }
        }
    }
    function getTemplateContent(el) {
        return 'content' in el /** Microsoft/TypeScript#21517 */ && isTemplateElement(el) ?
            el.content :
            null;
    }
    function isTemplateElement(el) {
        return el.nodeType === Node.ELEMENT_NODE && el.nodeName === 'TEMPLATE';
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    (function (SecurityContext) {
        SecurityContext[SecurityContext["NONE"] = 0] = "NONE";
        SecurityContext[SecurityContext["HTML"] = 1] = "HTML";
        SecurityContext[SecurityContext["STYLE"] = 2] = "STYLE";
        SecurityContext[SecurityContext["SCRIPT"] = 3] = "SCRIPT";
        SecurityContext[SecurityContext["URL"] = 4] = "URL";
        SecurityContext[SecurityContext["RESOURCE_URL"] = 5] = "RESOURCE_URL";
    })(exports.SecurityContext || (exports.SecurityContext = {}));

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * An `html` sanitizer which converts untrusted `html` **string** into trusted string by removing
     * dangerous content.
     *
     * This method parses the `html` and locates potentially dangerous content (such as urls and
     * javascript) and removes it.
     *
     * It is possible to mark a string as trusted by calling {@link bypassSanitizationTrustHtml}.
     *
     * @param unsafeHtml untrusted `html`, typically from the user.
     * @returns `html` string which is safe to display to user, because all of the dangerous javascript
     * and urls have been removed.
     *
     * @codeGenApi
     */
    function ɵɵsanitizeHtml(unsafeHtml) {
        var sanitizer = getSanitizer();
        if (sanitizer) {
            return trustedHTMLFromStringBypass(sanitizer.sanitize(exports.SecurityContext.HTML, unsafeHtml) || '');
        }
        if (allowSanitizationBypassAndThrow(unsafeHtml, "HTML" /* Html */)) {
            return trustedHTMLFromStringBypass(unwrapSafeValue(unsafeHtml));
        }
        return _sanitizeHtml(getDocument(), renderStringify(unsafeHtml));
    }
    /**
     * A `style` sanitizer which converts untrusted `style` **string** into trusted string by removing
     * dangerous content.
     *
     * It is possible to mark a string as trusted by calling {@link bypassSanitizationTrustStyle}.
     *
     * @param unsafeStyle untrusted `style`, typically from the user.
     * @returns `style` string which is safe to bind to the `style` properties.
     *
     * @codeGenApi
     */
    function ɵɵsanitizeStyle(unsafeStyle) {
        var sanitizer = getSanitizer();
        if (sanitizer) {
            return sanitizer.sanitize(exports.SecurityContext.STYLE, unsafeStyle) || '';
        }
        if (allowSanitizationBypassAndThrow(unsafeStyle, "Style" /* Style */)) {
            return unwrapSafeValue(unsafeStyle);
        }
        return renderStringify(unsafeStyle);
    }
    /**
     * A `url` sanitizer which converts untrusted `url` **string** into trusted string by removing
     * dangerous
     * content.
     *
     * This method parses the `url` and locates potentially dangerous content (such as javascript) and
     * removes it.
     *
     * It is possible to mark a string as trusted by calling {@link bypassSanitizationTrustUrl}.
     *
     * @param unsafeUrl untrusted `url`, typically from the user.
     * @returns `url` string which is safe to bind to the `src` properties such as `<img src>`, because
     * all of the dangerous javascript has been removed.
     *
     * @codeGenApi
     */
    function ɵɵsanitizeUrl(unsafeUrl) {
        var sanitizer = getSanitizer();
        if (sanitizer) {
            return sanitizer.sanitize(exports.SecurityContext.URL, unsafeUrl) || '';
        }
        if (allowSanitizationBypassAndThrow(unsafeUrl, "URL" /* Url */)) {
            return unwrapSafeValue(unsafeUrl);
        }
        return _sanitizeUrl(renderStringify(unsafeUrl));
    }
    /**
     * A `url` sanitizer which only lets trusted `url`s through.
     *
     * This passes only `url`s marked trusted by calling {@link bypassSanitizationTrustResourceUrl}.
     *
     * @param unsafeResourceUrl untrusted `url`, typically from the user.
     * @returns `url` string which is safe to bind to the `src` properties such as `<img src>`, because
     * only trusted `url`s have been allowed to pass.
     *
     * @codeGenApi
     */
    function ɵɵsanitizeResourceUrl(unsafeResourceUrl) {
        var sanitizer = getSanitizer();
        if (sanitizer) {
            return trustedScriptURLFromStringBypass(sanitizer.sanitize(exports.SecurityContext.RESOURCE_URL, unsafeResourceUrl) || '');
        }
        if (allowSanitizationBypassAndThrow(unsafeResourceUrl, "ResourceURL" /* ResourceUrl */)) {
            return trustedScriptURLFromStringBypass(unwrapSafeValue(unsafeResourceUrl));
        }
        throw new Error('unsafe value used in a resource URL context (see https://g.co/ng/security#xss)');
    }
    /**
     * A `script` sanitizer which only lets trusted javascript through.
     *
     * This passes only `script`s marked trusted by calling {@link
     * bypassSanitizationTrustScript}.
     *
     * @param unsafeScript untrusted `script`, typically from the user.
     * @returns `url` string which is safe to bind to the `<script>` element such as `<img src>`,
     * because only trusted `scripts` have been allowed to pass.
     *
     * @codeGenApi
     */
    function ɵɵsanitizeScript(unsafeScript) {
        var sanitizer = getSanitizer();
        if (sanitizer) {
            return trustedScriptFromStringBypass(sanitizer.sanitize(exports.SecurityContext.SCRIPT, unsafeScript) || '');
        }
        if (allowSanitizationBypassAndThrow(unsafeScript, "Script" /* Script */)) {
            return trustedScriptFromStringBypass(unwrapSafeValue(unsafeScript));
        }
        throw new Error('unsafe value used in a script context');
    }
    /**
     * A template tag function for promoting the associated constant literal to a
     * TrustedHTML. Interpolation is explicitly not allowed.
     *
     * @param html constant template literal containing trusted HTML.
     * @returns TrustedHTML wrapping `html`.
     *
     * @security This is a security-sensitive function and should only be used to
     * convert constant values of attributes and properties found in
     * application-provided Angular templates to TrustedHTML.
     *
     * @codeGenApi
     */
    function ɵɵtrustConstantHtml(html) {
        // The following runtime check ensures that the function was called as a
        // template tag (e.g. ɵɵtrustConstantHtml`content`), without any interpolation
        // (e.g. not ɵɵtrustConstantHtml`content ${variable}`). A TemplateStringsArray
        // is an array with a `raw` property that is also an array. The associated
        // template literal has no interpolation if and only if the length of the
        // TemplateStringsArray is 1.
        if (ngDevMode && (!Array.isArray(html) || !Array.isArray(html.raw) || html.length !== 1)) {
            throw new Error("Unexpected interpolation in trusted HTML constant: " + html.join('?'));
        }
        return trustedHTMLFromString(html[0]);
    }
    /**
     * A template tag function for promoting the associated constant literal to a
     * TrustedScriptURL. Interpolation is explicitly not allowed.
     *
     * @param url constant template literal containing a trusted script URL.
     * @returns TrustedScriptURL wrapping `url`.
     *
     * @security This is a security-sensitive function and should only be used to
     * convert constant values of attributes and properties found in
     * application-provided Angular templates to TrustedScriptURL.
     *
     * @codeGenApi
     */
    function ɵɵtrustConstantResourceUrl(url) {
        // The following runtime check ensures that the function was called as a
        // template tag (e.g. ɵɵtrustConstantResourceUrl`content`), without any
        // interpolation (e.g. not ɵɵtrustConstantResourceUrl`content ${variable}`). A
        // TemplateStringsArray is an array with a `raw` property that is also an
        // array. The associated template literal has no interpolation if and only if
        // the length of the TemplateStringsArray is 1.
        if (ngDevMode && (!Array.isArray(url) || !Array.isArray(url.raw) || url.length !== 1)) {
            throw new Error("Unexpected interpolation in trusted URL constant: " + url.join('?'));
        }
        return trustedScriptURLFromString(url[0]);
    }
    /**
     * Detects which sanitizer to use for URL property, based on tag name and prop name.
     *
     * The rules are based on the RESOURCE_URL context config from
     * `packages/compiler/src/schema/dom_security_schema.ts`.
     * If tag and prop names don't match Resource URL schema, use URL sanitizer.
     */
    function getUrlSanitizer(tag, prop) {
        if ((prop === 'src' &&
            (tag === 'embed' || tag === 'frame' || tag === 'iframe' || tag === 'media' ||
                tag === 'script')) ||
            (prop === 'href' && (tag === 'base' || tag === 'link'))) {
            return ɵɵsanitizeResourceUrl;
        }
        return ɵɵsanitizeUrl;
    }
    /**
     * Sanitizes URL, selecting sanitizer function based on tag and property names.
     *
     * This function is used in case we can't define security context at compile time, when only prop
     * name is available. This happens when we generate host bindings for Directives/Components. The
     * host element is unknown at compile time, so we defer calculation of specific sanitizer to
     * runtime.
     *
     * @param unsafeUrl untrusted `url`, typically from the user.
     * @param tag target element tag name.
     * @param prop name of the property that contains the value.
     * @returns `url` string which is safe to bind.
     *
     * @codeGenApi
     */
    function ɵɵsanitizeUrlOrResourceUrl(unsafeUrl, tag, prop) {
        return getUrlSanitizer(tag, prop)(unsafeUrl);
    }
    function validateAgainstEventProperties(name) {
        if (name.toLowerCase().startsWith('on')) {
            var msg = "Binding to event property '" + name + "' is disallowed for security reasons, " +
                ("please use (" + name.slice(2) + ")=...") +
                ("\nIf '" + name + "' is a directive input, make sure the directive is imported by the") +
                " current module.";
            throw new Error(msg);
        }
    }
    function validateAgainstEventAttributes(name) {
        if (name.toLowerCase().startsWith('on')) {
            var msg = "Binding to event attribute '" + name + "' is disallowed for security reasons, " +
                ("please use (" + name.slice(2) + ")=...");
            throw new Error(msg);
        }
    }
    function getSanitizer() {
        var lView = getLView();
        return lView && lView[SANITIZER];
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var ERROR_TYPE = 'ngType';
    var ERROR_DEBUG_CONTEXT = 'ngDebugContext';
    var ERROR_ORIGINAL_ERROR = 'ngOriginalError';
    var ERROR_LOGGER = 'ngErrorLogger';
    function wrappedError(message, originalError) {
        var msg = message + " caused by: " + (originalError instanceof Error ? originalError.message : originalError);
        var error = Error(msg);
        error[ERROR_ORIGINAL_ERROR] = originalError;
        return error;
    }

    function getType(error) {
        return error[ERROR_TYPE];
    }
    function getDebugContext(error) {
        return error[ERROR_DEBUG_CONTEXT];
    }
    function getOriginalError(error) {
        return error[ERROR_ORIGINAL_ERROR];
    }
    function getErrorLogger(error) {
        return error[ERROR_LOGGER] || defaultErrorLogger;
    }
    function defaultErrorLogger(console) {
        var values = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            values[_i - 1] = arguments[_i];
        }
        console.error.apply(console, __spread(values));
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Provides a hook for centralized exception handling.
     *
     * The default implementation of `ErrorHandler` prints error messages to the `console`. To
     * intercept error handling, write a custom exception handler that replaces this default as
     * appropriate for your app.
     *
     * @usageNotes
     * ### Example
     *
     * ```
     * class MyErrorHandler implements ErrorHandler {
     *   handleError(error) {
     *     // do something with the exception
     *   }
     * }
     *
     * @NgModule({
     *   providers: [{provide: ErrorHandler, useClass: MyErrorHandler}]
     * })
     * class MyModule {}
     * ```
     *
     * @publicApi
     */
    var ErrorHandler = /** @class */ (function () {
        function ErrorHandler() {
            /**
             * @internal
             */
            this._console = console;
        }
        ErrorHandler.prototype.handleError = function (error) {
            var originalError = this._findOriginalError(error);
            var context = this._findContext(error);
            // Note: Browser consoles show the place from where console.error was called.
            // We can use this to give users additional information about the error.
            var errorLogger = getErrorLogger(error);
            errorLogger(this._console, "ERROR", error);
            if (originalError) {
                errorLogger(this._console, "ORIGINAL ERROR", originalError);
            }
            if (context) {
                errorLogger(this._console, 'ERROR CONTEXT', context);
            }
        };
        /** @internal */
        ErrorHandler.prototype._findContext = function (error) {
            if (error) {
                return getDebugContext(error) ? getDebugContext(error) :
                    this._findContext(getOriginalError(error));
            }
            return null;
        };
        /** @internal */
        ErrorHandler.prototype._findOriginalError = function (error) {
            var e = getOriginalError(error);
            while (e && getOriginalError(e)) {
                e = getOriginalError(e);
            }
            return e;
        };
        return ErrorHandler;
    }());

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Defines a schema that allows an NgModule to contain the following:
     * - Non-Angular elements named with dash case (`-`).
     * - Element properties named with dash case (`-`).
     * Dash case is the naming convention for custom elements.
     *
     * @publicApi
     */
    var CUSTOM_ELEMENTS_SCHEMA = {
        name: 'custom-elements'
    };
    /**
     * Defines a schema that allows any property on any element.
     *
     * @publicApi
     */
    var NO_ERRORS_SCHEMA = {
        name: 'no-errors-schema'
    };

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Disallowed strings in the comment.
     *
     * see: https://html.spec.whatwg.org/multipage/syntax.html#comments
     */
    var COMMENT_DISALLOWED = /^>|^->|<!--|-->|--!>|<!-$/g;
    /**
     * Delimiter in the disallowed strings which needs to be wrapped with zero with character.
     */
    var COMMENT_DELIMITER = /(<|>)/;
    var COMMENT_DELIMITER_ESCAPED = '\u200B$1\u200B';
    /**
     * Escape the content of comment strings so that it can be safely inserted into a comment node.
     *
     * The issue is that HTML does not specify any way to escape comment end text inside the comment.
     * Consider: `<!-- The way you close a comment is with ">", and "->" at the beginning or by "-->" or
     * "--!>" at the end. -->`. Above the `"-->"` is meant to be text not an end to the comment. This
     * can be created programmatically through DOM APIs. (`<!--` are also disallowed.)
     *
     * see: https://html.spec.whatwg.org/multipage/syntax.html#comments
     *
     * ```
     * div.innerHTML = div.innerHTML
     * ```
     *
     * One would expect that the above code would be safe to do, but it turns out that because comment
     * text is not escaped, the comment may contain text which will prematurely close the comment
     * opening up the application for XSS attack. (In SSR we programmatically create comment nodes which
     * may contain such text and expect them to be safe.)
     *
     * This function escapes the comment text by looking for comment delimiters (`<` and `>`) and
     * surrounding them with `_>_` where the `_` is a zero width space `\u200B`. The result is that if a
     * comment contains any of the comment start/end delimiters (such as `<!--`, `-->` or `--!>`) the
     * text it will render normally but it will not cause the HTML parser to close/open the comment.
     *
     * @param value text to make safe for comment node by escaping the comment open/close character
     *     sequence.
     */
    function escapeCommentText(value) {
        return value.replace(COMMENT_DISALLOWED, function (text) { return text.replace(COMMENT_DELIMITER, COMMENT_DELIMITER_ESCAPED); });
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * THIS FILE CONTAINS CODE WHICH SHOULD BE TREE SHAKEN AND NEVER CALLED FROM PRODUCTION CODE!!!
     */
    /**
     * Creates an `Array` construction with a given name. This is useful when
     * looking for memory consumption to see what time of array it is.
     *
     *
     * @param name Name to give to the constructor
     * @returns A subclass of `Array` if possible. This can only be done in
     *          environments which support `class` construct.
     */
    function createNamedArrayType(name) {
        // This should never be called in prod mode, so let's verify that is the case.
        if (ngDevMode) {
            try {
                // If this function were compromised the following could lead to arbitrary
                // script execution. We bless it with Trusted Types anyway since this
                // function is stripped out of production binaries.
                return (newTrustedFunctionForDev('Array', "return class " + name + " extends Array{}"))(Array);
            }
            catch (e) {
                // If it does not work just give up and fall back to regular Array.
                return Array;
            }
        }
        else {
            throw new Error('Looks like we are in \'prod mode\', but we are creating a named Array type, which is wrong! Check your code');
        }
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function normalizeDebugBindingName(name) {
        // Attribute names with `$` (eg `x-y$`) are valid per spec, but unsupported by some browsers
        name = camelCaseToDashCase(name.replace(/[$@]/g, '_'));
        return "ng-reflect-" + name;
    }
    var CAMEL_CASE_REGEXP = /([A-Z])/g;
    function camelCaseToDashCase(input) {
        return input.replace(CAMEL_CASE_REGEXP, function () {
            var m = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                m[_i] = arguments[_i];
            }
            return '-' + m[1].toLowerCase();
        });
    }
    function normalizeDebugBindingValue(value) {
        try {
            // Limit the size of the value as otherwise the DOM just gets polluted.
            return value != null ? value.toString().slice(0, 30) : value;
        }
        catch (e) {
            return '[ERROR] Exception while trying to serialize the value';
        }
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Returns the matching `LContext` data for a given DOM node, directive or component instance.
     *
     * This function will examine the provided DOM element, component, or directive instance\'s
     * monkey-patched property to derive the `LContext` data. Once called then the monkey-patched
     * value will be that of the newly created `LContext`.
     *
     * If the monkey-patched value is the `LView` instance then the context value for that
     * target will be created and the monkey-patch reference will be updated. Therefore when this
     * function is called it may mutate the provided element\'s, component\'s or any of the associated
     * directive\'s monkey-patch values.
     *
     * If the monkey-patch value is not detected then the code will walk up the DOM until an element
     * is found which contains a monkey-patch reference. When that occurs then the provided element
     * will be updated with a new context (which is then returned). If the monkey-patch value is not
     * detected for a component/directive instance then it will throw an error (all components and
     * directives should be automatically monkey-patched by ivy).
     *
     * @param target Component, Directive or DOM Node.
     */
    function getLContext(target) {
        var mpValue = readPatchedData(target);
        if (mpValue) {
            // only when it's an array is it considered an LView instance
            // ... otherwise it's an already constructed LContext instance
            if (Array.isArray(mpValue)) {
                var lView = mpValue;
                var nodeIndex = void 0;
                var component = undefined;
                var directives = undefined;
                if (isComponentInstance(target)) {
                    nodeIndex = findViaComponent(lView, target);
                    if (nodeIndex == -1) {
                        throw new Error('The provided component was not found in the application');
                    }
                    component = target;
                }
                else if (isDirectiveInstance(target)) {
                    nodeIndex = findViaDirective(lView, target);
                    if (nodeIndex == -1) {
                        throw new Error('The provided directive was not found in the application');
                    }
                    directives = getDirectivesAtNodeIndex(nodeIndex, lView, false);
                }
                else {
                    nodeIndex = findViaNativeElement(lView, target);
                    if (nodeIndex == -1) {
                        return null;
                    }
                }
                // the goal is not to fill the entire context full of data because the lookups
                // are expensive. Instead, only the target data (the element, component, container, ICU
                // expression or directive details) are filled into the context. If called multiple times
                // with different target values then the missing target data will be filled in.
                var native = unwrapRNode(lView[nodeIndex]);
                var existingCtx = readPatchedData(native);
                var context = (existingCtx && !Array.isArray(existingCtx)) ?
                    existingCtx :
                    createLContext(lView, nodeIndex, native);
                // only when the component has been discovered then update the monkey-patch
                if (component && context.component === undefined) {
                    context.component = component;
                    attachPatchData(context.component, context);
                }
                // only when the directives have been discovered then update the monkey-patch
                if (directives && context.directives === undefined) {
                    context.directives = directives;
                    for (var i = 0; i < directives.length; i++) {
                        attachPatchData(directives[i], context);
                    }
                }
                attachPatchData(context.native, context);
                mpValue = context;
            }
        }
        else {
            var rElement = target;
            ngDevMode && assertDomNode(rElement);
            // if the context is not found then we need to traverse upwards up the DOM
            // to find the nearest element that has already been monkey patched with data
            var parent = rElement;
            while (parent = parent.parentNode) {
                var parentContext = readPatchedData(parent);
                if (parentContext) {
                    var lView = void 0;
                    if (Array.isArray(parentContext)) {
                        lView = parentContext;
                    }
                    else {
                        lView = parentContext.lView;
                    }
                    // the edge of the app was also reached here through another means
                    // (maybe because the DOM was changed manually).
                    if (!lView) {
                        return null;
                    }
                    var index = findViaNativeElement(lView, rElement);
                    if (index >= 0) {
                        var native = unwrapRNode(lView[index]);
                        var context = createLContext(lView, index, native);
                        attachPatchData(native, context);
                        mpValue = context;
                        break;
                    }
                }
            }
        }
        return mpValue || null;
    }
    /**
     * Creates an empty instance of a `LContext` context
     */
    function createLContext(lView, nodeIndex, native) {
        return {
            lView: lView,
            nodeIndex: nodeIndex,
            native: native,
            component: undefined,
            directives: undefined,
            localRefs: undefined,
        };
    }
    /**
     * Takes a component instance and returns the view for that component.
     *
     * @param componentInstance
     * @returns The component's view
     */
    function getComponentViewByInstance(componentInstance) {
        var lView = readPatchedData(componentInstance);
        var view;
        if (Array.isArray(lView)) {
            var nodeIndex = findViaComponent(lView, componentInstance);
            view = getComponentLViewByIndex(nodeIndex, lView);
            var context = createLContext(lView, nodeIndex, view[HOST]);
            context.component = componentInstance;
            attachPatchData(componentInstance, context);
            attachPatchData(context.native, context);
        }
        else {
            var context = lView;
            view = getComponentLViewByIndex(context.nodeIndex, context.lView);
        }
        return view;
    }
    /**
     * Assigns the given data to the given target (which could be a component,
     * directive or DOM node instance) using monkey-patching.
     */
    function attachPatchData(target, data) {
        target[MONKEY_PATCH_KEY_NAME] = data;
    }
    function isComponentInstance(instance) {
        return instance && instance.constructor && instance.constructor.ɵcmp;
    }
    function isDirectiveInstance(instance) {
        return instance && instance.constructor && instance.constructor.ɵdir;
    }
    /**
     * Locates the element within the given LView and returns the matching index
     */
    function findViaNativeElement(lView, target) {
        var tView = lView[TVIEW];
        for (var i = HEADER_OFFSET; i < tView.bindingStartIndex; i++) {
            if (unwrapRNode(lView[i]) === target) {
                return i;
            }
        }
        return -1;
    }
    /**
     * Locates the next tNode (child, sibling or parent).
     */
    function traverseNextElement(tNode) {
        if (tNode.child) {
            return tNode.child;
        }
        else if (tNode.next) {
            return tNode.next;
        }
        else {
            // Let's take the following template: <div><span>text</span></div><component/>
            // After checking the text node, we need to find the next parent that has a "next" TNode,
            // in this case the parent `div`, so that we can find the component.
            while (tNode.parent && !tNode.parent.next) {
                tNode = tNode.parent;
            }
            return tNode.parent && tNode.parent.next;
        }
    }
    /**
     * Locates the component within the given LView and returns the matching index
     */
    function findViaComponent(lView, componentInstance) {
        var componentIndices = lView[TVIEW].components;
        if (componentIndices) {
            for (var i = 0; i < componentIndices.length; i++) {
                var elementComponentIndex = componentIndices[i];
                var componentView = getComponentLViewByIndex(elementComponentIndex, lView);
                if (componentView[CONTEXT] === componentInstance) {
                    return elementComponentIndex;
                }
            }
        }
        else {
            var rootComponentView = getComponentLViewByIndex(HEADER_OFFSET, lView);
            var rootComponent = rootComponentView[CONTEXT];
            if (rootComponent === componentInstance) {
                // we are dealing with the root element here therefore we know that the
                // element is the very first element after the HEADER data in the lView
                return HEADER_OFFSET;
            }
        }
        return -1;
    }
    /**
     * Locates the directive within the given LView and returns the matching index
     */
    function findViaDirective(lView, directiveInstance) {
        // if a directive is monkey patched then it will (by default)
        // have a reference to the LView of the current view. The
        // element bound to the directive being search lives somewhere
        // in the view data. We loop through the nodes and check their
        // list of directives for the instance.
        var tNode = lView[TVIEW].firstChild;
        while (tNode) {
            var directiveIndexStart = tNode.directiveStart;
            var directiveIndexEnd = tNode.directiveEnd;
            for (var i = directiveIndexStart; i < directiveIndexEnd; i++) {
                if (lView[i] === directiveInstance) {
                    return tNode.index;
                }
            }
            tNode = traverseNextElement(tNode);
        }
        return -1;
    }
    /**
     * Returns a list of directives extracted from the given view based on the
     * provided list of directive index values.
     *
     * @param nodeIndex The node index
     * @param lView The target view data
     * @param includeComponents Whether or not to include components in returned directives
     */
    function getDirectivesAtNodeIndex(nodeIndex, lView, includeComponents) {
        var tNode = lView[TVIEW].data[nodeIndex];
        var directiveStartIndex = tNode.directiveStart;
        if (directiveStartIndex == 0)
            return EMPTY_ARRAY$1;
        var directiveEndIndex = tNode.directiveEnd;
        if (!includeComponents && tNode.flags & 2 /* isComponentHost */)
            directiveStartIndex++;
        return lView.slice(directiveStartIndex, directiveEndIndex);
    }
    function getComponentAtNodeIndex(nodeIndex, lView) {
        var tNode = lView[TVIEW].data[nodeIndex];
        var directiveStartIndex = tNode.directiveStart;
        return tNode.flags & 2 /* isComponentHost */ ? lView[directiveStartIndex] : null;
    }
    /**
     * Returns a map of local references (local reference name => element or directive instance) that
     * exist on a given element.
     */
    function discoverLocalRefs(lView, nodeIndex) {
        var tNode = lView[TVIEW].data[nodeIndex];
        if (tNode && tNode.localNames) {
            var result = {};
            var localIndex = tNode.index + 1;
            for (var i = 0; i < tNode.localNames.length; i += 2) {
                result[tNode.localNames[i]] = lView[localIndex];
                localIndex++;
            }
            return result;
        }
        return null;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var ɵ0$4 = function () { return (typeof requestAnimationFrame !== 'undefined' &&
        requestAnimationFrame || // browser only
        setTimeout // everything else
    )
        .bind(_global); };
    var defaultScheduler = (ɵ0$4)();
    /**
     *
     * @codeGenApi
     */
    function ɵɵresolveWindow(element) {
        return { name: 'window', target: element.ownerDocument.defaultView };
    }
    /**
     *
     * @codeGenApi
     */
    function ɵɵresolveDocument(element) {
        return { name: 'document', target: element.ownerDocument };
    }
    /**
     *
     * @codeGenApi
     */
    function ɵɵresolveBody(element) {
        return { name: 'body', target: element.ownerDocument.body };
    }
    /**
     * The special delimiter we use to separate property names, prefixes, and suffixes
     * in property binding metadata. See storeBindingMetadata().
     *
     * We intentionally use the Unicode "REPLACEMENT CHARACTER" (U+FFFD) as a delimiter
     * because it is a very uncommon character that is unlikely to be part of a user's
     * property names or interpolation strings. If it is in fact used in a property
     * binding, DebugElement.properties will not return the correct value for that
     * binding. However, there should be no runtime effect for real applications.
     *
     * This character is typically rendered as a question mark inside of a diamond.
     * See https://en.wikipedia.org/wiki/Specials_(Unicode_block)
     *
     */
    var INTERPOLATION_DELIMITER = "\uFFFD";
    /**
     * Unwrap a value which might be behind a closure (for forward declaration reasons).
     */
    function maybeUnwrapFn(value) {
        if (value instanceof Function) {
            return value();
        }
        else {
            return value;
        }
    }

    /** Called when there are multiple component selectors that match a given node */
    function throwMultipleComponentError(tNode) {
        throw new RuntimeError("300" /* MULTIPLE_COMPONENTS_MATCH */, "Multiple components match node with tagname " + tNode.value);
    }
    /** Throws an ExpressionChangedAfterChecked error if checkNoChanges mode is on. */
    function throwErrorIfNoChangesMode(creationMode, oldValue, currValue, propName) {
        var field = propName ? " for '" + propName + "'" : '';
        var msg = "ExpressionChangedAfterItHasBeenCheckedError: Expression has changed after it was checked. Previous value" + field + ": '" + oldValue + "'. Current value: '" + currValue + "'.";
        if (creationMode) {
            msg +=
                " It seems like the view has been created after its parent and its children have been dirty checked." +
                    " Has it been created in a change detection hook?";
        }
        // TODO: include debug context, see `viewDebugError` function in
        // `packages/core/src/view/errors.ts` for reference.
        throw new RuntimeError("100" /* EXPRESSION_CHANGED_AFTER_CHECKED */, msg);
    }
    function constructDetailsForInterpolation(lView, rootIndex, expressionIndex, meta, changedValue) {
        var _a = __read(meta.split(INTERPOLATION_DELIMITER)), propName = _a[0], prefix = _a[1], chunks = _a.slice(2);
        var oldValue = prefix, newValue = prefix;
        for (var i = 0; i < chunks.length; i++) {
            var slotIdx = rootIndex + i;
            oldValue += "" + lView[slotIdx] + chunks[i];
            newValue += "" + (slotIdx === expressionIndex ? changedValue : lView[slotIdx]) + chunks[i];
        }
        return { propName: propName, oldValue: oldValue, newValue: newValue };
    }
    /**
     * Constructs an object that contains details for the ExpressionChangedAfterItHasBeenCheckedError:
     * - property name (for property bindings or interpolations)
     * - old and new values, enriched using information from metadata
     *
     * More information on the metadata storage format can be found in `storePropertyBindingMetadata`
     * function description.
     */
    function getExpressionChangedErrorDetails(lView, bindingIndex, oldValue, newValue) {
        var tData = lView[TVIEW].data;
        var metadata = tData[bindingIndex];
        if (typeof metadata === 'string') {
            // metadata for property interpolation
            if (metadata.indexOf(INTERPOLATION_DELIMITER) > -1) {
                return constructDetailsForInterpolation(lView, bindingIndex, bindingIndex, metadata, newValue);
            }
            // metadata for property binding
            return { propName: metadata, oldValue: oldValue, newValue: newValue };
        }
        // metadata is not available for this expression, check if this expression is a part of the
        // property interpolation by going from the current binding index left and look for a string that
        // contains INTERPOLATION_DELIMITER, the layout in tView.data for this case will look like this:
        // [..., 'id�Prefix � and � suffix', null, null, null, ...]
        if (metadata === null) {
            var idx = bindingIndex - 1;
            while (typeof tData[idx] !== 'string' && tData[idx + 1] === null) {
                idx--;
            }
            var meta = tData[idx];
            if (typeof meta === 'string') {
                var matches = meta.match(new RegExp(INTERPOLATION_DELIMITER, 'g'));
                // first interpolation delimiter separates property name from interpolation parts (in case of
                // property interpolations), so we subtract one from total number of found delimiters
                if (matches && (matches.length - 1) > bindingIndex - idx) {
                    return constructDetailsForInterpolation(lView, idx, bindingIndex, meta, newValue);
                }
            }
        }
        return { propName: undefined, oldValue: oldValue, newValue: newValue };
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    (function (RendererStyleFlags2) {
        // TODO(misko): This needs to be refactored into a separate file so that it can be imported from
        // `node_manipulation.ts` Currently doing the import cause resolution order to change and fails
        // the tests. The work around is to have hard coded value in `node_manipulation.ts` for now.
        /**
         * Marks a style as important.
         */
        RendererStyleFlags2[RendererStyleFlags2["Important"] = 1] = "Important";
        /**
         * Marks a style as using dash case naming (this-is-dash-case).
         */
        RendererStyleFlags2[RendererStyleFlags2["DashCase"] = 2] = "DashCase";
    })(exports.RendererStyleFlags2 || (exports.RendererStyleFlags2 = {}));

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var _icuContainerIterate;
    /**
     * Iterator which provides ability to visit all of the `TIcuContainerNode` root `RNode`s.
     */
    function icuContainerIterate(tIcuContainerNode, lView) {
        return _icuContainerIterate(tIcuContainerNode, lView);
    }
    /**
     * Ensures that `IcuContainerVisitor`'s implementation is present.
     *
     * This function is invoked when i18n instruction comes across an ICU. The purpose is to allow the
     * bundler to tree shake ICU logic and only load it if ICU instruction is executed.
     */
    function ensureIcuContainerVisitorLoaded(loader) {
        if (_icuContainerIterate === undefined) {
            // Do not inline this function. We want to keep `ensureIcuContainerVisitorLoaded` light, so it
            // can be inlined into call-site.
            _icuContainerIterate = loader();
        }
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    // Note: This hack is necessary so we don't erroneously get a circular dependency
    // failure based on types.
    var unusedValueExportToPlacateAjd$5 = 1;

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Gets the parent LView of the passed LView, if the PARENT is an LContainer, will get the parent of
     * that LContainer, which is an LView
     * @param lView the lView whose parent to get
     */
    function getLViewParent(lView) {
        ngDevMode && assertLView(lView);
        var parent = lView[PARENT];
        return isLContainer(parent) ? parent[PARENT] : parent;
    }
    /**
     * Retrieve the root view from any component or `LView` by walking the parent `LView` until
     * reaching the root `LView`.
     *
     * @param componentOrLView any component or `LView`
     */
    function getRootView(componentOrLView) {
        ngDevMode && assertDefined(componentOrLView, 'component');
        var lView = isLView(componentOrLView) ? componentOrLView : readPatchedLView(componentOrLView);
        while (lView && !(lView[FLAGS] & 512 /* IsRoot */)) {
            lView = getLViewParent(lView);
        }
        ngDevMode && assertLView(lView);
        return lView;
    }
    /**
     * Returns the `RootContext` instance that is associated with
     * the application where the target is situated. It does this by walking the parent views until it
     * gets to the root view, then getting the context off of that.
     *
     * @param viewOrComponent the `LView` or component to get the root context for.
     */
    function getRootContext(viewOrComponent) {
        var rootView = getRootView(viewOrComponent);
        ngDevMode &&
            assertDefined(rootView[CONTEXT], 'RootView has no context. Perhaps it is disconnected?');
        return rootView[CONTEXT];
    }
    /**
     * Gets the first `LContainer` in the LView or `null` if none exists.
     */
    function getFirstLContainer(lView) {
        return getNearestLContainer(lView[CHILD_HEAD]);
    }
    /**
     * Gets the next `LContainer` that is a sibling of the given container.
     */
    function getNextLContainer(container) {
        return getNearestLContainer(container[NEXT]);
    }
    function getNearestLContainer(viewOrContainer) {
        while (viewOrContainer !== null && !isLContainer(viewOrContainer)) {
            viewOrContainer = viewOrContainer[NEXT];
        }
        return viewOrContainer;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var unusedValueToPlacateAjd = unusedValueExportToPlacateAjd + unusedValueExportToPlacateAjd$4 + unusedValueExportToPlacateAjd$5 + unusedValueExportToPlacateAjd$2 + unusedValueExportToPlacateAjd$1;
    /**
     * NOTE: for performance reasons, the possible actions are inlined within the function instead of
     * being passed as an argument.
     */
    function applyToElementOrContainer(action, renderer, parent, lNodeToHandle, beforeNode) {
        // If this slot was allocated for a text node dynamically created by i18n, the text node itself
        // won't be created until i18nApply() in the update block, so this node should be skipped.
        // For more info, see "ICU expressions should work inside an ngTemplateOutlet inside an ngFor"
        // in `i18n_spec.ts`.
        if (lNodeToHandle != null) {
            var lContainer = void 0;
            var isComponent = false;
            // We are expecting an RNode, but in the case of a component or LContainer the `RNode` is
            // wrapped in an array which needs to be unwrapped. We need to know if it is a component and if
            // it has LContainer so that we can process all of those cases appropriately.
            if (isLContainer(lNodeToHandle)) {
                lContainer = lNodeToHandle;
            }
            else if (isLView(lNodeToHandle)) {
                isComponent = true;
                ngDevMode && assertDefined(lNodeToHandle[HOST], 'HOST must be defined for a component LView');
                lNodeToHandle = lNodeToHandle[HOST];
            }
            var rNode = unwrapRNode(lNodeToHandle);
            ngDevMode && !isProceduralRenderer(renderer) && assertDomNode(rNode);
            if (action === 0 /* Create */ && parent !== null) {
                if (beforeNode == null) {
                    nativeAppendChild(renderer, parent, rNode);
                }
                else {
                    nativeInsertBefore(renderer, parent, rNode, beforeNode || null, true);
                }
            }
            else if (action === 1 /* Insert */ && parent !== null) {
                nativeInsertBefore(renderer, parent, rNode, beforeNode || null, true);
            }
            else if (action === 2 /* Detach */) {
                nativeRemoveNode(renderer, rNode, isComponent);
            }
            else if (action === 3 /* Destroy */) {
                ngDevMode && ngDevMode.rendererDestroyNode++;
                renderer.destroyNode(rNode);
            }
            if (lContainer != null) {
                applyContainer(renderer, action, lContainer, parent, beforeNode);
            }
        }
    }
    function createTextNode(renderer, value) {
        ngDevMode && ngDevMode.rendererCreateTextNode++;
        ngDevMode && ngDevMode.rendererSetText++;
        return isProceduralRenderer(renderer) ? renderer.createText(value) :
            renderer.createTextNode(value);
    }
    function updateTextNode(renderer, rNode, value) {
        ngDevMode && ngDevMode.rendererSetText++;
        isProceduralRenderer(renderer) ? renderer.setValue(rNode, value) : rNode.textContent = value;
    }
    function createCommentNode(renderer, value) {
        ngDevMode && ngDevMode.rendererCreateComment++;
        // isProceduralRenderer check is not needed because both `Renderer2` and `Renderer3` have the same
        // method name.
        return renderer.createComment(escapeCommentText(value));
    }
    /**
     * Creates a native element from a tag name, using a renderer.
     * @param renderer A renderer to use
     * @param name the tag name
     * @param namespace Optional namespace for element.
     * @returns the element created
     */
    function createElementNode(renderer, name, namespace) {
        ngDevMode && ngDevMode.rendererCreateElement++;
        if (isProceduralRenderer(renderer)) {
            return renderer.createElement(name, namespace);
        }
        else {
            return namespace === null ? renderer.createElement(name) :
                renderer.createElementNS(namespace, name);
        }
    }
    /**
     * Removes all DOM elements associated with a view.
     *
     * Because some root nodes of the view may be containers, we sometimes need
     * to propagate deeply into the nested containers to remove all elements in the
     * views beneath it.
     *
     * @param tView The `TView' of the `LView` from which elements should be added or removed
     * @param lView The view from which elements should be added or removed
     */
    function removeViewFromContainer(tView, lView) {
        var renderer = lView[RENDERER];
        applyView(tView, lView, renderer, 2 /* Detach */, null, null);
        lView[HOST] = null;
        lView[T_HOST] = null;
    }
    /**
     * Adds all DOM elements associated with a view.
     *
     * Because some root nodes of the view may be containers, we sometimes need
     * to propagate deeply into the nested containers to add all elements in the
     * views beneath it.
     *
     * @param tView The `TView' of the `LView` from which elements should be added or removed
     * @param parentTNode The `TNode` where the `LView` should be attached to.
     * @param renderer Current renderer to use for DOM manipulations.
     * @param lView The view from which elements should be added or removed
     * @param parentNativeNode The parent `RElement` where it should be inserted into.
     * @param beforeNode The node before which elements should be added, if insert mode
     */
    function addViewToContainer(tView, parentTNode, renderer, lView, parentNativeNode, beforeNode) {
        lView[HOST] = parentNativeNode;
        lView[T_HOST] = parentTNode;
        applyView(tView, lView, renderer, 1 /* Insert */, parentNativeNode, beforeNode);
    }
    /**
     * Detach a `LView` from the DOM by detaching its nodes.
     *
     * @param tView The `TView' of the `LView` to be detached
     * @param lView the `LView` to be detached.
     */
    function renderDetachView(tView, lView) {
        applyView(tView, lView, lView[RENDERER], 2 /* Detach */, null, null);
    }
    /**
     * Traverses down and up the tree of views and containers to remove listeners and
     * call onDestroy callbacks.
     *
     * Notes:
     *  - Because it's used for onDestroy calls, it needs to be bottom-up.
     *  - Must process containers instead of their views to avoid splicing
     *  when views are destroyed and re-added.
     *  - Using a while loop because it's faster than recursion
     *  - Destroy only called on movement to sibling or movement to parent (laterally or up)
     *
     *  @param rootView The view to destroy
     */
    function destroyViewTree(rootView) {
        // If the view has no children, we can clean it up and return early.
        var lViewOrLContainer = rootView[CHILD_HEAD];
        if (!lViewOrLContainer) {
            return cleanUpView(rootView[TVIEW], rootView);
        }
        while (lViewOrLContainer) {
            var next = null;
            if (isLView(lViewOrLContainer)) {
                // If LView, traverse down to child.
                next = lViewOrLContainer[CHILD_HEAD];
            }
            else {
                ngDevMode && assertLContainer(lViewOrLContainer);
                // If container, traverse down to its first LView.
                var firstView = lViewOrLContainer[CONTAINER_HEADER_OFFSET];
                if (firstView)
                    next = firstView;
            }
            if (!next) {
                // Only clean up view when moving to the side or up, as destroy hooks
                // should be called in order from the bottom up.
                while (lViewOrLContainer && !lViewOrLContainer[NEXT] && lViewOrLContainer !== rootView) {
                    if (isLView(lViewOrLContainer)) {
                        cleanUpView(lViewOrLContainer[TVIEW], lViewOrLContainer);
                    }
                    lViewOrLContainer = lViewOrLContainer[PARENT];
                }
                if (lViewOrLContainer === null)
                    lViewOrLContainer = rootView;
                if (isLView(lViewOrLContainer)) {
                    cleanUpView(lViewOrLContainer[TVIEW], lViewOrLContainer);
                }
                next = lViewOrLContainer && lViewOrLContainer[NEXT];
            }
            lViewOrLContainer = next;
        }
    }
    /**
     * Inserts a view into a container.
     *
     * This adds the view to the container's array of active views in the correct
     * position. It also adds the view's elements to the DOM if the container isn't a
     * root node of another view (in that case, the view's elements will be added when
     * the container's parent view is added later).
     *
     * @param tView The `TView' of the `LView` to insert
     * @param lView The view to insert
     * @param lContainer The container into which the view should be inserted
     * @param index Which index in the container to insert the child view into
     */
    function insertView(tView, lView, lContainer, index) {
        ngDevMode && assertLView(lView);
        ngDevMode && assertLContainer(lContainer);
        var indexInContainer = CONTAINER_HEADER_OFFSET + index;
        var containerLength = lContainer.length;
        if (index > 0) {
            // This is a new view, we need to add it to the children.
            lContainer[indexInContainer - 1][NEXT] = lView;
        }
        if (index < containerLength - CONTAINER_HEADER_OFFSET) {
            lView[NEXT] = lContainer[indexInContainer];
            addToArray(lContainer, CONTAINER_HEADER_OFFSET + index, lView);
        }
        else {
            lContainer.push(lView);
            lView[NEXT] = null;
        }
        lView[PARENT] = lContainer;
        // track views where declaration and insertion points are different
        var declarationLContainer = lView[DECLARATION_LCONTAINER];
        if (declarationLContainer !== null && lContainer !== declarationLContainer) {
            trackMovedView(declarationLContainer, lView);
        }
        // notify query that a new view has been added
        var lQueries = lView[QUERIES];
        if (lQueries !== null) {
            lQueries.insertView(tView);
        }
        // Sets the attached flag
        lView[FLAGS] |= 128 /* Attached */;
    }
    /**
     * Track views created from the declaration container (TemplateRef) and inserted into a
     * different LContainer.
     */
    function trackMovedView(declarationContainer, lView) {
        ngDevMode && assertDefined(lView, 'LView required');
        ngDevMode && assertLContainer(declarationContainer);
        var movedViews = declarationContainer[MOVED_VIEWS];
        var insertedLContainer = lView[PARENT];
        ngDevMode && assertLContainer(insertedLContainer);
        var insertedComponentLView = insertedLContainer[PARENT][DECLARATION_COMPONENT_VIEW];
        ngDevMode && assertDefined(insertedComponentLView, 'Missing insertedComponentLView');
        var declaredComponentLView = lView[DECLARATION_COMPONENT_VIEW];
        ngDevMode && assertDefined(declaredComponentLView, 'Missing declaredComponentLView');
        if (declaredComponentLView !== insertedComponentLView) {
            // At this point the declaration-component is not same as insertion-component; this means that
            // this is a transplanted view. Mark the declared lView as having transplanted views so that
            // those views can participate in CD.
            declarationContainer[HAS_TRANSPLANTED_VIEWS] = true;
        }
        if (movedViews === null) {
            declarationContainer[MOVED_VIEWS] = [lView];
        }
        else {
            movedViews.push(lView);
        }
    }
    function detachMovedView(declarationContainer, lView) {
        ngDevMode && assertLContainer(declarationContainer);
        ngDevMode &&
            assertDefined(declarationContainer[MOVED_VIEWS], 'A projected view should belong to a non-empty projected views collection');
        var movedViews = declarationContainer[MOVED_VIEWS];
        var declarationViewIndex = movedViews.indexOf(lView);
        var insertionLContainer = lView[PARENT];
        ngDevMode && assertLContainer(insertionLContainer);
        // If the view was marked for refresh but then detached before it was checked (where the flag
        // would be cleared and the counter decremented), we need to decrement the view counter here
        // instead.
        if (lView[FLAGS] & 1024 /* RefreshTransplantedView */) {
            lView[FLAGS] &= ~1024 /* RefreshTransplantedView */;
            updateTransplantedViewCount(insertionLContainer, -1);
        }
        movedViews.splice(declarationViewIndex, 1);
    }
    /**
     * Detaches a view from a container.
     *
     * This method removes the view from the container's array of active views. It also
     * removes the view's elements from the DOM.
     *
     * @param lContainer The container from which to detach a view
     * @param removeIndex The index of the view to detach
     * @returns Detached LView instance.
     */
    function detachView(lContainer, removeIndex) {
        if (lContainer.length <= CONTAINER_HEADER_OFFSET)
            return;
        var indexInContainer = CONTAINER_HEADER_OFFSET + removeIndex;
        var viewToDetach = lContainer[indexInContainer];
        if (viewToDetach) {
            var declarationLContainer = viewToDetach[DECLARATION_LCONTAINER];
            if (declarationLContainer !== null && declarationLContainer !== lContainer) {
                detachMovedView(declarationLContainer, viewToDetach);
            }
            if (removeIndex > 0) {
                lContainer[indexInContainer - 1][NEXT] = viewToDetach[NEXT];
            }
            var removedLView = removeFromArray(lContainer, CONTAINER_HEADER_OFFSET + removeIndex);
            removeViewFromContainer(viewToDetach[TVIEW], viewToDetach);
            // notify query that a view has been removed
            var lQueries = removedLView[QUERIES];
            if (lQueries !== null) {
                lQueries.detachView(removedLView[TVIEW]);
            }
            viewToDetach[PARENT] = null;
            viewToDetach[NEXT] = null;
            // Unsets the attached flag
            viewToDetach[FLAGS] &= ~128 /* Attached */;
        }
        return viewToDetach;
    }
    /**
     * A standalone function which destroys an LView,
     * conducting clean up (e.g. removing listeners, calling onDestroys).
     *
     * @param tView The `TView' of the `LView` to be destroyed
     * @param lView The view to be destroyed.
     */
    function destroyLView(tView, lView) {
        if (!(lView[FLAGS] & 256 /* Destroyed */)) {
            var renderer = lView[RENDERER];
            if (isProceduralRenderer(renderer) && renderer.destroyNode) {
                applyView(tView, lView, renderer, 3 /* Destroy */, null, null);
            }
            destroyViewTree(lView);
        }
    }
    /**
     * Calls onDestroys hooks for all directives and pipes in a given view and then removes all
     * listeners. Listeners are removed as the last step so events delivered in the onDestroys hooks
     * can be propagated to @Output listeners.
     *
     * @param tView `TView` for the `LView` to clean up.
     * @param lView The LView to clean up
     */
    function cleanUpView(tView, lView) {
        if (!(lView[FLAGS] & 256 /* Destroyed */)) {
            // Usually the Attached flag is removed when the view is detached from its parent, however
            // if it's a root view, the flag won't be unset hence why we're also removing on destroy.
            lView[FLAGS] &= ~128 /* Attached */;
            // Mark the LView as destroyed *before* executing the onDestroy hooks. An onDestroy hook
            // runs arbitrary user code, which could include its own `viewRef.destroy()` (or similar). If
            // We don't flag the view as destroyed before the hooks, this could lead to an infinite loop.
            // This also aligns with the ViewEngine behavior. It also means that the onDestroy hook is
            // really more of an "afterDestroy" hook if you think about it.
            lView[FLAGS] |= 256 /* Destroyed */;
            executeOnDestroys(tView, lView);
            processCleanups(tView, lView);
            // For component views only, the local renderer is destroyed at clean up time.
            if (lView[TVIEW].type === 1 /* Component */ && isProceduralRenderer(lView[RENDERER])) {
                ngDevMode && ngDevMode.rendererDestroy++;
                lView[RENDERER].destroy();
            }
            var declarationContainer = lView[DECLARATION_LCONTAINER];
            // we are dealing with an embedded view that is still inserted into a container
            if (declarationContainer !== null && isLContainer(lView[PARENT])) {
                // and this is a projected view
                if (declarationContainer !== lView[PARENT]) {
                    detachMovedView(declarationContainer, lView);
                }
                // For embedded views still attached to a container: remove query result from this view.
                var lQueries = lView[QUERIES];
                if (lQueries !== null) {
                    lQueries.detachView(tView);
                }
            }
        }
    }
    /** Removes listeners and unsubscribes from output subscriptions */
    function processCleanups(tView, lView) {
        var tCleanup = tView.cleanup;
        var lCleanup = lView[CLEANUP];
        // `LCleanup` contains both share information with `TCleanup` as well as instance specific
        // information appended at the end. We need to know where the end of the `TCleanup` information
        // is, and we track this with `lastLCleanupIndex`.
        var lastLCleanupIndex = -1;
        if (tCleanup !== null) {
            for (var i = 0; i < tCleanup.length - 1; i += 2) {
                if (typeof tCleanup[i] === 'string') {
                    // This is a native DOM listener
                    var idxOrTargetGetter = tCleanup[i + 1];
                    var target = typeof idxOrTargetGetter === 'function' ?
                        idxOrTargetGetter(lView) :
                        unwrapRNode(lView[idxOrTargetGetter]);
                    var listener = lCleanup[lastLCleanupIndex = tCleanup[i + 2]];
                    var useCaptureOrSubIdx = tCleanup[i + 3];
                    if (typeof useCaptureOrSubIdx === 'boolean') {
                        // native DOM listener registered with Renderer3
                        target.removeEventListener(tCleanup[i], listener, useCaptureOrSubIdx);
                    }
                    else {
                        if (useCaptureOrSubIdx >= 0) {
                            // unregister
                            lCleanup[lastLCleanupIndex = useCaptureOrSubIdx]();
                        }
                        else {
                            // Subscription
                            lCleanup[lastLCleanupIndex = -useCaptureOrSubIdx].unsubscribe();
                        }
                    }
                    i += 2;
                }
                else {
                    // This is a cleanup function that is grouped with the index of its context
                    var context = lCleanup[lastLCleanupIndex = tCleanup[i + 1]];
                    tCleanup[i].call(context);
                }
            }
        }
        if (lCleanup !== null) {
            for (var i = lastLCleanupIndex + 1; i < lCleanup.length; i++) {
                var instanceCleanupFn = lCleanup[i];
                ngDevMode && assertFunction(instanceCleanupFn, 'Expecting instance cleanup function.');
                instanceCleanupFn();
            }
            lView[CLEANUP] = null;
        }
    }
    /** Calls onDestroy hooks for this view */
    function executeOnDestroys(tView, lView) {
        var destroyHooks;
        if (tView != null && (destroyHooks = tView.destroyHooks) != null) {
            for (var i = 0; i < destroyHooks.length; i += 2) {
                var context = lView[destroyHooks[i]];
                // Only call the destroy hook if the context has been requested.
                if (!(context instanceof NodeInjectorFactory)) {
                    var toCall = destroyHooks[i + 1];
                    if (Array.isArray(toCall)) {
                        for (var j = 0; j < toCall.length; j += 2) {
                            toCall[j + 1].call(context[toCall[j]]);
                        }
                    }
                    else {
                        toCall.call(context);
                    }
                }
            }
        }
    }
    /**
     * Returns a native element if a node can be inserted into the given parent.
     *
     * There are two reasons why we may not be able to insert a element immediately.
     * - Projection: When creating a child content element of a component, we have to skip the
     *   insertion because the content of a component will be projected.
     *   `<component><content>delayed due to projection</content></component>`
     * - Parent container is disconnected: This can happen when we are inserting a view into
     *   parent container, which itself is disconnected. For example the parent container is part
     *   of a View which has not be inserted or is made for projection but has not been inserted
     *   into destination.
     *
     * @param tView: Current `TView`.
     * @param tNode: `TNode` for which we wish to retrieve render parent.
     * @param lView: Current `LView`.
     */
    function getParentRElement(tView, tNode, lView) {
        return getClosestRElement(tView, tNode.parent, lView);
    }
    /**
     * Get closest `RElement` or `null` if it can't be found.
     *
     * If `TNode` is `TNodeType.Element` => return `RElement` at `LView[tNode.index]` location.
     * If `TNode` is `TNodeType.ElementContainer|IcuContain` => return the parent (recursively).
     * If `TNode` is `null` then return host `RElement`:
     *   - return `null` if projection
     *   - return `null` if parent container is disconnected (we have no parent.)
     *
     * @param tView: Current `TView`.
     * @param tNode: `TNode` for which we wish to retrieve `RElement` (or `null` if host element is
     *     needed).
     * @param lView: Current `LView`.
     * @returns `null` if the `RElement` can't be determined at this time (no parent / projection)
     */
    function getClosestRElement(tView, tNode, lView) {
        var parentTNode = tNode;
        // Skip over element and ICU containers as those are represented by a comment node and
        // can't be used as a render parent.
        while (parentTNode !== null &&
            (parentTNode.type & (8 /* ElementContainer */ | 32 /* Icu */))) {
            tNode = parentTNode;
            parentTNode = tNode.parent;
        }
        // If the parent tNode is null, then we are inserting across views: either into an embedded view
        // or a component view.
        if (parentTNode === null) {
            // We are inserting a root element of the component view into the component host element and
            // it should always be eager.
            return lView[HOST];
        }
        else {
            ngDevMode && assertTNodeType(parentTNode, 3 /* AnyRNode */ | 4 /* Container */);
            if (parentTNode.flags & 2 /* isComponentHost */) {
                ngDevMode && assertTNodeForLView(parentTNode, lView);
                var encapsulation = tView.data[parentTNode.directiveStart].encapsulation;
                // We've got a parent which is an element in the current view. We just need to verify if the
                // parent element is not a component. Component's content nodes are not inserted immediately
                // because they will be projected, and so doing insert at this point would be wasteful.
                // Since the projection would then move it to its final destination. Note that we can't
                // make this assumption when using the Shadow DOM, because the native projection placeholders
                // (<content> or <slot>) have to be in place as elements are being inserted.
                if (encapsulation === exports.ViewEncapsulation.None ||
                    encapsulation === exports.ViewEncapsulation.Emulated) {
                    return null;
                }
            }
            return getNativeByTNode(parentTNode, lView);
        }
    }
    /**
     * Inserts a native node before another native node for a given parent using {@link Renderer3}.
     * This is a utility function that can be used when native nodes were determined - it abstracts an
     * actual renderer being used.
     */
    function nativeInsertBefore(renderer, parent, child, beforeNode, isMove) {
        ngDevMode && ngDevMode.rendererInsertBefore++;
        if (isProceduralRenderer(renderer)) {
            renderer.insertBefore(parent, child, beforeNode, isMove);
        }
        else {
            parent.insertBefore(child, beforeNode, isMove);
        }
    }
    function nativeAppendChild(renderer, parent, child) {
        ngDevMode && ngDevMode.rendererAppendChild++;
        ngDevMode && assertDefined(parent, 'parent node must be defined');
        if (isProceduralRenderer(renderer)) {
            renderer.appendChild(parent, child);
        }
        else {
            parent.appendChild(child);
        }
    }
    function nativeAppendOrInsertBefore(renderer, parent, child, beforeNode, isMove) {
        if (beforeNode !== null) {
            nativeInsertBefore(renderer, parent, child, beforeNode, isMove);
        }
        else {
            nativeAppendChild(renderer, parent, child);
        }
    }
    /** Removes a node from the DOM given its native parent. */
    function nativeRemoveChild(renderer, parent, child, isHostElement) {
        if (isProceduralRenderer(renderer)) {
            renderer.removeChild(parent, child, isHostElement);
        }
        else {
            parent.removeChild(child);
        }
    }
    /**
     * Returns a native parent of a given native node.
     */
    function nativeParentNode(renderer, node) {
        return (isProceduralRenderer(renderer) ? renderer.parentNode(node) : node.parentNode);
    }
    /**
     * Returns a native sibling of a given native node.
     */
    function nativeNextSibling(renderer, node) {
        return isProceduralRenderer(renderer) ? renderer.nextSibling(node) : node.nextSibling;
    }
    /**
     * Find a node in front of which `currentTNode` should be inserted.
     *
     * This method determines the `RNode` in front of which we should insert the `currentRNode`. This
     * takes `TNode.insertBeforeIndex` into account if i18n code has been invoked.
     *
     * @param parentTNode parent `TNode`
     * @param currentTNode current `TNode` (The node which we would like to insert into the DOM)
     * @param lView current `LView`
     */
    function getInsertInFrontOfRNode(parentTNode, currentTNode, lView) {
        return _getInsertInFrontOfRNodeWithI18n(parentTNode, currentTNode, lView);
    }
    /**
     * Find a node in front of which `currentTNode` should be inserted. (Does not take i18n into
     * account)
     *
     * This method determines the `RNode` in front of which we should insert the `currentRNode`. This
     * does not take `TNode.insertBeforeIndex` into account.
     *
     * @param parentTNode parent `TNode`
     * @param currentTNode current `TNode` (The node which we would like to insert into the DOM)
     * @param lView current `LView`
     */
    function getInsertInFrontOfRNodeWithNoI18n(parentTNode, currentTNode, lView) {
        if (parentTNode.type & (8 /* ElementContainer */ | 32 /* Icu */)) {
            return getNativeByTNode(parentTNode, lView);
        }
        return null;
    }
    /**
     * Tree shakable boundary for `getInsertInFrontOfRNodeWithI18n` function.
     *
     * This function will only be set if i18n code runs.
     */
    var _getInsertInFrontOfRNodeWithI18n = getInsertInFrontOfRNodeWithNoI18n;
    /**
     * Tree shakable boundary for `processI18nInsertBefore` function.
     *
     * This function will only be set if i18n code runs.
     */
    var _processI18nInsertBefore;
    function setI18nHandling(getInsertInFrontOfRNodeWithI18n, processI18nInsertBefore) {
        _getInsertInFrontOfRNodeWithI18n = getInsertInFrontOfRNodeWithI18n;
        _processI18nInsertBefore = processI18nInsertBefore;
    }
    /**
     * Appends the `child` native node (or a collection of nodes) to the `parent`.
     *
     * @param tView The `TView' to be appended
     * @param lView The current LView
     * @param childRNode The native child (or children) that should be appended
     * @param childTNode The TNode of the child element
     */
    function appendChild(tView, lView, childRNode, childTNode) {
        var parentRNode = getParentRElement(tView, childTNode, lView);
        var renderer = lView[RENDERER];
        var parentTNode = childTNode.parent || lView[T_HOST];
        var anchorNode = getInsertInFrontOfRNode(parentTNode, childTNode, lView);
        if (parentRNode != null) {
            if (Array.isArray(childRNode)) {
                for (var i = 0; i < childRNode.length; i++) {
                    nativeAppendOrInsertBefore(renderer, parentRNode, childRNode[i], anchorNode, false);
                }
            }
            else {
                nativeAppendOrInsertBefore(renderer, parentRNode, childRNode, anchorNode, false);
            }
        }
        _processI18nInsertBefore !== undefined &&
            _processI18nInsertBefore(renderer, childTNode, lView, childRNode, parentRNode);
    }
    /**
     * Returns the first native node for a given LView, starting from the provided TNode.
     *
     * Native nodes are returned in the order in which those appear in the native tree (DOM).
     */
    function getFirstNativeNode(lView, tNode) {
        if (tNode !== null) {
            ngDevMode &&
                assertTNodeType(tNode, 3 /* AnyRNode */ | 12 /* AnyContainer */ | 32 /* Icu */ | 16 /* Projection */);
            var tNodeType = tNode.type;
            if (tNodeType & 3 /* AnyRNode */) {
                return getNativeByTNode(tNode, lView);
            }
            else if (tNodeType & 4 /* Container */) {
                return getBeforeNodeForView(-1, lView[tNode.index]);
            }
            else if (tNodeType & 8 /* ElementContainer */) {
                var elIcuContainerChild = tNode.child;
                if (elIcuContainerChild !== null) {
                    return getFirstNativeNode(lView, elIcuContainerChild);
                }
                else {
                    var rNodeOrLContainer = lView[tNode.index];
                    if (isLContainer(rNodeOrLContainer)) {
                        return getBeforeNodeForView(-1, rNodeOrLContainer);
                    }
                    else {
                        return unwrapRNode(rNodeOrLContainer);
                    }
                }
            }
            else if (tNodeType & 32 /* Icu */) {
                var nextRNode = icuContainerIterate(tNode, lView);
                var rNode = nextRNode();
                // If the ICU container has no nodes, than we use the ICU anchor as the node.
                return rNode || unwrapRNode(lView[tNode.index]);
            }
            else {
                var projectionNodes = getProjectionNodes(lView, tNode);
                if (projectionNodes !== null) {
                    if (Array.isArray(projectionNodes)) {
                        return projectionNodes[0];
                    }
                    var parentView = getLViewParent(lView[DECLARATION_COMPONENT_VIEW]);
                    ngDevMode && assertParentView(parentView);
                    return getFirstNativeNode(parentView, projectionNodes);
                }
                else {
                    return getFirstNativeNode(lView, tNode.next);
                }
            }
        }
        return null;
    }
    function getProjectionNodes(lView, tNode) {
        if (tNode !== null) {
            var componentView = lView[DECLARATION_COMPONENT_VIEW];
            var componentHost = componentView[T_HOST];
            var slotIdx = tNode.projection;
            ngDevMode && assertProjectionSlots(lView);
            return componentHost.projection[slotIdx];
        }
        return null;
    }
    function getBeforeNodeForView(viewIndexInContainer, lContainer) {
        var nextViewIndex = CONTAINER_HEADER_OFFSET + viewIndexInContainer + 1;
        if (nextViewIndex < lContainer.length) {
            var lView = lContainer[nextViewIndex];
            var firstTNodeOfView = lView[TVIEW].firstChild;
            if (firstTNodeOfView !== null) {
                return getFirstNativeNode(lView, firstTNodeOfView);
            }
        }
        return lContainer[NATIVE];
    }
    /**
     * Removes a native node itself using a given renderer. To remove the node we are looking up its
     * parent from the native tree as not all platforms / browsers support the equivalent of
     * node.remove().
     *
     * @param renderer A renderer to be used
     * @param rNode The native node that should be removed
     * @param isHostElement A flag indicating if a node to be removed is a host of a component.
     */
    function nativeRemoveNode(renderer, rNode, isHostElement) {
        ngDevMode && ngDevMode.rendererRemoveNode++;
        var nativeParent = nativeParentNode(renderer, rNode);
        if (nativeParent) {
            nativeRemoveChild(renderer, nativeParent, rNode, isHostElement);
        }
    }
    /**
     * Performs the operation of `action` on the node. Typically this involves inserting or removing
     * nodes on the LView or projection boundary.
     */
    function applyNodes(renderer, action, tNode, lView, parentRElement, beforeNode, isProjection) {
        while (tNode != null) {
            ngDevMode && assertTNodeForLView(tNode, lView);
            ngDevMode &&
                assertTNodeType(tNode, 3 /* AnyRNode */ | 12 /* AnyContainer */ | 16 /* Projection */ | 32 /* Icu */);
            var rawSlotValue = lView[tNode.index];
            var tNodeType = tNode.type;
            if (isProjection) {
                if (action === 0 /* Create */) {
                    rawSlotValue && attachPatchData(unwrapRNode(rawSlotValue), lView);
                    tNode.flags |= 4 /* isProjected */;
                }
            }
            if ((tNode.flags & 64 /* isDetached */) !== 64 /* isDetached */) {
                if (tNodeType & 8 /* ElementContainer */) {
                    applyNodes(renderer, action, tNode.child, lView, parentRElement, beforeNode, false);
                    applyToElementOrContainer(action, renderer, parentRElement, rawSlotValue, beforeNode);
                }
                else if (tNodeType & 32 /* Icu */) {
                    var nextRNode = icuContainerIterate(tNode, lView);
                    var rNode = void 0;
                    while (rNode = nextRNode()) {
                        applyToElementOrContainer(action, renderer, parentRElement, rNode, beforeNode);
                    }
                    applyToElementOrContainer(action, renderer, parentRElement, rawSlotValue, beforeNode);
                }
                else if (tNodeType & 16 /* Projection */) {
                    applyProjectionRecursive(renderer, action, lView, tNode, parentRElement, beforeNode);
                }
                else {
                    ngDevMode && assertTNodeType(tNode, 3 /* AnyRNode */ | 4 /* Container */);
                    applyToElementOrContainer(action, renderer, parentRElement, rawSlotValue, beforeNode);
                }
            }
            tNode = isProjection ? tNode.projectionNext : tNode.next;
        }
    }
    function applyView(tView, lView, renderer, action, parentRElement, beforeNode) {
        applyNodes(renderer, action, tView.firstChild, lView, parentRElement, beforeNode, false);
    }
    /**
     * `applyProjection` performs operation on the projection.
     *
     * Inserting a projection requires us to locate the projected nodes from the parent component. The
     * complication is that those nodes themselves could be re-projected from their parent component.
     *
     * @param tView The `TView` of `LView` which needs to be inserted, detached, destroyed
     * @param lView The `LView` which needs to be inserted, detached, destroyed.
     * @param tProjectionNode node to project
     */
    function applyProjection(tView, lView, tProjectionNode) {
        var renderer = lView[RENDERER];
        var parentRNode = getParentRElement(tView, tProjectionNode, lView);
        var parentTNode = tProjectionNode.parent || lView[T_HOST];
        var beforeNode = getInsertInFrontOfRNode(parentTNode, tProjectionNode, lView);
        applyProjectionRecursive(renderer, 0 /* Create */, lView, tProjectionNode, parentRNode, beforeNode);
    }
    /**
     * `applyProjectionRecursive` performs operation on the projection specified by `action` (insert,
     * detach, destroy)
     *
     * Inserting a projection requires us to locate the projected nodes from the parent component. The
     * complication is that those nodes themselves could be re-projected from their parent component.
     *
     * @param renderer Render to use
     * @param action action to perform (insert, detach, destroy)
     * @param lView The LView which needs to be inserted, detached, destroyed.
     * @param tProjectionNode node to project
     * @param parentRElement parent DOM element for insertion/removal.
     * @param beforeNode Before which node the insertions should happen.
     */
    function applyProjectionRecursive(renderer, action, lView, tProjectionNode, parentRElement, beforeNode) {
        var componentLView = lView[DECLARATION_COMPONENT_VIEW];
        var componentNode = componentLView[T_HOST];
        ngDevMode &&
            assertEqual(typeof tProjectionNode.projection, 'number', 'expecting projection index');
        var nodeToProjectOrRNodes = componentNode.projection[tProjectionNode.projection];
        if (Array.isArray(nodeToProjectOrRNodes)) {
            // This should not exist, it is a bit of a hack. When we bootstrap a top level node and we
            // need to support passing projectable nodes, so we cheat and put them in the TNode
            // of the Host TView. (Yes we put instance info at the T Level). We can get away with it
            // because we know that that TView is not shared and therefore it will not be a problem.
            // This should be refactored and cleaned up.
            for (var i = 0; i < nodeToProjectOrRNodes.length; i++) {
                var rNode = nodeToProjectOrRNodes[i];
                applyToElementOrContainer(action, renderer, parentRElement, rNode, beforeNode);
            }
        }
        else {
            var nodeToProject = nodeToProjectOrRNodes;
            var projectedComponentLView = componentLView[PARENT];
            applyNodes(renderer, action, nodeToProject, projectedComponentLView, parentRElement, beforeNode, true);
        }
    }
    /**
     * `applyContainer` performs an operation on the container and its views as specified by
     * `action` (insert, detach, destroy)
     *
     * Inserting a Container is complicated by the fact that the container may have Views which
     * themselves have containers or projections.
     *
     * @param renderer Renderer to use
     * @param action action to perform (insert, detach, destroy)
     * @param lContainer The LContainer which needs to be inserted, detached, destroyed.
     * @param parentRElement parent DOM element for insertion/removal.
     * @param beforeNode Before which node the insertions should happen.
     */
    function applyContainer(renderer, action, lContainer, parentRElement, beforeNode) {
        ngDevMode && assertLContainer(lContainer);
        var anchor = lContainer[NATIVE]; // LContainer has its own before node.
        var native = unwrapRNode(lContainer);
        // An LContainer can be created dynamically on any node by injecting ViewContainerRef.
        // Asking for a ViewContainerRef on an element will result in a creation of a separate anchor
        // node (comment in the DOM) that will be different from the LContainer's host node. In this
        // particular case we need to execute action on 2 nodes:
        // - container's host node (this is done in the executeActionOnElementOrContainer)
        // - container's host node (this is done here)
        if (anchor !== native) {
            // This is very strange to me (Misko). I would expect that the native is same as anchor. I
            // don't see a reason why they should be different, but they are.
            //
            // If they are we need to process the second anchor as well.
            applyToElementOrContainer(action, renderer, parentRElement, anchor, beforeNode);
        }
        for (var i = CONTAINER_HEADER_OFFSET; i < lContainer.length; i++) {
            var lView = lContainer[i];
            applyView(lView[TVIEW], lView, renderer, action, parentRElement, anchor);
        }
    }
    /**
     * Writes class/style to element.
     *
     * @param renderer Renderer to use.
     * @param isClassBased `true` if it should be written to `class` (`false` to write to `style`)
     * @param rNode The Node to write to.
     * @param prop Property to write to. This would be the class/style name.
     * @param value Value to write. If `null`/`undefined`/`false` this is considered a remove (set/add
     *        otherwise).
     */
    function applyStyling(renderer, isClassBased, rNode, prop, value) {
        var isProcedural = isProceduralRenderer(renderer);
        if (isClassBased) {
            // We actually want JS true/false here because any truthy value should add the class
            if (!value) {
                ngDevMode && ngDevMode.rendererRemoveClass++;
                if (isProcedural) {
                    renderer.removeClass(rNode, prop);
                }
                else {
                    rNode.classList.remove(prop);
                }
            }
            else {
                ngDevMode && ngDevMode.rendererAddClass++;
                if (isProcedural) {
                    renderer.addClass(rNode, prop);
                }
                else {
                    ngDevMode && assertDefined(rNode.classList, 'HTMLElement expected');
                    rNode.classList.add(prop);
                }
            }
        }
        else {
            var flags = prop.indexOf('-') === -1 ? undefined : exports.RendererStyleFlags2.DashCase;
            if (value == null /** || value === undefined */) {
                ngDevMode && ngDevMode.rendererRemoveStyle++;
                if (isProcedural) {
                    renderer.removeStyle(rNode, prop, flags);
                }
                else {
                    rNode.style.removeProperty(prop);
                }
            }
            else {
                // A value is important if it ends with `!important`. The style
                // parser strips any semicolons at the end of the value.
                var isImportant = typeof value === 'string' ? value.endsWith('!important') : false;
                if (isImportant) {
                    // !important has to be stripped from the value for it to be valid.
                    value = value.slice(0, -10);
                    flags |= exports.RendererStyleFlags2.Important;
                }
                ngDevMode && ngDevMode.rendererSetStyle++;
                if (isProcedural) {
                    renderer.setStyle(rNode, prop, value, flags);
                }
                else {
                    ngDevMode && assertDefined(rNode.style, 'HTMLElement expected');
                    rNode.style.setProperty(prop, value, isImportant ? 'important' : '');
                }
            }
        }
    }
    /**
     * Write `cssText` to `RElement`.
     *
     * This function does direct write without any reconciliation. Used for writing initial values, so
     * that static styling values do not pull in the style parser.
     *
     * @param renderer Renderer to use
     * @param element The element which needs to be updated.
     * @param newValue The new class list to write.
     */
    function writeDirectStyle(renderer, element, newValue) {
        ngDevMode && assertString(newValue, '\'newValue\' should be a string');
        if (isProceduralRenderer(renderer)) {
            renderer.setAttribute(element, 'style', newValue);
        }
        else {
            element.style.cssText = newValue;
        }
        ngDevMode && ngDevMode.rendererSetStyle++;
    }
    /**
     * Write `className` to `RElement`.
     *
     * This function does direct write without any reconciliation. Used for writing initial values, so
     * that static styling values do not pull in the style parser.
     *
     * @param renderer Renderer to use
     * @param element The element which needs to be updated.
     * @param newValue The new class list to write.
     */
    function writeDirectClass(renderer, element, newValue) {
        ngDevMode && assertString(newValue, '\'newValue\' should be a string');
        if (isProceduralRenderer(renderer)) {
            if (newValue === '') {
                // There are tests in `google3` which expect `element.getAttribute('class')` to be `null`.
                renderer.removeAttribute(element, 'class');
            }
            else {
                renderer.setAttribute(element, 'class', newValue);
            }
        }
        else {
            element.className = newValue;
        }
        ngDevMode && ngDevMode.rendererSetClassName++;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Returns an index of `classToSearch` in `className` taking token boundaries into account.
     *
     * `classIndexOf('AB A', 'A', 0)` will be 3 (not 0 since `AB!==A`)
     *
     * @param className A string containing classes (whitespace separated)
     * @param classToSearch A class name to locate
     * @param startingIndex Starting location of search
     * @returns an index of the located class (or -1 if not found)
     */
    function classIndexOf(className, classToSearch, startingIndex) {
        ngDevMode && assertNotEqual(classToSearch, '', 'can not look for "" string.');
        var end = className.length;
        while (true) {
            var foundIndex = className.indexOf(classToSearch, startingIndex);
            if (foundIndex === -1)
                return foundIndex;
            if (foundIndex === 0 || className.charCodeAt(foundIndex - 1) <= 32 /* SPACE */) {
                // Ensure that it has leading whitespace
                var length = classToSearch.length;
                if (foundIndex + length === end ||
                    className.charCodeAt(foundIndex + length) <= 32 /* SPACE */) {
                    // Ensure that it has trailing whitespace
                    return foundIndex;
                }
            }
            // False positive, keep searching from where we left off.
            startingIndex = foundIndex + 1;
        }
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var unusedValueToPlacateAjd$1 = unusedValueExportToPlacateAjd$4 + unusedValueExportToPlacateAjd$5;
    var NG_TEMPLATE_SELECTOR = 'ng-template';
    /**
     * Search the `TAttributes` to see if it contains `cssClassToMatch` (case insensitive)
     *
     * @param attrs `TAttributes` to search through.
     * @param cssClassToMatch class to match (lowercase)
     * @param isProjectionMode Whether or not class matching should look into the attribute `class` in
     *    addition to the `AttributeMarker.Classes`.
     */
    function isCssClassMatching(attrs, cssClassToMatch, isProjectionMode) {
        // TODO(misko): The fact that this function needs to know about `isProjectionMode` seems suspect.
        // It is strange to me that sometimes the class information comes in form of `class` attribute
        // and sometimes in form of `AttributeMarker.Classes`. Some investigation is needed to determine
        // if that is the right behavior.
        ngDevMode &&
            assertEqual(cssClassToMatch, cssClassToMatch.toLowerCase(), 'Class name expected to be lowercase.');
        var i = 0;
        while (i < attrs.length) {
            var item = attrs[i++];
            if (isProjectionMode && item === 'class') {
                item = attrs[i];
                if (classIndexOf(item.toLowerCase(), cssClassToMatch, 0) !== -1) {
                    return true;
                }
            }
            else if (item === 1 /* Classes */) {
                // We found the classes section. Start searching for the class.
                while (i < attrs.length && typeof (item = attrs[i++]) == 'string') {
                    // while we have strings
                    if (item.toLowerCase() === cssClassToMatch)
                        return true;
                }
                return false;
            }
        }
        return false;
    }
    /**
     * Checks whether the `tNode` represents an inline template (e.g. `*ngFor`).
     *
     * @param tNode current TNode
     */
    function isInlineTemplate(tNode) {
        return tNode.type === 4 /* Container */ && tNode.value !== NG_TEMPLATE_SELECTOR;
    }
    /**
     * Function that checks whether a given tNode matches tag-based selector and has a valid type.
     *
     * Matching can be performed in 2 modes: projection mode (when we project nodes) and regular
     * directive matching mode:
     * - in the "directive matching" mode we do _not_ take TContainer's tagName into account if it is
     * different from NG_TEMPLATE_SELECTOR (value different from NG_TEMPLATE_SELECTOR indicates that a
     * tag name was extracted from * syntax so we would match the same directive twice);
     * - in the "projection" mode, we use a tag name potentially extracted from the * syntax processing
     * (applicable to TNodeType.Container only).
     */
    function hasTagAndTypeMatch(tNode, currentSelector, isProjectionMode) {
        var tagNameToCompare = tNode.type === 4 /* Container */ && !isProjectionMode ? NG_TEMPLATE_SELECTOR : tNode.value;
        return currentSelector === tagNameToCompare;
    }
    /**
     * A utility function to match an Ivy node static data against a simple CSS selector
     *
     * @param node static data of the node to match
     * @param selector The selector to try matching against the node.
     * @param isProjectionMode if `true` we are matching for content projection, otherwise we are doing
     * directive matching.
     * @returns true if node matches the selector.
     */
    function isNodeMatchingSelector(tNode, selector, isProjectionMode) {
        ngDevMode && assertDefined(selector[0], 'Selector should have a tag name');
        var mode = 4 /* ELEMENT */;
        var nodeAttrs = tNode.attrs || [];
        // Find the index of first attribute that has no value, only a name.
        var nameOnlyMarkerIdx = getNameOnlyMarkerIndex(nodeAttrs);
        // When processing ":not" selectors, we skip to the next ":not" if the
        // current one doesn't match
        var skipToNextSelector = false;
        for (var i = 0; i < selector.length; i++) {
            var current = selector[i];
            if (typeof current === 'number') {
                // If we finish processing a :not selector and it hasn't failed, return false
                if (!skipToNextSelector && !isPositive(mode) && !isPositive(current)) {
                    return false;
                }
                // If we are skipping to the next :not() and this mode flag is positive,
                // it's a part of the current :not() selector, and we should keep skipping
                if (skipToNextSelector && isPositive(current))
                    continue;
                skipToNextSelector = false;
                mode = current | (mode & 1 /* NOT */);
                continue;
            }
            if (skipToNextSelector)
                continue;
            if (mode & 4 /* ELEMENT */) {
                mode = 2 /* ATTRIBUTE */ | mode & 1 /* NOT */;
                if (current !== '' && !hasTagAndTypeMatch(tNode, current, isProjectionMode) ||
                    current === '' && selector.length === 1) {
                    if (isPositive(mode))
                        return false;
                    skipToNextSelector = true;
                }
            }
            else {
                var selectorAttrValue = mode & 8 /* CLASS */ ? current : selector[++i];
                // special case for matching against classes when a tNode has been instantiated with
                // class and style values as separate attribute values (e.g. ['title', CLASS, 'foo'])
                if ((mode & 8 /* CLASS */) && tNode.attrs !== null) {
                    if (!isCssClassMatching(tNode.attrs, selectorAttrValue, isProjectionMode)) {
                        if (isPositive(mode))
                            return false;
                        skipToNextSelector = true;
                    }
                    continue;
                }
                var attrName = (mode & 8 /* CLASS */) ? 'class' : current;
                var attrIndexInNode = findAttrIndexInNode(attrName, nodeAttrs, isInlineTemplate(tNode), isProjectionMode);
                if (attrIndexInNode === -1) {
                    if (isPositive(mode))
                        return false;
                    skipToNextSelector = true;
                    continue;
                }
                if (selectorAttrValue !== '') {
                    var nodeAttrValue = void 0;
                    if (attrIndexInNode > nameOnlyMarkerIdx) {
                        nodeAttrValue = '';
                    }
                    else {
                        ngDevMode &&
                            assertNotEqual(nodeAttrs[attrIndexInNode], 0 /* NamespaceURI */, 'We do not match directives on namespaced attributes');
                        // we lowercase the attribute value to be able to match
                        // selectors without case-sensitivity
                        // (selectors are already in lowercase when generated)
                        nodeAttrValue = nodeAttrs[attrIndexInNode + 1].toLowerCase();
                    }
                    var compareAgainstClassName = mode & 8 /* CLASS */ ? nodeAttrValue : null;
                    if (compareAgainstClassName &&
                        classIndexOf(compareAgainstClassName, selectorAttrValue, 0) !== -1 ||
                        mode & 2 /* ATTRIBUTE */ && selectorAttrValue !== nodeAttrValue) {
                        if (isPositive(mode))
                            return false;
                        skipToNextSelector = true;
                    }
                }
            }
        }
        return isPositive(mode) || skipToNextSelector;
    }
    function isPositive(mode) {
        return (mode & 1 /* NOT */) === 0;
    }
    /**
     * Examines the attribute's definition array for a node to find the index of the
     * attribute that matches the given `name`.
     *
     * NOTE: This will not match namespaced attributes.
     *
     * Attribute matching depends upon `isInlineTemplate` and `isProjectionMode`.
     * The following table summarizes which types of attributes we attempt to match:
     *
     * ===========================================================================================================
     * Modes                   | Normal Attributes | Bindings Attributes | Template Attributes | I18n
     * Attributes
     * ===========================================================================================================
     * Inline + Projection     | YES               | YES                 | NO                  | YES
     * -----------------------------------------------------------------------------------------------------------
     * Inline + Directive      | NO                | NO                  | YES                 | NO
     * -----------------------------------------------------------------------------------------------------------
     * Non-inline + Projection | YES               | YES                 | NO                  | YES
     * -----------------------------------------------------------------------------------------------------------
     * Non-inline + Directive  | YES               | YES                 | NO                  | YES
     * ===========================================================================================================
     *
     * @param name the name of the attribute to find
     * @param attrs the attribute array to examine
     * @param isInlineTemplate true if the node being matched is an inline template (e.g. `*ngFor`)
     * rather than a manually expanded template node (e.g `<ng-template>`).
     * @param isProjectionMode true if we are matching against content projection otherwise we are
     * matching against directives.
     */
    function findAttrIndexInNode(name, attrs, isInlineTemplate, isProjectionMode) {
        if (attrs === null)
            return -1;
        var i = 0;
        if (isProjectionMode || !isInlineTemplate) {
            var bindingsMode = false;
            while (i < attrs.length) {
                var maybeAttrName = attrs[i];
                if (maybeAttrName === name) {
                    return i;
                }
                else if (maybeAttrName === 3 /* Bindings */ || maybeAttrName === 6 /* I18n */) {
                    bindingsMode = true;
                }
                else if (maybeAttrName === 1 /* Classes */ || maybeAttrName === 2 /* Styles */) {
                    var value = attrs[++i];
                    // We should skip classes here because we have a separate mechanism for
                    // matching classes in projection mode.
                    while (typeof value === 'string') {
                        value = attrs[++i];
                    }
                    continue;
                }
                else if (maybeAttrName === 4 /* Template */) {
                    // We do not care about Template attributes in this scenario.
                    break;
                }
                else if (maybeAttrName === 0 /* NamespaceURI */) {
                    // Skip the whole namespaced attribute and value. This is by design.
                    i += 4;
                    continue;
                }
                // In binding mode there are only names, rather than name-value pairs.
                i += bindingsMode ? 1 : 2;
            }
            // We did not match the attribute
            return -1;
        }
        else {
            return matchTemplateAttribute(attrs, name);
        }
    }
    function isNodeMatchingSelectorList(tNode, selector, isProjectionMode) {
        if (isProjectionMode === void 0) { isProjectionMode = false; }
        for (var i = 0; i < selector.length; i++) {
            if (isNodeMatchingSelector(tNode, selector[i], isProjectionMode)) {
                return true;
            }
        }
        return false;
    }
    function getProjectAsAttrValue(tNode) {
        var nodeAttrs = tNode.attrs;
        if (nodeAttrs != null) {
            var ngProjectAsAttrIdx = nodeAttrs.indexOf(5 /* ProjectAs */);
            // only check for ngProjectAs in attribute names, don't accidentally match attribute's value
            // (attribute names are stored at even indexes)
            if ((ngProjectAsAttrIdx & 1) === 0) {
                return nodeAttrs[ngProjectAsAttrIdx + 1];
            }
        }
        return null;
    }
    function getNameOnlyMarkerIndex(nodeAttrs) {
        for (var i = 0; i < nodeAttrs.length; i++) {
            var nodeAttr = nodeAttrs[i];
            if (isNameOnlyAttributeMarker(nodeAttr)) {
                return i;
            }
        }
        return nodeAttrs.length;
    }
    function matchTemplateAttribute(attrs, name) {
        var i = attrs.indexOf(4 /* Template */);
        if (i > -1) {
            i++;
            while (i < attrs.length) {
                var attr = attrs[i];
                // Return in case we checked all template attrs and are switching to the next section in the
                // attrs array (that starts with a number that represents an attribute marker).
                if (typeof attr === 'number')
                    return -1;
                if (attr === name)
                    return i;
                i++;
            }
        }
        return -1;
    }
    /**
     * Checks whether a selector is inside a CssSelectorList
     * @param selector Selector to be checked.
     * @param list List in which to look for the selector.
     */
    function isSelectorInSelectorList(selector, list) {
        selectorListLoop: for (var i = 0; i < list.length; i++) {
            var currentSelectorInList = list[i];
            if (selector.length !== currentSelectorInList.length) {
                continue;
            }
            for (var j = 0; j < selector.length; j++) {
                if (selector[j] !== currentSelectorInList[j]) {
                    continue selectorListLoop;
                }
            }
            return true;
        }
        return false;
    }
    function maybeWrapInNotSelector(isNegativeMode, chunk) {
        return isNegativeMode ? ':not(' + chunk.trim() + ')' : chunk;
    }
    function stringifyCSSSelector(selector) {
        var result = selector[0];
        var i = 1;
        var mode = 2 /* ATTRIBUTE */;
        var currentChunk = '';
        var isNegativeMode = false;
        while (i < selector.length) {
            var valueOrMarker = selector[i];
            if (typeof valueOrMarker === 'string') {
                if (mode & 2 /* ATTRIBUTE */) {
                    var attrValue = selector[++i];
                    currentChunk +=
                        '[' + valueOrMarker + (attrValue.length > 0 ? '="' + attrValue + '"' : '') + ']';
                }
                else if (mode & 8 /* CLASS */) {
                    currentChunk += '.' + valueOrMarker;
                }
                else if (mode & 4 /* ELEMENT */) {
                    currentChunk += ' ' + valueOrMarker;
                }
            }
            else {
                //
                // Append current chunk to the final result in case we come across SelectorFlag, which
                // indicates that the previous section of a selector is over. We need to accumulate content
                // between flags to make sure we wrap the chunk later in :not() selector if needed, e.g.
                // ```
                //  ['', Flags.CLASS, '.classA', Flags.CLASS | Flags.NOT, '.classB', '.classC']
                // ```
                // should be transformed to `.classA :not(.classB .classC)`.
                //
                // Note: for negative selector part, we accumulate content between flags until we find the
                // next negative flag. This is needed to support a case where `:not()` rule contains more than
                // one chunk, e.g. the following selector:
                // ```
                //  ['', Flags.ELEMENT | Flags.NOT, 'p', Flags.CLASS, 'foo', Flags.CLASS | Flags.NOT, 'bar']
                // ```
                // should be stringified to `:not(p.foo) :not(.bar)`
                //
                if (currentChunk !== '' && !isPositive(valueOrMarker)) {
                    result += maybeWrapInNotSelector(isNegativeMode, currentChunk);
                    currentChunk = '';
                }
                mode = valueOrMarker;
                // According to CssSelector spec, once we come across `SelectorFlags.NOT` flag, the negative
                // mode is maintained for remaining chunks of a selector.
                isNegativeMode = isNegativeMode || !isPositive(mode);
            }
            i++;
        }
        if (currentChunk !== '') {
            result += maybeWrapInNotSelector(isNegativeMode, currentChunk);
        }
        return result;
    }
    /**
     * Generates string representation of CSS selector in parsed form.
     *
     * ComponentDef and DirectiveDef are generated with the selector in parsed form to avoid doing
     * additional parsing at runtime (for example, for directive matching). However in some cases (for
     * example, while bootstrapping a component), a string version of the selector is required to query
     * for the host element on the page. This function takes the parsed form of a selector and returns
     * its string representation.
     *
     * @param selectorList selector in parsed form
     * @returns string representation of a given selector
     */
    function stringifyCSSSelectorList(selectorList) {
        return selectorList.map(stringifyCSSSelector).join(',');
    }
    /**
     * Extracts attributes and classes information from a given CSS selector.
     *
     * This function is used while creating a component dynamically. In this case, the host element
     * (that is created dynamically) should contain attributes and classes specified in component's CSS
     * selector.
     *
     * @param selector CSS selector in parsed form (in a form of array)
     * @returns object with `attrs` and `classes` fields that contain extracted information
     */
    function extractAttrsAndClassesFromSelector(selector) {
        var attrs = [];
        var classes = [];
        var i = 1;
        var mode = 2 /* ATTRIBUTE */;
        while (i < selector.length) {
            var valueOrMarker = selector[i];
            if (typeof valueOrMarker === 'string') {
                if (mode === 2 /* ATTRIBUTE */) {
                    if (valueOrMarker !== '') {
                        attrs.push(valueOrMarker, selector[++i]);
                    }
                }
                else if (mode === 8 /* CLASS */) {
                    classes.push(valueOrMarker);
                }
            }
            else {
                // According to CssSelector spec, once we come across `SelectorFlags.NOT` flag, the negative
                // mode is maintained for remaining chunks of a selector. Since attributes and classes are
                // extracted only for "positive" part of the selector, we can stop here.
                if (!isPositive(mode))
                    break;
                mode = valueOrMarker;
            }
            i++;
        }
        return { attrs: attrs, classes: classes };
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /** A special value which designates that a value has not changed. */
    var NO_CHANGE = (typeof ngDevMode === 'undefined' || ngDevMode) ? { __brand__: 'NO_CHANGE' } : {};

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Advances to an element for later binding instructions.
     *
     * Used in conjunction with instructions like {@link property} to act on elements with specified
     * indices, for example those created with {@link element} or {@link elementStart}.
     *
     * ```ts
     * (rf: RenderFlags, ctx: any) => {
     *   if (rf & 1) {
     *     text(0, 'Hello');
     *     text(1, 'Goodbye')
     *     element(2, 'div');
     *   }
     *   if (rf & 2) {
     *     advance(2); // Advance twice to the <div>.
     *     property('title', 'test');
     *   }
     *  }
     * ```
     * @param delta Number of elements to advance forwards by.
     *
     * @codeGenApi
     */
    function ɵɵadvance(delta) {
        ngDevMode && assertGreaterThan(delta, 0, 'Can only advance forward');
        selectIndexInternal(getTView(), getLView(), getSelectedIndex() + delta, isInCheckNoChangesMode());
    }
    function selectIndexInternal(tView, lView, index, checkNoChangesMode) {
        ngDevMode && assertIndexInDeclRange(lView, index);
        // Flush the initial hooks for elements in the view that have been added up to this point.
        // PERF WARNING: do NOT extract this to a separate function without running benchmarks
        if (!checkNoChangesMode) {
            var hooksInitPhaseCompleted = (lView[FLAGS] & 3 /* InitPhaseStateMask */) === 3 /* InitPhaseCompleted */;
            if (hooksInitPhaseCompleted) {
                var preOrderCheckHooks = tView.preOrderCheckHooks;
                if (preOrderCheckHooks !== null) {
                    executeCheckHooks(lView, preOrderCheckHooks, index);
                }
            }
            else {
                var preOrderHooks = tView.preOrderHooks;
                if (preOrderHooks !== null) {
                    executeInitAndCheckHooks(lView, preOrderHooks, 0 /* OnInitHooksToBeRun */, index);
                }
            }
        }
        // We must set the selected index *after* running the hooks, because hooks may have side-effects
        // that cause other template functions to run, thus updating the selected index, which is global
        // state. If we run `setSelectedIndex` *before* we run the hooks, in some cases the selected index
        // will be altered by the time we leave the `ɵɵadvance` instruction.
        setSelectedIndex(index);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function toTStylingRange(prev, next) {
        ngDevMode && assertNumberInRange(prev, 0, 32767 /* UNSIGNED_MASK */);
        ngDevMode && assertNumberInRange(next, 0, 32767 /* UNSIGNED_MASK */);
        return (prev << 17 /* PREV_SHIFT */ | next << 2 /* NEXT_SHIFT */);
    }
    function getTStylingRangePrev(tStylingRange) {
        ngDevMode && assertNumber(tStylingRange, 'expected number');
        return (tStylingRange >> 17 /* PREV_SHIFT */) & 32767 /* UNSIGNED_MASK */;
    }
    function getTStylingRangePrevDuplicate(tStylingRange) {
        ngDevMode && assertNumber(tStylingRange, 'expected number');
        return (tStylingRange & 2 /* PREV_DUPLICATE */) ==
            2 /* PREV_DUPLICATE */;
    }
    function setTStylingRangePrev(tStylingRange, previous) {
        ngDevMode && assertNumber(tStylingRange, 'expected number');
        ngDevMode && assertNumberInRange(previous, 0, 32767 /* UNSIGNED_MASK */);
        return ((tStylingRange & ~4294836224 /* PREV_MASK */) |
            (previous << 17 /* PREV_SHIFT */));
    }
    function setTStylingRangePrevDuplicate(tStylingRange) {
        ngDevMode && assertNumber(tStylingRange, 'expected number');
        return (tStylingRange | 2 /* PREV_DUPLICATE */);
    }
    function getTStylingRangeNext(tStylingRange) {
        ngDevMode && assertNumber(tStylingRange, 'expected number');
        return (tStylingRange & 131068 /* NEXT_MASK */) >> 2 /* NEXT_SHIFT */;
    }
    function setTStylingRangeNext(tStylingRange, next) {
        ngDevMode && assertNumber(tStylingRange, 'expected number');
        ngDevMode && assertNumberInRange(next, 0, 32767 /* UNSIGNED_MASK */);
        return ((tStylingRange & ~131068 /* NEXT_MASK */) | //
            next << 2 /* NEXT_SHIFT */);
    }
    function getTStylingRangeNextDuplicate(tStylingRange) {
        ngDevMode && assertNumber(tStylingRange, 'expected number');
        return (tStylingRange & 1 /* NEXT_DUPLICATE */) ===
            1 /* NEXT_DUPLICATE */;
    }
    function setTStylingRangeNextDuplicate(tStylingRange) {
        ngDevMode && assertNumber(tStylingRange, 'expected number');
        return (tStylingRange | 1 /* NEXT_DUPLICATE */);
    }
    function getTStylingRangeTail(tStylingRange) {
        ngDevMode && assertNumber(tStylingRange, 'expected number');
        var next = getTStylingRangeNext(tStylingRange);
        return next === 0 ? getTStylingRangePrev(tStylingRange) : next;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Patch a `debug` property on top of the existing object.
     *
     * NOTE: always call this method with `ngDevMode && attachDebugObject(...)`
     *
     * @param obj Object to patch
     * @param debug Value to patch
     */
    function attachDebugObject(obj, debug) {
        if (ngDevMode) {
            Object.defineProperty(obj, 'debug', { value: debug, enumerable: false });
        }
        else {
            throw new Error('This method should be guarded with `ngDevMode` so that it can be tree shaken in production!');
        }
    }
    /**
     * Patch a `debug` property getter on top of the existing object.
     *
     * NOTE: always call this method with `ngDevMode && attachDebugObject(...)`
     *
     * @param obj Object to patch
     * @param debugGetter Getter returning a value to patch
     */
    function attachDebugGetter(obj, debugGetter) {
        if (ngDevMode) {
            Object.defineProperty(obj, 'debug', { get: debugGetter, enumerable: false });
        }
        else {
            throw new Error('This method should be guarded with `ngDevMode` so that it can be tree shaken in production!');
        }
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var NG_DEV_MODE = ((typeof ngDevMode === 'undefined' || !!ngDevMode) && initNgDevMode());
    /*
     * This file contains conditionally attached classes which provide human readable (debug) level
     * information for `LView`, `LContainer` and other internal data structures. These data structures
     * are stored internally as array which makes it very difficult during debugging to reason about the
     * current state of the system.
     *
     * Patching the array with extra property does change the array's hidden class' but it does not
     * change the cost of access, therefore this patching should not have significant if any impact in
     * `ngDevMode` mode. (see: https://jsperf.com/array-vs-monkey-patch-array)
     *
     * So instead of seeing:
     * ```
     * Array(30) [Object, 659, null, …]
     * ```
     *
     * You get to see:
     * ```
     * LViewDebug {
     *   views: [...],
     *   flags: {attached: true, ...}
     *   nodes: [
     *     {html: '<div id="123">', ..., nodes: [
     *       {html: '<span>', ..., nodes: null}
     *     ]}
     *   ]
     * }
     * ```
     */
    var LVIEW_COMPONENT_CACHE;
    var LVIEW_EMBEDDED_CACHE;
    var LVIEW_ROOT;
    /**
     * This function clones a blueprint and creates LView.
     *
     * Simple slice will keep the same type, and we need it to be LView
     */
    function cloneToLViewFromTViewBlueprint(tView) {
        var debugTView = tView;
        var lView = getLViewToClone(debugTView.type, tView.template && tView.template.name);
        return lView.concat(tView.blueprint);
    }
    function getLViewToClone(type, name) {
        switch (type) {
            case 0 /* Root */:
                if (LVIEW_ROOT === undefined)
                    LVIEW_ROOT = new (createNamedArrayType('LRootView'))();
                return LVIEW_ROOT;
            case 1 /* Component */:
                if (LVIEW_COMPONENT_CACHE === undefined)
                    LVIEW_COMPONENT_CACHE = new Map();
                var componentArray = LVIEW_COMPONENT_CACHE.get(name);
                if (componentArray === undefined) {
                    componentArray = new (createNamedArrayType('LComponentView' + nameSuffix(name)))();
                    LVIEW_COMPONENT_CACHE.set(name, componentArray);
                }
                return componentArray;
            case 2 /* Embedded */:
                if (LVIEW_EMBEDDED_CACHE === undefined)
                    LVIEW_EMBEDDED_CACHE = new Map();
                var embeddedArray = LVIEW_EMBEDDED_CACHE.get(name);
                if (embeddedArray === undefined) {
                    embeddedArray = new (createNamedArrayType('LEmbeddedView' + nameSuffix(name)))();
                    LVIEW_EMBEDDED_CACHE.set(name, embeddedArray);
                }
                return embeddedArray;
        }
    }
    function nameSuffix(text) {
        if (text == null)
            return '';
        var index = text.lastIndexOf('_Template');
        return '_' + (index === -1 ? text : text.substr(0, index));
    }
    /**
     * This class is a debug version of Object literal so that we can have constructor name show up
     * in
     * debug tools in ngDevMode.
     */
    var TViewConstructor = /** @class */ (function () {
        function TView(type, blueprint, template, queries, viewQuery, declTNode, data, bindingStartIndex, expandoStartIndex, hostBindingOpCodes, firstCreatePass, firstUpdatePass, staticViewQueries, staticContentQueries, preOrderHooks, preOrderCheckHooks, contentHooks, contentCheckHooks, viewHooks, viewCheckHooks, destroyHooks, cleanup, contentQueries, components, directiveRegistry, pipeRegistry, firstChild, schemas, consts, incompleteFirstPass, _decls, _vars) {
            this.type = type;
            this.blueprint = blueprint;
            this.template = template;
            this.queries = queries;
            this.viewQuery = viewQuery;
            this.declTNode = declTNode;
            this.data = data;
            this.bindingStartIndex = bindingStartIndex;
            this.expandoStartIndex = expandoStartIndex;
            this.hostBindingOpCodes = hostBindingOpCodes;
            this.firstCreatePass = firstCreatePass;
            this.firstUpdatePass = firstUpdatePass;
            this.staticViewQueries = staticViewQueries;
            this.staticContentQueries = staticContentQueries;
            this.preOrderHooks = preOrderHooks;
            this.preOrderCheckHooks = preOrderCheckHooks;
            this.contentHooks = contentHooks;
            this.contentCheckHooks = contentCheckHooks;
            this.viewHooks = viewHooks;
            this.viewCheckHooks = viewCheckHooks;
            this.destroyHooks = destroyHooks;
            this.cleanup = cleanup;
            this.contentQueries = contentQueries;
            this.components = components;
            this.directiveRegistry = directiveRegistry;
            this.pipeRegistry = pipeRegistry;
            this.firstChild = firstChild;
            this.schemas = schemas;
            this.consts = consts;
            this.incompleteFirstPass = incompleteFirstPass;
            this._decls = _decls;
            this._vars = _vars;
        }
        Object.defineProperty(TView.prototype, "template_", {
            get: function () {
                var buf = [];
                processTNodeChildren(this.firstChild, buf);
                return buf.join('');
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(TView.prototype, "type_", {
            get: function () {
                return TViewTypeAsString[this.type] || "TViewType.?" + this.type + "?";
            },
            enumerable: false,
            configurable: true
        });
        return TView;
    }());
    var TNode = /** @class */ (function () {
        function TNode(tView_, //
        type, //
        index, //
        insertBeforeIndex, //
        injectorIndex, //
        directiveStart, //
        directiveEnd, //
        directiveStylingLast, //
        propertyBindings, //
        flags, //
        providerIndexes, //
        value, //
        attrs, //
        mergedAttrs, //
        localNames, //
        initialInputs, //
        inputs, //
        outputs, //
        tViews, //
        next, //
        projectionNext, //
        child, //
        parent, //
        projection, //
        styles, //
        stylesWithoutHost, //
        residualStyles, //
        classes, //
        classesWithoutHost, //
        residualClasses, //
        classBindings, //
        styleBindings) {
            this.tView_ = tView_;
            this.type = type;
            this.index = index;
            this.insertBeforeIndex = insertBeforeIndex;
            this.injectorIndex = injectorIndex;
            this.directiveStart = directiveStart;
            this.directiveEnd = directiveEnd;
            this.directiveStylingLast = directiveStylingLast;
            this.propertyBindings = propertyBindings;
            this.flags = flags;
            this.providerIndexes = providerIndexes;
            this.value = value;
            this.attrs = attrs;
            this.mergedAttrs = mergedAttrs;
            this.localNames = localNames;
            this.initialInputs = initialInputs;
            this.inputs = inputs;
            this.outputs = outputs;
            this.tViews = tViews;
            this.next = next;
            this.projectionNext = projectionNext;
            this.child = child;
            this.parent = parent;
            this.projection = projection;
            this.styles = styles;
            this.stylesWithoutHost = stylesWithoutHost;
            this.residualStyles = residualStyles;
            this.classes = classes;
            this.classesWithoutHost = classesWithoutHost;
            this.residualClasses = residualClasses;
            this.classBindings = classBindings;
            this.styleBindings = styleBindings;
        }
        /**
         * Return a human debug version of the set of `NodeInjector`s which will be consulted when
         * resolving tokens from this `TNode`.
         *
         * When debugging applications, it is often difficult to determine which `NodeInjector`s will be
         * consulted. This method shows a list of `DebugNode`s representing the `TNode`s which will be
         * consulted in order when resolving a token starting at this `TNode`.
         *
         * The original data is stored in `LView` and `TView` with a lot of offset indexes, and so it is
         * difficult to reason about.
         *
         * @param lView The `LView` instance for this `TNode`.
         */
        TNode.prototype.debugNodeInjectorPath = function (lView) {
            var path = [];
            var injectorIndex = getInjectorIndex(this, lView);
            if (injectorIndex === -1) {
                // Looks like the current `TNode` does not have `NodeInjector` associated with it => look for
                // parent NodeInjector.
                var parentLocation = getParentInjectorLocation(this, lView);
                if (parentLocation !== NO_PARENT_INJECTOR) {
                    // We found a parent, so start searching from the parent location.
                    injectorIndex = getParentInjectorIndex(parentLocation);
                    lView = getParentInjectorView(parentLocation, lView);
                }
                else {
                    // No parents have been found, so there are no `NodeInjector`s to consult.
                }
            }
            while (injectorIndex !== -1) {
                ngDevMode && assertNodeInjector(lView, injectorIndex);
                var tNode = lView[TVIEW].data[injectorIndex + 8 /* TNODE */];
                path.push(buildDebugNode(tNode, lView));
                var parentLocation = lView[injectorIndex + 8 /* PARENT */];
                if (parentLocation === NO_PARENT_INJECTOR) {
                    injectorIndex = -1;
                }
                else {
                    injectorIndex = getParentInjectorIndex(parentLocation);
                    lView = getParentInjectorView(parentLocation, lView);
                }
            }
            return path;
        };
        Object.defineProperty(TNode.prototype, "type_", {
            get: function () {
                return toTNodeTypeAsString(this.type) || "TNodeType.?" + this.type + "?";
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(TNode.prototype, "flags_", {
            get: function () {
                var flags = [];
                if (this.flags & 16 /* hasClassInput */)
                    flags.push('TNodeFlags.hasClassInput');
                if (this.flags & 8 /* hasContentQuery */)
                    flags.push('TNodeFlags.hasContentQuery');
                if (this.flags & 32 /* hasStyleInput */)
                    flags.push('TNodeFlags.hasStyleInput');
                if (this.flags & 128 /* hasHostBindings */)
                    flags.push('TNodeFlags.hasHostBindings');
                if (this.flags & 2 /* isComponentHost */)
                    flags.push('TNodeFlags.isComponentHost');
                if (this.flags & 1 /* isDirectiveHost */)
                    flags.push('TNodeFlags.isDirectiveHost');
                if (this.flags & 64 /* isDetached */)
                    flags.push('TNodeFlags.isDetached');
                if (this.flags & 4 /* isProjected */)
                    flags.push('TNodeFlags.isProjected');
                return flags.join('|');
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(TNode.prototype, "template_", {
            get: function () {
                if (this.type & 1 /* Text */)
                    return this.value;
                var buf = [];
                var tagName = typeof this.value === 'string' && this.value || this.type_;
                buf.push('<', tagName);
                if (this.flags) {
                    buf.push(' ', this.flags_);
                }
                if (this.attrs) {
                    for (var i = 0; i < this.attrs.length;) {
                        var attrName = this.attrs[i++];
                        if (typeof attrName == 'number') {
                            break;
                        }
                        var attrValue = this.attrs[i++];
                        buf.push(' ', attrName, '="', attrValue, '"');
                    }
                }
                buf.push('>');
                processTNodeChildren(this.child, buf);
                buf.push('</', tagName, '>');
                return buf.join('');
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(TNode.prototype, "styleBindings_", {
            get: function () {
                return toDebugStyleBinding(this, false);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(TNode.prototype, "classBindings_", {
            get: function () {
                return toDebugStyleBinding(this, true);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(TNode.prototype, "providerIndexStart_", {
            get: function () {
                return this.providerIndexes & 1048575 /* ProvidersStartIndexMask */;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(TNode.prototype, "providerIndexEnd_", {
            get: function () {
                return this.providerIndexStart_ +
                    (this.providerIndexes >>> 20 /* CptViewProvidersCountShift */);
            },
            enumerable: false,
            configurable: true
        });
        return TNode;
    }());
    var TNodeDebug = TNode;
    function toDebugStyleBinding(tNode, isClassBased) {
        var tData = tNode.tView_.data;
        var bindings = [];
        var range = isClassBased ? tNode.classBindings : tNode.styleBindings;
        var prev = getTStylingRangePrev(range);
        var next = getTStylingRangeNext(range);
        var isTemplate = next !== 0;
        var cursor = isTemplate ? next : prev;
        while (cursor !== 0) {
            var itemKey = tData[cursor];
            var itemRange = tData[cursor + 1];
            bindings.unshift({
                key: itemKey,
                index: cursor,
                isTemplate: isTemplate,
                prevDuplicate: getTStylingRangePrevDuplicate(itemRange),
                nextDuplicate: getTStylingRangeNextDuplicate(itemRange),
                nextIndex: getTStylingRangeNext(itemRange),
                prevIndex: getTStylingRangePrev(itemRange),
            });
            if (cursor === prev)
                isTemplate = false;
            cursor = getTStylingRangePrev(itemRange);
        }
        bindings.push((isClassBased ? tNode.residualClasses : tNode.residualStyles) || null);
        return bindings;
    }
    function processTNodeChildren(tNode, buf) {
        while (tNode) {
            buf.push(tNode.template_);
            tNode = tNode.next;
        }
    }
    var TViewData = NG_DEV_MODE && createNamedArrayType('TViewData') || null;
    var TVIEWDATA_EMPTY; // can't initialize here or it will not be tree shaken, because
    // `LView` constructor could have side-effects.
    /**
     * This function clones a blueprint and creates TData.
     *
     * Simple slice will keep the same type, and we need it to be TData
     */
    function cloneToTViewData(list) {
        if (TVIEWDATA_EMPTY === undefined)
            TVIEWDATA_EMPTY = new TViewData();
        return TVIEWDATA_EMPTY.concat(list);
    }
    var LViewBlueprint = NG_DEV_MODE && createNamedArrayType('LViewBlueprint') || null;
    var MatchesArray = NG_DEV_MODE && createNamedArrayType('MatchesArray') || null;
    var TViewComponents = NG_DEV_MODE && createNamedArrayType('TViewComponents') || null;
    var TNodeLocalNames = NG_DEV_MODE && createNamedArrayType('TNodeLocalNames') || null;
    var TNodeInitialInputs = NG_DEV_MODE && createNamedArrayType('TNodeInitialInputs') || null;
    var TNodeInitialData = NG_DEV_MODE && createNamedArrayType('TNodeInitialData') || null;
    var LCleanup = NG_DEV_MODE && createNamedArrayType('LCleanup') || null;
    var TCleanup = NG_DEV_MODE && createNamedArrayType('TCleanup') || null;
    function attachLViewDebug(lView) {
        attachDebugObject(lView, new LViewDebug(lView));
    }
    function attachLContainerDebug(lContainer) {
        attachDebugObject(lContainer, new LContainerDebug(lContainer));
    }
    function toDebug(obj) {
        if (obj) {
            var debug = obj.debug;
            assertDefined(debug, 'Object does not have a debug representation.');
            return debug;
        }
        else {
            return obj;
        }
    }
    /**
     * Use this method to unwrap a native element in `LView` and convert it into HTML for easier
     * reading.
     *
     * @param value possibly wrapped native DOM node.
     * @param includeChildren If `true` then the serialized HTML form will include child elements
     * (same
     * as `outerHTML`). If `false` then the serialized HTML form will only contain the element
     * itself
     * (will not serialize child elements).
     */
    function toHtml(value, includeChildren) {
        if (includeChildren === void 0) { includeChildren = false; }
        var node = unwrapRNode(value);
        if (node) {
            switch (node.nodeType) {
                case Node.TEXT_NODE:
                    return node.textContent;
                case Node.COMMENT_NODE:
                    return "<!--" + node.textContent + "-->";
                case Node.ELEMENT_NODE:
                    var outerHTML = node.outerHTML;
                    if (includeChildren) {
                        return outerHTML;
                    }
                    else {
                        var innerHTML = '>' + node.innerHTML + '<';
                        return (outerHTML.split(innerHTML)[0]) + '>';
                    }
            }
        }
        return null;
    }
    var LViewDebug = /** @class */ (function () {
        function LViewDebug(_raw_lView) {
            this._raw_lView = _raw_lView;
        }
        Object.defineProperty(LViewDebug.prototype, "flags", {
            /**
             * Flags associated with the `LView` unpacked into a more readable state.
             */
            get: function () {
                var flags = this._raw_lView[FLAGS];
                return {
                    __raw__flags__: flags,
                    initPhaseState: flags & 3 /* InitPhaseStateMask */,
                    creationMode: !!(flags & 4 /* CreationMode */),
                    firstViewPass: !!(flags & 8 /* FirstLViewPass */),
                    checkAlways: !!(flags & 16 /* CheckAlways */),
                    dirty: !!(flags & 64 /* Dirty */),
                    attached: !!(flags & 128 /* Attached */),
                    destroyed: !!(flags & 256 /* Destroyed */),
                    isRoot: !!(flags & 512 /* IsRoot */),
                    indexWithinInitPhase: flags >> 11 /* IndexWithinInitPhaseShift */,
                };
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "parent", {
            get: function () {
                return toDebug(this._raw_lView[PARENT]);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "hostHTML", {
            get: function () {
                return toHtml(this._raw_lView[HOST], true);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "html", {
            get: function () {
                return (this.nodes || []).map(mapToHTML).join('');
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "context", {
            get: function () {
                return this._raw_lView[CONTEXT];
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "nodes", {
            /**
             * The tree of nodes associated with the current `LView`. The nodes have been normalized into
             * a tree structure with relevant details pulled out for readability.
             */
            get: function () {
                var lView = this._raw_lView;
                var tNode = lView[TVIEW].firstChild;
                return toDebugNodes(tNode, lView);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "template", {
            get: function () {
                return this.tView.template_;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "tView", {
            get: function () {
                return this._raw_lView[TVIEW];
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "cleanup", {
            get: function () {
                return this._raw_lView[CLEANUP];
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "injector", {
            get: function () {
                return this._raw_lView[INJECTOR];
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "rendererFactory", {
            get: function () {
                return this._raw_lView[RENDERER_FACTORY];
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "renderer", {
            get: function () {
                return this._raw_lView[RENDERER];
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "sanitizer", {
            get: function () {
                return this._raw_lView[SANITIZER];
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "childHead", {
            get: function () {
                return toDebug(this._raw_lView[CHILD_HEAD]);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "next", {
            get: function () {
                return toDebug(this._raw_lView[NEXT]);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "childTail", {
            get: function () {
                return toDebug(this._raw_lView[CHILD_TAIL]);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "declarationView", {
            get: function () {
                return toDebug(this._raw_lView[DECLARATION_VIEW]);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "queries", {
            get: function () {
                return this._raw_lView[QUERIES];
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "tHost", {
            get: function () {
                return this._raw_lView[T_HOST];
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "decls", {
            get: function () {
                return toLViewRange(this.tView, this._raw_lView, HEADER_OFFSET, this.tView.bindingStartIndex);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "vars", {
            get: function () {
                return toLViewRange(this.tView, this._raw_lView, this.tView.bindingStartIndex, this.tView.expandoStartIndex);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "expando", {
            get: function () {
                return toLViewRange(this.tView, this._raw_lView, this.tView.expandoStartIndex, this._raw_lView.length);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LViewDebug.prototype, "childViews", {
            /**
             * Normalized view of child views (and containers) attached at this location.
             */
            get: function () {
                var childViews = [];
                var child = this.childHead;
                while (child) {
                    childViews.push(child);
                    child = child.next;
                }
                return childViews;
            },
            enumerable: false,
            configurable: true
        });
        return LViewDebug;
    }());
    function mapToHTML(node) {
        if (node.type === 'ElementContainer') {
            return (node.children || []).map(mapToHTML).join('');
        }
        else if (node.type === 'IcuContainer') {
            throw new Error('Not implemented');
        }
        else {
            return toHtml(node.native, true) || '';
        }
    }
    function toLViewRange(tView, lView, start, end) {
        var content = [];
        for (var index = start; index < end; index++) {
            content.push({ index: index, t: tView.data[index], l: lView[index] });
        }
        return { start: start, end: end, length: end - start, content: content };
    }
    /**
     * Turns a flat list of nodes into a tree by walking the associated `TNode` tree.
     *
     * @param tNode
     * @param lView
     */
    function toDebugNodes(tNode, lView) {
        if (tNode) {
            var debugNodes = [];
            var tNodeCursor = tNode;
            while (tNodeCursor) {
                debugNodes.push(buildDebugNode(tNodeCursor, lView));
                tNodeCursor = tNodeCursor.next;
            }
            return debugNodes;
        }
        else {
            return [];
        }
    }
    function buildDebugNode(tNode, lView) {
        var rawValue = lView[tNode.index];
        var native = unwrapRNode(rawValue);
        var factories = [];
        var instances = [];
        var tView = lView[TVIEW];
        for (var i = tNode.directiveStart; i < tNode.directiveEnd; i++) {
            var def = tView.data[i];
            factories.push(def.type);
            instances.push(lView[i]);
        }
        return {
            html: toHtml(native),
            type: toTNodeTypeAsString(tNode.type),
            tNode: tNode,
            native: native,
            children: toDebugNodes(tNode.child, lView),
            factories: factories,
            instances: instances,
            injector: buildNodeInjectorDebug(tNode, tView, lView),
            get injectorResolutionPath() {
                return tNode.debugNodeInjectorPath(lView);
            },
        };
    }
    function buildNodeInjectorDebug(tNode, tView, lView) {
        var viewProviders = [];
        for (var i = tNode.providerIndexStart_; i < tNode.providerIndexEnd_; i++) {
            viewProviders.push(tView.data[i]);
        }
        var providers = [];
        for (var i = tNode.providerIndexEnd_; i < tNode.directiveEnd; i++) {
            providers.push(tView.data[i]);
        }
        var nodeInjectorDebug = {
            bloom: toBloom(lView, tNode.injectorIndex),
            cumulativeBloom: toBloom(tView.data, tNode.injectorIndex),
            providers: providers,
            viewProviders: viewProviders,
            parentInjectorIndex: lView[tNode.providerIndexStart_ - 1],
        };
        return nodeInjectorDebug;
    }
    /**
     * Convert a number at `idx` location in `array` into binary representation.
     *
     * @param array
     * @param idx
     */
    function binary(array, idx) {
        var value = array[idx];
        // If not a number we print 8 `?` to retain alignment but let user know that it was called on
        // wrong type.
        if (typeof value !== 'number')
            return '????????';
        // We prefix 0s so that we have constant length number
        var text = '00000000' + value.toString(2);
        return text.substring(text.length - 8);
    }
    /**
     * Convert a bloom filter at location `idx` in `array` into binary representation.
     *
     * @param array
     * @param idx
     */
    function toBloom(array, idx) {
        if (idx < 0) {
            return 'NO_NODE_INJECTOR';
        }
        return binary(array, idx + 7) + "_" + binary(array, idx + 6) + "_" + binary(array, idx + 5) + "_" + binary(array, idx + 4) + "_" + binary(array, idx + 3) + "_" + binary(array, idx + 2) + "_" + binary(array, idx + 1) + "_" + binary(array, idx + 0);
    }
    var LContainerDebug = /** @class */ (function () {
        function LContainerDebug(_raw_lContainer) {
            this._raw_lContainer = _raw_lContainer;
        }
        Object.defineProperty(LContainerDebug.prototype, "hasTransplantedViews", {
            get: function () {
                return this._raw_lContainer[HAS_TRANSPLANTED_VIEWS];
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LContainerDebug.prototype, "views", {
            get: function () {
                return this._raw_lContainer.slice(CONTAINER_HEADER_OFFSET)
                    .map(toDebug);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LContainerDebug.prototype, "parent", {
            get: function () {
                return toDebug(this._raw_lContainer[PARENT]);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LContainerDebug.prototype, "movedViews", {
            get: function () {
                return this._raw_lContainer[MOVED_VIEWS];
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LContainerDebug.prototype, "host", {
            get: function () {
                return this._raw_lContainer[HOST];
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LContainerDebug.prototype, "native", {
            get: function () {
                return this._raw_lContainer[NATIVE];
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(LContainerDebug.prototype, "next", {
            get: function () {
                return toDebug(this._raw_lContainer[NEXT]);
            },
            enumerable: false,
            configurable: true
        });
        return LContainerDebug;
    }());

    var ɵ0$5 = function () { return Promise.resolve(null); };
    /**
     * A permanent marker promise which signifies that the current CD tree is
     * clean.
     */
    var _CLEAN_PROMISE = (ɵ0$5)();
    /**
     * Invoke `HostBindingsFunction`s for view.
     *
     * This methods executes `TView.hostBindingOpCodes`. It is used to execute the
     * `HostBindingsFunction`s associated with the current `LView`.
     *
     * @param tView Current `TView`.
     * @param lView Current `LView`.
     */
    function processHostBindingOpCodes(tView, lView) {
        var hostBindingOpCodes = tView.hostBindingOpCodes;
        if (hostBindingOpCodes === null)
            return;
        try {
            for (var i = 0; i < hostBindingOpCodes.length; i++) {
                var opCode = hostBindingOpCodes[i];
                if (opCode < 0) {
                    // Negative numbers are element indexes.
                    setSelectedIndex(~opCode);
                }
                else {
                    // Positive numbers are NumberTuple which store bindingRootIndex and directiveIndex.
                    var directiveIdx = opCode;
                    var bindingRootIndx = hostBindingOpCodes[++i];
                    var hostBindingFn = hostBindingOpCodes[++i];
                    setBindingRootForHostBindings(bindingRootIndx, directiveIdx);
                    var context = lView[directiveIdx];
                    hostBindingFn(2 /* Update */, context);
                }
            }
        }
        finally {
            setSelectedIndex(-1);
        }
    }
    /** Refreshes all content queries declared by directives in a given view */
    function refreshContentQueries(tView, lView) {
        var contentQueries = tView.contentQueries;
        if (contentQueries !== null) {
            for (var i = 0; i < contentQueries.length; i += 2) {
                var queryStartIdx = contentQueries[i];
                var directiveDefIdx = contentQueries[i + 1];
                if (directiveDefIdx !== -1) {
                    var directiveDef = tView.data[directiveDefIdx];
                    ngDevMode && assertDefined(directiveDef, 'DirectiveDef not found.');
                    ngDevMode &&
                        assertDefined(directiveDef.contentQueries, 'contentQueries function should be defined');
                    setCurrentQueryIndex(queryStartIdx);
                    directiveDef.contentQueries(2 /* Update */, lView[directiveDefIdx], directiveDefIdx);
                }
            }
        }
    }
    /** Refreshes child components in the current view (update mode). */
    function refreshChildComponents(hostLView, components) {
        for (var i = 0; i < components.length; i++) {
            refreshComponent(hostLView, components[i]);
        }
    }
    /** Renders child components in the current view (creation mode). */
    function renderChildComponents(hostLView, components) {
        for (var i = 0; i < components.length; i++) {
            renderComponent(hostLView, components[i]);
        }
    }
    function createLView(parentLView, tView, context, flags, host, tHostNode, rendererFactory, renderer, sanitizer, injector) {
        var lView = ngDevMode ? cloneToLViewFromTViewBlueprint(tView) : tView.blueprint.slice();
        lView[HOST] = host;
        lView[FLAGS] = flags | 4 /* CreationMode */ | 128 /* Attached */ | 8 /* FirstLViewPass */;
        resetPreOrderHookFlags(lView);
        ngDevMode && tView.declTNode && parentLView && assertTNodeForLView(tView.declTNode, parentLView);
        lView[PARENT] = lView[DECLARATION_VIEW] = parentLView;
        lView[CONTEXT] = context;
        lView[RENDERER_FACTORY] = (rendererFactory || parentLView && parentLView[RENDERER_FACTORY]);
        ngDevMode && assertDefined(lView[RENDERER_FACTORY], 'RendererFactory is required');
        lView[RENDERER] = (renderer || parentLView && parentLView[RENDERER]);
        ngDevMode && assertDefined(lView[RENDERER], 'Renderer is required');
        lView[SANITIZER] = sanitizer || parentLView && parentLView[SANITIZER] || null;
        lView[INJECTOR] = injector || parentLView && parentLView[INJECTOR] || null;
        lView[T_HOST] = tHostNode;
        ngDevMode &&
            assertEqual(tView.type == 2 /* Embedded */ ? parentLView !== null : true, true, 'Embedded views must have parentLView');
        lView[DECLARATION_COMPONENT_VIEW] =
            tView.type == 2 /* Embedded */ ? parentLView[DECLARATION_COMPONENT_VIEW] : lView;
        ngDevMode && attachLViewDebug(lView);
        return lView;
    }
    function getOrCreateTNode(tView, index, type, name, attrs) {
        ngDevMode && index !== 0 && // 0 are bogus nodes and they are OK. See `createContainerRef` in
            // `view_engine_compatibility` for additional context.
            assertGreaterThanOrEqual(index, HEADER_OFFSET, 'TNodes can\'t be in the LView header.');
        // Keep this function short, so that the VM will inline it.
        ngDevMode && assertPureTNodeType(type);
        var tNode = tView.data[index];
        if (tNode === null) {
            tNode = createTNodeAtIndex(tView, index, type, name, attrs);
            if (isInI18nBlock()) {
                // If we are in i18n block then all elements should be pre declared through `Placeholder`
                // See `TNodeType.Placeholder` and `LFrame.inI18n` for more context.
                // If the `TNode` was not pre-declared than it means it was not mentioned which means it was
                // removed, so we mark it as detached.
                tNode.flags |= 64 /* isDetached */;
            }
        }
        else if (tNode.type & 64 /* Placeholder */) {
            tNode.type = type;
            tNode.value = name;
            tNode.attrs = attrs;
            var parent = getCurrentParentTNode();
            tNode.injectorIndex = parent === null ? -1 : parent.injectorIndex;
            ngDevMode && assertTNodeForTView(tNode, tView);
            ngDevMode && assertEqual(index, tNode.index, 'Expecting same index');
        }
        setCurrentTNode(tNode, true);
        return tNode;
    }
    function createTNodeAtIndex(tView, index, type, name, attrs) {
        var currentTNode = getCurrentTNodePlaceholderOk();
        var isParent = isCurrentTNodeParent();
        var parent = isParent ? currentTNode : currentTNode && currentTNode.parent;
        // Parents cannot cross component boundaries because components will be used in multiple places.
        var tNode = tView.data[index] =
            createTNode(tView, parent, type, index, name, attrs);
        // Assign a pointer to the first child node of a given view. The first node is not always the one
        // at index 0, in case of i18n, index 0 can be the instruction `i18nStart` and the first node has
        // the index 1 or more, so we can't just check node index.
        if (tView.firstChild === null) {
            tView.firstChild = tNode;
        }
        if (currentTNode !== null) {
            if (isParent) {
                // FIXME(misko): This logic looks unnecessarily complicated. Could we simplify?
                if (currentTNode.child == null && tNode.parent !== null) {
                    // We are in the same view, which means we are adding content node to the parent view.
                    currentTNode.child = tNode;
                }
            }
            else {
                if (currentTNode.next === null) {
                    // In the case of i18n the `currentTNode` may already be linked, in which case we don't want
                    // to break the links which i18n created.
                    currentTNode.next = tNode;
                }
            }
        }
        return tNode;
    }
    /**
     * When elements are created dynamically after a view blueprint is created (e.g. through
     * i18nApply()), we need to adjust the blueprint for future
     * template passes.
     *
     * @param tView `TView` associated with `LView`
     * @param lView The `LView` containing the blueprint to adjust
     * @param numSlotsToAlloc The number of slots to alloc in the LView, should be >0
     * @param initialValue Initial value to store in blueprint
     */
    function allocExpando(tView, lView, numSlotsToAlloc, initialValue) {
        if (numSlotsToAlloc === 0)
            return -1;
        if (ngDevMode) {
            assertFirstCreatePass(tView);
            assertSame(tView, lView[TVIEW], '`LView` must be associated with `TView`!');
            assertEqual(tView.data.length, lView.length, 'Expecting LView to be same size as TView');
            assertEqual(tView.data.length, tView.blueprint.length, 'Expecting Blueprint to be same size as TView');
            assertFirstUpdatePass(tView);
        }
        var allocIdx = lView.length;
        for (var i = 0; i < numSlotsToAlloc; i++) {
            lView.push(initialValue);
            tView.blueprint.push(initialValue);
            tView.data.push(null);
        }
        return allocIdx;
    }
    //////////////////////////
    //// Render
    //////////////////////////
    /**
     * Processes a view in the creation mode. This includes a number of steps in a specific order:
     * - creating view query functions (if any);
     * - executing a template function in the creation mode;
     * - updating static queries (if any);
     * - creating child components defined in a given view.
     */
    function renderView(tView, lView, context) {
        ngDevMode && assertEqual(isCreationMode(lView), true, 'Should be run in creation mode');
        enterView(lView);
        try {
            var viewQuery = tView.viewQuery;
            if (viewQuery !== null) {
                executeViewQueryFn(1 /* Create */, viewQuery, context);
            }
            // Execute a template associated with this view, if it exists. A template function might not be
            // defined for the root component views.
            var templateFn = tView.template;
            if (templateFn !== null) {
                executeTemplate(tView, lView, templateFn, 1 /* Create */, context);
            }
            // This needs to be set before children are processed to support recursive components.
            // This must be set to false immediately after the first creation run because in an
            // ngFor loop, all the views will be created together before update mode runs and turns
            // off firstCreatePass. If we don't set it here, instances will perform directive
            // matching, etc again and again.
            if (tView.firstCreatePass) {
                tView.firstCreatePass = false;
            }
            // We resolve content queries specifically marked as `static` in creation mode. Dynamic
            // content queries are resolved during change detection (i.e. update mode), after embedded
            // views are refreshed (see block above).
            if (tView.staticContentQueries) {
                refreshContentQueries(tView, lView);
            }
            // We must materialize query results before child components are processed
            // in case a child component has projected a container. The LContainer needs
            // to exist so the embedded views are properly attached by the container.
            if (tView.staticViewQueries) {
                executeViewQueryFn(2 /* Update */, tView.viewQuery, context);
            }
            // Render child component views.
            var components = tView.components;
            if (components !== null) {
                renderChildComponents(lView, components);
            }
        }
        catch (error) {
            // If we didn't manage to get past the first template pass due to
            // an error, mark the view as corrupted so we can try to recover.
            if (tView.firstCreatePass) {
                tView.incompleteFirstPass = true;
            }
            throw error;
        }
        finally {
            lView[FLAGS] &= ~4 /* CreationMode */;
            leaveView();
        }
    }
    /**
     * Processes a view in update mode. This includes a number of steps in a specific order:
     * - executing a template function in update mode;
     * - executing hooks;
     * - refreshing queries;
     * - setting host bindings;
     * - refreshing child (embedded and component) views.
     */
    function refreshView(tView, lView, templateFn, context) {
        ngDevMode && assertEqual(isCreationMode(lView), false, 'Should be run in update mode');
        var flags = lView[FLAGS];
        if ((flags & 256 /* Destroyed */) === 256 /* Destroyed */)
            return;
        enterView(lView);
        // Check no changes mode is a dev only mode used to verify that bindings have not changed
        // since they were assigned. We do not want to execute lifecycle hooks in that mode.
        var isInCheckNoChangesPass = isInCheckNoChangesMode();
        try {
            resetPreOrderHookFlags(lView);
            setBindingIndex(tView.bindingStartIndex);
            if (templateFn !== null) {
                executeTemplate(tView, lView, templateFn, 2 /* Update */, context);
            }
            var hooksInitPhaseCompleted = (flags & 3 /* InitPhaseStateMask */) === 3 /* InitPhaseCompleted */;
            // execute pre-order hooks (OnInit, OnChanges, DoCheck)
            // PERF WARNING: do NOT extract this to a separate function without running benchmarks
            if (!isInCheckNoChangesPass) {
                if (hooksInitPhaseCompleted) {
                    var preOrderCheckHooks = tView.preOrderCheckHooks;
                    if (preOrderCheckHooks !== null) {
                        executeCheckHooks(lView, preOrderCheckHooks, null);
                    }
                }
                else {
                    var preOrderHooks = tView.preOrderHooks;
                    if (preOrderHooks !== null) {
                        executeInitAndCheckHooks(lView, preOrderHooks, 0 /* OnInitHooksToBeRun */, null);
                    }
                    incrementInitPhaseFlags(lView, 0 /* OnInitHooksToBeRun */);
                }
            }
            // First mark transplanted views that are declared in this lView as needing a refresh at their
            // insertion points. This is needed to avoid the situation where the template is defined in this
            // `LView` but its declaration appears after the insertion component.
            markTransplantedViewsForRefresh(lView);
            refreshEmbeddedViews(lView);
            // Content query results must be refreshed before content hooks are called.
            if (tView.contentQueries !== null) {
                refreshContentQueries(tView, lView);
            }
            // execute content hooks (AfterContentInit, AfterContentChecked)
            // PERF WARNING: do NOT extract this to a separate function without running benchmarks
            if (!isInCheckNoChangesPass) {
                if (hooksInitPhaseCompleted) {
                    var contentCheckHooks = tView.contentCheckHooks;
                    if (contentCheckHooks !== null) {
                        executeCheckHooks(lView, contentCheckHooks);
                    }
                }
                else {
                    var contentHooks = tView.contentHooks;
                    if (contentHooks !== null) {
                        executeInitAndCheckHooks(lView, contentHooks, 1 /* AfterContentInitHooksToBeRun */);
                    }
                    incrementInitPhaseFlags(lView, 1 /* AfterContentInitHooksToBeRun */);
                }
            }
            processHostBindingOpCodes(tView, lView);
            // Refresh child component views.
            var components = tView.components;
            if (components !== null) {
                refreshChildComponents(lView, components);
            }
            // View queries must execute after refreshing child components because a template in this view
            // could be inserted in a child component. If the view query executes before child component
            // refresh, the template might not yet be inserted.
            var viewQuery = tView.viewQuery;
            if (viewQuery !== null) {
                executeViewQueryFn(2 /* Update */, viewQuery, context);
            }
            // execute view hooks (AfterViewInit, AfterViewChecked)
            // PERF WARNING: do NOT extract this to a separate function without running benchmarks
            if (!isInCheckNoChangesPass) {
                if (hooksInitPhaseCompleted) {
                    var viewCheckHooks = tView.viewCheckHooks;
                    if (viewCheckHooks !== null) {
                        executeCheckHooks(lView, viewCheckHooks);
                    }
                }
                else {
                    var viewHooks = tView.viewHooks;
                    if (viewHooks !== null) {
                        executeInitAndCheckHooks(lView, viewHooks, 2 /* AfterViewInitHooksToBeRun */);
                    }
                    incrementInitPhaseFlags(lView, 2 /* AfterViewInitHooksToBeRun */);
                }
            }
            if (tView.firstUpdatePass === true) {
                // We need to make sure that we only flip the flag on successful `refreshView` only
                // Don't do this in `finally` block.
                // If we did this in `finally` block then an exception could block the execution of styling
                // instructions which in turn would be unable to insert themselves into the styling linked
                // list. The result of this would be that if the exception would not be throw on subsequent CD
                // the styling would be unable to process it data and reflect to the DOM.
                tView.firstUpdatePass = false;
            }
            // Do not reset the dirty state when running in check no changes mode. We don't want components
            // to behave differently depending on whether check no changes is enabled or not. For example:
            // Marking an OnPush component as dirty from within the `ngAfterViewInit` hook in order to
            // refresh a `NgClass` binding should work. If we would reset the dirty state in the check
            // no changes cycle, the component would be not be dirty for the next update pass. This would
            // be different in production mode where the component dirty state is not reset.
            if (!isInCheckNoChangesPass) {
                lView[FLAGS] &= ~(64 /* Dirty */ | 8 /* FirstLViewPass */);
            }
            if (lView[FLAGS] & 1024 /* RefreshTransplantedView */) {
                lView[FLAGS] &= ~1024 /* RefreshTransplantedView */;
                updateTransplantedViewCount(lView[PARENT], -1);
            }
        }
        finally {
            leaveView();
        }
    }
    function renderComponentOrTemplate(tView, lView, templateFn, context) {
        var rendererFactory = lView[RENDERER_FACTORY];
        var normalExecutionPath = !isInCheckNoChangesMode();
        var creationModeIsActive = isCreationMode(lView);
        try {
            if (normalExecutionPath && !creationModeIsActive && rendererFactory.begin) {
                rendererFactory.begin();
            }
            if (creationModeIsActive) {
                renderView(tView, lView, context);
            }
            refreshView(tView, lView, templateFn, context);
        }
        finally {
            if (normalExecutionPath && !creationModeIsActive && rendererFactory.end) {
                rendererFactory.end();
            }
        }
    }
    function executeTemplate(tView, lView, templateFn, rf, context) {
        var prevSelectedIndex = getSelectedIndex();
        try {
            setSelectedIndex(-1);
            if (rf & 2 /* Update */ && lView.length > HEADER_OFFSET) {
                // When we're updating, inherently select 0 so we don't
                // have to generate that instruction for most update blocks.
                selectIndexInternal(tView, lView, HEADER_OFFSET, isInCheckNoChangesMode());
            }
            templateFn(rf, context);
        }
        finally {
            setSelectedIndex(prevSelectedIndex);
        }
    }
    //////////////////////////
    //// Element
    //////////////////////////
    function executeContentQueries(tView, tNode, lView) {
        if (isContentQueryHost(tNode)) {
            var start = tNode.directiveStart;
            var end = tNode.directiveEnd;
            for (var directiveIndex = start; directiveIndex < end; directiveIndex++) {
                var def = tView.data[directiveIndex];
                if (def.contentQueries) {
                    def.contentQueries(1 /* Create */, lView[directiveIndex], directiveIndex);
                }
            }
        }
    }
    /**
     * Creates directive instances.
     */
    function createDirectivesInstances(tView, lView, tNode) {
        if (!getBindingsEnabled())
            return;
        instantiateAllDirectives(tView, lView, tNode, getNativeByTNode(tNode, lView));
        if ((tNode.flags & 128 /* hasHostBindings */) === 128 /* hasHostBindings */) {
            invokeDirectivesHostBindings(tView, lView, tNode);
        }
    }
    /**
     * Takes a list of local names and indices and pushes the resolved local variable values
     * to LView in the same order as they are loaded in the template with load().
     */
    function saveResolvedLocalsInData(viewData, tNode, localRefExtractor) {
        if (localRefExtractor === void 0) { localRefExtractor = getNativeByTNode; }
        var localNames = tNode.localNames;
        if (localNames !== null) {
            var localIndex = tNode.index + 1;
            for (var i = 0; i < localNames.length; i += 2) {
                var index = localNames[i + 1];
                var value = index === -1 ?
                    localRefExtractor(tNode, viewData) :
                    viewData[index];
                viewData[localIndex++] = value;
            }
        }
    }
    /**
     * Gets TView from a template function or creates a new TView
     * if it doesn't already exist.
     *
     * @param def ComponentDef
     * @returns TView
     */
    function getOrCreateTComponentView(def) {
        var tView = def.tView;
        // Create a TView if there isn't one, or recreate it if the first create pass didn't
        // complete successfully since we can't know for sure whether it's in a usable shape.
        if (tView === null || tView.incompleteFirstPass) {
            // Declaration node here is null since this function is called when we dynamically create a
            // component and hence there is no declaration.
            var declTNode = null;
            return def.tView = createTView(1 /* Component */, declTNode, def.template, def.decls, def.vars, def.directiveDefs, def.pipeDefs, def.viewQuery, def.schemas, def.consts);
        }
        return tView;
    }
    /**
     * Creates a TView instance
     *
     * @param type Type of `TView`.
     * @param declTNode Declaration location of this `TView`.
     * @param templateFn Template function
     * @param decls The number of nodes, local refs, and pipes in this template
     * @param directives Registry of directives for this view
     * @param pipes Registry of pipes for this view
     * @param viewQuery View queries for this view
     * @param schemas Schemas for this view
     * @param consts Constants for this view
     */
    function createTView(type, declTNode, templateFn, decls, vars, directives, pipes, viewQuery, schemas, constsOrFactory) {
        ngDevMode && ngDevMode.tView++;
        var bindingStartIndex = HEADER_OFFSET + decls;
        // This length does not yet contain host bindings from child directives because at this point,
        // we don't know which directives are active on this template. As soon as a directive is matched
        // that has a host binding, we will update the blueprint with that def's hostVars count.
        var initialViewLength = bindingStartIndex + vars;
        var blueprint = createViewBlueprint(bindingStartIndex, initialViewLength);
        var consts = typeof constsOrFactory === 'function' ? constsOrFactory() : constsOrFactory;
        var tView = blueprint[TVIEW] = ngDevMode ?
            new TViewConstructor(type, // type: TViewType,
            blueprint, // blueprint: LView,
            templateFn, // template: ComponentTemplate<{}>|null,
            null, // queries: TQueries|null
            viewQuery, // viewQuery: ViewQueriesFunction<{}>|null,
            declTNode, // declTNode: TNode|null,
            cloneToTViewData(blueprint).fill(null, bindingStartIndex), // data: TData,
            bindingStartIndex, // bindingStartIndex: number,
            initialViewLength, // expandoStartIndex: number,
            null, // hostBindingOpCodes: HostBindingOpCodes,
            true, // firstCreatePass: boolean,
            true, // firstUpdatePass: boolean,
            false, // staticViewQueries: boolean,
            false, // staticContentQueries: boolean,
            null, // preOrderHooks: HookData|null,
            null, // preOrderCheckHooks: HookData|null,
            null, // contentHooks: HookData|null,
            null, // contentCheckHooks: HookData|null,
            null, // viewHooks: HookData|null,
            null, // viewCheckHooks: HookData|null,
            null, // destroyHooks: DestroyHookData|null,
            null, // cleanup: any[]|null,
            null, // contentQueries: number[]|null,
            null, // components: number[]|null,
            typeof directives === 'function' ? //
                directives() : //
                directives, // directiveRegistry: DirectiveDefList|null,
            typeof pipes === 'function' ? pipes() : pipes, // pipeRegistry: PipeDefList|null,
            null, // firstChild: TNode|null,
            schemas, // schemas: SchemaMetadata[]|null,
            consts, // consts: TConstants|null
            false, // incompleteFirstPass: boolean
            decls, // ngDevMode only: decls
            vars) :
            {
                type: type,
                blueprint: blueprint,
                template: templateFn,
                queries: null,
                viewQuery: viewQuery,
                declTNode: declTNode,
                data: blueprint.slice().fill(null, bindingStartIndex),
                bindingStartIndex: bindingStartIndex,
                expandoStartIndex: initialViewLength,
                hostBindingOpCodes: null,
                firstCreatePass: true,
                firstUpdatePass: true,
                staticViewQueries: false,
                staticContentQueries: false,
                preOrderHooks: null,
                preOrderCheckHooks: null,
                contentHooks: null,
                contentCheckHooks: null,
                viewHooks: null,
                viewCheckHooks: null,
                destroyHooks: null,
                cleanup: null,
                contentQueries: null,
                components: null,
                directiveRegistry: typeof directives === 'function' ? directives() : directives,
                pipeRegistry: typeof pipes === 'function' ? pipes() : pipes,
                firstChild: null,
                schemas: schemas,
                consts: consts,
                incompleteFirstPass: false
            };
        if (ngDevMode) {
            // For performance reasons it is important that the tView retains the same shape during runtime.
            // (To make sure that all of the code is monomorphic.) For this reason we seal the object to
            // prevent class transitions.
            Object.seal(tView);
        }
        return tView;
    }
    function createViewBlueprint(bindingStartIndex, initialViewLength) {
        var blueprint = ngDevMode ? new LViewBlueprint() : [];
        for (var i = 0; i < initialViewLength; i++) {
            blueprint.push(i < bindingStartIndex ? null : NO_CHANGE);
        }
        return blueprint;
    }
    function createError(text, token) {
        return new Error("Renderer: " + text + " [" + stringifyForError(token) + "]");
    }
    function assertHostNodeExists(rElement, elementOrSelector) {
        if (!rElement) {
            if (typeof elementOrSelector === 'string') {
                throw createError('Host node with selector not found:', elementOrSelector);
            }
            else {
                throw createError('Host node is required:', elementOrSelector);
            }
        }
    }
    /**
     * Locates the host native element, used for bootstrapping existing nodes into rendering pipeline.
     *
     * @param rendererFactory Factory function to create renderer instance.
     * @param elementOrSelector Render element or CSS selector to locate the element.
     * @param encapsulation View Encapsulation defined for component that requests host element.
     */
    function locateHostElement(renderer, elementOrSelector, encapsulation) {
        if (isProceduralRenderer(renderer)) {
            // When using native Shadow DOM, do not clear host element to allow native slot projection
            var preserveContent = encapsulation === exports.ViewEncapsulation.ShadowDom;
            return renderer.selectRootElement(elementOrSelector, preserveContent);
        }
        var rElement = typeof elementOrSelector === 'string' ?
            renderer.querySelector(elementOrSelector) :
            elementOrSelector;
        ngDevMode && assertHostNodeExists(rElement, elementOrSelector);
        // Always clear host element's content when Renderer3 is in use. For procedural renderer case we
        // make it depend on whether ShadowDom encapsulation is used (in which case the content should be
        // preserved to allow native slot projection). ShadowDom encapsulation requires procedural
        // renderer, and procedural renderer case is handled above.
        rElement.textContent = '';
        return rElement;
    }
    /**
     * Saves context for this cleanup function in LView.cleanupInstances.
     *
     * On the first template pass, saves in TView:
     * - Cleanup function
     * - Index of context we just saved in LView.cleanupInstances
     *
     * This function can also be used to store instance specific cleanup fns. In that case the `context`
     * is `null` and the function is store in `LView` (rather than it `TView`).
     */
    function storeCleanupWithContext(tView, lView, context, cleanupFn) {
        var lCleanup = getOrCreateLViewCleanup(lView);
        if (context === null) {
            // If context is null that this is instance specific callback. These callbacks can only be
            // inserted after template shared instances. For this reason in ngDevMode we freeze the TView.
            if (ngDevMode) {
                Object.freeze(getOrCreateTViewCleanup(tView));
            }
            lCleanup.push(cleanupFn);
        }
        else {
            lCleanup.push(context);
            if (tView.firstCreatePass) {
                getOrCreateTViewCleanup(tView).push(cleanupFn, lCleanup.length - 1);
            }
        }
    }
    function createTNode(tView, tParent, type, index, value, attrs) {
        ngDevMode && index !== 0 && // 0 are bogus nodes and they are OK. See `createContainerRef` in
            // `view_engine_compatibility` for additional context.
            assertGreaterThanOrEqual(index, HEADER_OFFSET, 'TNodes can\'t be in the LView header.');
        ngDevMode && assertNotSame(attrs, undefined, '\'undefined\' is not valid value for \'attrs\'');
        ngDevMode && ngDevMode.tNode++;
        ngDevMode && tParent && assertTNodeForTView(tParent, tView);
        var injectorIndex = tParent ? tParent.injectorIndex : -1;
        var tNode = ngDevMode ?
            new TNodeDebug(tView, // tView_: TView
            type, // type: TNodeType
            index, // index: number
            null, // insertBeforeIndex: null|-1|number|number[]
            injectorIndex, // injectorIndex: number
            -1, // directiveStart: number
            -1, // directiveEnd: number
            -1, // directiveStylingLast: number
            null, // propertyBindings: number[]|null
            0, // flags: TNodeFlags
            0, // providerIndexes: TNodeProviderIndexes
            value, // value: string|null
            attrs, // attrs: (string|AttributeMarker|(string|SelectorFlags)[])[]|null
            null, // mergedAttrs
            null, // localNames: (string|number)[]|null
            undefined, // initialInputs: (string[]|null)[]|null|undefined
            null, // inputs: PropertyAliases|null
            null, // outputs: PropertyAliases|null
            null, // tViews: ITView|ITView[]|null
            null, // next: ITNode|null
            null, // projectionNext: ITNode|null
            null, // child: ITNode|null
            tParent, // parent: TElementNode|TContainerNode|null
            null, // projection: number|(ITNode|RNode[])[]|null
            null, // styles: string|null
            null, // stylesWithoutHost: string|null
            undefined, // residualStyles: string|null
            null, // classes: string|null
            null, // classesWithoutHost: string|null
            undefined, // residualClasses: string|null
            0, // classBindings: TStylingRange;
            0) :
            {
                type: type,
                index: index,
                insertBeforeIndex: null,
                injectorIndex: injectorIndex,
                directiveStart: -1,
                directiveEnd: -1,
                directiveStylingLast: -1,
                propertyBindings: null,
                flags: 0,
                providerIndexes: 0,
                value: value,
                attrs: attrs,
                mergedAttrs: null,
                localNames: null,
                initialInputs: undefined,
                inputs: null,
                outputs: null,
                tViews: null,
                next: null,
                projectionNext: null,
                child: null,
                parent: tParent,
                projection: null,
                styles: null,
                stylesWithoutHost: null,
                residualStyles: undefined,
                classes: null,
                classesWithoutHost: null,
                residualClasses: undefined,
                classBindings: 0,
                styleBindings: 0,
            };
        if (ngDevMode) {
            // For performance reasons it is important that the tNode retains the same shape during runtime.
            // (To make sure that all of the code is monomorphic.) For this reason we seal the object to
            // prevent class transitions.
            Object.seal(tNode);
        }
        return tNode;
    }
    function generatePropertyAliases(inputAliasMap, directiveDefIdx, propStore) {
        for (var publicName in inputAliasMap) {
            if (inputAliasMap.hasOwnProperty(publicName)) {
                propStore = propStore === null ? {} : propStore;
                var internalName = inputAliasMap[publicName];
                if (propStore.hasOwnProperty(publicName)) {
                    propStore[publicName].push(directiveDefIdx, internalName);
                }
                else {
                    (propStore[publicName] = [directiveDefIdx, internalName]);
                }
            }
        }
        return propStore;
    }
    /**
     * Initializes data structures required to work with directive inputs and outputs.
     * Initialization is done for all directives matched on a given TNode.
     */
    function initializeInputAndOutputAliases(tView, tNode) {
        ngDevMode && assertFirstCreatePass(tView);
        var start = tNode.directiveStart;
        var end = tNode.directiveEnd;
        var tViewData = tView.data;
        var tNodeAttrs = tNode.attrs;
        var inputsFromAttrs = ngDevMode ? new TNodeInitialInputs() : [];
        var inputsStore = null;
        var outputsStore = null;
        for (var i = start; i < end; i++) {
            var directiveDef = tViewData[i];
            var directiveInputs = directiveDef.inputs;
            // Do not use unbound attributes as inputs to structural directives, since structural
            // directive inputs can only be set using microsyntax (e.g. `<div *dir="exp">`).
            // TODO(FW-1930): microsyntax expressions may also contain unbound/static attributes, which
            // should be set for inline templates.
            var initialInputs = (tNodeAttrs !== null && !isInlineTemplate(tNode)) ?
                generateInitialInputs(directiveInputs, tNodeAttrs) :
                null;
            inputsFromAttrs.push(initialInputs);
            inputsStore = generatePropertyAliases(directiveInputs, i, inputsStore);
            outputsStore = generatePropertyAliases(directiveDef.outputs, i, outputsStore);
        }
        if (inputsStore !== null) {
            if (inputsStore.hasOwnProperty('class')) {
                tNode.flags |= 16 /* hasClassInput */;
            }
            if (inputsStore.hasOwnProperty('style')) {
                tNode.flags |= 32 /* hasStyleInput */;
            }
        }
        tNode.initialInputs = inputsFromAttrs;
        tNode.inputs = inputsStore;
        tNode.outputs = outputsStore;
    }
    /**
     * Mapping between attributes names that don't correspond to their element property names.
     *
     * Performance note: this function is written as a series of if checks (instead of, say, a property
     * object lookup) for performance reasons - the series of `if` checks seems to be the fastest way of
     * mapping property names. Do NOT change without benchmarking.
     *
     * Note: this mapping has to be kept in sync with the equally named mapping in the template
     * type-checking machinery of ngtsc.
     */
    function mapPropName(name) {
        if (name === 'class')
            return 'className';
        if (name === 'for')
            return 'htmlFor';
        if (name === 'formaction')
            return 'formAction';
        if (name === 'innerHtml')
            return 'innerHTML';
        if (name === 'readonly')
            return 'readOnly';
        if (name === 'tabindex')
            return 'tabIndex';
        return name;
    }
    function elementPropertyInternal(tView, tNode, lView, propName, value, renderer, sanitizer, nativeOnly) {
        ngDevMode && assertNotSame(value, NO_CHANGE, 'Incoming value should never be NO_CHANGE.');
        var element = getNativeByTNode(tNode, lView);
        var inputData = tNode.inputs;
        var dataValue;
        if (!nativeOnly && inputData != null && (dataValue = inputData[propName])) {
            setInputsForProperty(tView, lView, dataValue, propName, value);
            if (isComponentHost(tNode))
                markDirtyIfOnPush(lView, tNode.index);
            if (ngDevMode) {
                setNgReflectProperties(lView, element, tNode.type, dataValue, value);
            }
        }
        else if (tNode.type & 3 /* AnyRNode */) {
            propName = mapPropName(propName);
            if (ngDevMode) {
                validateAgainstEventProperties(propName);
                if (!validateProperty(tView, element, propName, tNode)) {
                    // Return here since we only log warnings for unknown properties.
                    logUnknownPropertyError(propName, tNode);
                    return;
                }
                ngDevMode.rendererSetProperty++;
            }
            // It is assumed that the sanitizer is only added when the compiler determines that the
            // property is risky, so sanitization can be done without further checks.
            value = sanitizer != null ? sanitizer(value, tNode.value || '', propName) : value;
            if (isProceduralRenderer(renderer)) {
                renderer.setProperty(element, propName, value);
            }
            else if (!isAnimationProp(propName)) {
                element.setProperty ? element.setProperty(propName, value) :
                    element[propName] = value;
            }
        }
        else if (tNode.type & 12 /* AnyContainer */) {
            // If the node is a container and the property didn't
            // match any of the inputs or schemas we should throw.
            if (ngDevMode && !matchingSchemas(tView, tNode.value)) {
                logUnknownPropertyError(propName, tNode);
            }
        }
    }
    /** If node is an OnPush component, marks its LView dirty. */
    function markDirtyIfOnPush(lView, viewIndex) {
        ngDevMode && assertLView(lView);
        var childComponentLView = getComponentLViewByIndex(viewIndex, lView);
        if (!(childComponentLView[FLAGS] & 16 /* CheckAlways */)) {
            childComponentLView[FLAGS] |= 64 /* Dirty */;
        }
    }
    function setNgReflectProperty(lView, element, type, attrName, value) {
        var _a;
        var renderer = lView[RENDERER];
        attrName = normalizeDebugBindingName(attrName);
        var debugValue = normalizeDebugBindingValue(value);
        if (type & 3 /* AnyRNode */) {
            if (value == null) {
                isProceduralRenderer(renderer) ? renderer.removeAttribute(element, attrName) :
                    element.removeAttribute(attrName);
            }
            else {
                isProceduralRenderer(renderer) ?
                    renderer.setAttribute(element, attrName, debugValue) :
                    element.setAttribute(attrName, debugValue);
            }
        }
        else {
            var textContent = escapeCommentText("bindings=" + JSON.stringify((_a = {}, _a[attrName] = debugValue, _a), null, 2));
            if (isProceduralRenderer(renderer)) {
                renderer.setValue(element, textContent);
            }
            else {
                element.textContent = textContent;
            }
        }
    }
    function setNgReflectProperties(lView, element, type, dataValue, value) {
        if (type & (3 /* AnyRNode */ | 4 /* Container */)) {
            /**
             * dataValue is an array containing runtime input or output names for the directives:
             * i+0: directive instance index
             * i+1: privateName
             *
             * e.g. [0, 'change', 'change-minified']
             * we want to set the reflected property with the privateName: dataValue[i+1]
             */
            for (var i = 0; i < dataValue.length; i += 2) {
                setNgReflectProperty(lView, element, type, dataValue[i + 1], value);
            }
        }
    }
    function validateProperty(tView, element, propName, tNode) {
        // If `schemas` is set to `null`, that's an indication that this Component was compiled in AOT
        // mode where this check happens at compile time. In JIT mode, `schemas` is always present and
        // defined as an array (as an empty array in case `schemas` field is not defined) and we should
        // execute the check below.
        if (tView.schemas === null)
            return true;
        // The property is considered valid if the element matches the schema, it exists on the element
        // or it is synthetic, and we are in a browser context (web worker nodes should be skipped).
        if (matchingSchemas(tView, tNode.value) || propName in element || isAnimationProp(propName)) {
            return true;
        }
        // Note: `typeof Node` returns 'function' in most browsers, but on IE it is 'object' so we
        // need to account for both here, while being careful for `typeof null` also returning 'object'.
        return typeof Node === 'undefined' || Node === null || !(element instanceof Node);
    }
    function matchingSchemas(tView, tagName) {
        var schemas = tView.schemas;
        if (schemas !== null) {
            for (var i = 0; i < schemas.length; i++) {
                var schema = schemas[i];
                if (schema === NO_ERRORS_SCHEMA ||
                    schema === CUSTOM_ELEMENTS_SCHEMA && tagName && tagName.indexOf('-') > -1) {
                    return true;
                }
            }
        }
        return false;
    }
    /**
     * Logs an error that a property is not supported on an element.
     * @param propName Name of the invalid property.
     * @param tNode Node on which we encountered the property.
     */
    function logUnknownPropertyError(propName, tNode) {
        var message = "Can't bind to '" + propName + "' since it isn't a known property of '" + tNode.value + "'.";
        console.error(formatRuntimeError("303" /* UNKNOWN_BINDING */, message));
    }
    /**
     * Instantiate a root component.
     */
    function instantiateRootComponent(tView, lView, def) {
        var rootTNode = getCurrentTNode();
        if (tView.firstCreatePass) {
            if (def.providersResolver)
                def.providersResolver(def);
            var directiveIndex = allocExpando(tView, lView, 1, null);
            ngDevMode &&
                assertEqual(directiveIndex, rootTNode.directiveStart, 'Because this is a root component the allocated expando should match the TNode component.');
            configureViewWithDirective(tView, rootTNode, lView, directiveIndex, def);
        }
        var directive = getNodeInjectable(lView, tView, rootTNode.directiveStart, rootTNode);
        attachPatchData(directive, lView);
        var native = getNativeByTNode(rootTNode, lView);
        if (native) {
            attachPatchData(native, lView);
        }
        return directive;
    }
    /**
     * Resolve the matched directives on a node.
     */
    function resolveDirectives(tView, lView, tNode, localRefs) {
        // Please make sure to have explicit type for `exportsMap`. Inferred type triggers bug in
        // tsickle.
        ngDevMode && assertFirstCreatePass(tView);
        var hasDirectives = false;
        if (getBindingsEnabled()) {
            var directiveDefs = findDirectiveDefMatches(tView, lView, tNode);
            var exportsMap = localRefs === null ? null : { '': -1 };
            if (directiveDefs !== null) {
                hasDirectives = true;
                initTNodeFlags(tNode, tView.data.length, directiveDefs.length);
                // When the same token is provided by several directives on the same node, some rules apply in
                // the viewEngine:
                // - viewProviders have priority over providers
                // - the last directive in NgModule.declarations has priority over the previous one
                // So to match these rules, the order in which providers are added in the arrays is very
                // important.
                for (var i = 0; i < directiveDefs.length; i++) {
                    var def = directiveDefs[i];
                    if (def.providersResolver)
                        def.providersResolver(def);
                }
                var preOrderHooksFound = false;
                var preOrderCheckHooksFound = false;
                var directiveIdx = allocExpando(tView, lView, directiveDefs.length, null);
                ngDevMode &&
                    assertSame(directiveIdx, tNode.directiveStart, 'TNode.directiveStart should point to just allocated space');
                for (var i = 0; i < directiveDefs.length; i++) {
                    var def = directiveDefs[i];
                    // Merge the attrs in the order of matches. This assumes that the first directive is the
                    // component itself, so that the component has the least priority.
                    tNode.mergedAttrs = mergeHostAttrs(tNode.mergedAttrs, def.hostAttrs);
                    configureViewWithDirective(tView, tNode, lView, directiveIdx, def);
                    saveNameToExportMap(directiveIdx, def, exportsMap);
                    if (def.contentQueries !== null)
                        tNode.flags |= 8 /* hasContentQuery */;
                    if (def.hostBindings !== null || def.hostAttrs !== null || def.hostVars !== 0)
                        tNode.flags |= 128 /* hasHostBindings */;
                    var lifeCycleHooks = def.type.prototype;
                    // Only push a node index into the preOrderHooks array if this is the first
                    // pre-order hook found on this node.
                    if (!preOrderHooksFound &&
                        (lifeCycleHooks.ngOnChanges || lifeCycleHooks.ngOnInit || lifeCycleHooks.ngDoCheck)) {
                        // We will push the actual hook function into this array later during dir instantiation.
                        // We cannot do it now because we must ensure hooks are registered in the same
                        // order that directives are created (i.e. injection order).
                        (tView.preOrderHooks || (tView.preOrderHooks = [])).push(tNode.index);
                        preOrderHooksFound = true;
                    }
                    if (!preOrderCheckHooksFound && (lifeCycleHooks.ngOnChanges || lifeCycleHooks.ngDoCheck)) {
                        (tView.preOrderCheckHooks || (tView.preOrderCheckHooks = [])).push(tNode.index);
                        preOrderCheckHooksFound = true;
                    }
                    directiveIdx++;
                }
                initializeInputAndOutputAliases(tView, tNode);
            }
            if (exportsMap)
                cacheMatchingLocalNames(tNode, localRefs, exportsMap);
        }
        // Merge the template attrs last so that they have the highest priority.
        tNode.mergedAttrs = mergeHostAttrs(tNode.mergedAttrs, tNode.attrs);
        return hasDirectives;
    }
    /**
     * Add `hostBindings` to the `TView.hostBindingOpCodes`.
     *
     * @param tView `TView` to which the `hostBindings` should be added.
     * @param tNode `TNode` the element which contains the directive
     * @param lView `LView` current `LView`
     * @param directiveIdx Directive index in view.
     * @param directiveVarsIdx Where will the directive's vars be stored
     * @param def `ComponentDef`/`DirectiveDef`, which contains the `hostVars`/`hostBindings` to add.
     */
    function registerHostBindingOpCodes(tView, tNode, lView, directiveIdx, directiveVarsIdx, def) {
        ngDevMode && assertFirstCreatePass(tView);
        var hostBindings = def.hostBindings;
        if (hostBindings) {
            var hostBindingOpCodes = tView.hostBindingOpCodes;
            if (hostBindingOpCodes === null) {
                hostBindingOpCodes = tView.hostBindingOpCodes = [];
            }
            var elementIndx = ~tNode.index;
            if (lastSelectedElementIdx(hostBindingOpCodes) != elementIndx) {
                // Conditionally add select element so that we are more efficient in execution.
                // NOTE: this is strictly not necessary and it trades code size for runtime perf.
                // (We could just always add it.)
                hostBindingOpCodes.push(elementIndx);
            }
            hostBindingOpCodes.push(directiveIdx, directiveVarsIdx, hostBindings);
        }
    }
    /**
     * Returns the last selected element index in the `HostBindingOpCodes`
     *
     * For perf reasons we don't need to update the selected element index in `HostBindingOpCodes` only
     * if it changes. This method returns the last index (or '0' if not found.)
     *
     * Selected element index are only the ones which are negative.
     */
    function lastSelectedElementIdx(hostBindingOpCodes) {
        var i = hostBindingOpCodes.length;
        while (i > 0) {
            var value = hostBindingOpCodes[--i];
            if (typeof value === 'number' && value < 0) {
                return value;
            }
        }
        return 0;
    }
    /**
     * Instantiate all the directives that were previously resolved on the current node.
     */
    function instantiateAllDirectives(tView, lView, tNode, native) {
        var start = tNode.directiveStart;
        var end = tNode.directiveEnd;
        if (!tView.firstCreatePass) {
            getOrCreateNodeInjectorForNode(tNode, lView);
        }
        attachPatchData(native, lView);
        var initialInputs = tNode.initialInputs;
        for (var i = start; i < end; i++) {
            var def = tView.data[i];
            var isComponent = isComponentDef(def);
            if (isComponent) {
                ngDevMode && assertTNodeType(tNode, 3 /* AnyRNode */);
                addComponentLogic(lView, tNode, def);
            }
            var directive = getNodeInjectable(lView, tView, i, tNode);
            attachPatchData(directive, lView);
            if (initialInputs !== null) {
                setInputsFromAttrs(lView, i - start, directive, def, tNode, initialInputs);
            }
            if (isComponent) {
                var componentView = getComponentLViewByIndex(tNode.index, lView);
                componentView[CONTEXT] = directive;
            }
        }
    }
    function invokeDirectivesHostBindings(tView, lView, tNode) {
        var start = tNode.directiveStart;
        var end = tNode.directiveEnd;
        var firstCreatePass = tView.firstCreatePass;
        var elementIndex = tNode.index;
        var currentDirectiveIndex = getCurrentDirectiveIndex();
        try {
            setSelectedIndex(elementIndex);
            for (var dirIndex = start; dirIndex < end; dirIndex++) {
                var def = tView.data[dirIndex];
                var directive = lView[dirIndex];
                setCurrentDirectiveIndex(dirIndex);
                if (def.hostBindings !== null || def.hostVars !== 0 || def.hostAttrs !== null) {
                    invokeHostBindingsInCreationMode(def, directive);
                }
            }
        }
        finally {
            setSelectedIndex(-1);
            setCurrentDirectiveIndex(currentDirectiveIndex);
        }
    }
    /**
     * Invoke the host bindings in creation mode.
     *
     * @param def `DirectiveDef` which may contain the `hostBindings` function.
     * @param directive Instance of directive.
     */
    function invokeHostBindingsInCreationMode(def, directive) {
        if (def.hostBindings !== null) {
            def.hostBindings(1 /* Create */, directive);
        }
    }
    /**
     * Matches the current node against all available selectors.
     * If a component is matched (at most one), it is returned in first position in the array.
     */
    function findDirectiveDefMatches(tView, viewData, tNode) {
        ngDevMode && assertFirstCreatePass(tView);
        ngDevMode && assertTNodeType(tNode, 3 /* AnyRNode */ | 12 /* AnyContainer */);
        var registry = tView.directiveRegistry;
        var matches = null;
        if (registry) {
            for (var i = 0; i < registry.length; i++) {
                var def = registry[i];
                if (isNodeMatchingSelectorList(tNode, def.selectors, /* isProjectionMode */ false)) {
                    matches || (matches = ngDevMode ? new MatchesArray() : []);
                    diPublicInInjector(getOrCreateNodeInjectorForNode(tNode, viewData), tView, def.type);
                    if (isComponentDef(def)) {
                        if (ngDevMode) {
                            assertTNodeType(tNode, 2 /* Element */, "\"" + tNode.value + "\" tags cannot be used as component hosts. " +
                                ("Please use a different tag to activate the " + stringify(def.type) + " component."));
                            if (tNode.flags & 2 /* isComponentHost */)
                                throwMultipleComponentError(tNode);
                        }
                        markAsComponentHost(tView, tNode);
                        // The component is always stored first with directives after.
                        matches.unshift(def);
                    }
                    else {
                        matches.push(def);
                    }
                }
            }
        }
        return matches;
    }
    /**
     * Marks a given TNode as a component's host. This consists of:
     * - setting appropriate TNode flags;
     * - storing index of component's host element so it will be queued for view refresh during CD.
     */
    function markAsComponentHost(tView, hostTNode) {
        ngDevMode && assertFirstCreatePass(tView);
        hostTNode.flags |= 2 /* isComponentHost */;
        (tView.components || (tView.components = ngDevMode ? new TViewComponents() : []))
            .push(hostTNode.index);
    }
    /** Caches local names and their matching directive indices for query and template lookups. */
    function cacheMatchingLocalNames(tNode, localRefs, exportsMap) {
        if (localRefs) {
            var localNames = tNode.localNames = ngDevMode ? new TNodeLocalNames() : [];
            // Local names must be stored in tNode in the same order that localRefs are defined
            // in the template to ensure the data is loaded in the same slots as their refs
            // in the template (for template queries).
            for (var i = 0; i < localRefs.length; i += 2) {
                var index = exportsMap[localRefs[i + 1]];
                if (index == null)
                    throw new RuntimeError("301" /* EXPORT_NOT_FOUND */, "Export of name '" + localRefs[i + 1] + "' not found!");
                localNames.push(localRefs[i], index);
            }
        }
    }
    /**
     * Builds up an export map as directives are created, so local refs can be quickly mapped
     * to their directive instances.
     */
    function saveNameToExportMap(directiveIdx, def, exportsMap) {
        if (exportsMap) {
            if (def.exportAs) {
                for (var i = 0; i < def.exportAs.length; i++) {
                    exportsMap[def.exportAs[i]] = directiveIdx;
                }
            }
            if (isComponentDef(def))
                exportsMap[''] = directiveIdx;
        }
    }
    /**
     * Initializes the flags on the current node, setting all indices to the initial index,
     * the directive count to 0, and adding the isComponent flag.
     * @param index the initial index
     */
    function initTNodeFlags(tNode, index, numberOfDirectives) {
        ngDevMode &&
            assertNotEqual(numberOfDirectives, tNode.directiveEnd - tNode.directiveStart, 'Reached the max number of directives');
        tNode.flags |= 1 /* isDirectiveHost */;
        // When the first directive is created on a node, save the index
        tNode.directiveStart = index;
        tNode.directiveEnd = index + numberOfDirectives;
        tNode.providerIndexes = index;
    }
    /**
     * Setup directive for instantiation.
     *
     * We need to create a `NodeInjectorFactory` which is then inserted in both the `Blueprint` as well
     * as `LView`. `TView` gets the `DirectiveDef`.
     *
     * @param tView `TView`
     * @param tNode `TNode`
     * @param lView `LView`
     * @param directiveIndex Index where the directive will be stored in the Expando.
     * @param def `DirectiveDef`
     */
    function configureViewWithDirective(tView, tNode, lView, directiveIndex, def) {
        ngDevMode &&
            assertGreaterThanOrEqual(directiveIndex, HEADER_OFFSET, 'Must be in Expando section');
        tView.data[directiveIndex] = def;
        var directiveFactory = def.factory || (def.factory = getFactoryDef(def.type, true));
        var nodeInjectorFactory = new NodeInjectorFactory(directiveFactory, isComponentDef(def), null);
        tView.blueprint[directiveIndex] = nodeInjectorFactory;
        lView[directiveIndex] = nodeInjectorFactory;
        registerHostBindingOpCodes(tView, tNode, lView, directiveIndex, allocExpando(tView, lView, def.hostVars, NO_CHANGE), def);
    }
    function addComponentLogic(lView, hostTNode, def) {
        var native = getNativeByTNode(hostTNode, lView);
        var tView = getOrCreateTComponentView(def);
        // Only component views should be added to the view tree directly. Embedded views are
        // accessed through their containers because they may be removed / re-added later.
        var rendererFactory = lView[RENDERER_FACTORY];
        var componentView = addToViewTree(lView, createLView(lView, tView, null, def.onPush ? 64 /* Dirty */ : 16 /* CheckAlways */, native, hostTNode, rendererFactory, rendererFactory.createRenderer(native, def), null, null));
        // Component view will always be created before any injected LContainers,
        // so this is a regular element, wrap it with the component view
        lView[hostTNode.index] = componentView;
    }
    function elementAttributeInternal(tNode, lView, name, value, sanitizer, namespace) {
        if (ngDevMode) {
            assertNotSame(value, NO_CHANGE, 'Incoming value should never be NO_CHANGE.');
            validateAgainstEventAttributes(name);
            assertTNodeType(tNode, 2 /* Element */, "Attempted to set attribute `" + name + "` on a container node. " +
                "Host bindings are not valid on ng-container or ng-template.");
        }
        var element = getNativeByTNode(tNode, lView);
        setElementAttribute(lView[RENDERER], element, namespace, tNode.value, name, value, sanitizer);
    }
    function setElementAttribute(renderer, element, namespace, tagName, name, value, sanitizer) {
        if (value == null) {
            ngDevMode && ngDevMode.rendererRemoveAttribute++;
            isProceduralRenderer(renderer) ? renderer.removeAttribute(element, name, namespace) :
                element.removeAttribute(name);
        }
        else {
            ngDevMode && ngDevMode.rendererSetAttribute++;
            var strValue = sanitizer == null ? renderStringify(value) : sanitizer(value, tagName || '', name);
            if (isProceduralRenderer(renderer)) {
                renderer.setAttribute(element, name, strValue, namespace);
            }
            else {
                namespace ? element.setAttributeNS(namespace, name, strValue) :
                    element.setAttribute(name, strValue);
            }
        }
    }
    /**
     * Sets initial input properties on directive instances from attribute data
     *
     * @param lView Current LView that is being processed.
     * @param directiveIndex Index of the directive in directives array
     * @param instance Instance of the directive on which to set the initial inputs
     * @param def The directive def that contains the list of inputs
     * @param tNode The static data for this node
     */
    function setInputsFromAttrs(lView, directiveIndex, instance, def, tNode, initialInputData) {
        var initialInputs = initialInputData[directiveIndex];
        if (initialInputs !== null) {
            var setInput = def.setInput;
            for (var i = 0; i < initialInputs.length;) {
                var publicName = initialInputs[i++];
                var privateName = initialInputs[i++];
                var value = initialInputs[i++];
                if (setInput !== null) {
                    def.setInput(instance, value, publicName, privateName);
                }
                else {
                    instance[privateName] = value;
                }
                if (ngDevMode) {
                    var nativeElement = getNativeByTNode(tNode, lView);
                    setNgReflectProperty(lView, nativeElement, tNode.type, privateName, value);
                }
            }
        }
    }
    /**
     * Generates initialInputData for a node and stores it in the template's static storage
     * so subsequent template invocations don't have to recalculate it.
     *
     * initialInputData is an array containing values that need to be set as input properties
     * for directives on this node, but only once on creation. We need this array to support
     * the case where you set an @Input property of a directive using attribute-like syntax.
     * e.g. if you have a `name` @Input, you can set it once like this:
     *
     * <my-component name="Bess"></my-component>
     *
     * @param inputs The list of inputs from the directive def
     * @param attrs The static attrs on this node
     */
    function generateInitialInputs(inputs, attrs) {
        var inputsToStore = null;
        var i = 0;
        while (i < attrs.length) {
            var attrName = attrs[i];
            if (attrName === 0 /* NamespaceURI */) {
                // We do not allow inputs on namespaced attributes.
                i += 4;
                continue;
            }
            else if (attrName === 5 /* ProjectAs */) {
                // Skip over the `ngProjectAs` value.
                i += 2;
                continue;
            }
            // If we hit any other attribute markers, we're done anyway. None of those are valid inputs.
            if (typeof attrName === 'number')
                break;
            if (inputs.hasOwnProperty(attrName)) {
                if (inputsToStore === null)
                    inputsToStore = [];
                inputsToStore.push(attrName, inputs[attrName], attrs[i + 1]);
            }
            i += 2;
        }
        return inputsToStore;
    }
    //////////////////////////
    //// ViewContainer & View
    //////////////////////////
    // Not sure why I need to do `any` here but TS complains later.
    var LContainerArray = ((typeof ngDevMode === 'undefined' || ngDevMode) && initNgDevMode()) &&
        createNamedArrayType('LContainer');
    /**
     * Creates a LContainer, either from a container instruction, or for a ViewContainerRef.
     *
     * @param hostNative The host element for the LContainer
     * @param hostTNode The host TNode for the LContainer
     * @param currentView The parent view of the LContainer
     * @param native The native comment element
     * @param isForViewContainerRef Optional a flag indicating the ViewContainerRef case
     * @returns LContainer
     */
    function createLContainer(hostNative, currentView, native, tNode) {
        ngDevMode && assertLView(currentView);
        ngDevMode && !isProceduralRenderer(currentView[RENDERER]) && assertDomNode(native);
        // https://jsperf.com/array-literal-vs-new-array-really
        var lContainer = new (ngDevMode ? LContainerArray : Array)(hostNative, // host native
        true, // Boolean `true` in this position signifies that this is an `LContainer`
        false, // has transplanted views
        currentView, // parent
        null, // next
        0, // transplanted views to refresh count
        tNode, // t_host
        native, // native,
        null, // view refs
        null);
        ngDevMode &&
            assertEqual(lContainer.length, CONTAINER_HEADER_OFFSET, 'Should allocate correct number of slots for LContainer header.');
        ngDevMode && attachLContainerDebug(lContainer);
        return lContainer;
    }
    /**
     * Goes over embedded views (ones created through ViewContainerRef APIs) and refreshes
     * them by executing an associated template function.
     */
    function refreshEmbeddedViews(lView) {
        for (var lContainer = getFirstLContainer(lView); lContainer !== null; lContainer = getNextLContainer(lContainer)) {
            for (var i = CONTAINER_HEADER_OFFSET; i < lContainer.length; i++) {
                var embeddedLView = lContainer[i];
                var embeddedTView = embeddedLView[TVIEW];
                ngDevMode && assertDefined(embeddedTView, 'TView must be allocated');
                if (viewAttachedToChangeDetector(embeddedLView)) {
                    refreshView(embeddedTView, embeddedLView, embeddedTView.template, embeddedLView[CONTEXT]);
                }
            }
        }
    }
    /**
     * Mark transplanted views as needing to be refreshed at their insertion points.
     *
     * @param lView The `LView` that may have transplanted views.
     */
    function markTransplantedViewsForRefresh(lView) {
        for (var lContainer = getFirstLContainer(lView); lContainer !== null; lContainer = getNextLContainer(lContainer)) {
            if (!lContainer[HAS_TRANSPLANTED_VIEWS])
                continue;
            var movedViews = lContainer[MOVED_VIEWS];
            ngDevMode && assertDefined(movedViews, 'Transplanted View flags set but missing MOVED_VIEWS');
            for (var i = 0; i < movedViews.length; i++) {
                var movedLView = movedViews[i];
                var insertionLContainer = movedLView[PARENT];
                ngDevMode && assertLContainer(insertionLContainer);
                // We don't want to increment the counter if the moved LView was already marked for
                // refresh.
                if ((movedLView[FLAGS] & 1024 /* RefreshTransplantedView */) === 0) {
                    updateTransplantedViewCount(insertionLContainer, 1);
                }
                // Note, it is possible that the `movedViews` is tracking views that are transplanted *and*
                // those that aren't (declaration component === insertion component). In the latter case,
                // it's fine to add the flag, as we will clear it immediately in
                // `refreshEmbeddedViews` for the view currently being refreshed.
                movedLView[FLAGS] |= 1024 /* RefreshTransplantedView */;
            }
        }
    }
    /////////////
    /**
     * Refreshes components by entering the component view and processing its bindings, queries, etc.
     *
     * @param componentHostIdx  Element index in LView[] (adjusted for HEADER_OFFSET)
     */
    function refreshComponent(hostLView, componentHostIdx) {
        ngDevMode && assertEqual(isCreationMode(hostLView), false, 'Should be run in update mode');
        var componentView = getComponentLViewByIndex(componentHostIdx, hostLView);
        // Only attached components that are CheckAlways or OnPush and dirty should be refreshed
        if (viewAttachedToChangeDetector(componentView)) {
            var tView = componentView[TVIEW];
            if (componentView[FLAGS] & (16 /* CheckAlways */ | 64 /* Dirty */)) {
                refreshView(tView, componentView, tView.template, componentView[CONTEXT]);
            }
            else if (componentView[TRANSPLANTED_VIEWS_TO_REFRESH] > 0) {
                // Only attached components that are CheckAlways or OnPush and dirty should be refreshed
                refreshContainsDirtyView(componentView);
            }
        }
    }
    /**
     * Refreshes all transplanted views marked with `LViewFlags.RefreshTransplantedView` that are
     * children or descendants of the given lView.
     *
     * @param lView The lView which contains descendant transplanted views that need to be refreshed.
     */
    function refreshContainsDirtyView(lView) {
        for (var lContainer = getFirstLContainer(lView); lContainer !== null; lContainer = getNextLContainer(lContainer)) {
            for (var i = CONTAINER_HEADER_OFFSET; i < lContainer.length; i++) {
                var embeddedLView = lContainer[i];
                if (embeddedLView[FLAGS] & 1024 /* RefreshTransplantedView */) {
                    var embeddedTView = embeddedLView[TVIEW];
                    ngDevMode && assertDefined(embeddedTView, 'TView must be allocated');
                    refreshView(embeddedTView, embeddedLView, embeddedTView.template, embeddedLView[CONTEXT]);
                }
                else if (embeddedLView[TRANSPLANTED_VIEWS_TO_REFRESH] > 0) {
                    refreshContainsDirtyView(embeddedLView);
                }
            }
        }
        var tView = lView[TVIEW];
        // Refresh child component views.
        var components = tView.components;
        if (components !== null) {
            for (var i = 0; i < components.length; i++) {
                var componentView = getComponentLViewByIndex(components[i], lView);
                // Only attached components that are CheckAlways or OnPush and dirty should be refreshed
                if (viewAttachedToChangeDetector(componentView) &&
                    componentView[TRANSPLANTED_VIEWS_TO_REFRESH] > 0) {
                    refreshContainsDirtyView(componentView);
                }
            }
        }
    }
    function renderComponent(hostLView, componentHostIdx) {
        ngDevMode && assertEqual(isCreationMode(hostLView), true, 'Should be run in creation mode');
        var componentView = getComponentLViewByIndex(componentHostIdx, hostLView);
        var componentTView = componentView[TVIEW];
        syncViewWithBlueprint(componentTView, componentView);
        renderView(componentTView, componentView, componentView[CONTEXT]);
    }
    /**
     * Syncs an LView instance with its blueprint if they have gotten out of sync.
     *
     * Typically, blueprints and their view instances should always be in sync, so the loop here
     * will be skipped. However, consider this case of two components side-by-side:
     *
     * App template:
     * ```
     * <comp></comp>
     * <comp></comp>
     * ```
     *
     * The following will happen:
     * 1. App template begins processing.
     * 2. First <comp> is matched as a component and its LView is created.
     * 3. Second <comp> is matched as a component and its LView is created.
     * 4. App template completes processing, so it's time to check child templates.
     * 5. First <comp> template is checked. It has a directive, so its def is pushed to blueprint.
     * 6. Second <comp> template is checked. Its blueprint has been updated by the first
     * <comp> template, but its LView was created before this update, so it is out of sync.
     *
     * Note that embedded views inside ngFor loops will never be out of sync because these views
     * are processed as soon as they are created.
     *
     * @param tView The `TView` that contains the blueprint for syncing
     * @param lView The view to sync
     */
    function syncViewWithBlueprint(tView, lView) {
        for (var i = lView.length; i < tView.blueprint.length; i++) {
            lView.push(tView.blueprint[i]);
        }
    }
    /**
     * Adds LView or LContainer to the end of the current view tree.
     *
     * This structure will be used to traverse through nested views to remove listeners
     * and call onDestroy callbacks.
     *
     * @param lView The view where LView or LContainer should be added
     * @param adjustedHostIndex Index of the view's host node in LView[], adjusted for header
     * @param lViewOrLContainer The LView or LContainer to add to the view tree
     * @returns The state passed in
     */
    function addToViewTree(lView, lViewOrLContainer) {
        // TODO(benlesh/misko): This implementation is incorrect, because it always adds the LContainer
        // to the end of the queue, which means if the developer retrieves the LContainers from RNodes out
        // of order, the change detection will run out of order, as the act of retrieving the the
        // LContainer from the RNode is what adds it to the queue.
        if (lView[CHILD_HEAD]) {
            lView[CHILD_TAIL][NEXT] = lViewOrLContainer;
        }
        else {
            lView[CHILD_HEAD] = lViewOrLContainer;
        }
        lView[CHILD_TAIL] = lViewOrLContainer;
        return lViewOrLContainer;
    }
    ///////////////////////////////
    //// Change detection
    ///////////////////////////////
    /**
     * Marks current view and all ancestors dirty.
     *
     * Returns the root view because it is found as a byproduct of marking the view tree
     * dirty, and can be used by methods that consume markViewDirty() to easily schedule
     * change detection. Otherwise, such methods would need to traverse up the view tree
     * an additional time to get the root view and schedule a tick on it.
     *
     * @param lView The starting LView to mark dirty
     * @returns the root LView
     */
    function markViewDirty(lView) {
        while (lView) {
            lView[FLAGS] |= 64 /* Dirty */;
            var parent = getLViewParent(lView);
            // Stop traversing up as soon as you find a root view that wasn't attached to any container
            if (isRootView(lView) && !parent) {
                return lView;
            }
            // continue otherwise
            lView = parent;
        }
        return null;
    }
    /**
     * Used to schedule change detection on the whole application.
     *
     * Unlike `tick`, `scheduleTick` coalesces multiple calls into one change detection run.
     * It is usually called indirectly by calling `markDirty` when the view needs to be
     * re-rendered.
     *
     * Typically `scheduleTick` uses `requestAnimationFrame` to coalesce multiple
     * `scheduleTick` requests. The scheduling function can be overridden in
     * `renderComponent`'s `scheduler` option.
     */
    function scheduleTick(rootContext, flags) {
        var nothingScheduled = rootContext.flags === 0 /* Empty */;
        if (nothingScheduled && rootContext.clean == _CLEAN_PROMISE) {
            // https://github.com/angular/angular/issues/39296
            // should only attach the flags when really scheduling a tick
            rootContext.flags |= flags;
            var res_1;
            rootContext.clean = new Promise(function (r) { return res_1 = r; });
            rootContext.scheduler(function () {
                if (rootContext.flags & 1 /* DetectChanges */) {
                    rootContext.flags &= ~1 /* DetectChanges */;
                    tickRootContext(rootContext);
                }
                if (rootContext.flags & 2 /* FlushPlayers */) {
                    rootContext.flags &= ~2 /* FlushPlayers */;
                    var playerHandler = rootContext.playerHandler;
                    if (playerHandler) {
                        playerHandler.flushPlayers();
                    }
                }
                rootContext.clean = _CLEAN_PROMISE;
                res_1(null);
            });
        }
    }
    function tickRootContext(rootContext) {
        for (var i = 0; i < rootContext.components.length; i++) {
            var rootComponent = rootContext.components[i];
            var lView = readPatchedLView(rootComponent);
            var tView = lView[TVIEW];
            renderComponentOrTemplate(tView, lView, tView.template, rootComponent);
        }
    }
    function detectChangesInternal(tView, lView, context) {
        var rendererFactory = lView[RENDERER_FACTORY];
        if (rendererFactory.begin)
            rendererFactory.begin();
        try {
            refreshView(tView, lView, tView.template, context);
        }
        catch (error) {
            handleError(lView, error);
            throw error;
        }
        finally {
            if (rendererFactory.end)
                rendererFactory.end();
        }
    }
    /**
     * Synchronously perform change detection on a root view and its components.
     *
     * @param lView The view which the change detection should be performed on.
     */
    function detectChangesInRootView(lView) {
        tickRootContext(lView[CONTEXT]);
    }
    function checkNoChangesInternal(tView, view, context) {
        setIsInCheckNoChangesMode(true);
        try {
            detectChangesInternal(tView, view, context);
        }
        finally {
            setIsInCheckNoChangesMode(false);
        }
    }
    /**
     * Checks the change detector on a root view and its components, and throws if any changes are
     * detected.
     *
     * This is used in development mode to verify that running change detection doesn't
     * introduce other changes.
     *
     * @param lView The view which the change detection should be checked on.
     */
    function checkNoChangesInRootView(lView) {
        setIsInCheckNoChangesMode(true);
        try {
            detectChangesInRootView(lView);
        }
        finally {
            setIsInCheckNoChangesMode(false);
        }
    }
    function executeViewQueryFn(flags, viewQueryFn, component) {
        ngDevMode && assertDefined(viewQueryFn, 'View queries function to execute must be defined.');
        setCurrentQueryIndex(0);
        viewQueryFn(flags, component);
    }
    ///////////////////////////////
    //// Bindings & interpolations
    ///////////////////////////////
    /**
     * Stores meta-data for a property binding to be used by TestBed's `DebugElement.properties`.
     *
     * In order to support TestBed's `DebugElement.properties` we need to save, for each binding:
     * - a bound property name;
     * - a static parts of interpolated strings;
     *
     * A given property metadata is saved at the binding's index in the `TView.data` (in other words, a
     * property binding metadata will be stored in `TView.data` at the same index as a bound value in
     * `LView`). Metadata are represented as `INTERPOLATION_DELIMITER`-delimited string with the
     * following format:
     * - `propertyName` for bound properties;
     * - `propertyName�prefix�interpolation_static_part1�..interpolation_static_partN�suffix` for
     * interpolated properties.
     *
     * @param tData `TData` where meta-data will be saved;
     * @param tNode `TNode` that is a target of the binding;
     * @param propertyName bound property name;
     * @param bindingIndex binding index in `LView`
     * @param interpolationParts static interpolation parts (for property interpolations)
     */
    function storePropertyBindingMetadata(tData, tNode, propertyName, bindingIndex) {
        var interpolationParts = [];
        for (var _i = 4; _i < arguments.length; _i++) {
            interpolationParts[_i - 4] = arguments[_i];
        }
        // Binding meta-data are stored only the first time a given property instruction is processed.
        // Since we don't have a concept of the "first update pass" we need to check for presence of the
        // binding meta-data to decide if one should be stored (or if was stored already).
        if (tData[bindingIndex] === null) {
            if (tNode.inputs == null || !tNode.inputs[propertyName]) {
                var propBindingIdxs = tNode.propertyBindings || (tNode.propertyBindings = []);
                propBindingIdxs.push(bindingIndex);
                var bindingMetadata = propertyName;
                if (interpolationParts.length > 0) {
                    bindingMetadata +=
                        INTERPOLATION_DELIMITER + interpolationParts.join(INTERPOLATION_DELIMITER);
                }
                tData[bindingIndex] = bindingMetadata;
            }
        }
    }
    var CLEAN_PROMISE = _CLEAN_PROMISE;
    function getOrCreateLViewCleanup(view) {
        // top level variables should not be exported for performance reasons (PERF_NOTES.md)
        return view[CLEANUP] || (view[CLEANUP] = ngDevMode ? new LCleanup() : []);
    }
    function getOrCreateTViewCleanup(tView) {
        return tView.cleanup || (tView.cleanup = ngDevMode ? new TCleanup() : []);
    }
    /**
     * There are cases where the sub component's renderer needs to be included
     * instead of the current renderer (see the componentSyntheticHost* instructions).
     */
    function loadComponentRenderer(currentDef, tNode, lView) {
        // TODO(FW-2043): the `currentDef` is null when host bindings are invoked while creating root
        // component (see packages/core/src/render3/component.ts). This is not consistent with the process
        // of creating inner components, when current directive index is available in the state. In order
        // to avoid relying on current def being `null` (thus special-casing root component creation), the
        // process of creating root component should be unified with the process of creating inner
        // components.
        if (currentDef === null || isComponentDef(currentDef)) {
            lView = unwrapLView(lView[tNode.index]);
        }
        return lView[RENDERER];
    }
    /** Handles an error thrown in an LView. */
    function handleError(lView, error) {
        var injector = lView[INJECTOR];
        var errorHandler = injector ? injector.get(ErrorHandler, null) : null;
        errorHandler && errorHandler.handleError(error);
    }
    /**
     * Set the inputs of directives at the current node to corresponding value.
     *
     * @param tView The current TView
     * @param lView the `LView` which contains the directives.
     * @param inputs mapping between the public "input" name and privately-known,
     *        possibly minified, property names to write to.
     * @param value Value to set.
     */
    function setInputsForProperty(tView, lView, inputs, publicName, value) {
        for (var i = 0; i < inputs.length;) {
            var index = inputs[i++];
            var privateName = inputs[i++];
            var instance = lView[index];
            ngDevMode && assertIndexInRange(lView, index);
            var def = tView.data[index];
            if (def.setInput !== null) {
                def.setInput(instance, value, publicName, privateName);
            }
            else {
                instance[privateName] = value;
            }
        }
    }
    /**
     * Updates a text binding at a given index in a given LView.
     */
    function textBindingInternal(lView, index, value) {
        ngDevMode && assertString(value, 'Value should be a string');
        ngDevMode && assertNotSame(value, NO_CHANGE, 'value should not be NO_CHANGE');
        ngDevMode && assertIndexInRange(lView, index);
        var element = getNativeByIndex(index, lView);
        ngDevMode && assertDefined(element, 'native element should exist');
        updateTextNode(lView[RENDERER], element, value);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Compute the static styling (class/style) from `TAttributes`.
     *
     * This function should be called during `firstCreatePass` only.
     *
     * @param tNode The `TNode` into which the styling information should be loaded.
     * @param attrs `TAttributes` containing the styling information.
     * @param writeToHost Where should the resulting static styles be written?
     *   - `false` Write to `TNode.stylesWithoutHost` / `TNode.classesWithoutHost`
     *   - `true` Write to `TNode.styles` / `TNode.classes`
     */
    function computeStaticStyling(tNode, attrs, writeToHost) {
        ngDevMode &&
            assertFirstCreatePass(getTView(), 'Expecting to be called in first template pass only');
        var styles = writeToHost ? tNode.styles : null;
        var classes = writeToHost ? tNode.classes : null;
        var mode = 0;
        if (attrs !== null) {
            for (var i = 0; i < attrs.length; i++) {
                var value = attrs[i];
                if (typeof value === 'number') {
                    mode = value;
                }
                else if (mode == 1 /* Classes */) {
                    classes = concatStringsWithSpace(classes, value);
                }
                else if (mode == 2 /* Styles */) {
                    var style = value;
                    var styleValue = attrs[++i];
                    styles = concatStringsWithSpace(styles, style + ': ' + styleValue + ';');
                }
            }
        }
        writeToHost ? tNode.styles = styles : tNode.stylesWithoutHost = styles;
        writeToHost ? tNode.classes = classes : tNode.classesWithoutHost = classes;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Synchronously perform change detection on a component (and possibly its sub-components).
     *
     * This function triggers change detection in a synchronous way on a component.
     *
     * @param component The component which the change detection should be performed on.
     */
    function detectChanges(component) {
        var view = getComponentViewByInstance(component);
        detectChangesInternal(view[TVIEW], view, component);
    }
    /**
     * Marks the component as dirty (needing change detection). Marking a component dirty will
     * schedule a change detection on it at some point in the future.
     *
     * Marking an already dirty component as dirty won't do anything. Only one outstanding change
     * detection can be scheduled per component tree.
     *
     * @param component Component to mark as dirty.
     */
    function markDirty(component) {
        ngDevMode && assertDefined(component, 'component');
        var rootView = markViewDirty(getComponentViewByInstance(component));
        ngDevMode && assertDefined(rootView[CONTEXT], 'rootContext should be defined');
        scheduleTick(rootView[CONTEXT], 1 /* DetectChanges */);
    }
    /**
     * Used to perform change detection on the whole application.
     *
     * This is equivalent to `detectChanges`, but invoked on root component. Additionally, `tick`
     * executes lifecycle hooks and conditionally checks components based on their
     * `ChangeDetectionStrategy` and dirtiness.
     *
     * The preferred way to trigger change detection is to call `markDirty`. `markDirty` internally
     * schedules `tick` using a scheduler in order to coalesce multiple `markDirty` calls into a
     * single change detection run. By default, the scheduler is `requestAnimationFrame`, but can
     * be changed when calling `renderComponent` and providing the `scheduler` option.
     */
    function tick(component) {
        var rootView = getRootView(component);
        var rootContext = rootView[CONTEXT];
        tickRootContext(rootContext);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * An InjectionToken that gets the current `Injector` for `createInjector()`-style injectors.
     *
     * Requesting this token instead of `Injector` allows `StaticInjector` to be tree-shaken from a
     * project.
     *
     * @publicApi
     */
    var INJECTOR$1 = new InjectionToken('INJECTOR', 
    // Dissable tslint because this is const enum which gets inlined not top level prop access.
    // tslint:disable-next-line: no-toplevel-property-access
    -1 /* Injector */);

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var NullInjector = /** @class */ (function () {
        function NullInjector() {
        }
        NullInjector.prototype.get = function (token, notFoundValue) {
            if (notFoundValue === void 0) { notFoundValue = THROW_IF_NOT_FOUND; }
            if (notFoundValue === THROW_IF_NOT_FOUND) {
                var error = new Error("NullInjectorError: No provider for " + stringify(token) + "!");
                error.name = 'NullInjectorError';
                throw error;
            }
            return notFoundValue;
        };
        return NullInjector;
    }());

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * An internal token whose presence in an injector indicates that the injector should treat itself
     * as a root scoped injector when processing requests for unknown tokens which may indicate
     * they are provided in the root scope.
     */
    var INJECTOR_SCOPE = new InjectionToken('Set Injector scope.');

    /**
     * Marker which indicates that a value has not yet been created from the factory function.
     */
    var NOT_YET = {};
    /**
     * Marker which indicates that the factory function for a token is in the process of being called.
     *
     * If the injector is asked to inject a token with its value set to CIRCULAR, that indicates
     * injection of a dependency has recursively attempted to inject the original token, and there is
     * a circular dependency among the providers.
     */
    var CIRCULAR = {};
    var EMPTY_ARRAY$2 = [];
    /**
     * A lazily initialized NullInjector.
     */
    var NULL_INJECTOR = undefined;
    function getNullInjector() {
        if (NULL_INJECTOR === undefined) {
            NULL_INJECTOR = new NullInjector();
        }
        return NULL_INJECTOR;
    }
    /**
     * Create a new `Injector` which is configured using a `defType` of `InjectorType<any>`s.
     *
     * @publicApi
     */
    function createInjector(defType, parent, additionalProviders, name) {
        if (parent === void 0) { parent = null; }
        if (additionalProviders === void 0) { additionalProviders = null; }
        var injector = createInjectorWithoutInjectorInstances(defType, parent, additionalProviders, name);
        injector._resolveInjectorDefTypes();
        return injector;
    }
    /**
     * Creates a new injector without eagerly resolving its injector types. Can be used in places
     * where resolving the injector types immediately can lead to an infinite loop. The injector types
     * should be resolved at a later point by calling `_resolveInjectorDefTypes`.
     */
    function createInjectorWithoutInjectorInstances(defType, parent, additionalProviders, name) {
        if (parent === void 0) { parent = null; }
        if (additionalProviders === void 0) { additionalProviders = null; }
        return new R3Injector(defType, additionalProviders, parent || getNullInjector(), name);
    }
    var R3Injector = /** @class */ (function () {
        function R3Injector(def, additionalProviders, parent, source) {
            var _this = this;
            if (source === void 0) { source = null; }
            this.parent = parent;
            /**
             * Map of tokens to records which contain the instances of those tokens.
             * - `null` value implies that we don't have the record. Used by tree-shakable injectors
             * to prevent further searches.
             */
            this.records = new Map();
            /**
             * The transitive set of `InjectorType`s which define this injector.
             */
            this.injectorDefTypes = new Set();
            /**
             * Set of values instantiated by this injector which contain `ngOnDestroy` lifecycle hooks.
             */
            this.onDestroy = new Set();
            this._destroyed = false;
            var dedupStack = [];
            // Start off by creating Records for every provider declared in every InjectorType
            // included transitively in additional providers then do the same for `def`. This order is
            // important because `def` may include providers that override ones in additionalProviders.
            additionalProviders &&
                deepForEach(additionalProviders, function (provider) { return _this.processProvider(provider, def, additionalProviders); });
            deepForEach([def], function (injectorDef) { return _this.processInjectorType(injectorDef, [], dedupStack); });
            // Make sure the INJECTOR token provides this injector.
            this.records.set(INJECTOR$1, makeRecord(undefined, this));
            // Detect whether this injector has the APP_ROOT_SCOPE token and thus should provide
            // any injectable scoped to APP_ROOT_SCOPE.
            var record = this.records.get(INJECTOR_SCOPE);
            this.scope = record != null ? record.value : null;
            // Source name, used for debugging
            this.source = source || (typeof def === 'object' ? null : stringify(def));
        }
        Object.defineProperty(R3Injector.prototype, "destroyed", {
            /**
             * Flag indicating that this injector was previously destroyed.
             */
            get: function () {
                return this._destroyed;
            },
            enumerable: false,
            configurable: true
        });
        /**
         * Destroy the injector and release references to every instance or provider associated with it.
         *
         * Also calls the `OnDestroy` lifecycle hooks of every instance that was created for which a
         * hook was found.
         */
        R3Injector.prototype.destroy = function () {
            this.assertNotDestroyed();
            // Set destroyed = true first, in case lifecycle hooks re-enter destroy().
            this._destroyed = true;
            try {
                // Call all the lifecycle hooks.
                this.onDestroy.forEach(function (service) { return service.ngOnDestroy(); });
            }
            finally {
                // Release all references.
                this.records.clear();
                this.onDestroy.clear();
                this.injectorDefTypes.clear();
            }
        };
        R3Injector.prototype.get = function (token, notFoundValue, flags) {
            if (notFoundValue === void 0) { notFoundValue = THROW_IF_NOT_FOUND; }
            if (flags === void 0) { flags = exports.InjectFlags.Default; }
            this.assertNotDestroyed();
            // Set the injection context.
            var previousInjector = setCurrentInjector(this);
            try {
                // Check for the SkipSelf flag.
                if (!(flags & exports.InjectFlags.SkipSelf)) {
                    // SkipSelf isn't set, check if the record belongs to this injector.
                    var record = this.records.get(token);
                    if (record === undefined) {
                        // No record, but maybe the token is scoped to this injector. Look for an injectable
                        // def with a scope matching this injector.
                        var def = couldBeInjectableType(token) && getInjectableDef(token);
                        if (def && this.injectableDefInScope(def)) {
                            // Found an injectable def and it's scoped to this injector. Pretend as if it was here
                            // all along.
                            record = makeRecord(injectableDefOrInjectorDefFactory(token), NOT_YET);
                        }
                        else {
                            record = null;
                        }
                        this.records.set(token, record);
                    }
                    // If a record was found, get the instance for it and return it.
                    if (record != null /* NOT null || undefined */) {
                        return this.hydrate(token, record);
                    }
                }
                // Select the next injector based on the Self flag - if self is set, the next injector is
                // the NullInjector, otherwise it's the parent.
                var nextInjector = !(flags & exports.InjectFlags.Self) ? this.parent : getNullInjector();
                // Set the notFoundValue based on the Optional flag - if optional is set and notFoundValue
                // is undefined, the value is null, otherwise it's the notFoundValue.
                notFoundValue = (flags & exports.InjectFlags.Optional) && notFoundValue === THROW_IF_NOT_FOUND ?
                    null :
                    notFoundValue;
                return nextInjector.get(token, notFoundValue);
            }
            catch (e) {
                if (e.name === 'NullInjectorError') {
                    var path = e[NG_TEMP_TOKEN_PATH] = e[NG_TEMP_TOKEN_PATH] || [];
                    path.unshift(stringify(token));
                    if (previousInjector) {
                        // We still have a parent injector, keep throwing
                        throw e;
                    }
                    else {
                        // Format & throw the final error message when we don't have any previous injector
                        return catchInjectorError(e, token, 'R3InjectorError', this.source);
                    }
                }
                else {
                    throw e;
                }
            }
            finally {
                // Lastly, clean up the state by restoring the previous injector.
                setCurrentInjector(previousInjector);
            }
        };
        /** @internal */
        R3Injector.prototype._resolveInjectorDefTypes = function () {
            var _this = this;
            this.injectorDefTypes.forEach(function (defType) { return _this.get(defType); });
        };
        R3Injector.prototype.toString = function () {
            var tokens = [], records = this.records;
            records.forEach(function (v, token) { return tokens.push(stringify(token)); });
            return "R3Injector[" + tokens.join(', ') + "]";
        };
        R3Injector.prototype.assertNotDestroyed = function () {
            if (this._destroyed) {
                throw new Error('Injector has already been destroyed.');
            }
        };
        /**
         * Add an `InjectorType` or `InjectorTypeWithProviders` and all of its transitive providers
         * to this injector.
         *
         * If an `InjectorTypeWithProviders` that declares providers besides the type is specified,
         * the function will return "true" to indicate that the providers of the type definition need
         * to be processed. This allows us to process providers of injector types after all imports of
         * an injector definition are processed. (following View Engine semantics: see FW-1349)
         */
        R3Injector.prototype.processInjectorType = function (defOrWrappedDef, parents, dedupStack) {
            var _this = this;
            defOrWrappedDef = resolveForwardRef(defOrWrappedDef);
            if (!defOrWrappedDef)
                return false;
            // Either the defOrWrappedDef is an InjectorType (with injector def) or an
            // InjectorDefTypeWithProviders (aka ModuleWithProviders). Detecting either is a megamorphic
            // read, so care is taken to only do the read once.
            // First attempt to read the injector def (`ɵinj`).
            var def = getInjectorDef(defOrWrappedDef);
            // If that's not present, then attempt to read ngModule from the InjectorDefTypeWithProviders.
            var ngModule = (def == null) && defOrWrappedDef.ngModule || undefined;
            // Determine the InjectorType. In the case where `defOrWrappedDef` is an `InjectorType`,
            // then this is easy. In the case of an InjectorDefTypeWithProviders, then the definition type
            // is the `ngModule`.
            var defType = (ngModule === undefined) ? defOrWrappedDef : ngModule;
            // Check for circular dependencies.
            if (ngDevMode && parents.indexOf(defType) !== -1) {
                var defName = stringify(defType);
                var path = parents.map(stringify);
                throwCyclicDependencyError(defName, path);
            }
            // Check for multiple imports of the same module
            var isDuplicate = dedupStack.indexOf(defType) !== -1;
            // Finally, if defOrWrappedType was an `InjectorDefTypeWithProviders`, then the actual
            // `InjectorDef` is on its `ngModule`.
            if (ngModule !== undefined) {
                def = getInjectorDef(ngModule);
            }
            // If no definition was found, it might be from exports. Remove it.
            if (def == null) {
                return false;
            }
            // Add providers in the same way that @NgModule resolution did:
            // First, include providers from any imports.
            if (def.imports != null && !isDuplicate) {
                // Before processing defType's imports, add it to the set of parents. This way, if it ends
                // up deeply importing itself, this can be detected.
                ngDevMode && parents.push(defType);
                // Add it to the set of dedups. This way we can detect multiple imports of the same module
                dedupStack.push(defType);
                var importTypesWithProviders_1;
                try {
                    deepForEach(def.imports, function (imported) {
                        if (_this.processInjectorType(imported, parents, dedupStack)) {
                            if (importTypesWithProviders_1 === undefined)
                                importTypesWithProviders_1 = [];
                            // If the processed import is an injector type with providers, we store it in the
                            // list of import types with providers, so that we can process those afterwards.
                            importTypesWithProviders_1.push(imported);
                        }
                    });
                }
                finally {
                    // Remove it from the parents set when finished.
                    ngDevMode && parents.pop();
                }
                // Imports which are declared with providers (TypeWithProviders) need to be processed
                // after all imported modules are processed. This is similar to how View Engine
                // processes/merges module imports in the metadata resolver. See: FW-1349.
                if (importTypesWithProviders_1 !== undefined) {
                    var _loop_1 = function (i) {
                        var _a = importTypesWithProviders_1[i], ngModule_1 = _a.ngModule, providers = _a.providers;
                        deepForEach(providers, function (provider) { return _this.processProvider(provider, ngModule_1, providers || EMPTY_ARRAY$2); });
                    };
                    for (var i = 0; i < importTypesWithProviders_1.length; i++) {
                        _loop_1(i);
                    }
                }
            }
            // Track the InjectorType and add a provider for it. It's important that this is done after the
            // def's imports.
            this.injectorDefTypes.add(defType);
            var factory = getFactoryDef(defType) || (function () { return new defType(); });
            this.records.set(defType, makeRecord(factory, NOT_YET));
            // Next, include providers listed on the definition itself.
            var defProviders = def.providers;
            if (defProviders != null && !isDuplicate) {
                var injectorType_1 = defOrWrappedDef;
                deepForEach(defProviders, function (provider) { return _this.processProvider(provider, injectorType_1, defProviders); });
            }
            return (ngModule !== undefined &&
                defOrWrappedDef.providers !== undefined);
        };
        /**
         * Process a `SingleProvider` and add it.
         */
        R3Injector.prototype.processProvider = function (provider, ngModuleType, providers) {
            // Determine the token from the provider. Either it's its own token, or has a {provide: ...}
            // property.
            provider = resolveForwardRef(provider);
            var token = isTypeProvider(provider) ? provider : resolveForwardRef(provider && provider.provide);
            // Construct a `Record` for the provider.
            var record = providerToRecord(provider, ngModuleType, providers);
            if (!isTypeProvider(provider) && provider.multi === true) {
                // If the provider indicates that it's a multi-provider, process it specially.
                // First check whether it's been defined already.
                var multiRecord_1 = this.records.get(token);
                if (multiRecord_1) {
                    // It has. Throw a nice error if
                    if (ngDevMode && multiRecord_1.multi === undefined) {
                        throwMixedMultiProviderError();
                    }
                }
                else {
                    multiRecord_1 = makeRecord(undefined, NOT_YET, true);
                    multiRecord_1.factory = function () { return injectArgs(multiRecord_1.multi); };
                    this.records.set(token, multiRecord_1);
                }
                token = provider;
                multiRecord_1.multi.push(provider);
            }
            else {
                var existing = this.records.get(token);
                if (ngDevMode && existing && existing.multi !== undefined) {
                    throwMixedMultiProviderError();
                }
            }
            this.records.set(token, record);
        };
        R3Injector.prototype.hydrate = function (token, record) {
            if (ngDevMode && record.value === CIRCULAR) {
                throwCyclicDependencyError(stringify(token));
            }
            else if (record.value === NOT_YET) {
                record.value = CIRCULAR;
                record.value = record.factory();
            }
            if (typeof record.value === 'object' && record.value && hasOnDestroy(record.value)) {
                this.onDestroy.add(record.value);
            }
            return record.value;
        };
        R3Injector.prototype.injectableDefInScope = function (def) {
            if (!def.providedIn) {
                return false;
            }
            else if (typeof def.providedIn === 'string') {
                return def.providedIn === 'any' || (def.providedIn === this.scope);
            }
            else {
                return this.injectorDefTypes.has(def.providedIn);
            }
        };
        return R3Injector;
    }());
    function injectableDefOrInjectorDefFactory(token) {
        // Most tokens will have an injectable def directly on them, which specifies a factory directly.
        var injectableDef = getInjectableDef(token);
        var factory = injectableDef !== null ? injectableDef.factory : getFactoryDef(token);
        if (factory !== null) {
            return factory;
        }
        // InjectionTokens should have an injectable def (ɵprov) and thus should be handled above.
        // If it's missing that, it's an error.
        if (token instanceof InjectionToken) {
            throw new Error("Token " + stringify(token) + " is missing a \u0275prov definition.");
        }
        // Undecorated types can sometimes be created if they have no constructor arguments.
        if (token instanceof Function) {
            return getUndecoratedInjectableFactory(token);
        }
        // There was no way to resolve a factory for this token.
        throw new Error('unreachable');
    }
    function getUndecoratedInjectableFactory(token) {
        // If the token has parameters then it has dependencies that we cannot resolve implicitly.
        var paramLength = token.length;
        if (paramLength > 0) {
            var args = newArray(paramLength, '?');
            throw new Error("Can't resolve all parameters for " + stringify(token) + ": (" + args.join(', ') + ").");
        }
        // The constructor function appears to have no parameters.
        // This might be because it inherits from a super-class. In which case, use an injectable
        // def from an ancestor if there is one.
        // Otherwise this really is a simple class with no dependencies, so return a factory that
        // just instantiates the zero-arg constructor.
        var inheritedInjectableDef = getInheritedInjectableDef(token);
        if (inheritedInjectableDef !== null) {
            return function () { return inheritedInjectableDef.factory(token); };
        }
        else {
            return function () { return new token(); };
        }
    }
    function providerToRecord(provider, ngModuleType, providers) {
        if (isValueProvider(provider)) {
            return makeRecord(undefined, provider.useValue);
        }
        else {
            var factory = providerToFactory(provider, ngModuleType, providers);
            return makeRecord(factory, NOT_YET);
        }
    }
    /**
     * Converts a `SingleProvider` into a factory function.
     *
     * @param provider provider to convert to factory
     */
    function providerToFactory(provider, ngModuleType, providers) {
        var factory = undefined;
        if (isTypeProvider(provider)) {
            var unwrappedProvider = resolveForwardRef(provider);
            return getFactoryDef(unwrappedProvider) || injectableDefOrInjectorDefFactory(unwrappedProvider);
        }
        else {
            if (isValueProvider(provider)) {
                factory = function () { return resolveForwardRef(provider.useValue); };
            }
            else if (isFactoryProvider(provider)) {
                factory = function () { return provider.useFactory.apply(provider, __spread(injectArgs(provider.deps || []))); };
            }
            else if (isExistingProvider(provider)) {
                factory = function () { return ɵɵinject(resolveForwardRef(provider.useExisting)); };
            }
            else {
                var classRef_1 = resolveForwardRef(provider &&
                    (provider.useClass || provider.provide));
                if (ngDevMode && !classRef_1) {
                    throwInvalidProviderError(ngModuleType, providers, provider);
                }
                if (hasDeps(provider)) {
                    factory = function () { return new ((classRef_1).bind.apply((classRef_1), __spread([void 0], injectArgs(provider.deps))))(); };
                }
                else {
                    return getFactoryDef(classRef_1) || injectableDefOrInjectorDefFactory(classRef_1);
                }
            }
        }
        return factory;
    }
    function makeRecord(factory, value, multi) {
        if (multi === void 0) { multi = false; }
        return {
            factory: factory,
            value: value,
            multi: multi ? [] : undefined,
        };
    }
    function isValueProvider(value) {
        return value !== null && typeof value == 'object' && USE_VALUE in value;
    }
    function isExistingProvider(value) {
        return !!(value && value.useExisting);
    }
    function isFactoryProvider(value) {
        return !!(value && value.useFactory);
    }
    function isTypeProvider(value) {
        return typeof value === 'function';
    }
    function isClassProvider(value) {
        return !!value.useClass;
    }
    function hasDeps(value) {
        return !!value.deps;
    }
    function hasOnDestroy(value) {
        return value !== null && typeof value === 'object' &&
            typeof value.ngOnDestroy === 'function';
    }
    function couldBeInjectableType(value) {
        return (typeof value === 'function') ||
            (typeof value === 'object' && value instanceof InjectionToken);
    }

    function INJECTOR_IMPL__PRE_R3__(providers, parent, name) {
        return new StaticInjector(providers, parent, name);
    }
    function INJECTOR_IMPL__POST_R3__(providers, parent, name) {
        return createInjector({ name: name }, parent, providers, name);
    }
    var INJECTOR_IMPL = INJECTOR_IMPL__PRE_R3__;
    /**
     * Concrete injectors implement this interface. Injectors are configured
     * with [providers](guide/glossary#provider) that associate
     * dependencies of various types with [injection tokens](guide/glossary#di-token).
     *
     * @see ["DI Providers"](guide/dependency-injection-providers).
     * @see `StaticProvider`
     *
     * @usageNotes
     *
     *  The following example creates a service injector instance.
     *
     * {@example core/di/ts/provider_spec.ts region='ConstructorProvider'}
     *
     * ### Usage example
     *
     * {@example core/di/ts/injector_spec.ts region='Injector'}
     *
     * `Injector` returns itself when given `Injector` as a token:
     *
     * {@example core/di/ts/injector_spec.ts region='injectInjector'}
     *
     * @publicApi
     */
    var Injector = /** @class */ (function () {
        function Injector() {
        }
        Injector.create = function (options, parent) {
            if (Array.isArray(options)) {
                return INJECTOR_IMPL(options, parent, '');
            }
            else {
                return INJECTOR_IMPL(options.providers, options.parent, options.name || '');
            }
        };
        return Injector;
    }());
    Injector.THROW_IF_NOT_FOUND = THROW_IF_NOT_FOUND;
    Injector.NULL = new NullInjector();
    /** @nocollapse */
    Injector.ɵprov = ɵɵdefineInjectable({
        token: Injector,
        providedIn: 'any',
        factory: function () { return ɵɵinject(INJECTOR$1); },
    });
    /**
     * @internal
     * @nocollapse
     */
    Injector.__NG_ELEMENT_ID__ = -1 /* Injector */;
    var IDENT = function (value) {
        return value;
    };
    var ɵ0$6 = IDENT;
    var EMPTY = [];
    var CIRCULAR$1 = IDENT;
    var MULTI_PROVIDER_FN = function () {
        return Array.prototype.slice.call(arguments);
    };
    var ɵ1$1 = MULTI_PROVIDER_FN;
    var NO_NEW_LINE$1 = 'ɵ';
    var StaticInjector = /** @class */ (function () {
        function StaticInjector(providers, parent, source) {
            if (parent === void 0) { parent = Injector.NULL; }
            if (source === void 0) { source = null; }
            this.parent = parent;
            this.source = source;
            var records = this._records = new Map();
            records.set(Injector, { token: Injector, fn: IDENT, deps: EMPTY, value: this, useNew: false });
            records.set(INJECTOR$1, { token: INJECTOR$1, fn: IDENT, deps: EMPTY, value: this, useNew: false });
            this.scope = recursivelyProcessProviders(records, providers);
        }
        StaticInjector.prototype.get = function (token, notFoundValue, flags) {
            if (flags === void 0) { flags = exports.InjectFlags.Default; }
            var records = this._records;
            var record = records.get(token);
            if (record === undefined) {
                // This means we have never seen this record, see if it is tree shakable provider.
                var injectableDef = getInjectableDef(token);
                if (injectableDef) {
                    var providedIn = injectableDef && injectableDef.providedIn;
                    if (providedIn === 'any' || providedIn != null && providedIn === this.scope) {
                        records.set(token, record = resolveProvider({ provide: token, useFactory: injectableDef.factory, deps: EMPTY }));
                    }
                }
                if (record === undefined) {
                    // Set record to null to make sure that we don't go through expensive lookup above again.
                    records.set(token, null);
                }
            }
            var lastInjector = setCurrentInjector(this);
            try {
                return tryResolveToken(token, record, records, this.parent, notFoundValue, flags);
            }
            catch (e) {
                return catchInjectorError(e, token, 'StaticInjectorError', this.source);
            }
            finally {
                setCurrentInjector(lastInjector);
            }
        };
        StaticInjector.prototype.toString = function () {
            var tokens = [], records = this._records;
            records.forEach(function (v, token) { return tokens.push(stringify(token)); });
            return "StaticInjector[" + tokens.join(', ') + "]";
        };
        return StaticInjector;
    }());
    function resolveProvider(provider) {
        var deps = computeDeps(provider);
        var fn = IDENT;
        var value = EMPTY;
        var useNew = false;
        var provide = resolveForwardRef(provider.provide);
        if (USE_VALUE in provider) {
            // We need to use USE_VALUE in provider since provider.useValue could be defined as undefined.
            value = provider.useValue;
        }
        else if (provider.useFactory) {
            fn = provider.useFactory;
        }
        else if (provider.useExisting) {
            // Just use IDENT
        }
        else if (provider.useClass) {
            useNew = true;
            fn = resolveForwardRef(provider.useClass);
        }
        else if (typeof provide == 'function') {
            useNew = true;
            fn = provide;
        }
        else {
            throw staticError('StaticProvider does not have [useValue|useFactory|useExisting|useClass] or [provide] is not newable', provider);
        }
        return { deps: deps, fn: fn, useNew: useNew, value: value };
    }
    function multiProviderMixError(token) {
        return staticError('Cannot mix multi providers and regular providers', token);
    }
    function recursivelyProcessProviders(records, provider) {
        var scope = null;
        if (provider) {
            provider = resolveForwardRef(provider);
            if (Array.isArray(provider)) {
                // if we have an array recurse into the array
                for (var i = 0; i < provider.length; i++) {
                    scope = recursivelyProcessProviders(records, provider[i]) || scope;
                }
            }
            else if (typeof provider === 'function') {
                // Functions were supported in ReflectiveInjector, but are not here. For safety give useful
                // error messages
                throw staticError('Function/Class not supported', provider);
            }
            else if (provider && typeof provider === 'object' && provider.provide) {
                // At this point we have what looks like a provider: {provide: ?, ....}
                var token = resolveForwardRef(provider.provide);
                var resolvedProvider = resolveProvider(provider);
                if (provider.multi === true) {
                    // This is a multi provider.
                    var multiProvider = records.get(token);
                    if (multiProvider) {
                        if (multiProvider.fn !== MULTI_PROVIDER_FN) {
                            throw multiProviderMixError(token);
                        }
                    }
                    else {
                        // Create a placeholder factory which will look up the constituents of the multi provider.
                        records.set(token, multiProvider = {
                            token: provider.provide,
                            deps: [],
                            useNew: false,
                            fn: MULTI_PROVIDER_FN,
                            value: EMPTY
                        });
                    }
                    // Treat the provider as the token.
                    token = provider;
                    multiProvider.deps.push({ token: token, options: 6 /* Default */ });
                }
                var record = records.get(token);
                if (record && record.fn == MULTI_PROVIDER_FN) {
                    throw multiProviderMixError(token);
                }
                if (token === INJECTOR_SCOPE) {
                    scope = resolvedProvider.value;
                }
                records.set(token, resolvedProvider);
            }
            else {
                throw staticError('Unexpected provider', provider);
            }
        }
        return scope;
    }
    function tryResolveToken(token, record, records, parent, notFoundValue, flags) {
        try {
            return resolveToken(token, record, records, parent, notFoundValue, flags);
        }
        catch (e) {
            // ensure that 'e' is of type Error.
            if (!(e instanceof Error)) {
                e = new Error(e);
            }
            var path = e[NG_TEMP_TOKEN_PATH] = e[NG_TEMP_TOKEN_PATH] || [];
            path.unshift(token);
            if (record && record.value == CIRCULAR$1) {
                // Reset the Circular flag.
                record.value = EMPTY;
            }
            throw e;
        }
    }
    function resolveToken(token, record, records, parent, notFoundValue, flags) {
        var value;
        if (record && !(flags & exports.InjectFlags.SkipSelf)) {
            // If we don't have a record, this implies that we don't own the provider hence don't know how
            // to resolve it.
            value = record.value;
            if (value == CIRCULAR$1) {
                throw Error(NO_NEW_LINE$1 + 'Circular dependency');
            }
            else if (value === EMPTY) {
                record.value = CIRCULAR$1;
                var obj = undefined;
                var useNew = record.useNew;
                var fn = record.fn;
                var depRecords = record.deps;
                var deps = EMPTY;
                if (depRecords.length) {
                    deps = [];
                    for (var i = 0; i < depRecords.length; i++) {
                        var depRecord = depRecords[i];
                        var options = depRecord.options;
                        var childRecord = options & 2 /* CheckSelf */ ? records.get(depRecord.token) : undefined;
                        deps.push(tryResolveToken(
                        // Current Token to resolve
                        depRecord.token, 
                        // A record which describes how to resolve the token.
                        // If undefined, this means we don't have such a record
                        childRecord, 
                        // Other records we know about.
                        records, 
                        // If we don't know how to resolve dependency and we should not check parent for it,
                        // than pass in Null injector.
                        !childRecord && !(options & 4 /* CheckParent */) ? Injector.NULL : parent, options & 1 /* Optional */ ? null : Injector.THROW_IF_NOT_FOUND, exports.InjectFlags.Default));
                    }
                }
                record.value = value = useNew ? new (fn.bind.apply(fn, __spread([void 0], deps)))() : fn.apply(obj, deps);
            }
        }
        else if (!(flags & exports.InjectFlags.Self)) {
            value = parent.get(token, notFoundValue, exports.InjectFlags.Default);
        }
        else if (!(flags & exports.InjectFlags.Optional)) {
            value = Injector.NULL.get(token, notFoundValue);
        }
        else {
            value = Injector.NULL.get(token, typeof notFoundValue !== 'undefined' ? notFoundValue : null);
        }
        return value;
    }
    function computeDeps(provider) {
        var deps = EMPTY;
        var providerDeps = provider.deps;
        if (providerDeps && providerDeps.length) {
            deps = [];
            for (var i = 0; i < providerDeps.length; i++) {
                var options = 6 /* Default */;
                var token = resolveForwardRef(providerDeps[i]);
                if (Array.isArray(token)) {
                    for (var j = 0, annotations = token; j < annotations.length; j++) {
                        var annotation = annotations[j];
                        if (annotation instanceof Optional || annotation == Optional) {
                            options = options | 1 /* Optional */;
                        }
                        else if (annotation instanceof SkipSelf || annotation == SkipSelf) {
                            options = options & ~2 /* CheckSelf */;
                        }
                        else if (annotation instanceof Self || annotation == Self) {
                            options = options & ~4 /* CheckParent */;
                        }
                        else if (annotation instanceof Inject) {
                            token = annotation.token;
                        }
                        else {
                            token = resolveForwardRef(annotation);
                        }
                    }
                }
                deps.push({ token: token, options: options });
            }
        }
        else if (provider.useExisting) {
            var token = resolveForwardRef(provider.useExisting);
            deps = [{ token: token, options: 6 /* Default */ }];
        }
        else if (!providerDeps && !(USE_VALUE in provider)) {
            // useValue & useExisting are the only ones which are exempt from deps all others need it.
            throw staticError('\'deps\' required', provider);
        }
        return deps;
    }
    function staticError(text, obj) {
        return new Error(formatError(text, obj, 'StaticInjectorError'));
    }

    /**
     * Retrieves the component instance associated with a given DOM element.
     *
     * @usageNotes
     * Given the following DOM structure:
     * ```html
     * <my-app>
     *   <div>
     *     <child-comp></child-comp>
     *   </div>
     * </my-app>
     * ```
     * Calling `getComponent` on `<child-comp>` will return the instance of `ChildComponent`
     * associated with this DOM element.
     *
     * Calling the function on `<my-app>` will return the `MyApp` instance.
     *
     *
     * @param element DOM element from which the component should be retrieved.
     * @returns Component instance associated with the element or `null` if there
     *    is no component associated with it.
     *
     * @publicApi
     * @globalApi ng
     */
    function getComponent(element) {
        assertDomElement(element);
        var context = loadLContext(element, false);
        if (context === null)
            return null;
        if (context.component === undefined) {
            context.component = getComponentAtNodeIndex(context.nodeIndex, context.lView);
        }
        return context.component;
    }
    /**
     * If inside an embedded view (e.g. `*ngIf` or `*ngFor`), retrieves the context of the embedded
     * view that the element is part of. Otherwise retrieves the instance of the component whose view
     * owns the element (in this case, the result is the same as calling `getOwningComponent`).
     *
     * @param element Element for which to get the surrounding component instance.
     * @returns Instance of the component that is around the element or null if the element isn't
     *    inside any component.
     *
     * @publicApi
     * @globalApi ng
     */
    function getContext(element) {
        assertDomElement(element);
        var context = loadLContext(element, false);
        return context === null ? null : context.lView[CONTEXT];
    }
    /**
     * Retrieves the component instance whose view contains the DOM element.
     *
     * For example, if `<child-comp>` is used in the template of `<app-comp>`
     * (i.e. a `ViewChild` of `<app-comp>`), calling `getOwningComponent` on `<child-comp>`
     * would return `<app-comp>`.
     *
     * @param elementOrDir DOM element, component or directive instance
     *    for which to retrieve the root components.
     * @returns Component instance whose view owns the DOM element or null if the element is not
     *    part of a component view.
     *
     * @publicApi
     * @globalApi ng
     */
    function getOwningComponent(elementOrDir) {
        var context = loadLContext(elementOrDir, false);
        if (context === null)
            return null;
        var lView = context.lView;
        var parent;
        ngDevMode && assertLView(lView);
        while (lView[TVIEW].type === 2 /* Embedded */ && (parent = getLViewParent(lView))) {
            lView = parent;
        }
        return lView[FLAGS] & 512 /* IsRoot */ ? null : lView[CONTEXT];
    }
    /**
     * Retrieves all root components associated with a DOM element, directive or component instance.
     * Root components are those which have been bootstrapped by Angular.
     *
     * @param elementOrDir DOM element, component or directive instance
     *    for which to retrieve the root components.
     * @returns Root components associated with the target object.
     *
     * @publicApi
     * @globalApi ng
     */
    function getRootComponents(elementOrDir) {
        return __spread(getRootContext(elementOrDir).components);
    }
    /**
     * Retrieves an `Injector` associated with an element, component or directive instance.
     *
     * @param elementOrDir DOM element, component or directive instance for which to
     *    retrieve the injector.
     * @returns Injector associated with the element, component or directive instance.
     *
     * @publicApi
     * @globalApi ng
     */
    function getInjector(elementOrDir) {
        var context = loadLContext(elementOrDir, false);
        if (context === null)
            return Injector.NULL;
        var tNode = context.lView[TVIEW].data[context.nodeIndex];
        return new NodeInjector(tNode, context.lView);
    }
    /**
     * Retrieve a set of injection tokens at a given DOM node.
     *
     * @param element Element for which the injection tokens should be retrieved.
     */
    function getInjectionTokens(element) {
        var context = loadLContext(element, false);
        if (context === null)
            return [];
        var lView = context.lView;
        var tView = lView[TVIEW];
        var tNode = tView.data[context.nodeIndex];
        var providerTokens = [];
        var startIndex = tNode.providerIndexes & 1048575 /* ProvidersStartIndexMask */;
        var endIndex = tNode.directiveEnd;
        for (var i = startIndex; i < endIndex; i++) {
            var value = tView.data[i];
            if (isDirectiveDefHack(value)) {
                // The fact that we sometimes store Type and sometimes DirectiveDef in this location is a
                // design flaw.  We should always store same type so that we can be monomorphic. The issue
                // is that for Components/Directives we store the def instead the type. The correct behavior
                // is that we should always be storing injectable type in this location.
                value = value.type;
            }
            providerTokens.push(value);
        }
        return providerTokens;
    }
    /**
     * Retrieves directive instances associated with a given DOM element. Does not include
     * component instances.
     *
     * @usageNotes
     * Given the following DOM structure:
     * ```
     * <my-app>
     *   <button my-button></button>
     *   <my-comp></my-comp>
     * </my-app>
     * ```
     * Calling `getDirectives` on `<button>` will return an array with an instance of the `MyButton`
     * directive that is associated with the DOM element.
     *
     * Calling `getDirectives` on `<my-comp>` will return an empty array.
     *
     * @param element DOM element for which to get the directives.
     * @returns Array of directives associated with the element.
     *
     * @publicApi
     * @globalApi ng
     */
    function getDirectives(element) {
        var context = loadLContext(element);
        if (context.directives === undefined) {
            context.directives = getDirectivesAtNodeIndex(context.nodeIndex, context.lView, false);
        }
        // The `directives` in this case are a named array called `LComponentView`. Clone the
        // result so we don't expose an internal data structure in the user's console.
        return context.directives === null ? [] : __spread(context.directives);
    }
    function loadLContext(target, throwOnNotFound) {
        if (throwOnNotFound === void 0) { throwOnNotFound = true; }
        var context = getLContext(target);
        if (!context && throwOnNotFound) {
            throw new Error(ngDevMode ? "Unable to find context associated with " + stringifyForError(target) :
                'Invalid ng target');
        }
        return context;
    }
    /**
     * Retrieve map of local references.
     *
     * The references are retrieved as a map of local reference name to element or directive instance.
     *
     * @param target DOM element, component or directive instance for which to retrieve
     *    the local references.
     */
    function getLocalRefs(target) {
        var context = loadLContext(target, false);
        if (context === null)
            return {};
        if (context.localRefs === undefined) {
            context.localRefs = discoverLocalRefs(context.lView, context.nodeIndex);
        }
        return context.localRefs || {};
    }
    /**
     * Retrieves the host element of a component or directive instance.
     * The host element is the DOM element that matched the selector of the directive.
     *
     * @param componentOrDirective Component or directive instance for which the host
     *     element should be retrieved.
     * @returns Host element of the target.
     *
     * @publicApi
     * @globalApi ng
     */
    function getHostElement(componentOrDirective) {
        return getLContext(componentOrDirective).native;
    }
    /**
     * Retrieves the rendered text for a given component.
     *
     * This function retrieves the host element of a component and
     * and then returns the `textContent` for that element. This implies
     * that the text returned will include re-projected content of
     * the component as well.
     *
     * @param component The component to return the content text for.
     */
    function getRenderedText(component) {
        var hostElement = getHostElement(component);
        return hostElement.textContent || '';
    }
    function loadLContextFromNode(node) {
        if (!(node instanceof Node))
            throw new Error('Expecting instance of DOM Element');
        return loadLContext(node);
    }
    /**
     * Retrieves a list of event listeners associated with a DOM element. The list does include host
     * listeners, but it does not include event listeners defined outside of the Angular context
     * (e.g. through `addEventListener`).
     *
     * @usageNotes
     * Given the following DOM structure:
     * ```
     * <my-app>
     *   <div (click)="doSomething()"></div>
     * </my-app>
     *
     * ```
     * Calling `getListeners` on `<div>` will return an object that looks as follows:
     * ```
     * {
     *   name: 'click',
     *   element: <div>,
     *   callback: () => doSomething(),
     *   useCapture: false
     * }
     * ```
     *
     * @param element Element for which the DOM listeners should be retrieved.
     * @returns Array of event listeners on the DOM element.
     *
     * @publicApi
     * @globalApi ng
     */
    function getListeners(element) {
        assertDomElement(element);
        var lContext = loadLContext(element, false);
        if (lContext === null)
            return [];
        var lView = lContext.lView;
        var tView = lView[TVIEW];
        var lCleanup = lView[CLEANUP];
        var tCleanup = tView.cleanup;
        var listeners = [];
        if (tCleanup && lCleanup) {
            for (var i = 0; i < tCleanup.length;) {
                var firstParam = tCleanup[i++];
                var secondParam = tCleanup[i++];
                if (typeof firstParam === 'string') {
                    var name = firstParam;
                    var listenerElement = unwrapRNode(lView[secondParam]);
                    var callback = lCleanup[tCleanup[i++]];
                    var useCaptureOrIndx = tCleanup[i++];
                    // if useCaptureOrIndx is boolean then report it as is.
                    // if useCaptureOrIndx is positive number then it in unsubscribe method
                    // if useCaptureOrIndx is negative number then it is a Subscription
                    var type = (typeof useCaptureOrIndx === 'boolean' || useCaptureOrIndx >= 0) ? 'dom' : 'output';
                    var useCapture = typeof useCaptureOrIndx === 'boolean' ? useCaptureOrIndx : false;
                    if (element == listenerElement) {
                        listeners.push({ element: element, name: name, callback: callback, useCapture: useCapture, type: type });
                    }
                }
            }
        }
        listeners.sort(sortListeners);
        return listeners;
    }
    function sortListeners(a, b) {
        if (a.name == b.name)
            return 0;
        return a.name < b.name ? -1 : 1;
    }
    /**
     * This function should not exist because it is megamorphic and only mostly correct.
     *
     * See call site for more info.
     */
    function isDirectiveDefHack(obj) {
        return obj.type !== undefined && obj.template !== undefined && obj.declaredInputs !== undefined;
    }
    /**
     * Returns the attached `DebugNode` instance for an element in the DOM.
     *
     * @param element DOM element which is owned by an existing component's view.
     */
    function getDebugNode(element) {
        var debugNode = null;
        var lContext = loadLContextFromNode(element);
        var lView = lContext.lView;
        var nodeIndex = lContext.nodeIndex;
        if (nodeIndex !== -1) {
            var valueInLView = lView[nodeIndex];
            // this means that value in the lView is a component with its own
            // data. In this situation the TNode is not accessed at the same spot.
            var tNode = isLView(valueInLView) ? valueInLView[T_HOST] : getTNode(lView[TVIEW], nodeIndex);
            ngDevMode &&
                assertEqual(tNode.index, nodeIndex, 'Expecting that TNode at index is same as index');
            debugNode = buildDebugNode(tNode, lView);
        }
        return debugNode;
    }
    /**
     * Retrieve the component `LView` from component/element.
     *
     * NOTE: `LView` is a private and should not be leaked outside.
     *       Don't export this method to `ng.*` on window.
     *
     * @param target DOM element or component instance for which to retrieve the LView.
     */
    function getComponentLView(target) {
        var lContext = loadLContext(target);
        var nodeIndx = lContext.nodeIndex;
        var lView = lContext.lView;
        var componentLView = lView[nodeIndx];
        ngDevMode && assertLView(componentLView);
        return componentLView;
    }
    /** Asserts that a value is a DOM Element. */
    function assertDomElement(value) {
        if (typeof Element !== 'undefined' && !(value instanceof Element)) {
            throw new Error('Expecting instance of DOM Element');
        }
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Marks a component for check (in case of OnPush components) and synchronously
     * performs change detection on the application this component belongs to.
     *
     * @param component Component to {@link ChangeDetectorRef#markForCheck mark for check}.
     *
     * @publicApi
     * @globalApi ng
     */
    function applyChanges(component) {
        markDirty(component);
        getRootComponents(component).forEach(function (rootComponent) { return detectChanges(rootComponent); });
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * This file introduces series of globally accessible debug tools
     * to allow for the Angular debugging story to function.
     *
     * To see this in action run the following command:
     *
     *   bazel run --config=ivy
     *   //packages/core/test/bundling/todo:devserver
     *
     *  Then load `localhost:5432` and start using the console tools.
     */
    /**
     * This value reflects the property on the window where the dev
     * tools are patched (window.ng).
     * */
    var GLOBAL_PUBLISH_EXPANDO_KEY = 'ng';
    var _published = false;
    /**
     * Publishes a collection of default debug tools onto`window.ng`.
     *
     * These functions are available globally when Angular is in development
     * mode and are automatically stripped away from prod mode is on.
     */
    function publishDefaultGlobalUtils() {
        if (!_published) {
            _published = true;
            publishGlobalUtil('getComponent', getComponent);
            publishGlobalUtil('getContext', getContext);
            publishGlobalUtil('getListeners', getListeners);
            publishGlobalUtil('getOwningComponent', getOwningComponent);
            publishGlobalUtil('getHostElement', getHostElement);
            publishGlobalUtil('getInjector', getInjector);
            publishGlobalUtil('getRootComponents', getRootComponents);
            publishGlobalUtil('getDirectives', getDirectives);
            publishGlobalUtil('applyChanges', applyChanges);
        }
    }
    /**
     * Publishes the given function to `window.ng` so that it can be
     * used from the browser console when an application is not in production.
     */
    function publishGlobalUtil(name, fn) {
        if (typeof COMPILED === 'undefined' || !COMPILED) {
            // Note: we can't export `ng` when using closure enhanced optimization as:
            // - closure declares globals itself for minified names, which sometimes clobber our `ng` global
            // - we can't declare a closure extern as the namespace `ng` is already used within Google
            //   for typings for AngularJS (via `goog.provide('ng....')`).
            var w = _global;
            ngDevMode && assertDefined(fn, 'function not defined');
            if (w) {
                var container = w[GLOBAL_PUBLISH_EXPANDO_KEY];
                if (!container) {
                    container = w[GLOBAL_PUBLISH_EXPANDO_KEY] = {};
                }
                container[name] = fn;
            }
        }
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var ɵ0$7 = function (token, notFoundValue) {
        throwProviderNotFoundError(token, 'NullInjector');
    };
    // TODO: A hack to not pull in the NullInjector from @angular/core.
    var NULL_INJECTOR$1 = {
        get: ɵ0$7
    };
    /**
     * Bootstraps a Component into an existing host element and returns an instance
     * of the component.
     *
     * Use this function to bootstrap a component into the DOM tree. Each invocation
     * of this function will create a separate tree of components, injectors and
     * change detection cycles and lifetimes. To dynamically insert a new component
     * into an existing tree such that it shares the same injection, change detection
     * and object lifetime, use {@link ViewContainer#createComponent}.
     *
     * @param componentType Component to bootstrap
     * @param options Optional parameters which control bootstrapping
     */
    function renderComponent$1(componentType /* Type as workaround for: Microsoft/TypeScript/issues/4881 */, opts) {
        if (opts === void 0) { opts = {}; }
        ngDevMode && publishDefaultGlobalUtils();
        ngDevMode && assertComponentType(componentType);
        var rendererFactory = opts.rendererFactory || domRendererFactory3;
        var sanitizer = opts.sanitizer || null;
        var componentDef = getComponentDef(componentType);
        if (componentDef.type != componentType)
            componentDef.type = componentType;
        // The first index of the first selector is the tag name.
        var componentTag = componentDef.selectors[0][0];
        var hostRenderer = rendererFactory.createRenderer(null, null);
        var hostRNode = locateHostElement(hostRenderer, opts.host || componentTag, componentDef.encapsulation);
        var rootFlags = componentDef.onPush ? 64 /* Dirty */ | 512 /* IsRoot */ :
            16 /* CheckAlways */ | 512 /* IsRoot */;
        var rootContext = createRootContext(opts.scheduler, opts.playerHandler);
        var renderer = rendererFactory.createRenderer(hostRNode, componentDef);
        var rootTView = createTView(0 /* Root */, null, null, 1, 0, null, null, null, null, null);
        var rootView = createLView(null, rootTView, rootContext, rootFlags, null, null, rendererFactory, renderer, null, opts.injector || null);
        enterView(rootView);
        var component;
        try {
            if (rendererFactory.begin)
                rendererFactory.begin();
            var componentView = createRootComponentView(hostRNode, componentDef, rootView, rendererFactory, renderer, sanitizer);
            component = createRootComponent(componentView, componentDef, rootView, rootContext, opts.hostFeatures || null);
            // create mode pass
            renderView(rootTView, rootView, null);
            // update mode pass
            refreshView(rootTView, rootView, null, null);
        }
        finally {
            leaveView();
            if (rendererFactory.end)
                rendererFactory.end();
        }
        return component;
    }
    /**
     * Creates the root component view and the root component node.
     *
     * @param rNode Render host element.
     * @param def ComponentDef
     * @param rootView The parent view where the host node is stored
     * @param rendererFactory Factory to be used for creating child renderers.
     * @param hostRenderer The current renderer
     * @param sanitizer The sanitizer, if provided
     *
     * @returns Component view created
     */
    function createRootComponentView(rNode, def, rootView, rendererFactory, hostRenderer, sanitizer) {
        var tView = rootView[TVIEW];
        var index = HEADER_OFFSET;
        ngDevMode && assertIndexInRange(rootView, index);
        rootView[index] = rNode;
        // '#host' is added here as we don't know the real host DOM name (we don't want to read it) and at
        // the same time we want to communicate the debug `TNode` that this is a special `TNode`
        // representing a host element.
        var tNode = getOrCreateTNode(tView, index, 2 /* Element */, '#host', null);
        var mergedAttrs = tNode.mergedAttrs = def.hostAttrs;
        if (mergedAttrs !== null) {
            computeStaticStyling(tNode, mergedAttrs, true);
            if (rNode !== null) {
                setUpAttributes(hostRenderer, rNode, mergedAttrs);
                if (tNode.classes !== null) {
                    writeDirectClass(hostRenderer, rNode, tNode.classes);
                }
                if (tNode.styles !== null) {
                    writeDirectStyle(hostRenderer, rNode, tNode.styles);
                }
            }
        }
        var viewRenderer = rendererFactory.createRenderer(rNode, def);
        var componentView = createLView(rootView, getOrCreateTComponentView(def), null, def.onPush ? 64 /* Dirty */ : 16 /* CheckAlways */, rootView[index], tNode, rendererFactory, viewRenderer, sanitizer || null, null);
        if (tView.firstCreatePass) {
            diPublicInInjector(getOrCreateNodeInjectorForNode(tNode, rootView), tView, def.type);
            markAsComponentHost(tView, tNode);
            initTNodeFlags(tNode, rootView.length, 1);
        }
        addToViewTree(rootView, componentView);
        // Store component view at node index, with node as the HOST
        return rootView[index] = componentView;
    }
    /**
     * Creates a root component and sets it up with features and host bindings. Shared by
     * renderComponent() and ViewContainerRef.createComponent().
     */
    function createRootComponent(componentView, componentDef, rootLView, rootContext, hostFeatures) {
        var tView = rootLView[TVIEW];
        // Create directive instance with factory() and store at next index in viewData
        var component = instantiateRootComponent(tView, rootLView, componentDef);
        rootContext.components.push(component);
        componentView[CONTEXT] = component;
        hostFeatures && hostFeatures.forEach(function (feature) { return feature(component, componentDef); });
        // We want to generate an empty QueryList for root content queries for backwards
        // compatibility with ViewEngine.
        if (componentDef.contentQueries) {
            var tNode = getCurrentTNode();
            ngDevMode && assertDefined(tNode, 'TNode expected');
            componentDef.contentQueries(1 /* Create */, component, tNode.directiveStart);
        }
        var rootTNode = getCurrentTNode();
        ngDevMode && assertDefined(rootTNode, 'tNode should have been already created');
        if (tView.firstCreatePass &&
            (componentDef.hostBindings !== null || componentDef.hostAttrs !== null)) {
            setSelectedIndex(rootTNode.index);
            var rootTView = rootLView[TVIEW];
            registerHostBindingOpCodes(rootTView, rootTNode, rootLView, rootTNode.directiveStart, rootTNode.directiveEnd, componentDef);
            invokeHostBindingsInCreationMode(componentDef, component);
        }
        return component;
    }
    function createRootContext(scheduler, playerHandler) {
        return {
            components: [],
            scheduler: scheduler || defaultScheduler,
            clean: CLEAN_PROMISE,
            playerHandler: playerHandler || null,
            flags: 0 /* Empty */
        };
    }
    /**
     * Used to enable lifecycle hooks on the root component.
     *
     * Include this feature when calling `renderComponent` if the root component
     * you are rendering has lifecycle hooks defined. Otherwise, the hooks won't
     * be called properly.
     *
     * Example:
     *
     * ```
     * renderComponent(AppComponent, {hostFeatures: [LifecycleHooksFeature]});
     * ```
     */
    function LifecycleHooksFeature(component, def) {
        var lView = readPatchedLView(component);
        ngDevMode && assertDefined(lView, 'LView is required');
        var tView = lView[TVIEW];
        var tNode = getCurrentTNode();
        ngDevMode && assertDefined(tNode, 'TNode is required');
        registerPostOrderHooks(tView, tNode);
    }
    /**
     * Wait on component until it is rendered.
     *
     * This function returns a `Promise` which is resolved when the component's
     * change detection is executed. This is determined by finding the scheduler
     * associated with the `component`'s render tree and waiting until the scheduler
     * flushes. If nothing is scheduled, the function returns a resolved promise.
     *
     * Example:
     * ```
     * await whenRendered(myComponent);
     * ```
     *
     * @param component Component to wait upon
     * @returns Promise which resolves when the component is rendered.
     */
    function whenRendered(component) {
        return getRootContext(component).clean;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function getSuperType(type) {
        return Object.getPrototypeOf(type.prototype).constructor;
    }
    /**
     * Merges the definition from a super class to a sub class.
     * @param definition The definition that is a SubClass of another directive of component
     *
     * @codeGenApi
     */
    function ɵɵInheritDefinitionFeature(definition) {
        var superType = getSuperType(definition.type);
        var shouldInheritFields = true;
        var inheritanceChain = [definition];
        while (superType) {
            var superDef = undefined;
            if (isComponentDef(definition)) {
                // Don't use getComponentDef/getDirectiveDef. This logic relies on inheritance.
                superDef = superType.ɵcmp || superType.ɵdir;
            }
            else {
                if (superType.ɵcmp) {
                    throw new Error('Directives cannot inherit Components');
                }
                // Don't use getComponentDef/getDirectiveDef. This logic relies on inheritance.
                superDef = superType.ɵdir;
            }
            if (superDef) {
                if (shouldInheritFields) {
                    inheritanceChain.push(superDef);
                    // Some fields in the definition may be empty, if there were no values to put in them that
                    // would've justified object creation. Unwrap them if necessary.
                    var writeableDef = definition;
                    writeableDef.inputs = maybeUnwrapEmpty(definition.inputs);
                    writeableDef.declaredInputs = maybeUnwrapEmpty(definition.declaredInputs);
                    writeableDef.outputs = maybeUnwrapEmpty(definition.outputs);
                    // Merge hostBindings
                    var superHostBindings = superDef.hostBindings;
                    superHostBindings && inheritHostBindings(definition, superHostBindings);
                    // Merge queries
                    var superViewQuery = superDef.viewQuery;
                    var superContentQueries = superDef.contentQueries;
                    superViewQuery && inheritViewQuery(definition, superViewQuery);
                    superContentQueries && inheritContentQueries(definition, superContentQueries);
                    // Merge inputs and outputs
                    fillProperties(definition.inputs, superDef.inputs);
                    fillProperties(definition.declaredInputs, superDef.declaredInputs);
                    fillProperties(definition.outputs, superDef.outputs);
                    // Merge animations metadata.
                    // If `superDef` is a Component, the `data` field is present (defaults to an empty object).
                    if (isComponentDef(superDef) && superDef.data.animation) {
                        // If super def is a Component, the `definition` is also a Component, since Directives can
                        // not inherit Components (we throw an error above and cannot reach this code).
                        var defData = definition.data;
                        defData.animation = (defData.animation || []).concat(superDef.data.animation);
                    }
                }
                // Run parent features
                var features = superDef.features;
                if (features) {
                    for (var i = 0; i < features.length; i++) {
                        var feature = features[i];
                        if (feature && feature.ngInherit) {
                            feature(definition);
                        }
                        // If `InheritDefinitionFeature` is a part of the current `superDef`, it means that this
                        // def already has all the necessary information inherited from its super class(es), so we
                        // can stop merging fields from super classes. However we need to iterate through the
                        // prototype chain to look for classes that might contain other "features" (like
                        // NgOnChanges), which we should invoke for the original `definition`. We set the
                        // `shouldInheritFields` flag to indicate that, essentially skipping fields inheritance
                        // logic and only invoking functions from the "features" list.
                        if (feature === ɵɵInheritDefinitionFeature) {
                            shouldInheritFields = false;
                        }
                    }
                }
            }
            superType = Object.getPrototypeOf(superType);
        }
        mergeHostAttrsAcrossInheritance(inheritanceChain);
    }
    /**
     * Merge the `hostAttrs` and `hostVars` from the inherited parent to the base class.
     *
     * @param inheritanceChain A list of `WritableDefs` starting at the top most type and listing
     * sub-types in order. For each type take the `hostAttrs` and `hostVars` and merge it with the child
     * type.
     */
    function mergeHostAttrsAcrossInheritance(inheritanceChain) {
        var hostVars = 0;
        var hostAttrs = null;
        // We process the inheritance order from the base to the leaves here.
        for (var i = inheritanceChain.length - 1; i >= 0; i--) {
            var def = inheritanceChain[i];
            // For each `hostVars`, we need to add the superclass amount.
            def.hostVars = (hostVars += def.hostVars);
            // for each `hostAttrs` we need to merge it with superclass.
            def.hostAttrs =
                mergeHostAttrs(def.hostAttrs, hostAttrs = mergeHostAttrs(hostAttrs, def.hostAttrs));
        }
    }
    function maybeUnwrapEmpty(value) {
        if (value === EMPTY_OBJ) {
            return {};
        }
        else if (value === EMPTY_ARRAY$1) {
            return [];
        }
        else {
            return value;
        }
    }
    function inheritViewQuery(definition, superViewQuery) {
        var prevViewQuery = definition.viewQuery;
        if (prevViewQuery) {
            definition.viewQuery = function (rf, ctx) {
                superViewQuery(rf, ctx);
                prevViewQuery(rf, ctx);
            };
        }
        else {
            definition.viewQuery = superViewQuery;
        }
    }
    function inheritContentQueries(definition, superContentQueries) {
        var prevContentQueries = definition.contentQueries;
        if (prevContentQueries) {
            definition.contentQueries = function (rf, ctx, directiveIndex) {
                superContentQueries(rf, ctx, directiveIndex);
                prevContentQueries(rf, ctx, directiveIndex);
            };
        }
        else {
            definition.contentQueries = superContentQueries;
        }
    }
    function inheritHostBindings(definition, superHostBindings) {
        var prevHostBindings = definition.hostBindings;
        if (prevHostBindings) {
            definition.hostBindings = function (rf, ctx) {
                superHostBindings(rf, ctx);
                prevHostBindings(rf, ctx);
            };
        }
        else {
            definition.hostBindings = superHostBindings;
        }
    }

    /**
     * Fields which exist on either directive or component definitions, and need to be copied from
     * parent to child classes by the `ɵɵCopyDefinitionFeature`.
     */
    var COPY_DIRECTIVE_FIELDS = [
        // The child class should use the providers of its parent.
        'providersResolver',
    ];
    /**
     * Fields which exist only on component definitions, and need to be copied from parent to child
     * classes by the `ɵɵCopyDefinitionFeature`.
     *
     * The type here allows any field of `ComponentDef` which is not also a property of `DirectiveDef`,
     * since those should go in `COPY_DIRECTIVE_FIELDS` above.
     */
    var COPY_COMPONENT_FIELDS = [
        // The child class should use the template function of its parent, including all template
        // semantics.
        'template',
        'decls',
        'consts',
        'vars',
        'onPush',
        'ngContentSelectors',
        // The child class should use the CSS styles of its parent, including all styling semantics.
        'styles',
        'encapsulation',
        // The child class should be checked by the runtime in the same way as its parent.
        'schemas',
    ];
    /**
     * Copies the fields not handled by the `ɵɵInheritDefinitionFeature` from the supertype of a
     * definition.
     *
     * This exists primarily to support ngcc migration of an existing View Engine pattern, where an
     * entire decorator is inherited from a parent to a child class. When ngcc detects this case, it
     * generates a skeleton definition on the child class, and applies this feature.
     *
     * The `ɵɵCopyDefinitionFeature` then copies any needed fields from the parent class' definition,
     * including things like the component template function.
     *
     * @param definition The definition of a child class which inherits from a parent class with its
     * own definition.
     *
     * @codeGenApi
     */
    function ɵɵCopyDefinitionFeature(definition) {
        var e_1, _a, e_2, _b;
        var superType = getSuperType(definition.type);
        var superDef = undefined;
        if (isComponentDef(definition)) {
            // Don't use getComponentDef/getDirectiveDef. This logic relies on inheritance.
            superDef = superType.ɵcmp;
        }
        else {
            // Don't use getComponentDef/getDirectiveDef. This logic relies on inheritance.
            superDef = superType.ɵdir;
        }
        // Needed because `definition` fields are readonly.
        var defAny = definition;
        try {
            // Copy over any fields that apply to either directives or components.
            for (var COPY_DIRECTIVE_FIELDS_1 = __values(COPY_DIRECTIVE_FIELDS), COPY_DIRECTIVE_FIELDS_1_1 = COPY_DIRECTIVE_FIELDS_1.next(); !COPY_DIRECTIVE_FIELDS_1_1.done; COPY_DIRECTIVE_FIELDS_1_1 = COPY_DIRECTIVE_FIELDS_1.next()) {
                var field = COPY_DIRECTIVE_FIELDS_1_1.value;
                defAny[field] = superDef[field];
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (COPY_DIRECTIVE_FIELDS_1_1 && !COPY_DIRECTIVE_FIELDS_1_1.done && (_a = COPY_DIRECTIVE_FIELDS_1.return)) _a.call(COPY_DIRECTIVE_FIELDS_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (isComponentDef(superDef)) {
            try {
                // Copy over any component-specific fields.
                for (var COPY_COMPONENT_FIELDS_1 = __values(COPY_COMPONENT_FIELDS), COPY_COMPONENT_FIELDS_1_1 = COPY_COMPONENT_FIELDS_1.next(); !COPY_COMPONENT_FIELDS_1_1.done; COPY_COMPONENT_FIELDS_1_1 = COPY_COMPONENT_FIELDS_1.next()) {
                    var field = COPY_COMPONENT_FIELDS_1_1.value;
                    defAny[field] = superDef[field];
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (COPY_COMPONENT_FIELDS_1_1 && !COPY_COMPONENT_FIELDS_1_1.done && (_b = COPY_COMPONENT_FIELDS_1.return)) _b.call(COPY_COMPONENT_FIELDS_1);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var _symbolIterator = null;
    function getSymbolIterator() {
        if (!_symbolIterator) {
            var Symbol = _global['Symbol'];
            if (Symbol && Symbol.iterator) {
                _symbolIterator = Symbol.iterator;
            }
            else {
                // es6-shim specific logic
                var keys = Object.getOwnPropertyNames(Map.prototype);
                for (var i = 0; i < keys.length; ++i) {
                    var key = keys[i];
                    if (key !== 'entries' && key !== 'size' &&
                        Map.prototype[key] === Map.prototype['entries']) {
                        _symbolIterator = key;
                    }
                }
            }
        }
        return _symbolIterator;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function devModeEqual(a, b) {
        var isListLikeIterableA = isListLikeIterable(a);
        var isListLikeIterableB = isListLikeIterable(b);
        if (isListLikeIterableA && isListLikeIterableB) {
            return areIterablesEqual(a, b, devModeEqual);
        }
        else {
            var isAObject = a && (typeof a === 'object' || typeof a === 'function');
            var isBObject = b && (typeof b === 'object' || typeof b === 'function');
            if (!isListLikeIterableA && isAObject && !isListLikeIterableB && isBObject) {
                return true;
            }
            else {
                return Object.is(a, b);
            }
        }
    }
    /**
     * Indicates that the result of a {@link Pipe} transformation has changed even though the
     * reference has not changed.
     *
     * Wrapped values are unwrapped automatically during the change detection, and the unwrapped value
     * is stored.
     *
     * Example:
     *
     * ```
     * if (this._latestValue === this._latestReturnedValue) {
     *    return this._latestReturnedValue;
     *  } else {
     *    this._latestReturnedValue = this._latestValue;
     *    return WrappedValue.wrap(this._latestValue); // this will force update
     *  }
     * ```
     *
     * @publicApi
     * @deprecated from v10 stop using. (No replacement, deemed unnecessary.)
     */
    var WrappedValue = /** @class */ (function () {
        function WrappedValue(value) {
            this.wrapped = value;
        }
        /** Creates a wrapped value. */
        WrappedValue.wrap = function (value) {
            return new WrappedValue(value);
        };
        /**
         * Returns the underlying value of a wrapped value.
         * Returns the given `value` when it is not wrapped.
         **/
        WrappedValue.unwrap = function (value) {
            return WrappedValue.isWrapped(value) ? value.wrapped : value;
        };
        /** Returns true if `value` is a wrapped value. */
        WrappedValue.isWrapped = function (value) {
            return value instanceof WrappedValue;
        };
        return WrappedValue;
    }());
    function isListLikeIterable(obj) {
        if (!isJsObject(obj))
            return false;
        return Array.isArray(obj) ||
            (!(obj instanceof Map) && // JS Map are iterables but return entries as [k, v]
                getSymbolIterator() in obj); // JS Iterable have a Symbol.iterator prop
    }
    function areIterablesEqual(a, b, comparator) {
        var iterator1 = a[getSymbolIterator()]();
        var iterator2 = b[getSymbolIterator()]();
        while (true) {
            var item1 = iterator1.next();
            var item2 = iterator2.next();
            if (item1.done && item2.done)
                return true;
            if (item1.done || item2.done)
                return false;
            if (!comparator(item1.value, item2.value))
                return false;
        }
    }
    function iterateListLike(obj, fn) {
        if (Array.isArray(obj)) {
            for (var i = 0; i < obj.length; i++) {
                fn(obj[i]);
            }
        }
        else {
            var iterator = obj[getSymbolIterator()]();
            var item = void 0;
            while (!((item = iterator.next()).done)) {
                fn(item.value);
            }
        }
    }
    function isJsObject(o) {
        return o !== null && (typeof o === 'function' || typeof o === 'object');
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    // TODO(misko): consider inlining
    /** Updates binding and returns the value. */
    function updateBinding(lView, bindingIndex, value) {
        return lView[bindingIndex] = value;
    }
    /** Gets the current binding value. */
    function getBinding(lView, bindingIndex) {
        ngDevMode && assertIndexInRange(lView, bindingIndex);
        ngDevMode &&
            assertNotSame(lView[bindingIndex], NO_CHANGE, 'Stored value should never be NO_CHANGE.');
        return lView[bindingIndex];
    }
    /**
     * Updates binding if changed, then returns whether it was updated.
     *
     * This function also checks the `CheckNoChangesMode` and throws if changes are made.
     * Some changes (Objects/iterables) during `CheckNoChangesMode` are exempt to comply with VE
     * behavior.
     *
     * @param lView current `LView`
     * @param bindingIndex The binding in the `LView` to check
     * @param value New value to check against `lView[bindingIndex]`
     * @returns `true` if the bindings has changed. (Throws if binding has changed during
     *          `CheckNoChangesMode`)
     */
    function bindingUpdated(lView, bindingIndex, value) {
        ngDevMode && assertNotSame(value, NO_CHANGE, 'Incoming value should never be NO_CHANGE.');
        ngDevMode &&
            assertLessThan(bindingIndex, lView.length, "Slot should have been initialized to NO_CHANGE");
        var oldValue = lView[bindingIndex];
        if (Object.is(oldValue, value)) {
            return false;
        }
        else {
            if (ngDevMode && isInCheckNoChangesMode()) {
                // View engine didn't report undefined values as changed on the first checkNoChanges pass
                // (before the change detection was run).
                var oldValueToCompare = oldValue !== NO_CHANGE ? oldValue : undefined;
                if (!devModeEqual(oldValueToCompare, value)) {
                    var details = getExpressionChangedErrorDetails(lView, bindingIndex, oldValueToCompare, value);
                    throwErrorIfNoChangesMode(oldValue === NO_CHANGE, details.oldValue, details.newValue, details.propName);
                }
                // There was a change, but the `devModeEqual` decided that the change is exempt from an error.
                // For this reason we exit as if no change. The early exit is needed to prevent the changed
                // value to be written into `LView` (If we would write the new value that we would not see it
                // as change on next CD.)
                return false;
            }
            lView[bindingIndex] = value;
            return true;
        }
    }
    /** Updates 2 bindings if changed, then returns whether either was updated. */
    function bindingUpdated2(lView, bindingIndex, exp1, exp2) {
        var different = bindingUpdated(lView, bindingIndex, exp1);
        return bindingUpdated(lView, bindingIndex + 1, exp2) || different;
    }
    /** Updates 3 bindings if changed, then returns whether any was updated. */
    function bindingUpdated3(lView, bindingIndex, exp1, exp2, exp3) {
        var different = bindingUpdated2(lView, bindingIndex, exp1, exp2);
        return bindingUpdated(lView, bindingIndex + 2, exp3) || different;
    }
    /** Updates 4 bindings if changed, then returns whether any was updated. */
    function bindingUpdated4(lView, bindingIndex, exp1, exp2, exp3, exp4) {
        var different = bindingUpdated2(lView, bindingIndex, exp1, exp2);
        return bindingUpdated2(lView, bindingIndex + 2, exp3, exp4) || different;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Updates the value of or removes a bound attribute on an Element.
     *
     * Used in the case of `[attr.title]="value"`
     *
     * @param name name The name of the attribute.
     * @param value value The attribute is removed when value is `null` or `undefined`.
     *                  Otherwise the attribute value is set to the stringified value.
     * @param sanitizer An optional function used to sanitize the value.
     * @param namespace Optional namespace to use when setting the attribute.
     *
     * @codeGenApi
     */
    function ɵɵattribute(name, value, sanitizer, namespace) {
        var lView = getLView();
        var bindingIndex = nextBindingIndex();
        if (bindingUpdated(lView, bindingIndex, value)) {
            var tView = getTView();
            var tNode = getSelectedTNode();
            elementAttributeInternal(tNode, lView, name, value, sanitizer, namespace);
            ngDevMode && storePropertyBindingMetadata(tView.data, tNode, 'attr.' + name, bindingIndex);
        }
        return ɵɵattribute;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Create interpolation bindings with a variable number of expressions.
     *
     * If there are 1 to 8 expressions `interpolation1()` to `interpolation8()` should be used instead.
     * Those are faster because there is no need to create an array of expressions and iterate over it.
     *
     * `values`:
     * - has static text at even indexes,
     * - has evaluated expressions at odd indexes.
     *
     * Returns the concatenated string when any of the arguments changes, `NO_CHANGE` otherwise.
     */
    function interpolationV(lView, values) {
        ngDevMode && assertLessThan(2, values.length, 'should have at least 3 values');
        ngDevMode && assertEqual(values.length % 2, 1, 'should have an odd number of values');
        var isBindingUpdated = false;
        var bindingIndex = getBindingIndex();
        for (var i = 1; i < values.length; i += 2) {
            // Check if bindings (odd indexes) have changed
            isBindingUpdated = bindingUpdated(lView, bindingIndex++, values[i]) || isBindingUpdated;
        }
        setBindingIndex(bindingIndex);
        if (!isBindingUpdated) {
            return NO_CHANGE;
        }
        // Build the updated content
        var content = values[0];
        for (var i = 1; i < values.length; i += 2) {
            content += renderStringify(values[i]) + values[i + 1];
        }
        return content;
    }
    /**
     * Creates an interpolation binding with 1 expression.
     *
     * @param prefix static value used for concatenation only.
     * @param v0 value checked for change.
     * @param suffix static value used for concatenation only.
     */
    function interpolation1(lView, prefix, v0, suffix) {
        var different = bindingUpdated(lView, nextBindingIndex(), v0);
        return different ? prefix + renderStringify(v0) + suffix : NO_CHANGE;
    }
    /**
     * Creates an interpolation binding with 2 expressions.
     */
    function interpolation2(lView, prefix, v0, i0, v1, suffix) {
        var bindingIndex = getBindingIndex();
        var different = bindingUpdated2(lView, bindingIndex, v0, v1);
        incrementBindingIndex(2);
        return different ? prefix + renderStringify(v0) + i0 + renderStringify(v1) + suffix : NO_CHANGE;
    }
    /**
     * Creates an interpolation binding with 3 expressions.
     */
    function interpolation3(lView, prefix, v0, i0, v1, i1, v2, suffix) {
        var bindingIndex = getBindingIndex();
        var different = bindingUpdated3(lView, bindingIndex, v0, v1, v2);
        incrementBindingIndex(3);
        return different ?
            prefix + renderStringify(v0) + i0 + renderStringify(v1) + i1 + renderStringify(v2) + suffix :
            NO_CHANGE;
    }
    /**
     * Create an interpolation binding with 4 expressions.
     */
    function interpolation4(lView, prefix, v0, i0, v1, i1, v2, i2, v3, suffix) {
        var bindingIndex = getBindingIndex();
        var different = bindingUpdated4(lView, bindingIndex, v0, v1, v2, v3);
        incrementBindingIndex(4);
        return different ? prefix + renderStringify(v0) + i0 + renderStringify(v1) + i1 +
            renderStringify(v2) + i2 + renderStringify(v3) + suffix :
            NO_CHANGE;
    }
    /**
     * Creates an interpolation binding with 5 expressions.
     */
    function interpolation5(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, suffix) {
        var bindingIndex = getBindingIndex();
        var different = bindingUpdated4(lView, bindingIndex, v0, v1, v2, v3);
        different = bindingUpdated(lView, bindingIndex + 4, v4) || different;
        incrementBindingIndex(5);
        return different ? prefix + renderStringify(v0) + i0 + renderStringify(v1) + i1 +
            renderStringify(v2) + i2 + renderStringify(v3) + i3 + renderStringify(v4) + suffix :
            NO_CHANGE;
    }
    /**
     * Creates an interpolation binding with 6 expressions.
     */
    function interpolation6(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, suffix) {
        var bindingIndex = getBindingIndex();
        var different = bindingUpdated4(lView, bindingIndex, v0, v1, v2, v3);
        different = bindingUpdated2(lView, bindingIndex + 4, v4, v5) || different;
        incrementBindingIndex(6);
        return different ?
            prefix + renderStringify(v0) + i0 + renderStringify(v1) + i1 + renderStringify(v2) + i2 +
                renderStringify(v3) + i3 + renderStringify(v4) + i4 + renderStringify(v5) + suffix :
            NO_CHANGE;
    }
    /**
     * Creates an interpolation binding with 7 expressions.
     */
    function interpolation7(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, suffix) {
        var bindingIndex = getBindingIndex();
        var different = bindingUpdated4(lView, bindingIndex, v0, v1, v2, v3);
        different = bindingUpdated3(lView, bindingIndex + 4, v4, v5, v6) || different;
        incrementBindingIndex(7);
        return different ? prefix + renderStringify(v0) + i0 + renderStringify(v1) + i1 +
            renderStringify(v2) + i2 + renderStringify(v3) + i3 + renderStringify(v4) + i4 +
            renderStringify(v5) + i5 + renderStringify(v6) + suffix :
            NO_CHANGE;
    }
    /**
     * Creates an interpolation binding with 8 expressions.
     */
    function interpolation8(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, i6, v7, suffix) {
        var bindingIndex = getBindingIndex();
        var different = bindingUpdated4(lView, bindingIndex, v0, v1, v2, v3);
        different = bindingUpdated4(lView, bindingIndex + 4, v4, v5, v6, v7) || different;
        incrementBindingIndex(8);
        return different ? prefix + renderStringify(v0) + i0 + renderStringify(v1) + i1 +
            renderStringify(v2) + i2 + renderStringify(v3) + i3 + renderStringify(v4) + i4 +
            renderStringify(v5) + i5 + renderStringify(v6) + i6 + renderStringify(v7) + suffix :
            NO_CHANGE;
    }

    /**
     *
     * Update an interpolated attribute on an element with single bound value surrounded by text.
     *
     * Used when the value passed to a property has 1 interpolated value in it:
     *
     * ```html
     * <div attr.title="prefix{{v0}}suffix"></div>
     * ```
     *
     * Its compiled representation is::
     *
     * ```ts
     * ɵɵattributeInterpolate1('title', 'prefix', v0, 'suffix');
     * ```
     *
     * @param attrName The name of the attribute to update
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param sanitizer An optional sanitizer function
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵattributeInterpolate1(attrName, prefix, v0, suffix, sanitizer, namespace) {
        var lView = getLView();
        var interpolatedValue = interpolation1(lView, prefix, v0, suffix);
        if (interpolatedValue !== NO_CHANGE) {
            var tNode = getSelectedTNode();
            elementAttributeInternal(tNode, lView, attrName, interpolatedValue, sanitizer, namespace);
            ngDevMode &&
                storePropertyBindingMetadata(getTView().data, tNode, 'attr.' + attrName, getBindingIndex() - 1, prefix, suffix);
        }
        return ɵɵattributeInterpolate1;
    }
    /**
     *
     * Update an interpolated attribute on an element with 2 bound values surrounded by text.
     *
     * Used when the value passed to a property has 2 interpolated values in it:
     *
     * ```html
     * <div attr.title="prefix{{v0}}-{{v1}}suffix"></div>
     * ```
     *
     * Its compiled representation is::
     *
     * ```ts
     * ɵɵattributeInterpolate2('title', 'prefix', v0, '-', v1, 'suffix');
     * ```
     *
     * @param attrName The name of the attribute to update
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param sanitizer An optional sanitizer function
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵattributeInterpolate2(attrName, prefix, v0, i0, v1, suffix, sanitizer, namespace) {
        var lView = getLView();
        var interpolatedValue = interpolation2(lView, prefix, v0, i0, v1, suffix);
        if (interpolatedValue !== NO_CHANGE) {
            var tNode = getSelectedTNode();
            elementAttributeInternal(tNode, lView, attrName, interpolatedValue, sanitizer, namespace);
            ngDevMode &&
                storePropertyBindingMetadata(getTView().data, tNode, 'attr.' + attrName, getBindingIndex() - 2, prefix, i0, suffix);
        }
        return ɵɵattributeInterpolate2;
    }
    /**
     *
     * Update an interpolated attribute on an element with 3 bound values surrounded by text.
     *
     * Used when the value passed to a property has 3 interpolated values in it:
     *
     * ```html
     * <div attr.title="prefix{{v0}}-{{v1}}-{{v2}}suffix"></div>
     * ```
     *
     * Its compiled representation is::
     *
     * ```ts
     * ɵɵattributeInterpolate3(
     * 'title', 'prefix', v0, '-', v1, '-', v2, 'suffix');
     * ```
     *
     * @param attrName The name of the attribute to update
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param sanitizer An optional sanitizer function
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵattributeInterpolate3(attrName, prefix, v0, i0, v1, i1, v2, suffix, sanitizer, namespace) {
        var lView = getLView();
        var interpolatedValue = interpolation3(lView, prefix, v0, i0, v1, i1, v2, suffix);
        if (interpolatedValue !== NO_CHANGE) {
            var tNode = getSelectedTNode();
            elementAttributeInternal(tNode, lView, attrName, interpolatedValue, sanitizer, namespace);
            ngDevMode &&
                storePropertyBindingMetadata(getTView().data, tNode, 'attr.' + attrName, getBindingIndex() - 3, prefix, i0, i1, suffix);
        }
        return ɵɵattributeInterpolate3;
    }
    /**
     *
     * Update an interpolated attribute on an element with 4 bound values surrounded by text.
     *
     * Used when the value passed to a property has 4 interpolated values in it:
     *
     * ```html
     * <div attr.title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}suffix"></div>
     * ```
     *
     * Its compiled representation is::
     *
     * ```ts
     * ɵɵattributeInterpolate4(
     * 'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, 'suffix');
     * ```
     *
     * @param attrName The name of the attribute to update
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param sanitizer An optional sanitizer function
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵattributeInterpolate4(attrName, prefix, v0, i0, v1, i1, v2, i2, v3, suffix, sanitizer, namespace) {
        var lView = getLView();
        var interpolatedValue = interpolation4(lView, prefix, v0, i0, v1, i1, v2, i2, v3, suffix);
        if (interpolatedValue !== NO_CHANGE) {
            var tNode = getSelectedTNode();
            elementAttributeInternal(tNode, lView, attrName, interpolatedValue, sanitizer, namespace);
            ngDevMode &&
                storePropertyBindingMetadata(getTView().data, tNode, 'attr.' + attrName, getBindingIndex() - 4, prefix, i0, i1, i2, suffix);
        }
        return ɵɵattributeInterpolate4;
    }
    /**
     *
     * Update an interpolated attribute on an element with 5 bound values surrounded by text.
     *
     * Used when the value passed to a property has 5 interpolated values in it:
     *
     * ```html
     * <div attr.title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}suffix"></div>
     * ```
     *
     * Its compiled representation is::
     *
     * ```ts
     * ɵɵattributeInterpolate5(
     * 'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, 'suffix');
     * ```
     *
     * @param attrName The name of the attribute to update
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param sanitizer An optional sanitizer function
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵattributeInterpolate5(attrName, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, suffix, sanitizer, namespace) {
        var lView = getLView();
        var interpolatedValue = interpolation5(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, suffix);
        if (interpolatedValue !== NO_CHANGE) {
            var tNode = getSelectedTNode();
            elementAttributeInternal(tNode, lView, attrName, interpolatedValue, sanitizer, namespace);
            ngDevMode &&
                storePropertyBindingMetadata(getTView().data, tNode, 'attr.' + attrName, getBindingIndex() - 5, prefix, i0, i1, i2, i3, suffix);
        }
        return ɵɵattributeInterpolate5;
    }
    /**
     *
     * Update an interpolated attribute on an element with 6 bound values surrounded by text.
     *
     * Used when the value passed to a property has 6 interpolated values in it:
     *
     * ```html
     * <div attr.title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}suffix"></div>
     * ```
     *
     * Its compiled representation is::
     *
     * ```ts
     * ɵɵattributeInterpolate6(
     *    'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, 'suffix');
     * ```
     *
     * @param attrName The name of the attribute to update
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param i4 Static value used for concatenation only.
     * @param v5 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param sanitizer An optional sanitizer function
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵattributeInterpolate6(attrName, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, suffix, sanitizer, namespace) {
        var lView = getLView();
        var interpolatedValue = interpolation6(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, suffix);
        if (interpolatedValue !== NO_CHANGE) {
            var tNode = getSelectedTNode();
            elementAttributeInternal(tNode, lView, attrName, interpolatedValue, sanitizer, namespace);
            ngDevMode &&
                storePropertyBindingMetadata(getTView().data, tNode, 'attr.' + attrName, getBindingIndex() - 6, prefix, i0, i1, i2, i3, i4, suffix);
        }
        return ɵɵattributeInterpolate6;
    }
    /**
     *
     * Update an interpolated attribute on an element with 7 bound values surrounded by text.
     *
     * Used when the value passed to a property has 7 interpolated values in it:
     *
     * ```html
     * <div attr.title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}suffix"></div>
     * ```
     *
     * Its compiled representation is::
     *
     * ```ts
     * ɵɵattributeInterpolate7(
     *    'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, 'suffix');
     * ```
     *
     * @param attrName The name of the attribute to update
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param i4 Static value used for concatenation only.
     * @param v5 Value checked for change.
     * @param i5 Static value used for concatenation only.
     * @param v6 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param sanitizer An optional sanitizer function
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵattributeInterpolate7(attrName, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, suffix, sanitizer, namespace) {
        var lView = getLView();
        var interpolatedValue = interpolation7(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, suffix);
        if (interpolatedValue !== NO_CHANGE) {
            var tNode = getSelectedTNode();
            elementAttributeInternal(tNode, lView, attrName, interpolatedValue, sanitizer, namespace);
            ngDevMode &&
                storePropertyBindingMetadata(getTView().data, tNode, 'attr.' + attrName, getBindingIndex() - 7, prefix, i0, i1, i2, i3, i4, i5, suffix);
        }
        return ɵɵattributeInterpolate7;
    }
    /**
     *
     * Update an interpolated attribute on an element with 8 bound values surrounded by text.
     *
     * Used when the value passed to a property has 8 interpolated values in it:
     *
     * ```html
     * <div attr.title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}-{{v7}}suffix"></div>
     * ```
     *
     * Its compiled representation is::
     *
     * ```ts
     * ɵɵattributeInterpolate8(
     *  'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, '-', v7, 'suffix');
     * ```
     *
     * @param attrName The name of the attribute to update
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param i4 Static value used for concatenation only.
     * @param v5 Value checked for change.
     * @param i5 Static value used for concatenation only.
     * @param v6 Value checked for change.
     * @param i6 Static value used for concatenation only.
     * @param v7 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param sanitizer An optional sanitizer function
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵattributeInterpolate8(attrName, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, i6, v7, suffix, sanitizer, namespace) {
        var lView = getLView();
        var interpolatedValue = interpolation8(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, i6, v7, suffix);
        if (interpolatedValue !== NO_CHANGE) {
            var tNode = getSelectedTNode();
            elementAttributeInternal(tNode, lView, attrName, interpolatedValue, sanitizer, namespace);
            ngDevMode &&
                storePropertyBindingMetadata(getTView().data, tNode, 'attr.' + attrName, getBindingIndex() - 8, prefix, i0, i1, i2, i3, i4, i5, i6, suffix);
        }
        return ɵɵattributeInterpolate8;
    }
    /**
     * Update an interpolated attribute on an element with 9 or more bound values surrounded by text.
     *
     * Used when the number of interpolated values exceeds 8.
     *
     * ```html
     * <div
     *  title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}-{{v7}}-{{v8}}-{{v9}}suffix"></div>
     * ```
     *
     * Its compiled representation is::
     *
     * ```ts
     * ɵɵattributeInterpolateV(
     *  'title', ['prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, '-', v7, '-', v9,
     *  'suffix']);
     * ```
     *
     * @param attrName The name of the attribute to update.
     * @param values The collection of values and the strings in-between those values, beginning with
     * a string prefix and ending with a string suffix.
     * (e.g. `['prefix', value0, '-', value1, '-', value2, ..., value99, 'suffix']`)
     * @param sanitizer An optional sanitizer function
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵattributeInterpolateV(attrName, values, sanitizer, namespace) {
        var lView = getLView();
        var interpolated = interpolationV(lView, values);
        if (interpolated !== NO_CHANGE) {
            var tNode = getSelectedTNode();
            elementAttributeInternal(tNode, lView, attrName, interpolated, sanitizer, namespace);
            if (ngDevMode) {
                var interpolationInBetween = [values[0]]; // prefix
                for (var i = 2; i < values.length; i += 2) {
                    interpolationInBetween.push(values[i]);
                }
                storePropertyBindingMetadata.apply(void 0, __spread([getTView().data, tNode, 'attr.' + attrName, getBindingIndex() - interpolationInBetween.length + 1], interpolationInBetween));
            }
        }
        return ɵɵattributeInterpolateV;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function templateFirstCreatePass(index, tView, lView, templateFn, decls, vars, tagName, attrsIndex, localRefsIndex) {
        ngDevMode && assertFirstCreatePass(tView);
        ngDevMode && ngDevMode.firstCreatePass++;
        var tViewConsts = tView.consts;
        // TODO(pk): refactor getOrCreateTNode to have the "create" only version
        var tNode = getOrCreateTNode(tView, index, 4 /* Container */, tagName || null, getConstant(tViewConsts, attrsIndex));
        resolveDirectives(tView, lView, tNode, getConstant(tViewConsts, localRefsIndex));
        registerPostOrderHooks(tView, tNode);
        var embeddedTView = tNode.tViews = createTView(2 /* Embedded */, tNode, templateFn, decls, vars, tView.directiveRegistry, tView.pipeRegistry, null, tView.schemas, tViewConsts);
        if (tView.queries !== null) {
            tView.queries.template(tView, tNode);
            embeddedTView.queries = tView.queries.embeddedTView(tNode);
        }
        return tNode;
    }
    /**
     * Creates an LContainer for an ng-template (dynamically-inserted view), e.g.
     *
     * <ng-template #foo>
     *    <div></div>
     * </ng-template>
     *
     * @param index The index of the container in the data array
     * @param templateFn Inline template
     * @param decls The number of nodes, local refs, and pipes for this template
     * @param vars The number of bindings for this template
     * @param tagName The name of the container element, if applicable
     * @param attrsIndex Index of template attributes in the `consts` array.
     * @param localRefs Index of the local references in the `consts` array.
     * @param localRefExtractor A function which extracts local-refs values from the template.
     *        Defaults to the current element associated with the local-ref.
     *
     * @codeGenApi
     */
    function ɵɵtemplate(index, templateFn, decls, vars, tagName, attrsIndex, localRefsIndex, localRefExtractor) {
        var lView = getLView();
        var tView = getTView();
        var adjustedIndex = index + HEADER_OFFSET;
        var tNode = tView.firstCreatePass ? templateFirstCreatePass(adjustedIndex, tView, lView, templateFn, decls, vars, tagName, attrsIndex, localRefsIndex) :
            tView.data[adjustedIndex];
        setCurrentTNode(tNode, false);
        var comment = lView[RENDERER].createComment(ngDevMode ? 'container' : '');
        appendChild(tView, lView, comment, tNode);
        attachPatchData(comment, lView);
        addToViewTree(lView, lView[adjustedIndex] = createLContainer(comment, lView, comment, tNode));
        if (isDirectiveHost(tNode)) {
            createDirectivesInstances(tView, lView, tNode);
        }
        if (localRefsIndex != null) {
            saveResolvedLocalsInData(lView, tNode, localRefExtractor);
        }
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /** Store a value in the `data` at a given `index`. */
    function store(tView, lView, index, value) {
        // We don't store any static data for local variables, so the first time
        // we see the template, we should store as null to avoid a sparse array
        if (index >= tView.data.length) {
            tView.data[index] = null;
            tView.blueprint[index] = null;
        }
        lView[index] = value;
    }
    /**
     * Retrieves a local reference from the current contextViewData.
     *
     * If the reference to retrieve is in a parent view, this instruction is used in conjunction
     * with a nextContext() call, which walks up the tree and updates the contextViewData instance.
     *
     * @param index The index of the local ref in contextViewData.
     *
     * @codeGenApi
     */
    function ɵɵreference(index) {
        var contextLView = getContextLView();
        return load(contextLView, HEADER_OFFSET + index);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * A mapping of the @angular/core API surface used in generated expressions to the actual symbols.
     *
     * This should be kept up to date with the public exports of @angular/core.
     */
    var angularCoreDiEnv = {
        'ɵɵdefineInjectable': ɵɵdefineInjectable,
        'ɵɵdefineInjector': ɵɵdefineInjector,
        'ɵɵinject': ɵɵinject,
        'ɵɵinvalidFactoryDep': ɵɵinvalidFactoryDep,
    };

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Compile an Angular injectable according to its `Injectable` metadata, and patch the resulting
     * injectable def (`ɵprov`) onto the injectable type.
     */
    function compileInjectable(type, srcMeta) {
        var ngInjectableDef = null;
        var ngFactoryDef = null;
        // if NG_PROV_DEF is already defined on this class then don't overwrite it
        if (!type.hasOwnProperty(NG_PROV_DEF)) {
            Object.defineProperty(type, NG_PROV_DEF, {
                get: function () {
                    if (ngInjectableDef === null) {
                        ngInjectableDef = getCompilerFacade().compileInjectable(angularCoreDiEnv, "ng:///" + type.name + "/\u0275prov.js", getInjectableMetadata(type, srcMeta));
                    }
                    return ngInjectableDef;
                },
            });
        }
        // if NG_FACTORY_DEF is already defined on this class then don't overwrite it
        if (!type.hasOwnProperty(NG_FACTORY_DEF)) {
            Object.defineProperty(type, NG_FACTORY_DEF, {
                get: function () {
                    if (ngFactoryDef === null) {
                        var metadata = getInjectableMetadata(type, srcMeta);
                        var compiler = getCompilerFacade();
                        ngFactoryDef = compiler.compileFactory(angularCoreDiEnv, "ng:///" + type.name + "/\u0275fac.js", {
                            name: metadata.name,
                            type: metadata.type,
                            typeArgumentCount: metadata.typeArgumentCount,
                            deps: reflectDependencies(type),
                            injectFn: 'inject',
                            target: compiler.R3FactoryTarget.Injectable
                        });
                    }
                    return ngFactoryDef;
                },
                // Leave this configurable so that the factories from directives or pipes can take precedence.
                configurable: true
            });
        }
    }
    var ɵ0$8 = getClosureSafeProperty;
    var USE_VALUE$1 = getClosureSafeProperty({ provide: String, useValue: ɵ0$8 });
    function isUseClassProvider(meta) {
        return meta.useClass !== undefined;
    }
    function isUseValueProvider(meta) {
        return USE_VALUE$1 in meta;
    }
    function isUseFactoryProvider(meta) {
        return meta.useFactory !== undefined;
    }
    function isUseExistingProvider(meta) {
        return meta.useExisting !== undefined;
    }
    function getInjectableMetadata(type, srcMeta) {
        // Allow the compilation of a class with a `@Injectable()` decorator without parameters
        var meta = srcMeta || { providedIn: null };
        var compilerMeta = {
            name: type.name,
            type: type,
            typeArgumentCount: 0,
            providedIn: meta.providedIn,
            userDeps: undefined,
        };
        if ((isUseClassProvider(meta) || isUseFactoryProvider(meta)) && meta.deps !== undefined) {
            compilerMeta.userDeps = convertDependencies(meta.deps);
        }
        if (isUseClassProvider(meta)) {
            // The user explicitly specified useClass, and may or may not have provided deps.
            compilerMeta.useClass = resolveForwardRef(meta.useClass);
        }
        else if (isUseValueProvider(meta)) {
            // The user explicitly specified useValue.
            compilerMeta.useValue = resolveForwardRef(meta.useValue);
        }
        else if (isUseFactoryProvider(meta)) {
            // The user explicitly specified useFactory.
            compilerMeta.useFactory = meta.useFactory;
        }
        else if (isUseExistingProvider(meta)) {
            // The user explicitly specified useExisting.
            compilerMeta.useExisting = resolveForwardRef(meta.useExisting);
        }
        return compilerMeta;
    }

    var ɵ0$9 = getClosureSafeProperty;
    var USE_VALUE$2 = getClosureSafeProperty({ provide: String, useValue: ɵ0$9 });
    var EMPTY_ARRAY$3 = [];
    function convertInjectableProviderToFactory(type, provider) {
        if (!provider) {
            var reflectionCapabilities = new ReflectionCapabilities();
            var deps_1 = reflectionCapabilities.parameters(type);
            // TODO - convert to flags.
            return function () { return new (type.bind.apply(type, __spread([void 0], injectArgs(deps_1))))(); };
        }
        if (USE_VALUE$2 in provider) {
            var valueProvider_1 = provider;
            return function () { return valueProvider_1.useValue; };
        }
        else if (provider.useExisting) {
            var existingProvider_1 = provider;
            return function () { return ɵɵinject(resolveForwardRef(existingProvider_1.useExisting)); };
        }
        else if (provider.useFactory) {
            var factoryProvider_1 = provider;
            return function () { return factoryProvider_1.useFactory.apply(factoryProvider_1, __spread(injectArgs(factoryProvider_1.deps || EMPTY_ARRAY$3))); };
        }
        else if (provider.useClass) {
            var classProvider_1 = provider;
            var deps_2 = provider.deps;
            if (!deps_2) {
                var reflectionCapabilities = new ReflectionCapabilities();
                deps_2 = reflectionCapabilities.parameters(type);
            }
            return function () {
                var _a;
                return new ((_a = (resolveForwardRef(classProvider_1.useClass))).bind.apply(_a, __spread([void 0], injectArgs(deps_2))))();
            };
        }
        else {
            var deps_3 = provider.deps;
            if (!deps_3) {
                var reflectionCapabilities = new ReflectionCapabilities();
                deps_3 = reflectionCapabilities.parameters(type);
            }
            return function () { return new (type.bind.apply(type, __spread([void 0], injectArgs(deps_3))))(); };
        }
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var ɵ0$a = function (type, meta) { return SWITCH_COMPILE_INJECTABLE(type, meta); };
    /**
     * Injectable decorator and metadata.
     *
     * @Annotation
     * @publicApi
     */
    var Injectable = makeDecorator('Injectable', undefined, undefined, undefined, ɵ0$a);
    /**
     * Supports @Injectable() in JIT mode for Render2.
     */
    function render2CompileInjectable(injectableType, options) {
        if (options && options.providedIn !== undefined && !getInjectableDef(injectableType)) {
            injectableType.ɵprov = ɵɵdefineInjectable({
                token: injectableType,
                providedIn: options.providedIn,
                factory: convertInjectableProviderToFactory(injectableType, options),
            });
        }
    }
    var SWITCH_COMPILE_INJECTABLE__POST_R3__ = compileInjectable;
    var SWITCH_COMPILE_INJECTABLE__PRE_R3__ = render2CompileInjectable;
    var SWITCH_COMPILE_INJECTABLE = SWITCH_COMPILE_INJECTABLE__PRE_R3__;

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function findFirstClosedCycle(keys) {
        var res = [];
        for (var i = 0; i < keys.length; ++i) {
            if (res.indexOf(keys[i]) > -1) {
                res.push(keys[i]);
                return res;
            }
            res.push(keys[i]);
        }
        return res;
    }
    function constructResolvingPath(keys) {
        if (keys.length > 1) {
            var reversed = findFirstClosedCycle(keys.slice().reverse());
            var tokenStrs = reversed.map(function (k) { return stringify(k.token); });
            return ' (' + tokenStrs.join(' -> ') + ')';
        }
        return '';
    }
    function injectionError(injector, key, constructResolvingMessage, originalError) {
        var keys = [key];
        var errMsg = constructResolvingMessage(keys);
        var error = (originalError ? wrappedError(errMsg, originalError) : Error(errMsg));
        error.addKey = addKey;
        error.keys = keys;
        error.injectors = [injector];
        error.constructResolvingMessage = constructResolvingMessage;
        error[ERROR_ORIGINAL_ERROR] = originalError;
        return error;
    }
    function addKey(injector, key) {
        this.injectors.push(injector);
        this.keys.push(key);
        // Note: This updated message won't be reflected in the `.stack` property
        this.message = this.constructResolvingMessage(this.keys);
    }
    /**
     * Thrown when trying to retrieve a dependency by key from {@link Injector}, but the
     * {@link Injector} does not have a {@link Provider} for the given key.
     *
     * @usageNotes
     * ### Example
     *
     * ```typescript
     * class A {
     *   constructor(b:B) {}
     * }
     *
     * expect(() => Injector.resolveAndCreate([A])).toThrowError();
     * ```
     */
    function noProviderError(injector, key) {
        return injectionError(injector, key, function (keys) {
            var first = stringify(keys[0].token);
            return "No provider for " + first + "!" + constructResolvingPath(keys);
        });
    }
    /**
     * Thrown when dependencies form a cycle.
     *
     * @usageNotes
     * ### Example
     *
     * ```typescript
     * var injector = Injector.resolveAndCreate([
     *   {provide: "one", useFactory: (two) => "two", deps: [[new Inject("two")]]},
     *   {provide: "two", useFactory: (one) => "one", deps: [[new Inject("one")]]}
     * ]);
     *
     * expect(() => injector.get("one")).toThrowError();
     * ```
     *
     * Retrieving `A` or `B` throws a `CyclicDependencyError` as the graph above cannot be constructed.
     */
    function cyclicDependencyError(injector, key) {
        return injectionError(injector, key, function (keys) {
            return "Cannot instantiate cyclic dependency!" + constructResolvingPath(keys);
        });
    }
    /**
     * Thrown when a constructing type returns with an Error.
     *
     * The `InstantiationError` class contains the original error plus the dependency graph which caused
     * this object to be instantiated.
     *
     * @usageNotes
     * ### Example
     *
     * ```typescript
     * class A {
     *   constructor() {
     *     throw new Error('message');
     *   }
     * }
     *
     * var injector = Injector.resolveAndCreate([A]);

     * try {
     *   injector.get(A);
     * } catch (e) {
     *   expect(e instanceof InstantiationError).toBe(true);
     *   expect(e.originalException.message).toEqual("message");
     *   expect(e.originalStack).toBeDefined();
     * }
     * ```
     */
    function instantiationError(injector, originalException, originalStack, key) {
        return injectionError(injector, key, function (keys) {
            var first = stringify(keys[0].token);
            return originalException.message + ": Error during instantiation of " + first + "!" + constructResolvingPath(keys) + ".";
        }, originalException);
    }
    /**
     * Thrown when an object other then {@link Provider} (or `Type`) is passed to {@link Injector}
     * creation.
     *
     * @usageNotes
     * ### Example
     *
     * ```typescript
     * expect(() => Injector.resolveAndCreate(["not a type"])).toThrowError();
     * ```
     */
    function invalidProviderError(provider) {
        return Error("Invalid provider - only instances of Provider and Type are allowed, got: " + provider);
    }
    /**
     * Thrown when the class has no annotation information.
     *
     * Lack of annotation information prevents the {@link Injector} from determining which dependencies
     * need to be injected into the constructor.
     *
     * @usageNotes
     * ### Example
     *
     * ```typescript
     * class A {
     *   constructor(b) {}
     * }
     *
     * expect(() => Injector.resolveAndCreate([A])).toThrowError();
     * ```
     *
     * This error is also thrown when the class not marked with {@link Injectable} has parameter types.
     *
     * ```typescript
     * class B {}
     *
     * class A {
     *   constructor(b:B) {} // no information about the parameter types of A is available at runtime.
     * }
     *
     * expect(() => Injector.resolveAndCreate([A,B])).toThrowError();
     * ```
     *
     */
    function noAnnotationError(typeOrFunc, params) {
        var signature = [];
        for (var i = 0, ii = params.length; i < ii; i++) {
            var parameter = params[i];
            if (!parameter || parameter.length == 0) {
                signature.push('?');
            }
            else {
                signature.push(parameter.map(stringify).join(' '));
            }
        }
        return Error('Cannot resolve all parameters for \'' + stringify(typeOrFunc) + '\'(' +
            signature.join(', ') + '). ' +
            'Make sure that all the parameters are decorated with Inject or have valid type annotations and that \'' +
            stringify(typeOrFunc) + '\' is decorated with Injectable.');
    }
    /**
     * Thrown when getting an object by index.
     *
     * @usageNotes
     * ### Example
     *
     * ```typescript
     * class A {}
     *
     * var injector = Injector.resolveAndCreate([A]);
     *
     * expect(() => injector.getAt(100)).toThrowError();
     * ```
     *
     */
    function outOfBoundsError(index) {
        return Error("Index " + index + " is out-of-bounds.");
    }
    // TODO: add a working example after alpha38 is released
    /**
     * Thrown when a multi provider and a regular provider are bound to the same token.
     *
     * @usageNotes
     * ### Example
     *
     * ```typescript
     * expect(() => Injector.resolveAndCreate([
     *   { provide: "Strings", useValue: "string1", multi: true},
     *   { provide: "Strings", useValue: "string2", multi: false}
     * ])).toThrowError();
     * ```
     */
    function mixingMultiProvidersWithRegularProvidersError(provider1, provider2) {
        return Error("Cannot mix multi providers and regular providers, got: " + provider1 + " " + provider2);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * A unique object used for retrieving items from the {@link ReflectiveInjector}.
     *
     * Keys have:
     * - a system-wide unique `id`.
     * - a `token`.
     *
     * `Key` is used internally by {@link ReflectiveInjector} because its system-wide unique `id` allows
     * the
     * injector to store created objects in a more efficient way.
     *
     * `Key` should not be created directly. {@link ReflectiveInjector} creates keys automatically when
     * resolving
     * providers.
     *
     * @deprecated No replacement
     * @publicApi
     */
    var ReflectiveKey = /** @class */ (function () {
        /**
         * Private
         */
        function ReflectiveKey(token, id) {
            this.token = token;
            this.id = id;
            if (!token) {
                throw new Error('Token must be defined!');
            }
            this.displayName = stringify(this.token);
        }
        /**
         * Retrieves a `Key` for a token.
         */
        ReflectiveKey.get = function (token) {
            return _globalKeyRegistry.get(resolveForwardRef(token));
        };
        Object.defineProperty(ReflectiveKey, "numberOfKeys", {
            /**
             * @returns the number of keys registered in the system.
             */
            get: function () {
                return _globalKeyRegistry.numberOfKeys;
            },
            enumerable: false,
            configurable: true
        });
        return ReflectiveKey;
    }());
    var KeyRegistry = /** @class */ (function () {
        function KeyRegistry() {
            this._allKeys = new Map();
        }
        KeyRegistry.prototype.get = function (token) {
            if (token instanceof ReflectiveKey)
                return token;
            if (this._allKeys.has(token)) {
                return this._allKeys.get(token);
            }
            var newKey = new ReflectiveKey(token, ReflectiveKey.numberOfKeys);
            this._allKeys.set(token, newKey);
            return newKey;
        };
        Object.defineProperty(KeyRegistry.prototype, "numberOfKeys", {
            get: function () {
                return this._allKeys.size;
            },
            enumerable: false,
            configurable: true
        });
        return KeyRegistry;
    }());
    var _globalKeyRegistry = new KeyRegistry();

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Provides access to reflection data about symbols. Used internally by Angular
     * to power dependency injection and compilation.
     */
    var Reflector = /** @class */ (function () {
        function Reflector(reflectionCapabilities) {
            this.reflectionCapabilities = reflectionCapabilities;
        }
        Reflector.prototype.updateCapabilities = function (caps) {
            this.reflectionCapabilities = caps;
        };
        Reflector.prototype.factory = function (type) {
            return this.reflectionCapabilities.factory(type);
        };
        Reflector.prototype.parameters = function (typeOrFunc) {
            return this.reflectionCapabilities.parameters(typeOrFunc);
        };
        Reflector.prototype.annotations = function (typeOrFunc) {
            return this.reflectionCapabilities.annotations(typeOrFunc);
        };
        Reflector.prototype.propMetadata = function (typeOrFunc) {
            return this.reflectionCapabilities.propMetadata(typeOrFunc);
        };
        Reflector.prototype.hasLifecycleHook = function (type, lcProperty) {
            return this.reflectionCapabilities.hasLifecycleHook(type, lcProperty);
        };
        Reflector.prototype.getter = function (name) {
            return this.reflectionCapabilities.getter(name);
        };
        Reflector.prototype.setter = function (name) {
            return this.reflectionCapabilities.setter(name);
        };
        Reflector.prototype.method = function (name) {
            return this.reflectionCapabilities.method(name);
        };
        Reflector.prototype.importUri = function (type) {
            return this.reflectionCapabilities.importUri(type);
        };
        Reflector.prototype.resourceUri = function (type) {
            return this.reflectionCapabilities.resourceUri(type);
        };
        Reflector.prototype.resolveIdentifier = function (name, moduleUrl, members, runtime) {
            return this.reflectionCapabilities.resolveIdentifier(name, moduleUrl, members, runtime);
        };
        Reflector.prototype.resolveEnum = function (identifier, name) {
            return this.reflectionCapabilities.resolveEnum(identifier, name);
        };
        return Reflector;
    }());

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * The {@link Reflector} used internally in Angular to access metadata
     * about symbols.
     */
    var reflector = new Reflector(new ReflectionCapabilities());

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * `Dependency` is used by the framework to extend DI.
     * This is internal to Angular and should not be used directly.
     */
    var ReflectiveDependency = /** @class */ (function () {
        function ReflectiveDependency(key, optional, visibility) {
            this.key = key;
            this.optional = optional;
            this.visibility = visibility;
        }
        ReflectiveDependency.fromKey = function (key) {
            return new ReflectiveDependency(key, false, null);
        };
        return ReflectiveDependency;
    }());
    var _EMPTY_LIST = [];
    var ResolvedReflectiveProvider_ = /** @class */ (function () {
        function ResolvedReflectiveProvider_(key, resolvedFactories, multiProvider) {
            this.key = key;
            this.resolvedFactories = resolvedFactories;
            this.multiProvider = multiProvider;
            this.resolvedFactory = this.resolvedFactories[0];
        }
        return ResolvedReflectiveProvider_;
    }());
    /**
     * An internal resolved representation of a factory function created by resolving `Provider`.
     * @publicApi
     */
    var ResolvedReflectiveFactory = /** @class */ (function () {
        function ResolvedReflectiveFactory(
        /**
         * Factory function which can return an instance of an object represented by a key.
         */
        factory, 
        /**
         * Arguments (dependencies) to the `factory` function.
         */
        dependencies) {
            this.factory = factory;
            this.dependencies = dependencies;
        }
        return ResolvedReflectiveFactory;
    }());
    /**
     * Resolve a single provider.
     */
    function resolveReflectiveFactory(provider) {
        var factoryFn;
        var resolvedDeps;
        if (provider.useClass) {
            var useClass = resolveForwardRef(provider.useClass);
            factoryFn = reflector.factory(useClass);
            resolvedDeps = _dependenciesFor(useClass);
        }
        else if (provider.useExisting) {
            factoryFn = function (aliasInstance) { return aliasInstance; };
            resolvedDeps = [ReflectiveDependency.fromKey(ReflectiveKey.get(provider.useExisting))];
        }
        else if (provider.useFactory) {
            factoryFn = provider.useFactory;
            resolvedDeps = constructDependencies(provider.useFactory, provider.deps);
        }
        else {
            factoryFn = function () { return provider.useValue; };
            resolvedDeps = _EMPTY_LIST;
        }
        return new ResolvedReflectiveFactory(factoryFn, resolvedDeps);
    }
    /**
     * Converts the `Provider` into `ResolvedProvider`.
     *
     * `Injector` internally only uses `ResolvedProvider`, `Provider` contains convenience provider
     * syntax.
     */
    function resolveReflectiveProvider(provider) {
        return new ResolvedReflectiveProvider_(ReflectiveKey.get(provider.provide), [resolveReflectiveFactory(provider)], provider.multi || false);
    }
    /**
     * Resolve a list of Providers.
     */
    function resolveReflectiveProviders(providers) {
        var normalized = _normalizeProviders(providers, []);
        var resolved = normalized.map(resolveReflectiveProvider);
        var resolvedProviderMap = mergeResolvedReflectiveProviders(resolved, new Map());
        return Array.from(resolvedProviderMap.values());
    }
    /**
     * Merges a list of ResolvedProviders into a list where each key is contained exactly once and
     * multi providers have been merged.
     */
    function mergeResolvedReflectiveProviders(providers, normalizedProvidersMap) {
        for (var i = 0; i < providers.length; i++) {
            var provider = providers[i];
            var existing = normalizedProvidersMap.get(provider.key.id);
            if (existing) {
                if (provider.multiProvider !== existing.multiProvider) {
                    throw mixingMultiProvidersWithRegularProvidersError(existing, provider);
                }
                if (provider.multiProvider) {
                    for (var j = 0; j < provider.resolvedFactories.length; j++) {
                        existing.resolvedFactories.push(provider.resolvedFactories[j]);
                    }
                }
                else {
                    normalizedProvidersMap.set(provider.key.id, provider);
                }
            }
            else {
                var resolvedProvider = void 0;
                if (provider.multiProvider) {
                    resolvedProvider = new ResolvedReflectiveProvider_(provider.key, provider.resolvedFactories.slice(), provider.multiProvider);
                }
                else {
                    resolvedProvider = provider;
                }
                normalizedProvidersMap.set(provider.key.id, resolvedProvider);
            }
        }
        return normalizedProvidersMap;
    }
    function _normalizeProviders(providers, res) {
        providers.forEach(function (b) {
            if (b instanceof Type) {
                res.push({ provide: b, useClass: b });
            }
            else if (b && typeof b == 'object' && b.provide !== undefined) {
                res.push(b);
            }
            else if (Array.isArray(b)) {
                _normalizeProviders(b, res);
            }
            else {
                throw invalidProviderError(b);
            }
        });
        return res;
    }
    function constructDependencies(typeOrFunc, dependencies) {
        if (!dependencies) {
            return _dependenciesFor(typeOrFunc);
        }
        else {
            var params_1 = dependencies.map(function (t) { return [t]; });
            return dependencies.map(function (t) { return _extractToken(typeOrFunc, t, params_1); });
        }
    }
    function _dependenciesFor(typeOrFunc) {
        var params = reflector.parameters(typeOrFunc);
        if (!params)
            return [];
        if (params.some(function (p) { return p == null; })) {
            throw noAnnotationError(typeOrFunc, params);
        }
        return params.map(function (p) { return _extractToken(typeOrFunc, p, params); });
    }
    function _extractToken(typeOrFunc, metadata, params) {
        var token = null;
        var optional = false;
        if (!Array.isArray(metadata)) {
            if (metadata instanceof Inject) {
                return _createDependency(metadata.token, optional, null);
            }
            else {
                return _createDependency(metadata, optional, null);
            }
        }
        var visibility = null;
        for (var i = 0; i < metadata.length; ++i) {
            var paramMetadata = metadata[i];
            if (paramMetadata instanceof Type) {
                token = paramMetadata;
            }
            else if (paramMetadata instanceof Inject) {
                token = paramMetadata.token;
            }
            else if (paramMetadata instanceof Optional) {
                optional = true;
            }
            else if (paramMetadata instanceof Self || paramMetadata instanceof SkipSelf) {
                visibility = paramMetadata;
            }
            else if (paramMetadata instanceof InjectionToken) {
                token = paramMetadata;
            }
        }
        token = resolveForwardRef(token);
        if (token != null) {
            return _createDependency(token, optional, visibility);
        }
        else {
            throw noAnnotationError(typeOrFunc, params);
        }
    }
    function _createDependency(token, optional, visibility) {
        return new ReflectiveDependency(ReflectiveKey.get(token), optional, visibility);
    }

    // Threshold for the dynamic version
    var UNDEFINED = {};
    /**
     * A ReflectiveDependency injection container used for instantiating objects and resolving
     * dependencies.
     *
     * An `Injector` is a replacement for a `new` operator, which can automatically resolve the
     * constructor dependencies.
     *
     * In typical use, application code asks for the dependencies in the constructor and they are
     * resolved by the `Injector`.
     *
     * @usageNotes
     * ### Example
     *
     * The following example creates an `Injector` configured to create `Engine` and `Car`.
     *
     * ```typescript
     * @Injectable()
     * class Engine {
     * }
     *
     * @Injectable()
     * class Car {
     *   constructor(public engine:Engine) {}
     * }
     *
     * var injector = ReflectiveInjector.resolveAndCreate([Car, Engine]);
     * var car = injector.get(Car);
     * expect(car instanceof Car).toBe(true);
     * expect(car.engine instanceof Engine).toBe(true);
     * ```
     *
     * Notice, we don't use the `new` operator because we explicitly want to have the `Injector`
     * resolve all of the object's dependencies automatically.
     *
     * @deprecated from v5 - slow and brings in a lot of code, Use `Injector.create` instead.
     * @publicApi
     */
    var ReflectiveInjector = /** @class */ (function () {
        function ReflectiveInjector() {
        }
        /**
         * Turns an array of provider definitions into an array of resolved providers.
         *
         * A resolution is a process of flattening multiple nested arrays and converting individual
         * providers into an array of `ResolvedReflectiveProvider`s.
         *
         * @usageNotes
         * ### Example
         *
         * ```typescript
         * @Injectable()
         * class Engine {
         * }
         *
         * @Injectable()
         * class Car {
         *   constructor(public engine:Engine) {}
         * }
         *
         * var providers = ReflectiveInjector.resolve([Car, [[Engine]]]);
         *
         * expect(providers.length).toEqual(2);
         *
         * expect(providers[0] instanceof ResolvedReflectiveProvider).toBe(true);
         * expect(providers[0].key.displayName).toBe("Car");
         * expect(providers[0].dependencies.length).toEqual(1);
         * expect(providers[0].factory).toBeDefined();
         *
         * expect(providers[1].key.displayName).toBe("Engine");
         * });
         * ```
         *
         */
        ReflectiveInjector.resolve = function (providers) {
            return resolveReflectiveProviders(providers);
        };
        /**
         * Resolves an array of providers and creates an injector from those providers.
         *
         * The passed-in providers can be an array of `Type`, `Provider`,
         * or a recursive array of more providers.
         *
         * @usageNotes
         * ### Example
         *
         * ```typescript
         * @Injectable()
         * class Engine {
         * }
         *
         * @Injectable()
         * class Car {
         *   constructor(public engine:Engine) {}
         * }
         *
         * var injector = ReflectiveInjector.resolveAndCreate([Car, Engine]);
         * expect(injector.get(Car) instanceof Car).toBe(true);
         * ```
         */
        ReflectiveInjector.resolveAndCreate = function (providers, parent) {
            var ResolvedReflectiveProviders = ReflectiveInjector.resolve(providers);
            return ReflectiveInjector.fromResolvedProviders(ResolvedReflectiveProviders, parent);
        };
        /**
         * Creates an injector from previously resolved providers.
         *
         * This API is the recommended way to construct injectors in performance-sensitive parts.
         *
         * @usageNotes
         * ### Example
         *
         * ```typescript
         * @Injectable()
         * class Engine {
         * }
         *
         * @Injectable()
         * class Car {
         *   constructor(public engine:Engine) {}
         * }
         *
         * var providers = ReflectiveInjector.resolve([Car, Engine]);
         * var injector = ReflectiveInjector.fromResolvedProviders(providers);
         * expect(injector.get(Car) instanceof Car).toBe(true);
         * ```
         */
        ReflectiveInjector.fromResolvedProviders = function (providers, parent) {
            return new ReflectiveInjector_(providers, parent);
        };
        return ReflectiveInjector;
    }());
    var ReflectiveInjector_ = /** @class */ (function () {
        /**
         * Private
         */
        function ReflectiveInjector_(_providers, _parent) {
            /** @internal */
            this._constructionCounter = 0;
            this._providers = _providers;
            this.parent = _parent || null;
            var len = _providers.length;
            this.keyIds = [];
            this.objs = [];
            for (var i = 0; i < len; i++) {
                this.keyIds[i] = _providers[i].key.id;
                this.objs[i] = UNDEFINED;
            }
        }
        ReflectiveInjector_.prototype.get = function (token, notFoundValue) {
            if (notFoundValue === void 0) { notFoundValue = THROW_IF_NOT_FOUND; }
            return this._getByKey(ReflectiveKey.get(token), null, notFoundValue);
        };
        ReflectiveInjector_.prototype.resolveAndCreateChild = function (providers) {
            var ResolvedReflectiveProviders = ReflectiveInjector.resolve(providers);
            return this.createChildFromResolved(ResolvedReflectiveProviders);
        };
        ReflectiveInjector_.prototype.createChildFromResolved = function (providers) {
            var inj = new ReflectiveInjector_(providers);
            inj.parent = this;
            return inj;
        };
        ReflectiveInjector_.prototype.resolveAndInstantiate = function (provider) {
            return this.instantiateResolved(ReflectiveInjector.resolve([provider])[0]);
        };
        ReflectiveInjector_.prototype.instantiateResolved = function (provider) {
            return this._instantiateProvider(provider);
        };
        ReflectiveInjector_.prototype.getProviderAtIndex = function (index) {
            if (index < 0 || index >= this._providers.length) {
                throw outOfBoundsError(index);
            }
            return this._providers[index];
        };
        /** @internal */
        ReflectiveInjector_.prototype._new = function (provider) {
            if (this._constructionCounter++ > this._getMaxNumberOfObjects()) {
                throw cyclicDependencyError(this, provider.key);
            }
            return this._instantiateProvider(provider);
        };
        ReflectiveInjector_.prototype._getMaxNumberOfObjects = function () {
            return this.objs.length;
        };
        ReflectiveInjector_.prototype._instantiateProvider = function (provider) {
            if (provider.multiProvider) {
                var res = [];
                for (var i = 0; i < provider.resolvedFactories.length; ++i) {
                    res[i] = this._instantiate(provider, provider.resolvedFactories[i]);
                }
                return res;
            }
            else {
                return this._instantiate(provider, provider.resolvedFactories[0]);
            }
        };
        ReflectiveInjector_.prototype._instantiate = function (provider, ResolvedReflectiveFactory) {
            var _this = this;
            var factory = ResolvedReflectiveFactory.factory;
            var deps;
            try {
                deps =
                    ResolvedReflectiveFactory.dependencies.map(function (dep) { return _this._getByReflectiveDependency(dep); });
            }
            catch (e) {
                if (e.addKey) {
                    e.addKey(this, provider.key);
                }
                throw e;
            }
            var obj;
            try {
                obj = factory.apply(void 0, __spread(deps));
            }
            catch (e) {
                throw instantiationError(this, e, e.stack, provider.key);
            }
            return obj;
        };
        ReflectiveInjector_.prototype._getByReflectiveDependency = function (dep) {
            return this._getByKey(dep.key, dep.visibility, dep.optional ? null : THROW_IF_NOT_FOUND);
        };
        ReflectiveInjector_.prototype._getByKey = function (key, visibility, notFoundValue) {
            if (key === ReflectiveInjector_.INJECTOR_KEY) {
                return this;
            }
            if (visibility instanceof Self) {
                return this._getByKeySelf(key, notFoundValue);
            }
            else {
                return this._getByKeyDefault(key, notFoundValue, visibility);
            }
        };
        ReflectiveInjector_.prototype._getObjByKeyId = function (keyId) {
            for (var i = 0; i < this.keyIds.length; i++) {
                if (this.keyIds[i] === keyId) {
                    if (this.objs[i] === UNDEFINED) {
                        this.objs[i] = this._new(this._providers[i]);
                    }
                    return this.objs[i];
                }
            }
            return UNDEFINED;
        };
        /** @internal */
        ReflectiveInjector_.prototype._throwOrNull = function (key, notFoundValue) {
            if (notFoundValue !== THROW_IF_NOT_FOUND) {
                return notFoundValue;
            }
            else {
                throw noProviderError(this, key);
            }
        };
        /** @internal */
        ReflectiveInjector_.prototype._getByKeySelf = function (key, notFoundValue) {
            var obj = this._getObjByKeyId(key.id);
            return (obj !== UNDEFINED) ? obj : this._throwOrNull(key, notFoundValue);
        };
        /** @internal */
        ReflectiveInjector_.prototype._getByKeyDefault = function (key, notFoundValue, visibility) {
            var inj;
            if (visibility instanceof SkipSelf) {
                inj = this.parent;
            }
            else {
                inj = this;
            }
            while (inj instanceof ReflectiveInjector_) {
                var inj_ = inj;
                var obj = inj_._getObjByKeyId(key.id);
                if (obj !== UNDEFINED)
                    return obj;
                inj = inj_.parent;
            }
            if (inj !== null) {
                return inj.get(key.token, notFoundValue);
            }
            else {
                return this._throwOrNull(key, notFoundValue);
            }
        };
        Object.defineProperty(ReflectiveInjector_.prototype, "displayName", {
            get: function () {
                var providers = _mapProviders(this, function (b) { return ' "' + b.key.displayName + '" '; })
                    .join(', ');
                return "ReflectiveInjector(providers: [" + providers + "])";
            },
            enumerable: false,
            configurable: true
        });
        ReflectiveInjector_.prototype.toString = function () {
            return this.displayName;
        };
        return ReflectiveInjector_;
    }());
    ReflectiveInjector_.INJECTOR_KEY = ReflectiveKey.get(Injector);
    function _mapProviders(injector, fn) {
        var res = [];
        for (var i = 0; i < injector._providers.length; ++i) {
            res[i] = fn(injector.getProviderAtIndex(i));
        }
        return res;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function ɵɵdirectiveInject(token, flags) {
        if (flags === void 0) { flags = exports.InjectFlags.Default; }
        var lView = getLView();
        // Fall back to inject() if view hasn't been created. This situation can happen in tests
        // if inject utilities are used before bootstrapping.
        if (lView === null) {
            // Verify that we will not get into infinite loop.
            ngDevMode && assertInjectImplementationNotEqual(ɵɵdirectiveInject);
            return ɵɵinject(token, flags);
        }
        var tNode = getCurrentTNode();
        return getOrCreateInjectable(tNode, lView, resolveForwardRef(token), flags);
    }
    /**
     * Throws an error indicating that a factory function could not be generated by the compiler for a
     * particular class.
     *
     * This instruction allows the actual error message to be optimized away when ngDevMode is turned
     * off, saving bytes of generated code while still providing a good experience in dev mode.
     *
     * The name of the class is not mentioned here, but will be in the generated factory function name
     * and thus in the stack trace.
     *
     * @codeGenApi
     */
    function ɵɵinvalidFactory() {
        var msg = ngDevMode ? "This constructor was not compatible with Dependency Injection." : 'invalid';
        throw new Error(msg);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Update a property on a selected element.
     *
     * Operates on the element selected by index via the {@link select} instruction.
     *
     * If the property name also exists as an input property on one of the element's directives,
     * the component property will be set instead of the element property. This check must
     * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled
     *
     * @param propName Name of property. Because it is going to DOM, this is not subject to
     *        renaming as part of minification.
     * @param value New value to write.
     * @param sanitizer An optional function used to sanitize the value.
     * @returns This function returns itself so that it may be chained
     * (e.g. `property('name', ctx.name)('title', ctx.title)`)
     *
     * @codeGenApi
     */
    function ɵɵproperty(propName, value, sanitizer) {
        var lView = getLView();
        var bindingIndex = nextBindingIndex();
        if (bindingUpdated(lView, bindingIndex, value)) {
            var tView = getTView();
            var tNode = getSelectedTNode();
            elementPropertyInternal(tView, tNode, lView, propName, value, lView[RENDERER], sanitizer, false);
            ngDevMode && storePropertyBindingMetadata(tView.data, tNode, propName, bindingIndex);
        }
        return ɵɵproperty;
    }
    /**
     * Given `<div style="..." my-dir>` and `MyDir` with `@Input('style')` we need to write to
     * directive input.
     */
    function setDirectiveInputsWhichShadowsStyling(tView, tNode, lView, value, isClassBased) {
        var inputs = tNode.inputs;
        var property = isClassBased ? 'class' : 'style';
        // We support both 'class' and `className` hence the fallback.
        setInputsForProperty(tView, lView, inputs[property], property, value);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function elementStartFirstCreatePass(index, tView, lView, native, name, attrsIndex, localRefsIndex) {
        ngDevMode && assertFirstCreatePass(tView);
        ngDevMode && ngDevMode.firstCreatePass++;
        var tViewConsts = tView.consts;
        var attrs = getConstant(tViewConsts, attrsIndex);
        var tNode = getOrCreateTNode(tView, index, 2 /* Element */, name, attrs);
        var hasDirectives = resolveDirectives(tView, lView, tNode, getConstant(tViewConsts, localRefsIndex));
        ngDevMode && logUnknownElementError(tView, native, tNode, hasDirectives);
        if (tNode.attrs !== null) {
            computeStaticStyling(tNode, tNode.attrs, false);
        }
        if (tNode.mergedAttrs !== null) {
            computeStaticStyling(tNode, tNode.mergedAttrs, true);
        }
        if (tView.queries !== null) {
            tView.queries.elementStart(tView, tNode);
        }
        return tNode;
    }
    /**
     * Create DOM element. The instruction must later be followed by `elementEnd()` call.
     *
     * @param index Index of the element in the LView array
     * @param name Name of the DOM Node
     * @param attrsIndex Index of the element's attributes in the `consts` array.
     * @param localRefsIndex Index of the element's local references in the `consts` array.
     *
     * Attributes and localRefs are passed as an array of strings where elements with an even index
     * hold an attribute name and elements with an odd index hold an attribute value, ex.:
     * ['id', 'warning5', 'class', 'alert']
     *
     * @codeGenApi
     */
    function ɵɵelementStart(index, name, attrsIndex, localRefsIndex) {
        var lView = getLView();
        var tView = getTView();
        var adjustedIndex = HEADER_OFFSET + index;
        ngDevMode &&
            assertEqual(getBindingIndex(), tView.bindingStartIndex, 'elements should be created before any bindings');
        ngDevMode && assertIndexInRange(lView, adjustedIndex);
        var renderer = lView[RENDERER];
        var native = lView[adjustedIndex] = createElementNode(renderer, name, getNamespace());
        var tNode = tView.firstCreatePass ?
            elementStartFirstCreatePass(adjustedIndex, tView, lView, native, name, attrsIndex, localRefsIndex) :
            tView.data[adjustedIndex];
        setCurrentTNode(tNode, true);
        var mergedAttrs = tNode.mergedAttrs;
        if (mergedAttrs !== null) {
            setUpAttributes(renderer, native, mergedAttrs);
        }
        var classes = tNode.classes;
        if (classes !== null) {
            writeDirectClass(renderer, native, classes);
        }
        var styles = tNode.styles;
        if (styles !== null) {
            writeDirectStyle(renderer, native, styles);
        }
        if ((tNode.flags & 64 /* isDetached */) !== 64 /* isDetached */) {
            // In the i18n case, the translation may have removed this element, so only add it if it is not
            // detached. See `TNodeType.Placeholder` and `LFrame.inI18n` for more context.
            appendChild(tView, lView, native, tNode);
        }
        // any immediate children of a component or template container must be pre-emptively
        // monkey-patched with the component view data so that the element can be inspected
        // later on using any element discovery utility methods (see `element_discovery.ts`)
        if (getElementDepthCount() === 0) {
            attachPatchData(native, lView);
        }
        increaseElementDepthCount();
        if (isDirectiveHost(tNode)) {
            createDirectivesInstances(tView, lView, tNode);
            executeContentQueries(tView, tNode, lView);
        }
        if (localRefsIndex !== null) {
            saveResolvedLocalsInData(lView, tNode);
        }
    }
    /**
     * Mark the end of the element.
     *
     * @codeGenApi
     */
    function ɵɵelementEnd() {
        var currentTNode = getCurrentTNode();
        ngDevMode && assertDefined(currentTNode, 'No parent node to close.');
        if (isCurrentTNodeParent()) {
            setCurrentTNodeAsNotParent();
        }
        else {
            ngDevMode && assertHasParent(getCurrentTNode());
            currentTNode = currentTNode.parent;
            setCurrentTNode(currentTNode, false);
        }
        var tNode = currentTNode;
        ngDevMode && assertTNodeType(tNode, 3 /* AnyRNode */);
        decreaseElementDepthCount();
        var tView = getTView();
        if (tView.firstCreatePass) {
            registerPostOrderHooks(tView, currentTNode);
            if (isContentQueryHost(currentTNode)) {
                tView.queries.elementEnd(currentTNode);
            }
        }
        if (tNode.classesWithoutHost != null && hasClassInput(tNode)) {
            setDirectiveInputsWhichShadowsStyling(tView, tNode, getLView(), tNode.classesWithoutHost, true);
        }
        if (tNode.stylesWithoutHost != null && hasStyleInput(tNode)) {
            setDirectiveInputsWhichShadowsStyling(tView, tNode, getLView(), tNode.stylesWithoutHost, false);
        }
    }
    /**
     * Creates an empty element using {@link elementStart} and {@link elementEnd}
     *
     * @param index Index of the element in the data array
     * @param name Name of the DOM Node
     * @param attrsIndex Index of the element's attributes in the `consts` array.
     * @param localRefsIndex Index of the element's local references in the `consts` array.
     *
     * @codeGenApi
     */
    function ɵɵelement(index, name, attrsIndex, localRefsIndex) {
        ɵɵelementStart(index, name, attrsIndex, localRefsIndex);
        ɵɵelementEnd();
    }
    function logUnknownElementError(tView, element, tNode, hasDirectives) {
        var schemas = tView.schemas;
        // If `schemas` is set to `null`, that's an indication that this Component was compiled in AOT
        // mode where this check happens at compile time. In JIT mode, `schemas` is always present and
        // defined as an array (as an empty array in case `schemas` field is not defined) and we should
        // execute the check below.
        if (schemas === null)
            return;
        var tagName = tNode.value;
        // If the element matches any directive, it's considered as valid.
        if (!hasDirectives && tagName !== null) {
            // The element is unknown if it's an instance of HTMLUnknownElement or it isn't registered
            // as a custom element. Note that unknown elements with a dash in their name won't be instances
            // of HTMLUnknownElement in browsers that support web components.
            var isUnknown = 
            // Note that we can't check for `typeof HTMLUnknownElement === 'function'`,
            // because while most browsers return 'function', IE returns 'object'.
            (typeof HTMLUnknownElement !== 'undefined' && HTMLUnknownElement &&
                element instanceof HTMLUnknownElement) ||
                (typeof customElements !== 'undefined' && tagName.indexOf('-') > -1 &&
                    !customElements.get(tagName));
            if (isUnknown && !matchingSchemas(tView, tagName)) {
                var message = "'" + tagName + "' is not a known element:\n";
                message += "1. If '" + tagName + "' is an Angular component, then verify that it is part of this module.\n";
                if (tagName && tagName.indexOf('-') > -1) {
                    message += "2. If '" + tagName + "' is a Web Component then add 'CUSTOM_ELEMENTS_SCHEMA' to the '@NgModule.schemas' of this component to suppress this message.";
                }
                else {
                    message +=
                        "2. To allow any element add 'NO_ERRORS_SCHEMA' to the '@NgModule.schemas' of this component.";
                }
                console.error(formatRuntimeError("304" /* UNKNOWN_ELEMENT */, message));
            }
        }
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function elementContainerStartFirstCreatePass(index, tView, lView, attrsIndex, localRefsIndex) {
        ngDevMode && ngDevMode.firstCreatePass++;
        var tViewConsts = tView.consts;
        var attrs = getConstant(tViewConsts, attrsIndex);
        var tNode = getOrCreateTNode(tView, index, 8 /* ElementContainer */, 'ng-container', attrs);
        // While ng-container doesn't necessarily support styling, we use the style context to identify
        // and execute directives on the ng-container.
        if (attrs !== null) {
            computeStaticStyling(tNode, attrs, true);
        }
        var localRefs = getConstant(tViewConsts, localRefsIndex);
        resolveDirectives(tView, lView, tNode, localRefs);
        if (tView.queries !== null) {
            tView.queries.elementStart(tView, tNode);
        }
        return tNode;
    }
    /**
     * Creates a logical container for other nodes (<ng-container>) backed by a comment node in the DOM.
     * The instruction must later be followed by `elementContainerEnd()` call.
     *
     * @param index Index of the element in the LView array
     * @param attrsIndex Index of the container attributes in the `consts` array.
     * @param localRefsIndex Index of the container's local references in the `consts` array.
     *
     * Even if this instruction accepts a set of attributes no actual attribute values are propagated to
     * the DOM (as a comment node can't have attributes). Attributes are here only for directive
     * matching purposes and setting initial inputs of directives.
     *
     * @codeGenApi
     */
    function ɵɵelementContainerStart(index, attrsIndex, localRefsIndex) {
        var lView = getLView();
        var tView = getTView();
        var adjustedIndex = index + HEADER_OFFSET;
        ngDevMode && assertIndexInRange(lView, adjustedIndex);
        ngDevMode &&
            assertEqual(getBindingIndex(), tView.bindingStartIndex, 'element containers should be created before any bindings');
        var tNode = tView.firstCreatePass ?
            elementContainerStartFirstCreatePass(adjustedIndex, tView, lView, attrsIndex, localRefsIndex) :
            tView.data[adjustedIndex];
        setCurrentTNode(tNode, true);
        ngDevMode && ngDevMode.rendererCreateComment++;
        var native = lView[adjustedIndex] =
            lView[RENDERER].createComment(ngDevMode ? 'ng-container' : '');
        appendChild(tView, lView, native, tNode);
        attachPatchData(native, lView);
        if (isDirectiveHost(tNode)) {
            createDirectivesInstances(tView, lView, tNode);
            executeContentQueries(tView, tNode, lView);
        }
        if (localRefsIndex != null) {
            saveResolvedLocalsInData(lView, tNode);
        }
    }
    /**
     * Mark the end of the <ng-container>.
     *
     * @codeGenApi
     */
    function ɵɵelementContainerEnd() {
        var currentTNode = getCurrentTNode();
        var tView = getTView();
        if (isCurrentTNodeParent()) {
            setCurrentTNodeAsNotParent();
        }
        else {
            ngDevMode && assertHasParent(currentTNode);
            currentTNode = currentTNode.parent;
            setCurrentTNode(currentTNode, false);
        }
        ngDevMode && assertTNodeType(currentTNode, 8 /* ElementContainer */);
        if (tView.firstCreatePass) {
            registerPostOrderHooks(tView, currentTNode);
            if (isContentQueryHost(currentTNode)) {
                tView.queries.elementEnd(currentTNode);
            }
        }
    }
    /**
     * Creates an empty logical container using {@link elementContainerStart}
     * and {@link elementContainerEnd}
     *
     * @param index Index of the element in the LView array
     * @param attrsIndex Index of the container attributes in the `consts` array.
     * @param localRefsIndex Index of the container's local references in the `consts` array.
     *
     * @codeGenApi
     */
    function ɵɵelementContainer(index, attrsIndex, localRefsIndex) {
        ɵɵelementContainerStart(index, attrsIndex, localRefsIndex);
        ɵɵelementContainerEnd();
    }

    /**
     * Returns the current OpaqueViewState instance.
     *
     * Used in conjunction with the restoreView() instruction to save a snapshot
     * of the current view and restore it when listeners are invoked. This allows
     * walking the declaration view tree in listeners to get vars from parent views.
     *
     * @codeGenApi
     */
    function ɵɵgetCurrentView() {
        return getLView();
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Determine if the argument is shaped like a Promise
     */
    function isPromise(obj) {
        // allow any Promise/A+ compliant thenable.
        // It's up to the caller to ensure that obj.then conforms to the spec
        return !!obj && typeof obj.then === 'function';
    }
    /**
     * Determine if the argument is a Subscribable
     */
    function isSubscribable(obj) {
        return !!obj && typeof obj.subscribe === 'function';
    }
    /**
     * Determine if the argument is an Observable
     *
     * Strictly this tests that the `obj` is `Subscribable`, since `Observable`
     * types need additional methods, such as `lift()`. But it is adequate for our
     * needs since within the Angular framework code we only ever need to use the
     * `subscribe()` method, and RxJS has mechanisms to wrap `Subscribable` objects
     * into `Observable` as needed.
     */
    var isObservable = isSubscribable;

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Adds an event listener to the current node.
     *
     * If an output exists on one of the node's directives, it also subscribes to the output
     * and saves the subscription for later cleanup.
     *
     * @param eventName Name of the event
     * @param listenerFn The function to be called when event emits
     * @param useCapture Whether or not to use capture in event listener
     * @param eventTargetResolver Function that returns global target information in case this listener
     * should be attached to a global object like window, document or body
     *
     * @codeGenApi
     */
    function ɵɵlistener(eventName, listenerFn, useCapture, eventTargetResolver) {
        if (useCapture === void 0) { useCapture = false; }
        var lView = getLView();
        var tView = getTView();
        var tNode = getCurrentTNode();
        listenerInternal(tView, lView, lView[RENDERER], tNode, eventName, listenerFn, useCapture, eventTargetResolver);
        return ɵɵlistener;
    }
    /**
     * Registers a synthetic host listener (e.g. `(@foo.start)`) on a component or directive.
     *
     * This instruction is for compatibility purposes and is designed to ensure that a
     * synthetic host listener (e.g. `@HostListener('@foo.start')`) properly gets rendered
     * in the component's renderer. Normally all host listeners are evaluated with the
     * parent component's renderer, but, in the case of animation @triggers, they need
     * to be evaluated with the sub component's renderer (because that's where the
     * animation triggers are defined).
     *
     * Do not use this instruction as a replacement for `listener`. This instruction
     * only exists to ensure compatibility with the ViewEngine's host binding behavior.
     *
     * @param eventName Name of the event
     * @param listenerFn The function to be called when event emits
     * @param useCapture Whether or not to use capture in event listener
     * @param eventTargetResolver Function that returns global target information in case this listener
     * should be attached to a global object like window, document or body
     *
     * @codeGenApi
     */
    function ɵɵsyntheticHostListener(eventName, listenerFn, useCapture, eventTargetResolver) {
        if (useCapture === void 0) { useCapture = false; }
        var tNode = getCurrentTNode();
        var lView = getLView();
        var tView = getTView();
        var currentDef = getCurrentDirectiveDef(tView.data);
        var renderer = loadComponentRenderer(currentDef, tNode, lView);
        listenerInternal(tView, lView, renderer, tNode, eventName, listenerFn, useCapture, eventTargetResolver);
        return ɵɵsyntheticHostListener;
    }
    /**
     * A utility function that checks if a given element has already an event handler registered for an
     * event with a specified name. The TView.cleanup data structure is used to find out which events
     * are registered for a given element.
     */
    function findExistingListener(tView, lView, eventName, tNodeIdx) {
        var tCleanup = tView.cleanup;
        if (tCleanup != null) {
            for (var i = 0; i < tCleanup.length - 1; i += 2) {
                var cleanupEventName = tCleanup[i];
                if (cleanupEventName === eventName && tCleanup[i + 1] === tNodeIdx) {
                    // We have found a matching event name on the same node but it might not have been
                    // registered yet, so we must explicitly verify entries in the LView cleanup data
                    // structures.
                    var lCleanup = lView[CLEANUP];
                    var listenerIdxInLCleanup = tCleanup[i + 2];
                    return lCleanup.length > listenerIdxInLCleanup ? lCleanup[listenerIdxInLCleanup] : null;
                }
                // TView.cleanup can have a mix of 4-elements entries (for event handler cleanups) or
                // 2-element entries (for directive and queries destroy hooks). As such we can encounter
                // blocks of 4 or 2 items in the tView.cleanup and this is why we iterate over 2 elements
                // first and jump another 2 elements if we detect listeners cleanup (4 elements). Also check
                // documentation of TView.cleanup for more details of this data structure layout.
                if (typeof cleanupEventName === 'string') {
                    i += 2;
                }
            }
        }
        return null;
    }
    function listenerInternal(tView, lView, renderer, tNode, eventName, listenerFn, useCapture, eventTargetResolver) {
        if (useCapture === void 0) { useCapture = false; }
        var isTNodeDirectiveHost = isDirectiveHost(tNode);
        var firstCreatePass = tView.firstCreatePass;
        var tCleanup = firstCreatePass && getOrCreateTViewCleanup(tView);
        // When the ɵɵlistener instruction was generated and is executed we know that there is either a
        // native listener or a directive output on this element. As such we we know that we will have to
        // register a listener and store its cleanup function on LView.
        var lCleanup = getOrCreateLViewCleanup(lView);
        ngDevMode && assertTNodeType(tNode, 3 /* AnyRNode */ | 12 /* AnyContainer */);
        var processOutputs = true;
        // add native event listener - applicable to elements only
        if (tNode.type & 3 /* AnyRNode */) {
            var native = getNativeByTNode(tNode, lView);
            var resolved = eventTargetResolver ? eventTargetResolver(native) : EMPTY_OBJ;
            var target = resolved.target || native;
            var lCleanupIndex = lCleanup.length;
            var idxOrTargetGetter = eventTargetResolver ?
                function (_lView) { return eventTargetResolver(unwrapRNode(_lView[tNode.index])).target; } :
                tNode.index;
            // In order to match current behavior, native DOM event listeners must be added for all
            // events (including outputs).
            if (isProceduralRenderer(renderer)) {
                // There might be cases where multiple directives on the same element try to register an event
                // handler function for the same event. In this situation we want to avoid registration of
                // several native listeners as each registration would be intercepted by NgZone and
                // trigger change detection. This would mean that a single user action would result in several
                // change detections being invoked. To avoid this situation we want to have only one call to
                // native handler registration (for the same element and same type of event).
                //
                // In order to have just one native event handler in presence of multiple handler functions,
                // we just register a first handler function as a native event listener and then chain
                // (coalesce) other handler functions on top of the first native handler function.
                var existingListener = null;
                // Please note that the coalescing described here doesn't happen for events specifying an
                // alternative target (ex. (document:click)) - this is to keep backward compatibility with the
                // view engine.
                // Also, we don't have to search for existing listeners is there are no directives
                // matching on a given node as we can't register multiple event handlers for the same event in
                // a template (this would mean having duplicate attributes).
                if (!eventTargetResolver && isTNodeDirectiveHost) {
                    existingListener = findExistingListener(tView, lView, eventName, tNode.index);
                }
                if (existingListener !== null) {
                    // Attach a new listener to coalesced listeners list, maintaining the order in which
                    // listeners are registered. For performance reasons, we keep a reference to the last
                    // listener in that list (in `__ngLastListenerFn__` field), so we can avoid going through
                    // the entire set each time we need to add a new listener.
                    var lastListenerFn = existingListener.__ngLastListenerFn__ || existingListener;
                    lastListenerFn.__ngNextListenerFn__ = listenerFn;
                    existingListener.__ngLastListenerFn__ = listenerFn;
                    processOutputs = false;
                }
                else {
                    // The first argument of `listen` function in Procedural Renderer is:
                    // - either a target name (as a string) in case of global target (window, document, body)
                    // - or element reference (in all other cases)
                    listenerFn = wrapListener(tNode, lView, listenerFn, false /** preventDefault */);
                    var cleanupFn = renderer.listen(resolved.name || target, eventName, listenerFn);
                    ngDevMode && ngDevMode.rendererAddEventListener++;
                    lCleanup.push(listenerFn, cleanupFn);
                    tCleanup && tCleanup.push(eventName, idxOrTargetGetter, lCleanupIndex, lCleanupIndex + 1);
                }
            }
            else {
                listenerFn = wrapListener(tNode, lView, listenerFn, true /** preventDefault */);
                target.addEventListener(eventName, listenerFn, useCapture);
                ngDevMode && ngDevMode.rendererAddEventListener++;
                lCleanup.push(listenerFn);
                tCleanup && tCleanup.push(eventName, idxOrTargetGetter, lCleanupIndex, useCapture);
            }
        }
        else {
            // Even if there is no native listener to add, we still need to wrap the listener so that OnPush
            // ancestors are marked dirty when an event occurs.
            listenerFn = wrapListener(tNode, lView, listenerFn, false /** preventDefault */);
        }
        // subscribe to directive outputs
        var outputs = tNode.outputs;
        var props;
        if (processOutputs && outputs !== null && (props = outputs[eventName])) {
            var propsLength = props.length;
            if (propsLength) {
                for (var i = 0; i < propsLength; i += 2) {
                    var index = props[i];
                    ngDevMode && assertIndexInRange(lView, index);
                    var minifiedName = props[i + 1];
                    var directiveInstance = lView[index];
                    var output = directiveInstance[minifiedName];
                    if (ngDevMode && !isObservable(output)) {
                        throw new Error("@Output " + minifiedName + " not initialized in '" + directiveInstance.constructor.name + "'.");
                    }
                    var subscription = output.subscribe(listenerFn);
                    var idx = lCleanup.length;
                    lCleanup.push(listenerFn, subscription);
                    tCleanup && tCleanup.push(eventName, tNode.index, idx, -(idx + 1));
                }
            }
        }
    }
    function executeListenerWithErrorHandling(lView, listenerFn, e) {
        try {
            // Only explicitly returning false from a listener should preventDefault
            return listenerFn(e) !== false;
        }
        catch (error) {
            handleError(lView, error);
            return false;
        }
    }
    /**
     * Wraps an event listener with a function that marks ancestors dirty and prevents default behavior,
     * if applicable.
     *
     * @param tNode The TNode associated with this listener
     * @param lView The LView that contains this listener
     * @param listenerFn The listener function to call
     * @param wrapWithPreventDefault Whether or not to prevent default behavior
     * (the procedural renderer does this already, so in those cases, we should skip)
     */
    function wrapListener(tNode, lView, listenerFn, wrapWithPreventDefault) {
        // Note: we are performing most of the work in the listener function itself
        // to optimize listener registration.
        return function wrapListenerIn_markDirtyAndPreventDefault(e) {
            // Ivy uses `Function` as a special token that allows us to unwrap the function
            // so that it can be invoked programmatically by `DebugNode.triggerEventHandler`.
            if (e === Function) {
                return listenerFn;
            }
            // In order to be backwards compatible with View Engine, events on component host nodes
            // must also mark the component view itself dirty (i.e. the view that it owns).
            var startView = tNode.flags & 2 /* isComponentHost */ ?
                getComponentLViewByIndex(tNode.index, lView) :
                lView;
            // See interfaces/view.ts for more on LViewFlags.ManualOnPush
            if ((lView[FLAGS] & 32 /* ManualOnPush */) === 0) {
                markViewDirty(startView);
            }
            var result = executeListenerWithErrorHandling(lView, listenerFn, e);
            // A just-invoked listener function might have coalesced listeners so we need to check for
            // their presence and invoke as needed.
            var nextListenerFn = wrapListenerIn_markDirtyAndPreventDefault.__ngNextListenerFn__;
            while (nextListenerFn) {
                // We should prevent default if any of the listeners explicitly return false
                result = executeListenerWithErrorHandling(lView, nextListenerFn, e) && result;
                nextListenerFn = nextListenerFn.__ngNextListenerFn__;
            }
            if (wrapWithPreventDefault && result === false) {
                e.preventDefault();
                // Necessary for legacy browsers that don't support preventDefault (e.g. IE)
                e.returnValue = false;
            }
            return result;
        };
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Retrieves a context at the level specified and saves it as the global, contextViewData.
     * Will get the next level up if level is not specified.
     *
     * This is used to save contexts of parent views so they can be bound in embedded views, or
     * in conjunction with reference() to bind a ref from a parent view.
     *
     * @param level The relative level of the view from which to grab context compared to contextVewData
     * @returns context
     *
     * @codeGenApi
     */
    function ɵɵnextContext(level) {
        if (level === void 0) { level = 1; }
        return nextContextImpl(level);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Checks a given node against matching projection slots and returns the
     * determined slot index. Returns "null" if no slot matched the given node.
     *
     * This function takes into account the parsed ngProjectAs selector from the
     * node's attributes. If present, it will check whether the ngProjectAs selector
     * matches any of the projection slot selectors.
     */
    function matchingProjectionSlotIndex(tNode, projectionSlots) {
        var wildcardNgContentIndex = null;
        var ngProjectAsAttrVal = getProjectAsAttrValue(tNode);
        for (var i = 0; i < projectionSlots.length; i++) {
            var slotValue = projectionSlots[i];
            // The last wildcard projection slot should match all nodes which aren't matching
            // any selector. This is necessary to be backwards compatible with view engine.
            if (slotValue === '*') {
                wildcardNgContentIndex = i;
                continue;
            }
            // If we ran into an `ngProjectAs` attribute, we should match its parsed selector
            // to the list of selectors, otherwise we fall back to matching against the node.
            if (ngProjectAsAttrVal === null ?
                isNodeMatchingSelectorList(tNode, slotValue, /* isProjectionMode */ true) :
                isSelectorInSelectorList(ngProjectAsAttrVal, slotValue)) {
                return i; // first matching selector "captures" a given node
            }
        }
        return wildcardNgContentIndex;
    }
    /**
     * Instruction to distribute projectable nodes among <ng-content> occurrences in a given template.
     * It takes all the selectors from the entire component's template and decides where
     * each projected node belongs (it re-distributes nodes among "buckets" where each "bucket" is
     * backed by a selector).
     *
     * This function requires CSS selectors to be provided in 2 forms: parsed (by a compiler) and text,
     * un-parsed form.
     *
     * The parsed form is needed for efficient matching of a node against a given CSS selector.
     * The un-parsed, textual form is needed for support of the ngProjectAs attribute.
     *
     * Having a CSS selector in 2 different formats is not ideal, but alternatives have even more
     * drawbacks:
     * - having only a textual form would require runtime parsing of CSS selectors;
     * - we can't have only a parsed as we can't re-construct textual form from it (as entered by a
     * template author).
     *
     * @param projectionSlots? A collection of projection slots. A projection slot can be based
     *        on a parsed CSS selectors or set to the wildcard selector ("*") in order to match
     *        all nodes which do not match any selector. If not specified, a single wildcard
     *        selector projection slot will be defined.
     *
     * @codeGenApi
     */
    function ɵɵprojectionDef(projectionSlots) {
        var componentNode = getLView()[DECLARATION_COMPONENT_VIEW][T_HOST];
        if (!componentNode.projection) {
            // If no explicit projection slots are defined, fall back to a single
            // projection slot with the wildcard selector.
            var numProjectionSlots = projectionSlots ? projectionSlots.length : 1;
            var projectionHeads = componentNode.projection =
                newArray(numProjectionSlots, null);
            var tails = projectionHeads.slice();
            var componentChild = componentNode.child;
            while (componentChild !== null) {
                var slotIndex = projectionSlots ? matchingProjectionSlotIndex(componentChild, projectionSlots) : 0;
                if (slotIndex !== null) {
                    if (tails[slotIndex]) {
                        tails[slotIndex].projectionNext = componentChild;
                    }
                    else {
                        projectionHeads[slotIndex] = componentChild;
                    }
                    tails[slotIndex] = componentChild;
                }
                componentChild = componentChild.next;
            }
        }
    }
    /**
     * Inserts previously re-distributed projected nodes. This instruction must be preceded by a call
     * to the projectionDef instruction.
     *
     * @param nodeIndex
     * @param selectorIndex:
     *        - 0 when the selector is `*` (or unspecified as this is the default value),
     *        - 1 based index of the selector from the {@link projectionDef}
     *
     * @codeGenApi
     */
    function ɵɵprojection(nodeIndex, selectorIndex, attrs) {
        if (selectorIndex === void 0) { selectorIndex = 0; }
        var lView = getLView();
        var tView = getTView();
        var tProjectionNode = getOrCreateTNode(tView, HEADER_OFFSET + nodeIndex, 16 /* Projection */, null, attrs || null);
        // We can't use viewData[HOST_NODE] because projection nodes can be nested in embedded views.
        if (tProjectionNode.projection === null)
            tProjectionNode.projection = selectorIndex;
        // `<ng-content>` has no content
        setCurrentTNodeAsNotParent();
        if ((tProjectionNode.flags & 64 /* isDetached */) !== 64 /* isDetached */) {
            // re-distribution of projectable nodes is stored on a component's view level
            applyProjection(tView, lView, tProjectionNode);
        }
    }

    /**
     *
     * Update an interpolated property on an element with a lone bound value
     *
     * Used when the value passed to a property has 1 interpolated value in it, an no additional text
     * surrounds that interpolated value:
     *
     * ```html
     * <div title="{{v0}}"></div>
     * ```
     *
     * Its compiled representation is::
     *
     * ```ts
     * ɵɵpropertyInterpolate('title', v0);
     * ```
     *
     * If the property name also exists as an input property on one of the element's directives,
     * the component property will be set instead of the element property. This check must
     * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
     *
     * @param propName The name of the property to update
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param sanitizer An optional sanitizer function
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵpropertyInterpolate(propName, v0, sanitizer) {
        ɵɵpropertyInterpolate1(propName, '', v0, '', sanitizer);
        return ɵɵpropertyInterpolate;
    }
    /**
     *
     * Update an interpolated property on an element with single bound value surrounded by text.
     *
     * Used when the value passed to a property has 1 interpolated value in it:
     *
     * ```html
     * <div title="prefix{{v0}}suffix"></div>
     * ```
     *
     * Its compiled representation is::
     *
     * ```ts
     * ɵɵpropertyInterpolate1('title', 'prefix', v0, 'suffix');
     * ```
     *
     * If the property name also exists as an input property on one of the element's directives,
     * the component property will be set instead of the element property. This check must
     * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
     *
     * @param propName The name of the property to update
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param sanitizer An optional sanitizer function
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵpropertyInterpolate1(propName, prefix, v0, suffix, sanitizer) {
        var lView = getLView();
        var interpolatedValue = interpolation1(lView, prefix, v0, suffix);
        if (interpolatedValue !== NO_CHANGE) {
            var tView = getTView();
            var tNode = getSelectedTNode();
            elementPropertyInternal(tView, tNode, lView, propName, interpolatedValue, lView[RENDERER], sanitizer, false);
            ngDevMode &&
                storePropertyBindingMetadata(tView.data, tNode, propName, getBindingIndex() - 1, prefix, suffix);
        }
        return ɵɵpropertyInterpolate1;
    }
    /**
     *
     * Update an interpolated property on an element with 2 bound values surrounded by text.
     *
     * Used when the value passed to a property has 2 interpolated values in it:
     *
     * ```html
     * <div title="prefix{{v0}}-{{v1}}suffix"></div>
     * ```
     *
     * Its compiled representation is::
     *
     * ```ts
     * ɵɵpropertyInterpolate2('title', 'prefix', v0, '-', v1, 'suffix');
     * ```
     *
     * If the property name also exists as an input property on one of the element's directives,
     * the component property will be set instead of the element property. This check must
     * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
     *
     * @param propName The name of the property to update
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param sanitizer An optional sanitizer function
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵpropertyInterpolate2(propName, prefix, v0, i0, v1, suffix, sanitizer) {
        var lView = getLView();
        var interpolatedValue = interpolation2(lView, prefix, v0, i0, v1, suffix);
        if (interpolatedValue !== NO_CHANGE) {
            var tView = getTView();
            var tNode = getSelectedTNode();
            elementPropertyInternal(tView, tNode, lView, propName, interpolatedValue, lView[RENDERER], sanitizer, false);
            ngDevMode &&
                storePropertyBindingMetadata(tView.data, tNode, propName, getBindingIndex() - 2, prefix, i0, suffix);
        }
        return ɵɵpropertyInterpolate2;
    }
    /**
     *
     * Update an interpolated property on an element with 3 bound values surrounded by text.
     *
     * Used when the value passed to a property has 3 interpolated values in it:
     *
     * ```html
     * <div title="prefix{{v0}}-{{v1}}-{{v2}}suffix"></div>
     * ```
     *
     * Its compiled representation is::
     *
     * ```ts
     * ɵɵpropertyInterpolate3(
     * 'title', 'prefix', v0, '-', v1, '-', v2, 'suffix');
     * ```
     *
     * If the property name also exists as an input property on one of the element's directives,
     * the component property will be set instead of the element property. This check must
     * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
     *
     * @param propName The name of the property to update
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param sanitizer An optional sanitizer function
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵpropertyInterpolate3(propName, prefix, v0, i0, v1, i1, v2, suffix, sanitizer) {
        var lView = getLView();
        var interpolatedValue = interpolation3(lView, prefix, v0, i0, v1, i1, v2, suffix);
        if (interpolatedValue !== NO_CHANGE) {
            var tView = getTView();
            var tNode = getSelectedTNode();
            elementPropertyInternal(tView, tNode, lView, propName, interpolatedValue, lView[RENDERER], sanitizer, false);
            ngDevMode &&
                storePropertyBindingMetadata(tView.data, tNode, propName, getBindingIndex() - 3, prefix, i0, i1, suffix);
        }
        return ɵɵpropertyInterpolate3;
    }
    /**
     *
     * Update an interpolated property on an element with 4 bound values surrounded by text.
     *
     * Used when the value passed to a property has 4 interpolated values in it:
     *
     * ```html
     * <div title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}suffix"></div>
     * ```
     *
     * Its compiled representation is::
     *
     * ```ts
     * ɵɵpropertyInterpolate4(
     * 'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, 'suffix');
     * ```
     *
     * If the property name also exists as an input property on one of the element's directives,
     * the component property will be set instead of the element property. This check must
     * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
     *
     * @param propName The name of the property to update
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param sanitizer An optional sanitizer function
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵpropertyInterpolate4(propName, prefix, v0, i0, v1, i1, v2, i2, v3, suffix, sanitizer) {
        var lView = getLView();
        var interpolatedValue = interpolation4(lView, prefix, v0, i0, v1, i1, v2, i2, v3, suffix);
        if (interpolatedValue !== NO_CHANGE) {
            var tView = getTView();
            var tNode = getSelectedTNode();
            elementPropertyInternal(tView, tNode, lView, propName, interpolatedValue, lView[RENDERER], sanitizer, false);
            ngDevMode &&
                storePropertyBindingMetadata(tView.data, tNode, propName, getBindingIndex() - 4, prefix, i0, i1, i2, suffix);
        }
        return ɵɵpropertyInterpolate4;
    }
    /**
     *
     * Update an interpolated property on an element with 5 bound values surrounded by text.
     *
     * Used when the value passed to a property has 5 interpolated values in it:
     *
     * ```html
     * <div title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}suffix"></div>
     * ```
     *
     * Its compiled representation is::
     *
     * ```ts
     * ɵɵpropertyInterpolate5(
     * 'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, 'suffix');
     * ```
     *
     * If the property name also exists as an input property on one of the element's directives,
     * the component property will be set instead of the element property. This check must
     * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
     *
     * @param propName The name of the property to update
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param sanitizer An optional sanitizer function
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵpropertyInterpolate5(propName, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, suffix, sanitizer) {
        var lView = getLView();
        var interpolatedValue = interpolation5(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, suffix);
        if (interpolatedValue !== NO_CHANGE) {
            var tView = getTView();
            var tNode = getSelectedTNode();
            elementPropertyInternal(tView, tNode, lView, propName, interpolatedValue, lView[RENDERER], sanitizer, false);
            ngDevMode &&
                storePropertyBindingMetadata(tView.data, tNode, propName, getBindingIndex() - 5, prefix, i0, i1, i2, i3, suffix);
        }
        return ɵɵpropertyInterpolate5;
    }
    /**
     *
     * Update an interpolated property on an element with 6 bound values surrounded by text.
     *
     * Used when the value passed to a property has 6 interpolated values in it:
     *
     * ```html
     * <div title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}suffix"></div>
     * ```
     *
     * Its compiled representation is::
     *
     * ```ts
     * ɵɵpropertyInterpolate6(
     *    'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, 'suffix');
     * ```
     *
     * If the property name also exists as an input property on one of the element's directives,
     * the component property will be set instead of the element property. This check must
     * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
     *
     * @param propName The name of the property to update
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param i4 Static value used for concatenation only.
     * @param v5 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param sanitizer An optional sanitizer function
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵpropertyInterpolate6(propName, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, suffix, sanitizer) {
        var lView = getLView();
        var interpolatedValue = interpolation6(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, suffix);
        if (interpolatedValue !== NO_CHANGE) {
            var tView = getTView();
            var tNode = getSelectedTNode();
            elementPropertyInternal(tView, tNode, lView, propName, interpolatedValue, lView[RENDERER], sanitizer, false);
            ngDevMode &&
                storePropertyBindingMetadata(tView.data, tNode, propName, getBindingIndex() - 6, prefix, i0, i1, i2, i3, i4, suffix);
        }
        return ɵɵpropertyInterpolate6;
    }
    /**
     *
     * Update an interpolated property on an element with 7 bound values surrounded by text.
     *
     * Used when the value passed to a property has 7 interpolated values in it:
     *
     * ```html
     * <div title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}suffix"></div>
     * ```
     *
     * Its compiled representation is::
     *
     * ```ts
     * ɵɵpropertyInterpolate7(
     *    'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, 'suffix');
     * ```
     *
     * If the property name also exists as an input property on one of the element's directives,
     * the component property will be set instead of the element property. This check must
     * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
     *
     * @param propName The name of the property to update
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param i4 Static value used for concatenation only.
     * @param v5 Value checked for change.
     * @param i5 Static value used for concatenation only.
     * @param v6 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param sanitizer An optional sanitizer function
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵpropertyInterpolate7(propName, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, suffix, sanitizer) {
        var lView = getLView();
        var interpolatedValue = interpolation7(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, suffix);
        if (interpolatedValue !== NO_CHANGE) {
            var tView = getTView();
            var tNode = getSelectedTNode();
            elementPropertyInternal(tView, tNode, lView, propName, interpolatedValue, lView[RENDERER], sanitizer, false);
            ngDevMode &&
                storePropertyBindingMetadata(tView.data, tNode, propName, getBindingIndex() - 7, prefix, i0, i1, i2, i3, i4, i5, suffix);
        }
        return ɵɵpropertyInterpolate7;
    }
    /**
     *
     * Update an interpolated property on an element with 8 bound values surrounded by text.
     *
     * Used when the value passed to a property has 8 interpolated values in it:
     *
     * ```html
     * <div title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}-{{v7}}suffix"></div>
     * ```
     *
     * Its compiled representation is::
     *
     * ```ts
     * ɵɵpropertyInterpolate8(
     *  'title', 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, '-', v7, 'suffix');
     * ```
     *
     * If the property name also exists as an input property on one of the element's directives,
     * the component property will be set instead of the element property. This check must
     * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
     *
     * @param propName The name of the property to update
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param i4 Static value used for concatenation only.
     * @param v5 Value checked for change.
     * @param i5 Static value used for concatenation only.
     * @param v6 Value checked for change.
     * @param i6 Static value used for concatenation only.
     * @param v7 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param sanitizer An optional sanitizer function
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵpropertyInterpolate8(propName, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, i6, v7, suffix, sanitizer) {
        var lView = getLView();
        var interpolatedValue = interpolation8(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, i6, v7, suffix);
        if (interpolatedValue !== NO_CHANGE) {
            var tView = getTView();
            var tNode = getSelectedTNode();
            elementPropertyInternal(tView, tNode, lView, propName, interpolatedValue, lView[RENDERER], sanitizer, false);
            ngDevMode &&
                storePropertyBindingMetadata(tView.data, tNode, propName, getBindingIndex() - 8, prefix, i0, i1, i2, i3, i4, i5, i6, suffix);
        }
        return ɵɵpropertyInterpolate8;
    }
    /**
     * Update an interpolated property on an element with 9 or more bound values surrounded by text.
     *
     * Used when the number of interpolated values exceeds 8.
     *
     * ```html
     * <div
     *  title="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}-{{v7}}-{{v8}}-{{v9}}suffix"></div>
     * ```
     *
     * Its compiled representation is::
     *
     * ```ts
     * ɵɵpropertyInterpolateV(
     *  'title', ['prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, '-', v7, '-', v9,
     *  'suffix']);
     * ```
     *
     * If the property name also exists as an input property on one of the element's directives,
     * the component property will be set instead of the element property. This check must
     * be conducted at runtime so child components that add new `@Inputs` don't have to be re-compiled.
     *
     * @param propName The name of the property to update.
     * @param values The collection of values and the strings inbetween those values, beginning with a
     * string prefix and ending with a string suffix.
     * (e.g. `['prefix', value0, '-', value1, '-', value2, ..., value99, 'suffix']`)
     * @param sanitizer An optional sanitizer function
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵpropertyInterpolateV(propName, values, sanitizer) {
        var lView = getLView();
        var interpolatedValue = interpolationV(lView, values);
        if (interpolatedValue !== NO_CHANGE) {
            var tView = getTView();
            var tNode = getSelectedTNode();
            elementPropertyInternal(tView, tNode, lView, propName, interpolatedValue, lView[RENDERER], sanitizer, false);
            if (ngDevMode) {
                var interpolationInBetween = [values[0]]; // prefix
                for (var i = 2; i < values.length; i += 2) {
                    interpolationInBetween.push(values[i]);
                }
                storePropertyBindingMetadata.apply(void 0, __spread([tView.data, tNode, propName, getBindingIndex() - interpolationInBetween.length + 1], interpolationInBetween));
            }
        }
        return ɵɵpropertyInterpolateV;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * NOTE: The word `styling` is used interchangeably as style or class styling.
     *
     * This file contains code to link styling instructions together so that they can be replayed in
     * priority order. The file exists because Ivy styling instruction execution order does not match
     * that of the priority order. The purpose of this code is to create a linked list so that the
     * instructions can be traversed in priority order when computing the styles.
     *
     * Assume we are dealing with the following code:
     * ```
     * @Component({
     *   template: `
     *     <my-cmp [style]=" {color: '#001'} "
     *             [style.color]=" #002 "
     *             dir-style-color-1
     *             dir-style-color-2> `
     * })
     * class ExampleComponent {
     *   static ngComp = ... {
     *     ...
     *     // Compiler ensures that `ɵɵstyleProp` is after `ɵɵstyleMap`
     *     ɵɵstyleMap({color: '#001'});
     *     ɵɵstyleProp('color', '#002');
     *     ...
     *   }
     * }
     *
     * @Directive({
     *   selector: `[dir-style-color-1]',
     * })
     * class Style1Directive {
     *   @HostBinding('style') style = {color: '#005'};
     *   @HostBinding('style.color') color = '#006';
     *
     *   static ngDir = ... {
     *     ...
     *     // Compiler ensures that `ɵɵstyleProp` is after `ɵɵstyleMap`
     *     ɵɵstyleMap({color: '#005'});
     *     ɵɵstyleProp('color', '#006');
     *     ...
     *   }
     * }
     *
     * @Directive({
     *   selector: `[dir-style-color-2]',
     * })
     * class Style2Directive {
     *   @HostBinding('style') style = {color: '#007'};
     *   @HostBinding('style.color') color = '#008';
     *
     *   static ngDir = ... {
     *     ...
     *     // Compiler ensures that `ɵɵstyleProp` is after `ɵɵstyleMap`
     *     ɵɵstyleMap({color: '#007'});
     *     ɵɵstyleProp('color', '#008');
     *     ...
     *   }
     * }
     *
     * @Directive({
     *   selector: `my-cmp',
     * })
     * class MyComponent {
     *   @HostBinding('style') style = {color: '#003'};
     *   @HostBinding('style.color') color = '#004';
     *
     *   static ngComp = ... {
     *     ...
     *     // Compiler ensures that `ɵɵstyleProp` is after `ɵɵstyleMap`
     *     ɵɵstyleMap({color: '#003'});
     *     ɵɵstyleProp('color', '#004');
     *     ...
     *   }
     * }
     * ```
     *
     * The Order of instruction execution is:
     *
     * NOTE: the comment binding location is for illustrative purposes only.
     *
     * ```
     * // Template: (ExampleComponent)
     *     ɵɵstyleMap({color: '#001'});   // Binding index: 10
     *     ɵɵstyleProp('color', '#002');  // Binding index: 12
     * // MyComponent
     *     ɵɵstyleMap({color: '#003'});   // Binding index: 20
     *     ɵɵstyleProp('color', '#004');  // Binding index: 22
     * // Style1Directive
     *     ɵɵstyleMap({color: '#005'});   // Binding index: 24
     *     ɵɵstyleProp('color', '#006');  // Binding index: 26
     * // Style2Directive
     *     ɵɵstyleMap({color: '#007'});   // Binding index: 28
     *     ɵɵstyleProp('color', '#008');  // Binding index: 30
     * ```
     *
     * The correct priority order of concatenation is:
     *
     * ```
     * // MyComponent
     *     ɵɵstyleMap({color: '#003'});   // Binding index: 20
     *     ɵɵstyleProp('color', '#004');  // Binding index: 22
     * // Style1Directive
     *     ɵɵstyleMap({color: '#005'});   // Binding index: 24
     *     ɵɵstyleProp('color', '#006');  // Binding index: 26
     * // Style2Directive
     *     ɵɵstyleMap({color: '#007'});   // Binding index: 28
     *     ɵɵstyleProp('color', '#008');  // Binding index: 30
     * // Template: (ExampleComponent)
     *     ɵɵstyleMap({color: '#001'});   // Binding index: 10
     *     ɵɵstyleProp('color', '#002');  // Binding index: 12
     * ```
     *
     * What color should be rendered?
     *
     * Once the items are correctly sorted in the list, the answer is simply the last item in the
     * concatenation list which is `#002`.
     *
     * To do so we keep a linked list of all of the bindings which pertain to this element.
     * Notice that the bindings are inserted in the order of execution, but the `TView.data` allows
     * us to traverse them in the order of priority.
     *
     * |Idx|`TView.data`|`LView`          | Notes
     * |---|------------|-----------------|--------------
     * |...|            |                 |
     * |10 |`null`      |`{color: '#001'}`| `ɵɵstyleMap('color', {color: '#001'})`
     * |11 |`30 | 12`   | ...             |
     * |12 |`color`     |`'#002'`         | `ɵɵstyleProp('color', '#002')`
     * |13 |`10 | 0`    | ...             |
     * |...|            |                 |
     * |20 |`null`      |`{color: '#003'}`| `ɵɵstyleMap('color', {color: '#003'})`
     * |21 |`0 | 22`    | ...             |
     * |22 |`color`     |`'#004'`         | `ɵɵstyleProp('color', '#004')`
     * |23 |`20 | 24`   | ...             |
     * |24 |`null`      |`{color: '#005'}`| `ɵɵstyleMap('color', {color: '#005'})`
     * |25 |`22 | 26`   | ...             |
     * |26 |`color`     |`'#006'`         | `ɵɵstyleProp('color', '#006')`
     * |27 |`24 | 28`   | ...             |
     * |28 |`null`      |`{color: '#007'}`| `ɵɵstyleMap('color', {color: '#007'})`
     * |29 |`26 | 30`   | ...             |
     * |30 |`color`     |`'#008'`         | `ɵɵstyleProp('color', '#008')`
     * |31 |`28 | 10`   | ...             |
     *
     * The above data structure allows us to re-concatenate the styling no matter which data binding
     * changes.
     *
     * NOTE: in addition to keeping track of next/previous index the `TView.data` also stores prev/next
     * duplicate bit. The duplicate bit if true says there either is a binding with the same name or
     * there is a map (which may contain the name). This information is useful in knowing if other
     * styles with higher priority need to be searched for overwrites.
     *
     * NOTE: See `should support example in 'tnode_linked_list.ts' documentation` in
     * `tnode_linked_list_spec.ts` for working example.
     */
    var __unused_const_as_closure_does_not_like_standalone_comment_blocks__;
    /**
     * Insert new `tStyleValue` at `TData` and link existing style bindings such that we maintain linked
     * list of styles and compute the duplicate flag.
     *
     * Note: this function is executed during `firstUpdatePass` only to populate the `TView.data`.
     *
     * The function works by keeping track of `tStylingRange` which contains two pointers pointing to
     * the head/tail of the template portion of the styles.
     *  - if `isHost === false` (we are template) then insertion is at tail of `TStylingRange`
     *  - if `isHost === true` (we are host binding) then insertion is at head of `TStylingRange`
     *
     * @param tData The `TData` to insert into.
     * @param tNode `TNode` associated with the styling element.
     * @param tStylingKey See `TStylingKey`.
     * @param index location of where `tStyleValue` should be stored (and linked into list.)
     * @param isHostBinding `true` if the insertion is for a `hostBinding`. (insertion is in front of
     *               template.)
     * @param isClassBinding True if the associated `tStylingKey` as a `class` styling.
     *                       `tNode.classBindings` should be used (or `tNode.styleBindings` otherwise.)
     */
    function insertTStylingBinding(tData, tNode, tStylingKeyWithStatic, index, isHostBinding, isClassBinding) {
        ngDevMode && assertFirstUpdatePass(getTView());
        var tBindings = isClassBinding ? tNode.classBindings : tNode.styleBindings;
        var tmplHead = getTStylingRangePrev(tBindings);
        var tmplTail = getTStylingRangeNext(tBindings);
        tData[index] = tStylingKeyWithStatic;
        var isKeyDuplicateOfStatic = false;
        var tStylingKey;
        if (Array.isArray(tStylingKeyWithStatic)) {
            // We are case when the `TStylingKey` contains static fields as well.
            var staticKeyValueArray = tStylingKeyWithStatic;
            tStylingKey = staticKeyValueArray[1]; // unwrap.
            // We need to check if our key is present in the static so that we can mark it as duplicate.
            if (tStylingKey === null ||
                keyValueArrayIndexOf(staticKeyValueArray, tStylingKey) > 0) {
                // tStylingKey is present in the statics, need to mark it as duplicate.
                isKeyDuplicateOfStatic = true;
            }
        }
        else {
            tStylingKey = tStylingKeyWithStatic;
        }
        if (isHostBinding) {
            // We are inserting host bindings
            // If we don't have template bindings then `tail` is 0.
            var hasTemplateBindings = tmplTail !== 0;
            // This is important to know because that means that the `head` can't point to the first
            // template bindings (there are none.) Instead the head points to the tail of the template.
            if (hasTemplateBindings) {
                // template head's "prev" will point to last host binding or to 0 if no host bindings yet
                var previousNode = getTStylingRangePrev(tData[tmplHead + 1]);
                tData[index + 1] = toTStylingRange(previousNode, tmplHead);
                // if a host binding has already been registered, we need to update the next of that host
                // binding to point to this one
                if (previousNode !== 0) {
                    // We need to update the template-tail value to point to us.
                    tData[previousNode + 1] =
                        setTStylingRangeNext(tData[previousNode + 1], index);
                }
                // The "previous" of the template binding head should point to this host binding
                tData[tmplHead + 1] = setTStylingRangePrev(tData[tmplHead + 1], index);
            }
            else {
                tData[index + 1] = toTStylingRange(tmplHead, 0);
                // if a host binding has already been registered, we need to update the next of that host
                // binding to point to this one
                if (tmplHead !== 0) {
                    // We need to update the template-tail value to point to us.
                    tData[tmplHead + 1] = setTStylingRangeNext(tData[tmplHead + 1], index);
                }
                // if we don't have template, the head points to template-tail, and needs to be advanced.
                tmplHead = index;
            }
        }
        else {
            // We are inserting in template section.
            // We need to set this binding's "previous" to the current template tail
            tData[index + 1] = toTStylingRange(tmplTail, 0);
            ngDevMode &&
                assertEqual(tmplHead !== 0 && tmplTail === 0, false, 'Adding template bindings after hostBindings is not allowed.');
            if (tmplHead === 0) {
                tmplHead = index;
            }
            else {
                // We need to update the previous value "next" to point to this binding
                tData[tmplTail + 1] = setTStylingRangeNext(tData[tmplTail + 1], index);
            }
            tmplTail = index;
        }
        // Now we need to update / compute the duplicates.
        // Starting with our location search towards head (least priority)
        if (isKeyDuplicateOfStatic) {
            tData[index + 1] = setTStylingRangePrevDuplicate(tData[index + 1]);
        }
        markDuplicates(tData, tStylingKey, index, true, isClassBinding);
        markDuplicates(tData, tStylingKey, index, false, isClassBinding);
        markDuplicateOfResidualStyling(tNode, tStylingKey, tData, index, isClassBinding);
        tBindings = toTStylingRange(tmplHead, tmplTail);
        if (isClassBinding) {
            tNode.classBindings = tBindings;
        }
        else {
            tNode.styleBindings = tBindings;
        }
    }
    /**
     * Look into the residual styling to see if the current `tStylingKey` is duplicate of residual.
     *
     * @param tNode `TNode` where the residual is stored.
     * @param tStylingKey `TStylingKey` to store.
     * @param tData `TData` associated with the current `LView`.
     * @param index location of where `tStyleValue` should be stored (and linked into list.)
     * @param isClassBinding True if the associated `tStylingKey` as a `class` styling.
     *                       `tNode.classBindings` should be used (or `tNode.styleBindings` otherwise.)
     */
    function markDuplicateOfResidualStyling(tNode, tStylingKey, tData, index, isClassBinding) {
        var residual = isClassBinding ? tNode.residualClasses : tNode.residualStyles;
        if (residual != null /* or undefined */ && typeof tStylingKey == 'string' &&
            keyValueArrayIndexOf(residual, tStylingKey) >= 0) {
            // We have duplicate in the residual so mark ourselves as duplicate.
            tData[index + 1] = setTStylingRangeNextDuplicate(tData[index + 1]);
        }
    }
    /**
     * Marks `TStyleValue`s as duplicates if another style binding in the list has the same
     * `TStyleValue`.
     *
     * NOTE: this function is intended to be called twice once with `isPrevDir` set to `true` and once
     * with it set to `false` to search both the previous as well as next items in the list.
     *
     * No duplicate case
     * ```
     *   [style.color]
     *   [style.width.px] <<- index
     *   [style.height.px]
     * ```
     *
     * In the above case adding `[style.width.px]` to the existing `[style.color]` produces no
     * duplicates because `width` is not found in any other part of the linked list.
     *
     * Duplicate case
     * ```
     *   [style.color]
     *   [style.width.em]
     *   [style.width.px] <<- index
     * ```
     * In the above case adding `[style.width.px]` will produce a duplicate with `[style.width.em]`
     * because `width` is found in the chain.
     *
     * Map case 1
     * ```
     *   [style.width.px]
     *   [style.color]
     *   [style]  <<- index
     * ```
     * In the above case adding `[style]` will produce a duplicate with any other bindings because
     * `[style]` is a Map and as such is fully dynamic and could produce `color` or `width`.
     *
     * Map case 2
     * ```
     *   [style]
     *   [style.width.px]
     *   [style.color]  <<- index
     * ```
     * In the above case adding `[style.color]` will produce a duplicate because there is already a
     * `[style]` binding which is a Map and as such is fully dynamic and could produce `color` or
     * `width`.
     *
     * NOTE: Once `[style]` (Map) is added into the system all things are mapped as duplicates.
     * NOTE: We use `style` as example, but same logic is applied to `class`es as well.
     *
     * @param tData `TData` where the linked list is stored.
     * @param tStylingKey `TStylingKeyPrimitive` which contains the value to compare to other keys in
     *        the linked list.
     * @param index Starting location in the linked list to search from
     * @param isPrevDir Direction.
     *        - `true` for previous (lower priority);
     *        - `false` for next (higher priority).
     */
    function markDuplicates(tData, tStylingKey, index, isPrevDir, isClassBinding) {
        var tStylingAtIndex = tData[index + 1];
        var isMap = tStylingKey === null;
        var cursor = isPrevDir ? getTStylingRangePrev(tStylingAtIndex) : getTStylingRangeNext(tStylingAtIndex);
        var foundDuplicate = false;
        // We keep iterating as long as we have a cursor
        // AND either:
        // - we found what we are looking for, OR
        // - we are a map in which case we have to continue searching even after we find what we were
        //   looking for since we are a wild card and everything needs to be flipped to duplicate.
        while (cursor !== 0 && (foundDuplicate === false || isMap)) {
            ngDevMode && assertIndexInRange(tData, cursor);
            var tStylingValueAtCursor = tData[cursor];
            var tStyleRangeAtCursor = tData[cursor + 1];
            if (isStylingMatch(tStylingValueAtCursor, tStylingKey)) {
                foundDuplicate = true;
                tData[cursor + 1] = isPrevDir ? setTStylingRangeNextDuplicate(tStyleRangeAtCursor) :
                    setTStylingRangePrevDuplicate(tStyleRangeAtCursor);
            }
            cursor = isPrevDir ? getTStylingRangePrev(tStyleRangeAtCursor) :
                getTStylingRangeNext(tStyleRangeAtCursor);
        }
        if (foundDuplicate) {
            // if we found a duplicate, than mark ourselves.
            tData[index + 1] = isPrevDir ? setTStylingRangePrevDuplicate(tStylingAtIndex) :
                setTStylingRangeNextDuplicate(tStylingAtIndex);
        }
    }
    /**
     * Determines if two `TStylingKey`s are a match.
     *
     * When computing whether a binding contains a duplicate, we need to compare if the instruction
     * `TStylingKey` has a match.
     *
     * Here are examples of `TStylingKey`s which match given `tStylingKeyCursor` is:
     * - `color`
     *    - `color`    // Match another color
     *    - `null`     // That means that `tStylingKey` is a `classMap`/`styleMap` instruction
     *    - `['', 'color', 'other', true]` // wrapped `color` so match
     *    - `['', null, 'other', true]`       // wrapped `null` so match
     *    - `['', 'width', 'color', 'value']` // wrapped static value contains a match on `'color'`
     * - `null`       // `tStylingKeyCursor` always match as it is `classMap`/`styleMap` instruction
     *
     * @param tStylingKeyCursor
     * @param tStylingKey
     */
    function isStylingMatch(tStylingKeyCursor, tStylingKey) {
        ngDevMode &&
            assertNotEqual(Array.isArray(tStylingKey), true, 'Expected that \'tStylingKey\' has been unwrapped');
        if (tStylingKeyCursor === null || // If the cursor is `null` it means that we have map at that
            // location so we must assume that we have a match.
            tStylingKey == null || // If `tStylingKey` is `null` then it is a map therefor assume that it
            // contains a match.
            (Array.isArray(tStylingKeyCursor) ? tStylingKeyCursor[1] : tStylingKeyCursor) ===
                tStylingKey // If the keys match explicitly than we are a match.
        ) {
            return true;
        }
        else if (Array.isArray(tStylingKeyCursor) && typeof tStylingKey === 'string') {
            // if we did not find a match, but `tStylingKeyCursor` is `KeyValueArray` that means cursor has
            // statics and we need to check those as well.
            return keyValueArrayIndexOf(tStylingKeyCursor, tStylingKey) >=
                0; // see if we are matching the key
        }
        return false;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    // Global state of the parser. (This makes parser non-reentrant, but that is not an issue)
    var parserState = {
        textEnd: 0,
        key: 0,
        keyEnd: 0,
        value: 0,
        valueEnd: 0,
    };
    /**
     * Retrieves the last parsed `key` of style.
     * @param text the text to substring the key from.
     */
    function getLastParsedKey(text) {
        return text.substring(parserState.key, parserState.keyEnd);
    }
    /**
     * Retrieves the last parsed `value` of style.
     * @param text the text to substring the key from.
     */
    function getLastParsedValue(text) {
        return text.substring(parserState.value, parserState.valueEnd);
    }
    /**
     * Initializes `className` string for parsing and parses the first token.
     *
     * This function is intended to be used in this format:
     * ```
     * for (let i = parseClassName(text); i >= 0; i = parseClassNameNext(text, i)) {
     *   const key = getLastParsedKey();
     *   ...
     * }
     * ```
     * @param text `className` to parse
     * @returns index where the next invocation of `parseClassNameNext` should resume.
     */
    function parseClassName(text) {
        resetParserState(text);
        return parseClassNameNext(text, consumeWhitespace(text, 0, parserState.textEnd));
    }
    /**
     * Parses next `className` token.
     *
     * This function is intended to be used in this format:
     * ```
     * for (let i = parseClassName(text); i >= 0; i = parseClassNameNext(text, i)) {
     *   const key = getLastParsedKey();
     *   ...
     * }
     * ```
     *
     * @param text `className` to parse
     * @param index where the parsing should resume.
     * @returns index where the next invocation of `parseClassNameNext` should resume.
     */
    function parseClassNameNext(text, index) {
        var end = parserState.textEnd;
        if (end === index) {
            return -1;
        }
        index = parserState.keyEnd = consumeClassToken(text, parserState.key = index, end);
        return consumeWhitespace(text, index, end);
    }
    /**
     * Initializes `cssText` string for parsing and parses the first key/values.
     *
     * This function is intended to be used in this format:
     * ```
     * for (let i = parseStyle(text); i >= 0; i = parseStyleNext(text, i))) {
     *   const key = getLastParsedKey();
     *   const value = getLastParsedValue();
     *   ...
     * }
     * ```
     * @param text `cssText` to parse
     * @returns index where the next invocation of `parseStyleNext` should resume.
     */
    function parseStyle(text) {
        resetParserState(text);
        return parseStyleNext(text, consumeWhitespace(text, 0, parserState.textEnd));
    }
    /**
     * Parses the next `cssText` key/values.
     *
     * This function is intended to be used in this format:
     * ```
     * for (let i = parseStyle(text); i >= 0; i = parseStyleNext(text, i))) {
     *   const key = getLastParsedKey();
     *   const value = getLastParsedValue();
     *   ...
     * }
     *
     * @param text `cssText` to parse
     * @param index where the parsing should resume.
     * @returns index where the next invocation of `parseStyleNext` should resume.
     */
    function parseStyleNext(text, startIndex) {
        var end = parserState.textEnd;
        var index = parserState.key = consumeWhitespace(text, startIndex, end);
        if (end === index) {
            // we reached an end so just quit
            return -1;
        }
        index = parserState.keyEnd = consumeStyleKey(text, index, end);
        index = consumeSeparator(text, index, end, 58 /* COLON */);
        index = parserState.value = consumeWhitespace(text, index, end);
        index = parserState.valueEnd = consumeStyleValue(text, index, end);
        return consumeSeparator(text, index, end, 59 /* SEMI_COLON */);
    }
    /**
     * Reset the global state of the styling parser.
     * @param text The styling text to parse.
     */
    function resetParserState(text) {
        parserState.key = 0;
        parserState.keyEnd = 0;
        parserState.value = 0;
        parserState.valueEnd = 0;
        parserState.textEnd = text.length;
    }
    /**
     * Returns index of next non-whitespace character.
     *
     * @param text Text to scan
     * @param startIndex Starting index of character where the scan should start.
     * @param endIndex Ending index of character where the scan should end.
     * @returns Index of next non-whitespace character (May be the same as `start` if no whitespace at
     *          that location.)
     */
    function consumeWhitespace(text, startIndex, endIndex) {
        while (startIndex < endIndex && text.charCodeAt(startIndex) <= 32 /* SPACE */) {
            startIndex++;
        }
        return startIndex;
    }
    /**
     * Returns index of last char in class token.
     *
     * @param text Text to scan
     * @param startIndex Starting index of character where the scan should start.
     * @param endIndex Ending index of character where the scan should end.
     * @returns Index after last char in class token.
     */
    function consumeClassToken(text, startIndex, endIndex) {
        while (startIndex < endIndex && text.charCodeAt(startIndex) > 32 /* SPACE */) {
            startIndex++;
        }
        return startIndex;
    }
    /**
     * Consumes all of the characters belonging to style key and token.
     *
     * @param text Text to scan
     * @param startIndex Starting index of character where the scan should start.
     * @param endIndex Ending index of character where the scan should end.
     * @returns Index after last style key character.
     */
    function consumeStyleKey(text, startIndex, endIndex) {
        var ch;
        while (startIndex < endIndex &&
            ((ch = text.charCodeAt(startIndex)) === 45 /* DASH */ || ch === 95 /* UNDERSCORE */ ||
                ((ch & -33 /* UPPER_CASE */) >= 65 /* A */ && (ch & -33 /* UPPER_CASE */) <= 90 /* Z */) ||
                (ch >= 48 /* ZERO */ && ch <= 57 /* NINE */))) {
            startIndex++;
        }
        return startIndex;
    }
    /**
     * Consumes all whitespace and the separator `:` after the style key.
     *
     * @param text Text to scan
     * @param startIndex Starting index of character where the scan should start.
     * @param endIndex Ending index of character where the scan should end.
     * @returns Index after separator and surrounding whitespace.
     */
    function consumeSeparator(text, startIndex, endIndex, separator) {
        startIndex = consumeWhitespace(text, startIndex, endIndex);
        if (startIndex < endIndex) {
            if (ngDevMode && text.charCodeAt(startIndex) !== separator) {
                malformedStyleError(text, String.fromCharCode(separator), startIndex);
            }
            startIndex++;
        }
        return startIndex;
    }
    /**
     * Consumes style value honoring `url()` and `""` text.
     *
     * @param text Text to scan
     * @param startIndex Starting index of character where the scan should start.
     * @param endIndex Ending index of character where the scan should end.
     * @returns Index after last style value character.
     */
    function consumeStyleValue(text, startIndex, endIndex) {
        var ch1 = -1; // 1st previous character
        var ch2 = -1; // 2nd previous character
        var ch3 = -1; // 3rd previous character
        var i = startIndex;
        var lastChIndex = i;
        while (i < endIndex) {
            var ch = text.charCodeAt(i++);
            if (ch === 59 /* SEMI_COLON */) {
                return lastChIndex;
            }
            else if (ch === 34 /* DOUBLE_QUOTE */ || ch === 39 /* SINGLE_QUOTE */) {
                lastChIndex = i = consumeQuotedText(text, ch, i, endIndex);
            }
            else if (startIndex ===
                i - 4 && // We have seen only 4 characters so far "URL(" (Ignore "foo_URL()")
                ch3 === 85 /* U */ &&
                ch2 === 82 /* R */ && ch1 === 76 /* L */ && ch === 40 /* OPEN_PAREN */) {
                lastChIndex = i = consumeQuotedText(text, 41 /* CLOSE_PAREN */, i, endIndex);
            }
            else if (ch > 32 /* SPACE */) {
                // if we have a non-whitespace character then capture its location
                lastChIndex = i;
            }
            ch3 = ch2;
            ch2 = ch1;
            ch1 = ch & -33 /* UPPER_CASE */;
        }
        return lastChIndex;
    }
    /**
     * Consumes all of the quoted characters.
     *
     * @param text Text to scan
     * @param quoteCharCode CharCode of either `"` or `'` quote or `)` for `url(...)`.
     * @param startIndex Starting index of character where the scan should start.
     * @param endIndex Ending index of character where the scan should end.
     * @returns Index after quoted characters.
     */
    function consumeQuotedText(text, quoteCharCode, startIndex, endIndex) {
        var ch1 = -1; // 1st previous character
        var index = startIndex;
        while (index < endIndex) {
            var ch = text.charCodeAt(index++);
            if (ch == quoteCharCode && ch1 !== 92 /* BACK_SLASH */) {
                return index;
            }
            if (ch == 92 /* BACK_SLASH */ && ch1 === 92 /* BACK_SLASH */) {
                // two back slashes cancel each other out. For example `"\\"` should properly end the
                // quotation. (It should not assume that the last `"` is escaped.)
                ch1 = 0;
            }
            else {
                ch1 = ch;
            }
        }
        throw ngDevMode ? malformedStyleError(text, String.fromCharCode(quoteCharCode), endIndex) :
            new Error();
    }
    function malformedStyleError(text, expecting, index) {
        ngDevMode && assertEqual(typeof text === 'string', true, 'String expected here');
        throw throwError("Malformed style at location " + index + " in string '" + text.substring(0, index) + '[>>' +
            text.substring(index, index + 1) + '<<]' + text.substr(index + 1) +
            ("'. Expecting '" + expecting + "'."));
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Update a style binding on an element with the provided value.
     *
     * If the style value is falsy then it will be removed from the element
     * (or assigned a different value depending if there are any styles placed
     * on the element with `styleMap` or any static styles that are
     * present from when the element was created with `styling`).
     *
     * Note that the styling element is updated as part of `stylingApply`.
     *
     * @param prop A valid CSS property.
     * @param value New value to write (`null` or an empty string to remove).
     * @param suffix Optional suffix. Used with scalar values to add unit such as `px`.
     *
     * Note that this will apply the provided style value to the host element if this function is called
     * within a host binding function.
     *
     * @codeGenApi
     */
    function ɵɵstyleProp(prop, value, suffix) {
        checkStylingProperty(prop, value, suffix, false);
        return ɵɵstyleProp;
    }
    /**
     * Update a class binding on an element with the provided value.
     *
     * This instruction is meant to handle the `[class.foo]="exp"` case and,
     * therefore, the class binding itself must already be allocated using
     * `styling` within the creation block.
     *
     * @param prop A valid CSS class (only one).
     * @param value A true/false value which will turn the class on or off.
     *
     * Note that this will apply the provided class value to the host element if this function
     * is called within a host binding function.
     *
     * @codeGenApi
     */
    function ɵɵclassProp(className, value) {
        checkStylingProperty(className, value, null, true);
        return ɵɵclassProp;
    }
    /**
     * Update style bindings using an object literal on an element.
     *
     * This instruction is meant to apply styling via the `[style]="exp"` template bindings.
     * When styles are applied to the element they will then be updated with respect to
     * any styles/classes set via `styleProp`. If any styles are set to falsy
     * then they will be removed from the element.
     *
     * Note that the styling instruction will not be applied until `stylingApply` is called.
     *
     * @param styles A key/value style map of the styles that will be applied to the given element.
     *        Any missing styles (that have already been applied to the element beforehand) will be
     *        removed (unset) from the element's styling.
     *
     * Note that this will apply the provided styleMap value to the host element if this function
     * is called within a host binding.
     *
     * @codeGenApi
     */
    function ɵɵstyleMap(styles) {
        checkStylingMap(styleKeyValueArraySet, styleStringParser, styles, false);
    }
    /**
     * Parse text as style and add values to KeyValueArray.
     *
     * This code is pulled out to a separate function so that it can be tree shaken away if it is not
     * needed. It is only referenced from `ɵɵstyleMap`.
     *
     * @param keyValueArray KeyValueArray to add parsed values to.
     * @param text text to parse.
     */
    function styleStringParser(keyValueArray, text) {
        for (var i = parseStyle(text); i >= 0; i = parseStyleNext(text, i)) {
            styleKeyValueArraySet(keyValueArray, getLastParsedKey(text), getLastParsedValue(text));
        }
    }
    /**
     * Update class bindings using an object literal or class-string on an element.
     *
     * This instruction is meant to apply styling via the `[class]="exp"` template bindings.
     * When classes are applied to the element they will then be updated with
     * respect to any styles/classes set via `classProp`. If any
     * classes are set to falsy then they will be removed from the element.
     *
     * Note that the styling instruction will not be applied until `stylingApply` is called.
     * Note that this will the provided classMap value to the host element if this function is called
     * within a host binding.
     *
     * @param classes A key/value map or string of CSS classes that will be added to the
     *        given element. Any missing classes (that have already been applied to the element
     *        beforehand) will be removed (unset) from the element's list of CSS classes.
     *
     * @codeGenApi
     */
    function ɵɵclassMap(classes) {
        checkStylingMap(keyValueArraySet, classStringParser, classes, true);
    }
    /**
     * Parse text as class and add values to KeyValueArray.
     *
     * This code is pulled out to a separate function so that it can be tree shaken away if it is not
     * needed. It is only referenced from `ɵɵclassMap`.
     *
     * @param keyValueArray KeyValueArray to add parsed values to.
     * @param text text to parse.
     */
    function classStringParser(keyValueArray, text) {
        for (var i = parseClassName(text); i >= 0; i = parseClassNameNext(text, i)) {
            keyValueArraySet(keyValueArray, getLastParsedKey(text), true);
        }
    }
    /**
     * Common code between `ɵɵclassProp` and `ɵɵstyleProp`.
     *
     * @param prop property name.
     * @param value binding value.
     * @param suffix suffix for the property (e.g. `em` or `px`)
     * @param isClassBased `true` if `class` change (`false` if `style`)
     */
    function checkStylingProperty(prop, value, suffix, isClassBased) {
        var lView = getLView();
        var tView = getTView();
        // Styling instructions use 2 slots per binding.
        // 1. one for the value / TStylingKey
        // 2. one for the intermittent-value / TStylingRange
        var bindingIndex = incrementBindingIndex(2);
        if (tView.firstUpdatePass) {
            stylingFirstUpdatePass(tView, prop, bindingIndex, isClassBased);
        }
        if (value !== NO_CHANGE && bindingUpdated(lView, bindingIndex, value)) {
            var tNode = tView.data[getSelectedIndex()];
            updateStyling(tView, tNode, lView, lView[RENDERER], prop, lView[bindingIndex + 1] = normalizeSuffix(value, suffix), isClassBased, bindingIndex);
        }
    }
    /**
     * Common code between `ɵɵclassMap` and `ɵɵstyleMap`.
     *
     * @param keyValueArraySet (See `keyValueArraySet` in "util/array_utils") Gets passed in as a
     *        function so that `style` can be processed. This is done for tree shaking purposes.
     * @param stringParser Parser used to parse `value` if `string`. (Passed in as `style` and `class`
     *        have different parsers.)
     * @param value bound value from application
     * @param isClassBased `true` if `class` change (`false` if `style`)
     */
    function checkStylingMap(keyValueArraySet, stringParser, value, isClassBased) {
        var tView = getTView();
        var bindingIndex = incrementBindingIndex(2);
        if (tView.firstUpdatePass) {
            stylingFirstUpdatePass(tView, null, bindingIndex, isClassBased);
        }
        var lView = getLView();
        if (value !== NO_CHANGE && bindingUpdated(lView, bindingIndex, value)) {
            // `getSelectedIndex()` should be here (rather than in instruction) so that it is guarded by the
            // if so as not to read unnecessarily.
            var tNode = tView.data[getSelectedIndex()];
            if (hasStylingInputShadow(tNode, isClassBased) && !isInHostBindings(tView, bindingIndex)) {
                if (ngDevMode) {
                    // verify that if we are shadowing then `TData` is appropriately marked so that we skip
                    // processing this binding in styling resolution.
                    var tStylingKey = tView.data[bindingIndex];
                    assertEqual(Array.isArray(tStylingKey) ? tStylingKey[1] : tStylingKey, false, 'Styling linked list shadow input should be marked as \'false\'');
                }
                // VE does not concatenate the static portion like we are doing here.
                // Instead VE just ignores the static completely if dynamic binding is present.
                // Because of locality we have already set the static portion because we don't know if there
                // is a dynamic portion until later. If we would ignore the static portion it would look like
                // the binding has removed it. This would confuse `[ngStyle]`/`[ngClass]` to do the wrong
                // thing as it would think that the static portion was removed. For this reason we
                // concatenate it so that `[ngStyle]`/`[ngClass]`  can continue to work on changed.
                var staticPrefix = isClassBased ? tNode.classesWithoutHost : tNode.stylesWithoutHost;
                ngDevMode && isClassBased === false && staticPrefix !== null &&
                    assertEqual(staticPrefix.endsWith(';'), true, 'Expecting static portion to end with \';\'');
                if (staticPrefix !== null) {
                    // We want to make sure that falsy values of `value` become empty strings.
                    value = concatStringsWithSpace(staticPrefix, value ? value : '');
                }
                // Given `<div [style] my-dir>` such that `my-dir` has `@Input('style')`.
                // This takes over the `[style]` binding. (Same for `[class]`)
                setDirectiveInputsWhichShadowsStyling(tView, tNode, lView, value, isClassBased);
            }
            else {
                updateStylingMap(tView, tNode, lView, lView[RENDERER], lView[bindingIndex + 1], lView[bindingIndex + 1] = toStylingKeyValueArray(keyValueArraySet, stringParser, value), isClassBased, bindingIndex);
            }
        }
    }
    /**
     * Determines when the binding is in `hostBindings` section
     *
     * @param tView Current `TView`
     * @param bindingIndex index of binding which we would like if it is in `hostBindings`
     */
    function isInHostBindings(tView, bindingIndex) {
        // All host bindings are placed after the expando section.
        return bindingIndex >= tView.expandoStartIndex;
    }
    /**
     * Collects the necessary information to insert the binding into a linked list of style bindings
     * using `insertTStylingBinding`.
     *
     * @param tView `TView` where the binding linked list will be stored.
     * @param tStylingKey Property/key of the binding.
     * @param bindingIndex Index of binding associated with the `prop`
     * @param isClassBased `true` if `class` change (`false` if `style`)
     */
    function stylingFirstUpdatePass(tView, tStylingKey, bindingIndex, isClassBased) {
        ngDevMode && assertFirstUpdatePass(tView);
        var tData = tView.data;
        if (tData[bindingIndex + 1] === null) {
            // The above check is necessary because we don't clear first update pass until first successful
            // (no exception) template execution. This prevents the styling instruction from double adding
            // itself to the list.
            // `getSelectedIndex()` should be here (rather than in instruction) so that it is guarded by the
            // if so as not to read unnecessarily.
            var tNode = tData[getSelectedIndex()];
            ngDevMode && assertDefined(tNode, 'TNode expected');
            var isHostBindings = isInHostBindings(tView, bindingIndex);
            if (hasStylingInputShadow(tNode, isClassBased) && tStylingKey === null && !isHostBindings) {
                // `tStylingKey === null` implies that we are either `[style]` or `[class]` binding.
                // If there is a directive which uses `@Input('style')` or `@Input('class')` than
                // we need to neutralize this binding since that directive is shadowing it.
                // We turn this into a noop by setting the key to `false`
                tStylingKey = false;
            }
            tStylingKey = wrapInStaticStylingKey(tData, tNode, tStylingKey, isClassBased);
            insertTStylingBinding(tData, tNode, tStylingKey, bindingIndex, isHostBindings, isClassBased);
        }
    }
    /**
     * Adds static styling information to the binding if applicable.
     *
     * The linked list of styles not only stores the list and keys, but also stores static styling
     * information on some of the keys. This function determines if the key should contain the styling
     * information and computes it.
     *
     * See `TStylingStatic` for more details.
     *
     * @param tData `TData` where the linked list is stored.
     * @param tNode `TNode` for which the styling is being computed.
     * @param stylingKey `TStylingKeyPrimitive` which may need to be wrapped into `TStylingKey`
     * @param isClassBased `true` if `class` (`false` if `style`)
     */
    function wrapInStaticStylingKey(tData, tNode, stylingKey, isClassBased) {
        var hostDirectiveDef = getCurrentDirectiveDef(tData);
        var residual = isClassBased ? tNode.residualClasses : tNode.residualStyles;
        if (hostDirectiveDef === null) {
            // We are in template node.
            // If template node already had styling instruction then it has already collected the static
            // styling and there is no need to collect them again. We know that we are the first styling
            // instruction because the `TNode.*Bindings` points to 0 (nothing has been inserted yet).
            var isFirstStylingInstructionInTemplate = (isClassBased ? tNode.classBindings : tNode.styleBindings) === 0;
            if (isFirstStylingInstructionInTemplate) {
                // It would be nice to be able to get the statics from `mergeAttrs`, however, at this point
                // they are already merged and it would not be possible to figure which property belongs where
                // in the priority.
                stylingKey = collectStylingFromDirectives(null, tData, tNode, stylingKey, isClassBased);
                stylingKey = collectStylingFromTAttrs(stylingKey, tNode.attrs, isClassBased);
                // We know that if we have styling binding in template we can't have residual.
                residual = null;
            }
        }
        else {
            // We are in host binding node and there was no binding instruction in template node.
            // This means that we need to compute the residual.
            var directiveStylingLast = tNode.directiveStylingLast;
            var isFirstStylingInstructionInHostBinding = directiveStylingLast === -1 || tData[directiveStylingLast] !== hostDirectiveDef;
            if (isFirstStylingInstructionInHostBinding) {
                stylingKey =
                    collectStylingFromDirectives(hostDirectiveDef, tData, tNode, stylingKey, isClassBased);
                if (residual === null) {
                    // - If `null` than either:
                    //    - Template styling instruction already ran and it has consumed the static
                    //      styling into its `TStylingKey` and so there is no need to update residual. Instead
                    //      we need to update the `TStylingKey` associated with the first template node
                    //      instruction. OR
                    //    - Some other styling instruction ran and determined that there are no residuals
                    var templateStylingKey = getTemplateHeadTStylingKey(tData, tNode, isClassBased);
                    if (templateStylingKey !== undefined && Array.isArray(templateStylingKey)) {
                        // Only recompute if `templateStylingKey` had static values. (If no static value found
                        // then there is nothing to do since this operation can only produce less static keys, not
                        // more.)
                        templateStylingKey = collectStylingFromDirectives(null, tData, tNode, templateStylingKey[1] /* unwrap previous statics */, isClassBased);
                        templateStylingKey =
                            collectStylingFromTAttrs(templateStylingKey, tNode.attrs, isClassBased);
                        setTemplateHeadTStylingKey(tData, tNode, isClassBased, templateStylingKey);
                    }
                }
                else {
                    // We only need to recompute residual if it is not `null`.
                    // - If existing residual (implies there was no template styling). This means that some of
                    //   the statics may have moved from the residual to the `stylingKey` and so we have to
                    //   recompute.
                    // - If `undefined` this is the first time we are running.
                    residual = collectResidual(tData, tNode, isClassBased);
                }
            }
        }
        if (residual !== undefined) {
            isClassBased ? (tNode.residualClasses = residual) : (tNode.residualStyles = residual);
        }
        return stylingKey;
    }
    /**
     * Retrieve the `TStylingKey` for the template styling instruction.
     *
     * This is needed since `hostBinding` styling instructions are inserted after the template
     * instruction. While the template instruction needs to update the residual in `TNode` the
     * `hostBinding` instructions need to update the `TStylingKey` of the template instruction because
     * the template instruction is downstream from the `hostBindings` instructions.
     *
     * @param tData `TData` where the linked list is stored.
     * @param tNode `TNode` for which the styling is being computed.
     * @param isClassBased `true` if `class` (`false` if `style`)
     * @return `TStylingKey` if found or `undefined` if not found.
     */
    function getTemplateHeadTStylingKey(tData, tNode, isClassBased) {
        var bindings = isClassBased ? tNode.classBindings : tNode.styleBindings;
        if (getTStylingRangeNext(bindings) === 0) {
            // There does not seem to be a styling instruction in the `template`.
            return undefined;
        }
        return tData[getTStylingRangePrev(bindings)];
    }
    /**
     * Update the `TStylingKey` of the first template instruction in `TNode`.
     *
     * Logically `hostBindings` styling instructions are of lower priority than that of the template.
     * However, they execute after the template styling instructions. This means that they get inserted
     * in front of the template styling instructions.
     *
     * If we have a template styling instruction and a new `hostBindings` styling instruction is
     * executed it means that it may need to steal static fields from the template instruction. This
     * method allows us to update the first template instruction `TStylingKey` with a new value.
     *
     * Assume:
     * ```
     * <div my-dir style="color: red" [style.color]="tmplExp"></div>
     *
     * @Directive({
     *   host: {
     *     'style': 'width: 100px',
     *     '[style.color]': 'dirExp',
     *   }
     * })
     * class MyDir {}
     * ```
     *
     * when `[style.color]="tmplExp"` executes it creates this data structure.
     * ```
     *  ['', 'color', 'color', 'red', 'width', '100px'],
     * ```
     *
     * The reason for this is that the template instruction does not know if there are styling
     * instructions and must assume that there are none and must collect all of the static styling.
     * (both
     * `color' and 'width`)
     *
     * When `'[style.color]': 'dirExp',` executes we need to insert a new data into the linked list.
     * ```
     *  ['', 'color', 'width', '100px'],  // newly inserted
     *  ['', 'color', 'color', 'red', 'width', '100px'], // this is wrong
     * ```
     *
     * Notice that the template statics is now wrong as it incorrectly contains `width` so we need to
     * update it like so:
     * ```
     *  ['', 'color', 'width', '100px'],
     *  ['', 'color', 'color', 'red'],    // UPDATE
     * ```
     *
     * @param tData `TData` where the linked list is stored.
     * @param tNode `TNode` for which the styling is being computed.
     * @param isClassBased `true` if `class` (`false` if `style`)
     * @param tStylingKey New `TStylingKey` which is replacing the old one.
     */
    function setTemplateHeadTStylingKey(tData, tNode, isClassBased, tStylingKey) {
        var bindings = isClassBased ? tNode.classBindings : tNode.styleBindings;
        ngDevMode &&
            assertNotEqual(getTStylingRangeNext(bindings), 0, 'Expecting to have at least one template styling binding.');
        tData[getTStylingRangePrev(bindings)] = tStylingKey;
    }
    /**
     * Collect all static values after the current `TNode.directiveStylingLast` index.
     *
     * Collect the remaining styling information which has not yet been collected by an existing
     * styling instruction.
     *
     * @param tData `TData` where the `DirectiveDefs` are stored.
     * @param tNode `TNode` which contains the directive range.
     * @param isClassBased `true` if `class` (`false` if `style`)
     */
    function collectResidual(tData, tNode, isClassBased) {
        var residual = undefined;
        var directiveEnd = tNode.directiveEnd;
        ngDevMode &&
            assertNotEqual(tNode.directiveStylingLast, -1, 'By the time this function gets called at least one hostBindings-node styling instruction must have executed.');
        // We add `1 + tNode.directiveStart` because we need to skip the current directive (as we are
        // collecting things after the last `hostBindings` directive which had a styling instruction.)
        for (var i = 1 + tNode.directiveStylingLast; i < directiveEnd; i++) {
            var attrs = tData[i].hostAttrs;
            residual = collectStylingFromTAttrs(residual, attrs, isClassBased);
        }
        return collectStylingFromTAttrs(residual, tNode.attrs, isClassBased);
    }
    /**
     * Collect the static styling information with lower priority than `hostDirectiveDef`.
     *
     * (This is opposite of residual styling.)
     *
     * @param hostDirectiveDef `DirectiveDef` for which we want to collect lower priority static
     *        styling. (Or `null` if template styling)
     * @param tData `TData` where the linked list is stored.
     * @param tNode `TNode` for which the styling is being computed.
     * @param stylingKey Existing `TStylingKey` to update or wrap.
     * @param isClassBased `true` if `class` (`false` if `style`)
     */
    function collectStylingFromDirectives(hostDirectiveDef, tData, tNode, stylingKey, isClassBased) {
        // We need to loop because there can be directives which have `hostAttrs` but don't have
        // `hostBindings` so this loop catches up to the current directive..
        var currentDirective = null;
        var directiveEnd = tNode.directiveEnd;
        var directiveStylingLast = tNode.directiveStylingLast;
        if (directiveStylingLast === -1) {
            directiveStylingLast = tNode.directiveStart;
        }
        else {
            directiveStylingLast++;
        }
        while (directiveStylingLast < directiveEnd) {
            currentDirective = tData[directiveStylingLast];
            ngDevMode && assertDefined(currentDirective, 'expected to be defined');
            stylingKey = collectStylingFromTAttrs(stylingKey, currentDirective.hostAttrs, isClassBased);
            if (currentDirective === hostDirectiveDef)
                break;
            directiveStylingLast++;
        }
        if (hostDirectiveDef !== null) {
            // we only advance the styling cursor if we are collecting data from host bindings.
            // Template executes before host bindings and so if we would update the index,
            // host bindings would not get their statics.
            tNode.directiveStylingLast = directiveStylingLast;
        }
        return stylingKey;
    }
    /**
     * Convert `TAttrs` into `TStylingStatic`.
     *
     * @param stylingKey existing `TStylingKey` to update or wrap.
     * @param attrs `TAttributes` to process.
     * @param isClassBased `true` if `class` (`false` if `style`)
     */
    function collectStylingFromTAttrs(stylingKey, attrs, isClassBased) {
        var desiredMarker = isClassBased ? 1 /* Classes */ : 2 /* Styles */;
        var currentMarker = -1 /* ImplicitAttributes */;
        if (attrs !== null) {
            for (var i = 0; i < attrs.length; i++) {
                var item = attrs[i];
                if (typeof item === 'number') {
                    currentMarker = item;
                }
                else {
                    if (currentMarker === desiredMarker) {
                        if (!Array.isArray(stylingKey)) {
                            stylingKey = stylingKey === undefined ? [] : ['', stylingKey];
                        }
                        keyValueArraySet(stylingKey, item, isClassBased ? true : attrs[++i]);
                    }
                }
            }
        }
        return stylingKey === undefined ? null : stylingKey;
    }
    /**
     * Convert user input to `KeyValueArray`.
     *
     * This function takes user input which could be `string`, Object literal, or iterable and converts
     * it into a consistent representation. The output of this is `KeyValueArray` (which is an array
     * where
     * even indexes contain keys and odd indexes contain values for those keys).
     *
     * The advantage of converting to `KeyValueArray` is that we can perform diff in an input
     * independent
     * way.
     * (ie we can compare `foo bar` to `['bar', 'baz'] and determine a set of changes which need to be
     * applied)
     *
     * The fact that `KeyValueArray` is sorted is very important because it allows us to compute the
     * difference in linear fashion without the need to allocate any additional data.
     *
     * For example if we kept this as a `Map` we would have to iterate over previous `Map` to determine
     * which values need to be deleted, over the new `Map` to determine additions, and we would have to
     * keep additional `Map` to keep track of duplicates or items which have not yet been visited.
     *
     * @param keyValueArraySet (See `keyValueArraySet` in "util/array_utils") Gets passed in as a
     *        function so that `style` can be processed. This is done
     *        for tree shaking purposes.
     * @param stringParser The parser is passed in so that it will be tree shakable. See
     *        `styleStringParser` and `classStringParser`
     * @param value The value to parse/convert to `KeyValueArray`
     */
    function toStylingKeyValueArray(keyValueArraySet, stringParser, value) {
        if (value == null /*|| value === undefined */ || value === '')
            return EMPTY_ARRAY;
        var styleKeyValueArray = [];
        var unwrappedValue = unwrapSafeValue(value);
        if (Array.isArray(unwrappedValue)) {
            for (var i = 0; i < unwrappedValue.length; i++) {
                keyValueArraySet(styleKeyValueArray, unwrappedValue[i], true);
            }
        }
        else if (typeof unwrappedValue === 'object') {
            for (var key in unwrappedValue) {
                if (unwrappedValue.hasOwnProperty(key)) {
                    keyValueArraySet(styleKeyValueArray, key, unwrappedValue[key]);
                }
            }
        }
        else if (typeof unwrappedValue === 'string') {
            stringParser(styleKeyValueArray, unwrappedValue);
        }
        else {
            ngDevMode &&
                throwError('Unsupported styling type ' + typeof unwrappedValue + ': ' + unwrappedValue);
        }
        return styleKeyValueArray;
    }
    /**
     * Set a `value` for a `key`.
     *
     * See: `keyValueArraySet` for details
     *
     * @param keyValueArray KeyValueArray to add to.
     * @param key Style key to add.
     * @param value The value to set.
     */
    function styleKeyValueArraySet(keyValueArray, key, value) {
        keyValueArraySet(keyValueArray, key, unwrapSafeValue(value));
    }
    /**
     * Update map based styling.
     *
     * Map based styling could be anything which contains more than one binding. For example `string`,
     * or object literal. Dealing with all of these types would complicate the logic so
     * instead this function expects that the complex input is first converted into normalized
     * `KeyValueArray`. The advantage of normalization is that we get the values sorted, which makes it
     * very cheap to compute deltas between the previous and current value.
     *
     * @param tView Associated `TView.data` contains the linked list of binding priorities.
     * @param tNode `TNode` where the binding is located.
     * @param lView `LView` contains the values associated with other styling binding at this `TNode`.
     * @param renderer Renderer to use if any updates.
     * @param oldKeyValueArray Previous value represented as `KeyValueArray`
     * @param newKeyValueArray Current value represented as `KeyValueArray`
     * @param isClassBased `true` if `class` (`false` if `style`)
     * @param bindingIndex Binding index of the binding.
     */
    function updateStylingMap(tView, tNode, lView, renderer, oldKeyValueArray, newKeyValueArray, isClassBased, bindingIndex) {
        if (oldKeyValueArray === NO_CHANGE) {
            // On first execution the oldKeyValueArray is NO_CHANGE => treat it as empty KeyValueArray.
            oldKeyValueArray = EMPTY_ARRAY;
        }
        var oldIndex = 0;
        var newIndex = 0;
        var oldKey = 0 < oldKeyValueArray.length ? oldKeyValueArray[0] : null;
        var newKey = 0 < newKeyValueArray.length ? newKeyValueArray[0] : null;
        while (oldKey !== null || newKey !== null) {
            ngDevMode && assertLessThan(oldIndex, 999, 'Are we stuck in infinite loop?');
            ngDevMode && assertLessThan(newIndex, 999, 'Are we stuck in infinite loop?');
            var oldValue = oldIndex < oldKeyValueArray.length ? oldKeyValueArray[oldIndex + 1] : undefined;
            var newValue = newIndex < newKeyValueArray.length ? newKeyValueArray[newIndex + 1] : undefined;
            var setKey = null;
            var setValue = undefined;
            if (oldKey === newKey) {
                // UPDATE: Keys are equal => new value is overwriting old value.
                oldIndex += 2;
                newIndex += 2;
                if (oldValue !== newValue) {
                    setKey = newKey;
                    setValue = newValue;
                }
            }
            else if (newKey === null || oldKey !== null && oldKey < newKey) {
                // DELETE: oldKey key is missing or we did not find the oldKey in the newValue
                // (because the keyValueArray is sorted and `newKey` is found later alphabetically).
                // `"background" < "color"` so we need to delete `"background"` because it is not found in the
                // new array.
                oldIndex += 2;
                setKey = oldKey;
            }
            else {
                // CREATE: newKey's is earlier alphabetically than oldKey's (or no oldKey) => we have new key.
                // `"color" > "background"` so we need to add `color` because it is in new array but not in
                // old array.
                ngDevMode && assertDefined(newKey, 'Expecting to have a valid key');
                newIndex += 2;
                setKey = newKey;
                setValue = newValue;
            }
            if (setKey !== null) {
                updateStyling(tView, tNode, lView, renderer, setKey, setValue, isClassBased, bindingIndex);
            }
            oldKey = oldIndex < oldKeyValueArray.length ? oldKeyValueArray[oldIndex] : null;
            newKey = newIndex < newKeyValueArray.length ? newKeyValueArray[newIndex] : null;
        }
    }
    /**
     * Update a simple (property name) styling.
     *
     * This function takes `prop` and updates the DOM to that value. The function takes the binding
     * value as well as binding priority into consideration to determine which value should be written
     * to DOM. (For example it may be determined that there is a higher priority overwrite which blocks
     * the DOM write, or if the value goes to `undefined` a lower priority overwrite may be consulted.)
     *
     * @param tView Associated `TView.data` contains the linked list of binding priorities.
     * @param tNode `TNode` where the binding is located.
     * @param lView `LView` contains the values associated with other styling binding at this `TNode`.
     * @param renderer Renderer to use if any updates.
     * @param prop Either style property name or a class name.
     * @param value Either style value for `prop` or `true`/`false` if `prop` is class.
     * @param isClassBased `true` if `class` (`false` if `style`)
     * @param bindingIndex Binding index of the binding.
     */
    function updateStyling(tView, tNode, lView, renderer, prop, value, isClassBased, bindingIndex) {
        if (!(tNode.type & 3 /* AnyRNode */)) {
            // It is possible to have styling on non-elements (such as ng-container).
            // This is rare, but it does happen. In such a case, just ignore the binding.
            return;
        }
        var tData = tView.data;
        var tRange = tData[bindingIndex + 1];
        var higherPriorityValue = getTStylingRangeNextDuplicate(tRange) ?
            findStylingValue(tData, tNode, lView, prop, getTStylingRangeNext(tRange), isClassBased) :
            undefined;
        if (!isStylingValuePresent(higherPriorityValue)) {
            // We don't have a next duplicate, or we did not find a duplicate value.
            if (!isStylingValuePresent(value)) {
                // We should delete current value or restore to lower priority value.
                if (getTStylingRangePrevDuplicate(tRange)) {
                    // We have a possible prev duplicate, let's retrieve it.
                    value = findStylingValue(tData, null, lView, prop, bindingIndex, isClassBased);
                }
            }
            var rNode = getNativeByIndex(getSelectedIndex(), lView);
            applyStyling(renderer, isClassBased, rNode, prop, value);
        }
    }
    /**
     * Search for styling value with higher priority which is overwriting current value, or a
     * value of lower priority to which we should fall back if the value is `undefined`.
     *
     * When value is being applied at a location, related values need to be consulted.
     * - If there is a higher priority binding, we should be using that one instead.
     *   For example `<div  [style]="{color:exp1}" [style.color]="exp2">` change to `exp1`
     *   requires that we check `exp2` to see if it is set to value other than `undefined`.
     * - If there is a lower priority binding and we are changing to `undefined`
     *   For example `<div  [style]="{color:exp1}" [style.color]="exp2">` change to `exp2` to
     *   `undefined` requires that we check `exp1` (and static values) and use that as new value.
     *
     * NOTE: The styling stores two values.
     * 1. The raw value which came from the application is stored at `index + 0` location. (This value
     *    is used for dirty checking).
     * 2. The normalized value is stored at `index + 1`.
     *
     * @param tData `TData` used for traversing the priority.
     * @param tNode `TNode` to use for resolving static styling. Also controls search direction.
     *   - `TNode` search next and quit as soon as `isStylingValuePresent(value)` is true.
     *      If no value found consult `tNode.residualStyle`/`tNode.residualClass` for default value.
     *   - `null` search prev and go all the way to end. Return last value where
     *     `isStylingValuePresent(value)` is true.
     * @param lView `LView` used for retrieving the actual values.
     * @param prop Property which we are interested in.
     * @param index Starting index in the linked list of styling bindings where the search should start.
     * @param isClassBased `true` if `class` (`false` if `style`)
     */
    function findStylingValue(tData, tNode, lView, prop, index, isClassBased) {
        // `TNode` to use for resolving static styling. Also controls search direction.
        //   - `TNode` search next and quit as soon as `isStylingValuePresent(value)` is true.
        //      If no value found consult `tNode.residualStyle`/`tNode.residualClass` for default value.
        //   - `null` search prev and go all the way to end. Return last value where
        //     `isStylingValuePresent(value)` is true.
        var isPrevDirection = tNode === null;
        var value = undefined;
        while (index > 0) {
            var rawKey = tData[index];
            var containsStatics = Array.isArray(rawKey);
            // Unwrap the key if we contain static values.
            var key = containsStatics ? rawKey[1] : rawKey;
            var isStylingMap = key === null;
            var valueAtLViewIndex = lView[index + 1];
            if (valueAtLViewIndex === NO_CHANGE) {
                // In firstUpdatePass the styling instructions create a linked list of styling.
                // On subsequent passes it is possible for a styling instruction to try to read a binding
                // which
                // has not yet executed. In that case we will find `NO_CHANGE` and we should assume that
                // we have `undefined` (or empty array in case of styling-map instruction) instead. This
                // allows the resolution to apply the value (which may later be overwritten when the
                // binding actually executes.)
                valueAtLViewIndex = isStylingMap ? EMPTY_ARRAY : undefined;
            }
            var currentValue = isStylingMap ? keyValueArrayGet(valueAtLViewIndex, prop) :
                key === prop ? valueAtLViewIndex : undefined;
            if (containsStatics && !isStylingValuePresent(currentValue)) {
                currentValue = keyValueArrayGet(rawKey, prop);
            }
            if (isStylingValuePresent(currentValue)) {
                value = currentValue;
                if (isPrevDirection) {
                    return value;
                }
            }
            var tRange = tData[index + 1];
            index = isPrevDirection ? getTStylingRangePrev(tRange) : getTStylingRangeNext(tRange);
        }
        if (tNode !== null) {
            // in case where we are going in next direction AND we did not find anything, we need to
            // consult residual styling
            var residual = isClassBased ? tNode.residualClasses : tNode.residualStyles;
            if (residual != null /** OR residual !=== undefined */) {
                value = keyValueArrayGet(residual, prop);
            }
        }
        return value;
    }
    /**
     * Determines if the binding value should be used (or if the value is 'undefined' and hence priority
     * resolution should be used.)
     *
     * @param value Binding style value.
     */
    function isStylingValuePresent(value) {
        // Currently only `undefined` value is considered non-binding. That is `undefined` says I don't
        // have an opinion as to what this binding should be and you should consult other bindings by
        // priority to determine the valid value.
        // This is extracted into a single function so that we have a single place to control this.
        return value !== undefined;
    }
    /**
     * Normalizes and/or adds a suffix to the value.
     *
     * If value is `null`/`undefined` no suffix is added
     * @param value
     * @param suffix
     */
    function normalizeSuffix(value, suffix) {
        if (value == null /** || value === undefined */) {
            // do nothing
        }
        else if (typeof suffix === 'string') {
            value = value + suffix;
        }
        else if (typeof value === 'object') {
            value = stringify(unwrapSafeValue(value));
        }
        return value;
    }
    /**
     * Tests if the `TNode` has input shadow.
     *
     * An input shadow is when a directive steals (shadows) the input by using `@Input('style')` or
     * `@Input('class')` as input.
     *
     * @param tNode `TNode` which we would like to see if it has shadow.
     * @param isClassBased `true` if `class` (`false` if `style`)
     */
    function hasStylingInputShadow(tNode, isClassBased) {
        return (tNode.flags & (isClassBased ? 16 /* hasClassInput */ : 32 /* hasStyleInput */)) !== 0;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Create static text node
     *
     * @param index Index of the node in the data array
     * @param value Static string value to write.
     *
     * @codeGenApi
     */
    function ɵɵtext(index, value) {
        if (value === void 0) { value = ''; }
        var lView = getLView();
        var tView = getTView();
        var adjustedIndex = index + HEADER_OFFSET;
        ngDevMode &&
            assertEqual(getBindingIndex(), tView.bindingStartIndex, 'text nodes should be created before any bindings');
        ngDevMode && assertIndexInRange(lView, adjustedIndex);
        var tNode = tView.firstCreatePass ?
            getOrCreateTNode(tView, adjustedIndex, 1 /* Text */, value, null) :
            tView.data[adjustedIndex];
        var textNative = lView[adjustedIndex] = createTextNode(lView[RENDERER], value);
        appendChild(tView, lView, textNative, tNode);
        // Text nodes are self closing.
        setCurrentTNode(tNode, false);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     *
     * Update text content with a lone bound value
     *
     * Used when a text node has 1 interpolated value in it, an no additional text
     * surrounds that interpolated value:
     *
     * ```html
     * <div>{{v0}}</div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵtextInterpolate(v0);
     * ```
     * @returns itself, so that it may be chained.
     * @see textInterpolateV
     * @codeGenApi
     */
    function ɵɵtextInterpolate(v0) {
        ɵɵtextInterpolate1('', v0, '');
        return ɵɵtextInterpolate;
    }
    /**
     *
     * Update text content with single bound value surrounded by other text.
     *
     * Used when a text node has 1 interpolated value in it:
     *
     * ```html
     * <div>prefix{{v0}}suffix</div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵtextInterpolate1('prefix', v0, 'suffix');
     * ```
     * @returns itself, so that it may be chained.
     * @see textInterpolateV
     * @codeGenApi
     */
    function ɵɵtextInterpolate1(prefix, v0, suffix) {
        var lView = getLView();
        var interpolated = interpolation1(lView, prefix, v0, suffix);
        if (interpolated !== NO_CHANGE) {
            textBindingInternal(lView, getSelectedIndex(), interpolated);
        }
        return ɵɵtextInterpolate1;
    }
    /**
     *
     * Update text content with 2 bound values surrounded by other text.
     *
     * Used when a text node has 2 interpolated values in it:
     *
     * ```html
     * <div>prefix{{v0}}-{{v1}}suffix</div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵtextInterpolate2('prefix', v0, '-', v1, 'suffix');
     * ```
     * @returns itself, so that it may be chained.
     * @see textInterpolateV
     * @codeGenApi
     */
    function ɵɵtextInterpolate2(prefix, v0, i0, v1, suffix) {
        var lView = getLView();
        var interpolated = interpolation2(lView, prefix, v0, i0, v1, suffix);
        if (interpolated !== NO_CHANGE) {
            textBindingInternal(lView, getSelectedIndex(), interpolated);
        }
        return ɵɵtextInterpolate2;
    }
    /**
     *
     * Update text content with 3 bound values surrounded by other text.
     *
     * Used when a text node has 3 interpolated values in it:
     *
     * ```html
     * <div>prefix{{v0}}-{{v1}}-{{v2}}suffix</div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵtextInterpolate3(
     * 'prefix', v0, '-', v1, '-', v2, 'suffix');
     * ```
     * @returns itself, so that it may be chained.
     * @see textInterpolateV
     * @codeGenApi
     */
    function ɵɵtextInterpolate3(prefix, v0, i0, v1, i1, v2, suffix) {
        var lView = getLView();
        var interpolated = interpolation3(lView, prefix, v0, i0, v1, i1, v2, suffix);
        if (interpolated !== NO_CHANGE) {
            textBindingInternal(lView, getSelectedIndex(), interpolated);
        }
        return ɵɵtextInterpolate3;
    }
    /**
     *
     * Update text content with 4 bound values surrounded by other text.
     *
     * Used when a text node has 4 interpolated values in it:
     *
     * ```html
     * <div>prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}suffix</div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵtextInterpolate4(
     * 'prefix', v0, '-', v1, '-', v2, '-', v3, 'suffix');
     * ```
     * @returns itself, so that it may be chained.
     * @see ɵɵtextInterpolateV
     * @codeGenApi
     */
    function ɵɵtextInterpolate4(prefix, v0, i0, v1, i1, v2, i2, v3, suffix) {
        var lView = getLView();
        var interpolated = interpolation4(lView, prefix, v0, i0, v1, i1, v2, i2, v3, suffix);
        if (interpolated !== NO_CHANGE) {
            textBindingInternal(lView, getSelectedIndex(), interpolated);
        }
        return ɵɵtextInterpolate4;
    }
    /**
     *
     * Update text content with 5 bound values surrounded by other text.
     *
     * Used when a text node has 5 interpolated values in it:
     *
     * ```html
     * <div>prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}suffix</div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵtextInterpolate5(
     * 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, 'suffix');
     * ```
     * @returns itself, so that it may be chained.
     * @see textInterpolateV
     * @codeGenApi
     */
    function ɵɵtextInterpolate5(prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, suffix) {
        var lView = getLView();
        var interpolated = interpolation5(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, suffix);
        if (interpolated !== NO_CHANGE) {
            textBindingInternal(lView, getSelectedIndex(), interpolated);
        }
        return ɵɵtextInterpolate5;
    }
    /**
     *
     * Update text content with 6 bound values surrounded by other text.
     *
     * Used when a text node has 6 interpolated values in it:
     *
     * ```html
     * <div>prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}suffix</div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵtextInterpolate6(
     *    'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, 'suffix');
     * ```
     *
     * @param i4 Static value used for concatenation only.
     * @param v5 Value checked for change. @returns itself, so that it may be chained.
     * @see textInterpolateV
     * @codeGenApi
     */
    function ɵɵtextInterpolate6(prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, suffix) {
        var lView = getLView();
        var interpolated = interpolation6(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, suffix);
        if (interpolated !== NO_CHANGE) {
            textBindingInternal(lView, getSelectedIndex(), interpolated);
        }
        return ɵɵtextInterpolate6;
    }
    /**
     *
     * Update text content with 7 bound values surrounded by other text.
     *
     * Used when a text node has 7 interpolated values in it:
     *
     * ```html
     * <div>prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}suffix</div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵtextInterpolate7(
     *    'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, 'suffix');
     * ```
     * @returns itself, so that it may be chained.
     * @see textInterpolateV
     * @codeGenApi
     */
    function ɵɵtextInterpolate7(prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, suffix) {
        var lView = getLView();
        var interpolated = interpolation7(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, suffix);
        if (interpolated !== NO_CHANGE) {
            textBindingInternal(lView, getSelectedIndex(), interpolated);
        }
        return ɵɵtextInterpolate7;
    }
    /**
     *
     * Update text content with 8 bound values surrounded by other text.
     *
     * Used when a text node has 8 interpolated values in it:
     *
     * ```html
     * <div>prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}-{{v7}}suffix</div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵtextInterpolate8(
     *  'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, '-', v7, 'suffix');
     * ```
     * @returns itself, so that it may be chained.
     * @see textInterpolateV
     * @codeGenApi
     */
    function ɵɵtextInterpolate8(prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, i6, v7, suffix) {
        var lView = getLView();
        var interpolated = interpolation8(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, i6, v7, suffix);
        if (interpolated !== NO_CHANGE) {
            textBindingInternal(lView, getSelectedIndex(), interpolated);
        }
        return ɵɵtextInterpolate8;
    }
    /**
     * Update text content with 9 or more bound values other surrounded by text.
     *
     * Used when the number of interpolated values exceeds 8.
     *
     * ```html
     * <div>prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}-{{v7}}-{{v8}}-{{v9}}suffix</div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵtextInterpolateV(
     *  ['prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, '-', v7, '-', v9,
     *  'suffix']);
     * ```
     *.
     * @param values The collection of values and the strings in between those values, beginning with
     * a string prefix and ending with a string suffix.
     * (e.g. `['prefix', value0, '-', value1, '-', value2, ..., value99, 'suffix']`)
     *
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵtextInterpolateV(values) {
        var lView = getLView();
        var interpolated = interpolationV(lView, values);
        if (interpolated !== NO_CHANGE) {
            textBindingInternal(lView, getSelectedIndex(), interpolated);
        }
        return ɵɵtextInterpolateV;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     *
     * Update an interpolated class on an element with single bound value surrounded by text.
     *
     * Used when the value passed to a property has 1 interpolated value in it:
     *
     * ```html
     * <div class="prefix{{v0}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵclassMapInterpolate1('prefix', v0, 'suffix');
     * ```
     *
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @codeGenApi
     */
    function ɵɵclassMapInterpolate1(prefix, v0, suffix) {
        var lView = getLView();
        var interpolatedValue = interpolation1(lView, prefix, v0, suffix);
        checkStylingMap(keyValueArraySet, classStringParser, interpolatedValue, true);
    }
    /**
     *
     * Update an interpolated class on an element with 2 bound values surrounded by text.
     *
     * Used when the value passed to a property has 2 interpolated values in it:
     *
     * ```html
     * <div class="prefix{{v0}}-{{v1}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵclassMapInterpolate2('prefix', v0, '-', v1, 'suffix');
     * ```
     *
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @codeGenApi
     */
    function ɵɵclassMapInterpolate2(prefix, v0, i0, v1, suffix) {
        var lView = getLView();
        var interpolatedValue = interpolation2(lView, prefix, v0, i0, v1, suffix);
        checkStylingMap(keyValueArraySet, classStringParser, interpolatedValue, true);
    }
    /**
     *
     * Update an interpolated class on an element with 3 bound values surrounded by text.
     *
     * Used when the value passed to a property has 3 interpolated values in it:
     *
     * ```html
     * <div class="prefix{{v0}}-{{v1}}-{{v2}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵclassMapInterpolate3(
     * 'prefix', v0, '-', v1, '-', v2, 'suffix');
     * ```
     *
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @codeGenApi
     */
    function ɵɵclassMapInterpolate3(prefix, v0, i0, v1, i1, v2, suffix) {
        var lView = getLView();
        var interpolatedValue = interpolation3(lView, prefix, v0, i0, v1, i1, v2, suffix);
        checkStylingMap(keyValueArraySet, classStringParser, interpolatedValue, true);
    }
    /**
     *
     * Update an interpolated class on an element with 4 bound values surrounded by text.
     *
     * Used when the value passed to a property has 4 interpolated values in it:
     *
     * ```html
     * <div class="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵclassMapInterpolate4(
     * 'prefix', v0, '-', v1, '-', v2, '-', v3, 'suffix');
     * ```
     *
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @codeGenApi
     */
    function ɵɵclassMapInterpolate4(prefix, v0, i0, v1, i1, v2, i2, v3, suffix) {
        var lView = getLView();
        var interpolatedValue = interpolation4(lView, prefix, v0, i0, v1, i1, v2, i2, v3, suffix);
        checkStylingMap(keyValueArraySet, classStringParser, interpolatedValue, true);
    }
    /**
     *
     * Update an interpolated class on an element with 5 bound values surrounded by text.
     *
     * Used when the value passed to a property has 5 interpolated values in it:
     *
     * ```html
     * <div class="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵclassMapInterpolate5(
     * 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, 'suffix');
     * ```
     *
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @codeGenApi
     */
    function ɵɵclassMapInterpolate5(prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, suffix) {
        var lView = getLView();
        var interpolatedValue = interpolation5(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, suffix);
        checkStylingMap(keyValueArraySet, classStringParser, interpolatedValue, true);
    }
    /**
     *
     * Update an interpolated class on an element with 6 bound values surrounded by text.
     *
     * Used when the value passed to a property has 6 interpolated values in it:
     *
     * ```html
     * <div class="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵclassMapInterpolate6(
     *    'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, 'suffix');
     * ```
     *
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param i4 Static value used for concatenation only.
     * @param v5 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @codeGenApi
     */
    function ɵɵclassMapInterpolate6(prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, suffix) {
        var lView = getLView();
        var interpolatedValue = interpolation6(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, suffix);
        checkStylingMap(keyValueArraySet, classStringParser, interpolatedValue, true);
    }
    /**
     *
     * Update an interpolated class on an element with 7 bound values surrounded by text.
     *
     * Used when the value passed to a property has 7 interpolated values in it:
     *
     * ```html
     * <div class="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵclassMapInterpolate7(
     *    'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, 'suffix');
     * ```
     *
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param i4 Static value used for concatenation only.
     * @param v5 Value checked for change.
     * @param i5 Static value used for concatenation only.
     * @param v6 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @codeGenApi
     */
    function ɵɵclassMapInterpolate7(prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, suffix) {
        var lView = getLView();
        var interpolatedValue = interpolation7(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, suffix);
        checkStylingMap(keyValueArraySet, classStringParser, interpolatedValue, true);
    }
    /**
     *
     * Update an interpolated class on an element with 8 bound values surrounded by text.
     *
     * Used when the value passed to a property has 8 interpolated values in it:
     *
     * ```html
     * <div class="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}-{{v7}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵclassMapInterpolate8(
     *  'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, '-', v7, 'suffix');
     * ```
     *
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param i4 Static value used for concatenation only.
     * @param v5 Value checked for change.
     * @param i5 Static value used for concatenation only.
     * @param v6 Value checked for change.
     * @param i6 Static value used for concatenation only.
     * @param v7 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @codeGenApi
     */
    function ɵɵclassMapInterpolate8(prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, i6, v7, suffix) {
        var lView = getLView();
        var interpolatedValue = interpolation8(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, i6, v7, suffix);
        checkStylingMap(keyValueArraySet, classStringParser, interpolatedValue, true);
    }
    /**
     * Update an interpolated class on an element with 9 or more bound values surrounded by text.
     *
     * Used when the number of interpolated values exceeds 8.
     *
     * ```html
     * <div
     *  class="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}-{{v7}}-{{v8}}-{{v9}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵclassMapInterpolateV(
     *  ['prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, '-', v7, '-', v9,
     *  'suffix']);
     * ```
     *.
     * @param values The collection of values and the strings in-between those values, beginning with
     * a string prefix and ending with a string suffix.
     * (e.g. `['prefix', value0, '-', value1, '-', value2, ..., value99, 'suffix']`)
     * @codeGenApi
     */
    function ɵɵclassMapInterpolateV(values) {
        var lView = getLView();
        var interpolatedValue = interpolationV(lView, values);
        checkStylingMap(keyValueArraySet, classStringParser, interpolatedValue, true);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     *
     * Update an interpolated style on an element with single bound value surrounded by text.
     *
     * Used when the value passed to a property has 1 interpolated value in it:
     *
     * ```html
     * <div style="key: {{v0}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵstyleMapInterpolate1('key: ', v0, 'suffix');
     * ```
     *
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @codeGenApi
     */
    function ɵɵstyleMapInterpolate1(prefix, v0, suffix) {
        var lView = getLView();
        var interpolatedValue = interpolation1(lView, prefix, v0, suffix);
        ɵɵstyleMap(interpolatedValue);
    }
    /**
     *
     * Update an interpolated style on an element with 2 bound values surrounded by text.
     *
     * Used when the value passed to a property has 2 interpolated values in it:
     *
     * ```html
     * <div style="key: {{v0}}; key1: {{v1}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵstyleMapInterpolate2('key: ', v0, '; key1: ', v1, 'suffix');
     * ```
     *
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @codeGenApi
     */
    function ɵɵstyleMapInterpolate2(prefix, v0, i0, v1, suffix) {
        var lView = getLView();
        var interpolatedValue = interpolation2(lView, prefix, v0, i0, v1, suffix);
        ɵɵstyleMap(interpolatedValue);
    }
    /**
     *
     * Update an interpolated style on an element with 3 bound values surrounded by text.
     *
     * Used when the value passed to a property has 3 interpolated values in it:
     *
     * ```html
     * <div style="key: {{v0}}; key2: {{v1}}; key2: {{v2}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵstyleMapInterpolate3(
     *     'key: ', v0, '; key1: ', v1, '; key2: ', v2, 'suffix');
     * ```
     *
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @codeGenApi
     */
    function ɵɵstyleMapInterpolate3(prefix, v0, i0, v1, i1, v2, suffix) {
        var lView = getLView();
        var interpolatedValue = interpolation3(lView, prefix, v0, i0, v1, i1, v2, suffix);
        ɵɵstyleMap(interpolatedValue);
    }
    /**
     *
     * Update an interpolated style on an element with 4 bound values surrounded by text.
     *
     * Used when the value passed to a property has 4 interpolated values in it:
     *
     * ```html
     * <div style="key: {{v0}}; key1: {{v1}}; key2: {{v2}}; key3: {{v3}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵstyleMapInterpolate4(
     *     'key: ', v0, '; key1: ', v1, '; key2: ', v2, '; key3: ', v3, 'suffix');
     * ```
     *
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @codeGenApi
     */
    function ɵɵstyleMapInterpolate4(prefix, v0, i0, v1, i1, v2, i2, v3, suffix) {
        var lView = getLView();
        var interpolatedValue = interpolation4(lView, prefix, v0, i0, v1, i1, v2, i2, v3, suffix);
        ɵɵstyleMap(interpolatedValue);
    }
    /**
     *
     * Update an interpolated style on an element with 5 bound values surrounded by text.
     *
     * Used when the value passed to a property has 5 interpolated values in it:
     *
     * ```html
     * <div style="key: {{v0}}; key1: {{v1}}; key2: {{v2}}; key3: {{v3}}; key4: {{v4}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵstyleMapInterpolate5(
     *     'key: ', v0, '; key1: ', v1, '; key2: ', v2, '; key3: ', v3, '; key4: ', v4, 'suffix');
     * ```
     *
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @codeGenApi
     */
    function ɵɵstyleMapInterpolate5(prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, suffix) {
        var lView = getLView();
        var interpolatedValue = interpolation5(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, suffix);
        ɵɵstyleMap(interpolatedValue);
    }
    /**
     *
     * Update an interpolated style on an element with 6 bound values surrounded by text.
     *
     * Used when the value passed to a property has 6 interpolated values in it:
     *
     * ```html
     * <div style="key: {{v0}}; key1: {{v1}}; key2: {{v2}}; key3: {{v3}}; key4: {{v4}};
     *             key5: {{v5}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵstyleMapInterpolate6(
     *    'key: ', v0, '; key1: ', v1, '; key2: ', v2, '; key3: ', v3, '; key4: ', v4, '; key5: ', v5,
     *    'suffix');
     * ```
     *
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param i4 Static value used for concatenation only.
     * @param v5 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @codeGenApi
     */
    function ɵɵstyleMapInterpolate6(prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, suffix) {
        var lView = getLView();
        var interpolatedValue = interpolation6(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, suffix);
        ɵɵstyleMap(interpolatedValue);
    }
    /**
     *
     * Update an interpolated style on an element with 7 bound values surrounded by text.
     *
     * Used when the value passed to a property has 7 interpolated values in it:
     *
     * ```html
     * <div style="key: {{v0}}; key1: {{v1}}; key2: {{v2}}; key3: {{v3}}; key4: {{v4}}; key5: {{v5}};
     *             key6: {{v6}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵstyleMapInterpolate7(
     *    'key: ', v0, '; key1: ', v1, '; key2: ', v2, '; key3: ', v3, '; key4: ', v4, '; key5: ', v5,
     *    '; key6: ', v6, 'suffix');
     * ```
     *
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param i4 Static value used for concatenation only.
     * @param v5 Value checked for change.
     * @param i5 Static value used for concatenation only.
     * @param v6 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @codeGenApi
     */
    function ɵɵstyleMapInterpolate7(prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, suffix) {
        var lView = getLView();
        var interpolatedValue = interpolation7(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, suffix);
        ɵɵstyleMap(interpolatedValue);
    }
    /**
     *
     * Update an interpolated style on an element with 8 bound values surrounded by text.
     *
     * Used when the value passed to a property has 8 interpolated values in it:
     *
     * ```html
     * <div style="key: {{v0}}; key1: {{v1}}; key2: {{v2}}; key3: {{v3}}; key4: {{v4}}; key5: {{v5}};
     *             key6: {{v6}}; key7: {{v7}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵstyleMapInterpolate8(
     *    'key: ', v0, '; key1: ', v1, '; key2: ', v2, '; key3: ', v3, '; key4: ', v4, '; key5: ', v5,
     *    '; key6: ', v6, '; key7: ', v7, 'suffix');
     * ```
     *
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param i4 Static value used for concatenation only.
     * @param v5 Value checked for change.
     * @param i5 Static value used for concatenation only.
     * @param v6 Value checked for change.
     * @param i6 Static value used for concatenation only.
     * @param v7 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @codeGenApi
     */
    function ɵɵstyleMapInterpolate8(prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, i6, v7, suffix) {
        var lView = getLView();
        var interpolatedValue = interpolation8(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, i6, v7, suffix);
        ɵɵstyleMap(interpolatedValue);
    }
    /**
     * Update an interpolated style on an element with 9 or more bound values surrounded by text.
     *
     * Used when the number of interpolated values exceeds 8.
     *
     * ```html
     * <div
     *  class="key: {{v0}}; key1: {{v1}}; key2: {{v2}}; key3: {{v3}}; key4: {{v4}}; key5: {{v5}};
     *         key6: {{v6}}; key7: {{v7}}; key8: {{v8}}; key9: {{v9}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵstyleMapInterpolateV(
     *    ['key: ', v0, '; key1: ', v1, '; key2: ', v2, '; key3: ', v3, '; key4: ', v4, '; key5: ', v5,
     *     '; key6: ', v6, '; key7: ', v7, '; key8: ', v8, '; key9: ', v9, 'suffix']);
     * ```
     *.
     * @param values The collection of values and the strings in-between those values, beginning with
     * a string prefix and ending with a string suffix.
     * (e.g. `['prefix', value0, '; key2: ', value1, '; key2: ', value2, ..., value99, 'suffix']`)
     * @codeGenApi
     */
    function ɵɵstyleMapInterpolateV(values) {
        var lView = getLView();
        var interpolatedValue = interpolationV(lView, values);
        ɵɵstyleMap(interpolatedValue);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     *
     * Update an interpolated style property on an element with single bound value surrounded by text.
     *
     * Used when the value passed to a property has 1 interpolated value in it:
     *
     * ```html
     * <div style.color="prefix{{v0}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵstylePropInterpolate1(0, 'prefix', v0, 'suffix');
     * ```
     *
     * @param styleIndex Index of style to update. This index value refers to the
     *        index of the style in the style bindings array that was passed into
     *        `styling`.
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param valueSuffix Optional suffix. Used with scalar values to add unit such as `px`.
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵstylePropInterpolate1(prop, prefix, v0, suffix, valueSuffix) {
        var lView = getLView();
        var interpolatedValue = interpolation1(lView, prefix, v0, suffix);
        checkStylingProperty(prop, interpolatedValue, valueSuffix, false);
        return ɵɵstylePropInterpolate1;
    }
    /**
     *
     * Update an interpolated style property on an element with 2 bound values surrounded by text.
     *
     * Used when the value passed to a property has 2 interpolated values in it:
     *
     * ```html
     * <div style.color="prefix{{v0}}-{{v1}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵstylePropInterpolate2(0, 'prefix', v0, '-', v1, 'suffix');
     * ```
     *
     * @param styleIndex Index of style to update. This index value refers to the
     *        index of the style in the style bindings array that was passed into
     *        `styling`.
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param valueSuffix Optional suffix. Used with scalar values to add unit such as `px`.
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵstylePropInterpolate2(prop, prefix, v0, i0, v1, suffix, valueSuffix) {
        var lView = getLView();
        var interpolatedValue = interpolation2(lView, prefix, v0, i0, v1, suffix);
        checkStylingProperty(prop, interpolatedValue, valueSuffix, false);
        return ɵɵstylePropInterpolate2;
    }
    /**
     *
     * Update an interpolated style property on an element with 3 bound values surrounded by text.
     *
     * Used when the value passed to a property has 3 interpolated values in it:
     *
     * ```html
     * <div style.color="prefix{{v0}}-{{v1}}-{{v2}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵstylePropInterpolate3(0, 'prefix', v0, '-', v1, '-', v2, 'suffix');
     * ```
     *
     * @param styleIndex Index of style to update. This index value refers to the
     *        index of the style in the style bindings array that was passed into
     *        `styling`.
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param valueSuffix Optional suffix. Used with scalar values to add unit such as `px`.
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵstylePropInterpolate3(prop, prefix, v0, i0, v1, i1, v2, suffix, valueSuffix) {
        var lView = getLView();
        var interpolatedValue = interpolation3(lView, prefix, v0, i0, v1, i1, v2, suffix);
        checkStylingProperty(prop, interpolatedValue, valueSuffix, false);
        return ɵɵstylePropInterpolate3;
    }
    /**
     *
     * Update an interpolated style property on an element with 4 bound values surrounded by text.
     *
     * Used when the value passed to a property has 4 interpolated values in it:
     *
     * ```html
     * <div style.color="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵstylePropInterpolate4(0, 'prefix', v0, '-', v1, '-', v2, '-', v3, 'suffix');
     * ```
     *
     * @param styleIndex Index of style to update. This index value refers to the
     *        index of the style in the style bindings array that was passed into
     *        `styling`.
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param valueSuffix Optional suffix. Used with scalar values to add unit such as `px`.
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵstylePropInterpolate4(prop, prefix, v0, i0, v1, i1, v2, i2, v3, suffix, valueSuffix) {
        var lView = getLView();
        var interpolatedValue = interpolation4(lView, prefix, v0, i0, v1, i1, v2, i2, v3, suffix);
        checkStylingProperty(prop, interpolatedValue, valueSuffix, false);
        return ɵɵstylePropInterpolate4;
    }
    /**
     *
     * Update an interpolated style property on an element with 5 bound values surrounded by text.
     *
     * Used when the value passed to a property has 5 interpolated values in it:
     *
     * ```html
     * <div style.color="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵstylePropInterpolate5(0, 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, 'suffix');
     * ```
     *
     * @param styleIndex Index of style to update. This index value refers to the
     *        index of the style in the style bindings array that was passed into
     *        `styling`.
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param valueSuffix Optional suffix. Used with scalar values to add unit such as `px`.
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵstylePropInterpolate5(prop, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, suffix, valueSuffix) {
        var lView = getLView();
        var interpolatedValue = interpolation5(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, suffix);
        checkStylingProperty(prop, interpolatedValue, valueSuffix, false);
        return ɵɵstylePropInterpolate5;
    }
    /**
     *
     * Update an interpolated style property on an element with 6 bound values surrounded by text.
     *
     * Used when the value passed to a property has 6 interpolated values in it:
     *
     * ```html
     * <div style.color="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵstylePropInterpolate6(0, 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, 'suffix');
     * ```
     *
     * @param styleIndex Index of style to update. This index value refers to the
     *        index of the style in the style bindings array that was passed into
     *        `styling`.
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param i4 Static value used for concatenation only.
     * @param v5 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param valueSuffix Optional suffix. Used with scalar values to add unit such as `px`.
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵstylePropInterpolate6(prop, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, suffix, valueSuffix) {
        var lView = getLView();
        var interpolatedValue = interpolation6(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, suffix);
        checkStylingProperty(prop, interpolatedValue, valueSuffix, false);
        return ɵɵstylePropInterpolate6;
    }
    /**
     *
     * Update an interpolated style property on an element with 7 bound values surrounded by text.
     *
     * Used when the value passed to a property has 7 interpolated values in it:
     *
     * ```html
     * <div style.color="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵstylePropInterpolate7(
     *    0, 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, 'suffix');
     * ```
     *
     * @param styleIndex Index of style to update. This index value refers to the
     *        index of the style in the style bindings array that was passed into
     *        `styling`.
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param i4 Static value used for concatenation only.
     * @param v5 Value checked for change.
     * @param i5 Static value used for concatenation only.
     * @param v6 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param valueSuffix Optional suffix. Used with scalar values to add unit such as `px`.
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵstylePropInterpolate7(prop, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, suffix, valueSuffix) {
        var lView = getLView();
        var interpolatedValue = interpolation7(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, suffix);
        checkStylingProperty(prop, interpolatedValue, valueSuffix, false);
        return ɵɵstylePropInterpolate7;
    }
    /**
     *
     * Update an interpolated style property on an element with 8 bound values surrounded by text.
     *
     * Used when the value passed to a property has 8 interpolated values in it:
     *
     * ```html
     * <div style.color="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}-{{v7}}suffix"></div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵstylePropInterpolate8(0, 'prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6,
     * '-', v7, 'suffix');
     * ```
     *
     * @param styleIndex Index of style to update. This index value refers to the
     *        index of the style in the style bindings array that was passed into
     *        `styling`.
     * @param prefix Static value used for concatenation only.
     * @param v0 Value checked for change.
     * @param i0 Static value used for concatenation only.
     * @param v1 Value checked for change.
     * @param i1 Static value used for concatenation only.
     * @param v2 Value checked for change.
     * @param i2 Static value used for concatenation only.
     * @param v3 Value checked for change.
     * @param i3 Static value used for concatenation only.
     * @param v4 Value checked for change.
     * @param i4 Static value used for concatenation only.
     * @param v5 Value checked for change.
     * @param i5 Static value used for concatenation only.
     * @param v6 Value checked for change.
     * @param i6 Static value used for concatenation only.
     * @param v7 Value checked for change.
     * @param suffix Static value used for concatenation only.
     * @param valueSuffix Optional suffix. Used with scalar values to add unit such as `px`.
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵstylePropInterpolate8(prop, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, i6, v7, suffix, valueSuffix) {
        var lView = getLView();
        var interpolatedValue = interpolation8(lView, prefix, v0, i0, v1, i1, v2, i2, v3, i3, v4, i4, v5, i5, v6, i6, v7, suffix);
        checkStylingProperty(prop, interpolatedValue, valueSuffix, false);
        return ɵɵstylePropInterpolate8;
    }
    /**
     * Update an interpolated style property on an element with 9 or more bound values surrounded by
     * text.
     *
     * Used when the number of interpolated values exceeds 8.
     *
     * ```html
     * <div
     *  style.color="prefix{{v0}}-{{v1}}-{{v2}}-{{v3}}-{{v4}}-{{v5}}-{{v6}}-{{v7}}-{{v8}}-{{v9}}suffix">
     * </div>
     * ```
     *
     * Its compiled representation is:
     *
     * ```ts
     * ɵɵstylePropInterpolateV(
     *  0, ['prefix', v0, '-', v1, '-', v2, '-', v3, '-', v4, '-', v5, '-', v6, '-', v7, '-', v9,
     *  'suffix']);
     * ```
     *
     * @param styleIndex Index of style to update. This index value refers to the
     *        index of the style in the style bindings array that was passed into
     *        `styling`..
     * @param values The collection of values and the strings in-between those values, beginning with
     * a string prefix and ending with a string suffix.
     * (e.g. `['prefix', value0, '-', value1, '-', value2, ..., value99, 'suffix']`)
     * @param valueSuffix Optional suffix. Used with scalar values to add unit such as `px`.
     * @returns itself, so that it may be chained.
     * @codeGenApi
     */
    function ɵɵstylePropInterpolateV(prop, values, valueSuffix) {
        var lView = getLView();
        var interpolatedValue = interpolationV(lView, values);
        checkStylingProperty(prop, interpolatedValue, valueSuffix, false);
        return ɵɵstylePropInterpolateV;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Update a property on a host element. Only applies to native node properties, not inputs.
     *
     * Operates on the element selected by index via the {@link select} instruction.
     *
     * @param propName Name of property. Because it is going to DOM, this is not subject to
     *        renaming as part of minification.
     * @param value New value to write.
     * @param sanitizer An optional function used to sanitize the value.
     * @returns This function returns itself so that it may be chained
     * (e.g. `property('name', ctx.name)('title', ctx.title)`)
     *
     * @codeGenApi
     */
    function ɵɵhostProperty(propName, value, sanitizer) {
        var lView = getLView();
        var bindingIndex = nextBindingIndex();
        if (bindingUpdated(lView, bindingIndex, value)) {
            var tView = getTView();
            var tNode = getSelectedTNode();
            elementPropertyInternal(tView, tNode, lView, propName, value, lView[RENDERER], sanitizer, true);
            ngDevMode && storePropertyBindingMetadata(tView.data, tNode, propName, bindingIndex);
        }
        return ɵɵhostProperty;
    }
    /**
     * Updates a synthetic host binding (e.g. `[@foo]`) on a component or directive.
     *
     * This instruction is for compatibility purposes and is designed to ensure that a
     * synthetic host binding (e.g. `@HostBinding('@foo')`) properly gets rendered in
     * the component's renderer. Normally all host bindings are evaluated with the parent
     * component's renderer, but, in the case of animation @triggers, they need to be
     * evaluated with the sub component's renderer (because that's where the animation
     * triggers are defined).
     *
     * Do not use this instruction as a replacement for `elementProperty`. This instruction
     * only exists to ensure compatibility with the ViewEngine's host binding behavior.
     *
     * @param index The index of the element to update in the data array
     * @param propName Name of property. Because it is going to DOM, this is not subject to
     *        renaming as part of minification.
     * @param value New value to write.
     * @param sanitizer An optional function used to sanitize the value.
     *
     * @codeGenApi
     */
    function ɵɵsyntheticHostProperty(propName, value, sanitizer) {
        var lView = getLView();
        var bindingIndex = nextBindingIndex();
        if (bindingUpdated(lView, bindingIndex, value)) {
            var tView = getTView();
            var tNode = getSelectedTNode();
            var currentDef = getCurrentDirectiveDef(tView.data);
            var renderer = loadComponentRenderer(currentDef, tNode, lView);
            elementPropertyInternal(tView, tNode, lView, propName, value, renderer, sanitizer, true);
            ngDevMode && storePropertyBindingMetadata(tView.data, tNode, propName, bindingIndex);
        }
        return ɵɵsyntheticHostProperty;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * NOTE: changes to the `ngI18nClosureMode` name must be synced with `compiler-cli/src/tooling.ts`.
     */
    if (typeof ngI18nClosureMode === 'undefined') {
        // These property accesses can be ignored because ngI18nClosureMode will be set to false
        // when optimizing code and the whole if statement will be dropped.
        // Make sure to refer to ngI18nClosureMode as ['ngI18nClosureMode'] for closure.
        // NOTE: we need to have it in IIFE so that the tree-shaker is happy.
        (function () {
            // tslint:disable-next-line:no-toplevel-property-access
            _global['ngI18nClosureMode'] =
                // TODO(FW-1250): validate that this actually, you know, works.
                // tslint:disable-next-line:no-toplevel-property-access
                typeof goog !== 'undefined' && typeof goog.getMsg === 'function';
        })();
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    // THIS CODE IS GENERATED - DO NOT MODIFY
    // See angular/tools/gulp-tasks/cldr/extract.js
    var u = undefined;
    function plural(n) {
        var i = Math.floor(Math.abs(n)), v = n.toString().replace(/^[^.]*\.?/, '').length;
        if (i === 1 && v === 0)
            return 1;
        return 5;
    }
    var localeEn = [
        'en',
        [['a', 'p'], ['AM', 'PM'], u],
        [['AM', 'PM'], u, u],
        [
            ['S', 'M', 'T', 'W', 'T', 'F', 'S'], ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
            ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'],
            ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa']
        ],
        u,
        [
            ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
            ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
            [
                'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September',
                'October', 'November', 'December'
            ]
        ],
        u,
        [['B', 'A'], ['BC', 'AD'], ['Before Christ', 'Anno Domini']],
        0,
        [6, 0],
        ['M/d/yy', 'MMM d, y', 'MMMM d, y', 'EEEE, MMMM d, y'],
        ['h:mm a', 'h:mm:ss a', 'h:mm:ss a z', 'h:mm:ss a zzzz'],
        ['{1}, {0}', u, '{1} \'at\' {0}', u],
        ['.', ',', ';', '%', '+', '-', 'E', '×', '‰', '∞', 'NaN', ':'],
        ['#,##0.###', '#,##0%', '¤#,##0.00', '#E0'],
        'USD',
        '$',
        'US Dollar',
        {},
        'ltr',
        plural
    ];

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * This const is used to store the locale data registered with `registerLocaleData`
     */
    var LOCALE_DATA = {};
    /**
     * Register locale data to be used internally by Angular. See the
     * ["I18n guide"](guide/i18n#i18n-pipes) to know how to import additional locale data.
     *
     * The signature `registerLocaleData(data: any, extraData?: any)` is deprecated since v5.1
     */
    function registerLocaleData(data, localeId, extraData) {
        if (typeof localeId !== 'string') {
            extraData = localeId;
            localeId = data[exports.ɵLocaleDataIndex.LocaleId];
        }
        localeId = localeId.toLowerCase().replace(/_/g, '-');
        LOCALE_DATA[localeId] = data;
        if (extraData) {
            LOCALE_DATA[localeId][exports.ɵLocaleDataIndex.ExtraData] = extraData;
        }
    }
    /**
     * Finds the locale data for a given locale.
     *
     * @param locale The locale code.
     * @returns The locale data.
     * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n)
     */
    function findLocaleData(locale) {
        var normalizedLocale = normalizeLocale(locale);
        var match = getLocaleData(normalizedLocale);
        if (match) {
            return match;
        }
        // let's try to find a parent locale
        var parentLocale = normalizedLocale.split('-')[0];
        match = getLocaleData(parentLocale);
        if (match) {
            return match;
        }
        if (parentLocale === 'en') {
            return localeEn;
        }
        throw new Error("Missing locale data for the locale \"" + locale + "\".");
    }
    /**
     * Retrieves the default currency code for the given locale.
     *
     * The default is defined as the first currency which is still in use.
     *
     * @param locale The code of the locale whose currency code we want.
     * @returns The code of the default currency for the given locale.
     *
     */
    function getLocaleCurrencyCode(locale) {
        var data = findLocaleData(locale);
        return data[exports.ɵLocaleDataIndex.CurrencyCode] || null;
    }
    /**
     * Retrieves the plural function used by ICU expressions to determine the plural case to use
     * for a given locale.
     * @param locale A locale code for the locale format rules to use.
     * @returns The plural function for the locale.
     * @see `NgPlural`
     * @see [Internationalization (i18n) Guide](https://angular.io/guide/i18n)
     */
    function getLocalePluralCase(locale) {
        var data = findLocaleData(locale);
        return data[exports.ɵLocaleDataIndex.PluralCase];
    }
    /**
     * Helper function to get the given `normalizedLocale` from `LOCALE_DATA`
     * or from the global `ng.common.locale`.
     */
    function getLocaleData(normalizedLocale) {
        if (!(normalizedLocale in LOCALE_DATA)) {
            LOCALE_DATA[normalizedLocale] = _global.ng && _global.ng.common && _global.ng.common.locales &&
                _global.ng.common.locales[normalizedLocale];
        }
        return LOCALE_DATA[normalizedLocale];
    }
    /**
     * Helper function to remove all the locale data from `LOCALE_DATA`.
     */
    function unregisterAllLocaleData() {
        LOCALE_DATA = {};
    }
    (function (LocaleDataIndex) {
        LocaleDataIndex[LocaleDataIndex["LocaleId"] = 0] = "LocaleId";
        LocaleDataIndex[LocaleDataIndex["DayPeriodsFormat"] = 1] = "DayPeriodsFormat";
        LocaleDataIndex[LocaleDataIndex["DayPeriodsStandalone"] = 2] = "DayPeriodsStandalone";
        LocaleDataIndex[LocaleDataIndex["DaysFormat"] = 3] = "DaysFormat";
        LocaleDataIndex[LocaleDataIndex["DaysStandalone"] = 4] = "DaysStandalone";
        LocaleDataIndex[LocaleDataIndex["MonthsFormat"] = 5] = "MonthsFormat";
        LocaleDataIndex[LocaleDataIndex["MonthsStandalone"] = 6] = "MonthsStandalone";
        LocaleDataIndex[LocaleDataIndex["Eras"] = 7] = "Eras";
        LocaleDataIndex[LocaleDataIndex["FirstDayOfWeek"] = 8] = "FirstDayOfWeek";
        LocaleDataIndex[LocaleDataIndex["WeekendRange"] = 9] = "WeekendRange";
        LocaleDataIndex[LocaleDataIndex["DateFormat"] = 10] = "DateFormat";
        LocaleDataIndex[LocaleDataIndex["TimeFormat"] = 11] = "TimeFormat";
        LocaleDataIndex[LocaleDataIndex["DateTimeFormat"] = 12] = "DateTimeFormat";
        LocaleDataIndex[LocaleDataIndex["NumberSymbols"] = 13] = "NumberSymbols";
        LocaleDataIndex[LocaleDataIndex["NumberFormats"] = 14] = "NumberFormats";
        LocaleDataIndex[LocaleDataIndex["CurrencyCode"] = 15] = "CurrencyCode";
        LocaleDataIndex[LocaleDataIndex["CurrencySymbol"] = 16] = "CurrencySymbol";
        LocaleDataIndex[LocaleDataIndex["CurrencyName"] = 17] = "CurrencyName";
        LocaleDataIndex[LocaleDataIndex["Currencies"] = 18] = "Currencies";
        LocaleDataIndex[LocaleDataIndex["Directionality"] = 19] = "Directionality";
        LocaleDataIndex[LocaleDataIndex["PluralCase"] = 20] = "PluralCase";
        LocaleDataIndex[LocaleDataIndex["ExtraData"] = 21] = "ExtraData";
    })(exports.ɵLocaleDataIndex || (exports.ɵLocaleDataIndex = {}));
    /**
     * Returns the canonical form of a locale name - lowercase with `_` replaced with `-`.
     */
    function normalizeLocale(locale) {
        return locale.toLowerCase().replace(/_/g, '-');
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var pluralMapping = ['zero', 'one', 'two', 'few', 'many'];
    /**
     * Returns the plural case based on the locale
     */
    function getPluralCase(value, locale) {
        var plural = getLocalePluralCase(locale)(parseInt(value, 10));
        var result = pluralMapping[plural];
        return (result !== undefined) ? result : 'other';
    }
    /**
     * The locale id that the application is using by default (for translations and ICU expressions).
     */
    var DEFAULT_LOCALE_ID = 'en-US';
    /**
     * USD currency code that the application uses by default for CurrencyPipe when no
     * DEFAULT_CURRENCY_CODE is provided.
     */
    var USD_CURRENCY_CODE = 'USD';

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Marks that the next string is an element name.
     *
     * See `I18nMutateOpCodes` documentation.
     */
    var ELEMENT_MARKER = {
        marker: 'element'
    };
    /**
     * Marks that the next string is comment text need for ICU.
     *
     * See `I18nMutateOpCodes` documentation.
     */
    var ICU_MARKER = {
        marker: 'ICU'
    };
    /**
     * See `I18nCreateOpCodes`
     */
    var I18nCreateOpCode;
    (function (I18nCreateOpCode) {
        /**
         * Number of bits to shift index so that it can be combined with the `APPEND_EAGERLY` and
         * `COMMENT`.
         */
        I18nCreateOpCode[I18nCreateOpCode["SHIFT"] = 2] = "SHIFT";
        /**
         * Should the node be appended to parent imedditatly after creation.
         */
        I18nCreateOpCode[I18nCreateOpCode["APPEND_EAGERLY"] = 1] = "APPEND_EAGERLY";
        /**
         * If set the node should be comment (rather than a text) node.
         */
        I18nCreateOpCode[I18nCreateOpCode["COMMENT"] = 2] = "COMMENT";
    })(I18nCreateOpCode || (I18nCreateOpCode = {}));
    // Note: This hack is necessary so we don't erroneously get a circular dependency
    // failure based on types.
    var unusedValueExportToPlacateAjd$6 = 1;

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * The locale id that the application is currently using (for translations and ICU expressions).
     * This is the ivy version of `LOCALE_ID` that was defined as an injection token for the view engine
     * but is now defined as a global value.
     */
    var LOCALE_ID = DEFAULT_LOCALE_ID;
    /**
     * Sets the locale id that will be used for translations and ICU expressions.
     * This is the ivy version of `LOCALE_ID` that was defined as an injection token for the view engine
     * but is now defined as a global value.
     *
     * @param localeId
     */
    function setLocaleId(localeId) {
        assertDefined(localeId, "Expected localeId to be defined");
        if (typeof localeId === 'string') {
            LOCALE_ID = localeId.toLowerCase().replace(/_/g, '-');
        }
    }
    /**
     * Gets the locale id that will be used for translations and ICU expressions.
     * This is the ivy version of `LOCALE_ID` that was defined as an injection token for the view engine
     * but is now defined as a global value.
     */
    function getLocaleId() {
        return LOCALE_ID;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Find a node in front of which `currentTNode` should be inserted (takes i18n into account).
     *
     * This method determines the `RNode` in front of which we should insert the `currentRNode`. This
     * takes `TNode.insertBeforeIndex` into account.
     *
     * @param parentTNode parent `TNode`
     * @param currentTNode current `TNode` (The node which we would like to insert into the DOM)
     * @param lView current `LView`
     */
    function getInsertInFrontOfRNodeWithI18n(parentTNode, currentTNode, lView) {
        var tNodeInsertBeforeIndex = currentTNode.insertBeforeIndex;
        var insertBeforeIndex = Array.isArray(tNodeInsertBeforeIndex) ? tNodeInsertBeforeIndex[0] : tNodeInsertBeforeIndex;
        if (insertBeforeIndex === null) {
            return getInsertInFrontOfRNodeWithNoI18n(parentTNode, currentTNode, lView);
        }
        else {
            ngDevMode && assertIndexInRange(lView, insertBeforeIndex);
            return unwrapRNode(lView[insertBeforeIndex]);
        }
    }
    /**
     * Process `TNode.insertBeforeIndex` by adding i18n text nodes.
     *
     * See `TNode.insertBeforeIndex`
     */
    function processI18nInsertBefore(renderer, childTNode, lView, childRNode, parentRElement) {
        var tNodeInsertBeforeIndex = childTNode.insertBeforeIndex;
        if (Array.isArray(tNodeInsertBeforeIndex)) {
            // An array indicates that there are i18n nodes that need to be added as children of this
            // `childRNode`. These i18n nodes were created before this `childRNode` was available and so
            // only now can be added. The first element of the array is the normal index where we should
            // insert the `childRNode`. Additional elements are the extra nodes to be added as children of
            // `childRNode`.
            ngDevMode && assertDomNode(childRNode);
            var i18nParent = childRNode;
            var anchorRNode = null;
            if (!(childTNode.type & 3 /* AnyRNode */)) {
                anchorRNode = i18nParent;
                i18nParent = parentRElement;
            }
            if (i18nParent !== null && (childTNode.flags & 2 /* isComponentHost */) === 0) {
                for (var i = 1; i < tNodeInsertBeforeIndex.length; i++) {
                    // No need to `unwrapRNode` because all of the indexes point to i18n text nodes.
                    // see `assertDomNode` below.
                    var i18nChild = lView[tNodeInsertBeforeIndex[i]];
                    nativeInsertBefore(renderer, i18nParent, i18nChild, anchorRNode, false);
                }
            }
        }
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Add `tNode` to `previousTNodes` list and update relevant `TNode`s in `previousTNodes` list
     * `tNode.insertBeforeIndex`.
     *
     * Things to keep in mind:
     * 1. All i18n text nodes are encoded as `TNodeType.Element` and are created eagerly by the
     *    `ɵɵi18nStart` instruction.
     * 2. All `TNodeType.Placeholder` `TNodes` are elements which will be created later by
     *    `ɵɵelementStart` instruction.
     * 3. `ɵɵelementStart` instruction will create `TNode`s in the ascending `TNode.index` order. (So a
     *    smaller index `TNode` is guaranteed to be created before a larger one)
     *
     * We use the above three invariants to determine `TNode.insertBeforeIndex`.
     *
     * In an ideal world `TNode.insertBeforeIndex` would always be `TNode.next.index`. However,
     * this will not work because `TNode.next.index` may be larger than `TNode.index` which means that
     * the next node is not yet created and therefore we can't insert in front of it.
     *
     * Rule1: `TNode.insertBeforeIndex = null` if `TNode.next === null` (Initial condition, as we don't
     *        know if there will be further `TNode`s inserted after.)
     * Rule2: If `previousTNode` is created after the `tNode` being inserted, then
     *        `previousTNode.insertBeforeNode = tNode.index` (So when a new `tNode` is added we check
     *        previous to see if we can update its `insertBeforeTNode`)
     *
     * See `TNode.insertBeforeIndex` for more context.
     *
     * @param previousTNodes A list of previous TNodes so that we can easily traverse `TNode`s in
     *     reverse order. (If `TNode` would have `previous` this would not be necessary.)
     * @param newTNode A TNode to add to the `previousTNodes` list.
     */
    function addTNodeAndUpdateInsertBeforeIndex(previousTNodes, newTNode) {
        // Start with Rule1
        ngDevMode &&
            assertEqual(newTNode.insertBeforeIndex, null, 'We expect that insertBeforeIndex is not set');
        previousTNodes.push(newTNode);
        if (previousTNodes.length > 1) {
            for (var i = previousTNodes.length - 2; i >= 0; i--) {
                var existingTNode = previousTNodes[i];
                // Text nodes are created eagerly and so they don't need their `indexBeforeIndex` updated.
                // It is safe to ignore them.
                if (!isI18nText(existingTNode)) {
                    if (isNewTNodeCreatedBefore(existingTNode, newTNode) &&
                        getInsertBeforeIndex(existingTNode) === null) {
                        // If it was created before us in time, (and it does not yet have `insertBeforeIndex`)
                        // then add the `insertBeforeIndex`.
                        setInsertBeforeIndex(existingTNode, newTNode.index);
                    }
                }
            }
        }
    }
    function isI18nText(tNode) {
        return !(tNode.type & 64 /* Placeholder */);
    }
    function isNewTNodeCreatedBefore(existingTNode, newTNode) {
        return isI18nText(newTNode) || existingTNode.index > newTNode.index;
    }
    function getInsertBeforeIndex(tNode) {
        var index = tNode.insertBeforeIndex;
        return Array.isArray(index) ? index[0] : index;
    }
    function setInsertBeforeIndex(tNode, value) {
        var index = tNode.insertBeforeIndex;
        if (Array.isArray(index)) {
            // Array is stored if we have to insert child nodes. See `TNode.insertBeforeIndex`
            index[0] = value;
        }
        else {
            setI18nHandling(getInsertInFrontOfRNodeWithI18n, processI18nInsertBefore);
            tNode.insertBeforeIndex = value;
        }
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Retrieve `TIcu` at a given `index`.
     *
     * The `TIcu` can be stored either directly (if it is nested ICU) OR
     * it is stored inside tho `TIcuContainer` if it is top level ICU.
     *
     * The reason for this is that the top level ICU need a `TNode` so that they are part of the render
     * tree, but nested ICU's have no TNode, because we don't know ahead of time if the nested ICU is
     * expressed (parent ICU may have selected a case which does not contain it.)
     *
     * @param tView Current `TView`.
     * @param index Index where the value should be read from.
     */
    function getTIcu(tView, index) {
        var value = tView.data[index];
        if (value === null || typeof value === 'string')
            return null;
        if (ngDevMode &&
            !(value.hasOwnProperty('tViews') || value.hasOwnProperty('currentCaseLViewIndex'))) {
            throwError('We expect to get \'null\'|\'TIcu\'|\'TIcuContainer\', but got: ' + value);
        }
        // Here the `value.hasOwnProperty('currentCaseLViewIndex')` is a polymorphic read as it can be
        // either TIcu or TIcuContainerNode. This is not ideal, but we still think it is OK because it
        // will be just two cases which fits into the browser inline cache (inline cache can take up to
        // 4)
        var tIcu = value.hasOwnProperty('currentCaseLViewIndex') ? value :
            value.value;
        ngDevMode && assertTIcu(tIcu);
        return tIcu;
    }
    /**
     * Store `TIcu` at a give `index`.
     *
     * The `TIcu` can be stored either directly (if it is nested ICU) OR
     * it is stored inside tho `TIcuContainer` if it is top level ICU.
     *
     * The reason for this is that the top level ICU need a `TNode` so that they are part of the render
     * tree, but nested ICU's have no TNode, because we don't know ahead of time if the nested ICU is
     * expressed (parent ICU may have selected a case which does not contain it.)
     *
     * @param tView Current `TView`.
     * @param index Index where the value should be stored at in `Tview.data`
     * @param tIcu The TIcu to store.
     */
    function setTIcu(tView, index, tIcu) {
        var tNode = tView.data[index];
        ngDevMode &&
            assertEqual(tNode === null || tNode.hasOwnProperty('tViews'), true, 'We expect to get \'null\'|\'TIcuContainer\'');
        if (tNode === null) {
            tView.data[index] = tIcu;
        }
        else {
            ngDevMode && assertTNodeType(tNode, 32 /* Icu */);
            tNode.value = tIcu;
        }
    }
    /**
     * Set `TNode.insertBeforeIndex` taking the `Array` into account.
     *
     * See `TNode.insertBeforeIndex`
     */
    function setTNodeInsertBeforeIndex(tNode, index) {
        ngDevMode && assertTNode(tNode);
        var insertBeforeIndex = tNode.insertBeforeIndex;
        if (insertBeforeIndex === null) {
            setI18nHandling(getInsertInFrontOfRNodeWithI18n, processI18nInsertBefore);
            insertBeforeIndex = tNode.insertBeforeIndex =
                [null /* may be updated to number later */, index];
        }
        else {
            assertEqual(Array.isArray(insertBeforeIndex), true, 'Expecting array here');
            insertBeforeIndex.push(index);
        }
    }
    /**
     * Create `TNode.type=TNodeType.Placeholder` node.
     *
     * See `TNodeType.Placeholder` for more information.
     */
    function createTNodePlaceholder(tView, previousTNodes, index) {
        var tNode = createTNodeAtIndex(tView, index, 64 /* Placeholder */, null, null);
        addTNodeAndUpdateInsertBeforeIndex(previousTNodes, tNode);
        return tNode;
    }
    /**
     * Returns current ICU case.
     *
     * ICU cases are stored as index into the `TIcu.cases`.
     * At times it is necessary to communicate that the ICU case just switched and that next ICU update
     * should update all bindings regardless of the mask. In such a case the we store negative numbers
     * for cases which have just been switched. This function removes the negative flag.
     */
    function getCurrentICUCaseIndex(tIcu, lView) {
        var currentCase = lView[tIcu.currentCaseLViewIndex];
        return currentCase === null ? currentCase : (currentCase < 0 ? ~currentCase : currentCase);
    }
    function getParentFromIcuCreateOpCode(mergedCode) {
        return mergedCode >>> 17 /* SHIFT_PARENT */;
    }
    function getRefFromIcuCreateOpCode(mergedCode) {
        return (mergedCode & 131070 /* MASK_REF */) >>> 1 /* SHIFT_REF */;
    }
    function getInstructionFromIcuCreateOpCode(mergedCode) {
        return mergedCode & 1 /* MASK_INSTRUCTION */;
    }
    function icuCreateOpCode(opCode, parentIdx, refIdx) {
        ngDevMode && assertGreaterThanOrEqual(parentIdx, 0, 'Missing parent index');
        ngDevMode && assertGreaterThan(refIdx, 0, 'Missing ref index');
        return opCode | parentIdx << 17 /* SHIFT_PARENT */ | refIdx << 1 /* SHIFT_REF */;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Keep track of which input bindings in `ɵɵi18nExp` have changed.
     *
     * This is used to efficiently update expressions in i18n only when the corresponding input has
     * changed.
     *
     * 1) Each bit represents which of the `ɵɵi18nExp` has changed.
     * 2) There are 32 bits allowed in JS.
     * 3) Bit 32 is special as it is shared for all changes past 32. (In other words if you have more
     * than 32 `ɵɵi18nExp` then all changes past 32nd `ɵɵi18nExp` will be mapped to same bit. This means
     * that we may end up changing more than we need to. But i18n expressions with 32 bindings is rare
     * so in practice it should not be an issue.)
     */
    var changeMask = 0;
    /**
     * Keeps track of which bit needs to be updated in `changeMask`
     *
     * This value gets incremented on every call to `ɵɵi18nExp`
     */
    var changeMaskCounter = 0;
    /**
     * Keep track of which input bindings in `ɵɵi18nExp` have changed.
     *
     * `setMaskBit` gets invoked by each call to `ɵɵi18nExp`.
     *
     * @param hasChange did `ɵɵi18nExp` detect a change.
     */
    function setMaskBit(hasChange) {
        if (hasChange) {
            changeMask = changeMask | (1 << Math.min(changeMaskCounter, 31));
        }
        changeMaskCounter++;
    }
    function applyI18n(tView, lView, index) {
        if (changeMaskCounter > 0) {
            ngDevMode && assertDefined(tView, "tView should be defined");
            var tI18n = tView.data[index];
            // When `index` points to an `ɵɵi18nAttributes` then we have an array otherwise `TI18n`
            var updateOpCodes = Array.isArray(tI18n) ? tI18n : tI18n.update;
            var bindingsStartIndex = getBindingIndex() - changeMaskCounter - 1;
            applyUpdateOpCodes(tView, lView, updateOpCodes, bindingsStartIndex, changeMask);
        }
        // Reset changeMask & maskBit to default for the next update cycle
        changeMask = 0;
        changeMaskCounter = 0;
    }
    /**
     * Apply `I18nCreateOpCodes` op-codes as stored in `TI18n.create`.
     *
     * Creates text (and comment) nodes which are internationalized.
     *
     * @param lView Current lView
     * @param createOpCodes Set of op-codes to apply
     * @param parentRNode Parent node (so that direct children can be added eagerly) or `null` if it is
     *     a root node.
     * @param insertInFrontOf DOM node that should be used as an anchor.
     */
    function applyCreateOpCodes(lView, createOpCodes, parentRNode, insertInFrontOf) {
        var renderer = lView[RENDERER];
        for (var i = 0; i < createOpCodes.length; i++) {
            var opCode = createOpCodes[i++];
            var text = createOpCodes[i];
            var isComment = (opCode & I18nCreateOpCode.COMMENT) === I18nCreateOpCode.COMMENT;
            var appendNow = (opCode & I18nCreateOpCode.APPEND_EAGERLY) === I18nCreateOpCode.APPEND_EAGERLY;
            var index = opCode >>> I18nCreateOpCode.SHIFT;
            var rNode = lView[index];
            if (rNode === null) {
                // We only create new DOM nodes if they don't already exist: If ICU switches case back to a
                // case which was already instantiated, no need to create new DOM nodes.
                rNode = lView[index] =
                    isComment ? renderer.createComment(text) : createTextNode(renderer, text);
            }
            if (appendNow && parentRNode !== null) {
                nativeInsertBefore(renderer, parentRNode, rNode, insertInFrontOf, false);
            }
        }
    }
    /**
     * Apply `I18nMutateOpCodes` OpCodes.
     *
     * @param tView Current `TView`
     * @param mutableOpCodes Mutable OpCodes to process
     * @param lView Current `LView`
     * @param anchorRNode place where the i18n node should be inserted.
     */
    function applyMutableOpCodes(tView, mutableOpCodes, lView, anchorRNode) {
        ngDevMode && assertDomNode(anchorRNode);
        var renderer = lView[RENDERER];
        // `rootIdx` represents the node into which all inserts happen.
        var rootIdx = null;
        // `rootRNode` represents the real node into which we insert. This can be different from
        // `lView[rootIdx]` if we have projection.
        //  - null we don't have a parent (as can be the case in when we are inserting into a root of
        //    LView which has no parent.)
        //  - `RElement` The element representing the root after taking projection into account.
        var rootRNode;
        for (var i = 0; i < mutableOpCodes.length; i++) {
            var opCode = mutableOpCodes[i];
            if (typeof opCode == 'string') {
                var textNodeIndex = mutableOpCodes[++i];
                if (lView[textNodeIndex] === null) {
                    ngDevMode && ngDevMode.rendererCreateTextNode++;
                    ngDevMode && assertIndexInRange(lView, textNodeIndex);
                    lView[textNodeIndex] = createTextNode(renderer, opCode);
                }
            }
            else if (typeof opCode == 'number') {
                switch (opCode & 1 /* MASK_INSTRUCTION */) {
                    case 0 /* AppendChild */:
                        var parentIdx = getParentFromIcuCreateOpCode(opCode);
                        if (rootIdx === null) {
                            // The first operation should save the `rootIdx` because the first operation
                            // must insert into the root. (Only subsequent operations can insert into a dynamic
                            // parent)
                            rootIdx = parentIdx;
                            rootRNode = nativeParentNode(renderer, anchorRNode);
                        }
                        var insertInFrontOf = void 0;
                        var parentRNode = void 0;
                        if (parentIdx === rootIdx) {
                            insertInFrontOf = anchorRNode;
                            parentRNode = rootRNode;
                        }
                        else {
                            insertInFrontOf = null;
                            parentRNode = unwrapRNode(lView[parentIdx]);
                        }
                        // FIXME(misko): Refactor with `processI18nText`
                        if (parentRNode !== null) {
                            // This can happen if the `LView` we are adding to is not attached to a parent `LView`.
                            // In such a case there is no "root" we can attach to. This is fine, as we still need to
                            // create the elements. When the `LView` gets later added to a parent these "root" nodes
                            // get picked up and added.
                            ngDevMode && assertDomNode(parentRNode);
                            var refIdx = getRefFromIcuCreateOpCode(opCode);
                            ngDevMode && assertGreaterThan(refIdx, HEADER_OFFSET, 'Missing ref');
                            // `unwrapRNode` is not needed here as all of these point to RNodes as part of the i18n
                            // which can't have components.
                            var child = lView[refIdx];
                            ngDevMode && assertDomNode(child);
                            nativeInsertBefore(renderer, parentRNode, child, insertInFrontOf, false);
                            var tIcu = getTIcu(tView, refIdx);
                            if (tIcu !== null && typeof tIcu === 'object') {
                                // If we just added a comment node which has ICU then that ICU may have already been
                                // rendered and therefore we need to re-add it here.
                                ngDevMode && assertTIcu(tIcu);
                                var caseIndex = getCurrentICUCaseIndex(tIcu, lView);
                                if (caseIndex !== null) {
                                    applyMutableOpCodes(tView, tIcu.create[caseIndex], lView, lView[tIcu.anchorIdx]);
                                }
                            }
                        }
                        break;
                    case 1 /* Attr */:
                        var elementNodeIndex = opCode >>> 1 /* SHIFT_REF */;
                        var attrName = mutableOpCodes[++i];
                        var attrValue = mutableOpCodes[++i];
                        // This code is used for ICU expressions only, since we don't support
                        // directives/components in ICUs, we don't need to worry about inputs here
                        setElementAttribute(renderer, getNativeByIndex(elementNodeIndex, lView), null, null, attrName, attrValue, null);
                        break;
                    default:
                        throw new Error("Unable to determine the type of mutate operation for \"" + opCode + "\"");
                }
            }
            else {
                switch (opCode) {
                    case ICU_MARKER:
                        var commentValue = mutableOpCodes[++i];
                        var commentNodeIndex = mutableOpCodes[++i];
                        if (lView[commentNodeIndex] === null) {
                            ngDevMode &&
                                assertEqual(typeof commentValue, 'string', "Expected \"" + commentValue + "\" to be a comment node value");
                            ngDevMode && ngDevMode.rendererCreateComment++;
                            ngDevMode && assertIndexInExpandoRange(lView, commentNodeIndex);
                            var commentRNode = lView[commentNodeIndex] =
                                createCommentNode(renderer, commentValue);
                            // FIXME(misko): Attaching patch data is only needed for the root (Also add tests)
                            attachPatchData(commentRNode, lView);
                        }
                        break;
                    case ELEMENT_MARKER:
                        var tagName = mutableOpCodes[++i];
                        var elementNodeIndex = mutableOpCodes[++i];
                        if (lView[elementNodeIndex] === null) {
                            ngDevMode &&
                                assertEqual(typeof tagName, 'string', "Expected \"" + tagName + "\" to be an element node tag name");
                            ngDevMode && ngDevMode.rendererCreateElement++;
                            ngDevMode && assertIndexInExpandoRange(lView, elementNodeIndex);
                            var elementRNode = lView[elementNodeIndex] =
                                createElementNode(renderer, tagName, null);
                            // FIXME(misko): Attaching patch data is only needed for the root (Also add tests)
                            attachPatchData(elementRNode, lView);
                        }
                        break;
                    default:
                        ngDevMode &&
                            throwError("Unable to determine the type of mutate operation for \"" + opCode + "\"");
                }
            }
        }
    }
    /**
     * Apply `I18nUpdateOpCodes` OpCodes
     *
     * @param tView Current `TView`
     * @param lView Current `LView`
     * @param updateOpCodes OpCodes to process
     * @param bindingsStartIndex Location of the first `ɵɵi18nApply`
     * @param changeMask Each bit corresponds to a `ɵɵi18nExp` (Counting backwards from
     *     `bindingsStartIndex`)
     */
    function applyUpdateOpCodes(tView, lView, updateOpCodes, bindingsStartIndex, changeMask) {
        for (var i = 0; i < updateOpCodes.length; i++) {
            // bit code to check if we should apply the next update
            var checkBit = updateOpCodes[i];
            // Number of opCodes to skip until next set of update codes
            var skipCodes = updateOpCodes[++i];
            if (checkBit & changeMask) {
                // The value has been updated since last checked
                var value = '';
                for (var j = i + 1; j <= (i + skipCodes); j++) {
                    var opCode = updateOpCodes[j];
                    if (typeof opCode == 'string') {
                        value += opCode;
                    }
                    else if (typeof opCode == 'number') {
                        if (opCode < 0) {
                            // Negative opCode represent `i18nExp` values offset.
                            value += renderStringify(lView[bindingsStartIndex - opCode]);
                        }
                        else {
                            var nodeIndex = (opCode >>> 2 /* SHIFT_REF */);
                            switch (opCode & 3 /* MASK_OPCODE */) {
                                case 1 /* Attr */:
                                    var propName = updateOpCodes[++j];
                                    var sanitizeFn = updateOpCodes[++j];
                                    var tNodeOrTagName = tView.data[nodeIndex];
                                    ngDevMode && assertDefined(tNodeOrTagName, 'Experting TNode or string');
                                    if (typeof tNodeOrTagName === 'string') {
                                        // IF we don't have a `TNode`, then we are an element in ICU (as ICU content does
                                        // not have TNode), in which case we know that there are no directives, and hence
                                        // we use attribute setting.
                                        setElementAttribute(lView[RENDERER], lView[nodeIndex], null, tNodeOrTagName, propName, value, sanitizeFn);
                                    }
                                    else {
                                        elementPropertyInternal(tView, tNodeOrTagName, lView, propName, value, lView[RENDERER], sanitizeFn, false);
                                    }
                                    break;
                                case 0 /* Text */:
                                    var rText = lView[nodeIndex];
                                    rText !== null && updateTextNode(lView[RENDERER], rText, value);
                                    break;
                                case 2 /* IcuSwitch */:
                                    applyIcuSwitchCase(tView, getTIcu(tView, nodeIndex), lView, value);
                                    break;
                                case 3 /* IcuUpdate */:
                                    applyIcuUpdateCase(tView, getTIcu(tView, nodeIndex), bindingsStartIndex, lView);
                                    break;
                            }
                        }
                    }
                }
            }
            else {
                var opCode = updateOpCodes[i + 1];
                if (opCode > 0 && (opCode & 3 /* MASK_OPCODE */) === 3 /* IcuUpdate */) {
                    // Special case for the `icuUpdateCase`. It could be that the mask did not match, but
                    // we still need to execute `icuUpdateCase` because the case has changed recently due to
                    // previous `icuSwitchCase` instruction. (`icuSwitchCase` and `icuUpdateCase` always come in
                    // pairs.)
                    var nodeIndex = (opCode >>> 2 /* SHIFT_REF */);
                    var tIcu = getTIcu(tView, nodeIndex);
                    var currentIndex = lView[tIcu.currentCaseLViewIndex];
                    if (currentIndex < 0) {
                        applyIcuUpdateCase(tView, tIcu, bindingsStartIndex, lView);
                    }
                }
            }
            i += skipCodes;
        }
    }
    /**
     * Apply OpCodes associated with updating an existing ICU.
     *
     * @param tView Current `TView`
     * @param tIcu Current `TIcu`
     * @param bindingsStartIndex Location of the first `ɵɵi18nApply`
     * @param lView Current `LView`
     */
    function applyIcuUpdateCase(tView, tIcu, bindingsStartIndex, lView) {
        ngDevMode && assertIndexInRange(lView, tIcu.currentCaseLViewIndex);
        var activeCaseIndex = lView[tIcu.currentCaseLViewIndex];
        if (activeCaseIndex !== null) {
            var mask = changeMask;
            if (activeCaseIndex < 0) {
                // Clear the flag.
                // Negative number means that the ICU was freshly created and we need to force the update.
                activeCaseIndex = lView[tIcu.currentCaseLViewIndex] = ~activeCaseIndex;
                // -1 is same as all bits on, which simulates creation since it marks all bits dirty
                mask = -1;
            }
            applyUpdateOpCodes(tView, lView, tIcu.update[activeCaseIndex], bindingsStartIndex, mask);
        }
    }
    /**
     * Apply OpCodes associated with switching a case on ICU.
     *
     * This involves tearing down existing case and than building up a new case.
     *
     * @param tView Current `TView`
     * @param tIcu Current `TIcu`
     * @param lView Current `LView`
     * @param value Value of the case to update to.
     */
    function applyIcuSwitchCase(tView, tIcu, lView, value) {
        // Rebuild a new case for this ICU
        var caseIndex = getCaseIndex(tIcu, value);
        var activeCaseIndex = getCurrentICUCaseIndex(tIcu, lView);
        if (activeCaseIndex !== caseIndex) {
            applyIcuSwitchCaseRemove(tView, tIcu, lView);
            lView[tIcu.currentCaseLViewIndex] = caseIndex === null ? null : ~caseIndex;
            if (caseIndex !== null) {
                // Add the nodes for the new case
                var anchorRNode = lView[tIcu.anchorIdx];
                if (anchorRNode) {
                    ngDevMode && assertDomNode(anchorRNode);
                    applyMutableOpCodes(tView, tIcu.create[caseIndex], lView, anchorRNode);
                }
            }
        }
    }
    /**
     * Apply OpCodes associated with tearing ICU case.
     *
     * This involves tearing down existing case and than building up a new case.
     *
     * @param tView Current `TView`
     * @param tIcu Current `TIcu`
     * @param lView Current `LView`
     */
    function applyIcuSwitchCaseRemove(tView, tIcu, lView) {
        var activeCaseIndex = getCurrentICUCaseIndex(tIcu, lView);
        if (activeCaseIndex !== null) {
            var removeCodes = tIcu.remove[activeCaseIndex];
            for (var i = 0; i < removeCodes.length; i++) {
                var nodeOrIcuIndex = removeCodes[i];
                if (nodeOrIcuIndex > 0) {
                    // Positive numbers are `RNode`s.
                    var rNode = getNativeByIndex(nodeOrIcuIndex, lView);
                    rNode !== null && nativeRemoveNode(lView[RENDERER], rNode);
                }
                else {
                    // Negative numbers are ICUs
                    applyIcuSwitchCaseRemove(tView, getTIcu(tView, ~nodeOrIcuIndex), lView);
                }
            }
        }
    }
    /**
     * Returns the index of the current case of an ICU expression depending on the main binding value
     *
     * @param icuExpression
     * @param bindingValue The value of the main binding used by this ICU expression
     */
    function getCaseIndex(icuExpression, bindingValue) {
        var index = icuExpression.cases.indexOf(bindingValue);
        if (index === -1) {
            switch (icuExpression.type) {
                case 1 /* plural */: {
                    var resolvedCase = getPluralCase(bindingValue, getLocaleId());
                    index = icuExpression.cases.indexOf(resolvedCase);
                    if (index === -1 && resolvedCase !== 'other') {
                        index = icuExpression.cases.indexOf('other');
                    }
                    break;
                }
                case 0 /* select */: {
                    index = icuExpression.cases.indexOf('other');
                    break;
                }
            }
        }
        return index === -1 ? null : index;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function loadIcuContainerVisitor() {
        var _stack = [];
        var _index = -1;
        var _lView;
        var _removes;
        /**
         * Retrieves a set of root nodes from `TIcu.remove`. Used by `TNodeType.ICUContainer`
         * to determine which root belong to the ICU.
         *
         * Example of usage.
         * ```
         * const nextRNode = icuContainerIteratorStart(tIcuContainerNode, lView);
         * let rNode: RNode|null;
         * while(rNode = nextRNode()) {
         *   console.log(rNode);
         * }
         * ```
         *
         * @param tIcuContainerNode Current `TIcuContainerNode`
         * @param lView `LView` where the `RNode`s should be looked up.
         */
        function icuContainerIteratorStart(tIcuContainerNode, lView) {
            _lView = lView;
            while (_stack.length)
                _stack.pop();
            ngDevMode && assertTNodeForLView(tIcuContainerNode, lView);
            enterIcu(tIcuContainerNode.value, lView);
            return icuContainerIteratorNext;
        }
        function enterIcu(tIcu, lView) {
            _index = 0;
            var currentCase = getCurrentICUCaseIndex(tIcu, lView);
            if (currentCase !== null) {
                ngDevMode && assertNumberInRange(currentCase, 0, tIcu.cases.length - 1);
                _removes = tIcu.remove[currentCase];
            }
            else {
                _removes = EMPTY_ARRAY$1;
            }
        }
        function icuContainerIteratorNext() {
            if (_index < _removes.length) {
                var removeOpCode = _removes[_index++];
                ngDevMode && assertNumber(removeOpCode, 'Expecting OpCode number');
                if (removeOpCode > 0) {
                    var rNode = _lView[removeOpCode];
                    ngDevMode && assertDomNode(rNode);
                    return rNode;
                }
                else {
                    _stack.push(_index, _removes);
                    // ICUs are represented by negative indices
                    var tIcuIndex = ~removeOpCode;
                    var tIcu = _lView[TVIEW].data[tIcuIndex];
                    ngDevMode && assertTIcu(tIcu);
                    enterIcu(tIcu, _lView);
                    return icuContainerIteratorNext();
                }
            }
            else {
                if (_stack.length === 0) {
                    return null;
                }
                else {
                    _removes = _stack.pop();
                    _index = _stack.pop();
                    return icuContainerIteratorNext();
                }
            }
        }
        return icuContainerIteratorStart;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Converts `I18nCreateOpCodes` array into a human readable format.
     *
     * This function is attached to the `I18nCreateOpCodes.debug` property if `ngDevMode` is enabled.
     * This function provides a human readable view of the opcodes. This is useful when debugging the
     * application as well as writing more readable tests.
     *
     * @param this `I18nCreateOpCodes` if attached as a method.
     * @param opcodes `I18nCreateOpCodes` if invoked as a function.
     */
    function i18nCreateOpCodesToString(opcodes) {
        var createOpCodes = opcodes || (Array.isArray(this) ? this : []);
        var lines = [];
        for (var i = 0; i < createOpCodes.length; i++) {
            var opCode = createOpCodes[i++];
            var text = createOpCodes[i];
            var isComment = (opCode & I18nCreateOpCode.COMMENT) === I18nCreateOpCode.COMMENT;
            var appendNow = (opCode & I18nCreateOpCode.APPEND_EAGERLY) === I18nCreateOpCode.APPEND_EAGERLY;
            var index = opCode >>> I18nCreateOpCode.SHIFT;
            lines.push("lView[" + index + "] = document." + (isComment ? 'createComment' : 'createText') + "(" + JSON.stringify(text) + ");");
            if (appendNow) {
                lines.push("parent.appendChild(lView[" + index + "]);");
            }
        }
        return lines;
    }
    /**
     * Converts `I18nUpdateOpCodes` array into a human readable format.
     *
     * This function is attached to the `I18nUpdateOpCodes.debug` property if `ngDevMode` is enabled.
     * This function provides a human readable view of the opcodes. This is useful when debugging the
     * application as well as writing more readable tests.
     *
     * @param this `I18nUpdateOpCodes` if attached as a method.
     * @param opcodes `I18nUpdateOpCodes` if invoked as a function.
     */
    function i18nUpdateOpCodesToString(opcodes) {
        var parser = new OpCodeParser(opcodes || (Array.isArray(this) ? this : []));
        var lines = [];
        function consumeOpCode(value) {
            var ref = value >>> 2 /* SHIFT_REF */;
            var opCode = value & 3 /* MASK_OPCODE */;
            switch (opCode) {
                case 0 /* Text */:
                    return "(lView[" + ref + "] as Text).textContent = $$$";
                case 1 /* Attr */:
                    var attrName = parser.consumeString();
                    var sanitizationFn = parser.consumeFunction();
                    var value_1 = sanitizationFn ? "(" + sanitizationFn + ")($$$)" : '$$$';
                    return "(lView[" + ref + "] as Element).setAttribute('" + attrName + "', " + value_1 + ")";
                case 2 /* IcuSwitch */:
                    return "icuSwitchCase(" + ref + ", $$$)";
                case 3 /* IcuUpdate */:
                    return "icuUpdateCase(" + ref + ")";
            }
            throw new Error('unexpected OpCode');
        }
        while (parser.hasMore()) {
            var mask = parser.consumeNumber();
            var size = parser.consumeNumber();
            var end = parser.i + size;
            var statements = [];
            var statement = '';
            while (parser.i < end) {
                var value = parser.consumeNumberOrString();
                if (typeof value === 'string') {
                    statement += value;
                }
                else if (value < 0) {
                    // Negative numbers are ref indexes
                    // Here `i` refers to current binding index. It is to signify that the value is relative,
                    // rather than absolute.
                    statement += '${lView[i' + value + ']}';
                }
                else {
                    // Positive numbers are operations.
                    var opCodeText = consumeOpCode(value);
                    statements.push(opCodeText.replace('$$$', '`' + statement + '`') + ';');
                    statement = '';
                }
            }
            lines.push("if (mask & 0b" + mask.toString(2) + ") { " + statements.join(' ') + " }");
        }
        return lines;
    }
    /**
     * Converts `I18nCreateOpCodes` array into a human readable format.
     *
     * This function is attached to the `I18nCreateOpCodes.debug` if `ngDevMode` is enabled. This
     * function provides a human readable view of the opcodes. This is useful when debugging the
     * application as well as writing more readable tests.
     *
     * @param this `I18nCreateOpCodes` if attached as a method.
     * @param opcodes `I18nCreateOpCodes` if invoked as a function.
     */
    function icuCreateOpCodesToString(opcodes) {
        var parser = new OpCodeParser(opcodes || (Array.isArray(this) ? this : []));
        var lines = [];
        function consumeOpCode(opCode) {
            var parent = getParentFromIcuCreateOpCode(opCode);
            var ref = getRefFromIcuCreateOpCode(opCode);
            switch (getInstructionFromIcuCreateOpCode(opCode)) {
                case 0 /* AppendChild */:
                    return "(lView[" + parent + "] as Element).appendChild(lView[" + lastRef + "])";
                case 1 /* Attr */:
                    return "(lView[" + ref + "] as Element).setAttribute(\"" + parser.consumeString() + "\", \"" + parser.consumeString() + "\")";
            }
            throw new Error('Unexpected OpCode: ' + getInstructionFromIcuCreateOpCode(opCode));
        }
        var lastRef = -1;
        while (parser.hasMore()) {
            var value = parser.consumeNumberStringOrMarker();
            if (value === ICU_MARKER) {
                var text = parser.consumeString();
                lastRef = parser.consumeNumber();
                lines.push("lView[" + lastRef + "] = document.createComment(\"" + text + "\")");
            }
            else if (value === ELEMENT_MARKER) {
                var text = parser.consumeString();
                lastRef = parser.consumeNumber();
                lines.push("lView[" + lastRef + "] = document.createElement(\"" + text + "\")");
            }
            else if (typeof value === 'string') {
                lastRef = parser.consumeNumber();
                lines.push("lView[" + lastRef + "] = document.createTextNode(\"" + value + "\")");
            }
            else if (typeof value === 'number') {
                var line = consumeOpCode(value);
                line && lines.push(line);
            }
            else {
                throw new Error('Unexpected value');
            }
        }
        return lines;
    }
    /**
     * Converts `I18nRemoveOpCodes` array into a human readable format.
     *
     * This function is attached to the `I18nRemoveOpCodes.debug` if `ngDevMode` is enabled. This
     * function provides a human readable view of the opcodes. This is useful when debugging the
     * application as well as writing more readable tests.
     *
     * @param this `I18nRemoveOpCodes` if attached as a method.
     * @param opcodes `I18nRemoveOpCodes` if invoked as a function.
     */
    function i18nRemoveOpCodesToString(opcodes) {
        var removeCodes = opcodes || (Array.isArray(this) ? this : []);
        var lines = [];
        for (var i = 0; i < removeCodes.length; i++) {
            var nodeOrIcuIndex = removeCodes[i];
            if (nodeOrIcuIndex > 0) {
                // Positive numbers are `RNode`s.
                lines.push("remove(lView[" + nodeOrIcuIndex + "])");
            }
            else {
                // Negative numbers are ICUs
                lines.push("removeNestedICU(" + ~nodeOrIcuIndex + ")");
            }
        }
        return lines;
    }
    var OpCodeParser = /** @class */ (function () {
        function OpCodeParser(codes) {
            this.i = 0;
            this.codes = codes;
        }
        OpCodeParser.prototype.hasMore = function () {
            return this.i < this.codes.length;
        };
        OpCodeParser.prototype.consumeNumber = function () {
            var value = this.codes[this.i++];
            assertNumber(value, 'expecting number in OpCode');
            return value;
        };
        OpCodeParser.prototype.consumeString = function () {
            var value = this.codes[this.i++];
            assertString(value, 'expecting string in OpCode');
            return value;
        };
        OpCodeParser.prototype.consumeFunction = function () {
            var value = this.codes[this.i++];
            if (value === null || typeof value === 'function') {
                return value;
            }
            throw new Error('expecting function in OpCode');
        };
        OpCodeParser.prototype.consumeNumberOrString = function () {
            var value = this.codes[this.i++];
            if (typeof value === 'string') {
                return value;
            }
            assertNumber(value, 'expecting number or string in OpCode');
            return value;
        };
        OpCodeParser.prototype.consumeNumberStringOrMarker = function () {
            var value = this.codes[this.i++];
            if (typeof value === 'string' || typeof value === 'number' || value == ICU_MARKER ||
                value == ELEMENT_MARKER) {
                return value;
            }
            assertNumber(value, 'expecting number, string, ICU_MARKER or ELEMENT_MARKER in OpCode');
            return value;
        };
        return OpCodeParser;
    }());

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var BINDING_REGEXP = /�(\d+):?\d*�/gi;
    var ICU_REGEXP = /({\s*�\d+:?\d*�\s*,\s*\S{6}\s*,[\s\S]*})/gi;
    var NESTED_ICU = /�(\d+)�/;
    var ICU_BLOCK_REGEXP = /^\s*(�\d+:?\d*�)\s*,\s*(select|plural)\s*,/;
    var MARKER = "\uFFFD";
    var SUBTEMPLATE_REGEXP = /�\/?\*(\d+:\d+)�/gi;
    var PH_REGEXP = /�(\/?[#*]\d+):?\d*�/gi;
    /**
     * Angular Dart introduced &ngsp; as a placeholder for non-removable space, see:
     * https://github.com/dart-lang/angular/blob/0bb611387d29d65b5af7f9d2515ab571fd3fbee4/_tests/test/compiler/preserve_whitespace_test.dart#L25-L32
     * In Angular Dart &ngsp; is converted to the 0xE500 PUA (Private Use Areas) unicode character
     * and later on replaced by a space. We are re-implementing the same idea here, since translations
     * might contain this special character.
     */
    var NGSP_UNICODE_REGEXP = /\uE500/g;
    function replaceNgsp(value) {
        return value.replace(NGSP_UNICODE_REGEXP, ' ');
    }
    /**
     * Create dynamic nodes from i18n translation block.
     *
     * - Text nodes are created synchronously
     * - TNodes are linked into tree lazily
     *
     * @param tView Current `TView`
     * @parentTNodeIndex index to the parent TNode of this i18n block
     * @param lView Current `LView`
     * @param index Index of `ɵɵi18nStart` instruction.
     * @param message Message to translate.
     * @param subTemplateIndex Index into the sub template of message translation. (ie in case of
     *     `ngIf`) (-1 otherwise)
     */
    function i18nStartFirstCreatePass(tView, parentTNodeIndex, lView, index, message, subTemplateIndex) {
        var rootTNode = getCurrentParentTNode();
        var createOpCodes = [];
        var updateOpCodes = [];
        var existingTNodeStack = [[]];
        if (ngDevMode) {
            attachDebugGetter(createOpCodes, i18nCreateOpCodesToString);
            attachDebugGetter(updateOpCodes, i18nUpdateOpCodesToString);
        }
        message = getTranslationForTemplate(message, subTemplateIndex);
        var msgParts = replaceNgsp(message).split(PH_REGEXP);
        for (var i = 0; i < msgParts.length; i++) {
            var value = msgParts[i];
            if ((i & 1) === 0) {
                // Even indexes are text (including bindings & ICU expressions)
                var parts = i18nParseTextIntoPartsAndICU(value);
                for (var j = 0; j < parts.length; j++) {
                    var part = parts[j];
                    if ((j & 1) === 0) {
                        // `j` is odd therefore `part` is string
                        var text = part;
                        ngDevMode && assertString(text, 'Parsed ICU part should be string');
                        if (text !== '') {
                            i18nStartFirstCreatePassProcessTextNode(tView, rootTNode, existingTNodeStack[0], createOpCodes, updateOpCodes, lView, text);
                        }
                    }
                    else {
                        // `j` is Even therefor `part` is an `ICUExpression`
                        var icuExpression = part;
                        // Verify that ICU expression has the right shape. Translations might contain invalid
                        // constructions (while original messages were correct), so ICU parsing at runtime may
                        // not succeed (thus `icuExpression` remains a string).
                        // Note: we intentionally retain the error here by not using `ngDevMode`, because
                        // the value can change based on the locale and users aren't guaranteed to hit
                        // an invalid string while they're developing.
                        if (typeof icuExpression !== 'object') {
                            throw new Error("Unable to parse ICU expression in \"" + message + "\" message.");
                        }
                        var icuContainerTNode = createTNodeAndAddOpCode(tView, rootTNode, existingTNodeStack[0], lView, createOpCodes, ngDevMode ? "ICU " + index + ":" + icuExpression.mainBinding : '', true);
                        var icuNodeIndex = icuContainerTNode.index;
                        ngDevMode &&
                            assertGreaterThanOrEqual(icuNodeIndex, HEADER_OFFSET, 'Index must be in absolute LView offset');
                        icuStart(tView, lView, updateOpCodes, parentTNodeIndex, icuExpression, icuNodeIndex);
                    }
                }
            }
            else {
                // Odd indexes are placeholders (elements and sub-templates)
                // At this point value is something like: '/#1:2' (originally coming from '�/#1:2�')
                var isClosing = value.charCodeAt(0) === 47 /* SLASH */;
                var type = value.charCodeAt(isClosing ? 1 : 0);
                ngDevMode && assertOneOf(type, 42 /* STAR */, 35 /* HASH */);
                var index_1 = HEADER_OFFSET + Number.parseInt(value.substring((isClosing ? 2 : 1)));
                if (isClosing) {
                    existingTNodeStack.shift();
                    setCurrentTNode(getCurrentParentTNode(), false);
                }
                else {
                    var tNode = createTNodePlaceholder(tView, existingTNodeStack[0], index_1);
                    existingTNodeStack.unshift([]);
                    setCurrentTNode(tNode, true);
                }
            }
        }
        tView.data[index] = {
            create: createOpCodes,
            update: updateOpCodes,
        };
    }
    /**
     * Allocate space in i18n Range add create OpCode instruction to crete a text or comment node.
     *
     * @param tView Current `TView` needed to allocate space in i18n range.
     * @param rootTNode Root `TNode` of the i18n block. This node determines if the new TNode will be
     *     added as part of the `i18nStart` instruction or as part of the `TNode.insertBeforeIndex`.
     * @param existingTNodes internal state for `addTNodeAndUpdateInsertBeforeIndex`.
     * @param lView Current `LView` needed to allocate space in i18n range.
     * @param createOpCodes Array storing `I18nCreateOpCodes` where new opCodes will be added.
     * @param text Text to be added when the `Text` or `Comment` node will be created.
     * @param isICU true if a `Comment` node for ICU (instead of `Text`) node should be created.
     */
    function createTNodeAndAddOpCode(tView, rootTNode, existingTNodes, lView, createOpCodes, text, isICU) {
        var i18nNodeIdx = allocExpando(tView, lView, 1, null);
        var opCode = i18nNodeIdx << I18nCreateOpCode.SHIFT;
        var parentTNode = getCurrentParentTNode();
        if (rootTNode === parentTNode) {
            // FIXME(misko): A null `parentTNode` should represent when we fall of the `LView` boundary.
            // (there is no parent), but in some circumstances (because we are inconsistent about how we set
            // `previousOrParentTNode`) it could point to `rootTNode` So this is a work around.
            parentTNode = null;
        }
        if (parentTNode === null) {
            // If we don't have a parent that means that we can eagerly add nodes.
            // If we have a parent than these nodes can't be added now (as the parent has not been created
            // yet) and instead the `parentTNode` is responsible for adding it. See
            // `TNode.insertBeforeIndex`
            opCode |= I18nCreateOpCode.APPEND_EAGERLY;
        }
        if (isICU) {
            opCode |= I18nCreateOpCode.COMMENT;
            ensureIcuContainerVisitorLoaded(loadIcuContainerVisitor);
        }
        createOpCodes.push(opCode, text === null ? '' : text);
        // We store `{{?}}` so that when looking at debug `TNodeType.template` we can see where the
        // bindings are.
        var tNode = createTNodeAtIndex(tView, i18nNodeIdx, isICU ? 32 /* Icu */ : 1 /* Text */, text === null ? (ngDevMode ? '{{?}}' : '') : text, null);
        addTNodeAndUpdateInsertBeforeIndex(existingTNodes, tNode);
        var tNodeIdx = tNode.index;
        setCurrentTNode(tNode, false /* Text nodes are self closing */);
        if (parentTNode !== null && rootTNode !== parentTNode) {
            // We are a child of deeper node (rather than a direct child of `i18nStart` instruction.)
            // We have to make sure to add ourselves to the parent.
            setTNodeInsertBeforeIndex(parentTNode, tNodeIdx);
        }
        return tNode;
    }
    /**
     * Processes text node in i18n block.
     *
     * Text nodes can have:
     * - Create instruction in `createOpCodes` for creating the text node.
     * - Allocate spec for text node in i18n range of `LView`
     * - If contains binding:
     *    - bindings => allocate space in i18n range of `LView` to store the binding value.
     *    - populate `updateOpCodes` with update instructions.
     *
     * @param tView Current `TView`
     * @param rootTNode Root `TNode` of the i18n block. This node determines if the new TNode will
     *     be added as part of the `i18nStart` instruction or as part of the
     *     `TNode.insertBeforeIndex`.
     * @param existingTNodes internal state for `addTNodeAndUpdateInsertBeforeIndex`.
     * @param createOpCodes Location where the creation OpCodes will be stored.
     * @param lView Current `LView`
     * @param text The translated text (which may contain binding)
     */
    function i18nStartFirstCreatePassProcessTextNode(tView, rootTNode, existingTNodes, createOpCodes, updateOpCodes, lView, text) {
        var hasBinding = text.match(BINDING_REGEXP);
        var tNode = createTNodeAndAddOpCode(tView, rootTNode, existingTNodes, lView, createOpCodes, hasBinding ? null : text, false);
        if (hasBinding) {
            generateBindingUpdateOpCodes(updateOpCodes, text, tNode.index);
        }
    }
    /**
     * See `i18nAttributes` above.
     */
    function i18nAttributesFirstPass(tView, index, values) {
        var previousElement = getCurrentTNode();
        var previousElementIndex = previousElement.index;
        var updateOpCodes = [];
        if (ngDevMode) {
            attachDebugGetter(updateOpCodes, i18nUpdateOpCodesToString);
        }
        if (tView.firstCreatePass && tView.data[index] === null) {
            for (var i = 0; i < values.length; i += 2) {
                var attrName = values[i];
                var message = values[i + 1];
                if (message !== '') {
                    // Check if attribute value contains an ICU and throw an error if that's the case.
                    // ICUs in element attributes are not supported.
                    // Note: we intentionally retain the error here by not using `ngDevMode`, because
                    // the `value` can change based on the locale and users aren't guaranteed to hit
                    // an invalid string while they're developing.
                    if (ICU_REGEXP.test(message)) {
                        throw new Error("ICU expressions are not supported in attributes. Message: \"" + message + "\".");
                    }
                    // i18n attributes that hit this code path are guaranteed to have bindings, because
                    // the compiler treats static i18n attributes as regular attribute bindings.
                    generateBindingUpdateOpCodes(updateOpCodes, message, previousElementIndex, attrName);
                }
            }
            tView.data[index] = updateOpCodes;
        }
    }
    /**
     * Generate the OpCodes to update the bindings of a string.
     *
     * @param updateOpCodes Place where the update opcodes will be stored.
     * @param str The string containing the bindings.
     * @param destinationNode Index of the destination node which will receive the binding.
     * @param attrName Name of the attribute, if the string belongs to an attribute.
     * @param sanitizeFn Sanitization function used to sanitize the string after update, if necessary.
     */
    function generateBindingUpdateOpCodes(updateOpCodes, str, destinationNode, attrName, sanitizeFn) {
        if (sanitizeFn === void 0) { sanitizeFn = null; }
        ngDevMode &&
            assertGreaterThanOrEqual(destinationNode, HEADER_OFFSET, 'Index must be in absolute LView offset');
        var maskIndex = updateOpCodes.length; // Location of mask
        var sizeIndex = maskIndex + 1; // location of size for skipping
        updateOpCodes.push(null, null); // Alloc space for mask and size
        var startIndex = maskIndex + 2; // location of first allocation.
        if (ngDevMode) {
            attachDebugGetter(updateOpCodes, i18nUpdateOpCodesToString);
        }
        var textParts = str.split(BINDING_REGEXP);
        var mask = 0;
        for (var j = 0; j < textParts.length; j++) {
            var textValue = textParts[j];
            if (j & 1) {
                // Odd indexes are bindings
                var bindingIndex = parseInt(textValue, 10);
                updateOpCodes.push(-1 - bindingIndex);
                mask = mask | toMaskBit(bindingIndex);
            }
            else if (textValue !== '') {
                // Even indexes are text
                updateOpCodes.push(textValue);
            }
        }
        updateOpCodes.push(destinationNode << 2 /* SHIFT_REF */ |
            (attrName ? 1 /* Attr */ : 0 /* Text */));
        if (attrName) {
            updateOpCodes.push(attrName, sanitizeFn);
        }
        updateOpCodes[maskIndex] = mask;
        updateOpCodes[sizeIndex] = updateOpCodes.length - startIndex;
        return mask;
    }
    /**
     * Convert binding index to mask bit.
     *
     * Each index represents a single bit on the bit-mask. Because bit-mask only has 32 bits, we make
     * the 32nd bit share all masks for all bindings higher than 32. Since it is extremely rare to
     * have more than 32 bindings this will be hit very rarely. The downside of hitting this corner
     * case is that we will execute binding code more often than necessary. (penalty of performance)
     */
    function toMaskBit(bindingIndex) {
        return 1 << Math.min(bindingIndex, 31);
    }
    function isRootTemplateMessage(subTemplateIndex) {
        return subTemplateIndex === -1;
    }
    /**
     * Removes everything inside the sub-templates of a message.
     */
    function removeInnerTemplateTranslation(message) {
        var match;
        var res = '';
        var index = 0;
        var inTemplate = false;
        var tagMatched;
        while ((match = SUBTEMPLATE_REGEXP.exec(message)) !== null) {
            if (!inTemplate) {
                res += message.substring(index, match.index + match[0].length);
                tagMatched = match[1];
                inTemplate = true;
            }
            else {
                if (match[0] === MARKER + "/*" + tagMatched + MARKER) {
                    index = match.index;
                    inTemplate = false;
                }
            }
        }
        ngDevMode &&
            assertEqual(inTemplate, false, "Tag mismatch: unable to find the end of the sub-template in the translation \"" + message + "\"");
        res += message.substr(index);
        return res;
    }
    /**
     * Extracts a part of a message and removes the rest.
     *
     * This method is used for extracting a part of the message associated with a template. A
     * translated message can span multiple templates.
     *
     * Example:
     * ```
     * <div i18n>Translate <span *ngIf>me</span>!</div>
     * ```
     *
     * @param message The message to crop
     * @param subTemplateIndex Index of the sub-template to extract. If undefined it returns the
     * external template and removes all sub-templates.
     */
    function getTranslationForTemplate(message, subTemplateIndex) {
        if (isRootTemplateMessage(subTemplateIndex)) {
            // We want the root template message, ignore all sub-templates
            return removeInnerTemplateTranslation(message);
        }
        else {
            // We want a specific sub-template
            var start = message.indexOf(":" + subTemplateIndex + MARKER) + 2 + subTemplateIndex.toString().length;
            var end = message.search(new RegExp(MARKER + "\\/\\*\\d+:" + subTemplateIndex + MARKER));
            return removeInnerTemplateTranslation(message.substring(start, end));
        }
    }
    /**
     * Generate the OpCodes for ICU expressions.
     *
     * @param icuExpression
     * @param index Index where the anchor is stored and an optional `TIcuContainerNode`
     *   - `lView[anchorIdx]` points to a `Comment` node representing the anchor for the ICU.
     *   - `tView.data[anchorIdx]` points to the `TIcuContainerNode` if ICU is root (`null` otherwise)
     */
    function icuStart(tView, lView, updateOpCodes, parentIdx, icuExpression, anchorIdx) {
        ngDevMode && assertDefined(icuExpression, 'ICU expression must be defined');
        var bindingMask = 0;
        var tIcu = {
            type: icuExpression.type,
            currentCaseLViewIndex: allocExpando(tView, lView, 1, null),
            anchorIdx: anchorIdx,
            cases: [],
            create: [],
            remove: [],
            update: []
        };
        addUpdateIcuSwitch(updateOpCodes, icuExpression, anchorIdx);
        setTIcu(tView, anchorIdx, tIcu);
        var values = icuExpression.values;
        for (var i = 0; i < values.length; i++) {
            // Each value is an array of strings & other ICU expressions
            var valueArr = values[i];
            var nestedIcus = [];
            for (var j = 0; j < valueArr.length; j++) {
                var value = valueArr[j];
                if (typeof value !== 'string') {
                    // It is an nested ICU expression
                    var icuIndex = nestedIcus.push(value) - 1;
                    // Replace nested ICU expression by a comment node
                    valueArr[j] = "<!--\uFFFD" + icuIndex + "\uFFFD-->";
                }
            }
            bindingMask = parseIcuCase(tView, tIcu, lView, updateOpCodes, parentIdx, icuExpression.cases[i], valueArr.join(''), nestedIcus) |
                bindingMask;
        }
        if (bindingMask) {
            addUpdateIcuUpdate(updateOpCodes, bindingMask, anchorIdx);
        }
    }
    /**
     * Parses text containing an ICU expression and produces a JSON object for it.
     * Original code from closure library, modified for Angular.
     *
     * @param pattern Text containing an ICU expression that needs to be parsed.
     *
     */
    function parseICUBlock(pattern) {
        var cases = [];
        var values = [];
        var icuType = 1 /* plural */;
        var mainBinding = 0;
        pattern = pattern.replace(ICU_BLOCK_REGEXP, function (str, binding, type) {
            if (type === 'select') {
                icuType = 0 /* select */;
            }
            else {
                icuType = 1 /* plural */;
            }
            mainBinding = parseInt(binding.substr(1), 10);
            return '';
        });
        var parts = i18nParseTextIntoPartsAndICU(pattern);
        // Looking for (key block)+ sequence. One of the keys has to be "other".
        for (var pos = 0; pos < parts.length;) {
            var key = parts[pos++].trim();
            if (icuType === 1 /* plural */) {
                // Key can be "=x", we just want "x"
                key = key.replace(/\s*(?:=)?(\w+)\s*/, '$1');
            }
            if (key.length) {
                cases.push(key);
            }
            var blocks = i18nParseTextIntoPartsAndICU(parts[pos++]);
            if (cases.length > values.length) {
                values.push(blocks);
            }
        }
        // TODO(ocombe): support ICU expressions in attributes, see #21615
        return { type: icuType, mainBinding: mainBinding, cases: cases, values: values };
    }
    /**
     * Breaks pattern into strings and top level {...} blocks.
     * Can be used to break a message into text and ICU expressions, or to break an ICU expression
     * into keys and cases. Original code from closure library, modified for Angular.
     *
     * @param pattern (sub)Pattern to be broken.
     * @returns An `Array<string|IcuExpression>` where:
     *   - odd positions: `string` => text between ICU expressions
     *   - even positions: `ICUExpression` => ICU expression parsed into `ICUExpression` record.
     */
    function i18nParseTextIntoPartsAndICU(pattern) {
        if (!pattern) {
            return [];
        }
        var prevPos = 0;
        var braceStack = [];
        var results = [];
        var braces = /[{}]/g;
        // lastIndex doesn't get set to 0 so we have to.
        braces.lastIndex = 0;
        var match;
        while (match = braces.exec(pattern)) {
            var pos = match.index;
            if (match[0] == '}') {
                braceStack.pop();
                if (braceStack.length == 0) {
                    // End of the block.
                    var block = pattern.substring(prevPos, pos);
                    if (ICU_BLOCK_REGEXP.test(block)) {
                        results.push(parseICUBlock(block));
                    }
                    else {
                        results.push(block);
                    }
                    prevPos = pos + 1;
                }
            }
            else {
                if (braceStack.length == 0) {
                    var substring_1 = pattern.substring(prevPos, pos);
                    results.push(substring_1);
                    prevPos = pos + 1;
                }
                braceStack.push('{');
            }
        }
        var substring = pattern.substring(prevPos);
        results.push(substring);
        return results;
    }
    /**
     * Parses a node, its children and its siblings, and generates the mutate & update OpCodes.
     *
     */
    function parseIcuCase(tView, tIcu, lView, updateOpCodes, parentIdx, caseName, unsafeCaseHtml, nestedIcus) {
        var create = [];
        var remove = [];
        var update = [];
        if (ngDevMode) {
            attachDebugGetter(create, icuCreateOpCodesToString);
            attachDebugGetter(remove, i18nRemoveOpCodesToString);
            attachDebugGetter(update, i18nUpdateOpCodesToString);
        }
        tIcu.cases.push(caseName);
        tIcu.create.push(create);
        tIcu.remove.push(remove);
        tIcu.update.push(update);
        var inertBodyHelper = getInertBodyHelper(getDocument());
        var inertBodyElement = inertBodyHelper.getInertBodyElement(unsafeCaseHtml);
        ngDevMode && assertDefined(inertBodyElement, 'Unable to generate inert body element');
        var inertRootNode = getTemplateContent(inertBodyElement) || inertBodyElement;
        if (inertRootNode) {
            return walkIcuTree(tView, tIcu, lView, updateOpCodes, create, remove, update, inertRootNode, parentIdx, nestedIcus, 0);
        }
        else {
            return 0;
        }
    }
    function walkIcuTree(tView, tIcu, lView, sharedUpdateOpCodes, create, remove, update, parentNode, parentIdx, nestedIcus, depth) {
        var bindingMask = 0;
        var currentNode = parentNode.firstChild;
        while (currentNode) {
            var newIndex = allocExpando(tView, lView, 1, null);
            switch (currentNode.nodeType) {
                case Node.ELEMENT_NODE:
                    var element = currentNode;
                    var tagName = element.tagName.toLowerCase();
                    if (VALID_ELEMENTS.hasOwnProperty(tagName)) {
                        addCreateNodeAndAppend(create, ELEMENT_MARKER, tagName, parentIdx, newIndex);
                        tView.data[newIndex] = tagName;
                        var elAttrs = element.attributes;
                        for (var i = 0; i < elAttrs.length; i++) {
                            var attr = elAttrs.item(i);
                            var lowerAttrName = attr.name.toLowerCase();
                            var hasBinding_1 = !!attr.value.match(BINDING_REGEXP);
                            // we assume the input string is safe, unless it's using a binding
                            if (hasBinding_1) {
                                if (VALID_ATTRS.hasOwnProperty(lowerAttrName)) {
                                    if (URI_ATTRS[lowerAttrName]) {
                                        generateBindingUpdateOpCodes(update, attr.value, newIndex, attr.name, _sanitizeUrl);
                                    }
                                    else if (SRCSET_ATTRS[lowerAttrName]) {
                                        generateBindingUpdateOpCodes(update, attr.value, newIndex, attr.name, sanitizeSrcset);
                                    }
                                    else {
                                        generateBindingUpdateOpCodes(update, attr.value, newIndex, attr.name);
                                    }
                                }
                                else {
                                    ngDevMode &&
                                        console.warn("WARNING: ignoring unsafe attribute value " +
                                            (lowerAttrName + " on element " + tagName + " ") +
                                            "(see https://g.co/ng/security#xss)");
                                }
                            }
                            else {
                                addCreateAttribute(create, newIndex, attr);
                            }
                        }
                        // Parse the children of this node (if any)
                        bindingMask = walkIcuTree(tView, tIcu, lView, sharedUpdateOpCodes, create, remove, update, currentNode, newIndex, nestedIcus, depth + 1) |
                            bindingMask;
                        addRemoveNode(remove, newIndex, depth);
                    }
                    break;
                case Node.TEXT_NODE:
                    var value = currentNode.textContent || '';
                    var hasBinding = value.match(BINDING_REGEXP);
                    addCreateNodeAndAppend(create, null, hasBinding ? '' : value, parentIdx, newIndex);
                    addRemoveNode(remove, newIndex, depth);
                    if (hasBinding) {
                        bindingMask = generateBindingUpdateOpCodes(update, value, newIndex) | bindingMask;
                    }
                    break;
                case Node.COMMENT_NODE:
                    // Check if the comment node is a placeholder for a nested ICU
                    var isNestedIcu = NESTED_ICU.exec(currentNode.textContent || '');
                    if (isNestedIcu) {
                        var nestedIcuIndex = parseInt(isNestedIcu[1], 10);
                        var icuExpression = nestedIcus[nestedIcuIndex];
                        // Create the comment node that will anchor the ICU expression
                        addCreateNodeAndAppend(create, ICU_MARKER, ngDevMode ? "nested ICU " + nestedIcuIndex : '', parentIdx, newIndex);
                        icuStart(tView, lView, sharedUpdateOpCodes, parentIdx, icuExpression, newIndex);
                        addRemoveNestedIcu(remove, newIndex, depth);
                    }
                    break;
            }
            currentNode = currentNode.nextSibling;
        }
        return bindingMask;
    }
    function addRemoveNode(remove, index, depth) {
        if (depth === 0) {
            remove.push(index);
        }
    }
    function addRemoveNestedIcu(remove, index, depth) {
        if (depth === 0) {
            remove.push(~index); // remove ICU at `index`
            remove.push(index); // remove ICU comment at `index`
        }
    }
    function addUpdateIcuSwitch(update, icuExpression, index) {
        update.push(toMaskBit(icuExpression.mainBinding), 2, -1 - icuExpression.mainBinding, index << 2 /* SHIFT_REF */ | 2 /* IcuSwitch */);
    }
    function addUpdateIcuUpdate(update, bindingMask, index) {
        update.push(bindingMask, 1, index << 2 /* SHIFT_REF */ | 3 /* IcuUpdate */);
    }
    function addCreateNodeAndAppend(create, marker, text, appendToParentIdx, createAtIdx) {
        if (marker !== null) {
            create.push(marker);
        }
        create.push(text, createAtIdx, icuCreateOpCode(0 /* AppendChild */, appendToParentIdx, createAtIdx));
    }
    function addCreateAttribute(create, newIndex, attr) {
        create.push(newIndex << 1 /* SHIFT_REF */ | 1 /* Attr */, attr.name, attr.value);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    // i18nPostprocess consts
    var ROOT_TEMPLATE_ID = 0;
    var PP_MULTI_VALUE_PLACEHOLDERS_REGEXP = /\[(�.+?�?)\]/;
    var PP_PLACEHOLDERS_REGEXP = /\[(�.+?�?)\]|(�\/?\*\d+:\d+�)/g;
    var PP_ICU_VARS_REGEXP = /({\s*)(VAR_(PLURAL|SELECT)(_\d+)?)(\s*,)/g;
    var PP_ICU_PLACEHOLDERS_REGEXP = /{([A-Z0-9_]+)}/g;
    var PP_ICUS_REGEXP = /�I18N_EXP_(ICU(_\d+)?)�/g;
    var PP_CLOSE_TEMPLATE_REGEXP = /\/\*/;
    var PP_TEMPLATE_ID_REGEXP = /\d+\:(\d+)/;
    /**
     * Handles message string post-processing for internationalization.
     *
     * Handles message string post-processing by transforming it from intermediate
     * format (that might contain some markers that we need to replace) to the final
     * form, consumable by i18nStart instruction. Post processing steps include:
     *
     * 1. Resolve all multi-value cases (like [�*1:1��#2:1�|�#4:1�|�5�])
     * 2. Replace all ICU vars (like "VAR_PLURAL")
     * 3. Replace all placeholders used inside ICUs in a form of {PLACEHOLDER}
     * 4. Replace all ICU references with corresponding values (like �ICU_EXP_ICU_1�)
     *    in case multiple ICUs have the same placeholder name
     *
     * @param message Raw translation string for post processing
     * @param replacements Set of replacements that should be applied
     *
     * @returns Transformed string that can be consumed by i18nStart instruction
     *
     * @codeGenApi
     */
    function i18nPostprocess(message, replacements) {
        if (replacements === void 0) { replacements = {}; }
        /**
         * Step 1: resolve all multi-value placeholders like [�#5�|�*1:1��#2:1�|�#4:1�]
         *
         * Note: due to the way we process nested templates (BFS), multi-value placeholders are typically
         * grouped by templates, for example: [�#5�|�#6�|�#1:1�|�#3:2�] where �#5� and �#6� belong to root
         * template, �#1:1� belong to nested template with index 1 and �#1:2� - nested template with index
         * 3. However in real templates the order might be different: i.e. �#1:1� and/or �#3:2� may go in
         * front of �#6�. The post processing step restores the right order by keeping track of the
         * template id stack and looks for placeholders that belong to the currently active template.
         */
        var result = message;
        if (PP_MULTI_VALUE_PLACEHOLDERS_REGEXP.test(message)) {
            var matches_1 = {};
            var templateIdsStack_1 = [ROOT_TEMPLATE_ID];
            result = result.replace(PP_PLACEHOLDERS_REGEXP, function (m, phs, tmpl) {
                var content = phs || tmpl;
                var placeholders = matches_1[content] || [];
                if (!placeholders.length) {
                    content.split('|').forEach(function (placeholder) {
                        var match = placeholder.match(PP_TEMPLATE_ID_REGEXP);
                        var templateId = match ? parseInt(match[1], 10) : ROOT_TEMPLATE_ID;
                        var isCloseTemplateTag = PP_CLOSE_TEMPLATE_REGEXP.test(placeholder);
                        placeholders.push([templateId, isCloseTemplateTag, placeholder]);
                    });
                    matches_1[content] = placeholders;
                }
                if (!placeholders.length) {
                    throw new Error("i18n postprocess: unmatched placeholder - " + content);
                }
                var currentTemplateId = templateIdsStack_1[templateIdsStack_1.length - 1];
                var idx = 0;
                // find placeholder index that matches current template id
                for (var i = 0; i < placeholders.length; i++) {
                    if (placeholders[i][0] === currentTemplateId) {
                        idx = i;
                        break;
                    }
                }
                // update template id stack based on the current tag extracted
                var _a = __read(placeholders[idx], 3), templateId = _a[0], isCloseTemplateTag = _a[1], placeholder = _a[2];
                if (isCloseTemplateTag) {
                    templateIdsStack_1.pop();
                }
                else if (currentTemplateId !== templateId) {
                    templateIdsStack_1.push(templateId);
                }
                // remove processed tag from the list
                placeholders.splice(idx, 1);
                return placeholder;
            });
        }
        // return current result if no replacements specified
        if (!Object.keys(replacements).length) {
            return result;
        }
        /**
         * Step 2: replace all ICU vars (like "VAR_PLURAL")
         */
        result = result.replace(PP_ICU_VARS_REGEXP, function (match, start, key, _type, _idx, end) {
            return replacements.hasOwnProperty(key) ? "" + start + replacements[key] + end : match;
        });
        /**
         * Step 3: replace all placeholders used inside ICUs in a form of {PLACEHOLDER}
         */
        result = result.replace(PP_ICU_PLACEHOLDERS_REGEXP, function (match, key) {
            return replacements.hasOwnProperty(key) ? replacements[key] : match;
        });
        /**
         * Step 4: replace all ICU references with corresponding values (like �ICU_EXP_ICU_1�) in case
         * multiple ICUs have the same placeholder name
         */
        result = result.replace(PP_ICUS_REGEXP, function (match, key) {
            if (replacements.hasOwnProperty(key)) {
                var list = replacements[key];
                if (!list.length) {
                    throw new Error("i18n postprocess: unmatched ICU - " + match + " with key: " + key);
                }
                return list.shift();
            }
            return match;
        });
        return result;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Marks a block of text as translatable.
     *
     * The instructions `i18nStart` and `i18nEnd` mark the translation block in the template.
     * The translation `message` is the value which is locale specific. The translation string may
     * contain placeholders which associate inner elements and sub-templates within the translation.
     *
     * The translation `message` placeholders are:
     * - `�{index}(:{block})�`: *Binding Placeholder*: Marks a location where an expression will be
     *   interpolated into. The placeholder `index` points to the expression binding index. An optional
     *   `block` that matches the sub-template in which it was declared.
     * - `�#{index}(:{block})�`/`�/#{index}(:{block})�`: *Element Placeholder*:  Marks the beginning
     *   and end of DOM element that were embedded in the original translation block. The placeholder
     *   `index` points to the element index in the template instructions set. An optional `block` that
     *   matches the sub-template in which it was declared.
     * - `�*{index}:{block}�`/`�/*{index}:{block}�`: *Sub-template Placeholder*: Sub-templates must be
     *   split up and translated separately in each angular template function. The `index` points to the
     *   `template` instruction index. A `block` that matches the sub-template in which it was declared.
     *
     * @param index A unique index of the translation in the static block.
     * @param messageIndex An index of the translation message from the `def.consts` array.
     * @param subTemplateIndex Optional sub-template index in the `message`.
     *
     * @codeGenApi
     */
    function ɵɵi18nStart(index, messageIndex, subTemplateIndex) {
        if (subTemplateIndex === void 0) { subTemplateIndex = -1; }
        var tView = getTView();
        var lView = getLView();
        var adjustedIndex = HEADER_OFFSET + index;
        ngDevMode && assertDefined(tView, "tView should be defined");
        var message = getConstant(tView.consts, messageIndex);
        var parentTNode = getCurrentParentTNode();
        if (tView.firstCreatePass) {
            i18nStartFirstCreatePass(tView, parentTNode === null ? 0 : parentTNode.index, lView, adjustedIndex, message, subTemplateIndex);
        }
        var tI18n = tView.data[adjustedIndex];
        var sameViewParentTNode = parentTNode === lView[T_HOST] ? null : parentTNode;
        var parentRNode = getClosestRElement(tView, sameViewParentTNode, lView);
        // If `parentTNode` is an `ElementContainer` than it has `<!--ng-container--->`.
        // When we do inserts we have to make sure to insert in front of `<!--ng-container--->`.
        var insertInFrontOf = parentTNode && (parentTNode.type & 8 /* ElementContainer */) ?
            lView[parentTNode.index] :
            null;
        applyCreateOpCodes(lView, tI18n.create, parentRNode, insertInFrontOf);
        setInI18nBlock(true);
    }
    /**
     * Translates a translation block marked by `i18nStart` and `i18nEnd`. It inserts the text/ICU nodes
     * into the render tree, moves the placeholder nodes and removes the deleted nodes.
     *
     * @codeGenApi
     */
    function ɵɵi18nEnd() {
        setInI18nBlock(false);
    }
    /**
     *
     * Use this instruction to create a translation block that doesn't contain any placeholder.
     * It calls both {@link i18nStart} and {@link i18nEnd} in one instruction.
     *
     * The translation `message` is the value which is locale specific. The translation string may
     * contain placeholders which associate inner elements and sub-templates within the translation.
     *
     * The translation `message` placeholders are:
     * - `�{index}(:{block})�`: *Binding Placeholder*: Marks a location where an expression will be
     *   interpolated into. The placeholder `index` points to the expression binding index. An optional
     *   `block` that matches the sub-template in which it was declared.
     * - `�#{index}(:{block})�`/`�/#{index}(:{block})�`: *Element Placeholder*:  Marks the beginning
     *   and end of DOM element that were embedded in the original translation block. The placeholder
     *   `index` points to the element index in the template instructions set. An optional `block` that
     *   matches the sub-template in which it was declared.
     * - `�*{index}:{block}�`/`�/*{index}:{block}�`: *Sub-template Placeholder*: Sub-templates must be
     *   split up and translated separately in each angular template function. The `index` points to the
     *   `template` instruction index. A `block` that matches the sub-template in which it was declared.
     *
     * @param index A unique index of the translation in the static block.
     * @param messageIndex An index of the translation message from the `def.consts` array.
     * @param subTemplateIndex Optional sub-template index in the `message`.
     *
     * @codeGenApi
     */
    function ɵɵi18n(index, messageIndex, subTemplateIndex) {
        ɵɵi18nStart(index, messageIndex, subTemplateIndex);
        ɵɵi18nEnd();
    }
    /**
     * Marks a list of attributes as translatable.
     *
     * @param index A unique index in the static block
     * @param values
     *
     * @codeGenApi
     */
    function ɵɵi18nAttributes(index, attrsIndex) {
        var tView = getTView();
        ngDevMode && assertDefined(tView, "tView should be defined");
        var attrs = getConstant(tView.consts, attrsIndex);
        i18nAttributesFirstPass(tView, index + HEADER_OFFSET, attrs);
    }
    /**
     * Stores the values of the bindings during each update cycle in order to determine if we need to
     * update the translated nodes.
     *
     * @param value The binding's value
     * @returns This function returns itself so that it may be chained
     * (e.g. `i18nExp(ctx.name)(ctx.title)`)
     *
     * @codeGenApi
     */
    function ɵɵi18nExp(value) {
        var lView = getLView();
        setMaskBit(bindingUpdated(lView, nextBindingIndex(), value));
        return ɵɵi18nExp;
    }
    /**
     * Updates a translation block or an i18n attribute when the bindings have changed.
     *
     * @param index Index of either {@link i18nStart} (translation block) or {@link i18nAttributes}
     * (i18n attribute) on which it should update the content.
     *
     * @codeGenApi
     */
    function ɵɵi18nApply(index) {
        applyI18n(getTView(), getLView(), index + HEADER_OFFSET);
    }
    /**
     * Handles message string post-processing for internationalization.
     *
     * Handles message string post-processing by transforming it from intermediate
     * format (that might contain some markers that we need to replace) to the final
     * form, consumable by i18nStart instruction. Post processing steps include:
     *
     * 1. Resolve all multi-value cases (like [�*1:1��#2:1�|�#4:1�|�5�])
     * 2. Replace all ICU vars (like "VAR_PLURAL")
     * 3. Replace all placeholders used inside ICUs in a form of {PLACEHOLDER}
     * 4. Replace all ICU references with corresponding values (like �ICU_EXP_ICU_1�)
     *    in case multiple ICUs have the same placeholder name
     *
     * @param message Raw translation string for post processing
     * @param replacements Set of replacements that should be applied
     *
     * @returns Transformed string that can be consumed by i18nStart instruction
     *
     * @codeGenApi
     */
    function ɵɵi18nPostprocess(message, replacements) {
        if (replacements === void 0) { replacements = {}; }
        return i18nPostprocess(message, replacements);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Resolves the providers which are defined in the DirectiveDef.
     *
     * When inserting the tokens and the factories in their respective arrays, we can assume that
     * this method is called first for the component (if any), and then for other directives on the same
     * node.
     * As a consequence,the providers are always processed in that order:
     * 1) The view providers of the component
     * 2) The providers of the component
     * 3) The providers of the other directives
     * This matches the structure of the injectables arrays of a view (for each node).
     * So the tokens and the factories can be pushed at the end of the arrays, except
     * in one case for multi providers.
     *
     * @param def the directive definition
     * @param providers: Array of `providers`.
     * @param viewProviders: Array of `viewProviders`.
     */
    function providersResolver(def, providers, viewProviders) {
        var tView = getTView();
        if (tView.firstCreatePass) {
            var isComponent = isComponentDef(def);
            // The list of view providers is processed first, and the flags are updated
            resolveProvider$1(viewProviders, tView.data, tView.blueprint, isComponent, true);
            // Then, the list of providers is processed, and the flags are updated
            resolveProvider$1(providers, tView.data, tView.blueprint, isComponent, false);
        }
    }
    /**
     * Resolves a provider and publishes it to the DI system.
     */
    function resolveProvider$1(provider, tInjectables, lInjectablesBlueprint, isComponent, isViewProvider) {
        provider = resolveForwardRef(provider);
        if (Array.isArray(provider)) {
            // Recursively call `resolveProvider`
            // Recursion is OK in this case because this code will not be in hot-path once we implement
            // cloning of the initial state.
            for (var i = 0; i < provider.length; i++) {
                resolveProvider$1(provider[i], tInjectables, lInjectablesBlueprint, isComponent, isViewProvider);
            }
        }
        else {
            var tView = getTView();
            var lView = getLView();
            var token = isTypeProvider(provider) ? provider : resolveForwardRef(provider.provide);
            var providerFactory = providerToFactory(provider);
            var tNode = getCurrentTNode();
            var beginIndex = tNode.providerIndexes & 1048575 /* ProvidersStartIndexMask */;
            var endIndex = tNode.directiveStart;
            var cptViewProvidersCount = tNode.providerIndexes >> 20 /* CptViewProvidersCountShift */;
            if (isTypeProvider(provider) || !provider.multi) {
                // Single provider case: the factory is created and pushed immediately
                var factory = new NodeInjectorFactory(providerFactory, isViewProvider, ɵɵdirectiveInject);
                var existingFactoryIndex = indexOf(token, tInjectables, isViewProvider ? beginIndex : beginIndex + cptViewProvidersCount, endIndex);
                if (existingFactoryIndex === -1) {
                    diPublicInInjector(getOrCreateNodeInjectorForNode(tNode, lView), tView, token);
                    registerDestroyHooksIfSupported(tView, provider, tInjectables.length);
                    tInjectables.push(token);
                    tNode.directiveStart++;
                    tNode.directiveEnd++;
                    if (isViewProvider) {
                        tNode.providerIndexes += 1048576 /* CptViewProvidersCountShifter */;
                    }
                    lInjectablesBlueprint.push(factory);
                    lView.push(factory);
                }
                else {
                    lInjectablesBlueprint[existingFactoryIndex] = factory;
                    lView[existingFactoryIndex] = factory;
                }
            }
            else {
                // Multi provider case:
                // We create a multi factory which is going to aggregate all the values.
                // Since the output of such a factory depends on content or view injection,
                // we create two of them, which are linked together.
                //
                // The first one (for view providers) is always in the first block of the injectables array,
                // and the second one (for providers) is always in the second block.
                // This is important because view providers have higher priority. When a multi token
                // is being looked up, the view providers should be found first.
                // Note that it is not possible to have a multi factory in the third block (directive block).
                //
                // The algorithm to process multi providers is as follows:
                // 1) If the multi provider comes from the `viewProviders` of the component:
                //   a) If the special view providers factory doesn't exist, it is created and pushed.
                //   b) Else, the multi provider is added to the existing multi factory.
                // 2) If the multi provider comes from the `providers` of the component or of another
                // directive:
                //   a) If the multi factory doesn't exist, it is created and provider pushed into it.
                //      It is also linked to the multi factory for view providers, if it exists.
                //   b) Else, the multi provider is added to the existing multi factory.
                var existingProvidersFactoryIndex = indexOf(token, tInjectables, beginIndex + cptViewProvidersCount, endIndex);
                var existingViewProvidersFactoryIndex = indexOf(token, tInjectables, beginIndex, beginIndex + cptViewProvidersCount);
                var doesProvidersFactoryExist = existingProvidersFactoryIndex >= 0 &&
                    lInjectablesBlueprint[existingProvidersFactoryIndex];
                var doesViewProvidersFactoryExist = existingViewProvidersFactoryIndex >= 0 &&
                    lInjectablesBlueprint[existingViewProvidersFactoryIndex];
                if (isViewProvider && !doesViewProvidersFactoryExist ||
                    !isViewProvider && !doesProvidersFactoryExist) {
                    // Cases 1.a and 2.a
                    diPublicInInjector(getOrCreateNodeInjectorForNode(tNode, lView), tView, token);
                    var factory = multiFactory(isViewProvider ? multiViewProvidersFactoryResolver : multiProvidersFactoryResolver, lInjectablesBlueprint.length, isViewProvider, isComponent, providerFactory);
                    if (!isViewProvider && doesViewProvidersFactoryExist) {
                        lInjectablesBlueprint[existingViewProvidersFactoryIndex].providerFactory = factory;
                    }
                    registerDestroyHooksIfSupported(tView, provider, tInjectables.length, 0);
                    tInjectables.push(token);
                    tNode.directiveStart++;
                    tNode.directiveEnd++;
                    if (isViewProvider) {
                        tNode.providerIndexes += 1048576 /* CptViewProvidersCountShifter */;
                    }
                    lInjectablesBlueprint.push(factory);
                    lView.push(factory);
                }
                else {
                    // Cases 1.b and 2.b
                    var indexInFactory = multiFactoryAdd(lInjectablesBlueprint[isViewProvider ? existingViewProvidersFactoryIndex :
                        existingProvidersFactoryIndex], providerFactory, !isViewProvider && isComponent);
                    registerDestroyHooksIfSupported(tView, provider, existingProvidersFactoryIndex > -1 ? existingProvidersFactoryIndex :
                        existingViewProvidersFactoryIndex, indexInFactory);
                }
                if (!isViewProvider && isComponent && doesViewProvidersFactoryExist) {
                    lInjectablesBlueprint[existingViewProvidersFactoryIndex].componentProviders++;
                }
            }
        }
    }
    /**
     * Registers the `ngOnDestroy` hook of a provider, if the provider supports destroy hooks.
     * @param tView `TView` in which to register the hook.
     * @param provider Provider whose hook should be registered.
     * @param contextIndex Index under which to find the context for the hook when it's being invoked.
     * @param indexInFactory Only required for `multi` providers. Index of the provider in the multi
     * provider factory.
     */
    function registerDestroyHooksIfSupported(tView, provider, contextIndex, indexInFactory) {
        var providerIsTypeProvider = isTypeProvider(provider);
        if (providerIsTypeProvider || isClassProvider(provider)) {
            var prototype = (provider.useClass || provider).prototype;
            var ngOnDestroy = prototype.ngOnDestroy;
            if (ngOnDestroy) {
                var hooks = tView.destroyHooks || (tView.destroyHooks = []);
                if (!providerIsTypeProvider && provider.multi) {
                    ngDevMode &&
                        assertDefined(indexInFactory, 'indexInFactory when registering multi factory destroy hook');
                    var existingCallbacksIndex = hooks.indexOf(contextIndex);
                    if (existingCallbacksIndex === -1) {
                        hooks.push(contextIndex, [indexInFactory, ngOnDestroy]);
                    }
                    else {
                        hooks[existingCallbacksIndex + 1].push(indexInFactory, ngOnDestroy);
                    }
                }
                else {
                    hooks.push(contextIndex, ngOnDestroy);
                }
            }
        }
    }
    /**
     * Add a factory in a multi factory.
     * @returns Index at which the factory was inserted.
     */
    function multiFactoryAdd(multiFactory, factory, isComponentProvider) {
        if (isComponentProvider) {
            multiFactory.componentProviders++;
        }
        return multiFactory.multi.push(factory) - 1;
    }
    /**
     * Returns the index of item in the array, but only in the begin to end range.
     */
    function indexOf(item, arr, begin, end) {
        for (var i = begin; i < end; i++) {
            if (arr[i] === item)
                return i;
        }
        return -1;
    }
    /**
     * Use this with `multi` `providers`.
     */
    function multiProvidersFactoryResolver(_, tData, lData, tNode) {
        return multiResolve(this.multi, []);
    }
    /**
     * Use this with `multi` `viewProviders`.
     *
     * This factory knows how to concatenate itself with the existing `multi` `providers`.
     */
    function multiViewProvidersFactoryResolver(_, tData, lView, tNode) {
        var factories = this.multi;
        var result;
        if (this.providerFactory) {
            var componentCount = this.providerFactory.componentProviders;
            var multiProviders = getNodeInjectable(lView, lView[TVIEW], this.providerFactory.index, tNode);
            // Copy the section of the array which contains `multi` `providers` from the component
            result = multiProviders.slice(0, componentCount);
            // Insert the `viewProvider` instances.
            multiResolve(factories, result);
            // Copy the section of the array which contains `multi` `providers` from other directives
            for (var i = componentCount; i < multiProviders.length; i++) {
                result.push(multiProviders[i]);
            }
        }
        else {
            result = [];
            // Insert the `viewProvider` instances.
            multiResolve(factories, result);
        }
        return result;
    }
    /**
     * Maps an array of factories into an array of values.
     */
    function multiResolve(factories, result) {
        for (var i = 0; i < factories.length; i++) {
            var factory = factories[i];
            result.push(factory());
        }
        return result;
    }
    /**
     * Creates a multi factory.
     */
    function multiFactory(factoryFn, index, isViewProvider, isComponent, f) {
        var factory = new NodeInjectorFactory(factoryFn, isViewProvider, ɵɵdirectiveInject);
        factory.multi = [];
        factory.index = index;
        factory.componentProviders = 0;
        multiFactoryAdd(factory, f, isComponent && !isViewProvider);
        return factory;
    }

    /**
     * This feature resolves the providers of a directive (or component),
     * and publish them into the DI system, making it visible to others for injection.
     *
     * For example:
     * ```ts
     * class ComponentWithProviders {
     *   constructor(private greeter: GreeterDE) {}
     *
     *   static ɵcmp = defineComponent({
     *     type: ComponentWithProviders,
     *     selectors: [['component-with-providers']],
     *    factory: () => new ComponentWithProviders(directiveInject(GreeterDE as any)),
     *    decls: 1,
     *    vars: 1,
     *    template: function(fs: RenderFlags, ctx: ComponentWithProviders) {
     *      if (fs & RenderFlags.Create) {
     *        ɵɵtext(0);
     *      }
     *      if (fs & RenderFlags.Update) {
     *        ɵɵtextInterpolate(ctx.greeter.greet());
     *      }
     *    },
     *    features: [ɵɵProvidersFeature([GreeterDE])]
     *  });
     * }
     * ```
     *
     * @param definition
     *
     * @codeGenApi
     */
    function ɵɵProvidersFeature(providers, viewProviders) {
        if (viewProviders === void 0) { viewProviders = []; }
        return function (definition) {
            definition.providersResolver =
                function (def, processProvidersFn) {
                    return providersResolver(def, //
                    processProvidersFn ? processProvidersFn(providers) : providers, //
                    viewProviders);
                };
        };
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Represents a component created by a `ComponentFactory`.
     * Provides access to the component instance and related objects,
     * and provides the means of destroying the instance.
     *
     * @publicApi
     */
    var ComponentRef = /** @class */ (function () {
        function ComponentRef() {
        }
        return ComponentRef;
    }());
    /**
     * Base class for a factory that can create a component dynamically.
     * Instantiate a factory for a given type of component with `resolveComponentFactory()`.
     * Use the resulting `ComponentFactory.create()` method to create a component of that type.
     *
     * @see [Dynamic Components](guide/dynamic-component-loader)
     *
     * @publicApi
     */
    var ComponentFactory = /** @class */ (function () {
        function ComponentFactory() {
        }
        return ComponentFactory;
    }());

    function noComponentFactoryError(component) {
        var error = Error("No component factory found for " + stringify(component) + ". Did you add it to @NgModule.entryComponents?");
        error[ERROR_COMPONENT] = component;
        return error;
    }
    var ERROR_COMPONENT = 'ngComponent';
    function getComponent$1(error) {
        return error[ERROR_COMPONENT];
    }
    var _NullComponentFactoryResolver = /** @class */ (function () {
        function _NullComponentFactoryResolver() {
        }
        _NullComponentFactoryResolver.prototype.resolveComponentFactory = function (component) {
            throw noComponentFactoryError(component);
        };
        return _NullComponentFactoryResolver;
    }());
    /**
     * A simple registry that maps `Components` to generated `ComponentFactory` classes
     * that can be used to create instances of components.
     * Use to obtain the factory for a given component type,
     * then use the factory's `create()` method to create a component of that type.
     *
     * @see [Dynamic Components](guide/dynamic-component-loader)
     * @publicApi
     */
    var ComponentFactoryResolver = /** @class */ (function () {
        function ComponentFactoryResolver() {
        }
        return ComponentFactoryResolver;
    }());
    ComponentFactoryResolver.NULL = new _NullComponentFactoryResolver();
    var CodegenComponentFactoryResolver = /** @class */ (function () {
        function CodegenComponentFactoryResolver(factories, _parent, _ngModule) {
            this._parent = _parent;
            this._ngModule = _ngModule;
            this._factories = new Map();
            for (var i = 0; i < factories.length; i++) {
                var factory = factories[i];
                this._factories.set(factory.componentType, factory);
            }
        }
        CodegenComponentFactoryResolver.prototype.resolveComponentFactory = function (component) {
            var factory = this._factories.get(component);
            if (!factory && this._parent) {
                factory = this._parent.resolveComponentFactory(component);
            }
            if (!factory) {
                throw noComponentFactoryError(component);
            }
            return new ComponentFactoryBoundToModule(factory, this._ngModule);
        };
        return CodegenComponentFactoryResolver;
    }());
    var ComponentFactoryBoundToModule = /** @class */ (function (_super) {
        __extends(ComponentFactoryBoundToModule, _super);
        function ComponentFactoryBoundToModule(factory, ngModule) {
            var _this = _super.call(this) || this;
            _this.factory = factory;
            _this.ngModule = ngModule;
            _this.selector = factory.selector;
            _this.componentType = factory.componentType;
            _this.ngContentSelectors = factory.ngContentSelectors;
            _this.inputs = factory.inputs;
            _this.outputs = factory.outputs;
            return _this;
        }
        ComponentFactoryBoundToModule.prototype.create = function (injector, projectableNodes, rootSelectorOrNode, ngModule) {
            return this.factory.create(injector, projectableNodes, rootSelectorOrNode, ngModule || this.ngModule);
        };
        return ComponentFactoryBoundToModule;
    }(ComponentFactory));

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function noop() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        // Do nothing.
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Creates an ElementRef from the most recent node.
     *
     * @returns The ElementRef instance to use
     */
    function injectElementRef() {
        return createElementRef(getCurrentTNode(), getLView());
    }
    /**
     * Creates an ElementRef given a node.
     *
     * @param tNode The node for which you'd like an ElementRef
     * @param lView The view to which the node belongs
     * @returns The ElementRef instance to use
     */
    function createElementRef(tNode, lView) {
        return new ElementRef(getNativeByTNode(tNode, lView));
    }
    var SWITCH_ELEMENT_REF_FACTORY__POST_R3__ = injectElementRef;
    var SWITCH_ELEMENT_REF_FACTORY__PRE_R3__ = noop;
    var SWITCH_ELEMENT_REF_FACTORY = SWITCH_ELEMENT_REF_FACTORY__PRE_R3__;
    /**
     * A wrapper around a native element inside of a View.
     *
     * An `ElementRef` is backed by a render-specific element. In the browser, this is usually a DOM
     * element.
     *
     * @security Permitting direct access to the DOM can make your application more vulnerable to
     * XSS attacks. Carefully review any use of `ElementRef` in your code. For more detail, see the
     * [Security Guide](https://g.co/ng/security).
     *
     * @publicApi
     */
    // Note: We don't expose things like `Injector`, `ViewContainer`, ... here,
    // i.e. users have to ask for what they need. With that, we can build better analysis tools
    // and could do better codegen in the future.
    var ElementRef = /** @class */ (function () {
        function ElementRef(nativeElement) {
            this.nativeElement = nativeElement;
        }
        return ElementRef;
    }());
    /**
     * @internal
     * @nocollapse
     */
    ElementRef.__NG_ELEMENT_ID__ = SWITCH_ELEMENT_REF_FACTORY;
    /**
     * Unwraps `ElementRef` and return the `nativeElement`.
     *
     * @param value value to unwrap
     * @returns `nativeElement` if `ElementRef` otherwise returns value as is.
     */
    function unwrapElementRef(value) {
        return value instanceof ElementRef ? value.nativeElement : value;
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var Renderer2Interceptor = new InjectionToken('Renderer2Interceptor');
    /**
     * Creates and initializes a custom renderer that implements the `Renderer2` base class.
     *
     * @publicApi
     */
    var RendererFactory2 = /** @class */ (function () {
        function RendererFactory2() {
        }
        return RendererFactory2;
    }());
    /**
     * Extend this base class to implement custom rendering. By default, Angular
     * renders a template into DOM. You can use custom rendering to intercept
     * rendering calls, or to render to something other than DOM.
     *
     * Create your custom renderer using `RendererFactory2`.
     *
     * Use a custom renderer to bypass Angular's templating and
     * make custom UI changes that can't be expressed declaratively.
     * For example if you need to set a property or an attribute whose name is
     * not statically known, use the `setProperty()` or
     * `setAttribute()` method.
     *
     * @publicApi
     */
    var Renderer2 = /** @class */ (function () {
        function Renderer2() {
        }
        return Renderer2;
    }());
    /**
     * @internal
     * @nocollapse
     */
    Renderer2.__NG_ELEMENT_ID__ = function () { return SWITCH_RENDERER2_FACTORY(); };
    var SWITCH_RENDERER2_FACTORY__POST_R3__ = injectRenderer2;
    var SWITCH_RENDERER2_FACTORY__PRE_R3__ = noop;
    var SWITCH_RENDERER2_FACTORY = SWITCH_RENDERER2_FACTORY__PRE_R3__;
    /** Returns a Renderer2 (or throws when application was bootstrapped with Renderer3) */
    function getOrCreateRenderer2(lView) {
        var renderer = lView[RENDERER];
        if (ngDevMode && !isProceduralRenderer(renderer)) {
            throw new Error('Cannot inject Renderer2 when the application uses Renderer3!');
        }
        return renderer;
    }
    /** Injects a Renderer2 for the current component. */
    function injectRenderer2() {
        // We need the Renderer to be based on the component that it's being injected into, however since
        // DI happens before we've entered its view, `getLView` will return the parent view instead.
        var lView = getLView();
        var tNode = getCurrentTNode();
        var nodeAtIndex = getComponentLViewByIndex(tNode.index, lView);
        return getOrCreateRenderer2(isLView(nodeAtIndex) ? nodeAtIndex : lView);
    }

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * Sanitizer is used by the views to sanitize potentially dangerous values.
     *
     * @publicApi
     */
    var Sanitizer = /** @class */ (function () {
        function Sanitizer() {
        }
        return Sanitizer;
    }());
    /** @nocollapse */
    Sanitizer.ɵprov = ɵɵdefineInjectable({
        token: Sanitizer,
        providedIn: 'root',
        factory: function () { return null; },
    });

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /**
     * @description Represents the version of Angular
     *
     * @publicApi
     */
    var Version = /** @class */ (function () {
        function Version(full) {
            this.full = full;
            this.major = full.split('.')[0];
            this.minor = full.split('.')[1];
            this.patch = full.split('.').slice(2).join('.');
        }
        return Version;
    }());
    /**
     * @publicApi
     */
    var VERSION = new Version('11.2.6');

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var DefaultIterableDifferFactory = /** @class */ (function () {
        function DefaultIterableDifferFactory() {
        }
        DefaultIterableDifferFactory.prototype.supports = function (obj) {
            return isListLikeIterable(obj);
        };
        DefaultIterableDifferFactory.prototype.create = function (trackByFn) {
            return new DefaultIterableDiffer(trackByFn);
        };
        return DefaultIterableDifferFactory;
    }());
    var trackByIdentity = function (index, item) { return item; };
    var ɵ0$b = trackByIdentity;
    /**
     * @deprecated v4.0.0 - Should not be part of public API.
     * @publicApi
     */
    var DefaultIterableDiffer = /** @class */ (function () {
        function DefaultIterableDiffer(trackByFn) {
            this.length = 0;
            // Keeps track of the used records at any point in time (during & across `_check()` calls)
            this._linkedRecords = null;
            // Keeps track of the removed records at any point in time during `_check()` calls.
            this._unlinkedRecords = null;
            this._previousItHead = null;
            this._itHead = null;
            this._itTail = null;
            this._additionsHead = null;
            this._additionsTail = null;
            this._movesHead = null;
            this._movesTail = null;
            this._removalsHead = null;
            this._removalsTail = null;
            // Keeps track of records where custom track by is the same, but item identity has changed
            this._identityChangesHead = null;
            this._identityChangesTail = null;
            this._trackByFn = trackByFn || trackByIdentity;
        }
        DefaultIterableDiffer.prototype.forEachItem = function (fn) {
            var record;
            for (record = this._itHead; record !== null; record = record._next) {
                fn(record);
            }
        };
        DefaultIterableDiffer.prototype.forEachOperation = function (fn) {
            var nextIt = this._itHead;
            var nextRemove = this._removalsHead;
            var addRemoveOffset = 0;
            var moveOffsets = null;
            while (nextIt || nextRemove) {
                // Figure out which is the next record to process
                // Order: remove, add, move
                var record = !nextRemove ||
                    nextIt &&
                        nextIt.currentIndex <
                            getPreviousIndex(nextRemove, addRemoveOffset, moveOffsets) ?
                    nextIt :
                    nextRemove;
                var adjPreviousIndex = getPreviousIndex(record, addRemoveOffset, moveOffsets);
                var currentIndex = record.currentIndex;
                // consume the item, and adjust the addRemoveOffset and update moveDistance if necessary
                if (record === nextRemove) {
                    addRemoveOffset--;
                    nextRemove = nextRemove._nextRemoved;
                }
                else {
                    nextIt = nextIt._next;
                    if (record.previousIndex == null) {
                        addRemoveOffset++;
                    }
                    else {
                        // INVARIANT:  currentIndex < previousIndex
                        if (!moveOffsets)
                            moveOffsets = [];
                        var localMovePreviousIndex = adjPreviousIndex - addRemoveOffset;
                        var localCurrentIndex = currentIndex - addRemoveOffset;
                        if (localMovePreviousIndex != localCurrentIndex) {
                            for (var i = 0; i < localMovePreviousIndex; i++) {
                                var offset = i < moveOffsets.length ? moveOffsets[i] : (moveOffsets[i] = 0);
                                var index = offset + i;
                                if (localCurrentIndex <= index && index < localMovePreviousIndex) {
                                    moveOffsets[i] = offset + 1;
                                }
                            }
                            var previousIndex = record.previousIndex;
                            moveOffsets[previousIndex] = localCurrentIndex - localMovePreviousIndex;
                        }
                    }
                }
                if (adjPreviousIndex !== currentIndex) {
                    fn(record, adjPreviousIndex, currentIndex);
                }
            }
        };
        DefaultIterableDiffer.prototype.forEachPreviousItem = function (fn) {
            var record;
            for (record = this._previousItHead; record !== null; record = record._nextPrevious) {
                fn(record);
            }
        };
        DefaultIterableDiffer.prototype.forEachAddedItem = function (fn) {
            var record;
            for (record = this._additionsHead; record !== null; record = record._nextAdded) {
                fn(record);
            }
        };
        DefaultIterableDiffer.prototype.forEachMovedItem = function (fn) {
            var record;
            for (record = this._movesHead; record !== null; record = record._nextMoved) {
                fn(record);
            }
        };
        DefaultIterableDiffer.prototype.forEachRemovedItem = function (fn) {
            var record;
            for (record = this._removalsHead; record !== null; record = record._nextRemoved) {
                fn(record);
            }
        };
        DefaultIterableDiffer.prototype.forEachIdentityChange = function (fn) {
            var record;
            for (record = this._identityChangesHead; record !== null; record = record._nextIdentityChange) {
                fn(record);
            }
        };
        DefaultIterableDiffer.prototype.diff = function (collection) {
            if (collection == null)
                collection = [];
            if (!isListLikeIterable(collection)) {
                throw new Error("Error trying to diff '" + stringify(collection) + "'. Only arrays and iterables are allowed");
            }
            if (this.check(collection)) {
                return this;
            }
            else {
                return null;
            }
        };
        DefaultIterableDiffer.prototype.onDestroy = function () { };
        DefaultIterableDiffer.prototype.check = function (collection) {
            var _this = this;
            this._reset();
            var record = this._itHead;
            var mayBeDirty = false;
            var index;
            var item;
            var itemTrackBy;
            if (Array.isArray(collection)) {
                this.length = collection.length;
                for (var index_1 = 0; index_1 < this.length; index_1++) {
                    item = collection[index_1];
                    itemTrackBy = this._trackByFn(index_1, item);
                    if (record === null || !Object.is(record.trackById, itemTrackBy)) {
                        record = this._mismatch(record, item, itemTrackBy, index_1);
                        mayBeDirty = true;
                    }
                    else {
                        if (mayBeDirty) {
                            // TODO(misko): can we limit this to duplicates only?
                            record = this._verifyReinsertion(record, item, itemTrackBy, index_1);
                        }
                        if (!Object.is(record.item, item))
                            this._addIdentityChange(record, item);
                    }
                    record = record._next;
                }
            }
            else {
                index = 0;
                iterateListLike(collection, function (item) {
                    itemTrackBy = _this._trackByFn(index, item);
                    if (record === null || !Object.is(record.trackById, itemTrackBy)) {
                        record = _this._mismatch(record, item, itemTrackBy, index);
                        mayBeDirty = true;
                    }
                    else {
                        if (mayBeDirty) {
                            // TODO(misko): can we limit this to duplicates only?
                            record = _this._verifyReinsertion(record, item, itemTrackBy, index);
                        }
                        if (!Object.is(record.item, item))
                            _this._addIdentityChange(record, item);
                    }
                    record = record._next;
                    index++;
                });
                this.length = index;
            }
            this._truncate(record);
            this.collection = collection;
            return this.isDirty;
        };
        Object.defineProperty(DefaultIterableDiffer.prototype, "isDirty", {
            /* CollectionChanges is considered dirty if it has any additions, moves, removals, or identity
             * changes.
             */
            get: function () {
                return this._additionsHead !== null || this._movesHead !== null ||
                    this._removalsHead !== null || this._identityChangesHead !== null;
            },
            enumerable: false,
            configurable: true
        });
        /**
         * Reset the state of the change objects to show no changes. This means set previousKey to
         * currentKey, and clear all of the queues (additions, moves, removals).
         * Set the previousIndexes of moved and added items to their currentIndexes
         * Reset the list of additions, moves and removals
         *
         * @internal
         */
        DefaultIterableDiffer.prototype._reset = function () {
            if (this.isDirty) {
                var record = void 0;
                for (record = this._previousItHead = this._itHead; record !== null; record = record._next) {
                    record._nextPrevious = record._next;
                }
                for (record = this._additionsHead; record !== null; record = record._nextAdded) {
                    record.previousIndex = record.currentIndex;
                }
                this._additionsHead = this._additionsTail = null;
                for (record = this._movesHead; record !== null; record = record._nextMoved) {
                    record.previousIndex = record.currentIndex;
                }
                this._movesHead = this._movesTail = null;
                this._removalsHead = this._removalsTail = null;
                this._identityChangesHead = this._identityChangesTail = null;
                // TODO(vicb): when assert gets supported
                // assert(!this.isDirty);
            }
        };
        /**
         * This is the core function which handles differences between collections.
         *
         * - `record` is the record which we saw at this position last time. If null then it is a new
         *   item.
         * - `item` is the current item in the collection
         * - `index` is the position of the item in the collection
         *
         * @internal
         */
        DefaultIterableDiffer.prototype._mismatch = function (record, item, itemTrackBy, index) {
            // The previous record after which we will append the current one.
            var previousRecord;
            if (record === null) {
                previousRecord = this._itTail;
            }
            else {
                previousRecord = record._prev;
                // Remove the record from the collection since we know it does not match the item.
                this._remove(record);
            }
            // See if we have evicted the item, which used to be at some anterior position of _itHead list.
            record = this._unlinkedRecords === null ? null : this._unlinkedRecords.get(itemTrackBy, null);
            if (record !== null) {
                // It is an item which we have evicted earlier: reinsert it back into the list.
                // But first we need to check if identity changed, so we can update in view if necessary.
                if (!Object.is(record.item, item))
                    this._addIdentityChange(record, item);
                this._reinsertAfter(record, previousRecord, index);
            }
            else {
                // Attempt to see if the item is at some posterior position of _itHead list.
                record = this._linkedRecords === null ? null : this._linkedRecords.get(itemTrackBy, index);
                if (record !== null) {
                    // We have the item in _itHead at/after `index` position. We need to move it forward in the
                    // collection.
                    // But first we need to check if identity changed, so we can update in view if necessary.
                    if (!Object.is(record.item, item))
                        this._addIdentityChange(record, item);
                    this._moveAfter(record, previousRecord, index);
                }
                else {
                    // It is a new item: add it.
                    record =
                        this._addAfter(new IterableChangeRecord_(item, itemTrackBy), previousRecord, index);
                }
            }
            return record;
        };
        /**
         * This check is only needed if an array contains duplicates. (Short circuit of nothing dirty)
         *
         * Use case: `[a, a]` => `[b, a, a]`
         *
         * If we did not have this check then the insertion of `b` would:
         *   1) evict first `a`
         *   2) insert `b` at `0` index.
         *   3) leave `a` at index `1` as is. <-- this is wrong!
         *   3) reinsert `a` at index 2. <-- this is wrong!
         *
         * The correct behavior is:
         *   1) evict first `a`
         *   2) insert `b` at `0` index.
         *   3) reinsert `a` at index 1.
         *   3) move `a` at from `1` to `2`.
         *
         *
         * Double check that we have not evicted a duplicate item. We need to check if the item type may
         * have already been removed:
         * The insertion of b will evict the first 'a'. If we don't reinsert it now it will be reinserted
         * at the end. Which will show up as the two 'a's switching position. This is incorrect, since a
         * better way to think of it is as insert of 'b' rather then switch 'a' with 'b' and then add 'a'
         * at the end.
         *
         * @internal
         */
        DefaultIterableDiffer.prototype._verifyReinsertion = function (record, item, itemTrackBy, index) {
            var reinsertRecord = this._unlinkedRecords === null ? null : this._unlinkedRecords.get(itemTrackBy, null);
            if (reinsertRecord !== null) {
                record = this._reinsertAfter(reinsertRecord, record._prev, index);
            }
            else if (record.currentIndex != index) {
                record.currentIndex = index;
                this._addToMoves(record, index);
            }
            return record;
        };
        /**
         * Get rid of any excess {@link IterableChangeRecord_}s from the previous collection
         *
         * - `record` The first excess {@link IterableChangeRecord_}.
         *
         * @internal
         */
        DefaultIterableDiffer.prototype._truncate = function (record) {
            // Anything after that needs to be removed;
            while (record !== null) {
                var nextRecord = record._next;
                this._addToRemovals(this._unlink(record));
                record = nextRecord;
            }
            if (this._unlinkedRecords !== null) {
                this._unlinkedRecords.clear();
            }
            if (this._additionsTail !== null) {
                this._additionsTail._nextAdded = null;
            }
            if (this._movesTail !== null) {
                this._movesTail._nextMoved = null;
            }
            if (this._itTail !== null) {
                this._itTail._next = null;
            }
            if (this._removalsTail !== null) {
                this._removalsTail._nextRemoved = null;
            }
            if (this._identityChangesTail !== null) {
                this._identityChangesTail._nextIdentityChange = null;
            }
        };
        /** @internal */
        DefaultIterableDiffer.prototype._reinsertAfter = function (record, prevRecord, index) {
            if (this._unlinkedRecords !== null) {
                this._unlinkedRecords.remove(record);
            }
            var prev = record._prevRemoved;
            var next = record._nextRemoved;
            if (prev === null) {
                this._removalsHead = next;
            }
            else {
                prev._nextRemoved = next;
            }
            if (next === null) {
                this._removalsTail = prev;
            }
            else {
                next._prevRemoved = prev;
            }
            this._insertAfter(record, prevRecord, index);
            this._addToMoves(record, index);
            return record;
        };
        /** @internal */
        DefaultIterableDiffer.prototype._moveAfter = function (record, prevRecord, index) {
            this._unlink(record);
            this._insertAfter(record, prevRecord, index);
            this._addToMoves(record, index);
            return record;
        };
        /** @internal */
        DefaultIterableDiffer.prototype._addAfter = function (record, prevRecord, index) {
            this._insertAfter(record, prevRecord, index);
            if (this._additionsTail === null) {
                // TODO(vicb):
                // assert(this._additionsHead === null);
                this._additionsTail = this._additionsHead = record;
            }
            else {
                // TODO(vicb):
                // assert(_additionsTail._nextAdded === null);
                // assert(record._nextAdded === null);
                this._additionsTail = this._additionsTail._nextAdded = record;
            }
            return record;
        };
        /** @internal */
        DefaultIterableDiffer.prototype._insertAfter = function (record, prevRecord, index) {
            // TODO(vicb):
            // assert(record != prevRecord);
            // assert(record._next === null);
            // assert(record._prev === null);
            var next = prevRecord === null ? this._itHead : prevRecord._next;
            // TODO(vicb):
            // assert(next != record);
            // assert(prevRecord != record);
            record._next = next;
            record._prev = prevRecord;
            if (next === null) {
                this._itTail = record;
            }
            else {
                next._prev = record;
            }
            if (prevRecord === null) {
                this._itHead = record;
            }
            else {
                prevRecord._next = record;
            }
            if (this._linkedRecords === null) {
                this._linkedRecords = new _DuplicateMap();
            }
            this._linkedRecords.put(record);
            record.currentIndex = index;
            return record;
        };
        /** @internal */
        DefaultIterableDiffer.prototype._remove = function (record) {
            return this._addToRemovals(this._unlink(record));
        };
        /** @internal */
        DefaultIterableDiffer.prototype._unlink = function (record) {
            if (this._linkedRecords !== null) {
                this._linkedRecords.remove(record);
            }
            var prev = record._prev;
            var next = record._next;
            // TODO(vicb):
            // assert((record._prev = null) === null);
            // assert((record._next = null) === null);
            if (prev === null) {
                this._itHead = next;
            }
            else {
                prev._next = next;
            }
            if (next === null) {
                this._itTail = prev;
            }
            else {
                next._prev = prev;
            }
            return record;
        };
        /** @internal */
        DefaultIterableDiffer.prototype._addToMoves = function (record, toIndex) {
            // TODO(vicb):
            // assert(record._nextMoved === null);
            if (record.previousIndex === toIndex) {
                return record;
            }
            if (this._movesTail === null) {
                // TODO(vicb):
                // assert(_movesHead === null);
                this._movesTail = this._movesHead = record;
            }
            else {
                // TODO(vicb):
                // assert(_movesTail._nextMoved === null);
                this._movesTail = this._movesTail._nextMoved = record;
            }
            return record;
        };
        DefaultIterableDiffer.prototype._addToRemovals = function (record) {
            if (this._unlinkedRecords === null) {
                this._unlinkedRecords = new _DuplicateMap();
            }
            this._unlinkedRecords.put(record);
            record.currentIndex = null;
            record._nextRemoved = null;
            if (this._removalsTail === null) {
                // TODO(vicb):
                // assert(_removalsHead === null);
                this._removalsTail = this._removalsHead = record;
                record._prevRemoved = null;
            }
            else {
                // TODO(vicb):
                // assert(_removalsTail._nextRemoved === null);
                // assert(record._nextRemoved === null);
                record._prevRemoved = this._removalsTail;
                this._removalsTail = this._removalsTail._nextRemoved = record;
            }
            return record;
        };
        /** @internal */
        DefaultIterableDiffer.prototype._addIdentityChange = function (record, item) {
            record.item = item;
            if (this._identityChangesTail === null) {
                this._identityChangesTail = this._identityChangesHead = record;
            }
            else {
                this._identityChangesTail = this._identityChangesTail._nextIdentityChange = record;
            }
            return record;
        };
        return DefaultIterableDiffer;
    }());
    var IterableChangeRecord_ = /** @class */ (function () {
        function IterableChangeRecord_(item, trackById) {
            this.item = item;
            this.trackById = trackById;
            this.currentIndex = null;
            this.previousIndex = null;
            /** @internal */
            this._nextPrevious = null;
            /** @internal */
            this._prev = null;
            /** @internal */
            this._next = null;
            /** @internal */
            this._prevDup = null;
            /** @internal */
            this._nextDup = null;
            /** @internal */
            this._prevRemoved = null;
            /** @internal */
            this._nextRemoved = null;
            /** @internal */
            this._nextAdded = null;
            /** @internal */
            this._nextMoved = null;
            /** @internal */
            this._nextIdentityChange = null;
        }
        return IterableChangeRecord_;
    }());
    // A linked list of IterableChangeRecords with the same IterableChangeRecord_.item
    var _DuplicateItemRecordList = /** @class */ (function () {
        function _DuplicateItemRecordList() {
            /** @internal */
            this._head = null;
            /** @internal */
            this._tail = null;
        }
        /**
         * Append the record to the list of duplicates.
         *
         * Note: by design all records in the list of duplicates hold the same value in record.item.
         */
        _DuplicateItemRecordList.prototype.add = function (record) {
            if (this._head === null) {
                this._head = this._tail = record;
                record._nextDup = null;
                record._prevDup = null;
            }
            else {
                // TODO(vicb):
                // assert(record.item ==  _head.item ||
                //       record.item is num && record.item.isNaN && _head.item is num && _head.item.isNaN);
                this._tail._nextDup = record;
                record._prevDup = this._tail;
                record._nextDup = null;
                this._tail = record;
            }
        };
        // Returns a IterableChangeRecord_ having IterableChangeRecord_.trackById == trackById and
        // IterableChangeRecord_.currentIndex >= atOrAfterIndex
        _DuplicateItemRecordList.prototype.get = function (trackById, atOrAfterIndex) {
            var record;
            for (record = this._head; record !== null; record = record._nextDup) {
                if ((atOrAfterIndex === null || atOrAfterIndex <= record.currentIndex) &&
                    Object.is(record.trackById, trackById)) {
                    return record;
                }
            }
            return null;
       