/*

 Copyright Google LLC All Rights Reserved.

 Use of this source code is governed by an MIT-style license that can be
 found in the LICENSE file at https://angular.io/license
 Angular v13.1.1
 (c) 2010-2021 Google LLC. https://angular.io/
 License: MIT
*/
'use strict';(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports,require("@angular/common"),require("@angular/core"),require("@angular/platform-browser"),require("domino"),require("@angular/animations/browser"),require("@angular/common/http"),require("@angular/platform-browser-dynamic"),require("@angular/platform-browser/animations"),require("rxjs"),require("xhr2"),require("url"),require("@angular/compiler"),require("rxjs/operators")):typeof define==="function"&&
define.amd?define(["exports","@angular/common","@angular/core","@angular/platform-browser","domino","@angular/animations/browser","@angular/common/http","@angular/platform-browser-dynamic","@angular/platform-browser/animations","rxjs","xhr2","url","@angular/compiler","rxjs/operators"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory((global.ng=global.ng||{},global.ng.platformServer={}),global.common,global.i0,global.i1,global.domino,global.browser,global.http,global.platformBrowserDynamic,
global.animations,global.rxjs,global.xhr2,global.url,global.compiler,global.operators))})(this,function(exports,common,i0,i1,domino,browser,http,platformBrowserDynamic,animations,rxjs,xhr2,url,compiler,operators){function _interopNamespace(e){if(e&&e.__esModule)return e;var n=Object.create(null);if(e)Object.keys(e).forEach(function(k){if(k!=="default"){var d=Object.getOwnPropertyDescriptor(e,k);Object.defineProperty(n,k,d.get?d:{enumerable:true,get:function(){return e[k]}})}});n["default"]=e;return Object.freeze(n)}
var i0__namespace=_interopNamespace(i0);var i1__namespace=_interopNamespace(i1);var domino__namespace=_interopNamespace(domino);var xhr2__namespace=_interopNamespace(xhr2);var url__namespace=_interopNamespace(url);function setDomTypes(){Object.assign(global,domino__namespace.impl);global["KeyboardEvent"]=domino__namespace.impl.Event}function parseDocument(html,url="/"){let window=domino__namespace.createWindow(html,url);let doc=window.document;return doc}function serializeDocument(doc){return doc.serialize()}
class DominoAdapter extends i1["ɵBrowserDomAdapter"]{constructor(){super(...arguments);this.supportsDOMEvents=false}static makeCurrent(){setDomTypes();common["ɵsetRootDomAdapter"](new DominoAdapter)}createHtmlDocument(){return parseDocument("<html><head><title>fakeTitle</title></head><body></body></html>")}getDefaultDocument(){if(!DominoAdapter.defaultDoc)DominoAdapter.defaultDoc=domino__namespace.createDocument();return DominoAdapter.defaultDoc}isElementNode(node){return node?node.nodeType===DominoAdapter.defaultDoc.ELEMENT_NODE:
false}isShadowRoot(node){return node.shadowRoot==node}getGlobalEventTarget(doc,target){if(target==="window")return doc.defaultView;if(target==="document")return doc;if(target==="body")return doc.body;return null}getBaseHref(doc){var _a;return((_a=doc.documentElement.querySelector("base"))===null||_a===void 0?void 0:_a.getAttribute("href"))||""}dispatchEvent(el,evt){el.dispatchEvent(evt);const doc=el.ownerDocument||el;const win=doc.defaultView;if(win)win.dispatchEvent(evt)}getUserAgent(){return"Fake user agent"}getCookie(name){throw new Error("getCookie has not been implemented");
}}class PlatformState{constructor(_doc){this._doc=_doc}renderToString(){return serializeDocument(this._doc)}getDocument(){return this._doc}}PlatformState.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:PlatformState,deps:[{token:common.DOCUMENT}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});PlatformState.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,
type:PlatformState});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:PlatformState,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:undefined,decorators:[{type:i0.Inject,args:[common.DOCUMENT]}]}]}});const INITIAL_CONFIG=new i0.InjectionToken("Server.INITIAL_CONFIG");const BEFORE_APP_SERIALIZED=new i0.InjectionToken("Server.RENDER_MODULE_HOOK");const isAbsoluteUrl=/^[a-zA-Z\-\+.]+:\/\//;class ServerXhr{build(){return new xhr2__namespace.XMLHttpRequest}}
ServerXhr.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServerXhr,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});ServerXhr.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServerXhr});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServerXhr,decorators:[{type:i0.Injectable}]});
class ZoneMacroTaskWrapper{wrap(request){return new rxjs.Observable(observer=>{let task=null;let scheduled=false;let sub=null;let savedResult=null;let savedError=null;const scheduleTask=_task=>{task=_task;scheduled=true;const delegate=this.delegate(request);sub=delegate.subscribe(res=>savedResult=res,err=>{if(!scheduled)throw new Error("An http observable was completed twice. This shouldn't happen, please file a bug.");savedError=err;scheduled=false;task.invoke()},()=>{if(!scheduled)throw new Error("An http observable was completed twice. This shouldn't happen, please file a bug.");
scheduled=false;task.invoke()})};const cancelTask=_task=>{if(!scheduled)return;scheduled=false;if(sub){sub.unsubscribe();sub=null}};const onComplete=()=>{if(savedError!==null)observer.error(savedError);else{observer.next(savedResult);observer.complete()}};const _task=Zone.current.scheduleMacroTask("ZoneMacroTaskWrapper.subscribe",onComplete,{},()=>null,cancelTask);scheduleTask(_task);return()=>{if(scheduled&&task){task.zone.cancelTask(task);scheduled=false}if(sub){sub.unsubscribe();sub=null}}})}}
class ZoneClientBackend extends ZoneMacroTaskWrapper{constructor(backend,platformLocation,config){super();this.backend=backend;this.platformLocation=platformLocation;this.config=config}handle(request){const {href,protocol,hostname,port}=this.platformLocation;if(this.config.useAbsoluteUrl&&!isAbsoluteUrl.test(request.url)&&isAbsoluteUrl.test(href)){const baseHref=this.platformLocation.getBaseHrefFromDOM()||href;const urlPrefix=`${protocol}//${hostname}`+(port?`:${port}`:"");const baseUrl=new URL(baseHref,
urlPrefix);const url=new URL(request.url,baseUrl);return this.wrap(request.clone({url:url.toString()}))}return this.wrap(request)}delegate(request){return this.backend.handle(request)}}function zoneWrappedInterceptingHandler(backend,injector,platformLocation,config){const realBackend=new http["ɵHttpInterceptingHandler"](backend,injector);return new ZoneClientBackend(realBackend,platformLocation,config)}const SERVER_HTTP_PROVIDERS=[{provide:common.XhrFactory,useClass:ServerXhr},{provide:http.HttpHandler,
useFactory:zoneWrappedInterceptingHandler,deps:[http.HttpBackend,i0.Injector,common.PlatformLocation,INITIAL_CONFIG]}];function parseUrl(urlStr){const parsedUrl=url__namespace.parse(urlStr);return{hostname:parsedUrl.hostname||"",protocol:parsedUrl.protocol||"",port:parsedUrl.port||"",pathname:parsedUrl.pathname||"",search:parsedUrl.search||"",hash:parsedUrl.hash||""}}class ServerPlatformLocation{constructor(_doc,_config){this._doc=_doc;this.href="/";this.hostname="/";this.protocol="/";this.port="/";
this.pathname="/";this.search="";this.hash="";this._hashUpdate=new rxjs.Subject;const config=_config;if(!config)return;if(config.url){const url=parseUrl(config.url);this.protocol=url.protocol;this.hostname=url.hostname;this.port=url.port;this.pathname=url.pathname;this.search=url.search;this.hash=url.hash;this.href=_doc.location.href}if(config.useAbsoluteUrl){if(!config.baseUrl)throw new Error(`"PlatformConfig.baseUrl" must be set if "useAbsoluteUrl" is true`);const url=parseUrl(config.baseUrl);this.protocol=
url.protocol;this.hostname=url.hostname;this.port=url.port}}getBaseHrefFromDOM(){return common["ɵgetDOM"]().getBaseHref(this._doc)}onPopState(fn){return()=>{}}onHashChange(fn){const subscription=this._hashUpdate.subscribe(fn);return()=>subscription.unsubscribe()}get url(){return`${this.pathname}${this.search}${this.hash}`}setHash(value,oldUrl){if(this.hash===value)return;this.hash=value;const newUrl=this.url;scheduleMicroTask(()=>this._hashUpdate.next({type:"hashchange",state:null,oldUrl,newUrl}))}replaceState(state,
title,newUrl){const oldUrl=this.url;const parsedUrl=parseUrl(newUrl);this.pathname=parsedUrl.pathname;this.search=parsedUrl.search;this.setHash(parsedUrl.hash,oldUrl)}pushState(state,title,newUrl){this.replaceState(state,title,newUrl)}forward(){throw new Error("Not implemented");}back(){throw new Error("Not implemented");}getState(){return undefined}}ServerPlatformLocation.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServerPlatformLocation,
deps:[{token:common.DOCUMENT},{token:INITIAL_CONFIG,optional:true}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});ServerPlatformLocation.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServerPlatformLocation});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServerPlatformLocation,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:undefined,
decorators:[{type:i0.Inject,args:[common.DOCUMENT]}]},{type:undefined,decorators:[{type:i0.Optional},{type:i0.Inject,args:[INITIAL_CONFIG]}]}]}});function scheduleMicroTask(fn){Zone.current.scheduleMicroTask("scheduleMicrotask",fn)}class ServerEventManagerPlugin{constructor(doc){this.doc=doc}supports(eventName){return true}addEventListener(element,eventName,handler){return common["ɵgetDOM"]().onAndCancel(element,eventName,handler)}addGlobalEventListener(element,eventName,handler){const target=common["ɵgetDOM"]().getGlobalEventTarget(this.doc,
element);if(!target)throw new Error(`Unsupported event target ${target} for event ${eventName}`);return this.addEventListener(target,eventName,handler)}}ServerEventManagerPlugin.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServerEventManagerPlugin,deps:[{token:common.DOCUMENT}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});ServerEventManagerPlugin.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",
version:"13.1.1",ngImport:i0__namespace,type:ServerEventManagerPlugin});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServerEventManagerPlugin,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:undefined,decorators:[{type:i0.Inject,args:[common.DOCUMENT]}]}]}});const EMPTY_ARRAY=[];const DEFAULT_SCHEMA=new compiler.DomElementSchemaRegistry;class ServerRendererFactory2{constructor(eventManager,ngZone,document,
sharedStylesHost){this.eventManager=eventManager;this.ngZone=ngZone;this.document=document;this.sharedStylesHost=sharedStylesHost;this.rendererByCompId=new Map;this.schema=DEFAULT_SCHEMA;this.defaultRenderer=new DefaultServerRenderer2(eventManager,document,ngZone,this.schema)}createRenderer(element,type){if(!element||!type)return this.defaultRenderer;switch(type.encapsulation){case i0.ViewEncapsulation.Emulated:{let renderer=this.rendererByCompId.get(type.id);if(!renderer){renderer=new EmulatedEncapsulationServerRenderer2(this.eventManager,
this.document,this.ngZone,this.sharedStylesHost,this.schema,type);this.rendererByCompId.set(type.id,renderer)}renderer.applyToHost(element);return renderer}default:{if(!this.rendererByCompId.has(type.id)){const styles=i1["ɵflattenStyles"](type.id,type.styles,[]);this.sharedStylesHost.addStyles(styles);this.rendererByCompId.set(type.id,this.defaultRenderer)}return this.defaultRenderer}}}begin(){}end(){}}ServerRendererFactory2.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",
version:"13.1.1",ngImport:i0__namespace,type:ServerRendererFactory2,deps:[{token:i1__namespace.EventManager},{token:i0__namespace.NgZone},{token:common.DOCUMENT},{token:i1__namespace.\u0275SharedStylesHost}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});ServerRendererFactory2.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServerRendererFactory2});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",
version:"13.1.1",ngImport:i0__namespace,type:ServerRendererFactory2,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:i1__namespace.EventManager},{type:i0__namespace.NgZone},{type:undefined,decorators:[{type:i0.Inject,args:[common.DOCUMENT]}]},{type:i1__namespace.\u0275SharedStylesHost}]}});class DefaultServerRenderer2{constructor(eventManager,document,ngZone,schema){this.eventManager=eventManager;this.document=document;this.ngZone=ngZone;this.schema=schema;this.data=Object.create(null);
this.destroyNode=null}destroy(){}createElement(name,namespace,debugInfo){if(namespace){const doc=this.document||common["ɵgetDOM"]().getDefaultDocument();return doc.createElementNS(i1["ɵNAMESPACE_URIS"][namespace],name)}return common["ɵgetDOM"]().createElement(name,this.document)}createComment(value,debugInfo){return common["ɵgetDOM"]().getDefaultDocument().createComment(value)}createText(value,debugInfo){const doc=common["ɵgetDOM"]().getDefaultDocument();return doc.createTextNode(value)}appendChild(parent,
newChild){parent.appendChild(newChild)}insertBefore(parent,newChild,refChild){if(parent)parent.insertBefore(newChild,refChild)}removeChild(parent,oldChild){if(parent)parent.removeChild(oldChild)}selectRootElement(selectorOrNode,debugInfo){let el;if(typeof selectorOrNode==="string"){el=this.document.querySelector(selectorOrNode);if(!el)throw new Error(`The selector "${selectorOrNode}" did not match any elements`);}else el=selectorOrNode;while(el.firstChild)el.removeChild(el.firstChild);return el}parentNode(node){return node.parentNode}nextSibling(node){return node.nextSibling}setAttribute(el,
name,value,namespace){if(namespace)el.setAttributeNS(i1["ɵNAMESPACE_URIS"][namespace],namespace+":"+name,value);else el.setAttribute(name,value)}removeAttribute(el,name,namespace){if(namespace)el.removeAttributeNS(i1["ɵNAMESPACE_URIS"][namespace],name);else el.removeAttribute(name)}addClass(el,name){el.classList.add(name)}removeClass(el,name){el.classList.remove(name)}setStyle(el,style,value,flags){style=style.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase();const styleMap=_readStyleAttribute(el);
if(flags&i0.RendererStyleFlags2.Important)value+=" !important";styleMap[style]=value==null?"":value;_writeStyleAttribute(el,styleMap)}removeStyle(el,style,flags){this.setStyle(el,style,"",flags)}_isSafeToReflectProperty(tagName,propertyName){return this.schema.securityContext(tagName,propertyName,true)===this.schema.securityContext(tagName,propertyName,false)}setProperty(el,name,value){checkNoSyntheticProp(name,"property");if(name==="innerText")el.textContent=value;el[name]=value;const tagName=el.tagName.toLowerCase();
if(value!=null&&(typeof value==="number"||typeof value=="string")&&name.toLowerCase()!=="innerhtml"&&this.schema.hasElement(tagName,EMPTY_ARRAY)&&this.schema.hasProperty(tagName,name,EMPTY_ARRAY)&&this._isSafeToReflectProperty(tagName,name))this.setAttribute(el,name,value.toString())}setValue(node,value){node.textContent=value}listen(target,eventName,callback){checkNoSyntheticProp(eventName,"listener");if(typeof target==="string")return this.eventManager.addGlobalEventListener(target,eventName,this.decoratePreventDefault(callback));
return this.eventManager.addEventListener(target,eventName,this.decoratePreventDefault(callback))}decoratePreventDefault(eventHandler){return event=>{if(event===Function)return eventHandler;const allowDefaultBehavior=this.ngZone.runGuarded(()=>eventHandler(event));if(allowDefaultBehavior===false){event.preventDefault();event.returnValue=false}return undefined}}}const AT_CHARCODE="@".charCodeAt(0);function checkNoSyntheticProp(name,nameKind){if(name.charCodeAt(0)===AT_CHARCODE)throw new Error(`Unexpected synthetic ${nameKind} ${name} found. Please make sure that:
  - Either \`BrowserAnimationsModule\` or \`NoopAnimationsModule\` are imported in your application.
  - There is corresponding configuration for the animation named \`${name}\` defined in the \`animations\` field of the \`@Component\` decorator (see https://angular.io/api/core/Component#animations).`);}class EmulatedEncapsulationServerRenderer2 extends DefaultServerRenderer2{constructor(eventManager,document,ngZone,sharedStylesHost,schema,component){super(eventManager,document,ngZone,schema);this.component=component;const componentId="s"+component.id;const styles=i1["ɵflattenStyles"](componentId,
component.styles,[]);sharedStylesHost.addStyles(styles);this.contentAttr=i1["ɵshimContentAttribute"](componentId);this.hostAttr=i1["ɵshimHostAttribute"](componentId)}applyToHost(element){super.setAttribute(element,this.hostAttr,"")}createElement(parent,name){const el=super.createElement(parent,name,this.document);super.setAttribute(el,this.contentAttr,"");return el}}function _readStyleAttribute(element){const styleMap={};const styleAttribute=element.getAttribute("style");if(styleAttribute){const styleList=
styleAttribute.split(/;+/g);for(let i=0;i<styleList.length;i++){const style=styleList[i].trim();if(style.length>0){const colonIndex=style.indexOf(":");if(colonIndex===-1)throw new Error(`Invalid CSS style: ${style}`);const name=style.substr(0,colonIndex).trim();styleMap[name]=style.substr(colonIndex+1).trim()}}}return styleMap}function _writeStyleAttribute(element,styleMap){let styleAttrValue="";for(const key in styleMap){const newValue=styleMap[key];if(newValue!=null)styleAttrValue+=key+":"+styleMap[key]+
";"}element.setAttribute("style",styleAttrValue)}class ServerStylesHost extends i1["ɵSharedStylesHost"]{constructor(doc,transitionId){super();this.doc=doc;this.transitionId=transitionId;this.head=null;this._styleNodes=new Set;this.head=doc.getElementsByTagName("head")[0]}_addStyle(style){let adapter=common["ɵgetDOM"]();const el=adapter.createElement("style");el.textContent=style;if(!!this.transitionId)el.setAttribute("ng-transition",this.transitionId);this.head.appendChild(el);this._styleNodes.add(el)}onStylesAdded(additions){additions.forEach(style=>
this._addStyle(style))}ngOnDestroy(){this._styleNodes.forEach(styleNode=>styleNode.remove())}}ServerStylesHost.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServerStylesHost,deps:[{token:common.DOCUMENT},{token:i1["ɵTRANSITION_ID"],optional:true}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});ServerStylesHost.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,
type:ServerStylesHost});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServerStylesHost,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:undefined,decorators:[{type:i0.Inject,args:[common.DOCUMENT]}]},{type:undefined,decorators:[{type:i0.Optional},{type:i0.Inject,args:[i1["ɵTRANSITION_ID"]]}]}]}});const INTERNAL_SERVER_PLATFORM_PROVIDERS=[{provide:common.DOCUMENT,useFactory:_document,deps:[i0.Injector]},{provide:i0.PLATFORM_ID,
useValue:common["ɵPLATFORM_SERVER_ID"]},{provide:i0.PLATFORM_INITIALIZER,useFactory:initDominoAdapter,multi:true,deps:[i0.Injector]},{provide:common.PlatformLocation,useClass:ServerPlatformLocation,deps:[common.DOCUMENT,[i0.Optional,INITIAL_CONFIG]]},{provide:PlatformState,deps:[common.DOCUMENT]},{provide:i0["ɵALLOW_MULTIPLE_PLATFORMS"],useValue:true}];function initDominoAdapter(injector){return()=>{DominoAdapter.makeCurrent()}}function instantiateServerRendererFactory(renderer,engine,zone){return new animations["ɵAnimationRendererFactory"](renderer,
engine,zone)}const SERVER_RENDER_PROVIDERS=[ServerRendererFactory2,{provide:i0.RendererFactory2,useFactory:instantiateServerRendererFactory,deps:[ServerRendererFactory2,browser["ɵAnimationEngine"],i0.NgZone]},ServerStylesHost,{provide:i1["ɵSharedStylesHost"],useExisting:ServerStylesHost},{provide:i1.EVENT_MANAGER_PLUGINS,multi:true,useClass:ServerEventManagerPlugin}];class ServerModule{}ServerModule.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,
type:ServerModule,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.NgModule});ServerModule.\u0275mod=i0__namespace.\u0275\u0275ngDeclareNgModule({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServerModule,imports:[http.HttpClientModule,animations.NoopAnimationsModule],exports:[i1.BrowserModule]});ServerModule.\u0275inj=i0__namespace.\u0275\u0275ngDeclareInjector({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServerModule,providers:[SERVER_RENDER_PROVIDERS,
SERVER_HTTP_PROVIDERS,{provide:i0.Testability,useValue:null},{provide:common.ViewportScroller,useClass:common["ɵNullViewportScroller"]}],imports:[[http.HttpClientModule,animations.NoopAnimationsModule],i1.BrowserModule]});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServerModule,decorators:[{type:i0.NgModule,args:[{exports:[i1.BrowserModule],imports:[http.HttpClientModule,animations.NoopAnimationsModule],providers:[SERVER_RENDER_PROVIDERS,
SERVER_HTTP_PROVIDERS,{provide:i0.Testability,useValue:null},{provide:common.ViewportScroller,useClass:common["ɵNullViewportScroller"]}]}]}]});function _document(injector){let config=injector.get(INITIAL_CONFIG,null);const document=config&&config.document?parseDocument(config.document,config.url):common["ɵgetDOM"]().createHtmlDocument();i0["ɵsetDocument"](document);return document}const platformServer=i0.createPlatformFactory(i0.platformCore,"server",INTERNAL_SERVER_PLATFORM_PROVIDERS);const platformDynamicServer=
i0.createPlatformFactory(platformBrowserDynamic["ɵplatformCoreDynamic"],"serverDynamic",INTERNAL_SERVER_PLATFORM_PROVIDERS);function serializeTransferStateFactory(doc,appId,transferStore){return()=>{const script=doc.createElement("script");script.id=appId+"-state";script.setAttribute("type","application/json");script.textContent=i1["ɵescapeHtml"](transferStore.toJson());doc.body.appendChild(script)}}class ServerTransferStateModule{}ServerTransferStateModule.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",
version:"13.1.1",ngImport:i0__namespace,type:ServerTransferStateModule,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.NgModule});ServerTransferStateModule.\u0275mod=i0__namespace.\u0275\u0275ngDeclareNgModule({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServerTransferStateModule});ServerTransferStateModule.\u0275inj=i0__namespace.\u0275\u0275ngDeclareInjector({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServerTransferStateModule,providers:[i1.TransferState,
{provide:BEFORE_APP_SERIALIZED,useFactory:serializeTransferStateFactory,deps:[common.DOCUMENT,i0.APP_ID,i1.TransferState],multi:true}]});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServerTransferStateModule,decorators:[{type:i0.NgModule,args:[{providers:[i1.TransferState,{provide:BEFORE_APP_SERIALIZED,useFactory:serializeTransferStateFactory,deps:[common.DOCUMENT,i0.APP_ID,i1.TransferState],multi:true}]}]}]});function _getPlatform(platformFactory,
options){const extraProviders=options.extraProviders?options.extraProviders:[];return platformFactory([{provide:INITIAL_CONFIG,useValue:{document:options.document,url:options.url}},extraProviders])}function _render(platform,moduleRefPromise){return moduleRefPromise.then(moduleRef=>{const transitionId=moduleRef.injector.get(i1["ɵTRANSITION_ID"],null);if(!transitionId)throw new Error(`renderModule[Factory]() requires the use of BrowserModule.withServerTransition() to ensure
the server-rendered app can be properly bootstrapped into a client app.`);const applicationRef=moduleRef.injector.get(i0.ApplicationRef);return applicationRef.isStable.pipe(operators.first(isStable=>isStable)).toPromise().then(()=>{const platformState=platform.injector.get(PlatformState);const asyncPromises=[];const callbacks=moduleRef.injector.get(BEFORE_APP_SERIALIZED,null);if(callbacks)for(const callback of callbacks)try{const callbackResult=callback();if(i0["ɵisPromise"](callbackResult))asyncPromises.push(callbackResult)}catch(e){console.warn("Ignoring BEFORE_APP_SERIALIZED Exception: ",
e)}const complete=()=>{const output=platformState.renderToString();platform.destroy();return output};if(asyncPromises.length===0)return complete();return Promise.all(asyncPromises.map(asyncPromise=>{return asyncPromise.catch(e=>{console.warn("Ignoring BEFORE_APP_SERIALIZED Exception: ",e)})})).then(complete)})})}function renderModule(module,options){const platform=_getPlatform(platformDynamicServer,options);return _render(platform,platform.bootstrapModule(module))}function renderModuleFactory(moduleFactory,
options){const platform=_getPlatform(platformServer,options);return _render(platform,platform.bootstrapModuleFactory(moduleFactory))}const VERSION=new i0.Version("13.1.1");exports.BEFORE_APP_SERIALIZED=BEFORE_APP_SERIALIZED;exports.INITIAL_CONFIG=INITIAL_CONFIG;exports.PlatformState=PlatformState;exports.ServerModule=ServerModule;exports.ServerTransferStateModule=ServerTransferStateModule;exports.VERSION=VERSION;exports.platformDynamicServer=platformDynamicServer;exports.platformServer=platformServer;
exports.renderModule=renderModule;exports.renderModuleFactory=renderModuleFactory;exports["ɵINTERNAL_SERVER_PLATFORM_PROVIDERS"]=INTERNAL_SERVER_PLATFORM_PROVIDERS;exports["ɵSERVER_RENDER_PROVIDERS"]=SERVER_RENDER_PROVIDERS;exports["ɵServerRendererFactory2"]=ServerRendererFactory2;Object.defineProperty(exports,"__esModule",{value:true})});

