/*

 Copyright Google LLC All Rights Reserved.

 Use of this source code is governed by an MIT-style license that can be
 found in the LICENSE file at https://angular.io/license
 Angular v13.1.1
 (c) 2010-2021 Google LLC. https://angular.io/
 License: MIT
*/
'use strict';(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports,require("@angular/common"),require("@angular/core"),require("rxjs"),require("rxjs/operators")):typeof define==="function"&&define.amd?define(["exports","@angular/common","@angular/core","rxjs","rxjs/operators"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory((global.ng=global.ng||{},global.ng.serviceWorker={}),global.common,global.i0,global.rxjs,global.operators))})(this,
function(exports,common,i0,rxjs,operators){function _interopNamespace(e){if(e&&e.__esModule)return e;var n=Object.create(null);if(e)Object.keys(e).forEach(function(k){if(k!=="default"){var d=Object.getOwnPropertyDescriptor(e,k);Object.defineProperty(n,k,d.get?d:{enumerable:true,get:function(){return e[k]}})}});n["default"]=e;return Object.freeze(n)}var i0__namespace=_interopNamespace(i0);const ERR_SW_NOT_SUPPORTED="Service workers are disabled or not supported by this browser";function errorObservable(message){return rxjs.defer(()=>
rxjs.throwError(new Error(message)))}class NgswCommChannel{constructor(serviceWorker){this.serviceWorker=serviceWorker;if(!serviceWorker)this.worker=this.events=this.registration=errorObservable(ERR_SW_NOT_SUPPORTED);else{const controllerChangeEvents=rxjs.fromEvent(serviceWorker,"controllerchange");const controllerChanges=controllerChangeEvents.pipe(operators.map(()=>serviceWorker.controller));const currentController=rxjs.defer(()=>rxjs.of(serviceWorker.controller));const controllerWithChanges=rxjs.concat(currentController,
controllerChanges);this.worker=controllerWithChanges.pipe(operators.filter(c=>!!c));this.registration=this.worker.pipe(operators.switchMap(()=>serviceWorker.getRegistration()));const rawEvents=rxjs.fromEvent(serviceWorker,"message");const rawEventPayload=rawEvents.pipe(operators.map(event=>event.data));const eventsUnconnected=rawEventPayload.pipe(operators.filter(event=>event&&event.type));const events=eventsUnconnected.pipe(operators.publish());events.connect();this.events=events}}postMessage(action,
payload){return this.worker.pipe(operators.take(1),operators.tap(sw=>{sw.postMessage(Object.assign({action},payload))})).toPromise().then(()=>undefined)}postMessageWithOperation(type,payload,operationNonce){const waitForOperationCompleted=this.waitForOperationCompleted(operationNonce);const postMessage=this.postMessage(type,payload);return Promise.all([postMessage,waitForOperationCompleted]).then(([,result])=>result)}generateNonce(){return Math.round(Math.random()*1E7)}eventsOfType(type){let filterFn;
if(typeof type==="string")filterFn=event=>event.type===type;else filterFn=event=>type.includes(event.type);return this.events.pipe(operators.filter(filterFn))}nextEventOfType(type){return this.eventsOfType(type).pipe(operators.take(1))}waitForOperationCompleted(nonce){return this.eventsOfType("OPERATION_COMPLETED").pipe(operators.filter(event=>event.nonce===nonce),operators.take(1),operators.map(event=>{if(event.result!==undefined)return event.result;throw new Error(event.error);})).toPromise()}get isEnabled(){return!!this.serviceWorker}}
class SwPush{constructor(sw){this.sw=sw;this.subscriptionChanges=new rxjs.Subject;if(!sw.isEnabled){this.messages=rxjs.NEVER;this.notificationClicks=rxjs.NEVER;this.subscription=rxjs.NEVER;return}this.messages=this.sw.eventsOfType("PUSH").pipe(operators.map(message=>message.data));this.notificationClicks=this.sw.eventsOfType("NOTIFICATION_CLICK").pipe(operators.map(message=>message.data));this.pushManager=this.sw.registration.pipe(operators.map(registration=>registration.pushManager));const workerDrivenSubscriptions=
this.pushManager.pipe(operators.switchMap(pm=>pm.getSubscription()));this.subscription=rxjs.merge(workerDrivenSubscriptions,this.subscriptionChanges)}get isEnabled(){return this.sw.isEnabled}requestSubscription(options){if(!this.sw.isEnabled)return Promise.reject(new Error(ERR_SW_NOT_SUPPORTED));const pushOptions={userVisibleOnly:true};let key=this.decodeBase64(options.serverPublicKey.replace(/_/g,"/").replace(/-/g,"+"));let applicationServerKey=new Uint8Array(new ArrayBuffer(key.length));for(let i=
0;i<key.length;i++)applicationServerKey[i]=key.charCodeAt(i);pushOptions.applicationServerKey=applicationServerKey;return this.pushManager.pipe(operators.switchMap(pm=>pm.subscribe(pushOptions)),operators.take(1)).toPromise().then(sub=>{this.subscriptionChanges.next(sub);return sub})}unsubscribe(){if(!this.sw.isEnabled)return Promise.reject(new Error(ERR_SW_NOT_SUPPORTED));const doUnsubscribe=sub=>{if(sub===null)throw new Error("Not subscribed to push notifications.");return sub.unsubscribe().then(success=>
{if(!success)throw new Error("Unsubscribe failed!");this.subscriptionChanges.next(null)})};return this.subscription.pipe(operators.take(1),operators.switchMap(doUnsubscribe)).toPromise()}decodeBase64(input){return atob(input)}}SwPush.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:SwPush,deps:[{token:NgswCommChannel}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});SwPush.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",
version:"13.1.1",ngImport:i0__namespace,type:SwPush});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:SwPush,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:NgswCommChannel}]}});class SwUpdate{constructor(sw){this.sw=sw;if(!sw.isEnabled){this.versionUpdates=rxjs.NEVER;this.available=rxjs.NEVER;this.activated=rxjs.NEVER;this.unrecoverable=rxjs.NEVER;return}this.versionUpdates=this.sw.eventsOfType(["VERSION_DETECTED",
"VERSION_INSTALLATION_FAILED","VERSION_READY"]);this.available=this.versionUpdates.pipe(operators.filter(evt=>evt.type==="VERSION_READY"),operators.map(evt=>({type:"UPDATE_AVAILABLE",current:evt.currentVersion,available:evt.latestVersion})));this.activated=this.sw.eventsOfType("UPDATE_ACTIVATED");this.unrecoverable=this.sw.eventsOfType("UNRECOVERABLE_STATE")}get isEnabled(){return this.sw.isEnabled}checkForUpdate(){if(!this.sw.isEnabled)return Promise.reject(new Error(ERR_SW_NOT_SUPPORTED));const nonce=
this.sw.generateNonce();return this.sw.postMessageWithOperation("CHECK_FOR_UPDATES",{nonce},nonce)}activateUpdate(){if(!this.sw.isEnabled)return Promise.reject(new Error(ERR_SW_NOT_SUPPORTED));const nonce=this.sw.generateNonce();return this.sw.postMessageWithOperation("ACTIVATE_UPDATE",{nonce},nonce)}}SwUpdate.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:SwUpdate,deps:[{token:NgswCommChannel}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});
SwUpdate.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:SwUpdate});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:SwUpdate,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:NgswCommChannel}]}});class SwRegistrationOptions{}const SCRIPT=new i0.InjectionToken("NGSW_REGISTER_SCRIPT");function ngswAppInitializer(injector,script,options,
platformId){const initializer=()=>{if(!(common.isPlatformBrowser(platformId)&&"serviceWorker"in navigator&&options.enabled!==false))return;navigator.serviceWorker.addEventListener("controllerchange",()=>{if(navigator.serviceWorker.controller!==null)navigator.serviceWorker.controller.postMessage({action:"INITIALIZE"})});let readyToRegister$;if(typeof options.registrationStrategy==="function")readyToRegister$=options.registrationStrategy();else{const [strategy,...args]=(options.registrationStrategy||
"registerWhenStable:30000").split(":");switch(strategy){case "registerImmediately":readyToRegister$=rxjs.of(null);break;case "registerWithDelay":readyToRegister$=delayWithTimeout(+args[0]||0);break;case "registerWhenStable":readyToRegister$=!args[0]?whenStable(injector):rxjs.merge(whenStable(injector),delayWithTimeout(+args[0]));break;default:throw new Error(`Unknown ServiceWorker registration strategy: ${options.registrationStrategy}`);}}const ngZone=injector.get(i0.NgZone);ngZone.runOutsideAngular(()=>
readyToRegister$.pipe(operators.take(1)).subscribe(()=>navigator.serviceWorker.register(script,{scope:options.scope}).catch(err=>console.error("Service worker registration failed with:",err))))};return initializer}function delayWithTimeout(timeout){return rxjs.of(null).pipe(operators.delay(timeout))}function whenStable(injector){const appRef=injector.get(i0.ApplicationRef);return appRef.isStable.pipe(operators.filter(stable=>stable))}function ngswCommChannelFactory(opts,platformId){return new NgswCommChannel(common.isPlatformBrowser(platformId)&&
opts.enabled!==false?navigator.serviceWorker:undefined)}class ServiceWorkerModule{static register(script,opts={}){return{ngModule:ServiceWorkerModule,providers:[{provide:SCRIPT,useValue:script},{provide:SwRegistrationOptions,useValue:opts},{provide:NgswCommChannel,useFactory:ngswCommChannelFactory,deps:[SwRegistrationOptions,i0.PLATFORM_ID]},{provide:i0.APP_INITIALIZER,useFactory:ngswAppInitializer,deps:[i0.Injector,SCRIPT,SwRegistrationOptions,i0.PLATFORM_ID],multi:true}]}}}ServiceWorkerModule.\u0275fac=
i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServiceWorkerModule,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.NgModule});ServiceWorkerModule.\u0275mod=i0__namespace.\u0275\u0275ngDeclareNgModule({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServiceWorkerModule});ServiceWorkerModule.\u0275inj=i0__namespace.\u0275\u0275ngDeclareInjector({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServiceWorkerModule,
providers:[SwPush,SwUpdate]});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.1",ngImport:i0__namespace,type:ServiceWorkerModule,decorators:[{type:i0.NgModule,args:[{providers:[SwPush,SwUpdate]}]}]});exports.ServiceWorkerModule=ServiceWorkerModule;exports.SwPush=SwPush;exports.SwRegistrationOptions=SwRegistrationOptions;exports.SwUpdate=SwUpdate;Object.defineProperty(exports,"__esModule",{value:true})});

