/*

 Copyright Google LLC All Rights Reserved.

 Use of this source code is governed by an MIT-style license that can be
 found in the LICENSE file at https://angular.io/license
 Angular v13.1.3
 (c) 2010-2022 Google LLC. https://angular.io/
 License: MIT
*/
'use strict';(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports):typeof define==="function"&&define.amd?define(["exports"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory((global.ng=global.ng||{},global.ng.animations={})))})(this,function(exports){class AnimationBuilder{}class AnimationFactory{}const AUTO_STYLE="*";function trigger(name,definitions){return{type:7,name,definitions,options:{}}}function animate(timings,styles=
null){return{type:4,styles,timings}}function group(steps,options=null){return{type:3,steps,options}}function sequence(steps,options=null){return{type:2,steps,options}}function style(tokens){return{type:6,styles:tokens,offset:null}}function state(name,styles,options){return{type:0,name,styles,options}}function keyframes(steps){return{type:5,steps}}function transition(stateChangeExpr,steps,options=null){return{type:1,expr:stateChangeExpr,animation:steps,options}}function animation(steps,options=null){return{type:8,
animation:steps,options}}function animateChild(options=null){return{type:9,options}}function useAnimation(animation,options=null){return{type:10,animation,options}}function query(selector,animation,options=null){return{type:11,selector,animation,options}}function stagger(timings,animation){return{type:12,timings,animation}}function scheduleMicroTask(cb){Promise.resolve(null).then(cb)}class NoopAnimationPlayer{constructor(duration=0,delay=0){this._onDoneFns=[];this._onStartFns=[];this._onDestroyFns=
[];this._started=false;this._destroyed=false;this._finished=false;this._position=0;this.parentPlayer=null;this.totalTime=duration+delay}_onFinish(){if(!this._finished){this._finished=true;this._onDoneFns.forEach(fn=>fn());this._onDoneFns=[]}}onStart(fn){this._onStartFns.push(fn)}onDone(fn){this._onDoneFns.push(fn)}onDestroy(fn){this._onDestroyFns.push(fn)}hasStarted(){return this._started}init(){}play(){if(!this.hasStarted()){this._onStart();this.triggerMicrotask()}this._started=true}triggerMicrotask(){scheduleMicroTask(()=>
this._onFinish())}_onStart(){this._onStartFns.forEach(fn=>fn());this._onStartFns=[]}pause(){}restart(){}finish(){this._onFinish()}destroy(){if(!this._destroyed){this._destroyed=true;if(!this.hasStarted())this._onStart();this.finish();this._onDestroyFns.forEach(fn=>fn());this._onDestroyFns=[]}}reset(){this._started=false}setPosition(position){this._position=this.totalTime?position*this.totalTime:1}getPosition(){return this.totalTime?this._position/this.totalTime:1}triggerCallback(phaseName){const methods=
phaseName=="start"?this._onStartFns:this._onDoneFns;methods.forEach(fn=>fn());methods.length=0}}class AnimationGroupPlayer{constructor(_players){this._onDoneFns=[];this._onStartFns=[];this._finished=false;this._started=false;this._destroyed=false;this._onDestroyFns=[];this.parentPlayer=null;this.totalTime=0;this.players=_players;let doneCount=0;let destroyCount=0;let startCount=0;const total=this.players.length;if(total==0)scheduleMicroTask(()=>this._onFinish());else this.players.forEach(player=>
{player.onDone(()=>{if(++doneCount==total)this._onFinish()});player.onDestroy(()=>{if(++destroyCount==total)this._onDestroy()});player.onStart(()=>{if(++startCount==total)this._onStart()})});this.totalTime=this.players.reduce((time,player)=>Math.max(time,player.totalTime),0)}_onFinish(){if(!this._finished){this._finished=true;this._onDoneFns.forEach(fn=>fn());this._onDoneFns=[]}}init(){this.players.forEach(player=>player.init())}onStart(fn){this._onStartFns.push(fn)}_onStart(){if(!this.hasStarted()){this._started=
true;this._onStartFns.forEach(fn=>fn());this._onStartFns=[]}}onDone(fn){this._onDoneFns.push(fn)}onDestroy(fn){this._onDestroyFns.push(fn)}hasStarted(){return this._started}play(){if(!this.parentPlayer)this.init();this._onStart();this.players.forEach(player=>player.play())}pause(){this.players.forEach(player=>player.pause())}restart(){this.players.forEach(player=>player.restart())}finish(){this._onFinish();this.players.forEach(player=>player.finish())}destroy(){this._onDestroy()}_onDestroy(){if(!this._destroyed){this._destroyed=
true;this._onFinish();this.players.forEach(player=>player.destroy());this._onDestroyFns.forEach(fn=>fn());this._onDestroyFns=[]}}reset(){this.players.forEach(player=>player.reset());this._destroyed=false;this._finished=false;this._started=false}setPosition(p){const timeAtPosition=p*this.totalTime;this.players.forEach(player=>{const position=player.totalTime?Math.min(1,timeAtPosition/player.totalTime):1;player.setPosition(position)})}getPosition(){const longestPlayer=this.players.reduce((longestSoFar,
player)=>{const newPlayerIsLongest=longestSoFar===null||player.totalTime>longestSoFar.totalTime;return newPlayerIsLongest?player:longestSoFar},null);return longestPlayer!=null?longestPlayer.getPosition():0}beforeDestroy(){this.players.forEach(player=>{if(player.beforeDestroy)player.beforeDestroy()})}triggerCallback(phaseName){const methods=phaseName=="start"?this._onStartFns:this._onDoneFns;methods.forEach(fn=>fn());methods.length=0}}const \u0275PRE_STYLE="!";exports.AUTO_STYLE=AUTO_STYLE;exports.AnimationBuilder=
AnimationBuilder;exports.AnimationFactory=AnimationFactory;exports.NoopAnimationPlayer=NoopAnimationPlayer;exports.animate=animate;exports.animateChild=animateChild;exports.animation=animation;exports.group=group;exports.keyframes=keyframes;exports.query=query;exports.sequence=sequence;exports.stagger=stagger;exports.state=state;exports.style=style;exports.transition=transition;exports.trigger=trigger;exports.useAnimation=useAnimation;exports["ɵAnimationGroupPlayer"]=AnimationGroupPlayer;exports["ɵPRE_STYLE"]=
\u0275PRE_STYLE;Object.defineProperty(exports,"__esModule",{value:true})});

