/*

 Copyright Google LLC All Rights Reserved.

 Use of this source code is governed by an MIT-style license that can be
 found in the LICENSE file at https://angular.io/license
 Angular v13.1.3
 (c) 2010-2022 Google LLC. https://angular.io/
 License: MIT
*/
'use strict';(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports,require("@angular/common"),require("@angular/core"),require("rxjs"),require("rxjs/operators")):typeof define==="function"&&define.amd?define(["exports","@angular/common","@angular/core","rxjs","rxjs/operators"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory((global.ng=global.ng||{},global.ng.commonHttp={}),global.i1,global.i0,global.rxjs,global.operators))})(this,
function(exports,i1,i0,rxjs,operators){function _interopNamespace(e){if(e&&e.__esModule)return e;var n=Object.create(null);if(e)Object.keys(e).forEach(function(k){if(k!=="default"){var d=Object.getOwnPropertyDescriptor(e,k);Object.defineProperty(n,k,d.get?d:{enumerable:true,get:function(){return e[k]}})}});n["default"]=e;return Object.freeze(n)}var i1__namespace=_interopNamespace(i1);var i0__namespace=_interopNamespace(i0);class HttpHandler{}class HttpBackend{}class HttpHeaders{constructor(headers){this.normalizedNames=
new Map;this.lazyUpdate=null;if(!headers)this.headers=new Map;else if(typeof headers==="string")this.lazyInit=()=>{this.headers=new Map;headers.split("\n").forEach(line=>{const index=line.indexOf(":");if(index>0){const name=line.slice(0,index);const key=name.toLowerCase();const value=line.slice(index+1).trim();this.maybeSetNormalizedName(name,key);if(this.headers.has(key))this.headers.get(key).push(value);else this.headers.set(key,[value])}})};else this.lazyInit=()=>{this.headers=new Map;Object.keys(headers).forEach(name=>
{let values=headers[name];const key=name.toLowerCase();if(typeof values==="string")values=[values];if(values.length>0){this.headers.set(key,values);this.maybeSetNormalizedName(name,key)}})}}has(name){this.init();return this.headers.has(name.toLowerCase())}get(name){this.init();const values=this.headers.get(name.toLowerCase());return values&&values.length>0?values[0]:null}keys(){this.init();return Array.from(this.normalizedNames.values())}getAll(name){this.init();return this.headers.get(name.toLowerCase())||
null}append(name,value){return this.clone({name,value,op:"a"})}set(name,value){return this.clone({name,value,op:"s"})}delete(name,value){return this.clone({name,value,op:"d"})}maybeSetNormalizedName(name,lcName){if(!this.normalizedNames.has(lcName))this.normalizedNames.set(lcName,name)}init(){if(!!this.lazyInit){if(this.lazyInit instanceof HttpHeaders)this.copyFrom(this.lazyInit);else this.lazyInit();this.lazyInit=null;if(!!this.lazyUpdate){this.lazyUpdate.forEach(update=>this.applyUpdate(update));
this.lazyUpdate=null}}}copyFrom(other){other.init();Array.from(other.headers.keys()).forEach(key=>{this.headers.set(key,other.headers.get(key));this.normalizedNames.set(key,other.normalizedNames.get(key))})}clone(update){const clone=new HttpHeaders;clone.lazyInit=!!this.lazyInit&&this.lazyInit instanceof HttpHeaders?this.lazyInit:this;clone.lazyUpdate=(this.lazyUpdate||[]).concat([update]);return clone}applyUpdate(update){const key=update.name.toLowerCase();switch(update.op){case "a":case "s":let value=
update.value;if(typeof value==="string")value=[value];if(value.length===0)return;this.maybeSetNormalizedName(update.name,key);const base=(update.op==="a"?this.headers.get(key):undefined)||[];base.push(...value);this.headers.set(key,base);break;case "d":const toDelete=update.value;if(!toDelete){this.headers.delete(key);this.normalizedNames.delete(key)}else{let existing=this.headers.get(key);if(!existing)return;existing=existing.filter(value=>toDelete.indexOf(value)===-1);if(existing.length===0){this.headers.delete(key);
this.normalizedNames.delete(key)}else this.headers.set(key,existing)}break}}forEach(fn){this.init();Array.from(this.normalizedNames.keys()).forEach(key=>fn(this.normalizedNames.get(key),this.headers.get(key)))}}class HttpUrlEncodingCodec{encodeKey(key){return standardEncoding(key)}encodeValue(value){return standardEncoding(value)}decodeKey(key){return decodeURIComponent(key)}decodeValue(value){return decodeURIComponent(value)}}function paramParser(rawParams,codec){const map=new Map;if(rawParams.length>
0){const params=rawParams.replace(/^\?/,"").split("&");params.forEach(param=>{const eqIdx=param.indexOf("=");const [key,val]=eqIdx==-1?[codec.decodeKey(param),""]:[codec.decodeKey(param.slice(0,eqIdx)),codec.decodeValue(param.slice(eqIdx+1))];const list=map.get(key)||[];list.push(val);map.set(key,list)})}return map}const STANDARD_ENCODING_REGEX=/%(\d[a-f0-9])/gi;const STANDARD_ENCODING_REPLACEMENTS={40:"@","3A":":",24:"$","2C":",","3B":";","2B":"+","3D":"=","3F":"?","2F":"/"};function standardEncoding(v){return encodeURIComponent(v).replace(STANDARD_ENCODING_REGEX,
(s,t)=>{var _a;return(_a=STANDARD_ENCODING_REPLACEMENTS[t])!==null&&_a!==void 0?_a:s})}function valueToString(value){return`${value}`}class HttpParams{constructor(options={}){this.updates=null;this.cloneFrom=null;this.encoder=options.encoder||new HttpUrlEncodingCodec;if(!!options.fromString){if(!!options.fromObject)throw new Error(`Cannot specify both fromString and fromObject.`);this.map=paramParser(options.fromString,this.encoder)}else if(!!options.fromObject){this.map=new Map;Object.keys(options.fromObject).forEach(key=>
{const value=options.fromObject[key];this.map.set(key,Array.isArray(value)?value:[value])})}else this.map=null}has(param){this.init();return this.map.has(param)}get(param){this.init();const res=this.map.get(param);return!!res?res[0]:null}getAll(param){this.init();return this.map.get(param)||null}keys(){this.init();return Array.from(this.map.keys())}append(param,value){return this.clone({param,value,op:"a"})}appendAll(params){const updates=[];Object.keys(params).forEach(param=>{const value=params[param];
if(Array.isArray(value))value.forEach(_value=>{updates.push({param,value:_value,op:"a"})});else updates.push({param,value:value,op:"a"})});return this.clone(updates)}set(param,value){return this.clone({param,value,op:"s"})}delete(param,value){return this.clone({param,value,op:"d"})}toString(){this.init();return this.keys().map(key=>{const eKey=this.encoder.encodeKey(key);return this.map.get(key).map(value=>eKey+"="+this.encoder.encodeValue(value)).join("&")}).filter(param=>param!=="").join("&")}clone(update){const clone=
new HttpParams({encoder:this.encoder});clone.cloneFrom=this.cloneFrom||this;clone.updates=(this.updates||[]).concat(update);return clone}init(){if(this.map===null)this.map=new Map;if(this.cloneFrom!==null){this.cloneFrom.init();this.cloneFrom.keys().forEach(key=>this.map.set(key,this.cloneFrom.map.get(key)));this.updates.forEach(update=>{switch(update.op){case "a":case "s":const base=(update.op==="a"?this.map.get(update.param):undefined)||[];base.push(valueToString(update.value));this.map.set(update.param,
base);break;case "d":if(update.value!==undefined){let base=this.map.get(update.param)||[];const idx=base.indexOf(valueToString(update.value));if(idx!==-1)base.splice(idx,1);if(base.length>0)this.map.set(update.param,base);else this.map.delete(update.param)}else{this.map.delete(update.param);break}}});this.cloneFrom=this.updates=null}}}class HttpContextToken{constructor(defaultValue){this.defaultValue=defaultValue}}class HttpContext{constructor(){this.map=new Map}set(token,value){this.map.set(token,
value);return this}get(token){if(!this.map.has(token))this.map.set(token,token.defaultValue());return this.map.get(token)}delete(token){this.map.delete(token);return this}has(token){return this.map.has(token)}keys(){return this.map.keys()}}function mightHaveBody(method){switch(method){case "DELETE":case "GET":case "HEAD":case "OPTIONS":case "JSONP":return false;default:return true}}function isArrayBuffer(value){return typeof ArrayBuffer!=="undefined"&&value instanceof ArrayBuffer}function isBlob(value){return typeof Blob!==
"undefined"&&value instanceof Blob}function isFormData(value){return typeof FormData!=="undefined"&&value instanceof FormData}function isUrlSearchParams(value){return typeof URLSearchParams!=="undefined"&&value instanceof URLSearchParams}class HttpRequest{constructor(method,url,third,fourth){this.url=url;this.body=null;this.reportProgress=false;this.withCredentials=false;this.responseType="json";this.method=method.toUpperCase();let options;if(mightHaveBody(this.method)||!!fourth){this.body=third!==
undefined?third:null;options=fourth}else options=third;if(options){this.reportProgress=!!options.reportProgress;this.withCredentials=!!options.withCredentials;if(!!options.responseType)this.responseType=options.responseType;if(!!options.headers)this.headers=options.headers;if(!!options.context)this.context=options.context;if(!!options.params)this.params=options.params}if(!this.headers)this.headers=new HttpHeaders;if(!this.context)this.context=new HttpContext;if(!this.params){this.params=new HttpParams;
this.urlWithParams=url}else{const params=this.params.toString();if(params.length===0)this.urlWithParams=url;else{const qIdx=url.indexOf("?");const sep=qIdx===-1?"?":qIdx<url.length-1?"&":"";this.urlWithParams=url+sep+params}}}serializeBody(){if(this.body===null)return null;if(isArrayBuffer(this.body)||isBlob(this.body)||isFormData(this.body)||isUrlSearchParams(this.body)||typeof this.body==="string")return this.body;if(this.body instanceof HttpParams)return this.body.toString();if(typeof this.body===
"object"||typeof this.body==="boolean"||Array.isArray(this.body))return JSON.stringify(this.body);return this.body.toString()}detectContentTypeHeader(){if(this.body===null)return null;if(isFormData(this.body))return null;if(isBlob(this.body))return this.body.type||null;if(isArrayBuffer(this.body))return null;if(typeof this.body==="string")return"text/plain";if(this.body instanceof HttpParams)return"application/x-www-form-urlencoded;charset=UTF-8";if(typeof this.body==="object"||typeof this.body===
"number"||typeof this.body==="boolean")return"application/json";return null}clone(update={}){var _a;const method=update.method||this.method;const url=update.url||this.url;const responseType=update.responseType||this.responseType;const body=update.body!==undefined?update.body:this.body;const withCredentials=update.withCredentials!==undefined?update.withCredentials:this.withCredentials;const reportProgress=update.reportProgress!==undefined?update.reportProgress:this.reportProgress;let headers=update.headers||
this.headers;let params=update.params||this.params;const context=(_a=update.context)!==null&&_a!==void 0?_a:this.context;if(update.setHeaders!==undefined)headers=Object.keys(update.setHeaders).reduce((headers,name)=>headers.set(name,update.setHeaders[name]),headers);if(update.setParams)params=Object.keys(update.setParams).reduce((params,param)=>params.set(param,update.setParams[param]),params);return new HttpRequest(method,url,body,{params,headers,context,reportProgress,responseType,withCredentials})}}
exports.HttpEventType=void 0;(function(HttpEventType){HttpEventType[HttpEventType["Sent"]=0]="Sent";HttpEventType[HttpEventType["UploadProgress"]=1]="UploadProgress";HttpEventType[HttpEventType["ResponseHeader"]=2]="ResponseHeader";HttpEventType[HttpEventType["DownloadProgress"]=3]="DownloadProgress";HttpEventType[HttpEventType["Response"]=4]="Response";HttpEventType[HttpEventType["User"]=5]="User"})(exports.HttpEventType||(exports.HttpEventType={}));class HttpResponseBase{constructor(init,defaultStatus=
200,defaultStatusText="OK"){this.headers=init.headers||new HttpHeaders;this.status=init.status!==undefined?init.status:defaultStatus;this.statusText=init.statusText||defaultStatusText;this.url=init.url||null;this.ok=this.status>=200&&this.status<300}}class HttpHeaderResponse extends HttpResponseBase{constructor(init={}){super(init);this.type=exports.HttpEventType.ResponseHeader}clone(update={}){return new HttpHeaderResponse({headers:update.headers||this.headers,status:update.status!==undefined?update.status:
this.status,statusText:update.statusText||this.statusText,url:update.url||this.url||undefined})}}class HttpResponse extends HttpResponseBase{constructor(init={}){super(init);this.type=exports.HttpEventType.Response;this.body=init.body!==undefined?init.body:null}clone(update={}){return new HttpResponse({body:update.body!==undefined?update.body:this.body,headers:update.headers||this.headers,status:update.status!==undefined?update.status:this.status,statusText:update.statusText||this.statusText,url:update.url||
this.url||undefined})}}class HttpErrorResponse extends HttpResponseBase{constructor(init){super(init,0,"Unknown Error");this.name="HttpErrorResponse";this.ok=false;if(this.status>=200&&this.status<300)this.message=`Http failure during parsing for ${init.url||"(unknown url)"}`;else this.message=`Http failure response for ${init.url||"(unknown url)"}: ${init.status} ${init.statusText}`;this.error=init.error||null}}function addBody(options,body){return{body,headers:options.headers,context:options.context,
observe:options.observe,params:options.params,reportProgress:options.reportProgress,responseType:options.responseType,withCredentials:options.withCredentials}}class HttpClient{constructor(handler){this.handler=handler}request(first,url,options={}){let req;if(first instanceof HttpRequest)req=first;else{let headers=undefined;if(options.headers instanceof HttpHeaders)headers=options.headers;else headers=new HttpHeaders(options.headers);let params=undefined;if(!!options.params)if(options.params instanceof
HttpParams)params=options.params;else params=new HttpParams({fromObject:options.params});req=new HttpRequest(first,url,options.body!==undefined?options.body:null,{headers,context:options.context,params,reportProgress:options.reportProgress,responseType:options.responseType||"json",withCredentials:options.withCredentials})}const events$=rxjs.of(req).pipe(operators.concatMap(req=>this.handler.handle(req)));if(first instanceof HttpRequest||options.observe==="events")return events$;const res$=events$.pipe(operators.filter(event=>
event instanceof HttpResponse));switch(options.observe||"body"){case "body":switch(req.responseType){case "arraybuffer":return res$.pipe(operators.map(res=>{if(res.body!==null&&!(res.body instanceof ArrayBuffer))throw new Error("Response is not an ArrayBuffer.");return res.body}));case "blob":return res$.pipe(operators.map(res=>{if(res.body!==null&&!(res.body instanceof Blob))throw new Error("Response is not a Blob.");return res.body}));case "text":return res$.pipe(operators.map(res=>{if(res.body!==
null&&typeof res.body!=="string")throw new Error("Response is not a string.");return res.body}));case "json":default:return res$.pipe(operators.map(res=>res.body))}case "response":return res$;default:throw new Error(`Unreachable: unhandled observe type ${options.observe}}`);}}delete(url,options={}){return this.request("DELETE",url,options)}get(url,options={}){return this.request("GET",url,options)}head(url,options={}){return this.request("HEAD",url,options)}jsonp(url,callbackParam){return this.request("JSONP",
url,{params:(new HttpParams).append(callbackParam,"JSONP_CALLBACK"),observe:"body",responseType:"json"})}options(url,options={}){return this.request("OPTIONS",url,options)}patch(url,body,options={}){return this.request("PATCH",url,addBody(options,body))}post(url,body,options={}){return this.request("POST",url,addBody(options,body))}put(url,body,options={}){return this.request("PUT",url,addBody(options,body))}}HttpClient.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",
ngImport:i0__namespace,type:HttpClient,deps:[{token:HttpHandler}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});HttpClient.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpClient});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpClient,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:HttpHandler}]}});class HttpInterceptorHandler{constructor(next,
interceptor){this.next=next;this.interceptor=interceptor}handle(req){return this.interceptor.intercept(req,this.next)}}const HTTP_INTERCEPTORS=new i0.InjectionToken("HTTP_INTERCEPTORS");class NoopInterceptor{intercept(req,next){return next.handle(req)}}NoopInterceptor.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:NoopInterceptor,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});NoopInterceptor.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",
version:"13.1.3",ngImport:i0__namespace,type:NoopInterceptor});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:NoopInterceptor,decorators:[{type:i0.Injectable}]});let nextRequestId=0;const JSONP_ERR_NO_CALLBACK="JSONP injected script did not invoke callback.";const JSONP_ERR_WRONG_METHOD="JSONP requests must use JSONP request method.";const JSONP_ERR_WRONG_RESPONSE_TYPE="JSONP requests must use Json response type.";class JsonpCallbackContext{}
class JsonpClientBackend{constructor(callbackMap,document){this.callbackMap=callbackMap;this.document=document;this.resolvedPromise=Promise.resolve()}nextCallback(){return`ng_jsonp_callback_${nextRequestId++}`}handle(req){if(req.method!=="JSONP")throw new Error(JSONP_ERR_WRONG_METHOD);else if(req.responseType!=="json")throw new Error(JSONP_ERR_WRONG_RESPONSE_TYPE);return new rxjs.Observable(observer=>{const callback=this.nextCallback();const url=req.urlWithParams.replace(/=JSONP_CALLBACK(&|$)/,`=${callback}$1`);
const node=this.document.createElement("script");node.src=url;let body=null;let finished=false;let cancelled=false;this.callbackMap[callback]=data=>{delete this.callbackMap[callback];if(cancelled)return;body=data;finished=true};const cleanup=()=>{if(node.parentNode)node.parentNode.removeChild(node);delete this.callbackMap[callback]};const onLoad=event=>{if(cancelled)return;this.resolvedPromise.then(()=>{cleanup();if(!finished){observer.error(new HttpErrorResponse({url,status:0,statusText:"JSONP Error",
error:new Error(JSONP_ERR_NO_CALLBACK)}));return}observer.next(new HttpResponse({body,status:200,statusText:"OK",url}));observer.complete()})};const onError=error=>{if(cancelled)return;cleanup();observer.error(new HttpErrorResponse({error,status:0,statusText:"JSONP Error",url}))};node.addEventListener("load",onLoad);node.addEventListener("error",onError);this.document.body.appendChild(node);observer.next({type:exports.HttpEventType.Sent});return()=>{cancelled=true;node.removeEventListener("load",
onLoad);node.removeEventListener("error",onError);cleanup()}})}}JsonpClientBackend.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:JsonpClientBackend,deps:[{token:JsonpCallbackContext},{token:i1.DOCUMENT}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});JsonpClientBackend.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:JsonpClientBackend});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",
version:"13.1.3",ngImport:i0__namespace,type:JsonpClientBackend,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:JsonpCallbackContext},{type:undefined,decorators:[{type:i0.Inject,args:[i1.DOCUMENT]}]}]}});class JsonpInterceptor{constructor(jsonp){this.jsonp=jsonp}intercept(req,next){if(req.method==="JSONP")return this.jsonp.handle(req);return next.handle(req)}}JsonpInterceptor.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,
type:JsonpInterceptor,deps:[{token:JsonpClientBackend}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});JsonpInterceptor.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:JsonpInterceptor});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:JsonpInterceptor,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:JsonpClientBackend}]}});
const XSSI_PREFIX=/^\)\]\}',?\n/;function getResponseUrl(xhr){if("responseURL"in xhr&&xhr.responseURL)return xhr.responseURL;if(/^X-Request-URL:/m.test(xhr.getAllResponseHeaders()))return xhr.getResponseHeader("X-Request-URL");return null}class HttpXhrBackend{constructor(xhrFactory){this.xhrFactory=xhrFactory}handle(req){if(req.method==="JSONP")throw new Error(`Attempted to construct Jsonp request without HttpClientJsonpModule installed.`);return new rxjs.Observable(observer=>{const xhr=this.xhrFactory.build();
xhr.open(req.method,req.urlWithParams);if(!!req.withCredentials)xhr.withCredentials=true;req.headers.forEach((name,values)=>xhr.setRequestHeader(name,values.join(",")));if(!req.headers.has("Accept"))xhr.setRequestHeader("Accept","application/json, text/plain, */*");if(!req.headers.has("Content-Type")){const detectedType=req.detectContentTypeHeader();if(detectedType!==null)xhr.setRequestHeader("Content-Type",detectedType)}if(req.responseType){const responseType=req.responseType.toLowerCase();xhr.responseType=
responseType!=="json"?responseType:"text"}const reqBody=req.serializeBody();let headerResponse=null;const partialFromXhr=()=>{if(headerResponse!==null)return headerResponse;const status=xhr.status===1223?204:xhr.status;const statusText=xhr.statusText||"OK";const headers=new HttpHeaders(xhr.getAllResponseHeaders());const url=getResponseUrl(xhr)||req.url;headerResponse=new HttpHeaderResponse({headers,status,statusText,url});return headerResponse};const onLoad=()=>{let {headers,status,statusText,url}=
partialFromXhr();let body=null;if(status!==204)body=typeof xhr.response==="undefined"?xhr.responseText:xhr.response;if(status===0)status=!!body?200:0;let ok=status>=200&&status<300;if(req.responseType==="json"&&typeof body==="string"){const originalBody=body;body=body.replace(XSSI_PREFIX,"");try{body=body!==""?JSON.parse(body):null}catch(error){body=originalBody;if(ok){ok=false;body={error,text:body}}}}if(ok){observer.next(new HttpResponse({body,headers,status,statusText,url:url||undefined}));observer.complete()}else observer.error(new HttpErrorResponse({error:body,
headers,status,statusText,url:url||undefined}))};const onError=error=>{const {url}=partialFromXhr();const res=new HttpErrorResponse({error,status:xhr.status||0,statusText:xhr.statusText||"Unknown Error",url:url||undefined});observer.error(res)};let sentHeaders=false;const onDownProgress=event=>{if(!sentHeaders){observer.next(partialFromXhr());sentHeaders=true}let progressEvent={type:exports.HttpEventType.DownloadProgress,loaded:event.loaded};if(event.lengthComputable)progressEvent.total=event.total;
if(req.responseType==="text"&&!!xhr.responseText)progressEvent.partialText=xhr.responseText;observer.next(progressEvent)};const onUpProgress=event=>{let progress={type:exports.HttpEventType.UploadProgress,loaded:event.loaded};if(event.lengthComputable)progress.total=event.total;observer.next(progress)};xhr.addEventListener("load",onLoad);xhr.addEventListener("error",onError);xhr.addEventListener("timeout",onError);xhr.addEventListener("abort",onError);if(req.reportProgress){xhr.addEventListener("progress",
onDownProgress);if(reqBody!==null&&xhr.upload)xhr.upload.addEventListener("progress",onUpProgress)}xhr.send(reqBody);observer.next({type:exports.HttpEventType.Sent});return()=>{xhr.removeEventListener("error",onError);xhr.removeEventListener("abort",onError);xhr.removeEventListener("load",onLoad);xhr.removeEventListener("timeout",onError);if(req.reportProgress){xhr.removeEventListener("progress",onDownProgress);if(reqBody!==null&&xhr.upload)xhr.upload.removeEventListener("progress",onUpProgress)}if(xhr.readyState!==
xhr.DONE)xhr.abort()}})}}HttpXhrBackend.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpXhrBackend,deps:[{token:i1__namespace.XhrFactory}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});HttpXhrBackend.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpXhrBackend});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.3",
ngImport:i0__namespace,type:HttpXhrBackend,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:i1__namespace.XhrFactory}]}});const XSRF_COOKIE_NAME=new i0.InjectionToken("XSRF_COOKIE_NAME");const XSRF_HEADER_NAME=new i0.InjectionToken("XSRF_HEADER_NAME");class HttpXsrfTokenExtractor{}class HttpXsrfCookieExtractor{constructor(doc,platform,cookieName){this.doc=doc;this.platform=platform;this.cookieName=cookieName;this.lastCookieString="";this.lastToken=null;this.parseCount=0}getToken(){if(this.platform===
"server")return null;const cookieString=this.doc.cookie||"";if(cookieString!==this.lastCookieString){this.parseCount++;this.lastToken=i1["ɵparseCookieValue"](cookieString,this.cookieName);this.lastCookieString=cookieString}return this.lastToken}}HttpXsrfCookieExtractor.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpXsrfCookieExtractor,deps:[{token:i1.DOCUMENT},{token:i0.PLATFORM_ID},{token:XSRF_COOKIE_NAME}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});
HttpXsrfCookieExtractor.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpXsrfCookieExtractor});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpXsrfCookieExtractor,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:undefined,decorators:[{type:i0.Inject,args:[i1.DOCUMENT]}]},{type:undefined,decorators:[{type:i0.Inject,args:[i0.PLATFORM_ID]}]},
{type:undefined,decorators:[{type:i0.Inject,args:[XSRF_COOKIE_NAME]}]}]}});class HttpXsrfInterceptor{constructor(tokenService,headerName){this.tokenService=tokenService;this.headerName=headerName}intercept(req,next){const lcUrl=req.url.toLowerCase();if(req.method==="GET"||req.method==="HEAD"||lcUrl.startsWith("http://")||lcUrl.startsWith("https://"))return next.handle(req);const token=this.tokenService.getToken();if(token!==null&&!req.headers.has(this.headerName))req=req.clone({headers:req.headers.set(this.headerName,
token)});return next.handle(req)}}HttpXsrfInterceptor.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpXsrfInterceptor,deps:[{token:HttpXsrfTokenExtractor},{token:XSRF_HEADER_NAME}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});HttpXsrfInterceptor.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpXsrfInterceptor});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",
version:"13.1.3",ngImport:i0__namespace,type:HttpXsrfInterceptor,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:HttpXsrfTokenExtractor},{type:undefined,decorators:[{type:i0.Inject,args:[XSRF_HEADER_NAME]}]}]}});class HttpInterceptingHandler{constructor(backend,injector){this.backend=backend;this.injector=injector;this.chain=null}handle(req){if(this.chain===null){const interceptors=this.injector.get(HTTP_INTERCEPTORS,[]);this.chain=interceptors.reduceRight((next,interceptor)=>
new HttpInterceptorHandler(next,interceptor),this.backend)}return this.chain.handle(req)}}HttpInterceptingHandler.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpInterceptingHandler,deps:[{token:HttpBackend},{token:i0__namespace.Injector}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});HttpInterceptingHandler.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,
type:HttpInterceptingHandler});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpInterceptingHandler,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:HttpBackend},{type:i0__namespace.Injector}]}});function jsonpCallbackContext(){if(typeof window==="object")return window;return{}}class HttpClientXsrfModule{static disable(){return{ngModule:HttpClientXsrfModule,providers:[{provide:HttpXsrfInterceptor,useClass:NoopInterceptor}]}}static withOptions(options=
{}){return{ngModule:HttpClientXsrfModule,providers:[options.cookieName?{provide:XSRF_COOKIE_NAME,useValue:options.cookieName}:[],options.headerName?{provide:XSRF_HEADER_NAME,useValue:options.headerName}:[]]}}}HttpClientXsrfModule.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpClientXsrfModule,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.NgModule});HttpClientXsrfModule.\u0275mod=i0__namespace.\u0275\u0275ngDeclareNgModule({minVersion:"12.0.0",
version:"13.1.3",ngImport:i0__namespace,type:HttpClientXsrfModule});HttpClientXsrfModule.\u0275inj=i0__namespace.\u0275\u0275ngDeclareInjector({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpClientXsrfModule,providers:[HttpXsrfInterceptor,{provide:HTTP_INTERCEPTORS,useExisting:HttpXsrfInterceptor,multi:true},{provide:HttpXsrfTokenExtractor,useClass:HttpXsrfCookieExtractor},{provide:XSRF_COOKIE_NAME,useValue:"XSRF-TOKEN"},{provide:XSRF_HEADER_NAME,useValue:"X-XSRF-TOKEN"}]});
i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpClientXsrfModule,decorators:[{type:i0.NgModule,args:[{providers:[HttpXsrfInterceptor,{provide:HTTP_INTERCEPTORS,useExisting:HttpXsrfInterceptor,multi:true},{provide:HttpXsrfTokenExtractor,useClass:HttpXsrfCookieExtractor},{provide:XSRF_COOKIE_NAME,useValue:"XSRF-TOKEN"},{provide:XSRF_HEADER_NAME,useValue:"X-XSRF-TOKEN"}]}]}]});class HttpClientModule{}HttpClientModule.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",
version:"13.1.3",ngImport:i0__namespace,type:HttpClientModule,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.NgModule});HttpClientModule.\u0275mod=i0__namespace.\u0275\u0275ngDeclareNgModule({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpClientModule,imports:[HttpClientXsrfModule]});HttpClientModule.\u0275inj=i0__namespace.\u0275\u0275ngDeclareInjector({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpClientModule,providers:[HttpClient,{provide:HttpHandler,
useClass:HttpInterceptingHandler},HttpXhrBackend,{provide:HttpBackend,useExisting:HttpXhrBackend}],imports:[[HttpClientXsrfModule.withOptions({cookieName:"XSRF-TOKEN",headerName:"X-XSRF-TOKEN"})]]});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpClientModule,decorators:[{type:i0.NgModule,args:[{imports:[HttpClientXsrfModule.withOptions({cookieName:"XSRF-TOKEN",headerName:"X-XSRF-TOKEN"})],providers:[HttpClient,{provide:HttpHandler,
useClass:HttpInterceptingHandler},HttpXhrBackend,{provide:HttpBackend,useExisting:HttpXhrBackend}]}]}]});class HttpClientJsonpModule{}HttpClientJsonpModule.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpClientJsonpModule,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.NgModule});HttpClientJsonpModule.\u0275mod=i0__namespace.\u0275\u0275ngDeclareNgModule({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpClientJsonpModule});
HttpClientJsonpModule.\u0275inj=i0__namespace.\u0275\u0275ngDeclareInjector({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpClientJsonpModule,providers:[JsonpClientBackend,{provide:JsonpCallbackContext,useFactory:jsonpCallbackContext},{provide:HTTP_INTERCEPTORS,useClass:JsonpInterceptor,multi:true}]});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:HttpClientJsonpModule,decorators:[{type:i0.NgModule,args:[{providers:[JsonpClientBackend,
{provide:JsonpCallbackContext,useFactory:jsonpCallbackContext},{provide:HTTP_INTERCEPTORS,useClass:JsonpInterceptor,multi:true}]}]}]});const XhrFactory=i1.XhrFactory;exports.HTTP_INTERCEPTORS=HTTP_INTERCEPTORS;exports.HttpBackend=HttpBackend;exports.HttpClient=HttpClient;exports.HttpClientJsonpModule=HttpClientJsonpModule;exports.HttpClientModule=HttpClientModule;exports.HttpClientXsrfModule=HttpClientXsrfModule;exports.HttpContext=HttpContext;exports.HttpContextToken=HttpContextToken;exports.HttpErrorResponse=
HttpErrorResponse;exports.HttpHandler=HttpHandler;exports.HttpHeaderResponse=HttpHeaderResponse;exports.HttpHeaders=HttpHeaders;exports.HttpParams=HttpParams;exports.HttpRequest=HttpRequest;exports.HttpResponse=HttpResponse;exports.HttpResponseBase=HttpResponseBase;exports.HttpUrlEncodingCodec=HttpUrlEncodingCodec;exports.HttpXhrBackend=HttpXhrBackend;exports.HttpXsrfTokenExtractor=HttpXsrfTokenExtractor;exports.JsonpClientBackend=JsonpClientBackend;exports.JsonpInterceptor=JsonpInterceptor;exports.XhrFactory=
XhrFactory;exports["ɵHttpInterceptingHandler"]=HttpInterceptingHandler;Object.defineProperty(exports,"__esModule",{value:true})});

