/*

 Copyright Google LLC All Rights Reserved.

 Use of this source code is governed by an MIT-style license that can be
 found in the LICENSE file at https://angular.io/license
 Angular v13.1.3
 (c) 2010-2022 Google LLC. https://angular.io/
 License: MIT
*/
'use strict';(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports):typeof define==="function"&&define.amd?define(["exports"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory((global.ng=global.ng||{},global.ng.compiler={})))})(this,function(exports){exports.TagContentType=void 0;(function(TagContentType){TagContentType[TagContentType["RAW_TEXT"]=0]="RAW_TEXT";TagContentType[TagContentType["ESCAPABLE_RAW_TEXT"]=1]="ESCAPABLE_RAW_TEXT";
TagContentType[TagContentType["PARSABLE_DATA"]=2]="PARSABLE_DATA"})(exports.TagContentType||(exports.TagContentType={}));function splitNsName(elementName){if(elementName[0]!=":")return[null,elementName];const colonIndex=elementName.indexOf(":",1);if(colonIndex===-1)throw new Error(`Unsupported format "${elementName}" expecting ":namespace:name"`);return[elementName.slice(1,colonIndex),elementName.slice(colonIndex+1)]}function isNgContainer(tagName){return splitNsName(tagName)[1]==="ng-container"}
function isNgContent(tagName){return splitNsName(tagName)[1]==="ng-content"}function isNgTemplate(tagName){return splitNsName(tagName)[1]==="ng-template"}function getNsPrefix(fullName){return fullName===null?null:splitNsName(fullName)[0]}function mergeNsAndName(prefix,localName){return prefix?`:${prefix}:${localName}`:localName}class HtmlTagDefinition{constructor({closedByChildren,implicitNamespacePrefix,contentType=exports.TagContentType.PARSABLE_DATA,closedByParent=false,isVoid=false,ignoreFirstLf=
false,preventNamespaceInheritance=false}={}){this.closedByChildren={};this.closedByParent=false;this.canSelfClose=false;if(closedByChildren&&closedByChildren.length>0)closedByChildren.forEach(tagName=>this.closedByChildren[tagName]=true);this.isVoid=isVoid;this.closedByParent=closedByParent||isVoid;this.implicitNamespacePrefix=implicitNamespacePrefix||null;this.contentType=contentType;this.ignoreFirstLf=ignoreFirstLf;this.preventNamespaceInheritance=preventNamespaceInheritance}isClosedByChild(name){return this.isVoid||
name.toLowerCase()in this.closedByChildren}getContentType(prefix){if(typeof this.contentType==="object"){const overrideType=prefix===undefined?undefined:this.contentType[prefix];return overrideType!==null&&overrideType!==void 0?overrideType:this.contentType.default}return this.contentType}}let _DEFAULT_TAG_DEFINITION;let TAG_DEFINITIONS;function getHtmlTagDefinition(tagName){var _a,_b;if(!TAG_DEFINITIONS){_DEFAULT_TAG_DEFINITION=new HtmlTagDefinition;TAG_DEFINITIONS={"base":new HtmlTagDefinition({isVoid:true}),
"meta":new HtmlTagDefinition({isVoid:true}),"area":new HtmlTagDefinition({isVoid:true}),"embed":new HtmlTagDefinition({isVoid:true}),"link":new HtmlTagDefinition({isVoid:true}),"img":new HtmlTagDefinition({isVoid:true}),"input":new HtmlTagDefinition({isVoid:true}),"param":new HtmlTagDefinition({isVoid:true}),"hr":new HtmlTagDefinition({isVoid:true}),"br":new HtmlTagDefinition({isVoid:true}),"source":new HtmlTagDefinition({isVoid:true}),"track":new HtmlTagDefinition({isVoid:true}),"wbr":new HtmlTagDefinition({isVoid:true}),
"p":new HtmlTagDefinition({closedByChildren:["address","article","aside","blockquote","div","dl","fieldset","footer","form","h1","h2","h3","h4","h5","h6","header","hgroup","hr","main","nav","ol","p","pre","section","table","ul"],closedByParent:true}),"thead":new HtmlTagDefinition({closedByChildren:["tbody","tfoot"]}),"tbody":new HtmlTagDefinition({closedByChildren:["tbody","tfoot"],closedByParent:true}),"tfoot":new HtmlTagDefinition({closedByChildren:["tbody"],closedByParent:true}),"tr":new HtmlTagDefinition({closedByChildren:["tr"],
closedByParent:true}),"td":new HtmlTagDefinition({closedByChildren:["td","th"],closedByParent:true}),"th":new HtmlTagDefinition({closedByChildren:["td","th"],closedByParent:true}),"col":new HtmlTagDefinition({isVoid:true}),"svg":new HtmlTagDefinition({implicitNamespacePrefix:"svg"}),"foreignObject":new HtmlTagDefinition({implicitNamespacePrefix:"svg",preventNamespaceInheritance:true}),"math":new HtmlTagDefinition({implicitNamespacePrefix:"math"}),"li":new HtmlTagDefinition({closedByChildren:["li"],
closedByParent:true}),"dt":new HtmlTagDefinition({closedByChildren:["dt","dd"]}),"dd":new HtmlTagDefinition({closedByChildren:["dt","dd"],closedByParent:true}),"rb":new HtmlTagDefinition({closedByChildren:["rb","rt","rtc","rp"],closedByParent:true}),"rt":new HtmlTagDefinition({closedByChildren:["rb","rt","rtc","rp"],closedByParent:true}),"rtc":new HtmlTagDefinition({closedByChildren:["rb","rtc","rp"],closedByParent:true}),"rp":new HtmlTagDefinition({closedByChildren:["rb","rt","rtc","rp"],closedByParent:true}),
"optgroup":new HtmlTagDefinition({closedByChildren:["optgroup"],closedByParent:true}),"option":new HtmlTagDefinition({closedByChildren:["option","optgroup"],closedByParent:true}),"pre":new HtmlTagDefinition({ignoreFirstLf:true}),"listing":new HtmlTagDefinition({ignoreFirstLf:true}),"style":new HtmlTagDefinition({contentType:exports.TagContentType.RAW_TEXT}),"script":new HtmlTagDefinition({contentType:exports.TagContentType.RAW_TEXT}),"title":new HtmlTagDefinition({contentType:{default:exports.TagContentType.ESCAPABLE_RAW_TEXT,
svg:exports.TagContentType.PARSABLE_DATA}}),"textarea":new HtmlTagDefinition({contentType:exports.TagContentType.ESCAPABLE_RAW_TEXT,ignoreFirstLf:true})}}return(_b=(_a=TAG_DEFINITIONS[tagName])!==null&&_a!==void 0?_a:TAG_DEFINITIONS[tagName.toLowerCase()])!==null&&_b!==void 0?_b:_DEFAULT_TAG_DEFINITION}const _SELECTOR_REGEXP=new RegExp("(\\:not\\()|"+"(([\\.\\#]?)[-\\w]+)|"+"(?:\\[([-.\\w*\\\\$]+)(?:=([\"']?)([^\\]\"']*)\\5)?\\])|"+"(\\))|"+"(\\s*,\\s*)","g");class CssSelector{constructor(){this.element=
null;this.classNames=[];this.attrs=[];this.notSelectors=[]}static parse(selector){const results=[];const _addResult=(res,cssSel)=>{if(cssSel.notSelectors.length>0&&!cssSel.element&&cssSel.classNames.length==0&&cssSel.attrs.length==0)cssSel.element="*";res.push(cssSel)};let cssSelector=new CssSelector;let match;let current=cssSelector;let inNot=false;_SELECTOR_REGEXP.lastIndex=0;while(match=_SELECTOR_REGEXP.exec(selector)){if(match[1]){if(inNot)throw new Error("Nesting :not in a selector is not allowed");
inNot=true;current=new CssSelector;cssSelector.notSelectors.push(current)}const tag=match[2];if(tag){const prefix=match[3];if(prefix==="#")current.addAttribute("id",tag.substr(1));else if(prefix===".")current.addClassName(tag.substr(1));else current.setElement(tag)}const attribute=match[4];if(attribute)current.addAttribute(current.unescapeAttribute(attribute),match[6]);if(match[7]){inNot=false;current=cssSelector}if(match[8]){if(inNot)throw new Error("Multiple selectors in :not are not supported");
_addResult(results,cssSelector);cssSelector=current=new CssSelector}}_addResult(results,cssSelector);return results}unescapeAttribute(attr){let result="";let escaping=false;for(let i=0;i<attr.length;i++){const char=attr.charAt(i);if(char==="\\"){escaping=true;continue}if(char==="$"&&!escaping)throw new Error(`Error in attribute selector "${attr}". `+`Unescaped "$" is not supported. Please escape with "\\$".`);escaping=false;result+=char}return result}escapeAttribute(attr){return attr.replace(/\\/g,
"\\\\").replace(/\$/g,"\\$")}isElementSelector(){return this.hasElementSelector()&&this.classNames.length==0&&this.attrs.length==0&&this.notSelectors.length===0}hasElementSelector(){return!!this.element}setElement(element=null){this.element=element}getMatchingElementTemplate(){const tagName=this.element||"div";const classAttr=this.classNames.length>0?` class="${this.classNames.join(" ")}"`:"";let attrs="";for(let i=0;i<this.attrs.length;i+=2){const attrName=this.attrs[i];const attrValue=this.attrs[i+
1]!==""?`="${this.attrs[i+1]}"`:"";attrs+=` ${attrName}${attrValue}`}return getHtmlTagDefinition(tagName).isVoid?`<${tagName}${classAttr}${attrs}/>`:`<${tagName}${classAttr}${attrs}></${tagName}>`}getAttrs(){const result=[];if(this.classNames.length>0)result.push("class",this.classNames.join(" "));return result.concat(this.attrs)}addAttribute(name,value=""){this.attrs.push(name,value&&value.toLowerCase()||"")}addClassName(name){this.classNames.push(name.toLowerCase())}toString(){let res=this.element||
"";if(this.classNames)this.classNames.forEach(klass=>res+=`.${klass}`);if(this.attrs)for(let i=0;i<this.attrs.length;i+=2){const name=this.escapeAttribute(this.attrs[i]);const value=this.attrs[i+1];res+=`[${name}${value?"="+value:""}]`}this.notSelectors.forEach(notSelector=>res+=`:not(${notSelector})`);return res}}class SelectorMatcher{constructor(){this._elementMap=new Map;this._elementPartialMap=new Map;this._classMap=new Map;this._classPartialMap=new Map;this._attrValueMap=new Map;this._attrValuePartialMap=
new Map;this._listContexts=[]}static createNotMatcher(notSelectors){const notMatcher=new SelectorMatcher;notMatcher.addSelectables(notSelectors,null);return notMatcher}addSelectables(cssSelectors,callbackCtxt){let listContext=null;if(cssSelectors.length>1){listContext=new SelectorListContext(cssSelectors);this._listContexts.push(listContext)}for(let i=0;i<cssSelectors.length;i++)this._addSelectable(cssSelectors[i],callbackCtxt,listContext)}_addSelectable(cssSelector,callbackCtxt,listContext){let matcher=
this;const element=cssSelector.element;const classNames=cssSelector.classNames;const attrs=cssSelector.attrs;const selectable=new SelectorContext(cssSelector,callbackCtxt,listContext);if(element){const isTerminal=attrs.length===0&&classNames.length===0;if(isTerminal)this._addTerminal(matcher._elementMap,element,selectable);else matcher=this._addPartial(matcher._elementPartialMap,element)}if(classNames)for(let i=0;i<classNames.length;i++){const isTerminal=attrs.length===0&&i===classNames.length-1;
const className=classNames[i];if(isTerminal)this._addTerminal(matcher._classMap,className,selectable);else matcher=this._addPartial(matcher._classPartialMap,className)}if(attrs)for(let i=0;i<attrs.length;i+=2){const isTerminal=i===attrs.length-2;const name=attrs[i];const value=attrs[i+1];if(isTerminal){const terminalMap=matcher._attrValueMap;let terminalValuesMap=terminalMap.get(name);if(!terminalValuesMap){terminalValuesMap=new Map;terminalMap.set(name,terminalValuesMap)}this._addTerminal(terminalValuesMap,
value,selectable)}else{const partialMap=matcher._attrValuePartialMap;let partialValuesMap=partialMap.get(name);if(!partialValuesMap){partialValuesMap=new Map;partialMap.set(name,partialValuesMap)}matcher=this._addPartial(partialValuesMap,value)}}}_addTerminal(map,name,selectable){let terminalList=map.get(name);if(!terminalList){terminalList=[];map.set(name,terminalList)}terminalList.push(selectable)}_addPartial(map,name){let matcher=map.get(name);if(!matcher){matcher=new SelectorMatcher;map.set(name,
matcher)}return matcher}match(cssSelector,matchedCallback){let result=false;const element=cssSelector.element;const classNames=cssSelector.classNames;const attrs=cssSelector.attrs;for(let i=0;i<this._listContexts.length;i++)this._listContexts[i].alreadyMatched=false;result=this._matchTerminal(this._elementMap,element,cssSelector,matchedCallback)||result;result=this._matchPartial(this._elementPartialMap,element,cssSelector,matchedCallback)||result;if(classNames)for(let i=0;i<classNames.length;i++){const className=
classNames[i];result=this._matchTerminal(this._classMap,className,cssSelector,matchedCallback)||result;result=this._matchPartial(this._classPartialMap,className,cssSelector,matchedCallback)||result}if(attrs)for(let i=0;i<attrs.length;i+=2){const name=attrs[i];const value=attrs[i+1];const terminalValuesMap=this._attrValueMap.get(name);if(value)result=this._matchTerminal(terminalValuesMap,"",cssSelector,matchedCallback)||result;result=this._matchTerminal(terminalValuesMap,value,cssSelector,matchedCallback)||
result;const partialValuesMap=this._attrValuePartialMap.get(name);if(value)result=this._matchPartial(partialValuesMap,"",cssSelector,matchedCallback)||result;result=this._matchPartial(partialValuesMap,value,cssSelector,matchedCallback)||result}return result}_matchTerminal(map,name,cssSelector,matchedCallback){if(!map||typeof name!=="string")return false;let selectables=map.get(name)||[];const starSelectables=map.get("*");if(starSelectables)selectables=selectables.concat(starSelectables);if(selectables.length===
0)return false;let selectable;let result=false;for(let i=0;i<selectables.length;i++){selectable=selectables[i];result=selectable.finalize(cssSelector,matchedCallback)||result}return result}_matchPartial(map,name,cssSelector,matchedCallback){if(!map||typeof name!=="string")return false;const nestedSelector=map.get(name);if(!nestedSelector)return false;return nestedSelector.match(cssSelector,matchedCallback)}}class SelectorListContext{constructor(selectors){this.selectors=selectors;this.alreadyMatched=
false}}class SelectorContext{constructor(selector,cbContext,listContext){this.selector=selector;this.cbContext=cbContext;this.listContext=listContext;this.notSelectors=selector.notSelectors}finalize(cssSelector,callback){let result=true;if(this.notSelectors.length>0&&(!this.listContext||!this.listContext.alreadyMatched)){const notMatcher=SelectorMatcher.createNotMatcher(this.notSelectors);result=!notMatcher.match(cssSelector,null)}if(result&&callback&&(!this.listContext||!this.listContext.alreadyMatched)){if(this.listContext)this.listContext.alreadyMatched=
true;callback(this.selector,this.cbContext)}return result}}const emitDistinctChangesOnlyDefaultValue=true;exports.ViewEncapsulation=void 0;(function(ViewEncapsulation){ViewEncapsulation[ViewEncapsulation["Emulated"]=0]="Emulated";ViewEncapsulation[ViewEncapsulation["None"]=2]="None";ViewEncapsulation[ViewEncapsulation["ShadowDom"]=3]="ShadowDom"})(exports.ViewEncapsulation||(exports.ViewEncapsulation={}));exports.ChangeDetectionStrategy=void 0;(function(ChangeDetectionStrategy){ChangeDetectionStrategy[ChangeDetectionStrategy["OnPush"]=
0]="OnPush";ChangeDetectionStrategy[ChangeDetectionStrategy["Default"]=1]="Default"})(exports.ChangeDetectionStrategy||(exports.ChangeDetectionStrategy={}));const CUSTOM_ELEMENTS_SCHEMA={name:"custom-elements"};const NO_ERRORS_SCHEMA={name:"no-errors-schema"};const Type$1=Function;var SecurityContext;(function(SecurityContext){SecurityContext[SecurityContext["NONE"]=0]="NONE";SecurityContext[SecurityContext["HTML"]=1]="HTML";SecurityContext[SecurityContext["STYLE"]=2]="STYLE";SecurityContext[SecurityContext["SCRIPT"]=
3]="SCRIPT";SecurityContext[SecurityContext["URL"]=4]="URL";SecurityContext[SecurityContext["RESOURCE_URL"]=5]="RESOURCE_URL"})(SecurityContext||(SecurityContext={}));var MissingTranslationStrategy;(function(MissingTranslationStrategy){MissingTranslationStrategy[MissingTranslationStrategy["Error"]=0]="Error";MissingTranslationStrategy[MissingTranslationStrategy["Warning"]=1]="Warning";MissingTranslationStrategy[MissingTranslationStrategy["Ignore"]=2]="Ignore"})(MissingTranslationStrategy||(MissingTranslationStrategy=
{}));function parserSelectorToSimpleSelector(selector){const classes=selector.classNames&&selector.classNames.length?[8,...selector.classNames]:[];const elementName=selector.element&&selector.element!=="*"?selector.element:"";return[elementName,...selector.attrs,...classes]}function parserSelectorToNegativeSelector(selector){const classes=selector.classNames&&selector.classNames.length?[8,...selector.classNames]:[];if(selector.element)return[1|4,selector.element,...selector.attrs,...classes];else if(selector.attrs.length)return[1|
2,...selector.attrs,...classes];else return selector.classNames&&selector.classNames.length?[1|8,...selector.classNames]:[]}function parserSelectorToR3Selector(selector){const positive=parserSelectorToSimpleSelector(selector);const negative=selector.notSelectors&&selector.notSelectors.length?selector.notSelectors.map(notSelector=>parserSelectorToNegativeSelector(notSelector)):[];return positive.concat(...negative)}function parseSelectorToR3Selector(selector){return selector?CssSelector.parse(selector).map(parserSelectorToR3Selector):
[]}var core=Object.freeze({__proto__:null,emitDistinctChangesOnlyDefaultValue:emitDistinctChangesOnlyDefaultValue,get ViewEncapsulation(){return exports.ViewEncapsulation},get ChangeDetectionStrategy(){return exports.ChangeDetectionStrategy},CUSTOM_ELEMENTS_SCHEMA:CUSTOM_ELEMENTS_SCHEMA,NO_ERRORS_SCHEMA:NO_ERRORS_SCHEMA,Type:Type$1,get SecurityContext(){return SecurityContext},get MissingTranslationStrategy(){return MissingTranslationStrategy},parseSelectorToR3Selector:parseSelectorToR3Selector});
const DASH_CASE_REGEXP=/-+([a-z0-9])/g;function dashCaseToCamelCase(input){return input.replace(DASH_CASE_REGEXP,(...m)=>m[1].toUpperCase())}function splitAtColon(input,defaultValues){return _splitAt(input,":",defaultValues)}function splitAtPeriod(input,defaultValues){return _splitAt(input,".",defaultValues)}function _splitAt(input,character,defaultValues){const characterIndex=input.indexOf(character);if(characterIndex==-1)return defaultValues;return[input.slice(0,characterIndex).trim(),input.slice(characterIndex+
1).trim()]}function noUndefined(val){return val===undefined?null:val}function error(msg){throw new Error(`Internal Error: ${msg}`);}function utf8Encode(str){let encoded=[];for(let index=0;index<str.length;index++){let codePoint=str.charCodeAt(index);if(codePoint>=55296&&codePoint<=56319&&str.length>index+1){const low=str.charCodeAt(index+1);if(low>=56320&&low<=57343){index++;codePoint=(codePoint-55296<<10)+low-56320+65536}}if(codePoint<=127)encoded.push(codePoint);else if(codePoint<=2047)encoded.push(codePoint>>
6&31|192,codePoint&63|128);else if(codePoint<=65535)encoded.push(codePoint>>12|224,codePoint>>6&63|128,codePoint&63|128);else if(codePoint<=2097151)encoded.push(codePoint>>18&7|240,codePoint>>12&63|128,codePoint>>6&63|128,codePoint&63|128)}return encoded}function stringify(token){if(typeof token==="string")return token;if(Array.isArray(token))return"["+token.map(stringify).join(", ")+"]";if(token==null)return""+token;if(token.overriddenName)return`${token.overriddenName}`;if(token.name)return`${token.name}`;
if(!token.toString)return"object";const res=token.toString();if(res==null)return""+res;const newLineIndex=res.indexOf("\n");return newLineIndex===-1?res:res.substring(0,newLineIndex)}class Version{constructor(full){this.full=full;const splits=full.split(".");this.major=splits[0];this.minor=splits[1];this.patch=splits.slice(2).join(".")}}const __window=typeof window!=="undefined"&&window;const __self=typeof self!=="undefined"&&typeof WorkerGlobalScope!=="undefined"&&self instanceof WorkerGlobalScope&&
self;const __global=typeof global!=="undefined"&&global;const _global=__global||__window||__self;function newArray(size,value){const list=[];for(let i=0;i<size;i++)list.push(value);return list}function partitionArray(arr,conditionFn){const truthy=[];const falsy=[];for(const item of arr)(conditionFn(item)?truthy:falsy).push(item);return[truthy,falsy]}class BigInteger{constructor(digits){this.digits=digits}static zero(){return new BigInteger([0])}static one(){return new BigInteger([1])}clone(){return new BigInteger(this.digits.slice())}add(other){const result=
this.clone();result.addToSelf(other);return result}addToSelf(other){const maxNrOfDigits=Math.max(this.digits.length,other.digits.length);let carry=0;for(let i=0;i<maxNrOfDigits;i++){let digitSum=carry;if(i<this.digits.length)digitSum+=this.digits[i];if(i<other.digits.length)digitSum+=other.digits[i];if(digitSum>=10){this.digits[i]=digitSum-10;carry=1}else{this.digits[i]=digitSum;carry=0}}if(carry>0)this.digits[maxNrOfDigits]=1}toString(){let res="";for(let i=this.digits.length-1;i>=0;i--)res+=this.digits[i];
return res}}class BigIntForMultiplication{constructor(value){this.powerOfTwos=[value]}getValue(){return this.powerOfTwos[0]}multiplyBy(num){const product=BigInteger.zero();this.multiplyByAndAddTo(num,product);return product}multiplyByAndAddTo(num,result){for(let exponent=0;num!==0;num=num>>>1,exponent++)if(num&1){const value=this.getMultipliedByPowerOfTwo(exponent);result.addToSelf(value)}}getMultipliedByPowerOfTwo(exponent){for(let i=this.powerOfTwos.length;i<=exponent;i++){const previousPower=this.powerOfTwos[i-
1];this.powerOfTwos[i]=previousPower.add(previousPower)}return this.powerOfTwos[exponent]}}class BigIntExponentiation{constructor(base){this.base=base;this.exponents=[new BigIntForMultiplication(BigInteger.one())]}toThePowerOf(exponent){for(let i=this.exponents.length;i<=exponent;i++){const value=this.exponents[i-1].multiplyBy(this.base);this.exponents[i]=new BigIntForMultiplication(value)}return this.exponents[exponent]}}function digest$1(message){return message.id||computeDigest(message)}function computeDigest(message){return sha1(serializeNodes(message.nodes).join("")+
`[${message.meaning}]`)}function decimalDigest(message){return message.id||computeDecimalDigest(message)}function computeDecimalDigest(message){const visitor=new _SerializerIgnoreIcuExpVisitor;const parts=message.nodes.map(a=>a.visit(visitor,null));return computeMsgId(parts.join(""),message.meaning)}class _SerializerVisitor{visitText(text,context){return text.value}visitContainer(container,context){return`[${container.children.map(child=>child.visit(this)).join(", ")}]`}visitIcu(icu,context){const strCases=
Object.keys(icu.cases).map(k=>`${k} {${icu.cases[k].visit(this)}}`);return`{${icu.expression}, ${icu.type}, ${strCases.join(", ")}}`}visitTagPlaceholder(ph,context){return ph.isVoid?`<ph tag name="${ph.startName}"/>`:`<ph tag name="${ph.startName}">${ph.children.map(child=>child.visit(this)).join(", ")}</ph name="${ph.closeName}">`}visitPlaceholder(ph,context){return ph.value?`<ph name="${ph.name}">${ph.value}</ph>`:`<ph name="${ph.name}"/>`}visitIcuPlaceholder(ph,context){return`<ph icu name="${ph.name}">${ph.value.visit(this)}</ph>`}}
const serializerVisitor$1=new _SerializerVisitor;function serializeNodes(nodes){return nodes.map(a=>a.visit(serializerVisitor$1,null))}class _SerializerIgnoreIcuExpVisitor extends _SerializerVisitor{visitIcu(icu,context){let strCases=Object.keys(icu.cases).map(k=>`${k} {${icu.cases[k].visit(this)}}`);return`{${icu.type}, ${strCases.join(", ")}}`}}function sha1(str){const utf8=utf8Encode(str);const words32=bytesToWords32(utf8,Endian.Big);const len=utf8.length*8;const w=newArray(80);let a=1732584193,
b=4023233417,c=2562383102,d=271733878,e=3285377520;words32[len>>5]|=128<<24-len%32;words32[(len+64>>9<<4)+15]=len;for(let i=0;i<words32.length;i+=16){const h0=a,h1=b,h2=c,h3=d,h4=e;for(let j=0;j<80;j++){if(j<16)w[j]=words32[i+j];else w[j]=rol32(w[j-3]^w[j-8]^w[j-14]^w[j-16],1);const fkVal=fk(j,b,c,d);const f=fkVal[0];const k=fkVal[1];const temp=[rol32(a,5),f,e,k,w[j]].reduce(add32);e=d;d=c;c=rol32(b,30);b=a;a=temp}a=add32(a,h0);b=add32(b,h1);c=add32(c,h2);d=add32(d,h3);e=add32(e,h4)}return bytesToHexString(words32ToByteString([a,
b,c,d,e]))}function fk(index,b,c,d){if(index<20)return[b&c|~b&d,1518500249];if(index<40)return[b^c^d,1859775393];if(index<60)return[b&c|b&d|c&d,2400959708];return[b^c^d,3395469782]}function fingerprint(str){const utf8=utf8Encode(str);let hi=hash32(utf8,0);let lo=hash32(utf8,102072);if(hi==0&&(lo==0||lo==1)){hi=hi^319790063;lo=lo^-1801410264}return[hi,lo]}function computeMsgId(msg,meaning=""){let msgFingerprint=fingerprint(msg);if(meaning){const meaningFingerprint=fingerprint(meaning);msgFingerprint=
add64(rol64(msgFingerprint,1),meaningFingerprint)}const hi=msgFingerprint[0];const lo=msgFingerprint[1];return wordsToDecimalString(hi&2147483647,lo)}function hash32(bytes,c){let a=2654435769,b=2654435769;let i;const len=bytes.length;for(i=0;i+12<=len;i+=12){a=add32(a,wordAt(bytes,i,Endian.Little));b=add32(b,wordAt(bytes,i+4,Endian.Little));c=add32(c,wordAt(bytes,i+8,Endian.Little));const res=mix(a,b,c);a=res[0],b=res[1],c=res[2]}a=add32(a,wordAt(bytes,i,Endian.Little));b=add32(b,wordAt(bytes,i+4,
Endian.Little));c=add32(c,len);c=add32(c,wordAt(bytes,i+8,Endian.Little)<<8);return mix(a,b,c)[2]}function mix(a,b,c){a=sub32(a,b);a=sub32(a,c);a^=c>>>13;b=sub32(b,c);b=sub32(b,a);b^=a<<8;c=sub32(c,a);c=sub32(c,b);c^=b>>>13;a=sub32(a,b);a=sub32(a,c);a^=c>>>12;b=sub32(b,c);b=sub32(b,a);b^=a<<16;c=sub32(c,a);c=sub32(c,b);c^=b>>>5;a=sub32(a,b);a=sub32(a,c);a^=c>>>3;b=sub32(b,c);b=sub32(b,a);b^=a<<10;c=sub32(c,a);c=sub32(c,b);c^=b>>>15;return[a,b,c]}var Endian;(function(Endian){Endian[Endian["Little"]=
0]="Little";Endian[Endian["Big"]=1]="Big"})(Endian||(Endian={}));function add32(a,b){return add32to64(a,b)[1]}function add32to64(a,b){const low=(a&65535)+(b&65535);const high=(a>>>16)+(b>>>16)+(low>>>16);return[high>>>16,high<<16|low&65535]}function add64(a,b){const ah=a[0],al=a[1];const bh=b[0],bl=b[1];const result=add32to64(al,bl);const carry=result[0];const l=result[1];const h=add32(add32(ah,bh),carry);return[h,l]}function sub32(a,b){const low=(a&65535)-(b&65535);const high=(a>>16)-(b>>16)+(low>>
16);return high<<16|low&65535}function rol32(a,count){return a<<count|a>>>32-count}function rol64(num,count){const hi=num[0],lo=num[1];const h=hi<<count|lo>>>32-count;const l=lo<<count|hi>>>32-count;return[h,l]}function bytesToWords32(bytes,endian){const size=bytes.length+3>>>2;const words32=[];for(let i=0;i<size;i++)words32[i]=wordAt(bytes,i*4,endian);return words32}function byteAt(bytes,index){return index>=bytes.length?0:bytes[index]}function wordAt(bytes,index,endian){let word=0;if(endian===Endian.Big)for(let i=
0;i<4;i++)word+=byteAt(bytes,index+i)<<24-8*i;else for(let i=0;i<4;i++)word+=byteAt(bytes,index+i)<<8*i;return word}function words32ToByteString(words32){return words32.reduce((bytes,word)=>bytes.concat(word32ToByteString(word)),[])}function word32ToByteString(word){let bytes=[];for(let i=0;i<4;i++)bytes.push(word>>>8*(3-i)&255);return bytes}function bytesToHexString(bytes){let hex="";for(let i=0;i<bytes.length;i++){const b=byteAt(bytes,i);hex+=(b>>>4).toString(16)+(b&15).toString(16)}return hex.toLowerCase()}
const base256=new BigIntExponentiation(256);function wordsToDecimalString(hi,lo){const decimal=base256.toThePowerOf(0).multiplyBy(lo);base256.toThePowerOf(4).multiplyByAndAddTo(hi,decimal);return decimal.toString()}exports.TypeModifier=void 0;(function(TypeModifier){TypeModifier[TypeModifier["None"]=0]="None";TypeModifier[TypeModifier["Const"]=1]="Const"})(exports.TypeModifier||(exports.TypeModifier={}));class Type{constructor(modifiers=exports.TypeModifier.None){this.modifiers=modifiers}hasModifier(modifier){return(this.modifiers&
modifier)!==0}}exports.BuiltinTypeName=void 0;(function(BuiltinTypeName){BuiltinTypeName[BuiltinTypeName["Dynamic"]=0]="Dynamic";BuiltinTypeName[BuiltinTypeName["Bool"]=1]="Bool";BuiltinTypeName[BuiltinTypeName["String"]=2]="String";BuiltinTypeName[BuiltinTypeName["Int"]=3]="Int";BuiltinTypeName[BuiltinTypeName["Number"]=4]="Number";BuiltinTypeName[BuiltinTypeName["Function"]=5]="Function";BuiltinTypeName[BuiltinTypeName["Inferred"]=6]="Inferred";BuiltinTypeName[BuiltinTypeName["None"]=7]="None"})(exports.BuiltinTypeName||
(exports.BuiltinTypeName={}));class BuiltinType extends Type{constructor(name,modifiers){super(modifiers);this.name=name}visitType(visitor,context){return visitor.visitBuiltinType(this,context)}}class ExpressionType extends Type{constructor(value,modifiers,typeParams=null){super(modifiers);this.value=value;this.typeParams=typeParams}visitType(visitor,context){return visitor.visitExpressionType(this,context)}}class ArrayType extends Type{constructor(of,modifiers){super(modifiers);this.of=of}visitType(visitor,
context){return visitor.visitArrayType(this,context)}}class MapType extends Type{constructor(valueType,modifiers){super(modifiers);this.valueType=valueType||null}visitType(visitor,context){return visitor.visitMapType(this,context)}}const DYNAMIC_TYPE=new BuiltinType(exports.BuiltinTypeName.Dynamic);const INFERRED_TYPE=new BuiltinType(exports.BuiltinTypeName.Inferred);const BOOL_TYPE=new BuiltinType(exports.BuiltinTypeName.Bool);const INT_TYPE=new BuiltinType(exports.BuiltinTypeName.Int);const NUMBER_TYPE=
new BuiltinType(exports.BuiltinTypeName.Number);const STRING_TYPE=new BuiltinType(exports.BuiltinTypeName.String);const FUNCTION_TYPE=new BuiltinType(exports.BuiltinTypeName.Function);const NONE_TYPE=new BuiltinType(exports.BuiltinTypeName.None);exports.UnaryOperator=void 0;(function(UnaryOperator){UnaryOperator[UnaryOperator["Minus"]=0]="Minus";UnaryOperator[UnaryOperator["Plus"]=1]="Plus"})(exports.UnaryOperator||(exports.UnaryOperator={}));exports.BinaryOperator=void 0;(function(BinaryOperator){BinaryOperator[BinaryOperator["Equals"]=
0]="Equals";BinaryOperator[BinaryOperator["NotEquals"]=1]="NotEquals";BinaryOperator[BinaryOperator["Identical"]=2]="Identical";BinaryOperator[BinaryOperator["NotIdentical"]=3]="NotIdentical";BinaryOperator[BinaryOperator["Minus"]=4]="Minus";BinaryOperator[BinaryOperator["Plus"]=5]="Plus";BinaryOperator[BinaryOperator["Divide"]=6]="Divide";BinaryOperator[BinaryOperator["Multiply"]=7]="Multiply";BinaryOperator[BinaryOperator["Modulo"]=8]="Modulo";BinaryOperator[BinaryOperator["And"]=9]="And";BinaryOperator[BinaryOperator["Or"]=
10]="Or";BinaryOperator[BinaryOperator["BitwiseAnd"]=11]="BitwiseAnd";BinaryOperator[BinaryOperator["Lower"]=12]="Lower";BinaryOperator[BinaryOperator["LowerEquals"]=13]="LowerEquals";BinaryOperator[BinaryOperator["Bigger"]=14]="Bigger";BinaryOperator[BinaryOperator["BiggerEquals"]=15]="BiggerEquals";BinaryOperator[BinaryOperator["NullishCoalesce"]=16]="NullishCoalesce"})(exports.BinaryOperator||(exports.BinaryOperator={}));function nullSafeIsEquivalent(base,other){if(base==null||other==null)return base==
other;return base.isEquivalent(other)}function areAllEquivalentPredicate(base,other,equivalentPredicate){const len=base.length;if(len!==other.length)return false;for(let i=0;i<len;i++)if(!equivalentPredicate(base[i],other[i]))return false;return true}function areAllEquivalent(base,other){return areAllEquivalentPredicate(base,other,(baseElement,otherElement)=>baseElement.isEquivalent(otherElement))}class Expression{constructor(type,sourceSpan){this.type=type||null;this.sourceSpan=sourceSpan||null}prop(name,
sourceSpan){return new ReadPropExpr(this,name,null,sourceSpan)}key(index,type,sourceSpan){return new ReadKeyExpr(this,index,type,sourceSpan)}callFn(params,sourceSpan,pure){return new InvokeFunctionExpr(this,params,null,sourceSpan,pure)}instantiate(params,type,sourceSpan){return new InstantiateExpr(this,params,type,sourceSpan)}conditional(trueCase,falseCase=null,sourceSpan){return new ConditionalExpr(this,trueCase,falseCase,null,sourceSpan)}equals(rhs,sourceSpan){return new BinaryOperatorExpr(exports.BinaryOperator.Equals,
this,rhs,null,sourceSpan)}notEquals(rhs,sourceSpan){return new BinaryOperatorExpr(exports.BinaryOperator.NotEquals,this,rhs,null,sourceSpan)}identical(rhs,sourceSpan){return new BinaryOperatorExpr(exports.BinaryOperator.Identical,this,rhs,null,sourceSpan)}notIdentical(rhs,sourceSpan){return new BinaryOperatorExpr(exports.BinaryOperator.NotIdentical,this,rhs,null,sourceSpan)}minus(rhs,sourceSpan){return new BinaryOperatorExpr(exports.BinaryOperator.Minus,this,rhs,null,sourceSpan)}plus(rhs,sourceSpan){return new BinaryOperatorExpr(exports.BinaryOperator.Plus,
this,rhs,null,sourceSpan)}divide(rhs,sourceSpan){return new BinaryOperatorExpr(exports.BinaryOperator.Divide,this,rhs,null,sourceSpan)}multiply(rhs,sourceSpan){return new BinaryOperatorExpr(exports.BinaryOperator.Multiply,this,rhs,null,sourceSpan)}modulo(rhs,sourceSpan){return new BinaryOperatorExpr(exports.BinaryOperator.Modulo,this,rhs,null,sourceSpan)}and(rhs,sourceSpan){return new BinaryOperatorExpr(exports.BinaryOperator.And,this,rhs,null,sourceSpan)}bitwiseAnd(rhs,sourceSpan,parens=true){return new BinaryOperatorExpr(exports.BinaryOperator.BitwiseAnd,
this,rhs,null,sourceSpan,parens)}or(rhs,sourceSpan){return new BinaryOperatorExpr(exports.BinaryOperator.Or,this,rhs,null,sourceSpan)}lower(rhs,sourceSpan){return new BinaryOperatorExpr(exports.BinaryOperator.Lower,this,rhs,null,sourceSpan)}lowerEquals(rhs,sourceSpan){return new BinaryOperatorExpr(exports.BinaryOperator.LowerEquals,this,rhs,null,sourceSpan)}bigger(rhs,sourceSpan){return new BinaryOperatorExpr(exports.BinaryOperator.Bigger,this,rhs,null,sourceSpan)}biggerEquals(rhs,sourceSpan){return new BinaryOperatorExpr(exports.BinaryOperator.BiggerEquals,
this,rhs,null,sourceSpan)}isBlank(sourceSpan){return this.equals(TYPED_NULL_EXPR,sourceSpan)}nullishCoalesce(rhs,sourceSpan){return new BinaryOperatorExpr(exports.BinaryOperator.NullishCoalesce,this,rhs,null,sourceSpan)}toStmt(){return new ExpressionStatement(this,null)}}class ReadVarExpr extends Expression{constructor(name,type,sourceSpan){super(type,sourceSpan);this.name=name}isEquivalent(e){return e instanceof ReadVarExpr&&this.name===e.name}isConstant(){return false}visitExpression(visitor,context){return visitor.visitReadVarExpr(this,
context)}set(value){return new WriteVarExpr(this.name,value,null,this.sourceSpan)}}class TypeofExpr extends Expression{constructor(expr,type,sourceSpan){super(type,sourceSpan);this.expr=expr}visitExpression(visitor,context){return visitor.visitTypeofExpr(this,context)}isEquivalent(e){return e instanceof TypeofExpr&&e.expr.isEquivalent(this.expr)}isConstant(){return this.expr.isConstant()}}class WrappedNodeExpr extends Expression{constructor(node,type,sourceSpan){super(type,sourceSpan);this.node=node}isEquivalent(e){return e instanceof
WrappedNodeExpr&&this.node===e.node}isConstant(){return false}visitExpression(visitor,context){return visitor.visitWrappedNodeExpr(this,context)}}class WriteVarExpr extends Expression{constructor(name,value,type,sourceSpan){super(type||value.type,sourceSpan);this.name=name;this.value=value}isEquivalent(e){return e instanceof WriteVarExpr&&this.name===e.name&&this.value.isEquivalent(e.value)}isConstant(){return false}visitExpression(visitor,context){return visitor.visitWriteVarExpr(this,context)}toDeclStmt(type,
modifiers){return new DeclareVarStmt(this.name,this.value,type,modifiers,this.sourceSpan)}toConstDecl(){return this.toDeclStmt(INFERRED_TYPE,exports.StmtModifier.Final)}}class WriteKeyExpr extends Expression{constructor(receiver,index,value,type,sourceSpan){super(type||value.type,sourceSpan);this.receiver=receiver;this.index=index;this.value=value}isEquivalent(e){return e instanceof WriteKeyExpr&&this.receiver.isEquivalent(e.receiver)&&this.index.isEquivalent(e.index)&&this.value.isEquivalent(e.value)}isConstant(){return false}visitExpression(visitor,
context){return visitor.visitWriteKeyExpr(this,context)}}class WritePropExpr extends Expression{constructor(receiver,name,value,type,sourceSpan){super(type||value.type,sourceSpan);this.receiver=receiver;this.name=name;this.value=value}isEquivalent(e){return e instanceof WritePropExpr&&this.receiver.isEquivalent(e.receiver)&&this.name===e.name&&this.value.isEquivalent(e.value)}isConstant(){return false}visitExpression(visitor,context){return visitor.visitWritePropExpr(this,context)}}class InvokeFunctionExpr extends Expression{constructor(fn,
args,type,sourceSpan,pure=false){super(type,sourceSpan);this.fn=fn;this.args=args;this.pure=pure}isEquivalent(e){return e instanceof InvokeFunctionExpr&&this.fn.isEquivalent(e.fn)&&areAllEquivalent(this.args,e.args)&&this.pure===e.pure}isConstant(){return false}visitExpression(visitor,context){return visitor.visitInvokeFunctionExpr(this,context)}}class TaggedTemplateExpr extends Expression{constructor(tag,template,type,sourceSpan){super(type,sourceSpan);this.tag=tag;this.template=template}isEquivalent(e){return e instanceof
TaggedTemplateExpr&&this.tag.isEquivalent(e.tag)&&areAllEquivalentPredicate(this.template.elements,e.template.elements,(a,b)=>a.text===b.text)&&areAllEquivalent(this.template.expressions,e.template.expressions)}isConstant(){return false}visitExpression(visitor,context){return visitor.visitTaggedTemplateExpr(this,context)}}class InstantiateExpr extends Expression{constructor(classExpr,args,type,sourceSpan){super(type,sourceSpan);this.classExpr=classExpr;this.args=args}isEquivalent(e){return e instanceof
InstantiateExpr&&this.classExpr.isEquivalent(e.classExpr)&&areAllEquivalent(this.args,e.args)}isConstant(){return false}visitExpression(visitor,context){return visitor.visitInstantiateExpr(this,context)}}class LiteralExpr extends Expression{constructor(value,type,sourceSpan){super(type,sourceSpan);this.value=value}isEquivalent(e){return e instanceof LiteralExpr&&this.value===e.value}isConstant(){return true}visitExpression(visitor,context){return visitor.visitLiteralExpr(this,context)}}class TemplateLiteral{constructor(elements,
expressions){this.elements=elements;this.expressions=expressions}}class TemplateLiteralElement{constructor(text,sourceSpan,rawText){var _a;this.text=text;this.sourceSpan=sourceSpan;this.rawText=(_a=rawText!==null&&rawText!==void 0?rawText:sourceSpan===null||sourceSpan===void 0?void 0:sourceSpan.toString())!==null&&_a!==void 0?_a:escapeForTemplateLiteral(escapeSlashes(text))}}class LiteralPiece{constructor(text,sourceSpan){this.text=text;this.sourceSpan=sourceSpan}}class PlaceholderPiece{constructor(text,
sourceSpan,associatedMessage){this.text=text;this.sourceSpan=sourceSpan;this.associatedMessage=associatedMessage}}const MEANING_SEPARATOR$1="|";const ID_SEPARATOR$1="@@";const LEGACY_ID_INDICATOR="␟";class LocalizedString extends Expression{constructor(metaBlock,messageParts,placeHolderNames,expressions,sourceSpan){super(STRING_TYPE,sourceSpan);this.metaBlock=metaBlock;this.messageParts=messageParts;this.placeHolderNames=placeHolderNames;this.expressions=expressions}isEquivalent(e){return false}isConstant(){return false}visitExpression(visitor,
context){return visitor.visitLocalizedString(this,context)}serializeI18nHead(){let metaBlock=this.metaBlock.description||"";if(this.metaBlock.meaning)metaBlock=`${this.metaBlock.meaning}${MEANING_SEPARATOR$1}${metaBlock}`;if(this.metaBlock.customId)metaBlock=`${metaBlock}${ID_SEPARATOR$1}${this.metaBlock.customId}`;if(this.metaBlock.legacyIds)this.metaBlock.legacyIds.forEach(legacyId=>{metaBlock=`${metaBlock}${LEGACY_ID_INDICATOR}${legacyId}`});return createCookedRawString(metaBlock,this.messageParts[0].text,
this.getMessagePartSourceSpan(0))}getMessagePartSourceSpan(i){var _a,_b;return(_b=(_a=this.messageParts[i])===null||_a===void 0?void 0:_a.sourceSpan)!==null&&_b!==void 0?_b:this.sourceSpan}getPlaceholderSourceSpan(i){var _a,_b,_c,_d;return(_d=(_b=(_a=this.placeHolderNames[i])===null||_a===void 0?void 0:_a.sourceSpan)!==null&&_b!==void 0?_b:(_c=this.expressions[i])===null||_c===void 0?void 0:_c.sourceSpan)!==null&&_d!==void 0?_d:this.sourceSpan}serializeI18nTemplatePart(partIndex){var _a;const placeholder=
this.placeHolderNames[partIndex-1];const messagePart=this.messageParts[partIndex];let metaBlock=placeholder.text;if(((_a=placeholder.associatedMessage)===null||_a===void 0?void 0:_a.legacyIds.length)===0)metaBlock+=`${ID_SEPARATOR$1}${computeMsgId(placeholder.associatedMessage.messageString,placeholder.associatedMessage.meaning)}`;return createCookedRawString(metaBlock,messagePart.text,this.getMessagePartSourceSpan(partIndex))}}const escapeSlashes=str=>str.replace(/\\/g,"\\\\");const escapeStartingColon=
str=>str.replace(/^:/,"\\:");const escapeColons=str=>str.replace(/:/g,"\\:");const escapeForTemplateLiteral=str=>str.replace(/`/g,"\\`").replace(/\${/g,"$\\{");function createCookedRawString(metaBlock,messagePart,range){if(metaBlock==="")return{cooked:messagePart,raw:escapeForTemplateLiteral(escapeStartingColon(escapeSlashes(messagePart))),range};else return{cooked:`:${metaBlock}:${messagePart}`,raw:escapeForTemplateLiteral(`:${escapeColons(escapeSlashes(metaBlock))}:${escapeSlashes(messagePart)}`),
range}}class ExternalExpr extends Expression{constructor(value,type,typeParams=null,sourceSpan){super(type,sourceSpan);this.value=value;this.typeParams=typeParams}isEquivalent(e){return e instanceof ExternalExpr&&this.value.name===e.value.name&&this.value.moduleName===e.value.moduleName&&this.value.runtime===e.value.runtime}isConstant(){return false}visitExpression(visitor,context){return visitor.visitExternalExpr(this,context)}}class ExternalReference{constructor(moduleName,name,runtime){this.moduleName=
moduleName;this.name=name;this.runtime=runtime}}class ConditionalExpr extends Expression{constructor(condition,trueCase,falseCase=null,type,sourceSpan){super(type||trueCase.type,sourceSpan);this.condition=condition;this.falseCase=falseCase;this.trueCase=trueCase}isEquivalent(e){return e instanceof ConditionalExpr&&this.condition.isEquivalent(e.condition)&&this.trueCase.isEquivalent(e.trueCase)&&nullSafeIsEquivalent(this.falseCase,e.falseCase)}isConstant(){return false}visitExpression(visitor,context){return visitor.visitConditionalExpr(this,
context)}}class NotExpr extends Expression{constructor(condition,sourceSpan){super(BOOL_TYPE,sourceSpan);this.condition=condition}isEquivalent(e){return e instanceof NotExpr&&this.condition.isEquivalent(e.condition)}isConstant(){return false}visitExpression(visitor,context){return visitor.visitNotExpr(this,context)}}class FnParam{constructor(name,type=null){this.name=name;this.type=type}isEquivalent(param){return this.name===param.name}}class FunctionExpr extends Expression{constructor(params,statements,
type,sourceSpan,name){super(type,sourceSpan);this.params=params;this.statements=statements;this.name=name}isEquivalent(e){return e instanceof FunctionExpr&&areAllEquivalent(this.params,e.params)&&areAllEquivalent(this.statements,e.statements)}isConstant(){return false}visitExpression(visitor,context){return visitor.visitFunctionExpr(this,context)}toDeclStmt(name,modifiers){return new DeclareFunctionStmt(name,this.params,this.statements,this.type,modifiers,this.sourceSpan)}}class UnaryOperatorExpr extends Expression{constructor(operator,
expr,type,sourceSpan,parens=true){super(type||NUMBER_TYPE,sourceSpan);this.operator=operator;this.expr=expr;this.parens=parens}isEquivalent(e){return e instanceof UnaryOperatorExpr&&this.operator===e.operator&&this.expr.isEquivalent(e.expr)}isConstant(){return false}visitExpression(visitor,context){return visitor.visitUnaryOperatorExpr(this,context)}}class BinaryOperatorExpr extends Expression{constructor(operator,lhs,rhs,type,sourceSpan,parens=true){super(type||lhs.type,sourceSpan);this.operator=
operator;this.rhs=rhs;this.parens=parens;this.lhs=lhs}isEquivalent(e){return e instanceof BinaryOperatorExpr&&this.operator===e.operator&&this.lhs.isEquivalent(e.lhs)&&this.rhs.isEquivalent(e.rhs)}isConstant(){return false}visitExpression(visitor,context){return visitor.visitBinaryOperatorExpr(this,context)}}class ReadPropExpr extends Expression{constructor(receiver,name,type,sourceSpan){super(type,sourceSpan);this.receiver=receiver;this.name=name}isEquivalent(e){return e instanceof ReadPropExpr&&
this.receiver.isEquivalent(e.receiver)&&this.name===e.name}isConstant(){return false}visitExpression(visitor,context){return visitor.visitReadPropExpr(this,context)}set(value){return new WritePropExpr(this.receiver,this.name,value,null,this.sourceSpan)}}class ReadKeyExpr extends Expression{constructor(receiver,index,type,sourceSpan){super(type,sourceSpan);this.receiver=receiver;this.index=index}isEquivalent(e){return e instanceof ReadKeyExpr&&this.receiver.isEquivalent(e.receiver)&&this.index.isEquivalent(e.index)}isConstant(){return false}visitExpression(visitor,
context){return visitor.visitReadKeyExpr(this,context)}set(value){return new WriteKeyExpr(this.receiver,this.index,value,null,this.sourceSpan)}}class LiteralArrayExpr extends Expression{constructor(entries,type,sourceSpan){super(type,sourceSpan);this.entries=entries}isConstant(){return this.entries.every(e=>e.isConstant())}isEquivalent(e){return e instanceof LiteralArrayExpr&&areAllEquivalent(this.entries,e.entries)}visitExpression(visitor,context){return visitor.visitLiteralArrayExpr(this,context)}}
class LiteralMapEntry{constructor(key,value,quoted){this.key=key;this.value=value;this.quoted=quoted}isEquivalent(e){return this.key===e.key&&this.value.isEquivalent(e.value)}}class LiteralMapExpr extends Expression{constructor(entries,type,sourceSpan){super(type,sourceSpan);this.entries=entries;this.valueType=null;if(type)this.valueType=type.valueType}isEquivalent(e){return e instanceof LiteralMapExpr&&areAllEquivalent(this.entries,e.entries)}isConstant(){return this.entries.every(e=>e.value.isConstant())}visitExpression(visitor,
context){return visitor.visitLiteralMapExpr(this,context)}}class CommaExpr extends Expression{constructor(parts,sourceSpan){super(parts[parts.length-1].type,sourceSpan);this.parts=parts}isEquivalent(e){return e instanceof CommaExpr&&areAllEquivalent(this.parts,e.parts)}isConstant(){return false}visitExpression(visitor,context){return visitor.visitCommaExpr(this,context)}}const NULL_EXPR=new LiteralExpr(null,null,null);const TYPED_NULL_EXPR=new LiteralExpr(null,INFERRED_TYPE,null);exports.StmtModifier=
void 0;(function(StmtModifier){StmtModifier[StmtModifier["None"]=0]="None";StmtModifier[StmtModifier["Final"]=1]="Final";StmtModifier[StmtModifier["Private"]=2]="Private";StmtModifier[StmtModifier["Exported"]=4]="Exported";StmtModifier[StmtModifier["Static"]=8]="Static"})(exports.StmtModifier||(exports.StmtModifier={}));class LeadingComment{constructor(text,multiline,trailingNewline){this.text=text;this.multiline=multiline;this.trailingNewline=trailingNewline}toString(){return this.multiline?` ${this.text} `:
this.text}}class JSDocComment extends LeadingComment{constructor(tags){super("",true,true);this.tags=tags}toString(){return serializeTags(this.tags)}}class Statement{constructor(modifiers=exports.StmtModifier.None,sourceSpan=null,leadingComments){this.modifiers=modifiers;this.sourceSpan=sourceSpan;this.leadingComments=leadingComments}hasModifier(modifier){return(this.modifiers&modifier)!==0}addLeadingComment(leadingComment){var _a;this.leadingComments=(_a=this.leadingComments)!==null&&_a!==void 0?
_a:[];this.leadingComments.push(leadingComment)}}class DeclareVarStmt extends Statement{constructor(name,value,type,modifiers,sourceSpan,leadingComments){super(modifiers,sourceSpan,leadingComments);this.name=name;this.value=value;this.type=type||value&&value.type||null}isEquivalent(stmt){return stmt instanceof DeclareVarStmt&&this.name===stmt.name&&(this.value?!!stmt.value&&this.value.isEquivalent(stmt.value):!stmt.value)}visitStatement(visitor,context){return visitor.visitDeclareVarStmt(this,context)}}
class DeclareFunctionStmt extends Statement{constructor(name,params,statements,type,modifiers,sourceSpan,leadingComments){super(modifiers,sourceSpan,leadingComments);this.name=name;this.params=params;this.statements=statements;this.type=type||null}isEquivalent(stmt){return stmt instanceof DeclareFunctionStmt&&areAllEquivalent(this.params,stmt.params)&&areAllEquivalent(this.statements,stmt.statements)}visitStatement(visitor,context){return visitor.visitDeclareFunctionStmt(this,context)}}class ExpressionStatement extends Statement{constructor(expr,
sourceSpan,leadingComments){super(exports.StmtModifier.None,sourceSpan,leadingComments);this.expr=expr}isEquivalent(stmt){return stmt instanceof ExpressionStatement&&this.expr.isEquivalent(stmt.expr)}visitStatement(visitor,context){return visitor.visitExpressionStmt(this,context)}}class ReturnStatement extends Statement{constructor(value,sourceSpan=null,leadingComments){super(exports.StmtModifier.None,sourceSpan,leadingComments);this.value=value}isEquivalent(stmt){return stmt instanceof ReturnStatement&&
this.value.isEquivalent(stmt.value)}visitStatement(visitor,context){return visitor.visitReturnStmt(this,context)}}class IfStmt extends Statement{constructor(condition,trueCase,falseCase=[],sourceSpan,leadingComments){super(exports.StmtModifier.None,sourceSpan,leadingComments);this.condition=condition;this.trueCase=trueCase;this.falseCase=falseCase}isEquivalent(stmt){return stmt instanceof IfStmt&&this.condition.isEquivalent(stmt.condition)&&areAllEquivalent(this.trueCase,stmt.trueCase)&&areAllEquivalent(this.falseCase,
stmt.falseCase)}visitStatement(visitor,context){return visitor.visitIfStmt(this,context)}}class RecursiveAstVisitor$1{visitType(ast,context){return ast}visitExpression(ast,context){if(ast.type)ast.type.visitType(this,context);return ast}visitBuiltinType(type,context){return this.visitType(type,context)}visitExpressionType(type,context){type.value.visitExpression(this,context);if(type.typeParams!==null)type.typeParams.forEach(param=>this.visitType(param,context));return this.visitType(type,context)}visitArrayType(type,
context){return this.visitType(type,context)}visitMapType(type,context){return this.visitType(type,context)}visitWrappedNodeExpr(ast,context){return ast}visitTypeofExpr(ast,context){return this.visitExpression(ast,context)}visitReadVarExpr(ast,context){return this.visitExpression(ast,context)}visitWriteVarExpr(ast,context){ast.value.visitExpression(this,context);return this.visitExpression(ast,context)}visitWriteKeyExpr(ast,context){ast.receiver.visitExpression(this,context);ast.index.visitExpression(this,
context);ast.value.visitExpression(this,context);return this.visitExpression(ast,context)}visitWritePropExpr(ast,context){ast.receiver.visitExpression(this,context);ast.value.visitExpression(this,context);return this.visitExpression(ast,context)}visitInvokeFunctionExpr(ast,context){ast.fn.visitExpression(this,context);this.visitAllExpressions(ast.args,context);return this.visitExpression(ast,context)}visitTaggedTemplateExpr(ast,context){ast.tag.visitExpression(this,context);this.visitAllExpressions(ast.template.expressions,
context);return this.visitExpression(ast,context)}visitInstantiateExpr(ast,context){ast.classExpr.visitExpression(this,context);this.visitAllExpressions(ast.args,context);return this.visitExpression(ast,context)}visitLiteralExpr(ast,context){return this.visitExpression(ast,context)}visitLocalizedString(ast,context){return this.visitExpression(ast,context)}visitExternalExpr(ast,context){if(ast.typeParams)ast.typeParams.forEach(type=>type.visitType(this,context));return this.visitExpression(ast,context)}visitConditionalExpr(ast,
context){ast.condition.visitExpression(this,context);ast.trueCase.visitExpression(this,context);ast.falseCase.visitExpression(this,context);return this.visitExpression(ast,context)}visitNotExpr(ast,context){ast.condition.visitExpression(this,context);return this.visitExpression(ast,context)}visitFunctionExpr(ast,context){this.visitAllStatements(ast.statements,context);return this.visitExpression(ast,context)}visitUnaryOperatorExpr(ast,context){ast.expr.visitExpression(this,context);return this.visitExpression(ast,
context)}visitBinaryOperatorExpr(ast,context){ast.lhs.visitExpression(this,context);ast.rhs.visitExpression(this,context);return this.visitExpression(ast,context)}visitReadPropExpr(ast,context){ast.receiver.visitExpression(this,context);return this.visitExpression(ast,context)}visitReadKeyExpr(ast,context){ast.receiver.visitExpression(this,context);ast.index.visitExpression(this,context);return this.visitExpression(ast,context)}visitLiteralArrayExpr(ast,context){this.visitAllExpressions(ast.entries,
context);return this.visitExpression(ast,context)}visitLiteralMapExpr(ast,context){ast.entries.forEach(entry=>entry.value.visitExpression(this,context));return this.visitExpression(ast,context)}visitCommaExpr(ast,context){this.visitAllExpressions(ast.parts,context);return this.visitExpression(ast,context)}visitAllExpressions(exprs,context){exprs.forEach(expr=>expr.visitExpression(this,context))}visitDeclareVarStmt(stmt,context){if(stmt.value)stmt.value.visitExpression(this,context);if(stmt.type)stmt.type.visitType(this,
context);return stmt}visitDeclareFunctionStmt(stmt,context){this.visitAllStatements(stmt.statements,context);if(stmt.type)stmt.type.visitType(this,context);return stmt}visitExpressionStmt(stmt,context){stmt.expr.visitExpression(this,context);return stmt}visitReturnStmt(stmt,context){stmt.value.visitExpression(this,context);return stmt}visitIfStmt(stmt,context){stmt.condition.visitExpression(this,context);this.visitAllStatements(stmt.trueCase,context);this.visitAllStatements(stmt.falseCase,context);
return stmt}visitAllStatements(stmts,context){stmts.forEach(stmt=>stmt.visitStatement(this,context))}}function leadingComment(text,multiline=false,trailingNewline=true){return new LeadingComment(text,multiline,trailingNewline)}function jsDocComment(tags=[]){return new JSDocComment(tags)}function variable(name,type,sourceSpan){return new ReadVarExpr(name,type,sourceSpan)}function importExpr(id,typeParams=null,sourceSpan){return new ExternalExpr(id,null,typeParams,sourceSpan)}function importType(id,
typeParams,typeModifiers){return id!=null?expressionType(importExpr(id,typeParams,null),typeModifiers):null}function expressionType(expr,typeModifiers,typeParams){return new ExpressionType(expr,typeModifiers,typeParams)}function typeofExpr(expr){return new TypeofExpr(expr)}function literalArr(values,type,sourceSpan){return new LiteralArrayExpr(values,type,sourceSpan)}function literalMap(values,type=null){return new LiteralMapExpr(values.map(e=>new LiteralMapEntry(e.key,e.value,e.quoted)),type,null)}
function unary(operator,expr,type,sourceSpan){return new UnaryOperatorExpr(operator,expr,type,sourceSpan)}function not(expr,sourceSpan){return new NotExpr(expr,sourceSpan)}function fn(params,body,type,sourceSpan,name){return new FunctionExpr(params,body,type,sourceSpan,name)}function ifStmt(condition,thenClause,elseClause,sourceSpan,leadingComments){return new IfStmt(condition,thenClause,elseClause,sourceSpan,leadingComments)}function taggedTemplate(tag,template,type,sourceSpan){return new TaggedTemplateExpr(tag,
template,type,sourceSpan)}function literal(value,type,sourceSpan){return new LiteralExpr(value,type,sourceSpan)}function localizedString(metaBlock,messageParts,placeholderNames,expressions,sourceSpan){return new LocalizedString(metaBlock,messageParts,placeholderNames,expressions,sourceSpan)}function isNull(exp){return exp instanceof LiteralExpr&&exp.value===null}function tagToString(tag){let out="";if(tag.tagName)out+=` @${tag.tagName}`;if(tag.text){if(tag.text.match(/\/\*|\*\//))throw new Error('JSDoc text cannot contain "/*" and "*/"');
out+=" "+tag.text.replace(/@/g,"\\@")}return out}function serializeTags(tags){if(tags.length===0)return"";if(tags.length===1&&tags[0].tagName&&!tags[0].text)return`*${tagToString(tags[0])} `;let out="*\n";for(const tag of tags){out+=" *";out+=tagToString(tag).replace(/\n/g,"\n * ");out+="\n"}out+=" ";return out}var output_ast=Object.freeze({__proto__:null,get TypeModifier(){return exports.TypeModifier},Type:Type,get BuiltinTypeName(){return exports.BuiltinTypeName},BuiltinType:BuiltinType,ExpressionType:ExpressionType,
ArrayType:ArrayType,MapType:MapType,DYNAMIC_TYPE:DYNAMIC_TYPE,INFERRED_TYPE:INFERRED_TYPE,BOOL_TYPE:BOOL_TYPE,INT_TYPE:INT_TYPE,NUMBER_TYPE:NUMBER_TYPE,STRING_TYPE:STRING_TYPE,FUNCTION_TYPE:FUNCTION_TYPE,NONE_TYPE:NONE_TYPE,get UnaryOperator(){return exports.UnaryOperator},get BinaryOperator(){return exports.BinaryOperator},nullSafeIsEquivalent:nullSafeIsEquivalent,areAllEquivalent:areAllEquivalent,Expression:Expression,ReadVarExpr:ReadVarExpr,TypeofExpr:TypeofExpr,WrappedNodeExpr:WrappedNodeExpr,
WriteVarExpr:WriteVarExpr,WriteKeyExpr:WriteKeyExpr,WritePropExpr:WritePropExpr,InvokeFunctionExpr:InvokeFunctionExpr,TaggedTemplateExpr:TaggedTemplateExpr,InstantiateExpr:InstantiateExpr,LiteralExpr:LiteralExpr,TemplateLiteral:TemplateLiteral,TemplateLiteralElement:TemplateLiteralElement,LiteralPiece:LiteralPiece,PlaceholderPiece:PlaceholderPiece,LocalizedString:LocalizedString,ExternalExpr:ExternalExpr,ExternalReference:ExternalReference,ConditionalExpr:ConditionalExpr,NotExpr:NotExpr,FnParam:FnParam,
FunctionExpr:FunctionExpr,UnaryOperatorExpr:UnaryOperatorExpr,BinaryOperatorExpr:BinaryOperatorExpr,ReadPropExpr:ReadPropExpr,ReadKeyExpr:ReadKeyExpr,LiteralArrayExpr:LiteralArrayExpr,LiteralMapEntry:LiteralMapEntry,LiteralMapExpr:LiteralMapExpr,CommaExpr:CommaExpr,NULL_EXPR:NULL_EXPR,TYPED_NULL_EXPR:TYPED_NULL_EXPR,get StmtModifier(){return exports.StmtModifier},LeadingComment:LeadingComment,JSDocComment:JSDocComment,Statement:Statement,DeclareVarStmt:DeclareVarStmt,DeclareFunctionStmt:DeclareFunctionStmt,
ExpressionStatement:ExpressionStatement,ReturnStatement:ReturnStatement,IfStmt:IfStmt,RecursiveAstVisitor:RecursiveAstVisitor$1,leadingComment:leadingComment,jsDocComment:jsDocComment,variable:variable,importExpr:importExpr,importType:importType,expressionType:expressionType,typeofExpr:typeofExpr,literalArr:literalArr,literalMap:literalMap,unary:unary,not:not,fn:fn,ifStmt:ifStmt,taggedTemplate:taggedTemplate,literal:literal,localizedString:localizedString,isNull:isNull});const CONSTANT_PREFIX="_c";
const UNKNOWN_VALUE_KEY=variable("<unknown>");const KEY_CONTEXT={};const POOL_INCLUSION_LENGTH_THRESHOLD_FOR_STRINGS=50;class FixupExpression extends Expression{constructor(resolved){super(resolved.type);this.resolved=resolved;this.original=resolved}visitExpression(visitor,context){if(context===KEY_CONTEXT)return this.original.visitExpression(visitor,context);else return this.resolved.visitExpression(visitor,context)}isEquivalent(e){return e instanceof FixupExpression&&this.resolved.isEquivalent(e.resolved)}isConstant(){return true}fixup(expression){this.resolved=
expression;this.shared=true}}class ConstantPool{constructor(isClosureCompilerEnabled=false){this.isClosureCompilerEnabled=isClosureCompilerEnabled;this.statements=[];this.literals=new Map;this.literalFactories=new Map;this.nextNameIndex=0}getConstLiteral(literal,forceShared){if(literal instanceof LiteralExpr&&!isLongStringLiteral(literal)||literal instanceof FixupExpression)return literal;const key=this.keyOf(literal);let fixup=this.literals.get(key);let newValue=false;if(!fixup){fixup=new FixupExpression(literal);
this.literals.set(key,fixup);newValue=true}if(!newValue&&!fixup.shared||newValue&&forceShared){const name=this.freshName();let definition;let usage;if(this.isClosureCompilerEnabled&&isLongStringLiteral(literal)){definition=variable(name).set(new FunctionExpr([],[new ReturnStatement(literal)]));usage=variable(name).callFn([])}else{definition=variable(name).set(literal);usage=variable(name)}this.statements.push(definition.toDeclStmt(INFERRED_TYPE,exports.StmtModifier.Final));fixup.fixup(usage)}return fixup}getLiteralFactory(literal){if(literal instanceof
LiteralArrayExpr){const argumentsForKey=literal.entries.map(e=>e.isConstant()?e:UNKNOWN_VALUE_KEY);const key=this.keyOf(literalArr(argumentsForKey));return this._getLiteralFactory(key,literal.entries,entries=>literalArr(entries))}else{const expressionForKey=literalMap(literal.entries.map(e=>({key:e.key,value:e.value.isConstant()?e.value:UNKNOWN_VALUE_KEY,quoted:e.quoted})));const key=this.keyOf(expressionForKey);return this._getLiteralFactory(key,literal.entries.map(e=>e.value),entries=>literalMap(entries.map((value,
index)=>({key:literal.entries[index].key,value,quoted:literal.entries[index].quoted}))))}}_getLiteralFactory(key,values,resultMap){let literalFactory=this.literalFactories.get(key);const literalFactoryArguments=values.filter(e=>!e.isConstant());if(!literalFactory){const resultExpressions=values.map((e,index)=>e.isConstant()?this.getConstLiteral(e,true):variable(`a${index}`));const parameters=resultExpressions.filter(isVariable).map(e=>new FnParam(e.name,DYNAMIC_TYPE));const pureFunctionDeclaration=
fn(parameters,[new ReturnStatement(resultMap(resultExpressions))],INFERRED_TYPE);const name=this.freshName();this.statements.push(variable(name).set(pureFunctionDeclaration).toDeclStmt(INFERRED_TYPE,exports.StmtModifier.Final));literalFactory=variable(name);this.literalFactories.set(key,literalFactory)}return{literalFactory,literalFactoryArguments}}uniqueName(prefix){return`${prefix}${this.nextNameIndex++}`}freshName(){return this.uniqueName(CONSTANT_PREFIX)}keyOf(expression){return expression.visitExpression(new KeyVisitor,
KEY_CONTEXT)}}class KeyVisitor{constructor(){this.visitWrappedNodeExpr=invalid$1;this.visitWriteVarExpr=invalid$1;this.visitWriteKeyExpr=invalid$1;this.visitWritePropExpr=invalid$1;this.visitInvokeFunctionExpr=invalid$1;this.visitTaggedTemplateExpr=invalid$1;this.visitInstantiateExpr=invalid$1;this.visitConditionalExpr=invalid$1;this.visitNotExpr=invalid$1;this.visitAssertNotNullExpr=invalid$1;this.visitCastExpr=invalid$1;this.visitFunctionExpr=invalid$1;this.visitUnaryOperatorExpr=invalid$1;this.visitBinaryOperatorExpr=
invalid$1;this.visitReadPropExpr=invalid$1;this.visitReadKeyExpr=invalid$1;this.visitCommaExpr=invalid$1;this.visitLocalizedString=invalid$1}visitLiteralExpr(ast){return`${typeof ast.value==="string"?'"'+ast.value+'"':ast.value}`}visitLiteralArrayExpr(ast,context){return`[${ast.entries.map(entry=>entry.visitExpression(this,context)).join(",")}]`}visitLiteralMapExpr(ast,context){const mapKey=entry=>{const quote=entry.quoted?'"':"";return`${quote}${entry.key}${quote}`};const mapEntry=entry=>`${mapKey(entry)}:${entry.value.visitExpression(this,
context)}`;return`{${ast.entries.map(mapEntry).join(",")}`}visitExternalExpr(ast){return ast.value.moduleName?`EX:${ast.value.moduleName}:${ast.value.name}`:`EX:${ast.value.runtime.name}`}visitReadVarExpr(node){return`VAR:${node.name}`}visitTypeofExpr(node,context){return`TYPEOF:${node.expr.visitExpression(this,context)}`}}function invalid$1(arg){throw new Error(`Invalid state: Visitor ${this.constructor.name} doesn't handle ${arg.constructor.name}`);}function isVariable(e){return e instanceof ReadVarExpr}
function isLongStringLiteral(expr){return expr instanceof LiteralExpr&&typeof expr.value==="string"&&expr.value.length>=POOL_INCLUSION_LENGTH_THRESHOLD_FOR_STRINGS}const CORE$1="@angular/core";class Identifiers$1{}Identifiers$1.NEW_METHOD="factory";Identifiers$1.TRANSFORM_METHOD="transform";Identifiers$1.PATCH_DEPS="patchedDeps";Identifiers$1.core={name:null,moduleName:CORE$1};Identifiers$1.namespaceHTML={name:"ɵɵnamespaceHTML",moduleName:CORE$1};Identifiers$1.namespaceMathML={name:"ɵɵnamespaceMathML",
moduleName:CORE$1};Identifiers$1.namespaceSVG={name:"ɵɵnamespaceSVG",moduleName:CORE$1};Identifiers$1.element={name:"ɵɵelement",moduleName:CORE$1};Identifiers$1.elementStart={name:"ɵɵelementStart",moduleName:CORE$1};Identifiers$1.elementEnd={name:"ɵɵelementEnd",moduleName:CORE$1};Identifiers$1.advance={name:"ɵɵadvance",moduleName:CORE$1};Identifiers$1.syntheticHostProperty={name:"ɵɵsyntheticHostProperty",moduleName:CORE$1};Identifiers$1.syntheticHostListener={name:"ɵɵsyntheticHostListener",moduleName:CORE$1};
Identifiers$1.attribute={name:"ɵɵattribute",moduleName:CORE$1};Identifiers$1.attributeInterpolate1={name:"ɵɵattributeInterpolate1",moduleName:CORE$1};Identifiers$1.attributeInterpolate2={name:"ɵɵattributeInterpolate2",moduleName:CORE$1};Identifiers$1.attributeInterpolate3={name:"ɵɵattributeInterpolate3",moduleName:CORE$1};Identifiers$1.attributeInterpolate4={name:"ɵɵattributeInterpolate4",moduleName:CORE$1};Identifiers$1.attributeInterpolate5={name:"ɵɵattributeInterpolate5",moduleName:CORE$1};Identifiers$1.attributeInterpolate6=
{name:"ɵɵattributeInterpolate6",moduleName:CORE$1};Identifiers$1.attributeInterpolate7={name:"ɵɵattributeInterpolate7",moduleName:CORE$1};Identifiers$1.attributeInterpolate8={name:"ɵɵattributeInterpolate8",moduleName:CORE$1};Identifiers$1.attributeInterpolateV={name:"ɵɵattributeInterpolateV",moduleName:CORE$1};Identifiers$1.classProp={name:"ɵɵclassProp",moduleName:CORE$1};Identifiers$1.elementContainerStart={name:"ɵɵelementContainerStart",moduleName:CORE$1};Identifiers$1.elementContainerEnd={name:"ɵɵelementContainerEnd",
moduleName:CORE$1};Identifiers$1.elementContainer={name:"ɵɵelementContainer",moduleName:CORE$1};Identifiers$1.styleMap={name:"ɵɵstyleMap",moduleName:CORE$1};Identifiers$1.styleMapInterpolate1={name:"ɵɵstyleMapInterpolate1",moduleName:CORE$1};Identifiers$1.styleMapInterpolate2={name:"ɵɵstyleMapInterpolate2",moduleName:CORE$1};Identifiers$1.styleMapInterpolate3={name:"ɵɵstyleMapInterpolate3",moduleName:CORE$1};Identifiers$1.styleMapInterpolate4={name:"ɵɵstyleMapInterpolate4",moduleName:CORE$1};Identifiers$1.styleMapInterpolate5=
{name:"ɵɵstyleMapInterpolate5",moduleName:CORE$1};Identifiers$1.styleMapInterpolate6={name:"ɵɵstyleMapInterpolate6",moduleName:CORE$1};Identifiers$1.styleMapInterpolate7={name:"ɵɵstyleMapInterpolate7",moduleName:CORE$1};Identifiers$1.styleMapInterpolate8={name:"ɵɵstyleMapInterpolate8",moduleName:CORE$1};Identifiers$1.styleMapInterpolateV={name:"ɵɵstyleMapInterpolateV",moduleName:CORE$1};Identifiers$1.classMap={name:"ɵɵclassMap",moduleName:CORE$1};Identifiers$1.classMapInterpolate1={name:"ɵɵclassMapInterpolate1",
moduleName:CORE$1};Identifiers$1.classMapInterpolate2={name:"ɵɵclassMapInterpolate2",moduleName:CORE$1};Identifiers$1.classMapInterpolate3={name:"ɵɵclassMapInterpolate3",moduleName:CORE$1};Identifiers$1.classMapInterpolate4={name:"ɵɵclassMapInterpolate4",moduleName:CORE$1};Identifiers$1.classMapInterpolate5={name:"ɵɵclassMapInterpolate5",moduleName:CORE$1};Identifiers$1.classMapInterpolate6={name:"ɵɵclassMapInterpolate6",moduleName:CORE$1};Identifiers$1.classMapInterpolate7={name:"ɵɵclassMapInterpolate7",
moduleName:CORE$1};Identifiers$1.classMapInterpolate8={name:"ɵɵclassMapInterpolate8",moduleName:CORE$1};Identifiers$1.classMapInterpolateV={name:"ɵɵclassMapInterpolateV",moduleName:CORE$1};Identifiers$1.styleProp={name:"ɵɵstyleProp",moduleName:CORE$1};Identifiers$1.stylePropInterpolate1={name:"ɵɵstylePropInterpolate1",moduleName:CORE$1};Identifiers$1.stylePropInterpolate2={name:"ɵɵstylePropInterpolate2",moduleName:CORE$1};Identifiers$1.stylePropInterpolate3={name:"ɵɵstylePropInterpolate3",moduleName:CORE$1};
Identifiers$1.stylePropInterpolate4={name:"ɵɵstylePropInterpolate4",moduleName:CORE$1};Identifiers$1.stylePropInterpolate5={name:"ɵɵstylePropInterpolate5",moduleName:CORE$1};Identifiers$1.stylePropInterpolate6={name:"ɵɵstylePropInterpolate6",moduleName:CORE$1};Identifiers$1.stylePropInterpolate7={name:"ɵɵstylePropInterpolate7",moduleName:CORE$1};Identifiers$1.stylePropInterpolate8={name:"ɵɵstylePropInterpolate8",moduleName:CORE$1};Identifiers$1.stylePropInterpolateV={name:"ɵɵstylePropInterpolateV",
moduleName:CORE$1};Identifiers$1.nextContext={name:"ɵɵnextContext",moduleName:CORE$1};Identifiers$1.templateCreate={name:"ɵɵtemplate",moduleName:CORE$1};Identifiers$1.text={name:"ɵɵtext",moduleName:CORE$1};Identifiers$1.enableBindings={name:"ɵɵenableBindings",moduleName:CORE$1};Identifiers$1.disableBindings={name:"ɵɵdisableBindings",moduleName:CORE$1};Identifiers$1.getCurrentView={name:"ɵɵgetCurrentView",moduleName:CORE$1};Identifiers$1.textInterpolate={name:"ɵɵtextInterpolate",moduleName:CORE$1};
Identifiers$1.textInterpolate1={name:"ɵɵtextInterpolate1",moduleName:CORE$1};Identifiers$1.textInterpolate2={name:"ɵɵtextInterpolate2",moduleName:CORE$1};Identifiers$1.textInterpolate3={name:"ɵɵtextInterpolate3",moduleName:CORE$1};Identifiers$1.textInterpolate4={name:"ɵɵtextInterpolate4",moduleName:CORE$1};Identifiers$1.textInterpolate5={name:"ɵɵtextInterpolate5",moduleName:CORE$1};Identifiers$1.textInterpolate6={name:"ɵɵtextInterpolate6",moduleName:CORE$1};Identifiers$1.textInterpolate7={name:"ɵɵtextInterpolate7",
moduleName:CORE$1};Identifiers$1.textInterpolate8={name:"ɵɵtextInterpolate8",moduleName:CORE$1};Identifiers$1.textInterpolateV={name:"ɵɵtextInterpolateV",moduleName:CORE$1};Identifiers$1.restoreView={name:"ɵɵrestoreView",moduleName:CORE$1};Identifiers$1.pureFunction0={name:"ɵɵpureFunction0",moduleName:CORE$1};Identifiers$1.pureFunction1={name:"ɵɵpureFunction1",moduleName:CORE$1};Identifiers$1.pureFunction2={name:"ɵɵpureFunction2",moduleName:CORE$1};Identifiers$1.pureFunction3={name:"ɵɵpureFunction3",
moduleName:CORE$1};Identifiers$1.pureFunction4={name:"ɵɵpureFunction4",moduleName:CORE$1};Identifiers$1.pureFunction5={name:"ɵɵpureFunction5",moduleName:CORE$1};Identifiers$1.pureFunction6={name:"ɵɵpureFunction6",moduleName:CORE$1};Identifiers$1.pureFunction7={name:"ɵɵpureFunction7",moduleName:CORE$1};Identifiers$1.pureFunction8={name:"ɵɵpureFunction8",moduleName:CORE$1};Identifiers$1.pureFunctionV={name:"ɵɵpureFunctionV",moduleName:CORE$1};Identifiers$1.pipeBind1={name:"ɵɵpipeBind1",moduleName:CORE$1};
Identifiers$1.pipeBind2={name:"ɵɵpipeBind2",moduleName:CORE$1};Identifiers$1.pipeBind3={name:"ɵɵpipeBind3",moduleName:CORE$1};Identifiers$1.pipeBind4={name:"ɵɵpipeBind4",moduleName:CORE$1};Identifiers$1.pipeBindV={name:"ɵɵpipeBindV",moduleName:CORE$1};Identifiers$1.hostProperty={name:"ɵɵhostProperty",moduleName:CORE$1};Identifiers$1.property={name:"ɵɵproperty",moduleName:CORE$1};Identifiers$1.propertyInterpolate={name:"ɵɵpropertyInterpolate",moduleName:CORE$1};Identifiers$1.propertyInterpolate1={name:"ɵɵpropertyInterpolate1",
moduleName:CORE$1};Identifiers$1.propertyInterpolate2={name:"ɵɵpropertyInterpolate2",moduleName:CORE$1};Identifiers$1.propertyInterpolate3={name:"ɵɵpropertyInterpolate3",moduleName:CORE$1};Identifiers$1.propertyInterpolate4={name:"ɵɵpropertyInterpolate4",moduleName:CORE$1};Identifiers$1.propertyInterpolate5={name:"ɵɵpropertyInterpolate5",moduleName:CORE$1};Identifiers$1.propertyInterpolate6={name:"ɵɵpropertyInterpolate6",moduleName:CORE$1};Identifiers$1.propertyInterpolate7={name:"ɵɵpropertyInterpolate7",
moduleName:CORE$1};Identifiers$1.propertyInterpolate8={name:"ɵɵpropertyInterpolate8",moduleName:CORE$1};Identifiers$1.propertyInterpolateV={name:"ɵɵpropertyInterpolateV",moduleName:CORE$1};Identifiers$1.i18n={name:"ɵɵi18n",moduleName:CORE$1};Identifiers$1.i18nAttributes={name:"ɵɵi18nAttributes",moduleName:CORE$1};Identifiers$1.i18nExp={name:"ɵɵi18nExp",moduleName:CORE$1};Identifiers$1.i18nStart={name:"ɵɵi18nStart",moduleName:CORE$1};Identifiers$1.i18nEnd={name:"ɵɵi18nEnd",moduleName:CORE$1};Identifiers$1.i18nApply=
{name:"ɵɵi18nApply",moduleName:CORE$1};Identifiers$1.i18nPostprocess={name:"ɵɵi18nPostprocess",moduleName:CORE$1};Identifiers$1.pipe={name:"ɵɵpipe",moduleName:CORE$1};Identifiers$1.projection={name:"ɵɵprojection",moduleName:CORE$1};Identifiers$1.projectionDef={name:"ɵɵprojectionDef",moduleName:CORE$1};Identifiers$1.reference={name:"ɵɵreference",moduleName:CORE$1};Identifiers$1.inject={name:"ɵɵinject",moduleName:CORE$1};Identifiers$1.injectAttribute={name:"ɵɵinjectAttribute",moduleName:CORE$1};Identifiers$1.directiveInject=
{name:"ɵɵdirectiveInject",moduleName:CORE$1};Identifiers$1.invalidFactory={name:"ɵɵinvalidFactory",moduleName:CORE$1};Identifiers$1.invalidFactoryDep={name:"ɵɵinvalidFactoryDep",moduleName:CORE$1};Identifiers$1.templateRefExtractor={name:"ɵɵtemplateRefExtractor",moduleName:CORE$1};Identifiers$1.forwardRef={name:"forwardRef",moduleName:CORE$1};Identifiers$1.resolveForwardRef={name:"resolveForwardRef",moduleName:CORE$1};Identifiers$1.\u0275\u0275defineInjectable={name:"ɵɵdefineInjectable",moduleName:CORE$1};
Identifiers$1.declareInjectable={name:"ɵɵngDeclareInjectable",moduleName:CORE$1};Identifiers$1.InjectableDeclaration={name:"ɵɵInjectableDeclaration",moduleName:CORE$1};Identifiers$1.resolveWindow={name:"ɵɵresolveWindow",moduleName:CORE$1};Identifiers$1.resolveDocument={name:"ɵɵresolveDocument",moduleName:CORE$1};Identifiers$1.resolveBody={name:"ɵɵresolveBody",moduleName:CORE$1};Identifiers$1.defineComponent={name:"ɵɵdefineComponent",moduleName:CORE$1};Identifiers$1.declareComponent={name:"ɵɵngDeclareComponent",
moduleName:CORE$1};Identifiers$1.setComponentScope={name:"ɵɵsetComponentScope",moduleName:CORE$1};Identifiers$1.ChangeDetectionStrategy={name:"ChangeDetectionStrategy",moduleName:CORE$1};Identifiers$1.ViewEncapsulation={name:"ViewEncapsulation",moduleName:CORE$1};Identifiers$1.ComponentDeclaration={name:"ɵɵComponentDeclaration",moduleName:CORE$1};Identifiers$1.FactoryDeclaration={name:"ɵɵFactoryDeclaration",moduleName:CORE$1};Identifiers$1.declareFactory={name:"ɵɵngDeclareFactory",moduleName:CORE$1};
Identifiers$1.FactoryTarget={name:"ɵɵFactoryTarget",moduleName:CORE$1};Identifiers$1.defineDirective={name:"ɵɵdefineDirective",moduleName:CORE$1};Identifiers$1.declareDirective={name:"ɵɵngDeclareDirective",moduleName:CORE$1};Identifiers$1.DirectiveDeclaration={name:"ɵɵDirectiveDeclaration",moduleName:CORE$1};Identifiers$1.InjectorDef={name:"ɵɵInjectorDef",moduleName:CORE$1};Identifiers$1.InjectorDeclaration={name:"ɵɵInjectorDeclaration",moduleName:CORE$1};Identifiers$1.defineInjector={name:"ɵɵdefineInjector",
moduleName:CORE$1};Identifiers$1.declareInjector={name:"ɵɵngDeclareInjector",moduleName:CORE$1};Identifiers$1.NgModuleDeclaration={name:"ɵɵNgModuleDeclaration",moduleName:CORE$1};Identifiers$1.ModuleWithProviders={name:"ModuleWithProviders",moduleName:CORE$1};Identifiers$1.defineNgModule={name:"ɵɵdefineNgModule",moduleName:CORE$1};Identifiers$1.declareNgModule={name:"ɵɵngDeclareNgModule",moduleName:CORE$1};Identifiers$1.setNgModuleScope={name:"ɵɵsetNgModuleScope",moduleName:CORE$1};Identifiers$1.PipeDeclaration=
{name:"ɵɵPipeDeclaration",moduleName:CORE$1};Identifiers$1.definePipe={name:"ɵɵdefinePipe",moduleName:CORE$1};Identifiers$1.declarePipe={name:"ɵɵngDeclarePipe",moduleName:CORE$1};Identifiers$1.declareClassMetadata={name:"ɵɵngDeclareClassMetadata",moduleName:CORE$1};Identifiers$1.setClassMetadata={name:"ɵsetClassMetadata",moduleName:CORE$1};Identifiers$1.queryRefresh={name:"ɵɵqueryRefresh",moduleName:CORE$1};Identifiers$1.viewQuery={name:"ɵɵviewQuery",moduleName:CORE$1};Identifiers$1.loadQuery={name:"ɵɵloadQuery",
moduleName:CORE$1};Identifiers$1.contentQuery={name:"ɵɵcontentQuery",moduleName:CORE$1};Identifiers$1.NgOnChangesFeature={name:"ɵɵNgOnChangesFeature",moduleName:CORE$1};Identifiers$1.InheritDefinitionFeature={name:"ɵɵInheritDefinitionFeature",moduleName:CORE$1};Identifiers$1.CopyDefinitionFeature={name:"ɵɵCopyDefinitionFeature",moduleName:CORE$1};Identifiers$1.ProvidersFeature={name:"ɵɵProvidersFeature",moduleName:CORE$1};Identifiers$1.listener={name:"ɵɵlistener",moduleName:CORE$1};Identifiers$1.getInheritedFactory=
{name:"ɵɵgetInheritedFactory",moduleName:CORE$1};Identifiers$1.sanitizeHtml={name:"ɵɵsanitizeHtml",moduleName:CORE$1};Identifiers$1.sanitizeStyle={name:"ɵɵsanitizeStyle",moduleName:CORE$1};Identifiers$1.sanitizeResourceUrl={name:"ɵɵsanitizeResourceUrl",moduleName:CORE$1};Identifiers$1.sanitizeScript={name:"ɵɵsanitizeScript",moduleName:CORE$1};Identifiers$1.sanitizeUrl={name:"ɵɵsanitizeUrl",moduleName:CORE$1};Identifiers$1.sanitizeUrlOrResourceUrl={name:"ɵɵsanitizeUrlOrResourceUrl",moduleName:CORE$1};
Identifiers$1.trustConstantHtml={name:"ɵɵtrustConstantHtml",moduleName:CORE$1};Identifiers$1.trustConstantResourceUrl={name:"ɵɵtrustConstantResourceUrl",moduleName:CORE$1};const VERSION$1=3;const JS_B64_PREFIX="# sourceMappingURL=data:application/json;base64,";class SourceMapGenerator{constructor(file=null){this.file=file;this.sourcesContent=new Map;this.lines=[];this.lastCol0=0;this.hasMappings=false}addSource(url,content=null){if(!this.sourcesContent.has(url))this.sourcesContent.set(url,content);
return this}addLine(){this.lines.push([]);this.lastCol0=0;return this}addMapping(col0,sourceUrl,sourceLine0,sourceCol0){if(!this.currentLine)throw new Error(`A line must be added before mappings can be added`);if(sourceUrl!=null&&!this.sourcesContent.has(sourceUrl))throw new Error(`Unknown source file "${sourceUrl}"`);if(col0==null)throw new Error(`The column in the generated code must be provided`);if(col0<this.lastCol0)throw new Error(`Mapping should be added in output order`);if(sourceUrl&&(sourceLine0==
null||sourceCol0==null))throw new Error(`The source location must be provided when a source url is provided`);this.hasMappings=true;this.lastCol0=col0;this.currentLine.push({col0,sourceUrl,sourceLine0,sourceCol0});return this}get currentLine(){return this.lines.slice(-1)[0]}toJSON(){if(!this.hasMappings)return null;const sourcesIndex=new Map;const sources=[];const sourcesContent=[];Array.from(this.sourcesContent.keys()).forEach((url,i)=>{sourcesIndex.set(url,i);sources.push(url);sourcesContent.push(this.sourcesContent.get(url)||
null)});let mappings="";let lastCol0=0;let lastSourceIndex=0;let lastSourceLine0=0;let lastSourceCol0=0;this.lines.forEach(segments=>{lastCol0=0;mappings+=segments.map(segment=>{let segAsStr=toBase64VLQ(segment.col0-lastCol0);lastCol0=segment.col0;if(segment.sourceUrl!=null){segAsStr+=toBase64VLQ(sourcesIndex.get(segment.sourceUrl)-lastSourceIndex);lastSourceIndex=sourcesIndex.get(segment.sourceUrl);segAsStr+=toBase64VLQ(segment.sourceLine0-lastSourceLine0);lastSourceLine0=segment.sourceLine0;segAsStr+=
toBase64VLQ(segment.sourceCol0-lastSourceCol0);lastSourceCol0=segment.sourceCol0}return segAsStr}).join(",");mappings+=";"});mappings=mappings.slice(0,-1);return{"file":this.file||"","version":VERSION$1,"sourceRoot":"","sources":sources,"sourcesContent":sourcesContent,"mappings":mappings}}toJsComment(){return this.hasMappings?"//"+JS_B64_PREFIX+toBase64String(JSON.stringify(this,null,0)):""}}function toBase64String(value){let b64="";const encoded=utf8Encode(value);for(let i=0;i<encoded.length;){const i1=
encoded[i++];const i2=i<encoded.length?encoded[i++]:null;const i3=i<encoded.length?encoded[i++]:null;b64+=toBase64Digit(i1>>2);b64+=toBase64Digit((i1&3)<<4|(i2===null?0:i2>>4));b64+=i2===null?"=":toBase64Digit((i2&15)<<2|(i3===null?0:i3>>6));b64+=i2===null||i3===null?"=":toBase64Digit(i3&63)}return b64}function toBase64VLQ(value){value=value<0?(-value<<1)+1:value<<1;let out="";do{let digit=value&31;value=value>>5;if(value>0)digit=digit|32;out+=toBase64Digit(digit)}while(value>0);return out}const B64_DIGITS=
"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";function toBase64Digit(value){if(value<0||value>=64)throw new Error(`Can only encode value in the range [0, 63]`);return B64_DIGITS[value]}const _SINGLE_QUOTE_ESCAPE_STRING_RE=/'|\\|\n|\r|\$/g;const _LEGAL_IDENTIFIER_RE=/^[$A-Z_][0-9A-Z_$]*$/i;const _INDENT_WITH="  ";class _EmittedLine{constructor(indent){this.indent=indent;this.partsLength=0;this.parts=[];this.srcSpans=[]}}class EmitterVisitorContext{constructor(_indent){this._indent=
_indent;this._lines=[new _EmittedLine(_indent)]}static createRoot(){return new EmitterVisitorContext(0)}get _currentLine(){return this._lines[this._lines.length-1]}println(from,lastPart=""){this.print(from||null,lastPart,true)}lineIsEmpty(){return this._currentLine.parts.length===0}lineLength(){return this._currentLine.indent*_INDENT_WITH.length+this._currentLine.partsLength}print(from,part,newLine=false){if(part.length>0){this._currentLine.parts.push(part);this._currentLine.partsLength+=part.length;
this._currentLine.srcSpans.push(from&&from.sourceSpan||null)}if(newLine)this._lines.push(new _EmittedLine(this._indent))}removeEmptyLastLine(){if(this.lineIsEmpty())this._lines.pop()}incIndent(){this._indent++;if(this.lineIsEmpty())this._currentLine.indent=this._indent}decIndent(){this._indent--;if(this.lineIsEmpty())this._currentLine.indent=this._indent}toSource(){return this.sourceLines.map(l=>l.parts.length>0?_createIndent(l.indent)+l.parts.join(""):"").join("\n")}toSourceMapGenerator(genFilePath,
startsAtLine=0){const map=new SourceMapGenerator(genFilePath);let firstOffsetMapped=false;const mapFirstOffsetIfNeeded=()=>{if(!firstOffsetMapped){map.addSource(genFilePath," ").addMapping(0,genFilePath,0,0);firstOffsetMapped=true}};for(let i=0;i<startsAtLine;i++){map.addLine();mapFirstOffsetIfNeeded()}this.sourceLines.forEach((line,lineIdx)=>{map.addLine();const spans=line.srcSpans;const parts=line.parts;let col0=line.indent*_INDENT_WITH.length;let spanIdx=0;while(spanIdx<spans.length&&!spans[spanIdx]){col0+=
parts[spanIdx].length;spanIdx++}if(spanIdx<spans.length&&lineIdx===0&&col0===0)firstOffsetMapped=true;else mapFirstOffsetIfNeeded();while(spanIdx<spans.length){const span=spans[spanIdx];const source=span.start.file;const sourceLine=span.start.line;const sourceCol=span.start.col;map.addSource(source.url,source.content).addMapping(col0,source.url,sourceLine,sourceCol);col0+=parts[spanIdx].length;spanIdx++;while(spanIdx<spans.length&&(span===spans[spanIdx]||!spans[spanIdx])){col0+=parts[spanIdx].length;
spanIdx++}}});return map}spanOf(line,column){const emittedLine=this._lines[line];if(emittedLine){let columnsLeft=column-_createIndent(emittedLine.indent).length;for(let partIndex=0;partIndex<emittedLine.parts.length;partIndex++){const part=emittedLine.parts[partIndex];if(part.length>columnsLeft)return emittedLine.srcSpans[partIndex];columnsLeft-=part.length}}return null}get sourceLines(){if(this._lines.length&&this._lines[this._lines.length-1].parts.length===0)return this._lines.slice(0,-1);return this._lines}}
class AbstractEmitterVisitor{constructor(_escapeDollarInStrings){this._escapeDollarInStrings=_escapeDollarInStrings}printLeadingComments(stmt,ctx){if(stmt.leadingComments===undefined)return;for(const comment of stmt.leadingComments)if(comment instanceof JSDocComment)ctx.print(stmt,`/*${comment.toString()}*/`,comment.trailingNewline);else if(comment.multiline)ctx.print(stmt,`/* ${comment.text} */`,comment.trailingNewline);else comment.text.split("\n").forEach(line=>{ctx.println(stmt,`// ${line}`)})}visitExpressionStmt(stmt,
ctx){this.printLeadingComments(stmt,ctx);stmt.expr.visitExpression(this,ctx);ctx.println(stmt,";");return null}visitReturnStmt(stmt,ctx){this.printLeadingComments(stmt,ctx);ctx.print(stmt,`return `);stmt.value.visitExpression(this,ctx);ctx.println(stmt,";");return null}visitIfStmt(stmt,ctx){this.printLeadingComments(stmt,ctx);ctx.print(stmt,`if (`);stmt.condition.visitExpression(this,ctx);ctx.print(stmt,`) {`);const hasElseCase=stmt.falseCase!=null&&stmt.falseCase.length>0;if(stmt.trueCase.length<=
1&&!hasElseCase){ctx.print(stmt,` `);this.visitAllStatements(stmt.trueCase,ctx);ctx.removeEmptyLastLine();ctx.print(stmt,` `)}else{ctx.println();ctx.incIndent();this.visitAllStatements(stmt.trueCase,ctx);ctx.decIndent();if(hasElseCase){ctx.println(stmt,`} else {`);ctx.incIndent();this.visitAllStatements(stmt.falseCase,ctx);ctx.decIndent()}}ctx.println(stmt,`}`);return null}visitWriteVarExpr(expr,ctx){const lineWasEmpty=ctx.lineIsEmpty();if(!lineWasEmpty)ctx.print(expr,"(");ctx.print(expr,`${expr.name} = `);
expr.value.visitExpression(this,ctx);if(!lineWasEmpty)ctx.print(expr,")");return null}visitWriteKeyExpr(expr,ctx){const lineWasEmpty=ctx.lineIsEmpty();if(!lineWasEmpty)ctx.print(expr,"(");expr.receiver.visitExpression(this,ctx);ctx.print(expr,`[`);expr.index.visitExpression(this,ctx);ctx.print(expr,`] = `);expr.value.visitExpression(this,ctx);if(!lineWasEmpty)ctx.print(expr,")");return null}visitWritePropExpr(expr,ctx){const lineWasEmpty=ctx.lineIsEmpty();if(!lineWasEmpty)ctx.print(expr,"(");expr.receiver.visitExpression(this,
ctx);ctx.print(expr,`.${expr.name} = `);expr.value.visitExpression(this,ctx);if(!lineWasEmpty)ctx.print(expr,")");return null}visitInvokeFunctionExpr(expr,ctx){expr.fn.visitExpression(this,ctx);ctx.print(expr,`(`);this.visitAllExpressions(expr.args,ctx,",");ctx.print(expr,`)`);return null}visitTaggedTemplateExpr(expr,ctx){expr.tag.visitExpression(this,ctx);ctx.print(expr,"`"+expr.template.elements[0].rawText);for(let i=1;i<expr.template.elements.length;i++){ctx.print(expr,"${");expr.template.expressions[i-
1].visitExpression(this,ctx);ctx.print(expr,`}${expr.template.elements[i].rawText}`)}ctx.print(expr,"`");return null}visitWrappedNodeExpr(ast,ctx){throw new Error("Abstract emitter cannot visit WrappedNodeExpr.");}visitTypeofExpr(expr,ctx){ctx.print(expr,"typeof ");expr.expr.visitExpression(this,ctx)}visitReadVarExpr(ast,ctx){ctx.print(ast,ast.name);return null}visitInstantiateExpr(ast,ctx){ctx.print(ast,`new `);ast.classExpr.visitExpression(this,ctx);ctx.print(ast,`(`);this.visitAllExpressions(ast.args,
ctx,",");ctx.print(ast,`)`);return null}visitLiteralExpr(ast,ctx){const value=ast.value;if(typeof value==="string")ctx.print(ast,escapeIdentifier(value,this._escapeDollarInStrings));else ctx.print(ast,`${value}`);return null}visitLocalizedString(ast,ctx){const head=ast.serializeI18nHead();ctx.print(ast,"$localize `"+head.raw);for(let i=1;i<ast.messageParts.length;i++){ctx.print(ast,"${");ast.expressions[i-1].visitExpression(this,ctx);ctx.print(ast,`}${ast.serializeI18nTemplatePart(i).raw}`)}ctx.print(ast,
"`");return null}visitConditionalExpr(ast,ctx){ctx.print(ast,`(`);ast.condition.visitExpression(this,ctx);ctx.print(ast,"? ");ast.trueCase.visitExpression(this,ctx);ctx.print(ast,": ");ast.falseCase.visitExpression(this,ctx);ctx.print(ast,`)`);return null}visitNotExpr(ast,ctx){ctx.print(ast,"!");ast.condition.visitExpression(this,ctx);return null}visitUnaryOperatorExpr(ast,ctx){let opStr;switch(ast.operator){case exports.UnaryOperator.Plus:opStr="+";break;case exports.UnaryOperator.Minus:opStr="-";
break;default:throw new Error(`Unknown operator ${ast.operator}`);}if(ast.parens)ctx.print(ast,`(`);ctx.print(ast,opStr);ast.expr.visitExpression(this,ctx);if(ast.parens)ctx.print(ast,`)`);return null}visitBinaryOperatorExpr(ast,ctx){let opStr;switch(ast.operator){case exports.BinaryOperator.Equals:opStr="==";break;case exports.BinaryOperator.Identical:opStr="===";break;case exports.BinaryOperator.NotEquals:opStr="!=";break;case exports.BinaryOperator.NotIdentical:opStr="!==";break;case exports.BinaryOperator.And:opStr=
"&&";break;case exports.BinaryOperator.BitwiseAnd:opStr="&";break;case exports.BinaryOperator.Or:opStr="||";break;case exports.BinaryOperator.Plus:opStr="+";break;case exports.BinaryOperator.Minus:opStr="-";break;case exports.BinaryOperator.Divide:opStr="/";break;case exports.BinaryOperator.Multiply:opStr="*";break;case exports.BinaryOperator.Modulo:opStr="%";break;case exports.BinaryOperator.Lower:opStr="<";break;case exports.BinaryOperator.LowerEquals:opStr="<=";break;case exports.BinaryOperator.Bigger:opStr=
">";break;case exports.BinaryOperator.BiggerEquals:opStr=">=";break;case exports.BinaryOperator.NullishCoalesce:opStr="??";break;default:throw new Error(`Unknown operator ${ast.operator}`);}if(ast.parens)ctx.print(ast,`(`);ast.lhs.visitExpression(this,ctx);ctx.print(ast,` ${opStr} `);ast.rhs.visitExpression(this,ctx);if(ast.parens)ctx.print(ast,`)`);return null}visitReadPropExpr(ast,ctx){ast.receiver.visitExpression(this,ctx);ctx.print(ast,`.`);ctx.print(ast,ast.name);return null}visitReadKeyExpr(ast,
ctx){ast.receiver.visitExpression(this,ctx);ctx.print(ast,`[`);ast.index.visitExpression(this,ctx);ctx.print(ast,`]`);return null}visitLiteralArrayExpr(ast,ctx){ctx.print(ast,`[`);this.visitAllExpressions(ast.entries,ctx,",");ctx.print(ast,`]`);return null}visitLiteralMapExpr(ast,ctx){ctx.print(ast,`{`);this.visitAllObjects(entry=>{ctx.print(ast,`${escapeIdentifier(entry.key,this._escapeDollarInStrings,entry.quoted)}:`);entry.value.visitExpression(this,ctx)},ast.entries,ctx,",");ctx.print(ast,`}`);
return null}visitCommaExpr(ast,ctx){ctx.print(ast,"(");this.visitAllExpressions(ast.parts,ctx,",");ctx.print(ast,")");return null}visitAllExpressions(expressions,ctx,separator){this.visitAllObjects(expr=>expr.visitExpression(this,ctx),expressions,ctx,separator)}visitAllObjects(handler,expressions,ctx,separator){let incrementedIndent=false;for(let i=0;i<expressions.length;i++){if(i>0)if(ctx.lineLength()>80){ctx.print(null,separator,true);if(!incrementedIndent){ctx.incIndent();ctx.incIndent();incrementedIndent=
true}}else ctx.print(null,separator,false);handler(expressions[i])}if(incrementedIndent){ctx.decIndent();ctx.decIndent()}}visitAllStatements(statements,ctx){statements.forEach(stmt=>stmt.visitStatement(this,ctx))}}function escapeIdentifier(input,escapeDollar,alwaysQuote=true){if(input==null)return null;const body=input.replace(_SINGLE_QUOTE_ESCAPE_STRING_RE,(...match)=>{if(match[0]=="$")return escapeDollar?"\\$":"$";else if(match[0]=="\n")return"\\n";else if(match[0]=="\r")return"\\r";else return`\\${match[0]}`});
const requiresQuotes=alwaysQuote||!_LEGAL_IDENTIFIER_RE.test(body);return requiresQuotes?`'${body}'`:body}function _createIndent(count){let res="";for(let i=0;i<count;i++)res+=_INDENT_WITH;return res}function typeWithParameters(type,numParams){if(numParams===0)return expressionType(type);const params=[];for(let i=0;i<numParams;i++)params.push(DYNAMIC_TYPE);return expressionType(type,undefined,params)}const ANIMATE_SYMBOL_PREFIX="@";function prepareSyntheticPropertyName(name){return`${ANIMATE_SYMBOL_PREFIX}${name}`}
function prepareSyntheticListenerName(name,phase){return`${ANIMATE_SYMBOL_PREFIX}${name}.${phase}`}function getSafePropertyAccessString(accessor,name){const escapedName=escapeIdentifier(name,false,false);return escapedName!==name?`${accessor}[${escapedName}]`:`${accessor}.${name}`}function prepareSyntheticListenerFunctionName(name,phase){return`animation_${name}_${phase}`}function jitOnlyGuardedExpression(expr){return guardedExpression("ngJitMode",expr)}function devOnlyGuardedExpression(expr){return guardedExpression("ngDevMode",
expr)}function guardedExpression(guard,expr){const guardExpr=new ExternalExpr({name:guard,moduleName:null});const guardNotDefined=new BinaryOperatorExpr(exports.BinaryOperator.Identical,new TypeofExpr(guardExpr),literal("undefined"));const guardUndefinedOrTrue=new BinaryOperatorExpr(exports.BinaryOperator.Or,guardNotDefined,guardExpr,undefined,undefined,true);return new BinaryOperatorExpr(exports.BinaryOperator.And,guardUndefinedOrTrue,expr)}function wrapReference(value){const wrapped=new WrappedNodeExpr(value);
return{value:wrapped,type:wrapped}}function refsToArray(refs,shouldForwardDeclare){const values=literalArr(refs.map(ref=>ref.value));return shouldForwardDeclare?fn([],[new ReturnStatement(values)]):values}function createMayBeForwardRefExpression(expression,forwardRef){return{expression,forwardRef}}function convertFromMaybeForwardRefExpression({expression,forwardRef}){switch(forwardRef){case 0:case 1:return expression;case 2:return generateForwardRef(expression)}}function generateForwardRef(expr){return importExpr(Identifiers$1.forwardRef).callFn([fn([],
[new ReturnStatement(expr)])])}var R3FactoryDelegateType;(function(R3FactoryDelegateType){R3FactoryDelegateType[R3FactoryDelegateType["Class"]=0]="Class";R3FactoryDelegateType[R3FactoryDelegateType["Function"]=1]="Function"})(R3FactoryDelegateType||(R3FactoryDelegateType={}));exports.FactoryTarget=void 0;(function(FactoryTarget){FactoryTarget[FactoryTarget["Directive"]=0]="Directive";FactoryTarget[FactoryTarget["Component"]=1]="Component";FactoryTarget[FactoryTarget["Injectable"]=2]="Injectable";
FactoryTarget[FactoryTarget["Pipe"]=3]="Pipe";FactoryTarget[FactoryTarget["NgModule"]=4]="NgModule"})(exports.FactoryTarget||(exports.FactoryTarget={}));function compileFactoryFunction(meta){const t=variable("t");let baseFactoryVar=null;const typeForCtor=!isDelegatedFactoryMetadata(meta)?new BinaryOperatorExpr(exports.BinaryOperator.Or,t,meta.internalType):t;let ctorExpr=null;if(meta.deps!==null){if(meta.deps!=="invalid")ctorExpr=new InstantiateExpr(typeForCtor,injectDependencies(meta.deps,meta.target))}else{baseFactoryVar=
variable(`ɵ${meta.name}_BaseFactory`);ctorExpr=baseFactoryVar.callFn([typeForCtor])}const body=[];let retExpr=null;function makeConditionalFactory(nonCtorExpr){const r=variable("r");body.push(r.set(NULL_EXPR).toDeclStmt());const ctorStmt=ctorExpr!==null?r.set(ctorExpr).toStmt():importExpr(Identifiers$1.invalidFactory).callFn([]).toStmt();body.push(ifStmt(t,[ctorStmt],[r.set(nonCtorExpr).toStmt()]));return r}if(isDelegatedFactoryMetadata(meta)){const delegateArgs=injectDependencies(meta.delegateDeps,
meta.target);const factoryExpr=new (meta.delegateType===R3FactoryDelegateType.Class?InstantiateExpr:InvokeFunctionExpr)(meta.delegate,delegateArgs);retExpr=makeConditionalFactory(factoryExpr)}else if(isExpressionFactoryMetadata(meta))retExpr=makeConditionalFactory(meta.expression);else retExpr=ctorExpr;if(retExpr===null)body.push(importExpr(Identifiers$1.invalidFactory).callFn([]).toStmt());else if(baseFactoryVar!==null){const getInheritedFactoryCall=importExpr(Identifiers$1.getInheritedFactory).callFn([meta.internalType]);
const baseFactory=new BinaryOperatorExpr(exports.BinaryOperator.Or,baseFactoryVar,baseFactoryVar.set(getInheritedFactoryCall));body.push(new ReturnStatement(baseFactory.callFn([typeForCtor])))}else body.push(new ReturnStatement(retExpr));let factoryFn=fn([new FnParam("t",DYNAMIC_TYPE)],body,INFERRED_TYPE,undefined,`${meta.name}_Factory`);if(baseFactoryVar!==null)factoryFn=fn([],[new DeclareVarStmt(baseFactoryVar.name),new ReturnStatement(factoryFn)]).callFn([],undefined,true);return{expression:factoryFn,
statements:[],type:createFactoryType(meta)}}function createFactoryType(meta){const ctorDepsType=meta.deps!==null&&meta.deps!=="invalid"?createCtorDepsType(meta.deps):NONE_TYPE;return expressionType(importExpr(Identifiers$1.FactoryDeclaration,[typeWithParameters(meta.type.type,meta.typeArgumentCount),ctorDepsType]))}function injectDependencies(deps,target){return deps.map((dep,index)=>compileInjectDependency(dep,target,index))}function compileInjectDependency(dep,target,index){if(dep.token===null)return importExpr(Identifiers$1.invalidFactoryDep).callFn([literal(index)]);
else if(dep.attributeNameType===null){const flags=0|(dep.self?2:0)|(dep.skipSelf?4:0)|(dep.host?1:0)|(dep.optional?8:0)|(target===exports.FactoryTarget.Pipe?16:0);let flagsParam=flags!==0||dep.optional?literal(flags):null;const injectArgs=[dep.token];if(flagsParam)injectArgs.push(flagsParam);const injectFn=getInjectFn(target);return importExpr(injectFn).callFn(injectArgs)}else return importExpr(Identifiers$1.injectAttribute).callFn([dep.token])}function createCtorDepsType(deps){let hasTypes=false;
const attributeTypes=deps.map(dep=>{const type=createCtorDepType(dep);if(type!==null){hasTypes=true;return type}else return literal(null)});if(hasTypes)return expressionType(literalArr(attributeTypes));else return NONE_TYPE}function createCtorDepType(dep){const entries=[];if(dep.attributeNameType!==null)entries.push({key:"attribute",value:dep.attributeNameType,quoted:false});if(dep.optional)entries.push({key:"optional",value:literal(true),quoted:false});if(dep.host)entries.push({key:"host",value:literal(true),
quoted:false});if(dep.self)entries.push({key:"self",value:literal(true),quoted:false});if(dep.skipSelf)entries.push({key:"skipSelf",value:literal(true),quoted:false});return entries.length>0?literalMap(entries):null}function isDelegatedFactoryMetadata(meta){return meta.delegateType!==undefined}function isExpressionFactoryMetadata(meta){return meta.expression!==undefined}function getInjectFn(target){switch(target){case exports.FactoryTarget.Component:case exports.FactoryTarget.Directive:case exports.FactoryTarget.Pipe:return Identifiers$1.directiveInject;
case exports.FactoryTarget.NgModule:case exports.FactoryTarget.Injectable:default:return Identifiers$1.inject}}class Comment$1{constructor(value,sourceSpan){this.value=value;this.sourceSpan=sourceSpan}visit(_visitor){throw new Error("visit() not implemented for Comment");}}class Text$3{constructor(value,sourceSpan){this.value=value;this.sourceSpan=sourceSpan}visit(visitor){return visitor.visitText(this)}}class BoundText{constructor(value,sourceSpan,i18n){this.value=value;this.sourceSpan=sourceSpan;
this.i18n=i18n}visit(visitor){return visitor.visitBoundText(this)}}class TextAttribute{constructor(name,value,sourceSpan,keySpan,valueSpan,i18n){this.name=name;this.value=value;this.sourceSpan=sourceSpan;this.keySpan=keySpan;this.valueSpan=valueSpan;this.i18n=i18n}visit(visitor){return visitor.visitTextAttribute(this)}}class BoundAttribute{constructor(name,type,securityContext,value,unit,sourceSpan,keySpan,valueSpan,i18n){this.name=name;this.type=type;this.securityContext=securityContext;this.value=
value;this.unit=unit;this.sourceSpan=sourceSpan;this.keySpan=keySpan;this.valueSpan=valueSpan;this.i18n=i18n}static fromBoundElementProperty(prop,i18n){if(prop.keySpan===undefined)throw new Error(`Unexpected state: keySpan must be defined for bound attributes but was not for ${prop.name}: ${prop.sourceSpan}`);return new BoundAttribute(prop.name,prop.type,prop.securityContext,prop.value,prop.unit,prop.sourceSpan,prop.keySpan,prop.valueSpan,i18n)}visit(visitor){return visitor.visitBoundAttribute(this)}}
class BoundEvent{constructor(name,type,handler,target,phase,sourceSpan,handlerSpan,keySpan){this.name=name;this.type=type;this.handler=handler;this.target=target;this.phase=phase;this.sourceSpan=sourceSpan;this.handlerSpan=handlerSpan;this.keySpan=keySpan}static fromParsedEvent(event){const target=event.type===0?event.targetOrPhase:null;const phase=event.type===1?event.targetOrPhase:null;if(event.keySpan===undefined)throw new Error(`Unexpected state: keySpan must be defined for bound event but was not for ${event.name}: ${event.sourceSpan}`);
return new BoundEvent(event.name,event.type,event.handler,target,phase,event.sourceSpan,event.handlerSpan,event.keySpan)}visit(visitor){return visitor.visitBoundEvent(this)}}class Element$1{constructor(name,attributes,inputs,outputs,children,references,sourceSpan,startSourceSpan,endSourceSpan,i18n){this.name=name;this.attributes=attributes;this.inputs=inputs;this.outputs=outputs;this.children=children;this.references=references;this.sourceSpan=sourceSpan;this.startSourceSpan=startSourceSpan;this.endSourceSpan=
endSourceSpan;this.i18n=i18n}visit(visitor){return visitor.visitElement(this)}}class Template{constructor(tagName,attributes,inputs,outputs,templateAttrs,children,references,variables,sourceSpan,startSourceSpan,endSourceSpan,i18n){this.tagName=tagName;this.attributes=attributes;this.inputs=inputs;this.outputs=outputs;this.templateAttrs=templateAttrs;this.children=children;this.references=references;this.variables=variables;this.sourceSpan=sourceSpan;this.startSourceSpan=startSourceSpan;this.endSourceSpan=
endSourceSpan;this.i18n=i18n}visit(visitor){return visitor.visitTemplate(this)}}class Content{constructor(selector,attributes,sourceSpan,i18n){this.selector=selector;this.attributes=attributes;this.sourceSpan=sourceSpan;this.i18n=i18n;this.name="ng-content"}visit(visitor){return visitor.visitContent(this)}}class Variable{constructor(name,value,sourceSpan,keySpan,valueSpan){this.name=name;this.value=value;this.sourceSpan=sourceSpan;this.keySpan=keySpan;this.valueSpan=valueSpan}visit(visitor){return visitor.visitVariable(this)}}
class Reference{constructor(name,value,sourceSpan,keySpan,valueSpan){this.name=name;this.value=value;this.sourceSpan=sourceSpan;this.keySpan=keySpan;this.valueSpan=valueSpan}visit(visitor){return visitor.visitReference(this)}}class Icu$1{constructor(vars,placeholders,sourceSpan,i18n){this.vars=vars;this.placeholders=placeholders;this.sourceSpan=sourceSpan;this.i18n=i18n}visit(visitor){return visitor.visitIcu(this)}}class RecursiveVisitor$1{visitElement(element){visitAll$1(this,element.attributes);
visitAll$1(this,element.inputs);visitAll$1(this,element.outputs);visitAll$1(this,element.children);visitAll$1(this,element.references)}visitTemplate(template){visitAll$1(this,template.attributes);visitAll$1(this,template.inputs);visitAll$1(this,template.outputs);visitAll$1(this,template.children);visitAll$1(this,template.references);visitAll$1(this,template.variables)}visitContent(content){}visitVariable(variable){}visitReference(reference){}visitTextAttribute(attribute){}visitBoundAttribute(attribute){}visitBoundEvent(attribute){}visitText(text){}visitBoundText(text){}visitIcu(icu){}}
function visitAll$1(visitor,nodes){const result=[];if(visitor.visit)for(const node of nodes)visitor.visit(node)||node.visit(visitor);else for(const node of nodes){const newNode=node.visit(visitor);if(newNode)result.push(newNode)}return result}class Message{constructor(nodes,placeholders,placeholderToMessage,meaning,description,customId){this.nodes=nodes;this.placeholders=placeholders;this.placeholderToMessage=placeholderToMessage;this.meaning=meaning;this.description=description;this.customId=customId;
this.id=this.customId;this.legacyIds=[];this.messageString=serializeMessage(this.nodes);if(nodes.length)this.sources=[{filePath:nodes[0].sourceSpan.start.file.url,startLine:nodes[0].sourceSpan.start.line+1,startCol:nodes[0].sourceSpan.start.col+1,endLine:nodes[nodes.length-1].sourceSpan.end.line+1,endCol:nodes[0].sourceSpan.start.col+1}];else this.sources=[]}}class Text$2{constructor(value,sourceSpan){this.value=value;this.sourceSpan=sourceSpan}visit(visitor,context){return visitor.visitText(this,
context)}}class Container{constructor(children,sourceSpan){this.children=children;this.sourceSpan=sourceSpan}visit(visitor,context){return visitor.visitContainer(this,context)}}class Icu{constructor(expression,type,cases,sourceSpan){this.expression=expression;this.type=type;this.cases=cases;this.sourceSpan=sourceSpan}visit(visitor,context){return visitor.visitIcu(this,context)}}class TagPlaceholder{constructor(tag,attrs,startName,closeName,children,isVoid,sourceSpan,startSourceSpan,endSourceSpan){this.tag=
tag;this.attrs=attrs;this.startName=startName;this.closeName=closeName;this.children=children;this.isVoid=isVoid;this.sourceSpan=sourceSpan;this.startSourceSpan=startSourceSpan;this.endSourceSpan=endSourceSpan}visit(visitor,context){return visitor.visitTagPlaceholder(this,context)}}class Placeholder{constructor(value,name,sourceSpan){this.value=value;this.name=name;this.sourceSpan=sourceSpan}visit(visitor,context){return visitor.visitPlaceholder(this,context)}}class IcuPlaceholder{constructor(value,
name,sourceSpan){this.value=value;this.name=name;this.sourceSpan=sourceSpan}visit(visitor,context){return visitor.visitIcuPlaceholder(this,context)}}class CloneVisitor{visitText(text,context){return new Text$2(text.value,text.sourceSpan)}visitContainer(container,context){const children=container.children.map(n=>n.visit(this,context));return new Container(children,container.sourceSpan)}visitIcu(icu,context){const cases={};Object.keys(icu.cases).forEach(key=>cases[key]=icu.cases[key].visit(this,context));
const msg=new Icu(icu.expression,icu.type,cases,icu.sourceSpan);msg.expressionPlaceholder=icu.expressionPlaceholder;return msg}visitTagPlaceholder(ph,context){const children=ph.children.map(n=>n.visit(this,context));return new TagPlaceholder(ph.tag,ph.attrs,ph.startName,ph.closeName,children,ph.isVoid,ph.sourceSpan,ph.startSourceSpan,ph.endSourceSpan)}visitPlaceholder(ph,context){return new Placeholder(ph.value,ph.name,ph.sourceSpan)}visitIcuPlaceholder(ph,context){return new IcuPlaceholder(ph.value,
ph.name,ph.sourceSpan)}}class RecurseVisitor{visitText(text,context){}visitContainer(container,context){container.children.forEach(child=>child.visit(this))}visitIcu(icu,context){Object.keys(icu.cases).forEach(k=>{icu.cases[k].visit(this)})}visitTagPlaceholder(ph,context){ph.children.forEach(child=>child.visit(this))}visitPlaceholder(ph,context){}visitIcuPlaceholder(ph,context){}}function serializeMessage(messageNodes){const visitor=new LocalizeMessageStringVisitor;const str=messageNodes.map(n=>n.visit(visitor)).join("");
return str}class LocalizeMessageStringVisitor{visitText(text){return text.value}visitContainer(container){return container.children.map(child=>child.visit(this)).join("")}visitIcu(icu){const strCases=Object.keys(icu.cases).map(k=>`${k} {${icu.cases[k].visit(this)}}`);return`{${icu.expressionPlaceholder}, ${icu.type}, ${strCases.join(" ")}}`}visitTagPlaceholder(ph){const children=ph.children.map(child=>child.visit(this)).join("");return`{$${ph.startName}}${children}{$${ph.closeName}}`}visitPlaceholder(ph){return`{$${ph.name}}`}visitIcuPlaceholder(ph){return`{$${ph.name}}`}}
class Serializer{createNameMapper(message){return null}}class SimplePlaceholderMapper extends RecurseVisitor{constructor(message,mapName){super();this.mapName=mapName;this.internalToPublic={};this.publicToNextId={};this.publicToInternal={};message.nodes.forEach(node=>node.visit(this))}toPublicName(internalName){return this.internalToPublic.hasOwnProperty(internalName)?this.internalToPublic[internalName]:null}toInternalName(publicName){return this.publicToInternal.hasOwnProperty(publicName)?this.publicToInternal[publicName]:
null}visitText(text,context){return null}visitTagPlaceholder(ph,context){this.visitPlaceholderName(ph.startName);super.visitTagPlaceholder(ph,context);this.visitPlaceholderName(ph.closeName)}visitPlaceholder(ph,context){this.visitPlaceholderName(ph.name)}visitIcuPlaceholder(ph,context){this.visitPlaceholderName(ph.name)}visitPlaceholderName(internalName){if(!internalName||this.internalToPublic.hasOwnProperty(internalName))return;let publicName=this.mapName(internalName);if(this.publicToInternal.hasOwnProperty(publicName)){const nextId=
this.publicToNextId[publicName];this.publicToNextId[publicName]=nextId+1;publicName=`${publicName}_${nextId}`}else this.publicToNextId[publicName]=1;this.internalToPublic[internalName]=publicName;this.publicToInternal[publicName]=internalName}}class _Visitor$2{visitTag(tag){const strAttrs=this._serializeAttributes(tag.attrs);if(tag.children.length==0)return`<${tag.name}${strAttrs}/>`;const strChildren=tag.children.map(node=>node.visit(this));return`<${tag.name}${strAttrs}>${strChildren.join("")}</${tag.name}>`}visitText(text){return text.value}visitDeclaration(decl){return`<?xml${this._serializeAttributes(decl.attrs)} ?>`}_serializeAttributes(attrs){const strAttrs=
Object.keys(attrs).map(name=>`${name}="${attrs[name]}"`).join(" ");return strAttrs.length>0?" "+strAttrs:""}visitDoctype(doctype){return`<!DOCTYPE ${doctype.rootTag} [\n${doctype.dtd}\n]>`}}const _visitor=new _Visitor$2;function serialize(nodes){return nodes.map(node=>node.visit(_visitor)).join("")}class Declaration{constructor(unescapedAttrs){this.attrs={};Object.keys(unescapedAttrs).forEach(k=>{this.attrs[k]=escapeXml(unescapedAttrs[k])})}visit(visitor){return visitor.visitDeclaration(this)}}class Doctype{constructor(rootTag,
dtd){this.rootTag=rootTag;this.dtd=dtd}visit(visitor){return visitor.visitDoctype(this)}}class Tag{constructor(name,unescapedAttrs={},children=[]){this.name=name;this.children=children;this.attrs={};Object.keys(unescapedAttrs).forEach(k=>{this.attrs[k]=escapeXml(unescapedAttrs[k])})}visit(visitor){return visitor.visitTag(this)}}class Text$1{constructor(unescapedValue){this.value=escapeXml(unescapedValue)}visit(visitor){return visitor.visitText(this)}}class CR extends Text$1{constructor(ws=0){super(`\n${(new Array(ws+
1)).join(" ")}`)}}const _ESCAPED_CHARS=[[/&/g,"&amp;"],[/"/g,"&quot;"],[/'/g,"&apos;"],[/</g,"&lt;"],[/>/g,"&gt;"]];function escapeXml(text){return _ESCAPED_CHARS.reduce((text,entry)=>text.replace(entry[0],entry[1]),text)}const _MESSAGES_TAG="messagebundle";const _MESSAGE_TAG="msg";const _PLACEHOLDER_TAG$3="ph";const _EXAMPLE_TAG="ex";const _SOURCE_TAG$2="source";const _DOCTYPE=`<!ELEMENT messagebundle (msg)*>
<!ATTLIST messagebundle class CDATA #IMPLIED>

<!ELEMENT msg (#PCDATA|ph|source)*>
<!ATTLIST msg id CDATA #IMPLIED>
<!ATTLIST msg seq CDATA #IMPLIED>
<!ATTLIST msg name CDATA #IMPLIED>
<!ATTLIST msg desc CDATA #IMPLIED>
<!ATTLIST msg meaning CDATA #IMPLIED>
<!ATTLIST msg obsolete (obsolete) #IMPLIED>
<!ATTLIST msg xml:space (default|preserve) "default">
<!ATTLIST msg is_hidden CDATA #IMPLIED>

<!ELEMENT source (#PCDATA)>

<!ELEMENT ph (#PCDATA|ex)*>
<!ATTLIST ph name CDATA #REQUIRED>

<!ELEMENT ex (#PCDATA)>`;class Xmb extends Serializer{write(messages,locale){const exampleVisitor=new ExampleVisitor;const visitor=new _Visitor$1;let rootNode=new Tag(_MESSAGES_TAG);messages.forEach(message=>{const attrs={id:message.id};if(message.description)attrs["desc"]=message.description;if(message.meaning)attrs["meaning"]=message.meaning;let sourceTags=[];message.sources.forEach(source=>{sourceTags.push(new Tag(_SOURCE_TAG$2,{},[new Text$1(`${source.filePath}:${source.startLine}${source.endLine!==
source.startLine?","+source.endLine:""}`)]))});rootNode.children.push(new CR(2),new Tag(_MESSAGE_TAG,attrs,[...sourceTags,...visitor.serialize(message.nodes)]))});rootNode.children.push(new CR);return serialize([new Declaration({version:"1.0",encoding:"UTF-8"}),new CR,new Doctype(_MESSAGES_TAG,_DOCTYPE),new CR,exampleVisitor.addDefaultExamples(rootNode),new CR])}load(content,url){throw new Error("Unsupported");}digest(message){return digest(message)}createNameMapper(message){return new SimplePlaceholderMapper(message,
toPublicName)}}class _Visitor$1{visitText(text,context){return[new Text$1(text.value)]}visitContainer(container,context){const nodes=[];container.children.forEach(node=>nodes.push(...node.visit(this)));return nodes}visitIcu(icu,context){const nodes=[new Text$1(`{${icu.expressionPlaceholder}, ${icu.type}, `)];Object.keys(icu.cases).forEach(c=>{nodes.push(new Text$1(`${c} {`),...icu.cases[c].visit(this),new Text$1(`} `))});nodes.push(new Text$1(`}`));return nodes}visitTagPlaceholder(ph,context){const startTagAsText=
new Text$1(`<${ph.tag}>`);const startEx=new Tag(_EXAMPLE_TAG,{},[startTagAsText]);const startTagPh=new Tag(_PLACEHOLDER_TAG$3,{name:ph.startName},[startEx,startTagAsText]);if(ph.isVoid)return[startTagPh];const closeTagAsText=new Text$1(`</${ph.tag}>`);const closeEx=new Tag(_EXAMPLE_TAG,{},[closeTagAsText]);const closeTagPh=new Tag(_PLACEHOLDER_TAG$3,{name:ph.closeName},[closeEx,closeTagAsText]);return[startTagPh,...this.serialize(ph.children),closeTagPh]}visitPlaceholder(ph,context){const interpolationAsText=
new Text$1(`{{${ph.value}}}`);const exTag=new Tag(_EXAMPLE_TAG,{},[interpolationAsText]);return[new Tag(_PLACEHOLDER_TAG$3,{name:ph.name},[exTag,interpolationAsText])]}visitIcuPlaceholder(ph,context){const icuExpression=ph.value.expression;const icuType=ph.value.type;const icuCases=Object.keys(ph.value.cases).map(value=>value+" {...}").join(" ");const icuAsText=new Text$1(`{${icuExpression}, ${icuType}, ${icuCases}}`);const exTag=new Tag(_EXAMPLE_TAG,{},[icuAsText]);return[new Tag(_PLACEHOLDER_TAG$3,
{name:ph.name},[exTag,icuAsText])]}serialize(nodes){return[].concat(...nodes.map(node=>node.visit(this)))}}function digest(message){return decimalDigest(message)}class ExampleVisitor{addDefaultExamples(node){node.visit(this);return node}visitTag(tag){if(tag.name===_PLACEHOLDER_TAG$3){if(!tag.children||tag.children.length==0){const exText=new Text$1(tag.attrs["name"]||"...");tag.children=[new Tag(_EXAMPLE_TAG,{},[exText])]}}else if(tag.children)tag.children.forEach(node=>node.visit(this))}visitText(text){}visitDeclaration(decl){}visitDoctype(doctype){}}
function toPublicName(internalName){return internalName.toUpperCase().replace(/[^A-Z0-9_]/g,"_")}const CLOSURE_TRANSLATION_VAR_PREFIX="MSG_";const TRANSLATION_VAR_PREFIX="i18n_";const I18N_ATTR="i18n";const I18N_ATTR_PREFIX="i18n-";const I18N_ICU_VAR_PREFIX="VAR_";const I18N_ICU_MAPPING_PREFIX="I18N_EXP_";const I18N_PLACEHOLDER_SYMBOL="�";function isI18nAttribute(name){return name===I18N_ATTR||name.startsWith(I18N_ATTR_PREFIX)}function isI18nRootNode(meta){return meta instanceof Message}function isSingleI18nIcu(meta){return isI18nRootNode(meta)&&
meta.nodes.length===1&&meta.nodes[0]instanceof Icu}function hasI18nMeta(node){return!!node.i18n}function hasI18nAttrs(element){return element.attrs.some(attr=>isI18nAttribute(attr.name))}function icuFromI18nMessage(message){return message.nodes[0]}function wrapI18nPlaceholder(content,contextId=0){const blockId=contextId>0?`:${contextId}`:"";return`${I18N_PLACEHOLDER_SYMBOL}${content}${blockId}${I18N_PLACEHOLDER_SYMBOL}`}function assembleI18nBoundString(strings,bindingStartIndex=0,contextId=0){if(!strings.length)return"";
let acc="";const lastIdx=strings.length-1;for(let i=0;i<lastIdx;i++)acc+=`${strings[i]}${wrapI18nPlaceholder(bindingStartIndex+i,contextId)}`;acc+=strings[lastIdx];return acc}function getSeqNumberGenerator(startsAt=0){let current=startsAt;return()=>current++}function placeholdersToParams(placeholders){const params={};placeholders.forEach((values,key)=>{params[key]=literal(values.length>1?`[${values.join("|")}]`:values[0])});return params}function updatePlaceholderMap(map,name,...values){const current=
map.get(name)||[];current.push(...values);map.set(name,current)}function assembleBoundTextPlaceholders(meta,bindingStartIndex=0,contextId=0){const startIdx=bindingStartIndex;const placeholders=new Map;const node=meta instanceof Message?meta.nodes.find(node=>node instanceof Container):meta;if(node)node.children.filter(child=>child instanceof Placeholder).forEach((child,idx)=>{const content=wrapI18nPlaceholder(startIdx+idx,contextId);updatePlaceholderMap(placeholders,child.name,content)});return placeholders}
function i18nFormatPlaceholderNames(params={},useCamelCase){const _params={};if(params&&Object.keys(params).length)Object.keys(params).forEach(key=>_params[formatI18nPlaceholderName(key,useCamelCase)]=params[key]);return _params}function formatI18nPlaceholderName(name,useCamelCase=true){const publicName=toPublicName(name);if(!useCamelCase)return publicName;const chunks=publicName.split("_");if(chunks.length===1)return name.toLowerCase();let postfix;if(/^\d+$/.test(chunks[chunks.length-1]))postfix=
chunks.pop();let raw=chunks.shift().toLowerCase();if(chunks.length)raw+=chunks.map(c=>c.charAt(0).toUpperCase()+c.slice(1).toLowerCase()).join("");return postfix?`${raw}_${postfix}`:raw}function getTranslationConstPrefix(extra){return`${CLOSURE_TRANSLATION_VAR_PREFIX}${extra}`.toUpperCase()}function declareI18nVariable(variable){return new DeclareVarStmt(variable.name,undefined,INFERRED_TYPE,undefined,variable.sourceSpan)}const UNSAFE_OBJECT_KEY_NAME_REGEXP=/[-.]/;const TEMPORARY_NAME="_t";const CONTEXT_NAME=
"ctx";const RENDER_FLAGS="rf";const REFERENCE_PREFIX="_r";const IMPLICIT_REFERENCE="$implicit";const NON_BINDABLE_ATTR="ngNonBindable";const RESTORED_VIEW_CONTEXT_NAME="restoredCtx";function temporaryAllocator(statements,name){let temp=null;return()=>{if(!temp){statements.push(new DeclareVarStmt(TEMPORARY_NAME,undefined,DYNAMIC_TYPE));temp=variable(name)}return temp}}function invalid(arg){throw new Error(`Invalid state: Visitor ${this.constructor.name} doesn't handle ${arg.constructor.name}`);}function asLiteral(value){if(Array.isArray(value))return literalArr(value.map(asLiteral));
return literal(value,INFERRED_TYPE)}function conditionallyCreateMapObjectLiteral(keys,keepDeclared){if(Object.getOwnPropertyNames(keys).length>0)return mapToExpression(keys,keepDeclared);return null}function mapToExpression(map,keepDeclared){return literalMap(Object.getOwnPropertyNames(map).map(key=>{const value=map[key];let declaredName;let publicName;let minifiedName;let needsDeclaredName;if(Array.isArray(value)){[publicName,declaredName]=value;minifiedName=key;needsDeclaredName=publicName!==declaredName}else{[declaredName,
publicName]=splitAtColon(key,[key,value]);minifiedName=declaredName;needsDeclaredName=publicName!==declaredName&&key.includes(":")}return{key:minifiedName,quoted:UNSAFE_OBJECT_KEY_NAME_REGEXP.test(minifiedName),value:keepDeclared&&needsDeclaredName?literalArr([asLiteral(publicName),asLiteral(declaredName)]):asLiteral(publicName)}}))}function trimTrailingNulls(parameters){while(isNull(parameters[parameters.length-1]))parameters.pop();return parameters}function getQueryPredicate(query,constantPool){if(Array.isArray(query.predicate)){let predicate=
[];query.predicate.forEach(selector=>{const selectors=selector.split(",").map(token=>literal(token.trim()));predicate.push(...selectors)});return constantPool.getConstLiteral(literalArr(predicate),true)}else switch(query.predicate.forwardRef){case 0:case 2:return query.predicate.expression;case 1:return importExpr(Identifiers$1.resolveForwardRef).callFn([query.predicate.expression])}}class DefinitionMap{constructor(){this.values=[]}set(key,value){if(value)this.values.push({key:key,value,quoted:false})}toLiteralMap(){return literalMap(this.values)}}
function getAttrsForDirectiveMatching(elOrTpl){const attributesMap={};if(elOrTpl instanceof Template&&elOrTpl.tagName!=="ng-template")elOrTpl.templateAttrs.forEach(a=>attributesMap[a.name]="");else{elOrTpl.attributes.forEach(a=>{if(!isI18nAttribute(a.name))attributesMap[a.name]=a.value});elOrTpl.inputs.forEach(i=>{attributesMap[i.name]=""});elOrTpl.outputs.forEach(o=>{attributesMap[o.name]=""})}return attributesMap}function chainedInstruction(reference,calls,span){let expression=importExpr(reference,
null,span);if(calls.length>0)for(let i=0;i<calls.length;i++)expression=expression.callFn(calls[i],span);else expression=expression.callFn([],span);return expression}function getInterpolationArgsLength(interpolation){const {expressions,strings}=interpolation;if(expressions.length===1&&strings.length===2&&strings[0]===""&&strings[1]==="")return 1;else return expressions.length+strings.length}function compileInjectable(meta,resolveForwardRefs){let result=null;const factoryMeta={name:meta.name,type:meta.type,
internalType:meta.internalType,typeArgumentCount:meta.typeArgumentCount,deps:[],target:exports.FactoryTarget.Injectable};if(meta.useClass!==undefined){const useClassOnSelf=meta.useClass.expression.isEquivalent(meta.internalType);let deps=undefined;if(meta.deps!==undefined)deps=meta.deps;if(deps!==undefined)result=compileFactoryFunction(Object.assign(Object.assign({},factoryMeta),{delegate:meta.useClass.expression,delegateDeps:deps,delegateType:R3FactoryDelegateType.Class}));else if(useClassOnSelf)result=
compileFactoryFunction(factoryMeta);else result={statements:[],expression:delegateToFactory(meta.type.value,meta.useClass.expression,resolveForwardRefs)}}else if(meta.useFactory!==undefined)if(meta.deps!==undefined)result=compileFactoryFunction(Object.assign(Object.assign({},factoryMeta),{delegate:meta.useFactory,delegateDeps:meta.deps||[],delegateType:R3FactoryDelegateType.Function}));else result={statements:[],expression:fn([],[new ReturnStatement(meta.useFactory.callFn([]))])};else if(meta.useValue!==
undefined)result=compileFactoryFunction(Object.assign(Object.assign({},factoryMeta),{expression:meta.useValue.expression}));else if(meta.useExisting!==undefined)result=compileFactoryFunction(Object.assign(Object.assign({},factoryMeta),{expression:importExpr(Identifiers$1.inject).callFn([meta.useExisting.expression])}));else result={statements:[],expression:delegateToFactory(meta.type.value,meta.internalType,resolveForwardRefs)};const token=meta.internalType;const injectableProps=new DefinitionMap;
injectableProps.set("token",token);injectableProps.set("factory",result.expression);if(meta.providedIn.expression.value!==null)injectableProps.set("providedIn",convertFromMaybeForwardRefExpression(meta.providedIn));const expression=importExpr(Identifiers$1.\u0275\u0275defineInjectable).callFn([injectableProps.toLiteralMap()],undefined,true);return{expression,type:createInjectableType(meta),statements:result.statements}}function createInjectableType(meta){return new ExpressionType(importExpr(Identifiers$1.InjectableDeclaration,
[typeWithParameters(meta.type.type,meta.typeArgumentCount)]))}function delegateToFactory(type,internalType,unwrapForwardRefs){if(type.node===internalType.node)return internalType.prop("ɵfac");if(!unwrapForwardRefs)return createFactoryFunction(internalType);const unwrappedType=importExpr(Identifiers$1.resolveForwardRef).callFn([internalType]);return createFactoryFunction(unwrappedType)}function createFactoryFunction(type){return fn([new FnParam("t",DYNAMIC_TYPE)],[new ReturnStatement(type.prop("ɵfac").callFn([variable("t")]))])}
const UNUSABLE_INTERPOLATION_REGEXPS=[/^\s*$/,/[<>]/,/^[{}]$/,/&(#|[a-z])/i,/^\/\//];function assertInterpolationSymbols(identifier,value){if(value!=null&&!(Array.isArray(value)&&value.length==2))throw new Error(`Expected '${identifier}' to be an array, [start, end].`);else if(value!=null){const start=value[0];const end=value[1];UNUSABLE_INTERPOLATION_REGEXPS.forEach(regexp=>{if(regexp.test(start)||regexp.test(end))throw new Error(`['${start}', '${end}'] contains unusable interpolation symbol.`);
})}}class InterpolationConfig{constructor(start,end){this.start=start;this.end=end}static fromArray(markers){if(!markers)return DEFAULT_INTERPOLATION_CONFIG;assertInterpolationSymbols("interpolation",markers);return new InterpolationConfig(markers[0],markers[1])}}const DEFAULT_INTERPOLATION_CONFIG=new InterpolationConfig("{{","}}");const $EOF=0;const $BSPACE=8;const $TAB=9;const $LF=10;const $VTAB=11;const $FF=12;const $CR=13;const $SPACE=32;const $BANG=33;const $DQ=34;const $HASH=35;const $$=36;
const $PERCENT=37;const $AMPERSAND=38;const $SQ=39;const $LPAREN=40;const $RPAREN=41;const $STAR=42;const $PLUS=43;const $COMMA=44;const $MINUS=45;const $PERIOD=46;const $SLASH=47;const $COLON=58;const $SEMICOLON=59;const $LT=60;const $EQ=61;const $GT=62;const $QUESTION=63;const $0=48;const $7=55;const $9=57;const $A=65;const $E=69;const $F=70;const $X=88;const $Z=90;const $LBRACKET=91;const $BACKSLASH=92;const $RBRACKET=93;const $CARET=94;const $_=95;const $a=97;const $b=98;const $e=101;const $f=
102;const $n=110;const $r=114;const $t=116;const $u=117;const $v=118;const $x=120;const $z=122;const $LBRACE=123;const $BAR=124;const $RBRACE=125;const $NBSP=160;const $BT=96;function isWhitespace(code){return code>=$TAB&&code<=$SPACE||code==$NBSP}function isDigit(code){return $0<=code&&code<=$9}function isAsciiLetter(code){return code>=$a&&code<=$z||code>=$A&&code<=$Z}function isAsciiHexDigit(code){return code>=$a&&code<=$f||code>=$A&&code<=$F||isDigit(code)}function isNewLine(code){return code===
$LF||code===$CR}function isOctalDigit(code){return $0<=code&&code<=$7}function isQuote(code){return code===$SQ||code===$DQ||code===$BT}class ParseLocation{constructor(file,offset,line,col){this.file=file;this.offset=offset;this.line=line;this.col=col}toString(){return this.offset!=null?`${this.file.url}@${this.line}:${this.col}`:this.file.url}moveBy(delta){const source=this.file.content;const len=source.length;let offset=this.offset;let line=this.line;let col=this.col;while(offset>0&&delta<0){offset--;
delta++;const ch=source.charCodeAt(offset);if(ch==$LF){line--;const priorLine=source.substr(0,offset-1).lastIndexOf(String.fromCharCode($LF));col=priorLine>0?offset-priorLine:offset}else col--}while(offset<len&&delta>0){const ch=source.charCodeAt(offset);offset++;delta--;if(ch==$LF){line++;col=0}else col++}return new ParseLocation(this.file,offset,line,col)}getContext(maxChars,maxLines){const content=this.file.content;let startOffset=this.offset;if(startOffset!=null){if(startOffset>content.length-
1)startOffset=content.length-1;let endOffset=startOffset;let ctxChars=0;let ctxLines=0;while(ctxChars<maxChars&&startOffset>0){startOffset--;ctxChars++;if(content[startOffset]=="\n")if(++ctxLines==maxLines)break}ctxChars=0;ctxLines=0;while(ctxChars<maxChars&&endOffset<content.length-1){endOffset++;ctxChars++;if(content[endOffset]=="\n")if(++ctxLines==maxLines)break}return{before:content.substring(startOffset,this.offset),after:content.substring(this.offset,endOffset+1)}}return null}}class ParseSourceFile{constructor(content,
url){this.content=content;this.url=url}}class ParseSourceSpan{constructor(start,end,fullStart=start,details=null){this.start=start;this.end=end;this.fullStart=fullStart;this.details=details}toString(){return this.start.file.content.substring(this.start.offset,this.end.offset)}}exports.ParseErrorLevel=void 0;(function(ParseErrorLevel){ParseErrorLevel[ParseErrorLevel["WARNING"]=0]="WARNING";ParseErrorLevel[ParseErrorLevel["ERROR"]=1]="ERROR"})(exports.ParseErrorLevel||(exports.ParseErrorLevel={}));
class ParseError{constructor(span,msg,level=exports.ParseErrorLevel.ERROR){this.span=span;this.msg=msg;this.level=level}contextualMessage(){const ctx=this.span.start.getContext(100,3);return ctx?`${this.msg} ("${ctx.before}[${exports.ParseErrorLevel[this.level]} ->]${ctx.after}")`:this.msg}toString(){const details=this.span.details?`, ${this.span.details}`:"";return`${this.contextualMessage()}: ${this.span.start}${details}`}}function r3JitTypeSourceSpan(kind,typeName,sourceUrl){const sourceFileName=
`in ${kind} ${typeName} in ${sourceUrl}`;const sourceFile=new ParseSourceFile("",sourceFileName);return new ParseSourceSpan(new ParseLocation(sourceFile,-1,-1,-1),new ParseLocation(sourceFile,-1,-1,-1))}let _anonymousTypeIndex=0;function identifierName(compileIdentifier){if(!compileIdentifier||!compileIdentifier.reference)return null;const ref=compileIdentifier.reference;if(ref["__anonymousType"])return ref["__anonymousType"];if(ref["__forward_ref__"])return"__forward_ref__";let identifier=stringify(ref);
if(identifier.indexOf("(")>=0){identifier=`anonymous_${_anonymousTypeIndex++}`;ref["__anonymousType"]=identifier}else identifier=sanitizeIdentifier(identifier);return identifier}function sanitizeIdentifier(name){return name.replace(/\W/g,"_")}const makeTemplateObjectPolyfill='(this&&this.__makeTemplateObject||function(e,t){return Object.defineProperty?Object.defineProperty(e,"raw",{value:t}):e.raw=t,e})';class AbstractJsEmitterVisitor extends AbstractEmitterVisitor{constructor(){super(false)}visitWrappedNodeExpr(ast,
ctx){throw new Error("Cannot emit a WrappedNodeExpr in Javascript.");}visitDeclareVarStmt(stmt,ctx){ctx.print(stmt,`var ${stmt.name}`);if(stmt.value){ctx.print(stmt," = ");stmt.value.visitExpression(this,ctx)}ctx.println(stmt,`;`);return null}visitTaggedTemplateExpr(ast,ctx){const elements=ast.template.elements;ast.tag.visitExpression(this,ctx);ctx.print(ast,`(${makeTemplateObjectPolyfill}(`);ctx.print(ast,`[${elements.map(part=>escapeIdentifier(part.text,false)).join(", ")}], `);ctx.print(ast,`[${elements.map(part=>
escapeIdentifier(part.rawText,false)).join(", ")}])`);ast.template.expressions.forEach(expression=>{ctx.print(ast,", ");expression.visitExpression(this,ctx)});ctx.print(ast,")");return null}visitFunctionExpr(ast,ctx){ctx.print(ast,`function${ast.name?" "+ast.name:""}(`);this._visitParams(ast.params,ctx);ctx.println(ast,`) {`);ctx.incIndent();this.visitAllStatements(ast.statements,ctx);ctx.decIndent();ctx.print(ast,`}`);return null}visitDeclareFunctionStmt(stmt,ctx){ctx.print(stmt,`function ${stmt.name}(`);
this._visitParams(stmt.params,ctx);ctx.println(stmt,`) {`);ctx.incIndent();this.visitAllStatements(stmt.statements,ctx);ctx.decIndent();ctx.println(stmt,`}`);return null}visitLocalizedString(ast,ctx){ctx.print(ast,`$localize(${makeTemplateObjectPolyfill}(`);const parts=[ast.serializeI18nHead()];for(let i=1;i<ast.messageParts.length;i++)parts.push(ast.serializeI18nTemplatePart(i));ctx.print(ast,`[${parts.map(part=>escapeIdentifier(part.cooked,false)).join(", ")}], `);ctx.print(ast,`[${parts.map(part=>
escapeIdentifier(part.raw,false)).join(", ")}])`);ast.expressions.forEach(expression=>{ctx.print(ast,", ");expression.visitExpression(this,ctx)});ctx.print(ast,")");return null}_visitParams(params,ctx){this.visitAllObjects(param=>ctx.print(null,param.name),params,ctx,",")}}let policy;function getPolicy(){if(policy===undefined){policy=null;if(_global.trustedTypes)try{policy=_global.trustedTypes.createPolicy("angular#unsafe-jit",{createScript:s=>s})}catch(_a){}}return policy}function trustedScriptFromString(script){var _a;
return((_a=getPolicy())===null||_a===void 0?void 0:_a.createScript(script))||script}function newTrustedFunctionForJIT(...args){if(!_global.trustedTypes)return new Function(...args);const fnArgs=args.slice(0,-1).join(",");const fnBody=args[args.length-1];const body=`(function anonymous(${fnArgs}
) { ${fnBody}
})`;const fn=_global["eval"](trustedScriptFromString(body));if(fn.bind===undefined)return new Function(...args);fn.toString=()=>body;return fn.bind(_global)}class JitEvaluator{evaluateStatements(sourceUrl,statements,refResolver,createSourceMaps){const converter=new JitEmitterVisitor(refResolver);const ctx=EmitterVisitorContext.createRoot();if(statements.length>0&&!isUseStrictStatement(statements[0]))statements=[literal("use strict").toStmt(),...statements];converter.visitAllStatements(statements,
ctx);converter.createReturnStmt(ctx);return this.evaluateCode(sourceUrl,ctx,converter.getArgs(),createSourceMaps)}evaluateCode(sourceUrl,ctx,vars,createSourceMap){let fnBody=`"use strict";${ctx.toSource()}\n//# sourceURL=${sourceUrl}`;const fnArgNames=[];const fnArgValues=[];for(const argName in vars){fnArgValues.push(vars[argName]);fnArgNames.push(argName)}if(createSourceMap){const emptyFn=newTrustedFunctionForJIT(...fnArgNames.concat("return null;")).toString();const headerLines=emptyFn.slice(0,
emptyFn.indexOf("return null;")).split("\n").length-1;fnBody+=`\n${ctx.toSourceMapGenerator(sourceUrl,headerLines).toJsComment()}`}const fn=newTrustedFunctionForJIT(...fnArgNames.concat(fnBody));return this.executeFunction(fn,fnArgValues)}executeFunction(fn,args){return fn(...args)}}class JitEmitterVisitor extends AbstractJsEmitterVisitor{constructor(refResolver){super();this.refResolver=refResolver;this._evalArgNames=[];this._evalArgValues=[];this._evalExportedVars=[]}createReturnStmt(ctx){const stmt=
new ReturnStatement(new LiteralMapExpr(this._evalExportedVars.map(resultVar=>new LiteralMapEntry(resultVar,variable(resultVar),false))));stmt.visitStatement(this,ctx)}getArgs(){const result={};for(let i=0;i<this._evalArgNames.length;i++)result[this._evalArgNames[i]]=this._evalArgValues[i];return result}visitExternalExpr(ast,ctx){this._emitReferenceToExternal(ast,this.refResolver.resolveExternalReference(ast.value),ctx);return null}visitWrappedNodeExpr(ast,ctx){this._emitReferenceToExternal(ast,ast.node,
ctx);return null}visitDeclareVarStmt(stmt,ctx){if(stmt.hasModifier(exports.StmtModifier.Exported))this._evalExportedVars.push(stmt.name);return super.visitDeclareVarStmt(stmt,ctx)}visitDeclareFunctionStmt(stmt,ctx){if(stmt.hasModifier(exports.StmtModifier.Exported))this._evalExportedVars.push(stmt.name);return super.visitDeclareFunctionStmt(stmt,ctx)}_emitReferenceToExternal(ast,value,ctx){let id=this._evalArgValues.indexOf(value);if(id===-1){id=this._evalArgValues.length;this._evalArgValues.push(value);
const name=identifierName({reference:value})||"val";this._evalArgNames.push(`jit_${name}_${id}`)}ctx.print(ast,this._evalArgNames[id])}}function isUseStrictStatement(statement){return statement.isEquivalent(literal("use strict").toStmt())}function compileInjector(meta){const definitionMap=new DefinitionMap;if(meta.providers!==null)definitionMap.set("providers",meta.providers);if(meta.imports.length>0)definitionMap.set("imports",literalArr(meta.imports));const expression=importExpr(Identifiers$1.defineInjector).callFn([definitionMap.toLiteralMap()],
undefined,true);const type=createInjectorType(meta);return{expression,type,statements:[]}}function createInjectorType(meta){return new ExpressionType(importExpr(Identifiers$1.InjectorDeclaration,[new ExpressionType(meta.type.type)]))}class R3JitReflector{constructor(context){this.context=context}resolveExternalReference(ref){if(ref.moduleName!=="@angular/core")throw new Error(`Cannot resolve external reference to ${ref.moduleName}, only references to @angular/core are supported.`);if(!this.context.hasOwnProperty(ref.name))throw new Error(`No value provided for @angular/core symbol '${ref.name}'.`);
return this.context[ref.name]}}function compileNgModule(meta){const {internalType,bootstrap,declarations,imports,exports,schemas,containsForwardDecls,emitInline,id}=meta;const statements=[];const definitionMap=new DefinitionMap;definitionMap.set("type",internalType);if(bootstrap.length>0)definitionMap.set("bootstrap",refsToArray(bootstrap,containsForwardDecls));if(emitInline){if(declarations.length>0)definitionMap.set("declarations",refsToArray(declarations,containsForwardDecls));if(imports.length>
0)definitionMap.set("imports",refsToArray(imports,containsForwardDecls));if(exports.length>0)definitionMap.set("exports",refsToArray(exports,containsForwardDecls))}else{const setNgModuleScopeCall=generateSetNgModuleScopeCall(meta);if(setNgModuleScopeCall!==null)statements.push(setNgModuleScopeCall)}if(schemas!==null&&schemas.length>0)definitionMap.set("schemas",literalArr(schemas.map(ref=>ref.value)));if(id!==null)definitionMap.set("id",id);const expression=importExpr(Identifiers$1.defineNgModule).callFn([definitionMap.toLiteralMap()],
undefined,true);const type=createNgModuleType(meta);return{expression,type,statements}}function compileNgModuleDeclarationExpression(meta){const definitionMap=new DefinitionMap;definitionMap.set("type",new WrappedNodeExpr(meta.type));if(meta.bootstrap!==undefined)definitionMap.set("bootstrap",new WrappedNodeExpr(meta.bootstrap));if(meta.declarations!==undefined)definitionMap.set("declarations",new WrappedNodeExpr(meta.declarations));if(meta.imports!==undefined)definitionMap.set("imports",new WrappedNodeExpr(meta.imports));
if(meta.exports!==undefined)definitionMap.set("exports",new WrappedNodeExpr(meta.exports));if(meta.schemas!==undefined)definitionMap.set("schemas",new WrappedNodeExpr(meta.schemas));if(meta.id!==undefined)definitionMap.set("id",new WrappedNodeExpr(meta.id));return importExpr(Identifiers$1.defineNgModule).callFn([definitionMap.toLiteralMap()])}function createNgModuleType({type:moduleType,declarations,imports,exports}){return new ExpressionType(importExpr(Identifiers$1.NgModuleDeclaration,[new ExpressionType(moduleType.type),
tupleTypeOf(declarations),tupleTypeOf(imports),tupleTypeOf(exports)]))}function generateSetNgModuleScopeCall(meta){const {adjacentType:moduleType,declarations,imports,exports,containsForwardDecls}=meta;const scopeMap=new DefinitionMap;if(declarations.length>0)scopeMap.set("declarations",refsToArray(declarations,containsForwardDecls));if(imports.length>0)scopeMap.set("imports",refsToArray(imports,containsForwardDecls));if(exports.length>0)scopeMap.set("exports",refsToArray(exports,containsForwardDecls));
if(Object.keys(scopeMap.values).length===0)return null;const fnCall=new InvokeFunctionExpr(importExpr(Identifiers$1.setNgModuleScope),[moduleType,scopeMap.toLiteralMap()]);const guardedCall=jitOnlyGuardedExpression(fnCall);const iife=new FunctionExpr([],[guardedCall.toStmt()]);const iifeCall=new InvokeFunctionExpr(iife,[]);return iifeCall.toStmt()}function tupleTypeOf(exp){const types=exp.map(ref=>typeofExpr(ref.type));return exp.length>0?expressionType(literalArr(types)):NONE_TYPE}function compilePipeFromMetadata(metadata){const definitionMapValues=
[];definitionMapValues.push({key:"name",value:literal(metadata.pipeName),quoted:false});definitionMapValues.push({key:"type",value:metadata.type.value,quoted:false});definitionMapValues.push({key:"pure",value:literal(metadata.pure),quoted:false});const expression=importExpr(Identifiers$1.definePipe).callFn([literalMap(definitionMapValues)],undefined,true);const type=createPipeType(metadata);return{expression,type,statements:[]}}function createPipeType(metadata){return new ExpressionType(importExpr(Identifiers$1.PipeDeclaration,
[typeWithParameters(metadata.type.type,metadata.typeArgumentCount),new ExpressionType(new LiteralExpr(metadata.pipeName))]))}class ParserError{constructor(message,input,errLocation,ctxLocation){this.input=input;this.errLocation=errLocation;this.ctxLocation=ctxLocation;this.message=`Parser Error: ${message} ${errLocation} [${input}] in ${ctxLocation}`}}class ParseSpan{constructor(start,end){this.start=start;this.end=end}toAbsolute(absoluteOffset){return new AbsoluteSourceSpan(absoluteOffset+this.start,
absoluteOffset+this.end)}}class AST{constructor(span,sourceSpan){this.span=span;this.sourceSpan=sourceSpan}toString(){return"AST"}}class ASTWithName extends AST{constructor(span,sourceSpan,nameSpan){super(span,sourceSpan);this.nameSpan=nameSpan}}class Quote extends AST{constructor(span,sourceSpan,prefix,uninterpretedExpression,location){super(span,sourceSpan);this.prefix=prefix;this.uninterpretedExpression=uninterpretedExpression;this.location=location}visit(visitor,context=null){return visitor.visitQuote(this,
context)}toString(){return"Quote"}}class EmptyExpr extends AST{visit(visitor,context=null){}}class ImplicitReceiver extends AST{visit(visitor,context=null){return visitor.visitImplicitReceiver(this,context)}}class ThisReceiver extends ImplicitReceiver{visit(visitor,context=null){var _a;return(_a=visitor.visitThisReceiver)===null||_a===void 0?void 0:_a.call(visitor,this,context)}}class Chain extends AST{constructor(span,sourceSpan,expressions){super(span,sourceSpan);this.expressions=expressions}visit(visitor,
context=null){return visitor.visitChain(this,context)}}class Conditional extends AST{constructor(span,sourceSpan,condition,trueExp,falseExp){super(span,sourceSpan);this.condition=condition;this.trueExp=trueExp;this.falseExp=falseExp}visit(visitor,context=null){return visitor.visitConditional(this,context)}}class PropertyRead extends ASTWithName{constructor(span,sourceSpan,nameSpan,receiver,name){super(span,sourceSpan,nameSpan);this.receiver=receiver;this.name=name}visit(visitor,context=null){return visitor.visitPropertyRead(this,
context)}}class PropertyWrite extends ASTWithName{constructor(span,sourceSpan,nameSpan,receiver,name,value){super(span,sourceSpan,nameSpan);this.receiver=receiver;this.name=name;this.value=value}visit(visitor,context=null){return visitor.visitPropertyWrite(this,context)}}class SafePropertyRead extends ASTWithName{constructor(span,sourceSpan,nameSpan,receiver,name){super(span,sourceSpan,nameSpan);this.receiver=receiver;this.name=name}visit(visitor,context=null){return visitor.visitSafePropertyRead(this,
context)}}class KeyedRead extends AST{constructor(span,sourceSpan,receiver,key){super(span,sourceSpan);this.receiver=receiver;this.key=key}visit(visitor,context=null){return visitor.visitKeyedRead(this,context)}}class SafeKeyedRead extends AST{constructor(span,sourceSpan,receiver,key){super(span,sourceSpan);this.receiver=receiver;this.key=key}visit(visitor,context=null){return visitor.visitSafeKeyedRead(this,context)}}class KeyedWrite extends AST{constructor(span,sourceSpan,receiver,key,value){super(span,
sourceSpan);this.receiver=receiver;this.key=key;this.value=value}visit(visitor,context=null){return visitor.visitKeyedWrite(this,context)}}class BindingPipe extends ASTWithName{constructor(span,sourceSpan,exp,name,args,nameSpan){super(span,sourceSpan,nameSpan);this.exp=exp;this.name=name;this.args=args}visit(visitor,context=null){return visitor.visitPipe(this,context)}}class LiteralPrimitive extends AST{constructor(span,sourceSpan,value){super(span,sourceSpan);this.value=value}visit(visitor,context=
null){return visitor.visitLiteralPrimitive(this,context)}}class LiteralArray extends AST{constructor(span,sourceSpan,expressions){super(span,sourceSpan);this.expressions=expressions}visit(visitor,context=null){return visitor.visitLiteralArray(this,context)}}class LiteralMap extends AST{constructor(span,sourceSpan,keys,values){super(span,sourceSpan);this.keys=keys;this.values=values}visit(visitor,context=null){return visitor.visitLiteralMap(this,context)}}class Interpolation extends AST{constructor(span,
sourceSpan,strings,expressions){super(span,sourceSpan);this.strings=strings;this.expressions=expressions}visit(visitor,context=null){return visitor.visitInterpolation(this,context)}}class Binary extends AST{constructor(span,sourceSpan,operation,left,right){super(span,sourceSpan);this.operation=operation;this.left=left;this.right=right}visit(visitor,context=null){return visitor.visitBinary(this,context)}}class Unary extends Binary{constructor(span,sourceSpan,operator,expr,binaryOp,binaryLeft,binaryRight){super(span,
sourceSpan,binaryOp,binaryLeft,binaryRight);this.operator=operator;this.expr=expr;this.left=null;this.right=null;this.operation=null}static createMinus(span,sourceSpan,expr){return new Unary(span,sourceSpan,"-",expr,"-",new LiteralPrimitive(span,sourceSpan,0),expr)}static createPlus(span,sourceSpan,expr){return new Unary(span,sourceSpan,"+",expr,"-",expr,new LiteralPrimitive(span,sourceSpan,0))}visit(visitor,context=null){if(visitor.visitUnary!==undefined)return visitor.visitUnary(this,context);return visitor.visitBinary(this,
context)}}class PrefixNot extends AST{constructor(span,sourceSpan,expression){super(span,sourceSpan);this.expression=expression}visit(visitor,context=null){return visitor.visitPrefixNot(this,context)}}class NonNullAssert extends AST{constructor(span,sourceSpan,expression){super(span,sourceSpan);this.expression=expression}visit(visitor,context=null){return visitor.visitNonNullAssert(this,context)}}class Call extends AST{constructor(span,sourceSpan,receiver,args,argumentSpan){super(span,sourceSpan);
this.receiver=receiver;this.args=args;this.argumentSpan=argumentSpan}visit(visitor,context=null){return visitor.visitCall(this,context)}}class AbsoluteSourceSpan{constructor(start,end){this.start=start;this.end=end}}class ASTWithSource extends AST{constructor(ast,source,location,absoluteOffset,errors){super(new ParseSpan(0,source===null?0:source.length),new AbsoluteSourceSpan(absoluteOffset,source===null?absoluteOffset:absoluteOffset+source.length));this.ast=ast;this.source=source;this.location=location;
this.errors=errors}visit(visitor,context=null){if(visitor.visitASTWithSource)return visitor.visitASTWithSource(this,context);return this.ast.visit(visitor,context)}toString(){return`${this.source} in ${this.location}`}}class VariableBinding{constructor(sourceSpan,key,value){this.sourceSpan=sourceSpan;this.key=key;this.value=value}}class ExpressionBinding{constructor(sourceSpan,key,value){this.sourceSpan=sourceSpan;this.key=key;this.value=value}}class RecursiveAstVisitor{visit(ast,context){ast.visit(this,
context)}visitUnary(ast,context){this.visit(ast.expr,context)}visitBinary(ast,context){this.visit(ast.left,context);this.visit(ast.right,context)}visitChain(ast,context){this.visitAll(ast.expressions,context)}visitConditional(ast,context){this.visit(ast.condition,context);this.visit(ast.trueExp,context);this.visit(ast.falseExp,context)}visitPipe(ast,context){this.visit(ast.exp,context);this.visitAll(ast.args,context)}visitImplicitReceiver(ast,context){}visitThisReceiver(ast,context){}visitInterpolation(ast,
context){this.visitAll(ast.expressions,context)}visitKeyedRead(ast,context){this.visit(ast.receiver,context);this.visit(ast.key,context)}visitKeyedWrite(ast,context){this.visit(ast.receiver,context);this.visit(ast.key,context);this.visit(ast.value,context)}visitLiteralArray(ast,context){this.visitAll(ast.expressions,context)}visitLiteralMap(ast,context){this.visitAll(ast.values,context)}visitLiteralPrimitive(ast,context){}visitPrefixNot(ast,context){this.visit(ast.expression,context)}visitNonNullAssert(ast,
context){this.visit(ast.expression,context)}visitPropertyRead(ast,context){this.visit(ast.receiver,context)}visitPropertyWrite(ast,context){this.visit(ast.receiver,context);this.visit(ast.value,context)}visitSafePropertyRead(ast,context){this.visit(ast.receiver,context)}visitSafeKeyedRead(ast,context){this.visit(ast.receiver,context);this.visit(ast.key,context)}visitCall(ast,context){this.visit(ast.receiver,context);this.visitAll(ast.args,context)}visitQuote(ast,context){}visitAll(asts,context){for(const ast of asts)this.visit(ast,
context)}}class AstTransformer{visitImplicitReceiver(ast,context){return ast}visitThisReceiver(ast,context){return ast}visitInterpolation(ast,context){return new Interpolation(ast.span,ast.sourceSpan,ast.strings,this.visitAll(ast.expressions))}visitLiteralPrimitive(ast,context){return new LiteralPrimitive(ast.span,ast.sourceSpan,ast.value)}visitPropertyRead(ast,context){return new PropertyRead(ast.span,ast.sourceSpan,ast.nameSpan,ast.receiver.visit(this),ast.name)}visitPropertyWrite(ast,context){return new PropertyWrite(ast.span,
ast.sourceSpan,ast.nameSpan,ast.receiver.visit(this),ast.name,ast.value.visit(this))}visitSafePropertyRead(ast,context){return new SafePropertyRead(ast.span,ast.sourceSpan,ast.nameSpan,ast.receiver.visit(this),ast.name)}visitLiteralArray(ast,context){return new LiteralArray(ast.span,ast.sourceSpan,this.visitAll(ast.expressions))}visitLiteralMap(ast,context){return new LiteralMap(ast.span,ast.sourceSpan,ast.keys,this.visitAll(ast.values))}visitUnary(ast,context){switch(ast.operator){case "+":return Unary.createPlus(ast.span,
ast.sourceSpan,ast.expr.visit(this));case "-":return Unary.createMinus(ast.span,ast.sourceSpan,ast.expr.visit(this));default:throw new Error(`Unknown unary operator ${ast.operator}`);}}visitBinary(ast,context){return new Binary(ast.span,ast.sourceSpan,ast.operation,ast.left.visit(this),ast.right.visit(this))}visitPrefixNot(ast,context){return new PrefixNot(ast.span,ast.sourceSpan,ast.expression.visit(this))}visitNonNullAssert(ast,context){return new NonNullAssert(ast.span,ast.sourceSpan,ast.expression.visit(this))}visitConditional(ast,
context){return new Conditional(ast.span,ast.sourceSpan,ast.condition.visit(this),ast.trueExp.visit(this),ast.falseExp.visit(this))}visitPipe(ast,context){return new BindingPipe(ast.span,ast.sourceSpan,ast.exp.visit(this),ast.name,this.visitAll(ast.args),ast.nameSpan)}visitKeyedRead(ast,context){return new KeyedRead(ast.span,ast.sourceSpan,ast.receiver.visit(this),ast.key.visit(this))}visitKeyedWrite(ast,context){return new KeyedWrite(ast.span,ast.sourceSpan,ast.receiver.visit(this),ast.key.visit(this),
ast.value.visit(this))}visitCall(ast,context){return new Call(ast.span,ast.sourceSpan,ast.receiver.visit(this),this.visitAll(ast.args),ast.argumentSpan)}visitAll(asts){const res=[];for(let i=0;i<asts.length;++i)res[i]=asts[i].visit(this);return res}visitChain(ast,context){return new Chain(ast.span,ast.sourceSpan,this.visitAll(ast.expressions))}visitQuote(ast,context){return new Quote(ast.span,ast.sourceSpan,ast.prefix,ast.uninterpretedExpression,ast.location)}visitSafeKeyedRead(ast,context){return new SafeKeyedRead(ast.span,
ast.sourceSpan,ast.receiver.visit(this),ast.key.visit(this))}}class AstMemoryEfficientTransformer{visitImplicitReceiver(ast,context){return ast}visitThisReceiver(ast,context){return ast}visitInterpolation(ast,context){const expressions=this.visitAll(ast.expressions);if(expressions!==ast.expressions)return new Interpolation(ast.span,ast.sourceSpan,ast.strings,expressions);return ast}visitLiteralPrimitive(ast,context){return ast}visitPropertyRead(ast,context){const receiver=ast.receiver.visit(this);
if(receiver!==ast.receiver)return new PropertyRead(ast.span,ast.sourceSpan,ast.nameSpan,receiver,ast.name);return ast}visitPropertyWrite(ast,context){const receiver=ast.receiver.visit(this);const value=ast.value.visit(this);if(receiver!==ast.receiver||value!==ast.value)return new PropertyWrite(ast.span,ast.sourceSpan,ast.nameSpan,receiver,ast.name,value);return ast}visitSafePropertyRead(ast,context){const receiver=ast.receiver.visit(this);if(receiver!==ast.receiver)return new SafePropertyRead(ast.span,
ast.sourceSpan,ast.nameSpan,receiver,ast.name);return ast}visitLiteralArray(ast,context){const expressions=this.visitAll(ast.expressions);if(expressions!==ast.expressions)return new LiteralArray(ast.span,ast.sourceSpan,expressions);return ast}visitLiteralMap(ast,context){const values=this.visitAll(ast.values);if(values!==ast.values)return new LiteralMap(ast.span,ast.sourceSpan,ast.keys,values);return ast}visitUnary(ast,context){const expr=ast.expr.visit(this);if(expr!==ast.expr)switch(ast.operator){case "+":return Unary.createPlus(ast.span,
ast.sourceSpan,expr);case "-":return Unary.createMinus(ast.span,ast.sourceSpan,expr);default:throw new Error(`Unknown unary operator ${ast.operator}`);}return ast}visitBinary(ast,context){const left=ast.left.visit(this);const right=ast.right.visit(this);if(left!==ast.left||right!==ast.right)return new Binary(ast.span,ast.sourceSpan,ast.operation,left,right);return ast}visitPrefixNot(ast,context){const expression=ast.expression.visit(this);if(expression!==ast.expression)return new PrefixNot(ast.span,
ast.sourceSpan,expression);return ast}visitNonNullAssert(ast,context){const expression=ast.expression.visit(this);if(expression!==ast.expression)return new NonNullAssert(ast.span,ast.sourceSpan,expression);return ast}visitConditional(ast,context){const condition=ast.condition.visit(this);const trueExp=ast.trueExp.visit(this);const falseExp=ast.falseExp.visit(this);if(condition!==ast.condition||trueExp!==ast.trueExp||falseExp!==ast.falseExp)return new Conditional(ast.span,ast.sourceSpan,condition,
trueExp,falseExp);return ast}visitPipe(ast,context){const exp=ast.exp.visit(this);const args=this.visitAll(ast.args);if(exp!==ast.exp||args!==ast.args)return new BindingPipe(ast.span,ast.sourceSpan,exp,ast.name,args,ast.nameSpan);return ast}visitKeyedRead(ast,context){const obj=ast.receiver.visit(this);const key=ast.key.visit(this);if(obj!==ast.receiver||key!==ast.key)return new KeyedRead(ast.span,ast.sourceSpan,obj,key);return ast}visitKeyedWrite(ast,context){const obj=ast.receiver.visit(this);const key=
ast.key.visit(this);const value=ast.value.visit(this);if(obj!==ast.receiver||key!==ast.key||value!==ast.value)return new KeyedWrite(ast.span,ast.sourceSpan,obj,key,value);return ast}visitAll(asts){const res=[];let modified=false;for(let i=0;i<asts.length;++i){const original=asts[i];const value=original.visit(this);res[i]=value;modified=modified||value!==original}return modified?res:asts}visitChain(ast,context){const expressions=this.visitAll(ast.expressions);if(expressions!==ast.expressions)return new Chain(ast.span,
ast.sourceSpan,expressions);return ast}visitCall(ast,context){const receiver=ast.receiver.visit(this);const args=this.visitAll(ast.args);if(receiver!==ast.receiver||args!==ast.args)return new Call(ast.span,ast.sourceSpan,receiver,args,ast.argumentSpan);return ast}visitQuote(ast,context){return ast}visitSafeKeyedRead(ast,context){const obj=ast.receiver.visit(this);const key=ast.key.visit(this);if(obj!==ast.receiver||key!==ast.key)return new SafeKeyedRead(ast.span,ast.sourceSpan,obj,key);return ast}}
class ParsedProperty{constructor(name,expression,type,sourceSpan,keySpan,valueSpan){this.name=name;this.expression=expression;this.type=type;this.sourceSpan=sourceSpan;this.keySpan=keySpan;this.valueSpan=valueSpan;this.isLiteral=this.type===exports.ParsedPropertyType.LITERAL_ATTR;this.isAnimation=this.type===exports.ParsedPropertyType.ANIMATION}}exports.ParsedPropertyType=void 0;(function(ParsedPropertyType){ParsedPropertyType[ParsedPropertyType["DEFAULT"]=0]="DEFAULT";ParsedPropertyType[ParsedPropertyType["LITERAL_ATTR"]=
1]="LITERAL_ATTR";ParsedPropertyType[ParsedPropertyType["ANIMATION"]=2]="ANIMATION"})(exports.ParsedPropertyType||(exports.ParsedPropertyType={}));class ParsedEvent{constructor(name,targetOrPhase,type,handler,sourceSpan,handlerSpan,keySpan){this.name=name;this.targetOrPhase=targetOrPhase;this.type=type;this.handler=handler;this.sourceSpan=sourceSpan;this.handlerSpan=handlerSpan;this.keySpan=keySpan}}class ParsedVariable{constructor(name,value,sourceSpan,keySpan,valueSpan){this.name=name;this.value=
value;this.sourceSpan=sourceSpan;this.keySpan=keySpan;this.valueSpan=valueSpan}}class BoundElementProperty{constructor(name,type,securityContext,value,unit,sourceSpan,keySpan,valueSpan){this.name=name;this.type=type;this.securityContext=securityContext;this.value=value;this.unit=unit;this.sourceSpan=sourceSpan;this.keySpan=keySpan;this.valueSpan=valueSpan}}const CORE="@angular/core";class Identifiers{}Identifiers.ANALYZE_FOR_ENTRY_COMPONENTS={name:"ANALYZE_FOR_ENTRY_COMPONENTS",moduleName:CORE};Identifiers.ElementRef=
{name:"ElementRef",moduleName:CORE};Identifiers.NgModuleRef={name:"NgModuleRef",moduleName:CORE};Identifiers.ViewContainerRef={name:"ViewContainerRef",moduleName:CORE};Identifiers.ChangeDetectorRef={name:"ChangeDetectorRef",moduleName:CORE};Identifiers.QueryList={name:"QueryList",moduleName:CORE};Identifiers.TemplateRef={name:"TemplateRef",moduleName:CORE};Identifiers.Renderer2={name:"Renderer2",moduleName:CORE};Identifiers.CodegenComponentFactoryResolver={name:"ɵCodegenComponentFactoryResolver",
moduleName:CORE};Identifiers.ComponentFactoryResolver={name:"ComponentFactoryResolver",moduleName:CORE};Identifiers.ComponentFactory={name:"ComponentFactory",moduleName:CORE};Identifiers.ComponentRef={name:"ComponentRef",moduleName:CORE};Identifiers.NgModuleFactory={name:"NgModuleFactory",moduleName:CORE};Identifiers.createModuleFactory={name:"ɵcmf",moduleName:CORE};Identifiers.moduleDef={name:"ɵmod",moduleName:CORE};Identifiers.moduleProviderDef={name:"ɵmpd",moduleName:CORE};Identifiers.RegisterModuleFactoryFn=
{name:"ɵregisterModuleFactory",moduleName:CORE};Identifiers.inject={name:"ɵɵinject",moduleName:CORE};Identifiers.directiveInject={name:"ɵɵdirectiveInject",moduleName:CORE};Identifiers.INJECTOR={name:"INJECTOR",moduleName:CORE};Identifiers.Injector={name:"Injector",moduleName:CORE};Identifiers.ViewEncapsulation={name:"ViewEncapsulation",moduleName:CORE};Identifiers.ChangeDetectionStrategy={name:"ChangeDetectionStrategy",moduleName:CORE};Identifiers.SecurityContext={name:"SecurityContext",moduleName:CORE};
Identifiers.LOCALE_ID={name:"LOCALE_ID",moduleName:CORE};Identifiers.TRANSLATIONS_FORMAT={name:"TRANSLATIONS_FORMAT",moduleName:CORE};Identifiers.inlineInterpolate={name:"ɵinlineInterpolate",moduleName:CORE};Identifiers.interpolate={name:"ɵinterpolate",moduleName:CORE};Identifiers.EMPTY_ARRAY={name:"ɵEMPTY_ARRAY",moduleName:CORE};Identifiers.EMPTY_MAP={name:"ɵEMPTY_MAP",moduleName:CORE};Identifiers.Renderer={name:"Renderer",moduleName:CORE};Identifiers.RendererType2={name:"RendererType2",moduleName:CORE};
Identifiers.ViewDefinition={name:"ɵViewDefinition",moduleName:CORE};Identifiers.createComponentFactory={name:"ɵccf",moduleName:CORE};class EventHandlerVars{}EventHandlerVars.event=variable("$event");function convertActionBinding(localResolver,implicitReceiver,action,bindingId,interpolationFunction,baseSourceSpan,implicitReceiverAccesses,globals){if(!localResolver)localResolver=new DefaultLocalResolver(globals);const actionWithoutBuiltins=convertPropertyBindingBuiltins({createLiteralArrayConverter:argCount=>
{return args=>literalArr(args)},createLiteralMapConverter:keys=>{return values=>{const entries=keys.map((k,i)=>({key:k.key,value:values[i],quoted:k.quoted}));return literalMap(entries)}},createPipeConverter:name=>{throw new Error(`Illegal State: Actions are not allowed to contain pipes. Pipe: ${name}`);}},action);const visitor=new _AstToIrVisitor(localResolver,implicitReceiver,bindingId,interpolationFunction,baseSourceSpan,implicitReceiverAccesses);const actionStmts=[];flattenStatements(actionWithoutBuiltins.visit(visitor,
_Mode.Statement),actionStmts);prependTemporaryDecls(visitor.temporaryCount,bindingId,actionStmts);if(visitor.usesImplicitReceiver)localResolver.notifyImplicitReceiverUse();const lastIndex=actionStmts.length-1;if(lastIndex>=0){const lastStatement=actionStmts[lastIndex];if(lastStatement instanceof ExpressionStatement)actionStmts[lastIndex]=new ReturnStatement(lastStatement.expr)}return actionStmts}function convertPropertyBindingBuiltins(converterFactory,ast){return convertBuiltins(converterFactory,
ast)}class ConvertPropertyBindingResult{constructor(stmts,currValExpr){this.stmts=stmts;this.currValExpr=currValExpr}}function convertPropertyBinding(localResolver,implicitReceiver,expressionWithoutBuiltins,bindingId,interpolationFunction){if(!localResolver)localResolver=new DefaultLocalResolver;const visitor=new _AstToIrVisitor(localResolver,implicitReceiver,bindingId,interpolationFunction);const outputExpr=expressionWithoutBuiltins.visit(visitor,_Mode.Expression);const stmts=getStatementsFromVisitor(visitor,
bindingId);if(visitor.usesImplicitReceiver)localResolver.notifyImplicitReceiverUse();return new ConvertPropertyBindingResult(stmts,outputExpr)}function convertUpdateArguments(localResolver,contextVariableExpression,expressionWithArgumentsToExtract,bindingId){const visitor=new _AstToIrVisitor(localResolver,contextVariableExpression,bindingId,undefined);const outputExpr=expressionWithArgumentsToExtract.visit(visitor,_Mode.Expression);if(visitor.usesImplicitReceiver)localResolver.notifyImplicitReceiverUse();
const stmts=getStatementsFromVisitor(visitor,bindingId);let args=outputExpr.args.slice(1);if(expressionWithArgumentsToExtract instanceof Interpolation){const strings=expressionWithArgumentsToExtract.strings;if(args.length===3&&strings[0]===""&&strings[1]==="")args=[args[1]];else if(args.length>=19)args=[literalArr(args)]}return{stmts,args}}function getStatementsFromVisitor(visitor,bindingId){const stmts=[];for(let i=0;i<visitor.temporaryCount;i++)stmts.push(temporaryDeclaration(bindingId,i));return stmts}
function convertBuiltins(converterFactory,ast){const visitor=new _BuiltinAstConverter(converterFactory);return ast.visit(visitor)}function temporaryName(bindingId,temporaryNumber){return`tmp_${bindingId}_${temporaryNumber}`}function temporaryDeclaration(bindingId,temporaryNumber){return new DeclareVarStmt(temporaryName(bindingId,temporaryNumber))}function prependTemporaryDecls(temporaryCount,bindingId,statements){for(let i=temporaryCount-1;i>=0;i--)statements.unshift(temporaryDeclaration(bindingId,
i))}var _Mode;(function(_Mode){_Mode[_Mode["Statement"]=0]="Statement";_Mode[_Mode["Expression"]=1]="Expression"})(_Mode||(_Mode={}));function ensureStatementMode(mode,ast){if(mode!==_Mode.Statement)throw new Error(`Expected a statement, but saw ${ast}`);}function ensureExpressionMode(mode,ast){if(mode!==_Mode.Expression)throw new Error(`Expected an expression, but saw ${ast}`);}function convertToStatementIfNeeded(mode,expr){if(mode===_Mode.Statement)return expr.toStmt();else return expr}class _BuiltinAstConverter extends AstTransformer{constructor(_converterFactory){super();
this._converterFactory=_converterFactory}visitPipe(ast,context){const args=[ast.exp,...ast.args].map(ast=>ast.visit(this,context));return new BuiltinFunctionCall(ast.span,ast.sourceSpan,args,this._converterFactory.createPipeConverter(ast.name,args.length))}visitLiteralArray(ast,context){const args=ast.expressions.map(ast=>ast.visit(this,context));return new BuiltinFunctionCall(ast.span,ast.sourceSpan,args,this._converterFactory.createLiteralArrayConverter(ast.expressions.length))}visitLiteralMap(ast,
context){const args=ast.values.map(ast=>ast.visit(this,context));return new BuiltinFunctionCall(ast.span,ast.sourceSpan,args,this._converterFactory.createLiteralMapConverter(ast.keys))}}class _AstToIrVisitor{constructor(_localResolver,_implicitReceiver,bindingId,interpolationFunction,baseSourceSpan,implicitReceiverAccesses){this._localResolver=_localResolver;this._implicitReceiver=_implicitReceiver;this.bindingId=bindingId;this.interpolationFunction=interpolationFunction;this.baseSourceSpan=baseSourceSpan;
this.implicitReceiverAccesses=implicitReceiverAccesses;this._nodeMap=new Map;this._resultMap=new Map;this._currentTemporary=0;this.temporaryCount=0;this.usesImplicitReceiver=false}visitUnary(ast,mode){let op;switch(ast.operator){case "+":op=exports.UnaryOperator.Plus;break;case "-":op=exports.UnaryOperator.Minus;break;default:throw new Error(`Unsupported operator ${ast.operator}`);}return convertToStatementIfNeeded(mode,new UnaryOperatorExpr(op,this._visit(ast.expr,_Mode.Expression),undefined,this.convertSourceSpan(ast.span)))}visitBinary(ast,
mode){let op;switch(ast.operation){case "+":op=exports.BinaryOperator.Plus;break;case "-":op=exports.BinaryOperator.Minus;break;case "*":op=exports.BinaryOperator.Multiply;break;case "/":op=exports.BinaryOperator.Divide;break;case "%":op=exports.BinaryOperator.Modulo;break;case "&&":op=exports.BinaryOperator.And;break;case "||":op=exports.BinaryOperator.Or;break;case "==":op=exports.BinaryOperator.Equals;break;case "!=":op=exports.BinaryOperator.NotEquals;break;case "===":op=exports.BinaryOperator.Identical;
break;case "!==":op=exports.BinaryOperator.NotIdentical;break;case "<":op=exports.BinaryOperator.Lower;break;case ">":op=exports.BinaryOperator.Bigger;break;case "<=":op=exports.BinaryOperator.LowerEquals;break;case ">=":op=exports.BinaryOperator.BiggerEquals;break;case "??":return this.convertNullishCoalesce(ast,mode);default:throw new Error(`Unsupported operation ${ast.operation}`);}return convertToStatementIfNeeded(mode,new BinaryOperatorExpr(op,this._visit(ast.left,_Mode.Expression),this._visit(ast.right,
_Mode.Expression),undefined,this.convertSourceSpan(ast.span)))}visitChain(ast,mode){ensureStatementMode(mode,ast);return this.visitAll(ast.expressions,mode)}visitConditional(ast,mode){const value=this._visit(ast.condition,_Mode.Expression);return convertToStatementIfNeeded(mode,value.conditional(this._visit(ast.trueExp,_Mode.Expression),this._visit(ast.falseExp,_Mode.Expression),this.convertSourceSpan(ast.span)))}visitPipe(ast,mode){throw new Error(`Illegal state: Pipes should have been converted into functions. Pipe: ${ast.name}`);
}visitImplicitReceiver(ast,mode){ensureExpressionMode(mode,ast);this.usesImplicitReceiver=true;return this._implicitReceiver}visitThisReceiver(ast,mode){return this.visitImplicitReceiver(ast,mode)}visitInterpolation(ast,mode){ensureExpressionMode(mode,ast);const args=[literal(ast.expressions.length)];for(let i=0;i<ast.strings.length-1;i++){args.push(literal(ast.strings[i]));args.push(this._visit(ast.expressions[i],_Mode.Expression))}args.push(literal(ast.strings[ast.strings.length-1]));if(this.interpolationFunction)return this.interpolationFunction(args);
return ast.expressions.length<=9?importExpr(Identifiers.inlineInterpolate).callFn(args):importExpr(Identifiers.interpolate).callFn([args[0],literalArr(args.slice(1),undefined,this.convertSourceSpan(ast.span))])}visitKeyedRead(ast,mode){const leftMostSafe=this.leftMostSafeNode(ast);if(leftMostSafe)return this.convertSafeAccess(ast,leftMostSafe,mode);else return convertToStatementIfNeeded(mode,this._visit(ast.receiver,_Mode.Expression).key(this._visit(ast.key,_Mode.Expression)))}visitKeyedWrite(ast,
mode){const obj=this._visit(ast.receiver,_Mode.Expression);const key=this._visit(ast.key,_Mode.Expression);const value=this._visit(ast.value,_Mode.Expression);if(obj===this._implicitReceiver)this._localResolver.maybeRestoreView();return convertToStatementIfNeeded(mode,obj.key(key).set(value))}visitLiteralArray(ast,mode){throw new Error(`Illegal State: literal arrays should have been converted into functions`);}visitLiteralMap(ast,mode){throw new Error(`Illegal State: literal maps should have been converted into functions`);
}visitLiteralPrimitive(ast,mode){const type=ast.value===null||ast.value===undefined||ast.value===true||ast.value===true?INFERRED_TYPE:undefined;return convertToStatementIfNeeded(mode,literal(ast.value,type,this.convertSourceSpan(ast.span)))}_getLocal(name,receiver){var _a;if(((_a=this._localResolver.globals)===null||_a===void 0?void 0:_a.has(name))&&receiver instanceof ThisReceiver)return null;return this._localResolver.getLocal(name)}visitPrefixNot(ast,mode){return convertToStatementIfNeeded(mode,
not(this._visit(ast.expression,_Mode.Expression)))}visitNonNullAssert(ast,mode){return convertToStatementIfNeeded(mode,this._visit(ast.expression,_Mode.Expression))}visitPropertyRead(ast,mode){const leftMostSafe=this.leftMostSafeNode(ast);if(leftMostSafe)return this.convertSafeAccess(ast,leftMostSafe,mode);else{let result=null;const prevUsesImplicitReceiver=this.usesImplicitReceiver;const receiver=this._visit(ast.receiver,_Mode.Expression);if(receiver===this._implicitReceiver){result=this._getLocal(ast.name,
ast.receiver);if(result){this.usesImplicitReceiver=prevUsesImplicitReceiver;this.addImplicitReceiverAccess(ast.name)}}if(result==null)result=receiver.prop(ast.name,this.convertSourceSpan(ast.span));return convertToStatementIfNeeded(mode,result)}}visitPropertyWrite(ast,mode){const receiver=this._visit(ast.receiver,_Mode.Expression);const prevUsesImplicitReceiver=this.usesImplicitReceiver;let varExpr=null;if(receiver===this._implicitReceiver){const localExpr=this._getLocal(ast.name,ast.receiver);if(localExpr)if(localExpr instanceof
ReadPropExpr){varExpr=localExpr;this.usesImplicitReceiver=prevUsesImplicitReceiver;this.addImplicitReceiverAccess(ast.name)}else{const receiver=ast.name;const value=ast.value instanceof PropertyRead?ast.value.name:undefined;throw new Error(`Cannot assign value "${value}" to template variable "${receiver}". Template variables are read-only.`);}}if(varExpr===null)varExpr=receiver.prop(ast.name,this.convertSourceSpan(ast.span));return convertToStatementIfNeeded(mode,varExpr.set(this._visit(ast.value,
_Mode.Expression)))}visitSafePropertyRead(ast,mode){return this.convertSafeAccess(ast,this.leftMostSafeNode(ast),mode)}visitSafeKeyedRead(ast,mode){return this.convertSafeAccess(ast,this.leftMostSafeNode(ast),mode)}visitAll(asts,mode){return asts.map(ast=>this._visit(ast,mode))}visitQuote(ast,mode){throw new Error(`Quotes are not supported for evaluation!
        Statement: ${ast.uninterpretedExpression} located at ${ast.location}`);}visitCall(ast,mode){const leftMostSafe=this.leftMostSafeNode(ast);if(leftMostSafe)return this.convertSafeAccess(ast,leftMostSafe,mode);const convertedArgs=this.visitAll(ast.args,_Mode.Expression);if(ast instanceof BuiltinFunctionCall)return convertToStatementIfNeeded(mode,ast.converter(convertedArgs));const receiver=ast.receiver;if(receiver instanceof PropertyRead&&receiver.receiver instanceof ImplicitReceiver&&!(receiver.receiver instanceof
ThisReceiver)&&receiver.name==="$any"){if(convertedArgs.length!==1)throw new Error(`Invalid call to $any, expected 1 argument but received ${convertedArgs.length||"none"}`);return convertToStatementIfNeeded(mode,convertedArgs[0])}const call=this._visit(receiver,_Mode.Expression).callFn(convertedArgs,this.convertSourceSpan(ast.span));return convertToStatementIfNeeded(mode,call)}_visit(ast,mode){const result=this._resultMap.get(ast);if(result)return result;return(this._nodeMap.get(ast)||ast).visit(this,
mode)}convertSafeAccess(ast,leftMostSafe,mode){let guardedExpression=this._visit(leftMostSafe.receiver,_Mode.Expression);let temporary=undefined;if(this.needsTemporaryInSafeAccess(leftMostSafe.receiver)){temporary=this.allocateTemporary();guardedExpression=temporary.set(guardedExpression);this._resultMap.set(leftMostSafe.receiver,temporary)}const condition=guardedExpression.isBlank();if(leftMostSafe instanceof SafeKeyedRead)this._nodeMap.set(leftMostSafe,new KeyedRead(leftMostSafe.span,leftMostSafe.sourceSpan,
leftMostSafe.receiver,leftMostSafe.key));else this._nodeMap.set(leftMostSafe,new PropertyRead(leftMostSafe.span,leftMostSafe.sourceSpan,leftMostSafe.nameSpan,leftMostSafe.receiver,leftMostSafe.name));const access=this._visit(ast,_Mode.Expression);this._nodeMap.delete(leftMostSafe);if(temporary)this.releaseTemporary(temporary);return convertToStatementIfNeeded(mode,condition.conditional(NULL_EXPR,access))}convertNullishCoalesce(ast,mode){const left=this._visit(ast.left,_Mode.Expression);const right=
this._visit(ast.right,_Mode.Expression);const temporary=this.allocateTemporary();this.releaseTemporary(temporary);return convertToStatementIfNeeded(mode,temporary.set(left).notIdentical(NULL_EXPR).and(temporary.notIdentical(literal(undefined))).conditional(temporary,right))}leftMostSafeNode(ast){const visit=(visitor,ast)=>{return(this._nodeMap.get(ast)||ast).visit(visitor)};return ast.visit({visitUnary(ast){return null},visitBinary(ast){return null},visitChain(ast){return null},visitConditional(ast){return null},
visitCall(ast){return visit(this,ast.receiver)},visitImplicitReceiver(ast){return null},visitThisReceiver(ast){return null},visitInterpolation(ast){return null},visitKeyedRead(ast){return visit(this,ast.receiver)},visitKeyedWrite(ast){return null},visitLiteralArray(ast){return null},visitLiteralMap(ast){return null},visitLiteralPrimitive(ast){return null},visitPipe(ast){return null},visitPrefixNot(ast){return null},visitNonNullAssert(ast){return null},visitPropertyRead(ast){return visit(this,ast.receiver)},
visitPropertyWrite(ast){return null},visitQuote(ast){return null},visitSafePropertyRead(ast){return visit(this,ast.receiver)||ast},visitSafeKeyedRead(ast){return visit(this,ast.receiver)||ast}})}needsTemporaryInSafeAccess(ast){const visit=(visitor,ast)=>{return ast&&(this._nodeMap.get(ast)||ast).visit(visitor)};const visitSome=(visitor,ast)=>{return ast.some(ast=>visit(visitor,ast))};return ast.visit({visitUnary(ast){return visit(this,ast.expr)},visitBinary(ast){return visit(this,ast.left)||visit(this,
ast.right)},visitChain(ast){return false},visitConditional(ast){return visit(this,ast.condition)||visit(this,ast.trueExp)||visit(this,ast.falseExp)},visitCall(ast){return true},visitImplicitReceiver(ast){return false},visitThisReceiver(ast){return false},visitInterpolation(ast){return visitSome(this,ast.expressions)},visitKeyedRead(ast){return false},visitKeyedWrite(ast){return false},visitLiteralArray(ast){return true},visitLiteralMap(ast){return true},visitLiteralPrimitive(ast){return false},visitPipe(ast){return true},
visitPrefixNot(ast){return visit(this,ast.expression)},visitNonNullAssert(ast){return visit(this,ast.expression)},visitPropertyRead(ast){return false},visitPropertyWrite(ast){return false},visitQuote(ast){return false},visitSafePropertyRead(ast){return false},visitSafeKeyedRead(ast){return false}})}allocateTemporary(){const tempNumber=this._currentTemporary++;this.temporaryCount=Math.max(this._currentTemporary,this.temporaryCount);return new ReadVarExpr(temporaryName(this.bindingId,tempNumber))}releaseTemporary(temporary){this._currentTemporary--;
if(temporary.name!=temporaryName(this.bindingId,this._currentTemporary))throw new Error(`Temporary ${temporary.name} released out of order`);}convertSourceSpan(span){if(this.baseSourceSpan){const start=this.baseSourceSpan.start.moveBy(span.start);const end=this.baseSourceSpan.start.moveBy(span.end);const fullStart=this.baseSourceSpan.fullStart.moveBy(span.start);return new ParseSourceSpan(start,end,fullStart)}else return null}addImplicitReceiverAccess(name){if(this.implicitReceiverAccesses)this.implicitReceiverAccesses.add(name)}}
function flattenStatements(arg,output){if(Array.isArray(arg))arg.forEach(entry=>flattenStatements(entry,output));else output.push(arg)}class DefaultLocalResolver{constructor(globals){this.globals=globals}notifyImplicitReceiverUse(){}maybeRestoreView(){}getLocal(name){if(name===EventHandlerVars.event.name)return EventHandlerVars.event;return null}}class BuiltinFunctionCall extends Call{constructor(span,sourceSpan,args,converter){super(span,sourceSpan,new EmptyExpr(span,sourceSpan),args,null);this.converter=
converter}}class ShadowCss{constructor(){this.strictStyling=true}shimCssText(cssText,selector,hostSelector=""){const commentsWithHash=extractCommentsWithHash(cssText);cssText=stripComments(cssText);cssText=this._insertDirectives(cssText);const scopedCssText=this._scopeCssText(cssText,selector,hostSelector);return[scopedCssText,...commentsWithHash].join("\n")}_insertDirectives(cssText){cssText=this._insertPolyfillDirectivesInCssText(cssText);return this._insertPolyfillRulesInCssText(cssText)}_insertPolyfillDirectivesInCssText(cssText){return cssText.replace(_cssContentNextSelectorRe,
function(...m){return m[2]+"{"})}_insertPolyfillRulesInCssText(cssText){return cssText.replace(_cssContentRuleRe,(...m)=>{const rule=m[0].replace(m[1],"").replace(m[2],"");return m[4]+rule})}_scopeCssText(cssText,scopeSelector,hostSelector){const unscopedRules=this._extractUnscopedRulesFromCssText(cssText);cssText=this._insertPolyfillHostInCssText(cssText);cssText=this._convertColonHost(cssText);cssText=this._convertColonHostContext(cssText);cssText=this._convertShadowDOMSelectors(cssText);if(scopeSelector)cssText=
this._scopeSelectors(cssText,scopeSelector,hostSelector);cssText=cssText+"\n"+unscopedRules;return cssText.trim()}_extractUnscopedRulesFromCssText(cssText){let r="";let m;_cssContentUnscopedRuleRe.lastIndex=0;while((m=_cssContentUnscopedRuleRe.exec(cssText))!==null){const rule=m[0].replace(m[2],"").replace(m[1],m[4]);r+=rule+"\n\n"}return r}_convertColonHost(cssText){return cssText.replace(_cssColonHostRe,(_,hostSelectors,otherSelectors)=>{if(hostSelectors){const convertedSelectors=[];const hostSelectorArray=
hostSelectors.split(",").map(p=>p.trim());for(const hostSelector of hostSelectorArray){if(!hostSelector)break;const convertedSelector=_polyfillHostNoCombinator+hostSelector.replace(_polyfillHost,"")+otherSelectors;convertedSelectors.push(convertedSelector)}return convertedSelectors.join(",")}else return _polyfillHostNoCombinator+otherSelectors})}_convertColonHostContext(cssText){return cssText.replace(_cssColonHostContextReGlobal,selectorText=>{var _a;const contextSelectorGroups=[[]];let match;while(match=
_cssColonHostContextRe.exec(selectorText)){const newContextSelectors=((_a=match[1])!==null&&_a!==void 0?_a:"").trim().split(",").map(m=>m.trim()).filter(m=>m!=="");const contextSelectorGroupsLength=contextSelectorGroups.length;repeatGroups(contextSelectorGroups,newContextSelectors.length);for(let i=0;i<newContextSelectors.length;i++)for(let j=0;j<contextSelectorGroupsLength;j++)contextSelectorGroups[j+i*contextSelectorGroupsLength].push(newContextSelectors[i]);selectorText=match[2]}return contextSelectorGroups.map(contextSelectors=>
combineHostContextSelectors(contextSelectors,selectorText)).join(", ")})}_convertShadowDOMSelectors(cssText){return _shadowDOMSelectorsRe.reduce((result,pattern)=>result.replace(pattern," "),cssText)}_scopeSelectors(cssText,scopeSelector,hostSelector){return processRules(cssText,rule=>{let selector=rule.selector;let content=rule.content;if(rule.selector[0]!=="@")selector=this._scopeSelector(rule.selector,scopeSelector,hostSelector,this.strictStyling);else if(rule.selector.startsWith("@media")||rule.selector.startsWith("@supports")||
rule.selector.startsWith("@document"))content=this._scopeSelectors(rule.content,scopeSelector,hostSelector);else if(rule.selector.startsWith("@font-face")||rule.selector.startsWith("@page"))content=this._stripScopingSelectors(rule.content);return new CssRule(selector,content)})}_stripScopingSelectors(cssText){return processRules(cssText,rule=>{const selector=rule.selector.replace(_shadowDeepSelectors," ").replace(_polyfillHostNoCombinatorRe," ");return new CssRule(selector,rule.content)})}_scopeSelector(selector,
scopeSelector,hostSelector,strict){return selector.split(",").map(part=>part.trim().split(_shadowDeepSelectors)).map(deepParts=>{const [shallowPart,...otherParts]=deepParts;const applyScope=shallowPart=>{if(this._selectorNeedsScoping(shallowPart,scopeSelector))return strict?this._applyStrictSelectorScope(shallowPart,scopeSelector,hostSelector):this._applySelectorScope(shallowPart,scopeSelector,hostSelector);else return shallowPart};return[applyScope(shallowPart),...otherParts].join(" ")}).join(", ")}_selectorNeedsScoping(selector,
scopeSelector){const re=this._makeScopeMatcher(scopeSelector);return!re.test(selector)}_makeScopeMatcher(scopeSelector){const lre=/\[/g;const rre=/\]/g;scopeSelector=scopeSelector.replace(lre,"\\[").replace(rre,"\\]");return new RegExp("^("+scopeSelector+")"+_selectorReSuffix,"m")}_applySelectorScope(selector,scopeSelector,hostSelector){return this._applySimpleSelectorScope(selector,scopeSelector,hostSelector)}_applySimpleSelectorScope(selector,scopeSelector,hostSelector){_polyfillHostRe.lastIndex=
0;if(_polyfillHostRe.test(selector)){const replaceBy=this.strictStyling?`[${hostSelector}]`:scopeSelector;return selector.replace(_polyfillHostNoCombinatorRe,(hnc,selector)=>{return selector.replace(/([^:]*)(:*)(.*)/,(_,before,colon,after)=>{return before+replaceBy+colon+after})}).replace(_polyfillHostRe,replaceBy+" ")}return scopeSelector+" "+selector}_applyStrictSelectorScope(selector,scopeSelector,hostSelector){const isRe=/\[is=([^\]]*)\]/g;scopeSelector=scopeSelector.replace(isRe,(_,...parts)=>
parts[0]);const attrName="["+scopeSelector+"]";const _scopeSelectorPart=p=>{let scopedP=p.trim();if(!scopedP)return"";if(p.indexOf(_polyfillHostNoCombinator)>-1)scopedP=this._applySimpleSelectorScope(p,scopeSelector,hostSelector);else{const t=p.replace(_polyfillHostRe,"");if(t.length>0){const matches=t.match(/([^:]*)(:*)(.*)/);if(matches)scopedP=matches[1]+attrName+matches[2]+matches[3]}}return scopedP};const safeContent=new SafeSelector(selector);selector=safeContent.content();let scopedSelector=
"";let startIndex=0;let res;const sep=/( |>|\+|~(?!=))\s*/g;const hasHost=selector.indexOf(_polyfillHostNoCombinator)>-1;let shouldScope=!hasHost;while((res=sep.exec(selector))!==null){const separator=res[1];const part=selector.slice(startIndex,res.index).trim();shouldScope=shouldScope||part.indexOf(_polyfillHostNoCombinator)>-1;const scopedPart=shouldScope?_scopeSelectorPart(part):part;scopedSelector+=`${scopedPart} ${separator} `;startIndex=sep.lastIndex}const part=selector.substring(startIndex);
shouldScope=shouldScope||part.indexOf(_polyfillHostNoCombinator)>-1;scopedSelector+=shouldScope?_scopeSelectorPart(part):part;return safeContent.restore(scopedSelector)}_insertPolyfillHostInCssText(selector){return selector.replace(_colonHostContextRe,_polyfillHostContext).replace(_colonHostRe,_polyfillHost)}}class SafeSelector{constructor(selector){this.placeholders=[];this.index=0;selector=this._escapeRegexMatches(selector,/(\[[^\]]*\])/g);selector=this._escapeRegexMatches(selector,/(\\.)/g);this._content=
selector.replace(/(:nth-[-\w]+)(\([^)]+\))/g,(_,pseudo,exp)=>{const replaceBy=`__ph-${this.index}__`;this.placeholders.push(exp);this.index++;return pseudo+replaceBy})}restore(content){return content.replace(/__ph-(\d+)__/g,(_ph,index)=>this.placeholders[+index])}content(){return this._content}_escapeRegexMatches(content,pattern){return content.replace(pattern,(_,keep)=>{const replaceBy=`__ph-${this.index}__`;this.placeholders.push(keep);this.index++;return replaceBy})}}const _cssContentNextSelectorRe=
/polyfill-next-selector[^}]*content:[\s]*?(['"])(.*?)\1[;\s]*}([^{]*?){/gim;const _cssContentRuleRe=/(polyfill-rule)[^}]*(content:[\s]*(['"])(.*?)\3)[;\s]*[^}]*}/gim;const _cssContentUnscopedRuleRe=/(polyfill-unscoped-rule)[^}]*(content:[\s]*(['"])(.*?)\3)[;\s]*[^}]*}/gim;const _polyfillHost="-shadowcsshost";const _polyfillHostContext="-shadowcsscontext";const _parenSuffix="(?:\\(("+"(?:\\([^)(]*\\)|[^)(]*)+?"+")\\))?([^,{]*)";const _cssColonHostRe=new RegExp(_polyfillHost+_parenSuffix,"gim");const _cssColonHostContextReGlobal=
new RegExp(_polyfillHostContext+_parenSuffix,"gim");const _cssColonHostContextRe=new RegExp(_polyfillHostContext+_parenSuffix,"im");const _polyfillHostNoCombinator=_polyfillHost+"-no-combinator";const _polyfillHostNoCombinatorRe=/-shadowcsshost-no-combinator([^\s]*)/;const _shadowDOMSelectorsRe=[/::shadow/g,/::content/g,/\/shadow-deep\//g,/\/shadow\//g];const _shadowDeepSelectors=/(?:>>>)|(?:\/deep\/)|(?:::ng-deep)/g;const _selectorReSuffix="([>\\s~+[.,{:][\\s\\S]*)?$";const _polyfillHostRe=/-shadowcsshost/gim;
const _colonHostRe=/:host/gim;const _colonHostContextRe=/:host-context/gim;const _commentRe=/\/\*[\s\S]*?\*\//g;function stripComments(input){return input.replace(_commentRe,"")}const _commentWithHashRe=/\/\*\s*#\s*source(Mapping)?URL=[\s\S]+?\*\//g;function extractCommentsWithHash(input){return input.match(_commentWithHashRe)||[]}const BLOCK_PLACEHOLDER="%BLOCK%";const QUOTE_PLACEHOLDER="%QUOTED%";const _ruleRe=/(\s*)([^;\{\}]+?)(\s*)((?:{%BLOCK%}?\s*;?)|(?:\s*;))/g;const _quotedRe=/%QUOTED%/g;const CONTENT_PAIRS=
new Map([["{","}"]]);const QUOTE_PAIRS=new Map([[`"`,`"`],[`'`,`'`]]);class CssRule{constructor(selector,content){this.selector=selector;this.content=content}}function processRules(input,ruleCallback){const inputWithEscapedQuotes=escapeBlocks(input,QUOTE_PAIRS,QUOTE_PLACEHOLDER);const inputWithEscapedBlocks=escapeBlocks(inputWithEscapedQuotes.escapedString,CONTENT_PAIRS,BLOCK_PLACEHOLDER);let nextBlockIndex=0;let nextQuoteIndex=0;return inputWithEscapedBlocks.escapedString.replace(_ruleRe,(...m)=>
{const selector=m[2];let content="";let suffix=m[4];let contentPrefix="";if(suffix&&suffix.startsWith("{"+BLOCK_PLACEHOLDER)){content=inputWithEscapedBlocks.blocks[nextBlockIndex++];suffix=suffix.substring(BLOCK_PLACEHOLDER.length+1);contentPrefix="{"}const rule=ruleCallback(new CssRule(selector,content));return`${m[1]}${rule.selector}${m[3]}${contentPrefix}${rule.content}${suffix}`}).replace(_quotedRe,()=>inputWithEscapedQuotes.blocks[nextQuoteIndex++])}class StringWithEscapedBlocks{constructor(escapedString,
blocks){this.escapedString=escapedString;this.blocks=blocks}}function escapeBlocks(input,charPairs,placeholder){const resultParts=[];const escapedBlocks=[];let openCharCount=0;let nonBlockStartIndex=0;let blockStartIndex=-1;let openChar;let closeChar;for(let i=0;i<input.length;i++){const char=input[i];if(char==="\\")i++;else if(char===closeChar){openCharCount--;if(openCharCount===0){escapedBlocks.push(input.substring(blockStartIndex,i));resultParts.push(placeholder);nonBlockStartIndex=i;blockStartIndex=
-1;openChar=closeChar=undefined}}else if(char===openChar)openCharCount++;else if(openCharCount===0&&charPairs.has(char)){openChar=char;closeChar=charPairs.get(char);openCharCount=1;blockStartIndex=i+1;resultParts.push(input.substring(nonBlockStartIndex,blockStartIndex))}}if(blockStartIndex!==-1){escapedBlocks.push(input.substring(blockStartIndex));resultParts.push(placeholder)}else resultParts.push(input.substring(nonBlockStartIndex));return new StringWithEscapedBlocks(resultParts.join(""),escapedBlocks)}
function combineHostContextSelectors(contextSelectors,otherSelectors){const hostMarker=_polyfillHostNoCombinator;_polyfillHostRe.lastIndex=0;const otherSelectorsHasHost=_polyfillHostRe.test(otherSelectors);if(contextSelectors.length===0)return hostMarker+otherSelectors;const combined=[contextSelectors.pop()||""];while(contextSelectors.length>0){const length=combined.length;const contextSelector=contextSelectors.pop();for(let i=0;i<length;i++){const previousSelectors=combined[i];combined[length*2+
i]=previousSelectors+" "+contextSelector;combined[length+i]=contextSelector+" "+previousSelectors;combined[i]=contextSelector+previousSelectors}}return combined.map(s=>otherSelectorsHasHost?`${s}${otherSelectors}`:`${s}${hostMarker}${otherSelectors}, ${s} ${hostMarker}${otherSelectors}`).join(",")}function repeatGroups(groups,multiples){const length=groups.length;for(let i=1;i<multiples;i++)for(let j=0;j<length;j++)groups[j+i*length]=groups[j].slice(0)}function parse(value){const styles=[];let i=
0;let parenDepth=0;let quote=0;let valueStart=0;let propStart=0;let currentProp=null;let valueHasQuotes=false;while(i<value.length){const token=value.charCodeAt(i++);switch(token){case 40:parenDepth++;break;case 41:parenDepth--;break;case 39:valueHasQuotes=valueHasQuotes||valueStart>0;if(quote===0)quote=39;else if(quote===39&&value.charCodeAt(i-1)!==92)quote=0;break;case 34:valueHasQuotes=valueHasQuotes||valueStart>0;if(quote===0)quote=34;else if(quote===34&&value.charCodeAt(i-1)!==92)quote=0;break;
case 58:if(!currentProp&&parenDepth===0&&quote===0){currentProp=hyphenate(value.substring(propStart,i-1).trim());valueStart=i}break;case 59:if(currentProp&&valueStart>0&&parenDepth===0&&quote===0){const styleVal=value.substring(valueStart,i-1).trim();styles.push(currentProp,valueHasQuotes?stripUnnecessaryQuotes(styleVal):styleVal);propStart=i;valueStart=0;currentProp=null;valueHasQuotes=false}break}}if(currentProp&&valueStart){const styleVal=value.substr(valueStart).trim();styles.push(currentProp,
valueHasQuotes?stripUnnecessaryQuotes(styleVal):styleVal)}return styles}function stripUnnecessaryQuotes(value){const qS=value.charCodeAt(0);const qE=value.charCodeAt(value.length-1);if(qS==qE&&(qS==39||qS==34)){const tempValue=value.substring(1,value.length-1);if(tempValue.indexOf("'")==-1&&tempValue.indexOf('"')==-1)value=tempValue}return value}function hyphenate(value){return value.replace(/[a-z][A-Z]/g,v=>{return v.charAt(0)+"-"+v.charAt(1)}).toLowerCase()}const IMPORTANT_FLAG="!important";const MIN_STYLING_BINDING_SLOTS_REQUIRED=
2;class StylingBuilder{constructor(_directiveExpr){this._directiveExpr=_directiveExpr;this._hasInitialValues=false;this.hasBindings=false;this.hasBindingsWithPipes=false;this._classMapInput=null;this._styleMapInput=null;this._singleStyleInputs=null;this._singleClassInputs=null;this._lastStylingInput=null;this._firstStylingInput=null;this._stylesIndex=new Map;this._classesIndex=new Map;this._initialStyleValues=[];this._initialClassValues=[]}registerBoundInput(input){let binding=null;let name=input.name;
switch(input.type){case 0:binding=this.registerInputBasedOnName(name,input.value,input.sourceSpan);break;case 3:binding=this.registerStyleInput(name,false,input.value,input.sourceSpan,input.unit);break;case 2:binding=this.registerClassInput(name,false,input.value,input.sourceSpan);break}return binding?true:false}registerInputBasedOnName(name,expression,sourceSpan){let binding=null;const prefix=name.substring(0,6);const isStyle=name==="style"||prefix==="style."||prefix==="style!";const isClass=!isStyle&&
(name==="class"||prefix==="class."||prefix==="class!");if(isStyle||isClass){const isMapBased=name.charAt(5)!==".";const property=name.substr(isMapBased?5:6);if(isStyle)binding=this.registerStyleInput(property,isMapBased,expression,sourceSpan);else binding=this.registerClassInput(property,isMapBased,expression,sourceSpan)}return binding}registerStyleInput(name,isMapBased,value,sourceSpan,suffix){if(isEmptyExpression(value))return null;if(!isCssCustomProperty(name))name=hyphenate(name);const {property,
hasOverrideFlag,suffix:bindingSuffix}=parseProperty(name);suffix=typeof suffix==="string"&&suffix.length!==0?suffix:bindingSuffix;const entry={name:property,suffix:suffix,value,sourceSpan,hasOverrideFlag};if(isMapBased)this._styleMapInput=entry;else{(this._singleStyleInputs=this._singleStyleInputs||[]).push(entry);registerIntoMap(this._stylesIndex,property)}this._lastStylingInput=entry;this._firstStylingInput=this._firstStylingInput||entry;this._checkForPipes(value);this.hasBindings=true;return entry}registerClassInput(name,
isMapBased,value,sourceSpan){if(isEmptyExpression(value))return null;const {property,hasOverrideFlag}=parseProperty(name);const entry={name:property,value,sourceSpan,hasOverrideFlag,suffix:null};if(isMapBased)this._classMapInput=entry;else{(this._singleClassInputs=this._singleClassInputs||[]).push(entry);registerIntoMap(this._classesIndex,property)}this._lastStylingInput=entry;this._firstStylingInput=this._firstStylingInput||entry;this._checkForPipes(value);this.hasBindings=true;return entry}_checkForPipes(value){if(value instanceof
ASTWithSource&&value.ast instanceof BindingPipe)this.hasBindingsWithPipes=true}registerStyleAttr(value){this._initialStyleValues=parse(value);this._hasInitialValues=true}registerClassAttr(value){this._initialClassValues=value.trim().split(/\s+/g);this._hasInitialValues=true}populateInitialStylingAttrs(attrs){if(this._initialClassValues.length){attrs.push(literal(1));for(let i=0;i<this._initialClassValues.length;i++)attrs.push(literal(this._initialClassValues[i]))}if(this._initialStyleValues.length){attrs.push(literal(2));
for(let i=0;i<this._initialStyleValues.length;i+=2)attrs.push(literal(this._initialStyleValues[i]),literal(this._initialStyleValues[i+1]))}}assignHostAttrs(attrs,definitionMap){if(this._directiveExpr&&(attrs.length||this._hasInitialValues)){this.populateInitialStylingAttrs(attrs);definitionMap.set("hostAttrs",literalArr(attrs))}}buildClassMapInstruction(valueConverter){if(this._classMapInput)return this._buildMapBasedInstruction(valueConverter,true,this._classMapInput);return null}buildStyleMapInstruction(valueConverter){if(this._styleMapInput)return this._buildMapBasedInstruction(valueConverter,
false,this._styleMapInput);return null}_buildMapBasedInstruction(valueConverter,isClassBased,stylingInput){let totalBindingSlotsRequired=MIN_STYLING_BINDING_SLOTS_REQUIRED;const mapValue=stylingInput.value.visit(valueConverter);let reference;if(mapValue instanceof Interpolation){totalBindingSlotsRequired+=mapValue.expressions.length;reference=isClassBased?getClassMapInterpolationExpression(mapValue):getStyleMapInterpolationExpression(mapValue)}else reference=isClassBased?Identifiers$1.classMap:Identifiers$1.styleMap;
return{reference,calls:[{supportsInterpolation:true,sourceSpan:stylingInput.sourceSpan,allocateBindingSlots:totalBindingSlotsRequired,params:convertFn=>{const convertResult=convertFn(mapValue);const params=Array.isArray(convertResult)?convertResult:[convertResult];return params}}]}}_buildSingleInputs(reference,inputs,valueConverter,getInterpolationExpressionFn,isClassBased){const instructions=[];inputs.forEach(input=>{const previousInstruction=instructions[instructions.length-1];const value=input.value.visit(valueConverter);
let referenceForCall=reference;let totalBindingSlotsRequired=MIN_STYLING_BINDING_SLOTS_REQUIRED;if(value instanceof Interpolation){totalBindingSlotsRequired+=value.expressions.length;if(getInterpolationExpressionFn)referenceForCall=getInterpolationExpressionFn(value)}const call={sourceSpan:input.sourceSpan,allocateBindingSlots:totalBindingSlotsRequired,supportsInterpolation:!!getInterpolationExpressionFn,params:convertFn=>{const params=[];params.push(literal(input.name));const convertResult=convertFn(value);
if(Array.isArray(convertResult))params.push(...convertResult);else params.push(convertResult);if(!isClassBased&&input.suffix!==null)params.push(literal(input.suffix));return params}};if(previousInstruction&&previousInstruction.reference===referenceForCall)previousInstruction.calls.push(call);else instructions.push({reference:referenceForCall,calls:[call]})});return instructions}_buildClassInputs(valueConverter){if(this._singleClassInputs)return this._buildSingleInputs(Identifiers$1.classProp,this._singleClassInputs,
valueConverter,null,true);return[]}_buildStyleInputs(valueConverter){if(this._singleStyleInputs)return this._buildSingleInputs(Identifiers$1.styleProp,this._singleStyleInputs,valueConverter,getStylePropInterpolationExpression,false);return[]}buildUpdateLevelInstructions(valueConverter){const instructions=[];if(this.hasBindings){const styleMapInstruction=this.buildStyleMapInstruction(valueConverter);if(styleMapInstruction)instructions.push(styleMapInstruction);const classMapInstruction=this.buildClassMapInstruction(valueConverter);
if(classMapInstruction)instructions.push(classMapInstruction);instructions.push(...this._buildStyleInputs(valueConverter));instructions.push(...this._buildClassInputs(valueConverter))}return instructions}}function registerIntoMap(map,key){if(!map.has(key))map.set(key,map.size)}function parseProperty(name){let hasOverrideFlag=false;const overrideIndex=name.indexOf(IMPORTANT_FLAG);if(overrideIndex!==-1){name=overrideIndex>0?name.substring(0,overrideIndex):"";hasOverrideFlag=true}let suffix=null;let property=
name;const unitIndex=name.lastIndexOf(".");if(unitIndex>0){suffix=name.substr(unitIndex+1);property=name.substring(0,unitIndex)}return{property,suffix,hasOverrideFlag}}function getClassMapInterpolationExpression(interpolation){switch(getInterpolationArgsLength(interpolation)){case 1:return Identifiers$1.classMap;case 3:return Identifiers$1.classMapInterpolate1;case 5:return Identifiers$1.classMapInterpolate2;case 7:return Identifiers$1.classMapInterpolate3;case 9:return Identifiers$1.classMapInterpolate4;
case 11:return Identifiers$1.classMapInterpolate5;case 13:return Identifiers$1.classMapInterpolate6;case 15:return Identifiers$1.classMapInterpolate7;case 17:return Identifiers$1.classMapInterpolate8;default:return Identifiers$1.classMapInterpolateV}}function getStyleMapInterpolationExpression(interpolation){switch(getInterpolationArgsLength(interpolation)){case 1:return Identifiers$1.styleMap;case 3:return Identifiers$1.styleMapInterpolate1;case 5:return Identifiers$1.styleMapInterpolate2;case 7:return Identifiers$1.styleMapInterpolate3;
case 9:return Identifiers$1.styleMapInterpolate4;case 11:return Identifiers$1.styleMapInterpolate5;case 13:return Identifiers$1.styleMapInterpolate6;case 15:return Identifiers$1.styleMapInterpolate7;case 17:return Identifiers$1.styleMapInterpolate8;default:return Identifiers$1.styleMapInterpolateV}}function getStylePropInterpolationExpression(interpolation){switch(getInterpolationArgsLength(interpolation)){case 1:return Identifiers$1.styleProp;case 3:return Identifiers$1.stylePropInterpolate1;case 5:return Identifiers$1.stylePropInterpolate2;
case 7:return Identifiers$1.stylePropInterpolate3;case 9:return Identifiers$1.stylePropInterpolate4;case 11:return Identifiers$1.stylePropInterpolate5;case 13:return Identifiers$1.stylePropInterpolate6;case 15:return Identifiers$1.stylePropInterpolate7;case 17:return Identifiers$1.stylePropInterpolate8;default:return Identifiers$1.stylePropInterpolateV}}function isCssCustomProperty(name){return name.startsWith("--")}function isEmptyExpression(ast){if(ast instanceof ASTWithSource)ast=ast.ast;return ast instanceof
EmptyExpr}exports.TokenType=void 0;(function(TokenType){TokenType[TokenType["Character"]=0]="Character";TokenType[TokenType["Identifier"]=1]="Identifier";TokenType[TokenType["PrivateIdentifier"]=2]="PrivateIdentifier";TokenType[TokenType["Keyword"]=3]="Keyword";TokenType[TokenType["String"]=4]="String";TokenType[TokenType["Operator"]=5]="Operator";TokenType[TokenType["Number"]=6]="Number";TokenType[TokenType["Error"]=7]="Error"})(exports.TokenType||(exports.TokenType={}));const KEYWORDS=["var","let",
"as","null","undefined","true","false","if","else","this"];class Lexer{tokenize(text){const scanner=new _Scanner(text);const tokens=[];let token=scanner.scanToken();while(token!=null){tokens.push(token);token=scanner.scanToken()}return tokens}}class Token{constructor(index,end,type,numValue,strValue){this.index=index;this.end=end;this.type=type;this.numValue=numValue;this.strValue=strValue}isCharacter(code){return this.type==exports.TokenType.Character&&this.numValue==code}isNumber(){return this.type==
exports.TokenType.Number}isString(){return this.type==exports.TokenType.String}isOperator(operator){return this.type==exports.TokenType.Operator&&this.strValue==operator}isIdentifier(){return this.type==exports.TokenType.Identifier}isPrivateIdentifier(){return this.type==exports.TokenType.PrivateIdentifier}isKeyword(){return this.type==exports.TokenType.Keyword}isKeywordLet(){return this.type==exports.TokenType.Keyword&&this.strValue=="let"}isKeywordAs(){return this.type==exports.TokenType.Keyword&&
this.strValue=="as"}isKeywordNull(){return this.type==exports.TokenType.Keyword&&this.strValue=="null"}isKeywordUndefined(){return this.type==exports.TokenType.Keyword&&this.strValue=="undefined"}isKeywordTrue(){return this.type==exports.TokenType.Keyword&&this.strValue=="true"}isKeywordFalse(){return this.type==exports.TokenType.Keyword&&this.strValue=="false"}isKeywordThis(){return this.type==exports.TokenType.Keyword&&this.strValue=="this"}isError(){return this.type==exports.TokenType.Error}toNumber(){return this.type==
exports.TokenType.Number?this.numValue:-1}toString(){switch(this.type){case exports.TokenType.Character:case exports.TokenType.Identifier:case exports.TokenType.Keyword:case exports.TokenType.Operator:case exports.TokenType.PrivateIdentifier:case exports.TokenType.String:case exports.TokenType.Error:return this.strValue;case exports.TokenType.Number:return this.numValue.toString();default:return null}}}function newCharacterToken(index,end,code){return new Token(index,end,exports.TokenType.Character,
code,String.fromCharCode(code))}function newIdentifierToken(index,end,text){return new Token(index,end,exports.TokenType.Identifier,0,text)}function newPrivateIdentifierToken(index,end,text){return new Token(index,end,exports.TokenType.PrivateIdentifier,0,text)}function newKeywordToken(index,end,text){return new Token(index,end,exports.TokenType.Keyword,0,text)}function newOperatorToken(index,end,text){return new Token(index,end,exports.TokenType.Operator,0,text)}function newStringToken(index,end,
text){return new Token(index,end,exports.TokenType.String,0,text)}function newNumberToken(index,end,n){return new Token(index,end,exports.TokenType.Number,n,"")}function newErrorToken(index,end,message){return new Token(index,end,exports.TokenType.Error,0,message)}const EOF=new Token(-1,-1,exports.TokenType.Character,0,"");class _Scanner{constructor(input){this.input=input;this.peek=0;this.index=-1;this.length=input.length;this.advance()}advance(){this.peek=++this.index>=this.length?$EOF:this.input.charCodeAt(this.index)}scanToken(){const input=
this.input,length=this.length;let peek=this.peek,index=this.index;while(peek<=$SPACE)if(++index>=length){peek=$EOF;break}else peek=input.charCodeAt(index);this.peek=peek;this.index=index;if(index>=length)return null;if(isIdentifierStart(peek))return this.scanIdentifier();if(isDigit(peek))return this.scanNumber(index);const start=index;switch(peek){case $PERIOD:this.advance();return isDigit(this.peek)?this.scanNumber(start):newCharacterToken(start,this.index,$PERIOD);case $LPAREN:case $RPAREN:case $LBRACE:case $RBRACE:case $LBRACKET:case $RBRACKET:case $COMMA:case $COLON:case $SEMICOLON:return this.scanCharacter(start,
peek);case $SQ:case $DQ:return this.scanString();case $HASH:return this.scanPrivateIdentifier();case $PLUS:case $MINUS:case $STAR:case $SLASH:case $PERCENT:case $CARET:return this.scanOperator(start,String.fromCharCode(peek));case $QUESTION:return this.scanQuestion(start);case $LT:case $GT:return this.scanComplexOperator(start,String.fromCharCode(peek),$EQ,"=");case $BANG:case $EQ:return this.scanComplexOperator(start,String.fromCharCode(peek),$EQ,"=",$EQ,"=");case $AMPERSAND:return this.scanComplexOperator(start,
"&",$AMPERSAND,"&");case $BAR:return this.scanComplexOperator(start,"|",$BAR,"|");case $NBSP:while(isWhitespace(this.peek))this.advance();return this.scanToken()}this.advance();return this.error(`Unexpected character [${String.fromCharCode(peek)}]`,0)}scanCharacter(start,code){this.advance();return newCharacterToken(start,this.index,code)}scanOperator(start,str){this.advance();return newOperatorToken(start,this.index,str)}scanComplexOperator(start,one,twoCode,two,threeCode,three){this.advance();let str=
one;if(this.peek==twoCode){this.advance();str+=two}if(threeCode!=null&&this.peek==threeCode){this.advance();str+=three}return newOperatorToken(start,this.index,str)}scanIdentifier(){const start=this.index;this.advance();while(isIdentifierPart(this.peek))this.advance();const str=this.input.substring(start,this.index);return KEYWORDS.indexOf(str)>-1?newKeywordToken(start,this.index,str):newIdentifierToken(start,this.index,str)}scanPrivateIdentifier(){const start=this.index;this.advance();if(!isIdentifierStart(this.peek))return this.error("Invalid character [#]",
-1);while(isIdentifierPart(this.peek))this.advance();const identifierName=this.input.substring(start,this.index);return newPrivateIdentifierToken(start,this.index,identifierName)}scanNumber(start){let simple=this.index===start;let hasSeparators=false;this.advance();while(true){if(isDigit(this.peek));else if(this.peek===$_){if(!isDigit(this.input.charCodeAt(this.index-1))||!isDigit(this.input.charCodeAt(this.index+1)))return this.error("Invalid numeric separator",0);hasSeparators=true}else if(this.peek===
$PERIOD)simple=false;else if(isExponentStart(this.peek)){this.advance();if(isExponentSign(this.peek))this.advance();if(!isDigit(this.peek))return this.error("Invalid exponent",-1);simple=false}else break;this.advance()}let str=this.input.substring(start,this.index);if(hasSeparators)str=str.replace(/_/g,"");const value=simple?parseIntAutoRadix(str):parseFloat(str);return newNumberToken(start,this.index,value)}scanString(){const start=this.index;const quote=this.peek;this.advance();let buffer="";let marker=
this.index;const input=this.input;while(this.peek!=quote)if(this.peek==$BACKSLASH){buffer+=input.substring(marker,this.index);this.advance();let unescapedCode;this.peek=this.peek;if(this.peek==$u){const hex=input.substring(this.index+1,this.index+5);if(/^[0-9a-f]+$/i.test(hex))unescapedCode=parseInt(hex,16);else return this.error(`Invalid unicode escape [\\u${hex}]`,0);for(let i=0;i<5;i++)this.advance()}else{unescapedCode=unescape(this.peek);this.advance()}buffer+=String.fromCharCode(unescapedCode);
marker=this.index}else if(this.peek==$EOF)return this.error("Unterminated quote",0);else this.advance();const last=input.substring(marker,this.index);this.advance();return newStringToken(start,this.index,buffer+last)}scanQuestion(start){this.advance();let str="?";if(this.peek===$QUESTION||this.peek===$PERIOD){str+=this.peek===$PERIOD?".":"?";this.advance()}return newOperatorToken(start,this.index,str)}error(message,offset){const position=this.index+offset;return newErrorToken(position,this.index,
`Lexer Error: ${message} at column ${position} in expression [${this.input}]`)}}function isIdentifierStart(code){return $a<=code&&code<=$z||$A<=code&&code<=$Z||code==$_||code==$$}function isIdentifier(input){if(input.length==0)return false;const scanner=new _Scanner(input);if(!isIdentifierStart(scanner.peek))return false;scanner.advance();while(scanner.peek!==$EOF){if(!isIdentifierPart(scanner.peek))return false;scanner.advance()}return true}function isIdentifierPart(code){return isAsciiLetter(code)||
isDigit(code)||code==$_||code==$$}function isExponentStart(code){return code==$e||code==$E}function isExponentSign(code){return code==$MINUS||code==$PLUS}function unescape(code){switch(code){case $n:return $LF;case $f:return $FF;case $r:return $CR;case $t:return $TAB;case $v:return $VTAB;default:return code}}function parseIntAutoRadix(text){const result=parseInt(text);if(isNaN(result))throw new Error("Invalid integer literal when parsing "+text);return result}class SplitInterpolation{constructor(strings,
expressions,offsets){this.strings=strings;this.expressions=expressions;this.offsets=offsets}}class TemplateBindingParseResult{constructor(templateBindings,warnings,errors){this.templateBindings=templateBindings;this.warnings=warnings;this.errors=errors}}class Parser$1{constructor(_lexer){this._lexer=_lexer;this.errors=[]}parseAction(input,location,absoluteOffset,interpolationConfig=DEFAULT_INTERPOLATION_CONFIG){this._checkNoInterpolation(input,location,interpolationConfig);const sourceToLex=this._stripComments(input);
const tokens=this._lexer.tokenize(sourceToLex);const ast=(new _ParseAST(input,location,absoluteOffset,tokens,sourceToLex.length,true,this.errors,0)).parseChain();return new ASTWithSource(ast,input,location,absoluteOffset,this.errors)}parseBinding(input,location,absoluteOffset,interpolationConfig=DEFAULT_INTERPOLATION_CONFIG){const ast=this._parseBindingAst(input,location,absoluteOffset,interpolationConfig);return new ASTWithSource(ast,input,location,absoluteOffset,this.errors)}checkSimpleExpression(ast){const checker=
new SimpleExpressionChecker;ast.visit(checker);return checker.errors}parseSimpleBinding(input,location,absoluteOffset,interpolationConfig=DEFAULT_INTERPOLATION_CONFIG){const ast=this._parseBindingAst(input,location,absoluteOffset,interpolationConfig);const errors=this.checkSimpleExpression(ast);if(errors.length>0)this._reportError(`Host binding expression cannot contain ${errors.join(" ")}`,input,location);return new ASTWithSource(ast,input,location,absoluteOffset,this.errors)}_reportError(message,
input,errLocation,ctxLocation){this.errors.push(new ParserError(message,input,errLocation,ctxLocation))}_parseBindingAst(input,location,absoluteOffset,interpolationConfig){const quote=this._parseQuote(input,location,absoluteOffset);if(quote!=null)return quote;this._checkNoInterpolation(input,location,interpolationConfig);const sourceToLex=this._stripComments(input);const tokens=this._lexer.tokenize(sourceToLex);return(new _ParseAST(input,location,absoluteOffset,tokens,sourceToLex.length,false,this.errors,
0)).parseChain()}_parseQuote(input,location,absoluteOffset){if(input==null)return null;const prefixSeparatorIndex=input.indexOf(":");if(prefixSeparatorIndex==-1)return null;const prefix=input.substring(0,prefixSeparatorIndex).trim();if(!isIdentifier(prefix))return null;const uninterpretedExpression=input.substring(prefixSeparatorIndex+1);const span=new ParseSpan(0,input.length);return new Quote(span,span.toAbsolute(absoluteOffset),prefix,uninterpretedExpression,location)}parseTemplateBindings(templateKey,
templateValue,templateUrl,absoluteKeyOffset,absoluteValueOffset){const tokens=this._lexer.tokenize(templateValue);const parser=new _ParseAST(templateValue,templateUrl,absoluteValueOffset,tokens,templateValue.length,false,this.errors,0);return parser.parseTemplateBindings({source:templateKey,span:new AbsoluteSourceSpan(absoluteKeyOffset,absoluteKeyOffset+templateKey.length)})}parseInterpolation(input,location,absoluteOffset,interpolationConfig=DEFAULT_INTERPOLATION_CONFIG){const {strings,expressions,
offsets}=this.splitInterpolation(input,location,interpolationConfig);if(expressions.length===0)return null;const expressionNodes=[];for(let i=0;i<expressions.length;++i){const expressionText=expressions[i].text;const sourceToLex=this._stripComments(expressionText);const tokens=this._lexer.tokenize(sourceToLex);const ast=(new _ParseAST(input,location,absoluteOffset,tokens,sourceToLex.length,false,this.errors,offsets[i])).parseChain();expressionNodes.push(ast)}return this.createInterpolationAst(strings.map(s=>
s.text),expressionNodes,input,location,absoluteOffset)}parseInterpolationExpression(expression,location,absoluteOffset){const sourceToLex=this._stripComments(expression);const tokens=this._lexer.tokenize(sourceToLex);const ast=(new _ParseAST(expression,location,absoluteOffset,tokens,sourceToLex.length,false,this.errors,0)).parseChain();const strings=["",""];return this.createInterpolationAst(strings,[ast],expression,location,absoluteOffset)}createInterpolationAst(strings,expressions,input,location,
absoluteOffset){const span=new ParseSpan(0,input.length);const interpolation=new Interpolation(span,span.toAbsolute(absoluteOffset),strings,expressions);return new ASTWithSource(interpolation,input,location,absoluteOffset,this.errors)}splitInterpolation(input,location,interpolationConfig=DEFAULT_INTERPOLATION_CONFIG){const strings=[];const expressions=[];const offsets=[];let i=0;let atInterpolation=false;let extendLastString=false;let {start:interpStart,end:interpEnd}=interpolationConfig;while(i<
input.length)if(!atInterpolation){const start=i;i=input.indexOf(interpStart,i);if(i===-1)i=input.length;const text=input.substring(start,i);strings.push({text,start,end:i});atInterpolation=true}else{const fullStart=i;const exprStart=fullStart+interpStart.length;const exprEnd=this._getInterpolationEndIndex(input,interpEnd,exprStart);if(exprEnd===-1){atInterpolation=false;extendLastString=true;break}const fullEnd=exprEnd+interpEnd.length;const text=input.substring(exprStart,exprEnd);if(text.trim().length===
0)this._reportError("Blank expressions are not allowed in interpolated strings",input,`at column ${i} in`,location);expressions.push({text,start:fullStart,end:fullEnd});offsets.push(exprStart);i=fullEnd;atInterpolation=false}if(!atInterpolation)if(extendLastString){const piece=strings[strings.length-1];piece.text+=input.substring(i);piece.end=input.length}else strings.push({text:input.substring(i),start:i,end:input.length});return new SplitInterpolation(strings,expressions,offsets)}wrapLiteralPrimitive(input,
location,absoluteOffset){const span=new ParseSpan(0,input==null?0:input.length);return new ASTWithSource(new LiteralPrimitive(span,span.toAbsolute(absoluteOffset),input),input,location,absoluteOffset,this.errors)}_stripComments(input){const i=this._commentStart(input);return i!=null?input.substring(0,i).trim():input}_commentStart(input){let outerQuote=null;for(let i=0;i<input.length-1;i++){const char=input.charCodeAt(i);const nextChar=input.charCodeAt(i+1);if(char===$SLASH&&nextChar==$SLASH&&outerQuote==
null)return i;if(outerQuote===char)outerQuote=null;else if(outerQuote==null&&isQuote(char))outerQuote=char}return null}_checkNoInterpolation(input,location,{start,end}){let startIndex=-1;let endIndex=-1;for(const charIndex of this._forEachUnquotedChar(input,0))if(startIndex===-1){if(input.startsWith(start))startIndex=charIndex}else{endIndex=this._getInterpolationEndIndex(input,end,charIndex);if(endIndex>-1)break}if(startIndex>-1&&endIndex>-1)this._reportError(`Got interpolation (${start}${end}) where expression was expected`,
input,`at column ${startIndex} in`,location)}_getInterpolationEndIndex(input,expressionEnd,start){for(const charIndex of this._forEachUnquotedChar(input,start)){if(input.startsWith(expressionEnd,charIndex))return charIndex;if(input.startsWith("//",charIndex))return input.indexOf(expressionEnd,charIndex)}return-1}*_forEachUnquotedChar(input,start){let currentQuote=null;let escapeCount=0;for(let i=start;i<input.length;i++){const char=input[i];if(isQuote(input.charCodeAt(i))&&(currentQuote===null||currentQuote===
char)&&escapeCount%2===0)currentQuote=currentQuote===null?char:null;else if(currentQuote===null)yield i;escapeCount=char==="\\"?escapeCount+1:0}}}var ParseContextFlags;(function(ParseContextFlags){ParseContextFlags[ParseContextFlags["None"]=0]="None";ParseContextFlags[ParseContextFlags["Writable"]=1]="Writable"})(ParseContextFlags||(ParseContextFlags={}));class _ParseAST{constructor(input,location,absoluteOffset,tokens,inputLength,parseAction,errors,offset){this.input=input;this.location=location;
this.absoluteOffset=absoluteOffset;this.tokens=tokens;this.inputLength=inputLength;this.parseAction=parseAction;this.errors=errors;this.offset=offset;this.rparensExpected=0;this.rbracketsExpected=0;this.rbracesExpected=0;this.context=ParseContextFlags.None;this.sourceSpanCache=new Map;this.index=0}peek(offset){const i=this.index+offset;return i<this.tokens.length?this.tokens[i]:EOF}get next(){return this.peek(0)}get atEOF(){return this.index>=this.tokens.length}get inputIndex(){return this.atEOF?
this.currentEndIndex:this.next.index+this.offset}get currentEndIndex(){if(this.index>0){const curToken=this.peek(-1);return curToken.end+this.offset}if(this.tokens.length===0)return this.inputLength+this.offset;return this.next.index+this.offset}get currentAbsoluteOffset(){return this.absoluteOffset+this.inputIndex}span(start,artificialEndIndex){let endIndex=this.currentEndIndex;if(artificialEndIndex!==undefined&&artificialEndIndex>this.currentEndIndex)endIndex=artificialEndIndex;if(start>endIndex){const tmp=
endIndex;endIndex=start;start=tmp}return new ParseSpan(start,endIndex)}sourceSpan(start,artificialEndIndex){const serial=`${start}@${this.inputIndex}:${artificialEndIndex}`;if(!this.sourceSpanCache.has(serial))this.sourceSpanCache.set(serial,this.span(start,artificialEndIndex).toAbsolute(this.absoluteOffset));return this.sourceSpanCache.get(serial)}advance(){this.index++}withContext(context,cb){this.context|=context;const ret=cb();this.context^=context;return ret}consumeOptionalCharacter(code){if(this.next.isCharacter(code)){this.advance();
return true}else return false}peekKeywordLet(){return this.next.isKeywordLet()}peekKeywordAs(){return this.next.isKeywordAs()}expectCharacter(code){if(this.consumeOptionalCharacter(code))return;this.error(`Missing expected ${String.fromCharCode(code)}`)}consumeOptionalOperator(op){if(this.next.isOperator(op)){this.advance();return true}else return false}expectOperator(operator){if(this.consumeOptionalOperator(operator))return;this.error(`Missing expected operator ${operator}`)}prettyPrintToken(tok){return tok===
EOF?"end of input":`token ${tok}`}expectIdentifierOrKeyword(){const n=this.next;if(!n.isIdentifier()&&!n.isKeyword()){if(n.isPrivateIdentifier())this._reportErrorForPrivateIdentifier(n,"expected identifier or keyword");else this.error(`Unexpected ${this.prettyPrintToken(n)}, expected identifier or keyword`);return null}this.advance();return n.toString()}expectIdentifierOrKeywordOrString(){const n=this.next;if(!n.isIdentifier()&&!n.isKeyword()&&!n.isString()){if(n.isPrivateIdentifier())this._reportErrorForPrivateIdentifier(n,
"expected identifier, keyword or string");else this.error(`Unexpected ${this.prettyPrintToken(n)}, expected identifier, keyword, or string`);return""}this.advance();return n.toString()}parseChain(){const exprs=[];const start=this.inputIndex;while(this.index<this.tokens.length){const expr=this.parsePipe();exprs.push(expr);if(this.consumeOptionalCharacter($SEMICOLON)){if(!this.parseAction)this.error("Binding expression cannot contain chained expression");while(this.consumeOptionalCharacter($SEMICOLON));
}else if(this.index<this.tokens.length)this.error(`Unexpected token '${this.next}'`)}if(exprs.length==0){const artificialStart=this.offset;const artificialEnd=this.offset+this.inputLength;return new EmptyExpr(this.span(artificialStart,artificialEnd),this.sourceSpan(artificialStart,artificialEnd))}if(exprs.length==1)return exprs[0];return new Chain(this.span(start),this.sourceSpan(start),exprs)}parsePipe(){const start=this.inputIndex;let result=this.parseExpression();if(this.consumeOptionalOperator("|")){if(this.parseAction)this.error("Cannot have a pipe in an action expression");
do{const nameStart=this.inputIndex;let nameId=this.expectIdentifierOrKeyword();let nameSpan;let fullSpanEnd=undefined;if(nameId!==null)nameSpan=this.sourceSpan(nameStart);else{nameId="";fullSpanEnd=this.next.index!==-1?this.next.index:this.inputLength+this.offset;nameSpan=(new ParseSpan(fullSpanEnd,fullSpanEnd)).toAbsolute(this.absoluteOffset)}const args=[];while(this.consumeOptionalCharacter($COLON))args.push(this.parseExpression());result=new BindingPipe(this.span(start),this.sourceSpan(start,fullSpanEnd),
result,nameId,args,nameSpan)}while(this.consumeOptionalOperator("|"))}return result}parseExpression(){return this.parseConditional()}parseConditional(){const start=this.inputIndex;const result=this.parseLogicalOr();if(this.consumeOptionalOperator("?")){const yes=this.parsePipe();let no;if(!this.consumeOptionalCharacter($COLON)){const end=this.inputIndex;const expression=this.input.substring(start,end);this.error(`Conditional expression ${expression} requires all 3 expressions`);no=new EmptyExpr(this.span(start),
this.sourceSpan(start))}else no=this.parsePipe();return new Conditional(this.span(start),this.sourceSpan(start),result,yes,no)}else return result}parseLogicalOr(){const start=this.inputIndex;let result=this.parseLogicalAnd();while(this.consumeOptionalOperator("||")){const right=this.parseLogicalAnd();result=new Binary(this.span(start),this.sourceSpan(start),"||",result,right)}return result}parseLogicalAnd(){const start=this.inputIndex;let result=this.parseNullishCoalescing();while(this.consumeOptionalOperator("&&")){const right=
this.parseNullishCoalescing();result=new Binary(this.span(start),this.sourceSpan(start),"&&",result,right)}return result}parseNullishCoalescing(){const start=this.inputIndex;let result=this.parseEquality();while(this.consumeOptionalOperator("??")){const right=this.parseEquality();result=new Binary(this.span(start),this.sourceSpan(start),"??",result,right)}return result}parseEquality(){const start=this.inputIndex;let result=this.parseRelational();while(this.next.type==exports.TokenType.Operator){const operator=
this.next.strValue;switch(operator){case "==":case "===":case "!=":case "!==":this.advance();const right=this.parseRelational();result=new Binary(this.span(start),this.sourceSpan(start),operator,result,right);continue}break}return result}parseRelational(){const start=this.inputIndex;let result=this.parseAdditive();while(this.next.type==exports.TokenType.Operator){const operator=this.next.strValue;switch(operator){case "<":case ">":case "<=":case ">=":this.advance();const right=this.parseAdditive();
result=new Binary(this.span(start),this.sourceSpan(start),operator,result,right);continue}break}return result}parseAdditive(){const start=this.inputIndex;let result=this.parseMultiplicative();while(this.next.type==exports.TokenType.Operator){const operator=this.next.strValue;switch(operator){case "+":case "-":this.advance();let right=this.parseMultiplicative();result=new Binary(this.span(start),this.sourceSpan(start),operator,result,right);continue}break}return result}parseMultiplicative(){const start=
this.inputIndex;let result=this.parsePrefix();while(this.next.type==exports.TokenType.Operator){const operator=this.next.strValue;switch(operator){case "*":case "%":case "/":this.advance();let right=this.parsePrefix();result=new Binary(this.span(start),this.sourceSpan(start),operator,result,right);continue}break}return result}parsePrefix(){if(this.next.type==exports.TokenType.Operator){const start=this.inputIndex;const operator=this.next.strValue;let result;switch(operator){case "+":this.advance();
result=this.parsePrefix();return Unary.createPlus(this.span(start),this.sourceSpan(start),result);case "-":this.advance();result=this.parsePrefix();return Unary.createMinus(this.span(start),this.sourceSpan(start),result);case "!":this.advance();result=this.parsePrefix();return new PrefixNot(this.span(start),this.sourceSpan(start),result)}}return this.parseCallChain()}parseCallChain(){const start=this.inputIndex;let result=this.parsePrimary();while(true)if(this.consumeOptionalCharacter($PERIOD))result=
this.parseAccessMemberOrCall(result,start,false);else if(this.consumeOptionalOperator("?."))result=this.consumeOptionalCharacter($LBRACKET)?this.parseKeyedReadOrWrite(result,start,true):this.parseAccessMemberOrCall(result,start,true);else if(this.consumeOptionalCharacter($LBRACKET))result=this.parseKeyedReadOrWrite(result,start,false);else if(this.consumeOptionalCharacter($LPAREN)){const argumentStart=this.inputIndex;this.rparensExpected++;const args=this.parseCallArguments();const argumentSpan=this.span(argumentStart,
this.inputIndex).toAbsolute(this.absoluteOffset);this.rparensExpected--;this.expectCharacter($RPAREN);result=new Call(this.span(start),this.sourceSpan(start),result,args,argumentSpan)}else if(this.consumeOptionalOperator("!"))result=new NonNullAssert(this.span(start),this.sourceSpan(start),result);else return result}parsePrimary(){const start=this.inputIndex;if(this.consumeOptionalCharacter($LPAREN)){this.rparensExpected++;const result=this.parsePipe();this.rparensExpected--;this.expectCharacter($RPAREN);
return result}else if(this.next.isKeywordNull()){this.advance();return new LiteralPrimitive(this.span(start),this.sourceSpan(start),null)}else if(this.next.isKeywordUndefined()){this.advance();return new LiteralPrimitive(this.span(start),this.sourceSpan(start),void 0)}else if(this.next.isKeywordTrue()){this.advance();return new LiteralPrimitive(this.span(start),this.sourceSpan(start),true)}else if(this.next.isKeywordFalse()){this.advance();return new LiteralPrimitive(this.span(start),this.sourceSpan(start),
false)}else if(this.next.isKeywordThis()){this.advance();return new ThisReceiver(this.span(start),this.sourceSpan(start))}else if(this.consumeOptionalCharacter($LBRACKET)){this.rbracketsExpected++;const elements=this.parseExpressionList($RBRACKET);this.rbracketsExpected--;this.expectCharacter($RBRACKET);return new LiteralArray(this.span(start),this.sourceSpan(start),elements)}else if(this.next.isCharacter($LBRACE))return this.parseLiteralMap();else if(this.next.isIdentifier())return this.parseAccessMemberOrCall(new ImplicitReceiver(this.span(start),
this.sourceSpan(start)),start,false);else if(this.next.isNumber()){const value=this.next.toNumber();this.advance();return new LiteralPrimitive(this.span(start),this.sourceSpan(start),value)}else if(this.next.isString()){const literalValue=this.next.toString();this.advance();return new LiteralPrimitive(this.span(start),this.sourceSpan(start),literalValue)}else if(this.next.isPrivateIdentifier()){this._reportErrorForPrivateIdentifier(this.next,null);return new EmptyExpr(this.span(start),this.sourceSpan(start))}else if(this.index>=
this.tokens.length){this.error(`Unexpected end of expression: ${this.input}`);return new EmptyExpr(this.span(start),this.sourceSpan(start))}else{this.error(`Unexpected token ${this.next}`);return new EmptyExpr(this.span(start),this.sourceSpan(start))}}parseExpressionList(terminator){const result=[];do if(!this.next.isCharacter(terminator))result.push(this.parsePipe());else break;while(this.consumeOptionalCharacter($COMMA));return result}parseLiteralMap(){const keys=[];const values=[];const start=
this.inputIndex;this.expectCharacter($LBRACE);if(!this.consumeOptionalCharacter($RBRACE)){this.rbracesExpected++;do{const keyStart=this.inputIndex;const quoted=this.next.isString();const key=this.expectIdentifierOrKeywordOrString();keys.push({key,quoted});if(quoted){this.expectCharacter($COLON);values.push(this.parsePipe())}else if(this.consumeOptionalCharacter($COLON))values.push(this.parsePipe());else{const span=this.span(keyStart);const sourceSpan=this.sourceSpan(keyStart);values.push(new PropertyRead(span,
sourceSpan,sourceSpan,new ImplicitReceiver(span,sourceSpan),key))}}while(this.consumeOptionalCharacter($COMMA));this.rbracesExpected--;this.expectCharacter($RBRACE)}return new LiteralMap(this.span(start),this.sourceSpan(start),keys,values)}parseAccessMemberOrCall(readReceiver,start,isSafe){const nameStart=this.inputIndex;const id=this.withContext(ParseContextFlags.Writable,()=>{var _a;const id=(_a=this.expectIdentifierOrKeyword())!==null&&_a!==void 0?_a:"";if(id.length===0)this.error(`Expected identifier for property access`,
readReceiver.span.end);return id});const nameSpan=this.sourceSpan(nameStart);let receiver;if(isSafe)if(this.consumeOptionalOperator("=")){this.error("The '?.' operator cannot be used in the assignment");receiver=new EmptyExpr(this.span(start),this.sourceSpan(start))}else receiver=new SafePropertyRead(this.span(start),this.sourceSpan(start),nameSpan,readReceiver,id);else if(this.consumeOptionalOperator("=")){if(!this.parseAction){this.error("Bindings cannot contain assignments");return new EmptyExpr(this.span(start),
this.sourceSpan(start))}const value=this.parseConditional();receiver=new PropertyWrite(this.span(start),this.sourceSpan(start),nameSpan,readReceiver,id,value)}else receiver=new PropertyRead(this.span(start),this.sourceSpan(start),nameSpan,readReceiver,id);if(this.consumeOptionalCharacter($LPAREN)){const argumentStart=this.inputIndex;this.rparensExpected++;const args=this.parseCallArguments();const argumentSpan=this.span(argumentStart,this.inputIndex).toAbsolute(this.absoluteOffset);this.expectCharacter($RPAREN);
this.rparensExpected--;const span=this.span(start);const sourceSpan=this.sourceSpan(start);return new Call(span,sourceSpan,receiver,args,argumentSpan)}return receiver}parseCallArguments(){if(this.next.isCharacter($RPAREN))return[];const positionals=[];do positionals.push(this.parsePipe());while(this.consumeOptionalCharacter($COMMA));return positionals}expectTemplateBindingKey(){let result="";let operatorFound=false;const start=this.currentAbsoluteOffset;do{result+=this.expectIdentifierOrKeywordOrString();
operatorFound=this.consumeOptionalOperator("-");if(operatorFound)result+="-"}while(operatorFound);return{source:result,span:new AbsoluteSourceSpan(start,start+result.length)}}parseTemplateBindings(templateKey){const bindings=[];bindings.push(...this.parseDirectiveKeywordBindings(templateKey));while(this.index<this.tokens.length){const letBinding=this.parseLetBinding();if(letBinding)bindings.push(letBinding);else{const key=this.expectTemplateBindingKey();const binding=this.parseAsBinding(key);if(binding)bindings.push(binding);
else{key.source=templateKey.source+key.source.charAt(0).toUpperCase()+key.source.substring(1);bindings.push(...this.parseDirectiveKeywordBindings(key))}}this.consumeStatementTerminator()}return new TemplateBindingParseResult(bindings,[],this.errors)}parseKeyedReadOrWrite(receiver,start,isSafe){return this.withContext(ParseContextFlags.Writable,()=>{this.rbracketsExpected++;const key=this.parsePipe();if(key instanceof EmptyExpr)this.error(`Key access cannot be empty`);this.rbracketsExpected--;this.expectCharacter($RBRACKET);
if(this.consumeOptionalOperator("="))if(isSafe)this.error("The '?.' operator cannot be used in the assignment");else{const value=this.parseConditional();return new KeyedWrite(this.span(start),this.sourceSpan(start),receiver,key,value)}else return isSafe?new SafeKeyedRead(this.span(start),this.sourceSpan(start),receiver,key):new KeyedRead(this.span(start),this.sourceSpan(start),receiver,key);return new EmptyExpr(this.span(start),this.sourceSpan(start))})}parseDirectiveKeywordBindings(key){const bindings=
[];this.consumeOptionalCharacter($COLON);const value=this.getDirectiveBoundTarget();let spanEnd=this.currentAbsoluteOffset;const asBinding=this.parseAsBinding(key);if(!asBinding){this.consumeStatementTerminator();spanEnd=this.currentAbsoluteOffset}const sourceSpan=new AbsoluteSourceSpan(key.span.start,spanEnd);bindings.push(new ExpressionBinding(sourceSpan,key,value));if(asBinding)bindings.push(asBinding);return bindings}getDirectiveBoundTarget(){if(this.next===EOF||this.peekKeywordAs()||this.peekKeywordLet())return null;
const ast=this.parsePipe();const {start,end}=ast.span;const value=this.input.substring(start,end);return new ASTWithSource(ast,value,this.location,this.absoluteOffset+start,this.errors)}parseAsBinding(value){if(!this.peekKeywordAs())return null;this.advance();const key=this.expectTemplateBindingKey();this.consumeStatementTerminator();const sourceSpan=new AbsoluteSourceSpan(value.span.start,this.currentAbsoluteOffset);return new VariableBinding(sourceSpan,key,value)}parseLetBinding(){if(!this.peekKeywordLet())return null;
const spanStart=this.currentAbsoluteOffset;this.advance();const key=this.expectTemplateBindingKey();let value=null;if(this.consumeOptionalOperator("="))value=this.expectTemplateBindingKey();this.consumeStatementTerminator();const sourceSpan=new AbsoluteSourceSpan(spanStart,this.currentAbsoluteOffset);return new VariableBinding(sourceSpan,key,value)}consumeStatementTerminator(){this.consumeOptionalCharacter($SEMICOLON)||this.consumeOptionalCharacter($COMMA)}error(message,index=null){this.errors.push(new ParserError(message,
this.input,this.locationText(index),this.location));this.skip()}locationText(index=null){if(index==null)index=this.index;return index<this.tokens.length?`at column ${this.tokens[index].index+1} in`:`at the end of the expression`}_reportErrorForPrivateIdentifier(token,extraMessage){let errorMessage=`Private identifiers are not supported. Unexpected private identifier: ${token}`;if(extraMessage!==null)errorMessage+=`, ${extraMessage}`;this.error(errorMessage)}skip(){let n=this.next;while(this.index<
this.tokens.length&&!n.isCharacter($SEMICOLON)&&!n.isOperator("|")&&(this.rparensExpected<=0||!n.isCharacter($RPAREN))&&(this.rbracesExpected<=0||!n.isCharacter($RBRACE))&&(this.rbracketsExpected<=0||!n.isCharacter($RBRACKET))&&(!(this.context&ParseContextFlags.Writable)||!n.isOperator("="))){if(this.next.isError())this.errors.push(new ParserError(this.next.toString(),this.input,this.locationText(),this.location));this.advance();n=this.next}}}class SimpleExpressionChecker extends RecursiveAstVisitor{constructor(){super(...arguments);
this.errors=[]}visitPipe(){this.errors.push("pipes")}}class NodeWithI18n{constructor(sourceSpan,i18n){this.sourceSpan=sourceSpan;this.i18n=i18n}}class Text extends NodeWithI18n{constructor(value,sourceSpan,tokens,i18n){super(sourceSpan,i18n);this.value=value;this.tokens=tokens}visit(visitor,context){return visitor.visitText(this,context)}}class Expansion extends NodeWithI18n{constructor(switchValue,type,cases,sourceSpan,switchValueSourceSpan,i18n){super(sourceSpan,i18n);this.switchValue=switchValue;
this.type=type;this.cases=cases;this.switchValueSourceSpan=switchValueSourceSpan}visit(visitor,context){return visitor.visitExpansion(this,context)}}class ExpansionCase{constructor(value,expression,sourceSpan,valueSourceSpan,expSourceSpan){this.value=value;this.expression=expression;this.sourceSpan=sourceSpan;this.valueSourceSpan=valueSourceSpan;this.expSourceSpan=expSourceSpan}visit(visitor,context){return visitor.visitExpansionCase(this,context)}}class Attribute extends NodeWithI18n{constructor(name,
value,sourceSpan,keySpan,valueSpan,valueTokens,i18n){super(sourceSpan,i18n);this.name=name;this.value=value;this.keySpan=keySpan;this.valueSpan=valueSpan;this.valueTokens=valueTokens}visit(visitor,context){return visitor.visitAttribute(this,context)}}class Element extends NodeWithI18n{constructor(name,attrs,children,sourceSpan,startSourceSpan,endSourceSpan=null,i18n){super(sourceSpan,i18n);this.name=name;this.attrs=attrs;this.children=children;this.startSourceSpan=startSourceSpan;this.endSourceSpan=
endSourceSpan}visit(visitor,context){return visitor.visitElement(this,context)}}class Comment{constructor(value,sourceSpan){this.value=value;this.sourceSpan=sourceSpan}visit(visitor,context){return visitor.visitComment(this,context)}}function visitAll(visitor,nodes,context=null){const result=[];const visit=visitor.visit?ast=>visitor.visit(ast,context)||ast.visit(visitor,context):ast=>ast.visit(visitor,context);nodes.forEach(ast=>{const astResult=visit(ast);if(astResult)result.push(astResult)});return result}
class RecursiveVisitor{constructor(){}visitElement(ast,context){this.visitChildren(context,visit=>{visit(ast.attrs);visit(ast.children)})}visitAttribute(ast,context){}visitText(ast,context){}visitComment(ast,context){}visitExpansion(ast,context){return this.visitChildren(context,visit=>{visit(ast.cases)})}visitExpansionCase(ast,context){}visitChildren(context,cb){let results=[];let t=this;function visit(children){if(children)results.push(visitAll(t,children,context))}cb(visit);return Array.prototype.concat.apply([],
results)}}const NAMED_ENTITIES={"AElig":"Æ","AMP":"&","amp":"&","Aacute":"Á","Abreve":"Ă","Acirc":"Â","Acy":"А","Afr":"\ud835\udd04","Agrave":"À","Alpha":"Α","Amacr":"Ā","And":"⩓","Aogon":"Ą","Aopf":"\ud835\udd38","ApplyFunction":"⁡","af":"⁡","Aring":"Å","angst":"Å","Ascr":"\ud835\udc9c","Assign":"≔","colone":"≔","coloneq":"≔","Atilde":"Ã","Auml":"Ä","Backslash":"∖","setminus":"∖","setmn":"∖","smallsetminus":"∖","ssetmn":"∖","Barv":"⫧","Barwed":"⌆","doublebarwedge":"⌆","Bcy":"Б","Because":"∵","becaus":"∵",
"because":"∵","Bernoullis":"ℬ","Bscr":"ℬ","bernou":"ℬ","Beta":"Β","Bfr":"\ud835\udd05","Bopf":"\ud835\udd39","Breve":"˘","breve":"˘","Bumpeq":"≎","HumpDownHump":"≎","bump":"≎","CHcy":"Ч","COPY":"©","copy":"©","Cacute":"Ć","Cap":"⋒","CapitalDifferentialD":"ⅅ","DD":"ⅅ","Cayleys":"ℭ","Cfr":"ℭ","Ccaron":"Č","Ccedil":"Ç","Ccirc":"Ĉ","Cconint":"∰","Cdot":"Ċ","Cedilla":"¸","cedil":"¸","CenterDot":"·","centerdot":"·","middot":"·","Chi":"Χ","CircleDot":"⊙","odot":"⊙","CircleMinus":"⊖","ominus":"⊖","CirclePlus":"⊕",
"oplus":"⊕","CircleTimes":"⊗","otimes":"⊗","ClockwiseContourIntegral":"∲","cwconint":"∲","CloseCurlyDoubleQuote":"”","rdquo":"”","rdquor":"”","CloseCurlyQuote":"’","rsquo":"’","rsquor":"’","Colon":"∷","Proportion":"∷","Colone":"⩴","Congruent":"≡","equiv":"≡","Conint":"∯","DoubleContourIntegral":"∯","ContourIntegral":"∮","conint":"∮","oint":"∮","Copf":"ℂ","complexes":"ℂ","Coproduct":"∐","coprod":"∐","CounterClockwiseContourIntegral":"∳","awconint":"∳","Cross":"⨯","Cscr":"\ud835\udc9e","Cup":"⋓","CupCap":"≍",
"asympeq":"≍","DDotrahd":"⤑","DJcy":"Ђ","DScy":"Ѕ","DZcy":"Џ","Dagger":"‡","ddagger":"‡","Darr":"↡","Dashv":"⫤","DoubleLeftTee":"⫤","Dcaron":"Ď","Dcy":"Д","Del":"∇","nabla":"∇","Delta":"Δ","Dfr":"\ud835\udd07","DiacriticalAcute":"´","acute":"´","DiacriticalDot":"˙","dot":"˙","DiacriticalDoubleAcute":"˝","dblac":"˝","DiacriticalGrave":"`","grave":"`","DiacriticalTilde":"˜","tilde":"˜","Diamond":"⋄","diam":"⋄","diamond":"⋄","DifferentialD":"ⅆ","dd":"ⅆ","Dopf":"\ud835\udd3b","Dot":"¨","DoubleDot":"¨",
"die":"¨","uml":"¨","DotDot":"⃜","DotEqual":"≐","doteq":"≐","esdot":"≐","DoubleDownArrow":"⇓","Downarrow":"⇓","dArr":"⇓","DoubleLeftArrow":"⇐","Leftarrow":"⇐","lArr":"⇐","DoubleLeftRightArrow":"⇔","Leftrightarrow":"⇔","hArr":"⇔","iff":"⇔","DoubleLongLeftArrow":"⟸","Longleftarrow":"⟸","xlArr":"⟸","DoubleLongLeftRightArrow":"⟺","Longleftrightarrow":"⟺","xhArr":"⟺","DoubleLongRightArrow":"⟹","Longrightarrow":"⟹","xrArr":"⟹","DoubleRightArrow":"⇒","Implies":"⇒","Rightarrow":"⇒","rArr":"⇒","DoubleRightTee":"⊨",
"vDash":"⊨","DoubleUpArrow":"⇑","Uparrow":"⇑","uArr":"⇑","DoubleUpDownArrow":"⇕","Updownarrow":"⇕","vArr":"⇕","DoubleVerticalBar":"∥","par":"∥","parallel":"∥","shortparallel":"∥","spar":"∥","DownArrow":"↓","ShortDownArrow":"↓","darr":"↓","downarrow":"↓","DownArrowBar":"⤓","DownArrowUpArrow":"⇵","duarr":"⇵","DownBreve":"̑","DownLeftRightVector":"⥐","DownLeftTeeVector":"⥞","DownLeftVector":"↽","leftharpoondown":"↽","lhard":"↽","DownLeftVectorBar":"⥖","DownRightTeeVector":"⥟","DownRightVector":"⇁","rhard":"⇁",
"rightharpoondown":"⇁","DownRightVectorBar":"⥗","DownTee":"⊤","top":"⊤","DownTeeArrow":"↧","mapstodown":"↧","Dscr":"\ud835\udc9f","Dstrok":"Đ","ENG":"Ŋ","ETH":"Ð","Eacute":"É","Ecaron":"Ě","Ecirc":"Ê","Ecy":"Э","Edot":"Ė","Efr":"\ud835\udd08","Egrave":"È","Element":"∈","in":"∈","isin":"∈","isinv":"∈","Emacr":"Ē","EmptySmallSquare":"◻","EmptyVerySmallSquare":"▫","Eogon":"Ę","Eopf":"\ud835\udd3c","Epsilon":"Ε","Equal":"⩵","EqualTilde":"≂","eqsim":"≂","esim":"≂","Equilibrium":"⇌","rightleftharpoons":"⇌",
"rlhar":"⇌","Escr":"ℰ","expectation":"ℰ","Esim":"⩳","Eta":"Η","Euml":"Ë","Exists":"∃","exist":"∃","ExponentialE":"ⅇ","ee":"ⅇ","exponentiale":"ⅇ","Fcy":"Ф","Ffr":"\ud835\udd09","FilledSmallSquare":"◼","FilledVerySmallSquare":"▪","blacksquare":"▪","squarf":"▪","squf":"▪","Fopf":"\ud835\udd3d","ForAll":"∀","forall":"∀","Fouriertrf":"ℱ","Fscr":"ℱ","GJcy":"Ѓ","GT":">","gt":">","Gamma":"Γ","Gammad":"Ϝ","Gbreve":"Ğ","Gcedil":"Ģ","Gcirc":"Ĝ","Gcy":"Г","Gdot":"Ġ","Gfr":"\ud835\udd0a","Gg":"⋙","ggg":"⋙","Gopf":"\ud835\udd3e",
"GreaterEqual":"≥","ge":"≥","geq":"≥","GreaterEqualLess":"⋛","gel":"⋛","gtreqless":"⋛","GreaterFullEqual":"≧","gE":"≧","geqq":"≧","GreaterGreater":"⪢","GreaterLess":"≷","gl":"≷","gtrless":"≷","GreaterSlantEqual":"⩾","geqslant":"⩾","ges":"⩾","GreaterTilde":"≳","gsim":"≳","gtrsim":"≳","Gscr":"\ud835\udca2","Gt":"≫","NestedGreaterGreater":"≫","gg":"≫","HARDcy":"Ъ","Hacek":"ˇ","caron":"ˇ","Hat":"^","Hcirc":"Ĥ","Hfr":"ℌ","Poincareplane":"ℌ","HilbertSpace":"ℋ","Hscr":"ℋ","hamilt":"ℋ","Hopf":"ℍ","quaternions":"ℍ",
"HorizontalLine":"─","boxh":"─","Hstrok":"Ħ","HumpEqual":"≏","bumpe":"≏","bumpeq":"≏","IEcy":"Е","IJlig":"Ĳ","IOcy":"Ё","Iacute":"Í","Icirc":"Î","Icy":"И","Idot":"İ","Ifr":"ℑ","Im":"ℑ","image":"ℑ","imagpart":"ℑ","Igrave":"Ì","Imacr":"Ī","ImaginaryI":"ⅈ","ii":"ⅈ","Int":"∬","Integral":"∫","int":"∫","Intersection":"⋂","bigcap":"⋂","xcap":"⋂","InvisibleComma":"⁣","ic":"⁣","InvisibleTimes":"⁢","it":"⁢","Iogon":"Į","Iopf":"\ud835\udd40","Iota":"Ι","Iscr":"ℐ","imagline":"ℐ","Itilde":"Ĩ","Iukcy":"І","Iuml":"Ï",
"Jcirc":"Ĵ","Jcy":"Й","Jfr":"\ud835\udd0d","Jopf":"\ud835\udd41","Jscr":"\ud835\udca5","Jsercy":"Ј","Jukcy":"Є","KHcy":"Х","KJcy":"Ќ","Kappa":"Κ","Kcedil":"Ķ","Kcy":"К","Kfr":"\ud835\udd0e","Kopf":"\ud835\udd42","Kscr":"\ud835\udca6","LJcy":"Љ","LT":"<","lt":"<","Lacute":"Ĺ","Lambda":"Λ","Lang":"⟪","Laplacetrf":"ℒ","Lscr":"ℒ","lagran":"ℒ","Larr":"↞","twoheadleftarrow":"↞","Lcaron":"Ľ","Lcedil":"Ļ","Lcy":"Л","LeftAngleBracket":"⟨","lang":"⟨","langle":"⟨","LeftArrow":"←","ShortLeftArrow":"←","larr":"←",
"leftarrow":"←","slarr":"←","LeftArrowBar":"⇤","larrb":"⇤","LeftArrowRightArrow":"⇆","leftrightarrows":"⇆","lrarr":"⇆","LeftCeiling":"⌈","lceil":"⌈","LeftDoubleBracket":"⟦","lobrk":"⟦","LeftDownTeeVector":"⥡","LeftDownVector":"⇃","dharl":"⇃","downharpoonleft":"⇃","LeftDownVectorBar":"⥙","LeftFloor":"⌊","lfloor":"⌊","LeftRightArrow":"↔","harr":"↔","leftrightarrow":"↔","LeftRightVector":"⥎","LeftTee":"⊣","dashv":"⊣","LeftTeeArrow":"↤","mapstoleft":"↤","LeftTeeVector":"⥚","LeftTriangle":"⊲","vartriangleleft":"⊲",
"vltri":"⊲","LeftTriangleBar":"⧏","LeftTriangleEqual":"⊴","ltrie":"⊴","trianglelefteq":"⊴","LeftUpDownVector":"⥑","LeftUpTeeVector":"⥠","LeftUpVector":"↿","uharl":"↿","upharpoonleft":"↿","LeftUpVectorBar":"⥘","LeftVector":"↼","leftharpoonup":"↼","lharu":"↼","LeftVectorBar":"⥒","LessEqualGreater":"⋚","leg":"⋚","lesseqgtr":"⋚","LessFullEqual":"≦","lE":"≦","leqq":"≦","LessGreater":"≶","lessgtr":"≶","lg":"≶","LessLess":"⪡","LessSlantEqual":"⩽","leqslant":"⩽","les":"⩽","LessTilde":"≲","lesssim":"≲","lsim":"≲",
"Lfr":"\ud835\udd0f","Ll":"⋘","Lleftarrow":"⇚","lAarr":"⇚","Lmidot":"Ŀ","LongLeftArrow":"⟵","longleftarrow":"⟵","xlarr":"⟵","LongLeftRightArrow":"⟷","longleftrightarrow":"⟷","xharr":"⟷","LongRightArrow":"⟶","longrightarrow":"⟶","xrarr":"⟶","Lopf":"\ud835\udd43","LowerLeftArrow":"↙","swarr":"↙","swarrow":"↙","LowerRightArrow":"↘","searr":"↘","searrow":"↘","Lsh":"↰","lsh":"↰","Lstrok":"Ł","Lt":"≪","NestedLessLess":"≪","ll":"≪","Map":"⤅","Mcy":"М","MediumSpace":" ","Mellintrf":"ℳ","Mscr":"ℳ","phmmat":"ℳ",
"Mfr":"\ud835\udd10","MinusPlus":"∓","mnplus":"∓","mp":"∓","Mopf":"\ud835\udd44","Mu":"Μ","NJcy":"Њ","Nacute":"Ń","Ncaron":"Ň","Ncedil":"Ņ","Ncy":"Н","NegativeMediumSpace":"​","NegativeThickSpace":"​","NegativeThinSpace":"​","NegativeVeryThinSpace":"​","ZeroWidthSpace":"​","NewLine":"\n","Nfr":"\ud835\udd11","NoBreak":"⁠","NonBreakingSpace":" ","nbsp":" ","Nopf":"ℕ","naturals":"ℕ","Not":"⫬","NotCongruent":"≢","nequiv":"≢","NotCupCap":"≭","NotDoubleVerticalBar":"∦","npar":"∦","nparallel":"∦","nshortparallel":"∦",
"nspar":"∦","NotElement":"∉","notin":"∉","notinva":"∉","NotEqual":"≠","ne":"≠","NotEqualTilde":"≂̸","nesim":"≂̸","NotExists":"∄","nexist":"∄","nexists":"∄","NotGreater":"≯","ngt":"≯","ngtr":"≯","NotGreaterEqual":"≱","nge":"≱","ngeq":"≱","NotGreaterFullEqual":"≧̸","ngE":"≧̸","ngeqq":"≧̸","NotGreaterGreater":"≫̸","nGtv":"≫̸","NotGreaterLess":"≹","ntgl":"≹","NotGreaterSlantEqual":"⩾̸","ngeqslant":"⩾̸","nges":"⩾̸","NotGreaterTilde":"≵","ngsim":"≵","NotHumpDownHump":"≎̸","nbump":"≎̸","NotHumpEqual":"≏̸",
"nbumpe":"≏̸","NotLeftTriangle":"⋪","nltri":"⋪","ntriangleleft":"⋪","NotLeftTriangleBar":"⧏̸","NotLeftTriangleEqual":"⋬","nltrie":"⋬","ntrianglelefteq":"⋬","NotLess":"≮","nless":"≮","nlt":"≮","NotLessEqual":"≰","nle":"≰","nleq":"≰","NotLessGreater":"≸","ntlg":"≸","NotLessLess":"≪̸","nLtv":"≪̸","NotLessSlantEqual":"⩽̸","nleqslant":"⩽̸","nles":"⩽̸","NotLessTilde":"≴","nlsim":"≴","NotNestedGreaterGreater":"⪢̸","NotNestedLessLess":"⪡̸","NotPrecedes":"⊀","npr":"⊀","nprec":"⊀","NotPrecedesEqual":"⪯̸","npre":"⪯̸",
"npreceq":"⪯̸","NotPrecedesSlantEqual":"⋠","nprcue":"⋠","NotReverseElement":"∌","notni":"∌","notniva":"∌","NotRightTriangle":"⋫","nrtri":"⋫","ntriangleright":"⋫","NotRightTriangleBar":"⧐̸","NotRightTriangleEqual":"⋭","nrtrie":"⋭","ntrianglerighteq":"⋭","NotSquareSubset":"⊏̸","NotSquareSubsetEqual":"⋢","nsqsube":"⋢","NotSquareSuperset":"⊐̸","NotSquareSupersetEqual":"⋣","nsqsupe":"⋣","NotSubset":"⊂⃒","nsubset":"⊂⃒","vnsub":"⊂⃒","NotSubsetEqual":"⊈","nsube":"⊈","nsubseteq":"⊈","NotSucceeds":"⊁","nsc":"⊁",
"nsucc":"⊁","NotSucceedsEqual":"⪰̸","nsce":"⪰̸","nsucceq":"⪰̸","NotSucceedsSlantEqual":"⋡","nsccue":"⋡","NotSucceedsTilde":"≿̸","NotSuperset":"⊃⃒","nsupset":"⊃⃒","vnsup":"⊃⃒","NotSupersetEqual":"⊉","nsupe":"⊉","nsupseteq":"⊉","NotTilde":"≁","nsim":"≁","NotTildeEqual":"≄","nsime":"≄","nsimeq":"≄","NotTildeFullEqual":"≇","ncong":"≇","NotTildeTilde":"≉","nap":"≉","napprox":"≉","NotVerticalBar":"∤","nmid":"∤","nshortmid":"∤","nsmid":"∤","Nscr":"\ud835\udca9","Ntilde":"Ñ","Nu":"Ν","OElig":"Œ","Oacute":"Ó",
"Ocirc":"Ô","Ocy":"О","Odblac":"Ő","Ofr":"\ud835\udd12","Ograve":"Ò","Omacr":"Ō","Omega":"Ω","ohm":"Ω","Omicron":"Ο","Oopf":"\ud835\udd46","OpenCurlyDoubleQuote":"“","ldquo":"“","OpenCurlyQuote":"‘","lsquo":"‘","Or":"⩔","Oscr":"\ud835\udcaa","Oslash":"Ø","Otilde":"Õ","Otimes":"⨷","Ouml":"Ö","OverBar":"‾","oline":"‾","OverBrace":"⏞","OverBracket":"⎴","tbrk":"⎴","OverParenthesis":"⏜","PartialD":"∂","part":"∂","Pcy":"П","Pfr":"\ud835\udd13","Phi":"Φ","Pi":"Π","PlusMinus":"±","plusmn":"±","pm":"±","Popf":"ℙ",
"primes":"ℙ","Pr":"⪻","Precedes":"≺","pr":"≺","prec":"≺","PrecedesEqual":"⪯","pre":"⪯","preceq":"⪯","PrecedesSlantEqual":"≼","prcue":"≼","preccurlyeq":"≼","PrecedesTilde":"≾","precsim":"≾","prsim":"≾","Prime":"″","Product":"∏","prod":"∏","Proportional":"∝","prop":"∝","propto":"∝","varpropto":"∝","vprop":"∝","Pscr":"\ud835\udcab","Psi":"Ψ","QUOT":'"',"quot":'"',"Qfr":"\ud835\udd14","Qopf":"ℚ","rationals":"ℚ","Qscr":"\ud835\udcac","RBarr":"⤐","drbkarow":"⤐","REG":"®","circledR":"®","reg":"®","Racute":"Ŕ",
"Rang":"⟫","Rarr":"↠","twoheadrightarrow":"↠","Rarrtl":"⤖","Rcaron":"Ř","Rcedil":"Ŗ","Rcy":"Р","Re":"ℜ","Rfr":"ℜ","real":"ℜ","realpart":"ℜ","ReverseElement":"∋","SuchThat":"∋","ni":"∋","niv":"∋","ReverseEquilibrium":"⇋","leftrightharpoons":"⇋","lrhar":"⇋","ReverseUpEquilibrium":"⥯","duhar":"⥯","Rho":"Ρ","RightAngleBracket":"⟩","rang":"⟩","rangle":"⟩","RightArrow":"→","ShortRightArrow":"→","rarr":"→","rightarrow":"→","srarr":"→","RightArrowBar":"⇥","rarrb":"⇥","RightArrowLeftArrow":"⇄","rightleftarrows":"⇄",
"rlarr":"⇄","RightCeiling":"⌉","rceil":"⌉","RightDoubleBracket":"⟧","robrk":"⟧","RightDownTeeVector":"⥝","RightDownVector":"⇂","dharr":"⇂","downharpoonright":"⇂","RightDownVectorBar":"⥕","RightFloor":"⌋","rfloor":"⌋","RightTee":"⊢","vdash":"⊢","RightTeeArrow":"↦","map":"↦","mapsto":"↦","RightTeeVector":"⥛","RightTriangle":"⊳","vartriangleright":"⊳","vrtri":"⊳","RightTriangleBar":"⧐","RightTriangleEqual":"⊵","rtrie":"⊵","trianglerighteq":"⊵","RightUpDownVector":"⥏","RightUpTeeVector":"⥜","RightUpVector":"↾",
"uharr":"↾","upharpoonright":"↾","RightUpVectorBar":"⥔","RightVector":"⇀","rharu":"⇀","rightharpoonup":"⇀","RightVectorBar":"⥓","Ropf":"ℝ","reals":"ℝ","RoundImplies":"⥰","Rrightarrow":"⇛","rAarr":"⇛","Rscr":"ℛ","realine":"ℛ","Rsh":"↱","rsh":"↱","RuleDelayed":"⧴","SHCHcy":"Щ","SHcy":"Ш","SOFTcy":"Ь","Sacute":"Ś","Sc":"⪼","Scaron":"Š","Scedil":"Ş","Scirc":"Ŝ","Scy":"С","Sfr":"\ud835\udd16","ShortUpArrow":"↑","UpArrow":"↑","uarr":"↑","uparrow":"↑","Sigma":"Σ","SmallCircle":"∘","compfn":"∘","Sopf":"\ud835\udd4a",
"Sqrt":"√","radic":"√","Square":"□","squ":"□","square":"□","SquareIntersection":"⊓","sqcap":"⊓","SquareSubset":"⊏","sqsub":"⊏","sqsubset":"⊏","SquareSubsetEqual":"⊑","sqsube":"⊑","sqsubseteq":"⊑","SquareSuperset":"⊐","sqsup":"⊐","sqsupset":"⊐","SquareSupersetEqual":"⊒","sqsupe":"⊒","sqsupseteq":"⊒","SquareUnion":"⊔","sqcup":"⊔","Sscr":"\ud835\udcae","Star":"⋆","sstarf":"⋆","Sub":"⋐","Subset":"⋐","SubsetEqual":"⊆","sube":"⊆","subseteq":"⊆","Succeeds":"≻","sc":"≻","succ":"≻","SucceedsEqual":"⪰","sce":"⪰",
"succeq":"⪰","SucceedsSlantEqual":"≽","sccue":"≽","succcurlyeq":"≽","SucceedsTilde":"≿","scsim":"≿","succsim":"≿","Sum":"∑","sum":"∑","Sup":"⋑","Supset":"⋑","Superset":"⊃","sup":"⊃","supset":"⊃","SupersetEqual":"⊇","supe":"⊇","supseteq":"⊇","THORN":"Þ","TRADE":"™","trade":"™","TSHcy":"Ћ","TScy":"Ц","Tab":"\t","Tau":"Τ","Tcaron":"Ť","Tcedil":"Ţ","Tcy":"Т","Tfr":"\ud835\udd17","Therefore":"∴","there4":"∴","therefore":"∴","Theta":"Θ","ThickSpace":"  ","ThinSpace":" ","thinsp":" ","Tilde":"∼","sim":"∼",
"thicksim":"∼","thksim":"∼","TildeEqual":"≃","sime":"≃","simeq":"≃","TildeFullEqual":"≅","cong":"≅","TildeTilde":"≈","ap":"≈","approx":"≈","asymp":"≈","thickapprox":"≈","thkap":"≈","Topf":"\ud835\udd4b","TripleDot":"⃛","tdot":"⃛","Tscr":"\ud835\udcaf","Tstrok":"Ŧ","Uacute":"Ú","Uarr":"↟","Uarrocir":"⥉","Ubrcy":"Ў","Ubreve":"Ŭ","Ucirc":"Û","Ucy":"У","Udblac":"Ű","Ufr":"\ud835\udd18","Ugrave":"Ù","Umacr":"Ū","UnderBar":"_","lowbar":"_","UnderBrace":"⏟","UnderBracket":"⎵","bbrk":"⎵","UnderParenthesis":"⏝",
"Union":"⋃","bigcup":"⋃","xcup":"⋃","UnionPlus":"⊎","uplus":"⊎","Uogon":"Ų","Uopf":"\ud835\udd4c","UpArrowBar":"⤒","UpArrowDownArrow":"⇅","udarr":"⇅","UpDownArrow":"↕","updownarrow":"↕","varr":"↕","UpEquilibrium":"⥮","udhar":"⥮","UpTee":"⊥","bot":"⊥","bottom":"⊥","perp":"⊥","UpTeeArrow":"↥","mapstoup":"↥","UpperLeftArrow":"↖","nwarr":"↖","nwarrow":"↖","UpperRightArrow":"↗","nearr":"↗","nearrow":"↗","Upsi":"ϒ","upsih":"ϒ","Upsilon":"Υ","Uring":"Ů","Uscr":"\ud835\udcb0","Utilde":"Ũ","Uuml":"Ü","VDash":"⊫",
"Vbar":"⫫","Vcy":"В","Vdash":"⊩","Vdashl":"⫦","Vee":"⋁","bigvee":"⋁","xvee":"⋁","Verbar":"‖","Vert":"‖","VerticalBar":"∣","mid":"∣","shortmid":"∣","smid":"∣","VerticalLine":"|","verbar":"|","vert":"|","VerticalSeparator":"❘","VerticalTilde":"≀","wr":"≀","wreath":"≀","VeryThinSpace":" ","hairsp":" ","Vfr":"\ud835\udd19","Vopf":"\ud835\udd4d","Vscr":"\ud835\udcb1","Vvdash":"⊪","Wcirc":"Ŵ","Wedge":"⋀","bigwedge":"⋀","xwedge":"⋀","Wfr":"\ud835\udd1a","Wopf":"\ud835\udd4e","Wscr":"\ud835\udcb2","Xfr":"\ud835\udd1b",
"Xi":"Ξ","Xopf":"\ud835\udd4f","Xscr":"\ud835\udcb3","YAcy":"Я","YIcy":"Ї","YUcy":"Ю","Yacute":"Ý","Ycirc":"Ŷ","Ycy":"Ы","Yfr":"\ud835\udd1c","Yopf":"\ud835\udd50","Yscr":"\ud835\udcb4","Yuml":"Ÿ","ZHcy":"Ж","Zacute":"Ź","Zcaron":"Ž","Zcy":"З","Zdot":"Ż","Zeta":"Ζ","Zfr":"ℨ","zeetrf":"ℨ","Zopf":"ℤ","integers":"ℤ","Zscr":"\ud835\udcb5","aacute":"á","abreve":"ă","ac":"∾","mstpos":"∾","acE":"∾̳","acd":"∿","acirc":"â","acy":"а","aelig":"æ","afr":"\ud835\udd1e","agrave":"à","alefsym":"ℵ","aleph":"ℵ","alpha":"α",
"amacr":"ā","amalg":"⨿","and":"∧","wedge":"∧","andand":"⩕","andd":"⩜","andslope":"⩘","andv":"⩚","ang":"∠","angle":"∠","ange":"⦤","angmsd":"∡","measuredangle":"∡","angmsdaa":"⦨","angmsdab":"⦩","angmsdac":"⦪","angmsdad":"⦫","angmsdae":"⦬","angmsdaf":"⦭","angmsdag":"⦮","angmsdah":"⦯","angrt":"∟","angrtvb":"⊾","angrtvbd":"⦝","angsph":"∢","angzarr":"⍼","aogon":"ą","aopf":"\ud835\udd52","apE":"⩰","apacir":"⩯","ape":"≊","approxeq":"≊","apid":"≋","apos":"'","aring":"å","ascr":"\ud835\udcb6","ast":"*","midast":"*",
"atilde":"ã","auml":"ä","awint":"⨑","bNot":"⫭","backcong":"≌","bcong":"≌","backepsilon":"϶","bepsi":"϶","backprime":"‵","bprime":"‵","backsim":"∽","bsim":"∽","backsimeq":"⋍","bsime":"⋍","barvee":"⊽","barwed":"⌅","barwedge":"⌅","bbrktbrk":"⎶","bcy":"б","bdquo":"„","ldquor":"„","bemptyv":"⦰","beta":"β","beth":"ℶ","between":"≬","twixt":"≬","bfr":"\ud835\udd1f","bigcirc":"◯","xcirc":"◯","bigodot":"⨀","xodot":"⨀","bigoplus":"⨁","xoplus":"⨁","bigotimes":"⨂","xotime":"⨂","bigsqcup":"⨆","xsqcup":"⨆","bigstar":"★",
"starf":"★","bigtriangledown":"▽","xdtri":"▽","bigtriangleup":"△","xutri":"△","biguplus":"⨄","xuplus":"⨄","bkarow":"⤍","rbarr":"⤍","blacklozenge":"⧫","lozf":"⧫","blacktriangle":"▴","utrif":"▴","blacktriangledown":"▾","dtrif":"▾","blacktriangleleft":"◂","ltrif":"◂","blacktriangleright":"▸","rtrif":"▸","blank":"␣","blk12":"▒","blk14":"░","blk34":"▓","block":"█","bne":"=⃥","bnequiv":"≡⃥","bnot":"⌐","bopf":"\ud835\udd53","bowtie":"⋈","boxDL":"╗","boxDR":"╔","boxDl":"╖","boxDr":"╓","boxH":"═","boxHD":"╦",
"boxHU":"╩","boxHd":"╤","boxHu":"╧","boxUL":"╝","boxUR":"╚","boxUl":"╜","boxUr":"╙","boxV":"║","boxVH":"╬","boxVL":"╣","boxVR":"╠","boxVh":"╫","boxVl":"╢","boxVr":"╟","boxbox":"⧉","boxdL":"╕","boxdR":"╒","boxdl":"┐","boxdr":"┌","boxhD":"╥","boxhU":"╨","boxhd":"┬","boxhu":"┴","boxminus":"⊟","minusb":"⊟","boxplus":"⊞","plusb":"⊞","boxtimes":"⊠","timesb":"⊠","boxuL":"╛","boxuR":"╘","boxul":"┘","boxur":"└","boxv":"│","boxvH":"╪","boxvL":"╡","boxvR":"╞","boxvh":"┼","boxvl":"┤","boxvr":"├","brvbar":"¦",
"bscr":"\ud835\udcb7","bsemi":"⁏","bsol":"\\","bsolb":"⧅","bsolhsub":"⟈","bull":"•","bullet":"•","bumpE":"⪮","cacute":"ć","cap":"∩","capand":"⩄","capbrcup":"⩉","capcap":"⩋","capcup":"⩇","capdot":"⩀","caps":"∩︀","caret":"⁁","ccaps":"⩍","ccaron":"č","ccedil":"ç","ccirc":"ĉ","ccups":"⩌","ccupssm":"⩐","cdot":"ċ","cemptyv":"⦲","cent":"¢","cfr":"\ud835\udd20","chcy":"ч","check":"✓","checkmark":"✓","chi":"χ","cir":"○","cirE":"⧃","circ":"ˆ","circeq":"≗","cire":"≗","circlearrowleft":"↺","olarr":"↺","circlearrowright":"↻",
"orarr":"↻","circledS":"Ⓢ","oS":"Ⓢ","circledast":"⊛","oast":"⊛","circledcirc":"⊚","ocir":"⊚","circleddash":"⊝","odash":"⊝","cirfnint":"⨐","cirmid":"⫯","cirscir":"⧂","clubs":"♣","clubsuit":"♣","colon":":","comma":",","commat":"@","comp":"∁","complement":"∁","congdot":"⩭","copf":"\ud835\udd54","copysr":"℗","crarr":"↵","cross":"✗","cscr":"\ud835\udcb8","csub":"⫏","csube":"⫑","csup":"⫐","csupe":"⫒","ctdot":"⋯","cudarrl":"⤸","cudarrr":"⤵","cuepr":"⋞","curlyeqprec":"⋞","cuesc":"⋟","curlyeqsucc":"⋟","cularr":"↶",
"curvearrowleft":"↶","cularrp":"⤽","cup":"∪","cupbrcap":"⩈","cupcap":"⩆","cupcup":"⩊","cupdot":"⊍","cupor":"⩅","cups":"∪︀","curarr":"↷","curvearrowright":"↷","curarrm":"⤼","curlyvee":"⋎","cuvee":"⋎","curlywedge":"⋏","cuwed":"⋏","curren":"¤","cwint":"∱","cylcty":"⌭","dHar":"⥥","dagger":"†","daleth":"ℸ","dash":"‐","hyphen":"‐","dbkarow":"⤏","rBarr":"⤏","dcaron":"ď","dcy":"д","ddarr":"⇊","downdownarrows":"⇊","ddotseq":"⩷","eDDot":"⩷","deg":"°","delta":"δ","demptyv":"⦱","dfisht":"⥿","dfr":"\ud835\udd21",
"diamondsuit":"♦","diams":"♦","digamma":"ϝ","gammad":"ϝ","disin":"⋲","div":"÷","divide":"÷","divideontimes":"⋇","divonx":"⋇","djcy":"ђ","dlcorn":"⌞","llcorner":"⌞","dlcrop":"⌍","dollar":"$","dopf":"\ud835\udd55","doteqdot":"≑","eDot":"≑","dotminus":"∸","minusd":"∸","dotplus":"∔","plusdo":"∔","dotsquare":"⊡","sdotb":"⊡","drcorn":"⌟","lrcorner":"⌟","drcrop":"⌌","dscr":"\ud835\udcb9","dscy":"ѕ","dsol":"⧶","dstrok":"đ","dtdot":"⋱","dtri":"▿","triangledown":"▿","dwangle":"⦦","dzcy":"џ","dzigrarr":"⟿",
"eacute":"é","easter":"⩮","ecaron":"ě","ecir":"≖","eqcirc":"≖","ecirc":"ê","ecolon":"≕","eqcolon":"≕","ecy":"э","edot":"ė","efDot":"≒","fallingdotseq":"≒","efr":"\ud835\udd22","eg":"⪚","egrave":"è","egs":"⪖","eqslantgtr":"⪖","egsdot":"⪘","el":"⪙","elinters":"⏧","ell":"ℓ","els":"⪕","eqslantless":"⪕","elsdot":"⪗","emacr":"ē","empty":"∅","emptyset":"∅","emptyv":"∅","varnothing":"∅","emsp13":" ","emsp14":" ","emsp":" ","eng":"ŋ","ensp":" ","eogon":"ę","eopf":"\ud835\udd56","epar":"⋕","eparsl":"⧣","eplus":"⩱",
"epsi":"ε","epsilon":"ε","epsiv":"ϵ","straightepsilon":"ϵ","varepsilon":"ϵ","equals":"=","equest":"≟","questeq":"≟","equivDD":"⩸","eqvparsl":"⧥","erDot":"≓","risingdotseq":"≓","erarr":"⥱","escr":"ℯ","eta":"η","eth":"ð","euml":"ë","euro":"€","excl":"!","fcy":"ф","female":"♀","ffilig":"ﬃ","fflig":"ﬀ","ffllig":"ﬄ","ffr":"\ud835\udd23","filig":"ﬁ","fjlig":"fj","flat":"♭","fllig":"ﬂ","fltns":"▱","fnof":"ƒ","fopf":"\ud835\udd57","fork":"⋔","pitchfork":"⋔","forkv":"⫙","fpartint":"⨍","frac12":"½","half":"½",
"frac13":"⅓","frac14":"¼","frac15":"⅕","frac16":"⅙","frac18":"⅛","frac23":"⅔","frac25":"⅖","frac34":"¾","frac35":"⅗","frac38":"⅜","frac45":"⅘","frac56":"⅚","frac58":"⅝","frac78":"⅞","frasl":"⁄","frown":"⌢","sfrown":"⌢","fscr":"\ud835\udcbb","gEl":"⪌","gtreqqless":"⪌","gacute":"ǵ","gamma":"γ","gap":"⪆","gtrapprox":"⪆","gbreve":"ğ","gcirc":"ĝ","gcy":"г","gdot":"ġ","gescc":"⪩","gesdot":"⪀","gesdoto":"⪂","gesdotol":"⪄","gesl":"⋛︀","gesles":"⪔","gfr":"\ud835\udd24","gimel":"ℷ","gjcy":"ѓ","glE":"⪒","gla":"⪥",
"glj":"⪤","gnE":"≩","gneqq":"≩","gnap":"⪊","gnapprox":"⪊","gne":"⪈","gneq":"⪈","gnsim":"⋧","gopf":"\ud835\udd58","gscr":"ℊ","gsime":"⪎","gsiml":"⪐","gtcc":"⪧","gtcir":"⩺","gtdot":"⋗","gtrdot":"⋗","gtlPar":"⦕","gtquest":"⩼","gtrarr":"⥸","gvertneqq":"≩︀","gvnE":"≩︀","hardcy":"ъ","harrcir":"⥈","harrw":"↭","leftrightsquigarrow":"↭","hbar":"ℏ","hslash":"ℏ","planck":"ℏ","plankv":"ℏ","hcirc":"ĥ","hearts":"♥","heartsuit":"♥","hellip":"…","mldr":"…","hercon":"⊹","hfr":"\ud835\udd25","hksearow":"⤥","searhk":"⤥",
"hkswarow":"⤦","swarhk":"⤦","hoarr":"⇿","homtht":"∻","hookleftarrow":"↩","larrhk":"↩","hookrightarrow":"↪","rarrhk":"↪","hopf":"\ud835\udd59","horbar":"―","hscr":"\ud835\udcbd","hstrok":"ħ","hybull":"⁃","iacute":"í","icirc":"î","icy":"и","iecy":"е","iexcl":"¡","ifr":"\ud835\udd26","igrave":"ì","iiiint":"⨌","qint":"⨌","iiint":"∭","tint":"∭","iinfin":"⧜","iiota":"℩","ijlig":"ĳ","imacr":"ī","imath":"ı","inodot":"ı","imof":"⊷","imped":"Ƶ","incare":"℅","infin":"∞","infintie":"⧝","intcal":"⊺","intercal":"⊺",
"intlarhk":"⨗","intprod":"⨼","iprod":"⨼","iocy":"ё","iogon":"į","iopf":"\ud835\udd5a","iota":"ι","iquest":"¿","iscr":"\ud835\udcbe","isinE":"⋹","isindot":"⋵","isins":"⋴","isinsv":"⋳","itilde":"ĩ","iukcy":"і","iuml":"ï","jcirc":"ĵ","jcy":"й","jfr":"\ud835\udd27","jmath":"ȷ","jopf":"\ud835\udd5b","jscr":"\ud835\udcbf","jsercy":"ј","jukcy":"є","kappa":"κ","kappav":"ϰ","varkappa":"ϰ","kcedil":"ķ","kcy":"к","kfr":"\ud835\udd28","kgreen":"ĸ","khcy":"х","kjcy":"ќ","kopf":"\ud835\udd5c","kscr":"\ud835\udcc0",
"lAtail":"⤛","lBarr":"⤎","lEg":"⪋","lesseqqgtr":"⪋","lHar":"⥢","lacute":"ĺ","laemptyv":"⦴","lambda":"λ","langd":"⦑","lap":"⪅","lessapprox":"⪅","laquo":"«","larrbfs":"⤟","larrfs":"⤝","larrlp":"↫","looparrowleft":"↫","larrpl":"⤹","larrsim":"⥳","larrtl":"↢","leftarrowtail":"↢","lat":"⪫","latail":"⤙","late":"⪭","lates":"⪭︀","lbarr":"⤌","lbbrk":"❲","lbrace":"{","lcub":"{","lbrack":"[","lsqb":"[","lbrke":"⦋","lbrksld":"⦏","lbrkslu":"⦍","lcaron":"ľ","lcedil":"ļ","lcy":"л","ldca":"⤶","ldrdhar":"⥧","ldrushar":"⥋",
"ldsh":"↲","le":"≤","leq":"≤","leftleftarrows":"⇇","llarr":"⇇","leftthreetimes":"⋋","lthree":"⋋","lescc":"⪨","lesdot":"⩿","lesdoto":"⪁","lesdotor":"⪃","lesg":"⋚︀","lesges":"⪓","lessdot":"⋖","ltdot":"⋖","lfisht":"⥼","lfr":"\ud835\udd29","lgE":"⪑","lharul":"⥪","lhblk":"▄","ljcy":"љ","llhard":"⥫","lltri":"◺","lmidot":"ŀ","lmoust":"⎰","lmoustache":"⎰","lnE":"≨","lneqq":"≨","lnap":"⪉","lnapprox":"⪉","lne":"⪇","lneq":"⪇","lnsim":"⋦","loang":"⟬","loarr":"⇽","longmapsto":"⟼","xmap":"⟼","looparrowright":"↬",
"rarrlp":"↬","lopar":"⦅","lopf":"\ud835\udd5d","loplus":"⨭","lotimes":"⨴","lowast":"∗","loz":"◊","lozenge":"◊","lpar":"(","lparlt":"⦓","lrhard":"⥭","lrm":"‎","lrtri":"⊿","lsaquo":"‹","lscr":"\ud835\udcc1","lsime":"⪍","lsimg":"⪏","lsquor":"‚","sbquo":"‚","lstrok":"ł","ltcc":"⪦","ltcir":"⩹","ltimes":"⋉","ltlarr":"⥶","ltquest":"⩻","ltrPar":"⦖","ltri":"◃","triangleleft":"◃","lurdshar":"⥊","luruhar":"⥦","lvertneqq":"≨︀","lvnE":"≨︀","mDDot":"∺","macr":"¯","strns":"¯","male":"♂","malt":"✠","maltese":"✠",
"marker":"▮","mcomma":"⨩","mcy":"м","mdash":"—","mfr":"\ud835\udd2a","mho":"℧","micro":"µ","midcir":"⫰","minus":"−","minusdu":"⨪","mlcp":"⫛","models":"⊧","mopf":"\ud835\udd5e","mscr":"\ud835\udcc2","mu":"μ","multimap":"⊸","mumap":"⊸","nGg":"⋙̸","nGt":"≫⃒","nLeftarrow":"⇍","nlArr":"⇍","nLeftrightarrow":"⇎","nhArr":"⇎","nLl":"⋘̸","nLt":"≪⃒","nRightarrow":"⇏","nrArr":"⇏","nVDash":"⊯","nVdash":"⊮","nacute":"ń","nang":"∠⃒","napE":"⩰̸","napid":"≋̸","napos":"ŉ","natur":"♮","natural":"♮","ncap":"⩃","ncaron":"ň",
"ncedil":"ņ","ncongdot":"⩭̸","ncup":"⩂","ncy":"н","ndash":"–","neArr":"⇗","nearhk":"⤤","nedot":"≐̸","nesear":"⤨","toea":"⤨","nfr":"\ud835\udd2b","nharr":"↮","nleftrightarrow":"↮","nhpar":"⫲","nis":"⋼","nisd":"⋺","njcy":"њ","nlE":"≦̸","nleqq":"≦̸","nlarr":"↚","nleftarrow":"↚","nldr":"‥","nopf":"\ud835\udd5f","not":"¬","notinE":"⋹̸","notindot":"⋵̸","notinvb":"⋷","notinvc":"⋶","notnivb":"⋾","notnivc":"⋽","nparsl":"⫽⃥","npart":"∂̸","npolint":"⨔","nrarr":"↛","nrightarrow":"↛","nrarrc":"⤳̸","nrarrw":"↝̸",
"nscr":"\ud835\udcc3","nsub":"⊄","nsubE":"⫅̸","nsubseteqq":"⫅̸","nsup":"⊅","nsupE":"⫆̸","nsupseteqq":"⫆̸","ntilde":"ñ","nu":"ν","num":"#","numero":"№","numsp":" ","nvDash":"⊭","nvHarr":"⤄","nvap":"≍⃒","nvdash":"⊬","nvge":"≥⃒","nvgt":">⃒","nvinfin":"⧞","nvlArr":"⤂","nvle":"≤⃒","nvlt":"<⃒","nvltrie":"⊴⃒","nvrArr":"⤃","nvrtrie":"⊵⃒","nvsim":"∼⃒","nwArr":"⇖","nwarhk":"⤣","nwnear":"⤧","oacute":"ó","ocirc":"ô","ocy":"о","odblac":"ő","odiv":"⨸","odsold":"⦼","oelig":"œ","ofcir":"⦿","ofr":"\ud835\udd2c","ogon":"˛",
"ograve":"ò","ogt":"⧁","ohbar":"⦵","olcir":"⦾","olcross":"⦻","olt":"⧀","omacr":"ō","omega":"ω","omicron":"ο","omid":"⦶","oopf":"\ud835\udd60","opar":"⦷","operp":"⦹","or":"∨","vee":"∨","ord":"⩝","order":"ℴ","orderof":"ℴ","oscr":"ℴ","ordf":"ª","ordm":"º","origof":"⊶","oror":"⩖","orslope":"⩗","orv":"⩛","oslash":"ø","osol":"⊘","otilde":"õ","otimesas":"⨶","ouml":"ö","ovbar":"⌽","para":"¶","parsim":"⫳","parsl":"⫽","pcy":"п","percnt":"%","period":".","permil":"‰","pertenk":"‱","pfr":"\ud835\udd2d","phi":"φ",
"phiv":"ϕ","straightphi":"ϕ","varphi":"ϕ","phone":"☎","pi":"π","piv":"ϖ","varpi":"ϖ","planckh":"ℎ","plus":"+","plusacir":"⨣","pluscir":"⨢","plusdu":"⨥","pluse":"⩲","plussim":"⨦","plustwo":"⨧","pointint":"⨕","popf":"\ud835\udd61","pound":"£","prE":"⪳","prap":"⪷","precapprox":"⪷","precnapprox":"⪹","prnap":"⪹","precneqq":"⪵","prnE":"⪵","precnsim":"⋨","prnsim":"⋨","prime":"′","profalar":"⌮","profline":"⌒","profsurf":"⌓","prurel":"⊰","pscr":"\ud835\udcc5","psi":"ψ","puncsp":" ","qfr":"\ud835\udd2e","qopf":"\ud835\udd62",
"qprime":"⁗","qscr":"\ud835\udcc6","quatint":"⨖","quest":"?","rAtail":"⤜","rHar":"⥤","race":"∽̱","racute":"ŕ","raemptyv":"⦳","rangd":"⦒","range":"⦥","raquo":"»","rarrap":"⥵","rarrbfs":"⤠","rarrc":"⤳","rarrfs":"⤞","rarrpl":"⥅","rarrsim":"⥴","rarrtl":"↣","rightarrowtail":"↣","rarrw":"↝","rightsquigarrow":"↝","ratail":"⤚","ratio":"∶","rbbrk":"❳","rbrace":"}","rcub":"}","rbrack":"]","rsqb":"]","rbrke":"⦌","rbrksld":"⦎","rbrkslu":"⦐","rcaron":"ř","rcedil":"ŗ","rcy":"р","rdca":"⤷","rdldhar":"⥩","rdsh":"↳",
"rect":"▭","rfisht":"⥽","rfr":"\ud835\udd2f","rharul":"⥬","rho":"ρ","rhov":"ϱ","varrho":"ϱ","rightrightarrows":"⇉","rrarr":"⇉","rightthreetimes":"⋌","rthree":"⋌","ring":"˚","rlm":"‏","rmoust":"⎱","rmoustache":"⎱","rnmid":"⫮","roang":"⟭","roarr":"⇾","ropar":"⦆","ropf":"\ud835\udd63","roplus":"⨮","rotimes":"⨵","rpar":")","rpargt":"⦔","rppolint":"⨒","rsaquo":"›","rscr":"\ud835\udcc7","rtimes":"⋊","rtri":"▹","triangleright":"▹","rtriltri":"⧎","ruluhar":"⥨","rx":"℞","sacute":"ś","scE":"⪴","scap":"⪸","succapprox":"⪸",
"scaron":"š","scedil":"ş","scirc":"ŝ","scnE":"⪶","succneqq":"⪶","scnap":"⪺","succnapprox":"⪺","scnsim":"⋩","succnsim":"⋩","scpolint":"⨓","scy":"с","sdot":"⋅","sdote":"⩦","seArr":"⇘","sect":"§","semi":";","seswar":"⤩","tosa":"⤩","sext":"✶","sfr":"\ud835\udd30","sharp":"♯","shchcy":"щ","shcy":"ш","shy":"­","sigma":"σ","sigmaf":"ς","sigmav":"ς","varsigma":"ς","simdot":"⩪","simg":"⪞","simgE":"⪠","siml":"⪝","simlE":"⪟","simne":"≆","simplus":"⨤","simrarr":"⥲","smashp":"⨳","smeparsl":"⧤","smile":"⌣","ssmile":"⌣",
"smt":"⪪","smte":"⪬","smtes":"⪬︀","softcy":"ь","sol":"/","solb":"⧄","solbar":"⌿","sopf":"\ud835\udd64","spades":"♠","spadesuit":"♠","sqcaps":"⊓︀","sqcups":"⊔︀","sscr":"\ud835\udcc8","star":"☆","sub":"⊂","subset":"⊂","subE":"⫅","subseteqq":"⫅","subdot":"⪽","subedot":"⫃","submult":"⫁","subnE":"⫋","subsetneqq":"⫋","subne":"⊊","subsetneq":"⊊","subplus":"⪿","subrarr":"⥹","subsim":"⫇","subsub":"⫕","subsup":"⫓","sung":"♪","sup1":"¹","sup2":"²","sup3":"³","supE":"⫆","supseteqq":"⫆","supdot":"⪾","supdsub":"⫘",
"supedot":"⫄","suphsol":"⟉","suphsub":"⫗","suplarr":"⥻","supmult":"⫂","supnE":"⫌","supsetneqq":"⫌","supne":"⊋","supsetneq":"⊋","supplus":"⫀","supsim":"⫈","supsub":"⫔","supsup":"⫖","swArr":"⇙","swnwar":"⤪","szlig":"ß","target":"⌖","tau":"τ","tcaron":"ť","tcedil":"ţ","tcy":"т","telrec":"⌕","tfr":"\ud835\udd31","theta":"θ","thetasym":"ϑ","thetav":"ϑ","vartheta":"ϑ","thorn":"þ","times":"×","timesbar":"⨱","timesd":"⨰","topbot":"⌶","topcir":"⫱","topf":"\ud835\udd65","topfork":"⫚","tprime":"‴","triangle":"▵",
"utri":"▵","triangleq":"≜","trie":"≜","tridot":"◬","triminus":"⨺","triplus":"⨹","trisb":"⧍","tritime":"⨻","trpezium":"⏢","tscr":"\ud835\udcc9","tscy":"ц","tshcy":"ћ","tstrok":"ŧ","uHar":"⥣","uacute":"ú","ubrcy":"ў","ubreve":"ŭ","ucirc":"û","ucy":"у","udblac":"ű","ufisht":"⥾","ufr":"\ud835\udd32","ugrave":"ù","uhblk":"▀","ulcorn":"⌜","ulcorner":"⌜","ulcrop":"⌏","ultri":"◸","umacr":"ū","uogon":"ų","uopf":"\ud835\udd66","upsi":"υ","upsilon":"υ","upuparrows":"⇈","uuarr":"⇈","urcorn":"⌝","urcorner":"⌝",
"urcrop":"⌎","uring":"ů","urtri":"◹","uscr":"\ud835\udcca","utdot":"⋰","utilde":"ũ","uuml":"ü","uwangle":"⦧","vBar":"⫨","vBarv":"⫩","vangrt":"⦜","varsubsetneq":"⊊︀","vsubne":"⊊︀","varsubsetneqq":"⫋︀","vsubnE":"⫋︀","varsupsetneq":"⊋︀","vsupne":"⊋︀","varsupsetneqq":"⫌︀","vsupnE":"⫌︀","vcy":"в","veebar":"⊻","veeeq":"≚","vellip":"⋮","vfr":"\ud835\udd33","vopf":"\ud835\udd67","vscr":"\ud835\udccb","vzigzag":"⦚","wcirc":"ŵ","wedbar":"⩟","wedgeq":"≙","weierp":"℘","wp":"℘","wfr":"\ud835\udd34","wopf":"\ud835\udd68",
"wscr":"\ud835\udccc","xfr":"\ud835\udd35","xi":"ξ","xnis":"⋻","xopf":"\ud835\udd69","xscr":"\ud835\udccd","yacute":"ý","yacy":"я","ycirc":"ŷ","ycy":"ы","yen":"¥","yfr":"\ud835\udd36","yicy":"ї","yopf":"\ud835\udd6a","yscr":"\ud835\udcce","yucy":"ю","yuml":"ÿ","zacute":"ź","zcaron":"ž","zcy":"з","zdot":"ż","zeta":"ζ","zfr":"\ud835\udd37","zhcy":"ж","zigrarr":"⇝","zopf":"\ud835\udd6b","zscr":"\ud835\udccf","zwj":"‍","zwnj":"‌"};const NGSP_UNICODE="";NAMED_ENTITIES["ngsp"]=NGSP_UNICODE;class TokenError extends ParseError{constructor(errorMsg,
tokenType,span){super(span,errorMsg);this.tokenType=tokenType}}class TokenizeResult{constructor(tokens,errors,nonNormalizedIcuExpressions){this.tokens=tokens;this.errors=errors;this.nonNormalizedIcuExpressions=nonNormalizedIcuExpressions}}function tokenize(source,url,getTagDefinition,options={}){const tokenizer=new _Tokenizer(new ParseSourceFile(source,url),getTagDefinition,options);tokenizer.tokenize();return new TokenizeResult(mergeTextTokens(tokenizer.tokens),tokenizer.errors,tokenizer.nonNormalizedIcuExpressions)}
const _CR_OR_CRLF_REGEXP=/\r\n?/g;function _unexpectedCharacterErrorMsg(charCode){const char=charCode===$EOF?"EOF":String.fromCharCode(charCode);return`Unexpected character "${char}"`}function _unknownEntityErrorMsg(entitySrc){return`Unknown entity "${entitySrc}" - use the "&#<decimal>;" or  "&#x<hex>;" syntax`}function _unparsableEntityErrorMsg(type,entityStr){return`Unable to parse entity "${entityStr}" - ${type} character reference entities must end with ";"`}var CharacterReferenceType;(function(CharacterReferenceType){CharacterReferenceType["HEX"]=
"hexadecimal";CharacterReferenceType["DEC"]="decimal"})(CharacterReferenceType||(CharacterReferenceType={}));class _ControlFlowError{constructor(error){this.error=error}}class _Tokenizer{constructor(_file,_getTagDefinition,options){this._getTagDefinition=_getTagDefinition;this._currentTokenStart=null;this._currentTokenType=null;this._expansionCaseStack=[];this._inInterpolation=false;this.tokens=[];this.errors=[];this.nonNormalizedIcuExpressions=[];this._tokenizeIcu=options.tokenizeExpansionForms||
false;this._interpolationConfig=options.interpolationConfig||DEFAULT_INTERPOLATION_CONFIG;this._leadingTriviaCodePoints=options.leadingTriviaChars&&options.leadingTriviaChars.map(c=>c.codePointAt(0)||0);const range=options.range||{endPos:_file.content.length,startPos:0,startLine:0,startCol:0};this._cursor=options.escapedString?new EscapedCharacterCursor(_file,range):new PlainCharacterCursor(_file,range);this._preserveLineEndings=options.preserveLineEndings||false;this._escapedString=options.escapedString||
false;this._i18nNormalizeLineEndingsInICUs=options.i18nNormalizeLineEndingsInICUs||false;try{this._cursor.init()}catch(e){this.handleError(e)}}_processCarriageReturns(content){if(this._preserveLineEndings)return content;return content.replace(_CR_OR_CRLF_REGEXP,"\n")}tokenize(){while(this._cursor.peek()!==$EOF){const start=this._cursor.clone();try{if(this._attemptCharCode($LT))if(this._attemptCharCode($BANG))if(this._attemptCharCode($LBRACKET))this._consumeCdata(start);else if(this._attemptCharCode($MINUS))this._consumeComment(start);
else this._consumeDocType(start);else if(this._attemptCharCode($SLASH))this._consumeTagClose(start);else this._consumeTagOpen(start);else if(!(this._tokenizeIcu&&this._tokenizeExpansionForm()))this._consumeWithInterpolation(5,8,()=>this._isTextEnd(),()=>this._isTagStart())}catch(e){this.handleError(e)}}this._beginToken(24);this._endToken([])}_tokenizeExpansionForm(){if(this.isExpansionFormStart()){this._consumeExpansionFormStart();return true}if(isExpansionCaseStart(this._cursor.peek())&&this._isInExpansionForm()){this._consumeExpansionCaseStart();
return true}if(this._cursor.peek()===$RBRACE){if(this._isInExpansionCase()){this._consumeExpansionCaseEnd();return true}if(this._isInExpansionForm()){this._consumeExpansionFormEnd();return true}}return false}_beginToken(type,start=this._cursor.clone()){this._currentTokenStart=start;this._currentTokenType=type}_endToken(parts,end){if(this._currentTokenStart===null)throw new TokenError("Programming error - attempted to end a token when there was no start to the token",this._currentTokenType,this._cursor.getSpan(end));
if(this._currentTokenType===null)throw new TokenError("Programming error - attempted to end a token which has no token type",null,this._cursor.getSpan(this._currentTokenStart));const token={type:this._currentTokenType,parts,sourceSpan:(end!==null&&end!==void 0?end:this._cursor).getSpan(this._currentTokenStart,this._leadingTriviaCodePoints)};this.tokens.push(token);this._currentTokenStart=null;this._currentTokenType=null;return token}_createError(msg,span){if(this._isInExpansionForm())msg+=` (Do you have an unescaped "{" in your template? Use "{{ '{' }}") to escape it.)`;
const error=new TokenError(msg,this._currentTokenType,span);this._currentTokenStart=null;this._currentTokenType=null;return new _ControlFlowError(error)}handleError(e){if(e instanceof CursorError)e=this._createError(e.msg,this._cursor.getSpan(e.cursor));if(e instanceof _ControlFlowError)this.errors.push(e.error);else throw e;}_attemptCharCode(charCode){if(this._cursor.peek()===charCode){this._cursor.advance();return true}return false}_attemptCharCodeCaseInsensitive(charCode){if(compareCharCodeCaseInsensitive(this._cursor.peek(),
charCode)){this._cursor.advance();return true}return false}_requireCharCode(charCode){const location=this._cursor.clone();if(!this._attemptCharCode(charCode))throw this._createError(_unexpectedCharacterErrorMsg(this._cursor.peek()),this._cursor.getSpan(location));}_attemptStr(chars){const len=chars.length;if(this._cursor.charsLeft()<len)return false;const initialPosition=this._cursor.clone();for(let i=0;i<len;i++)if(!this._attemptCharCode(chars.charCodeAt(i))){this._cursor=initialPosition;return false}return true}_attemptStrCaseInsensitive(chars){for(let i=
0;i<chars.length;i++)if(!this._attemptCharCodeCaseInsensitive(chars.charCodeAt(i)))return false;return true}_requireStr(chars){const location=this._cursor.clone();if(!this._attemptStr(chars))throw this._createError(_unexpectedCharacterErrorMsg(this._cursor.peek()),this._cursor.getSpan(location));}_attemptCharCodeUntilFn(predicate){while(!predicate(this._cursor.peek()))this._cursor.advance()}_requireCharCodeUntilFn(predicate,len){const start=this._cursor.clone();this._attemptCharCodeUntilFn(predicate);
if(this._cursor.diff(start)<len)throw this._createError(_unexpectedCharacterErrorMsg(this._cursor.peek()),this._cursor.getSpan(start));}_attemptUntilChar(char){while(this._cursor.peek()!==char)this._cursor.advance()}_readChar(){const char=String.fromCodePoint(this._cursor.peek());this._cursor.advance();return char}_consumeEntity(textTokenType){this._beginToken(9);const start=this._cursor.clone();this._cursor.advance();if(this._attemptCharCode($HASH)){const isHex=this._attemptCharCode($x)||this._attemptCharCode($X);
const codeStart=this._cursor.clone();this._attemptCharCodeUntilFn(isDigitEntityEnd);if(this._cursor.peek()!=$SEMICOLON){this._cursor.advance();const entityType=isHex?CharacterReferenceType.HEX:CharacterReferenceType.DEC;throw this._createError(_unparsableEntityErrorMsg(entityType,this._cursor.getChars(start)),this._cursor.getSpan());}const strNum=this._cursor.getChars(codeStart);this._cursor.advance();try{const charCode=parseInt(strNum,isHex?16:10);this._endToken([String.fromCharCode(charCode),this._cursor.getChars(start)])}catch(_a){throw this._createError(_unknownEntityErrorMsg(this._cursor.getChars(start)),
this._cursor.getSpan());}}else{const nameStart=this._cursor.clone();this._attemptCharCodeUntilFn(isNamedEntityEnd);if(this._cursor.peek()!=$SEMICOLON){this._beginToken(textTokenType,start);this._cursor=nameStart;this._endToken(["&"])}else{const name=this._cursor.getChars(nameStart);this._cursor.advance();const char=NAMED_ENTITIES[name];if(!char)throw this._createError(_unknownEntityErrorMsg(name),this._cursor.getSpan(start));this._endToken([char,`&${name};`])}}}_consumeRawText(consumeEntities,endMarkerPredicate){this._beginToken(consumeEntities?
6:7);const parts=[];while(true){const tagCloseStart=this._cursor.clone();const foundEndMarker=endMarkerPredicate();this._cursor=tagCloseStart;if(foundEndMarker)break;if(consumeEntities&&this._cursor.peek()===$AMPERSAND){this._endToken([this._processCarriageReturns(parts.join(""))]);parts.length=0;this._consumeEntity(6);this._beginToken(6)}else parts.push(this._readChar())}this._endToken([this._processCarriageReturns(parts.join(""))])}_consumeComment(start){this._beginToken(10,start);this._requireCharCode($MINUS);
this._endToken([]);this._consumeRawText(false,()=>this._attemptStr("--\x3e"));this._beginToken(11);this._requireStr("--\x3e");this._endToken([])}_consumeCdata(start){this._beginToken(12,start);this._requireStr("CDATA[");this._endToken([]);this._consumeRawText(false,()=>this._attemptStr("]]\x3e"));this._beginToken(13);this._requireStr("]]\x3e");this._endToken([])}_consumeDocType(start){this._beginToken(18,start);const contentStart=this._cursor.clone();this._attemptUntilChar($GT);const content=this._cursor.getChars(contentStart);
this._cursor.advance();this._endToken([content])}_consumePrefixAndName(){const nameOrPrefixStart=this._cursor.clone();let prefix="";while(this._cursor.peek()!==$COLON&&!isPrefixEnd(this._cursor.peek()))this._cursor.advance();let nameStart;if(this._cursor.peek()===$COLON){prefix=this._cursor.getChars(nameOrPrefixStart);this._cursor.advance();nameStart=this._cursor.clone()}else nameStart=nameOrPrefixStart;this._requireCharCodeUntilFn(isNameEnd,prefix===""?0:1);const name=this._cursor.getChars(nameStart);
return[prefix,name]}_consumeTagOpen(start){let tagName;let prefix;let openTagToken;try{if(!isAsciiLetter(this._cursor.peek()))throw this._createError(_unexpectedCharacterErrorMsg(this._cursor.peek()),this._cursor.getSpan(start));openTagToken=this._consumeTagOpenStart(start);prefix=openTagToken.parts[0];tagName=openTagToken.parts[1];this._attemptCharCodeUntilFn(isNotWhitespace);while(this._cursor.peek()!==$SLASH&&this._cursor.peek()!==$GT&&this._cursor.peek()!==$LT&&this._cursor.peek()!==$EOF){this._consumeAttributeName();
this._attemptCharCodeUntilFn(isNotWhitespace);if(this._attemptCharCode($EQ)){this._attemptCharCodeUntilFn(isNotWhitespace);this._consumeAttributeValue()}this._attemptCharCodeUntilFn(isNotWhitespace)}this._consumeTagOpenEnd()}catch(e){if(e instanceof _ControlFlowError){if(openTagToken)openTagToken.type=4;else{this._beginToken(5,start);this._endToken(["<"])}return}throw e;}const contentTokenType=this._getTagDefinition(tagName).getContentType(prefix);if(contentTokenType===exports.TagContentType.RAW_TEXT)this._consumeRawTextWithTagClose(prefix,
tagName,false);else if(contentTokenType===exports.TagContentType.ESCAPABLE_RAW_TEXT)this._consumeRawTextWithTagClose(prefix,tagName,true)}_consumeRawTextWithTagClose(prefix,tagName,consumeEntities){this._consumeRawText(consumeEntities,()=>{if(!this._attemptCharCode($LT))return false;if(!this._attemptCharCode($SLASH))return false;this._attemptCharCodeUntilFn(isNotWhitespace);if(!this._attemptStrCaseInsensitive(tagName))return false;this._attemptCharCodeUntilFn(isNotWhitespace);return this._attemptCharCode($GT)});
this._beginToken(3);this._requireCharCodeUntilFn(code=>code===$GT,3);this._cursor.advance();this._endToken([prefix,tagName])}_consumeTagOpenStart(start){this._beginToken(0,start);const parts=this._consumePrefixAndName();return this._endToken(parts)}_consumeAttributeName(){const attrNameStart=this._cursor.peek();if(attrNameStart===$SQ||attrNameStart===$DQ)throw this._createError(_unexpectedCharacterErrorMsg(attrNameStart),this._cursor.getSpan());this._beginToken(14);const prefixAndName=this._consumePrefixAndName();
this._endToken(prefixAndName)}_consumeAttributeValue(){if(this._cursor.peek()===$SQ||this._cursor.peek()===$DQ){const quoteChar=this._cursor.peek();this._consumeQuote(quoteChar);const endPredicate=()=>this._cursor.peek()===quoteChar;this._consumeWithInterpolation(16,17,endPredicate,endPredicate);this._consumeQuote(quoteChar)}else{const endPredicate=()=>isNameEnd(this._cursor.peek());this._consumeWithInterpolation(16,17,endPredicate,endPredicate)}}_consumeQuote(quoteChar){this._beginToken(15);this._requireCharCode(quoteChar);
this._endToken([String.fromCodePoint(quoteChar)])}_consumeTagOpenEnd(){const tokenType=this._attemptCharCode($SLASH)?2:1;this._beginToken(tokenType);this._requireCharCode($GT);this._endToken([])}_consumeTagClose(start){this._beginToken(3,start);this._attemptCharCodeUntilFn(isNotWhitespace);const prefixAndName=this._consumePrefixAndName();this._attemptCharCodeUntilFn(isNotWhitespace);this._requireCharCode($GT);this._endToken(prefixAndName)}_consumeExpansionFormStart(){this._beginToken(19);this._requireCharCode($LBRACE);
this._endToken([]);this._expansionCaseStack.push(19);this._beginToken(7);const condition=this._readUntil($COMMA);const normalizedCondition=this._processCarriageReturns(condition);if(this._i18nNormalizeLineEndingsInICUs)this._endToken([normalizedCondition]);else{const conditionToken=this._endToken([condition]);if(normalizedCondition!==condition)this.nonNormalizedIcuExpressions.push(conditionToken)}this._requireCharCode($COMMA);this._attemptCharCodeUntilFn(isNotWhitespace);this._beginToken(7);const type=
this._readUntil($COMMA);this._endToken([type]);this._requireCharCode($COMMA);this._attemptCharCodeUntilFn(isNotWhitespace)}_consumeExpansionCaseStart(){this._beginToken(20);const value=this._readUntil($LBRACE).trim();this._endToken([value]);this._attemptCharCodeUntilFn(isNotWhitespace);this._beginToken(21);this._requireCharCode($LBRACE);this._endToken([]);this._attemptCharCodeUntilFn(isNotWhitespace);this._expansionCaseStack.push(21)}_consumeExpansionCaseEnd(){this._beginToken(22);this._requireCharCode($RBRACE);
this._endToken([]);this._attemptCharCodeUntilFn(isNotWhitespace);this._expansionCaseStack.pop()}_consumeExpansionFormEnd(){this._beginToken(23);this._requireCharCode($RBRACE);this._endToken([]);this._expansionCaseStack.pop()}_consumeWithInterpolation(textTokenType,interpolationTokenType,endPredicate,endInterpolation){this._beginToken(textTokenType);const parts=[];while(!endPredicate()){const current=this._cursor.clone();if(this._interpolationConfig&&this._attemptStr(this._interpolationConfig.start)){this._endToken([this._processCarriageReturns(parts.join(""))],
current);parts.length=0;this._consumeInterpolation(interpolationTokenType,current,endInterpolation);this._beginToken(textTokenType)}else if(this._cursor.peek()===$AMPERSAND){this._endToken([this._processCarriageReturns(parts.join(""))]);parts.length=0;this._consumeEntity(textTokenType);this._beginToken(textTokenType)}else parts.push(this._readChar())}this._inInterpolation=false;this._endToken([this._processCarriageReturns(parts.join(""))])}_consumeInterpolation(interpolationTokenType,interpolationStart,
prematureEndPredicate){const parts=[];this._beginToken(interpolationTokenType,interpolationStart);parts.push(this._interpolationConfig.start);const expressionStart=this._cursor.clone();let inQuote=null;let inComment=false;while(this._cursor.peek()!==$EOF&&(prematureEndPredicate===null||!prematureEndPredicate())){const current=this._cursor.clone();if(this._isTagStart()){this._cursor=current;parts.push(this._getProcessedChars(expressionStart,current));this._endToken(parts);return}if(inQuote===null)if(this._attemptStr(this._interpolationConfig.end)){parts.push(this._getProcessedChars(expressionStart,
current));parts.push(this._interpolationConfig.end);this._endToken(parts);return}else if(this._attemptStr("//"))inComment=true;const char=this._cursor.peek();this._cursor.advance();if(char===$BACKSLASH)this._cursor.advance();else if(char===inQuote)inQuote=null;else if(!inComment&&inQuote===null&&isQuote(char))inQuote=char}parts.push(this._getProcessedChars(expressionStart,this._cursor));this._endToken(parts)}_getProcessedChars(start,end){return this._processCarriageReturns(end.getChars(start))}_isTextEnd(){if(this._isTagStart()||
this._cursor.peek()===$EOF)return true;if(this._tokenizeIcu&&!this._inInterpolation){if(this.isExpansionFormStart())return true;if(this._cursor.peek()===$RBRACE&&this._isInExpansionCase())return true}return false}_isTagStart(){if(this._cursor.peek()===$LT){const tmp=this._cursor.clone();tmp.advance();const code=tmp.peek();if($a<=code&&code<=$z||$A<=code&&code<=$Z||code===$SLASH||code===$BANG)return true}return false}_readUntil(char){const start=this._cursor.clone();this._attemptUntilChar(char);return this._cursor.getChars(start)}_isInExpansionCase(){return this._expansionCaseStack.length>
0&&this._expansionCaseStack[this._expansionCaseStack.length-1]===21}_isInExpansionForm(){return this._expansionCaseStack.length>0&&this._expansionCaseStack[this._expansionCaseStack.length-1]===19}isExpansionFormStart(){if(this._cursor.peek()!==$LBRACE)return false;if(this._interpolationConfig){const start=this._cursor.clone();const isInterpolation=this._attemptStr(this._interpolationConfig.start);this._cursor=start;return!isInterpolation}return true}}function isNotWhitespace(code){return!isWhitespace(code)||
code===$EOF}function isNameEnd(code){return isWhitespace(code)||code===$GT||code===$LT||code===$SLASH||code===$SQ||code===$DQ||code===$EQ||code===$EOF}function isPrefixEnd(code){return(code<$a||$z<code)&&(code<$A||$Z<code)&&(code<$0||code>$9)}function isDigitEntityEnd(code){return code===$SEMICOLON||code===$EOF||!isAsciiHexDigit(code)}function isNamedEntityEnd(code){return code===$SEMICOLON||code===$EOF||!isAsciiLetter(code)}function isExpansionCaseStart(peek){return peek!==$RBRACE}function compareCharCodeCaseInsensitive(code1,
code2){return toUpperCaseCharCode(code1)===toUpperCaseCharCode(code2)}function toUpperCaseCharCode(code){return code>=$a&&code<=$z?code-$a+$A:code}function mergeTextTokens(srcTokens){const dstTokens=[];let lastDstToken=undefined;for(let i=0;i<srcTokens.length;i++){const token=srcTokens[i];if(lastDstToken&&lastDstToken.type===5&&token.type===5||lastDstToken&&lastDstToken.type===16&&token.type===16){lastDstToken.parts[0]+=token.parts[0];lastDstToken.sourceSpan.end=token.sourceSpan.end}else{lastDstToken=
token;dstTokens.push(lastDstToken)}}return dstTokens}class PlainCharacterCursor{constructor(fileOrCursor,range){if(fileOrCursor instanceof PlainCharacterCursor){this.file=fileOrCursor.file;this.input=fileOrCursor.input;this.end=fileOrCursor.end;const state=fileOrCursor.state;this.state={peek:state.peek,offset:state.offset,line:state.line,column:state.column}}else{if(!range)throw new Error("Programming error: the range argument must be provided with a file argument.");this.file=fileOrCursor;this.input=
fileOrCursor.content;this.end=range.endPos;this.state={peek:-1,offset:range.startPos,line:range.startLine,column:range.startCol}}}clone(){return new PlainCharacterCursor(this)}peek(){return this.state.peek}charsLeft(){return this.end-this.state.offset}diff(other){return this.state.offset-other.state.offset}advance(){this.advanceState(this.state)}init(){this.updatePeek(this.state)}getSpan(start,leadingTriviaCodePoints){start=start||this;let fullStart=start;if(leadingTriviaCodePoints)while(this.diff(start)>
0&&leadingTriviaCodePoints.indexOf(start.peek())!==-1){if(fullStart===start)start=start.clone();start.advance()}const startLocation=this.locationFromCursor(start);const endLocation=this.locationFromCursor(this);const fullStartLocation=fullStart!==start?this.locationFromCursor(fullStart):startLocation;return new ParseSourceSpan(startLocation,endLocation,fullStartLocation)}getChars(start){return this.input.substring(start.state.offset,this.state.offset)}charAt(pos){return this.input.charCodeAt(pos)}advanceState(state){if(state.offset>=
this.end){this.state=state;throw new CursorError('Unexpected character "EOF"',this);}const currentChar=this.charAt(state.offset);if(currentChar===$LF){state.line++;state.column=0}else if(!isNewLine(currentChar))state.column++;state.offset++;this.updatePeek(state)}updatePeek(state){state.peek=state.offset>=this.end?$EOF:this.charAt(state.offset)}locationFromCursor(cursor){return new ParseLocation(cursor.file,cursor.state.offset,cursor.state.line,cursor.state.column)}}class EscapedCharacterCursor extends PlainCharacterCursor{constructor(fileOrCursor,
range){if(fileOrCursor instanceof EscapedCharacterCursor){super(fileOrCursor);this.internalState=Object.assign({},fileOrCursor.internalState)}else{super(fileOrCursor,range);this.internalState=this.state}}advance(){this.state=this.internalState;super.advance();this.processEscapeSequence()}init(){super.init();this.processEscapeSequence()}clone(){return new EscapedCharacterCursor(this)}getChars(start){const cursor=start.clone();let chars="";while(cursor.internalState.offset<this.internalState.offset){chars+=
String.fromCodePoint(cursor.peek());cursor.advance()}return chars}processEscapeSequence(){const peek=()=>this.internalState.peek;if(peek()===$BACKSLASH){this.internalState=Object.assign({},this.state);this.advanceState(this.internalState);if(peek()===$n)this.state.peek=$LF;else if(peek()===$r)this.state.peek=$CR;else if(peek()===$v)this.state.peek=$VTAB;else if(peek()===$t)this.state.peek=$TAB;else if(peek()===$b)this.state.peek=$BSPACE;else if(peek()===$f)this.state.peek=$FF;else if(peek()===$u){this.advanceState(this.internalState);
if(peek()===$LBRACE){this.advanceState(this.internalState);const digitStart=this.clone();let length=0;while(peek()!==$RBRACE){this.advanceState(this.internalState);length++}this.state.peek=this.decodeHexDigits(digitStart,length)}else{const digitStart=this.clone();this.advanceState(this.internalState);this.advanceState(this.internalState);this.advanceState(this.internalState);this.state.peek=this.decodeHexDigits(digitStart,4)}}else if(peek()===$x){this.advanceState(this.internalState);const digitStart=
this.clone();this.advanceState(this.internalState);this.state.peek=this.decodeHexDigits(digitStart,2)}else if(isOctalDigit(peek())){let octal="";let length=0;let previous=this.clone();while(isOctalDigit(peek())&&length<3){previous=this.clone();octal+=String.fromCodePoint(peek());this.advanceState(this.internalState);length++}this.state.peek=parseInt(octal,8);this.internalState=previous.internalState}else if(isNewLine(this.internalState.peek)){this.advanceState(this.internalState);this.state=this.internalState}else this.state.peek=
this.internalState.peek}}decodeHexDigits(start,length){const hex=this.input.substr(start.internalState.offset,length);const charCode=parseInt(hex,16);if(!isNaN(charCode))return charCode;else{start.state=start.internalState;throw new CursorError("Invalid hexadecimal escape sequence",start);}}}class CursorError{constructor(msg,cursor){this.msg=msg;this.cursor=cursor}}class TreeError extends ParseError{constructor(elementName,span,msg){super(span,msg);this.elementName=elementName}static create(elementName,
span,msg){return new TreeError(elementName,span,msg)}}class ParseTreeResult{constructor(rootNodes,errors){this.rootNodes=rootNodes;this.errors=errors}}class Parser{constructor(getTagDefinition){this.getTagDefinition=getTagDefinition}parse(source,url,options){const tokenizeResult=tokenize(source,url,this.getTagDefinition,options);const parser=new _TreeBuilder(tokenizeResult.tokens,this.getTagDefinition);parser.build();return new ParseTreeResult(parser.rootNodes,tokenizeResult.errors.concat(parser.errors))}}
class _TreeBuilder{constructor(tokens,getTagDefinition){this.tokens=tokens;this.getTagDefinition=getTagDefinition;this._index=-1;this._elementStack=[];this.rootNodes=[];this.errors=[];this._advance()}build(){while(this._peek.type!==24)if(this._peek.type===0||this._peek.type===4)this._consumeStartTag(this._advance());else if(this._peek.type===3)this._consumeEndTag(this._advance());else if(this._peek.type===12){this._closeVoidElement();this._consumeCdata(this._advance())}else if(this._peek.type===10){this._closeVoidElement();
this._consumeComment(this._advance())}else if(this._peek.type===5||this._peek.type===7||this._peek.type===6){this._closeVoidElement();this._consumeText(this._advance())}else if(this._peek.type===19)this._consumeExpansion(this._advance());else this._advance()}_advance(){const prev=this._peek;if(this._index<this.tokens.length-1)this._index++;this._peek=this.tokens[this._index];return prev}_advanceIf(type){if(this._peek.type===type)return this._advance();return null}_consumeCdata(_startToken){this._consumeText(this._advance());
this._advanceIf(13)}_consumeComment(token){const text=this._advanceIf(7);this._advanceIf(11);const value=text!=null?text.parts[0].trim():null;this._addToParent(new Comment(value,token.sourceSpan))}_consumeExpansion(token){const switchValue=this._advance();const type=this._advance();const cases=[];while(this._peek.type===20){const expCase=this._parseExpansionCase();if(!expCase)return;cases.push(expCase)}if(this._peek.type!==23){this.errors.push(TreeError.create(null,this._peek.sourceSpan,`Invalid ICU message. Missing '}'.`));
return}const sourceSpan=new ParseSourceSpan(token.sourceSpan.start,this._peek.sourceSpan.end,token.sourceSpan.fullStart);this._addToParent(new Expansion(switchValue.parts[0],type.parts[0],cases,sourceSpan,switchValue.sourceSpan));this._advance()}_parseExpansionCase(){const value=this._advance();if(this._peek.type!==21){this.errors.push(TreeError.create(null,this._peek.sourceSpan,`Invalid ICU message. Missing '{'.`));return null}const start=this._advance();const exp=this._collectExpansionExpTokens(start);
if(!exp)return null;const end=this._advance();exp.push({type:24,parts:[],sourceSpan:end.sourceSpan});const expansionCaseParser=new _TreeBuilder(exp,this.getTagDefinition);expansionCaseParser.build();if(expansionCaseParser.errors.length>0){this.errors=this.errors.concat(expansionCaseParser.errors);return null}const sourceSpan=new ParseSourceSpan(value.sourceSpan.start,end.sourceSpan.end,value.sourceSpan.fullStart);const expSourceSpan=new ParseSourceSpan(start.sourceSpan.start,end.sourceSpan.end,start.sourceSpan.fullStart);
return new ExpansionCase(value.parts[0],expansionCaseParser.rootNodes,sourceSpan,value.sourceSpan,expSourceSpan)}_collectExpansionExpTokens(start){const exp=[];const expansionFormStack=[21];while(true){if(this._peek.type===19||this._peek.type===21)expansionFormStack.push(this._peek.type);if(this._peek.type===22)if(lastOnStack(expansionFormStack,21)){expansionFormStack.pop();if(expansionFormStack.length===0)return exp}else{this.errors.push(TreeError.create(null,start.sourceSpan,`Invalid ICU message. Missing '}'.`));
return null}if(this._peek.type===23)if(lastOnStack(expansionFormStack,19))expansionFormStack.pop();else{this.errors.push(TreeError.create(null,start.sourceSpan,`Invalid ICU message. Missing '}'.`));return null}if(this._peek.type===24){this.errors.push(TreeError.create(null,start.sourceSpan,`Invalid ICU message. Missing '}'.`));return null}exp.push(this._advance())}}_consumeText(token){const tokens=[token];const startSpan=token.sourceSpan;let text=token.parts[0];if(text.length>0&&text[0]==="\n"){const parent=
this._getParentElement();if(parent!=null&&parent.children.length===0&&this.getTagDefinition(parent.name).ignoreFirstLf){text=text.substring(1);tokens[0]={type:token.type,sourceSpan:token.sourceSpan,parts:[text]}}}while(this._peek.type===8||this._peek.type===5||this._peek.type===9){token=this._advance();tokens.push(token);if(token.type===8)text+=token.parts.join("").replace(/&([^;]+);/g,decodeEntity);else if(token.type===9)text+=token.parts[0];else text+=token.parts.join("")}if(text.length>0){const endSpan=
token.sourceSpan;this._addToParent(new Text(text,new ParseSourceSpan(startSpan.start,endSpan.end,startSpan.fullStart,startSpan.details),tokens))}}_closeVoidElement(){const el=this._getParentElement();if(el&&this.getTagDefinition(el.name).isVoid)this._elementStack.pop()}_consumeStartTag(startTagToken){const [prefix,name]=startTagToken.parts;const attrs=[];while(this._peek.type===14)attrs.push(this._consumeAttr(this._advance()));const fullName=this._getElementFullName(prefix,name,this._getParentElement());
let selfClosing=false;if(this._peek.type===2){this._advance();selfClosing=true;const tagDef=this.getTagDefinition(fullName);if(!(tagDef.canSelfClose||getNsPrefix(fullName)!==null||tagDef.isVoid))this.errors.push(TreeError.create(fullName,startTagToken.sourceSpan,`Only void and foreign elements can be self closed "${startTagToken.parts[1]}"`))}else if(this._peek.type===1){this._advance();selfClosing=false}const end=this._peek.sourceSpan.fullStart;const span=new ParseSourceSpan(startTagToken.sourceSpan.start,
end,startTagToken.sourceSpan.fullStart);const startSpan=new ParseSourceSpan(startTagToken.sourceSpan.start,end,startTagToken.sourceSpan.fullStart);const el=new Element(fullName,attrs,[],span,startSpan,undefined);this._pushElement(el);if(selfClosing)this._popElement(fullName,span);else if(startTagToken.type===4){this._popElement(fullName,null);this.errors.push(TreeError.create(fullName,span,`Opening tag "${fullName}" not terminated.`))}}_pushElement(el){const parentEl=this._getParentElement();if(parentEl&&
this.getTagDefinition(parentEl.name).isClosedByChild(el.name))this._elementStack.pop();this._addToParent(el);this._elementStack.push(el)}_consumeEndTag(endTagToken){const fullName=this._getElementFullName(endTagToken.parts[0],endTagToken.parts[1],this._getParentElement());if(this.getTagDefinition(fullName).isVoid)this.errors.push(TreeError.create(fullName,endTagToken.sourceSpan,`Void elements do not have end tags "${endTagToken.parts[1]}"`));else if(!this._popElement(fullName,endTagToken.sourceSpan)){const errMsg=
`Unexpected closing tag "${fullName}". It may happen when the tag has already been closed by another tag. For more info see https://www.w3.org/TR/html5/syntax.html#closing-elements-that-have-implied-end-tags`;this.errors.push(TreeError.create(fullName,endTagToken.sourceSpan,errMsg))}}_popElement(fullName,endSourceSpan){let unexpectedCloseTagDetected=false;for(let stackIndex=this._elementStack.length-1;stackIndex>=0;stackIndex--){const el=this._elementStack[stackIndex];if(el.name===fullName){el.endSourceSpan=
endSourceSpan;el.sourceSpan.end=endSourceSpan!==null?endSourceSpan.end:el.sourceSpan.end;this._elementStack.splice(stackIndex,this._elementStack.length-stackIndex);return!unexpectedCloseTagDetected}if(!this.getTagDefinition(el.name).closedByParent)unexpectedCloseTagDetected=true}return false}_consumeAttr(attrName){const fullName=mergeNsAndName(attrName.parts[0],attrName.parts[1]);let attrEnd=attrName.sourceSpan.end;if(this._peek.type===15)this._advance();let value="";const valueTokens=[];let valueStartSpan=
undefined;let valueEnd=undefined;const nextTokenType=this._peek.type;if(nextTokenType===16){valueStartSpan=this._peek.sourceSpan;valueEnd=this._peek.sourceSpan.end;while(this._peek.type===16||this._peek.type===17||this._peek.type===9){const valueToken=this._advance();valueTokens.push(valueToken);if(valueToken.type===17)value+=valueToken.parts.join("").replace(/&([^;]+);/g,decodeEntity);else if(valueToken.type===9)value+=valueToken.parts[0];else value+=valueToken.parts.join("");valueEnd=attrEnd=valueToken.sourceSpan.end}}if(this._peek.type===
15){const quoteToken=this._advance();attrEnd=quoteToken.sourceSpan.end}const valueSpan=valueStartSpan&&valueEnd&&new ParseSourceSpan(valueStartSpan.start,valueEnd,valueStartSpan.fullStart);return new Attribute(fullName,value,new ParseSourceSpan(attrName.sourceSpan.start,attrEnd,attrName.sourceSpan.fullStart),attrName.sourceSpan,valueSpan,valueTokens.length>0?valueTokens:undefined,undefined)}_getParentElement(){return this._elementStack.length>0?this._elementStack[this._elementStack.length-1]:null}_addToParent(node){const parent=
this._getParentElement();if(parent!=null)parent.children.push(node);else this.rootNodes.push(node)}_getElementFullName(prefix,localName,parentElement){if(prefix===""){prefix=this.getTagDefinition(localName).implicitNamespacePrefix||"";if(prefix===""&&parentElement!=null){const parentTagName=splitNsName(parentElement.name)[1];const parentTagDefinition=this.getTagDefinition(parentTagName);if(!parentTagDefinition.preventNamespaceInheritance)prefix=getNsPrefix(parentElement.name)}}return mergeNsAndName(prefix,
localName)}}function lastOnStack(stack,element){return stack.length>0&&stack[stack.length-1]===element}function decodeEntity(match,entity){if(NAMED_ENTITIES[entity]!==undefined)return NAMED_ENTITIES[entity]||match;if(/^#x[a-f0-9]+$/i.test(entity))return String.fromCodePoint(parseInt(entity.slice(2),16));if(/^#\d+$/.test(entity))return String.fromCodePoint(parseInt(entity.slice(1),10));return match}class HtmlParser extends Parser{constructor(){super(getHtmlTagDefinition)}parse(source,url,options){return super.parse(source,
url,options)}}const PRESERVE_WS_ATTR_NAME="ngPreserveWhitespaces";const SKIP_WS_TRIM_TAGS=new Set(["pre","template","textarea","script","style"]);const WS_CHARS=" \f\n\r\t\v ᠎ - \u2028\u2029  　﻿";const NO_WS_REGEXP=new RegExp(`[^${WS_CHARS}]`);const WS_REPLACE_REGEXP=new RegExp(`[${WS_CHARS}]{2,}`,"g");function hasPreserveWhitespacesAttr(attrs){return attrs.some(attr=>attr.name===PRESERVE_WS_ATTR_NAME)}function replaceNgsp(value){return value.replace(new RegExp(NGSP_UNICODE,"g")," ")}class WhitespaceVisitor{visitElement(element,
context){if(SKIP_WS_TRIM_TAGS.has(element.name)||hasPreserveWhitespacesAttr(element.attrs))return new Element(element.name,visitAll(this,element.attrs),element.children,element.sourceSpan,element.startSourceSpan,element.endSourceSpan,element.i18n);return new Element(element.name,element.attrs,visitAllWithSiblings(this,element.children),element.sourceSpan,element.startSourceSpan,element.endSourceSpan,element.i18n)}visitAttribute(attribute,context){return attribute.name!==PRESERVE_WS_ATTR_NAME?attribute:
null}visitText(text,context){const isNotBlank=text.value.match(NO_WS_REGEXP);const hasExpansionSibling=context&&(context.prev instanceof Expansion||context.next instanceof Expansion);if(isNotBlank||hasExpansionSibling){const tokens=text.tokens.map(token=>token.type===5?createWhitespaceProcessedTextToken(token):token);const value=processWhitespace(text.value);return new Text(value,text.sourceSpan,tokens,text.i18n)}return null}visitComment(comment,context){return comment}visitExpansion(expansion,context){return expansion}visitExpansionCase(expansionCase,
context){return expansionCase}}function createWhitespaceProcessedTextToken({type,parts,sourceSpan}){return{type,parts:[processWhitespace(parts[0])],sourceSpan}}function processWhitespace(text){return replaceNgsp(text).replace(WS_REPLACE_REGEXP," ")}function visitAllWithSiblings(visitor,nodes){const result=[];nodes.forEach((ast,i)=>{const context={prev:nodes[i-1],next:nodes[i+1]};const astResult=ast.visit(visitor,context);if(astResult)result.push(astResult)});return result}function mapLiteral(obj,
quoted=false){return literalMap(Object.keys(obj).map(key=>({key,quoted,value:obj[key]})))}let _SECURITY_SCHEMA;function SECURITY_SCHEMA(){if(!_SECURITY_SCHEMA){_SECURITY_SCHEMA={};registerContext(SecurityContext.HTML,["iframe|srcdoc","*|innerHTML","*|outerHTML"]);registerContext(SecurityContext.STYLE,["*|style"]);registerContext(SecurityContext.URL,["*|formAction","area|href","area|ping","audio|src","a|href","a|ping","blockquote|cite","body|background","del|cite","form|action","img|src","img|srcset",
"input|src","ins|cite","q|cite","source|src","source|srcset","track|src","video|poster","video|src"]);registerContext(SecurityContext.RESOURCE_URL,["applet|code","applet|codebase","base|href","embed|src","frame|src","head|profile","html|manifest","iframe|src","link|href","media|src","object|codebase","object|data","script|src"])}return _SECURITY_SCHEMA}function registerContext(ctx,specs){for(const spec of specs)_SECURITY_SCHEMA[spec.toLowerCase()]=ctx}class ElementSchemaRegistry{}const BOOLEAN="boolean";
const NUMBER="number";const STRING="string";const OBJECT="object";const SCHEMA=["[Element]|textContent,%classList,className,id,innerHTML,*beforecopy,*beforecut,*beforepaste,*copy,*cut,*paste,*search,*selectstart,*webkitfullscreenchange,*webkitfullscreenerror,*wheel,outerHTML,#scrollLeft,#scrollTop,slot"+",*message,*mozfullscreenchange,*mozfullscreenerror,*mozpointerlockchange,*mozpointerlockerror,*webglcontextcreationerror,*webglcontextlost,*webglcontextrestored","[HTMLElement]^[Element]|accessKey,contentEditable,dir,!draggable,!hidden,innerText,lang,*abort,*auxclick,*blur,*cancel,*canplay,*canplaythrough,*change,*click,*close,*contextmenu,*cuechange,*dblclick,*drag,*dragend,*dragenter,*dragleave,*dragover,*dragstart,*drop,*durationchange,*emptied,*ended,*error,*focus,*gotpointercapture,*input,*invalid,*keydown,*keypress,*keyup,*load,*loadeddata,*loadedmetadata,*loadstart,*lostpointercapture,*mousedown,*mouseenter,*mouseleave,*mousemove,*mouseout,*mouseover,*mouseup,*mousewheel,*pause,*play,*playing,*pointercancel,*pointerdown,*pointerenter,*pointerleave,*pointermove,*pointerout,*pointerover,*pointerup,*progress,*ratechange,*reset,*resize,*scroll,*seeked,*seeking,*select,*show,*stalled,*submit,*suspend,*timeupdate,*toggle,*volumechange,*waiting,outerText,!spellcheck,%style,#tabIndex,title,!translate",
"abbr,address,article,aside,b,bdi,bdo,cite,code,dd,dfn,dt,em,figcaption,figure,footer,header,i,kbd,main,mark,nav,noscript,rb,rp,rt,rtc,ruby,s,samp,section,small,strong,sub,sup,u,var,wbr^[HTMLElement]|accessKey,contentEditable,dir,!draggable,!hidden,innerText,lang,*abort,*auxclick,*blur,*cancel,*canplay,*canplaythrough,*change,*click,*close,*contextmenu,*cuechange,*dblclick,*drag,*dragend,*dragenter,*dragleave,*dragover,*dragstart,*drop,*durationchange,*emptied,*ended,*error,*focus,*gotpointercapture,*input,*invalid,*keydown,*keypress,*keyup,*load,*loadeddata,*loadedmetadata,*loadstart,*lostpointercapture,*mousedown,*mouseenter,*mouseleave,*mousemove,*mouseout,*mouseover,*mouseup,*mousewheel,*pause,*play,*playing,*pointercancel,*pointerdown,*pointerenter,*pointerleave,*pointermove,*pointerout,*pointerover,*pointerup,*progress,*ratechange,*reset,*resize,*scroll,*seeked,*seeking,*select,*show,*stalled,*submit,*suspend,*timeupdate,*toggle,*volumechange,*waiting,outerText,!spellcheck,%style,#tabIndex,title,!translate",
"media^[HTMLElement]|!autoplay,!controls,%controlsList,%crossOrigin,#currentTime,!defaultMuted,#defaultPlaybackRate,!disableRemotePlayback,!loop,!muted,*encrypted,*waitingforkey,#playbackRate,preload,src,%srcObject,#volume",":svg:^[HTMLElement]|*abort,*auxclick,*blur,*cancel,*canplay,*canplaythrough,*change,*click,*close,*contextmenu,*cuechange,*dblclick,*drag,*dragend,*dragenter,*dragleave,*dragover,*dragstart,*drop,*durationchange,*emptied,*ended,*error,*focus,*gotpointercapture,*input,*invalid,*keydown,*keypress,*keyup,*load,*loadeddata,*loadedmetadata,*loadstart,*lostpointercapture,*mousedown,*mouseenter,*mouseleave,*mousemove,*mouseout,*mouseover,*mouseup,*mousewheel,*pause,*play,*playing,*pointercancel,*pointerdown,*pointerenter,*pointerleave,*pointermove,*pointerout,*pointerover,*pointerup,*progress,*ratechange,*reset,*resize,*scroll,*seeked,*seeking,*select,*show,*stalled,*submit,*suspend,*timeupdate,*toggle,*volumechange,*waiting,%style,#tabIndex",
":svg:graphics^:svg:|",":svg:animation^:svg:|*begin,*end,*repeat",":svg:geometry^:svg:|",":svg:componentTransferFunction^:svg:|",":svg:gradient^:svg:|",":svg:textContent^:svg:graphics|",":svg:textPositioning^:svg:textContent|","a^[HTMLElement]|charset,coords,download,hash,host,hostname,href,hreflang,name,password,pathname,ping,port,protocol,referrerPolicy,rel,rev,search,shape,target,text,type,username","area^[HTMLElement]|alt,coords,download,hash,host,hostname,href,!noHref,password,pathname,ping,port,protocol,referrerPolicy,rel,search,shape,target,username",
"audio^media|","br^[HTMLElement]|clear","base^[HTMLElement]|href,target","body^[HTMLElement]|aLink,background,bgColor,link,*beforeunload,*blur,*error,*focus,*hashchange,*languagechange,*load,*message,*offline,*online,*pagehide,*pageshow,*popstate,*rejectionhandled,*resize,*scroll,*storage,*unhandledrejection,*unload,text,vLink","button^[HTMLElement]|!autofocus,!disabled,formAction,formEnctype,formMethod,!formNoValidate,formTarget,name,type,value","canvas^[HTMLElement]|#height,#width","content^[HTMLElement]|select",
"dl^[HTMLElement]|!compact","datalist^[HTMLElement]|","details^[HTMLElement]|!open","dialog^[HTMLElement]|!open,returnValue","dir^[HTMLElement]|!compact","div^[HTMLElement]|align","embed^[HTMLElement]|align,height,name,src,type,width","fieldset^[HTMLElement]|!disabled,name","font^[HTMLElement]|color,face,size","form^[HTMLElement]|acceptCharset,action,autocomplete,encoding,enctype,method,name,!noValidate,target","frame^[HTMLElement]|frameBorder,longDesc,marginHeight,marginWidth,name,!noResize,scrolling,src",
"frameset^[HTMLElement]|cols,*beforeunload,*blur,*error,*focus,*hashchange,*languagechange,*load,*message,*offline,*online,*pagehide,*pageshow,*popstate,*rejectionhandled,*resize,*scroll,*storage,*unhandledrejection,*unload,rows","hr^[HTMLElement]|align,color,!noShade,size,width","head^[HTMLElement]|","h1,h2,h3,h4,h5,h6^[HTMLElement]|align","html^[HTMLElement]|version","iframe^[HTMLElement]|align,!allowFullscreen,frameBorder,height,longDesc,marginHeight,marginWidth,name,referrerPolicy,%sandbox,scrolling,src,srcdoc,width",
"img^[HTMLElement]|align,alt,border,%crossOrigin,#height,#hspace,!isMap,longDesc,lowsrc,name,referrerPolicy,sizes,src,srcset,useMap,#vspace,#width","input^[HTMLElement]|accept,align,alt,autocapitalize,autocomplete,!autofocus,!checked,!defaultChecked,defaultValue,dirName,!disabled,%files,formAction,formEnctype,formMethod,!formNoValidate,formTarget,#height,!incremental,!indeterminate,max,#maxLength,min,#minLength,!multiple,name,pattern,placeholder,!readOnly,!required,selectionDirection,#selectionEnd,#selectionStart,#size,src,step,type,useMap,value,%valueAsDate,#valueAsNumber,#width",
"li^[HTMLElement]|type,#value","label^[HTMLElement]|htmlFor","legend^[HTMLElement]|align","link^[HTMLElement]|as,charset,%crossOrigin,!disabled,href,hreflang,integrity,media,referrerPolicy,rel,%relList,rev,%sizes,target,type","map^[HTMLElement]|name","marquee^[HTMLElement]|behavior,bgColor,direction,height,#hspace,#loop,#scrollAmount,#scrollDelay,!trueSpeed,#vspace,width","menu^[HTMLElement]|!compact","meta^[HTMLElement]|content,httpEquiv,name,scheme","meter^[HTMLElement]|#high,#low,#max,#min,#optimum,#value",
"ins,del^[HTMLElement]|cite,dateTime","ol^[HTMLElement]|!compact,!reversed,#start,type","object^[HTMLElement]|align,archive,border,code,codeBase,codeType,data,!declare,height,#hspace,name,standby,type,useMap,#vspace,width","optgroup^[HTMLElement]|!disabled,label","option^[HTMLElement]|!defaultSelected,!disabled,label,!selected,text,value","output^[HTMLElement]|defaultValue,%htmlFor,name,value","p^[HTMLElement]|align","param^[HTMLElement]|name,type,value,valueType","picture^[HTMLElement]|","pre^[HTMLElement]|#width",
"progress^[HTMLElement]|#max,#value","q,blockquote,cite^[HTMLElement]|","script^[HTMLElement]|!async,charset,%crossOrigin,!defer,event,htmlFor,integrity,src,text,type","select^[HTMLElement]|autocomplete,!autofocus,!disabled,#length,!multiple,name,!required,#selectedIndex,#size,value","shadow^[HTMLElement]|","slot^[HTMLElement]|name","source^[HTMLElement]|media,sizes,src,srcset,type","span^[HTMLElement]|","style^[HTMLElement]|!disabled,media,type","caption^[HTMLElement]|align","th,td^[HTMLElement]|abbr,align,axis,bgColor,ch,chOff,#colSpan,headers,height,!noWrap,#rowSpan,scope,vAlign,width",
"col,colgroup^[HTMLElement]|align,ch,chOff,#span,vAlign,width","table^[HTMLElement]|align,bgColor,border,%caption,cellPadding,cellSpacing,frame,rules,summary,%tFoot,%tHead,width","tr^[HTMLElement]|align,bgColor,ch,chOff,vAlign","tfoot,thead,tbody^[HTMLElement]|align,ch,chOff,vAlign","template^[HTMLElement]|","textarea^[HTMLElement]|autocapitalize,autocomplete,!autofocus,#cols,defaultValue,dirName,!disabled,#maxLength,#minLength,name,placeholder,!readOnly,!required,#rows,selectionDirection,#selectionEnd,#selectionStart,value,wrap",
"title^[HTMLElement]|text","track^[HTMLElement]|!default,kind,label,src,srclang","ul^[HTMLElement]|!compact,type","unknown^[HTMLElement]|","video^media|#height,poster,#width",":svg:a^:svg:graphics|",":svg:animate^:svg:animation|",":svg:animateMotion^:svg:animation|",":svg:animateTransform^:svg:animation|",":svg:circle^:svg:geometry|",":svg:clipPath^:svg:graphics|",":svg:defs^:svg:graphics|",":svg:desc^:svg:|",":svg:discard^:svg:|",":svg:ellipse^:svg:geometry|",":svg:feBlend^:svg:|",":svg:feColorMatrix^:svg:|",
":svg:feComponentTransfer^:svg:|",":svg:feComposite^:svg:|",":svg:feConvolveMatrix^:svg:|",":svg:feDiffuseLighting^:svg:|",":svg:feDisplacementMap^:svg:|",":svg:feDistantLight^:svg:|",":svg:feDropShadow^:svg:|",":svg:feFlood^:svg:|",":svg:feFuncA^:svg:componentTransferFunction|",":svg:feFuncB^:svg:componentTransferFunction|",":svg:feFuncG^:svg:componentTransferFunction|",":svg:feFuncR^:svg:componentTransferFunction|",":svg:feGaussianBlur^:svg:|",":svg:feImage^:svg:|",":svg:feMerge^:svg:|",":svg:feMergeNode^:svg:|",
":svg:feMorphology^:svg:|",":svg:feOffset^:svg:|",":svg:fePointLight^:svg:|",":svg:feSpecularLighting^:svg:|",":svg:feSpotLight^:svg:|",":svg:feTile^:svg:|",":svg:feTurbulence^:svg:|",":svg:filter^:svg:|",":svg:foreignObject^:svg:graphics|",":svg:g^:svg:graphics|",":svg:image^:svg:graphics|",":svg:line^:svg:geometry|",":svg:linearGradient^:svg:gradient|",":svg:mpath^:svg:|",":svg:marker^:svg:|",":svg:mask^:svg:|",":svg:metadata^:svg:|",":svg:path^:svg:geometry|",":svg:pattern^:svg:|",":svg:polygon^:svg:geometry|",
":svg:polyline^:svg:geometry|",":svg:radialGradient^:svg:gradient|",":svg:rect^:svg:geometry|",":svg:svg^:svg:graphics|#currentScale,#zoomAndPan",":svg:script^:svg:|type",":svg:set^:svg:animation|",":svg:stop^:svg:|",":svg:style^:svg:|!disabled,media,title,type",":svg:switch^:svg:graphics|",":svg:symbol^:svg:|",":svg:tspan^:svg:textPositioning|",":svg:text^:svg:textPositioning|",":svg:textPath^:svg:textContent|",":svg:title^:svg:|",":svg:use^:svg:graphics|",":svg:view^:svg:|#zoomAndPan","data^[HTMLElement]|value",
"keygen^[HTMLElement]|!autofocus,challenge,!disabled,form,keytype,name","menuitem^[HTMLElement]|type,label,icon,!disabled,!checked,radiogroup,!default","summary^[HTMLElement]|","time^[HTMLElement]|dateTime",":svg:cursor^:svg:|"];const _ATTR_TO_PROP={"class":"className","for":"htmlFor","formaction":"formAction","innerHtml":"innerHTML","readonly":"readOnly","tabindex":"tabIndex"};const _PROP_TO_ATTR=Object.keys(_ATTR_TO_PROP).reduce((inverted,attr)=>{inverted[_ATTR_TO_PROP[attr]]=attr;return inverted},
{});class DomElementSchemaRegistry extends ElementSchemaRegistry{constructor(){super();this._schema={};this._eventSchema={};SCHEMA.forEach(encodedType=>{const type={};const events=new Set;const [strType,strProperties]=encodedType.split("|");const properties=strProperties.split(",");const [typeNames,superName]=strType.split("^");typeNames.split(",").forEach(tag=>{this._schema[tag.toLowerCase()]=type;this._eventSchema[tag.toLowerCase()]=events});const superType=superName&&this._schema[superName.toLowerCase()];
if(superType){Object.keys(superType).forEach(prop=>{type[prop]=superType[prop]});for(const superEvent of this._eventSchema[superName.toLowerCase()])events.add(superEvent)}properties.forEach(property=>{if(property.length>0)switch(property[0]){case "*":events.add(property.substring(1));break;case "!":type[property.substring(1)]=BOOLEAN;break;case "#":type[property.substring(1)]=NUMBER;break;case "%":type[property.substring(1)]=OBJECT;break;default:type[property]=STRING}})})}hasProperty(tagName,propName,
schemaMetas){if(schemaMetas.some(schema=>schema.name===NO_ERRORS_SCHEMA.name))return true;if(tagName.indexOf("-")>-1){if(isNgContainer(tagName)||isNgContent(tagName))return false;if(schemaMetas.some(schema=>schema.name===CUSTOM_ELEMENTS_SCHEMA.name))return true}const elementProperties=this._schema[tagName.toLowerCase()]||this._schema["unknown"];return!!elementProperties[propName]}hasElement(tagName,schemaMetas){if(schemaMetas.some(schema=>schema.name===NO_ERRORS_SCHEMA.name))return true;if(tagName.indexOf("-")>
-1){if(isNgContainer(tagName)||isNgContent(tagName))return true;if(schemaMetas.some(schema=>schema.name===CUSTOM_ELEMENTS_SCHEMA.name))return true}return!!this._schema[tagName.toLowerCase()]}securityContext(tagName,propName,isAttribute){if(isAttribute)propName=this.getMappedPropName(propName);tagName=tagName.toLowerCase();propName=propName.toLowerCase();let ctx=SECURITY_SCHEMA()[tagName+"|"+propName];if(ctx)return ctx;ctx=SECURITY_SCHEMA()["*|"+propName];return ctx?ctx:SecurityContext.NONE}getMappedPropName(propName){return _ATTR_TO_PROP[propName]||
propName}getDefaultComponentElementName(){return"ng-component"}validateProperty(name){if(name.toLowerCase().startsWith("on")){const msg=`Binding to event property '${name}' is disallowed for security reasons, `+`please use (${name.slice(2)})=...`+`\nIf '${name}' is a directive input, make sure the directive is imported by the`+` current module.`;return{error:true,msg:msg}}else return{error:false}}validateAttribute(name){if(name.toLowerCase().startsWith("on")){const msg=`Binding to event attribute '${name}' is disallowed for security reasons, `+
`please use (${name.slice(2)})=...`;return{error:true,msg:msg}}else return{error:false}}allKnownElementNames(){return Object.keys(this._schema)}allKnownAttributesOfElement(tagName){const elementProperties=this._schema[tagName.toLowerCase()]||this._schema["unknown"];return Object.keys(elementProperties).map(prop=>{var _a;return(_a=_PROP_TO_ATTR[prop])!==null&&_a!==void 0?_a:prop})}allKnownEventsOfElement(tagName){var _a;return Array.from((_a=this._eventSchema[tagName.toLowerCase()])!==null&&_a!==void 0?
_a:[])}normalizeAnimationStyleProperty(propName){return dashCaseToCamelCase(propName)}normalizeAnimationStyleValue(camelCaseProp,userProvidedProp,val){let unit="";const strVal=val.toString().trim();let errorMsg=null;if(_isPixelDimensionStyle(camelCaseProp)&&val!==0&&val!=="0")if(typeof val==="number")unit="px";else{const valAndSuffixMatch=val.match(/^[+-]?[\d\.]+([a-z]*)$/);if(valAndSuffixMatch&&valAndSuffixMatch[1].length==0)errorMsg=`Please provide a CSS unit value for ${userProvidedProp}:${val}`}return{error:errorMsg,
value:strVal+unit}}}function _isPixelDimensionStyle(prop){switch(prop){case "width":case "height":case "minWidth":case "minHeight":case "maxWidth":case "maxHeight":case "left":case "top":case "bottom":case "right":case "fontSize":case "outlineWidth":case "outlineOffset":case "paddingTop":case "paddingLeft":case "paddingBottom":case "paddingRight":case "marginTop":case "marginLeft":case "marginBottom":case "marginRight":case "borderRadius":case "borderWidth":case "borderTopWidth":case "borderLeftWidth":case "borderRightWidth":case "borderBottomWidth":case "textIndent":return true;
default:return false}}const TRUSTED_TYPES_SINKS=new Set(["iframe|srcdoc","*|innerhtml","*|outerhtml","embed|src","object|codebase","object|data"]);function isTrustedTypesSink(tagName,propName){tagName=tagName.toLowerCase();propName=propName.toLowerCase();return TRUSTED_TYPES_SINKS.has(tagName+"|"+propName)||TRUSTED_TYPES_SINKS.has("*|"+propName)}const PROPERTY_PARTS_SEPARATOR=".";const ATTRIBUTE_PREFIX="attr";const CLASS_PREFIX="class";const STYLE_PREFIX="style";const TEMPLATE_ATTR_PREFIX$1="*";const ANIMATE_PROP_PREFIX=
"animate-";class BindingParser{constructor(_exprParser,_interpolationConfig,_schemaRegistry,errors){this._exprParser=_exprParser;this._interpolationConfig=_interpolationConfig;this._schemaRegistry=_schemaRegistry;this.errors=errors}get interpolationConfig(){return this._interpolationConfig}createBoundHostProperties(properties,sourceSpan){const boundProps=[];for(const propName of Object.keys(properties)){const expression=properties[propName];if(typeof expression==="string")this.parsePropertyBinding(propName,
expression,true,sourceSpan,sourceSpan.start.offset,undefined,[],boundProps,sourceSpan);else this._reportError(`Value of the host property binding "${propName}" needs to be a string representing an expression but got "${expression}" (${typeof expression})`,sourceSpan)}return boundProps}createDirectiveHostEventAsts(hostListeners,sourceSpan){const targetEvents=[];for(const propName of Object.keys(hostListeners)){const expression=hostListeners[propName];if(typeof expression==="string")this.parseEvent(propName,
expression,sourceSpan,sourceSpan,[],targetEvents,sourceSpan);else this._reportError(`Value of the host listener "${propName}" needs to be a string representing an expression but got "${expression}" (${typeof expression})`,sourceSpan)}return targetEvents}parseInterpolation(value,sourceSpan){const sourceInfo=sourceSpan.start.toString();const absoluteOffset=sourceSpan.fullStart.offset;try{const ast=this._exprParser.parseInterpolation(value,sourceInfo,absoluteOffset,this._interpolationConfig);if(ast)this._reportExpressionParserErrors(ast.errors,
sourceSpan);return ast}catch(e){this._reportError(`${e}`,sourceSpan);return this._exprParser.wrapLiteralPrimitive("ERROR",sourceInfo,absoluteOffset)}}parseInterpolationExpression(expression,sourceSpan){const sourceInfo=sourceSpan.start.toString();const absoluteOffset=sourceSpan.start.offset;try{const ast=this._exprParser.parseInterpolationExpression(expression,sourceInfo,absoluteOffset);if(ast)this._reportExpressionParserErrors(ast.errors,sourceSpan);return ast}catch(e){this._reportError(`${e}`,sourceSpan);
return this._exprParser.wrapLiteralPrimitive("ERROR",sourceInfo,absoluteOffset)}}parseInlineTemplateBinding(tplKey,tplValue,sourceSpan,absoluteValueOffset,targetMatchableAttrs,targetProps,targetVars,isIvyAst){const absoluteKeyOffset=sourceSpan.start.offset+TEMPLATE_ATTR_PREFIX$1.length;const bindings=this._parseTemplateBindings(tplKey,tplValue,sourceSpan,absoluteKeyOffset,absoluteValueOffset);for(const binding of bindings){const bindingSpan=moveParseSourceSpan(sourceSpan,binding.sourceSpan);const key=
binding.key.source;const keySpan=moveParseSourceSpan(sourceSpan,binding.key.span);if(binding instanceof VariableBinding){const value=binding.value?binding.value.source:"$implicit";const valueSpan=binding.value?moveParseSourceSpan(sourceSpan,binding.value.span):undefined;targetVars.push(new ParsedVariable(key,value,bindingSpan,keySpan,valueSpan))}else if(binding.value){const srcSpan=isIvyAst?bindingSpan:sourceSpan;const valueSpan=moveParseSourceSpan(sourceSpan,binding.value.ast.sourceSpan);this._parsePropertyAst(key,
binding.value,srcSpan,keySpan,valueSpan,targetMatchableAttrs,targetProps)}else{targetMatchableAttrs.push([key,""]);this.parseLiteralAttr(key,null,keySpan,absoluteValueOffset,undefined,targetMatchableAttrs,targetProps,keySpan)}}}_parseTemplateBindings(tplKey,tplValue,sourceSpan,absoluteKeyOffset,absoluteValueOffset){const sourceInfo=sourceSpan.start.toString();try{const bindingsResult=this._exprParser.parseTemplateBindings(tplKey,tplValue,sourceInfo,absoluteKeyOffset,absoluteValueOffset);this._reportExpressionParserErrors(bindingsResult.errors,
sourceSpan);bindingsResult.warnings.forEach(warning=>{this._reportError(warning,sourceSpan,exports.ParseErrorLevel.WARNING)});return bindingsResult.templateBindings}catch(e){this._reportError(`${e}`,sourceSpan);return[]}}parseLiteralAttr(name,value,sourceSpan,absoluteOffset,valueSpan,targetMatchableAttrs,targetProps,keySpan){if(isAnimationLabel(name)){name=name.substring(1);if(keySpan!==undefined)keySpan=moveParseSourceSpan(keySpan,new AbsoluteSourceSpan(keySpan.start.offset+1,keySpan.end.offset));
if(value)this._reportError(`Assigning animation triggers via @prop="exp" attributes with an expression is invalid.`+` Use property bindings (e.g. [@prop]="exp") or use an attribute without a value (e.g. @prop) instead.`,sourceSpan,exports.ParseErrorLevel.ERROR);this._parseAnimation(name,value,sourceSpan,absoluteOffset,keySpan,valueSpan,targetMatchableAttrs,targetProps)}else targetProps.push(new ParsedProperty(name,this._exprParser.wrapLiteralPrimitive(value,"",absoluteOffset),exports.ParsedPropertyType.LITERAL_ATTR,
sourceSpan,keySpan,valueSpan))}parsePropertyBinding(name,expression,isHost,sourceSpan,absoluteOffset,valueSpan,targetMatchableAttrs,targetProps,keySpan){if(name.length===0)this._reportError(`Property name is missing in binding`,sourceSpan);let isAnimationProp=false;if(name.startsWith(ANIMATE_PROP_PREFIX)){isAnimationProp=true;name=name.substring(ANIMATE_PROP_PREFIX.length);if(keySpan!==undefined)keySpan=moveParseSourceSpan(keySpan,new AbsoluteSourceSpan(keySpan.start.offset+ANIMATE_PROP_PREFIX.length,
keySpan.end.offset))}else if(isAnimationLabel(name)){isAnimationProp=true;name=name.substring(1);if(keySpan!==undefined)keySpan=moveParseSourceSpan(keySpan,new AbsoluteSourceSpan(keySpan.start.offset+1,keySpan.end.offset))}if(isAnimationProp)this._parseAnimation(name,expression,sourceSpan,absoluteOffset,keySpan,valueSpan,targetMatchableAttrs,targetProps);else this._parsePropertyAst(name,this._parseBinding(expression,isHost,valueSpan||sourceSpan,absoluteOffset),sourceSpan,keySpan,valueSpan,targetMatchableAttrs,
targetProps)}parsePropertyInterpolation(name,value,sourceSpan,valueSpan,targetMatchableAttrs,targetProps,keySpan){const expr=this.parseInterpolation(value,valueSpan||sourceSpan);if(expr){this._parsePropertyAst(name,expr,sourceSpan,keySpan,valueSpan,targetMatchableAttrs,targetProps);return true}return false}_parsePropertyAst(name,ast,sourceSpan,keySpan,valueSpan,targetMatchableAttrs,targetProps){targetMatchableAttrs.push([name,ast.source]);targetProps.push(new ParsedProperty(name,ast,exports.ParsedPropertyType.DEFAULT,
sourceSpan,keySpan,valueSpan))}_parseAnimation(name,expression,sourceSpan,absoluteOffset,keySpan,valueSpan,targetMatchableAttrs,targetProps){if(name.length===0)this._reportError("Animation trigger is missing",sourceSpan);const ast=this._parseBinding(expression||"undefined",false,valueSpan||sourceSpan,absoluteOffset);targetMatchableAttrs.push([name,ast.source]);targetProps.push(new ParsedProperty(name,ast,exports.ParsedPropertyType.ANIMATION,sourceSpan,keySpan,valueSpan))}_parseBinding(value,isHostBinding,
sourceSpan,absoluteOffset){const sourceInfo=(sourceSpan&&sourceSpan.start||"(unknown)").toString();try{const ast=isHostBinding?this._exprParser.parseSimpleBinding(value,sourceInfo,absoluteOffset,this._interpolationConfig):this._exprParser.parseBinding(value,sourceInfo,absoluteOffset,this._interpolationConfig);if(ast)this._reportExpressionParserErrors(ast.errors,sourceSpan);return ast}catch(e){this._reportError(`${e}`,sourceSpan);return this._exprParser.wrapLiteralPrimitive("ERROR",sourceInfo,absoluteOffset)}}createBoundElementProperty(elementSelector,
boundProp,skipValidation=false,mapPropertyName=true){if(boundProp.isAnimation)return new BoundElementProperty(boundProp.name,4,SecurityContext.NONE,boundProp.expression,null,boundProp.sourceSpan,boundProp.keySpan,boundProp.valueSpan);let unit=null;let bindingType=undefined;let boundPropertyName=null;const parts=boundProp.name.split(PROPERTY_PARTS_SEPARATOR);let securityContexts=undefined;if(parts.length>1)if(parts[0]==ATTRIBUTE_PREFIX){boundPropertyName=parts.slice(1).join(PROPERTY_PARTS_SEPARATOR);
if(!skipValidation)this._validatePropertyOrAttributeName(boundPropertyName,boundProp.sourceSpan,true);securityContexts=calcPossibleSecurityContexts(this._schemaRegistry,elementSelector,boundPropertyName,true);const nsSeparatorIdx=boundPropertyName.indexOf(":");if(nsSeparatorIdx>-1){const ns=boundPropertyName.substring(0,nsSeparatorIdx);const name=boundPropertyName.substring(nsSeparatorIdx+1);boundPropertyName=mergeNsAndName(ns,name)}bindingType=1}else if(parts[0]==CLASS_PREFIX){boundPropertyName=
parts[1];bindingType=2;securityContexts=[SecurityContext.NONE]}else if(parts[0]==STYLE_PREFIX){unit=parts.length>2?parts[2]:null;boundPropertyName=parts[1];bindingType=3;securityContexts=[SecurityContext.STYLE]}if(boundPropertyName===null){const mappedPropName=this._schemaRegistry.getMappedPropName(boundProp.name);boundPropertyName=mapPropertyName?mappedPropName:boundProp.name;securityContexts=calcPossibleSecurityContexts(this._schemaRegistry,elementSelector,mappedPropName,false);bindingType=0;if(!skipValidation)this._validatePropertyOrAttributeName(mappedPropName,
boundProp.sourceSpan,false)}return new BoundElementProperty(boundPropertyName,bindingType,securityContexts[0],boundProp.expression,unit,boundProp.sourceSpan,boundProp.keySpan,boundProp.valueSpan)}parseEvent(name,expression,sourceSpan,handlerSpan,targetMatchableAttrs,targetEvents,keySpan){if(name.length===0)this._reportError(`Event name is missing in binding`,sourceSpan);if(isAnimationLabel(name)){name=name.substr(1);if(keySpan!==undefined)keySpan=moveParseSourceSpan(keySpan,new AbsoluteSourceSpan(keySpan.start.offset+
1,keySpan.end.offset));this._parseAnimationEvent(name,expression,sourceSpan,handlerSpan,targetEvents,keySpan)}else this._parseRegularEvent(name,expression,sourceSpan,handlerSpan,targetMatchableAttrs,targetEvents,keySpan)}calcPossibleSecurityContexts(selector,propName,isAttribute){const prop=this._schemaRegistry.getMappedPropName(propName);return calcPossibleSecurityContexts(this._schemaRegistry,selector,prop,isAttribute)}_parseAnimationEvent(name,expression,sourceSpan,handlerSpan,targetEvents,keySpan){const matches=
splitAtPeriod(name,[name,""]);const eventName=matches[0];const phase=matches[1].toLowerCase();const ast=this._parseAction(expression,handlerSpan);targetEvents.push(new ParsedEvent(eventName,phase,1,ast,sourceSpan,handlerSpan,keySpan));if(eventName.length===0)this._reportError(`Animation event name is missing in binding`,sourceSpan);if(phase){if(phase!=="start"&&phase!=="done")this._reportError(`The provided animation output phase value "${phase}" for "@${eventName}" is not supported (use start or done)`,
sourceSpan)}else this._reportError(`The animation trigger output event (@${eventName}) is missing its phase value name (start or done are currently supported)`,sourceSpan)}_parseRegularEvent(name,expression,sourceSpan,handlerSpan,targetMatchableAttrs,targetEvents,keySpan){const [target,eventName]=splitAtColon(name,[null,name]);const ast=this._parseAction(expression,handlerSpan);targetMatchableAttrs.push([name,ast.source]);targetEvents.push(new ParsedEvent(eventName,target,0,ast,sourceSpan,handlerSpan,
keySpan))}_parseAction(value,sourceSpan){const sourceInfo=(sourceSpan&&sourceSpan.start||"(unknown").toString();const absoluteOffset=sourceSpan&&sourceSpan.start?sourceSpan.start.offset:0;try{const ast=this._exprParser.parseAction(value,sourceInfo,absoluteOffset,this._interpolationConfig);if(ast)this._reportExpressionParserErrors(ast.errors,sourceSpan);if(!ast||ast.ast instanceof EmptyExpr){this._reportError(`Empty expressions are not allowed`,sourceSpan);return this._exprParser.wrapLiteralPrimitive("ERROR",
sourceInfo,absoluteOffset)}return ast}catch(e){this._reportError(`${e}`,sourceSpan);return this._exprParser.wrapLiteralPrimitive("ERROR",sourceInfo,absoluteOffset)}}_reportError(message,sourceSpan,level=exports.ParseErrorLevel.ERROR){this.errors.push(new ParseError(sourceSpan,message,level))}_reportExpressionParserErrors(errors,sourceSpan){for(const error of errors)this._reportError(error.message,sourceSpan)}_validatePropertyOrAttributeName(propName,sourceSpan,isAttr){const report=isAttr?this._schemaRegistry.validateAttribute(propName):
this._schemaRegistry.validateProperty(propName);if(report.error)this._reportError(report.msg,sourceSpan,exports.ParseErrorLevel.ERROR)}}function isAnimationLabel(name){return name[0]=="@"}function calcPossibleSecurityContexts(registry,selector,propName,isAttribute){const ctxs=[];CssSelector.parse(selector).forEach(selector=>{const elementNames=selector.element?[selector.element]:registry.allKnownElementNames();const notElementNames=new Set(selector.notSelectors.filter(selector=>selector.isElementSelector()).map(selector=>
selector.element));const possibleElementNames=elementNames.filter(elementName=>!notElementNames.has(elementName));ctxs.push(...possibleElementNames.map(elementName=>registry.securityContext(elementName,propName,isAttribute)))});return ctxs.length===0?[SecurityContext.NONE]:Array.from(new Set(ctxs)).sort()}function moveParseSourceSpan(sourceSpan,absoluteSpan){const startDiff=absoluteSpan.start-sourceSpan.start.offset;const endDiff=absoluteSpan.end-sourceSpan.end.offset;return new ParseSourceSpan(sourceSpan.start.moveBy(startDiff),
sourceSpan.end.moveBy(endDiff),sourceSpan.fullStart.moveBy(startDiff),sourceSpan.details)}function isStyleUrlResolvable(url){if(url==null||url.length===0||url[0]=="/")return false;const schemeMatch=url.match(URL_WITH_SCHEMA_REGEXP);return schemeMatch===null||schemeMatch[1]=="package"||schemeMatch[1]=="asset"}const URL_WITH_SCHEMA_REGEXP=/^([^:/?#]+):/;const NG_CONTENT_SELECT_ATTR$1="select";const LINK_ELEMENT="link";const LINK_STYLE_REL_ATTR="rel";const LINK_STYLE_HREF_ATTR="href";const LINK_STYLE_REL_VALUE=
"stylesheet";const STYLE_ELEMENT="style";const SCRIPT_ELEMENT="script";const NG_NON_BINDABLE_ATTR="ngNonBindable";const NG_PROJECT_AS="ngProjectAs";function preparseElement(ast){let selectAttr=null;let hrefAttr=null;let relAttr=null;let nonBindable=false;let projectAs="";ast.attrs.forEach(attr=>{const lcAttrName=attr.name.toLowerCase();if(lcAttrName==NG_CONTENT_SELECT_ATTR$1)selectAttr=attr.value;else if(lcAttrName==LINK_STYLE_HREF_ATTR)hrefAttr=attr.value;else if(lcAttrName==LINK_STYLE_REL_ATTR)relAttr=
attr.value;else if(attr.name==NG_NON_BINDABLE_ATTR)nonBindable=true;else if(attr.name==NG_PROJECT_AS)if(attr.value.length>0)projectAs=attr.value});selectAttr=normalizeNgContentSelect(selectAttr);const nodeName=ast.name.toLowerCase();let type=PreparsedElementType.OTHER;if(isNgContent(nodeName))type=PreparsedElementType.NG_CONTENT;else if(nodeName==STYLE_ELEMENT)type=PreparsedElementType.STYLE;else if(nodeName==SCRIPT_ELEMENT)type=PreparsedElementType.SCRIPT;else if(nodeName==LINK_ELEMENT&&relAttr==
LINK_STYLE_REL_VALUE)type=PreparsedElementType.STYLESHEET;return new PreparsedElement(type,selectAttr,hrefAttr,nonBindable,projectAs)}var PreparsedElementType;(function(PreparsedElementType){PreparsedElementType[PreparsedElementType["NG_CONTENT"]=0]="NG_CONTENT";PreparsedElementType[PreparsedElementType["STYLE"]=1]="STYLE";PreparsedElementType[PreparsedElementType["STYLESHEET"]=2]="STYLESHEET";PreparsedElementType[PreparsedElementType["SCRIPT"]=3]="SCRIPT";PreparsedElementType[PreparsedElementType["OTHER"]=
4]="OTHER"})(PreparsedElementType||(PreparsedElementType={}));class PreparsedElement{constructor(type,selectAttr,hrefAttr,nonBindable,projectAs){this.type=type;this.selectAttr=selectAttr;this.hrefAttr=hrefAttr;this.nonBindable=nonBindable;this.projectAs=projectAs}}function normalizeNgContentSelect(selectAttr){if(selectAttr===null||selectAttr.length===0)return"*";return selectAttr}const BIND_NAME_REGEXP=/^(?:(bind-)|(let-)|(ref-|#)|(on-)|(bindon-)|(@))(.*)$/;const KW_BIND_IDX=1;const KW_LET_IDX=2;
const KW_REF_IDX=3;const KW_ON_IDX=4;const KW_BINDON_IDX=5;const KW_AT_IDX=6;const IDENT_KW_IDX=7;const BINDING_DELIMS={BANANA_BOX:{start:"[(",end:")]"},PROPERTY:{start:"[",end:"]"},EVENT:{start:"(",end:")"}};const TEMPLATE_ATTR_PREFIX="*";function htmlAstToRender3Ast(htmlNodes,bindingParser,options){const transformer=new HtmlAstToIvyAst(bindingParser,options);const ivyNodes=visitAll(transformer,htmlNodes);const allErrors=bindingParser.errors.concat(transformer.errors);const result={nodes:ivyNodes,
errors:allErrors,styleUrls:transformer.styleUrls,styles:transformer.styles,ngContentSelectors:transformer.ngContentSelectors};if(options.collectCommentNodes)result.commentNodes=transformer.commentNodes;return result}class HtmlAstToIvyAst{constructor(bindingParser,options){this.bindingParser=bindingParser;this.options=options;this.errors=[];this.styles=[];this.styleUrls=[];this.ngContentSelectors=[];this.commentNodes=[];this.inI18nBlock=false}visitElement(element){const isI18nRootElement=isI18nRootNode(element.i18n);
if(isI18nRootElement){if(this.inI18nBlock)this.reportError("Cannot mark an element as translatable inside of a translatable section. Please remove the nested i18n marker.",element.sourceSpan);this.inI18nBlock=true}const preparsedElement=preparseElement(element);if(preparsedElement.type===PreparsedElementType.SCRIPT)return null;else if(preparsedElement.type===PreparsedElementType.STYLE){const contents=textContents(element);if(contents!==null)this.styles.push(contents);return null}else if(preparsedElement.type===
PreparsedElementType.STYLESHEET&&isStyleUrlResolvable(preparsedElement.hrefAttr)){this.styleUrls.push(preparsedElement.hrefAttr);return null}const isTemplateElement=isNgTemplate(element.name);const parsedProperties=[];const boundEvents=[];const variables=[];const references=[];const attributes=[];const i18nAttrsMeta={};const templateParsedProperties=[];const templateVariables=[];let elementHasInlineTemplate=false;for(const attribute of element.attrs){let hasBinding=false;const normalizedName=normalizeAttributeName(attribute.name);
let isTemplateBinding=false;if(attribute.i18n)i18nAttrsMeta[attribute.name]=attribute.i18n;if(normalizedName.startsWith(TEMPLATE_ATTR_PREFIX)){if(elementHasInlineTemplate)this.reportError(`Can't have multiple template bindings on one element. Use only one attribute prefixed with *`,attribute.sourceSpan);isTemplateBinding=true;elementHasInlineTemplate=true;const templateValue=attribute.value;const templateKey=normalizedName.substring(TEMPLATE_ATTR_PREFIX.length);const parsedVariables=[];const absoluteValueOffset=
attribute.valueSpan?attribute.valueSpan.start.offset:attribute.sourceSpan.start.offset+attribute.name.length;this.bindingParser.parseInlineTemplateBinding(templateKey,templateValue,attribute.sourceSpan,absoluteValueOffset,[],templateParsedProperties,parsedVariables,true);templateVariables.push(...parsedVariables.map(v=>new Variable(v.name,v.value,v.sourceSpan,v.keySpan,v.valueSpan)))}else hasBinding=this.parseAttribute(isTemplateElement,attribute,[],parsedProperties,boundEvents,variables,references);
if(!hasBinding&&!isTemplateBinding)attributes.push(this.visitAttribute(attribute))}const children=visitAll(preparsedElement.nonBindable?NON_BINDABLE_VISITOR:this,element.children);let parsedElement;if(preparsedElement.type===PreparsedElementType.NG_CONTENT){if(element.children&&!element.children.every(node=>isEmptyTextNode(node)||isCommentNode(node)))this.reportError(`<ng-content> element cannot have content.`,element.sourceSpan);const selector=preparsedElement.selectAttr;const attrs=element.attrs.map(attr=>
this.visitAttribute(attr));parsedElement=new Content(selector,attrs,element.sourceSpan,element.i18n);this.ngContentSelectors.push(selector)}else if(isTemplateElement){const attrs=this.extractAttributes(element.name,parsedProperties,i18nAttrsMeta);parsedElement=new Template(element.name,attributes,attrs.bound,boundEvents,[],children,references,variables,element.sourceSpan,element.startSourceSpan,element.endSourceSpan,element.i18n)}else{const attrs=this.extractAttributes(element.name,parsedProperties,
i18nAttrsMeta);parsedElement=new Element$1(element.name,attributes,attrs.bound,boundEvents,children,references,element.sourceSpan,element.startSourceSpan,element.endSourceSpan,element.i18n)}if(elementHasInlineTemplate){const attrs=this.extractAttributes("ng-template",templateParsedProperties,i18nAttrsMeta);const templateAttrs=[];attrs.literal.forEach(attr=>templateAttrs.push(attr));attrs.bound.forEach(attr=>templateAttrs.push(attr));const hoistedAttrs=parsedElement instanceof Element$1?{attributes:parsedElement.attributes,
inputs:parsedElement.inputs,outputs:parsedElement.outputs}:{attributes:[],inputs:[],outputs:[]};const i18n=isTemplateElement&&isI18nRootElement?undefined:element.i18n;parsedElement=new Template(parsedElement.name,hoistedAttrs.attributes,hoistedAttrs.inputs,hoistedAttrs.outputs,templateAttrs,[parsedElement],[],templateVariables,element.sourceSpan,element.startSourceSpan,element.endSourceSpan,i18n)}if(isI18nRootElement)this.inI18nBlock=false;return parsedElement}visitAttribute(attribute){return new TextAttribute(attribute.name,
attribute.value,attribute.sourceSpan,attribute.keySpan,attribute.valueSpan,attribute.i18n)}visitText(text){return this._visitTextWithInterpolation(text.value,text.sourceSpan,text.i18n)}visitExpansion(expansion){if(!expansion.i18n)return null;if(!isI18nRootNode(expansion.i18n))throw new Error(`Invalid type "${expansion.i18n.constructor}" for "i18n" property of ${expansion.sourceSpan.toString()}. Expected a "Message"`);const message=expansion.i18n;const vars={};const placeholders={};Object.keys(message.placeholders).forEach(key=>
{const value=message.placeholders[key];if(key.startsWith(I18N_ICU_VAR_PREFIX)){const formattedKey=key.trim();const ast=this.bindingParser.parseInterpolationExpression(value.text,value.sourceSpan);vars[formattedKey]=new BoundText(ast,value.sourceSpan)}else placeholders[key]=this._visitTextWithInterpolation(value.text,value.sourceSpan)});return new Icu$1(vars,placeholders,expansion.sourceSpan,message)}visitExpansionCase(expansionCase){return null}visitComment(comment){if(this.options.collectCommentNodes)this.commentNodes.push(new Comment$1(comment.value||
"",comment.sourceSpan));return null}extractAttributes(elementName,properties,i18nPropsMeta){const bound=[];const literal=[];properties.forEach(prop=>{const i18n=i18nPropsMeta[prop.name];if(prop.isLiteral)literal.push(new TextAttribute(prop.name,prop.expression.source||"",prop.sourceSpan,prop.keySpan,prop.valueSpan,i18n));else{const bep=this.bindingParser.createBoundElementProperty(elementName,prop,true,false);bound.push(BoundAttribute.fromBoundElementProperty(bep,i18n))}});return{bound,literal}}parseAttribute(isTemplateElement,
attribute,matchableAttributes,parsedProperties,boundEvents,variables,references){const name=normalizeAttributeName(attribute.name);const value=attribute.value;const srcSpan=attribute.sourceSpan;const absoluteOffset=attribute.valueSpan?attribute.valueSpan.start.offset:srcSpan.start.offset;function createKeySpan(srcSpan,prefix,identifier){const normalizationAdjustment=attribute.name.length-name.length;const keySpanStart=srcSpan.start.moveBy(prefix.length+normalizationAdjustment);const keySpanEnd=keySpanStart.moveBy(identifier.length);
return new ParseSourceSpan(keySpanStart,keySpanEnd,keySpanStart,identifier)}const bindParts=name.match(BIND_NAME_REGEXP);if(bindParts){if(bindParts[KW_BIND_IDX]!=null){const identifier=bindParts[IDENT_KW_IDX];const keySpan=createKeySpan(srcSpan,bindParts[KW_BIND_IDX],identifier);this.bindingParser.parsePropertyBinding(identifier,value,false,srcSpan,absoluteOffset,attribute.valueSpan,matchableAttributes,parsedProperties,keySpan)}else if(bindParts[KW_LET_IDX])if(isTemplateElement){const identifier=
bindParts[IDENT_KW_IDX];const keySpan=createKeySpan(srcSpan,bindParts[KW_LET_IDX],identifier);this.parseVariable(identifier,value,srcSpan,keySpan,attribute.valueSpan,variables)}else this.reportError(`"let-" is only supported on ng-template elements.`,srcSpan);else if(bindParts[KW_REF_IDX]){const identifier=bindParts[IDENT_KW_IDX];const keySpan=createKeySpan(srcSpan,bindParts[KW_REF_IDX],identifier);this.parseReference(identifier,value,srcSpan,keySpan,attribute.valueSpan,references)}else if(bindParts[KW_ON_IDX]){const events=
[];const identifier=bindParts[IDENT_KW_IDX];const keySpan=createKeySpan(srcSpan,bindParts[KW_ON_IDX],identifier);this.bindingParser.parseEvent(identifier,value,srcSpan,attribute.valueSpan||srcSpan,matchableAttributes,events,keySpan);addEvents(events,boundEvents)}else if(bindParts[KW_BINDON_IDX]){const identifier=bindParts[IDENT_KW_IDX];const keySpan=createKeySpan(srcSpan,bindParts[KW_BINDON_IDX],identifier);this.bindingParser.parsePropertyBinding(identifier,value,false,srcSpan,absoluteOffset,attribute.valueSpan,
matchableAttributes,parsedProperties,keySpan);this.parseAssignmentEvent(identifier,value,srcSpan,attribute.valueSpan,matchableAttributes,boundEvents,keySpan)}else if(bindParts[KW_AT_IDX]){const keySpan=createKeySpan(srcSpan,"",name);this.bindingParser.parseLiteralAttr(name,value,srcSpan,absoluteOffset,attribute.valueSpan,matchableAttributes,parsedProperties,keySpan)}return true}let delims=null;if(name.startsWith(BINDING_DELIMS.BANANA_BOX.start))delims=BINDING_DELIMS.BANANA_BOX;else if(name.startsWith(BINDING_DELIMS.PROPERTY.start))delims=
BINDING_DELIMS.PROPERTY;else if(name.startsWith(BINDING_DELIMS.EVENT.start))delims=BINDING_DELIMS.EVENT;if(delims!==null&&name.endsWith(delims.end)&&name.length>delims.start.length+delims.end.length){const identifier=name.substring(delims.start.length,name.length-delims.end.length);const keySpan=createKeySpan(srcSpan,delims.start,identifier);if(delims.start===BINDING_DELIMS.BANANA_BOX.start){this.bindingParser.parsePropertyBinding(identifier,value,false,srcSpan,absoluteOffset,attribute.valueSpan,
matchableAttributes,parsedProperties,keySpan);this.parseAssignmentEvent(identifier,value,srcSpan,attribute.valueSpan,matchableAttributes,boundEvents,keySpan)}else if(delims.start===BINDING_DELIMS.PROPERTY.start)this.bindingParser.parsePropertyBinding(identifier,value,false,srcSpan,absoluteOffset,attribute.valueSpan,matchableAttributes,parsedProperties,keySpan);else{const events=[];this.bindingParser.parseEvent(identifier,value,srcSpan,attribute.valueSpan||srcSpan,matchableAttributes,events,keySpan);
addEvents(events,boundEvents)}return true}const keySpan=createKeySpan(srcSpan,"",name);const hasBinding=this.bindingParser.parsePropertyInterpolation(name,value,srcSpan,attribute.valueSpan,matchableAttributes,parsedProperties,keySpan);return hasBinding}_visitTextWithInterpolation(value,sourceSpan,i18n){const valueNoNgsp=replaceNgsp(value);const expr=this.bindingParser.parseInterpolation(valueNoNgsp,sourceSpan);return expr?new BoundText(expr,sourceSpan,i18n):new Text$3(valueNoNgsp,sourceSpan)}parseVariable(identifier,
value,sourceSpan,keySpan,valueSpan,variables){if(identifier.indexOf("-")>-1)this.reportError(`"-" is not allowed in variable names`,sourceSpan);else if(identifier.length===0)this.reportError(`Variable does not have a name`,sourceSpan);variables.push(new Variable(identifier,value,sourceSpan,keySpan,valueSpan))}parseReference(identifier,value,sourceSpan,keySpan,valueSpan,references){if(identifier.indexOf("-")>-1)this.reportError(`"-" is not allowed in reference names`,sourceSpan);else if(identifier.length===
0)this.reportError(`Reference does not have a name`,sourceSpan);else if(references.some(reference=>reference.name===identifier))this.reportError(`Reference "#${identifier}" is defined more than once`,sourceSpan);references.push(new Reference(identifier,value,sourceSpan,keySpan,valueSpan))}parseAssignmentEvent(name,expression,sourceSpan,valueSpan,targetMatchableAttrs,boundEvents,keySpan){const events=[];this.bindingParser.parseEvent(`${name}Change`,`${expression}=$event`,sourceSpan,valueSpan||sourceSpan,
targetMatchableAttrs,events,keySpan);addEvents(events,boundEvents)}reportError(message,sourceSpan,level=exports.ParseErrorLevel.ERROR){this.errors.push(new ParseError(sourceSpan,message,level))}}class NonBindableVisitor{visitElement(ast){const preparsedElement=preparseElement(ast);if(preparsedElement.type===PreparsedElementType.SCRIPT||preparsedElement.type===PreparsedElementType.STYLE||preparsedElement.type===PreparsedElementType.STYLESHEET)return null;const children=visitAll(this,ast.children,null);
return new Element$1(ast.name,visitAll(this,ast.attrs),[],[],children,[],ast.sourceSpan,ast.startSourceSpan,ast.endSourceSpan)}visitComment(comment){return null}visitAttribute(attribute){return new TextAttribute(attribute.name,attribute.value,attribute.sourceSpan,attribute.keySpan,attribute.valueSpan,attribute.i18n)}visitText(text){return new Text$3(text.value,text.sourceSpan)}visitExpansion(expansion){return null}visitExpansionCase(expansionCase){return null}}const NON_BINDABLE_VISITOR=new NonBindableVisitor;
function normalizeAttributeName(attrName){return/^data-/i.test(attrName)?attrName.substring(5):attrName}function addEvents(events,boundEvents){boundEvents.push(...events.map(e=>BoundEvent.fromParsedEvent(e)))}function isEmptyTextNode(node){return node instanceof Text&&node.value.trim().length==0}function isCommentNode(node){return node instanceof Comment}function textContents(node){if(node.children.length!==1||!(node.children[0]instanceof Text))return null;else return node.children[0].value}var TagType;
(function(TagType){TagType[TagType["ELEMENT"]=0]="ELEMENT";TagType[TagType["TEMPLATE"]=1]="TEMPLATE"})(TagType||(TagType={}));function setupRegistry(){return{getUniqueId:getSeqNumberGenerator(),icus:new Map}}class I18nContext{constructor(index,ref,level=0,templateIndex=null,meta,registry){this.index=index;this.ref=ref;this.level=level;this.templateIndex=templateIndex;this.meta=meta;this.registry=registry;this.bindings=new Set;this.placeholders=new Map;this.isEmitted=false;this._unresolvedCtxCount=
0;this._registry=registry||setupRegistry();this.id=this._registry.getUniqueId()}appendTag(type,node,index,closed){if(node.isVoid&&closed)return;const ph=node.isVoid||!closed?node.startName:node.closeName;const content={type,index,ctx:this.id,isVoid:node.isVoid,closed};updatePlaceholderMap(this.placeholders,ph,content)}get icus(){return this._registry.icus}get isRoot(){return this.level===0}get isResolved(){return this._unresolvedCtxCount===0}getSerializedPlaceholders(){const result=new Map;this.placeholders.forEach((values,
key)=>result.set(key,values.map(serializePlaceholderValue)));return result}appendBinding(binding){this.bindings.add(binding)}appendIcu(name,ref){updatePlaceholderMap(this._registry.icus,name,ref)}appendBoundText(node){const phs=assembleBoundTextPlaceholders(node,this.bindings.size,this.id);phs.forEach((values,key)=>updatePlaceholderMap(this.placeholders,key,...values))}appendTemplate(node,index){this.appendTag(TagType.TEMPLATE,node,index,false);this.appendTag(TagType.TEMPLATE,node,index,true);this._unresolvedCtxCount++}appendElement(node,
index,closed){this.appendTag(TagType.ELEMENT,node,index,closed)}appendProjection(node,index){this.appendTag(TagType.ELEMENT,node,index,false);this.appendTag(TagType.ELEMENT,node,index,true)}forkChildContext(index,templateIndex,meta){return new I18nContext(index,this.ref,this.level+1,templateIndex,meta,this._registry)}reconcileChildContext(context){["start","close"].forEach(op=>{const key=context.meta[`${op}Name`];const phs=this.placeholders.get(key)||[];const tag=phs.find(findTemplateFn(this.id,context.templateIndex));
if(tag)tag.ctx=context.id});const childPhs=context.placeholders;childPhs.forEach((values,key)=>{const phs=this.placeholders.get(key);if(!phs){this.placeholders.set(key,values);return}const tmplIdx=phs.findIndex(findTemplateFn(context.id,context.templateIndex));if(tmplIdx>=0){const isCloseTag=key.startsWith("CLOSE");const isTemplateTag=key.endsWith("NG-TEMPLATE");if(isTemplateTag)phs.splice(tmplIdx+(isCloseTag?0:1),0,...values);else{const idx=isCloseTag?values.length-1:0;values[idx].tmpl=phs[tmplIdx];
phs.splice(tmplIdx,1,...values)}}else phs.push(...values);this.placeholders.set(key,phs)});this._unresolvedCtxCount--}}function wrap(symbol,index,contextId,closed){const state=closed?"/":"";return wrapI18nPlaceholder(`${state}${symbol}${index}`,contextId)}function wrapTag(symbol,{index,ctx,isVoid},closed){return isVoid?wrap(symbol,index,ctx)+wrap(symbol,index,ctx,true):wrap(symbol,index,ctx,closed)}function findTemplateFn(ctx,templateIndex){return token=>typeof token==="object"&&token.type===TagType.TEMPLATE&&
token.index===templateIndex&&token.ctx===ctx}function serializePlaceholderValue(value){const element=(data,closed)=>wrapTag("#",data,closed);const template=(data,closed)=>wrapTag("*",data,closed);switch(value.type){case TagType.ELEMENT:if(value.closed)return element(value,true)+(value.tmpl?template(value.tmpl,true):"");if(value.tmpl)return template(value.tmpl)+element(value)+(value.isVoid?template(value.tmpl,true):"");return element(value);case TagType.TEMPLATE:return template(value,value.closed);
default:return value}}class IcuSerializerVisitor{visitText(text){return text.value}visitContainer(container){return container.children.map(child=>child.visit(this)).join("")}visitIcu(icu){const strCases=Object.keys(icu.cases).map(k=>`${k} {${icu.cases[k].visit(this)}}`);const result=`{${icu.expressionPlaceholder}, ${icu.type}, ${strCases.join(" ")}}`;return result}visitTagPlaceholder(ph){return ph.isVoid?this.formatPh(ph.startName):`${this.formatPh(ph.startName)}${ph.children.map(child=>child.visit(this)).join("")}${this.formatPh(ph.closeName)}`}visitPlaceholder(ph){return this.formatPh(ph.name)}visitIcuPlaceholder(ph,
context){return this.formatPh(ph.name)}formatPh(value){return`{${formatI18nPlaceholderName(value,false)}}`}}const serializer=new IcuSerializerVisitor;function serializeIcuNode(icu){return icu.visit(serializer)}const TAG_TO_PLACEHOLDER_NAMES={"A":"LINK","B":"BOLD_TEXT","BR":"LINE_BREAK","EM":"EMPHASISED_TEXT","H1":"HEADING_LEVEL1","H2":"HEADING_LEVEL2","H3":"HEADING_LEVEL3","H4":"HEADING_LEVEL4","H5":"HEADING_LEVEL5","H6":"HEADING_LEVEL6","HR":"HORIZONTAL_RULE","I":"ITALIC_TEXT","LI":"LIST_ITEM","LINK":"MEDIA_LINK",
"OL":"ORDERED_LIST","P":"PARAGRAPH","Q":"QUOTATION","S":"STRIKETHROUGH_TEXT","SMALL":"SMALL_TEXT","SUB":"SUBSTRIPT","SUP":"SUPERSCRIPT","TBODY":"TABLE_BODY","TD":"TABLE_CELL","TFOOT":"TABLE_FOOTER","TH":"TABLE_HEADER_CELL","THEAD":"TABLE_HEADER","TR":"TABLE_ROW","TT":"MONOSPACED_TEXT","U":"UNDERLINED_TEXT","UL":"UNORDERED_LIST"};class PlaceholderRegistry{constructor(){this._placeHolderNameCounts={};this._signatureToName={}}getStartTagPlaceholderName(tag,attrs,isVoid){const signature=this._hashTag(tag,
attrs,isVoid);if(this._signatureToName[signature])return this._signatureToName[signature];const upperTag=tag.toUpperCase();const baseName=TAG_TO_PLACEHOLDER_NAMES[upperTag]||`TAG_${upperTag}`;const name=this._generateUniqueName(isVoid?baseName:`START_${baseName}`);this._signatureToName[signature]=name;return name}getCloseTagPlaceholderName(tag){const signature=this._hashClosingTag(tag);if(this._signatureToName[signature])return this._signatureToName[signature];const upperTag=tag.toUpperCase();const baseName=
TAG_TO_PLACEHOLDER_NAMES[upperTag]||`TAG_${upperTag}`;const name=this._generateUniqueName(`CLOSE_${baseName}`);this._signatureToName[signature]=name;return name}getPlaceholderName(name,content){const upperName=name.toUpperCase();const signature=`PH: ${upperName}=${content}`;if(this._signatureToName[signature])return this._signatureToName[signature];const uniqueName=this._generateUniqueName(upperName);this._signatureToName[signature]=uniqueName;return uniqueName}getUniquePlaceholder(name){return this._generateUniqueName(name.toUpperCase())}_hashTag(tag,
attrs,isVoid){const start=`<${tag}`;const strAttrs=Object.keys(attrs).sort().map(name=>` ${name}=${attrs[name]}`).join("");const end=isVoid?"/>":`></${tag}>`;return start+strAttrs+end}_hashClosingTag(tag){return this._hashTag(`/${tag}`,{},false)}_generateUniqueName(base){const seen=this._placeHolderNameCounts.hasOwnProperty(base);if(!seen){this._placeHolderNameCounts[base]=1;return base}const id=this._placeHolderNameCounts[base];this._placeHolderNameCounts[base]=id+1;return`${base}_${id}`}}const _expParser=
new Parser$1(new Lexer);function createI18nMessageFactory(interpolationConfig){const visitor=new _I18nVisitor(_expParser,interpolationConfig);return(nodes,meaning,description,customId,visitNodeFn)=>visitor.toI18nMessage(nodes,meaning,description,customId,visitNodeFn)}function noopVisitNodeFn(_html,i18n){return i18n}class _I18nVisitor{constructor(_expressionParser,_interpolationConfig){this._expressionParser=_expressionParser;this._interpolationConfig=_interpolationConfig}toI18nMessage(nodes,meaning=
"",description="",customId="",visitNodeFn){const context={isIcu:nodes.length==1&&nodes[0]instanceof Expansion,icuDepth:0,placeholderRegistry:new PlaceholderRegistry,placeholderToContent:{},placeholderToMessage:{},visitNodeFn:visitNodeFn||noopVisitNodeFn};const i18nodes=visitAll(this,nodes,context);return new Message(i18nodes,context.placeholderToContent,context.placeholderToMessage,meaning,description,customId)}visitElement(el,context){var _a;const children=visitAll(this,el.children,context);const attrs=
{};el.attrs.forEach(attr=>{attrs[attr.name]=attr.value});const isVoid=getHtmlTagDefinition(el.name).isVoid;const startPhName=context.placeholderRegistry.getStartTagPlaceholderName(el.name,attrs,isVoid);context.placeholderToContent[startPhName]={text:el.startSourceSpan.toString(),sourceSpan:el.startSourceSpan};let closePhName="";if(!isVoid){closePhName=context.placeholderRegistry.getCloseTagPlaceholderName(el.name);context.placeholderToContent[closePhName]={text:`</${el.name}>`,sourceSpan:(_a=el.endSourceSpan)!==
null&&_a!==void 0?_a:el.sourceSpan}}const node=new TagPlaceholder(el.name,attrs,startPhName,closePhName,children,isVoid,el.sourceSpan,el.startSourceSpan,el.endSourceSpan);return context.visitNodeFn(el,node)}visitAttribute(attribute,context){const node=attribute.valueTokens===undefined||attribute.valueTokens.length===1?new Text$2(attribute.value,attribute.valueSpan||attribute.sourceSpan):this._visitTextWithInterpolation(attribute.valueTokens,attribute.valueSpan||attribute.sourceSpan,context,attribute.i18n);
return context.visitNodeFn(attribute,node)}visitText(text,context){const node=text.tokens.length===1?new Text$2(text.value,text.sourceSpan):this._visitTextWithInterpolation(text.tokens,text.sourceSpan,context,text.i18n);return context.visitNodeFn(text,node)}visitComment(comment,context){return null}visitExpansion(icu,context){context.icuDepth++;const i18nIcuCases={};const i18nIcu=new Icu(icu.switchValue,icu.type,i18nIcuCases,icu.sourceSpan);icu.cases.forEach(caze=>{i18nIcuCases[caze.value]=new Container(caze.expression.map(node=>
node.visit(this,context)),caze.expSourceSpan)});context.icuDepth--;if(context.isIcu||context.icuDepth>0){const expPh=context.placeholderRegistry.getUniquePlaceholder(`VAR_${icu.type}`);i18nIcu.expressionPlaceholder=expPh;context.placeholderToContent[expPh]={text:icu.switchValue,sourceSpan:icu.switchValueSourceSpan};return context.visitNodeFn(icu,i18nIcu)}const phName=context.placeholderRegistry.getPlaceholderName("ICU",icu.sourceSpan.toString());context.placeholderToMessage[phName]=this.toI18nMessage([icu],
"","","",undefined);const node=new IcuPlaceholder(i18nIcu,phName,icu.sourceSpan);return context.visitNodeFn(icu,node)}visitExpansionCase(_icuCase,_context){throw new Error("Unreachable code");}_visitTextWithInterpolation(tokens,sourceSpan,context,previousI18n){const nodes=[];let hasInterpolation=false;for(const token of tokens)switch(token.type){case 8:case 17:hasInterpolation=true;const expression=token.parts[1];const baseName=extractPlaceholderName(expression)||"INTERPOLATION";const phName=context.placeholderRegistry.getPlaceholderName(baseName,
expression);context.placeholderToContent[phName]={text:token.parts.join(""),sourceSpan:token.sourceSpan};nodes.push(new Placeholder(expression,phName,token.sourceSpan));break;default:if(token.parts[0].length>0){const previous=nodes[nodes.length-1];if(previous instanceof Text$2){previous.value+=token.parts[0];previous.sourceSpan=new ParseSourceSpan(previous.sourceSpan.start,token.sourceSpan.end,previous.sourceSpan.fullStart,previous.sourceSpan.details)}else nodes.push(new Text$2(token.parts[0],token.sourceSpan))}break}if(hasInterpolation){reusePreviousSourceSpans(nodes,
previousI18n);return new Container(nodes,sourceSpan)}else return nodes[0]}}function reusePreviousSourceSpans(nodes,previousI18n){if(previousI18n instanceof Message){assertSingleContainerMessage(previousI18n);previousI18n=previousI18n.nodes[0]}if(previousI18n instanceof Container){assertEquivalentNodes(previousI18n.children,nodes);for(let i=0;i<nodes.length;i++)nodes[i].sourceSpan=previousI18n.children[i].sourceSpan}}function assertSingleContainerMessage(message){const nodes=message.nodes;if(nodes.length!==
1||!(nodes[0]instanceof Container))throw new Error("Unexpected previous i18n message - expected it to consist of only a single `Container` node.");}function assertEquivalentNodes(previousNodes,nodes){if(previousNodes.length!==nodes.length)throw new Error("The number of i18n message children changed between first and second pass.");if(previousNodes.some((node,i)=>nodes[i].constructor!==node.constructor))throw new Error("The types of the i18n message children changed between first and second pass.");
}const _CUSTOM_PH_EXP=/\/\/[\s\S]*i18n[\s\S]*\([\s\S]*ph[\s\S]*=[\s\S]*("|')([\s\S]*?)\1[\s\S]*\)/g;function extractPlaceholderName(input){return input.split(_CUSTOM_PH_EXP)[2]}class I18nError extends ParseError{constructor(span,msg){super(span,msg)}}const setI18nRefs=(htmlNode,i18nNode)=>{if(htmlNode instanceof NodeWithI18n){if(i18nNode instanceof IcuPlaceholder&&htmlNode.i18n instanceof Message)i18nNode.previousMessage=htmlNode.i18n;htmlNode.i18n=i18nNode}return i18nNode};class I18nMetaVisitor{constructor(interpolationConfig=
DEFAULT_INTERPOLATION_CONFIG,keepI18nAttrs=false,enableI18nLegacyMessageIdFormat=false){this.interpolationConfig=interpolationConfig;this.keepI18nAttrs=keepI18nAttrs;this.enableI18nLegacyMessageIdFormat=enableI18nLegacyMessageIdFormat;this.hasI18nMeta=false;this._errors=[];this._createI18nMessage=createI18nMessageFactory(this.interpolationConfig)}_generateI18nMessage(nodes,meta="",visitNodeFn){const {meaning,description,customId}=this._parseMetadata(meta);const message=this._createI18nMessage(nodes,
meaning,description,customId,visitNodeFn);this._setMessageId(message,meta);this._setLegacyIds(message,meta);return message}visitAllWithErrors(nodes){const result=nodes.map(node=>node.visit(this,null));return new ParseTreeResult(result,this._errors)}visitElement(element){let message=undefined;if(hasI18nAttrs(element)){this.hasI18nMeta=true;const attrs=[];const attrsMeta={};for(const attr of element.attrs)if(attr.name===I18N_ATTR){const i18n=element.i18n||attr.value;message=this._generateI18nMessage(element.children,
i18n,setI18nRefs);if(message.nodes.length===0)message=undefined;element.i18n=message}else if(attr.name.startsWith(I18N_ATTR_PREFIX)){const name=attr.name.slice(I18N_ATTR_PREFIX.length);if(isTrustedTypesSink(element.name,name))this._reportError(attr,`Translating attribute '${name}' is disallowed for security reasons.`);else attrsMeta[name]=attr.value}else attrs.push(attr);if(Object.keys(attrsMeta).length)for(const attr of attrs){const meta=attrsMeta[attr.name];if(meta!==undefined&&attr.value)attr.i18n=
this._generateI18nMessage([attr],attr.i18n||meta)}if(!this.keepI18nAttrs)element.attrs=attrs}visitAll(this,element.children,message);return element}visitExpansion(expansion,currentMessage){let message;const meta=expansion.i18n;this.hasI18nMeta=true;if(meta instanceof IcuPlaceholder){const name=meta.name;message=this._generateI18nMessage([expansion],meta);const icu=icuFromI18nMessage(message);icu.name=name;if(currentMessage!==null)currentMessage.placeholderToMessage[name]=message}else message=this._generateI18nMessage([expansion],
currentMessage||meta);expansion.i18n=message;return expansion}visitText(text){return text}visitAttribute(attribute){return attribute}visitComment(comment){return comment}visitExpansionCase(expansionCase){return expansionCase}_parseMetadata(meta){return typeof meta==="string"?parseI18nMeta(meta):meta instanceof Message?meta:{}}_setMessageId(message,meta){if(!message.id)message.id=meta instanceof Message&&meta.id||decimalDigest(message)}_setLegacyIds(message,meta){if(this.enableI18nLegacyMessageIdFormat)message.legacyIds=
[computeDigest(message),computeDecimalDigest(message)];else if(typeof meta!=="string"){const previousMessage=meta instanceof Message?meta:meta instanceof IcuPlaceholder?meta.previousMessage:undefined;message.legacyIds=previousMessage?previousMessage.legacyIds:[]}}_reportError(node,msg){this._errors.push(new I18nError(node.sourceSpan,msg))}}const I18N_MEANING_SEPARATOR="|";const I18N_ID_SEPARATOR="@@";function parseI18nMeta(meta=""){let customId;let meaning;let description;meta=meta.trim();if(meta){const idIndex=
meta.indexOf(I18N_ID_SEPARATOR);const descIndex=meta.indexOf(I18N_MEANING_SEPARATOR);let meaningAndDesc;[meaningAndDesc,customId]=idIndex>-1?[meta.slice(0,idIndex),meta.slice(idIndex+2)]:[meta,""];[meaning,description]=descIndex>-1?[meaningAndDesc.slice(0,descIndex),meaningAndDesc.slice(descIndex+1)]:["",meaningAndDesc]}return{customId,meaning,description}}function i18nMetaToJSDoc(meta){const tags=[];if(meta.description)tags.push({tagName:"desc",text:meta.description});if(meta.meaning)tags.push({tagName:"meaning",
text:meta.meaning});return tags.length==0?null:jsDocComment(tags)}const GOOG_GET_MSG="goog.getMsg";function createGoogleGetMsgStatements(variable$1,message,closureVar,params){const messageString=serializeI18nMessageForGetMsg(message);const args=[literal(messageString)];if(Object.keys(params).length)args.push(mapLiteral(params,true));const googGetMsgStmt=closureVar.set(variable(GOOG_GET_MSG).callFn(args)).toConstDecl();const metaComment=i18nMetaToJSDoc(message);if(metaComment!==null)googGetMsgStmt.addLeadingComment(metaComment);
const i18nAssignmentStmt=new ExpressionStatement(variable$1.set(closureVar));return[googGetMsgStmt,i18nAssignmentStmt]}class GetMsgSerializerVisitor{formatPh(value){return`{$${formatI18nPlaceholderName(value)}}`}visitText(text){return text.value}visitContainer(container){return container.children.map(child=>child.visit(this)).join("")}visitIcu(icu){return serializeIcuNode(icu)}visitTagPlaceholder(ph){return ph.isVoid?this.formatPh(ph.startName):`${this.formatPh(ph.startName)}${ph.children.map(child=>
child.visit(this)).join("")}${this.formatPh(ph.closeName)}`}visitPlaceholder(ph){return this.formatPh(ph.name)}visitIcuPlaceholder(ph,context){return this.formatPh(ph.name)}}const serializerVisitor=new GetMsgSerializerVisitor;function serializeI18nMessageForGetMsg(message){return message.nodes.map(node=>node.visit(serializerVisitor,null)).join("")}function createLocalizeStatements(variable,message,params){const {messageParts,placeHolders}=serializeI18nMessageForLocalize(message);const sourceSpan=
getSourceSpan(message);const expressions=placeHolders.map(ph=>params[ph.text]);const localizedString$1=localizedString(message,messageParts,placeHolders,expressions,sourceSpan);const variableInitialization=variable.set(localizedString$1);return[new ExpressionStatement(variableInitialization)]}class LocalizeSerializerVisitor{constructor(placeholderToMessage,pieces){this.placeholderToMessage=placeholderToMessage;this.pieces=pieces}visitText(text){if(this.pieces[this.pieces.length-1]instanceof LiteralPiece)this.pieces[this.pieces.length-
1].text+=text.value;else{const sourceSpan=new ParseSourceSpan(text.sourceSpan.fullStart,text.sourceSpan.end,text.sourceSpan.fullStart,text.sourceSpan.details);this.pieces.push(new LiteralPiece(text.value,sourceSpan))}}visitContainer(container){container.children.forEach(child=>child.visit(this))}visitIcu(icu){this.pieces.push(new LiteralPiece(serializeIcuNode(icu),icu.sourceSpan))}visitTagPlaceholder(ph){var _a,_b;this.pieces.push(this.createPlaceholderPiece(ph.startName,(_a=ph.startSourceSpan)!==
null&&_a!==void 0?_a:ph.sourceSpan));if(!ph.isVoid){ph.children.forEach(child=>child.visit(this));this.pieces.push(this.createPlaceholderPiece(ph.closeName,(_b=ph.endSourceSpan)!==null&&_b!==void 0?_b:ph.sourceSpan))}}visitPlaceholder(ph){this.pieces.push(this.createPlaceholderPiece(ph.name,ph.sourceSpan))}visitIcuPlaceholder(ph){this.pieces.push(this.createPlaceholderPiece(ph.name,ph.sourceSpan,this.placeholderToMessage[ph.name]))}createPlaceholderPiece(name,sourceSpan,associatedMessage){return new PlaceholderPiece(formatI18nPlaceholderName(name,
false),sourceSpan,associatedMessage)}}function serializeI18nMessageForLocalize(message){const pieces=[];const serializerVisitor=new LocalizeSerializerVisitor(message.placeholderToMessage,pieces);message.nodes.forEach(node=>node.visit(serializerVisitor));return processMessagePieces(pieces)}function getSourceSpan(message){const startNode=message.nodes[0];const endNode=message.nodes[message.nodes.length-1];return new ParseSourceSpan(startNode.sourceSpan.fullStart,endNode.sourceSpan.end,startNode.sourceSpan.fullStart,
startNode.sourceSpan.details)}function processMessagePieces(pieces){const messageParts=[];const placeHolders=[];if(pieces[0]instanceof PlaceholderPiece)messageParts.push(createEmptyMessagePart(pieces[0].sourceSpan.start));for(let i=0;i<pieces.length;i++){const part=pieces[i];if(part instanceof LiteralPiece)messageParts.push(part);else{placeHolders.push(part);if(pieces[i-1]instanceof PlaceholderPiece)messageParts.push(createEmptyMessagePart(pieces[i-1].sourceSpan.end))}}if(pieces[pieces.length-1]instanceof
PlaceholderPiece)messageParts.push(createEmptyMessagePart(pieces[pieces.length-1].sourceSpan.end));return{messageParts,placeHolders}}function createEmptyMessagePart(location){return new LiteralPiece("",new ParseSourceSpan(location,location))}const NG_CONTENT_SELECT_ATTR="select";const NG_PROJECT_AS_ATTR_NAME="ngProjectAs";const EVENT_BINDING_SCOPE_GLOBALS=new Set(["$event"]);const GLOBAL_TARGET_RESOLVERS=new Map([["window",Identifiers$1.resolveWindow],["document",Identifiers$1.resolveDocument],["body",
Identifiers$1.resolveBody]]);const LEADING_TRIVIA_CHARS=[" ","\n","\r","\t"];function renderFlagCheckIfStmt(flags,statements){return ifStmt(variable(RENDER_FLAGS).bitwiseAnd(literal(flags),null,false),statements)}function prepareEventListenerParameters(eventAst,handlerName=null,scope=null){const {type,name,target,phase,handler}=eventAst;if(target&&!GLOBAL_TARGET_RESOLVERS.has(target))throw new Error(`Unexpected global target '${target}' defined for '${name}' event.
        Supported list of global targets: ${Array.from(GLOBAL_TARGET_RESOLVERS.keys())}.`);const eventArgumentName="$event";const implicitReceiverAccesses=new Set;const implicitReceiverExpr=scope===null||scope.bindingLevel===0?variable(CONTEXT_NAME):scope.getOrCreateSharedContextVar(0);const bindingStatements=convertActionBinding(scope,implicitReceiverExpr,handler,"b",()=>error("Unexpected interpolation"),eventAst.handlerSpan,implicitReceiverAccesses,EVENT_BINDING_SCOPE_GLOBALS);const statements=
[];if(scope){statements.push(...scope.variableDeclarations());statements.unshift(...scope.restoreViewStatement())}statements.push(...bindingStatements);const eventName=type===1?prepareSyntheticListenerName(name,phase):name;const fnName=handlerName&&sanitizeIdentifier(handlerName);const fnArgs=[];if(implicitReceiverAccesses.has(eventArgumentName))fnArgs.push(new FnParam(eventArgumentName,DYNAMIC_TYPE));const handlerFn=fn(fnArgs,statements,INFERRED_TYPE,null,fnName);const params=[literal(eventName),
handlerFn];if(target)params.push(literal(false),importExpr(GLOBAL_TARGET_RESOLVERS.get(target)));return params}function createComponentDefConsts(){return{prepareStatements:[],constExpressions:[],i18nVarRefsCache:new Map}}class TemplateDefinitionBuilder{constructor(constantPool,parentBindingScope,level=0,contextName,i18nContext,templateIndex,templateName,_namespace,relativeContextFilePath,i18nUseExternalIds,_constants=createComponentDefConsts()){this.constantPool=constantPool;this.level=level;this.contextName=
contextName;this.i18nContext=i18nContext;this.templateIndex=templateIndex;this.templateName=templateName;this._namespace=_namespace;this.i18nUseExternalIds=i18nUseExternalIds;this._constants=_constants;this._dataIndex=0;this._bindingContext=0;this._prefixCode=[];this._creationCodeFns=[];this._updateCodeFns=[];this._currentIndex=0;this._tempVariables=[];this._nestedTemplateFns=[];this.i18n=null;this._pureFunctionSlots=0;this._bindingSlots=0;this._ngContentReservedSlots=[];this._ngContentSelectorsOffset=
0;this._implicitReceiverExpr=null;this.visitReference=invalid;this.visitVariable=invalid;this.visitTextAttribute=invalid;this.visitBoundAttribute=invalid;this.visitBoundEvent=invalid;this._bindingScope=parentBindingScope.nestedScope(level);this.fileBasedI18nSuffix=relativeContextFilePath.replace(/[^A-Za-z0-9]/g,"_")+"_";this._valueConverter=new ValueConverter(constantPool,()=>this.allocateDataSlot(),numSlots=>this.allocatePureFunctionSlots(numSlots),(name,localName,slot,value)=>{this._bindingScope.set(this.level,
localName,value);this.creationInstruction(null,Identifiers$1.pipe,[literal(slot),literal(name)])})}buildTemplateFunction(nodes,variables,ngContentSelectorsOffset=0,i18n){this._ngContentSelectorsOffset=ngContentSelectorsOffset;if(this._namespace!==Identifiers$1.namespaceHTML)this.creationInstruction(null,this._namespace);variables.forEach(v=>this.registerContextVariables(v));const initI18nContext=this.i18nContext||isI18nRootNode(i18n)&&!isSingleI18nIcu(i18n)&&!(isSingleElementTemplate(nodes)&&nodes[0].i18n===
i18n);const selfClosingI18nInstruction=hasTextChildrenOnly(nodes);if(initI18nContext)this.i18nStart(null,i18n,selfClosingI18nInstruction);visitAll$1(this,nodes);this._pureFunctionSlots+=this._bindingSlots;this._valueConverter.updatePipeSlotOffsets(this._bindingSlots);this._nestedTemplateFns.forEach(buildTemplateFn=>buildTemplateFn());if(this.level===0&&this._ngContentReservedSlots.length){const parameters=[];if(this._ngContentReservedSlots.length>1||this._ngContentReservedSlots[0]!=="*"){const r3ReservedSlots=
this._ngContentReservedSlots.map(s=>s!=="*"?parseSelectorToR3Selector(s):s);parameters.push(this.constantPool.getConstLiteral(asLiteral(r3ReservedSlots),true))}this.creationInstruction(null,Identifiers$1.projectionDef,parameters,true)}if(initI18nContext)this.i18nEnd(null,selfClosingI18nInstruction);const creationStatements=this._creationCodeFns.map(fn=>fn());const updateStatements=this._updateCodeFns.map(fn=>fn());const creationVariables=this._bindingScope.viewSnapshotStatements();const updateVariables=
this._bindingScope.variableDeclarations().concat(this._tempVariables);const creationBlock=creationStatements.length>0?[renderFlagCheckIfStmt(1,creationVariables.concat(creationStatements))]:[];const updateBlock=updateStatements.length>0?[renderFlagCheckIfStmt(2,updateVariables.concat(updateStatements))]:[];return fn([new FnParam(RENDER_FLAGS,NUMBER_TYPE),new FnParam(CONTEXT_NAME,null)],[...this._prefixCode,...creationBlock,...updateBlock],INFERRED_TYPE,null,this.templateName)}getLocal(name){return this._bindingScope.get(name)}notifyImplicitReceiverUse(){this._bindingScope.notifyImplicitReceiverUse()}maybeRestoreView(){this._bindingScope.maybeRestoreView()}i18nTranslate(message,
params={},ref,transformFn){const _ref=ref||this.i18nGenerateMainBlockVar();const closureVar=this.i18nGenerateClosureVar(message.id);const statements=getTranslationDeclStmts(message,_ref,closureVar,params,transformFn);this._constants.prepareStatements.push(...statements);return _ref}registerContextVariables(variable$1){const scopedName=this._bindingScope.freshReferenceName();const retrievalLevel=this.level;const lhs=variable(variable$1.name+scopedName);this._bindingScope.set(retrievalLevel,variable$1.name,
lhs,1,(scope,relativeLevel)=>{let rhs;if(scope.bindingLevel===retrievalLevel)if(scope.isListenerScope()&&scope.hasRestoreViewVariable()){rhs=variable(RESTORED_VIEW_CONTEXT_NAME);scope.notifyRestoredViewContextUse()}else rhs=variable(CONTEXT_NAME);else{const sharedCtxVar=scope.getSharedContextName(retrievalLevel);rhs=sharedCtxVar?sharedCtxVar:generateNextContextExpr(relativeLevel)}return[lhs.set(rhs.prop(variable$1.value||IMPLICIT_REFERENCE)).toConstDecl()]})}i18nAppendBindings(expressions){if(expressions.length>
0)expressions.forEach(expression=>this.i18n.appendBinding(expression))}i18nBindProps(props){const bound={};Object.keys(props).forEach(key=>{const prop=props[key];if(prop instanceof Text$3)bound[key]=literal(prop.value);else{const value=prop.value.visit(this._valueConverter);this.allocateBindingSlots(value);if(value instanceof Interpolation){const {strings,expressions}=value;const {id,bindings}=this.i18n;const label=assembleI18nBoundString(strings,bindings.size,id);this.i18nAppendBindings(expressions);
bound[key]=literal(label)}}});return bound}i18nGenerateMainBlockVar(){return variable(this.constantPool.uniqueName(TRANSLATION_VAR_PREFIX))}i18nGenerateClosureVar(messageId){let name;const suffix=this.fileBasedI18nSuffix.toUpperCase();if(this.i18nUseExternalIds){const prefix=getTranslationConstPrefix(`EXTERNAL_`);const uniqueSuffix=this.constantPool.uniqueName(suffix);name=`${prefix}${sanitizeIdentifier(messageId)}$$${uniqueSuffix}`}else{const prefix=getTranslationConstPrefix(suffix);name=this.constantPool.uniqueName(prefix)}return variable(name)}i18nUpdateRef(context){const {icus,
meta,isRoot,isResolved,isEmitted}=context;if(isRoot&&isResolved&&!isEmitted&&!isSingleI18nIcu(meta)){context.isEmitted=true;const placeholders=context.getSerializedPlaceholders();let icuMapping={};let params=placeholders.size?placeholdersToParams(placeholders):{};if(icus.size)icus.forEach((refs,key)=>{if(refs.length===1)params[key]=refs[0];else{const placeholder=wrapI18nPlaceholder(`${I18N_ICU_MAPPING_PREFIX}${key}`);params[key]=literal(placeholder);icuMapping[key]=literalArr(refs)}});const needsPostprocessing=
Array.from(placeholders.values()).some(value=>value.length>1)||Object.keys(icuMapping).length;let transformFn;if(needsPostprocessing)transformFn=raw=>{const args=[raw];if(Object.keys(icuMapping).length)args.push(mapLiteral(icuMapping,true));return instruction(null,Identifiers$1.i18nPostprocess,args)};this.i18nTranslate(meta,params,context.ref,transformFn)}}i18nStart(span=null,meta,selfClosing){const index=this.allocateDataSlot();this.i18n=this.i18nContext?this.i18nContext.forkChildContext(index,this.templateIndex,
meta):new I18nContext(index,this.i18nGenerateMainBlockVar(),0,this.templateIndex,meta);const {id,ref}=this.i18n;const params=[literal(index),this.addToConsts(ref)];if(id>0)params.push(literal(id));this.creationInstruction(span,selfClosing?Identifiers$1.i18n:Identifiers$1.i18nStart,params)}i18nEnd(span=null,selfClosing){if(!this.i18n)throw new Error("i18nEnd is executed with no i18n context present");if(this.i18nContext){this.i18nContext.reconcileChildContext(this.i18n);this.i18nUpdateRef(this.i18nContext)}else this.i18nUpdateRef(this.i18n);
const {index,bindings}=this.i18n;if(bindings.size){const chainBindings=[];bindings.forEach(binding=>{chainBindings.push({sourceSpan:span,value:()=>this.convertPropertyBinding(binding)})});this.updateInstructionChainWithAdvance(this.getConstCount()-1,Identifiers$1.i18nExp,chainBindings);this.updateInstruction(span,Identifiers$1.i18nApply,[literal(index)])}if(!selfClosing)this.creationInstruction(span,Identifiers$1.i18nEnd);this.i18n=null}i18nAttributesInstruction(nodeIndex,attrs,sourceSpan){let hasBindings=
false;const i18nAttrArgs=[];const bindings=[];attrs.forEach(attr=>{const message=attr.i18n;const converted=attr.value.visit(this._valueConverter);this.allocateBindingSlots(converted);if(converted instanceof Interpolation){const placeholders=assembleBoundTextPlaceholders(message);const params=placeholdersToParams(placeholders);i18nAttrArgs.push(literal(attr.name),this.i18nTranslate(message,params));converted.expressions.forEach(expression=>{hasBindings=true;bindings.push({sourceSpan,value:()=>this.convertPropertyBinding(expression)})})}});
if(bindings.length>0)this.updateInstructionChainWithAdvance(nodeIndex,Identifiers$1.i18nExp,bindings);if(i18nAttrArgs.length>0){const index=literal(this.allocateDataSlot());const constIndex=this.addToConsts(literalArr(i18nAttrArgs));this.creationInstruction(sourceSpan,Identifiers$1.i18nAttributes,[index,constIndex]);if(hasBindings)this.updateInstruction(sourceSpan,Identifiers$1.i18nApply,[index])}}getNamespaceInstruction(namespaceKey){switch(namespaceKey){case "math":return Identifiers$1.namespaceMathML;
case "svg":return Identifiers$1.namespaceSVG;default:return Identifiers$1.namespaceHTML}}addNamespaceInstruction(nsInstruction,element){this._namespace=nsInstruction;this.creationInstruction(element.startSourceSpan,nsInstruction)}interpolatedUpdateInstruction(instruction,elementIndex,attrName,input,value,params){this.updateInstructionWithAdvance(elementIndex,input.sourceSpan,instruction,()=>[literal(attrName),...this.getUpdateInstructionArguments(value),...params])}visitContent(ngContent){const slot=
this.allocateDataSlot();const projectionSlotIdx=this._ngContentSelectorsOffset+this._ngContentReservedSlots.length;const parameters=[literal(slot)];this._ngContentReservedSlots.push(ngContent.selector);const nonContentSelectAttributes=ngContent.attributes.filter(attr=>attr.name.toLowerCase()!==NG_CONTENT_SELECT_ATTR);const attributes=this.getAttributeExpressions(ngContent.name,nonContentSelectAttributes,[],[]);if(attributes.length>0)parameters.push(literal(projectionSlotIdx),literalArr(attributes));
else if(projectionSlotIdx!==0)parameters.push(literal(projectionSlotIdx));this.creationInstruction(ngContent.sourceSpan,Identifiers$1.projection,parameters);if(this.i18n)this.i18n.appendProjection(ngContent.i18n,slot)}visitElement(element){var _a,_b;const elementIndex=this.allocateDataSlot();const stylingBuilder=new StylingBuilder(null);let isNonBindableMode=false;const isI18nRootElement=isI18nRootNode(element.i18n)&&!isSingleI18nIcu(element.i18n);const outputAttrs=[];const [namespaceKey,elementName]=
splitNsName(element.name);const isNgContainer$1=isNgContainer(element.name);for(const attr of element.attributes){const {name,value}=attr;if(name===NON_BINDABLE_ATTR)isNonBindableMode=true;else if(name==="style")stylingBuilder.registerStyleAttr(value);else if(name==="class")stylingBuilder.registerClassAttr(value);else outputAttrs.push(attr)}const parameters=[literal(elementIndex)];if(!isNgContainer$1)parameters.push(literal(elementName));const allOtherInputs=[];const boundI18nAttrs=[];element.inputs.forEach(input=>
{const stylingInputWasSet=stylingBuilder.registerBoundInput(input);if(!stylingInputWasSet)if(input.type===0&&input.i18n)boundI18nAttrs.push(input);else allOtherInputs.push(input)});const attributes=this.getAttributeExpressions(element.name,outputAttrs,allOtherInputs,element.outputs,stylingBuilder,[],boundI18nAttrs);parameters.push(this.addAttrsToConsts(attributes));const refs=this.prepareRefsArray(element.references);parameters.push(this.addToConsts(refs));const wasInNamespace=this._namespace;const currentNamespace=
this.getNamespaceInstruction(namespaceKey);if(currentNamespace!==wasInNamespace)this.addNamespaceInstruction(currentNamespace,element);if(this.i18n)this.i18n.appendElement(element.i18n,elementIndex);const hasChildren=!isI18nRootElement&&this.i18n?!hasTextChildrenOnly(element.children):element.children.length>0;const createSelfClosingInstruction=!stylingBuilder.hasBindingsWithPipes&&element.outputs.length===0&&boundI18nAttrs.length===0&&!hasChildren;const createSelfClosingI18nInstruction=!createSelfClosingInstruction&&
hasTextChildrenOnly(element.children);if(createSelfClosingInstruction)this.creationInstruction(element.sourceSpan,isNgContainer$1?Identifiers$1.elementContainer:Identifiers$1.element,trimTrailingNulls(parameters));else{this.creationInstruction(element.startSourceSpan,isNgContainer$1?Identifiers$1.elementContainerStart:Identifiers$1.elementStart,trimTrailingNulls(parameters));if(isNonBindableMode)this.creationInstruction(element.startSourceSpan,Identifiers$1.disableBindings);if(boundI18nAttrs.length>
0)this.i18nAttributesInstruction(elementIndex,boundI18nAttrs,(_a=element.startSourceSpan)!==null&&_a!==void 0?_a:element.sourceSpan);if(element.outputs.length>0){const listeners=element.outputs.map(outputAst=>({sourceSpan:outputAst.sourceSpan,params:this.prepareListenerParameter(element.name,outputAst,elementIndex)}));this.creationInstructionChain(Identifiers$1.listener,listeners)}if(isI18nRootElement)this.i18nStart(element.startSourceSpan,element.i18n,createSelfClosingI18nInstruction)}const stylingInstructions=
stylingBuilder.buildUpdateLevelInstructions(this._valueConverter);const limit=stylingInstructions.length-1;for(let i=0;i<=limit;i++){const instruction=stylingInstructions[i];this._bindingSlots+=this.processStylingUpdateInstruction(elementIndex,instruction)}const emptyValueBindInstruction=literal(undefined);const propertyBindings=[];const attributeBindings=[];allOtherInputs.forEach(input=>{const inputType=input.type;if(inputType===4){const value=input.value.visit(this._valueConverter);const hasValue=
value instanceof LiteralPrimitive?!!value.value:true;this.allocateBindingSlots(value);propertyBindings.push({name:prepareSyntheticPropertyName(input.name),sourceSpan:input.sourceSpan,value:()=>hasValue?this.convertPropertyBinding(value):emptyValueBindInstruction})}else{if(input.i18n)return;const value=input.value.visit(this._valueConverter);if(value!==undefined){const params=[];const [attrNamespace,attrName]=splitNsName(input.name);const isAttributeBinding=inputType===1;const sanitizationRef=resolveSanitizationFn(input.securityContext,
isAttributeBinding);if(sanitizationRef)params.push(sanitizationRef);if(attrNamespace){const namespaceLiteral=literal(attrNamespace);if(sanitizationRef)params.push(namespaceLiteral);else params.push(literal(null),namespaceLiteral)}this.allocateBindingSlots(value);if(inputType===0)if(value instanceof Interpolation)this.interpolatedUpdateInstruction(getPropertyInterpolationExpression(value),elementIndex,attrName,input,value,params);else propertyBindings.push({name:attrName,sourceSpan:input.sourceSpan,
value:()=>this.convertPropertyBinding(value),params});else if(inputType===1)if(value instanceof Interpolation&&getInterpolationArgsLength(value)>1)this.interpolatedUpdateInstruction(getAttributeInterpolationExpression(value),elementIndex,attrName,input,value,params);else{const boundValue=value instanceof Interpolation?value.expressions[0]:value;attributeBindings.push({name:attrName,sourceSpan:input.sourceSpan,value:()=>this.convertPropertyBinding(boundValue),params})}else this.updateInstructionWithAdvance(elementIndex,
input.sourceSpan,Identifiers$1.classProp,()=>{return[literal(elementIndex),literal(attrName),this.convertPropertyBinding(value),...params]})}}});if(propertyBindings.length>0)this.updateInstructionChainWithAdvance(elementIndex,Identifiers$1.property,propertyBindings);if(attributeBindings.length>0)this.updateInstructionChainWithAdvance(elementIndex,Identifiers$1.attribute,attributeBindings);visitAll$1(this,element.children);if(!isI18nRootElement&&this.i18n)this.i18n.appendElement(element.i18n,elementIndex,
true);if(!createSelfClosingInstruction){const span=(_b=element.endSourceSpan)!==null&&_b!==void 0?_b:element.sourceSpan;if(isI18nRootElement)this.i18nEnd(span,createSelfClosingI18nInstruction);if(isNonBindableMode)this.creationInstruction(span,Identifiers$1.enableBindings);this.creationInstruction(span,isNgContainer$1?Identifiers$1.elementContainerEnd:Identifiers$1.elementEnd)}}visitTemplate(template){var _a;const NG_TEMPLATE_TAG_NAME="ng-template";const templateIndex=this.allocateDataSlot();if(this.i18n)this.i18n.appendTemplate(template.i18n,
templateIndex);const tagNameWithoutNamespace=template.tagName?splitNsName(template.tagName)[1]:template.tagName;const contextName=`${this.contextName}${template.tagName?"_"+sanitizeIdentifier(template.tagName):""}_${templateIndex}`;const templateName=`${contextName}_Template`;const parameters=[literal(templateIndex),variable(templateName),literal(tagNameWithoutNamespace)];const attrsExprs=this.getAttributeExpressions(NG_TEMPLATE_TAG_NAME,template.attributes,template.inputs,template.outputs,undefined,
template.templateAttrs);parameters.push(this.addAttrsToConsts(attrsExprs));if(template.references&&template.references.length){const refs=this.prepareRefsArray(template.references);parameters.push(this.addToConsts(refs));parameters.push(importExpr(Identifiers$1.templateRefExtractor))}const templateVisitor=new TemplateDefinitionBuilder(this.constantPool,this._bindingScope,this.level+1,contextName,this.i18n,templateIndex,templateName,this._namespace,this.fileBasedI18nSuffix,this.i18nUseExternalIds,
this._constants);this._nestedTemplateFns.push(()=>{const templateFunctionExpr=templateVisitor.buildTemplateFunction(template.children,template.variables,this._ngContentReservedSlots.length+this._ngContentSelectorsOffset,template.i18n);this.constantPool.statements.push(templateFunctionExpr.toDeclStmt(templateName));if(templateVisitor._ngContentReservedSlots.length)this._ngContentReservedSlots.push(...templateVisitor._ngContentReservedSlots)});this.creationInstruction(template.sourceSpan,Identifiers$1.templateCreate,
()=>{parameters.splice(2,0,literal(templateVisitor.getConstCount()),literal(templateVisitor.getVarCount()));return trimTrailingNulls(parameters)});this.templatePropertyBindings(templateIndex,template.templateAttrs);if(tagNameWithoutNamespace===NG_TEMPLATE_TAG_NAME){const [i18nInputs,inputs]=partitionArray(template.inputs,hasI18nMeta);if(i18nInputs.length>0)this.i18nAttributesInstruction(templateIndex,i18nInputs,(_a=template.startSourceSpan)!==null&&_a!==void 0?_a:template.sourceSpan);if(inputs.length>
0)this.templatePropertyBindings(templateIndex,inputs);if(template.outputs.length>0){const listeners=template.outputs.map(outputAst=>({sourceSpan:outputAst.sourceSpan,params:this.prepareListenerParameter("ng_template",outputAst,templateIndex)}));this.creationInstructionChain(Identifiers$1.listener,listeners)}}}visitBoundText(text){if(this.i18n){const value=text.value.visit(this._valueConverter);this.allocateBindingSlots(value);if(value instanceof Interpolation){this.i18n.appendBoundText(text.i18n);
this.i18nAppendBindings(value.expressions)}return}const nodeIndex=this.allocateDataSlot();this.creationInstruction(text.sourceSpan,Identifiers$1.text,[literal(nodeIndex)]);const value=text.value.visit(this._valueConverter);this.allocateBindingSlots(value);if(value instanceof Interpolation)this.updateInstructionWithAdvance(nodeIndex,text.sourceSpan,getTextInterpolationExpression(value),()=>this.getUpdateInstructionArguments(value));else error("Text nodes should be interpolated and never bound directly.")}visitText(text){if(!this.i18n)this.creationInstruction(text.sourceSpan,
Identifiers$1.text,[literal(this.allocateDataSlot()),literal(text.value)])}visitIcu(icu){let initWasInvoked=false;if(!this.i18n){initWasInvoked=true;this.i18nStart(null,icu.i18n,true)}const i18n=this.i18n;const vars=this.i18nBindProps(icu.vars);const placeholders=this.i18nBindProps(icu.placeholders);const message=icu.i18n;const transformFn=raw=>{const params=Object.assign(Object.assign({},vars),placeholders);const formatted=i18nFormatPlaceholderNames(params,false);return instruction(null,Identifiers$1.i18nPostprocess,
[raw,mapLiteral(formatted,true)])};if(isSingleI18nIcu(i18n.meta))this.i18nTranslate(message,{},i18n.ref,transformFn);else{const ref=this.i18nTranslate(message,{},undefined,transformFn);i18n.appendIcu(icuFromI18nMessage(message).name,ref)}if(initWasInvoked)this.i18nEnd(null,true);return null}allocateDataSlot(){return this._dataIndex++}getConstCount(){return this._dataIndex}getVarCount(){return this._pureFunctionSlots}getConsts(){return this._constants}getNgContentSelectors(){return this._ngContentReservedSlots.length?
this.constantPool.getConstLiteral(asLiteral(this._ngContentReservedSlots),true):null}bindingContext(){return`${this._bindingContext++}`}templatePropertyBindings(templateIndex,attrs){const propertyBindings=[];attrs.forEach(input=>{if(input instanceof BoundAttribute){const value=input.value.visit(this._valueConverter);if(value!==undefined){this.allocateBindingSlots(value);if(value instanceof Interpolation){const params=[];this.interpolatedUpdateInstruction(getPropertyInterpolationExpression(value),
templateIndex,input.name,input,value,params)}else propertyBindings.push({name:input.name,sourceSpan:input.sourceSpan,value:()=>this.convertPropertyBinding(value)})}}});if(propertyBindings.length>0)this.updateInstructionChainWithAdvance(templateIndex,Identifiers$1.property,propertyBindings)}instructionFn(fns,span,reference,paramsOrFn,prepend=false){fns[prepend?"unshift":"push"](()=>{const params=Array.isArray(paramsOrFn)?paramsOrFn:paramsOrFn();return instruction(span,reference,params).toStmt()})}processStylingUpdateInstruction(elementIndex,
instruction){let allocateBindingSlots=0;if(instruction){const calls=[];instruction.calls.forEach(call=>{allocateBindingSlots+=call.allocateBindingSlots;calls.push({sourceSpan:call.sourceSpan,value:()=>{return call.params(value=>call.supportsInterpolation&&value instanceof Interpolation?this.getUpdateInstructionArguments(value):this.convertPropertyBinding(value))}})});this.updateInstructionChainWithAdvance(elementIndex,instruction.reference,calls)}return allocateBindingSlots}creationInstruction(span,
reference,paramsOrFn,prepend){this.instructionFn(this._creationCodeFns,span,reference,paramsOrFn||[],prepend)}creationInstructionChain(reference,calls){const span=calls.length?calls[0].sourceSpan:null;this._creationCodeFns.push(()=>{return chainedInstruction(reference,calls.map(call=>call.params()),span).toStmt()})}updateInstructionWithAdvance(nodeIndex,span,reference,paramsOrFn){this.addAdvanceInstructionIfNecessary(nodeIndex,span);this.updateInstruction(span,reference,paramsOrFn)}updateInstruction(span,
reference,paramsOrFn){this.instructionFn(this._updateCodeFns,span,reference,paramsOrFn||[])}updateInstructionChain(reference,bindings){const span=bindings.length?bindings[0].sourceSpan:null;this._updateCodeFns.push(()=>{const calls=bindings.map(property=>{const value=property.value();const fnParams=Array.isArray(value)?value:[value];if(property.params)fnParams.push(...property.params);if(property.name)fnParams.unshift(literal(property.name));return fnParams});return chainedInstruction(reference,calls,
span).toStmt()})}updateInstructionChainWithAdvance(nodeIndex,reference,bindings){this.addAdvanceInstructionIfNecessary(nodeIndex,bindings.length?bindings[0].sourceSpan:null);this.updateInstructionChain(reference,bindings)}addAdvanceInstructionIfNecessary(nodeIndex,span){if(nodeIndex!==this._currentIndex){const delta=nodeIndex-this._currentIndex;if(delta<1)throw new Error("advance instruction can only go forwards");this.instructionFn(this._updateCodeFns,span,Identifiers$1.advance,[literal(delta)]);
this._currentIndex=nodeIndex}}allocatePureFunctionSlots(numSlots){const originalSlots=this._pureFunctionSlots;this._pureFunctionSlots+=numSlots;return originalSlots}allocateBindingSlots(value){this._bindingSlots+=value instanceof Interpolation?value.expressions.length:1}getImplicitReceiverExpr(){if(this._implicitReceiverExpr)return this._implicitReceiverExpr;return this._implicitReceiverExpr=this.level===0?variable(CONTEXT_NAME):this._bindingScope.getOrCreateSharedContextVar(0)}convertPropertyBinding(value){const convertedPropertyBinding=
convertPropertyBinding(this,this.getImplicitReceiverExpr(),value,this.bindingContext(),()=>error("Unexpected interpolation"));const valExpr=convertedPropertyBinding.currValExpr;this._tempVariables.push(...convertedPropertyBinding.stmts);return valExpr}getUpdateInstructionArguments(value){const {args,stmts}=convertUpdateArguments(this,this.getImplicitReceiverExpr(),value,this.bindingContext());this._tempVariables.push(...stmts);return args}getAttributeExpressions(elementName,renderAttributes,inputs,
outputs,styles,templateAttrs=[],boundI18nAttrs=[]){const alreadySeen=new Set;const attrExprs=[];let ngProjectAsAttr;for(const attr of renderAttributes){if(attr.name===NG_PROJECT_AS_ATTR_NAME)ngProjectAsAttr=attr;if(attr.i18n){const {i18nVarRefsCache}=this._constants;let i18nVarRef;if(i18nVarRefsCache.has(attr.i18n))i18nVarRef=i18nVarRefsCache.get(attr.i18n);else{i18nVarRef=this.i18nTranslate(attr.i18n);i18nVarRefsCache.set(attr.i18n,i18nVarRef)}attrExprs.push(literal(attr.name),i18nVarRef)}else attrExprs.push(...getAttributeNameLiterals(attr.name),
trustedConstAttribute(elementName,attr))}if(ngProjectAsAttr)attrExprs.push(...getNgProjectAsLiteral(ngProjectAsAttr));function addAttrExpr(key,value){if(typeof key==="string"){if(!alreadySeen.has(key)){attrExprs.push(...getAttributeNameLiterals(key));value!==undefined&&attrExprs.push(value);alreadySeen.add(key)}}else attrExprs.push(literal(key))}if(styles)styles.populateInitialStylingAttrs(attrExprs);if(inputs.length||outputs.length){const attrsLengthBeforeInputs=attrExprs.length;for(let i=0;i<inputs.length;i++){const input=
inputs[i];if(input.type!==4&&input.type!==1)addAttrExpr(input.name)}for(let i=0;i<outputs.length;i++){const output=outputs[i];if(output.type!==1)addAttrExpr(output.name)}if(attrExprs.length!==attrsLengthBeforeInputs)attrExprs.splice(attrsLengthBeforeInputs,0,literal(3))}if(templateAttrs.length){attrExprs.push(literal(4));templateAttrs.forEach(attr=>addAttrExpr(attr.name))}if(boundI18nAttrs.length){attrExprs.push(literal(6));boundI18nAttrs.forEach(attr=>addAttrExpr(attr.name))}return attrExprs}addToConsts(expression){if(isNull(expression))return TYPED_NULL_EXPR;
const consts=this._constants.constExpressions;for(let i=0;i<consts.length;i++)if(consts[i].isEquivalent(expression))return literal(i);return literal(consts.push(expression)-1)}addAttrsToConsts(attrs){return attrs.length>0?this.addToConsts(literalArr(attrs)):TYPED_NULL_EXPR}prepareRefsArray(references){if(!references||references.length===0)return TYPED_NULL_EXPR;const refsParam=flatten(references.map(reference=>{const slot=this.allocateDataSlot();const variableName=this._bindingScope.freshReferenceName();
const retrievalLevel=this.level;const lhs=variable(variableName);this._bindingScope.set(retrievalLevel,reference.name,lhs,0,(scope,relativeLevel)=>{const nextContextStmt=relativeLevel>0?[generateNextContextExpr(relativeLevel).toStmt()]:[];const refExpr=lhs.set(importExpr(Identifiers$1.reference).callFn([literal(slot)]));return nextContextStmt.concat(refExpr.toConstDecl())},true);return[reference.name,reference.value]}));return asLiteral(refsParam)}prepareListenerParameter(tagName,outputAst,index){return()=>
{const eventName=outputAst.name;const bindingFnName=outputAst.type===1?prepareSyntheticListenerFunctionName(eventName,outputAst.phase):sanitizeIdentifier(eventName);const handlerName=`${this.templateName}_${tagName}_${bindingFnName}_${index}_listener`;const scope=this._bindingScope.nestedScope(this._bindingScope.bindingLevel,EVENT_BINDING_SCOPE_GLOBALS);return prepareEventListenerParameters(outputAst,handlerName,scope)}}}class ValueConverter extends AstMemoryEfficientTransformer{constructor(constantPool,
allocateSlot,allocatePureFunctionSlots,definePipe){super();this.constantPool=constantPool;this.allocateSlot=allocateSlot;this.allocatePureFunctionSlots=allocatePureFunctionSlots;this.definePipe=definePipe;this._pipeBindExprs=[]}visitPipe(pipe,context){const slot=this.allocateSlot();const slotPseudoLocal=`PIPE:${slot}`;const pureFunctionSlot=this.allocatePureFunctionSlots(2+pipe.args.length);const target=new PropertyRead(pipe.span,pipe.sourceSpan,pipe.nameSpan,new ImplicitReceiver(pipe.span,pipe.sourceSpan),
slotPseudoLocal);const {identifier,isVarLength}=pipeBindingCallInfo(pipe.args);this.definePipe(pipe.name,slotPseudoLocal,slot,importExpr(identifier));const args=[pipe.exp,...pipe.args];const convertedArgs=isVarLength?this.visitAll([new LiteralArray(pipe.span,pipe.sourceSpan,args)]):this.visitAll(args);const pipeBindExpr=new Call(pipe.span,pipe.sourceSpan,target,[new LiteralPrimitive(pipe.span,pipe.sourceSpan,slot),new LiteralPrimitive(pipe.span,pipe.sourceSpan,pureFunctionSlot),...convertedArgs],
null);this._pipeBindExprs.push(pipeBindExpr);return pipeBindExpr}updatePipeSlotOffsets(bindingSlots){this._pipeBindExprs.forEach(pipe=>{const slotOffset=pipe.args[1];slotOffset.value+=bindingSlots})}visitLiteralArray(array,context){return new BuiltinFunctionCall(array.span,array.sourceSpan,this.visitAll(array.expressions),values=>{const literal=literalArr(values);return getLiteralFactory(this.constantPool,literal,this.allocatePureFunctionSlots)})}visitLiteralMap(map,context){return new BuiltinFunctionCall(map.span,
map.sourceSpan,this.visitAll(map.values),values=>{const literal=literalMap(values.map((value,index)=>({key:map.keys[index].key,value,quoted:map.keys[index].quoted})));return getLiteralFactory(this.constantPool,literal,this.allocatePureFunctionSlots)})}}const pipeBindingIdentifiers=[Identifiers$1.pipeBind1,Identifiers$1.pipeBind2,Identifiers$1.pipeBind3,Identifiers$1.pipeBind4];function pipeBindingCallInfo(args){const identifier=pipeBindingIdentifiers[args.length];return{identifier:identifier||Identifiers$1.pipeBindV,
isVarLength:!identifier}}const pureFunctionIdentifiers=[Identifiers$1.pureFunction0,Identifiers$1.pureFunction1,Identifiers$1.pureFunction2,Identifiers$1.pureFunction3,Identifiers$1.pureFunction4,Identifiers$1.pureFunction5,Identifiers$1.pureFunction6,Identifiers$1.pureFunction7,Identifiers$1.pureFunction8];function pureFunctionCallInfo(args){const identifier=pureFunctionIdentifiers[args.length];return{identifier:identifier||Identifiers$1.pureFunctionV,isVarLength:!identifier}}function instruction(span,
reference,params){return importExpr(reference,null,span).callFn(params,span)}function generateNextContextExpr(relativeLevelDiff){return importExpr(Identifiers$1.nextContext).callFn(relativeLevelDiff>1?[literal(relativeLevelDiff)]:[])}function getLiteralFactory(constantPool,literal$1,allocateSlots){const {literalFactory,literalFactoryArguments}=constantPool.getLiteralFactory(literal$1);const startSlot=allocateSlots(1+literalFactoryArguments.length);const {identifier,isVarLength}=pureFunctionCallInfo(literalFactoryArguments);
const args=[literal(startSlot),literalFactory];if(isVarLength)args.push(literalArr(literalFactoryArguments));else args.push(...literalFactoryArguments);return importExpr(identifier).callFn(args)}function getAttributeNameLiterals(name){const [attributeNamespace,attributeName]=splitNsName(name);const nameLiteral=literal(attributeName);if(attributeNamespace)return[literal(0),literal(attributeNamespace),nameLiteral];return[nameLiteral]}const SHARED_CONTEXT_KEY="$$shared_ctx$$";class BindingScope{constructor(bindingLevel=
0,parent=null,globals){this.bindingLevel=bindingLevel;this.parent=parent;this.globals=globals;this.map=new Map;this.referenceNameIndex=0;this.restoreViewVariable=null;this.usesRestoredViewContext=false;if(globals!==undefined)for(const name of globals)this.set(0,name,variable(name))}static createRootScope(){return new BindingScope}get(name){let current=this;while(current){let value=current.map.get(name);if(value!=null){if(current!==this){value={retrievalLevel:value.retrievalLevel,lhs:value.lhs,declareLocalCallback:value.declareLocalCallback,
declare:false,priority:value.priority};this.map.set(name,value);this.maybeGenerateSharedContextVar(value);this.maybeRestoreView()}if(value.declareLocalCallback&&!value.declare)value.declare=true;return value.lhs}current=current.parent}return this.bindingLevel===0?null:this.getComponentProperty(name)}set(retrievalLevel,name,lhs,priority=0,declareLocalCallback,localRef){if(this.map.has(name)){if(localRef)return this;error(`The name ${name} is already defined in scope to be ${this.map.get(name)}`)}this.map.set(name,
{retrievalLevel:retrievalLevel,lhs:lhs,declare:false,declareLocalCallback:declareLocalCallback,priority:priority});return this}getLocal(name){return this.get(name)}notifyImplicitReceiverUse(){if(this.bindingLevel!==0)this.map.get(SHARED_CONTEXT_KEY+0).declare=true}nestedScope(level,globals){const newScope=new BindingScope(level,this,globals);if(level>0)newScope.generateSharedContextVar(0);return newScope}getOrCreateSharedContextVar(retrievalLevel){const bindingKey=SHARED_CONTEXT_KEY+retrievalLevel;
if(!this.map.has(bindingKey))this.generateSharedContextVar(retrievalLevel);return this.map.get(bindingKey).lhs}getSharedContextName(retrievalLevel){const sharedCtxObj=this.map.get(SHARED_CONTEXT_KEY+retrievalLevel);return sharedCtxObj&&sharedCtxObj.declare?sharedCtxObj.lhs:null}maybeGenerateSharedContextVar(value){if(value.priority===1&&value.retrievalLevel<this.bindingLevel){const sharedCtxObj=this.map.get(SHARED_CONTEXT_KEY+value.retrievalLevel);if(sharedCtxObj)sharedCtxObj.declare=true;else this.generateSharedContextVar(value.retrievalLevel)}}generateSharedContextVar(retrievalLevel){const lhs=
variable(CONTEXT_NAME+this.freshReferenceName());this.map.set(SHARED_CONTEXT_KEY+retrievalLevel,{retrievalLevel:retrievalLevel,lhs:lhs,declareLocalCallback:(scope,relativeLevel)=>{return[lhs.set(generateNextContextExpr(relativeLevel)).toConstDecl()]},declare:false,priority:2})}getComponentProperty(name){const componentValue=this.map.get(SHARED_CONTEXT_KEY+0);componentValue.declare=true;this.maybeRestoreView();return componentValue.lhs.prop(name)}maybeRestoreView(){if(this.isListenerScope()){if(!this.parent.restoreViewVariable)this.parent.restoreViewVariable=
variable(this.parent.freshReferenceName());this.restoreViewVariable=this.parent.restoreViewVariable}}restoreViewStatement(){const statements=[];if(this.restoreViewVariable){const restoreCall=instruction(null,Identifiers$1.restoreView,[this.restoreViewVariable]);statements.push(this.usesRestoredViewContext?variable(RESTORED_VIEW_CONTEXT_NAME).set(restoreCall).toConstDecl():restoreCall.toStmt())}return statements}viewSnapshotStatements(){return this.restoreViewVariable?[this.restoreViewVariable.set(instruction(null,
Identifiers$1.getCurrentView,[])).toConstDecl()]:[]}isListenerScope(){return this.parent&&this.parent.bindingLevel===this.bindingLevel}variableDeclarations(){let currentContextLevel=0;return Array.from(this.map.values()).filter(value=>value.declare).sort((a,b)=>b.retrievalLevel-a.retrievalLevel||b.priority-a.priority).reduce((stmts,value)=>{const levelDiff=this.bindingLevel-value.retrievalLevel;const currStmts=value.declareLocalCallback(this,levelDiff-currentContextLevel);currentContextLevel=levelDiff;
return stmts.concat(currStmts)},[])}freshReferenceName(){let current=this;while(current.parent)current=current.parent;const ref=`${REFERENCE_PREFIX}${current.referenceNameIndex++}`;return ref}hasRestoreViewVariable(){return!!this.restoreViewVariable}notifyRestoredViewContextUse(){this.usesRestoredViewContext=true}}function createCssSelector(elementName,attributes){const cssSelector=new CssSelector;const elementNameNoNs=splitNsName(elementName)[1];cssSelector.setElement(elementNameNoNs);Object.getOwnPropertyNames(attributes).forEach(name=>
{const nameNoNs=splitNsName(name)[1];const value=attributes[name];cssSelector.addAttribute(nameNoNs,value);if(name.toLowerCase()==="class"){const classes=value.trim().split(/\s+/);classes.forEach(className=>cssSelector.addClassName(className))}});return cssSelector}function getNgProjectAsLiteral(attribute){const parsedR3Selector=parseSelectorToR3Selector(attribute.value)[0];return[literal(5),asLiteral(parsedR3Selector)]}function getPropertyInterpolationExpression(interpolation){switch(getInterpolationArgsLength(interpolation)){case 1:return Identifiers$1.propertyInterpolate;
case 3:return Identifiers$1.propertyInterpolate1;case 5:return Identifiers$1.propertyInterpolate2;case 7:return Identifiers$1.propertyInterpolate3;case 9:return Identifiers$1.propertyInterpolate4;case 11:return Identifiers$1.propertyInterpolate5;case 13:return Identifiers$1.propertyInterpolate6;case 15:return Identifiers$1.propertyInterpolate7;case 17:return Identifiers$1.propertyInterpolate8;default:return Identifiers$1.propertyInterpolateV}}function getAttributeInterpolationExpression(interpolation){switch(getInterpolationArgsLength(interpolation)){case 3:return Identifiers$1.attributeInterpolate1;
case 5:return Identifiers$1.attributeInterpolate2;case 7:return Identifiers$1.attributeInterpolate3;case 9:return Identifiers$1.attributeInterpolate4;case 11:return Identifiers$1.attributeInterpolate5;case 13:return Identifiers$1.attributeInterpolate6;case 15:return Identifiers$1.attributeInterpolate7;case 17:return Identifiers$1.attributeInterpolate8;default:return Identifiers$1.attributeInterpolateV}}function getTextInterpolationExpression(interpolation){switch(getInterpolationArgsLength(interpolation)){case 1:return Identifiers$1.textInterpolate;
case 3:return Identifiers$1.textInterpolate1;case 5:return Identifiers$1.textInterpolate2;case 7:return Identifiers$1.textInterpolate3;case 9:return Identifiers$1.textInterpolate4;case 11:return Identifiers$1.textInterpolate5;case 13:return Identifiers$1.textInterpolate6;case 15:return Identifiers$1.textInterpolate7;case 17:return Identifiers$1.textInterpolate8;default:return Identifiers$1.textInterpolateV}}function parseTemplate(template,templateUrl,options={}){const {interpolationConfig,preserveWhitespaces,
enableI18nLegacyMessageIdFormat}=options;const bindingParser=makeBindingParser(interpolationConfig);const htmlParser=new HtmlParser;const parseResult=htmlParser.parse(template,templateUrl,Object.assign(Object.assign({leadingTriviaChars:LEADING_TRIVIA_CHARS},options),{tokenizeExpansionForms:true}));if(!options.alwaysAttemptHtmlToR3AstConversion&&parseResult.errors&&parseResult.errors.length>0){const parsedTemplate={interpolationConfig,preserveWhitespaces,errors:parseResult.errors,nodes:[],styleUrls:[],
styles:[],ngContentSelectors:[]};if(options.collectCommentNodes)parsedTemplate.commentNodes=[];return parsedTemplate}let rootNodes=parseResult.rootNodes;const i18nMetaVisitor=new I18nMetaVisitor(interpolationConfig,!preserveWhitespaces,enableI18nLegacyMessageIdFormat);const i18nMetaResult=i18nMetaVisitor.visitAllWithErrors(rootNodes);if(!options.alwaysAttemptHtmlToR3AstConversion&&i18nMetaResult.errors&&i18nMetaResult.errors.length>0){const parsedTemplate={interpolationConfig,preserveWhitespaces,
errors:i18nMetaResult.errors,nodes:[],styleUrls:[],styles:[],ngContentSelectors:[]};if(options.collectCommentNodes)parsedTemplate.commentNodes=[];return parsedTemplate}rootNodes=i18nMetaResult.rootNodes;if(!preserveWhitespaces){rootNodes=visitAll(new WhitespaceVisitor,rootNodes);if(i18nMetaVisitor.hasI18nMeta)rootNodes=visitAll(new I18nMetaVisitor(interpolationConfig,false),rootNodes)}const {nodes,errors,styleUrls,styles,ngContentSelectors,commentNodes}=htmlAstToRender3Ast(rootNodes,bindingParser,
{collectCommentNodes:!!options.collectCommentNodes});errors.push(...parseResult.errors,...i18nMetaResult.errors);const parsedTemplate={interpolationConfig,preserveWhitespaces,errors:errors.length>0?errors:null,nodes,styleUrls,styles,ngContentSelectors};if(options.collectCommentNodes)parsedTemplate.commentNodes=commentNodes;return parsedTemplate}const elementRegistry=new DomElementSchemaRegistry;function makeBindingParser(interpolationConfig=DEFAULT_INTERPOLATION_CONFIG){return new BindingParser(new Parser$1(new Lexer),
interpolationConfig,elementRegistry,[])}function resolveSanitizationFn(context,isAttribute){switch(context){case SecurityContext.HTML:return importExpr(Identifiers$1.sanitizeHtml);case SecurityContext.SCRIPT:return importExpr(Identifiers$1.sanitizeScript);case SecurityContext.STYLE:return isAttribute?importExpr(Identifiers$1.sanitizeStyle):null;case SecurityContext.URL:return importExpr(Identifiers$1.sanitizeUrl);case SecurityContext.RESOURCE_URL:return importExpr(Identifiers$1.sanitizeResourceUrl);
default:return null}}function trustedConstAttribute(tagName,attr){const value=asLiteral(attr.value);if(isTrustedTypesSink(tagName,attr.name))switch(elementRegistry.securityContext(tagName,attr.name,true)){case SecurityContext.HTML:return taggedTemplate(importExpr(Identifiers$1.trustConstantHtml),new TemplateLiteral([new TemplateLiteralElement(attr.value)],[]),undefined,attr.valueSpan);case SecurityContext.RESOURCE_URL:return taggedTemplate(importExpr(Identifiers$1.trustConstantResourceUrl),new TemplateLiteral([new TemplateLiteralElement(attr.value)],
[]),undefined,attr.valueSpan);default:return value}else return value}function isSingleElementTemplate(children){return children.length===1&&children[0]instanceof Element$1}function isTextNode(node){return node instanceof Text$3||node instanceof BoundText||node instanceof Icu$1}function hasTextChildrenOnly(children){return children.every(isTextNode)}const NG_I18N_CLOSURE_MODE="ngI18nClosureMode";function getTranslationDeclStmts(message,variable,closureVar,params={},transformFn){const statements=[declareI18nVariable(variable),
ifStmt(createClosureModeGuard(),createGoogleGetMsgStatements(variable,message,closureVar,i18nFormatPlaceholderNames(params,true)),createLocalizeStatements(variable,message,i18nFormatPlaceholderNames(params,false)))];if(transformFn)statements.push(new ExpressionStatement(variable.set(transformFn(variable))));return statements}function createClosureModeGuard(){return typeofExpr(variable(NG_I18N_CLOSURE_MODE)).notIdentical(literal("undefined",STRING_TYPE)).and(variable(NG_I18N_CLOSURE_MODE))}function flatten(list){return list.reduce((flat,
item)=>{const flatItem=Array.isArray(item)?flatten(item):item;return flat.concat(flatItem)},[])}const ATTR_REGEX=/attr\.([^\]]+)/;const COMPONENT_VARIABLE="%COMP%";const HOST_ATTR=`_nghost-${COMPONENT_VARIABLE}`;const CONTENT_ATTR=`_ngcontent-${COMPONENT_VARIABLE}`;function baseDirectiveFields(meta,constantPool,bindingParser){const definitionMap=new DefinitionMap;const selectors=parseSelectorToR3Selector(meta.selector);definitionMap.set("type",meta.internalType);if(selectors.length>0)definitionMap.set("selectors",
asLiteral(selectors));if(meta.queries.length>0)definitionMap.set("contentQueries",createContentQueriesFunction(meta.queries,constantPool,meta.name));if(meta.viewQueries.length)definitionMap.set("viewQuery",createViewQueriesFunction(meta.viewQueries,constantPool,meta.name));definitionMap.set("hostBindings",createHostBindingsFunction(meta.host,meta.typeSourceSpan,bindingParser,constantPool,meta.selector||"",meta.name,definitionMap));definitionMap.set("inputs",conditionallyCreateMapObjectLiteral(meta.inputs,
true));definitionMap.set("outputs",conditionallyCreateMapObjectLiteral(meta.outputs));if(meta.exportAs!==null)definitionMap.set("exportAs",literalArr(meta.exportAs.map(e=>literal(e))));return definitionMap}function addFeatures(definitionMap,meta){const features=[];const providers=meta.providers;const viewProviders=meta.viewProviders;if(providers||viewProviders){const args=[providers||new LiteralArrayExpr([])];if(viewProviders)args.push(viewProviders);features.push(importExpr(Identifiers$1.ProvidersFeature).callFn(args))}if(meta.usesInheritance)features.push(importExpr(Identifiers$1.InheritDefinitionFeature));
if(meta.fullInheritance)features.push(importExpr(Identifiers$1.CopyDefinitionFeature));if(meta.lifecycle.usesOnChanges)features.push(importExpr(Identifiers$1.NgOnChangesFeature));if(features.length)definitionMap.set("features",literalArr(features))}function compileDirectiveFromMetadata(meta,constantPool,bindingParser){const definitionMap=baseDirectiveFields(meta,constantPool,bindingParser);addFeatures(definitionMap,meta);const expression=importExpr(Identifiers$1.defineDirective).callFn([definitionMap.toLiteralMap()],
undefined,true);const type=createDirectiveType(meta);return{expression,type,statements:[]}}function compileComponentFromMetadata(meta,constantPool,bindingParser){const definitionMap=baseDirectiveFields(meta,constantPool,bindingParser);addFeatures(definitionMap,meta);const selector=meta.selector&&CssSelector.parse(meta.selector);const firstSelector=selector&&selector[0];if(firstSelector){const selectorAttributes=firstSelector.getAttrs();if(selectorAttributes.length)definitionMap.set("attrs",constantPool.getConstLiteral(literalArr(selectorAttributes.map(value=>
value!=null?literal(value):literal(undefined))),true))}const templateTypeName=meta.name;const templateName=templateTypeName?`${templateTypeName}_Template`:null;const changeDetection=meta.changeDetection;const template=meta.template;const templateBuilder=new TemplateDefinitionBuilder(constantPool,BindingScope.createRootScope(),0,templateTypeName,null,null,templateName,Identifiers$1.namespaceHTML,meta.relativeContextFilePath,meta.i18nUseExternalIds);const templateFunctionExpression=templateBuilder.buildTemplateFunction(template.nodes,
[]);const ngContentSelectors=templateBuilder.getNgContentSelectors();if(ngContentSelectors)definitionMap.set("ngContentSelectors",ngContentSelectors);definitionMap.set("decls",literal(templateBuilder.getConstCount()));definitionMap.set("vars",literal(templateBuilder.getVarCount()));const {constExpressions,prepareStatements}=templateBuilder.getConsts();if(constExpressions.length>0){let constsExpr=literalArr(constExpressions);if(prepareStatements.length>0)constsExpr=fn([],[...prepareStatements,new ReturnStatement(constsExpr)]);
definitionMap.set("consts",constsExpr)}definitionMap.set("template",templateFunctionExpression);if(meta.directives.length>0){const directivesList=literalArr(meta.directives.map(dir=>dir.type));const directivesExpr=compileDeclarationList(directivesList,meta.declarationListEmitMode);definitionMap.set("directives",directivesExpr)}if(meta.pipes.size>0){const pipesList=literalArr(Array.from(meta.pipes.values()));const pipesExpr=compileDeclarationList(pipesList,meta.declarationListEmitMode);definitionMap.set("pipes",
pipesExpr)}if(meta.encapsulation===null)meta.encapsulation=exports.ViewEncapsulation.Emulated;if(meta.styles&&meta.styles.length){const styleValues=meta.encapsulation==exports.ViewEncapsulation.Emulated?compileStyles(meta.styles,CONTENT_ATTR,HOST_ATTR):meta.styles;const strings=styleValues.map(str=>constantPool.getConstLiteral(literal(str)));definitionMap.set("styles",literalArr(strings))}else if(meta.encapsulation===exports.ViewEncapsulation.Emulated)meta.encapsulation=exports.ViewEncapsulation.None;
if(meta.encapsulation!==exports.ViewEncapsulation.Emulated)definitionMap.set("encapsulation",literal(meta.encapsulation));if(meta.animations!==null)definitionMap.set("data",literalMap([{key:"animation",value:meta.animations,quoted:false}]));if(changeDetection!=null&&changeDetection!==exports.ChangeDetectionStrategy.Default)definitionMap.set("changeDetection",literal(changeDetection));const expression=importExpr(Identifiers$1.defineComponent).callFn([definitionMap.toLiteralMap()],undefined,true);const type=
createComponentType(meta);return{expression,type,statements:[]}}function createComponentType(meta){const typeParams=createDirectiveTypeParams(meta);typeParams.push(stringArrayAsType(meta.template.ngContentSelectors));return expressionType(importExpr(Identifiers$1.ComponentDeclaration,typeParams))}function compileDeclarationList(list,mode){switch(mode){case 0:return list;case 1:return fn([],[new ReturnStatement(list)]);case 2:const resolvedList=list.prop("map").callFn([importExpr(Identifiers$1.resolveForwardRef)]);
return fn([],[new ReturnStatement(resolvedList)])}}function prepareQueryParams(query,constantPool){const parameters=[getQueryPredicate(query,constantPool),literal(toQueryFlags(query))];if(query.read)parameters.push(query.read);return parameters}function toQueryFlags(query){return(query.descendants?1:0)|(query.static?2:0)|(query.emitDistinctChangesOnly?4:0)}function convertAttributesToExpressions(attributes){const values=[];for(let key of Object.getOwnPropertyNames(attributes)){const value=attributes[key];
values.push(literal(key),value)}return values}function createContentQueriesFunction(queries,constantPool,name){const createStatements=[];const updateStatements=[];const tempAllocator=temporaryAllocator(updateStatements,TEMPORARY_NAME);for(const query of queries){createStatements.push(importExpr(Identifiers$1.contentQuery).callFn([variable("dirIndex"),...prepareQueryParams(query,constantPool)]).toStmt());const temporary=tempAllocator();const getQueryList=importExpr(Identifiers$1.loadQuery).callFn([]);
const refresh=importExpr(Identifiers$1.queryRefresh).callFn([temporary.set(getQueryList)]);const updateDirective=variable(CONTEXT_NAME).prop(query.propertyName).set(query.first?temporary.prop("first"):temporary);updateStatements.push(refresh.and(updateDirective).toStmt())}const contentQueriesFnName=name?`${name}_ContentQueries`:null;return fn([new FnParam(RENDER_FLAGS,NUMBER_TYPE),new FnParam(CONTEXT_NAME,null),new FnParam("dirIndex",null)],[renderFlagCheckIfStmt(1,createStatements),renderFlagCheckIfStmt(2,
updateStatements)],INFERRED_TYPE,null,contentQueriesFnName)}function stringAsType(str){return expressionType(literal(str))}function stringMapAsType(map){const mapValues=Object.keys(map).map(key=>{const value=Array.isArray(map[key])?map[key][0]:map[key];return{key,value:literal(value),quoted:true}});return expressionType(literalMap(mapValues))}function stringArrayAsType(arr){return arr.length>0?expressionType(literalArr(arr.map(value=>literal(value)))):NONE_TYPE}function createDirectiveTypeParams(meta){const selectorForType=
meta.selector!==null?meta.selector.replace(/\n/g,""):null;return[typeWithParameters(meta.type.type,meta.typeArgumentCount),selectorForType!==null?stringAsType(selectorForType):NONE_TYPE,meta.exportAs!==null?stringArrayAsType(meta.exportAs):NONE_TYPE,stringMapAsType(meta.inputs),stringMapAsType(meta.outputs),stringArrayAsType(meta.queries.map(q=>q.propertyName))]}function createDirectiveType(meta){const typeParams=createDirectiveTypeParams(meta);return expressionType(importExpr(Identifiers$1.DirectiveDeclaration,
typeParams))}function createViewQueriesFunction(viewQueries,constantPool,name){const createStatements=[];const updateStatements=[];const tempAllocator=temporaryAllocator(updateStatements,TEMPORARY_NAME);viewQueries.forEach(query=>{const queryDefinition=importExpr(Identifiers$1.viewQuery).callFn(prepareQueryParams(query,constantPool));createStatements.push(queryDefinition.toStmt());const temporary=tempAllocator();const getQueryList=importExpr(Identifiers$1.loadQuery).callFn([]);const refresh=importExpr(Identifiers$1.queryRefresh).callFn([temporary.set(getQueryList)]);
const updateDirective=variable(CONTEXT_NAME).prop(query.propertyName).set(query.first?temporary.prop("first"):temporary);updateStatements.push(refresh.and(updateDirective).toStmt())});const viewQueryFnName=name?`${name}_Query`:null;return fn([new FnParam(RENDER_FLAGS,NUMBER_TYPE),new FnParam(CONTEXT_NAME,null)],[renderFlagCheckIfStmt(1,createStatements),renderFlagCheckIfStmt(2,updateStatements)],INFERRED_TYPE,null,viewQueryFnName)}function createHostBindingsFunction(hostBindingsMetadata,typeSourceSpan,
bindingParser,constantPool,selector,name,definitionMap){const bindingContext=variable(CONTEXT_NAME);const styleBuilder=new StylingBuilder(bindingContext);const {styleAttr,classAttr}=hostBindingsMetadata.specialAttributes;if(styleAttr!==undefined)styleBuilder.registerStyleAttr(styleAttr);if(classAttr!==undefined)styleBuilder.registerClassAttr(classAttr);const createStatements=[];const updateStatements=[];const hostBindingSourceSpan=typeSourceSpan;const eventBindings=bindingParser.createDirectiveHostEventAsts(hostBindingsMetadata.listeners,
hostBindingSourceSpan);if(eventBindings&&eventBindings.length){const listeners=createHostListeners(eventBindings,name);createStatements.push(...listeners)}const bindings=bindingParser.createBoundHostProperties(hostBindingsMetadata.properties,hostBindingSourceSpan);const allOtherBindings=[];let totalHostVarsCount=0;bindings&&bindings.forEach(binding=>{const stylingInputWasSet=styleBuilder.registerInputBasedOnName(binding.name,binding.expression,hostBindingSourceSpan);if(stylingInputWasSet)totalHostVarsCount+=
MIN_STYLING_BINDING_SLOTS_REQUIRED;else{allOtherBindings.push(binding);totalHostVarsCount++}});let valueConverter;const getValueConverter=()=>{if(!valueConverter){const hostVarsCountFn=numSlots=>{const originalVarsCount=totalHostVarsCount;totalHostVarsCount+=numSlots;return originalVarsCount};valueConverter=new ValueConverter(constantPool,()=>error("Unexpected node"),hostVarsCountFn,()=>error("Unexpected pipe"))}return valueConverter};const propertyBindings=[];const attributeBindings=[];const syntheticHostBindings=
[];allOtherBindings.forEach(binding=>{const value=binding.expression.visit(getValueConverter());const bindingExpr=bindingFn(bindingContext,value);const {bindingName,instruction,isAttribute}=getBindingNameAndInstruction(binding);const securityContexts=bindingParser.calcPossibleSecurityContexts(selector,bindingName,isAttribute).filter(context=>context!==SecurityContext.NONE);let sanitizerFn=null;if(securityContexts.length)if(securityContexts.length===2&&securityContexts.indexOf(SecurityContext.URL)>
-1&&securityContexts.indexOf(SecurityContext.RESOURCE_URL)>-1)sanitizerFn=importExpr(Identifiers$1.sanitizeUrlOrResourceUrl);else sanitizerFn=resolveSanitizationFn(securityContexts[0],isAttribute);const instructionParams=[literal(bindingName),bindingExpr.currValExpr];if(sanitizerFn)instructionParams.push(sanitizerFn);updateStatements.push(...bindingExpr.stmts);if(instruction===Identifiers$1.hostProperty)propertyBindings.push(instructionParams);else if(instruction===Identifiers$1.attribute)attributeBindings.push(instructionParams);
else if(instruction===Identifiers$1.syntheticHostProperty)syntheticHostBindings.push(instructionParams);else updateStatements.push(importExpr(instruction).callFn(instructionParams).toStmt())});if(propertyBindings.length>0)updateStatements.push(chainedInstruction(Identifiers$1.hostProperty,propertyBindings).toStmt());if(attributeBindings.length>0)updateStatements.push(chainedInstruction(Identifiers$1.attribute,attributeBindings).toStmt());if(syntheticHostBindings.length>0)updateStatements.push(chainedInstruction(Identifiers$1.syntheticHostProperty,
syntheticHostBindings).toStmt());const hostAttrs=convertAttributesToExpressions(hostBindingsMetadata.attributes);styleBuilder.assignHostAttrs(hostAttrs,definitionMap);if(styleBuilder.hasBindings)styleBuilder.buildUpdateLevelInstructions(getValueConverter()).forEach(instruction=>{if(instruction.calls.length>0){const calls=[];instruction.calls.forEach(call=>{totalHostVarsCount+=Math.max(call.allocateBindingSlots-MIN_STYLING_BINDING_SLOTS_REQUIRED,0);calls.push(convertStylingCall(call,bindingContext,
bindingFn))});updateStatements.push(chainedInstruction(instruction.reference,calls).toStmt())}});if(totalHostVarsCount)definitionMap.set("hostVars",literal(totalHostVarsCount));if(createStatements.length>0||updateStatements.length>0){const hostBindingsFnName=name?`${name}_HostBindings`:null;const statements=[];if(createStatements.length>0)statements.push(renderFlagCheckIfStmt(1,createStatements));if(updateStatements.length>0)statements.push(renderFlagCheckIfStmt(2,updateStatements));return fn([new FnParam(RENDER_FLAGS,
NUMBER_TYPE),new FnParam(CONTEXT_NAME,null)],statements,INFERRED_TYPE,null,hostBindingsFnName)}return null}function bindingFn(implicit,value){return convertPropertyBinding(null,implicit,value,"b",()=>error("Unexpected interpolation"))}function convertStylingCall(call,bindingContext,bindingFn){return call.params(value=>bindingFn(bindingContext,value).currValExpr)}function getBindingNameAndInstruction(binding){let bindingName=binding.name;let instruction;const attrMatches=bindingName.match(ATTR_REGEX);
if(attrMatches){bindingName=attrMatches[1];instruction=Identifiers$1.attribute}else if(binding.isAnimation){bindingName=prepareSyntheticPropertyName(bindingName);instruction=Identifiers$1.syntheticHostProperty}else instruction=Identifiers$1.hostProperty;return{bindingName,instruction,isAttribute:!!attrMatches}}function createHostListeners(eventBindings,name){const listeners=[];const syntheticListeners=[];const instructions=[];eventBindings.forEach(binding=>{let bindingName=binding.name&&sanitizeIdentifier(binding.name);
const bindingFnName=binding.type===1?prepareSyntheticListenerFunctionName(bindingName,binding.targetOrPhase):bindingName;const handlerName=name&&bindingName?`${name}_${bindingFnName}_HostBindingHandler`:null;const params=prepareEventListenerParameters(BoundEvent.fromParsedEvent(binding),handlerName);if(binding.type==1)syntheticListeners.push(params);else listeners.push(params)});if(syntheticListeners.length>0)instructions.push(chainedInstruction(Identifiers$1.syntheticHostListener,syntheticListeners).toStmt());
if(listeners.length>0)instructions.push(chainedInstruction(Identifiers$1.listener,listeners).toStmt());return instructions}const HOST_REG_EXP=/^(?:\[([^\]]+)\])|(?:\(([^\)]+)\))$/;function parseHostBindings(host){const attributes={};const listeners={};const properties={};const specialAttributes={};for(const key of Object.keys(host)){const value=host[key];const matches=key.match(HOST_REG_EXP);if(matches===null)switch(key){case "class":if(typeof value!=="string")throw new Error(`Class binding must be string`);
specialAttributes.classAttr=value;break;case "style":if(typeof value!=="string")throw new Error(`Style binding must be string`);specialAttributes.styleAttr=value;break;default:if(typeof value==="string")attributes[key]=literal(value);else attributes[key]=value}else if(matches[1]!=null){if(typeof value!=="string")throw new Error(`Property binding must be string`);properties[matches[1]]=value}else if(matches[2]!=null){if(typeof value!=="string")throw new Error(`Event binding must be string`);listeners[matches[2]]=
value}}return{attributes,listeners,properties,specialAttributes}}function verifyHostBindings(bindings,sourceSpan){const bindingParser=makeBindingParser();bindingParser.createDirectiveHostEventAsts(bindings.listeners,sourceSpan);bindingParser.createBoundHostProperties(bindings.properties,sourceSpan);return bindingParser.errors}function compileStyles(styles,selector,hostSelector){const shadowCss=new ShadowCss;return styles.map(style=>{return shadowCss.shimCssText(style,selector,hostSelector)})}class ResourceLoader{}
class CompilerFacadeImpl{constructor(jitEvaluator=new JitEvaluator){this.jitEvaluator=jitEvaluator;this.FactoryTarget=exports.FactoryTarget;this.ResourceLoader=ResourceLoader;this.elementSchemaRegistry=new DomElementSchemaRegistry}compilePipe(angularCoreEnv,sourceMapUrl,facade){const metadata={name:facade.name,type:wrapReference(facade.type),internalType:new WrappedNodeExpr(facade.type),typeArgumentCount:0,deps:null,pipeName:facade.pipeName,pure:facade.pure};const res=compilePipeFromMetadata(metadata);
return this.jitExpression(res.expression,angularCoreEnv,sourceMapUrl,[])}compilePipeDeclaration(angularCoreEnv,sourceMapUrl,declaration){const meta=convertDeclarePipeFacadeToMetadata(declaration);const res=compilePipeFromMetadata(meta);return this.jitExpression(res.expression,angularCoreEnv,sourceMapUrl,[])}compileInjectable(angularCoreEnv,sourceMapUrl,facade){var _a;const {expression,statements}=compileInjectable({name:facade.name,type:wrapReference(facade.type),internalType:new WrappedNodeExpr(facade.type),
typeArgumentCount:facade.typeArgumentCount,providedIn:computeProvidedIn(facade.providedIn),useClass:convertToProviderExpression(facade,USE_CLASS),useFactory:wrapExpression(facade,USE_FACTORY),useValue:convertToProviderExpression(facade,USE_VALUE),useExisting:convertToProviderExpression(facade,USE_EXISTING),deps:(_a=facade.deps)===null||_a===void 0?void 0:_a.map(convertR3DependencyMetadata)},true);return this.jitExpression(expression,angularCoreEnv,sourceMapUrl,statements)}compileInjectableDeclaration(angularCoreEnv,
sourceMapUrl,facade){var _a;const {expression,statements}=compileInjectable({name:facade.type.name,type:wrapReference(facade.type),internalType:new WrappedNodeExpr(facade.type),typeArgumentCount:0,providedIn:computeProvidedIn(facade.providedIn),useClass:convertToProviderExpression(facade,USE_CLASS),useFactory:wrapExpression(facade,USE_FACTORY),useValue:convertToProviderExpression(facade,USE_VALUE),useExisting:convertToProviderExpression(facade,USE_EXISTING),deps:(_a=facade.deps)===null||_a===void 0?
void 0:_a.map(convertR3DeclareDependencyMetadata)},true);return this.jitExpression(expression,angularCoreEnv,sourceMapUrl,statements)}compileInjector(angularCoreEnv,sourceMapUrl,facade){const meta={name:facade.name,type:wrapReference(facade.type),internalType:new WrappedNodeExpr(facade.type),providers:new WrappedNodeExpr(facade.providers),imports:facade.imports.map(i=>new WrappedNodeExpr(i))};const res=compileInjector(meta);return this.jitExpression(res.expression,angularCoreEnv,sourceMapUrl,[])}compileInjectorDeclaration(angularCoreEnv,
sourceMapUrl,declaration){const meta=convertDeclareInjectorFacadeToMetadata(declaration);const res=compileInjector(meta);return this.jitExpression(res.expression,angularCoreEnv,sourceMapUrl,[])}compileNgModule(angularCoreEnv,sourceMapUrl,facade){const meta={type:wrapReference(facade.type),internalType:new WrappedNodeExpr(facade.type),adjacentType:new WrappedNodeExpr(facade.type),bootstrap:facade.bootstrap.map(wrapReference),declarations:facade.declarations.map(wrapReference),imports:facade.imports.map(wrapReference),
exports:facade.exports.map(wrapReference),emitInline:true,containsForwardDecls:false,schemas:facade.schemas?facade.schemas.map(wrapReference):null,id:facade.id?new WrappedNodeExpr(facade.id):null};const res=compileNgModule(meta);return this.jitExpression(res.expression,angularCoreEnv,sourceMapUrl,[])}compileNgModuleDeclaration(angularCoreEnv,sourceMapUrl,declaration){const expression=compileNgModuleDeclarationExpression(declaration);return this.jitExpression(expression,angularCoreEnv,sourceMapUrl,
[])}compileDirective(angularCoreEnv,sourceMapUrl,facade){const meta=convertDirectiveFacadeToMetadata(facade);return this.compileDirectiveFromMeta(angularCoreEnv,sourceMapUrl,meta)}compileDirectiveDeclaration(angularCoreEnv,sourceMapUrl,declaration){const typeSourceSpan=this.createParseSourceSpan("Directive",declaration.type.name,sourceMapUrl);const meta=convertDeclareDirectiveFacadeToMetadata(declaration,typeSourceSpan);return this.compileDirectiveFromMeta(angularCoreEnv,sourceMapUrl,meta)}compileDirectiveFromMeta(angularCoreEnv,
sourceMapUrl,meta){const constantPool=new ConstantPool;const bindingParser=makeBindingParser();const res=compileDirectiveFromMetadata(meta,constantPool,bindingParser);return this.jitExpression(res.expression,angularCoreEnv,sourceMapUrl,constantPool.statements)}compileComponent(angularCoreEnv,sourceMapUrl,facade){const {template,interpolation}=parseJitTemplate(facade.template,facade.name,sourceMapUrl,facade.preserveWhitespaces,facade.interpolation);const meta=Object.assign(Object.assign(Object.assign({},
facade),convertDirectiveFacadeToMetadata(facade)),{selector:facade.selector||this.elementSchemaRegistry.getDefaultComponentElementName(),template,declarationListEmitMode:0,styles:[...facade.styles,...template.styles],encapsulation:facade.encapsulation,interpolation,changeDetection:facade.changeDetection,animations:facade.animations!=null?new WrappedNodeExpr(facade.animations):null,viewProviders:facade.viewProviders!=null?new WrappedNodeExpr(facade.viewProviders):null,relativeContextFilePath:"",i18nUseExternalIds:true});
const jitExpressionSourceMap=`ng:///${facade.name}.js`;return this.compileComponentFromMeta(angularCoreEnv,jitExpressionSourceMap,meta)}compileComponentDeclaration(angularCoreEnv,sourceMapUrl,declaration){const typeSourceSpan=this.createParseSourceSpan("Component",declaration.type.name,sourceMapUrl);const meta=convertDeclareComponentFacadeToMetadata(declaration,typeSourceSpan,sourceMapUrl);return this.compileComponentFromMeta(angularCoreEnv,sourceMapUrl,meta)}compileComponentFromMeta(angularCoreEnv,
sourceMapUrl,meta){const constantPool=new ConstantPool;const bindingParser=makeBindingParser(meta.interpolation);const res=compileComponentFromMetadata(meta,constantPool,bindingParser);return this.jitExpression(res.expression,angularCoreEnv,sourceMapUrl,constantPool.statements)}compileFactory(angularCoreEnv,sourceMapUrl,meta){const factoryRes=compileFactoryFunction({name:meta.name,type:wrapReference(meta.type),internalType:new WrappedNodeExpr(meta.type),typeArgumentCount:meta.typeArgumentCount,deps:convertR3DependencyMetadataArray(meta.deps),
target:meta.target});return this.jitExpression(factoryRes.expression,angularCoreEnv,sourceMapUrl,factoryRes.statements)}compileFactoryDeclaration(angularCoreEnv,sourceMapUrl,meta){const factoryRes=compileFactoryFunction({name:meta.type.name,type:wrapReference(meta.type),internalType:new WrappedNodeExpr(meta.type),typeArgumentCount:0,deps:Array.isArray(meta.deps)?meta.deps.map(convertR3DeclareDependencyMetadata):meta.deps,target:meta.target});return this.jitExpression(factoryRes.expression,angularCoreEnv,
sourceMapUrl,factoryRes.statements)}createParseSourceSpan(kind,typeName,sourceUrl){return r3JitTypeSourceSpan(kind,typeName,sourceUrl)}jitExpression(def,context,sourceUrl,preStatements){const statements=[...preStatements,new DeclareVarStmt("$def",def,undefined,exports.StmtModifier.Exported)];const res=this.jitEvaluator.evaluateStatements(sourceUrl,statements,new R3JitReflector(context),true);return res["$def"]}}const USE_CLASS=Object.keys({useClass:null})[0];const USE_FACTORY=Object.keys({useFactory:null})[0];
const USE_VALUE=Object.keys({useValue:null})[0];const USE_EXISTING=Object.keys({useExisting:null})[0];function convertToR3QueryMetadata(facade){return Object.assign(Object.assign({},facade),{predicate:convertQueryPredicate(facade.predicate),read:facade.read?new WrappedNodeExpr(facade.read):null,static:facade.static,emitDistinctChangesOnly:facade.emitDistinctChangesOnly})}function convertQueryDeclarationToMetadata(declaration){var _a,_b,_c,_d;return{propertyName:declaration.propertyName,first:(_a=
declaration.first)!==null&&_a!==void 0?_a:false,predicate:convertQueryPredicate(declaration.predicate),descendants:(_b=declaration.descendants)!==null&&_b!==void 0?_b:false,read:declaration.read?new WrappedNodeExpr(declaration.read):null,static:(_c=declaration.static)!==null&&_c!==void 0?_c:false,emitDistinctChangesOnly:(_d=declaration.emitDistinctChangesOnly)!==null&&_d!==void 0?_d:true}}function convertQueryPredicate(predicate){return Array.isArray(predicate)?predicate:createMayBeForwardRefExpression(new WrappedNodeExpr(predicate),
1)}function convertDirectiveFacadeToMetadata(facade){const inputsFromMetadata=parseInputOutputs(facade.inputs||[]);const outputsFromMetadata=parseInputOutputs(facade.outputs||[]);const propMetadata=facade.propMetadata;const inputsFromType={};const outputsFromType={};for(const field in propMetadata)if(propMetadata.hasOwnProperty(field))propMetadata[field].forEach(ann=>{if(isInput(ann))inputsFromType[field]=ann.bindingPropertyName?[ann.bindingPropertyName,field]:field;else if(isOutput(ann))outputsFromType[field]=
ann.bindingPropertyName||field});return Object.assign(Object.assign({},facade),{typeArgumentCount:0,typeSourceSpan:facade.typeSourceSpan,type:wrapReference(facade.type),internalType:new WrappedNodeExpr(facade.type),deps:null,host:extractHostBindings(facade.propMetadata,facade.typeSourceSpan,facade.host),inputs:Object.assign(Object.assign({},inputsFromMetadata),inputsFromType),outputs:Object.assign(Object.assign({},outputsFromMetadata),outputsFromType),queries:facade.queries.map(convertToR3QueryMetadata),
providers:facade.providers!=null?new WrappedNodeExpr(facade.providers):null,viewQueries:facade.viewQueries.map(convertToR3QueryMetadata),fullInheritance:false})}function convertDeclareDirectiveFacadeToMetadata(declaration,typeSourceSpan){var _a,_b,_c,_d,_e,_f,_g,_h;return{name:declaration.type.name,type:wrapReference(declaration.type),typeSourceSpan,internalType:new WrappedNodeExpr(declaration.type),selector:(_a=declaration.selector)!==null&&_a!==void 0?_a:null,inputs:(_b=declaration.inputs)!==null&&
_b!==void 0?_b:{},outputs:(_c=declaration.outputs)!==null&&_c!==void 0?_c:{},host:convertHostDeclarationToMetadata(declaration.host),queries:((_d=declaration.queries)!==null&&_d!==void 0?_d:[]).map(convertQueryDeclarationToMetadata),viewQueries:((_e=declaration.viewQueries)!==null&&_e!==void 0?_e:[]).map(convertQueryDeclarationToMetadata),providers:declaration.providers!==undefined?new WrappedNodeExpr(declaration.providers):null,exportAs:(_f=declaration.exportAs)!==null&&_f!==void 0?_f:null,usesInheritance:(_g=
declaration.usesInheritance)!==null&&_g!==void 0?_g:false,lifecycle:{usesOnChanges:(_h=declaration.usesOnChanges)!==null&&_h!==void 0?_h:false},deps:null,typeArgumentCount:0,fullInheritance:false}}function convertHostDeclarationToMetadata(host={}){var _a,_b,_c;return{attributes:convertOpaqueValuesToExpressions((_a=host.attributes)!==null&&_a!==void 0?_a:{}),listeners:(_b=host.listeners)!==null&&_b!==void 0?_b:{},properties:(_c=host.properties)!==null&&_c!==void 0?_c:{},specialAttributes:{classAttr:host.classAttribute,
styleAttr:host.styleAttribute}}}function convertOpaqueValuesToExpressions(obj){const result={};for(const key of Object.keys(obj))result[key]=new WrappedNodeExpr(obj[key]);return result}function convertDeclareComponentFacadeToMetadata(declaration,typeSourceSpan,sourceMapUrl){var _a,_b,_c,_d,_e,_f;const {template,interpolation}=parseJitTemplate(declaration.template,declaration.type.name,sourceMapUrl,(_a=declaration.preserveWhitespaces)!==null&&_a!==void 0?_a:false,declaration.interpolation);return Object.assign(Object.assign({},
convertDeclareDirectiveFacadeToMetadata(declaration,typeSourceSpan)),{template,styles:(_b=declaration.styles)!==null&&_b!==void 0?_b:[],directives:((_c=declaration.components)!==null&&_c!==void 0?_c:[]).concat((_d=declaration.directives)!==null&&_d!==void 0?_d:[]).map(convertUsedDirectiveDeclarationToMetadata),pipes:convertUsedPipesToMetadata(declaration.pipes),viewProviders:declaration.viewProviders!==undefined?new WrappedNodeExpr(declaration.viewProviders):null,animations:declaration.animations!==
undefined?new WrappedNodeExpr(declaration.animations):null,changeDetection:(_e=declaration.changeDetection)!==null&&_e!==void 0?_e:exports.ChangeDetectionStrategy.Default,encapsulation:(_f=declaration.encapsulation)!==null&&_f!==void 0?_f:exports.ViewEncapsulation.Emulated,interpolation,declarationListEmitMode:2,relativeContextFilePath:"",i18nUseExternalIds:true})}function convertUsedDirectiveDeclarationToMetadata(declaration){var _a,_b,_c;return{selector:declaration.selector,type:new WrappedNodeExpr(declaration.type),
inputs:(_a=declaration.inputs)!==null&&_a!==void 0?_a:[],outputs:(_b=declaration.outputs)!==null&&_b!==void 0?_b:[],exportAs:(_c=declaration.exportAs)!==null&&_c!==void 0?_c:null}}function convertUsedPipesToMetadata(declaredPipes){const pipes=new Map;if(declaredPipes===undefined)return pipes;for(const pipeName of Object.keys(declaredPipes)){const pipeType=declaredPipes[pipeName];pipes.set(pipeName,new WrappedNodeExpr(pipeType))}return pipes}function parseJitTemplate(template,typeName,sourceMapUrl,
preserveWhitespaces,interpolation){const interpolationConfig=interpolation?InterpolationConfig.fromArray(interpolation):DEFAULT_INTERPOLATION_CONFIG;const parsed=parseTemplate(template,sourceMapUrl,{preserveWhitespaces,interpolationConfig});if(parsed.errors!==null){const errors=parsed.errors.map(err=>err.toString()).join(", ");throw new Error(`Errors during JIT compilation of template for ${typeName}: ${errors}`);}return{template:parsed,interpolation:interpolationConfig}}function convertToProviderExpression(obj,
property){if(obj.hasOwnProperty(property))return createMayBeForwardRefExpression(new WrappedNodeExpr(obj[property]),0);else return undefined}function wrapExpression(obj,property){if(obj.hasOwnProperty(property))return new WrappedNodeExpr(obj[property]);else return undefined}function computeProvidedIn(providedIn){const expression=typeof providedIn==="function"?new WrappedNodeExpr(providedIn):new LiteralExpr(providedIn!==null&&providedIn!==void 0?providedIn:null);return createMayBeForwardRefExpression(expression,
0)}function convertR3DependencyMetadataArray(facades){return facades==null?null:facades.map(convertR3DependencyMetadata)}function convertR3DependencyMetadata(facade){const isAttributeDep=facade.attribute!=null;const rawToken=facade.token===null?null:new WrappedNodeExpr(facade.token);const token=isAttributeDep?new WrappedNodeExpr(facade.attribute):rawToken;return createR3DependencyMetadata(token,isAttributeDep,facade.host,facade.optional,facade.self,facade.skipSelf)}function convertR3DeclareDependencyMetadata(facade){var _a,
_b,_c,_d,_e;const isAttributeDep=(_a=facade.attribute)!==null&&_a!==void 0?_a:false;const token=facade.token===null?null:new WrappedNodeExpr(facade.token);return createR3DependencyMetadata(token,isAttributeDep,(_b=facade.host)!==null&&_b!==void 0?_b:false,(_c=facade.optional)!==null&&_c!==void 0?_c:false,(_d=facade.self)!==null&&_d!==void 0?_d:false,(_e=facade.skipSelf)!==null&&_e!==void 0?_e:false)}function createR3DependencyMetadata(token,isAttributeDep,host,optional,self,skipSelf){const attributeNameType=
isAttributeDep?literal("unknown"):null;return{token,attributeNameType,host,optional,self,skipSelf}}function extractHostBindings(propMetadata,sourceSpan,host){const bindings=parseHostBindings(host||{});const errors=verifyHostBindings(bindings,sourceSpan);if(errors.length)throw new Error(errors.map(error=>error.msg).join("\n"));for(const field in propMetadata)if(propMetadata.hasOwnProperty(field))propMetadata[field].forEach(ann=>{if(isHostBinding(ann))bindings.properties[ann.hostPropertyName||field]=
getSafePropertyAccessString("this",field);else if(isHostListener(ann))bindings.listeners[ann.eventName||field]=`${field}(${(ann.args||[]).join(",")})`});return bindings}function isHostBinding(value){return value.ngMetadataName==="HostBinding"}function isHostListener(value){return value.ngMetadataName==="HostListener"}function isInput(value){return value.ngMetadataName==="Input"}function isOutput(value){return value.ngMetadataName==="Output"}function parseInputOutputs(values){return values.reduce((map,
value)=>{const [field,property]=value.split(",").map(piece=>piece.trim());map[field]=property||field;return map},{})}function convertDeclarePipeFacadeToMetadata(declaration){var _a;return{name:declaration.type.name,type:wrapReference(declaration.type),internalType:new WrappedNodeExpr(declaration.type),typeArgumentCount:0,pipeName:declaration.name,deps:null,pure:(_a=declaration.pure)!==null&&_a!==void 0?_a:true}}function convertDeclareInjectorFacadeToMetadata(declaration){return{name:declaration.type.name,
type:wrapReference(declaration.type),internalType:new WrappedNodeExpr(declaration.type),providers:declaration.providers!==undefined?new WrappedNodeExpr(declaration.providers):null,imports:declaration.imports!==undefined?declaration.imports.map(i=>new WrappedNodeExpr(i)):[]}}function publishFacade(global){const ng=global.ng||(global.ng={});ng.\u0275compilerFacade=new CompilerFacadeImpl}const VERSION=new Version("13.1.3");class CompilerConfig{constructor({defaultEncapsulation=exports.ViewEncapsulation.Emulated,
useJit=true,jitDevMode=false,missingTranslation=null,preserveWhitespaces,strictInjectionParameters}={}){this.defaultEncapsulation=defaultEncapsulation;this.useJit=!!useJit;this.jitDevMode=!!jitDevMode;this.missingTranslation=missingTranslation;this.preserveWhitespaces=preserveWhitespacesDefault(noUndefined(preserveWhitespaces));this.strictInjectionParameters=strictInjectionParameters===true}}function preserveWhitespacesDefault(preserveWhitespacesOption,defaultSetting=false){return preserveWhitespacesOption===
null?defaultSetting:preserveWhitespacesOption}const _I18N_ATTR="i18n";const _I18N_ATTR_PREFIX="i18n-";const _I18N_COMMENT_PREFIX_REGEXP=/^i18n:?/;const MEANING_SEPARATOR="|";const ID_SEPARATOR="@@";let i18nCommentsWarned=false;function extractMessages(nodes,interpolationConfig,implicitTags,implicitAttrs){const visitor=new _Visitor(implicitTags,implicitAttrs);return visitor.extract(nodes,interpolationConfig)}function mergeTranslations(nodes,translations,interpolationConfig,implicitTags,implicitAttrs){const visitor=
new _Visitor(implicitTags,implicitAttrs);return visitor.merge(nodes,translations,interpolationConfig)}class ExtractionResult{constructor(messages,errors){this.messages=messages;this.errors=errors}}var _VisitorMode;(function(_VisitorMode){_VisitorMode[_VisitorMode["Extract"]=0]="Extract";_VisitorMode[_VisitorMode["Merge"]=1]="Merge"})(_VisitorMode||(_VisitorMode={}));class _Visitor{constructor(_implicitTags,_implicitAttrs){this._implicitTags=_implicitTags;this._implicitAttrs=_implicitAttrs}extract(nodes,
interpolationConfig){this._init(_VisitorMode.Extract,interpolationConfig);nodes.forEach(node=>node.visit(this,null));if(this._inI18nBlock)this._reportError(nodes[nodes.length-1],"Unclosed block");return new ExtractionResult(this._messages,this._errors)}merge(nodes,translations,interpolationConfig){this._init(_VisitorMode.Merge,interpolationConfig);this._translations=translations;const wrapper=new Element("wrapper",[],nodes,undefined,undefined,undefined);const translatedNode=wrapper.visit(this,null);
if(this._inI18nBlock)this._reportError(nodes[nodes.length-1],"Unclosed block");return new ParseTreeResult(translatedNode.children,this._errors)}visitExpansionCase(icuCase,context){const expression=visitAll(this,icuCase.expression,context);if(this._mode===_VisitorMode.Merge)return new ExpansionCase(icuCase.value,expression,icuCase.sourceSpan,icuCase.valueSourceSpan,icuCase.expSourceSpan)}visitExpansion(icu,context){this._mayBeAddBlockChildren(icu);const wasInIcu=this._inIcu;if(!this._inIcu){if(this._isInTranslatableSection)this._addMessage([icu]);
this._inIcu=true}const cases=visitAll(this,icu.cases,context);if(this._mode===_VisitorMode.Merge)icu=new Expansion(icu.switchValue,icu.type,cases,icu.sourceSpan,icu.switchValueSourceSpan);this._inIcu=wasInIcu;return icu}visitComment(comment,context){const isOpening=_isOpeningComment(comment);if(isOpening&&this._isInTranslatableSection){this._reportError(comment,"Could not start a block inside a translatable section");return}const isClosing=_isClosingComment(comment);if(isClosing&&!this._inI18nBlock){this._reportError(comment,
"Trying to close an unopened block");return}if(!this._inI18nNode&&!this._inIcu)if(!this._inI18nBlock){if(isOpening){if(!i18nCommentsWarned&&console&&console.warn){i18nCommentsWarned=true;const details=comment.sourceSpan.details?`, ${comment.sourceSpan.details}`:"";console.warn(`I18n comments are deprecated, use an <ng-container> element instead (${comment.sourceSpan.start}${details})`)}this._inI18nBlock=true;this._blockStartDepth=this._depth;this._blockChildren=[];this._blockMeaningAndDesc=comment.value.replace(_I18N_COMMENT_PREFIX_REGEXP,
"").trim();this._openTranslatableSection(comment)}}else if(isClosing)if(this._depth==this._blockStartDepth){this._closeTranslatableSection(comment,this._blockChildren);this._inI18nBlock=false;const message=this._addMessage(this._blockChildren,this._blockMeaningAndDesc);const nodes=this._translateMessage(comment,message);return visitAll(this,nodes)}else{this._reportError(comment,"I18N blocks should not cross element boundaries");return}}visitText(text,context){if(this._isInTranslatableSection)this._mayBeAddBlockChildren(text);
return text}visitElement(el,context){this._mayBeAddBlockChildren(el);this._depth++;const wasInI18nNode=this._inI18nNode;const wasInImplicitNode=this._inImplicitNode;let childNodes=[];let translatedChildNodes=undefined;const i18nAttr=_getI18nAttr(el);const i18nMeta=i18nAttr?i18nAttr.value:"";const isImplicit=this._implicitTags.some(tag=>el.name===tag)&&!this._inIcu&&!this._isInTranslatableSection;const isTopLevelImplicit=!wasInImplicitNode&&isImplicit;this._inImplicitNode=wasInImplicitNode||isImplicit;
if(!this._isInTranslatableSection&&!this._inIcu){if(i18nAttr||isTopLevelImplicit){this._inI18nNode=true;const message=this._addMessage(el.children,i18nMeta);translatedChildNodes=this._translateMessage(el,message)}if(this._mode==_VisitorMode.Extract){const isTranslatable=i18nAttr||isTopLevelImplicit;if(isTranslatable)this._openTranslatableSection(el);visitAll(this,el.children);if(isTranslatable)this._closeTranslatableSection(el,el.children)}}else{if(i18nAttr||isTopLevelImplicit)this._reportError(el,
"Could not mark an element as translatable inside a translatable section");if(this._mode==_VisitorMode.Extract)visitAll(this,el.children)}if(this._mode===_VisitorMode.Merge){const visitNodes=translatedChildNodes||el.children;visitNodes.forEach(child=>{const visited=child.visit(this,context);if(visited&&!this._isInTranslatableSection)childNodes=childNodes.concat(visited)})}this._visitAttributesOf(el);this._depth--;this._inI18nNode=wasInI18nNode;this._inImplicitNode=wasInImplicitNode;if(this._mode===
_VisitorMode.Merge){const translatedAttrs=this._translateAttributes(el);return new Element(el.name,translatedAttrs,childNodes,el.sourceSpan,el.startSourceSpan,el.endSourceSpan)}return null}visitAttribute(attribute,context){throw new Error("unreachable code");}_init(mode,interpolationConfig){this._mode=mode;this._inI18nBlock=false;this._inI18nNode=false;this._depth=0;this._inIcu=false;this._msgCountAtSectionStart=undefined;this._errors=[];this._messages=[];this._inImplicitNode=false;this._createI18nMessage=
createI18nMessageFactory(interpolationConfig)}_visitAttributesOf(el){const explicitAttrNameToValue={};const implicitAttrNames=this._implicitAttrs[el.name]||[];el.attrs.filter(attr=>attr.name.startsWith(_I18N_ATTR_PREFIX)).forEach(attr=>explicitAttrNameToValue[attr.name.slice(_I18N_ATTR_PREFIX.length)]=attr.value);el.attrs.forEach(attr=>{if(attr.name in explicitAttrNameToValue)this._addMessage([attr],explicitAttrNameToValue[attr.name]);else if(implicitAttrNames.some(name=>attr.name===name))this._addMessage([attr])})}_addMessage(ast,
msgMeta){if(ast.length==0||ast.length==1&&ast[0]instanceof Attribute&&!ast[0].value)return null;const {meaning,description,id}=_parseMessageMeta(msgMeta);const message=this._createI18nMessage(ast,meaning,description,id);this._messages.push(message);return message}_translateMessage(el,message){if(message&&this._mode===_VisitorMode.Merge){const nodes=this._translations.get(message);if(nodes)return nodes;this._reportError(el,`Translation unavailable for message id="${this._translations.digest(message)}"`)}return[]}_translateAttributes(el){const attributes=
el.attrs;const i18nParsedMessageMeta={};attributes.forEach(attr=>{if(attr.name.startsWith(_I18N_ATTR_PREFIX))i18nParsedMessageMeta[attr.name.slice(_I18N_ATTR_PREFIX.length)]=_parseMessageMeta(attr.value)});const translatedAttributes=[];attributes.forEach(attr=>{if(attr.name===_I18N_ATTR||attr.name.startsWith(_I18N_ATTR_PREFIX))return;if(attr.value&&attr.value!=""&&i18nParsedMessageMeta.hasOwnProperty(attr.name)){const {meaning,description,id}=i18nParsedMessageMeta[attr.name];const message=this._createI18nMessage([attr],
meaning,description,id);const nodes=this._translations.get(message);if(nodes)if(nodes.length==0)translatedAttributes.push(new Attribute(attr.name,"",attr.sourceSpan,undefined,undefined,undefined,undefined));else if(nodes[0]instanceof Text){const value=nodes[0].value;translatedAttributes.push(new Attribute(attr.name,value,attr.sourceSpan,undefined,undefined,undefined,undefined))}else this._reportError(el,`Unexpected translation for attribute "${attr.name}" (id="${id||this._translations.digest(message)}")`);
else this._reportError(el,`Translation unavailable for attribute "${attr.name}" (id="${id||this._translations.digest(message)}")`)}else translatedAttributes.push(attr)});return translatedAttributes}_mayBeAddBlockChildren(node){if(this._inI18nBlock&&!this._inIcu&&this._depth==this._blockStartDepth)this._blockChildren.push(node)}_openTranslatableSection(node){if(this._isInTranslatableSection)this._reportError(node,"Unexpected section start");else this._msgCountAtSectionStart=this._messages.length}get _isInTranslatableSection(){return this._msgCountAtSectionStart!==
void 0}_closeTranslatableSection(node,directChildren){if(!this._isInTranslatableSection){this._reportError(node,"Unexpected section end");return}const startIndex=this._msgCountAtSectionStart;const significantChildren=directChildren.reduce((count,node)=>count+(node instanceof Comment?0:1),0);if(significantChildren==1)for(let i=this._messages.length-1;i>=startIndex;i--){const ast=this._messages[i].nodes;if(!(ast.length==1&&ast[0]instanceof Text$2)){this._messages.splice(i,1);break}}this._msgCountAtSectionStart=
undefined}_reportError(node,msg){this._errors.push(new I18nError(node.sourceSpan,msg))}}function _isOpeningComment(n){return!!(n instanceof Comment&&n.value&&n.value.startsWith("i18n"))}function _isClosingComment(n){return!!(n instanceof Comment&&n.value&&n.value==="/i18n")}function _getI18nAttr(p){return p.attrs.find(attr=>attr.name===_I18N_ATTR)||null}function _parseMessageMeta(i18n){if(!i18n)return{meaning:"",description:"",id:""};const idIndex=i18n.indexOf(ID_SEPARATOR);const descIndex=i18n.indexOf(MEANING_SEPARATOR);
const [meaningAndDesc,id]=idIndex>-1?[i18n.slice(0,idIndex),i18n.slice(idIndex+2)]:[i18n,""];const [meaning,description]=descIndex>-1?[meaningAndDesc.slice(0,descIndex),meaningAndDesc.slice(descIndex+1)]:["",meaningAndDesc];return{meaning,description,id:id.trim()}}class XmlTagDefinition{constructor(){this.closedByParent=false;this.isVoid=false;this.ignoreFirstLf=false;this.canSelfClose=true;this.preventNamespaceInheritance=false}requireExtraParent(currentParent){return false}isClosedByChild(name){return false}getContentType(){return exports.TagContentType.PARSABLE_DATA}}
const _TAG_DEFINITION=new XmlTagDefinition;function getXmlTagDefinition(tagName){return _TAG_DEFINITION}class XmlParser extends Parser{constructor(){super(getXmlTagDefinition)}parse(source,url,options){return super.parse(source,url,options)}}const _VERSION$1="1.2";const _XMLNS$1="urn:oasis:names:tc:xliff:document:1.2";const _DEFAULT_SOURCE_LANG$1="en";const _PLACEHOLDER_TAG$2="x";const _MARKER_TAG$1="mrk";const _FILE_TAG="file";const _SOURCE_TAG$1="source";const _SEGMENT_SOURCE_TAG="seg-source";const _ALT_TRANS_TAG=
"alt-trans";const _TARGET_TAG$1="target";const _UNIT_TAG$1="trans-unit";const _CONTEXT_GROUP_TAG="context-group";const _CONTEXT_TAG="context";class Xliff extends Serializer{write(messages,locale){const visitor=new _WriteVisitor$1;const transUnits=[];messages.forEach(message=>{let contextTags=[];message.sources.forEach(source=>{let contextGroupTag=new Tag(_CONTEXT_GROUP_TAG,{purpose:"location"});contextGroupTag.children.push(new CR(10),new Tag(_CONTEXT_TAG,{"context-type":"sourcefile"},[new Text$1(source.filePath)]),
new CR(10),new Tag(_CONTEXT_TAG,{"context-type":"linenumber"},[new Text$1(`${source.startLine}`)]),new CR(8));contextTags.push(new CR(8),contextGroupTag)});const transUnit=new Tag(_UNIT_TAG$1,{id:message.id,datatype:"html"});transUnit.children.push(new CR(8),new Tag(_SOURCE_TAG$1,{},visitor.serialize(message.nodes)),...contextTags);if(message.description)transUnit.children.push(new CR(8),new Tag("note",{priority:"1",from:"description"},[new Text$1(message.description)]));if(message.meaning)transUnit.children.push(new CR(8),
new Tag("note",{priority:"1",from:"meaning"},[new Text$1(message.meaning)]));transUnit.children.push(new CR(6));transUnits.push(new CR(6),transUnit)});const body=new Tag("body",{},[...transUnits,new CR(4)]);const file=new Tag("file",{"source-language":locale||_DEFAULT_SOURCE_LANG$1,datatype:"plaintext",original:"ng2.template"},[new CR(4),body,new CR(2)]);const xliff=new Tag("xliff",{version:_VERSION$1,xmlns:_XMLNS$1},[new CR(2),file,new CR]);return serialize([new Declaration({version:"1.0",encoding:"UTF-8"}),
new CR,xliff,new CR])}load(content,url){const xliffParser=new XliffParser;const {locale,msgIdToHtml,errors}=xliffParser.parse(content,url);const i18nNodesByMsgId={};const converter=new XmlToI18n$2;Object.keys(msgIdToHtml).forEach(msgId=>{const {i18nNodes,errors:e}=converter.convert(msgIdToHtml[msgId],url);errors.push(...e);i18nNodesByMsgId[msgId]=i18nNodes});if(errors.length)throw new Error(`xliff parse errors:\n${errors.join("\n")}`);return{locale:locale,i18nNodesByMsgId}}digest(message){return digest$1(message)}}
class _WriteVisitor$1{visitText(text,context){return[new Text$1(text.value)]}visitContainer(container,context){const nodes=[];container.children.forEach(node=>nodes.push(...node.visit(this)));return nodes}visitIcu(icu,context){const nodes=[new Text$1(`{${icu.expressionPlaceholder}, ${icu.type}, `)];Object.keys(icu.cases).forEach(c=>{nodes.push(new Text$1(`${c} {`),...icu.cases[c].visit(this),new Text$1(`} `))});nodes.push(new Text$1(`}`));return nodes}visitTagPlaceholder(ph,context){const ctype=getCtypeForTag(ph.tag);
if(ph.isVoid)return[new Tag(_PLACEHOLDER_TAG$2,{id:ph.startName,ctype,"equiv-text":`<${ph.tag}/>`})];const startTagPh=new Tag(_PLACEHOLDER_TAG$2,{id:ph.startName,ctype,"equiv-text":`<${ph.tag}>`});const closeTagPh=new Tag(_PLACEHOLDER_TAG$2,{id:ph.closeName,ctype,"equiv-text":`</${ph.tag}>`});return[startTagPh,...this.serialize(ph.children),closeTagPh]}visitPlaceholder(ph,context){return[new Tag(_PLACEHOLDER_TAG$2,{id:ph.name,"equiv-text":`{{${ph.value}}}`})]}visitIcuPlaceholder(ph,context){const equivText=
`{${ph.value.expression}, ${ph.value.type}, ${Object.keys(ph.value.cases).map(value=>value+" {...}").join(" ")}}`;return[new Tag(_PLACEHOLDER_TAG$2,{id:ph.name,"equiv-text":equivText})]}serialize(nodes){return[].concat(...nodes.map(node=>node.visit(this)))}}class XliffParser{constructor(){this._locale=null}parse(xliff,url){this._unitMlString=null;this._msgIdToHtml={};const xml=(new XmlParser).parse(xliff,url);this._errors=xml.errors;visitAll(this,xml.rootNodes,null);return{msgIdToHtml:this._msgIdToHtml,
errors:this._errors,locale:this._locale}}visitElement(element,context){switch(element.name){case _UNIT_TAG$1:this._unitMlString=null;const idAttr=element.attrs.find(attr=>attr.name==="id");if(!idAttr)this._addError(element,`<${_UNIT_TAG$1}> misses the "id" attribute`);else{const id=idAttr.value;if(this._msgIdToHtml.hasOwnProperty(id))this._addError(element,`Duplicated translations for msg ${id}`);else{visitAll(this,element.children,null);if(typeof this._unitMlString==="string")this._msgIdToHtml[id]=
this._unitMlString;else this._addError(element,`Message ${id} misses a translation`)}}break;case _SOURCE_TAG$1:case _SEGMENT_SOURCE_TAG:case _ALT_TRANS_TAG:break;case _TARGET_TAG$1:const innerTextStart=element.startSourceSpan.end.offset;const innerTextEnd=element.endSourceSpan.start.offset;const content=element.startSourceSpan.start.file.content;const innerText=content.slice(innerTextStart,innerTextEnd);this._unitMlString=innerText;break;case _FILE_TAG:const localeAttr=element.attrs.find(attr=>attr.name===
"target-language");if(localeAttr)this._locale=localeAttr.value;visitAll(this,element.children,null);break;default:visitAll(this,element.children,null)}}visitAttribute(attribute,context){}visitText(text,context){}visitComment(comment,context){}visitExpansion(expansion,context){}visitExpansionCase(expansionCase,context){}_addError(node,message){this._errors.push(new I18nError(node.sourceSpan,message))}}class XmlToI18n$2{convert(message,url){const xmlIcu=(new XmlParser).parse(message,url,{tokenizeExpansionForms:true});
this._errors=xmlIcu.errors;const i18nNodes=this._errors.length>0||xmlIcu.rootNodes.length==0?[]:[].concat(...visitAll(this,xmlIcu.rootNodes));return{i18nNodes:i18nNodes,errors:this._errors}}visitText(text,context){return new Text$2(text.value,text.sourceSpan)}visitElement(el,context){if(el.name===_PLACEHOLDER_TAG$2){const nameAttr=el.attrs.find(attr=>attr.name==="id");if(nameAttr)return new Placeholder("",nameAttr.value,el.sourceSpan);this._addError(el,`<${_PLACEHOLDER_TAG$2}> misses the "id" attribute`);
return null}if(el.name===_MARKER_TAG$1)return[].concat(...visitAll(this,el.children));this._addError(el,`Unexpected tag`);return null}visitExpansion(icu,context){const caseMap={};visitAll(this,icu.cases).forEach(c=>{caseMap[c.value]=new Container(c.nodes,icu.sourceSpan)});return new Icu(icu.switchValue,icu.type,caseMap,icu.sourceSpan)}visitExpansionCase(icuCase,context){return{value:icuCase.value,nodes:visitAll(this,icuCase.expression)}}visitComment(comment,context){}visitAttribute(attribute,context){}_addError(node,
message){this._errors.push(new I18nError(node.sourceSpan,message))}}function getCtypeForTag(tag){switch(tag.toLowerCase()){case "br":return"lb";case "img":return"image";default:return`x-${tag}`}}const _VERSION="2.0";const _XMLNS="urn:oasis:names:tc:xliff:document:2.0";const _DEFAULT_SOURCE_LANG="en";const _PLACEHOLDER_TAG$1="ph";const _PLACEHOLDER_SPANNING_TAG="pc";const _MARKER_TAG="mrk";const _XLIFF_TAG="xliff";const _SOURCE_TAG="source";const _TARGET_TAG="target";const _UNIT_TAG="unit";class Xliff2 extends Serializer{write(messages,
locale){const visitor=new _WriteVisitor;const units=[];messages.forEach(message=>{const unit=new Tag(_UNIT_TAG,{id:message.id});const notes=new Tag("notes");if(message.description||message.meaning){if(message.description)notes.children.push(new CR(8),new Tag("note",{category:"description"},[new Text$1(message.description)]));if(message.meaning)notes.children.push(new CR(8),new Tag("note",{category:"meaning"},[new Text$1(message.meaning)]))}message.sources.forEach(source=>{notes.children.push(new CR(8),
new Tag("note",{category:"location"},[new Text$1(`${source.filePath}:${source.startLine}${source.endLine!==source.startLine?","+source.endLine:""}`)]))});notes.children.push(new CR(6));unit.children.push(new CR(6),notes);const segment=new Tag("segment");segment.children.push(new CR(8),new Tag(_SOURCE_TAG,{},visitor.serialize(message.nodes)),new CR(6));unit.children.push(new CR(6),segment,new CR(4));units.push(new CR(4),unit)});const file=new Tag("file",{"original":"ng.template",id:"ngi18n"},[...units,
new CR(2)]);const xliff=new Tag(_XLIFF_TAG,{version:_VERSION,xmlns:_XMLNS,srcLang:locale||_DEFAULT_SOURCE_LANG},[new CR(2),file,new CR]);return serialize([new Declaration({version:"1.0",encoding:"UTF-8"}),new CR,xliff,new CR])}load(content,url){const xliff2Parser=new Xliff2Parser;const {locale,msgIdToHtml,errors}=xliff2Parser.parse(content,url);const i18nNodesByMsgId={};const converter=new XmlToI18n$1;Object.keys(msgIdToHtml).forEach(msgId=>{const {i18nNodes,errors:e}=converter.convert(msgIdToHtml[msgId],
url);errors.push(...e);i18nNodesByMsgId[msgId]=i18nNodes});if(errors.length)throw new Error(`xliff2 parse errors:\n${errors.join("\n")}`);return{locale:locale,i18nNodesByMsgId}}digest(message){return decimalDigest(message)}}class _WriteVisitor{visitText(text,context){return[new Text$1(text.value)]}visitContainer(container,context){const nodes=[];container.children.forEach(node=>nodes.push(...node.visit(this)));return nodes}visitIcu(icu,context){const nodes=[new Text$1(`{${icu.expressionPlaceholder}, ${icu.type}, `)];
Object.keys(icu.cases).forEach(c=>{nodes.push(new Text$1(`${c} {`),...icu.cases[c].visit(this),new Text$1(`} `))});nodes.push(new Text$1(`}`));return nodes}visitTagPlaceholder(ph,context){const type=getTypeForTag(ph.tag);if(ph.isVoid){const tagPh=new Tag(_PLACEHOLDER_TAG$1,{id:(this._nextPlaceholderId++).toString(),equiv:ph.startName,type:type,disp:`<${ph.tag}/>`});return[tagPh]}const tagPc=new Tag(_PLACEHOLDER_SPANNING_TAG,{id:(this._nextPlaceholderId++).toString(),equivStart:ph.startName,equivEnd:ph.closeName,
type:type,dispStart:`<${ph.tag}>`,dispEnd:`</${ph.tag}>`});const nodes=[].concat(...ph.children.map(node=>node.visit(this)));if(nodes.length)nodes.forEach(node=>tagPc.children.push(node));else tagPc.children.push(new Text$1(""));return[tagPc]}visitPlaceholder(ph,context){const idStr=(this._nextPlaceholderId++).toString();return[new Tag(_PLACEHOLDER_TAG$1,{id:idStr,equiv:ph.name,disp:`{{${ph.value}}}`})]}visitIcuPlaceholder(ph,context){const cases=Object.keys(ph.value.cases).map(value=>value+" {...}").join(" ");
const idStr=(this._nextPlaceholderId++).toString();return[new Tag(_PLACEHOLDER_TAG$1,{id:idStr,equiv:ph.name,disp:`{${ph.value.expression}, ${ph.value.type}, ${cases}}`})]}serialize(nodes){this._nextPlaceholderId=0;return[].concat(...nodes.map(node=>node.visit(this)))}}class Xliff2Parser{constructor(){this._locale=null}parse(xliff,url){this._unitMlString=null;this._msgIdToHtml={};const xml=(new XmlParser).parse(xliff,url);this._errors=xml.errors;visitAll(this,xml.rootNodes,null);return{msgIdToHtml:this._msgIdToHtml,
errors:this._errors,locale:this._locale}}visitElement(element,context){switch(element.name){case _UNIT_TAG:this._unitMlString=null;const idAttr=element.attrs.find(attr=>attr.name==="id");if(!idAttr)this._addError(element,`<${_UNIT_TAG}> misses the "id" attribute`);else{const id=idAttr.value;if(this._msgIdToHtml.hasOwnProperty(id))this._addError(element,`Duplicated translations for msg ${id}`);else{visitAll(this,element.children,null);if(typeof this._unitMlString==="string")this._msgIdToHtml[id]=this._unitMlString;
else this._addError(element,`Message ${id} misses a translation`)}}break;case _SOURCE_TAG:break;case _TARGET_TAG:const innerTextStart=element.startSourceSpan.end.offset;const innerTextEnd=element.endSourceSpan.start.offset;const content=element.startSourceSpan.start.file.content;const innerText=content.slice(innerTextStart,innerTextEnd);this._unitMlString=innerText;break;case _XLIFF_TAG:const localeAttr=element.attrs.find(attr=>attr.name==="trgLang");if(localeAttr)this._locale=localeAttr.value;const versionAttr=
element.attrs.find(attr=>attr.name==="version");if(versionAttr){const version=versionAttr.value;if(version!=="2.0")this._addError(element,`The XLIFF file version ${version} is not compatible with XLIFF 2.0 serializer`);else visitAll(this,element.children,null)}break;default:visitAll(this,element.children,null)}}visitAttribute(attribute,context){}visitText(text,context){}visitComment(comment,context){}visitExpansion(expansion,context){}visitExpansionCase(expansionCase,context){}_addError(node,message){this._errors.push(new I18nError(node.sourceSpan,
message))}}class XmlToI18n$1{convert(message,url){const xmlIcu=(new XmlParser).parse(message,url,{tokenizeExpansionForms:true});this._errors=xmlIcu.errors;const i18nNodes=this._errors.length>0||xmlIcu.rootNodes.length==0?[]:[].concat(...visitAll(this,xmlIcu.rootNodes));return{i18nNodes,errors:this._errors}}visitText(text,context){return new Text$2(text.value,text.sourceSpan)}visitElement(el,context){switch(el.name){case _PLACEHOLDER_TAG$1:const nameAttr=el.attrs.find(attr=>attr.name==="equiv");if(nameAttr)return[new Placeholder("",
nameAttr.value,el.sourceSpan)];this._addError(el,`<${_PLACEHOLDER_TAG$1}> misses the "equiv" attribute`);break;case _PLACEHOLDER_SPANNING_TAG:const startAttr=el.attrs.find(attr=>attr.name==="equivStart");const endAttr=el.attrs.find(attr=>attr.name==="equivEnd");if(!startAttr)this._addError(el,`<${_PLACEHOLDER_TAG$1}> misses the "equivStart" attribute`);else if(!endAttr)this._addError(el,`<${_PLACEHOLDER_TAG$1}> misses the "equivEnd" attribute`);else{const startId=startAttr.value;const endId=endAttr.value;
const nodes=[];return nodes.concat(new Placeholder("",startId,el.sourceSpan),...el.children.map(node=>node.visit(this,null)),new Placeholder("",endId,el.sourceSpan))}break;case _MARKER_TAG:return[].concat(...visitAll(this,el.children));default:this._addError(el,`Unexpected tag`)}return null}visitExpansion(icu,context){const caseMap={};visitAll(this,icu.cases).forEach(c=>{caseMap[c.value]=new Container(c.nodes,icu.sourceSpan)});return new Icu(icu.switchValue,icu.type,caseMap,icu.sourceSpan)}visitExpansionCase(icuCase,
context){return{value:icuCase.value,nodes:[].concat(...visitAll(this,icuCase.expression))}}visitComment(comment,context){}visitAttribute(attribute,context){}_addError(node,message){this._errors.push(new I18nError(node.sourceSpan,message))}}function getTypeForTag(tag){switch(tag.toLowerCase()){case "br":case "b":case "i":case "u":return"fmt";case "img":return"image";case "a":return"link";default:return"other"}}const _TRANSLATIONS_TAG="translationbundle";const _TRANSLATION_TAG="translation";const _PLACEHOLDER_TAG=
"ph";class Xtb extends Serializer{write(messages,locale){throw new Error("Unsupported");}load(content,url){const xtbParser=new XtbParser;const {locale,msgIdToHtml,errors}=xtbParser.parse(content,url);const i18nNodesByMsgId={};const converter=new XmlToI18n;Object.keys(msgIdToHtml).forEach(msgId=>{const valueFn=function(){const {i18nNodes,errors}=converter.convert(msgIdToHtml[msgId],url);if(errors.length)throw new Error(`xtb parse errors:\n${errors.join("\n")}`);return i18nNodes};createLazyProperty(i18nNodesByMsgId,
msgId,valueFn)});if(errors.length)throw new Error(`xtb parse errors:\n${errors.join("\n")}`);return{locale:locale,i18nNodesByMsgId}}digest(message){return digest(message)}createNameMapper(message){return new SimplePlaceholderMapper(message,toPublicName)}}function createLazyProperty(messages,id,valueFn){Object.defineProperty(messages,id,{configurable:true,enumerable:true,get:function(){const value=valueFn();Object.defineProperty(messages,id,{enumerable:true,value});return value},set:_=>{throw new Error("Could not overwrite an XTB translation");
}})}class XtbParser{constructor(){this._locale=null}parse(xtb,url){this._bundleDepth=0;this._msgIdToHtml={};const xml=(new XmlParser).parse(xtb,url);this._errors=xml.errors;visitAll(this,xml.rootNodes);return{msgIdToHtml:this._msgIdToHtml,errors:this._errors,locale:this._locale}}visitElement(element,context){switch(element.name){case _TRANSLATIONS_TAG:this._bundleDepth++;if(this._bundleDepth>1)this._addError(element,`<${_TRANSLATIONS_TAG}> elements can not be nested`);const langAttr=element.attrs.find(attr=>
attr.name==="lang");if(langAttr)this._locale=langAttr.value;visitAll(this,element.children,null);this._bundleDepth--;break;case _TRANSLATION_TAG:const idAttr=element.attrs.find(attr=>attr.name==="id");if(!idAttr)this._addError(element,`<${_TRANSLATION_TAG}> misses the "id" attribute`);else{const id=idAttr.value;if(this._msgIdToHtml.hasOwnProperty(id))this._addError(element,`Duplicated translations for msg ${id}`);else{const innerTextStart=element.startSourceSpan.end.offset;const innerTextEnd=element.endSourceSpan.start.offset;
const content=element.startSourceSpan.start.file.content;const innerText=content.slice(innerTextStart,innerTextEnd);this._msgIdToHtml[id]=innerText}}break;default:this._addError(element,"Unexpected tag")}}visitAttribute(attribute,context){}visitText(text,context){}visitComment(comment,context){}visitExpansion(expansion,context){}visitExpansionCase(expansionCase,context){}_addError(node,message){this._errors.push(new I18nError(node.sourceSpan,message))}}class XmlToI18n{convert(message,url){const xmlIcu=
(new XmlParser).parse(message,url,{tokenizeExpansionForms:true});this._errors=xmlIcu.errors;const i18nNodes=this._errors.length>0||xmlIcu.rootNodes.length==0?[]:visitAll(this,xmlIcu.rootNodes);return{i18nNodes,errors:this._errors}}visitText(text,context){return new Text$2(text.value,text.sourceSpan)}visitExpansion(icu,context){const caseMap={};visitAll(this,icu.cases).forEach(c=>{caseMap[c.value]=new Container(c.nodes,icu.sourceSpan)});return new Icu(icu.switchValue,icu.type,caseMap,icu.sourceSpan)}visitExpansionCase(icuCase,
context){return{value:icuCase.value,nodes:visitAll(this,icuCase.expression)}}visitElement(el,context){if(el.name===_PLACEHOLDER_TAG){const nameAttr=el.attrs.find(attr=>attr.name==="name");if(nameAttr)return new Placeholder("",nameAttr.value,el.sourceSpan);this._addError(el,`<${_PLACEHOLDER_TAG}> misses the "name" attribute`)}else this._addError(el,`Unexpected tag`);return null}visitComment(comment,context){}visitAttribute(attribute,context){}_addError(node,message){this._errors.push(new I18nError(node.sourceSpan,
message))}}class TranslationBundle{constructor(_i18nNodesByMsgId={},locale,digest,mapperFactory,missingTranslationStrategy=MissingTranslationStrategy.Warning,console){this._i18nNodesByMsgId=_i18nNodesByMsgId;this.digest=digest;this.mapperFactory=mapperFactory;this._i18nToHtml=new I18nToHtmlVisitor(_i18nNodesByMsgId,locale,digest,mapperFactory,missingTranslationStrategy,console)}static load(content,url,serializer,missingTranslationStrategy,console){const {locale,i18nNodesByMsgId}=serializer.load(content,
url);const digestFn=m=>serializer.digest(m);const mapperFactory=m=>serializer.createNameMapper(m);return new TranslationBundle(i18nNodesByMsgId,locale,digestFn,mapperFactory,missingTranslationStrategy,console)}get(srcMsg){const html=this._i18nToHtml.convert(srcMsg);if(html.errors.length)throw new Error(html.errors.join("\n"));return html.nodes}has(srcMsg){return this.digest(srcMsg)in this._i18nNodesByMsgId}}class I18nToHtmlVisitor{constructor(_i18nNodesByMsgId={},_locale,_digest,_mapperFactory,_missingTranslationStrategy,
_console){this._i18nNodesByMsgId=_i18nNodesByMsgId;this._locale=_locale;this._digest=_digest;this._mapperFactory=_mapperFactory;this._missingTranslationStrategy=_missingTranslationStrategy;this._console=_console;this._contextStack=[];this._errors=[]}convert(srcMsg){this._contextStack.length=0;this._errors.length=0;const text=this._convertToText(srcMsg);const url=srcMsg.nodes[0].sourceSpan.start.file.url;const html=(new HtmlParser).parse(text,url,{tokenizeExpansionForms:true});return{nodes:html.rootNodes,
errors:[...this._errors,...html.errors]}}visitText(text,context){return escapeXml(text.value)}visitContainer(container,context){return container.children.map(n=>n.visit(this)).join("")}visitIcu(icu,context){const cases=Object.keys(icu.cases).map(k=>`${k} {${icu.cases[k].visit(this)}}`);const exp=this._srcMsg.placeholders.hasOwnProperty(icu.expression)?this._srcMsg.placeholders[icu.expression].text:icu.expression;return`{${exp}, ${icu.type}, ${cases.join(" ")}}`}visitPlaceholder(ph,context){const phName=
this._mapper(ph.name);if(this._srcMsg.placeholders.hasOwnProperty(phName))return this._srcMsg.placeholders[phName].text;if(this._srcMsg.placeholderToMessage.hasOwnProperty(phName))return this._convertToText(this._srcMsg.placeholderToMessage[phName]);this._addError(ph,`Unknown placeholder "${ph.name}"`);return""}visitTagPlaceholder(ph,context){const tag=`${ph.tag}`;const attrs=Object.keys(ph.attrs).map(name=>`${name}="${ph.attrs[name]}"`).join(" ");if(ph.isVoid)return`<${tag} ${attrs}/>`;const children=
ph.children.map(c=>c.visit(this)).join("");return`<${tag} ${attrs}>${children}</${tag}>`}visitIcuPlaceholder(ph,context){return this._convertToText(this._srcMsg.placeholderToMessage[ph.name])}_convertToText(srcMsg){const id=this._digest(srcMsg);const mapper=this._mapperFactory?this._mapperFactory(srcMsg):null;let nodes;this._contextStack.push({msg:this._srcMsg,mapper:this._mapper});this._srcMsg=srcMsg;if(this._i18nNodesByMsgId.hasOwnProperty(id)){nodes=this._i18nNodesByMsgId[id];this._mapper=name=>
mapper?mapper.toInternalName(name):name}else{if(this._missingTranslationStrategy===MissingTranslationStrategy.Error){const ctx=this._locale?` for locale "${this._locale}"`:"";this._addError(srcMsg.nodes[0],`Missing translation for message "${id}"${ctx}`)}else if(this._console&&this._missingTranslationStrategy===MissingTranslationStrategy.Warning){const ctx=this._locale?` for locale "${this._locale}"`:"";this._console.warn(`Missing translation for message "${id}"${ctx}`)}nodes=srcMsg.nodes;this._mapper=
name=>name}const text=nodes.map(node=>node.visit(this)).join("");const context=this._contextStack.pop();this._srcMsg=context.msg;this._mapper=context.mapper;return text}_addError(el,msg){this._errors.push(new I18nError(el.sourceSpan,msg))}}class I18NHtmlParser{constructor(_htmlParser,translations,translationsFormat,missingTranslation=MissingTranslationStrategy.Warning,console){this._htmlParser=_htmlParser;if(translations){const serializer=createSerializer(translationsFormat);this._translationBundle=
TranslationBundle.load(translations,"i18n",serializer,missingTranslation,console)}else this._translationBundle=new TranslationBundle({},null,digest$1,undefined,missingTranslation,console)}parse(source,url,options={}){const interpolationConfig=options.interpolationConfig||DEFAULT_INTERPOLATION_CONFIG;const parseResult=this._htmlParser.parse(source,url,Object.assign({interpolationConfig},options));if(parseResult.errors.length)return new ParseTreeResult(parseResult.rootNodes,parseResult.errors);return mergeTranslations(parseResult.rootNodes,
this._translationBundle,interpolationConfig,[],{})}}function createSerializer(format){format=(format||"xlf").toLowerCase();switch(format){case "xmb":return new Xmb;case "xtb":return new Xtb;case "xliff2":case "xlf2":return new Xliff2;case "xliff":case "xlf":default:return new Xliff}}class MessageBundle{constructor(_htmlParser,_implicitTags,_implicitAttrs,_locale=null){this._htmlParser=_htmlParser;this._implicitTags=_implicitTags;this._implicitAttrs=_implicitAttrs;this._locale=_locale;this._messages=
[]}updateFromTemplate(html,url,interpolationConfig){const htmlParserResult=this._htmlParser.parse(html,url,{tokenizeExpansionForms:true,interpolationConfig});if(htmlParserResult.errors.length)return htmlParserResult.errors;const i18nParserResult=extractMessages(htmlParserResult.rootNodes,interpolationConfig,this._implicitTags,this._implicitAttrs);if(i18nParserResult.errors.length)return i18nParserResult.errors;this._messages.push(...i18nParserResult.messages);return[]}getMessages(){return this._messages}write(serializer,
filterSources){const messages={};const mapperVisitor=new MapPlaceholderNames;this._messages.forEach(message=>{const id=serializer.digest(message);if(!messages.hasOwnProperty(id))messages[id]=message;else messages[id].sources.push(...message.sources)});const msgList=Object.keys(messages).map(id=>{const mapper=serializer.createNameMapper(messages[id]);const src=messages[id];const nodes=mapper?mapperVisitor.convert(src.nodes,mapper):src.nodes;let transformedMessage=new Message(nodes,{},{},src.meaning,
src.description,id);transformedMessage.sources=src.sources;if(filterSources)transformedMessage.sources.forEach(source=>source.filePath=filterSources(source.filePath));return transformedMessage});return serializer.write(msgList,this._locale)}}class MapPlaceholderNames extends CloneVisitor{convert(nodes,mapper){return mapper?nodes.map(n=>n.visit(this,mapper)):nodes}visitTagPlaceholder(ph,mapper){const startName=mapper.toPublicName(ph.startName);const closeName=ph.closeName?mapper.toPublicName(ph.closeName):
ph.closeName;const children=ph.children.map(n=>n.visit(this,mapper));return new TagPlaceholder(ph.tag,ph.attrs,startName,closeName,children,ph.isVoid,ph.sourceSpan,ph.startSourceSpan,ph.endSourceSpan)}visitPlaceholder(ph,mapper){return new Placeholder(ph.value,mapper.toPublicName(ph.name),ph.sourceSpan)}visitIcuPlaceholder(ph,mapper){return new IcuPlaceholder(ph.value,mapper.toPublicName(ph.name),ph.sourceSpan)}}var FactoryTarget;(function(FactoryTarget){FactoryTarget[FactoryTarget["Directive"]=0]=
"Directive";FactoryTarget[FactoryTarget["Component"]=1]="Component";FactoryTarget[FactoryTarget["Injectable"]=2]="Injectable";FactoryTarget[FactoryTarget["Pipe"]=3]="Pipe";FactoryTarget[FactoryTarget["NgModule"]=4]="NgModule"})(FactoryTarget||(FactoryTarget={}));class R3TargetBinder{constructor(directiveMatcher){this.directiveMatcher=directiveMatcher}bind(target){if(!target.template)throw new Error("Binding without a template not yet supported");const scope=Scope.apply(target.template);const templateEntities=
extractTemplateEntities(scope);const {directives,bindings,references}=DirectiveBinder.apply(target.template,this.directiveMatcher);const {expressions,symbols,nestingLevel,usedPipes}=TemplateBinder.applyWithScope(target.template,scope);return new R3BoundTarget(target,directives,bindings,references,expressions,symbols,nestingLevel,templateEntities,usedPipes)}}class Scope{constructor(parentScope,template){this.parentScope=parentScope;this.template=template;this.namedEntities=new Map;this.childScopes=
new Map}static newRootScope(){return new Scope(null,null)}static apply(template){const scope=Scope.newRootScope();scope.ingest(template);return scope}ingest(template){if(template instanceof Template){template.variables.forEach(node=>this.visitVariable(node));template.children.forEach(node=>node.visit(this))}else template.forEach(node=>node.visit(this))}visitElement(element){element.references.forEach(node=>this.visitReference(node));element.children.forEach(node=>node.visit(this))}visitTemplate(template){template.references.forEach(node=>
this.visitReference(node));const scope=new Scope(this,template);scope.ingest(template);this.childScopes.set(template,scope)}visitVariable(variable){this.maybeDeclare(variable)}visitReference(reference){this.maybeDeclare(reference)}visitContent(content){}visitBoundAttribute(attr){}visitBoundEvent(event){}visitBoundText(text){}visitText(text){}visitTextAttribute(attr){}visitIcu(icu){}maybeDeclare(thing){if(!this.namedEntities.has(thing.name))this.namedEntities.set(thing.name,thing)}lookup(name){if(this.namedEntities.has(name))return this.namedEntities.get(name);
else if(this.parentScope!==null)return this.parentScope.lookup(name);else return null}getChildScope(template){const res=this.childScopes.get(template);if(res===undefined)throw new Error(`Assertion error: child scope for ${template} not found`);return res}}class DirectiveBinder{constructor(matcher,directives,bindings,references){this.matcher=matcher;this.directives=directives;this.bindings=bindings;this.references=references}static apply(template,selectorMatcher){const directives=new Map;const bindings=
new Map;const references=new Map;const matcher=new DirectiveBinder(selectorMatcher,directives,bindings,references);matcher.ingest(template);return{directives,bindings,references}}ingest(template){template.forEach(node=>node.visit(this))}visitElement(element){this.visitElementOrTemplate(element.name,element)}visitTemplate(template){this.visitElementOrTemplate("ng-template",template)}visitElementOrTemplate(elementName,node){const cssSelector=createCssSelector(elementName,getAttrsForDirectiveMatching(node));
const directives=[];this.matcher.match(cssSelector,(_,directive)=>directives.push(directive));if(directives.length>0)this.directives.set(node,directives);node.references.forEach(ref=>{let dirTarget=null;if(ref.value.trim()==="")dirTarget=directives.find(dir=>dir.isComponent)||null;else{dirTarget=directives.find(dir=>dir.exportAs!==null&&dir.exportAs.some(value=>value===ref.value))||null;if(dirTarget===null)return}if(dirTarget!==null)this.references.set(ref,{directive:dirTarget,node});else this.references.set(ref,
node)});const setAttributeBinding=(attribute,ioType)=>{const dir=directives.find(dir=>dir[ioType].hasBindingPropertyName(attribute.name));const binding=dir!==undefined?dir:node;this.bindings.set(attribute,binding)};node.inputs.forEach(input=>setAttributeBinding(input,"inputs"));node.attributes.forEach(attr=>setAttributeBinding(attr,"inputs"));if(node instanceof Template)node.templateAttrs.forEach(attr=>setAttributeBinding(attr,"inputs"));node.outputs.forEach(output=>setAttributeBinding(output,"outputs"));
node.children.forEach(child=>child.visit(this))}visitContent(content){}visitVariable(variable){}visitReference(reference){}visitTextAttribute(attribute){}visitBoundAttribute(attribute){}visitBoundEvent(attribute){}visitBoundAttributeOrEvent(node){}visitText(text){}visitBoundText(text){}visitIcu(icu){}}class TemplateBinder extends RecursiveAstVisitor{constructor(bindings,symbols,usedPipes,nestingLevel,scope,template,level){super();this.bindings=bindings;this.symbols=symbols;this.usedPipes=usedPipes;
this.nestingLevel=nestingLevel;this.scope=scope;this.template=template;this.level=level;this.pipesUsed=[];this.visitNode=node=>node.visit(this)}visit(node,context){if(node instanceof AST)node.visit(this,context);else node.visit(this)}static applyWithScope(template,scope){const expressions=new Map;const symbols=new Map;const nestingLevel=new Map;const usedPipes=new Set;const binder=new TemplateBinder(expressions,symbols,usedPipes,nestingLevel,scope,template instanceof Template?template:null,0);binder.ingest(template);
return{expressions,symbols,nestingLevel,usedPipes}}ingest(template){if(template instanceof Template){template.variables.forEach(this.visitNode);template.children.forEach(this.visitNode);this.nestingLevel.set(template,this.level)}else template.forEach(this.visitNode)}visitElement(element){element.inputs.forEach(this.visitNode);element.outputs.forEach(this.visitNode);element.children.forEach(this.visitNode)}visitTemplate(template){template.inputs.forEach(this.visitNode);template.outputs.forEach(this.visitNode);
template.templateAttrs.forEach(this.visitNode);template.references.forEach(this.visitNode);const childScope=this.scope.getChildScope(template);const binder=new TemplateBinder(this.bindings,this.symbols,this.usedPipes,this.nestingLevel,childScope,template,this.level+1);binder.ingest(template)}visitVariable(variable){if(this.template!==null)this.symbols.set(variable,this.template)}visitReference(reference){if(this.template!==null)this.symbols.set(reference,this.template)}visitText(text){}visitContent(content){}visitTextAttribute(attribute){}visitIcu(icu){Object.keys(icu.vars).forEach(key=>
icu.vars[key].visit(this));Object.keys(icu.placeholders).forEach(key=>icu.placeholders[key].visit(this))}visitBoundAttribute(attribute){attribute.value.visit(this)}visitBoundEvent(event){event.handler.visit(this)}visitBoundText(text){text.value.visit(this)}visitPipe(ast,context){this.usedPipes.add(ast.name);return super.visitPipe(ast,context)}visitPropertyRead(ast,context){this.maybeMap(context,ast,ast.name);return super.visitPropertyRead(ast,context)}visitSafePropertyRead(ast,context){this.maybeMap(context,
ast,ast.name);return super.visitSafePropertyRead(ast,context)}visitPropertyWrite(ast,context){this.maybeMap(context,ast,ast.name);return super.visitPropertyWrite(ast,context)}maybeMap(scope,ast,name){if(!(ast.receiver instanceof ImplicitReceiver))return;let target=this.scope.lookup(name);if(target!==null)this.bindings.set(ast,target)}}class R3BoundTarget{constructor(target,directives,bindings,references,exprTargets,symbols,nestingLevel,templateEntities,usedPipes){this.target=target;this.directives=
directives;this.bindings=bindings;this.references=references;this.exprTargets=exprTargets;this.symbols=symbols;this.nestingLevel=nestingLevel;this.templateEntities=templateEntities;this.usedPipes=usedPipes}getEntitiesInTemplateScope(template){var _a;return(_a=this.templateEntities.get(template))!==null&&_a!==void 0?_a:new Set}getDirectivesOfNode(node){return this.directives.get(node)||null}getReferenceTarget(ref){return this.references.get(ref)||null}getConsumerOfBinding(binding){return this.bindings.get(binding)||
null}getExpressionTarget(expr){return this.exprTargets.get(expr)||null}getTemplateOfSymbol(symbol){return this.symbols.get(symbol)||null}getNestingLevel(template){return this.nestingLevel.get(template)||0}getUsedDirectives(){const set=new Set;this.directives.forEach(dirs=>dirs.forEach(dir=>set.add(dir)));return Array.from(set.values())}getUsedPipes(){return Array.from(this.usedPipes)}}function extractTemplateEntities(rootScope){const entityMap=new Map;function extractScopeEntities(scope){if(entityMap.has(scope.template))return entityMap.get(scope.template);
const currentEntities=scope.namedEntities;let templateEntities;if(scope.parentScope!==null)templateEntities=new Map([...extractScopeEntities(scope.parentScope),...currentEntities]);else templateEntities=new Map(currentEntities);entityMap.set(scope.template,templateEntities);return templateEntities}const scopesToProcess=[rootScope];while(scopesToProcess.length>0){const scope=scopesToProcess.pop();for(const childScope of scope.childScopes.values())scopesToProcess.push(childScope);extractScopeEntities(scope)}const templateEntities=
new Map;for(const [template,entities]of entityMap)templateEntities.set(template,new Set(entities.values()));return templateEntities}function compileClassMetadata(metadata){var _a,_b;const fnCall=importExpr(Identifiers$1.setClassMetadata).callFn([metadata.type,metadata.decorators,(_a=metadata.ctorParameters)!==null&&_a!==void 0?_a:literal(null),(_b=metadata.propDecorators)!==null&&_b!==void 0?_b:literal(null)]);const iife=fn([],[devOnlyGuardedExpression(fnCall).toStmt()]);return iife.callFn([])}const MINIMUM_PARTIAL_LINKER_VERSION$6=
"12.0.0";function compileDeclareClassMetadata(metadata){const definitionMap=new DefinitionMap;definitionMap.set("minVersion",literal(MINIMUM_PARTIAL_LINKER_VERSION$6));definitionMap.set("version",literal("13.1.3"));definitionMap.set("ngImport",importExpr(Identifiers$1.core));definitionMap.set("type",metadata.type);definitionMap.set("decorators",metadata.decorators);definitionMap.set("ctorParameters",metadata.ctorParameters);definitionMap.set("propDecorators",metadata.propDecorators);return importExpr(Identifiers$1.declareClassMetadata).callFn([definitionMap.toLiteralMap()])}
function toOptionalLiteralArray(values,mapper){if(values===null||values.length===0)return null;return literalArr(values.map(value=>mapper(value)))}function toOptionalLiteralMap(object,mapper){const entries=Object.keys(object).map(key=>{const value=object[key];return{key,value:mapper(value),quoted:true}});if(entries.length>0)return literalMap(entries);else return null}function compileDependencies(deps){if(deps==="invalid")return literal("invalid");else if(deps===null)return literal(null);else return literalArr(deps.map(compileDependency))}
function compileDependency(dep){const depMeta=new DefinitionMap;depMeta.set("token",dep.token);if(dep.attributeNameType!==null)depMeta.set("attribute",literal(true));if(dep.host)depMeta.set("host",literal(true));if(dep.optional)depMeta.set("optional",literal(true));if(dep.self)depMeta.set("self",literal(true));if(dep.skipSelf)depMeta.set("skipSelf",literal(true));return depMeta.toLiteralMap()}const MINIMUM_PARTIAL_LINKER_VERSION$5="12.0.0";function compileDeclareDirectiveFromMetadata(meta){const definitionMap=
createDirectiveDefinitionMap(meta);const expression=importExpr(Identifiers$1.declareDirective).callFn([definitionMap.toLiteralMap()]);const type=createDirectiveType(meta);return{expression,type,statements:[]}}function createDirectiveDefinitionMap(meta){const definitionMap=new DefinitionMap;definitionMap.set("minVersion",literal(MINIMUM_PARTIAL_LINKER_VERSION$5));definitionMap.set("version",literal("13.1.3"));definitionMap.set("type",meta.internalType);if(meta.selector!==null)definitionMap.set("selector",
literal(meta.selector));definitionMap.set("inputs",conditionallyCreateMapObjectLiteral(meta.inputs,true));definitionMap.set("outputs",conditionallyCreateMapObjectLiteral(meta.outputs));definitionMap.set("host",compileHostMetadata(meta.host));definitionMap.set("providers",meta.providers);if(meta.queries.length>0)definitionMap.set("queries",literalArr(meta.queries.map(compileQuery)));if(meta.viewQueries.length>0)definitionMap.set("viewQueries",literalArr(meta.viewQueries.map(compileQuery)));if(meta.exportAs!==
null)definitionMap.set("exportAs",asLiteral(meta.exportAs));if(meta.usesInheritance)definitionMap.set("usesInheritance",literal(true));if(meta.lifecycle.usesOnChanges)definitionMap.set("usesOnChanges",literal(true));definitionMap.set("ngImport",importExpr(Identifiers$1.core));return definitionMap}function compileQuery(query){const meta=new DefinitionMap;meta.set("propertyName",literal(query.propertyName));if(query.first)meta.set("first",literal(true));meta.set("predicate",Array.isArray(query.predicate)?
asLiteral(query.predicate):convertFromMaybeForwardRefExpression(query.predicate));if(!query.emitDistinctChangesOnly)meta.set("emitDistinctChangesOnly",literal(false));if(query.descendants)meta.set("descendants",literal(true));meta.set("read",query.read);if(query.static)meta.set("static",literal(true));return meta.toLiteralMap()}function compileHostMetadata(meta){const hostMetadata=new DefinitionMap;hostMetadata.set("attributes",toOptionalLiteralMap(meta.attributes,expression=>expression));hostMetadata.set("listeners",
toOptionalLiteralMap(meta.listeners,literal));hostMetadata.set("properties",toOptionalLiteralMap(meta.properties,literal));if(meta.specialAttributes.styleAttr)hostMetadata.set("styleAttribute",literal(meta.specialAttributes.styleAttr));if(meta.specialAttributes.classAttr)hostMetadata.set("classAttribute",literal(meta.specialAttributes.classAttr));if(hostMetadata.values.length>0)return hostMetadata.toLiteralMap();else return null}function compileDeclareComponentFromMetadata(meta,template,additionalTemplateInfo){const definitionMap=
createComponentDefinitionMap(meta,template,additionalTemplateInfo);const expression=importExpr(Identifiers$1.declareComponent).callFn([definitionMap.toLiteralMap()]);const type=createComponentType(meta);return{expression,type,statements:[]}}function createComponentDefinitionMap(meta,template,templateInfo){const definitionMap=createDirectiveDefinitionMap(meta);definitionMap.set("template",getTemplateExpression(template,templateInfo));if(templateInfo.isInline)definitionMap.set("isInline",literal(true));
definitionMap.set("styles",toOptionalLiteralArray(meta.styles,literal));definitionMap.set("components",compileUsedDirectiveMetadata(meta,directive=>directive.isComponent===true));definitionMap.set("directives",compileUsedDirectiveMetadata(meta,directive=>directive.isComponent!==true));definitionMap.set("pipes",compileUsedPipeMetadata(meta));definitionMap.set("viewProviders",meta.viewProviders);definitionMap.set("animations",meta.animations);if(meta.changeDetection!==undefined)definitionMap.set("changeDetection",
importExpr(Identifiers$1.ChangeDetectionStrategy).prop(exports.ChangeDetectionStrategy[meta.changeDetection]));if(meta.encapsulation!==exports.ViewEncapsulation.Emulated)definitionMap.set("encapsulation",importExpr(Identifiers$1.ViewEncapsulation).prop(exports.ViewEncapsulation[meta.encapsulation]));if(meta.interpolation!==DEFAULT_INTERPOLATION_CONFIG)definitionMap.set("interpolation",literalArr([literal(meta.interpolation.start),literal(meta.interpolation.end)]));if(template.preserveWhitespaces===
true)definitionMap.set("preserveWhitespaces",literal(true));return definitionMap}function getTemplateExpression(template,templateInfo){if(templateInfo.inlineTemplateLiteralExpression!==null)return templateInfo.inlineTemplateLiteralExpression;if(templateInfo.isInline)return literal(templateInfo.content,null,null);const contents=templateInfo.content;const file=new ParseSourceFile(contents,templateInfo.sourceUrl);const start=new ParseLocation(file,0,0,0);const end=computeEndLocation(file,contents);const span=
new ParseSourceSpan(start,end);return literal(contents,null,span)}function computeEndLocation(file,contents){const length=contents.length;let lineStart=0;let lastLineStart=0;let line=0;do{lineStart=contents.indexOf("\n",lastLineStart);if(lineStart!==-1){lastLineStart=lineStart+1;line++}}while(lineStart!==-1);return new ParseLocation(file,length,line,length-lastLineStart)}function compileUsedDirectiveMetadata(meta,predicate){const wrapType=meta.declarationListEmitMode!==0?generateForwardRef:expr=>
expr;const directives=meta.directives.filter(predicate);return toOptionalLiteralArray(directives,directive=>{const dirMeta=new DefinitionMap;dirMeta.set("type",wrapType(directive.type));dirMeta.set("selector",literal(directive.selector));dirMeta.set("inputs",toOptionalLiteralArray(directive.inputs,literal));dirMeta.set("outputs",toOptionalLiteralArray(directive.outputs,literal));dirMeta.set("exportAs",toOptionalLiteralArray(directive.exportAs,literal));return dirMeta.toLiteralMap()})}function compileUsedPipeMetadata(meta){if(meta.pipes.size===
0)return null;const wrapType=meta.declarationListEmitMode!==0?generateForwardRef:expr=>expr;const entries=[];for(const [name,pipe]of meta.pipes)entries.push({key:name,value:wrapType(pipe),quoted:true});return literalMap(entries)}const MINIMUM_PARTIAL_LINKER_VERSION$4="12.0.0";function compileDeclareFactoryFunction(meta){const definitionMap=new DefinitionMap;definitionMap.set("minVersion",literal(MINIMUM_PARTIAL_LINKER_VERSION$4));definitionMap.set("version",literal("13.1.3"));definitionMap.set("ngImport",
importExpr(Identifiers$1.core));definitionMap.set("type",meta.internalType);definitionMap.set("deps",compileDependencies(meta.deps));definitionMap.set("target",importExpr(Identifiers$1.FactoryTarget).prop(exports.FactoryTarget[meta.target]));return{expression:importExpr(Identifiers$1.declareFactory).callFn([definitionMap.toLiteralMap()]),statements:[],type:createFactoryType(meta)}}const MINIMUM_PARTIAL_LINKER_VERSION$3="12.0.0";function compileDeclareInjectableFromMetadata(meta){const definitionMap=
createInjectableDefinitionMap(meta);const expression=importExpr(Identifiers$1.declareInjectable).callFn([definitionMap.toLiteralMap()]);const type=createInjectableType(meta);return{expression,type,statements:[]}}function createInjectableDefinitionMap(meta){const definitionMap=new DefinitionMap;definitionMap.set("minVersion",literal(MINIMUM_PARTIAL_LINKER_VERSION$3));definitionMap.set("version",literal("13.1.3"));definitionMap.set("ngImport",importExpr(Identifiers$1.core));definitionMap.set("type",
meta.internalType);if(meta.providedIn!==undefined){const providedIn=convertFromMaybeForwardRefExpression(meta.providedIn);if(providedIn.value!==null)definitionMap.set("providedIn",providedIn)}if(meta.useClass!==undefined)definitionMap.set("useClass",convertFromMaybeForwardRefExpression(meta.useClass));if(meta.useExisting!==undefined)definitionMap.set("useExisting",convertFromMaybeForwardRefExpression(meta.useExisting));if(meta.useValue!==undefined)definitionMap.set("useValue",convertFromMaybeForwardRefExpression(meta.useValue));
if(meta.useFactory!==undefined)definitionMap.set("useFactory",meta.useFactory);if(meta.deps!==undefined)definitionMap.set("deps",literalArr(meta.deps.map(compileDependency)));return definitionMap}const MINIMUM_PARTIAL_LINKER_VERSION$2="12.0.0";function compileDeclareInjectorFromMetadata(meta){const definitionMap=createInjectorDefinitionMap(meta);const expression=importExpr(Identifiers$1.declareInjector).callFn([definitionMap.toLiteralMap()]);const type=createInjectorType(meta);return{expression,type,
statements:[]}}function createInjectorDefinitionMap(meta){const definitionMap=new DefinitionMap;definitionMap.set("minVersion",literal(MINIMUM_PARTIAL_LINKER_VERSION$2));definitionMap.set("version",literal("13.1.3"));definitionMap.set("ngImport",importExpr(Identifiers$1.core));definitionMap.set("type",meta.internalType);definitionMap.set("providers",meta.providers);if(meta.imports.length>0)definitionMap.set("imports",literalArr(meta.imports));return definitionMap}const MINIMUM_PARTIAL_LINKER_VERSION$1=
"12.0.0";function compileDeclareNgModuleFromMetadata(meta){const definitionMap=createNgModuleDefinitionMap(meta);const expression=importExpr(Identifiers$1.declareNgModule).callFn([definitionMap.toLiteralMap()]);const type=createNgModuleType(meta);return{expression,type,statements:[]}}function createNgModuleDefinitionMap(meta){const definitionMap=new DefinitionMap;definitionMap.set("minVersion",literal(MINIMUM_PARTIAL_LINKER_VERSION$1));definitionMap.set("version",literal("13.1.3"));definitionMap.set("ngImport",
importExpr(Identifiers$1.core));definitionMap.set("type",meta.internalType);if(meta.bootstrap.length>0)definitionMap.set("bootstrap",refsToArray(meta.bootstrap,meta.containsForwardDecls));if(meta.declarations.length>0)definitionMap.set("declarations",refsToArray(meta.declarations,meta.containsForwardDecls));if(meta.imports.length>0)definitionMap.set("imports",refsToArray(meta.imports,meta.containsForwardDecls));if(meta.exports.length>0)definitionMap.set("exports",refsToArray(meta.exports,meta.containsForwardDecls));
if(meta.schemas!==null&&meta.schemas.length>0)definitionMap.set("schemas",literalArr(meta.schemas.map(ref=>ref.value)));if(meta.id!==null)definitionMap.set("id",meta.id);return definitionMap}const MINIMUM_PARTIAL_LINKER_VERSION="12.0.0";function compileDeclarePipeFromMetadata(meta){const definitionMap=createPipeDefinitionMap(meta);const expression=importExpr(Identifiers$1.declarePipe).callFn([definitionMap.toLiteralMap()]);const type=createPipeType(meta);return{expression,type,statements:[]}}function createPipeDefinitionMap(meta){const definitionMap=
new DefinitionMap;definitionMap.set("minVersion",literal(MINIMUM_PARTIAL_LINKER_VERSION));definitionMap.set("version",literal("13.1.3"));definitionMap.set("ngImport",importExpr(Identifiers$1.core));definitionMap.set("type",meta.internalType);definitionMap.set("name",literal(meta.pipeName));if(meta.pure===false)definitionMap.set("pure",literal(meta.pure));return definitionMap}publishFacade(_global);exports.AST=AST;exports.ASTWithName=ASTWithName;exports.ASTWithSource=ASTWithSource;exports.AbsoluteSourceSpan=
AbsoluteSourceSpan;exports.ArrayType=ArrayType;exports.AstMemoryEfficientTransformer=AstMemoryEfficientTransformer;exports.AstTransformer=AstTransformer;exports.Attribute=Attribute;exports.Binary=Binary;exports.BinaryOperatorExpr=BinaryOperatorExpr;exports.BindingPipe=BindingPipe;exports.BoundElementProperty=BoundElementProperty;exports.BuiltinType=BuiltinType;exports.CUSTOM_ELEMENTS_SCHEMA=CUSTOM_ELEMENTS_SCHEMA;exports.Call=Call;exports.Chain=Chain;exports.CommaExpr=CommaExpr;exports.Comment=Comment;
exports.CompilerConfig=CompilerConfig;exports.Conditional=Conditional;exports.ConditionalExpr=ConditionalExpr;exports.ConstantPool=ConstantPool;exports.CssSelector=CssSelector;exports.DEFAULT_INTERPOLATION_CONFIG=DEFAULT_INTERPOLATION_CONFIG;exports.DYNAMIC_TYPE=DYNAMIC_TYPE;exports.DeclareFunctionStmt=DeclareFunctionStmt;exports.DeclareVarStmt=DeclareVarStmt;exports.DomElementSchemaRegistry=DomElementSchemaRegistry;exports.EOF=EOF;exports.Element=Element;exports.ElementSchemaRegistry=ElementSchemaRegistry;
exports.EmitterVisitorContext=EmitterVisitorContext;exports.EmptyExpr=EmptyExpr;exports.Expansion=Expansion;exports.ExpansionCase=ExpansionCase;exports.Expression=Expression;exports.ExpressionBinding=ExpressionBinding;exports.ExpressionStatement=ExpressionStatement;exports.ExpressionType=ExpressionType;exports.ExternalExpr=ExternalExpr;exports.ExternalReference=ExternalReference;exports.FunctionExpr=FunctionExpr;exports.HtmlParser=HtmlParser;exports.HtmlTagDefinition=HtmlTagDefinition;exports.I18NHtmlParser=
I18NHtmlParser;exports.Identifiers=Identifiers;exports.IfStmt=IfStmt;exports.ImplicitReceiver=ImplicitReceiver;exports.InstantiateExpr=InstantiateExpr;exports.Interpolation=Interpolation;exports.InterpolationConfig=InterpolationConfig;exports.InvokeFunctionExpr=InvokeFunctionExpr;exports.JSDocComment=JSDocComment;exports.JitEvaluator=JitEvaluator;exports.KeyedRead=KeyedRead;exports.KeyedWrite=KeyedWrite;exports.LeadingComment=LeadingComment;exports.Lexer=Lexer;exports.LiteralArray=LiteralArray;exports.LiteralArrayExpr=
LiteralArrayExpr;exports.LiteralExpr=LiteralExpr;exports.LiteralMap=LiteralMap;exports.LiteralMapExpr=LiteralMapExpr;exports.LiteralPrimitive=LiteralPrimitive;exports.LocalizedString=LocalizedString;exports.MapType=MapType;exports.MessageBundle=MessageBundle;exports.NONE_TYPE=NONE_TYPE;exports.NO_ERRORS_SCHEMA=NO_ERRORS_SCHEMA;exports.NodeWithI18n=NodeWithI18n;exports.NonNullAssert=NonNullAssert;exports.NotExpr=NotExpr;exports.ParseError=ParseError;exports.ParseLocation=ParseLocation;exports.ParseSourceFile=
ParseSourceFile;exports.ParseSourceSpan=ParseSourceSpan;exports.ParseSpan=ParseSpan;exports.ParseTreeResult=ParseTreeResult;exports.ParsedEvent=ParsedEvent;exports.ParsedProperty=ParsedProperty;exports.ParsedVariable=ParsedVariable;exports.Parser=Parser$1;exports.ParserError=ParserError;exports.PrefixNot=PrefixNot;exports.PropertyRead=PropertyRead;exports.PropertyWrite=PropertyWrite;exports.Quote=Quote;exports.R3BoundTarget=R3BoundTarget;exports.R3Identifiers=Identifiers$1;exports.R3TargetBinder=
R3TargetBinder;exports.ReadKeyExpr=ReadKeyExpr;exports.ReadPropExpr=ReadPropExpr;exports.ReadVarExpr=ReadVarExpr;exports.RecursiveAstVisitor=RecursiveAstVisitor;exports.RecursiveVisitor=RecursiveVisitor;exports.ResourceLoader=ResourceLoader;exports.ReturnStatement=ReturnStatement;exports.STRING_TYPE=STRING_TYPE;exports.SafeKeyedRead=SafeKeyedRead;exports.SafePropertyRead=SafePropertyRead;exports.SelectorContext=SelectorContext;exports.SelectorListContext=SelectorListContext;exports.SelectorMatcher=
SelectorMatcher;exports.Serializer=Serializer;exports.SplitInterpolation=SplitInterpolation;exports.Statement=Statement;exports.TaggedTemplateExpr=TaggedTemplateExpr;exports.TemplateBindingParseResult=TemplateBindingParseResult;exports.TemplateLiteral=TemplateLiteral;exports.TemplateLiteralElement=TemplateLiteralElement;exports.Text=Text;exports.ThisReceiver=ThisReceiver;exports.TmplAstBoundAttribute=BoundAttribute;exports.TmplAstBoundEvent=BoundEvent;exports.TmplAstBoundText=BoundText;exports.TmplAstContent=
Content;exports.TmplAstElement=Element$1;exports.TmplAstIcu=Icu$1;exports.TmplAstRecursiveVisitor=RecursiveVisitor$1;exports.TmplAstReference=Reference;exports.TmplAstTemplate=Template;exports.TmplAstText=Text$3;exports.TmplAstTextAttribute=TextAttribute;exports.TmplAstVariable=Variable;exports.Token=Token;exports.TreeError=TreeError;exports.Type=Type;exports.TypeofExpr=TypeofExpr;exports.Unary=Unary;exports.UnaryOperatorExpr=UnaryOperatorExpr;exports.VERSION=VERSION;exports.VariableBinding=VariableBinding;
exports.Version=Version;exports.WrappedNodeExpr=WrappedNodeExpr;exports.WriteKeyExpr=WriteKeyExpr;exports.WritePropExpr=WritePropExpr;exports.WriteVarExpr=WriteVarExpr;exports.Xliff=Xliff;exports.Xliff2=Xliff2;exports.Xmb=Xmb;exports.XmlParser=XmlParser;exports.Xtb=Xtb;exports._ParseAST=_ParseAST;exports.compileClassMetadata=compileClassMetadata;exports.compileComponentFromMetadata=compileComponentFromMetadata;exports.compileDeclareClassMetadata=compileDeclareClassMetadata;exports.compileDeclareComponentFromMetadata=
compileDeclareComponentFromMetadata;exports.compileDeclareDirectiveFromMetadata=compileDeclareDirectiveFromMetadata;exports.compileDeclareFactoryFunction=compileDeclareFactoryFunction;exports.compileDeclareInjectableFromMetadata=compileDeclareInjectableFromMetadata;exports.compileDeclareInjectorFromMetadata=compileDeclareInjectorFromMetadata;exports.compileDeclareNgModuleFromMetadata=compileDeclareNgModuleFromMetadata;exports.compileDeclarePipeFromMetadata=compileDeclarePipeFromMetadata;exports.compileDirectiveFromMetadata=
compileDirectiveFromMetadata;exports.compileFactoryFunction=compileFactoryFunction;exports.compileInjectable=compileInjectable;exports.compileInjector=compileInjector;exports.compileNgModule=compileNgModule;exports.compilePipeFromMetadata=compilePipeFromMetadata;exports.computeMsgId=computeMsgId;exports.core=core;exports.createInjectableType=createInjectableType;exports.createMayBeForwardRefExpression=createMayBeForwardRefExpression;exports.devOnlyGuardedExpression=devOnlyGuardedExpression;exports.emitDistinctChangesOnlyDefaultValue=
emitDistinctChangesOnlyDefaultValue;exports.getHtmlTagDefinition=getHtmlTagDefinition;exports.getNsPrefix=getNsPrefix;exports.getSafePropertyAccessString=getSafePropertyAccessString;exports.identifierName=identifierName;exports.isIdentifier=isIdentifier;exports.isNgContainer=isNgContainer;exports.isNgContent=isNgContent;exports.isNgTemplate=isNgTemplate;exports.jsDocComment=jsDocComment;exports.leadingComment=leadingComment;exports.literalMap=literalMap;exports.makeBindingParser=makeBindingParser;
exports.mergeNsAndName=mergeNsAndName;exports.outputAst=output_ast;exports.parseHostBindings=parseHostBindings;exports.parseTemplate=parseTemplate;exports.preserveWhitespacesDefault=preserveWhitespacesDefault;exports.publishFacade=publishFacade;exports.r3JitTypeSourceSpan=r3JitTypeSourceSpan;exports.sanitizeIdentifier=sanitizeIdentifier;exports.splitNsName=splitNsName;exports.verifyHostBindings=verifyHostBindings;exports.visitAll=visitAll;Object.defineProperty(exports,"__esModule",{value:true})});

