/*

 Copyright Google LLC All Rights Reserved.

 Use of this source code is governed by an MIT-style license that can be
 found in the LICENSE file at https://angular.io/license
 Angular v13.1.3
 (c) 2010-2022 Google LLC. https://angular.io/
 License: MIT
*/
'use strict';(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports,require("rxjs"),require("rxjs/operators")):typeof define==="function"&&define.amd?define(["exports","rxjs","rxjs/operators"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory((global.ng=global.ng||{},global.ng.core={}),global.rxjs,global.operators))})(this,function(exports,rxjs,operators){function getClosureSafeProperty(objWithPropertyToExtract){for(let key in objWithPropertyToExtract)if(objWithPropertyToExtract[key]===
getClosureSafeProperty)return key;throw Error("Could not find renamed property on target object.");}function fillProperties(target,source){for(const key in source)if(source.hasOwnProperty(key)&&!target.hasOwnProperty(key))target[key]=source[key]}function stringify(token){if(typeof token==="string")return token;if(Array.isArray(token))return"["+token.map(stringify).join(", ")+"]";if(token==null)return""+token;if(token.overriddenName)return`${token.overriddenName}`;if(token.name)return`${token.name}`;
const res=token.toString();if(res==null)return""+res;const newLineIndex=res.indexOf("\n");return newLineIndex===-1?res:res.substring(0,newLineIndex)}function concatStringsWithSpace(before,after){return before==null||before===""?after===null?"":after:after==null||after===""?before:before+" "+after}const __forward_ref__=getClosureSafeProperty({__forward_ref__:getClosureSafeProperty});function forwardRef(forwardRefFn){forwardRefFn.__forward_ref__=forwardRef;forwardRefFn.toString=function(){return stringify(this())};
return forwardRefFn}function resolveForwardRef(type){return isForwardRef(type)?type():type}function isForwardRef(fn){return typeof fn==="function"&&fn.hasOwnProperty(__forward_ref__)&&fn.__forward_ref__===forwardRef}const ERROR_DETAILS_PAGE_BASE_URL="https://angular.io/errors";class RuntimeError extends Error{constructor(code,message){super(formatRuntimeError(code,message));this.code=code}}function formatRuntimeError(code,message){const codeAsNumber=code;const fullCode=`NG0${Math.abs(codeAsNumber)}`;
let errorMessage=`${fullCode}${message?": "+message:""}`;if(ngDevMode&&codeAsNumber<0)errorMessage=`${errorMessage}. Find more at ${ERROR_DETAILS_PAGE_BASE_URL}/${fullCode}`;return errorMessage}function renderStringify(value){if(typeof value==="string")return value;if(value==null)return"";return String(value)}function stringifyForError(value){if(typeof value==="function")return value.name||value.toString();if(typeof value==="object"&&value!=null&&typeof value.type==="function")return value.type.name||
value.type.toString();return renderStringify(value)}function throwCyclicDependencyError(token,path){const depPath=path?`. Dependency path: ${path.join(" > ")} > ${token}`:"";throw new RuntimeError(-200,`Circular dependency in DI detected for ${token}${depPath}`);}function throwMixedMultiProviderError(){throw new Error(`Cannot mix multi providers and regular providers`);}function throwInvalidProviderError(ngModuleType,providers,provider){let ngModuleDetail="";if(ngModuleType&&providers){const providerDetail=
providers.map(v=>v==provider?"?"+provider+"?":"...");ngModuleDetail=` - only instances of Provider and Type are allowed, got: [${providerDetail.join(", ")}]`}throw new Error(`Invalid provider for the NgModule '${stringify(ngModuleType)}'`+ngModuleDetail);}function throwProviderNotFoundError(token,injectorName){const injectorDetails=injectorName?` in ${injectorName}`:"";throw new RuntimeError(-201,`No provider for ${stringifyForError(token)} found${injectorDetails}`);}function assertNumber(actual,
msg){if(!(typeof actual==="number"))throwError(msg,typeof actual,"number","===")}function assertNumberInRange(actual,minInclusive,maxInclusive){assertNumber(actual,"Expected a number");assertLessThanOrEqual(actual,maxInclusive,"Expected number to be less than or equal to");assertGreaterThanOrEqual(actual,minInclusive,"Expected number to be greater than or equal to")}function assertString(actual,msg){if(!(typeof actual==="string"))throwError(msg,actual===null?"null":typeof actual,"string","===")}function assertFunction(actual,
msg){if(!(typeof actual==="function"))throwError(msg,actual===null?"null":typeof actual,"function","===")}function assertEqual(actual,expected,msg){if(!(actual==expected))throwError(msg,actual,expected,"==")}function assertNotEqual(actual,expected,msg){if(!(actual!=expected))throwError(msg,actual,expected,"!=")}function assertSame(actual,expected,msg){if(!(actual===expected))throwError(msg,actual,expected,"===")}function assertNotSame(actual,expected,msg){if(!(actual!==expected))throwError(msg,actual,
expected,"!==")}function assertLessThan(actual,expected,msg){if(!(actual<expected))throwError(msg,actual,expected,"<")}function assertLessThanOrEqual(actual,expected,msg){if(!(actual<=expected))throwError(msg,actual,expected,"<=")}function assertGreaterThan(actual,expected,msg){if(!(actual>expected))throwError(msg,actual,expected,">")}function assertGreaterThanOrEqual(actual,expected,msg){if(!(actual>=expected))throwError(msg,actual,expected,">=")}function assertDefined(actual,msg){if(actual==null)throwError(msg,
actual,null,"!=")}function throwError(msg,actual,expected,comparison){throw new Error(`ASSERTION ERROR: ${msg}`+(comparison==null?"":` [Expected=> ${expected} ${comparison} ${actual} <=Actual]`));}function assertDomNode(node){if(!(typeof Node!=="undefined"&&node instanceof Node)&&!(typeof node==="object"&&node!=null&&node.constructor.name==="WebWorkerRenderNode"))throwError(`The provided value must be an instance of a DOM Node but got ${stringify(node)}`)}function assertIndexInRange(arr,index){assertDefined(arr,
"Array must be defined.");const maxLen=arr.length;if(index<0||index>=maxLen)throwError(`Index expected to be less than ${maxLen} but got ${index}`)}function assertOneOf(value,...validValues){if(validValues.indexOf(value)!==-1)return true;throwError(`Expected value to be one of ${JSON.stringify(validValues)} but was ${JSON.stringify(value)}.`)}function \u0275\u0275defineInjectable(opts){return{token:opts.token,providedIn:opts.providedIn||null,factory:opts.factory,value:undefined}}const defineInjectable=
\u0275\u0275defineInjectable;function \u0275\u0275defineInjector(options){return{providers:options.providers||[],imports:options.imports||[]}}function getInjectableDef(type){return getOwnDefinition(type,NG_PROV_DEF)||getOwnDefinition(type,NG_INJECTABLE_DEF)}function getOwnDefinition(type,field){return type.hasOwnProperty(field)?type[field]:null}function getInheritedInjectableDef(type){const def=type&&(type[NG_PROV_DEF]||type[NG_INJECTABLE_DEF]);if(def){const typeName=getTypeName(type);console.warn(`DEPRECATED: DI is instantiating a token "${typeName}" that inherits its @Injectable decorator but does not provide one itself.\n`+
`This will become an error in a future version of Angular. Please add @Injectable() to the "${typeName}" class.`);return def}else return null}function getTypeName(type){if(type.hasOwnProperty("name"))return type.name;const match=(""+type).match(/^function\s*([^\s(]+)/);return match===null?"":match[1]}function getInjectorDef(type){return type&&(type.hasOwnProperty(NG_INJ_DEF)||type.hasOwnProperty(NG_INJECTOR_DEF))?type[NG_INJ_DEF]:null}const NG_PROV_DEF=getClosureSafeProperty({"ɵprov":getClosureSafeProperty});
const NG_INJ_DEF=getClosureSafeProperty({"ɵinj":getClosureSafeProperty});const NG_INJECTABLE_DEF=getClosureSafeProperty({ngInjectableDef:getClosureSafeProperty});const NG_INJECTOR_DEF=getClosureSafeProperty({ngInjectorDef:getClosureSafeProperty});exports.InjectFlags=void 0;(function(InjectFlags){InjectFlags[InjectFlags["Default"]=0]="Default";InjectFlags[InjectFlags["Host"]=1]="Host";InjectFlags[InjectFlags["Self"]=2]="Self";InjectFlags[InjectFlags["SkipSelf"]=4]="SkipSelf";InjectFlags[InjectFlags["Optional"]=
8]="Optional"})(exports.InjectFlags||(exports.InjectFlags={}));let _injectImplementation;function getInjectImplementation(){return _injectImplementation}function setInjectImplementation(impl){const previous=_injectImplementation;_injectImplementation=impl;return previous}function injectRootLimpMode(token,notFoundValue,flags){const injectableDef=getInjectableDef(token);if(injectableDef&&injectableDef.providedIn=="root")return injectableDef.value===undefined?injectableDef.value=injectableDef.factory():
injectableDef.value;if(flags&exports.InjectFlags.Optional)return null;if(notFoundValue!==undefined)return notFoundValue;throwProviderNotFoundError(stringify(token),"Injector")}function assertInjectImplementationNotEqual(fn){ngDevMode&&assertNotEqual(_injectImplementation,fn,"Calling ɵɵinject would cause infinite recursion")}function noSideEffects(fn){return{toString:fn}.toString()}exports.ChangeDetectionStrategy=void 0;(function(ChangeDetectionStrategy){ChangeDetectionStrategy[ChangeDetectionStrategy["OnPush"]=
0]="OnPush";ChangeDetectionStrategy[ChangeDetectionStrategy["Default"]=1]="Default"})(exports.ChangeDetectionStrategy||(exports.ChangeDetectionStrategy={}));exports["ɵChangeDetectorStatus"]=void 0;(function(ChangeDetectorStatus){ChangeDetectorStatus[ChangeDetectorStatus["CheckOnce"]=0]="CheckOnce";ChangeDetectorStatus[ChangeDetectorStatus["Checked"]=1]="Checked";ChangeDetectorStatus[ChangeDetectorStatus["CheckAlways"]=2]="CheckAlways";ChangeDetectorStatus[ChangeDetectorStatus["Detached"]=3]="Detached";
ChangeDetectorStatus[ChangeDetectorStatus["Errored"]=4]="Errored";ChangeDetectorStatus[ChangeDetectorStatus["Destroyed"]=5]="Destroyed"})(exports["ɵChangeDetectorStatus"]||(exports["ɵChangeDetectorStatus"]={}));function isDefaultChangeDetectionStrategy(changeDetectionStrategy){return changeDetectionStrategy==null||changeDetectionStrategy===exports.ChangeDetectionStrategy.Default}exports.ViewEncapsulation=void 0;(function(ViewEncapsulation){ViewEncapsulation[ViewEncapsulation["Emulated"]=0]="Emulated";
ViewEncapsulation[ViewEncapsulation["None"]=2]="None";ViewEncapsulation[ViewEncapsulation["ShadowDom"]=3]="ShadowDom"})(exports.ViewEncapsulation||(exports.ViewEncapsulation={}));const __globalThis=typeof globalThis!=="undefined"&&globalThis;const __window=typeof window!=="undefined"&&window;const __self=typeof self!=="undefined"&&typeof WorkerGlobalScope!=="undefined"&&self instanceof WorkerGlobalScope&&self;const __global=typeof global!=="undefined"&&global;const _global=__globalThis||__global||
__window||__self;function ngDevModeResetPerfCounters(){const locationString=typeof location!=="undefined"?location.toString():"";const newCounters={namedConstructors:locationString.indexOf("ngDevMode=namedConstructors")!=-1,firstCreatePass:0,tNode:0,tView:0,rendererCreateTextNode:0,rendererSetText:0,rendererCreateElement:0,rendererAddEventListener:0,rendererSetAttribute:0,rendererRemoveAttribute:0,rendererSetProperty:0,rendererSetClassName:0,rendererAddClass:0,rendererRemoveClass:0,rendererSetStyle:0,
rendererRemoveStyle:0,rendererDestroy:0,rendererDestroyNode:0,rendererMoveNode:0,rendererRemoveNode:0,rendererAppendChild:0,rendererInsertBefore:0,rendererCreateComment:0};const allowNgDevModeTrue=locationString.indexOf("ngDevMode=false")===-1;_global["ngDevMode"]=allowNgDevModeTrue&&newCounters;return newCounters}function initNgDevMode(){if(typeof ngDevMode==="undefined"||ngDevMode){if(typeof ngDevMode!=="object")ngDevModeResetPerfCounters();return typeof ngDevMode!=="undefined"&&!!ngDevMode}return false}
const EMPTY_OBJ={};const EMPTY_ARRAY=[];if((typeof ngDevMode==="undefined"||ngDevMode)&&initNgDevMode()){Object.freeze(EMPTY_OBJ);Object.freeze(EMPTY_ARRAY)}const NG_COMP_DEF=getClosureSafeProperty({"ɵcmp":getClosureSafeProperty});const NG_DIR_DEF=getClosureSafeProperty({"ɵdir":getClosureSafeProperty});const NG_PIPE_DEF=getClosureSafeProperty({"ɵpipe":getClosureSafeProperty});const NG_MOD_DEF=getClosureSafeProperty({"ɵmod":getClosureSafeProperty});const NG_FACTORY_DEF=getClosureSafeProperty({"ɵfac":getClosureSafeProperty});
const NG_ELEMENT_ID=getClosureSafeProperty({__NG_ELEMENT_ID__:getClosureSafeProperty});let _renderCompCount=0;function \u0275\u0275defineComponent(componentDefinition){return noSideEffects(()=>{(typeof ngDevMode==="undefined"||ngDevMode)&&initNgDevMode();const type=componentDefinition.type;const declaredInputs={};const def={type:type,providersResolver:null,decls:componentDefinition.decls,vars:componentDefinition.vars,factory:null,template:componentDefinition.template||null,consts:componentDefinition.consts||
null,ngContentSelectors:componentDefinition.ngContentSelectors,hostBindings:componentDefinition.hostBindings||null,hostVars:componentDefinition.hostVars||0,hostAttrs:componentDefinition.hostAttrs||null,contentQueries:componentDefinition.contentQueries||null,declaredInputs:declaredInputs,inputs:null,outputs:null,exportAs:componentDefinition.exportAs||null,onPush:componentDefinition.changeDetection===exports.ChangeDetectionStrategy.OnPush,directiveDefs:null,pipeDefs:null,selectors:componentDefinition.selectors||
EMPTY_ARRAY,viewQuery:componentDefinition.viewQuery||null,features:componentDefinition.features||null,data:componentDefinition.data||{},encapsulation:componentDefinition.encapsulation||exports.ViewEncapsulation.Emulated,id:"c",styles:componentDefinition.styles||EMPTY_ARRAY,_:null,setInput:null,schemas:componentDefinition.schemas||null,tView:null};const directiveTypes=componentDefinition.directives;const feature=componentDefinition.features;const pipeTypes=componentDefinition.pipes;def.id+=_renderCompCount++;
def.inputs=invertObject(componentDefinition.inputs,declaredInputs),def.outputs=invertObject(componentDefinition.outputs),feature&&feature.forEach(fn=>fn(def));def.directiveDefs=directiveTypes?()=>(typeof directiveTypes==="function"?directiveTypes():directiveTypes).map(extractDirectiveDef):null;def.pipeDefs=pipeTypes?()=>(typeof pipeTypes==="function"?pipeTypes():pipeTypes).map(extractPipeDef):null;return def})}function \u0275\u0275setComponentScope(type,directives,pipes){const def=type.\u0275cmp;
def.directiveDefs=()=>directives.map(extractDirectiveDef);def.pipeDefs=()=>pipes.map(extractPipeDef)}function extractDirectiveDef(type){const def=getComponentDef(type)||getDirectiveDef(type);if(ngDevMode&&!def)throw new Error(`'${type.name}' is neither 'ComponentType' or 'DirectiveType'.`);return def}function extractPipeDef(type){const def=getPipeDef$1(type);if(ngDevMode&&!def)throw new Error(`'${type.name}' is not a 'PipeType'.`);return def}const autoRegisterModuleById={};function \u0275\u0275defineNgModule(def){return noSideEffects(()=>
{const res={type:def.type,bootstrap:def.bootstrap||EMPTY_ARRAY,declarations:def.declarations||EMPTY_ARRAY,imports:def.imports||EMPTY_ARRAY,exports:def.exports||EMPTY_ARRAY,transitiveCompileScopes:null,schemas:def.schemas||null,id:def.id||null};if(def.id!=null)autoRegisterModuleById[def.id]=def.type;return res})}function \u0275\u0275setNgModuleScope(type,scope){return noSideEffects(()=>{const ngModuleDef=getNgModuleDef(type,true);ngModuleDef.declarations=scope.declarations||EMPTY_ARRAY;ngModuleDef.imports=
scope.imports||EMPTY_ARRAY;ngModuleDef.exports=scope.exports||EMPTY_ARRAY})}function invertObject(obj,secondary){if(obj==null)return EMPTY_OBJ;const newLookup={};for(const minifiedKey in obj)if(obj.hasOwnProperty(minifiedKey)){let publicName=obj[minifiedKey];let declaredName=publicName;if(Array.isArray(publicName)){declaredName=publicName[1];publicName=publicName[0]}newLookup[publicName]=minifiedKey;if(secondary)secondary[publicName]=declaredName}return newLookup}const \u0275\u0275defineDirective=
\u0275\u0275defineComponent;function \u0275\u0275definePipe(pipeDef){return{type:pipeDef.type,name:pipeDef.name,factory:null,pure:pipeDef.pure!==false,onDestroy:pipeDef.type.prototype.ngOnDestroy||null}}function getComponentDef(type){return type[NG_COMP_DEF]||null}function getDirectiveDef(type){return type[NG_DIR_DEF]||null}function getPipeDef$1(type){return type[NG_PIPE_DEF]||null}function getNgModuleDef(type,throwNotFound){const ngModuleDef=type[NG_MOD_DEF]||null;if(!ngModuleDef&&throwNotFound===
true)throw new Error(`Type ${stringify(type)} does not have 'ɵmod' property.`);return ngModuleDef}const TYPE=1;const HAS_TRANSPLANTED_VIEWS=2;const NATIVE=7;const VIEW_REFS=8;const MOVED_VIEWS=9;const CONTAINER_HEADER_OFFSET=10;const HOST=0;const TVIEW=1;const FLAGS=2;const PARENT=3;const NEXT=4;const TRANSPLANTED_VIEWS_TO_REFRESH=5;const T_HOST=6;const CLEANUP=7;const CONTEXT=8;const INJECTOR$1=9;const RENDERER_FACTORY=10;const RENDERER=11;const SANITIZER=12;const CHILD_HEAD=13;const CHILD_TAIL=
14;const DECLARATION_VIEW=15;const DECLARATION_COMPONENT_VIEW=16;const DECLARATION_LCONTAINER=17;const PREORDER_HOOK_FLAGS=18;const QUERIES=19;const HEADER_OFFSET=20;const TViewTypeAsString=["Root","Component","Embedded"];function isLView(value){return Array.isArray(value)&&typeof value[TYPE]==="object"}function isLContainer(value){return Array.isArray(value)&&value[TYPE]===true}function isContentQueryHost(tNode){return(tNode.flags&8)!==0}function isComponentHost(tNode){return(tNode.flags&2)===2}
function isDirectiveHost(tNode){return(tNode.flags&1)===1}function isComponentDef(def){return def.template!==null}function isRootView(target){return(target[FLAGS]&512)!==0}function assertTNodeForLView(tNode,lView){assertTNodeForTView(tNode,lView[TVIEW])}function assertTNodeForTView(tNode,tView){assertTNode(tNode);tNode.hasOwnProperty("tView_")&&assertEqual(tNode.tView_,tView,"This TNode does not belong to this TView.")}function assertTNode(tNode){assertDefined(tNode,"TNode must be defined");if(!(tNode&&
typeof tNode==="object"&&tNode.hasOwnProperty("directiveStylingLast")))throwError("Not of type TNode, got: "+tNode)}function assertTIcu(tIcu){assertDefined(tIcu,"Expected TIcu to be defined");if(!(typeof tIcu.currentCaseLViewIndex==="number"))throwError("Object is not of TIcu type.")}function assertComponentType(actual,msg="Type passed in is not ComponentType, it does not have 'ɵcmp' property."){if(!getComponentDef(actual))throwError(msg)}function assertNgModuleType(actual,msg="Type passed in is not NgModuleType, it does not have 'ɵmod' property."){if(!getNgModuleDef(actual))throwError(msg)}
function assertHasParent(tNode){assertDefined(tNode,"currentTNode should exist!");assertDefined(tNode.parent,"currentTNode should have a parent")}function assertLContainer(value){assertDefined(value,"LContainer must be defined");assertEqual(isLContainer(value),true,"Expecting LContainer")}function assertLViewOrUndefined(value){value&&assertEqual(isLView(value),true,"Expecting LView or undefined or null")}function assertLView(value){assertDefined(value,"LView must be defined");assertEqual(isLView(value),
true,"Expecting LView")}function assertFirstCreatePass(tView,errMessage){assertEqual(tView.firstCreatePass,true,errMessage||"Should only be called in first create pass.")}function assertFirstUpdatePass(tView,errMessage){assertEqual(tView.firstUpdatePass,true,errMessage||"Should only be called in first update pass.")}function assertDirectiveDef(obj){if(obj.type===undefined||obj.selectors==undefined||obj.inputs===undefined)throwError(`Expected a DirectiveDef/ComponentDef and this object does not seem to have the expected shape.`)}
function assertIndexInDeclRange(lView,index){const tView=lView[1];assertBetween(HEADER_OFFSET,tView.bindingStartIndex,index)}function assertIndexInExpandoRange(lView,index){const tView=lView[1];assertBetween(tView.expandoStartIndex,lView.length,index)}function assertBetween(lower,upper,index){if(!(lower<=index&&index<upper))throwError(`Index out of range (expecting ${lower} <= ${index} < ${upper})`)}function assertProjectionSlots(lView,errMessage){assertDefined(lView[DECLARATION_COMPONENT_VIEW],"Component views should exist.");
assertDefined(lView[DECLARATION_COMPONENT_VIEW][T_HOST].projection,errMessage||"Components with projection nodes (<ng-content>) must have projection slots defined.")}function assertParentView(lView,errMessage){assertDefined(lView,errMessage||"Component views should always have a parent view (component's host view)")}function assertNodeInjector(lView,injectorIndex){assertIndexInExpandoRange(lView,injectorIndex);assertIndexInExpandoRange(lView,injectorIndex+8);assertNumber(lView[injectorIndex+0],"injectorIndex should point to a bloom filter");
assertNumber(lView[injectorIndex+1],"injectorIndex should point to a bloom filter");assertNumber(lView[injectorIndex+2],"injectorIndex should point to a bloom filter");assertNumber(lView[injectorIndex+3],"injectorIndex should point to a bloom filter");assertNumber(lView[injectorIndex+4],"injectorIndex should point to a bloom filter");assertNumber(lView[injectorIndex+5],"injectorIndex should point to a bloom filter");assertNumber(lView[injectorIndex+6],"injectorIndex should point to a bloom filter");
assertNumber(lView[injectorIndex+7],"injectorIndex should point to a bloom filter");assertNumber(lView[injectorIndex+8],"injectorIndex should point to parent injector")}function getFactoryDef(type,throwNotFound){const hasFactoryDef=type.hasOwnProperty(NG_FACTORY_DEF);if(!hasFactoryDef&&throwNotFound===true&&ngDevMode)throw new Error(`Type ${stringify(type)} does not have 'ɵfac' property.`);return hasFactoryDef?type[NG_FACTORY_DEF]:null}class SimpleChange{constructor(previousValue,currentValue,firstChange){this.previousValue=
previousValue;this.currentValue=currentValue;this.firstChange=firstChange}isFirstChange(){return this.firstChange}}function \u0275\u0275NgOnChangesFeature(){return NgOnChangesFeatureImpl}function NgOnChangesFeatureImpl(definition){if(definition.type.prototype.ngOnChanges)definition.setInput=ngOnChangesSetInput;return rememberChangeHistoryAndInvokeOnChangesHook}\u0275\u0275NgOnChangesFeature.ngInherit=true;function rememberChangeHistoryAndInvokeOnChangesHook(){const simpleChangesStore=getSimpleChangesStore(this);
const current=simpleChangesStore===null||simpleChangesStore===void 0?void 0:simpleChangesStore.current;if(current){const previous=simpleChangesStore.previous;if(previous===EMPTY_OBJ)simpleChangesStore.previous=current;else for(let key in current)previous[key]=current[key];simpleChangesStore.current=null;this.ngOnChanges(current)}}function ngOnChangesSetInput(instance,value,publicName,privateName){const simpleChangesStore=getSimpleChangesStore(instance)||setSimpleChangesStore(instance,{previous:EMPTY_OBJ,
current:null});const current=simpleChangesStore.current||(simpleChangesStore.current={});const previous=simpleChangesStore.previous;const declaredName=this.declaredInputs[publicName];const previousChange=previous[declaredName];current[declaredName]=new SimpleChange(previousChange&&previousChange.currentValue,value,previous===EMPTY_OBJ);instance[privateName]=value}const SIMPLE_CHANGES_STORE="__ngSimpleChanges__";function getSimpleChangesStore(instance){return instance[SIMPLE_CHANGES_STORE]||null}function setSimpleChangesStore(instance,
store){return instance[SIMPLE_CHANGES_STORE]=store}let profilerCallback=null;const setProfiler=profiler=>{profilerCallback=profiler};const profiler=function(event,instance,hookOrListener){if(profilerCallback!=null)profilerCallback(event,instance,hookOrListener)};const SVG_NAMESPACE="http://www.w3.org/2000/svg";const MATH_ML_NAMESPACE="http://www.w3.org/1998/MathML/";let DOCUMENT=undefined;function setDocument(document){DOCUMENT=document}function getDocument(){if(DOCUMENT!==undefined)return DOCUMENT;
else if(typeof document!=="undefined")return document;return undefined}var RendererStyleFlags3;(function(RendererStyleFlags3){RendererStyleFlags3[RendererStyleFlags3["Important"]=1]="Important";RendererStyleFlags3[RendererStyleFlags3["DashCase"]=2]="DashCase"})(RendererStyleFlags3||(RendererStyleFlags3={}));function isProceduralRenderer(renderer){return!!renderer.listen}const domRendererFactory3={createRenderer:(hostElement,rendererType)=>{return getDocument()}};function unwrapRNode(value){while(Array.isArray(value))value=
value[HOST];return value}function unwrapLView(value){while(Array.isArray(value)){if(typeof value[TYPE]==="object")return value;value=value[HOST]}return null}function getNativeByIndex(index,lView){ngDevMode&&assertIndexInRange(lView,index);ngDevMode&&assertGreaterThanOrEqual(index,HEADER_OFFSET,"Expected to be past HEADER_OFFSET");return unwrapRNode(lView[index])}function getNativeByTNode(tNode,lView){ngDevMode&&assertTNodeForLView(tNode,lView);ngDevMode&&assertIndexInRange(lView,tNode.index);const node=
unwrapRNode(lView[tNode.index]);ngDevMode&&!isProceduralRenderer(lView[RENDERER])&&assertDomNode(node);return node}function getNativeByTNodeOrNull(tNode,lView){const index=tNode===null?-1:tNode.index;if(index!==-1){ngDevMode&&assertTNodeForLView(tNode,lView);const node=unwrapRNode(lView[index]);ngDevMode&&node!==null&&!isProceduralRenderer(lView[RENDERER])&&assertDomNode(node);return node}return null}function getTNode(tView,index){ngDevMode&&assertGreaterThan(index,-1,"wrong index for TNode");ngDevMode&&
assertLessThan(index,tView.data.length,"wrong index for TNode");const tNode=tView.data[index];ngDevMode&&tNode!==null&&assertTNode(tNode);return tNode}function load(view,index){ngDevMode&&assertIndexInRange(view,index);return view[index]}function getComponentLViewByIndex(nodeIndex,hostView){ngDevMode&&assertIndexInRange(hostView,nodeIndex);const slotValue=hostView[nodeIndex];const lView=isLView(slotValue)?slotValue:slotValue[HOST];return lView}function isCreationMode(view){return(view[FLAGS]&4)===
4}function viewAttachedToChangeDetector(view){return(view[FLAGS]&128)===128}function viewAttachedToContainer(view){return isLContainer(view[PARENT])}function getConstant(consts,index){if(index===null||index===undefined)return null;ngDevMode&&assertIndexInRange(consts,index);return consts[index]}function resetPreOrderHookFlags(lView){lView[PREORDER_HOOK_FLAGS]=0}function updateTransplantedViewCount(lContainer,amount){lContainer[TRANSPLANTED_VIEWS_TO_REFRESH]+=amount;let viewOrContainer=lContainer;
let parent=lContainer[PARENT];while(parent!==null&&(amount===1&&viewOrContainer[TRANSPLANTED_VIEWS_TO_REFRESH]===1||amount===-1&&viewOrContainer[TRANSPLANTED_VIEWS_TO_REFRESH]===0)){parent[TRANSPLANTED_VIEWS_TO_REFRESH]+=amount;viewOrContainer=parent;parent=parent[PARENT]}}const instructionState={lFrame:createLFrame(null),bindingsEnabled:true,isInCheckNoChangesMode:false};function getElementDepthCount(){return instructionState.lFrame.elementDepthCount}function increaseElementDepthCount(){instructionState.lFrame.elementDepthCount++}
function decreaseElementDepthCount(){instructionState.lFrame.elementDepthCount--}function getBindingsEnabled(){return instructionState.bindingsEnabled}function \u0275\u0275enableBindings(){instructionState.bindingsEnabled=true}function \u0275\u0275disableBindings(){instructionState.bindingsEnabled=false}function getLView(){return instructionState.lFrame.lView}function getTView(){return instructionState.lFrame.tView}function \u0275\u0275restoreView(viewToRestore){instructionState.lFrame.contextLView=
viewToRestore;return viewToRestore[CONTEXT]}function getCurrentTNode(){let currentTNode=getCurrentTNodePlaceholderOk();while(currentTNode!==null&&currentTNode.type===64)currentTNode=currentTNode.parent;return currentTNode}function getCurrentTNodePlaceholderOk(){return instructionState.lFrame.currentTNode}function getCurrentParentTNode(){const lFrame=instructionState.lFrame;const currentTNode=lFrame.currentTNode;return lFrame.isParent?currentTNode:currentTNode.parent}function setCurrentTNode(tNode,
isParent){ngDevMode&&tNode&&assertTNodeForTView(tNode,instructionState.lFrame.tView);const lFrame=instructionState.lFrame;lFrame.currentTNode=tNode;lFrame.isParent=isParent}function isCurrentTNodeParent(){return instructionState.lFrame.isParent}function setCurrentTNodeAsNotParent(){instructionState.lFrame.isParent=false}function getContextLView(){return instructionState.lFrame.contextLView}function isInCheckNoChangesMode(){return instructionState.isInCheckNoChangesMode}function setIsInCheckNoChangesMode(mode){instructionState.isInCheckNoChangesMode=
mode}function getBindingRoot(){const lFrame=instructionState.lFrame;let index=lFrame.bindingRootIndex;if(index===-1)index=lFrame.bindingRootIndex=lFrame.tView.bindingStartIndex;return index}function getBindingIndex(){return instructionState.lFrame.bindingIndex}function setBindingIndex(value){return instructionState.lFrame.bindingIndex=value}function nextBindingIndex(){return instructionState.lFrame.bindingIndex++}function incrementBindingIndex(count){const lFrame=instructionState.lFrame;const index=
lFrame.bindingIndex;lFrame.bindingIndex=lFrame.bindingIndex+count;return index}function isInI18nBlock(){return instructionState.lFrame.inI18n}function setInI18nBlock(isInI18nBlock){instructionState.lFrame.inI18n=isInI18nBlock}function setBindingRootForHostBindings(bindingRootIndex,currentDirectiveIndex){const lFrame=instructionState.lFrame;lFrame.bindingIndex=lFrame.bindingRootIndex=bindingRootIndex;setCurrentDirectiveIndex(currentDirectiveIndex)}function getCurrentDirectiveIndex(){return instructionState.lFrame.currentDirectiveIndex}
function setCurrentDirectiveIndex(currentDirectiveIndex){instructionState.lFrame.currentDirectiveIndex=currentDirectiveIndex}function getCurrentDirectiveDef(tData){const currentDirectiveIndex=instructionState.lFrame.currentDirectiveIndex;return currentDirectiveIndex===-1?null:tData[currentDirectiveIndex]}function getCurrentQueryIndex(){return instructionState.lFrame.currentQueryIndex}function setCurrentQueryIndex(value){instructionState.lFrame.currentQueryIndex=value}function getDeclarationTNode(lView){const tView=
lView[TVIEW];if(tView.type===2){ngDevMode&&assertDefined(tView.declTNode,"Embedded TNodes should have declaration parents.");return tView.declTNode}if(tView.type===1)return lView[T_HOST];return null}function enterDI(lView,tNode,flags){ngDevMode&&assertLViewOrUndefined(lView);if(flags&exports.InjectFlags.SkipSelf){ngDevMode&&assertTNodeForTView(tNode,lView[TVIEW]);let parentTNode=tNode;let parentLView=lView;while(true){ngDevMode&&assertDefined(parentTNode,"Parent TNode should be defined");parentTNode=
parentTNode.parent;if(parentTNode===null&&!(flags&exports.InjectFlags.Host)){parentTNode=getDeclarationTNode(parentLView);if(parentTNode===null)break;ngDevMode&&assertDefined(parentLView,"Parent LView should be defined");parentLView=parentLView[DECLARATION_VIEW];if(parentTNode.type&(2|8))break}else break}if(parentTNode===null)return false;else{tNode=parentTNode;lView=parentLView}}ngDevMode&&assertTNodeForLView(tNode,lView);const lFrame=instructionState.lFrame=allocLFrame();lFrame.currentTNode=tNode;
lFrame.lView=lView;return true}function enterView(newView){ngDevMode&&assertNotEqual(newView[0],newView[1],"????");ngDevMode&&assertLViewOrUndefined(newView);const newLFrame=allocLFrame();if(ngDevMode){assertEqual(newLFrame.isParent,true,"Expected clean LFrame");assertEqual(newLFrame.lView,null,"Expected clean LFrame");assertEqual(newLFrame.tView,null,"Expected clean LFrame");assertEqual(newLFrame.selectedIndex,-1,"Expected clean LFrame");assertEqual(newLFrame.elementDepthCount,0,"Expected clean LFrame");
assertEqual(newLFrame.currentDirectiveIndex,-1,"Expected clean LFrame");assertEqual(newLFrame.currentNamespace,null,"Expected clean LFrame");assertEqual(newLFrame.bindingRootIndex,-1,"Expected clean LFrame");assertEqual(newLFrame.currentQueryIndex,0,"Expected clean LFrame")}const tView=newView[TVIEW];instructionState.lFrame=newLFrame;ngDevMode&&tView.firstChild&&assertTNodeForTView(tView.firstChild,tView);newLFrame.currentTNode=tView.firstChild;newLFrame.lView=newView;newLFrame.tView=tView;newLFrame.contextLView=
newView;newLFrame.bindingIndex=tView.bindingStartIndex;newLFrame.inI18n=false}function allocLFrame(){const currentLFrame=instructionState.lFrame;const childLFrame=currentLFrame===null?null:currentLFrame.child;const newLFrame=childLFrame===null?createLFrame(currentLFrame):childLFrame;return newLFrame}function createLFrame(parent){const lFrame={currentTNode:null,isParent:true,lView:null,tView:null,selectedIndex:-1,contextLView:null,elementDepthCount:0,currentNamespace:null,currentDirectiveIndex:-1,
bindingRootIndex:-1,bindingIndex:-1,currentQueryIndex:0,parent:parent,child:null,inI18n:false};parent!==null&&(parent.child=lFrame);return lFrame}function leaveViewLight(){const oldLFrame=instructionState.lFrame;instructionState.lFrame=oldLFrame.parent;oldLFrame.currentTNode=null;oldLFrame.lView=null;return oldLFrame}const leaveDI=leaveViewLight;function leaveView(){const oldLFrame=leaveViewLight();oldLFrame.isParent=true;oldLFrame.tView=null;oldLFrame.selectedIndex=-1;oldLFrame.contextLView=null;
oldLFrame.elementDepthCount=0;oldLFrame.currentDirectiveIndex=-1;oldLFrame.currentNamespace=null;oldLFrame.bindingRootIndex=-1;oldLFrame.bindingIndex=-1;oldLFrame.currentQueryIndex=0}function nextContextImpl(level){const contextLView=instructionState.lFrame.contextLView=walkUpViews(level,instructionState.lFrame.contextLView);return contextLView[CONTEXT]}function walkUpViews(nestingLevel,currentView){while(nestingLevel>0){ngDevMode&&assertDefined(currentView[DECLARATION_VIEW],"Declaration view should be defined if nesting level is greater than 0.");
currentView=currentView[DECLARATION_VIEW];nestingLevel--}return currentView}function getSelectedIndex(){return instructionState.lFrame.selectedIndex}function setSelectedIndex(index){ngDevMode&&index!==-1&&assertGreaterThanOrEqual(index,HEADER_OFFSET,"Index must be past HEADER_OFFSET (or -1).");ngDevMode&&assertLessThan(index,instructionState.lFrame.lView.length,"Can't set index passed end of LView");instructionState.lFrame.selectedIndex=index}function getSelectedTNode(){const lFrame=instructionState.lFrame;
return getTNode(lFrame.tView,lFrame.selectedIndex)}function \u0275\u0275namespaceSVG(){instructionState.lFrame.currentNamespace=SVG_NAMESPACE}function \u0275\u0275namespaceMathML(){instructionState.lFrame.currentNamespace=MATH_ML_NAMESPACE}function \u0275\u0275namespaceHTML(){namespaceHTMLInternal()}function namespaceHTMLInternal(){instructionState.lFrame.currentNamespace=null}function getNamespace$1(){return instructionState.lFrame.currentNamespace}function registerPreOrderHooks(directiveIndex,directiveDef,
tView){ngDevMode&&assertFirstCreatePass(tView);const {ngOnChanges,ngOnInit,ngDoCheck}=directiveDef.type.prototype;if(ngOnChanges){const wrappedOnChanges=NgOnChangesFeatureImpl(directiveDef);(tView.preOrderHooks||(tView.preOrderHooks=[])).push(directiveIndex,wrappedOnChanges);(tView.preOrderCheckHooks||(tView.preOrderCheckHooks=[])).push(directiveIndex,wrappedOnChanges)}if(ngOnInit)(tView.preOrderHooks||(tView.preOrderHooks=[])).push(0-directiveIndex,ngOnInit);if(ngDoCheck){(tView.preOrderHooks||(tView.preOrderHooks=
[])).push(directiveIndex,ngDoCheck);(tView.preOrderCheckHooks||(tView.preOrderCheckHooks=[])).push(directiveIndex,ngDoCheck)}}function registerPostOrderHooks(tView,tNode){ngDevMode&&assertFirstCreatePass(tView);for(let i=tNode.directiveStart,end=tNode.directiveEnd;i<end;i++){const directiveDef=tView.data[i];ngDevMode&&assertDefined(directiveDef,"Expecting DirectiveDef");const lifecycleHooks=directiveDef.type.prototype;const {ngAfterContentInit,ngAfterContentChecked,ngAfterViewInit,ngAfterViewChecked,
ngOnDestroy}=lifecycleHooks;if(ngAfterContentInit)(tView.contentHooks||(tView.contentHooks=[])).push(-i,ngAfterContentInit);if(ngAfterContentChecked){(tView.contentHooks||(tView.contentHooks=[])).push(i,ngAfterContentChecked);(tView.contentCheckHooks||(tView.contentCheckHooks=[])).push(i,ngAfterContentChecked)}if(ngAfterViewInit)(tView.viewHooks||(tView.viewHooks=[])).push(-i,ngAfterViewInit);if(ngAfterViewChecked){(tView.viewHooks||(tView.viewHooks=[])).push(i,ngAfterViewChecked);(tView.viewCheckHooks||
(tView.viewCheckHooks=[])).push(i,ngAfterViewChecked)}if(ngOnDestroy!=null)(tView.destroyHooks||(tView.destroyHooks=[])).push(i,ngOnDestroy)}}function executeCheckHooks(lView,hooks,nodeIndex){callHooks(lView,hooks,3,nodeIndex)}function executeInitAndCheckHooks(lView,hooks,initPhase,nodeIndex){ngDevMode&&assertNotEqual(initPhase,3,"Init pre-order hooks should not be called more than once");if((lView[FLAGS]&3)===initPhase)callHooks(lView,hooks,initPhase,nodeIndex)}function incrementInitPhaseFlags(lView,
initPhase){ngDevMode&&assertNotEqual(initPhase,3,"Init hooks phase should not be incremented after all init hooks have been run.");let flags=lView[FLAGS];if((flags&3)===initPhase){flags&=2047;flags+=1;lView[FLAGS]=flags}}function callHooks(currentView,arr,initPhase,currentNodeIndex){ngDevMode&&assertEqual(isInCheckNoChangesMode(),false,"Hooks should never be run when in check no changes mode.");const startIndex=currentNodeIndex!==undefined?currentView[PREORDER_HOOK_FLAGS]&65535:0;const nodeIndexLimit=
currentNodeIndex!=null?currentNodeIndex:-1;const max=arr.length-1;let lastNodeIndexFound=0;for(let i=startIndex;i<max;i++){const hook=arr[i+1];if(typeof hook==="number"){lastNodeIndexFound=arr[i];if(currentNodeIndex!=null&&lastNodeIndexFound>=currentNodeIndex)break}else{const isInitHook=arr[i]<0;if(isInitHook)currentView[PREORDER_HOOK_FLAGS]+=65536;if(lastNodeIndexFound<nodeIndexLimit||nodeIndexLimit==-1){callHook(currentView,initPhase,arr,i);currentView[PREORDER_HOOK_FLAGS]=(currentView[PREORDER_HOOK_FLAGS]&
4294901760)+i+2}i++}}}function callHook(currentView,initPhase,arr,i){const isInitHook=arr[i]<0;const hook=arr[i+1];const directiveIndex=isInitHook?-arr[i]:arr[i];const directive=currentView[directiveIndex];if(isInitHook){const indexWithintInitPhase=currentView[FLAGS]>>11;if(indexWithintInitPhase<currentView[PREORDER_HOOK_FLAGS]>>16&&(currentView[FLAGS]&3)===initPhase){currentView[FLAGS]+=2048;profiler(4,directive,hook);try{hook.call(directive)}finally{profiler(5,directive,hook)}}}else{profiler(4,
directive,hook);try{hook.call(directive)}finally{profiler(5,directive,hook)}}}const NO_PARENT_INJECTOR=-1;class NodeInjectorFactory{constructor(factory,isViewProvider,injectImplementation){this.factory=factory;this.resolving=false;ngDevMode&&assertDefined(factory,"Factory not specified");ngDevMode&&assertEqual(typeof factory,"function","Expected factory function.");this.canSeeViewProviders=isViewProvider;this.injectImpl=injectImplementation}}function isFactory(obj){return obj instanceof NodeInjectorFactory}
function toTNodeTypeAsString(tNodeType){let text="";tNodeType&1&&(text+="|Text");tNodeType&2&&(text+="|Element");tNodeType&4&&(text+="|Container");tNodeType&8&&(text+="|ElementContainer");tNodeType&16&&(text+="|Projection");tNodeType&32&&(text+="|IcuContainer");tNodeType&64&&(text+="|Placeholder");return text.length>0?text.substring(1):text}function hasClassInput(tNode){return(tNode.flags&16)!==0}function hasStyleInput(tNode){return(tNode.flags&32)!==0}function assertTNodeType(tNode,expectedTypes,
message){assertDefined(tNode,"should be called with a TNode");if((tNode.type&expectedTypes)===0)throwError(message||`Expected [${toTNodeTypeAsString(expectedTypes)}] but got ${toTNodeTypeAsString(tNode.type)}.`)}function assertPureTNodeType(type){if(!(type===2||type===1||type===4||type===8||type===32||type===16||type===64))throwError(`Expected TNodeType to have only a single type selected, but got ${toTNodeTypeAsString(type)}.`)}function setUpAttributes(renderer,native,attrs){const isProc=isProceduralRenderer(renderer);
let i=0;while(i<attrs.length){const value=attrs[i];if(typeof value==="number"){if(value!==0)break;i++;const namespaceURI=attrs[i++];const attrName=attrs[i++];const attrVal=attrs[i++];ngDevMode&&ngDevMode.rendererSetAttribute++;isProc?renderer.setAttribute(native,attrName,attrVal,namespaceURI):native.setAttributeNS(namespaceURI,attrName,attrVal)}else{const attrName=value;const attrVal=attrs[++i];ngDevMode&&ngDevMode.rendererSetAttribute++;if(isAnimationProp(attrName)){if(isProc)renderer.setProperty(native,
attrName,attrVal)}else isProc?renderer.setAttribute(native,attrName,attrVal):native.setAttribute(attrName,attrVal);i++}}return i}function isNameOnlyAttributeMarker(marker){return marker===3||marker===4||marker===6}function isAnimationProp(name){return name.charCodeAt(0)===64}function mergeHostAttrs(dst,src){if(src===null||src.length===0);else if(dst===null||dst.length===0)dst=src.slice();else{let srcMarker=-1;for(let i=0;i<src.length;i++){const item=src[i];if(typeof item==="number")srcMarker=item;
else if(srcMarker===0);else if(srcMarker===-1||srcMarker===2)mergeHostAttribute(dst,srcMarker,item,null,src[++i]);else mergeHostAttribute(dst,srcMarker,item,null,null)}}return dst}function mergeHostAttribute(dst,marker,key1,key2,value){let i=0;let markerInsertPosition=dst.length;if(marker===-1)markerInsertPosition=-1;else while(i<dst.length){const dstValue=dst[i++];if(typeof dstValue==="number")if(dstValue===marker){markerInsertPosition=-1;break}else if(dstValue>marker){markerInsertPosition=i-1;break}}while(i<
dst.length){const item=dst[i];if(typeof item==="number")break;else if(item===key1)if(key2===null){if(value!==null)dst[i+1]=value;return}else if(key2===dst[i+1]){dst[i+2]=value;return}i++;if(key2!==null)i++;if(value!==null)i++}if(markerInsertPosition!==-1){dst.splice(markerInsertPosition,0,marker);i=markerInsertPosition+1}dst.splice(i++,0,key1);if(key2!==null)dst.splice(i++,0,key2);if(value!==null)dst.splice(i++,0,value)}function hasParentInjector(parentLocation){return parentLocation!==NO_PARENT_INJECTOR}
function getParentInjectorIndex(parentLocation){ngDevMode&&assertNumber(parentLocation,"Number expected");ngDevMode&&assertNotEqual(parentLocation,-1,"Not a valid state.");const parentInjectorIndex=parentLocation&32767;ngDevMode&&assertGreaterThan(parentInjectorIndex,HEADER_OFFSET,"Parent injector must be pointing past HEADER_OFFSET.");return parentLocation&32767}function getParentInjectorViewOffset(parentLocation){return parentLocation>>16}function getParentInjectorView(location,startView){let viewOffset=
getParentInjectorViewOffset(location);let parentView=startView;while(viewOffset>0){parentView=parentView[DECLARATION_VIEW];viewOffset--}return parentView}let includeViewProviders=true;function setIncludeViewProviders(v){const oldValue=includeViewProviders;includeViewProviders=v;return oldValue}const BLOOM_SIZE=256;const BLOOM_MASK=BLOOM_SIZE-1;const BLOOM_BUCKET_BITS=5;let nextNgElementId=0;function bloomAdd(injectorIndex,tView,type){ngDevMode&&assertEqual(tView.firstCreatePass,true,"expected firstCreatePass to be true");
let id;if(typeof type==="string")id=type.charCodeAt(0)||0;else if(type.hasOwnProperty(NG_ELEMENT_ID))id=type[NG_ELEMENT_ID];if(id==null)id=type[NG_ELEMENT_ID]=nextNgElementId++;const bloomHash=id&BLOOM_MASK;const mask=1<<bloomHash;tView.data[injectorIndex+(bloomHash>>BLOOM_BUCKET_BITS)]|=mask}function getOrCreateNodeInjectorForNode(tNode,lView){const existingInjectorIndex=getInjectorIndex(tNode,lView);if(existingInjectorIndex!==-1)return existingInjectorIndex;const tView=lView[TVIEW];if(tView.firstCreatePass){tNode.injectorIndex=
lView.length;insertBloom(tView.data,tNode);insertBloom(lView,null);insertBloom(tView.blueprint,null)}const parentLoc=getParentInjectorLocation(tNode,lView);const injectorIndex=tNode.injectorIndex;if(hasParentInjector(parentLoc)){const parentIndex=getParentInjectorIndex(parentLoc);const parentLView=getParentInjectorView(parentLoc,lView);const parentData=parentLView[TVIEW].data;for(let i=0;i<8;i++)lView[injectorIndex+i]=parentLView[parentIndex+i]|parentData[parentIndex+i]}lView[injectorIndex+8]=parentLoc;
return injectorIndex}function insertBloom(arr,footer){arr.push(0,0,0,0,0,0,0,0,footer)}function getInjectorIndex(tNode,lView){if(tNode.injectorIndex===-1||tNode.parent&&tNode.parent.injectorIndex===tNode.injectorIndex||lView[tNode.injectorIndex+8]===null)return-1;else{ngDevMode&&assertIndexInRange(lView,tNode.injectorIndex);return tNode.injectorIndex}}function getParentInjectorLocation(tNode,lView){if(tNode.parent&&tNode.parent.injectorIndex!==-1)return tNode.parent.injectorIndex;let declarationViewOffset=
0;let parentTNode=null;let lViewCursor=lView;while(lViewCursor!==null){const tView=lViewCursor[TVIEW];const tViewType=tView.type;if(tViewType===2){ngDevMode&&assertDefined(tView.declTNode,"Embedded TNodes should have declaration parents.");parentTNode=tView.declTNode}else if(tViewType===1)parentTNode=lViewCursor[T_HOST];else{ngDevMode&&assertEqual(tView.type,0,"Root type expected");parentTNode=null}if(parentTNode===null)return NO_PARENT_INJECTOR;ngDevMode&&parentTNode&&assertTNodeForLView(parentTNode,
lViewCursor[DECLARATION_VIEW]);declarationViewOffset++;lViewCursor=lViewCursor[DECLARATION_VIEW];if(parentTNode.injectorIndex!==-1)return parentTNode.injectorIndex|declarationViewOffset<<16}return NO_PARENT_INJECTOR}function diPublicInInjector(injectorIndex,tView,token){bloomAdd(injectorIndex,tView,token)}function injectAttributeImpl(tNode,attrNameToInject){ngDevMode&&assertTNodeType(tNode,12|3);ngDevMode&&assertDefined(tNode,"expecting tNode");if(attrNameToInject==="class")return tNode.classes;if(attrNameToInject===
"style")return tNode.styles;const attrs=tNode.attrs;if(attrs){const attrsLength=attrs.length;let i=0;while(i<attrsLength){const value=attrs[i];if(isNameOnlyAttributeMarker(value))break;if(value===0)i=i+2;else if(typeof value==="number"){i++;while(i<attrsLength&&typeof attrs[i]==="string")i++}else if(value===attrNameToInject)return attrs[i+1];else i=i+2}}return null}function notFoundValueOrThrow(notFoundValue,token,flags){if(flags&exports.InjectFlags.Optional)return notFoundValue;else throwProviderNotFoundError(token,
"NodeInjector")}function lookupTokenUsingModuleInjector(lView,token,flags,notFoundValue){if(flags&exports.InjectFlags.Optional&&notFoundValue===undefined)notFoundValue=null;if((flags&(exports.InjectFlags.Self|exports.InjectFlags.Host))===0){const moduleInjector=lView[INJECTOR$1];const previousInjectImplementation=setInjectImplementation(undefined);try{if(moduleInjector)return moduleInjector.get(token,notFoundValue,flags&exports.InjectFlags.Optional);else return injectRootLimpMode(token,notFoundValue,
flags&exports.InjectFlags.Optional)}finally{setInjectImplementation(previousInjectImplementation)}}return notFoundValueOrThrow(notFoundValue,token,flags)}function getOrCreateInjectable(tNode,lView,token,flags=exports.InjectFlags.Default,notFoundValue){if(tNode!==null){const bloomHash=bloomHashBitOrFactory(token);if(typeof bloomHash==="function"){if(!enterDI(lView,tNode,flags))return flags&exports.InjectFlags.Host?notFoundValueOrThrow(notFoundValue,token,flags):lookupTokenUsingModuleInjector(lView,
token,flags,notFoundValue);try{const value=bloomHash(flags);if(value==null&&!(flags&exports.InjectFlags.Optional))throwProviderNotFoundError(token);else return value}finally{leaveDI()}}else if(typeof bloomHash==="number"){let previousTView=null;let injectorIndex=getInjectorIndex(tNode,lView);let parentLocation=NO_PARENT_INJECTOR;let hostTElementNode=flags&exports.InjectFlags.Host?lView[DECLARATION_COMPONENT_VIEW][T_HOST]:null;if(injectorIndex===-1||flags&exports.InjectFlags.SkipSelf){parentLocation=
injectorIndex===-1?getParentInjectorLocation(tNode,lView):lView[injectorIndex+8];if(parentLocation===NO_PARENT_INJECTOR||!shouldSearchParent(flags,false))injectorIndex=-1;else{previousTView=lView[TVIEW];injectorIndex=getParentInjectorIndex(parentLocation);lView=getParentInjectorView(parentLocation,lView)}}while(injectorIndex!==-1){ngDevMode&&assertNodeInjector(lView,injectorIndex);const tView=lView[TVIEW];ngDevMode&&assertTNodeForLView(tView.data[injectorIndex+8],lView);if(bloomHasToken(bloomHash,
injectorIndex,tView.data)){const instance=searchTokensOnInjector(injectorIndex,lView,token,previousTView,flags,hostTElementNode);if(instance!==NOT_FOUND)return instance}parentLocation=lView[injectorIndex+8];if(parentLocation!==NO_PARENT_INJECTOR&&shouldSearchParent(flags,lView[TVIEW].data[injectorIndex+8]===hostTElementNode)&&bloomHasToken(bloomHash,injectorIndex,lView)){previousTView=tView;injectorIndex=getParentInjectorIndex(parentLocation);lView=getParentInjectorView(parentLocation,lView)}else injectorIndex=
-1}}}return lookupTokenUsingModuleInjector(lView,token,flags,notFoundValue)}const NOT_FOUND={};function createNodeInjector(){return new NodeInjector(getCurrentTNode(),getLView())}function searchTokensOnInjector(injectorIndex,lView,token,previousTView,flags,hostTElementNode){const currentTView=lView[TVIEW];const tNode=currentTView.data[injectorIndex+8];const canAccessViewProviders=previousTView==null?isComponentHost(tNode)&&includeViewProviders:previousTView!=currentTView&&(tNode.type&3)!==0;const isHostSpecialCase=
flags&exports.InjectFlags.Host&&hostTElementNode===tNode;const injectableIdx=locateDirectiveOrProvider(tNode,currentTView,token,canAccessViewProviders,isHostSpecialCase);if(injectableIdx!==null)return getNodeInjectable(lView,currentTView,injectableIdx,tNode);else return NOT_FOUND}function locateDirectiveOrProvider(tNode,tView,token,canAccessViewProviders,isHostSpecialCase){const nodeProviderIndexes=tNode.providerIndexes;const tInjectables=tView.data;const injectablesStart=nodeProviderIndexes&1048575;
const directivesStart=tNode.directiveStart;const directiveEnd=tNode.directiveEnd;const cptViewProvidersCount=nodeProviderIndexes>>20;const startingIndex=canAccessViewProviders?injectablesStart:injectablesStart+cptViewProvidersCount;const endIndex=isHostSpecialCase?injectablesStart+cptViewProvidersCount:directiveEnd;for(let i=startingIndex;i<endIndex;i++){const providerTokenOrDef=tInjectables[i];if(i<directivesStart&&token===providerTokenOrDef||i>=directivesStart&&providerTokenOrDef.type===token)return i}if(isHostSpecialCase){const dirDef=
tInjectables[directivesStart];if(dirDef&&isComponentDef(dirDef)&&dirDef.type===token)return directivesStart}return null}function getNodeInjectable(lView,tView,index,tNode){let value=lView[index];const tData=tView.data;if(isFactory(value)){const factory=value;if(factory.resolving)throwCyclicDependencyError(stringifyForError(tData[index]));const previousIncludeViewProviders=setIncludeViewProviders(factory.canSeeViewProviders);factory.resolving=true;const previousInjectImplementation=factory.injectImpl?
setInjectImplementation(factory.injectImpl):null;const success=enterDI(lView,tNode,exports.InjectFlags.Default);ngDevMode&&assertEqual(success,true,"Because flags do not contain `SkipSelf' we expect this to always succeed.");try{value=lView[index]=factory.factory(undefined,tData,lView,tNode);if(tView.firstCreatePass&&index>=tNode.directiveStart){ngDevMode&&assertDirectiveDef(tData[index]);registerPreOrderHooks(index,tData[index],tView)}}finally{previousInjectImplementation!==null&&setInjectImplementation(previousInjectImplementation);
setIncludeViewProviders(previousIncludeViewProviders);factory.resolving=false;leaveDI()}}return value}function bloomHashBitOrFactory(token){ngDevMode&&assertDefined(token,"token must be defined");if(typeof token==="string")return token.charCodeAt(0)||0;const tokenId=token.hasOwnProperty(NG_ELEMENT_ID)?token[NG_ELEMENT_ID]:undefined;if(typeof tokenId==="number")if(tokenId>=0)return tokenId&BLOOM_MASK;else{ngDevMode&&assertEqual(tokenId,-1,"Expecting to get Special Injector Id");return createNodeInjector}else return tokenId}
function bloomHasToken(bloomHash,injectorIndex,injectorView){const mask=1<<bloomHash;const value=injectorView[injectorIndex+(bloomHash>>BLOOM_BUCKET_BITS)];return!!(value&mask)}function shouldSearchParent(flags,isFirstHostTNode){return!(flags&exports.InjectFlags.Self)&&!(flags&exports.InjectFlags.Host&&isFirstHostTNode)}class NodeInjector{constructor(_tNode,_lView){this._tNode=_tNode;this._lView=_lView}get(token,notFoundValue,flags){return getOrCreateInjectable(this._tNode,this._lView,token,flags,
notFoundValue)}}function \u0275\u0275getInheritedFactory(type){return noSideEffects(()=>{const ownConstructor=type.prototype.constructor;const ownFactory=ownConstructor[NG_FACTORY_DEF]||getFactoryOf(ownConstructor);const objectPrototype=Object.prototype;let parent=Object.getPrototypeOf(type.prototype).constructor;while(parent&&parent!==objectPrototype){const factory=parent[NG_FACTORY_DEF]||getFactoryOf(parent);if(factory&&factory!==ownFactory)return factory;parent=Object.getPrototypeOf(parent)}return t=>
new t})}function getFactoryOf(type){if(isForwardRef(type))return()=>{const factory=getFactoryOf(resolveForwardRef(type));return factory&&factory()};return getFactoryDef(type)}function \u0275\u0275injectAttribute(attrNameToInject){return injectAttributeImpl(getCurrentTNode(),attrNameToInject)}const ANNOTATIONS="__annotations__";const PARAMETERS="__parameters__";const PROP_METADATA="__prop__metadata__";function makeDecorator(name,props,parentClass,additionalProcessing,typeFn){return noSideEffects(()=>
{const metaCtor=makeMetadataCtor(props);function DecoratorFactory(...args){if(this instanceof DecoratorFactory){metaCtor.call(this,...args);return this}const annotationInstance=new DecoratorFactory(...args);return function TypeDecorator(cls){if(typeFn)typeFn(cls,...args);const annotations=cls.hasOwnProperty(ANNOTATIONS)?cls[ANNOTATIONS]:Object.defineProperty(cls,ANNOTATIONS,{value:[]})[ANNOTATIONS];annotations.push(annotationInstance);if(additionalProcessing)additionalProcessing(cls);return cls}}
if(parentClass)DecoratorFactory.prototype=Object.create(parentClass.prototype);DecoratorFactory.prototype.ngMetadataName=name;DecoratorFactory.annotationCls=DecoratorFactory;return DecoratorFactory})}function makeMetadataCtor(props){return function ctor(...args){if(props){const values=props(...args);for(const propName in values)this[propName]=values[propName]}}}function makeParamDecorator(name,props,parentClass){return noSideEffects(()=>{const metaCtor=makeMetadataCtor(props);function ParamDecoratorFactory(...args){if(this instanceof
ParamDecoratorFactory){metaCtor.apply(this,args);return this}const annotationInstance=new ParamDecoratorFactory(...args);ParamDecorator.annotation=annotationInstance;return ParamDecorator;function ParamDecorator(cls,unusedKey,index){const parameters=cls.hasOwnProperty(PARAMETERS)?cls[PARAMETERS]:Object.defineProperty(cls,PARAMETERS,{value:[]})[PARAMETERS];while(parameters.length<=index)parameters.push(null);(parameters[index]=parameters[index]||[]).push(annotationInstance);return cls}}if(parentClass)ParamDecoratorFactory.prototype=
Object.create(parentClass.prototype);ParamDecoratorFactory.prototype.ngMetadataName=name;ParamDecoratorFactory.annotationCls=ParamDecoratorFactory;return ParamDecoratorFactory})}function makePropDecorator(name,props,parentClass,additionalProcessing){return noSideEffects(()=>{const metaCtor=makeMetadataCtor(props);function PropDecoratorFactory(...args){if(this instanceof PropDecoratorFactory){metaCtor.apply(this,args);return this}const decoratorInstance=new PropDecoratorFactory(...args);function PropDecorator(target,
name){const constructor=target.constructor;const meta=constructor.hasOwnProperty(PROP_METADATA)?constructor[PROP_METADATA]:Object.defineProperty(constructor,PROP_METADATA,{value:{}})[PROP_METADATA];meta[name]=meta.hasOwnProperty(name)&&meta[name]||[];meta[name].unshift(decoratorInstance);if(additionalProcessing)additionalProcessing(target,name,...args)}return PropDecorator}if(parentClass)PropDecoratorFactory.prototype=Object.create(parentClass.prototype);PropDecoratorFactory.prototype.ngMetadataName=
name;PropDecoratorFactory.annotationCls=PropDecoratorFactory;return PropDecoratorFactory})}const Attribute=makeParamDecorator("Attribute",attributeName=>({attributeName,__NG_ELEMENT_ID__:()=>\u0275\u0275injectAttribute(attributeName)}));class InjectionToken{constructor(_desc,options){this._desc=_desc;this.ngMetadataName="InjectionToken";this.\u0275prov=undefined;if(typeof options=="number"){(typeof ngDevMode==="undefined"||ngDevMode)&&assertLessThan(options,0,"Only negative numbers are supported here");
this.__NG_ELEMENT_ID__=options}else if(options!==undefined)this.\u0275prov=\u0275\u0275defineInjectable({token:this,providedIn:options.providedIn||"root",factory:options.factory})}toString(){return`InjectionToken ${this._desc}`}}const ANALYZE_FOR_ENTRY_COMPONENTS=new InjectionToken("AnalyzeForEntryComponents");const emitDistinctChangesOnlyDefaultValue=true;class Query{}const ContentChildren=makePropDecorator("ContentChildren",(selector,data={})=>Object.assign({selector,first:false,isViewQuery:false,
descendants:false,emitDistinctChangesOnly:emitDistinctChangesOnlyDefaultValue},data),Query);const ContentChild=makePropDecorator("ContentChild",(selector,data={})=>Object.assign({selector,first:true,isViewQuery:false,descendants:true},data),Query);const ViewChildren=makePropDecorator("ViewChildren",(selector,data={})=>Object.assign({selector,first:false,isViewQuery:true,descendants:true,emitDistinctChangesOnly:emitDistinctChangesOnlyDefaultValue},data),Query);const ViewChild=makePropDecorator("ViewChild",
(selector,data)=>Object.assign({selector,first:true,isViewQuery:true,descendants:true},data),Query);exports["ɵɵFactoryTarget"]=void 0;(function(FactoryTarget){FactoryTarget[FactoryTarget["Directive"]=0]="Directive";FactoryTarget[FactoryTarget["Component"]=1]="Component";FactoryTarget[FactoryTarget["Injectable"]=2]="Injectable";FactoryTarget[FactoryTarget["Pipe"]=3]="Pipe";FactoryTarget[FactoryTarget["NgModule"]=4]="NgModule"})(exports["ɵɵFactoryTarget"]||(exports["ɵɵFactoryTarget"]={}));var ViewEncapsulation;
(function(ViewEncapsulation){ViewEncapsulation[ViewEncapsulation["Emulated"]=0]="Emulated";ViewEncapsulation[ViewEncapsulation["None"]=2]="None";ViewEncapsulation[ViewEncapsulation["ShadowDom"]=3]="ShadowDom"})(ViewEncapsulation||(ViewEncapsulation={}));function getCompilerFacade(request){const globalNg=_global["ng"];if(globalNg&&globalNg.\u0275compilerFacade)return globalNg.\u0275compilerFacade;if(typeof ngDevMode==="undefined"||ngDevMode){console.error(`JIT compilation failed for ${request.kind}`,
request.type);let message=`The ${request.kind} '${request.type.name}' needs to be compiled using the JIT compiler, but '@angular/compiler' is not available.\n\n`;if(request.usage===1){message+=`The ${request.kind} is part of a library that has been partially compiled.\n`;message+=`However, the Angular Linker has not processed the library such that JIT compilation is used as fallback.\n`;message+="\n";message+=`Ideally, the library is processed using the Angular Linker to become fully AOT compiled.\n`}else message+=
`JIT compilation is discouraged for production use-cases! Consider using AOT mode instead.\n`;message+=`Alternatively, the JIT compiler should be loaded by bootstrapping using '@angular/platform-browser-dynamic' or '@angular/platform-server',\n`;message+=`or manually provide the compiler with 'import "@angular/compiler";' before bootstrapping.`;throw new Error(message);}else throw new Error("JIT compiler unavailable");}const Type=Function;function isType(v){return typeof v==="function"}function arrayEquals(a,
b,identityAccessor){if(a.length!==b.length)return false;for(let i=0;i<a.length;i++){let valueA=a[i];let valueB=b[i];if(identityAccessor){valueA=identityAccessor(valueA);valueB=identityAccessor(valueB)}if(valueB!==valueA)return false}return true}function flatten(list,dst){if(dst===undefined)dst=list;for(let i=0;i<list.length;i++){let item=list[i];if(Array.isArray(item)){if(dst===list)dst=list.slice(0,i);flatten(item,dst)}else if(dst!==list)dst.push(item)}return dst}function deepForEach(input,fn){input.forEach(value=>
Array.isArray(value)?deepForEach(value,fn):fn(value))}function addToArray(arr,index,value){if(index>=arr.length)arr.push(value);else arr.splice(index,0,value)}function removeFromArray(arr,index){if(index>=arr.length-1)return arr.pop();else return arr.splice(index,1)[0]}function newArray(size,value){const list=[];for(let i=0;i<size;i++)list.push(value);return list}function arrayInsert2(array,index,value1,value2){ngDevMode&&assertLessThanOrEqual(index,array.length,"Can't insert past array end.");let end=
array.length;if(end==index)array.push(value1,value2);else if(end===1){array.push(value2,array[0]);array[0]=value1}else{end--;array.push(array[end-1],array[end]);while(end>index){const previousEnd=end-2;array[end]=array[previousEnd];end--}array[index]=value1;array[index+1]=value2}}function keyValueArraySet(keyValueArray,key,value){let index=keyValueArrayIndexOf(keyValueArray,key);if(index>=0)keyValueArray[index|1]=value;else{index=~index;arrayInsert2(keyValueArray,index,key,value)}return index}function keyValueArrayGet(keyValueArray,
key){const index=keyValueArrayIndexOf(keyValueArray,key);if(index>=0)return keyValueArray[index|1];return undefined}function keyValueArrayIndexOf(keyValueArray,key){return _arrayIndexOfSorted(keyValueArray,key,1)}function _arrayIndexOfSorted(array,value,shift){ngDevMode&&assertEqual(Array.isArray(array),true,"Expecting an array");let start=0;let end=array.length>>shift;while(end!==start){const middle=start+(end-start>>1);const current=array[middle<<shift];if(value===current)return middle<<shift;else if(current>
value)end=middle;else start=middle+1}return~(end<<shift)}const ES5_DELEGATE_CTOR=/^function\s+\S+\(\)\s*{[\s\S]+\.apply\(this,\s*(arguments|(?:[^()]+\(\[\],)?[^()]+\(arguments\).*)\)/;const ES2015_INHERITED_CLASS=/^class\s+[A-Za-z\d$_]*\s*extends\s+[^{]+{/;const ES2015_INHERITED_CLASS_WITH_CTOR=/^class\s+[A-Za-z\d$_]*\s*extends\s+[^{]+{[\s\S]*constructor\s*\(/;const ES2015_INHERITED_CLASS_WITH_DELEGATE_CTOR=/^class\s+[A-Za-z\d$_]*\s*extends\s+[^{]+{[\s\S]*constructor\s*\(\)\s*{\s*super\(\.\.\.arguments\)/;
function isDelegateCtor(typeStr){return ES5_DELEGATE_CTOR.test(typeStr)||ES2015_INHERITED_CLASS_WITH_DELEGATE_CTOR.test(typeStr)||ES2015_INHERITED_CLASS.test(typeStr)&&!ES2015_INHERITED_CLASS_WITH_CTOR.test(typeStr)}class ReflectionCapabilities{constructor(reflect){this._reflect=reflect||_global["Reflect"]}isReflectionEnabled(){return true}factory(t){return(...args)=>new t(...args)}_zipTypesAndAnnotations(paramTypes,paramAnnotations){let result;if(typeof paramTypes==="undefined")result=newArray(paramAnnotations.length);
else result=newArray(paramTypes.length);for(let i=0;i<result.length;i++){if(typeof paramTypes==="undefined")result[i]=[];else if(paramTypes[i]&&paramTypes[i]!=Object)result[i]=[paramTypes[i]];else result[i]=[];if(paramAnnotations&&paramAnnotations[i]!=null)result[i]=result[i].concat(paramAnnotations[i])}return result}_ownParameters(type,parentCtor){const typeStr=type.toString();if(isDelegateCtor(typeStr))return null;if(type.parameters&&type.parameters!==parentCtor.parameters)return type.parameters;
const tsickleCtorParams=type.ctorParameters;if(tsickleCtorParams&&tsickleCtorParams!==parentCtor.ctorParameters){const ctorParameters=typeof tsickleCtorParams==="function"?tsickleCtorParams():tsickleCtorParams;const paramTypes=ctorParameters.map(ctorParam=>ctorParam&&ctorParam.type);const paramAnnotations=ctorParameters.map(ctorParam=>ctorParam&&convertTsickleDecoratorIntoMetadata(ctorParam.decorators));return this._zipTypesAndAnnotations(paramTypes,paramAnnotations)}const paramAnnotations=type.hasOwnProperty(PARAMETERS)&&
type[PARAMETERS];const paramTypes=this._reflect&&this._reflect.getOwnMetadata&&this._reflect.getOwnMetadata("design:paramtypes",type);if(paramTypes||paramAnnotations)return this._zipTypesAndAnnotations(paramTypes,paramAnnotations);return newArray(type.length)}parameters(type){if(!isType(type))return[];const parentCtor=getParentCtor(type);let parameters=this._ownParameters(type,parentCtor);if(!parameters&&parentCtor!==Object)parameters=this.parameters(parentCtor);return parameters||[]}_ownAnnotations(typeOrFunc,
parentCtor){if(typeOrFunc.annotations&&typeOrFunc.annotations!==parentCtor.annotations){let annotations=typeOrFunc.annotations;if(typeof annotations==="function"&&annotations.annotations)annotations=annotations.annotations;return annotations}if(typeOrFunc.decorators&&typeOrFunc.decorators!==parentCtor.decorators)return convertTsickleDecoratorIntoMetadata(typeOrFunc.decorators);if(typeOrFunc.hasOwnProperty(ANNOTATIONS))return typeOrFunc[ANNOTATIONS];return null}annotations(typeOrFunc){if(!isType(typeOrFunc))return[];
const parentCtor=getParentCtor(typeOrFunc);const ownAnnotations=this._ownAnnotations(typeOrFunc,parentCtor)||[];const parentAnnotations=parentCtor!==Object?this.annotations(parentCtor):[];return parentAnnotations.concat(ownAnnotations)}_ownPropMetadata(typeOrFunc,parentCtor){if(typeOrFunc.propMetadata&&typeOrFunc.propMetadata!==parentCtor.propMetadata){let propMetadata=typeOrFunc.propMetadata;if(typeof propMetadata==="function"&&propMetadata.propMetadata)propMetadata=propMetadata.propMetadata;return propMetadata}if(typeOrFunc.propDecorators&&
typeOrFunc.propDecorators!==parentCtor.propDecorators){const propDecorators=typeOrFunc.propDecorators;const propMetadata={};Object.keys(propDecorators).forEach(prop=>{propMetadata[prop]=convertTsickleDecoratorIntoMetadata(propDecorators[prop])});return propMetadata}if(typeOrFunc.hasOwnProperty(PROP_METADATA))return typeOrFunc[PROP_METADATA];return null}propMetadata(typeOrFunc){if(!isType(typeOrFunc))return{};const parentCtor=getParentCtor(typeOrFunc);const propMetadata={};if(parentCtor!==Object){const parentPropMetadata=
this.propMetadata(parentCtor);Object.keys(parentPropMetadata).forEach(propName=>{propMetadata[propName]=parentPropMetadata[propName]})}const ownPropMetadata=this._ownPropMetadata(typeOrFunc,parentCtor);if(ownPropMetadata)Object.keys(ownPropMetadata).forEach(propName=>{const decorators=[];if(propMetadata.hasOwnProperty(propName))decorators.push(...propMetadata[propName]);decorators.push(...ownPropMetadata[propName]);propMetadata[propName]=decorators});return propMetadata}ownPropMetadata(typeOrFunc){if(!isType(typeOrFunc))return{};
return this._ownPropMetadata(typeOrFunc,getParentCtor(typeOrFunc))||{}}hasLifecycleHook(type,lcProperty){return type instanceof Type&&lcProperty in type.prototype}guards(type){return{}}getter(name){return new Function("o","return o."+name+";")}setter(name){return new Function("o","v","return o."+name+" = v;")}method(name){const functionBody=`if (!o.${name}) throw new Error('"${name}" is undefined');
        return o.${name}.apply(o, args);`;return new Function("o","args",functionBody)}importUri(type){if(typeof type==="object"&&type["filePath"])return type["filePath"];return`./${stringify(type)}`}resourceUri(type){return`./${stringify(type)}`}resolveIdentifier(name,moduleUrl,members,runtime){return runtime}resolveEnum(enumIdentifier,name){return enumIdentifier[name]}}function convertTsickleDecoratorIntoMetadata(decoratorInvocations){if(!decoratorInvocations)return[];return decoratorInvocations.map(decoratorInvocation=>
{const decoratorType=decoratorInvocation.type;const annotationCls=decoratorType.annotationCls;const annotationArgs=decoratorInvocation.args?decoratorInvocation.args:[];return new annotationCls(...annotationArgs)})}function getParentCtor(ctor){const parentProto=ctor.prototype?Object.getPrototypeOf(ctor.prototype):null;const parentCtor=parentProto?parentProto.constructor:null;return parentCtor||Object}const _THROW_IF_NOT_FOUND={};const THROW_IF_NOT_FOUND=_THROW_IF_NOT_FOUND;const DI_DECORATOR_FLAG=
"__NG_DI_FLAG__";const NG_TEMP_TOKEN_PATH="ngTempTokenPath";const NG_TOKEN_PATH="ngTokenPath";const NEW_LINE=/\n/gm;const NO_NEW_LINE="ɵ";const SOURCE="__source";const USE_VALUE$1=getClosureSafeProperty({provide:String,useValue:getClosureSafeProperty});let _currentInjector=undefined;function setCurrentInjector(injector){const former=_currentInjector;_currentInjector=injector;return former}function injectInjectorOnly(token,flags=exports.InjectFlags.Default){if(_currentInjector===undefined){const errorMessage=
typeof ngDevMode==="undefined"||ngDevMode?`inject() must be called from an injection context`:"";throw new RuntimeError(203,errorMessage);}else if(_currentInjector===null)return injectRootLimpMode(token,undefined,flags);else return _currentInjector.get(token,flags&exports.InjectFlags.Optional?null:undefined,flags)}function \u0275\u0275inject(token,flags=exports.InjectFlags.Default){return(getInjectImplementation()||injectInjectorOnly)(resolveForwardRef(token),flags)}function \u0275\u0275invalidFactoryDep(index){const msg=
ngDevMode?`This constructor is not compatible with Angular Dependency Injection because its dependency at index ${index} of the parameter list is invalid.
This can happen if the dependency type is a primitive like a string or if an ancestor of this class is missing an Angular decorator.

Please check that 1) the type for the parameter at index ${index} is correct and 2) the correct Angular decorators are defined for this class and its ancestors.`:"invalid";throw new Error(msg);}const inject=\u0275\u0275inject;function injectArgs(types){const args=[];for(let i=0;i<types.length;i++){const arg=resolveForwardRef(types[i]);if(Array.isArray(arg)){if(arg.length===0){const errorMessage=typeof ngDevMode==="undefined"||ngDevMode?"Arguments array must have arguments.":"";throw new RuntimeError(900,
errorMessage);}let type=undefined;let flags=exports.InjectFlags.Default;for(let j=0;j<arg.length;j++){const meta=arg[j];const flag=getInjectFlag(meta);if(typeof flag==="number")if(flag===-1)type=meta.token;else flags|=flag;else type=meta}args.push(\u0275\u0275inject(type,flags))}else args.push(\u0275\u0275inject(arg))}return args}function attachInjectFlag(decorator,flag){decorator[DI_DECORATOR_FLAG]=flag;decorator.prototype[DI_DECORATOR_FLAG]=flag;return decorator}function getInjectFlag(token){return token[DI_DECORATOR_FLAG]}
function catchInjectorError(e,token,injectorErrorName,source){const tokenPath=e[NG_TEMP_TOKEN_PATH];if(token[SOURCE])tokenPath.unshift(token[SOURCE]);e.message=formatError("\n"+e.message,tokenPath,injectorErrorName,source);e[NG_TOKEN_PATH]=tokenPath;e[NG_TEMP_TOKEN_PATH]=null;throw e;}function formatError(text,obj,injectorErrorName,source=null){text=text&&text.charAt(0)==="\n"&&text.charAt(1)==NO_NEW_LINE?text.substr(2):text;let context=stringify(obj);if(Array.isArray(obj))context=obj.map(stringify).join(" -> ");
else if(typeof obj==="object"){let parts=[];for(let key in obj)if(obj.hasOwnProperty(key)){let value=obj[key];parts.push(key+":"+(typeof value==="string"?JSON.stringify(value):stringify(value)))}context=`{${parts.join(", ")}}`}return`${injectorErrorName}${source?"("+source+")":""}[${context}]: ${text.replace(NEW_LINE,"\n  ")}`}const Inject=attachInjectFlag(makeParamDecorator("Inject",token=>({token})),-1);const Optional=attachInjectFlag(makeParamDecorator("Optional"),8);const Self=attachInjectFlag(makeParamDecorator("Self"),
2);const SkipSelf=attachInjectFlag(makeParamDecorator("SkipSelf"),4);const Host=attachInjectFlag(makeParamDecorator("Host"),1);let _reflect=null;function getReflect(){return _reflect=_reflect||new ReflectionCapabilities}function reflectDependencies(type){return convertDependencies(getReflect().parameters(type))}function convertDependencies(deps){return deps.map(dep=>reflectDependency(dep))}function reflectDependency(dep){const meta={token:null,attribute:null,host:false,optional:false,self:false,skipSelf:false};
if(Array.isArray(dep)&&dep.length>0)for(let j=0;j<dep.length;j++){const param=dep[j];if(param===undefined)continue;const proto=Object.getPrototypeOf(param);if(param instanceof Optional||proto.ngMetadataName==="Optional")meta.optional=true;else if(param instanceof SkipSelf||proto.ngMetadataName==="SkipSelf")meta.skipSelf=true;else if(param instanceof Self||proto.ngMetadataName==="Self")meta.self=true;else if(param instanceof Host||proto.ngMetadataName==="Host")meta.host=true;else if(param instanceof
Inject)meta.token=param.token;else if(param instanceof Attribute){if(param.attributeName===undefined)throw new Error(`Attribute name must be defined.`);meta.attribute=param.attributeName}else meta.token=param}else if(dep===undefined||Array.isArray(dep)&&dep.length===0)meta.token=null;else meta.token=dep;return meta}function resolveComponentResources(resourceResolver){const componentResolved=[];const urlMap=new Map;function cachedResourceResolve(url){let promise=urlMap.get(url);if(!promise){const resp=
resourceResolver(url);urlMap.set(url,promise=resp.then(unwrapResponse))}return promise}componentResourceResolutionQueue.forEach((component,type)=>{const promises=[];if(component.templateUrl)promises.push(cachedResourceResolve(component.templateUrl).then(template=>{component.template=template}));const styleUrls=component.styleUrls;const styles=component.styles||(component.styles=[]);const styleOffset=component.styles.length;styleUrls&&styleUrls.forEach((styleUrl,index)=>{styles.push("");promises.push(cachedResourceResolve(styleUrl).then(style=>
{styles[styleOffset+index]=style;styleUrls.splice(styleUrls.indexOf(styleUrl),1);if(styleUrls.length==0)component.styleUrls=undefined}))});const fullyResolved=Promise.all(promises).then(()=>componentDefResolved(type));componentResolved.push(fullyResolved)});clearResolutionOfComponentResourcesQueue();return Promise.all(componentResolved).then(()=>undefined)}let componentResourceResolutionQueue=new Map;const componentDefPendingResolution=new Set;function maybeQueueResolutionOfComponentResources(type,
metadata){if(componentNeedsResolution(metadata)){componentResourceResolutionQueue.set(type,metadata);componentDefPendingResolution.add(type)}}function componentNeedsResolution(component){return!!(component.templateUrl&&!component.hasOwnProperty("template")||component.styleUrls&&component.styleUrls.length)}function clearResolutionOfComponentResourcesQueue(){const old=componentResourceResolutionQueue;componentResourceResolutionQueue=new Map;return old}function isComponentResourceResolutionQueueEmpty(){return componentResourceResolutionQueue.size===
0}function unwrapResponse(response){return typeof response=="string"?response:response.text()}function componentDefResolved(type){componentDefPendingResolution.delete(type)}let policy$1;function getPolicy$1(){if(policy$1===undefined){policy$1=null;if(_global.trustedTypes)try{policy$1=_global.trustedTypes.createPolicy("angular",{createHTML:s=>s,createScript:s=>s,createScriptURL:s=>s})}catch(_a){}}return policy$1}function trustedHTMLFromString(html){var _a;return((_a=getPolicy$1())===null||_a===void 0?
void 0:_a.createHTML(html))||html}function trustedScriptFromString(script){var _a;return((_a=getPolicy$1())===null||_a===void 0?void 0:_a.createScript(script))||script}function trustedScriptURLFromString(url){var _a;return((_a=getPolicy$1())===null||_a===void 0?void 0:_a.createScriptURL(url))||url}function newTrustedFunctionForDev(...args){if(typeof ngDevMode==="undefined")throw new Error("newTrustedFunctionForDev should never be called in production");if(!_global.trustedTypes)return new Function(...args);
const fnArgs=args.slice(0,-1).join(",");const fnBody=args[args.length-1];const body=`(function anonymous(${fnArgs}
) { ${fnBody}
})`;const fn=_global["eval"](trustedScriptFromString(body));if(fn.bind===undefined)return new Function(...args);fn.toString=()=>body;return fn.bind(_global)}let policy;function getPolicy(){if(policy===undefined){policy=null;if(_global.trustedTypes)try{policy=_global.trustedTypes.createPolicy("angular#unsafe-bypass",{createHTML:s=>s,createScript:s=>s,createScriptURL:s=>s})}catch(_a){}}return policy}function trustedHTMLFromStringBypass(html){var _a;return((_a=getPolicy())===null||_a===void 0?void 0:
_a.createHTML(html))||html}function trustedScriptFromStringBypass(script){var _a;return((_a=getPolicy())===null||_a===void 0?void 0:_a.createScript(script))||script}function trustedScriptURLFromStringBypass(url){var _a;return((_a=getPolicy())===null||_a===void 0?void 0:_a.createScriptURL(url))||url}class SafeValueImpl{constructor(changingThisBreaksApplicationSecurity){this.changingThisBreaksApplicationSecurity=changingThisBreaksApplicationSecurity}toString(){return`SafeValue must use [property]=binding: ${this.changingThisBreaksApplicationSecurity}`+
` (see https://g.co/ng/security#xss)`}}class SafeHtmlImpl extends SafeValueImpl{getTypeName(){return"HTML"}}class SafeStyleImpl extends SafeValueImpl{getTypeName(){return"Style"}}class SafeScriptImpl extends SafeValueImpl{getTypeName(){return"Script"}}class SafeUrlImpl extends SafeValueImpl{getTypeName(){return"URL"}}class SafeResourceUrlImpl extends SafeValueImpl{getTypeName(){return"ResourceURL"}}function unwrapSafeValue(value){return value instanceof SafeValueImpl?value.changingThisBreaksApplicationSecurity:
value}function allowSanitizationBypassAndThrow(value,type){const actualType=getSanitizationBypassType(value);if(actualType!=null&&actualType!==type){if(actualType==="ResourceURL"&&type==="URL")return true;throw new Error(`Required a safe ${type}, got a ${actualType} (see https://g.co/ng/security#xss)`);}return actualType===type}function getSanitizationBypassType(value){return value instanceof SafeValueImpl&&value.getTypeName()||null}function bypassSanitizationTrustHtml(trustedHtml){return new SafeHtmlImpl(trustedHtml)}
function bypassSanitizationTrustStyle(trustedStyle){return new SafeStyleImpl(trustedStyle)}function bypassSanitizationTrustScript(trustedScript){return new SafeScriptImpl(trustedScript)}function bypassSanitizationTrustUrl(trustedUrl){return new SafeUrlImpl(trustedUrl)}function bypassSanitizationTrustResourceUrl(trustedResourceUrl){return new SafeResourceUrlImpl(trustedResourceUrl)}function getInertBodyHelper(defaultDoc){const inertDocumentHelper=new InertDocumentHelper(defaultDoc);return isDOMParserAvailable()?
new DOMParserHelper(inertDocumentHelper):inertDocumentHelper}class DOMParserHelper{constructor(inertDocumentHelper){this.inertDocumentHelper=inertDocumentHelper}getInertBodyElement(html){html="<body><remove></remove>"+html;try{const body=(new window.DOMParser).parseFromString(trustedHTMLFromString(html),"text/html").body;if(body===null)return this.inertDocumentHelper.getInertBodyElement(html);body.removeChild(body.firstChild);return body}catch(_a){return null}}}class InertDocumentHelper{constructor(defaultDoc){this.defaultDoc=
defaultDoc;this.inertDocument=this.defaultDoc.implementation.createHTMLDocument("sanitization-inert");if(this.inertDocument.body==null){const inertHtml=this.inertDocument.createElement("html");this.inertDocument.appendChild(inertHtml);const inertBodyElement=this.inertDocument.createElement("body");inertHtml.appendChild(inertBodyElement)}}getInertBodyElement(html){const templateEl=this.inertDocument.createElement("template");if("content"in templateEl){templateEl.innerHTML=trustedHTMLFromString(html);
return templateEl}const inertBody=this.inertDocument.createElement("body");inertBody.innerHTML=trustedHTMLFromString(html);if(this.defaultDoc.documentMode)this.stripCustomNsAttrs(inertBody);return inertBody}stripCustomNsAttrs(el){const elAttrs=el.attributes;for(let i=elAttrs.length-1;0<i;i--){const attrib=elAttrs.item(i);const attrName=attrib.name;if(attrName==="xmlns:ns1"||attrName.indexOf("ns1:")===0)el.removeAttribute(attrName)}let childNode=el.firstChild;while(childNode){if(childNode.nodeType===
Node.ELEMENT_NODE)this.stripCustomNsAttrs(childNode);childNode=childNode.nextSibling}}}function isDOMParserAvailable(){try{return!!(new window.DOMParser).parseFromString(trustedHTMLFromString(""),"text/html")}catch(_a){return false}}const SAFE_URL_PATTERN=/^(?:(?:https?|mailto|ftp|tel|file|sms):|[^&:/?#]*(?:[/?#]|$))/gi;const DATA_URL_PATTERN=/^data:(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm)|audio\/(?:mp3|oga|ogg|opus));base64,[a-z0-9+\/]+=*$/i;function _sanitizeUrl(url){url=
String(url);if(url.match(SAFE_URL_PATTERN)||url.match(DATA_URL_PATTERN))return url;if(typeof ngDevMode==="undefined"||ngDevMode)console.warn(`WARNING: sanitizing unsafe URL value ${url} (see https://g.co/ng/security#xss)`);return"unsafe:"+url}function sanitizeSrcset(srcset){srcset=String(srcset);return srcset.split(",").map(srcset=>_sanitizeUrl(srcset.trim())).join(", ")}function tagSet(tags){const res={};for(const t of tags.split(","))res[t]=true;return res}function merge(...sets){const res={};for(const s of sets)for(const v in s)if(s.hasOwnProperty(v))res[v]=
true;return res}const VOID_ELEMENTS=tagSet("area,br,col,hr,img,wbr");const OPTIONAL_END_TAG_BLOCK_ELEMENTS=tagSet("colgroup,dd,dt,li,p,tbody,td,tfoot,th,thead,tr");const OPTIONAL_END_TAG_INLINE_ELEMENTS=tagSet("rp,rt");const OPTIONAL_END_TAG_ELEMENTS=merge(OPTIONAL_END_TAG_INLINE_ELEMENTS,OPTIONAL_END_TAG_BLOCK_ELEMENTS);const BLOCK_ELEMENTS=merge(OPTIONAL_END_TAG_BLOCK_ELEMENTS,tagSet("address,article,"+"aside,blockquote,caption,center,del,details,dialog,dir,div,dl,figure,figcaption,footer,h1,h2,h3,h4,h5,"+
"h6,header,hgroup,hr,ins,main,map,menu,nav,ol,pre,section,summary,table,ul"));const INLINE_ELEMENTS=merge(OPTIONAL_END_TAG_INLINE_ELEMENTS,tagSet("a,abbr,acronym,audio,b,"+"bdi,bdo,big,br,cite,code,del,dfn,em,font,i,img,ins,kbd,label,map,mark,picture,q,ruby,rp,rt,s,"+"samp,small,source,span,strike,strong,sub,sup,time,track,tt,u,var,video"));const VALID_ELEMENTS=merge(VOID_ELEMENTS,BLOCK_ELEMENTS,INLINE_ELEMENTS,OPTIONAL_END_TAG_ELEMENTS);const URI_ATTRS=tagSet("background,cite,href,itemtype,longdesc,poster,src,xlink:href");
const SRCSET_ATTRS=tagSet("srcset");const HTML_ATTRS=tagSet("abbr,accesskey,align,alt,autoplay,axis,bgcolor,border,cellpadding,cellspacing,class,clear,color,cols,colspan,"+"compact,controls,coords,datetime,default,dir,download,face,headers,height,hidden,hreflang,hspace,"+"ismap,itemscope,itemprop,kind,label,lang,language,loop,media,muted,nohref,nowrap,open,preload,rel,rev,role,rows,rowspan,rules,"+"scope,scrolling,shape,size,sizes,span,srclang,start,summary,tabindex,target,title,translate,type,usemap,"+
"valign,value,vspace,width");const ARIA_ATTRS=tagSet("aria-activedescendant,aria-atomic,aria-autocomplete,aria-busy,aria-checked,aria-colcount,aria-colindex,"+"aria-colspan,aria-controls,aria-current,aria-describedby,aria-details,aria-disabled,aria-dropeffect,"+"aria-errormessage,aria-expanded,aria-flowto,aria-grabbed,aria-haspopup,aria-hidden,aria-invalid,"+"aria-keyshortcuts,aria-label,aria-labelledby,aria-level,aria-live,aria-modal,aria-multiline,"+"aria-multiselectable,aria-orientation,aria-owns,aria-placeholder,aria-posinset,aria-pressed,aria-readonly,"+
"aria-relevant,aria-required,aria-roledescription,aria-rowcount,aria-rowindex,aria-rowspan,aria-selected,"+"aria-setsize,aria-sort,aria-valuemax,aria-valuemin,aria-valuenow,aria-valuetext");const VALID_ATTRS=merge(URI_ATTRS,SRCSET_ATTRS,HTML_ATTRS,ARIA_ATTRS);const SKIP_TRAVERSING_CONTENT_IF_INVALID_ELEMENTS=tagSet("script,style,template");class SanitizingHtmlSerializer{constructor(){this.sanitizedSomething=false;this.buf=[]}sanitizeChildren(el){let current=el.firstChild;let traverseContent=true;
while(current){if(current.nodeType===Node.ELEMENT_NODE)traverseContent=this.startElement(current);else if(current.nodeType===Node.TEXT_NODE)this.chars(current.nodeValue);else this.sanitizedSomething=true;if(traverseContent&&current.firstChild){current=current.firstChild;continue}while(current){if(current.nodeType===Node.ELEMENT_NODE)this.endElement(current);let next=this.checkClobberedElement(current,current.nextSibling);if(next){current=next;break}current=this.checkClobberedElement(current,current.parentNode)}}return this.buf.join("")}startElement(element){const tagName=
element.nodeName.toLowerCase();if(!VALID_ELEMENTS.hasOwnProperty(tagName)){this.sanitizedSomething=true;return!SKIP_TRAVERSING_CONTENT_IF_INVALID_ELEMENTS.hasOwnProperty(tagName)}this.buf.push("<");this.buf.push(tagName);const elAttrs=element.attributes;for(let i=0;i<elAttrs.length;i++){const elAttr=elAttrs.item(i);const attrName=elAttr.name;const lower=attrName.toLowerCase();if(!VALID_ATTRS.hasOwnProperty(lower)){this.sanitizedSomething=true;continue}let value=elAttr.value;if(URI_ATTRS[lower])value=
_sanitizeUrl(value);if(SRCSET_ATTRS[lower])value=sanitizeSrcset(value);this.buf.push(" ",attrName,'="',encodeEntities(value),'"')}this.buf.push(">");return true}endElement(current){const tagName=current.nodeName.toLowerCase();if(VALID_ELEMENTS.hasOwnProperty(tagName)&&!VOID_ELEMENTS.hasOwnProperty(tagName)){this.buf.push("</");this.buf.push(tagName);this.buf.push(">")}}chars(chars){this.buf.push(encodeEntities(chars))}checkClobberedElement(node,nextNode){if(nextNode&&(node.compareDocumentPosition(nextNode)&
Node.DOCUMENT_POSITION_CONTAINED_BY)===Node.DOCUMENT_POSITION_CONTAINED_BY)throw new Error(`Failed to sanitize html because the element is clobbered: ${node.outerHTML}`);return nextNode}}const SURROGATE_PAIR_REGEXP=/[\uD800-\uDBFF][\uDC00-\uDFFF]/g;const NON_ALPHANUMERIC_REGEXP=/([^#-~ |!])/g;function encodeEntities(value){return value.replace(/&/g,"&amp;").replace(SURROGATE_PAIR_REGEXP,function(match){const hi=match.charCodeAt(0);const low=match.charCodeAt(1);return"&#"+((hi-55296)*1024+(low-56320)+
65536)+";"}).replace(NON_ALPHANUMERIC_REGEXP,function(match){return"&#"+match.charCodeAt(0)+";"}).replace(/</g,"&lt;").replace(/>/g,"&gt;")}let inertBodyHelper;function _sanitizeHtml(defaultDoc,unsafeHtmlInput){let inertBodyElement=null;try{inertBodyHelper=inertBodyHelper||getInertBodyHelper(defaultDoc);let unsafeHtml=unsafeHtmlInput?String(unsafeHtmlInput):"";inertBodyElement=inertBodyHelper.getInertBodyElement(unsafeHtml);let mXSSAttempts=5;let parsedHtml=unsafeHtml;do{if(mXSSAttempts===0)throw new Error("Failed to sanitize html because the input is unstable");
mXSSAttempts--;unsafeHtml=parsedHtml;parsedHtml=inertBodyElement.innerHTML;inertBodyElement=inertBodyHelper.getInertBodyElement(unsafeHtml)}while(unsafeHtml!==parsedHtml);const sanitizer=new SanitizingHtmlSerializer;const safeHtml=sanitizer.sanitizeChildren(getTemplateContent(inertBodyElement)||inertBodyElement);if((typeof ngDevMode==="undefined"||ngDevMode)&&sanitizer.sanitizedSomething)console.warn("WARNING: sanitizing HTML stripped some content, see https://g.co/ng/security#xss");return trustedHTMLFromString(safeHtml)}finally{if(inertBodyElement){const parent=
getTemplateContent(inertBodyElement)||inertBodyElement;while(parent.firstChild)parent.removeChild(parent.firstChild)}}}function getTemplateContent(el){return"content"in el&&isTemplateElement(el)?el.content:null}function isTemplateElement(el){return el.nodeType===Node.ELEMENT_NODE&&el.nodeName==="TEMPLATE"}exports.SecurityContext=void 0;(function(SecurityContext){SecurityContext[SecurityContext["NONE"]=0]="NONE";SecurityContext[SecurityContext["HTML"]=1]="HTML";SecurityContext[SecurityContext["STYLE"]=
2]="STYLE";SecurityContext[SecurityContext["SCRIPT"]=3]="SCRIPT";SecurityContext[SecurityContext["URL"]=4]="URL";SecurityContext[SecurityContext["RESOURCE_URL"]=5]="RESOURCE_URL"})(exports.SecurityContext||(exports.SecurityContext={}));function \u0275\u0275sanitizeHtml(unsafeHtml){const sanitizer=getSanitizer();if(sanitizer)return trustedHTMLFromStringBypass(sanitizer.sanitize(exports.SecurityContext.HTML,unsafeHtml)||"");if(allowSanitizationBypassAndThrow(unsafeHtml,"HTML"))return trustedHTMLFromStringBypass(unwrapSafeValue(unsafeHtml));
return _sanitizeHtml(getDocument(),renderStringify(unsafeHtml))}function \u0275\u0275sanitizeStyle(unsafeStyle){const sanitizer=getSanitizer();if(sanitizer)return sanitizer.sanitize(exports.SecurityContext.STYLE,unsafeStyle)||"";if(allowSanitizationBypassAndThrow(unsafeStyle,"Style"))return unwrapSafeValue(unsafeStyle);return renderStringify(unsafeStyle)}function \u0275\u0275sanitizeUrl(unsafeUrl){const sanitizer=getSanitizer();if(sanitizer)return sanitizer.sanitize(exports.SecurityContext.URL,unsafeUrl)||
"";if(allowSanitizationBypassAndThrow(unsafeUrl,"URL"))return unwrapSafeValue(unsafeUrl);return _sanitizeUrl(renderStringify(unsafeUrl))}function \u0275\u0275sanitizeResourceUrl(unsafeResourceUrl){const sanitizer=getSanitizer();if(sanitizer)return trustedScriptURLFromStringBypass(sanitizer.sanitize(exports.SecurityContext.RESOURCE_URL,unsafeResourceUrl)||"");if(allowSanitizationBypassAndThrow(unsafeResourceUrl,"ResourceURL"))return trustedScriptURLFromStringBypass(unwrapSafeValue(unsafeResourceUrl));
const errorMessage=typeof ngDevMode==="undefined"||ngDevMode?"unsafe value used in a resource URL context (see https://g.co/ng/security#xss)":"";throw new RuntimeError(904,errorMessage);}function \u0275\u0275sanitizeScript(unsafeScript){const sanitizer=getSanitizer();if(sanitizer)return trustedScriptFromStringBypass(sanitizer.sanitize(exports.SecurityContext.SCRIPT,unsafeScript)||"");if(allowSanitizationBypassAndThrow(unsafeScript,"Script"))return trustedScriptFromStringBypass(unwrapSafeValue(unsafeScript));
const errorMessage=typeof ngDevMode==="undefined"||ngDevMode?"unsafe value used in a script context":"";throw new RuntimeError(905,errorMessage);}function \u0275\u0275trustConstantHtml(html){if(ngDevMode&&(!Array.isArray(html)||!Array.isArray(html.raw)||html.length!==1))throw new Error(`Unexpected interpolation in trusted HTML constant: ${html.join("?")}`);return trustedHTMLFromString(html[0])}function \u0275\u0275trustConstantResourceUrl(url){if(ngDevMode&&(!Array.isArray(url)||!Array.isArray(url.raw)||
url.length!==1))throw new Error(`Unexpected interpolation in trusted URL constant: ${url.join("?")}`);return trustedScriptURLFromString(url[0])}function getUrlSanitizer(tag,prop){if(prop==="src"&&(tag==="embed"||tag==="frame"||tag==="iframe"||tag==="media"||tag==="script")||prop==="href"&&(tag==="base"||tag==="link"))return \u0275\u0275sanitizeResourceUrl;return \u0275\u0275sanitizeUrl}function \u0275\u0275sanitizeUrlOrResourceUrl(unsafeUrl,tag,prop){return getUrlSanitizer(tag,prop)(unsafeUrl)}function validateAgainstEventProperties(name){if(name.toLowerCase().startsWith("on")){const errorMessage=
`Binding to event property '${name}' is disallowed for security reasons, `+`please use (${name.slice(2)})=...`+`\nIf '${name}' is a directive input, make sure the directive is imported by the`+` current module.`;throw new RuntimeError(306,errorMessage);}}function validateAgainstEventAttributes(name){if(name.toLowerCase().startsWith("on")){const errorMessage=`Binding to event attribute '${name}' is disallowed for security reasons, `+`please use (${name.slice(2)})=...`;throw new RuntimeError(306,errorMessage);
}}function getSanitizer(){const lView=getLView();return lView&&lView[SANITIZER]}function getLContext(target){let mpValue=readPatchedData(target);if(mpValue){if(Array.isArray(mpValue)){const lView=mpValue;let nodeIndex;let component=undefined;let directives=undefined;if(isComponentInstance(target)){nodeIndex=findViaComponent(lView,target);if(nodeIndex==-1)throw new Error("The provided component was not found in the application");component=target}else if(isDirectiveInstance(target)){nodeIndex=findViaDirective(lView,
target);if(nodeIndex==-1)throw new Error("The provided directive was not found in the application");directives=getDirectivesAtNodeIndex(nodeIndex,lView,false)}else{nodeIndex=findViaNativeElement(lView,target);if(nodeIndex==-1)return null}const native=unwrapRNode(lView[nodeIndex]);const existingCtx=readPatchedData(native);const context=existingCtx&&!Array.isArray(existingCtx)?existingCtx:createLContext(lView,nodeIndex,native);if(component&&context.component===undefined){context.component=component;
attachPatchData(context.component,context)}if(directives&&context.directives===undefined){context.directives=directives;for(let i=0;i<directives.length;i++)attachPatchData(directives[i],context)}attachPatchData(context.native,context);mpValue=context}}else{const rElement=target;ngDevMode&&assertDomNode(rElement);let parent=rElement;while(parent=parent.parentNode){const parentContext=readPatchedData(parent);if(parentContext){let lView;if(Array.isArray(parentContext))lView=parentContext;else lView=
parentContext.lView;if(!lView)return null;const index=findViaNativeElement(lView,rElement);if(index>=0){const native=unwrapRNode(lView[index]);const context=createLContext(lView,index,native);attachPatchData(native,context);mpValue=context;break}}}}return mpValue||null}function createLContext(lView,nodeIndex,native){return{lView,nodeIndex,native,component:undefined,directives:undefined,localRefs:undefined}}function getComponentViewByInstance(componentInstance){let lView=readPatchedData(componentInstance);
let view;if(Array.isArray(lView)){const nodeIndex=findViaComponent(lView,componentInstance);view=getComponentLViewByIndex(nodeIndex,lView);const context=createLContext(lView,nodeIndex,view[HOST]);context.component=componentInstance;attachPatchData(componentInstance,context);attachPatchData(context.native,context)}else{const context=lView;view=getComponentLViewByIndex(context.nodeIndex,context.lView)}return view}const MONKEY_PATCH_KEY_NAME="__ngContext__";function attachPatchData(target,data){ngDevMode&&
assertDefined(target,"Target expected");target[MONKEY_PATCH_KEY_NAME]=data}function readPatchedData(target){ngDevMode&&assertDefined(target,"Target expected");return target[MONKEY_PATCH_KEY_NAME]||null}function readPatchedLView(target){const value=readPatchedData(target);if(value)return Array.isArray(value)?value:value.lView;return null}function isComponentInstance(instance){return instance&&instance.constructor&&instance.constructor.\u0275cmp}function isDirectiveInstance(instance){return instance&&
instance.constructor&&instance.constructor.\u0275dir}function findViaNativeElement(lView,target){const tView=lView[TVIEW];for(let i=HEADER_OFFSET;i<tView.bindingStartIndex;i++)if(unwrapRNode(lView[i])===target)return i;return-1}function traverseNextElement(tNode){if(tNode.child)return tNode.child;else if(tNode.next)return tNode.next;else{while(tNode.parent&&!tNode.parent.next)tNode=tNode.parent;return tNode.parent&&tNode.parent.next}}function findViaComponent(lView,componentInstance){const componentIndices=
lView[TVIEW].components;if(componentIndices)for(let i=0;i<componentIndices.length;i++){const elementComponentIndex=componentIndices[i];const componentView=getComponentLViewByIndex(elementComponentIndex,lView);if(componentView[CONTEXT]===componentInstance)return elementComponentIndex}else{const rootComponentView=getComponentLViewByIndex(HEADER_OFFSET,lView);const rootComponent=rootComponentView[CONTEXT];if(rootComponent===componentInstance)return HEADER_OFFSET}return-1}function findViaDirective(lView,
directiveInstance){let tNode=lView[TVIEW].firstChild;while(tNode){const directiveIndexStart=tNode.directiveStart;const directiveIndexEnd=tNode.directiveEnd;for(let i=directiveIndexStart;i<directiveIndexEnd;i++)if(lView[i]===directiveInstance)return tNode.index;tNode=traverseNextElement(tNode)}return-1}function getDirectivesAtNodeIndex(nodeIndex,lView,includeComponents){const tNode=lView[TVIEW].data[nodeIndex];let directiveStartIndex=tNode.directiveStart;if(directiveStartIndex==0)return EMPTY_ARRAY;
const directiveEndIndex=tNode.directiveEnd;if(!includeComponents&&tNode.flags&2)directiveStartIndex++;return lView.slice(directiveStartIndex,directiveEndIndex)}function getComponentAtNodeIndex(nodeIndex,lView){const tNode=lView[TVIEW].data[nodeIndex];let directiveStartIndex=tNode.directiveStart;return tNode.flags&2?lView[directiveStartIndex]:null}function discoverLocalRefs(lView,nodeIndex){const tNode=lView[TVIEW].data[nodeIndex];if(tNode&&tNode.localNames){const result={};let localIndex=tNode.index+
1;for(let i=0;i<tNode.localNames.length;i+=2){result[tNode.localNames[i]]=lView[localIndex];localIndex++}return result}return null}const ERROR_ORIGINAL_ERROR="ngOriginalError";const ERROR_LOGGER="ngErrorLogger";function wrappedError(message,originalError){const msg=`${message} caused by: ${originalError instanceof Error?originalError.message:originalError}`;const error=Error(msg);error[ERROR_ORIGINAL_ERROR]=originalError;return error}function getOriginalError(error){return error[ERROR_ORIGINAL_ERROR]}
function getErrorLogger(error){return error&&error[ERROR_LOGGER]||defaultErrorLogger}function defaultErrorLogger(console,...values){console.error(...values)}class ErrorHandler{constructor(){this._console=console}handleError(error){const originalError=this._findOriginalError(error);const errorLogger=getErrorLogger(error);errorLogger(this._console,`ERROR`,error);if(originalError)errorLogger(this._console,`ORIGINAL ERROR`,originalError)}_findOriginalError(error){let e=error&&getOriginalError(error);
while(e&&getOriginalError(e))e=getOriginalError(e);return e||null}}const CUSTOM_ELEMENTS_SCHEMA={name:"custom-elements"};const NO_ERRORS_SCHEMA={name:"no-errors-schema"};const COMMENT_DISALLOWED=/^>|^->|\x3c!--|--\x3e|--!>|<!-$/g;const COMMENT_DELIMITER=/(<|>)/;const COMMENT_DELIMITER_ESCAPED="​$1​";function escapeCommentText(value){return value.replace(COMMENT_DISALLOWED,text=>text.replace(COMMENT_DELIMITER,COMMENT_DELIMITER_ESCAPED))}function normalizeDebugBindingName(name){name=camelCaseToDashCase(name.replace(/[$@]/g,
"_"));return`ng-reflect-${name}`}const CAMEL_CASE_REGEXP=/([A-Z])/g;function camelCaseToDashCase(input){return input.replace(CAMEL_CASE_REGEXP,(...m)=>"-"+m[1].toLowerCase())}function normalizeDebugBindingValue(value){try{return value!=null?value.toString().slice(0,30):value}catch(e){return"[ERROR] Exception while trying to serialize the value"}}const defaultScheduler=(()=>(typeof requestAnimationFrame!=="undefined"&&requestAnimationFrame||setTimeout).bind(_global))();function \u0275\u0275resolveWindow(element){return element.ownerDocument.defaultView}
function \u0275\u0275resolveDocument(element){return element.ownerDocument}function \u0275\u0275resolveBody(element){return element.ownerDocument.body}const INTERPOLATION_DELIMITER=`�`;function maybeUnwrapFn(value){if(value instanceof Function)return value();else return value}function throwMultipleComponentError(tNode){throw new RuntimeError(-300,`Multiple components match node with tagname ${tNode.value}`);}function throwErrorIfNoChangesMode(creationMode,oldValue,currValue,propName){const field=
propName?` for '${propName}'`:"";let msg=`ExpressionChangedAfterItHasBeenCheckedError: Expression has changed after it was checked. Previous value${field}: '${oldValue}'. Current value: '${currValue}'.`;if(creationMode)msg+=` It seems like the view has been created after its parent and its children have been dirty checked.`+` Has it been created in a change detection hook?`;throw new RuntimeError(-100,msg);}function constructDetailsForInterpolation(lView,rootIndex,expressionIndex,meta,changedValue){const [propName,
prefix,...chunks]=meta.split(INTERPOLATION_DELIMITER);let oldValue=prefix,newValue=prefix;for(let i=0;i<chunks.length;i++){const slotIdx=rootIndex+i;oldValue+=`${lView[slotIdx]}${chunks[i]}`;newValue+=`${slotIdx===expressionIndex?changedValue:lView[slotIdx]}${chunks[i]}`}return{propName,oldValue,newValue}}function getExpressionChangedErrorDetails(lView,bindingIndex,oldValue,newValue){const tData=lView[TVIEW].data;const metadata=tData[bindingIndex];if(typeof metadata==="string"){if(metadata.indexOf(INTERPOLATION_DELIMITER)>
-1)return constructDetailsForInterpolation(lView,bindingIndex,bindingIndex,metadata,newValue);return{propName:metadata,oldValue,newValue}}if(metadata===null){let idx=bindingIndex-1;while(typeof tData[idx]!=="string"&&tData[idx+1]===null)idx--;const meta=tData[idx];if(typeof meta==="string"){const matches=meta.match(new RegExp(INTERPOLATION_DELIMITER,"g"));if(matches&&matches.length-1>bindingIndex-idx)return constructDetailsForInterpolation(lView,idx,bindingIndex,meta,newValue)}}return{propName:undefined,
oldValue,newValue}}exports.RendererStyleFlags2=void 0;(function(RendererStyleFlags2){RendererStyleFlags2[RendererStyleFlags2["Important"]=1]="Important";RendererStyleFlags2[RendererStyleFlags2["DashCase"]=2]="DashCase"})(exports.RendererStyleFlags2||(exports.RendererStyleFlags2={}));let _icuContainerIterate;function icuContainerIterate(tIcuContainerNode,lView){return _icuContainerIterate(tIcuContainerNode,lView)}function ensureIcuContainerVisitorLoaded(loader){if(_icuContainerIterate===undefined)_icuContainerIterate=
loader()}function getLViewParent(lView){ngDevMode&&assertLView(lView);const parent=lView[PARENT];return isLContainer(parent)?parent[PARENT]:parent}function getRootView(componentOrLView){ngDevMode&&assertDefined(componentOrLView,"component");let lView=isLView(componentOrLView)?componentOrLView:readPatchedLView(componentOrLView);while(lView&&!(lView[FLAGS]&512))lView=getLViewParent(lView);ngDevMode&&assertLView(lView);return lView}function getRootContext(viewOrComponent){const rootView=getRootView(viewOrComponent);
ngDevMode&&assertDefined(rootView[CONTEXT],"RootView has no context. Perhaps it is disconnected?");return rootView[CONTEXT]}function getFirstLContainer(lView){return getNearestLContainer(lView[CHILD_HEAD])}function getNextLContainer(container){return getNearestLContainer(container[NEXT])}function getNearestLContainer(viewOrContainer){while(viewOrContainer!==null&&!isLContainer(viewOrContainer))viewOrContainer=viewOrContainer[NEXT];return viewOrContainer}function applyToElementOrContainer(action,renderer,
parent,lNodeToHandle,beforeNode){if(lNodeToHandle!=null){let lContainer;let isComponent=false;if(isLContainer(lNodeToHandle))lContainer=lNodeToHandle;else if(isLView(lNodeToHandle)){isComponent=true;ngDevMode&&assertDefined(lNodeToHandle[HOST],"HOST must be defined for a component LView");lNodeToHandle=lNodeToHandle[HOST]}const rNode=unwrapRNode(lNodeToHandle);ngDevMode&&!isProceduralRenderer(renderer)&&assertDomNode(rNode);if(action===0&&parent!==null)if(beforeNode==null)nativeAppendChild(renderer,
parent,rNode);else nativeInsertBefore(renderer,parent,rNode,beforeNode||null,true);else if(action===1&&parent!==null)nativeInsertBefore(renderer,parent,rNode,beforeNode||null,true);else if(action===2)nativeRemoveNode(renderer,rNode,isComponent);else if(action===3){ngDevMode&&ngDevMode.rendererDestroyNode++;renderer.destroyNode(rNode)}if(lContainer!=null)applyContainer(renderer,action,lContainer,parent,beforeNode)}}function createTextNode(renderer,value){ngDevMode&&ngDevMode.rendererCreateTextNode++;
ngDevMode&&ngDevMode.rendererSetText++;return isProceduralRenderer(renderer)?renderer.createText(value):renderer.createTextNode(value)}function updateTextNode(renderer,rNode,value){ngDevMode&&ngDevMode.rendererSetText++;isProceduralRenderer(renderer)?renderer.setValue(rNode,value):rNode.textContent=value}function createCommentNode(renderer,value){ngDevMode&&ngDevMode.rendererCreateComment++;return renderer.createComment(escapeCommentText(value))}function createElementNode(renderer,name,namespace){ngDevMode&&
ngDevMode.rendererCreateElement++;if(isProceduralRenderer(renderer))return renderer.createElement(name,namespace);else return namespace===null?renderer.createElement(name):renderer.createElementNS(namespace,name)}function removeViewFromContainer(tView,lView){const renderer=lView[RENDERER];applyView(tView,lView,renderer,2,null,null);lView[HOST]=null;lView[T_HOST]=null}function addViewToContainer(tView,parentTNode,renderer,lView,parentNativeNode,beforeNode){lView[HOST]=parentNativeNode;lView[T_HOST]=
parentTNode;applyView(tView,lView,renderer,1,parentNativeNode,beforeNode)}function renderDetachView(tView,lView){applyView(tView,lView,lView[RENDERER],2,null,null)}function destroyViewTree(rootView){let lViewOrLContainer=rootView[CHILD_HEAD];if(!lViewOrLContainer)return cleanUpView(rootView[TVIEW],rootView);while(lViewOrLContainer){let next=null;if(isLView(lViewOrLContainer))next=lViewOrLContainer[CHILD_HEAD];else{ngDevMode&&assertLContainer(lViewOrLContainer);const firstView=lViewOrLContainer[CONTAINER_HEADER_OFFSET];
if(firstView)next=firstView}if(!next){while(lViewOrLContainer&&!lViewOrLContainer[NEXT]&&lViewOrLContainer!==rootView){if(isLView(lViewOrLContainer))cleanUpView(lViewOrLContainer[TVIEW],lViewOrLContainer);lViewOrLContainer=lViewOrLContainer[PARENT]}if(lViewOrLContainer===null)lViewOrLContainer=rootView;if(isLView(lViewOrLContainer))cleanUpView(lViewOrLContainer[TVIEW],lViewOrLContainer);next=lViewOrLContainer&&lViewOrLContainer[NEXT]}lViewOrLContainer=next}}function insertView(tView,lView,lContainer,
index){ngDevMode&&assertLView(lView);ngDevMode&&assertLContainer(lContainer);const indexInContainer=CONTAINER_HEADER_OFFSET+index;const containerLength=lContainer.length;if(index>0)lContainer[indexInContainer-1][NEXT]=lView;if(index<containerLength-CONTAINER_HEADER_OFFSET){lView[NEXT]=lContainer[indexInContainer];addToArray(lContainer,CONTAINER_HEADER_OFFSET+index,lView)}else{lContainer.push(lView);lView[NEXT]=null}lView[PARENT]=lContainer;const declarationLContainer=lView[DECLARATION_LCONTAINER];
if(declarationLContainer!==null&&lContainer!==declarationLContainer)trackMovedView(declarationLContainer,lView);const lQueries=lView[QUERIES];if(lQueries!==null)lQueries.insertView(tView);lView[FLAGS]|=128}function trackMovedView(declarationContainer,lView){ngDevMode&&assertDefined(lView,"LView required");ngDevMode&&assertLContainer(declarationContainer);const movedViews=declarationContainer[MOVED_VIEWS];const insertedLContainer=lView[PARENT];ngDevMode&&assertLContainer(insertedLContainer);const insertedComponentLView=
insertedLContainer[PARENT][DECLARATION_COMPONENT_VIEW];ngDevMode&&assertDefined(insertedComponentLView,"Missing insertedComponentLView");const declaredComponentLView=lView[DECLARATION_COMPONENT_VIEW];ngDevMode&&assertDefined(declaredComponentLView,"Missing declaredComponentLView");if(declaredComponentLView!==insertedComponentLView)declarationContainer[HAS_TRANSPLANTED_VIEWS]=true;if(movedViews===null)declarationContainer[MOVED_VIEWS]=[lView];else movedViews.push(lView)}function detachMovedView(declarationContainer,
lView){ngDevMode&&assertLContainer(declarationContainer);ngDevMode&&assertDefined(declarationContainer[MOVED_VIEWS],"A projected view should belong to a non-empty projected views collection");const movedViews=declarationContainer[MOVED_VIEWS];const declarationViewIndex=movedViews.indexOf(lView);const insertionLContainer=lView[PARENT];ngDevMode&&assertLContainer(insertionLContainer);if(lView[FLAGS]&1024){lView[FLAGS]&=~1024;updateTransplantedViewCount(insertionLContainer,-1)}movedViews.splice(declarationViewIndex,
1)}function detachView(lContainer,removeIndex){if(lContainer.length<=CONTAINER_HEADER_OFFSET)return;const indexInContainer=CONTAINER_HEADER_OFFSET+removeIndex;const viewToDetach=lContainer[indexInContainer];if(viewToDetach){const declarationLContainer=viewToDetach[DECLARATION_LCONTAINER];if(declarationLContainer!==null&&declarationLContainer!==lContainer)detachMovedView(declarationLContainer,viewToDetach);if(removeIndex>0)lContainer[indexInContainer-1][NEXT]=viewToDetach[NEXT];const removedLView=
removeFromArray(lContainer,CONTAINER_HEADER_OFFSET+removeIndex);removeViewFromContainer(viewToDetach[TVIEW],viewToDetach);const lQueries=removedLView[QUERIES];if(lQueries!==null)lQueries.detachView(removedLView[TVIEW]);viewToDetach[PARENT]=null;viewToDetach[NEXT]=null;viewToDetach[FLAGS]&=~128}return viewToDetach}function destroyLView(tView,lView){if(!(lView[FLAGS]&256)){const renderer=lView[RENDERER];if(isProceduralRenderer(renderer)&&renderer.destroyNode)applyView(tView,lView,renderer,3,null,null);
destroyViewTree(lView)}}function cleanUpView(tView,lView){if(!(lView[FLAGS]&256)){lView[FLAGS]&=~128;lView[FLAGS]|=256;executeOnDestroys(tView,lView);processCleanups(tView,lView);if(lView[TVIEW].type===1&&isProceduralRenderer(lView[RENDERER])){ngDevMode&&ngDevMode.rendererDestroy++;lView[RENDERER].destroy()}const declarationContainer=lView[DECLARATION_LCONTAINER];if(declarationContainer!==null&&isLContainer(lView[PARENT])){if(declarationContainer!==lView[PARENT])detachMovedView(declarationContainer,
lView);const lQueries=lView[QUERIES];if(lQueries!==null)lQueries.detachView(tView)}}}function processCleanups(tView,lView){const tCleanup=tView.cleanup;const lCleanup=lView[CLEANUP];let lastLCleanupIndex=-1;if(tCleanup!==null)for(let i=0;i<tCleanup.length-1;i+=2)if(typeof tCleanup[i]==="string"){const idxOrTargetGetter=tCleanup[i+1];const target=typeof idxOrTargetGetter==="function"?idxOrTargetGetter(lView):unwrapRNode(lView[idxOrTargetGetter]);const listener=lCleanup[lastLCleanupIndex=tCleanup[i+
2]];const useCaptureOrSubIdx=tCleanup[i+3];if(typeof useCaptureOrSubIdx==="boolean")target.removeEventListener(tCleanup[i],listener,useCaptureOrSubIdx);else if(useCaptureOrSubIdx>=0)lCleanup[lastLCleanupIndex=useCaptureOrSubIdx]();else lCleanup[lastLCleanupIndex=-useCaptureOrSubIdx].unsubscribe();i+=2}else{const context=lCleanup[lastLCleanupIndex=tCleanup[i+1]];tCleanup[i].call(context)}if(lCleanup!==null){for(let i=lastLCleanupIndex+1;i<lCleanup.length;i++){const instanceCleanupFn=lCleanup[i];ngDevMode&&
assertFunction(instanceCleanupFn,"Expecting instance cleanup function.");instanceCleanupFn()}lView[CLEANUP]=null}}function executeOnDestroys(tView,lView){let destroyHooks;if(tView!=null&&(destroyHooks=tView.destroyHooks)!=null)for(let i=0;i<destroyHooks.length;i+=2){const context=lView[destroyHooks[i]];if(!(context instanceof NodeInjectorFactory)){const toCall=destroyHooks[i+1];if(Array.isArray(toCall))for(let j=0;j<toCall.length;j+=2){const callContext=context[toCall[j]];const hook=toCall[j+1];profiler(4,
callContext,hook);try{hook.call(callContext)}finally{profiler(5,callContext,hook)}}else{profiler(4,context,toCall);try{toCall.call(context)}finally{profiler(5,context,toCall)}}}}}function getParentRElement(tView,tNode,lView){return getClosestRElement(tView,tNode.parent,lView)}function getClosestRElement(tView,tNode,lView){let parentTNode=tNode;while(parentTNode!==null&&parentTNode.type&(8|32)){tNode=parentTNode;parentTNode=tNode.parent}if(parentTNode===null)return lView[HOST];else{ngDevMode&&assertTNodeType(parentTNode,
3|4);if(parentTNode.flags&2){ngDevMode&&assertTNodeForLView(parentTNode,lView);const encapsulation=tView.data[parentTNode.directiveStart].encapsulation;if(encapsulation===exports.ViewEncapsulation.None||encapsulation===exports.ViewEncapsulation.Emulated)return null}return getNativeByTNode(parentTNode,lView)}}function nativeInsertBefore(renderer,parent,child,beforeNode,isMove){ngDevMode&&ngDevMode.rendererInsertBefore++;if(isProceduralRenderer(renderer))renderer.insertBefore(parent,child,beforeNode,
isMove);else parent.insertBefore(child,beforeNode,isMove)}function nativeAppendChild(renderer,parent,child){ngDevMode&&ngDevMode.rendererAppendChild++;ngDevMode&&assertDefined(parent,"parent node must be defined");if(isProceduralRenderer(renderer))renderer.appendChild(parent,child);else parent.appendChild(child)}function nativeAppendOrInsertBefore(renderer,parent,child,beforeNode,isMove){if(beforeNode!==null)nativeInsertBefore(renderer,parent,child,beforeNode,isMove);else nativeAppendChild(renderer,
parent,child)}function nativeRemoveChild(renderer,parent,child,isHostElement){if(isProceduralRenderer(renderer))renderer.removeChild(parent,child,isHostElement);else parent.removeChild(child)}function nativeParentNode(renderer,node){return isProceduralRenderer(renderer)?renderer.parentNode(node):node.parentNode}function nativeNextSibling(renderer,node){return isProceduralRenderer(renderer)?renderer.nextSibling(node):node.nextSibling}function getInsertInFrontOfRNode(parentTNode,currentTNode,lView){return _getInsertInFrontOfRNodeWithI18n(parentTNode,
currentTNode,lView)}function getInsertInFrontOfRNodeWithNoI18n(parentTNode,currentTNode,lView){if(parentTNode.type&(8|32))return getNativeByTNode(parentTNode,lView);return null}let _getInsertInFrontOfRNodeWithI18n=getInsertInFrontOfRNodeWithNoI18n;let _processI18nInsertBefore;function setI18nHandling(getInsertInFrontOfRNodeWithI18n,processI18nInsertBefore){_getInsertInFrontOfRNodeWithI18n=getInsertInFrontOfRNodeWithI18n;_processI18nInsertBefore=processI18nInsertBefore}function appendChild(tView,lView,
childRNode,childTNode){const parentRNode=getParentRElement(tView,childTNode,lView);const renderer=lView[RENDERER];const parentTNode=childTNode.parent||lView[T_HOST];const anchorNode=getInsertInFrontOfRNode(parentTNode,childTNode,lView);if(parentRNode!=null)if(Array.isArray(childRNode))for(let i=0;i<childRNode.length;i++)nativeAppendOrInsertBefore(renderer,parentRNode,childRNode[i],anchorNode,false);else nativeAppendOrInsertBefore(renderer,parentRNode,childRNode,anchorNode,false);_processI18nInsertBefore!==
undefined&&_processI18nInsertBefore(renderer,childTNode,lView,childRNode,parentRNode)}function getFirstNativeNode(lView,tNode){if(tNode!==null){ngDevMode&&assertTNodeType(tNode,3|12|32|16);const tNodeType=tNode.type;if(tNodeType&3)return getNativeByTNode(tNode,lView);else if(tNodeType&4)return getBeforeNodeForView(-1,lView[tNode.index]);else if(tNodeType&8){const elIcuContainerChild=tNode.child;if(elIcuContainerChild!==null)return getFirstNativeNode(lView,elIcuContainerChild);else{const rNodeOrLContainer=
lView[tNode.index];if(isLContainer(rNodeOrLContainer))return getBeforeNodeForView(-1,rNodeOrLContainer);else return unwrapRNode(rNodeOrLContainer)}}else if(tNodeType&32){let nextRNode=icuContainerIterate(tNode,lView);let rNode=nextRNode();return rNode||unwrapRNode(lView[tNode.index])}else{const projectionNodes=getProjectionNodes(lView,tNode);if(projectionNodes!==null){if(Array.isArray(projectionNodes))return projectionNodes[0];const parentView=getLViewParent(lView[DECLARATION_COMPONENT_VIEW]);ngDevMode&&
assertParentView(parentView);return getFirstNativeNode(parentView,projectionNodes)}else return getFirstNativeNode(lView,tNode.next)}}return null}function getProjectionNodes(lView,tNode){if(tNode!==null){const componentView=lView[DECLARATION_COMPONENT_VIEW];const componentHost=componentView[T_HOST];const slotIdx=tNode.projection;ngDevMode&&assertProjectionSlots(lView);return componentHost.projection[slotIdx]}return null}function getBeforeNodeForView(viewIndexInContainer,lContainer){const nextViewIndex=
CONTAINER_HEADER_OFFSET+viewIndexInContainer+1;if(nextViewIndex<lContainer.length){const lView=lContainer[nextViewIndex];const firstTNodeOfView=lView[TVIEW].firstChild;if(firstTNodeOfView!==null)return getFirstNativeNode(lView,firstTNodeOfView)}return lContainer[NATIVE]}function nativeRemoveNode(renderer,rNode,isHostElement){ngDevMode&&ngDevMode.rendererRemoveNode++;const nativeParent=nativeParentNode(renderer,rNode);if(nativeParent)nativeRemoveChild(renderer,nativeParent,rNode,isHostElement)}function applyNodes(renderer,
action,tNode,lView,parentRElement,beforeNode,isProjection){while(tNode!=null){ngDevMode&&assertTNodeForLView(tNode,lView);ngDevMode&&assertTNodeType(tNode,3|12|16|32);const rawSlotValue=lView[tNode.index];const tNodeType=tNode.type;if(isProjection)if(action===0){rawSlotValue&&attachPatchData(unwrapRNode(rawSlotValue),lView);tNode.flags|=4}if((tNode.flags&64)!==64)if(tNodeType&8){applyNodes(renderer,action,tNode.child,lView,parentRElement,beforeNode,false);applyToElementOrContainer(action,renderer,
parentRElement,rawSlotValue,beforeNode)}else if(tNodeType&32){const nextRNode=icuContainerIterate(tNode,lView);let rNode;while(rNode=nextRNode())applyToElementOrContainer(action,renderer,parentRElement,rNode,beforeNode);applyToElementOrContainer(action,renderer,parentRElement,rawSlotValue,beforeNode)}else if(tNodeType&16)applyProjectionRecursive(renderer,action,lView,tNode,parentRElement,beforeNode);else{ngDevMode&&assertTNodeType(tNode,3|4);applyToElementOrContainer(action,renderer,parentRElement,
rawSlotValue,beforeNode)}tNode=isProjection?tNode.projectionNext:tNode.next}}function applyView(tView,lView,renderer,action,parentRElement,beforeNode){applyNodes(renderer,action,tView.firstChild,lView,parentRElement,beforeNode,false)}function applyProjection(tView,lView,tProjectionNode){const renderer=lView[RENDERER];const parentRNode=getParentRElement(tView,tProjectionNode,lView);const parentTNode=tProjectionNode.parent||lView[T_HOST];let beforeNode=getInsertInFrontOfRNode(parentTNode,tProjectionNode,
lView);applyProjectionRecursive(renderer,0,lView,tProjectionNode,parentRNode,beforeNode)}function applyProjectionRecursive(renderer,action,lView,tProjectionNode,parentRElement,beforeNode){const componentLView=lView[DECLARATION_COMPONENT_VIEW];const componentNode=componentLView[T_HOST];ngDevMode&&assertEqual(typeof tProjectionNode.projection,"number","expecting projection index");const nodeToProjectOrRNodes=componentNode.projection[tProjectionNode.projection];if(Array.isArray(nodeToProjectOrRNodes))for(let i=
0;i<nodeToProjectOrRNodes.length;i++){const rNode=nodeToProjectOrRNodes[i];applyToElementOrContainer(action,renderer,parentRElement,rNode,beforeNode)}else{let nodeToProject=nodeToProjectOrRNodes;const projectedComponentLView=componentLView[PARENT];applyNodes(renderer,action,nodeToProject,projectedComponentLView,parentRElement,beforeNode,true)}}function applyContainer(renderer,action,lContainer,parentRElement,beforeNode){ngDevMode&&assertLContainer(lContainer);const anchor=lContainer[NATIVE];const native=
unwrapRNode(lContainer);if(anchor!==native)applyToElementOrContainer(action,renderer,parentRElement,anchor,beforeNode);for(let i=CONTAINER_HEADER_OFFSET;i<lContainer.length;i++){const lView=lContainer[i];applyView(lView[TVIEW],lView,renderer,action,parentRElement,anchor)}}function applyStyling(renderer,isClassBased,rNode,prop,value){const isProcedural=isProceduralRenderer(renderer);if(isClassBased)if(!value){ngDevMode&&ngDevMode.rendererRemoveClass++;if(isProcedural)renderer.removeClass(rNode,prop);
else rNode.classList.remove(prop)}else{ngDevMode&&ngDevMode.rendererAddClass++;if(isProcedural)renderer.addClass(rNode,prop);else{ngDevMode&&assertDefined(rNode.classList,"HTMLElement expected");rNode.classList.add(prop)}}else{let flags=prop.indexOf("-")===-1?undefined:exports.RendererStyleFlags2.DashCase;if(value==null){ngDevMode&&ngDevMode.rendererRemoveStyle++;if(isProcedural)renderer.removeStyle(rNode,prop,flags);else rNode.style.removeProperty(prop)}else{const isImportant=typeof value==="string"?
value.endsWith("!important"):false;if(isImportant){value=value.slice(0,-10);flags|=exports.RendererStyleFlags2.Important}ngDevMode&&ngDevMode.rendererSetStyle++;if(isProcedural)renderer.setStyle(rNode,prop,value,flags);else{ngDevMode&&assertDefined(rNode.style,"HTMLElement expected");rNode.style.setProperty(prop,value,isImportant?"important":"")}}}}function writeDirectStyle(renderer,element,newValue){ngDevMode&&assertString(newValue,"'newValue' should be a string");if(isProceduralRenderer(renderer))renderer.setAttribute(element,
"style",newValue);else element.style.cssText=newValue;ngDevMode&&ngDevMode.rendererSetStyle++}function writeDirectClass(renderer,element,newValue){ngDevMode&&assertString(newValue,"'newValue' should be a string");if(isProceduralRenderer(renderer))if(newValue==="")renderer.removeAttribute(element,"class");else renderer.setAttribute(element,"class",newValue);else element.className=newValue;ngDevMode&&ngDevMode.rendererSetClassName++}function classIndexOf(className,classToSearch,startingIndex){ngDevMode&&
assertNotEqual(classToSearch,"",'can not look for "" string.');let end=className.length;while(true){const foundIndex=className.indexOf(classToSearch,startingIndex);if(foundIndex===-1)return foundIndex;if(foundIndex===0||className.charCodeAt(foundIndex-1)<=32){const length=classToSearch.length;if(foundIndex+length===end||className.charCodeAt(foundIndex+length)<=32)return foundIndex}startingIndex=foundIndex+1}}const NG_TEMPLATE_SELECTOR="ng-template";function isCssClassMatching(attrs,cssClassToMatch,
isProjectionMode){ngDevMode&&assertEqual(cssClassToMatch,cssClassToMatch.toLowerCase(),"Class name expected to be lowercase.");let i=0;while(i<attrs.length){let item=attrs[i++];if(isProjectionMode&&item==="class"){item=attrs[i];if(classIndexOf(item.toLowerCase(),cssClassToMatch,0)!==-1)return true}else if(item===1){while(i<attrs.length&&typeof(item=attrs[i++])=="string")if(item.toLowerCase()===cssClassToMatch)return true;return false}}return false}function isInlineTemplate(tNode){return tNode.type===
4&&tNode.value!==NG_TEMPLATE_SELECTOR}function hasTagAndTypeMatch(tNode,currentSelector,isProjectionMode){const tagNameToCompare=tNode.type===4&&!isProjectionMode?NG_TEMPLATE_SELECTOR:tNode.value;return currentSelector===tagNameToCompare}function isNodeMatchingSelector(tNode,selector,isProjectionMode){ngDevMode&&assertDefined(selector[0],"Selector should have a tag name");let mode=4;const nodeAttrs=tNode.attrs||[];const nameOnlyMarkerIdx=getNameOnlyMarkerIndex(nodeAttrs);let skipToNextSelector=false;
for(let i=0;i<selector.length;i++){const current=selector[i];if(typeof current==="number"){if(!skipToNextSelector&&!isPositive(mode)&&!isPositive(current))return false;if(skipToNextSelector&&isPositive(current))continue;skipToNextSelector=false;mode=current|mode&1;continue}if(skipToNextSelector)continue;if(mode&4){mode=2|mode&1;if(current!==""&&!hasTagAndTypeMatch(tNode,current,isProjectionMode)||current===""&&selector.length===1){if(isPositive(mode))return false;skipToNextSelector=true}}else{const selectorAttrValue=
mode&8?current:selector[++i];if(mode&8&&tNode.attrs!==null){if(!isCssClassMatching(tNode.attrs,selectorAttrValue,isProjectionMode)){if(isPositive(mode))return false;skipToNextSelector=true}continue}const attrName=mode&8?"class":current;const attrIndexInNode=findAttrIndexInNode(attrName,nodeAttrs,isInlineTemplate(tNode),isProjectionMode);if(attrIndexInNode===-1){if(isPositive(mode))return false;skipToNextSelector=true;continue}if(selectorAttrValue!==""){let nodeAttrValue;if(attrIndexInNode>nameOnlyMarkerIdx)nodeAttrValue=
"";else{ngDevMode&&assertNotEqual(nodeAttrs[attrIndexInNode],0,"We do not match directives on namespaced attributes");nodeAttrValue=nodeAttrs[attrIndexInNode+1].toLowerCase()}const compareAgainstClassName=mode&8?nodeAttrValue:null;if(compareAgainstClassName&&classIndexOf(compareAgainstClassName,selectorAttrValue,0)!==-1||mode&2&&selectorAttrValue!==nodeAttrValue){if(isPositive(mode))return false;skipToNextSelector=true}}}}return isPositive(mode)||skipToNextSelector}function isPositive(mode){return(mode&
1)===0}function findAttrIndexInNode(name,attrs,isInlineTemplate,isProjectionMode){if(attrs===null)return-1;let i=0;if(isProjectionMode||!isInlineTemplate){let bindingsMode=false;while(i<attrs.length){const maybeAttrName=attrs[i];if(maybeAttrName===name)return i;else if(maybeAttrName===3||maybeAttrName===6)bindingsMode=true;else if(maybeAttrName===1||maybeAttrName===2){let value=attrs[++i];while(typeof value==="string")value=attrs[++i];continue}else if(maybeAttrName===4)break;else if(maybeAttrName===
0){i+=4;continue}i+=bindingsMode?1:2}return-1}else return matchTemplateAttribute(attrs,name)}function isNodeMatchingSelectorList(tNode,selector,isProjectionMode=false){for(let i=0;i<selector.length;i++)if(isNodeMatchingSelector(tNode,selector[i],isProjectionMode))return true;return false}function getProjectAsAttrValue(tNode){const nodeAttrs=tNode.attrs;if(nodeAttrs!=null){const ngProjectAsAttrIdx=nodeAttrs.indexOf(5);if((ngProjectAsAttrIdx&1)===0)return nodeAttrs[ngProjectAsAttrIdx+1]}return null}
function getNameOnlyMarkerIndex(nodeAttrs){for(let i=0;i<nodeAttrs.length;i++){const nodeAttr=nodeAttrs[i];if(isNameOnlyAttributeMarker(nodeAttr))return i}return nodeAttrs.length}function matchTemplateAttribute(attrs,name){let i=attrs.indexOf(4);if(i>-1){i++;while(i<attrs.length){const attr=attrs[i];if(typeof attr==="number")return-1;if(attr===name)return i;i++}}return-1}function isSelectorInSelectorList(selector,list){selectorListLoop:for(let i=0;i<list.length;i++){const currentSelectorInList=list[i];
if(selector.length!==currentSelectorInList.length)continue;for(let j=0;j<selector.length;j++)if(selector[j]!==currentSelectorInList[j])continue selectorListLoop;return true}return false}function maybeWrapInNotSelector(isNegativeMode,chunk){return isNegativeMode?":not("+chunk.trim()+")":chunk}function stringifyCSSSelector(selector){let result=selector[0];let i=1;let mode=2;let currentChunk="";let isNegativeMode=false;while(i<selector.length){let valueOrMarker=selector[i];if(typeof valueOrMarker===
"string")if(mode&2){const attrValue=selector[++i];currentChunk+="["+valueOrMarker+(attrValue.length>0?'="'+attrValue+'"':"")+"]"}else if(mode&8)currentChunk+="."+valueOrMarker;else{if(mode&4)currentChunk+=" "+valueOrMarker}else{if(currentChunk!==""&&!isPositive(valueOrMarker)){result+=maybeWrapInNotSelector(isNegativeMode,currentChunk);currentChunk=""}mode=valueOrMarker;isNegativeMode=isNegativeMode||!isPositive(mode)}i++}if(currentChunk!=="")result+=maybeWrapInNotSelector(isNegativeMode,currentChunk);
return result}function stringifyCSSSelectorList(selectorList){return selectorList.map(stringifyCSSSelector).join(",")}function extractAttrsAndClassesFromSelector(selector){const attrs=[];const classes=[];let i=1;let mode=2;while(i<selector.length){let valueOrMarker=selector[i];if(typeof valueOrMarker==="string")if(mode===2){if(valueOrMarker!=="")attrs.push(valueOrMarker,selector[++i])}else{if(mode===8)classes.push(valueOrMarker)}else{if(!isPositive(mode))break;mode=valueOrMarker}i++}return{attrs,
classes}}const NO_CHANGE=typeof ngDevMode==="undefined"||ngDevMode?{__brand__:"NO_CHANGE"}:{};function \u0275\u0275advance(delta){ngDevMode&&assertGreaterThan(delta,0,"Can only advance forward");selectIndexInternal(getTView(),getLView(),getSelectedIndex()+delta,isInCheckNoChangesMode())}function selectIndexInternal(tView,lView,index,checkNoChangesMode){ngDevMode&&assertIndexInDeclRange(lView,index);if(!checkNoChangesMode){const hooksInitPhaseCompleted=(lView[FLAGS]&3)===3;if(hooksInitPhaseCompleted){const preOrderCheckHooks=
tView.preOrderCheckHooks;if(preOrderCheckHooks!==null)executeCheckHooks(lView,preOrderCheckHooks,index)}else{const preOrderHooks=tView.preOrderHooks;if(preOrderHooks!==null)executeInitAndCheckHooks(lView,preOrderHooks,0,index)}}setSelectedIndex(index)}function createNamedArrayType(name){if(ngDevMode)try{return newTrustedFunctionForDev("Array",`return class ${name} extends Array{}`)(Array)}catch(e){return Array}else throw new Error("Looks like we are in 'prod mode', but we are creating a named Array type, which is wrong! Check your code");
}function toTStylingRange(prev,next){ngDevMode&&assertNumberInRange(prev,0,32767);ngDevMode&&assertNumberInRange(next,0,32767);return prev<<17|next<<2}function getTStylingRangePrev(tStylingRange){ngDevMode&&assertNumber(tStylingRange,"expected number");return tStylingRange>>17&32767}function getTStylingRangePrevDuplicate(tStylingRange){ngDevMode&&assertNumber(tStylingRange,"expected number");return(tStylingRange&2)==2}function setTStylingRangePrev(tStylingRange,previous){ngDevMode&&assertNumber(tStylingRange,
"expected number");ngDevMode&&assertNumberInRange(previous,0,32767);return tStylingRange&~4294836224|previous<<17}function setTStylingRangePrevDuplicate(tStylingRange){ngDevMode&&assertNumber(tStylingRange,"expected number");return tStylingRange|2}function getTStylingRangeNext(tStylingRange){ngDevMode&&assertNumber(tStylingRange,"expected number");return(tStylingRange&131068)>>2}function setTStylingRangeNext(tStylingRange,next){ngDevMode&&assertNumber(tStylingRange,"expected number");ngDevMode&&assertNumberInRange(next,
0,32767);return tStylingRange&~131068|next<<2}function getTStylingRangeNextDuplicate(tStylingRange){ngDevMode&&assertNumber(tStylingRange,"expected number");return(tStylingRange&1)===1}function setTStylingRangeNextDuplicate(tStylingRange){ngDevMode&&assertNumber(tStylingRange,"expected number");return tStylingRange|1}function attachDebugObject(obj,debug){if(ngDevMode)Object.defineProperty(obj,"debug",{value:debug,enumerable:false});else throw new Error("This method should be guarded with `ngDevMode` so that it can be tree shaken in production!");
}function attachDebugGetter(obj,debugGetter){if(ngDevMode)Object.defineProperty(obj,"debug",{get:debugGetter,enumerable:false});else throw new Error("This method should be guarded with `ngDevMode` so that it can be tree shaken in production!");}let LVIEW_COMPONENT_CACHE;let LVIEW_EMBEDDED_CACHE;let LVIEW_ROOT;let LVIEW_COMPONENT;let LVIEW_EMBEDDED;function cloneToLViewFromTViewBlueprint(tView){const debugTView=tView;const lView=getLViewToClone(debugTView.type,tView.template&&tView.template.name);
return lView.concat(tView.blueprint)}class LRootView extends Array{}class LComponentView extends Array{}class LEmbeddedView extends Array{}function getLViewToClone(type,name){switch(type){case 0:if(LVIEW_ROOT===undefined)LVIEW_ROOT=new LRootView;return LVIEW_ROOT;case 1:if(!ngDevMode||!ngDevMode.namedConstructors){if(LVIEW_COMPONENT===undefined)LVIEW_COMPONENT=new LComponentView;return LVIEW_COMPONENT}if(LVIEW_COMPONENT_CACHE===undefined)LVIEW_COMPONENT_CACHE=new Map;let componentArray=LVIEW_COMPONENT_CACHE.get(name);
if(componentArray===undefined){componentArray=new (createNamedArrayType("LComponentView"+nameSuffix(name)));LVIEW_COMPONENT_CACHE.set(name,componentArray)}return componentArray;case 2:if(!ngDevMode||!ngDevMode.namedConstructors){if(LVIEW_EMBEDDED===undefined)LVIEW_EMBEDDED=new LEmbeddedView;return LVIEW_EMBEDDED}if(LVIEW_EMBEDDED_CACHE===undefined)LVIEW_EMBEDDED_CACHE=new Map;let embeddedArray=LVIEW_EMBEDDED_CACHE.get(name);if(embeddedArray===undefined){embeddedArray=new (createNamedArrayType("LEmbeddedView"+
nameSuffix(name)));LVIEW_EMBEDDED_CACHE.set(name,embeddedArray)}return embeddedArray}}function nameSuffix(text){if(text==null)return"";const index=text.lastIndexOf("_Template");return"_"+(index===-1?text:text.substr(0,index))}const TViewConstructor=class TView{constructor(type,blueprint,template,queries,viewQuery,declTNode,data,bindingStartIndex,expandoStartIndex,hostBindingOpCodes,firstCreatePass,firstUpdatePass,staticViewQueries,staticContentQueries,preOrderHooks,preOrderCheckHooks,contentHooks,
contentCheckHooks,viewHooks,viewCheckHooks,destroyHooks,cleanup,contentQueries,components,directiveRegistry,pipeRegistry,firstChild,schemas,consts,incompleteFirstPass,_decls,_vars){this.type=type;this.blueprint=blueprint;this.template=template;this.queries=queries;this.viewQuery=viewQuery;this.declTNode=declTNode;this.data=data;this.bindingStartIndex=bindingStartIndex;this.expandoStartIndex=expandoStartIndex;this.hostBindingOpCodes=hostBindingOpCodes;this.firstCreatePass=firstCreatePass;this.firstUpdatePass=
firstUpdatePass;this.staticViewQueries=staticViewQueries;this.staticContentQueries=staticContentQueries;this.preOrderHooks=preOrderHooks;this.preOrderCheckHooks=preOrderCheckHooks;this.contentHooks=contentHooks;this.contentCheckHooks=contentCheckHooks;this.viewHooks=viewHooks;this.viewCheckHooks=viewCheckHooks;this.destroyHooks=destroyHooks;this.cleanup=cleanup;this.contentQueries=contentQueries;this.components=components;this.directiveRegistry=directiveRegistry;this.pipeRegistry=pipeRegistry;this.firstChild=
firstChild;this.schemas=schemas;this.consts=consts;this.incompleteFirstPass=incompleteFirstPass;this._decls=_decls;this._vars=_vars}get template_(){const buf=[];processTNodeChildren(this.firstChild,buf);return buf.join("")}get type_(){return TViewTypeAsString[this.type]||`TViewType.?${this.type}?`}};class TNode{constructor(tView_,type,index,insertBeforeIndex,injectorIndex,directiveStart,directiveEnd,directiveStylingLast,propertyBindings,flags,providerIndexes,value,attrs,mergedAttrs,localNames,initialInputs,
inputs,outputs,tViews,next,projectionNext,child,parent,projection,styles,stylesWithoutHost,residualStyles,classes,classesWithoutHost,residualClasses,classBindings,styleBindings){this.tView_=tView_;this.type=type;this.index=index;this.insertBeforeIndex=insertBeforeIndex;this.injectorIndex=injectorIndex;this.directiveStart=directiveStart;this.directiveEnd=directiveEnd;this.directiveStylingLast=directiveStylingLast;this.propertyBindings=propertyBindings;this.flags=flags;this.providerIndexes=providerIndexes;
this.value=value;this.attrs=attrs;this.mergedAttrs=mergedAttrs;this.localNames=localNames;this.initialInputs=initialInputs;this.inputs=inputs;this.outputs=outputs;this.tViews=tViews;this.next=next;this.projectionNext=projectionNext;this.child=child;this.parent=parent;this.projection=projection;this.styles=styles;this.stylesWithoutHost=stylesWithoutHost;this.residualStyles=residualStyles;this.classes=classes;this.classesWithoutHost=classesWithoutHost;this.residualClasses=residualClasses;this.classBindings=
classBindings;this.styleBindings=styleBindings}debugNodeInjectorPath(lView){const path=[];let injectorIndex=getInjectorIndex(this,lView);if(injectorIndex===-1){const parentLocation=getParentInjectorLocation(this,lView);if(parentLocation!==NO_PARENT_INJECTOR){injectorIndex=getParentInjectorIndex(parentLocation);lView=getParentInjectorView(parentLocation,lView)}}while(injectorIndex!==-1){ngDevMode&&assertNodeInjector(lView,injectorIndex);const tNode=lView[TVIEW].data[injectorIndex+8];path.push(buildDebugNode(tNode,
lView));const parentLocation=lView[injectorIndex+8];if(parentLocation===NO_PARENT_INJECTOR)injectorIndex=-1;else{injectorIndex=getParentInjectorIndex(parentLocation);lView=getParentInjectorView(parentLocation,lView)}}return path}get type_(){return toTNodeTypeAsString(this.type)||`TNodeType.?${this.type}?`}get flags_(){const flags=[];if(this.flags&16)flags.push("TNodeFlags.hasClassInput");if(this.flags&8)flags.push("TNodeFlags.hasContentQuery");if(this.flags&32)flags.push("TNodeFlags.hasStyleInput");
if(this.flags&128)flags.push("TNodeFlags.hasHostBindings");if(this.flags&2)flags.push("TNodeFlags.isComponentHost");if(this.flags&1)flags.push("TNodeFlags.isDirectiveHost");if(this.flags&64)flags.push("TNodeFlags.isDetached");if(this.flags&4)flags.push("TNodeFlags.isProjected");return flags.join("|")}get template_(){if(this.type&1)return this.value;const buf=[];const tagName=typeof this.value==="string"&&this.value||this.type_;buf.push("<",tagName);if(this.flags)buf.push(" ",this.flags_);if(this.attrs)for(let i=
0;i<this.attrs.length;){const attrName=this.attrs[i++];if(typeof attrName=="number")break;const attrValue=this.attrs[i++];buf.push(" ",attrName,'="',attrValue,'"')}buf.push(">");processTNodeChildren(this.child,buf);buf.push("</",tagName,">");return buf.join("")}get styleBindings_(){return toDebugStyleBinding(this,false)}get classBindings_(){return toDebugStyleBinding(this,true)}get providerIndexStart_(){return this.providerIndexes&1048575}get providerIndexEnd_(){return this.providerIndexStart_+(this.providerIndexes>>>
20)}}const TNodeDebug=TNode;function toDebugStyleBinding(tNode,isClassBased){const tData=tNode.tView_.data;const bindings=[];const range=isClassBased?tNode.classBindings:tNode.styleBindings;const prev=getTStylingRangePrev(range);const next=getTStylingRangeNext(range);let isTemplate=next!==0;let cursor=isTemplate?next:prev;while(cursor!==0){const itemKey=tData[cursor];const itemRange=tData[cursor+1];bindings.unshift({key:itemKey,index:cursor,isTemplate:isTemplate,prevDuplicate:getTStylingRangePrevDuplicate(itemRange),
nextDuplicate:getTStylingRangeNextDuplicate(itemRange),nextIndex:getTStylingRangeNext(itemRange),prevIndex:getTStylingRangePrev(itemRange)});if(cursor===prev)isTemplate=false;cursor=getTStylingRangePrev(itemRange)}bindings.push((isClassBased?tNode.residualClasses:tNode.residualStyles)||null);return bindings}function processTNodeChildren(tNode,buf){while(tNode){buf.push(tNode.template_);tNode=tNode.next}}class TViewData extends Array{}let TVIEWDATA_EMPTY;function cloneToTViewData(list){if(TVIEWDATA_EMPTY===
undefined)TVIEWDATA_EMPTY=new TViewData;return TVIEWDATA_EMPTY.concat(list)}class LViewBlueprint extends Array{}class MatchesArray extends Array{}class TViewComponents extends Array{}class TNodeLocalNames extends Array{}class TNodeInitialInputs extends Array{}class LCleanup extends Array{}class TCleanup extends Array{}function attachLViewDebug(lView){attachDebugObject(lView,new LViewDebug(lView))}function attachLContainerDebug(lContainer){attachDebugObject(lContainer,new LContainerDebug(lContainer))}
function toDebug(obj){if(obj){const debug=obj.debug;assertDefined(debug,"Object does not have a debug representation.");return debug}else return obj}function toHtml(value,includeChildren=false){const node=unwrapRNode(value);if(node)switch(node.nodeType){case Node.TEXT_NODE:return node.textContent;case Node.COMMENT_NODE:return`<!--${node.textContent}-->`;case Node.ELEMENT_NODE:const outerHTML=node.outerHTML;if(includeChildren)return outerHTML;else{const innerHTML=">"+node.innerHTML+"<";return outerHTML.split(innerHTML)[0]+
">"}}return null}class LViewDebug{constructor(_raw_lView){this._raw_lView=_raw_lView}get flags(){const flags=this._raw_lView[FLAGS];return{__raw__flags__:flags,initPhaseState:flags&3,creationMode:!!(flags&4),firstViewPass:!!(flags&8),checkAlways:!!(flags&16),dirty:!!(flags&64),attached:!!(flags&128),destroyed:!!(flags&256),isRoot:!!(flags&512),indexWithinInitPhase:flags>>11}}get parent(){return toDebug(this._raw_lView[PARENT])}get hostHTML(){return toHtml(this._raw_lView[HOST],true)}get html(){return(this.nodes||
[]).map(mapToHTML).join("")}get context(){return this._raw_lView[CONTEXT]}get nodes(){const lView=this._raw_lView;const tNode=lView[TVIEW].firstChild;return toDebugNodes(tNode,lView)}get template(){return this.tView.template_}get tView(){return this._raw_lView[TVIEW]}get cleanup(){return this._raw_lView[CLEANUP]}get injector(){return this._raw_lView[INJECTOR$1]}get rendererFactory(){return this._raw_lView[RENDERER_FACTORY]}get renderer(){return this._raw_lView[RENDERER]}get sanitizer(){return this._raw_lView[SANITIZER]}get childHead(){return toDebug(this._raw_lView[CHILD_HEAD])}get next(){return toDebug(this._raw_lView[NEXT])}get childTail(){return toDebug(this._raw_lView[CHILD_TAIL])}get declarationView(){return toDebug(this._raw_lView[DECLARATION_VIEW])}get queries(){return this._raw_lView[QUERIES]}get tHost(){return this._raw_lView[T_HOST]}get decls(){return toLViewRange(this.tView,
this._raw_lView,HEADER_OFFSET,this.tView.bindingStartIndex)}get vars(){return toLViewRange(this.tView,this._raw_lView,this.tView.bindingStartIndex,this.tView.expandoStartIndex)}get expando(){return toLViewRange(this.tView,this._raw_lView,this.tView.expandoStartIndex,this._raw_lView.length)}get childViews(){const childViews=[];let child=this.childHead;while(child){childViews.push(child);child=child.next}return childViews}}function mapToHTML(node){if(node.type==="ElementContainer")return(node.children||
[]).map(mapToHTML).join("");else if(node.type==="IcuContainer")throw new Error("Not implemented");else return toHtml(node.native,true)||""}function toLViewRange(tView,lView,start,end){let content=[];for(let index=start;index<end;index++)content.push({index:index,t:tView.data[index],l:lView[index]});return{start:start,end:end,length:end-start,content:content}}function toDebugNodes(tNode,lView){if(tNode){const debugNodes=[];let tNodeCursor=tNode;while(tNodeCursor){debugNodes.push(buildDebugNode(tNodeCursor,
lView));tNodeCursor=tNodeCursor.next}return debugNodes}else return[]}function buildDebugNode(tNode,lView){const rawValue=lView[tNode.index];const native=unwrapRNode(rawValue);const factories=[];const instances=[];const tView=lView[TVIEW];for(let i=tNode.directiveStart;i<tNode.directiveEnd;i++){const def=tView.data[i];factories.push(def.type);instances.push(lView[i])}return{html:toHtml(native),type:toTNodeTypeAsString(tNode.type),tNode,native:native,children:toDebugNodes(tNode.child,lView),factories,
instances,injector:buildNodeInjectorDebug(tNode,tView,lView),get injectorResolutionPath(){return tNode.debugNodeInjectorPath(lView)}}}function buildNodeInjectorDebug(tNode,tView,lView){const viewProviders=[];for(let i=tNode.providerIndexStart_;i<tNode.providerIndexEnd_;i++)viewProviders.push(tView.data[i]);const providers=[];for(let i=tNode.providerIndexEnd_;i<tNode.directiveEnd;i++)providers.push(tView.data[i]);const nodeInjectorDebug={bloom:toBloom(lView,tNode.injectorIndex),cumulativeBloom:toBloom(tView.data,
tNode.injectorIndex),providers,viewProviders,parentInjectorIndex:lView[tNode.providerIndexStart_-1]};return nodeInjectorDebug}function binary(array,idx){const value=array[idx];if(typeof value!=="number")return"????????";const text="00000000"+value.toString(2);return text.substring(text.length-8)}function toBloom(array,idx){if(idx<0)return"NO_NODE_INJECTOR";return`${binary(array,idx+7)}_${binary(array,idx+6)}_${binary(array,idx+5)}_${binary(array,idx+4)}_${binary(array,idx+3)}_${binary(array,idx+2)}_${binary(array,
idx+1)}_${binary(array,idx+0)}`}class LContainerDebug{constructor(_raw_lContainer){this._raw_lContainer=_raw_lContainer}get hasTransplantedViews(){return this._raw_lContainer[HAS_TRANSPLANTED_VIEWS]}get views(){return this._raw_lContainer.slice(CONTAINER_HEADER_OFFSET).map(toDebug)}get parent(){return toDebug(this._raw_lContainer[PARENT])}get movedViews(){return this._raw_lContainer[MOVED_VIEWS]}get host(){return this._raw_lContainer[HOST]}get native(){return this._raw_lContainer[NATIVE]}get next(){return toDebug(this._raw_lContainer[NEXT])}}
const _CLEAN_PROMISE=(()=>Promise.resolve(null))();function processHostBindingOpCodes(tView,lView){const hostBindingOpCodes=tView.hostBindingOpCodes;if(hostBindingOpCodes===null)return;try{for(let i=0;i<hostBindingOpCodes.length;i++){const opCode=hostBindingOpCodes[i];if(opCode<0)setSelectedIndex(~opCode);else{const directiveIdx=opCode;const bindingRootIndx=hostBindingOpCodes[++i];const hostBindingFn=hostBindingOpCodes[++i];setBindingRootForHostBindings(bindingRootIndx,directiveIdx);const context=
lView[directiveIdx];hostBindingFn(2,context)}}}finally{setSelectedIndex(-1)}}function refreshContentQueries(tView,lView){const contentQueries=tView.contentQueries;if(contentQueries!==null)for(let i=0;i<contentQueries.length;i+=2){const queryStartIdx=contentQueries[i];const directiveDefIdx=contentQueries[i+1];if(directiveDefIdx!==-1){const directiveDef=tView.data[directiveDefIdx];ngDevMode&&assertDefined(directiveDef,"DirectiveDef not found.");ngDevMode&&assertDefined(directiveDef.contentQueries,"contentQueries function should be defined");
setCurrentQueryIndex(queryStartIdx);directiveDef.contentQueries(2,lView[directiveDefIdx],directiveDefIdx)}}}function refreshChildComponents(hostLView,components){for(let i=0;i<components.length;i++)refreshComponent(hostLView,components[i])}function renderChildComponents(hostLView,components){for(let i=0;i<components.length;i++)renderComponent$1(hostLView,components[i])}function createLView(parentLView,tView,context,flags,host,tHostNode,rendererFactory,renderer,sanitizer,injector){const lView=ngDevMode?
cloneToLViewFromTViewBlueprint(tView):tView.blueprint.slice();lView[HOST]=host;lView[FLAGS]=flags|4|128|8;resetPreOrderHookFlags(lView);ngDevMode&&tView.declTNode&&parentLView&&assertTNodeForLView(tView.declTNode,parentLView);lView[PARENT]=lView[DECLARATION_VIEW]=parentLView;lView[CONTEXT]=context;lView[RENDERER_FACTORY]=rendererFactory||parentLView&&parentLView[RENDERER_FACTORY];ngDevMode&&assertDefined(lView[RENDERER_FACTORY],"RendererFactory is required");lView[RENDERER]=renderer||parentLView&&
parentLView[RENDERER];ngDevMode&&assertDefined(lView[RENDERER],"Renderer is required");lView[SANITIZER]=sanitizer||parentLView&&parentLView[SANITIZER]||null;lView[INJECTOR$1]=injector||parentLView&&parentLView[INJECTOR$1]||null;lView[T_HOST]=tHostNode;ngDevMode&&assertEqual(tView.type==2?parentLView!==null:true,true,"Embedded views must have parentLView");lView[DECLARATION_COMPONENT_VIEW]=tView.type==2?parentLView[DECLARATION_COMPONENT_VIEW]:lView;ngDevMode&&attachLViewDebug(lView);return lView}function getOrCreateTNode(tView,
index,type,name,attrs){ngDevMode&&index!==0&&assertGreaterThanOrEqual(index,HEADER_OFFSET,"TNodes can't be in the LView header.");ngDevMode&&assertPureTNodeType(type);let tNode=tView.data[index];if(tNode===null){tNode=createTNodeAtIndex(tView,index,type,name,attrs);if(isInI18nBlock())tNode.flags|=64}else if(tNode.type&64){tNode.type=type;tNode.value=name;tNode.attrs=attrs;const parent=getCurrentParentTNode();tNode.injectorIndex=parent===null?-1:parent.injectorIndex;ngDevMode&&assertTNodeForTView(tNode,
tView);ngDevMode&&assertEqual(index,tNode.index,"Expecting same index")}setCurrentTNode(tNode,true);return tNode}function createTNodeAtIndex(tView,index,type,name,attrs){const currentTNode=getCurrentTNodePlaceholderOk();const isParent=isCurrentTNodeParent();const parent=isParent?currentTNode:currentTNode&&currentTNode.parent;const tNode=tView.data[index]=createTNode(tView,parent,type,index,name,attrs);if(tView.firstChild===null)tView.firstChild=tNode;if(currentTNode!==null)if(isParent){if(currentTNode.child==
null&&tNode.parent!==null)currentTNode.child=tNode}else if(currentTNode.next===null)currentTNode.next=tNode;return tNode}function allocExpando(tView,lView,numSlotsToAlloc,initialValue){if(numSlotsToAlloc===0)return-1;if(ngDevMode){assertFirstCreatePass(tView);assertSame(tView,lView[TVIEW],"`LView` must be associated with `TView`!");assertEqual(tView.data.length,lView.length,"Expecting LView to be same size as TView");assertEqual(tView.data.length,tView.blueprint.length,"Expecting Blueprint to be same size as TView");
assertFirstUpdatePass(tView)}const allocIdx=lView.length;for(let i=0;i<numSlotsToAlloc;i++){lView.push(initialValue);tView.blueprint.push(initialValue);tView.data.push(null)}return allocIdx}function renderView(tView,lView,context){ngDevMode&&assertEqual(isCreationMode(lView),true,"Should be run in creation mode");enterView(lView);try{const viewQuery=tView.viewQuery;if(viewQuery!==null)executeViewQueryFn(1,viewQuery,context);const templateFn=tView.template;if(templateFn!==null)executeTemplate(tView,
lView,templateFn,1,context);if(tView.firstCreatePass)tView.firstCreatePass=false;if(tView.staticContentQueries)refreshContentQueries(tView,lView);if(tView.staticViewQueries)executeViewQueryFn(2,tView.viewQuery,context);const components=tView.components;if(components!==null)renderChildComponents(lView,components)}catch(error){if(tView.firstCreatePass){tView.incompleteFirstPass=true;tView.firstCreatePass=false}throw error;}finally{lView[FLAGS]&=~4;leaveView()}}function refreshView(tView,lView,templateFn,
context){ngDevMode&&assertEqual(isCreationMode(lView),false,"Should be run in update mode");const flags=lView[FLAGS];if((flags&256)===256)return;enterView(lView);const isInCheckNoChangesPass=isInCheckNoChangesMode();try{resetPreOrderHookFlags(lView);setBindingIndex(tView.bindingStartIndex);if(templateFn!==null)executeTemplate(tView,lView,templateFn,2,context);const hooksInitPhaseCompleted=(flags&3)===3;if(!isInCheckNoChangesPass)if(hooksInitPhaseCompleted){const preOrderCheckHooks=tView.preOrderCheckHooks;
if(preOrderCheckHooks!==null)executeCheckHooks(lView,preOrderCheckHooks,null)}else{const preOrderHooks=tView.preOrderHooks;if(preOrderHooks!==null)executeInitAndCheckHooks(lView,preOrderHooks,0,null);incrementInitPhaseFlags(lView,0)}markTransplantedViewsForRefresh(lView);refreshEmbeddedViews(lView);if(tView.contentQueries!==null)refreshContentQueries(tView,lView);if(!isInCheckNoChangesPass)if(hooksInitPhaseCompleted){const contentCheckHooks=tView.contentCheckHooks;if(contentCheckHooks!==null)executeCheckHooks(lView,
contentCheckHooks)}else{const contentHooks=tView.contentHooks;if(contentHooks!==null)executeInitAndCheckHooks(lView,contentHooks,1);incrementInitPhaseFlags(lView,1)}processHostBindingOpCodes(tView,lView);const components=tView.components;if(components!==null)refreshChildComponents(lView,components);const viewQuery=tView.viewQuery;if(viewQuery!==null)executeViewQueryFn(2,viewQuery,context);if(!isInCheckNoChangesPass)if(hooksInitPhaseCompleted){const viewCheckHooks=tView.viewCheckHooks;if(viewCheckHooks!==
null)executeCheckHooks(lView,viewCheckHooks)}else{const viewHooks=tView.viewHooks;if(viewHooks!==null)executeInitAndCheckHooks(lView,viewHooks,2);incrementInitPhaseFlags(lView,2)}if(tView.firstUpdatePass===true)tView.firstUpdatePass=false;if(!isInCheckNoChangesPass)lView[FLAGS]&=~(64|8);if(lView[FLAGS]&1024){lView[FLAGS]&=~1024;updateTransplantedViewCount(lView[PARENT],-1)}}finally{leaveView()}}function renderComponentOrTemplate(tView,lView,templateFn,context){const rendererFactory=lView[RENDERER_FACTORY];
const normalExecutionPath=!isInCheckNoChangesMode();const creationModeIsActive=isCreationMode(lView);try{if(normalExecutionPath&&!creationModeIsActive&&rendererFactory.begin)rendererFactory.begin();if(creationModeIsActive)renderView(tView,lView,context);refreshView(tView,lView,templateFn,context)}finally{if(normalExecutionPath&&!creationModeIsActive&&rendererFactory.end)rendererFactory.end()}}function executeTemplate(tView,lView,templateFn,rf,context){const prevSelectedIndex=getSelectedIndex();const isUpdatePhase=
rf&2;try{setSelectedIndex(-1);if(isUpdatePhase&&lView.length>HEADER_OFFSET)selectIndexInternal(tView,lView,HEADER_OFFSET,isInCheckNoChangesMode());const preHookType=isUpdatePhase?2:0;profiler(preHookType,context);templateFn(rf,context)}finally{setSelectedIndex(prevSelectedIndex);const postHookType=isUpdatePhase?3:1;profiler(postHookType,context)}}function executeContentQueries(tView,tNode,lView){if(isContentQueryHost(tNode)){const start=tNode.directiveStart;const end=tNode.directiveEnd;for(let directiveIndex=
start;directiveIndex<end;directiveIndex++){const def=tView.data[directiveIndex];if(def.contentQueries)def.contentQueries(1,lView[directiveIndex],directiveIndex)}}}function createDirectivesInstances(tView,lView,tNode){if(!getBindingsEnabled())return;instantiateAllDirectives(tView,lView,tNode,getNativeByTNode(tNode,lView));if((tNode.flags&128)===128)invokeDirectivesHostBindings(tView,lView,tNode)}function saveResolvedLocalsInData(viewData,tNode,localRefExtractor=getNativeByTNode){const localNames=tNode.localNames;
if(localNames!==null){let localIndex=tNode.index+1;for(let i=0;i<localNames.length;i+=2){const index=localNames[i+1];const value=index===-1?localRefExtractor(tNode,viewData):viewData[index];viewData[localIndex++]=value}}}function getOrCreateTComponentView(def){const tView=def.tView;if(tView===null||tView.incompleteFirstPass){const declTNode=null;return def.tView=createTView(1,declTNode,def.template,def.decls,def.vars,def.directiveDefs,def.pipeDefs,def.viewQuery,def.schemas,def.consts)}return tView}
function createTView(type,declTNode,templateFn,decls,vars,directives,pipes,viewQuery,schemas,constsOrFactory){ngDevMode&&ngDevMode.tView++;const bindingStartIndex=HEADER_OFFSET+decls;const initialViewLength=bindingStartIndex+vars;const blueprint=createViewBlueprint(bindingStartIndex,initialViewLength);const consts=typeof constsOrFactory==="function"?constsOrFactory():constsOrFactory;const tView=blueprint[TVIEW]=ngDevMode?new TViewConstructor(type,blueprint,templateFn,null,viewQuery,declTNode,cloneToTViewData(blueprint).fill(null,
bindingStartIndex),bindingStartIndex,initialViewLength,null,true,true,false,false,null,null,null,null,null,null,null,null,null,null,typeof directives==="function"?directives():directives,typeof pipes==="function"?pipes():pipes,null,schemas,consts,false,decls,vars):{type:type,blueprint:blueprint,template:templateFn,queries:null,viewQuery:viewQuery,declTNode:declTNode,data:blueprint.slice().fill(null,bindingStartIndex),bindingStartIndex:bindingStartIndex,expandoStartIndex:initialViewLength,hostBindingOpCodes:null,
firstCreatePass:true,firstUpdatePass:true,staticViewQueries:false,staticContentQueries:false,preOrderHooks:null,preOrderCheckHooks:null,contentHooks:null,contentCheckHooks:null,viewHooks:null,viewCheckHooks:null,destroyHooks:null,cleanup:null,contentQueries:null,components:null,directiveRegistry:typeof directives==="function"?directives():directives,pipeRegistry:typeof pipes==="function"?pipes():pipes,firstChild:null,schemas:schemas,consts:consts,incompleteFirstPass:false};if(ngDevMode)Object.seal(tView);
return tView}function createViewBlueprint(bindingStartIndex,initialViewLength){const blueprint=ngDevMode?new LViewBlueprint:[];for(let i=0;i<initialViewLength;i++)blueprint.push(i<bindingStartIndex?null:NO_CHANGE);return blueprint}function createError(text,token){return new Error(`Renderer: ${text} [${stringifyForError(token)}]`)}function assertHostNodeExists(rElement,elementOrSelector){if(!rElement)if(typeof elementOrSelector==="string")throw createError("Host node with selector not found:",elementOrSelector);
else throw createError("Host node is required:",elementOrSelector);}function locateHostElement(renderer,elementOrSelector,encapsulation){if(isProceduralRenderer(renderer)){const preserveContent=encapsulation===exports.ViewEncapsulation.ShadowDom;return renderer.selectRootElement(elementOrSelector,preserveContent)}let rElement=typeof elementOrSelector==="string"?renderer.querySelector(elementOrSelector):elementOrSelector;ngDevMode&&assertHostNodeExists(rElement,elementOrSelector);rElement.textContent=
"";return rElement}function storeCleanupWithContext(tView,lView,context,cleanupFn){const lCleanup=getOrCreateLViewCleanup(lView);if(context===null){if(ngDevMode)Object.freeze(getOrCreateTViewCleanup(tView));lCleanup.push(cleanupFn)}else{lCleanup.push(context);if(tView.firstCreatePass)getOrCreateTViewCleanup(tView).push(cleanupFn,lCleanup.length-1)}}function createTNode(tView,tParent,type,index,value,attrs){ngDevMode&&index!==0&&assertGreaterThanOrEqual(index,HEADER_OFFSET,"TNodes can't be in the LView header.");
ngDevMode&&assertNotSame(attrs,undefined,"'undefined' is not valid value for 'attrs'");ngDevMode&&ngDevMode.tNode++;ngDevMode&&tParent&&assertTNodeForTView(tParent,tView);let injectorIndex=tParent?tParent.injectorIndex:-1;const tNode=ngDevMode?new TNodeDebug(tView,type,index,null,injectorIndex,-1,-1,-1,null,0,0,value,attrs,null,null,undefined,null,null,null,null,null,null,tParent,null,null,null,undefined,null,null,undefined,0,0):{type,index,insertBeforeIndex:null,injectorIndex,directiveStart:-1,directiveEnd:-1,
directiveStylingLast:-1,propertyBindings:null,flags:0,providerIndexes:0,value:value,attrs:attrs,mergedAttrs:null,localNames:null,initialInputs:undefined,inputs:null,outputs:null,tViews:null,next:null,projectionNext:null,child:null,parent:tParent,projection:null,styles:null,stylesWithoutHost:null,residualStyles:undefined,classes:null,classesWithoutHost:null,residualClasses:undefined,classBindings:0,styleBindings:0};if(ngDevMode)Object.seal(tNode);return tNode}function generatePropertyAliases(inputAliasMap,
directiveDefIdx,propStore){for(let publicName in inputAliasMap)if(inputAliasMap.hasOwnProperty(publicName)){propStore=propStore===null?{}:propStore;const internalName=inputAliasMap[publicName];if(propStore.hasOwnProperty(publicName))propStore[publicName].push(directiveDefIdx,internalName);else propStore[publicName]=[directiveDefIdx,internalName]}return propStore}function initializeInputAndOutputAliases(tView,tNode){ngDevMode&&assertFirstCreatePass(tView);const start=tNode.directiveStart;const end=
tNode.directiveEnd;const tViewData=tView.data;const tNodeAttrs=tNode.attrs;const inputsFromAttrs=ngDevMode?new TNodeInitialInputs:[];let inputsStore=null;let outputsStore=null;for(let i=start;i<end;i++){const directiveDef=tViewData[i];const directiveInputs=directiveDef.inputs;const initialInputs=tNodeAttrs!==null&&!isInlineTemplate(tNode)?generateInitialInputs(directiveInputs,tNodeAttrs):null;inputsFromAttrs.push(initialInputs);inputsStore=generatePropertyAliases(directiveInputs,i,inputsStore);outputsStore=
generatePropertyAliases(directiveDef.outputs,i,outputsStore)}if(inputsStore!==null){if(inputsStore.hasOwnProperty("class"))tNode.flags|=16;if(inputsStore.hasOwnProperty("style"))tNode.flags|=32}tNode.initialInputs=inputsFromAttrs;tNode.inputs=inputsStore;tNode.outputs=outputsStore}function mapPropName(name){if(name==="class")return"className";if(name==="for")return"htmlFor";if(name==="formaction")return"formAction";if(name==="innerHtml")return"innerHTML";if(name==="readonly")return"readOnly";if(name===
"tabindex")return"tabIndex";return name}function elementPropertyInternal(tView,tNode,lView,propName,value,renderer,sanitizer,nativeOnly){ngDevMode&&assertNotSame(value,NO_CHANGE,"Incoming value should never be NO_CHANGE.");const element=getNativeByTNode(tNode,lView);let inputData=tNode.inputs;let dataValue;if(!nativeOnly&&inputData!=null&&(dataValue=inputData[propName])){setInputsForProperty(tView,lView,dataValue,propName,value);if(isComponentHost(tNode))markDirtyIfOnPush(lView,tNode.index);if(ngDevMode)setNgReflectProperties(lView,
element,tNode.type,dataValue,value)}else if(tNode.type&3){propName=mapPropName(propName);if(ngDevMode){validateAgainstEventProperties(propName);if(!validateProperty(tView,element,propName,tNode)){logUnknownPropertyError(propName,tNode);return}ngDevMode.rendererSetProperty++}value=sanitizer!=null?sanitizer(value,tNode.value||"",propName):value;if(isProceduralRenderer(renderer))renderer.setProperty(element,propName,value);else if(!isAnimationProp(propName))element.setProperty?element.setProperty(propName,
value):element[propName]=value}else if(tNode.type&12)if(ngDevMode&&!matchingSchemas(tView,tNode.value))logUnknownPropertyError(propName,tNode)}function markDirtyIfOnPush(lView,viewIndex){ngDevMode&&assertLView(lView);const childComponentLView=getComponentLViewByIndex(viewIndex,lView);if(!(childComponentLView[FLAGS]&16))childComponentLView[FLAGS]|=64}function setNgReflectProperty(lView,element,type,attrName,value){const renderer=lView[RENDERER];attrName=normalizeDebugBindingName(attrName);const debugValue=
normalizeDebugBindingValue(value);if(type&3)if(value==null)isProceduralRenderer(renderer)?renderer.removeAttribute(element,attrName):element.removeAttribute(attrName);else isProceduralRenderer(renderer)?renderer.setAttribute(element,attrName,debugValue):element.setAttribute(attrName,debugValue);else{const textContent=escapeCommentText(`bindings=${JSON.stringify({[attrName]:debugValue},null,2)}`);if(isProceduralRenderer(renderer))renderer.setValue(element,textContent);else element.textContent=textContent}}
function setNgReflectProperties(lView,element,type,dataValue,value){if(type&(3|4))for(let i=0;i<dataValue.length;i+=2)setNgReflectProperty(lView,element,type,dataValue[i+1],value)}function validateProperty(tView,element,propName,tNode){if(tView.schemas===null)return true;if(matchingSchemas(tView,tNode.value)||propName in element||isAnimationProp(propName))return true;return typeof Node==="undefined"||Node===null||!(element instanceof Node)}function matchingSchemas(tView,tagName){const schemas=tView.schemas;
if(schemas!==null)for(let i=0;i<schemas.length;i++){const schema=schemas[i];if(schema===NO_ERRORS_SCHEMA||schema===CUSTOM_ELEMENTS_SCHEMA&&tagName&&tagName.indexOf("-")>-1)return true}return false}function logUnknownPropertyError(propName,tNode){let message=`Can't bind to '${propName}' since it isn't a known property of '${tNode.value}'.`;console.error(formatRuntimeError(303,message))}function instantiateRootComponent(tView,lView,def){const rootTNode=getCurrentTNode();if(tView.firstCreatePass){if(def.providersResolver)def.providersResolver(def);
const directiveIndex=allocExpando(tView,lView,1,null);ngDevMode&&assertEqual(directiveIndex,rootTNode.directiveStart,"Because this is a root component the allocated expando should match the TNode component.");configureViewWithDirective(tView,rootTNode,lView,directiveIndex,def)}const directive=getNodeInjectable(lView,tView,rootTNode.directiveStart,rootTNode);attachPatchData(directive,lView);const native=getNativeByTNode(rootTNode,lView);if(native)attachPatchData(native,lView);return directive}function resolveDirectives(tView,
lView,tNode,localRefs){ngDevMode&&assertFirstCreatePass(tView);let hasDirectives=false;if(getBindingsEnabled()){const directiveDefs=findDirectiveDefMatches(tView,lView,tNode);const exportsMap=localRefs===null?null:{"":-1};if(directiveDefs!==null){hasDirectives=true;initTNodeFlags(tNode,tView.data.length,directiveDefs.length);for(let i=0;i<directiveDefs.length;i++){const def=directiveDefs[i];if(def.providersResolver)def.providersResolver(def)}let preOrderHooksFound=false;let preOrderCheckHooksFound=
false;let directiveIdx=allocExpando(tView,lView,directiveDefs.length,null);ngDevMode&&assertSame(directiveIdx,tNode.directiveStart,"TNode.directiveStart should point to just allocated space");for(let i=0;i<directiveDefs.length;i++){const def=directiveDefs[i];tNode.mergedAttrs=mergeHostAttrs(tNode.mergedAttrs,def.hostAttrs);configureViewWithDirective(tView,tNode,lView,directiveIdx,def);saveNameToExportMap(directiveIdx,def,exportsMap);if(def.contentQueries!==null)tNode.flags|=8;if(def.hostBindings!==
null||def.hostAttrs!==null||def.hostVars!==0)tNode.flags|=128;const lifeCycleHooks=def.type.prototype;if(!preOrderHooksFound&&(lifeCycleHooks.ngOnChanges||lifeCycleHooks.ngOnInit||lifeCycleHooks.ngDoCheck)){(tView.preOrderHooks||(tView.preOrderHooks=[])).push(tNode.index);preOrderHooksFound=true}if(!preOrderCheckHooksFound&&(lifeCycleHooks.ngOnChanges||lifeCycleHooks.ngDoCheck)){(tView.preOrderCheckHooks||(tView.preOrderCheckHooks=[])).push(tNode.index);preOrderCheckHooksFound=true}directiveIdx++}initializeInputAndOutputAliases(tView,
tNode)}if(exportsMap)cacheMatchingLocalNames(tNode,localRefs,exportsMap)}tNode.mergedAttrs=mergeHostAttrs(tNode.mergedAttrs,tNode.attrs);return hasDirectives}function registerHostBindingOpCodes(tView,tNode,lView,directiveIdx,directiveVarsIdx,def){ngDevMode&&assertFirstCreatePass(tView);const hostBindings=def.hostBindings;if(hostBindings){let hostBindingOpCodes=tView.hostBindingOpCodes;if(hostBindingOpCodes===null)hostBindingOpCodes=tView.hostBindingOpCodes=[];const elementIndx=~tNode.index;if(lastSelectedElementIdx(hostBindingOpCodes)!=
elementIndx)hostBindingOpCodes.push(elementIndx);hostBindingOpCodes.push(directiveIdx,directiveVarsIdx,hostBindings)}}function lastSelectedElementIdx(hostBindingOpCodes){let i=hostBindingOpCodes.length;while(i>0){const value=hostBindingOpCodes[--i];if(typeof value==="number"&&value<0)return value}return 0}function instantiateAllDirectives(tView,lView,tNode,native){const start=tNode.directiveStart;const end=tNode.directiveEnd;if(!tView.firstCreatePass)getOrCreateNodeInjectorForNode(tNode,lView);attachPatchData(native,
lView);const initialInputs=tNode.initialInputs;for(let i=start;i<end;i++){const def=tView.data[i];const isComponent=isComponentDef(def);if(isComponent){ngDevMode&&assertTNodeType(tNode,3);addComponentLogic(lView,tNode,def)}const directive=getNodeInjectable(lView,tView,i,tNode);attachPatchData(directive,lView);if(initialInputs!==null)setInputsFromAttrs(lView,i-start,directive,def,tNode,initialInputs);if(isComponent){const componentView=getComponentLViewByIndex(tNode.index,lView);componentView[CONTEXT]=
directive}}}function invokeDirectivesHostBindings(tView,lView,tNode){const start=tNode.directiveStart;const end=tNode.directiveEnd;tView.firstCreatePass;const elementIndex=tNode.index;const currentDirectiveIndex=getCurrentDirectiveIndex();try{setSelectedIndex(elementIndex);for(let dirIndex=start;dirIndex<end;dirIndex++){const def=tView.data[dirIndex];const directive=lView[dirIndex];setCurrentDirectiveIndex(dirIndex);if(def.hostBindings!==null||def.hostVars!==0||def.hostAttrs!==null)invokeHostBindingsInCreationMode(def,
directive)}}finally{setSelectedIndex(-1);setCurrentDirectiveIndex(currentDirectiveIndex)}}function invokeHostBindingsInCreationMode(def,directive){if(def.hostBindings!==null)def.hostBindings(1,directive)}function findDirectiveDefMatches(tView,viewData,tNode){ngDevMode&&assertFirstCreatePass(tView);ngDevMode&&assertTNodeType(tNode,3|12);const registry=tView.directiveRegistry;let matches=null;if(registry)for(let i=0;i<registry.length;i++){const def=registry[i];if(isNodeMatchingSelectorList(tNode,def.selectors,
false)){matches||(matches=ngDevMode?new MatchesArray:[]);diPublicInInjector(getOrCreateNodeInjectorForNode(tNode,viewData),tView,def.type);if(isComponentDef(def)){if(ngDevMode){assertTNodeType(tNode,2,`"${tNode.value}" tags cannot be used as component hosts. `+`Please use a different tag to activate the ${stringify(def.type)} component.`);if(tNode.flags&2)throwMultipleComponentError(tNode)}markAsComponentHost(tView,tNode);matches.unshift(def)}else matches.push(def)}}return matches}function markAsComponentHost(tView,
hostTNode){ngDevMode&&assertFirstCreatePass(tView);hostTNode.flags|=2;(tView.components||(tView.components=ngDevMode?new TViewComponents:[])).push(hostTNode.index)}function cacheMatchingLocalNames(tNode,localRefs,exportsMap){if(localRefs){const localNames=tNode.localNames=ngDevMode?new TNodeLocalNames:[];for(let i=0;i<localRefs.length;i+=2){const index=exportsMap[localRefs[i+1]];if(index==null)throw new RuntimeError(-301,`Export of name '${localRefs[i+1]}' not found!`);localNames.push(localRefs[i],
index)}}}function saveNameToExportMap(directiveIdx,def,exportsMap){if(exportsMap){if(def.exportAs)for(let i=0;i<def.exportAs.length;i++)exportsMap[def.exportAs[i]]=directiveIdx;if(isComponentDef(def))exportsMap[""]=directiveIdx}}function initTNodeFlags(tNode,index,numberOfDirectives){ngDevMode&&assertNotEqual(numberOfDirectives,tNode.directiveEnd-tNode.directiveStart,"Reached the max number of directives");tNode.flags|=1;tNode.directiveStart=index;tNode.directiveEnd=index+numberOfDirectives;tNode.providerIndexes=
index}function configureViewWithDirective(tView,tNode,lView,directiveIndex,def){ngDevMode&&assertGreaterThanOrEqual(directiveIndex,HEADER_OFFSET,"Must be in Expando section");tView.data[directiveIndex]=def;const directiveFactory=def.factory||(def.factory=getFactoryDef(def.type,true));const nodeInjectorFactory=new NodeInjectorFactory(directiveFactory,isComponentDef(def),null);tView.blueprint[directiveIndex]=nodeInjectorFactory;lView[directiveIndex]=nodeInjectorFactory;registerHostBindingOpCodes(tView,
tNode,lView,directiveIndex,allocExpando(tView,lView,def.hostVars,NO_CHANGE),def)}function addComponentLogic(lView,hostTNode,def){const native=getNativeByTNode(hostTNode,lView);const tView=getOrCreateTComponentView(def);const rendererFactory=lView[RENDERER_FACTORY];const componentView=addToViewTree(lView,createLView(lView,tView,null,def.onPush?64:16,native,hostTNode,rendererFactory,rendererFactory.createRenderer(native,def),null,null));lView[hostTNode.index]=componentView}function elementAttributeInternal(tNode,
lView,name,value,sanitizer,namespace){if(ngDevMode){assertNotSame(value,NO_CHANGE,"Incoming value should never be NO_CHANGE.");validateAgainstEventAttributes(name);assertTNodeType(tNode,2,`Attempted to set attribute \`${name}\` on a container node. `+`Host bindings are not valid on ng-container or ng-template.`)}const element=getNativeByTNode(tNode,lView);setElementAttribute(lView[RENDERER],element,namespace,tNode.value,name,value,sanitizer)}function setElementAttribute(renderer,element,namespace,
tagName,name,value,sanitizer){if(value==null){ngDevMode&&ngDevMode.rendererRemoveAttribute++;isProceduralRenderer(renderer)?renderer.removeAttribute(element,name,namespace):element.removeAttribute(name)}else{ngDevMode&&ngDevMode.rendererSetAttribute++;const strValue=sanitizer==null?renderStringify(value):sanitizer(value,tagName||"",name);if(isProceduralRenderer(renderer))renderer.setAttribute(element,name,strValue,namespace);else namespace?element.setAttributeNS(namespace,name,strValue):element.setAttribute(name,
strValue)}}function setInputsFromAttrs(lView,directiveIndex,instance,def,tNode,initialInputData){const initialInputs=initialInputData[directiveIndex];if(initialInputs!==null){const setInput=def.setInput;for(let i=0;i<initialInputs.length;){const publicName=initialInputs[i++];const privateName=initialInputs[i++];const value=initialInputs[i++];if(setInput!==null)def.setInput(instance,value,publicName,privateName);else instance[privateName]=value;if(ngDevMode){const nativeElement=getNativeByTNode(tNode,
lView);setNgReflectProperty(lView,nativeElement,tNode.type,privateName,value)}}}}function generateInitialInputs(inputs,attrs){let inputsToStore=null;let i=0;while(i<attrs.length){const attrName=attrs[i];if(attrName===0){i+=4;continue}else if(attrName===5){i+=2;continue}if(typeof attrName==="number")break;if(inputs.hasOwnProperty(attrName)){if(inputsToStore===null)inputsToStore=[];inputsToStore.push(attrName,inputs[attrName],attrs[i+1])}i+=2}return inputsToStore}const LContainerArray=class LContainer extends Array{};
function createLContainer(hostNative,currentView,native,tNode){ngDevMode&&assertLView(currentView);ngDevMode&&!isProceduralRenderer(currentView[RENDERER])&&assertDomNode(native);const lContainer=new (ngDevMode?LContainerArray:Array)(hostNative,true,false,currentView,null,0,tNode,native,null,null);ngDevMode&&assertEqual(lContainer.length,CONTAINER_HEADER_OFFSET,"Should allocate correct number of slots for LContainer header.");ngDevMode&&attachLContainerDebug(lContainer);return lContainer}function refreshEmbeddedViews(lView){for(let lContainer=
getFirstLContainer(lView);lContainer!==null;lContainer=getNextLContainer(lContainer))for(let i=CONTAINER_HEADER_OFFSET;i<lContainer.length;i++){const embeddedLView=lContainer[i];const embeddedTView=embeddedLView[TVIEW];ngDevMode&&assertDefined(embeddedTView,"TView must be allocated");if(viewAttachedToChangeDetector(embeddedLView))refreshView(embeddedTView,embeddedLView,embeddedTView.template,embeddedLView[CONTEXT])}}function markTransplantedViewsForRefresh(lView){for(let lContainer=getFirstLContainer(lView);lContainer!==
null;lContainer=getNextLContainer(lContainer)){if(!lContainer[HAS_TRANSPLANTED_VIEWS])continue;const movedViews=lContainer[MOVED_VIEWS];ngDevMode&&assertDefined(movedViews,"Transplanted View flags set but missing MOVED_VIEWS");for(let i=0;i<movedViews.length;i++){const movedLView=movedViews[i];const insertionLContainer=movedLView[PARENT];ngDevMode&&assertLContainer(insertionLContainer);if((movedLView[FLAGS]&1024)===0)updateTransplantedViewCount(insertionLContainer,1);movedLView[FLAGS]|=1024}}}function refreshComponent(hostLView,
componentHostIdx){ngDevMode&&assertEqual(isCreationMode(hostLView),false,"Should be run in update mode");const componentView=getComponentLViewByIndex(componentHostIdx,hostLView);if(viewAttachedToChangeDetector(componentView)){const tView=componentView[TVIEW];if(componentView[FLAGS]&(16|64))refreshView(tView,componentView,tView.template,componentView[CONTEXT]);else if(componentView[TRANSPLANTED_VIEWS_TO_REFRESH]>0)refreshContainsDirtyView(componentView)}}function refreshContainsDirtyView(lView){for(let lContainer=
getFirstLContainer(lView);lContainer!==null;lContainer=getNextLContainer(lContainer))for(let i=CONTAINER_HEADER_OFFSET;i<lContainer.length;i++){const embeddedLView=lContainer[i];if(embeddedLView[FLAGS]&1024){const embeddedTView=embeddedLView[TVIEW];ngDevMode&&assertDefined(embeddedTView,"TView must be allocated");refreshView(embeddedTView,embeddedLView,embeddedTView.template,embeddedLView[CONTEXT])}else if(embeddedLView[TRANSPLANTED_VIEWS_TO_REFRESH]>0)refreshContainsDirtyView(embeddedLView)}const tView=
lView[TVIEW];const components=tView.components;if(components!==null)for(let i=0;i<components.length;i++){const componentView=getComponentLViewByIndex(components[i],lView);if(viewAttachedToChangeDetector(componentView)&&componentView[TRANSPLANTED_VIEWS_TO_REFRESH]>0)refreshContainsDirtyView(componentView)}}function renderComponent$1(hostLView,componentHostIdx){ngDevMode&&assertEqual(isCreationMode(hostLView),true,"Should be run in creation mode");const componentView=getComponentLViewByIndex(componentHostIdx,
hostLView);const componentTView=componentView[TVIEW];syncViewWithBlueprint(componentTView,componentView);renderView(componentTView,componentView,componentView[CONTEXT])}function syncViewWithBlueprint(tView,lView){for(let i=lView.length;i<tView.blueprint.length;i++)lView.push(tView.blueprint[i])}function addToViewTree(lView,lViewOrLContainer){if(lView[CHILD_HEAD])lView[CHILD_TAIL][NEXT]=lViewOrLContainer;else lView[CHILD_HEAD]=lViewOrLContainer;lView[CHILD_TAIL]=lViewOrLContainer;return lViewOrLContainer}
function markViewDirty(lView){while(lView){lView[FLAGS]|=64;const parent=getLViewParent(lView);if(isRootView(lView)&&!parent)return lView;lView=parent}return null}function scheduleTick(rootContext,flags){const nothingScheduled=rootContext.flags===0;if(nothingScheduled&&rootContext.clean==_CLEAN_PROMISE){rootContext.flags|=flags;let res;rootContext.clean=new Promise(r=>res=r);rootContext.scheduler(()=>{if(rootContext.flags&1){rootContext.flags&=~1;tickRootContext(rootContext)}if(rootContext.flags&
2){rootContext.flags&=~2;const playerHandler=rootContext.playerHandler;if(playerHandler)playerHandler.flushPlayers()}rootContext.clean=_CLEAN_PROMISE;res(null)})}}function tickRootContext(rootContext){for(let i=0;i<rootContext.components.length;i++){const rootComponent=rootContext.components[i];const lView=readPatchedLView(rootComponent);const tView=lView[TVIEW];renderComponentOrTemplate(tView,lView,tView.template,rootComponent)}}function detectChangesInternal(tView,lView,context){const rendererFactory=
lView[RENDERER_FACTORY];if(rendererFactory.begin)rendererFactory.begin();try{refreshView(tView,lView,tView.template,context)}catch(error){handleError(lView,error);throw error;}finally{if(rendererFactory.end)rendererFactory.end()}}function detectChangesInRootView(lView){tickRootContext(lView[CONTEXT])}function checkNoChangesInternal(tView,view,context){setIsInCheckNoChangesMode(true);try{detectChangesInternal(tView,view,context)}finally{setIsInCheckNoChangesMode(false)}}function checkNoChangesInRootView(lView){setIsInCheckNoChangesMode(true);
try{detectChangesInRootView(lView)}finally{setIsInCheckNoChangesMode(false)}}function executeViewQueryFn(flags,viewQueryFn,component){ngDevMode&&assertDefined(viewQueryFn,"View queries function to execute must be defined.");setCurrentQueryIndex(0);viewQueryFn(flags,component)}function storePropertyBindingMetadata(tData,tNode,propertyName,bindingIndex,...interpolationParts){if(tData[bindingIndex]===null)if(tNode.inputs==null||!tNode.inputs[propertyName]){const propBindingIdxs=tNode.propertyBindings||
(tNode.propertyBindings=[]);propBindingIdxs.push(bindingIndex);let bindingMetadata=propertyName;if(interpolationParts.length>0)bindingMetadata+=INTERPOLATION_DELIMITER+interpolationParts.join(INTERPOLATION_DELIMITER);tData[bindingIndex]=bindingMetadata}}const CLEAN_PROMISE=_CLEAN_PROMISE;function getOrCreateLViewCleanup(view){return view[CLEANUP]||(view[CLEANUP]=ngDevMode?new LCleanup:[])}function getOrCreateTViewCleanup(tView){return tView.cleanup||(tView.cleanup=ngDevMode?new TCleanup:[])}function loadComponentRenderer(currentDef,
tNode,lView){if(currentDef===null||isComponentDef(currentDef))lView=unwrapLView(lView[tNode.index]);return lView[RENDERER]}function handleError(lView,error){const injector=lView[INJECTOR$1];const errorHandler=injector?injector.get(ErrorHandler,null):null;errorHandler&&errorHandler.handleError(error)}function setInputsForProperty(tView,lView,inputs,publicName,value){for(let i=0;i<inputs.length;){const index=inputs[i++];const privateName=inputs[i++];const instance=lView[index];ngDevMode&&assertIndexInRange(lView,
index);const def=tView.data[index];if(def.setInput!==null)def.setInput(instance,value,publicName,privateName);else instance[privateName]=value}}function textBindingInternal(lView,index,value){ngDevMode&&assertString(value,"Value should be a string");ngDevMode&&assertNotSame(value,NO_CHANGE,"value should not be NO_CHANGE");ngDevMode&&assertIndexInRange(lView,index);const element=getNativeByIndex(index,lView);ngDevMode&&assertDefined(element,"native element should exist");updateTextNode(lView[RENDERER],
element,value)}function computeStaticStyling(tNode,attrs,writeToHost){ngDevMode&&assertFirstCreatePass(getTView(),"Expecting to be called in first template pass only");let styles=writeToHost?tNode.styles:null;let classes=writeToHost?tNode.classes:null;let mode=0;if(attrs!==null)for(let i=0;i<attrs.length;i++){const value=attrs[i];if(typeof value==="number")mode=value;else if(mode==1)classes=concatStringsWithSpace(classes,value);else if(mode==2){const style=value;const styleValue=attrs[++i];styles=
concatStringsWithSpace(styles,style+": "+styleValue+";")}}writeToHost?tNode.styles=styles:tNode.stylesWithoutHost=styles;writeToHost?tNode.classes=classes:tNode.classesWithoutHost=classes}function detectChanges(component){const view=getComponentViewByInstance(component);detectChangesInternal(view[TVIEW],view,component)}function markDirty(component){ngDevMode&&assertDefined(component,"component");const rootView=markViewDirty(getComponentViewByInstance(component));ngDevMode&&assertDefined(rootView[CONTEXT],
"rootContext should be defined");scheduleTick(rootView[CONTEXT],1)}const INJECTOR=new InjectionToken("INJECTOR",-1);class NullInjector{get(token,notFoundValue=THROW_IF_NOT_FOUND){if(notFoundValue===THROW_IF_NOT_FOUND){const error=new Error(`NullInjectorError: No provider for ${stringify(token)}!`);error.name="NullInjectorError";throw error;}return notFoundValue}}const INJECTOR_SCOPE=new InjectionToken("Set Injector scope.");const NOT_YET={};const CIRCULAR={};let NULL_INJECTOR$1=undefined;function getNullInjector(){if(NULL_INJECTOR$1===
undefined)NULL_INJECTOR$1=new NullInjector;return NULL_INJECTOR$1}function createInjector(defType,parent=null,additionalProviders=null,name){const injector=createInjectorWithoutInjectorInstances(defType,parent,additionalProviders,name);injector._resolveInjectorDefTypes();return injector}function createInjectorWithoutInjectorInstances(defType,parent=null,additionalProviders=null,name){return new R3Injector(defType,additionalProviders,parent||getNullInjector(),name)}class R3Injector{constructor(def,
additionalProviders,parent,source=null){this.parent=parent;this.records=new Map;this.injectorDefTypes=new Set;this.onDestroy=new Set;this._destroyed=false;const dedupStack=[];additionalProviders&&deepForEach(additionalProviders,provider=>this.processProvider(provider,def,additionalProviders));deepForEach([def],injectorDef=>this.processInjectorType(injectorDef,[],dedupStack));this.records.set(INJECTOR,makeRecord(undefined,this));const record=this.records.get(INJECTOR_SCOPE);this.scope=record!=null?
record.value:null;this.source=source||(typeof def==="object"?null:stringify(def))}get destroyed(){return this._destroyed}destroy(){this.assertNotDestroyed();this._destroyed=true;try{this.onDestroy.forEach(service=>service.ngOnDestroy())}finally{this.records.clear();this.onDestroy.clear();this.injectorDefTypes.clear()}}get(token,notFoundValue=THROW_IF_NOT_FOUND,flags=exports.InjectFlags.Default){this.assertNotDestroyed();const previousInjector=setCurrentInjector(this);const previousInjectImplementation=
setInjectImplementation(undefined);try{if(!(flags&exports.InjectFlags.SkipSelf)){let record=this.records.get(token);if(record===undefined){const def=couldBeInjectableType(token)&&getInjectableDef(token);if(def&&this.injectableDefInScope(def))record=makeRecord(injectableDefOrInjectorDefFactory(token),NOT_YET);else record=null;this.records.set(token,record)}if(record!=null)return this.hydrate(token,record)}const nextInjector=!(flags&exports.InjectFlags.Self)?this.parent:getNullInjector();notFoundValue=
flags&exports.InjectFlags.Optional&&notFoundValue===THROW_IF_NOT_FOUND?null:notFoundValue;return nextInjector.get(token,notFoundValue)}catch(e){if(e.name==="NullInjectorError"){const path=e[NG_TEMP_TOKEN_PATH]=e[NG_TEMP_TOKEN_PATH]||[];path.unshift(stringify(token));if(previousInjector)throw e;else return catchInjectorError(e,token,"R3InjectorError",this.source)}else throw e;}finally{setInjectImplementation(previousInjectImplementation);setCurrentInjector(previousInjector)}}_resolveInjectorDefTypes(){this.injectorDefTypes.forEach(defType=>
this.get(defType))}toString(){const tokens=[],records=this.records;records.forEach((v,token)=>tokens.push(stringify(token)));return`R3Injector[${tokens.join(", ")}]`}assertNotDestroyed(){if(this._destroyed){const errorMessage=typeof ngDevMode==="undefined"||ngDevMode?"Injector has already been destroyed.":"";throw new RuntimeError(205,errorMessage);}}processInjectorType(defOrWrappedDef,parents,dedupStack){defOrWrappedDef=resolveForwardRef(defOrWrappedDef);if(!defOrWrappedDef)return false;let def=
getInjectorDef(defOrWrappedDef);const ngModule=def==null&&defOrWrappedDef.ngModule||undefined;const defType=ngModule===undefined?defOrWrappedDef:ngModule;if(ngDevMode&&parents.indexOf(defType)!==-1){const defName=stringify(defType);const path=parents.map(stringify);throwCyclicDependencyError(defName,path)}const isDuplicate=dedupStack.indexOf(defType)!==-1;if(ngModule!==undefined)def=getInjectorDef(ngModule);if(def==null)return false;if(def.imports!=null&&!isDuplicate){ngDevMode&&parents.push(defType);
dedupStack.push(defType);let importTypesWithProviders;try{deepForEach(def.imports,imported=>{if(this.processInjectorType(imported,parents,dedupStack)){if(importTypesWithProviders===undefined)importTypesWithProviders=[];importTypesWithProviders.push(imported)}})}finally{ngDevMode&&parents.pop()}if(importTypesWithProviders!==undefined)for(let i=0;i<importTypesWithProviders.length;i++){const {ngModule,providers}=importTypesWithProviders[i];deepForEach(providers,provider=>this.processProvider(provider,
ngModule,providers||EMPTY_ARRAY))}}this.injectorDefTypes.add(defType);const factory=getFactoryDef(defType)||(()=>new defType);this.records.set(defType,makeRecord(factory,NOT_YET));const defProviders=def.providers;if(defProviders!=null&&!isDuplicate){const injectorType=defOrWrappedDef;deepForEach(defProviders,provider=>this.processProvider(provider,injectorType,defProviders))}return ngModule!==undefined&&defOrWrappedDef.providers!==undefined}processProvider(provider,ngModuleType,providers){provider=
resolveForwardRef(provider);let token=isTypeProvider(provider)?provider:resolveForwardRef(provider&&provider.provide);const record=providerToRecord(provider,ngModuleType,providers);if(!isTypeProvider(provider)&&provider.multi===true){let multiRecord=this.records.get(token);if(multiRecord){if(ngDevMode&&multiRecord.multi===undefined)throwMixedMultiProviderError()}else{multiRecord=makeRecord(undefined,NOT_YET,true);multiRecord.factory=()=>injectArgs(multiRecord.multi);this.records.set(token,multiRecord)}token=
provider;multiRecord.multi.push(provider)}else{const existing=this.records.get(token);if(ngDevMode&&existing&&existing.multi!==undefined)throwMixedMultiProviderError()}this.records.set(token,record)}hydrate(token,record){if(ngDevMode&&record.value===CIRCULAR)throwCyclicDependencyError(stringify(token));else if(record.value===NOT_YET){record.value=CIRCULAR;record.value=record.factory()}if(typeof record.value==="object"&&record.value&&hasOnDestroy(record.value))this.onDestroy.add(record.value);return record.value}injectableDefInScope(def){if(!def.providedIn)return false;
const providedIn=resolveForwardRef(def.providedIn);if(typeof providedIn==="string")return providedIn==="any"||providedIn===this.scope;else return this.injectorDefTypes.has(providedIn)}}function injectableDefOrInjectorDefFactory(token){const injectableDef=getInjectableDef(token);const factory=injectableDef!==null?injectableDef.factory:getFactoryDef(token);if(factory!==null)return factory;if(token instanceof InjectionToken){const errorMessage=typeof ngDevMode==="undefined"||ngDevMode?`Token ${stringify(token)} is missing a ɵprov definition.`:
"";throw new RuntimeError(204,errorMessage);}if(token instanceof Function)return getUndecoratedInjectableFactory(token);const errorMessage=typeof ngDevMode==="undefined"||ngDevMode?"unreachable":"";throw new RuntimeError(204,errorMessage);}function getUndecoratedInjectableFactory(token){const paramLength=token.length;if(paramLength>0){const args=newArray(paramLength,"?");const errorMessage=typeof ngDevMode==="undefined"||ngDevMode?`Can't resolve all parameters for ${stringify(token)}: (${args.join(", ")}).`:
"";throw new RuntimeError(204,errorMessage);}const inheritedInjectableDef=getInheritedInjectableDef(token);if(inheritedInjectableDef!==null)return()=>inheritedInjectableDef.factory(token);else return()=>new token}function providerToRecord(provider,ngModuleType,providers){if(isValueProvider(provider))return makeRecord(undefined,provider.useValue);else{const factory=providerToFactory(provider,ngModuleType,providers);return makeRecord(factory,NOT_YET)}}function providerToFactory(provider,ngModuleType,
providers){let factory=undefined;if(isTypeProvider(provider)){const unwrappedProvider=resolveForwardRef(provider);return getFactoryDef(unwrappedProvider)||injectableDefOrInjectorDefFactory(unwrappedProvider)}else if(isValueProvider(provider))factory=()=>resolveForwardRef(provider.useValue);else if(isFactoryProvider(provider))factory=()=>provider.useFactory(...injectArgs(provider.deps||[]));else if(isExistingProvider(provider))factory=()=>\u0275\u0275inject(resolveForwardRef(provider.useExisting));
else{const classRef=resolveForwardRef(provider&&(provider.useClass||provider.provide));if(ngDevMode&&!classRef)throwInvalidProviderError(ngModuleType,providers,provider);if(hasDeps(provider))factory=()=>new classRef(...injectArgs(provider.deps));else return getFactoryDef(classRef)||injectableDefOrInjectorDefFactory(classRef)}return factory}function makeRecord(factory,value,multi=false){return{factory:factory,value:value,multi:multi?[]:undefined}}function isValueProvider(value){return value!==null&&
typeof value=="object"&&USE_VALUE$1 in value}function isExistingProvider(value){return!!(value&&value.useExisting)}function isFactoryProvider(value){return!!(value&&value.useFactory)}function isTypeProvider(value){return typeof value==="function"}function isClassProvider(value){return!!value.useClass}function hasDeps(value){return!!value.deps}function hasOnDestroy(value){return value!==null&&typeof value==="object"&&typeof value.ngOnDestroy==="function"}function couldBeInjectableType(value){return typeof value===
"function"||typeof value==="object"&&value instanceof InjectionToken}class Injector{static create(options,parent){var _a;if(Array.isArray(options))return createInjector({name:""},parent,options,"");else{const name=(_a=options.name)!==null&&_a!==void 0?_a:"";return createInjector({name},options.parent,options.providers,name)}}}Injector.THROW_IF_NOT_FOUND=THROW_IF_NOT_FOUND;Injector.NULL=new NullInjector;Injector.\u0275prov=\u0275\u0275defineInjectable({token:Injector,providedIn:"any",factory:()=>\u0275\u0275inject(INJECTOR)});
Injector.__NG_ELEMENT_ID__=-1;function getComponent$1(element){assertDomElement(element);const context=getLContext(element);if(context===null)return null;if(context.component===undefined)context.component=getComponentAtNodeIndex(context.nodeIndex,context.lView);return context.component}function getContext(element){assertDomElement(element);const context=getLContext(element);return context===null?null:context.lView[CONTEXT]}function getOwningComponent(elementOrDir){const context=getLContext(elementOrDir);
if(context===null)return null;let lView=context.lView;let parent;ngDevMode&&assertLView(lView);while(lView[TVIEW].type===2&&(parent=getLViewParent(lView)))lView=parent;return lView[FLAGS]&512?null:lView[CONTEXT]}function getRootComponents(elementOrDir){return[...getRootContext(elementOrDir).components]}function getInjector(elementOrDir){const context=getLContext(elementOrDir);if(context===null)return Injector.NULL;const tNode=context.lView[TVIEW].data[context.nodeIndex];return new NodeInjector(tNode,
context.lView)}function getInjectionTokens(element){const context=getLContext(element);if(context===null)return[];const lView=context.lView;const tView=lView[TVIEW];const tNode=tView.data[context.nodeIndex];const providerTokens=[];const startIndex=tNode.providerIndexes&1048575;const endIndex=tNode.directiveEnd;for(let i=startIndex;i<endIndex;i++){let value=tView.data[i];if(isDirectiveDefHack(value))value=value.type;providerTokens.push(value)}return providerTokens}function getDirectives(node){if(node instanceof
Text)return[];const context=getLContext(node);if(context===null)return[];const lView=context.lView;const tView=lView[TVIEW];const nodeIndex=context.nodeIndex;if(!(tView===null||tView===void 0?void 0:tView.data[nodeIndex]))return[];if(context.directives===undefined)context.directives=getDirectivesAtNodeIndex(nodeIndex,lView,false);return context.directives===null?[]:[...context.directives]}function getDirectiveMetadata$1(directiveOrComponentInstance){const {constructor}=directiveOrComponentInstance;
if(!constructor)throw new Error("Unable to find the instance constructor");const componentDef=getComponentDef(constructor);if(componentDef)return{inputs:componentDef.inputs,outputs:componentDef.outputs,encapsulation:componentDef.encapsulation,changeDetection:componentDef.onPush?exports.ChangeDetectionStrategy.OnPush:exports.ChangeDetectionStrategy.Default};const directiveDef=getDirectiveDef(constructor);if(directiveDef)return{inputs:directiveDef.inputs,outputs:directiveDef.outputs};return null}function getLocalRefs(target){const context=
getLContext(target);if(context===null)return{};if(context.localRefs===undefined)context.localRefs=discoverLocalRefs(context.lView,context.nodeIndex);return context.localRefs||{}}function getHostElement(componentOrDirective){return getLContext(componentOrDirective).native}function getListeners(element){assertDomElement(element);const lContext=getLContext(element);if(lContext===null)return[];const lView=lContext.lView;const tView=lView[TVIEW];const lCleanup=lView[CLEANUP];const tCleanup=tView.cleanup;
const listeners=[];if(tCleanup&&lCleanup)for(let i=0;i<tCleanup.length;){const firstParam=tCleanup[i++];const secondParam=tCleanup[i++];if(typeof firstParam==="string"){const name=firstParam;const listenerElement=unwrapRNode(lView[secondParam]);const callback=lCleanup[tCleanup[i++]];const useCaptureOrIndx=tCleanup[i++];const type=typeof useCaptureOrIndx==="boolean"||useCaptureOrIndx>=0?"dom":"output";const useCapture=typeof useCaptureOrIndx==="boolean"?useCaptureOrIndx:false;if(element==listenerElement)listeners.push({element,
name,callback,useCapture,type})}}listeners.sort(sortListeners);return listeners}function sortListeners(a,b){if(a.name==b.name)return 0;return a.name<b.name?-1:1}function isDirectiveDefHack(obj){return obj.type!==undefined&&obj.template!==undefined&&obj.declaredInputs!==undefined}function assertDomElement(value){if(typeof Element!=="undefined"&&!(value instanceof Element))throw new Error("Expecting instance of DOM Element");}function applyChanges(component){markDirty(component);getRootComponents(component).forEach(rootComponent=>
detectChanges(rootComponent))}const GLOBAL_PUBLISH_EXPANDO_KEY="ng";let _published=false;function publishDefaultGlobalUtils$1(){if(!_published){_published=true;publishGlobalUtil("ɵsetProfiler",setProfiler);publishGlobalUtil("getDirectiveMetadata",getDirectiveMetadata$1);publishGlobalUtil("getComponent",getComponent$1);publishGlobalUtil("getContext",getContext);publishGlobalUtil("getListeners",getListeners);publishGlobalUtil("getOwningComponent",getOwningComponent);publishGlobalUtil("getHostElement",
getHostElement);publishGlobalUtil("getInjector",getInjector);publishGlobalUtil("getRootComponents",getRootComponents);publishGlobalUtil("getDirectives",getDirectives);publishGlobalUtil("applyChanges",applyChanges)}}function publishGlobalUtil(name,fn){if(typeof COMPILED==="undefined"||!COMPILED){const w=_global;ngDevMode&&assertDefined(fn,"function not defined");if(w){let container=w[GLOBAL_PUBLISH_EXPANDO_KEY];if(!container)container=w[GLOBAL_PUBLISH_EXPANDO_KEY]={};container[name]=fn}}}function renderComponent(componentType,
opts={}){ngDevMode&&publishDefaultGlobalUtils$1();ngDevMode&&assertComponentType(componentType);const rendererFactory=opts.rendererFactory||domRendererFactory3;const sanitizer=opts.sanitizer||null;const componentDef=getComponentDef(componentType);if(componentDef.type!=componentType)componentDef.type=componentType;const componentTag=componentDef.selectors[0][0];const hostRenderer=rendererFactory.createRenderer(null,null);const hostRNode=locateHostElement(hostRenderer,opts.host||componentTag,componentDef.encapsulation);
const rootFlags=componentDef.onPush?64|512:16|512;const rootContext=createRootContext(opts.scheduler,opts.playerHandler);const renderer=rendererFactory.createRenderer(hostRNode,componentDef);const rootTView=createTView(0,null,null,1,0,null,null,null,null,null);const rootView=createLView(null,rootTView,rootContext,rootFlags,null,null,rendererFactory,renderer,null,opts.injector||null);enterView(rootView);let component;try{if(rendererFactory.begin)rendererFactory.begin();const componentView=createRootComponentView(hostRNode,
componentDef,rootView,rendererFactory,renderer,sanitizer);component=createRootComponent(componentView,componentDef,rootView,rootContext,opts.hostFeatures||null);renderView(rootTView,rootView,null);refreshView(rootTView,rootView,null,null)}finally{leaveView();if(rendererFactory.end)rendererFactory.end()}return component}function createRootComponentView(rNode,def,rootView,rendererFactory,hostRenderer,sanitizer){const tView=rootView[TVIEW];const index=HEADER_OFFSET;ngDevMode&&assertIndexInRange(rootView,
index);rootView[index]=rNode;const tNode=getOrCreateTNode(tView,index,2,"#host",null);const mergedAttrs=tNode.mergedAttrs=def.hostAttrs;if(mergedAttrs!==null){computeStaticStyling(tNode,mergedAttrs,true);if(rNode!==null){setUpAttributes(hostRenderer,rNode,mergedAttrs);if(tNode.classes!==null)writeDirectClass(hostRenderer,rNode,tNode.classes);if(tNode.styles!==null)writeDirectStyle(hostRenderer,rNode,tNode.styles)}}const viewRenderer=rendererFactory.createRenderer(rNode,def);const componentView=createLView(rootView,
getOrCreateTComponentView(def),null,def.onPush?64:16,rootView[index],tNode,rendererFactory,viewRenderer,sanitizer||null,null);if(tView.firstCreatePass){diPublicInInjector(getOrCreateNodeInjectorForNode(tNode,rootView),tView,def.type);markAsComponentHost(tView,tNode);initTNodeFlags(tNode,rootView.length,1)}addToViewTree(rootView,componentView);return rootView[index]=componentView}function createRootComponent(componentView,componentDef,rootLView,rootContext,hostFeatures){const tView=rootLView[TVIEW];
const component=instantiateRootComponent(tView,rootLView,componentDef);rootContext.components.push(component);componentView[CONTEXT]=component;hostFeatures&&hostFeatures.forEach(feature=>feature(component,componentDef));if(componentDef.contentQueries){const tNode=getCurrentTNode();ngDevMode&&assertDefined(tNode,"TNode expected");componentDef.contentQueries(1,component,tNode.directiveStart)}const rootTNode=getCurrentTNode();ngDevMode&&assertDefined(rootTNode,"tNode should have been already created");
if(tView.firstCreatePass&&(componentDef.hostBindings!==null||componentDef.hostAttrs!==null)){setSelectedIndex(rootTNode.index);const rootTView=rootLView[TVIEW];registerHostBindingOpCodes(rootTView,rootTNode,rootLView,rootTNode.directiveStart,rootTNode.directiveEnd,componentDef);invokeHostBindingsInCreationMode(componentDef,component)}return component}function createRootContext(scheduler,playerHandler){return{components:[],scheduler:scheduler||defaultScheduler,clean:CLEAN_PROMISE,playerHandler:playerHandler||
null,flags:0}}function LifecycleHooksFeature(component,def){const lView=readPatchedLView(component);ngDevMode&&assertDefined(lView,"LView is required");const tView=lView[TVIEW];const tNode=getCurrentTNode();ngDevMode&&assertDefined(tNode,"TNode is required");registerPostOrderHooks(tView,tNode)}function whenRendered(component){return getRootContext(component).clean}function getSuperType(type){return Object.getPrototypeOf(type.prototype).constructor}function \u0275\u0275InheritDefinitionFeature(definition){let superType=
getSuperType(definition.type);let shouldInheritFields=true;const inheritanceChain=[definition];while(superType){let superDef=undefined;if(isComponentDef(definition))superDef=superType.\u0275cmp||superType.\u0275dir;else{if(superType.\u0275cmp){const errorMessage=typeof ngDevMode==="undefined"||ngDevMode?"Directives cannot inherit Components":"";throw new RuntimeError(903,errorMessage);}superDef=superType.\u0275dir}if(superDef){if(shouldInheritFields){inheritanceChain.push(superDef);const writeableDef=
definition;writeableDef.inputs=maybeUnwrapEmpty(definition.inputs);writeableDef.declaredInputs=maybeUnwrapEmpty(definition.declaredInputs);writeableDef.outputs=maybeUnwrapEmpty(definition.outputs);const superHostBindings=superDef.hostBindings;superHostBindings&&inheritHostBindings(definition,superHostBindings);const superViewQuery=superDef.viewQuery;const superContentQueries=superDef.contentQueries;superViewQuery&&inheritViewQuery(definition,superViewQuery);superContentQueries&&inheritContentQueries(definition,
superContentQueries);fillProperties(definition.inputs,superDef.inputs);fillProperties(definition.declaredInputs,superDef.declaredInputs);fillProperties(definition.outputs,superDef.outputs);if(isComponentDef(superDef)&&superDef.data.animation){const defData=definition.data;defData.animation=(defData.animation||[]).concat(superDef.data.animation)}}const features=superDef.features;if(features)for(let i=0;i<features.length;i++){const feature=features[i];if(feature&&feature.ngInherit)feature(definition);
if(feature===\u0275\u0275InheritDefinitionFeature)shouldInheritFields=false}}superType=Object.getPrototypeOf(superType)}mergeHostAttrsAcrossInheritance(inheritanceChain)}function mergeHostAttrsAcrossInheritance(inheritanceChain){let hostVars=0;let hostAttrs=null;for(let i=inheritanceChain.length-1;i>=0;i--){const def=inheritanceChain[i];def.hostVars=hostVars+=def.hostVars;def.hostAttrs=mergeHostAttrs(def.hostAttrs,hostAttrs=mergeHostAttrs(hostAttrs,def.hostAttrs))}}function maybeUnwrapEmpty(value){if(value===
EMPTY_OBJ)return{};else if(value===EMPTY_ARRAY)return[];else return value}function inheritViewQuery(definition,superViewQuery){const prevViewQuery=definition.viewQuery;if(prevViewQuery)definition.viewQuery=(rf,ctx)=>{superViewQuery(rf,ctx);prevViewQuery(rf,ctx)};else definition.viewQuery=superViewQuery}function inheritContentQueries(definition,superContentQueries){const prevContentQueries=definition.contentQueries;if(prevContentQueries)definition.contentQueries=(rf,ctx,directiveIndex)=>{superContentQueries(rf,
ctx,directiveIndex);prevContentQueries(rf,ctx,directiveIndex)};else definition.contentQueries=superContentQueries}function inheritHostBindings(definition,superHostBindings){const prevHostBindings=definition.hostBindings;if(prevHostBindings)definition.hostBindings=(rf,ctx)=>{superHostBindings(rf,ctx);prevHostBindings(rf,ctx)};else definition.hostBindings=superHostBindings}const COPY_DIRECTIVE_FIELDS=["providersResolver"];const COPY_COMPONENT_FIELDS=["template","decls","consts","vars","onPush","ngContentSelectors",
"styles","encapsulation","schemas"];function \u0275\u0275CopyDefinitionFeature(definition){let superType=getSuperType(definition.type);let superDef=undefined;if(isComponentDef(definition))superDef=superType.\u0275cmp;else superDef=superType.\u0275dir;const defAny=definition;for(const field of COPY_DIRECTIVE_FIELDS)defAny[field]=superDef[field];if(isComponentDef(superDef))for(const field of COPY_COMPONENT_FIELDS)defAny[field]=superDef[field]}let _symbolIterator=null;function getSymbolIterator(){if(!_symbolIterator){const Symbol=
_global["Symbol"];if(Symbol&&Symbol.iterator)_symbolIterator=Symbol.iterator;else{const keys=Object.getOwnPropertyNames(Map.prototype);for(let i=0;i<keys.length;++i){const key=keys[i];if(key!=="entries"&&key!=="size"&&Map.prototype[key]===Map.prototype["entries"])_symbolIterator=key}}}return _symbolIterator}function devModeEqual(a,b){const isListLikeIterableA=isListLikeIterable(a);const isListLikeIterableB=isListLikeIterable(b);if(isListLikeIterableA&&isListLikeIterableB)return areIterablesEqual(a,
b,devModeEqual);else{const isAObject=a&&(typeof a==="object"||typeof a==="function");const isBObject=b&&(typeof b==="object"||typeof b==="function");if(!isListLikeIterableA&&isAObject&&!isListLikeIterableB&&isBObject)return true;else return Object.is(a,b)}}function isListLikeIterable(obj){if(!isJsObject(obj))return false;return Array.isArray(obj)||!(obj instanceof Map)&&getSymbolIterator()in obj}function areIterablesEqual(a,b,comparator){const iterator1=a[getSymbolIterator()]();const iterator2=b[getSymbolIterator()]();
while(true){const item1=iterator1.next();const item2=iterator2.next();if(item1.done&&item2.done)return true;if(item1.done||item2.done)return false;if(!comparator(item1.value,item2.value))return false}}function iterateListLike(obj,fn){if(Array.isArray(obj))for(let i=0;i<obj.length;i++)fn(obj[i]);else{const iterator=obj[getSymbolIterator()]();let item;while(!(item=iterator.next()).done)fn(item.value)}}function isJsObject(o){return o!==null&&(typeof o==="function"||typeof o==="object")}function updateBinding(lView,
bindingIndex,value){return lView[bindingIndex]=value}function getBinding(lView,bindingIndex){ngDevMode&&assertIndexInRange(lView,bindingIndex);ngDevMode&&assertNotSame(lView[bindingIndex],NO_CHANGE,"Stored value should never be NO_CHANGE.");return lView[bindingIndex]}function bindingUpdated(lView,bindingIndex,value){ngDevMode&&assertNotSame(value,NO_CHANGE,"Incoming value should never be NO_CHANGE.");ngDevMode&&assertLessThan(bindingIndex,lView.length,`Slot should have been initialized to NO_CHANGE`);
const oldValue=lView[bindingIndex];if(Object.is(oldValue,value))return false;else{if(ngDevMode&&isInCheckNoChangesMode()){const oldValueToCompare=oldValue!==NO_CHANGE?oldValue:undefined;if(!devModeEqual(oldValueToCompare,value)){const details=getExpressionChangedErrorDetails(lView,bindingIndex,oldValueToCompare,value);throwErrorIfNoChangesMode(oldValue===NO_CHANGE,details.oldValue,details.newValue,details.propName)}return false}lView[bindingIndex]=value;return true}}function bindingUpdated2(lView,
bindingIndex,exp1,exp2){const different=bindingUpdated(lView,bindingIndex,exp1);return bindingUpdated(lView,bindingIndex+1,exp2)||different}function bindingUpdated3(lView,bindingIndex,exp1,exp2,exp3){const different=bindingUpdated2(lView,bindingIndex,exp1,exp2);return bindingUpdated(lView,bindingIndex+2,exp3)||different}function bindingUpdated4(lView,bindingIndex,exp1,exp2,exp3,exp4){const different=bindingUpdated2(lView,bindingIndex,exp1,exp2);return bindingUpdated2(lView,bindingIndex+2,exp3,exp4)||
different}function \u0275\u0275attribute(name,value,sanitizer,namespace){const lView=getLView();const bindingIndex=nextBindingIndex();if(bindingUpdated(lView,bindingIndex,value)){const tView=getTView();const tNode=getSelectedTNode();elementAttributeInternal(tNode,lView,name,value,sanitizer,namespace);ngDevMode&&storePropertyBindingMetadata(tView.data,tNode,"attr."+name,bindingIndex)}return \u0275\u0275attribute}function interpolationV(lView,values){ngDevMode&&assertLessThan(2,values.length,"should have at least 3 values");
ngDevMode&&assertEqual(values.length%2,1,"should have an odd number of values");let isBindingUpdated=false;let bindingIndex=getBindingIndex();for(let i=1;i<values.length;i+=2)isBindingUpdated=bindingUpdated(lView,bindingIndex++,values[i])||isBindingUpdated;setBindingIndex(bindingIndex);if(!isBindingUpdated)return NO_CHANGE;let content=values[0];for(let i=1;i<values.length;i+=2)content+=renderStringify(values[i])+values[i+1];return content}function interpolation1(lView,prefix,v0,suffix){const different=
bindingUpdated(lView,nextBindingIndex(),v0);return different?prefix+renderStringify(v0)+suffix:NO_CHANGE}function interpolation2(lView,prefix,v0,i0,v1,suffix){const bindingIndex=getBindingIndex();const different=bindingUpdated2(lView,bindingIndex,v0,v1);incrementBindingIndex(2);return different?prefix+renderStringify(v0)+i0+renderStringify(v1)+suffix:NO_CHANGE}function interpolation3(lView,prefix,v0,i0,v1,i1,v2,suffix){const bindingIndex=getBindingIndex();const different=bindingUpdated3(lView,bindingIndex,
v0,v1,v2);incrementBindingIndex(3);return different?prefix+renderStringify(v0)+i0+renderStringify(v1)+i1+renderStringify(v2)+suffix:NO_CHANGE}function interpolation4(lView,prefix,v0,i0,v1,i1,v2,i2,v3,suffix){const bindingIndex=getBindingIndex();const different=bindingUpdated4(lView,bindingIndex,v0,v1,v2,v3);incrementBindingIndex(4);return different?prefix+renderStringify(v0)+i0+renderStringify(v1)+i1+renderStringify(v2)+i2+renderStringify(v3)+suffix:NO_CHANGE}function interpolation5(lView,prefix,
v0,i0,v1,i1,v2,i2,v3,i3,v4,suffix){const bindingIndex=getBindingIndex();let different=bindingUpdated4(lView,bindingIndex,v0,v1,v2,v3);different=bindingUpdated(lView,bindingIndex+4,v4)||different;incrementBindingIndex(5);return different?prefix+renderStringify(v0)+i0+renderStringify(v1)+i1+renderStringify(v2)+i2+renderStringify(v3)+i3+renderStringify(v4)+suffix:NO_CHANGE}function interpolation6(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,suffix){const bindingIndex=getBindingIndex();let different=
bindingUpdated4(lView,bindingIndex,v0,v1,v2,v3);different=bindingUpdated2(lView,bindingIndex+4,v4,v5)||different;incrementBindingIndex(6);return different?prefix+renderStringify(v0)+i0+renderStringify(v1)+i1+renderStringify(v2)+i2+renderStringify(v3)+i3+renderStringify(v4)+i4+renderStringify(v5)+suffix:NO_CHANGE}function interpolation7(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,suffix){const bindingIndex=getBindingIndex();let different=bindingUpdated4(lView,bindingIndex,v0,v1,v2,v3);different=
bindingUpdated3(lView,bindingIndex+4,v4,v5,v6)||different;incrementBindingIndex(7);return different?prefix+renderStringify(v0)+i0+renderStringify(v1)+i1+renderStringify(v2)+i2+renderStringify(v3)+i3+renderStringify(v4)+i4+renderStringify(v5)+i5+renderStringify(v6)+suffix:NO_CHANGE}function interpolation8(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,i6,v7,suffix){const bindingIndex=getBindingIndex();let different=bindingUpdated4(lView,bindingIndex,v0,v1,v2,v3);different=bindingUpdated4(lView,
bindingIndex+4,v4,v5,v6,v7)||different;incrementBindingIndex(8);return different?prefix+renderStringify(v0)+i0+renderStringify(v1)+i1+renderStringify(v2)+i2+renderStringify(v3)+i3+renderStringify(v4)+i4+renderStringify(v5)+i5+renderStringify(v6)+i6+renderStringify(v7)+suffix:NO_CHANGE}function \u0275\u0275attributeInterpolate1(attrName,prefix,v0,suffix,sanitizer,namespace){const lView=getLView();const interpolatedValue=interpolation1(lView,prefix,v0,suffix);if(interpolatedValue!==NO_CHANGE){const tNode=
getSelectedTNode();elementAttributeInternal(tNode,lView,attrName,interpolatedValue,sanitizer,namespace);ngDevMode&&storePropertyBindingMetadata(getTView().data,tNode,"attr."+attrName,getBindingIndex()-1,prefix,suffix)}return \u0275\u0275attributeInterpolate1}function \u0275\u0275attributeInterpolate2(attrName,prefix,v0,i0,v1,suffix,sanitizer,namespace){const lView=getLView();const interpolatedValue=interpolation2(lView,prefix,v0,i0,v1,suffix);if(interpolatedValue!==NO_CHANGE){const tNode=getSelectedTNode();
elementAttributeInternal(tNode,lView,attrName,interpolatedValue,sanitizer,namespace);ngDevMode&&storePropertyBindingMetadata(getTView().data,tNode,"attr."+attrName,getBindingIndex()-2,prefix,i0,suffix)}return \u0275\u0275attributeInterpolate2}function \u0275\u0275attributeInterpolate3(attrName,prefix,v0,i0,v1,i1,v2,suffix,sanitizer,namespace){const lView=getLView();const interpolatedValue=interpolation3(lView,prefix,v0,i0,v1,i1,v2,suffix);if(interpolatedValue!==NO_CHANGE){const tNode=getSelectedTNode();
elementAttributeInternal(tNode,lView,attrName,interpolatedValue,sanitizer,namespace);ngDevMode&&storePropertyBindingMetadata(getTView().data,tNode,"attr."+attrName,getBindingIndex()-3,prefix,i0,i1,suffix)}return \u0275\u0275attributeInterpolate3}function \u0275\u0275attributeInterpolate4(attrName,prefix,v0,i0,v1,i1,v2,i2,v3,suffix,sanitizer,namespace){const lView=getLView();const interpolatedValue=interpolation4(lView,prefix,v0,i0,v1,i1,v2,i2,v3,suffix);if(interpolatedValue!==NO_CHANGE){const tNode=
getSelectedTNode();elementAttributeInternal(tNode,lView,attrName,interpolatedValue,sanitizer,namespace);ngDevMode&&storePropertyBindingMetadata(getTView().data,tNode,"attr."+attrName,getBindingIndex()-4,prefix,i0,i1,i2,suffix)}return \u0275\u0275attributeInterpolate4}function \u0275\u0275attributeInterpolate5(attrName,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,suffix,sanitizer,namespace){const lView=getLView();const interpolatedValue=interpolation5(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,suffix);if(interpolatedValue!==
NO_CHANGE){const tNode=getSelectedTNode();elementAttributeInternal(tNode,lView,attrName,interpolatedValue,sanitizer,namespace);ngDevMode&&storePropertyBindingMetadata(getTView().data,tNode,"attr."+attrName,getBindingIndex()-5,prefix,i0,i1,i2,i3,suffix)}return \u0275\u0275attributeInterpolate5}function \u0275\u0275attributeInterpolate6(attrName,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,suffix,sanitizer,namespace){const lView=getLView();const interpolatedValue=interpolation6(lView,prefix,v0,i0,v1,i1,
v2,i2,v3,i3,v4,i4,v5,suffix);if(interpolatedValue!==NO_CHANGE){const tNode=getSelectedTNode();elementAttributeInternal(tNode,lView,attrName,interpolatedValue,sanitizer,namespace);ngDevMode&&storePropertyBindingMetadata(getTView().data,tNode,"attr."+attrName,getBindingIndex()-6,prefix,i0,i1,i2,i3,i4,suffix)}return \u0275\u0275attributeInterpolate6}function \u0275\u0275attributeInterpolate7(attrName,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,suffix,sanitizer,namespace){const lView=getLView();const interpolatedValue=
interpolation7(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,suffix);if(interpolatedValue!==NO_CHANGE){const tNode=getSelectedTNode();elementAttributeInternal(tNode,lView,attrName,interpolatedValue,sanitizer,namespace);ngDevMode&&storePropertyBindingMetadata(getTView().data,tNode,"attr."+attrName,getBindingIndex()-7,prefix,i0,i1,i2,i3,i4,i5,suffix)}return \u0275\u0275attributeInterpolate7}function \u0275\u0275attributeInterpolate8(attrName,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,i6,v7,
suffix,sanitizer,namespace){const lView=getLView();const interpolatedValue=interpolation8(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,i6,v7,suffix);if(interpolatedValue!==NO_CHANGE){const tNode=getSelectedTNode();elementAttributeInternal(tNode,lView,attrName,interpolatedValue,sanitizer,namespace);ngDevMode&&storePropertyBindingMetadata(getTView().data,tNode,"attr."+attrName,getBindingIndex()-8,prefix,i0,i1,i2,i3,i4,i5,i6,suffix)}return \u0275\u0275attributeInterpolate8}function \u0275\u0275attributeInterpolateV(attrName,
values,sanitizer,namespace){const lView=getLView();const interpolated=interpolationV(lView,values);if(interpolated!==NO_CHANGE){const tNode=getSelectedTNode();elementAttributeInternal(tNode,lView,attrName,interpolated,sanitizer,namespace);if(ngDevMode){const interpolationInBetween=[values[0]];for(let i=2;i<values.length;i+=2)interpolationInBetween.push(values[i]);storePropertyBindingMetadata(getTView().data,tNode,"attr."+attrName,getBindingIndex()-interpolationInBetween.length+1,...interpolationInBetween)}}return \u0275\u0275attributeInterpolateV}
function templateFirstCreatePass(index,tView,lView,templateFn,decls,vars,tagName,attrsIndex,localRefsIndex){ngDevMode&&assertFirstCreatePass(tView);ngDevMode&&ngDevMode.firstCreatePass++;const tViewConsts=tView.consts;const tNode=getOrCreateTNode(tView,index,4,tagName||null,getConstant(tViewConsts,attrsIndex));resolveDirectives(tView,lView,tNode,getConstant(tViewConsts,localRefsIndex));registerPostOrderHooks(tView,tNode);const embeddedTView=tNode.tViews=createTView(2,tNode,templateFn,decls,vars,tView.directiveRegistry,
tView.pipeRegistry,null,tView.schemas,tViewConsts);if(tView.queries!==null){tView.queries.template(tView,tNode);embeddedTView.queries=tView.queries.embeddedTView(tNode)}return tNode}function \u0275\u0275template(index,templateFn,decls,vars,tagName,attrsIndex,localRefsIndex,localRefExtractor){const lView=getLView();const tView=getTView();const adjustedIndex=index+HEADER_OFFSET;const tNode=tView.firstCreatePass?templateFirstCreatePass(adjustedIndex,tView,lView,templateFn,decls,vars,tagName,attrsIndex,
localRefsIndex):tView.data[adjustedIndex];setCurrentTNode(tNode,false);const comment=lView[RENDERER].createComment(ngDevMode?"container":"");appendChild(tView,lView,comment,tNode);attachPatchData(comment,lView);addToViewTree(lView,lView[adjustedIndex]=createLContainer(comment,lView,comment,tNode));if(isDirectiveHost(tNode))createDirectivesInstances(tView,lView,tNode);if(localRefsIndex!=null)saveResolvedLocalsInData(lView,tNode,localRefExtractor)}function store(tView,lView,index,value){if(index>=tView.data.length){tView.data[index]=
null;tView.blueprint[index]=null}lView[index]=value}function \u0275\u0275reference(index){const contextLView=getContextLView();return load(contextLView,HEADER_OFFSET+index)}const angularCoreDiEnv={"ɵɵdefineInjectable":\u0275\u0275defineInjectable,"ɵɵdefineInjector":\u0275\u0275defineInjector,"ɵɵinject":\u0275\u0275inject,"ɵɵinvalidFactoryDep":\u0275\u0275invalidFactoryDep,"resolveForwardRef":resolveForwardRef};function compileInjectable(type,meta){let ngInjectableDef=null;let ngFactoryDef=null;if(!type.hasOwnProperty(NG_PROV_DEF))Object.defineProperty(type,
NG_PROV_DEF,{get:()=>{if(ngInjectableDef===null){const compiler=getCompilerFacade({usage:0,kind:"injectable",type});ngInjectableDef=compiler.compileInjectable(angularCoreDiEnv,`ng:///${type.name}/ɵprov.js`,getInjectableMetadata(type,meta))}return ngInjectableDef}});if(!type.hasOwnProperty(NG_FACTORY_DEF))Object.defineProperty(type,NG_FACTORY_DEF,{get:()=>{if(ngFactoryDef===null){const compiler=getCompilerFacade({usage:0,kind:"injectable",type});ngFactoryDef=compiler.compileFactory(angularCoreDiEnv,
`ng:///${type.name}/ɵfac.js`,{name:type.name,type,typeArgumentCount:0,deps:reflectDependencies(type),target:compiler.FactoryTarget.Injectable})}return ngFactoryDef},configurable:true})}const USE_VALUE=getClosureSafeProperty({provide:String,useValue:getClosureSafeProperty});function isUseClassProvider(meta){return meta.useClass!==undefined}function isUseValueProvider(meta){return USE_VALUE in meta}function isUseFactoryProvider(meta){return meta.useFactory!==undefined}function isUseExistingProvider(meta){return meta.useExisting!==
undefined}function getInjectableMetadata(type,srcMeta){const meta=srcMeta||{providedIn:null};const compilerMeta={name:type.name,type:type,typeArgumentCount:0,providedIn:meta.providedIn};if((isUseClassProvider(meta)||isUseFactoryProvider(meta))&&meta.deps!==undefined)compilerMeta.deps=convertDependencies(meta.deps);if(isUseClassProvider(meta))compilerMeta.useClass=meta.useClass;else if(isUseValueProvider(meta))compilerMeta.useValue=meta.useValue;else if(isUseFactoryProvider(meta))compilerMeta.useFactory=
meta.useFactory;else if(isUseExistingProvider(meta))compilerMeta.useExisting=meta.useExisting;return compilerMeta}const Injectable=makeDecorator("Injectable",undefined,undefined,undefined,(type,meta)=>compileInjectable(type,meta));function findFirstClosedCycle(keys){const res=[];for(let i=0;i<keys.length;++i){if(res.indexOf(keys[i])>-1){res.push(keys[i]);return res}res.push(keys[i])}return res}function constructResolvingPath(keys){if(keys.length>1){const reversed=findFirstClosedCycle(keys.slice().reverse());
const tokenStrs=reversed.map(k=>stringify(k.token));return" ("+tokenStrs.join(" -> ")+")"}return""}function injectionError(injector,key,constructResolvingMessage,originalError){const keys=[key];const errMsg=constructResolvingMessage(keys);const error=originalError?wrappedError(errMsg,originalError):Error(errMsg);error.addKey=addKey;error.keys=keys;error.injectors=[injector];error.constructResolvingMessage=constructResolvingMessage;error[ERROR_ORIGINAL_ERROR]=originalError;return error}function addKey(injector,
key){this.injectors.push(injector);this.keys.push(key);this.message=this.constructResolvingMessage(this.keys)}function noProviderError(injector,key){return injectionError(injector,key,function(keys){const first=stringify(keys[0].token);return`No provider for ${first}!${constructResolvingPath(keys)}`})}function cyclicDependencyError(injector,key){return injectionError(injector,key,function(keys){return`Cannot instantiate cyclic dependency!${constructResolvingPath(keys)}`})}function instantiationError(injector,
originalException,originalStack,key){return injectionError(injector,key,function(keys){const first=stringify(keys[0].token);return`${originalException.message}: Error during instantiation of ${first}!${constructResolvingPath(keys)}.`},originalException)}function invalidProviderError(provider){return Error(`Invalid provider - only instances of Provider and Type are allowed, got: ${provider}`)}function noAnnotationError(typeOrFunc,params){const signature=[];for(let i=0,ii=params.length;i<ii;i++){const parameter=
params[i];if(!parameter||parameter.length==0)signature.push("?");else signature.push(parameter.map(stringify).join(" "))}return Error("Cannot resolve all parameters for '"+stringify(typeOrFunc)+"'("+signature.join(", ")+"). "+"Make sure that all the parameters are decorated with Inject or have valid type annotations and that '"+stringify(typeOrFunc)+"' is decorated with Injectable.")}function outOfBoundsError(index){return Error(`Index ${index} is out-of-bounds.`)}function mixingMultiProvidersWithRegularProvidersError(provider1,
provider2){return Error(`Cannot mix multi providers and regular providers, got: ${provider1} ${provider2}`)}class ReflectiveKey{constructor(token,id){this.token=token;this.id=id;if(!token)throw new Error("Token must be defined!");this.displayName=stringify(this.token)}static get(token){return _globalKeyRegistry.get(resolveForwardRef(token))}static get numberOfKeys(){return _globalKeyRegistry.numberOfKeys}}class KeyRegistry{constructor(){this._allKeys=new Map}get(token){if(token instanceof ReflectiveKey)return token;
if(this._allKeys.has(token))return this._allKeys.get(token);const newKey=new ReflectiveKey(token,ReflectiveKey.numberOfKeys);this._allKeys.set(token,newKey);return newKey}get numberOfKeys(){return this._allKeys.size}}const _globalKeyRegistry=new KeyRegistry;class Reflector{constructor(reflectionCapabilities){this.reflectionCapabilities=reflectionCapabilities}updateCapabilities(caps){this.reflectionCapabilities=caps}factory(type){return this.reflectionCapabilities.factory(type)}parameters(typeOrFunc){return this.reflectionCapabilities.parameters(typeOrFunc)}annotations(typeOrFunc){return this.reflectionCapabilities.annotations(typeOrFunc)}propMetadata(typeOrFunc){return this.reflectionCapabilities.propMetadata(typeOrFunc)}hasLifecycleHook(type,
lcProperty){return this.reflectionCapabilities.hasLifecycleHook(type,lcProperty)}getter(name){return this.reflectionCapabilities.getter(name)}setter(name){return this.reflectionCapabilities.setter(name)}method(name){return this.reflectionCapabilities.method(name)}importUri(type){return this.reflectionCapabilities.importUri(type)}resourceUri(type){return this.reflectionCapabilities.resourceUri(type)}resolveIdentifier(name,moduleUrl,members,runtime){return this.reflectionCapabilities.resolveIdentifier(name,
moduleUrl,members,runtime)}resolveEnum(identifier,name){return this.reflectionCapabilities.resolveEnum(identifier,name)}}const reflector=new Reflector(new ReflectionCapabilities);class ReflectiveDependency{constructor(key,optional,visibility){this.key=key;this.optional=optional;this.visibility=visibility}static fromKey(key){return new ReflectiveDependency(key,false,null)}}const _EMPTY_LIST=[];class ResolvedReflectiveProvider_{constructor(key,resolvedFactories,multiProvider){this.key=key;this.resolvedFactories=
resolvedFactories;this.multiProvider=multiProvider;this.resolvedFactory=this.resolvedFactories[0]}}class ResolvedReflectiveFactory{constructor(factory,dependencies){this.factory=factory;this.dependencies=dependencies}}function resolveReflectiveFactory(provider){let factoryFn;let resolvedDeps;if(provider.useClass){const useClass=resolveForwardRef(provider.useClass);factoryFn=reflector.factory(useClass);resolvedDeps=_dependenciesFor(useClass)}else if(provider.useExisting){factoryFn=aliasInstance=>aliasInstance;
resolvedDeps=[ReflectiveDependency.fromKey(ReflectiveKey.get(provider.useExisting))]}else if(provider.useFactory){factoryFn=provider.useFactory;resolvedDeps=constructDependencies(provider.useFactory,provider.deps)}else{factoryFn=()=>provider.useValue;resolvedDeps=_EMPTY_LIST}return new ResolvedReflectiveFactory(factoryFn,resolvedDeps)}function resolveReflectiveProvider(provider){return new ResolvedReflectiveProvider_(ReflectiveKey.get(provider.provide),[resolveReflectiveFactory(provider)],provider.multi||
false)}function resolveReflectiveProviders(providers){const normalized=_normalizeProviders(providers,[]);const resolved=normalized.map(resolveReflectiveProvider);const resolvedProviderMap=mergeResolvedReflectiveProviders(resolved,new Map);return Array.from(resolvedProviderMap.values())}function mergeResolvedReflectiveProviders(providers,normalizedProvidersMap){for(let i=0;i<providers.length;i++){const provider=providers[i];const existing=normalizedProvidersMap.get(provider.key.id);if(existing){if(provider.multiProvider!==
existing.multiProvider)throw mixingMultiProvidersWithRegularProvidersError(existing,provider);if(provider.multiProvider)for(let j=0;j<provider.resolvedFactories.length;j++)existing.resolvedFactories.push(provider.resolvedFactories[j]);else normalizedProvidersMap.set(provider.key.id,provider)}else{let resolvedProvider;if(provider.multiProvider)resolvedProvider=new ResolvedReflectiveProvider_(provider.key,provider.resolvedFactories.slice(),provider.multiProvider);else resolvedProvider=provider;normalizedProvidersMap.set(provider.key.id,
resolvedProvider)}}return normalizedProvidersMap}function _normalizeProviders(providers,res){providers.forEach(b=>{if(b instanceof Type)res.push({provide:b,useClass:b});else if(b&&typeof b=="object"&&b.provide!==undefined)res.push(b);else if(Array.isArray(b))_normalizeProviders(b,res);else throw invalidProviderError(b);});return res}function constructDependencies(typeOrFunc,dependencies){if(!dependencies)return _dependenciesFor(typeOrFunc);else{const params=dependencies.map(t=>[t]);return dependencies.map(t=>
_extractToken(typeOrFunc,t,params))}}function _dependenciesFor(typeOrFunc){const params=reflector.parameters(typeOrFunc);if(!params)return[];if(params.some(p=>p==null))throw noAnnotationError(typeOrFunc,params);return params.map(p=>_extractToken(typeOrFunc,p,params))}function _extractToken(typeOrFunc,metadata,params){let token=null;let optional=false;if(!Array.isArray(metadata))if(metadata instanceof Inject)return _createDependency(metadata.token,optional,null);else return _createDependency(metadata,
optional,null);let visibility=null;for(let i=0;i<metadata.length;++i){const paramMetadata=metadata[i];if(paramMetadata instanceof Type)token=paramMetadata;else if(paramMetadata instanceof Inject)token=paramMetadata.token;else if(paramMetadata instanceof Optional)optional=true;else if(paramMetadata instanceof Self||paramMetadata instanceof SkipSelf)visibility=paramMetadata;else if(paramMetadata instanceof InjectionToken)token=paramMetadata}token=resolveForwardRef(token);if(token!=null)return _createDependency(token,
optional,visibility);else throw noAnnotationError(typeOrFunc,params);}function _createDependency(token,optional,visibility){return new ReflectiveDependency(ReflectiveKey.get(token),optional,visibility)}const UNDEFINED={};class ReflectiveInjector{static resolve(providers){return resolveReflectiveProviders(providers)}static resolveAndCreate(providers,parent){const ResolvedReflectiveProviders=ReflectiveInjector.resolve(providers);return ReflectiveInjector.fromResolvedProviders(ResolvedReflectiveProviders,
parent)}static fromResolvedProviders(providers,parent){return new ReflectiveInjector_(providers,parent)}}class ReflectiveInjector_{constructor(_providers,_parent){this._constructionCounter=0;this._providers=_providers;this.parent=_parent||null;const len=_providers.length;this.keyIds=[];this.objs=[];for(let i=0;i<len;i++){this.keyIds[i]=_providers[i].key.id;this.objs[i]=UNDEFINED}}get(token,notFoundValue=THROW_IF_NOT_FOUND){return this._getByKey(ReflectiveKey.get(token),null,notFoundValue)}resolveAndCreateChild(providers){const ResolvedReflectiveProviders=
ReflectiveInjector.resolve(providers);return this.createChildFromResolved(ResolvedReflectiveProviders)}createChildFromResolved(providers){const inj=new ReflectiveInjector_(providers);inj.parent=this;return inj}resolveAndInstantiate(provider){return this.instantiateResolved(ReflectiveInjector.resolve([provider])[0])}instantiateResolved(provider){return this._instantiateProvider(provider)}getProviderAtIndex(index){if(index<0||index>=this._providers.length)throw outOfBoundsError(index);return this._providers[index]}_new(provider){if(this._constructionCounter++>
this._getMaxNumberOfObjects())throw cyclicDependencyError(this,provider.key);return this._instantiateProvider(provider)}_getMaxNumberOfObjects(){return this.objs.length}_instantiateProvider(provider){if(provider.multiProvider){const res=[];for(let i=0;i<provider.resolvedFactories.length;++i)res[i]=this._instantiate(provider,provider.resolvedFactories[i]);return res}else return this._instantiate(provider,provider.resolvedFactories[0])}_instantiate(provider,ResolvedReflectiveFactory){const factory=
ResolvedReflectiveFactory.factory;let deps;try{deps=ResolvedReflectiveFactory.dependencies.map(dep=>this._getByReflectiveDependency(dep))}catch(e){if(e.addKey)e.addKey(this,provider.key);throw e;}let obj;try{obj=factory(...deps)}catch(e){throw instantiationError(this,e,e.stack,provider.key);}return obj}_getByReflectiveDependency(dep){return this._getByKey(dep.key,dep.visibility,dep.optional?null:THROW_IF_NOT_FOUND)}_getByKey(key,visibility,notFoundValue){if(key===ReflectiveInjector_.INJECTOR_KEY)return this;
if(visibility instanceof Self)return this._getByKeySelf(key,notFoundValue);else return this._getByKeyDefault(key,notFoundValue,visibility)}_getObjByKeyId(keyId){for(let i=0;i<this.keyIds.length;i++)if(this.keyIds[i]===keyId){if(this.objs[i]===UNDEFINED)this.objs[i]=this._new(this._providers[i]);return this.objs[i]}return UNDEFINED}_throwOrNull(key,notFoundValue){if(notFoundValue!==THROW_IF_NOT_FOUND)return notFoundValue;else throw noProviderError(this,key);}_getByKeySelf(key,notFoundValue){const obj=
this._getObjByKeyId(key.id);return obj!==UNDEFINED?obj:this._throwOrNull(key,notFoundValue)}_getByKeyDefault(key,notFoundValue,visibility){let inj;if(visibility instanceof SkipSelf)inj=this.parent;else inj=this;while(inj instanceof ReflectiveInjector_){const inj_=inj;const obj=inj_._getObjByKeyId(key.id);if(obj!==UNDEFINED)return obj;inj=inj_.parent}if(inj!==null)return inj.get(key.token,notFoundValue);else return this._throwOrNull(key,notFoundValue)}get displayName(){const providers=_mapProviders(this,
b=>' "'+b.key.displayName+'" ').join(", ");return`ReflectiveInjector(providers: [${providers}])`}toString(){return this.displayName}}ReflectiveInjector_.INJECTOR_KEY=ReflectiveKey.get(Injector);function _mapProviders(injector,fn){const res=[];for(let i=0;i<injector._providers.length;++i)res[i]=fn(injector.getProviderAtIndex(i));return res}function \u0275\u0275directiveInject(token,flags=exports.InjectFlags.Default){const lView=getLView();if(lView===null){ngDevMode&&assertInjectImplementationNotEqual(\u0275\u0275directiveInject);
return \u0275\u0275inject(token,flags)}const tNode=getCurrentTNode();return getOrCreateInjectable(tNode,lView,resolveForwardRef(token),flags)}function \u0275\u0275invalidFactory(){const msg=ngDevMode?`This constructor was not compatible with Dependency Injection.`:"invalid";throw new Error(msg);}function \u0275\u0275property(propName,value,sanitizer){const lView=getLView();const bindingIndex=nextBindingIndex();if(bindingUpdated(lView,bindingIndex,value)){const tView=getTView();const tNode=getSelectedTNode();
elementPropertyInternal(tView,tNode,lView,propName,value,lView[RENDERER],sanitizer,false);ngDevMode&&storePropertyBindingMetadata(tView.data,tNode,propName,bindingIndex)}return \u0275\u0275property}function setDirectiveInputsWhichShadowsStyling(tView,tNode,lView,value,isClassBased){const inputs=tNode.inputs;const property=isClassBased?"class":"style";setInputsForProperty(tView,lView,inputs[property],property,value)}function elementStartFirstCreatePass(index,tView,lView,native,name,attrsIndex,localRefsIndex){ngDevMode&&
assertFirstCreatePass(tView);ngDevMode&&ngDevMode.firstCreatePass++;const tViewConsts=tView.consts;const attrs=getConstant(tViewConsts,attrsIndex);const tNode=getOrCreateTNode(tView,index,2,name,attrs);const hasDirectives=resolveDirectives(tView,lView,tNode,getConstant(tViewConsts,localRefsIndex));ngDevMode&&logUnknownElementError(tView,native,tNode,hasDirectives);if(tNode.attrs!==null)computeStaticStyling(tNode,tNode.attrs,false);if(tNode.mergedAttrs!==null)computeStaticStyling(tNode,tNode.mergedAttrs,
true);if(tView.queries!==null)tView.queries.elementStart(tView,tNode);return tNode}function \u0275\u0275elementStart(index,name,attrsIndex,localRefsIndex){const lView=getLView();const tView=getTView();const adjustedIndex=HEADER_OFFSET+index;ngDevMode&&assertEqual(getBindingIndex(),tView.bindingStartIndex,"elements should be created before any bindings");ngDevMode&&assertIndexInRange(lView,adjustedIndex);const renderer=lView[RENDERER];const native=lView[adjustedIndex]=createElementNode(renderer,name,
getNamespace$1());const tNode=tView.firstCreatePass?elementStartFirstCreatePass(adjustedIndex,tView,lView,native,name,attrsIndex,localRefsIndex):tView.data[adjustedIndex];setCurrentTNode(tNode,true);const mergedAttrs=tNode.mergedAttrs;if(mergedAttrs!==null)setUpAttributes(renderer,native,mergedAttrs);const classes=tNode.classes;if(classes!==null)writeDirectClass(renderer,native,classes);const styles=tNode.styles;if(styles!==null)writeDirectStyle(renderer,native,styles);if((tNode.flags&64)!==64)appendChild(tView,
lView,native,tNode);if(getElementDepthCount()===0)attachPatchData(native,lView);increaseElementDepthCount();if(isDirectiveHost(tNode)){createDirectivesInstances(tView,lView,tNode);executeContentQueries(tView,tNode,lView)}if(localRefsIndex!==null)saveResolvedLocalsInData(lView,tNode)}function \u0275\u0275elementEnd(){let currentTNode=getCurrentTNode();ngDevMode&&assertDefined(currentTNode,"No parent node to close.");if(isCurrentTNodeParent())setCurrentTNodeAsNotParent();else{ngDevMode&&assertHasParent(getCurrentTNode());
currentTNode=currentTNode.parent;setCurrentTNode(currentTNode,false)}const tNode=currentTNode;ngDevMode&&assertTNodeType(tNode,3);decreaseElementDepthCount();const tView=getTView();if(tView.firstCreatePass){registerPostOrderHooks(tView,currentTNode);if(isContentQueryHost(currentTNode))tView.queries.elementEnd(currentTNode)}if(tNode.classesWithoutHost!=null&&hasClassInput(tNode))setDirectiveInputsWhichShadowsStyling(tView,tNode,getLView(),tNode.classesWithoutHost,true);if(tNode.stylesWithoutHost!=
null&&hasStyleInput(tNode))setDirectiveInputsWhichShadowsStyling(tView,tNode,getLView(),tNode.stylesWithoutHost,false)}function \u0275\u0275element(index,name,attrsIndex,localRefsIndex){\u0275\u0275elementStart(index,name,attrsIndex,localRefsIndex);\u0275\u0275elementEnd()}function logUnknownElementError(tView,element,tNode,hasDirectives){const schemas=tView.schemas;if(schemas===null)return;const tagName=tNode.value;if(!hasDirectives&&tagName!==null){const isUnknown=typeof HTMLUnknownElement!=="undefined"&&
HTMLUnknownElement&&element instanceof HTMLUnknownElement||typeof customElements!=="undefined"&&tagName.indexOf("-")>-1&&!customElements.get(tagName);if(isUnknown&&!matchingSchemas(tView,tagName)){let message=`'${tagName}' is not a known element:\n`;message+=`1. If '${tagName}' is an Angular component, then verify that it is part of this module.\n`;if(tagName&&tagName.indexOf("-")>-1)message+=`2. If '${tagName}' is a Web Component then add 'CUSTOM_ELEMENTS_SCHEMA' to the '@NgModule.schemas' of this component to suppress this message.`;
else message+=`2. To allow any element add 'NO_ERRORS_SCHEMA' to the '@NgModule.schemas' of this component.`;console.error(formatRuntimeError(304,message))}}}function elementContainerStartFirstCreatePass(index,tView,lView,attrsIndex,localRefsIndex){ngDevMode&&ngDevMode.firstCreatePass++;const tViewConsts=tView.consts;const attrs=getConstant(tViewConsts,attrsIndex);const tNode=getOrCreateTNode(tView,index,8,"ng-container",attrs);if(attrs!==null)computeStaticStyling(tNode,attrs,true);const localRefs=
getConstant(tViewConsts,localRefsIndex);resolveDirectives(tView,lView,tNode,localRefs);if(tView.queries!==null)tView.queries.elementStart(tView,tNode);return tNode}function \u0275\u0275elementContainerStart(index,attrsIndex,localRefsIndex){const lView=getLView();const tView=getTView();const adjustedIndex=index+HEADER_OFFSET;ngDevMode&&assertIndexInRange(lView,adjustedIndex);ngDevMode&&assertEqual(getBindingIndex(),tView.bindingStartIndex,"element containers should be created before any bindings");
const tNode=tView.firstCreatePass?elementContainerStartFirstCreatePass(adjustedIndex,tView,lView,attrsIndex,localRefsIndex):tView.data[adjustedIndex];setCurrentTNode(tNode,true);ngDevMode&&ngDevMode.rendererCreateComment++;const native=lView[adjustedIndex]=lView[RENDERER].createComment(ngDevMode?"ng-container":"");appendChild(tView,lView,native,tNode);attachPatchData(native,lView);if(isDirectiveHost(tNode)){createDirectivesInstances(tView,lView,tNode);executeContentQueries(tView,tNode,lView)}if(localRefsIndex!=
null)saveResolvedLocalsInData(lView,tNode)}function \u0275\u0275elementContainerEnd(){let currentTNode=getCurrentTNode();const tView=getTView();if(isCurrentTNodeParent())setCurrentTNodeAsNotParent();else{ngDevMode&&assertHasParent(currentTNode);currentTNode=currentTNode.parent;setCurrentTNode(currentTNode,false)}ngDevMode&&assertTNodeType(currentTNode,8);if(tView.firstCreatePass){registerPostOrderHooks(tView,currentTNode);if(isContentQueryHost(currentTNode))tView.queries.elementEnd(currentTNode)}}
function \u0275\u0275elementContainer(index,attrsIndex,localRefsIndex){\u0275\u0275elementContainerStart(index,attrsIndex,localRefsIndex);\u0275\u0275elementContainerEnd()}function \u0275\u0275getCurrentView(){return getLView()}function isPromise(obj){return!!obj&&typeof obj.then==="function"}function isSubscribable(obj){return!!obj&&typeof obj.subscribe==="function"}const isObservable=isSubscribable;function \u0275\u0275listener(eventName,listenerFn,useCapture,eventTargetResolver){const lView=getLView();
const tView=getTView();const tNode=getCurrentTNode();listenerInternal(tView,lView,lView[RENDERER],tNode,eventName,listenerFn,!!useCapture,eventTargetResolver);return \u0275\u0275listener}function \u0275\u0275syntheticHostListener(eventName,listenerFn){const tNode=getCurrentTNode();const lView=getLView();const tView=getTView();const currentDef=getCurrentDirectiveDef(tView.data);const renderer=loadComponentRenderer(currentDef,tNode,lView);listenerInternal(tView,lView,renderer,tNode,eventName,listenerFn,
false);return \u0275\u0275syntheticHostListener}function findExistingListener(tView,lView,eventName,tNodeIdx){const tCleanup=tView.cleanup;if(tCleanup!=null)for(let i=0;i<tCleanup.length-1;i+=2){const cleanupEventName=tCleanup[i];if(cleanupEventName===eventName&&tCleanup[i+1]===tNodeIdx){const lCleanup=lView[CLEANUP];const listenerIdxInLCleanup=tCleanup[i+2];return lCleanup.length>listenerIdxInLCleanup?lCleanup[listenerIdxInLCleanup]:null}if(typeof cleanupEventName==="string")i+=2}return null}function listenerInternal(tView,
lView,renderer,tNode,eventName,listenerFn,useCapture,eventTargetResolver){const isTNodeDirectiveHost=isDirectiveHost(tNode);const firstCreatePass=tView.firstCreatePass;const tCleanup=firstCreatePass&&getOrCreateTViewCleanup(tView);const context=lView[CONTEXT];const lCleanup=getOrCreateLViewCleanup(lView);ngDevMode&&assertTNodeType(tNode,3|12);let processOutputs=true;if(tNode.type&3||eventTargetResolver){const native=getNativeByTNode(tNode,lView);const target=eventTargetResolver?eventTargetResolver(native):
native;const lCleanupIndex=lCleanup.length;const idxOrTargetGetter=eventTargetResolver?_lView=>eventTargetResolver(unwrapRNode(_lView[tNode.index])):tNode.index;if(isProceduralRenderer(renderer)){let existingListener=null;if(!eventTargetResolver&&isTNodeDirectiveHost)existingListener=findExistingListener(tView,lView,eventName,tNode.index);if(existingListener!==null){const lastListenerFn=existingListener.__ngLastListenerFn__||existingListener;lastListenerFn.__ngNextListenerFn__=listenerFn;existingListener.__ngLastListenerFn__=
listenerFn;processOutputs=false}else{listenerFn=wrapListener(tNode,lView,context,listenerFn,false);const cleanupFn=renderer.listen(target,eventName,listenerFn);ngDevMode&&ngDevMode.rendererAddEventListener++;lCleanup.push(listenerFn,cleanupFn);tCleanup&&tCleanup.push(eventName,idxOrTargetGetter,lCleanupIndex,lCleanupIndex+1)}}else{listenerFn=wrapListener(tNode,lView,context,listenerFn,true);target.addEventListener(eventName,listenerFn,useCapture);ngDevMode&&ngDevMode.rendererAddEventListener++;lCleanup.push(listenerFn);
tCleanup&&tCleanup.push(eventName,idxOrTargetGetter,lCleanupIndex,useCapture)}}else listenerFn=wrapListener(tNode,lView,context,listenerFn,false);const outputs=tNode.outputs;let props;if(processOutputs&&outputs!==null&&(props=outputs[eventName])){const propsLength=props.length;if(propsLength)for(let i=0;i<propsLength;i+=2){const index=props[i];ngDevMode&&assertIndexInRange(lView,index);const minifiedName=props[i+1];const directiveInstance=lView[index];const output=directiveInstance[minifiedName];
if(ngDevMode&&!isObservable(output))throw new Error(`@Output ${minifiedName} not initialized in '${directiveInstance.constructor.name}'.`);const subscription=output.subscribe(listenerFn);const idx=lCleanup.length;lCleanup.push(listenerFn,subscription);tCleanup&&tCleanup.push(eventName,tNode.index,idx,-(idx+1))}}}function executeListenerWithErrorHandling(lView,context,listenerFn,e){try{profiler(6,context,listenerFn);return listenerFn(e)!==false}catch(error){handleError(lView,error);return false}finally{profiler(7,
context,listenerFn)}}function wrapListener(tNode,lView,context,listenerFn,wrapWithPreventDefault){return function wrapListenerIn_markDirtyAndPreventDefault(e){if(e===Function)return listenerFn;const startView=tNode.flags&2?getComponentLViewByIndex(tNode.index,lView):lView;if((lView[FLAGS]&32)===0)markViewDirty(startView);let result=executeListenerWithErrorHandling(lView,context,listenerFn,e);let nextListenerFn=wrapListenerIn_markDirtyAndPreventDefault.__ngNextListenerFn__;while(nextListenerFn){result=
executeListenerWithErrorHandling(lView,context,nextListenerFn,e)&&result;nextListenerFn=nextListenerFn.__ngNextListenerFn__}if(wrapWithPreventDefault&&result===false){e.preventDefault();e.returnValue=false}return result}}function \u0275\u0275nextContext(level=1){return nextContextImpl(level)}function matchingProjectionSlotIndex(tNode,projectionSlots){let wildcardNgContentIndex=null;const ngProjectAsAttrVal=getProjectAsAttrValue(tNode);for(let i=0;i<projectionSlots.length;i++){const slotValue=projectionSlots[i];
if(slotValue==="*"){wildcardNgContentIndex=i;continue}if(ngProjectAsAttrVal===null?isNodeMatchingSelectorList(tNode,slotValue,true):isSelectorInSelectorList(ngProjectAsAttrVal,slotValue))return i}return wildcardNgContentIndex}function \u0275\u0275projectionDef(projectionSlots){const componentNode=getLView()[DECLARATION_COMPONENT_VIEW][T_HOST];if(!componentNode.projection){const numProjectionSlots=projectionSlots?projectionSlots.length:1;const projectionHeads=componentNode.projection=newArray(numProjectionSlots,
null);const tails=projectionHeads.slice();let componentChild=componentNode.child;while(componentChild!==null){const slotIndex=projectionSlots?matchingProjectionSlotIndex(componentChild,projectionSlots):0;if(slotIndex!==null){if(tails[slotIndex])tails[slotIndex].projectionNext=componentChild;else projectionHeads[slotIndex]=componentChild;tails[slotIndex]=componentChild}componentChild=componentChild.next}}}function \u0275\u0275projection(nodeIndex,selectorIndex=0,attrs){const lView=getLView();const tView=
getTView();const tProjectionNode=getOrCreateTNode(tView,HEADER_OFFSET+nodeIndex,16,null,attrs||null);if(tProjectionNode.projection===null)tProjectionNode.projection=selectorIndex;setCurrentTNodeAsNotParent();if((tProjectionNode.flags&64)!==64)applyProjection(tView,lView,tProjectionNode)}function \u0275\u0275propertyInterpolate(propName,v0,sanitizer){\u0275\u0275propertyInterpolate1(propName,"",v0,"",sanitizer);return \u0275\u0275propertyInterpolate}function \u0275\u0275propertyInterpolate1(propName,
prefix,v0,suffix,sanitizer){const lView=getLView();const interpolatedValue=interpolation1(lView,prefix,v0,suffix);if(interpolatedValue!==NO_CHANGE){const tView=getTView();const tNode=getSelectedTNode();elementPropertyInternal(tView,tNode,lView,propName,interpolatedValue,lView[RENDERER],sanitizer,false);ngDevMode&&storePropertyBindingMetadata(tView.data,tNode,propName,getBindingIndex()-1,prefix,suffix)}return \u0275\u0275propertyInterpolate1}function \u0275\u0275propertyInterpolate2(propName,prefix,
v0,i0,v1,suffix,sanitizer){const lView=getLView();const interpolatedValue=interpolation2(lView,prefix,v0,i0,v1,suffix);if(interpolatedValue!==NO_CHANGE){const tView=getTView();const tNode=getSelectedTNode();elementPropertyInternal(tView,tNode,lView,propName,interpolatedValue,lView[RENDERER],sanitizer,false);ngDevMode&&storePropertyBindingMetadata(tView.data,tNode,propName,getBindingIndex()-2,prefix,i0,suffix)}return \u0275\u0275propertyInterpolate2}function \u0275\u0275propertyInterpolate3(propName,
prefix,v0,i0,v1,i1,v2,suffix,sanitizer){const lView=getLView();const interpolatedValue=interpolation3(lView,prefix,v0,i0,v1,i1,v2,suffix);if(interpolatedValue!==NO_CHANGE){const tView=getTView();const tNode=getSelectedTNode();elementPropertyInternal(tView,tNode,lView,propName,interpolatedValue,lView[RENDERER],sanitizer,false);ngDevMode&&storePropertyBindingMetadata(tView.data,tNode,propName,getBindingIndex()-3,prefix,i0,i1,suffix)}return \u0275\u0275propertyInterpolate3}function \u0275\u0275propertyInterpolate4(propName,
prefix,v0,i0,v1,i1,v2,i2,v3,suffix,sanitizer){const lView=getLView();const interpolatedValue=interpolation4(lView,prefix,v0,i0,v1,i1,v2,i2,v3,suffix);if(interpolatedValue!==NO_CHANGE){const tView=getTView();const tNode=getSelectedTNode();elementPropertyInternal(tView,tNode,lView,propName,interpolatedValue,lView[RENDERER],sanitizer,false);ngDevMode&&storePropertyBindingMetadata(tView.data,tNode,propName,getBindingIndex()-4,prefix,i0,i1,i2,suffix)}return \u0275\u0275propertyInterpolate4}function \u0275\u0275propertyInterpolate5(propName,
prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,suffix,sanitizer){const lView=getLView();const interpolatedValue=interpolation5(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,suffix);if(interpolatedValue!==NO_CHANGE){const tView=getTView();const tNode=getSelectedTNode();elementPropertyInternal(tView,tNode,lView,propName,interpolatedValue,lView[RENDERER],sanitizer,false);ngDevMode&&storePropertyBindingMetadata(tView.data,tNode,propName,getBindingIndex()-5,prefix,i0,i1,i2,i3,suffix)}return \u0275\u0275propertyInterpolate5}
function \u0275\u0275propertyInterpolate6(propName,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,suffix,sanitizer){const lView=getLView();const interpolatedValue=interpolation6(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,suffix);if(interpolatedValue!==NO_CHANGE){const tView=getTView();const tNode=getSelectedTNode();elementPropertyInternal(tView,tNode,lView,propName,interpolatedValue,lView[RENDERER],sanitizer,false);ngDevMode&&storePropertyBindingMetadata(tView.data,tNode,propName,getBindingIndex()-6,
prefix,i0,i1,i2,i3,i4,suffix)}return \u0275\u0275propertyInterpolate6}function \u0275\u0275propertyInterpolate7(propName,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,suffix,sanitizer){const lView=getLView();const interpolatedValue=interpolation7(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,suffix);if(interpolatedValue!==NO_CHANGE){const tView=getTView();const tNode=getSelectedTNode();elementPropertyInternal(tView,tNode,lView,propName,interpolatedValue,lView[RENDERER],sanitizer,false);ngDevMode&&
storePropertyBindingMetadata(tView.data,tNode,propName,getBindingIndex()-7,prefix,i0,i1,i2,i3,i4,i5,suffix)}return \u0275\u0275propertyInterpolate7}function \u0275\u0275propertyInterpolate8(propName,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,i6,v7,suffix,sanitizer){const lView=getLView();const interpolatedValue=interpolation8(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,i6,v7,suffix);if(interpolatedValue!==NO_CHANGE){const tView=getTView();const tNode=getSelectedTNode();elementPropertyInternal(tView,
tNode,lView,propName,interpolatedValue,lView[RENDERER],sanitizer,false);ngDevMode&&storePropertyBindingMetadata(tView.data,tNode,propName,getBindingIndex()-8,prefix,i0,i1,i2,i3,i4,i5,i6,suffix)}return \u0275\u0275propertyInterpolate8}function \u0275\u0275propertyInterpolateV(propName,values,sanitizer){const lView=getLView();const interpolatedValue=interpolationV(lView,values);if(interpolatedValue!==NO_CHANGE){const tView=getTView();const tNode=getSelectedTNode();elementPropertyInternal(tView,tNode,
lView,propName,interpolatedValue,lView[RENDERER],sanitizer,false);if(ngDevMode){const interpolationInBetween=[values[0]];for(let i=2;i<values.length;i+=2)interpolationInBetween.push(values[i]);storePropertyBindingMetadata(tView.data,tNode,propName,getBindingIndex()-interpolationInBetween.length+1,...interpolationInBetween)}}return \u0275\u0275propertyInterpolateV}function insertTStylingBinding(tData,tNode,tStylingKeyWithStatic,index,isHostBinding,isClassBinding){ngDevMode&&assertFirstUpdatePass(getTView());
let tBindings=isClassBinding?tNode.classBindings:tNode.styleBindings;let tmplHead=getTStylingRangePrev(tBindings);let tmplTail=getTStylingRangeNext(tBindings);tData[index]=tStylingKeyWithStatic;let isKeyDuplicateOfStatic=false;let tStylingKey;if(Array.isArray(tStylingKeyWithStatic)){const staticKeyValueArray=tStylingKeyWithStatic;tStylingKey=staticKeyValueArray[1];if(tStylingKey===null||keyValueArrayIndexOf(staticKeyValueArray,tStylingKey)>0)isKeyDuplicateOfStatic=true}else tStylingKey=tStylingKeyWithStatic;
if(isHostBinding){const hasTemplateBindings=tmplTail!==0;if(hasTemplateBindings){const previousNode=getTStylingRangePrev(tData[tmplHead+1]);tData[index+1]=toTStylingRange(previousNode,tmplHead);if(previousNode!==0)tData[previousNode+1]=setTStylingRangeNext(tData[previousNode+1],index);tData[tmplHead+1]=setTStylingRangePrev(tData[tmplHead+1],index)}else{tData[index+1]=toTStylingRange(tmplHead,0);if(tmplHead!==0)tData[tmplHead+1]=setTStylingRangeNext(tData[tmplHead+1],index);tmplHead=index}}else{tData[index+
1]=toTStylingRange(tmplTail,0);ngDevMode&&assertEqual(tmplHead!==0&&tmplTail===0,false,"Adding template bindings after hostBindings is not allowed.");if(tmplHead===0)tmplHead=index;else tData[tmplTail+1]=setTStylingRangeNext(tData[tmplTail+1],index);tmplTail=index}if(isKeyDuplicateOfStatic)tData[index+1]=setTStylingRangePrevDuplicate(tData[index+1]);markDuplicates(tData,tStylingKey,index,true);markDuplicates(tData,tStylingKey,index,false);markDuplicateOfResidualStyling(tNode,tStylingKey,tData,index,
isClassBinding);tBindings=toTStylingRange(tmplHead,tmplTail);if(isClassBinding)tNode.classBindings=tBindings;else tNode.styleBindings=tBindings}function markDuplicateOfResidualStyling(tNode,tStylingKey,tData,index,isClassBinding){const residual=isClassBinding?tNode.residualClasses:tNode.residualStyles;if(residual!=null&&typeof tStylingKey=="string"&&keyValueArrayIndexOf(residual,tStylingKey)>=0)tData[index+1]=setTStylingRangeNextDuplicate(tData[index+1])}function markDuplicates(tData,tStylingKey,
index,isPrevDir,isClassBinding){const tStylingAtIndex=tData[index+1];const isMap=tStylingKey===null;let cursor=isPrevDir?getTStylingRangePrev(tStylingAtIndex):getTStylingRangeNext(tStylingAtIndex);let foundDuplicate=false;while(cursor!==0&&(foundDuplicate===false||isMap)){ngDevMode&&assertIndexInRange(tData,cursor);const tStylingValueAtCursor=tData[cursor];const tStyleRangeAtCursor=tData[cursor+1];if(isStylingMatch(tStylingValueAtCursor,tStylingKey)){foundDuplicate=true;tData[cursor+1]=isPrevDir?
setTStylingRangeNextDuplicate(tStyleRangeAtCursor):setTStylingRangePrevDuplicate(tStyleRangeAtCursor)}cursor=isPrevDir?getTStylingRangePrev(tStyleRangeAtCursor):getTStylingRangeNext(tStyleRangeAtCursor)}if(foundDuplicate)tData[index+1]=isPrevDir?setTStylingRangePrevDuplicate(tStylingAtIndex):setTStylingRangeNextDuplicate(tStylingAtIndex)}function isStylingMatch(tStylingKeyCursor,tStylingKey){ngDevMode&&assertNotEqual(Array.isArray(tStylingKey),true,"Expected that 'tStylingKey' has been unwrapped");
if(tStylingKeyCursor===null||tStylingKey==null||(Array.isArray(tStylingKeyCursor)?tStylingKeyCursor[1]:tStylingKeyCursor)===tStylingKey)return true;else if(Array.isArray(tStylingKeyCursor)&&typeof tStylingKey==="string")return keyValueArrayIndexOf(tStylingKeyCursor,tStylingKey)>=0;return false}const parserState={textEnd:0,key:0,keyEnd:0,value:0,valueEnd:0};function getLastParsedKey(text){return text.substring(parserState.key,parserState.keyEnd)}function getLastParsedValue(text){return text.substring(parserState.value,
parserState.valueEnd)}function parseClassName(text){resetParserState(text);return parseClassNameNext(text,consumeWhitespace(text,0,parserState.textEnd))}function parseClassNameNext(text,index){const end=parserState.textEnd;if(end===index)return-1;index=parserState.keyEnd=consumeClassToken(text,parserState.key=index,end);return consumeWhitespace(text,index,end)}function parseStyle(text){resetParserState(text);return parseStyleNext(text,consumeWhitespace(text,0,parserState.textEnd))}function parseStyleNext(text,
startIndex){const end=parserState.textEnd;let index=parserState.key=consumeWhitespace(text,startIndex,end);if(end===index)return-1;index=parserState.keyEnd=consumeStyleKey(text,index,end);index=consumeSeparator(text,index,end,58);index=parserState.value=consumeWhitespace(text,index,end);index=parserState.valueEnd=consumeStyleValue(text,index,end);return consumeSeparator(text,index,end,59)}function resetParserState(text){parserState.key=0;parserState.keyEnd=0;parserState.value=0;parserState.valueEnd=
0;parserState.textEnd=text.length}function consumeWhitespace(text,startIndex,endIndex){while(startIndex<endIndex&&text.charCodeAt(startIndex)<=32)startIndex++;return startIndex}function consumeClassToken(text,startIndex,endIndex){while(startIndex<endIndex&&text.charCodeAt(startIndex)>32)startIndex++;return startIndex}function consumeStyleKey(text,startIndex,endIndex){let ch;while(startIndex<endIndex&&((ch=text.charCodeAt(startIndex))===45||ch===95||(ch&-33)>=65&&(ch&-33)<=90||ch>=48&&ch<=57))startIndex++;
return startIndex}function consumeSeparator(text,startIndex,endIndex,separator){startIndex=consumeWhitespace(text,startIndex,endIndex);if(startIndex<endIndex){if(ngDevMode&&text.charCodeAt(startIndex)!==separator)malformedStyleError(text,String.fromCharCode(separator),startIndex);startIndex++}return startIndex}function consumeStyleValue(text,startIndex,endIndex){let ch1=-1;let ch2=-1;let ch3=-1;let i=startIndex;let lastChIndex=i;while(i<endIndex){const ch=text.charCodeAt(i++);if(ch===59)return lastChIndex;
else if(ch===34||ch===39)lastChIndex=i=consumeQuotedText(text,ch,i,endIndex);else if(startIndex===i-4&&ch3===85&&ch2===82&&ch1===76&&ch===40)lastChIndex=i=consumeQuotedText(text,41,i,endIndex);else if(ch>32)lastChIndex=i;ch3=ch2;ch2=ch1;ch1=ch&-33}return lastChIndex}function consumeQuotedText(text,quoteCharCode,startIndex,endIndex){let ch1=-1;let index=startIndex;while(index<endIndex){const ch=text.charCodeAt(index++);if(ch==quoteCharCode&&ch1!==92)return index;if(ch==92&&ch1===92)ch1=0;else ch1=
ch}throw ngDevMode?malformedStyleError(text,String.fromCharCode(quoteCharCode),endIndex):new Error;}function malformedStyleError(text,expecting,index){ngDevMode&&assertEqual(typeof text==="string",true,"String expected here");throw throwError(`Malformed style at location ${index} in string '`+text.substring(0,index)+"[>>"+text.substring(index,index+1)+"<<]"+text.substr(index+1)+`'. Expecting '${expecting}'.`);}function \u0275\u0275styleProp(prop,value,suffix){checkStylingProperty(prop,value,suffix,
false);return \u0275\u0275styleProp}function \u0275\u0275classProp(className,value){checkStylingProperty(className,value,null,true);return \u0275\u0275classProp}function \u0275\u0275styleMap(styles){checkStylingMap(styleKeyValueArraySet,styleStringParser,styles,false)}function styleStringParser(keyValueArray,text){for(let i=parseStyle(text);i>=0;i=parseStyleNext(text,i))styleKeyValueArraySet(keyValueArray,getLastParsedKey(text),getLastParsedValue(text))}function \u0275\u0275classMap(classes){checkStylingMap(keyValueArraySet,
classStringParser,classes,true)}function classStringParser(keyValueArray,text){for(let i=parseClassName(text);i>=0;i=parseClassNameNext(text,i))keyValueArraySet(keyValueArray,getLastParsedKey(text),true)}function checkStylingProperty(prop,value,suffix,isClassBased){const lView=getLView();const tView=getTView();const bindingIndex=incrementBindingIndex(2);if(tView.firstUpdatePass)stylingFirstUpdatePass(tView,prop,bindingIndex,isClassBased);if(value!==NO_CHANGE&&bindingUpdated(lView,bindingIndex,value)){const tNode=
tView.data[getSelectedIndex()];updateStyling(tView,tNode,lView,lView[RENDERER],prop,lView[bindingIndex+1]=normalizeSuffix(value,suffix),isClassBased,bindingIndex)}}function checkStylingMap(keyValueArraySet,stringParser,value,isClassBased){const tView=getTView();const bindingIndex=incrementBindingIndex(2);if(tView.firstUpdatePass)stylingFirstUpdatePass(tView,null,bindingIndex,isClassBased);const lView=getLView();if(value!==NO_CHANGE&&bindingUpdated(lView,bindingIndex,value)){const tNode=tView.data[getSelectedIndex()];
if(hasStylingInputShadow(tNode,isClassBased)&&!isInHostBindings(tView,bindingIndex)){if(ngDevMode){const tStylingKey=tView.data[bindingIndex];assertEqual(Array.isArray(tStylingKey)?tStylingKey[1]:tStylingKey,false,"Styling linked list shadow input should be marked as 'false'")}let staticPrefix=isClassBased?tNode.classesWithoutHost:tNode.stylesWithoutHost;ngDevMode&&isClassBased===false&&staticPrefix!==null&&assertEqual(staticPrefix.endsWith(";"),true,"Expecting static portion to end with ';'");if(staticPrefix!==
null)value=concatStringsWithSpace(staticPrefix,value?value:"");setDirectiveInputsWhichShadowsStyling(tView,tNode,lView,value,isClassBased)}else updateStylingMap(tView,tNode,lView,lView[RENDERER],lView[bindingIndex+1],lView[bindingIndex+1]=toStylingKeyValueArray(keyValueArraySet,stringParser,value),isClassBased,bindingIndex)}}function isInHostBindings(tView,bindingIndex){return bindingIndex>=tView.expandoStartIndex}function stylingFirstUpdatePass(tView,tStylingKey,bindingIndex,isClassBased){ngDevMode&&
assertFirstUpdatePass(tView);const tData=tView.data;if(tData[bindingIndex+1]===null){const tNode=tData[getSelectedIndex()];ngDevMode&&assertDefined(tNode,"TNode expected");const isHostBindings=isInHostBindings(tView,bindingIndex);if(hasStylingInputShadow(tNode,isClassBased)&&tStylingKey===null&&!isHostBindings)tStylingKey=false;tStylingKey=wrapInStaticStylingKey(tData,tNode,tStylingKey,isClassBased);insertTStylingBinding(tData,tNode,tStylingKey,bindingIndex,isHostBindings,isClassBased)}}function wrapInStaticStylingKey(tData,
tNode,stylingKey,isClassBased){const hostDirectiveDef=getCurrentDirectiveDef(tData);let residual=isClassBased?tNode.residualClasses:tNode.residualStyles;if(hostDirectiveDef===null){const isFirstStylingInstructionInTemplate=(isClassBased?tNode.classBindings:tNode.styleBindings)===0;if(isFirstStylingInstructionInTemplate){stylingKey=collectStylingFromDirectives(null,tData,tNode,stylingKey,isClassBased);stylingKey=collectStylingFromTAttrs(stylingKey,tNode.attrs,isClassBased);residual=null}}else{const directiveStylingLast=
tNode.directiveStylingLast;const isFirstStylingInstructionInHostBinding=directiveStylingLast===-1||tData[directiveStylingLast]!==hostDirectiveDef;if(isFirstStylingInstructionInHostBinding){stylingKey=collectStylingFromDirectives(hostDirectiveDef,tData,tNode,stylingKey,isClassBased);if(residual===null){let templateStylingKey=getTemplateHeadTStylingKey(tData,tNode,isClassBased);if(templateStylingKey!==undefined&&Array.isArray(templateStylingKey)){templateStylingKey=collectStylingFromDirectives(null,
tData,tNode,templateStylingKey[1],isClassBased);templateStylingKey=collectStylingFromTAttrs(templateStylingKey,tNode.attrs,isClassBased);setTemplateHeadTStylingKey(tData,tNode,isClassBased,templateStylingKey)}}else residual=collectResidual(tData,tNode,isClassBased)}}if(residual!==undefined)isClassBased?tNode.residualClasses=residual:tNode.residualStyles=residual;return stylingKey}function getTemplateHeadTStylingKey(tData,tNode,isClassBased){const bindings=isClassBased?tNode.classBindings:tNode.styleBindings;
if(getTStylingRangeNext(bindings)===0)return undefined;return tData[getTStylingRangePrev(bindings)]}function setTemplateHeadTStylingKey(tData,tNode,isClassBased,tStylingKey){const bindings=isClassBased?tNode.classBindings:tNode.styleBindings;ngDevMode&&assertNotEqual(getTStylingRangeNext(bindings),0,"Expecting to have at least one template styling binding.");tData[getTStylingRangePrev(bindings)]=tStylingKey}function collectResidual(tData,tNode,isClassBased){let residual=undefined;const directiveEnd=
tNode.directiveEnd;ngDevMode&&assertNotEqual(tNode.directiveStylingLast,-1,"By the time this function gets called at least one hostBindings-node styling instruction must have executed.");for(let i=1+tNode.directiveStylingLast;i<directiveEnd;i++){const attrs=tData[i].hostAttrs;residual=collectStylingFromTAttrs(residual,attrs,isClassBased)}return collectStylingFromTAttrs(residual,tNode.attrs,isClassBased)}function collectStylingFromDirectives(hostDirectiveDef,tData,tNode,stylingKey,isClassBased){let currentDirective=
null;const directiveEnd=tNode.directiveEnd;let directiveStylingLast=tNode.directiveStylingLast;if(directiveStylingLast===-1)directiveStylingLast=tNode.directiveStart;else directiveStylingLast++;while(directiveStylingLast<directiveEnd){currentDirective=tData[directiveStylingLast];ngDevMode&&assertDefined(currentDirective,"expected to be defined");stylingKey=collectStylingFromTAttrs(stylingKey,currentDirective.hostAttrs,isClassBased);if(currentDirective===hostDirectiveDef)break;directiveStylingLast++}if(hostDirectiveDef!==
null)tNode.directiveStylingLast=directiveStylingLast;return stylingKey}function collectStylingFromTAttrs(stylingKey,attrs,isClassBased){const desiredMarker=isClassBased?1:2;let currentMarker=-1;if(attrs!==null)for(let i=0;i<attrs.length;i++){const item=attrs[i];if(typeof item==="number")currentMarker=item;else if(currentMarker===desiredMarker){if(!Array.isArray(stylingKey))stylingKey=stylingKey===undefined?[]:["",stylingKey];keyValueArraySet(stylingKey,item,isClassBased?true:attrs[++i])}}return stylingKey===
undefined?null:stylingKey}function toStylingKeyValueArray(keyValueArraySet,stringParser,value){if(value==null||value==="")return EMPTY_ARRAY;const styleKeyValueArray=[];const unwrappedValue=unwrapSafeValue(value);if(Array.isArray(unwrappedValue))for(let i=0;i<unwrappedValue.length;i++)keyValueArraySet(styleKeyValueArray,unwrappedValue[i],true);else if(typeof unwrappedValue==="object")for(const key in unwrappedValue){if(unwrappedValue.hasOwnProperty(key))keyValueArraySet(styleKeyValueArray,key,unwrappedValue[key])}else if(typeof unwrappedValue===
"string")stringParser(styleKeyValueArray,unwrappedValue);else ngDevMode&&throwError("Unsupported styling type "+typeof unwrappedValue+": "+unwrappedValue);return styleKeyValueArray}function styleKeyValueArraySet(keyValueArray,key,value){keyValueArraySet(keyValueArray,key,unwrapSafeValue(value))}function updateStylingMap(tView,tNode,lView,renderer,oldKeyValueArray,newKeyValueArray,isClassBased,bindingIndex){if(oldKeyValueArray===NO_CHANGE)oldKeyValueArray=EMPTY_ARRAY;let oldIndex=0;let newIndex=0;
let oldKey=0<oldKeyValueArray.length?oldKeyValueArray[0]:null;let newKey=0<newKeyValueArray.length?newKeyValueArray[0]:null;while(oldKey!==null||newKey!==null){ngDevMode&&assertLessThan(oldIndex,999,"Are we stuck in infinite loop?");ngDevMode&&assertLessThan(newIndex,999,"Are we stuck in infinite loop?");const oldValue=oldIndex<oldKeyValueArray.length?oldKeyValueArray[oldIndex+1]:undefined;const newValue=newIndex<newKeyValueArray.length?newKeyValueArray[newIndex+1]:undefined;let setKey=null;let setValue=
undefined;if(oldKey===newKey){oldIndex+=2;newIndex+=2;if(oldValue!==newValue){setKey=newKey;setValue=newValue}}else if(newKey===null||oldKey!==null&&oldKey<newKey){oldIndex+=2;setKey=oldKey}else{ngDevMode&&assertDefined(newKey,"Expecting to have a valid key");newIndex+=2;setKey=newKey;setValue=newValue}if(setKey!==null)updateStyling(tView,tNode,lView,renderer,setKey,setValue,isClassBased,bindingIndex);oldKey=oldIndex<oldKeyValueArray.length?oldKeyValueArray[oldIndex]:null;newKey=newIndex<newKeyValueArray.length?
newKeyValueArray[newIndex]:null}}function updateStyling(tView,tNode,lView,renderer,prop,value,isClassBased,bindingIndex){if(!(tNode.type&3))return;const tData=tView.data;const tRange=tData[bindingIndex+1];const higherPriorityValue=getTStylingRangeNextDuplicate(tRange)?findStylingValue(tData,tNode,lView,prop,getTStylingRangeNext(tRange),isClassBased):undefined;if(!isStylingValuePresent(higherPriorityValue)){if(!isStylingValuePresent(value))if(getTStylingRangePrevDuplicate(tRange))value=findStylingValue(tData,
null,lView,prop,bindingIndex,isClassBased);const rNode=getNativeByIndex(getSelectedIndex(),lView);applyStyling(renderer,isClassBased,rNode,prop,value)}}function findStylingValue(tData,tNode,lView,prop,index,isClassBased){const isPrevDirection=tNode===null;let value=undefined;while(index>0){const rawKey=tData[index];const containsStatics=Array.isArray(rawKey);const key=containsStatics?rawKey[1]:rawKey;const isStylingMap=key===null;let valueAtLViewIndex=lView[index+1];if(valueAtLViewIndex===NO_CHANGE)valueAtLViewIndex=
isStylingMap?EMPTY_ARRAY:undefined;let currentValue=isStylingMap?keyValueArrayGet(valueAtLViewIndex,prop):key===prop?valueAtLViewIndex:undefined;if(containsStatics&&!isStylingValuePresent(currentValue))currentValue=keyValueArrayGet(rawKey,prop);if(isStylingValuePresent(currentValue)){value=currentValue;if(isPrevDirection)return value}const tRange=tData[index+1];index=isPrevDirection?getTStylingRangePrev(tRange):getTStylingRangeNext(tRange)}if(tNode!==null){let residual=isClassBased?tNode.residualClasses:
tNode.residualStyles;if(residual!=null)value=keyValueArrayGet(residual,prop)}return value}function isStylingValuePresent(value){return value!==undefined}function normalizeSuffix(value,suffix){if(value==null);else if(typeof suffix==="string")value=value+suffix;else if(typeof value==="object")value=stringify(unwrapSafeValue(value));return value}function hasStylingInputShadow(tNode,isClassBased){return(tNode.flags&(isClassBased?16:32))!==0}function \u0275\u0275text(index,value=""){const lView=getLView();
const tView=getTView();const adjustedIndex=index+HEADER_OFFSET;ngDevMode&&assertEqual(getBindingIndex(),tView.bindingStartIndex,"text nodes should be created before any bindings");ngDevMode&&assertIndexInRange(lView,adjustedIndex);const tNode=tView.firstCreatePass?getOrCreateTNode(tView,adjustedIndex,1,value,null):tView.data[adjustedIndex];const textNative=lView[adjustedIndex]=createTextNode(lView[RENDERER],value);appendChild(tView,lView,textNative,tNode);setCurrentTNode(tNode,false)}function \u0275\u0275textInterpolate(v0){\u0275\u0275textInterpolate1("",
v0,"");return \u0275\u0275textInterpolate}function \u0275\u0275textInterpolate1(prefix,v0,suffix){const lView=getLView();const interpolated=interpolation1(lView,prefix,v0,suffix);if(interpolated!==NO_CHANGE)textBindingInternal(lView,getSelectedIndex(),interpolated);return \u0275\u0275textInterpolate1}function \u0275\u0275textInterpolate2(prefix,v0,i0,v1,suffix){const lView=getLView();const interpolated=interpolation2(lView,prefix,v0,i0,v1,suffix);if(interpolated!==NO_CHANGE)textBindingInternal(lView,
getSelectedIndex(),interpolated);return \u0275\u0275textInterpolate2}function \u0275\u0275textInterpolate3(prefix,v0,i0,v1,i1,v2,suffix){const lView=getLView();const interpolated=interpolation3(lView,prefix,v0,i0,v1,i1,v2,suffix);if(interpolated!==NO_CHANGE)textBindingInternal(lView,getSelectedIndex(),interpolated);return \u0275\u0275textInterpolate3}function \u0275\u0275textInterpolate4(prefix,v0,i0,v1,i1,v2,i2,v3,suffix){const lView=getLView();const interpolated=interpolation4(lView,prefix,v0,i0,
v1,i1,v2,i2,v3,suffix);if(interpolated!==NO_CHANGE)textBindingInternal(lView,getSelectedIndex(),interpolated);return \u0275\u0275textInterpolate4}function \u0275\u0275textInterpolate5(prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,suffix){const lView=getLView();const interpolated=interpolation5(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,suffix);if(interpolated!==NO_CHANGE)textBindingInternal(lView,getSelectedIndex(),interpolated);return \u0275\u0275textInterpolate5}function \u0275\u0275textInterpolate6(prefix,v0,
i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,suffix){const lView=getLView();const interpolated=interpolation6(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,suffix);if(interpolated!==NO_CHANGE)textBindingInternal(lView,getSelectedIndex(),interpolated);return \u0275\u0275textInterpolate6}function \u0275\u0275textInterpolate7(prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,suffix){const lView=getLView();const interpolated=interpolation7(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,suffix);if(interpolated!==NO_CHANGE)textBindingInternal(lView,
getSelectedIndex(),interpolated);return \u0275\u0275textInterpolate7}function \u0275\u0275textInterpolate8(prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,i6,v7,suffix){const lView=getLView();const interpolated=interpolation8(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,i6,v7,suffix);if(interpolated!==NO_CHANGE)textBindingInternal(lView,getSelectedIndex(),interpolated);return \u0275\u0275textInterpolate8}function \u0275\u0275textInterpolateV(values){const lView=getLView();const interpolated=
interpolationV(lView,values);if(interpolated!==NO_CHANGE)textBindingInternal(lView,getSelectedIndex(),interpolated);return \u0275\u0275textInterpolateV}function \u0275\u0275classMapInterpolate1(prefix,v0,suffix){const lView=getLView();const interpolatedValue=interpolation1(lView,prefix,v0,suffix);checkStylingMap(keyValueArraySet,classStringParser,interpolatedValue,true)}function \u0275\u0275classMapInterpolate2(prefix,v0,i0,v1,suffix){const lView=getLView();const interpolatedValue=interpolation2(lView,
prefix,v0,i0,v1,suffix);checkStylingMap(keyValueArraySet,classStringParser,interpolatedValue,true)}function \u0275\u0275classMapInterpolate3(prefix,v0,i0,v1,i1,v2,suffix){const lView=getLView();const interpolatedValue=interpolation3(lView,prefix,v0,i0,v1,i1,v2,suffix);checkStylingMap(keyValueArraySet,classStringParser,interpolatedValue,true)}function \u0275\u0275classMapInterpolate4(prefix,v0,i0,v1,i1,v2,i2,v3,suffix){const lView=getLView();const interpolatedValue=interpolation4(lView,prefix,v0,i0,
v1,i1,v2,i2,v3,suffix);checkStylingMap(keyValueArraySet,classStringParser,interpolatedValue,true)}function \u0275\u0275classMapInterpolate5(prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,suffix){const lView=getLView();const interpolatedValue=interpolation5(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,suffix);checkStylingMap(keyValueArraySet,classStringParser,interpolatedValue,true)}function \u0275\u0275classMapInterpolate6(prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,suffix){const lView=getLView();const interpolatedValue=
interpolation6(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,suffix);checkStylingMap(keyValueArraySet,classStringParser,interpolatedValue,true)}function \u0275\u0275classMapInterpolate7(prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,suffix){const lView=getLView();const interpolatedValue=interpolation7(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,suffix);checkStylingMap(keyValueArraySet,classStringParser,interpolatedValue,true)}function \u0275\u0275classMapInterpolate8(prefix,v0,i0,v1,i1,v2,
i2,v3,i3,v4,i4,v5,i5,v6,i6,v7,suffix){const lView=getLView();const interpolatedValue=interpolation8(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,i6,v7,suffix);checkStylingMap(keyValueArraySet,classStringParser,interpolatedValue,true)}function \u0275\u0275classMapInterpolateV(values){const lView=getLView();const interpolatedValue=interpolationV(lView,values);checkStylingMap(keyValueArraySet,classStringParser,interpolatedValue,true)}function \u0275\u0275styleMapInterpolate1(prefix,v0,suffix){const lView=
getLView();const interpolatedValue=interpolation1(lView,prefix,v0,suffix);\u0275\u0275styleMap(interpolatedValue)}function \u0275\u0275styleMapInterpolate2(prefix,v0,i0,v1,suffix){const lView=getLView();const interpolatedValue=interpolation2(lView,prefix,v0,i0,v1,suffix);\u0275\u0275styleMap(interpolatedValue)}function \u0275\u0275styleMapInterpolate3(prefix,v0,i0,v1,i1,v2,suffix){const lView=getLView();const interpolatedValue=interpolation3(lView,prefix,v0,i0,v1,i1,v2,suffix);\u0275\u0275styleMap(interpolatedValue)}
function \u0275\u0275styleMapInterpolate4(prefix,v0,i0,v1,i1,v2,i2,v3,suffix){const lView=getLView();const interpolatedValue=interpolation4(lView,prefix,v0,i0,v1,i1,v2,i2,v3,suffix);\u0275\u0275styleMap(interpolatedValue)}function \u0275\u0275styleMapInterpolate5(prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,suffix){const lView=getLView();const interpolatedValue=interpolation5(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,suffix);\u0275\u0275styleMap(interpolatedValue)}function \u0275\u0275styleMapInterpolate6(prefix,
v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,suffix){const lView=getLView();const interpolatedValue=interpolation6(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,suffix);\u0275\u0275styleMap(interpolatedValue)}function \u0275\u0275styleMapInterpolate7(prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,suffix){const lView=getLView();const interpolatedValue=interpolation7(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,suffix);\u0275\u0275styleMap(interpolatedValue)}function \u0275\u0275styleMapInterpolate8(prefix,
v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,i6,v7,suffix){const lView=getLView();const interpolatedValue=interpolation8(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,i6,v7,suffix);\u0275\u0275styleMap(interpolatedValue)}function \u0275\u0275styleMapInterpolateV(values){const lView=getLView();const interpolatedValue=interpolationV(lView,values);\u0275\u0275styleMap(interpolatedValue)}function \u0275\u0275stylePropInterpolate1(prop,prefix,v0,suffix,valueSuffix){const lView=getLView();const interpolatedValue=
interpolation1(lView,prefix,v0,suffix);checkStylingProperty(prop,interpolatedValue,valueSuffix,false);return \u0275\u0275stylePropInterpolate1}function \u0275\u0275stylePropInterpolate2(prop,prefix,v0,i0,v1,suffix,valueSuffix){const lView=getLView();const interpolatedValue=interpolation2(lView,prefix,v0,i0,v1,suffix);checkStylingProperty(prop,interpolatedValue,valueSuffix,false);return \u0275\u0275stylePropInterpolate2}function \u0275\u0275stylePropInterpolate3(prop,prefix,v0,i0,v1,i1,v2,suffix,valueSuffix){const lView=
getLView();const interpolatedValue=interpolation3(lView,prefix,v0,i0,v1,i1,v2,suffix);checkStylingProperty(prop,interpolatedValue,valueSuffix,false);return \u0275\u0275stylePropInterpolate3}function \u0275\u0275stylePropInterpolate4(prop,prefix,v0,i0,v1,i1,v2,i2,v3,suffix,valueSuffix){const lView=getLView();const interpolatedValue=interpolation4(lView,prefix,v0,i0,v1,i1,v2,i2,v3,suffix);checkStylingProperty(prop,interpolatedValue,valueSuffix,false);return \u0275\u0275stylePropInterpolate4}function \u0275\u0275stylePropInterpolate5(prop,
prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,suffix,valueSuffix){const lView=getLView();const interpolatedValue=interpolation5(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,suffix);checkStylingProperty(prop,interpolatedValue,valueSuffix,false);return \u0275\u0275stylePropInterpolate5}function \u0275\u0275stylePropInterpolate6(prop,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,suffix,valueSuffix){const lView=getLView();const interpolatedValue=interpolation6(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,suffix);checkStylingProperty(prop,
interpolatedValue,valueSuffix,false);return \u0275\u0275stylePropInterpolate6}function \u0275\u0275stylePropInterpolate7(prop,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,suffix,valueSuffix){const lView=getLView();const interpolatedValue=interpolation7(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,suffix);checkStylingProperty(prop,interpolatedValue,valueSuffix,false);return \u0275\u0275stylePropInterpolate7}function \u0275\u0275stylePropInterpolate8(prop,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,
v5,i5,v6,i6,v7,suffix,valueSuffix){const lView=getLView();const interpolatedValue=interpolation8(lView,prefix,v0,i0,v1,i1,v2,i2,v3,i3,v4,i4,v5,i5,v6,i6,v7,suffix);checkStylingProperty(prop,interpolatedValue,valueSuffix,false);return \u0275\u0275stylePropInterpolate8}function \u0275\u0275stylePropInterpolateV(prop,values,valueSuffix){const lView=getLView();const interpolatedValue=interpolationV(lView,values);checkStylingProperty(prop,interpolatedValue,valueSuffix,false);return \u0275\u0275stylePropInterpolateV}
function \u0275\u0275hostProperty(propName,value,sanitizer){const lView=getLView();const bindingIndex=nextBindingIndex();if(bindingUpdated(lView,bindingIndex,value)){const tView=getTView();const tNode=getSelectedTNode();elementPropertyInternal(tView,tNode,lView,propName,value,lView[RENDERER],sanitizer,true);ngDevMode&&storePropertyBindingMetadata(tView.data,tNode,propName,bindingIndex)}return \u0275\u0275hostProperty}function \u0275\u0275syntheticHostProperty(propName,value,sanitizer){const lView=
getLView();const bindingIndex=nextBindingIndex();if(bindingUpdated(lView,bindingIndex,value)){const tView=getTView();const tNode=getSelectedTNode();const currentDef=getCurrentDirectiveDef(tView.data);const renderer=loadComponentRenderer(currentDef,tNode,lView);elementPropertyInternal(tView,tNode,lView,propName,value,renderer,sanitizer,true);ngDevMode&&storePropertyBindingMetadata(tView.data,tNode,propName,bindingIndex)}return \u0275\u0275syntheticHostProperty}if(typeof ngI18nClosureMode==="undefined")(function(){_global["ngI18nClosureMode"]=
typeof goog!=="undefined"&&typeof goog.getMsg==="function"})();const u=undefined;function plural(val){const i=Math.floor(Math.abs(val)),v=val.toString().replace(/^[^.]*\.?/,"").length;if(i===1&&v===0)return 1;return 5}var localeEn=["en",[["a","p"],["AM","PM"],u],[["AM","PM"],u,u],[["S","M","T","W","T","F","S"],["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],["Su","Mo","Tu","We","Th","Fr","Sa"]],u,[["J","F","M","A","M","J","J","A",
"S","O","N","D"],["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],["January","February","March","April","May","June","July","August","September","October","November","December"]],u,[["B","A"],["BC","AD"],["Before Christ","Anno Domini"]],0,[6,0],["M/d/yy","MMM d, y","MMMM d, y","EEEE, MMMM d, y"],["h:mm a","h:mm:ss a","h:mm:ss a z","h:mm:ss a zzzz"],["{1}, {0}",u,"{1} 'at' {0}",u],[".",",",";","%","+","-","E","×","‰","∞","NaN",":"],["#,##0.###","#,##0%","¤#,##0.00","#E0"],
"USD","$","US Dollar",{},"ltr",plural];let LOCALE_DATA={};function registerLocaleData(data,localeId,extraData){if(typeof localeId!=="string"){extraData=localeId;localeId=data[exports["ɵLocaleDataIndex"].LocaleId]}localeId=localeId.toLowerCase().replace(/_/g,"-");LOCALE_DATA[localeId]=data;if(extraData)LOCALE_DATA[localeId][exports["ɵLocaleDataIndex"].ExtraData]=extraData}function findLocaleData(locale){const normalizedLocale=normalizeLocale(locale);let match=getLocaleData(normalizedLocale);if(match)return match;
const parentLocale=normalizedLocale.split("-")[0];match=getLocaleData(parentLocale);if(match)return match;if(parentLocale==="en")return localeEn;throw new Error(`Missing locale data for the locale "${locale}".`);}function getLocaleCurrencyCode(locale){const data=findLocaleData(locale);return data[exports["ɵLocaleDataIndex"].CurrencyCode]||null}function getLocalePluralCase(locale){const data=findLocaleData(locale);return data[exports["ɵLocaleDataIndex"].PluralCase]}function getLocaleData(normalizedLocale){if(!(normalizedLocale in
LOCALE_DATA))LOCALE_DATA[normalizedLocale]=_global.ng&&_global.ng.common&&_global.ng.common.locales&&_global.ng.common.locales[normalizedLocale];return LOCALE_DATA[normalizedLocale]}function unregisterAllLocaleData(){LOCALE_DATA={}}exports["ɵLocaleDataIndex"]=void 0;(function(LocaleDataIndex){LocaleDataIndex[LocaleDataIndex["LocaleId"]=0]="LocaleId";LocaleDataIndex[LocaleDataIndex["DayPeriodsFormat"]=1]="DayPeriodsFormat";LocaleDataIndex[LocaleDataIndex["DayPeriodsStandalone"]=2]="DayPeriodsStandalone";
LocaleDataIndex[LocaleDataIndex["DaysFormat"]=3]="DaysFormat";LocaleDataIndex[LocaleDataIndex["DaysStandalone"]=4]="DaysStandalone";LocaleDataIndex[LocaleDataIndex["MonthsFormat"]=5]="MonthsFormat";LocaleDataIndex[LocaleDataIndex["MonthsStandalone"]=6]="MonthsStandalone";LocaleDataIndex[LocaleDataIndex["Eras"]=7]="Eras";LocaleDataIndex[LocaleDataIndex["FirstDayOfWeek"]=8]="FirstDayOfWeek";LocaleDataIndex[LocaleDataIndex["WeekendRange"]=9]="WeekendRange";LocaleDataIndex[LocaleDataIndex["DateFormat"]=
10]="DateFormat";LocaleDataIndex[LocaleDataIndex["TimeFormat"]=11]="TimeFormat";LocaleDataIndex[LocaleDataIndex["DateTimeFormat"]=12]="DateTimeFormat";LocaleDataIndex[LocaleDataIndex["NumberSymbols"]=13]="NumberSymbols";LocaleDataIndex[LocaleDataIndex["NumberFormats"]=14]="NumberFormats";LocaleDataIndex[LocaleDataIndex["CurrencyCode"]=15]="CurrencyCode";LocaleDataIndex[LocaleDataIndex["CurrencySymbol"]=16]="CurrencySymbol";LocaleDataIndex[LocaleDataIndex["CurrencyName"]=17]="CurrencyName";LocaleDataIndex[LocaleDataIndex["Currencies"]=
18]="Currencies";LocaleDataIndex[LocaleDataIndex["Directionality"]=19]="Directionality";LocaleDataIndex[LocaleDataIndex["PluralCase"]=20]="PluralCase";LocaleDataIndex[LocaleDataIndex["ExtraData"]=21]="ExtraData"})(exports["ɵLocaleDataIndex"]||(exports["ɵLocaleDataIndex"]={}));function normalizeLocale(locale){return locale.toLowerCase().replace(/_/g,"-")}const pluralMapping=["zero","one","two","few","many"];function getPluralCase(value,locale){const plural=getLocalePluralCase(locale)(parseInt(value,
10));const result=pluralMapping[plural];return result!==undefined?result:"other"}const DEFAULT_LOCALE_ID="en-US";const USD_CURRENCY_CODE="USD";const ELEMENT_MARKER={marker:"element"};const ICU_MARKER={marker:"ICU"};var I18nCreateOpCode;(function(I18nCreateOpCode){I18nCreateOpCode[I18nCreateOpCode["SHIFT"]=2]="SHIFT";I18nCreateOpCode[I18nCreateOpCode["APPEND_EAGERLY"]=1]="APPEND_EAGERLY";I18nCreateOpCode[I18nCreateOpCode["COMMENT"]=2]="COMMENT"})(I18nCreateOpCode||(I18nCreateOpCode={}));let LOCALE_ID$1=
DEFAULT_LOCALE_ID;function setLocaleId(localeId){assertDefined(localeId,`Expected localeId to be defined`);if(typeof localeId==="string")LOCALE_ID$1=localeId.toLowerCase().replace(/_/g,"-")}function getLocaleId(){return LOCALE_ID$1}function getInsertInFrontOfRNodeWithI18n(parentTNode,currentTNode,lView){const tNodeInsertBeforeIndex=currentTNode.insertBeforeIndex;const insertBeforeIndex=Array.isArray(tNodeInsertBeforeIndex)?tNodeInsertBeforeIndex[0]:tNodeInsertBeforeIndex;if(insertBeforeIndex===null)return getInsertInFrontOfRNodeWithNoI18n(parentTNode,
currentTNode,lView);else{ngDevMode&&assertIndexInRange(lView,insertBeforeIndex);return unwrapRNode(lView[insertBeforeIndex])}}function processI18nInsertBefore(renderer,childTNode,lView,childRNode,parentRElement){const tNodeInsertBeforeIndex=childTNode.insertBeforeIndex;if(Array.isArray(tNodeInsertBeforeIndex)){ngDevMode&&assertDomNode(childRNode);let i18nParent=childRNode;let anchorRNode=null;if(!(childTNode.type&3)){anchorRNode=i18nParent;i18nParent=parentRElement}if(i18nParent!==null&&(childTNode.flags&
2)===0)for(let i=1;i<tNodeInsertBeforeIndex.length;i++){const i18nChild=lView[tNodeInsertBeforeIndex[i]];nativeInsertBefore(renderer,i18nParent,i18nChild,anchorRNode,false)}}}function addTNodeAndUpdateInsertBeforeIndex(previousTNodes,newTNode){ngDevMode&&assertEqual(newTNode.insertBeforeIndex,null,"We expect that insertBeforeIndex is not set");previousTNodes.push(newTNode);if(previousTNodes.length>1)for(let i=previousTNodes.length-2;i>=0;i--){const existingTNode=previousTNodes[i];if(!isI18nText(existingTNode))if(isNewTNodeCreatedBefore(existingTNode,
newTNode)&&getInsertBeforeIndex(existingTNode)===null)setInsertBeforeIndex(existingTNode,newTNode.index)}}function isI18nText(tNode){return!(tNode.type&64)}function isNewTNodeCreatedBefore(existingTNode,newTNode){return isI18nText(newTNode)||existingTNode.index>newTNode.index}function getInsertBeforeIndex(tNode){const index=tNode.insertBeforeIndex;return Array.isArray(index)?index[0]:index}function setInsertBeforeIndex(tNode,value){const index=tNode.insertBeforeIndex;if(Array.isArray(index))index[0]=
value;else{setI18nHandling(getInsertInFrontOfRNodeWithI18n,processI18nInsertBefore);tNode.insertBeforeIndex=value}}function getTIcu(tView,index){const value=tView.data[index];if(value===null||typeof value==="string")return null;if(ngDevMode&&!(value.hasOwnProperty("tViews")||value.hasOwnProperty("currentCaseLViewIndex")))throwError("We expect to get 'null'|'TIcu'|'TIcuContainer', but got: "+value);const tIcu=value.hasOwnProperty("currentCaseLViewIndex")?value:value.value;ngDevMode&&assertTIcu(tIcu);
return tIcu}function setTIcu(tView,index,tIcu){const tNode=tView.data[index];ngDevMode&&assertEqual(tNode===null||tNode.hasOwnProperty("tViews"),true,"We expect to get 'null'|'TIcuContainer'");if(tNode===null)tView.data[index]=tIcu;else{ngDevMode&&assertTNodeType(tNode,32);tNode.value=tIcu}}function setTNodeInsertBeforeIndex(tNode,index){ngDevMode&&assertTNode(tNode);let insertBeforeIndex=tNode.insertBeforeIndex;if(insertBeforeIndex===null){setI18nHandling(getInsertInFrontOfRNodeWithI18n,processI18nInsertBefore);
insertBeforeIndex=tNode.insertBeforeIndex=[null,index]}else{assertEqual(Array.isArray(insertBeforeIndex),true,"Expecting array here");insertBeforeIndex.push(index)}}function createTNodePlaceholder(tView,previousTNodes,index){const tNode=createTNodeAtIndex(tView,index,64,null,null);addTNodeAndUpdateInsertBeforeIndex(previousTNodes,tNode);return tNode}function getCurrentICUCaseIndex(tIcu,lView){const currentCase=lView[tIcu.currentCaseLViewIndex];return currentCase===null?currentCase:currentCase<0?~currentCase:
currentCase}function getParentFromIcuCreateOpCode(mergedCode){return mergedCode>>>17}function getRefFromIcuCreateOpCode(mergedCode){return(mergedCode&131070)>>>1}function getInstructionFromIcuCreateOpCode(mergedCode){return mergedCode&1}function icuCreateOpCode(opCode,parentIdx,refIdx){ngDevMode&&assertGreaterThanOrEqual(parentIdx,0,"Missing parent index");ngDevMode&&assertGreaterThan(refIdx,0,"Missing ref index");return opCode|parentIdx<<17|refIdx<<1}let changeMask=0;let changeMaskCounter=0;function setMaskBit(hasChange){if(hasChange)changeMask=
changeMask|1<<Math.min(changeMaskCounter,31);changeMaskCounter++}function applyI18n(tView,lView,index){if(changeMaskCounter>0){ngDevMode&&assertDefined(tView,`tView should be defined`);const tI18n=tView.data[index];const updateOpCodes=Array.isArray(tI18n)?tI18n:tI18n.update;const bindingsStartIndex=getBindingIndex()-changeMaskCounter-1;applyUpdateOpCodes(tView,lView,updateOpCodes,bindingsStartIndex,changeMask)}changeMask=0;changeMaskCounter=0}function applyCreateOpCodes(lView,createOpCodes,parentRNode,
insertInFrontOf){const renderer=lView[RENDERER];for(let i=0;i<createOpCodes.length;i++){const opCode=createOpCodes[i++];const text=createOpCodes[i];const isComment=(opCode&I18nCreateOpCode.COMMENT)===I18nCreateOpCode.COMMENT;const appendNow=(opCode&I18nCreateOpCode.APPEND_EAGERLY)===I18nCreateOpCode.APPEND_EAGERLY;const index=opCode>>>I18nCreateOpCode.SHIFT;let rNode=lView[index];if(rNode===null)rNode=lView[index]=isComment?renderer.createComment(text):createTextNode(renderer,text);if(appendNow&&
parentRNode!==null)nativeInsertBefore(renderer,parentRNode,rNode,insertInFrontOf,false)}}function applyMutableOpCodes(tView,mutableOpCodes,lView,anchorRNode){ngDevMode&&assertDomNode(anchorRNode);const renderer=lView[RENDERER];let rootIdx=null;let rootRNode;for(let i=0;i<mutableOpCodes.length;i++){const opCode=mutableOpCodes[i];if(typeof opCode=="string"){const textNodeIndex=mutableOpCodes[++i];if(lView[textNodeIndex]===null){ngDevMode&&ngDevMode.rendererCreateTextNode++;ngDevMode&&assertIndexInRange(lView,
textNodeIndex);lView[textNodeIndex]=createTextNode(renderer,opCode)}}else if(typeof opCode=="number")switch(opCode&1){case 0:const parentIdx=getParentFromIcuCreateOpCode(opCode);if(rootIdx===null){rootIdx=parentIdx;rootRNode=nativeParentNode(renderer,anchorRNode)}let insertInFrontOf;let parentRNode;if(parentIdx===rootIdx){insertInFrontOf=anchorRNode;parentRNode=rootRNode}else{insertInFrontOf=null;parentRNode=unwrapRNode(lView[parentIdx])}if(parentRNode!==null){ngDevMode&&assertDomNode(parentRNode);
const refIdx=getRefFromIcuCreateOpCode(opCode);ngDevMode&&assertGreaterThan(refIdx,HEADER_OFFSET,"Missing ref");const child=lView[refIdx];ngDevMode&&assertDomNode(child);nativeInsertBefore(renderer,parentRNode,child,insertInFrontOf,false);const tIcu=getTIcu(tView,refIdx);if(tIcu!==null&&typeof tIcu==="object"){ngDevMode&&assertTIcu(tIcu);const caseIndex=getCurrentICUCaseIndex(tIcu,lView);if(caseIndex!==null)applyMutableOpCodes(tView,tIcu.create[caseIndex],lView,lView[tIcu.anchorIdx])}}break;case 1:const elementNodeIndex=
opCode>>>1;const attrName=mutableOpCodes[++i];const attrValue=mutableOpCodes[++i];setElementAttribute(renderer,getNativeByIndex(elementNodeIndex,lView),null,null,attrName,attrValue,null);break;default:if(ngDevMode)throw new RuntimeError(700,`Unable to determine the type of mutate operation for "${opCode}"`);}else switch(opCode){case ICU_MARKER:const commentValue=mutableOpCodes[++i];const commentNodeIndex=mutableOpCodes[++i];if(lView[commentNodeIndex]===null){ngDevMode&&assertEqual(typeof commentValue,
"string",`Expected "${commentValue}" to be a comment node value`);ngDevMode&&ngDevMode.rendererCreateComment++;ngDevMode&&assertIndexInExpandoRange(lView,commentNodeIndex);const commentRNode=lView[commentNodeIndex]=createCommentNode(renderer,commentValue);attachPatchData(commentRNode,lView)}break;case ELEMENT_MARKER:const tagName=mutableOpCodes[++i];const elementNodeIndex=mutableOpCodes[++i];if(lView[elementNodeIndex]===null){ngDevMode&&assertEqual(typeof tagName,"string",`Expected "${tagName}" to be an element node tag name`);
ngDevMode&&ngDevMode.rendererCreateElement++;ngDevMode&&assertIndexInExpandoRange(lView,elementNodeIndex);const elementRNode=lView[elementNodeIndex]=createElementNode(renderer,tagName,null);attachPatchData(elementRNode,lView)}break;default:ngDevMode&&throwError(`Unable to determine the type of mutate operation for "${opCode}"`)}}}function applyUpdateOpCodes(tView,lView,updateOpCodes,bindingsStartIndex,changeMask){for(let i=0;i<updateOpCodes.length;i++){const checkBit=updateOpCodes[i];const skipCodes=
updateOpCodes[++i];if(checkBit&changeMask){let value="";for(let j=i+1;j<=i+skipCodes;j++){const opCode=updateOpCodes[j];if(typeof opCode=="string")value+=opCode;else if(typeof opCode=="number")if(opCode<0)value+=renderStringify(lView[bindingsStartIndex-opCode]);else{const nodeIndex=opCode>>>2;switch(opCode&3){case 1:const propName=updateOpCodes[++j];const sanitizeFn=updateOpCodes[++j];const tNodeOrTagName=tView.data[nodeIndex];ngDevMode&&assertDefined(tNodeOrTagName,"Experting TNode or string");if(typeof tNodeOrTagName===
"string")setElementAttribute(lView[RENDERER],lView[nodeIndex],null,tNodeOrTagName,propName,value,sanitizeFn);else elementPropertyInternal(tView,tNodeOrTagName,lView,propName,value,lView[RENDERER],sanitizeFn,false);break;case 0:const rText=lView[nodeIndex];rText!==null&&updateTextNode(lView[RENDERER],rText,value);break;case 2:applyIcuSwitchCase(tView,getTIcu(tView,nodeIndex),lView,value);break;case 3:applyIcuUpdateCase(tView,getTIcu(tView,nodeIndex),bindingsStartIndex,lView);break}}}}else{const opCode=
updateOpCodes[i+1];if(opCode>0&&(opCode&3)===3){const nodeIndex=opCode>>>2;const tIcu=getTIcu(tView,nodeIndex);const currentIndex=lView[tIcu.currentCaseLViewIndex];if(currentIndex<0)applyIcuUpdateCase(tView,tIcu,bindingsStartIndex,lView)}}i+=skipCodes}}function applyIcuUpdateCase(tView,tIcu,bindingsStartIndex,lView){ngDevMode&&assertIndexInRange(lView,tIcu.currentCaseLViewIndex);let activeCaseIndex=lView[tIcu.currentCaseLViewIndex];if(activeCaseIndex!==null){let mask=changeMask;if(activeCaseIndex<
0){activeCaseIndex=lView[tIcu.currentCaseLViewIndex]=~activeCaseIndex;mask=-1}applyUpdateOpCodes(tView,lView,tIcu.update[activeCaseIndex],bindingsStartIndex,mask)}}function applyIcuSwitchCase(tView,tIcu,lView,value){const caseIndex=getCaseIndex(tIcu,value);let activeCaseIndex=getCurrentICUCaseIndex(tIcu,lView);if(activeCaseIndex!==caseIndex){applyIcuSwitchCaseRemove(tView,tIcu,lView);lView[tIcu.currentCaseLViewIndex]=caseIndex===null?null:~caseIndex;if(caseIndex!==null){const anchorRNode=lView[tIcu.anchorIdx];
if(anchorRNode){ngDevMode&&assertDomNode(anchorRNode);applyMutableOpCodes(tView,tIcu.create[caseIndex],lView,anchorRNode)}}}}function applyIcuSwitchCaseRemove(tView,tIcu,lView){let activeCaseIndex=getCurrentICUCaseIndex(tIcu,lView);if(activeCaseIndex!==null){const removeCodes=tIcu.remove[activeCaseIndex];for(let i=0;i<removeCodes.length;i++){const nodeOrIcuIndex=removeCodes[i];if(nodeOrIcuIndex>0){const rNode=getNativeByIndex(nodeOrIcuIndex,lView);rNode!==null&&nativeRemoveNode(lView[RENDERER],rNode)}else applyIcuSwitchCaseRemove(tView,
getTIcu(tView,~nodeOrIcuIndex),lView)}}}function getCaseIndex(icuExpression,bindingValue){let index=icuExpression.cases.indexOf(bindingValue);if(index===-1)switch(icuExpression.type){case 1:{const resolvedCase=getPluralCase(bindingValue,getLocaleId());index=icuExpression.cases.indexOf(resolvedCase);if(index===-1&&resolvedCase!=="other")index=icuExpression.cases.indexOf("other");break}case 0:{index=icuExpression.cases.indexOf("other");break}}return index===-1?null:index}function loadIcuContainerVisitor(){const _stack=
[];let _index=-1;let _lView;let _removes;function icuContainerIteratorStart(tIcuContainerNode,lView){_lView=lView;while(_stack.length)_stack.pop();ngDevMode&&assertTNodeForLView(tIcuContainerNode,lView);enterIcu(tIcuContainerNode.value,lView);return icuContainerIteratorNext}function enterIcu(tIcu,lView){_index=0;const currentCase=getCurrentICUCaseIndex(tIcu,lView);if(currentCase!==null){ngDevMode&&assertNumberInRange(currentCase,0,tIcu.cases.length-1);_removes=tIcu.remove[currentCase]}else _removes=
EMPTY_ARRAY}function icuContainerIteratorNext(){if(_index<_removes.length){const removeOpCode=_removes[_index++];ngDevMode&&assertNumber(removeOpCode,"Expecting OpCode number");if(removeOpCode>0){const rNode=_lView[removeOpCode];ngDevMode&&assertDomNode(rNode);return rNode}else{_stack.push(_index,_removes);const tIcuIndex=~removeOpCode;const tIcu=_lView[TVIEW].data[tIcuIndex];ngDevMode&&assertTIcu(tIcu);enterIcu(tIcu,_lView);return icuContainerIteratorNext()}}else if(_stack.length===0)return null;
else{_removes=_stack.pop();_index=_stack.pop();return icuContainerIteratorNext()}}return icuContainerIteratorStart}function i18nCreateOpCodesToString(opcodes){const createOpCodes=opcodes||(Array.isArray(this)?this:[]);let lines=[];for(let i=0;i<createOpCodes.length;i++){const opCode=createOpCodes[i++];const text=createOpCodes[i];const isComment=(opCode&I18nCreateOpCode.COMMENT)===I18nCreateOpCode.COMMENT;const appendNow=(opCode&I18nCreateOpCode.APPEND_EAGERLY)===I18nCreateOpCode.APPEND_EAGERLY;const index=
opCode>>>I18nCreateOpCode.SHIFT;lines.push(`lView[${index}] = document.${isComment?"createComment":"createText"}(${JSON.stringify(text)});`);if(appendNow)lines.push(`parent.appendChild(lView[${index}]);`)}return lines}function i18nUpdateOpCodesToString(opcodes){const parser=new OpCodeParser(opcodes||(Array.isArray(this)?this:[]));let lines=[];function consumeOpCode(value){const ref=value>>>2;const opCode=value&3;switch(opCode){case 0:return`(lView[${ref}] as Text).textContent = $$$`;case 1:const attrName=
parser.consumeString();const sanitizationFn=parser.consumeFunction();const value=sanitizationFn?`(${sanitizationFn})($$$)`:"$$$";return`(lView[${ref}] as Element).setAttribute('${attrName}', ${value})`;case 2:return`icuSwitchCase(${ref}, $$$)`;case 3:return`icuUpdateCase(${ref})`}throw new Error("unexpected OpCode");}while(parser.hasMore()){let mask=parser.consumeNumber();let size=parser.consumeNumber();const end=parser.i+size;const statements=[];let statement="";while(parser.i<end){let value=parser.consumeNumberOrString();
if(typeof value==="string")statement+=value;else if(value<0)statement+="${lView[i"+value+"]}";else{const opCodeText=consumeOpCode(value);statements.push(opCodeText.replace("$$$","`"+statement+"`")+";");statement=""}}lines.push(`if (mask & 0b${mask.toString(2)}) { ${statements.join(" ")} }`)}return lines}function icuCreateOpCodesToString(opcodes){const parser=new OpCodeParser(opcodes||(Array.isArray(this)?this:[]));let lines=[];function consumeOpCode(opCode){const parent=getParentFromIcuCreateOpCode(opCode);
const ref=getRefFromIcuCreateOpCode(opCode);switch(getInstructionFromIcuCreateOpCode(opCode)){case 0:return`(lView[${parent}] as Element).appendChild(lView[${lastRef}])`;case 1:return`(lView[${ref}] as Element).setAttribute("${parser.consumeString()}", "${parser.consumeString()}")`}throw new Error("Unexpected OpCode: "+getInstructionFromIcuCreateOpCode(opCode));}let lastRef=-1;while(parser.hasMore()){let value=parser.consumeNumberStringOrMarker();if(value===ICU_MARKER){const text=parser.consumeString();
lastRef=parser.consumeNumber();lines.push(`lView[${lastRef}] = document.createComment("${text}")`)}else if(value===ELEMENT_MARKER){const text=parser.consumeString();lastRef=parser.consumeNumber();lines.push(`lView[${lastRef}] = document.createElement("${text}")`)}else if(typeof value==="string"){lastRef=parser.consumeNumber();lines.push(`lView[${lastRef}] = document.createTextNode("${value}")`)}else if(typeof value==="number"){const line=consumeOpCode(value);line&&lines.push(line)}else throw new Error("Unexpected value");
}return lines}function i18nRemoveOpCodesToString(opcodes){const removeCodes=opcodes||(Array.isArray(this)?this:[]);let lines=[];for(let i=0;i<removeCodes.length;i++){const nodeOrIcuIndex=removeCodes[i];if(nodeOrIcuIndex>0)lines.push(`remove(lView[${nodeOrIcuIndex}])`);else lines.push(`removeNestedICU(${~nodeOrIcuIndex})`)}return lines}class OpCodeParser{constructor(codes){this.i=0;this.codes=codes}hasMore(){return this.i<this.codes.length}consumeNumber(){let value=this.codes[this.i++];assertNumber(value,
"expecting number in OpCode");return value}consumeString(){let value=this.codes[this.i++];assertString(value,"expecting string in OpCode");return value}consumeFunction(){let value=this.codes[this.i++];if(value===null||typeof value==="function")return value;throw new Error("expecting function in OpCode");}consumeNumberOrString(){let value=this.codes[this.i++];if(typeof value==="string")return value;assertNumber(value,"expecting number or string in OpCode");return value}consumeNumberStringOrMarker(){let value=
this.codes[this.i++];if(typeof value==="string"||typeof value==="number"||value==ICU_MARKER||value==ELEMENT_MARKER)return value;assertNumber(value,"expecting number, string, ICU_MARKER or ELEMENT_MARKER in OpCode");return value}}const BINDING_REGEXP=/�(\d+):?\d*�/gi;const ICU_REGEXP=/({\s*�\d+:?\d*�\s*,\s*\S{6}\s*,[\s\S]*})/gi;const NESTED_ICU=/�(\d+)�/;const ICU_BLOCK_REGEXP=/^\s*(�\d+:?\d*�)\s*,\s*(select|plural)\s*,/;const MARKER=`�`;const SUBTEMPLATE_REGEXP=/�\/?\*(\d+:\d+)�/gi;const PH_REGEXP=
/�(\/?[#*]\d+):?\d*�/gi;const NGSP_UNICODE_REGEXP=/\uE500/g;function replaceNgsp(value){return value.replace(NGSP_UNICODE_REGEXP," ")}function i18nStartFirstCreatePass(tView,parentTNodeIndex,lView,index,message,subTemplateIndex){const rootTNode=getCurrentParentTNode();const createOpCodes=[];const updateOpCodes=[];const existingTNodeStack=[[]];if(ngDevMode){attachDebugGetter(createOpCodes,i18nCreateOpCodesToString);attachDebugGetter(updateOpCodes,i18nUpdateOpCodesToString)}message=getTranslationForTemplate(message,
subTemplateIndex);const msgParts=replaceNgsp(message).split(PH_REGEXP);for(let i=0;i<msgParts.length;i++){let value=msgParts[i];if((i&1)===0){const parts=i18nParseTextIntoPartsAndICU(value);for(let j=0;j<parts.length;j++){let part=parts[j];if((j&1)===0){const text=part;ngDevMode&&assertString(text,"Parsed ICU part should be string");if(text!=="")i18nStartFirstCreatePassProcessTextNode(tView,rootTNode,existingTNodeStack[0],createOpCodes,updateOpCodes,lView,text)}else{const icuExpression=part;if(typeof icuExpression!==
"object")throw new Error(`Unable to parse ICU expression in "${message}" message.`);const icuContainerTNode=createTNodeAndAddOpCode(tView,rootTNode,existingTNodeStack[0],lView,createOpCodes,ngDevMode?`ICU ${index}:${icuExpression.mainBinding}`:"",true);const icuNodeIndex=icuContainerTNode.index;ngDevMode&&assertGreaterThanOrEqual(icuNodeIndex,HEADER_OFFSET,"Index must be in absolute LView offset");icuStart(tView,lView,updateOpCodes,parentTNodeIndex,icuExpression,icuNodeIndex)}}}else{const isClosing=
value.charCodeAt(0)===47;const type=value.charCodeAt(isClosing?1:0);ngDevMode&&assertOneOf(type,42,35);const index=HEADER_OFFSET+Number.parseInt(value.substring(isClosing?2:1));if(isClosing){existingTNodeStack.shift();setCurrentTNode(getCurrentParentTNode(),false)}else{const tNode=createTNodePlaceholder(tView,existingTNodeStack[0],index);existingTNodeStack.unshift([]);setCurrentTNode(tNode,true)}}}tView.data[index]={create:createOpCodes,update:updateOpCodes}}function createTNodeAndAddOpCode(tView,
rootTNode,existingTNodes,lView,createOpCodes,text,isICU){const i18nNodeIdx=allocExpando(tView,lView,1,null);let opCode=i18nNodeIdx<<I18nCreateOpCode.SHIFT;let parentTNode=getCurrentParentTNode();if(rootTNode===parentTNode)parentTNode=null;if(parentTNode===null)opCode|=I18nCreateOpCode.APPEND_EAGERLY;if(isICU){opCode|=I18nCreateOpCode.COMMENT;ensureIcuContainerVisitorLoaded(loadIcuContainerVisitor)}createOpCodes.push(opCode,text===null?"":text);const tNode=createTNodeAtIndex(tView,i18nNodeIdx,isICU?
32:1,text===null?ngDevMode?"{{?}}":"":text,null);addTNodeAndUpdateInsertBeforeIndex(existingTNodes,tNode);const tNodeIdx=tNode.index;setCurrentTNode(tNode,false);if(parentTNode!==null&&rootTNode!==parentTNode)setTNodeInsertBeforeIndex(parentTNode,tNodeIdx);return tNode}function i18nStartFirstCreatePassProcessTextNode(tView,rootTNode,existingTNodes,createOpCodes,updateOpCodes,lView,text){const hasBinding=text.match(BINDING_REGEXP);const tNode=createTNodeAndAddOpCode(tView,rootTNode,existingTNodes,
lView,createOpCodes,hasBinding?null:text,false);if(hasBinding)generateBindingUpdateOpCodes(updateOpCodes,text,tNode.index,null,0,null)}function i18nAttributesFirstPass(tView,index,values){const previousElement=getCurrentTNode();const previousElementIndex=previousElement.index;const updateOpCodes=[];if(ngDevMode)attachDebugGetter(updateOpCodes,i18nUpdateOpCodesToString);if(tView.firstCreatePass&&tView.data[index]===null){for(let i=0;i<values.length;i+=2){const attrName=values[i];const message=values[i+
1];if(message!==""){if(ICU_REGEXP.test(message))throw new Error(`ICU expressions are not supported in attributes. Message: "${message}".`);generateBindingUpdateOpCodes(updateOpCodes,message,previousElementIndex,attrName,countBindings(updateOpCodes),null)}}tView.data[index]=updateOpCodes}}function generateBindingUpdateOpCodes(updateOpCodes,str,destinationNode,attrName,bindingStart,sanitizeFn){ngDevMode&&assertGreaterThanOrEqual(destinationNode,HEADER_OFFSET,"Index must be in absolute LView offset");
const maskIndex=updateOpCodes.length;const sizeIndex=maskIndex+1;updateOpCodes.push(null,null);const startIndex=maskIndex+2;if(ngDevMode)attachDebugGetter(updateOpCodes,i18nUpdateOpCodesToString);const textParts=str.split(BINDING_REGEXP);let mask=0;for(let j=0;j<textParts.length;j++){const textValue=textParts[j];if(j&1){const bindingIndex=bindingStart+parseInt(textValue,10);updateOpCodes.push(-1-bindingIndex);mask=mask|toMaskBit(bindingIndex)}else if(textValue!=="")updateOpCodes.push(textValue)}updateOpCodes.push(destinationNode<<
2|(attrName?1:0));if(attrName)updateOpCodes.push(attrName,sanitizeFn);updateOpCodes[maskIndex]=mask;updateOpCodes[sizeIndex]=updateOpCodes.length-startIndex;return mask}function countBindings(opCodes){let count=0;for(let i=0;i<opCodes.length;i++){const opCode=opCodes[i];if(typeof opCode==="number"&&opCode<0)count++}return count}function toMaskBit(bindingIndex){return 1<<Math.min(bindingIndex,31)}function isRootTemplateMessage(subTemplateIndex){return subTemplateIndex===-1}function removeInnerTemplateTranslation(message){let match;
let res="";let index=0;let inTemplate=false;let tagMatched;while((match=SUBTEMPLATE_REGEXP.exec(message))!==null)if(!inTemplate){res+=message.substring(index,match.index+match[0].length);tagMatched=match[1];inTemplate=true}else if(match[0]===`${MARKER}/*${tagMatched}${MARKER}`){index=match.index;inTemplate=false}ngDevMode&&assertEqual(inTemplate,false,`Tag mismatch: unable to find the end of the sub-template in the translation "${message}"`);res+=message.substr(index);return res}function getTranslationForTemplate(message,
subTemplateIndex){if(isRootTemplateMessage(subTemplateIndex))return removeInnerTemplateTranslation(message);else{const start=message.indexOf(`:${subTemplateIndex}${MARKER}`)+2+subTemplateIndex.toString().length;const end=message.search(new RegExp(`${MARKER}\\/\\*\\d+:${subTemplateIndex}${MARKER}`));return removeInnerTemplateTranslation(message.substring(start,end))}}function icuStart(tView,lView,updateOpCodes,parentIdx,icuExpression,anchorIdx){ngDevMode&&assertDefined(icuExpression,"ICU expression must be defined");
let bindingMask=0;const tIcu={type:icuExpression.type,currentCaseLViewIndex:allocExpando(tView,lView,1,null),anchorIdx,cases:[],create:[],remove:[],update:[]};addUpdateIcuSwitch(updateOpCodes,icuExpression,anchorIdx);setTIcu(tView,anchorIdx,tIcu);const values=icuExpression.values;for(let i=0;i<values.length;i++){const valueArr=values[i];const nestedIcus=[];for(let j=0;j<valueArr.length;j++){const value=valueArr[j];if(typeof value!=="string"){const icuIndex=nestedIcus.push(value)-1;valueArr[j]=`<!--�${icuIndex}�-->`}}bindingMask=
parseIcuCase(tView,tIcu,lView,updateOpCodes,parentIdx,icuExpression.cases[i],valueArr.join(""),nestedIcus)|bindingMask}if(bindingMask)addUpdateIcuUpdate(updateOpCodes,bindingMask,anchorIdx)}function parseICUBlock(pattern){const cases=[];const values=[];let icuType=1;let mainBinding=0;pattern=pattern.replace(ICU_BLOCK_REGEXP,function(str,binding,type){if(type==="select")icuType=0;else icuType=1;mainBinding=parseInt(binding.substr(1),10);return""});const parts=i18nParseTextIntoPartsAndICU(pattern);
for(let pos=0;pos<parts.length;){let key=parts[pos++].trim();if(icuType===1)key=key.replace(/\s*(?:=)?(\w+)\s*/,"$1");if(key.length)cases.push(key);const blocks=i18nParseTextIntoPartsAndICU(parts[pos++]);if(cases.length>values.length)values.push(blocks)}return{type:icuType,mainBinding:mainBinding,cases,values}}function i18nParseTextIntoPartsAndICU(pattern){if(!pattern)return[];let prevPos=0;const braceStack=[];const results=[];const braces=/[{}]/g;braces.lastIndex=0;let match;while(match=braces.exec(pattern)){const pos=
match.index;if(match[0]=="}"){braceStack.pop();if(braceStack.length==0){const block=pattern.substring(prevPos,pos);if(ICU_BLOCK_REGEXP.test(block))results.push(parseICUBlock(block));else results.push(block);prevPos=pos+1}}else{if(braceStack.length==0){const substring=pattern.substring(prevPos,pos);results.push(substring);prevPos=pos+1}braceStack.push("{")}}const substring=pattern.substring(prevPos);results.push(substring);return results}function parseIcuCase(tView,tIcu,lView,updateOpCodes,parentIdx,
caseName,unsafeCaseHtml,nestedIcus){const create=[];const remove=[];const update=[];if(ngDevMode){attachDebugGetter(create,icuCreateOpCodesToString);attachDebugGetter(remove,i18nRemoveOpCodesToString);attachDebugGetter(update,i18nUpdateOpCodesToString)}tIcu.cases.push(caseName);tIcu.create.push(create);tIcu.remove.push(remove);tIcu.update.push(update);const inertBodyHelper=getInertBodyHelper(getDocument());const inertBodyElement=inertBodyHelper.getInertBodyElement(unsafeCaseHtml);ngDevMode&&assertDefined(inertBodyElement,
"Unable to generate inert body element");const inertRootNode=getTemplateContent(inertBodyElement)||inertBodyElement;if(inertRootNode)return walkIcuTree(tView,tIcu,lView,updateOpCodes,create,remove,update,inertRootNode,parentIdx,nestedIcus,0);else return 0}function walkIcuTree(tView,tIcu,lView,sharedUpdateOpCodes,create,remove,update,parentNode,parentIdx,nestedIcus,depth){let bindingMask=0;let currentNode=parentNode.firstChild;while(currentNode){const newIndex=allocExpando(tView,lView,1,null);switch(currentNode.nodeType){case Node.ELEMENT_NODE:const element=
currentNode;const tagName=element.tagName.toLowerCase();if(VALID_ELEMENTS.hasOwnProperty(tagName)){addCreateNodeAndAppend(create,ELEMENT_MARKER,tagName,parentIdx,newIndex);tView.data[newIndex]=tagName;const elAttrs=element.attributes;for(let i=0;i<elAttrs.length;i++){const attr=elAttrs.item(i);const lowerAttrName=attr.name.toLowerCase();const hasBinding=!!attr.value.match(BINDING_REGEXP);if(hasBinding)if(VALID_ATTRS.hasOwnProperty(lowerAttrName))if(URI_ATTRS[lowerAttrName])generateBindingUpdateOpCodes(update,
attr.value,newIndex,attr.name,0,_sanitizeUrl);else if(SRCSET_ATTRS[lowerAttrName])generateBindingUpdateOpCodes(update,attr.value,newIndex,attr.name,0,sanitizeSrcset);else generateBindingUpdateOpCodes(update,attr.value,newIndex,attr.name,0,null);else ngDevMode&&console.warn(`WARNING: ignoring unsafe attribute value `+`${lowerAttrName} on element ${tagName} `+`(see https://g.co/ng/security#xss)`);else addCreateAttribute(create,newIndex,attr)}bindingMask=walkIcuTree(tView,tIcu,lView,sharedUpdateOpCodes,
create,remove,update,currentNode,newIndex,nestedIcus,depth+1)|bindingMask;addRemoveNode(remove,newIndex,depth)}break;case Node.TEXT_NODE:const value=currentNode.textContent||"";const hasBinding=value.match(BINDING_REGEXP);addCreateNodeAndAppend(create,null,hasBinding?"":value,parentIdx,newIndex);addRemoveNode(remove,newIndex,depth);if(hasBinding)bindingMask=generateBindingUpdateOpCodes(update,value,newIndex,null,0,null)|bindingMask;break;case Node.COMMENT_NODE:const isNestedIcu=NESTED_ICU.exec(currentNode.textContent||
"");if(isNestedIcu){const nestedIcuIndex=parseInt(isNestedIcu[1],10);const icuExpression=nestedIcus[nestedIcuIndex];addCreateNodeAndAppend(create,ICU_MARKER,ngDevMode?`nested ICU ${nestedIcuIndex}`:"",parentIdx,newIndex);icuStart(tView,lView,sharedUpdateOpCodes,parentIdx,icuExpression,newIndex);addRemoveNestedIcu(remove,newIndex,depth)}break}currentNode=currentNode.nextSibling}return bindingMask}function addRemoveNode(remove,index,depth){if(depth===0)remove.push(index)}function addRemoveNestedIcu(remove,
index,depth){if(depth===0){remove.push(~index);remove.push(index)}}function addUpdateIcuSwitch(update,icuExpression,index){update.push(toMaskBit(icuExpression.mainBinding),2,-1-icuExpression.mainBinding,index<<2|2)}function addUpdateIcuUpdate(update,bindingMask,index){update.push(bindingMask,1,index<<2|3)}function addCreateNodeAndAppend(create,marker,text,appendToParentIdx,createAtIdx){if(marker!==null)create.push(marker);create.push(text,createAtIdx,icuCreateOpCode(0,appendToParentIdx,createAtIdx))}
function addCreateAttribute(create,newIndex,attr){create.push(newIndex<<1|1,attr.name,attr.value)}const ROOT_TEMPLATE_ID=0;const PP_MULTI_VALUE_PLACEHOLDERS_REGEXP=/\[(�.+?�?)\]/;const PP_PLACEHOLDERS_REGEXP=/\[(�.+?�?)\]|(�\/?\*\d+:\d+�)/g;const PP_ICU_VARS_REGEXP=/({\s*)(VAR_(PLURAL|SELECT)(_\d+)?)(\s*,)/g;const PP_ICU_PLACEHOLDERS_REGEXP=/{([A-Z0-9_]+)}/g;const PP_ICUS_REGEXP=/�I18N_EXP_(ICU(_\d+)?)�/g;const PP_CLOSE_TEMPLATE_REGEXP=/\/\*/;const PP_TEMPLATE_ID_REGEXP=/\d+:(\d+)/;function i18nPostprocess(message,
replacements={}){let result=message;if(PP_MULTI_VALUE_PLACEHOLDERS_REGEXP.test(message)){const matches={};const templateIdsStack=[ROOT_TEMPLATE_ID];result=result.replace(PP_PLACEHOLDERS_REGEXP,(m,phs,tmpl)=>{const content=phs||tmpl;const placeholders=matches[content]||[];if(!placeholders.length){content.split("|").forEach(placeholder=>{const match=placeholder.match(PP_TEMPLATE_ID_REGEXP);const templateId=match?parseInt(match[1],10):ROOT_TEMPLATE_ID;const isCloseTemplateTag=PP_CLOSE_TEMPLATE_REGEXP.test(placeholder);
placeholders.push([templateId,isCloseTemplateTag,placeholder])});matches[content]=placeholders}if(!placeholders.length)throw new Error(`i18n postprocess: unmatched placeholder - ${content}`);const currentTemplateId=templateIdsStack[templateIdsStack.length-1];let idx=0;for(let i=0;i<placeholders.length;i++)if(placeholders[i][0]===currentTemplateId){idx=i;break}const [templateId,isCloseTemplateTag,placeholder]=placeholders[idx];if(isCloseTemplateTag)templateIdsStack.pop();else if(currentTemplateId!==
templateId)templateIdsStack.push(templateId);placeholders.splice(idx,1);return placeholder})}if(!Object.keys(replacements).length)return result;result=result.replace(PP_ICU_VARS_REGEXP,(match,start,key,_type,_idx,end)=>{return replacements.hasOwnProperty(key)?`${start}${replacements[key]}${end}`:match});result=result.replace(PP_ICU_PLACEHOLDERS_REGEXP,(match,key)=>{return replacements.hasOwnProperty(key)?replacements[key]:match});result=result.replace(PP_ICUS_REGEXP,(match,key)=>{if(replacements.hasOwnProperty(key)){const list=
replacements[key];if(!list.length)throw new Error(`i18n postprocess: unmatched ICU - ${match} with key: ${key}`);return list.shift()}return match});return result}function \u0275\u0275i18nStart(index,messageIndex,subTemplateIndex=-1){const tView=getTView();const lView=getLView();const adjustedIndex=HEADER_OFFSET+index;ngDevMode&&assertDefined(tView,`tView should be defined`);const message=getConstant(tView.consts,messageIndex);const parentTNode=getCurrentParentTNode();if(tView.firstCreatePass)i18nStartFirstCreatePass(tView,
parentTNode===null?0:parentTNode.index,lView,adjustedIndex,message,subTemplateIndex);const tI18n=tView.data[adjustedIndex];const sameViewParentTNode=parentTNode===lView[T_HOST]?null:parentTNode;const parentRNode=getClosestRElement(tView,sameViewParentTNode,lView);const insertInFrontOf=parentTNode&&parentTNode.type&8?lView[parentTNode.index]:null;applyCreateOpCodes(lView,tI18n.create,parentRNode,insertInFrontOf);setInI18nBlock(true)}function \u0275\u0275i18nEnd(){setInI18nBlock(false)}function \u0275\u0275i18n(index,
messageIndex,subTemplateIndex){\u0275\u0275i18nStart(index,messageIndex,subTemplateIndex);\u0275\u0275i18nEnd()}function \u0275\u0275i18nAttributes(index,attrsIndex){const tView=getTView();ngDevMode&&assertDefined(tView,`tView should be defined`);const attrs=getConstant(tView.consts,attrsIndex);i18nAttributesFirstPass(tView,index+HEADER_OFFSET,attrs)}function \u0275\u0275i18nExp(value){const lView=getLView();setMaskBit(bindingUpdated(lView,nextBindingIndex(),value));return \u0275\u0275i18nExp}function \u0275\u0275i18nApply(index){applyI18n(getTView(),
getLView(),index+HEADER_OFFSET)}function \u0275\u0275i18nPostprocess(message,replacements={}){return i18nPostprocess(message,replacements)}function providersResolver(def,providers,viewProviders){const tView=getTView();if(tView.firstCreatePass){const isComponent=isComponentDef(def);resolveProvider(viewProviders,tView.data,tView.blueprint,isComponent,true);resolveProvider(providers,tView.data,tView.blueprint,isComponent,false)}}function resolveProvider(provider,tInjectables,lInjectablesBlueprint,isComponent,
isViewProvider){provider=resolveForwardRef(provider);if(Array.isArray(provider))for(let i=0;i<provider.length;i++)resolveProvider(provider[i],tInjectables,lInjectablesBlueprint,isComponent,isViewProvider);else{const tView=getTView();const lView=getLView();let token=isTypeProvider(provider)?provider:resolveForwardRef(provider.provide);let providerFactory=providerToFactory(provider);const tNode=getCurrentTNode();const beginIndex=tNode.providerIndexes&1048575;const endIndex=tNode.directiveStart;const cptViewProvidersCount=
tNode.providerIndexes>>20;if(isTypeProvider(provider)||!provider.multi){const factory=new NodeInjectorFactory(providerFactory,isViewProvider,\u0275\u0275directiveInject);const existingFactoryIndex=indexOf(token,tInjectables,isViewProvider?beginIndex:beginIndex+cptViewProvidersCount,endIndex);if(existingFactoryIndex===-1){diPublicInInjector(getOrCreateNodeInjectorForNode(tNode,lView),tView,token);registerDestroyHooksIfSupported(tView,provider,tInjectables.length);tInjectables.push(token);tNode.directiveStart++;
tNode.directiveEnd++;if(isViewProvider)tNode.providerIndexes+=1048576;lInjectablesBlueprint.push(factory);lView.push(factory)}else{lInjectablesBlueprint[existingFactoryIndex]=factory;lView[existingFactoryIndex]=factory}}else{const existingProvidersFactoryIndex=indexOf(token,tInjectables,beginIndex+cptViewProvidersCount,endIndex);const existingViewProvidersFactoryIndex=indexOf(token,tInjectables,beginIndex,beginIndex+cptViewProvidersCount);const doesProvidersFactoryExist=existingProvidersFactoryIndex>=
0&&lInjectablesBlueprint[existingProvidersFactoryIndex];const doesViewProvidersFactoryExist=existingViewProvidersFactoryIndex>=0&&lInjectablesBlueprint[existingViewProvidersFactoryIndex];if(isViewProvider&&!doesViewProvidersFactoryExist||!isViewProvider&&!doesProvidersFactoryExist){diPublicInInjector(getOrCreateNodeInjectorForNode(tNode,lView),tView,token);const factory=multiFactory(isViewProvider?multiViewProvidersFactoryResolver:multiProvidersFactoryResolver,lInjectablesBlueprint.length,isViewProvider,
isComponent,providerFactory);if(!isViewProvider&&doesViewProvidersFactoryExist)lInjectablesBlueprint[existingViewProvidersFactoryIndex].providerFactory=factory;registerDestroyHooksIfSupported(tView,provider,tInjectables.length,0);tInjectables.push(token);tNode.directiveStart++;tNode.directiveEnd++;if(isViewProvider)tNode.providerIndexes+=1048576;lInjectablesBlueprint.push(factory);lView.push(factory)}else{const indexInFactory=multiFactoryAdd(lInjectablesBlueprint[isViewProvider?existingViewProvidersFactoryIndex:
existingProvidersFactoryIndex],providerFactory,!isViewProvider&&isComponent);registerDestroyHooksIfSupported(tView,provider,existingProvidersFactoryIndex>-1?existingProvidersFactoryIndex:existingViewProvidersFactoryIndex,indexInFactory)}if(!isViewProvider&&isComponent&&doesViewProvidersFactoryExist)lInjectablesBlueprint[existingViewProvidersFactoryIndex].componentProviders++}}}function registerDestroyHooksIfSupported(tView,provider,contextIndex,indexInFactory){const providerIsTypeProvider=isTypeProvider(provider);
const providerIsClassProvider=isClassProvider(provider);if(providerIsTypeProvider||providerIsClassProvider){const classToken=providerIsClassProvider?resolveForwardRef(provider.useClass):provider;const prototype=classToken.prototype;const ngOnDestroy=prototype.ngOnDestroy;if(ngOnDestroy){const hooks=tView.destroyHooks||(tView.destroyHooks=[]);if(!providerIsTypeProvider&&provider.multi){ngDevMode&&assertDefined(indexInFactory,"indexInFactory when registering multi factory destroy hook");const existingCallbacksIndex=
hooks.indexOf(contextIndex);if(existingCallbacksIndex===-1)hooks.push(contextIndex,[indexInFactory,ngOnDestroy]);else hooks[existingCallbacksIndex+1].push(indexInFactory,ngOnDestroy)}else hooks.push(contextIndex,ngOnDestroy)}}}function multiFactoryAdd(multiFactory,factory,isComponentProvider){if(isComponentProvider)multiFactory.componentProviders++;return multiFactory.multi.push(factory)-1}function indexOf(item,arr,begin,end){for(let i=begin;i<end;i++)if(arr[i]===item)return i;return-1}function multiProvidersFactoryResolver(_,
tData,lData,tNode){return multiResolve(this.multi,[])}function multiViewProvidersFactoryResolver(_,tData,lView,tNode){const factories=this.multi;let result;if(this.providerFactory){const componentCount=this.providerFactory.componentProviders;const multiProviders=getNodeInjectable(lView,lView[TVIEW],this.providerFactory.index,tNode);result=multiProviders.slice(0,componentCount);multiResolve(factories,result);for(let i=componentCount;i<multiProviders.length;i++)result.push(multiProviders[i])}else{result=
[];multiResolve(factories,result)}return result}function multiResolve(factories,result){for(let i=0;i<factories.length;i++){const factory=factories[i];result.push(factory())}return result}function multiFactory(factoryFn,index,isViewProvider,isComponent,f){const factory=new NodeInjectorFactory(factoryFn,isViewProvider,\u0275\u0275directiveInject);factory.multi=[];factory.index=index;factory.componentProviders=0;multiFactoryAdd(factory,f,isComponent&&!isViewProvider);return factory}function \u0275\u0275ProvidersFeature(providers,
viewProviders=[]){return definition=>{definition.providersResolver=(def,processProvidersFn)=>{return providersResolver(def,processProvidersFn?processProvidersFn(providers):providers,viewProviders)}}}class ComponentRef$1{}class ComponentFactory$1{}function noComponentFactoryError(component){const error=Error(`No component factory found for ${stringify(component)}. Did you add it to @NgModule.entryComponents?`);error[ERROR_COMPONENT]=component;return error}const ERROR_COMPONENT="ngComponent";class _NullComponentFactoryResolver{resolveComponentFactory(component){throw noComponentFactoryError(component);
}}class ComponentFactoryResolver$1{}ComponentFactoryResolver$1.NULL=new _NullComponentFactoryResolver;function injectElementRef(){return createElementRef(getCurrentTNode(),getLView())}function createElementRef(tNode,lView){return new ElementRef(getNativeByTNode(tNode,lView))}class ElementRef{constructor(nativeElement){this.nativeElement=nativeElement}}ElementRef.__NG_ELEMENT_ID__=injectElementRef;function unwrapElementRef(value){return value instanceof ElementRef?value.nativeElement:value}new InjectionToken("Renderer2Interceptor");
class RendererFactory2{}class Renderer2{}Renderer2.__NG_ELEMENT_ID__=()=>injectRenderer2();function getOrCreateRenderer2(lView){const renderer=lView[RENDERER];if(ngDevMode&&!isProceduralRenderer(renderer))throw new Error("Cannot inject Renderer2 when the application uses Renderer3!");return renderer}function injectRenderer2(){const lView=getLView();const tNode=getCurrentTNode();const nodeAtIndex=getComponentLViewByIndex(tNode.index,lView);return getOrCreateRenderer2(isLView(nodeAtIndex)?nodeAtIndex:
lView)}class Sanitizer{}Sanitizer.\u0275prov=\u0275\u0275defineInjectable({token:Sanitizer,providedIn:"root",factory:()=>null});class Version{constructor(full){this.full=full;this.major=full.split(".")[0];this.minor=full.split(".")[1];this.patch=full.split(".").slice(2).join(".")}}const VERSION=new Version("13.1.3");const NOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR={};function collectNativeNodes(tView,lView,tNode,result,isProjection=false){while(tNode!==null){ngDevMode&&assertTNodeType(tNode,3|12|16|32);
const lNode=lView[tNode.index];if(lNode!==null)result.push(unwrapRNode(lNode));if(isLContainer(lNode))for(let i=CONTAINER_HEADER_OFFSET;i<lNode.length;i++){const lViewInAContainer=lNode[i];const lViewFirstChildTNode=lViewInAContainer[TVIEW].firstChild;if(lViewFirstChildTNode!==null)collectNativeNodes(lViewInAContainer[TVIEW],lViewInAContainer,lViewFirstChildTNode,result)}const tNodeType=tNode.type;if(tNodeType&8)collectNativeNodes(tView,lView,tNode.child,result);else if(tNodeType&32){const nextRNode=
icuContainerIterate(tNode,lView);let rNode;while(rNode=nextRNode())result.push(rNode)}else if(tNodeType&16){const nodesInSlot=getProjectionNodes(lView,tNode);if(Array.isArray(nodesInSlot))result.push(...nodesInSlot);else{const parentView=getLViewParent(lView[DECLARATION_COMPONENT_VIEW]);ngDevMode&&assertParentView(parentView);collectNativeNodes(parentView[TVIEW],parentView,nodesInSlot,result,true)}}tNode=isProjection?tNode.projectionNext:tNode.next}return result}class ViewRef$1{constructor(_lView,
_cdRefInjectingView){this._lView=_lView;this._cdRefInjectingView=_cdRefInjectingView;this._appRef=null;this._attachedToViewContainer=false}get rootNodes(){const lView=this._lView;const tView=lView[TVIEW];return collectNativeNodes(tView,lView,tView.firstChild,[])}get context(){return this._lView[CONTEXT]}set context(value){this._lView[CONTEXT]=value}get destroyed(){return(this._lView[FLAGS]&256)===256}destroy(){if(this._appRef)this._appRef.detachView(this);else if(this._attachedToViewContainer){const parent=
this._lView[PARENT];if(isLContainer(parent)){const viewRefs=parent[VIEW_REFS];const index=viewRefs?viewRefs.indexOf(this):-1;if(index>-1){ngDevMode&&assertEqual(index,parent.indexOf(this._lView)-CONTAINER_HEADER_OFFSET,"An attached view should be in the same position within its container as its ViewRef in the VIEW_REFS array.");detachView(parent,index);removeFromArray(viewRefs,index)}}this._attachedToViewContainer=false}destroyLView(this._lView[TVIEW],this._lView)}onDestroy(callback){storeCleanupWithContext(this._lView[TVIEW],
this._lView,null,callback)}markForCheck(){markViewDirty(this._cdRefInjectingView||this._lView)}detach(){this._lView[FLAGS]&=~128}reattach(){this._lView[FLAGS]|=128}detectChanges(){detectChangesInternal(this._lView[TVIEW],this._lView,this.context)}checkNoChanges(){checkNoChangesInternal(this._lView[TVIEW],this._lView,this.context)}attachToViewContainerRef(){if(this._appRef){const errorMessage=ngDevMode?"This view is already attached directly to the ApplicationRef!":"";throw new RuntimeError(902,errorMessage);
}this._attachedToViewContainer=true}detachFromAppRef(){this._appRef=null;renderDetachView(this._lView[TVIEW],this._lView)}attachToAppRef(appRef){if(this._attachedToViewContainer){const errorMessage=ngDevMode?"This view is already attached to a ViewContainer!":"";throw new RuntimeError(902,errorMessage);}this._appRef=appRef}}class RootViewRef extends ViewRef$1{constructor(_view){super(_view);this._view=_view}detectChanges(){detectChangesInRootView(this._view)}checkNoChanges(){checkNoChangesInRootView(this._view)}get context(){return null}}
class ComponentFactoryResolver extends ComponentFactoryResolver$1{constructor(ngModule){super();this.ngModule=ngModule}resolveComponentFactory(component){ngDevMode&&assertComponentType(component);const componentDef=getComponentDef(component);return new ComponentFactory(componentDef,this.ngModule)}}function toRefArray(map){const array=[];for(let nonMinified in map)if(map.hasOwnProperty(nonMinified)){const minified=map[nonMinified];array.push({propName:minified,templateName:nonMinified})}return array}
function getNamespace(elementName){const name=elementName.toLowerCase();return name==="svg"?SVG_NAMESPACE:name==="math"?MATH_ML_NAMESPACE:null}const SCHEDULER=new InjectionToken("SCHEDULER_TOKEN",{providedIn:"root",factory:()=>defaultScheduler});function createChainedInjector(rootViewInjector,moduleInjector){return{get:(token,notFoundValue,flags)=>{const value=rootViewInjector.get(token,NOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR,flags);if(value!==NOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR||notFoundValue===
NOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR)return value;return moduleInjector.get(token,notFoundValue,flags)}}}class ComponentFactory extends ComponentFactory$1{constructor(componentDef,ngModule){super();this.componentDef=componentDef;this.ngModule=ngModule;this.componentType=componentDef.type;this.selector=stringifyCSSSelectorList(componentDef.selectors);this.ngContentSelectors=componentDef.ngContentSelectors?componentDef.ngContentSelectors:[];this.isBoundToModule=!!ngModule}get inputs(){return toRefArray(this.componentDef.inputs)}get outputs(){return toRefArray(this.componentDef.outputs)}create(injector,
projectableNodes,rootSelectorOrNode,ngModule){ngModule=ngModule||this.ngModule;const rootViewInjector=ngModule?createChainedInjector(injector,ngModule.injector):injector;const rendererFactory=rootViewInjector.get(RendererFactory2,domRendererFactory3);const sanitizer=rootViewInjector.get(Sanitizer,null);const hostRenderer=rendererFactory.createRenderer(null,this.componentDef);const elementName=this.componentDef.selectors[0][0]||"div";const hostRNode=rootSelectorOrNode?locateHostElement(hostRenderer,
rootSelectorOrNode,this.componentDef.encapsulation):createElementNode(rendererFactory.createRenderer(null,this.componentDef),elementName,getNamespace(elementName));const rootFlags=this.componentDef.onPush?64|512:16|512;const rootContext=createRootContext();const rootTView=createTView(0,null,null,1,0,null,null,null,null,null);const rootLView=createLView(null,rootTView,rootContext,rootFlags,null,null,rendererFactory,hostRenderer,sanitizer,rootViewInjector);enterView(rootLView);let component;let tElementNode;
try{const componentView=createRootComponentView(hostRNode,this.componentDef,rootLView,rendererFactory,hostRenderer);if(hostRNode)if(rootSelectorOrNode)setUpAttributes(hostRenderer,hostRNode,["ng-version",VERSION.full]);else{const {attrs,classes}=extractAttrsAndClassesFromSelector(this.componentDef.selectors[0]);if(attrs)setUpAttributes(hostRenderer,hostRNode,attrs);if(classes&&classes.length>0)writeDirectClass(hostRenderer,hostRNode,classes.join(" "))}tElementNode=getTNode(rootTView,HEADER_OFFSET);
if(projectableNodes!==undefined){const projection=tElementNode.projection=[];for(let i=0;i<this.ngContentSelectors.length;i++){const nodesforSlot=projectableNodes[i];projection.push(nodesforSlot!=null?Array.from(nodesforSlot):null)}}component=createRootComponent(componentView,this.componentDef,rootLView,rootContext,[LifecycleHooksFeature]);renderView(rootTView,rootLView,null)}finally{leaveView()}return new ComponentRef(this.componentType,component,createElementRef(tElementNode,rootLView),rootLView,
tElementNode)}}new ComponentFactoryResolver;class ComponentRef extends ComponentRef$1{constructor(componentType,instance,location,_rootLView,_tNode){super();this.location=location;this._rootLView=_rootLView;this._tNode=_tNode;this.instance=instance;this.hostView=this.changeDetectorRef=new RootViewRef(_rootLView);this.componentType=componentType}get injector(){return new NodeInjector(this._tNode,this._rootLView)}destroy(){this.hostView.destroy()}onDestroy(callback){this.hostView.onDestroy(callback)}}
function setClassMetadata(type,decorators,ctorParameters,propDecorators){return noSideEffects(()=>{const clazz=type;if(decorators!==null)if(clazz.hasOwnProperty("decorators")&&clazz.decorators!==undefined)clazz.decorators.push(...decorators);else clazz.decorators=decorators;if(ctorParameters!==null)clazz.ctorParameters=ctorParameters;if(propDecorators!==null)if(clazz.hasOwnProperty("propDecorators")&&clazz.propDecorators!==undefined)clazz.propDecorators=Object.assign(Object.assign({},clazz.propDecorators),
propDecorators);else clazz.propDecorators=propDecorators})}class NgModuleRef$1{}class NgModuleFactory$1{}const modules=new Map;function assertSameOrNotExisting(id,type,incoming){if(type&&type!==incoming)throw new Error(`Duplicate module registered for ${id} - ${stringify(type)} vs ${stringify(type.name)}`);}function registerNgModuleType(ngModuleType){const visited=new Set;recurse(ngModuleType);function recurse(ngModuleType){const def=getNgModuleDef(ngModuleType,true);const id=def.id;if(id!==null){const existing=
modules.get(id);assertSameOrNotExisting(id,existing,ngModuleType);modules.set(id,ngModuleType)}const imports=maybeUnwrapFn(def.imports);for(const i of imports)if(!visited.has(i)){visited.add(i);recurse(i)}}}function getRegisteredNgModuleType(id){return modules.get(id)||autoRegisterModuleById[id]}function createNgModuleRef(ngModule,parentInjector){return new NgModuleRef(ngModule,parentInjector!==null&&parentInjector!==void 0?parentInjector:null)}class NgModuleRef extends NgModuleRef$1{constructor(ngModuleType,
_parent){super();this._parent=_parent;this._bootstrapComponents=[];this.injector=this;this.destroyCbs=[];this.componentFactoryResolver=new ComponentFactoryResolver(this);const ngModuleDef=getNgModuleDef(ngModuleType);ngDevMode&&assertDefined(ngModuleDef,`NgModule '${stringify(ngModuleType)}' is not a subtype of 'NgModuleType'.`);this._bootstrapComponents=maybeUnwrapFn(ngModuleDef.bootstrap);this._r3Injector=createInjectorWithoutInjectorInstances(ngModuleType,_parent,[{provide:NgModuleRef$1,useValue:this},
{provide:ComponentFactoryResolver$1,useValue:this.componentFactoryResolver}],stringify(ngModuleType));this._r3Injector._resolveInjectorDefTypes();this.instance=this.get(ngModuleType)}get(token,notFoundValue=Injector.THROW_IF_NOT_FOUND,injectFlags=exports.InjectFlags.Default){if(token===Injector||token===NgModuleRef$1||token===INJECTOR)return this;return this._r3Injector.get(token,notFoundValue,injectFlags)}destroy(){ngDevMode&&assertDefined(this.destroyCbs,"NgModule already destroyed");const injector=
this._r3Injector;!injector.destroyed&&injector.destroy();this.destroyCbs.forEach(fn=>fn());this.destroyCbs=null}onDestroy(callback){ngDevMode&&assertDefined(this.destroyCbs,"NgModule already destroyed");this.destroyCbs.push(callback)}}class NgModuleFactory extends NgModuleFactory$1{constructor(moduleType){super();this.moduleType=moduleType;const ngModuleDef=getNgModuleDef(moduleType);if(ngModuleDef!==null)registerNgModuleType(moduleType)}create(parentInjector){return new NgModuleRef(this.moduleType,
parentInjector)}}function \u0275\u0275pureFunction0(slotOffset,pureFn,thisArg){const bindingIndex=getBindingRoot()+slotOffset;const lView=getLView();return lView[bindingIndex]===NO_CHANGE?updateBinding(lView,bindingIndex,thisArg?pureFn.call(thisArg):pureFn()):getBinding(lView,bindingIndex)}function \u0275\u0275pureFunction1(slotOffset,pureFn,exp,thisArg){return pureFunction1Internal(getLView(),getBindingRoot(),slotOffset,pureFn,exp,thisArg)}function \u0275\u0275pureFunction2(slotOffset,pureFn,exp1,
exp2,thisArg){return pureFunction2Internal(getLView(),getBindingRoot(),slotOffset,pureFn,exp1,exp2,thisArg)}function \u0275\u0275pureFunction3(slotOffset,pureFn,exp1,exp2,exp3,thisArg){return pureFunction3Internal(getLView(),getBindingRoot(),slotOffset,pureFn,exp1,exp2,exp3,thisArg)}function \u0275\u0275pureFunction4(slotOffset,pureFn,exp1,exp2,exp3,exp4,thisArg){return pureFunction4Internal(getLView(),getBindingRoot(),slotOffset,pureFn,exp1,exp2,exp3,exp4,thisArg)}function \u0275\u0275pureFunction5(slotOffset,
pureFn,exp1,exp2,exp3,exp4,exp5,thisArg){const bindingIndex=getBindingRoot()+slotOffset;const lView=getLView();const different=bindingUpdated4(lView,bindingIndex,exp1,exp2,exp3,exp4);return bindingUpdated(lView,bindingIndex+4,exp5)||different?updateBinding(lView,bindingIndex+5,thisArg?pureFn.call(thisArg,exp1,exp2,exp3,exp4,exp5):pureFn(exp1,exp2,exp3,exp4,exp5)):getBinding(lView,bindingIndex+5)}function \u0275\u0275pureFunction6(slotOffset,pureFn,exp1,exp2,exp3,exp4,exp5,exp6,thisArg){const bindingIndex=
getBindingRoot()+slotOffset;const lView=getLView();const different=bindingUpdated4(lView,bindingIndex,exp1,exp2,exp3,exp4);return bindingUpdated2(lView,bindingIndex+4,exp5,exp6)||different?updateBinding(lView,bindingIndex+6,thisArg?pureFn.call(thisArg,exp1,exp2,exp3,exp4,exp5,exp6):pureFn(exp1,exp2,exp3,exp4,exp5,exp6)):getBinding(lView,bindingIndex+6)}function \u0275\u0275pureFunction7(slotOffset,pureFn,exp1,exp2,exp3,exp4,exp5,exp6,exp7,thisArg){const bindingIndex=getBindingRoot()+slotOffset;const lView=
getLView();let different=bindingUpdated4(lView,bindingIndex,exp1,exp2,exp3,exp4);return bindingUpdated3(lView,bindingIndex+4,exp5,exp6,exp7)||different?updateBinding(lView,bindingIndex+7,thisArg?pureFn.call(thisArg,exp1,exp2,exp3,exp4,exp5,exp6,exp7):pureFn(exp1,exp2,exp3,exp4,exp5,exp6,exp7)):getBinding(lView,bindingIndex+7)}function \u0275\u0275pureFunction8(slotOffset,pureFn,exp1,exp2,exp3,exp4,exp5,exp6,exp7,exp8,thisArg){const bindingIndex=getBindingRoot()+slotOffset;const lView=getLView();const different=
bindingUpdated4(lView,bindingIndex,exp1,exp2,exp3,exp4);return bindingUpdated4(lView,bindingIndex+4,exp5,exp6,exp7,exp8)||different?updateBinding(lView,bindingIndex+8,thisArg?pureFn.call(thisArg,exp1,exp2,exp3,exp4,exp5,exp6,exp7,exp8):pureFn(exp1,exp2,exp3,exp4,exp5,exp6,exp7,exp8)):getBinding(lView,bindingIndex+8)}function \u0275\u0275pureFunctionV(slotOffset,pureFn,exps,thisArg){return pureFunctionVInternal(getLView(),getBindingRoot(),slotOffset,pureFn,exps,thisArg)}function getPureFunctionReturnValue(lView,
returnValueIndex){ngDevMode&&assertIndexInRange(lView,returnValueIndex);const lastReturnValue=lView[returnValueIndex];return lastReturnValue===NO_CHANGE?undefined:lastReturnValue}function pureFunction1Internal(lView,bindingRoot,slotOffset,pureFn,exp,thisArg){const bindingIndex=bindingRoot+slotOffset;return bindingUpdated(lView,bindingIndex,exp)?updateBinding(lView,bindingIndex+1,thisArg?pureFn.call(thisArg,exp):pureFn(exp)):getPureFunctionReturnValue(lView,bindingIndex+1)}function pureFunction2Internal(lView,
bindingRoot,slotOffset,pureFn,exp1,exp2,thisArg){const bindingIndex=bindingRoot+slotOffset;return bindingUpdated2(lView,bindingIndex,exp1,exp2)?updateBinding(lView,bindingIndex+2,thisArg?pureFn.call(thisArg,exp1,exp2):pureFn(exp1,exp2)):getPureFunctionReturnValue(lView,bindingIndex+2)}function pureFunction3Internal(lView,bindingRoot,slotOffset,pureFn,exp1,exp2,exp3,thisArg){const bindingIndex=bindingRoot+slotOffset;return bindingUpdated3(lView,bindingIndex,exp1,exp2,exp3)?updateBinding(lView,bindingIndex+
3,thisArg?pureFn.call(thisArg,exp1,exp2,exp3):pureFn(exp1,exp2,exp3)):getPureFunctionReturnValue(lView,bindingIndex+3)}function pureFunction4Internal(lView,bindingRoot,slotOffset,pureFn,exp1,exp2,exp3,exp4,thisArg){const bindingIndex=bindingRoot+slotOffset;return bindingUpdated4(lView,bindingIndex,exp1,exp2,exp3,exp4)?updateBinding(lView,bindingIndex+4,thisArg?pureFn.call(thisArg,exp1,exp2,exp3,exp4):pureFn(exp1,exp2,exp3,exp4)):getPureFunctionReturnValue(lView,bindingIndex+4)}function pureFunctionVInternal(lView,
bindingRoot,slotOffset,pureFn,exps,thisArg){let bindingIndex=bindingRoot+slotOffset;let different=false;for(let i=0;i<exps.length;i++)bindingUpdated(lView,bindingIndex++,exps[i])&&(different=true);return different?updateBinding(lView,bindingIndex,pureFn.apply(thisArg,exps)):getPureFunctionReturnValue(lView,bindingIndex)}function \u0275\u0275pipe(index,pipeName){const tView=getTView();let pipeDef;const adjustedIndex=index+HEADER_OFFSET;if(tView.firstCreatePass){pipeDef=getPipeDef(pipeName,tView.pipeRegistry);
tView.data[adjustedIndex]=pipeDef;if(pipeDef.onDestroy)(tView.destroyHooks||(tView.destroyHooks=[])).push(adjustedIndex,pipeDef.onDestroy)}else pipeDef=tView.data[adjustedIndex];const pipeFactory=pipeDef.factory||(pipeDef.factory=getFactoryDef(pipeDef.type,true));const previousInjectImplementation=setInjectImplementation(\u0275\u0275directiveInject);try{const previousIncludeViewProviders=setIncludeViewProviders(false);const pipeInstance=pipeFactory();setIncludeViewProviders(previousIncludeViewProviders);
store(tView,getLView(),adjustedIndex,pipeInstance);return pipeInstance}finally{setInjectImplementation(previousInjectImplementation)}}function getPipeDef(name,registry){if(registry)for(let i=registry.length-1;i>=0;i--){const pipeDef=registry[i];if(name===pipeDef.name)return pipeDef}if(ngDevMode){const lView=getLView();const declarationLView=lView[DECLARATION_COMPONENT_VIEW];const context=declarationLView[CONTEXT];const component=context?` in the '${context.constructor.name}' component`:"";throw new RuntimeError(-302,
`The pipe '${name}' could not be found${component}!`);}}function \u0275\u0275pipeBind1(index,slotOffset,v1){const adjustedIndex=index+HEADER_OFFSET;const lView=getLView();const pipeInstance=load(lView,adjustedIndex);return isPure(lView,adjustedIndex)?pureFunction1Internal(lView,getBindingRoot(),slotOffset,pipeInstance.transform,v1,pipeInstance):pipeInstance.transform(v1)}function \u0275\u0275pipeBind2(index,slotOffset,v1,v2){const adjustedIndex=index+HEADER_OFFSET;const lView=getLView();const pipeInstance=
load(lView,adjustedIndex);return isPure(lView,adjustedIndex)?pureFunction2Internal(lView,getBindingRoot(),slotOffset,pipeInstance.transform,v1,v2,pipeInstance):pipeInstance.transform(v1,v2)}function \u0275\u0275pipeBind3(index,slotOffset,v1,v2,v3){const adjustedIndex=index+HEADER_OFFSET;const lView=getLView();const pipeInstance=load(lView,adjustedIndex);return isPure(lView,adjustedIndex)?pureFunction3Internal(lView,getBindingRoot(),slotOffset,pipeInstance.transform,v1,v2,v3,pipeInstance):pipeInstance.transform(v1,
v2,v3)}function \u0275\u0275pipeBind4(index,slotOffset,v1,v2,v3,v4){const adjustedIndex=index+HEADER_OFFSET;const lView=getLView();const pipeInstance=load(lView,adjustedIndex);return isPure(lView,adjustedIndex)?pureFunction4Internal(lView,getBindingRoot(),slotOffset,pipeInstance.transform,v1,v2,v3,v4,pipeInstance):pipeInstance.transform(v1,v2,v3,v4)}function \u0275\u0275pipeBindV(index,slotOffset,values){const adjustedIndex=index+HEADER_OFFSET;const lView=getLView();const pipeInstance=load(lView,
adjustedIndex);return isPure(lView,adjustedIndex)?pureFunctionVInternal(lView,getBindingRoot(),slotOffset,pipeInstance.transform,values,pipeInstance):pipeInstance.transform.apply(pipeInstance,values)}function isPure(lView,index){return lView[TVIEW].data[index].pure}class EventEmitter_ extends rxjs.Subject{constructor(isAsync=false){super();this.__isAsync=isAsync}emit(value){super.next(value)}subscribe(observerOrNext,error,complete){var _a,_b,_c;let nextFn=observerOrNext;let errorFn=error||(()=>null);
let completeFn=complete;if(observerOrNext&&typeof observerOrNext==="object"){const observer=observerOrNext;nextFn=(_a=observer.next)===null||_a===void 0?void 0:_a.bind(observer);errorFn=(_b=observer.error)===null||_b===void 0?void 0:_b.bind(observer);completeFn=(_c=observer.complete)===null||_c===void 0?void 0:_c.bind(observer)}if(this.__isAsync){errorFn=_wrapInTimeout(errorFn);if(nextFn)nextFn=_wrapInTimeout(nextFn);if(completeFn)completeFn=_wrapInTimeout(completeFn)}const sink=super.subscribe({next:nextFn,
error:errorFn,complete:completeFn});if(observerOrNext instanceof rxjs.Subscription)observerOrNext.add(sink);return sink}}function _wrapInTimeout(fn){return value=>{setTimeout(fn,undefined,value)}}const EventEmitter=EventEmitter_;function symbolIterator(){return this._results[getSymbolIterator()]()}class QueryList{constructor(_emitDistinctChangesOnly=false){this._emitDistinctChangesOnly=_emitDistinctChangesOnly;this.dirty=true;this._results=[];this._changesDetected=false;this._changes=null;this.length=
0;this.first=undefined;this.last=undefined;const symbol=getSymbolIterator();const proto=QueryList.prototype;if(!proto[symbol])proto[symbol]=symbolIterator}get changes(){return this._changes||(this._changes=new EventEmitter)}get(index){return this._results[index]}map(fn){return this._results.map(fn)}filter(fn){return this._results.filter(fn)}find(fn){return this._results.find(fn)}reduce(fn,init){return this._results.reduce(fn,init)}forEach(fn){this._results.forEach(fn)}some(fn){return this._results.some(fn)}toArray(){return this._results.slice()}toString(){return this._results.toString()}reset(resultsTree,
identityAccessor){const self=this;self.dirty=false;const newResultFlat=flatten(resultsTree);if(this._changesDetected=!arrayEquals(self._results,newResultFlat,identityAccessor)){self._results=newResultFlat;self.length=newResultFlat.length;self.last=newResultFlat[this.length-1];self.first=newResultFlat[0]}}notifyOnChanges(){if(this._changes&&(this._changesDetected||!this._emitDistinctChangesOnly))this._changes.emit(this)}setDirty(){this.dirty=true}destroy(){this.changes.complete();this.changes.unsubscribe()}}
class TemplateRef{}TemplateRef.__NG_ELEMENT_ID__=injectTemplateRef;const ViewEngineTemplateRef=TemplateRef;const R3TemplateRef=class TemplateRef extends ViewEngineTemplateRef{constructor(_declarationLView,_declarationTContainer,elementRef){super();this._declarationLView=_declarationLView;this._declarationTContainer=_declarationTContainer;this.elementRef=elementRef}createEmbeddedView(context){const embeddedTView=this._declarationTContainer.tViews;const embeddedLView=createLView(this._declarationLView,
embeddedTView,context,16,null,embeddedTView.declTNode,null,null,null,null);const declarationLContainer=this._declarationLView[this._declarationTContainer.index];ngDevMode&&assertLContainer(declarationLContainer);embeddedLView[DECLARATION_LCONTAINER]=declarationLContainer;const declarationViewLQueries=this._declarationLView[QUERIES];if(declarationViewLQueries!==null)embeddedLView[QUERIES]=declarationViewLQueries.createEmbeddedView(embeddedTView);renderView(embeddedTView,embeddedLView,context);return new ViewRef$1(embeddedLView)}};
function injectTemplateRef(){return createTemplateRef(getCurrentTNode(),getLView())}function createTemplateRef(hostTNode,hostLView){if(hostTNode.type&4){ngDevMode&&assertDefined(hostTNode.tViews,"TView must be allocated");return new R3TemplateRef(hostLView,hostTNode,createElementRef(hostTNode,hostLView))}return null}class ViewContainerRef{}ViewContainerRef.__NG_ELEMENT_ID__=injectViewContainerRef;function injectViewContainerRef(){const previousTNode=getCurrentTNode();return createContainerRef(previousTNode,
getLView())}const VE_ViewContainerRef=ViewContainerRef;const R3ViewContainerRef=class ViewContainerRef extends VE_ViewContainerRef{constructor(_lContainer,_hostTNode,_hostLView){super();this._lContainer=_lContainer;this._hostTNode=_hostTNode;this._hostLView=_hostLView}get element(){return createElementRef(this._hostTNode,this._hostLView)}get injector(){return new NodeInjector(this._hostTNode,this._hostLView)}get parentInjector(){const parentLocation=getParentInjectorLocation(this._hostTNode,this._hostLView);
if(hasParentInjector(parentLocation)){const parentView=getParentInjectorView(parentLocation,this._hostLView);const injectorIndex=getParentInjectorIndex(parentLocation);ngDevMode&&assertNodeInjector(parentView,injectorIndex);const parentTNode=parentView[TVIEW].data[injectorIndex+8];return new NodeInjector(parentTNode,parentView)}else return new NodeInjector(null,this._hostLView)}clear(){while(this.length>0)this.remove(this.length-1)}get(index){const viewRefs=getViewRefs(this._lContainer);return viewRefs!==
null&&viewRefs[index]||null}get length(){return this._lContainer.length-CONTAINER_HEADER_OFFSET}createEmbeddedView(templateRef,context,index){const viewRef=templateRef.createEmbeddedView(context||{});this.insert(viewRef,index);return viewRef}createComponent(componentFactoryOrType,indexOrOptions,injector,projectableNodes,ngModuleRef){const isComponentFactory=componentFactoryOrType&&!isType(componentFactoryOrType);let index;if(isComponentFactory){if(ngDevMode)assertEqual(typeof indexOrOptions!=="object",
true,"It looks like Component factory was provided as the first argument "+"and an options object as the second argument. This combination of arguments "+"is incompatible. You can either change the first argument to provide Component "+"type or change the second argument to be a number (representing an index at "+"which to insert the new component's host view into this container)");index=indexOrOptions}else{if(ngDevMode){assertDefined(getComponentDef(componentFactoryOrType),`Provided Component class doesn't contain Component definition. `+
`Please check whether provided class has @Component decorator.`);assertEqual(typeof indexOrOptions!=="number",true,"It looks like Component type was provided as the first argument "+"and a number (representing an index at which to insert the new component's "+"host view into this container as the second argument. This combination of arguments "+"is incompatible. Please use an object as the second argument instead.")}const options=indexOrOptions||{};index=options.index;injector=options.injector;projectableNodes=
options.projectableNodes;ngModuleRef=options.ngModuleRef}const componentFactory=isComponentFactory?componentFactoryOrType:new ComponentFactory(getComponentDef(componentFactoryOrType));const contextInjector=injector||this.parentInjector;if(!ngModuleRef&&componentFactory.ngModule==null&&contextInjector){const result=contextInjector.get(NgModuleRef$1,null);if(result)ngModuleRef=result}const componentRef=componentFactory.create(contextInjector,projectableNodes,undefined,ngModuleRef);this.insert(componentRef.hostView,
index);return componentRef}insert(viewRef,index){const lView=viewRef._lView;const tView=lView[TVIEW];if(ngDevMode&&viewRef.destroyed)throw new Error("Cannot insert a destroyed View in a ViewContainer!");if(viewAttachedToContainer(lView)){const prevIdx=this.indexOf(viewRef);if(prevIdx!==-1)this.detach(prevIdx);else{const prevLContainer=lView[PARENT];ngDevMode&&assertEqual(isLContainer(prevLContainer),true,"An attached view should have its PARENT point to a container.");const prevVCRef=new R3ViewContainerRef(prevLContainer,
prevLContainer[T_HOST],prevLContainer[PARENT]);prevVCRef.detach(prevVCRef.indexOf(viewRef))}}const adjustedIdx=this._adjustIndex(index);const lContainer=this._lContainer;insertView(tView,lView,lContainer,adjustedIdx);const beforeNode=getBeforeNodeForView(adjustedIdx,lContainer);const renderer=lView[RENDERER];const parentRNode=nativeParentNode(renderer,lContainer[NATIVE]);if(parentRNode!==null)addViewToContainer(tView,lContainer[T_HOST],renderer,lView,parentRNode,beforeNode);viewRef.attachToViewContainerRef();
addToArray(getOrCreateViewRefs(lContainer),adjustedIdx,viewRef);return viewRef}move(viewRef,newIndex){if(ngDevMode&&viewRef.destroyed)throw new Error("Cannot move a destroyed View in a ViewContainer!");return this.insert(viewRef,newIndex)}indexOf(viewRef){const viewRefsArr=getViewRefs(this._lContainer);return viewRefsArr!==null?viewRefsArr.indexOf(viewRef):-1}remove(index){const adjustedIdx=this._adjustIndex(index,-1);const detachedView=detachView(this._lContainer,adjustedIdx);if(detachedView){removeFromArray(getOrCreateViewRefs(this._lContainer),
adjustedIdx);destroyLView(detachedView[TVIEW],detachedView)}}detach(index){const adjustedIdx=this._adjustIndex(index,-1);const view=detachView(this._lContainer,adjustedIdx);const wasDetached=view&&removeFromArray(getOrCreateViewRefs(this._lContainer),adjustedIdx)!=null;return wasDetached?new ViewRef$1(view):null}_adjustIndex(index,shift=0){if(index==null)return this.length+shift;if(ngDevMode){assertGreaterThan(index,-1,`ViewRef index must be positive, got ${index}`);assertLessThan(index,this.length+
1+shift,"index")}return index}};function getViewRefs(lContainer){return lContainer[VIEW_REFS]}function getOrCreateViewRefs(lContainer){return lContainer[VIEW_REFS]||(lContainer[VIEW_REFS]=[])}function createContainerRef(hostTNode,hostLView){ngDevMode&&assertTNodeType(hostTNode,12|3);let lContainer;const slotValue=hostLView[hostTNode.index];if(isLContainer(slotValue))lContainer=slotValue;else{let commentNode;if(hostTNode.type&8)commentNode=unwrapRNode(slotValue);else{const renderer=hostLView[RENDERER];
ngDevMode&&ngDevMode.rendererCreateComment++;commentNode=renderer.createComment(ngDevMode?"container":"");const hostNative=getNativeByTNode(hostTNode,hostLView);const parentOfHostNative=nativeParentNode(renderer,hostNative);nativeInsertBefore(renderer,parentOfHostNative,commentNode,nativeNextSibling(renderer,hostNative),false)}hostLView[hostTNode.index]=lContainer=createLContainer(slotValue,hostLView,commentNode,hostTNode);addToViewTree(hostLView,lContainer)}return new R3ViewContainerRef(lContainer,
hostTNode,hostLView)}class LQuery_{constructor(queryList){this.queryList=queryList;this.matches=null}clone(){return new LQuery_(this.queryList)}setDirty(){this.queryList.setDirty()}}class LQueries_{constructor(queries=[]){this.queries=queries}createEmbeddedView(tView){const tQueries=tView.queries;if(tQueries!==null){const noOfInheritedQueries=tView.contentQueries!==null?tView.contentQueries[0]:tQueries.length;const viewLQueries=[];for(let i=0;i<noOfInheritedQueries;i++){const tQuery=tQueries.getByIndex(i);
const parentLQuery=this.queries[tQuery.indexInDeclarationView];viewLQueries.push(parentLQuery.clone())}return new LQueries_(viewLQueries)}return null}insertView(tView){this.dirtyQueriesWithMatches(tView)}detachView(tView){this.dirtyQueriesWithMatches(tView)}dirtyQueriesWithMatches(tView){for(let i=0;i<this.queries.length;i++)if(getTQuery(tView,i).matches!==null)this.queries[i].setDirty()}}class TQueryMetadata_{constructor(predicate,flags,read=null){this.predicate=predicate;this.flags=flags;this.read=
read}}class TQueries_{constructor(queries=[]){this.queries=queries}elementStart(tView,tNode){ngDevMode&&assertFirstCreatePass(tView,"Queries should collect results on the first template pass only");for(let i=0;i<this.queries.length;i++)this.queries[i].elementStart(tView,tNode)}elementEnd(tNode){for(let i=0;i<this.queries.length;i++)this.queries[i].elementEnd(tNode)}embeddedTView(tNode){let queriesForTemplateRef=null;for(let i=0;i<this.length;i++){const childQueryIndex=queriesForTemplateRef!==null?
queriesForTemplateRef.length:0;const tqueryClone=this.getByIndex(i).embeddedTView(tNode,childQueryIndex);if(tqueryClone){tqueryClone.indexInDeclarationView=i;if(queriesForTemplateRef!==null)queriesForTemplateRef.push(tqueryClone);else queriesForTemplateRef=[tqueryClone]}}return queriesForTemplateRef!==null?new TQueries_(queriesForTemplateRef):null}template(tView,tNode){ngDevMode&&assertFirstCreatePass(tView,"Queries should collect results on the first template pass only");for(let i=0;i<this.queries.length;i++)this.queries[i].template(tView,
tNode)}getByIndex(index){ngDevMode&&assertIndexInRange(this.queries,index);return this.queries[index]}get length(){return this.queries.length}track(tquery){this.queries.push(tquery)}}class TQuery_{constructor(metadata,nodeIndex=-1){this.metadata=metadata;this.matches=null;this.indexInDeclarationView=-1;this.crossesNgTemplate=false;this._appliesToNextNode=true;this._declarationNodeIndex=nodeIndex}elementStart(tView,tNode){if(this.isApplyingToNode(tNode))this.matchTNode(tView,tNode)}elementEnd(tNode){if(this._declarationNodeIndex===
tNode.index)this._appliesToNextNode=false}template(tView,tNode){this.elementStart(tView,tNode)}embeddedTView(tNode,childQueryIndex){if(this.isApplyingToNode(tNode)){this.crossesNgTemplate=true;this.addMatch(-tNode.index,childQueryIndex);return new TQuery_(this.metadata)}return null}isApplyingToNode(tNode){if(this._appliesToNextNode&&(this.metadata.flags&1)!==1){const declarationNodeIdx=this._declarationNodeIndex;let parent=tNode.parent;while(parent!==null&&parent.type&8&&parent.index!==declarationNodeIdx)parent=
parent.parent;return declarationNodeIdx===(parent!==null?parent.index:-1)}return this._appliesToNextNode}matchTNode(tView,tNode){const predicate=this.metadata.predicate;if(Array.isArray(predicate))for(let i=0;i<predicate.length;i++){const name=predicate[i];this.matchTNodeWithReadOption(tView,tNode,getIdxOfMatchingSelector(tNode,name));this.matchTNodeWithReadOption(tView,tNode,locateDirectiveOrProvider(tNode,tView,name,false,false))}else if(predicate===TemplateRef){if(tNode.type&4)this.matchTNodeWithReadOption(tView,
tNode,-1)}else this.matchTNodeWithReadOption(tView,tNode,locateDirectiveOrProvider(tNode,tView,predicate,false,false))}matchTNodeWithReadOption(tView,tNode,nodeMatchIdx){if(nodeMatchIdx!==null){const read=this.metadata.read;if(read!==null)if(read===ElementRef||read===ViewContainerRef||read===TemplateRef&&tNode.type&4)this.addMatch(tNode.index,-2);else{const directiveOrProviderIdx=locateDirectiveOrProvider(tNode,tView,read,false,false);if(directiveOrProviderIdx!==null)this.addMatch(tNode.index,directiveOrProviderIdx)}else this.addMatch(tNode.index,
nodeMatchIdx)}}addMatch(tNodeIdx,matchIdx){if(this.matches===null)this.matches=[tNodeIdx,matchIdx];else this.matches.push(tNodeIdx,matchIdx)}}function getIdxOfMatchingSelector(tNode,selector){const localNames=tNode.localNames;if(localNames!==null)for(let i=0;i<localNames.length;i+=2)if(localNames[i]===selector)return localNames[i+1];return null}function createResultByTNodeType(tNode,currentView){if(tNode.type&(3|8))return createElementRef(tNode,currentView);else if(tNode.type&4)return createTemplateRef(tNode,
currentView);return null}function createResultForNode(lView,tNode,matchingIdx,read){if(matchingIdx===-1)return createResultByTNodeType(tNode,lView);else if(matchingIdx===-2)return createSpecialToken(lView,tNode,read);else return getNodeInjectable(lView,lView[TVIEW],matchingIdx,tNode)}function createSpecialToken(lView,tNode,read){if(read===ElementRef)return createElementRef(tNode,lView);else if(read===TemplateRef)return createTemplateRef(tNode,lView);else if(read===ViewContainerRef){ngDevMode&&assertTNodeType(tNode,
3|12);return createContainerRef(tNode,lView)}else ngDevMode&&throwError(`Special token to read should be one of ElementRef, TemplateRef or ViewContainerRef but got ${stringify(read)}.`)}function materializeViewResults(tView,lView,tQuery,queryIndex){const lQuery=lView[QUERIES].queries[queryIndex];if(lQuery.matches===null){const tViewData=tView.data;const tQueryMatches=tQuery.matches;const result=[];for(let i=0;i<tQueryMatches.length;i+=2){const matchedNodeIdx=tQueryMatches[i];if(matchedNodeIdx<0)result.push(null);
else{ngDevMode&&assertIndexInRange(tViewData,matchedNodeIdx);const tNode=tViewData[matchedNodeIdx];result.push(createResultForNode(lView,tNode,tQueryMatches[i+1],tQuery.metadata.read))}}lQuery.matches=result}return lQuery.matches}function collectQueryResults(tView,lView,queryIndex,result){const tQuery=tView.queries.getByIndex(queryIndex);const tQueryMatches=tQuery.matches;if(tQueryMatches!==null){const lViewResults=materializeViewResults(tView,lView,tQuery,queryIndex);for(let i=0;i<tQueryMatches.length;i+=
2){const tNodeIdx=tQueryMatches[i];if(tNodeIdx>0)result.push(lViewResults[i/2]);else{const childQueryIndex=tQueryMatches[i+1];const declarationLContainer=lView[-tNodeIdx];ngDevMode&&assertLContainer(declarationLContainer);for(let i=CONTAINER_HEADER_OFFSET;i<declarationLContainer.length;i++){const embeddedLView=declarationLContainer[i];if(embeddedLView[DECLARATION_LCONTAINER]===embeddedLView[PARENT])collectQueryResults(embeddedLView[TVIEW],embeddedLView,childQueryIndex,result)}if(declarationLContainer[MOVED_VIEWS]!==
null){const embeddedLViews=declarationLContainer[MOVED_VIEWS];for(let i=0;i<embeddedLViews.length;i++){const embeddedLView=embeddedLViews[i];collectQueryResults(embeddedLView[TVIEW],embeddedLView,childQueryIndex,result)}}}}}return result}function \u0275\u0275queryRefresh(queryList){const lView=getLView();const tView=getTView();const queryIndex=getCurrentQueryIndex();setCurrentQueryIndex(queryIndex+1);const tQuery=getTQuery(tView,queryIndex);if(queryList.dirty&&isCreationMode(lView)===((tQuery.metadata.flags&
2)===2)){if(tQuery.matches===null)queryList.reset([]);else{const result=tQuery.crossesNgTemplate?collectQueryResults(tView,lView,queryIndex,[]):materializeViewResults(tView,lView,tQuery,queryIndex);queryList.reset(result,unwrapElementRef);queryList.notifyOnChanges()}return true}return false}function \u0275\u0275viewQuery(predicate,flags,read){ngDevMode&&assertNumber(flags,"Expecting flags");const tView=getTView();if(tView.firstCreatePass){createTQuery(tView,new TQueryMetadata_(predicate,flags,read),
-1);if((flags&2)===2)tView.staticViewQueries=true}createLQuery(tView,getLView(),flags)}function \u0275\u0275contentQuery(directiveIndex,predicate,flags,read){ngDevMode&&assertNumber(flags,"Expecting flags");const tView=getTView();if(tView.firstCreatePass){const tNode=getCurrentTNode();createTQuery(tView,new TQueryMetadata_(predicate,flags,read),tNode.index);saveContentQueryAndDirectiveIndex(tView,directiveIndex);if((flags&2)===2)tView.staticContentQueries=true}createLQuery(tView,getLView(),flags)}
function \u0275\u0275loadQuery(){return loadQueryInternal(getLView(),getCurrentQueryIndex())}function loadQueryInternal(lView,queryIndex){ngDevMode&&assertDefined(lView[QUERIES],"LQueries should be defined when trying to load a query");ngDevMode&&assertIndexInRange(lView[QUERIES].queries,queryIndex);return lView[QUERIES].queries[queryIndex].queryList}function createLQuery(tView,lView,flags){const queryList=new QueryList((flags&4)===4);storeCleanupWithContext(tView,lView,queryList,queryList.destroy);
if(lView[QUERIES]===null)lView[QUERIES]=new LQueries_;lView[QUERIES].queries.push(new LQuery_(queryList))}function createTQuery(tView,metadata,nodeIndex){if(tView.queries===null)tView.queries=new TQueries_;tView.queries.track(new TQuery_(metadata,nodeIndex))}function saveContentQueryAndDirectiveIndex(tView,directiveIndex){const tViewContentQueries=tView.contentQueries||(tView.contentQueries=[]);const lastSavedDirectiveIndex=tViewContentQueries.length?tViewContentQueries[tViewContentQueries.length-
1]:-1;if(directiveIndex!==lastSavedDirectiveIndex)tViewContentQueries.push(tView.queries.length-1,directiveIndex)}function getTQuery(tView,index){ngDevMode&&assertDefined(tView.queries,"TQueries must be defined to retrieve a TQuery");return tView.queries.getByIndex(index)}function \u0275\u0275templateRefExtractor(tNode,lView){return createTemplateRef(tNode,lView)}const angularCoreEnv=(()=>({"ɵɵattribute":\u0275\u0275attribute,"ɵɵattributeInterpolate1":\u0275\u0275attributeInterpolate1,"ɵɵattributeInterpolate2":\u0275\u0275attributeInterpolate2,
"ɵɵattributeInterpolate3":\u0275\u0275attributeInterpolate3,"ɵɵattributeInterpolate4":\u0275\u0275attributeInterpolate4,"ɵɵattributeInterpolate5":\u0275\u0275attributeInterpolate5,"ɵɵattributeInterpolate6":\u0275\u0275attributeInterpolate6,"ɵɵattributeInterpolate7":\u0275\u0275attributeInterpolate7,"ɵɵattributeInterpolate8":\u0275\u0275attributeInterpolate8,"ɵɵattributeInterpolateV":\u0275\u0275attributeInterpolateV,"ɵɵdefineComponent":\u0275\u0275defineComponent,"ɵɵdefineDirective":\u0275\u0275defineDirective,
"ɵɵdefineInjectable":\u0275\u0275defineInjectable,"ɵɵdefineInjector":\u0275\u0275defineInjector,"ɵɵdefineNgModule":\u0275\u0275defineNgModule,"ɵɵdefinePipe":\u0275\u0275definePipe,"ɵɵdirectiveInject":\u0275\u0275directiveInject,"ɵɵgetInheritedFactory":\u0275\u0275getInheritedFactory,"ɵɵinject":\u0275\u0275inject,"ɵɵinjectAttribute":\u0275\u0275injectAttribute,"ɵɵinvalidFactory":\u0275\u0275invalidFactory,"ɵɵinvalidFactoryDep":\u0275\u0275invalidFactoryDep,"ɵɵtemplateRefExtractor":\u0275\u0275templateRefExtractor,
"ɵɵNgOnChangesFeature":\u0275\u0275NgOnChangesFeature,"ɵɵProvidersFeature":\u0275\u0275ProvidersFeature,"ɵɵCopyDefinitionFeature":\u0275\u0275CopyDefinitionFeature,"ɵɵInheritDefinitionFeature":\u0275\u0275InheritDefinitionFeature,"ɵɵnextContext":\u0275\u0275nextContext,"ɵɵnamespaceHTML":\u0275\u0275namespaceHTML,"ɵɵnamespaceMathML":\u0275\u0275namespaceMathML,"ɵɵnamespaceSVG":\u0275\u0275namespaceSVG,"ɵɵenableBindings":\u0275\u0275enableBindings,"ɵɵdisableBindings":\u0275\u0275disableBindings,"ɵɵelementStart":\u0275\u0275elementStart,
"ɵɵelementEnd":\u0275\u0275elementEnd,"ɵɵelement":\u0275\u0275element,"ɵɵelementContainerStart":\u0275\u0275elementContainerStart,"ɵɵelementContainerEnd":\u0275\u0275elementContainerEnd,"ɵɵelementContainer":\u0275\u0275elementContainer,"ɵɵpureFunction0":\u0275\u0275pureFunction0,"ɵɵpureFunction1":\u0275\u0275pureFunction1,"ɵɵpureFunction2":\u0275\u0275pureFunction2,"ɵɵpureFunction3":\u0275\u0275pureFunction3,"ɵɵpureFunction4":\u0275\u0275pureFunction4,"ɵɵpureFunction5":\u0275\u0275pureFunction5,"ɵɵpureFunction6":\u0275\u0275pureFunction6,
"ɵɵpureFunction7":\u0275\u0275pureFunction7,"ɵɵpureFunction8":\u0275\u0275pureFunction8,"ɵɵpureFunctionV":\u0275\u0275pureFunctionV,"ɵɵgetCurrentView":\u0275\u0275getCurrentView,"ɵɵrestoreView":\u0275\u0275restoreView,"ɵɵlistener":\u0275\u0275listener,"ɵɵprojection":\u0275\u0275projection,"ɵɵsyntheticHostProperty":\u0275\u0275syntheticHostProperty,"ɵɵsyntheticHostListener":\u0275\u0275syntheticHostListener,"ɵɵpipeBind1":\u0275\u0275pipeBind1,"ɵɵpipeBind2":\u0275\u0275pipeBind2,"ɵɵpipeBind3":\u0275\u0275pipeBind3,
"ɵɵpipeBind4":\u0275\u0275pipeBind4,"ɵɵpipeBindV":\u0275\u0275pipeBindV,"ɵɵprojectionDef":\u0275\u0275projectionDef,"ɵɵhostProperty":\u0275\u0275hostProperty,"ɵɵproperty":\u0275\u0275property,"ɵɵpropertyInterpolate":\u0275\u0275propertyInterpolate,"ɵɵpropertyInterpolate1":\u0275\u0275propertyInterpolate1,"ɵɵpropertyInterpolate2":\u0275\u0275propertyInterpolate2,"ɵɵpropertyInterpolate3":\u0275\u0275propertyInterpolate3,"ɵɵpropertyInterpolate4":\u0275\u0275propertyInterpolate4,"ɵɵpropertyInterpolate5":\u0275\u0275propertyInterpolate5,
"ɵɵpropertyInterpolate6":\u0275\u0275propertyInterpolate6,"ɵɵpropertyInterpolate7":\u0275\u0275propertyInterpolate7,"ɵɵpropertyInterpolate8":\u0275\u0275propertyInterpolate8,"ɵɵpropertyInterpolateV":\u0275\u0275propertyInterpolateV,"ɵɵpipe":\u0275\u0275pipe,"ɵɵqueryRefresh":\u0275\u0275queryRefresh,"ɵɵviewQuery":\u0275\u0275viewQuery,"ɵɵloadQuery":\u0275\u0275loadQuery,"ɵɵcontentQuery":\u0275\u0275contentQuery,"ɵɵreference":\u0275\u0275reference,"ɵɵclassMap":\u0275\u0275classMap,"ɵɵclassMapInterpolate1":\u0275\u0275classMapInterpolate1,
"ɵɵclassMapInterpolate2":\u0275\u0275classMapInterpolate2,"ɵɵclassMapInterpolate3":\u0275\u0275classMapInterpolate3,"ɵɵclassMapInterpolate4":\u0275\u0275classMapInterpolate4,"ɵɵclassMapInterpolate5":\u0275\u0275classMapInterpolate5,"ɵɵclassMapInterpolate6":\u0275\u0275classMapInterpolate6,"ɵɵclassMapInterpolate7":\u0275\u0275classMapInterpolate7,"ɵɵclassMapInterpolate8":\u0275\u0275classMapInterpolate8,"ɵɵclassMapInterpolateV":\u0275\u0275classMapInterpolateV,"ɵɵstyleMap":\u0275\u0275styleMap,"ɵɵstyleMapInterpolate1":\u0275\u0275styleMapInterpolate1,
"ɵɵstyleMapInterpolate2":\u0275\u0275styleMapInterpolate2,"ɵɵstyleMapInterpolate3":\u0275\u0275styleMapInterpolate3,"ɵɵstyleMapInterpolate4":\u0275\u0275styleMapInterpolate4,"ɵɵstyleMapInterpolate5":\u0275\u0275styleMapInterpolate5,"ɵɵstyleMapInterpolate6":\u0275\u0275styleMapInterpolate6,"ɵɵstyleMapInterpolate7":\u0275\u0275styleMapInterpolate7,"ɵɵstyleMapInterpolate8":\u0275\u0275styleMapInterpolate8,"ɵɵstyleMapInterpolateV":\u0275\u0275styleMapInterpolateV,"ɵɵstyleProp":\u0275\u0275styleProp,"ɵɵstylePropInterpolate1":\u0275\u0275stylePropInterpolate1,
"ɵɵstylePropInterpolate2":\u0275\u0275stylePropInterpolate2,"ɵɵstylePropInterpolate3":\u0275\u0275stylePropInterpolate3,"ɵɵstylePropInterpolate4":\u0275\u0275stylePropInterpolate4,"ɵɵstylePropInterpolate5":\u0275\u0275stylePropInterpolate5,"ɵɵstylePropInterpolate6":\u0275\u0275stylePropInterpolate6,"ɵɵstylePropInterpolate7":\u0275\u0275stylePropInterpolate7,"ɵɵstylePropInterpolate8":\u0275\u0275stylePropInterpolate8,"ɵɵstylePropInterpolateV":\u0275\u0275stylePropInterpolateV,"ɵɵclassProp":\u0275\u0275classProp,
"ɵɵadvance":\u0275\u0275advance,"ɵɵtemplate":\u0275\u0275template,"ɵɵtext":\u0275\u0275text,"ɵɵtextInterpolate":\u0275\u0275textInterpolate,"ɵɵtextInterpolate1":\u0275\u0275textInterpolate1,"ɵɵtextInterpolate2":\u0275\u0275textInterpolate2,"ɵɵtextInterpolate3":\u0275\u0275textInterpolate3,"ɵɵtextInterpolate4":\u0275\u0275textInterpolate4,"ɵɵtextInterpolate5":\u0275\u0275textInterpolate5,"ɵɵtextInterpolate6":\u0275\u0275textInterpolate6,"ɵɵtextInterpolate7":\u0275\u0275textInterpolate7,"ɵɵtextInterpolate8":\u0275\u0275textInterpolate8,
"ɵɵtextInterpolateV":\u0275\u0275textInterpolateV,"ɵɵi18n":\u0275\u0275i18n,"ɵɵi18nAttributes":\u0275\u0275i18nAttributes,"ɵɵi18nExp":\u0275\u0275i18nExp,"ɵɵi18nStart":\u0275\u0275i18nStart,"ɵɵi18nEnd":\u0275\u0275i18nEnd,"ɵɵi18nApply":\u0275\u0275i18nApply,"ɵɵi18nPostprocess":\u0275\u0275i18nPostprocess,"ɵɵresolveWindow":\u0275\u0275resolveWindow,"ɵɵresolveDocument":\u0275\u0275resolveDocument,"ɵɵresolveBody":\u0275\u0275resolveBody,"ɵɵsetComponentScope":\u0275\u0275setComponentScope,"ɵɵsetNgModuleScope":\u0275\u0275setNgModuleScope,
"ɵɵsanitizeHtml":\u0275\u0275sanitizeHtml,"ɵɵsanitizeStyle":\u0275\u0275sanitizeStyle,"ɵɵsanitizeResourceUrl":\u0275\u0275sanitizeResourceUrl,"ɵɵsanitizeScript":\u0275\u0275sanitizeScript,"ɵɵsanitizeUrl":\u0275\u0275sanitizeUrl,"ɵɵsanitizeUrlOrResourceUrl":\u0275\u0275sanitizeUrlOrResourceUrl,"ɵɵtrustConstantHtml":\u0275\u0275trustConstantHtml,"ɵɵtrustConstantResourceUrl":\u0275\u0275trustConstantResourceUrl,"forwardRef":forwardRef,"resolveForwardRef":resolveForwardRef}))();let jitOptions=null;function setJitOptions(options){if(jitOptions!==
null){if(options.defaultEncapsulation!==jitOptions.defaultEncapsulation){ngDevMode&&console.error("Provided value for `defaultEncapsulation` can not be changed once it has been set.");return}if(options.preserveWhitespaces!==jitOptions.preserveWhitespaces){ngDevMode&&console.error("Provided value for `preserveWhitespaces` can not be changed once it has been set.");return}}jitOptions=options}function getJitOptions(){return jitOptions}function resetJitOptions(){jitOptions=null}const moduleQueue=[];function enqueueModuleForDelayedScoping(moduleType,
ngModule){moduleQueue.push({moduleType,ngModule})}let flushingModuleQueue=false;function flushModuleScopingQueueAsMuchAsPossible(){if(!flushingModuleQueue){flushingModuleQueue=true;try{for(let i=moduleQueue.length-1;i>=0;i--){const {moduleType,ngModule}=moduleQueue[i];if(ngModule.declarations&&ngModule.declarations.every(isResolvedDeclaration)){moduleQueue.splice(i,1);setScopeOnDeclaredComponents(moduleType,ngModule)}}}finally{flushingModuleQueue=false}}}function isResolvedDeclaration(declaration){if(Array.isArray(declaration))return declaration.every(isResolvedDeclaration);
return!!resolveForwardRef(declaration)}function compileNgModule(moduleType,ngModule={}){compileNgModuleDefs(moduleType,ngModule);enqueueModuleForDelayedScoping(moduleType,ngModule)}function compileNgModuleDefs(moduleType,ngModule,allowDuplicateDeclarationsInRoot=false){ngDevMode&&assertDefined(moduleType,"Required value moduleType");ngDevMode&&assertDefined(ngModule,"Required value ngModule");const declarations=flatten(ngModule.declarations||EMPTY_ARRAY);let ngModuleDef=null;Object.defineProperty(moduleType,
NG_MOD_DEF,{configurable:true,get:()=>{if(ngModuleDef===null){if(ngDevMode&&ngModule.imports&&ngModule.imports.indexOf(moduleType)>-1)throw new Error(`'${stringifyForError(moduleType)}' module can't import itself`);const compiler=getCompilerFacade({usage:0,kind:"NgModule",type:moduleType});ngModuleDef=compiler.compileNgModule(angularCoreEnv,`ng:///${moduleType.name}/ɵmod.js`,{type:moduleType,bootstrap:flatten(ngModule.bootstrap||EMPTY_ARRAY).map(resolveForwardRef),declarations:declarations.map(resolveForwardRef),
imports:flatten(ngModule.imports||EMPTY_ARRAY).map(resolveForwardRef).map(expandModuleWithProviders),exports:flatten(ngModule.exports||EMPTY_ARRAY).map(resolveForwardRef).map(expandModuleWithProviders),schemas:ngModule.schemas?flatten(ngModule.schemas):null,id:ngModule.id||null});if(!ngModuleDef.schemas)ngModuleDef.schemas=[]}return ngModuleDef}});let ngFactoryDef=null;Object.defineProperty(moduleType,NG_FACTORY_DEF,{get:()=>{if(ngFactoryDef===null){const compiler=getCompilerFacade({usage:0,kind:"NgModule",
type:moduleType});ngFactoryDef=compiler.compileFactory(angularCoreEnv,`ng:///${moduleType.name}/ɵfac.js`,{name:moduleType.name,type:moduleType,deps:reflectDependencies(moduleType),target:compiler.FactoryTarget.NgModule,typeArgumentCount:0})}return ngFactoryDef},configurable:!!ngDevMode});let ngInjectorDef=null;Object.defineProperty(moduleType,NG_INJ_DEF,{get:()=>{if(ngInjectorDef===null){ngDevMode&&verifySemanticsOfNgModuleDef(moduleType,allowDuplicateDeclarationsInRoot);const meta={name:moduleType.name,
type:moduleType,providers:ngModule.providers||EMPTY_ARRAY,imports:[(ngModule.imports||EMPTY_ARRAY).map(resolveForwardRef),(ngModule.exports||EMPTY_ARRAY).map(resolveForwardRef)]};const compiler=getCompilerFacade({usage:0,kind:"NgModule",type:moduleType});ngInjectorDef=compiler.compileInjector(angularCoreEnv,`ng:///${moduleType.name}/ɵinj.js`,meta)}return ngInjectorDef},configurable:!!ngDevMode})}function verifySemanticsOfNgModuleDef(moduleType,allowDuplicateDeclarationsInRoot,importingModule){if(verifiedNgModule.get(moduleType))return;
verifiedNgModule.set(moduleType,true);moduleType=resolveForwardRef(moduleType);let ngModuleDef;if(importingModule){ngModuleDef=getNgModuleDef(moduleType);if(!ngModuleDef)throw new Error(`Unexpected value '${moduleType.name}' imported by the module '${importingModule.name}'. Please add an @NgModule annotation.`);}else ngModuleDef=getNgModuleDef(moduleType,true);const errors=[];const declarations=maybeUnwrapFn(ngModuleDef.declarations);const imports=maybeUnwrapFn(ngModuleDef.imports);flatten(imports).map(unwrapModuleWithProvidersImports).forEach(mod=>
{verifySemanticsOfNgModuleImport(mod,moduleType);verifySemanticsOfNgModuleDef(mod,false,moduleType)});const exports=maybeUnwrapFn(ngModuleDef.exports);declarations.forEach(verifyDeclarationsHaveDefinitions);declarations.forEach(verifyDirectivesHaveSelector);const combinedDeclarations=[...declarations.map(resolveForwardRef),...flatten(imports.map(computeCombinedExports)).map(resolveForwardRef)];exports.forEach(verifyExportsAreDeclaredOrReExported);declarations.forEach(decl=>verifyDeclarationIsUnique(decl,
allowDuplicateDeclarationsInRoot));declarations.forEach(verifyComponentEntryComponentsIsPartOfNgModule);const ngModule=getAnnotation(moduleType,"NgModule");if(ngModule){ngModule.imports&&flatten(ngModule.imports).map(unwrapModuleWithProvidersImports).forEach(mod=>{verifySemanticsOfNgModuleImport(mod,moduleType);verifySemanticsOfNgModuleDef(mod,false,moduleType)});ngModule.bootstrap&&deepForEach(ngModule.bootstrap,verifyCorrectBootstrapType);ngModule.bootstrap&&deepForEach(ngModule.bootstrap,verifyComponentIsPartOfNgModule);
ngModule.entryComponents&&deepForEach(ngModule.entryComponents,verifyComponentIsPartOfNgModule)}if(errors.length)throw new Error(errors.join("\n"));function verifyDeclarationsHaveDefinitions(type){type=resolveForwardRef(type);const def=getComponentDef(type)||getDirectiveDef(type)||getPipeDef$1(type);if(!def)errors.push(`Unexpected value '${stringifyForError(type)}' declared by the module '${stringifyForError(moduleType)}'. Please add a @Pipe/@Directive/@Component annotation.`)}function verifyDirectivesHaveSelector(type){type=
resolveForwardRef(type);const def=getDirectiveDef(type);if(!getComponentDef(type)&&def&&def.selectors.length==0)errors.push(`Directive ${stringifyForError(type)} has no selector, please add it!`)}function verifyExportsAreDeclaredOrReExported(type){type=resolveForwardRef(type);const kind=getComponentDef(type)&&"component"||getDirectiveDef(type)&&"directive"||getPipeDef$1(type)&&"pipe";if(kind)if(combinedDeclarations.lastIndexOf(type)===-1)errors.push(`Can't export ${kind} ${stringifyForError(type)} from ${stringifyForError(moduleType)} as it was neither declared nor imported!`)}
function verifyDeclarationIsUnique(type,suppressErrors){type=resolveForwardRef(type);const existingModule=ownerNgModule.get(type);if(existingModule&&existingModule!==moduleType){if(!suppressErrors){const modules=[existingModule,moduleType].map(stringifyForError).sort();errors.push(`Type ${stringifyForError(type)} is part of the declarations of 2 modules: ${modules[0]} and ${modules[1]}! `+`Please consider moving ${stringifyForError(type)} to a higher module that imports ${modules[0]} and ${modules[1]}. `+
`You can also create a new NgModule that exports and includes ${stringifyForError(type)} then import that NgModule in ${modules[0]} and ${modules[1]}.`)}}else ownerNgModule.set(type,moduleType)}function verifyComponentIsPartOfNgModule(type){type=resolveForwardRef(type);const existingModule=ownerNgModule.get(type);if(!existingModule)errors.push(`Component ${stringifyForError(type)} is not part of any NgModule or the module has not been imported into your module.`)}function verifyCorrectBootstrapType(type){type=
resolveForwardRef(type);if(!getComponentDef(type))errors.push(`${stringifyForError(type)} cannot be used as an entry component.`)}function verifyComponentEntryComponentsIsPartOfNgModule(type){type=resolveForwardRef(type);if(getComponentDef(type)){const component=getAnnotation(type,"Component");if(component&&component.entryComponents)deepForEach(component.entryComponents,verifyComponentIsPartOfNgModule)}}function verifySemanticsOfNgModuleImport(type,importingModule){type=resolveForwardRef(type);if(getComponentDef(type)||
getDirectiveDef(type))throw new Error(`Unexpected directive '${type.name}' imported by the module '${importingModule.name}'. Please add an @NgModule annotation.`);if(getPipeDef$1(type))throw new Error(`Unexpected pipe '${type.name}' imported by the module '${importingModule.name}'. Please add an @NgModule annotation.`);}}function unwrapModuleWithProvidersImports(typeOrWithProviders){typeOrWithProviders=resolveForwardRef(typeOrWithProviders);return typeOrWithProviders.ngModule||typeOrWithProviders}
function getAnnotation(type,name){let annotation=null;collect(type.__annotations__);collect(type.decorators);return annotation;function collect(annotations){if(annotations)annotations.forEach(readAnnotation)}function readAnnotation(decorator){if(!annotation){const proto=Object.getPrototypeOf(decorator);if(proto.ngMetadataName==name)annotation=decorator;else if(decorator.type){const proto=Object.getPrototypeOf(decorator.type);if(proto.ngMetadataName==name)annotation=decorator.args[0]}}}}let ownerNgModule=
new WeakMap;let verifiedNgModule=new WeakMap;function resetCompiledComponents(){ownerNgModule=new WeakMap;verifiedNgModule=new WeakMap;moduleQueue.length=0}function computeCombinedExports(type){type=resolveForwardRef(type);const ngModuleDef=getNgModuleDef(type,true);return[...flatten(maybeUnwrapFn(ngModuleDef.exports).map(type=>{const ngModuleDef=getNgModuleDef(type);if(ngModuleDef){verifySemanticsOfNgModuleDef(type,false);return computeCombinedExports(type)}else return type}))]}function setScopeOnDeclaredComponents(moduleType,
ngModule){const declarations=flatten(ngModule.declarations||EMPTY_ARRAY);const transitiveScopes=transitiveScopesFor(moduleType);declarations.forEach(declaration=>{if(declaration.hasOwnProperty(NG_COMP_DEF)){const component=declaration;const componentDef=getComponentDef(component);patchComponentDefWithScope(componentDef,transitiveScopes)}else if(!declaration.hasOwnProperty(NG_DIR_DEF)&&!declaration.hasOwnProperty(NG_PIPE_DEF))declaration.ngSelectorScope=moduleType})}function patchComponentDefWithScope(componentDef,
transitiveScopes){componentDef.directiveDefs=()=>Array.from(transitiveScopes.compilation.directives).map(dir=>dir.hasOwnProperty(NG_COMP_DEF)?getComponentDef(dir):getDirectiveDef(dir)).filter(def=>!!def);componentDef.pipeDefs=()=>Array.from(transitiveScopes.compilation.pipes).map(pipe=>getPipeDef$1(pipe));componentDef.schemas=transitiveScopes.schemas;componentDef.tView=null}function transitiveScopesFor(moduleType){if(!isNgModule(moduleType))throw new Error(`${moduleType.name} does not have a module def (ɵmod property)`);
const def=getNgModuleDef(moduleType);if(def.transitiveCompileScopes!==null)return def.transitiveCompileScopes;const scopes={schemas:def.schemas||null,compilation:{directives:new Set,pipes:new Set},exported:{directives:new Set,pipes:new Set}};maybeUnwrapFn(def.imports).forEach(imported=>{const importedType=imported;if(!isNgModule(importedType))throw new Error(`Importing ${importedType.name} which does not have a ɵmod property`);const importedScope=transitiveScopesFor(importedType);importedScope.exported.directives.forEach(entry=>
scopes.compilation.directives.add(entry));importedScope.exported.pipes.forEach(entry=>scopes.compilation.pipes.add(entry))});maybeUnwrapFn(def.declarations).forEach(declared=>{const declaredWithDefs=declared;if(getPipeDef$1(declaredWithDefs))scopes.compilation.pipes.add(declared);else scopes.compilation.directives.add(declared)});maybeUnwrapFn(def.exports).forEach(exported=>{const exportedType=exported;if(isNgModule(exportedType)){const exportedScope=transitiveScopesFor(exportedType);exportedScope.exported.directives.forEach(entry=>
{scopes.compilation.directives.add(entry);scopes.exported.directives.add(entry)});exportedScope.exported.pipes.forEach(entry=>{scopes.compilation.pipes.add(entry);scopes.exported.pipes.add(entry)})}else if(getPipeDef$1(exportedType))scopes.exported.pipes.add(exportedType);else scopes.exported.directives.add(exportedType)});def.transitiveCompileScopes=scopes;return scopes}function expandModuleWithProviders(value){if(isModuleWithProviders(value))return value.ngModule;return value}function isModuleWithProviders(value){return value.ngModule!==
undefined}function isNgModule(value){return!!getNgModuleDef(value)}let compilationDepth=0;function compileComponent(type,metadata){(typeof ngDevMode==="undefined"||ngDevMode)&&initNgDevMode();let ngComponentDef=null;maybeQueueResolutionOfComponentResources(type,metadata);addDirectiveFactoryDef(type,metadata);Object.defineProperty(type,NG_COMP_DEF,{get:()=>{if(ngComponentDef===null){const compiler=getCompilerFacade({usage:0,kind:"component",type:type});if(componentNeedsResolution(metadata)){const error=
[`Component '${type.name}' is not resolved:`];if(metadata.templateUrl)error.push(` - templateUrl: ${metadata.templateUrl}`);if(metadata.styleUrls&&metadata.styleUrls.length)error.push(` - styleUrls: ${JSON.stringify(metadata.styleUrls)}`);error.push(`Did you run and wait for 'resolveComponentResources()'?`);throw new Error(error.join("\n"));}const options=getJitOptions();let preserveWhitespaces=metadata.preserveWhitespaces;if(preserveWhitespaces===undefined)if(options!==null&&options.preserveWhitespaces!==
undefined)preserveWhitespaces=options.preserveWhitespaces;else preserveWhitespaces=false;let encapsulation=metadata.encapsulation;if(encapsulation===undefined)if(options!==null&&options.defaultEncapsulation!==undefined)encapsulation=options.defaultEncapsulation;else encapsulation=exports.ViewEncapsulation.Emulated;const templateUrl=metadata.templateUrl||`ng:///${type.name}/template.html`;const meta=Object.assign(Object.assign({},directiveMetadata(type,metadata)),{typeSourceSpan:compiler.createParseSourceSpan("Component",
type.name,templateUrl),template:metadata.template||"",preserveWhitespaces,styles:metadata.styles||EMPTY_ARRAY,animations:metadata.animations,directives:[],changeDetection:metadata.changeDetection,pipes:new Map,encapsulation,interpolation:metadata.interpolation,viewProviders:metadata.viewProviders||null});compilationDepth++;try{if(meta.usesInheritance)addDirectiveDefToUndecoratedParents(type);ngComponentDef=compiler.compileComponent(angularCoreEnv,templateUrl,meta)}finally{compilationDepth--}if(compilationDepth===
0)flushModuleScopingQueueAsMuchAsPossible();if(hasSelectorScope(type)){const scopes=transitiveScopesFor(type.ngSelectorScope);patchComponentDefWithScope(ngComponentDef,scopes)}}return ngComponentDef},configurable:!!ngDevMode})}function hasSelectorScope(component){return component.ngSelectorScope!==undefined}function compileDirective(type,directive){let ngDirectiveDef=null;addDirectiveFactoryDef(type,directive||{});Object.defineProperty(type,NG_DIR_DEF,{get:()=>{if(ngDirectiveDef===null){const meta=
getDirectiveMetadata(type,directive||{});const compiler=getCompilerFacade({usage:0,kind:"directive",type});ngDirectiveDef=compiler.compileDirective(angularCoreEnv,meta.sourceMapUrl,meta.metadata)}return ngDirectiveDef},configurable:!!ngDevMode})}function getDirectiveMetadata(type,metadata){const name=type&&type.name;const sourceMapUrl=`ng:///${name}/ɵdir.js`;const compiler=getCompilerFacade({usage:0,kind:"directive",type});const facade=directiveMetadata(type,metadata);facade.typeSourceSpan=compiler.createParseSourceSpan("Directive",
name,sourceMapUrl);if(facade.usesInheritance)addDirectiveDefToUndecoratedParents(type);return{metadata:facade,sourceMapUrl}}function addDirectiveFactoryDef(type,metadata){let ngFactoryDef=null;Object.defineProperty(type,NG_FACTORY_DEF,{get:()=>{if(ngFactoryDef===null){const meta=getDirectiveMetadata(type,metadata);const compiler=getCompilerFacade({usage:0,kind:"directive",type});ngFactoryDef=compiler.compileFactory(angularCoreEnv,`ng:///${type.name}/ɵfac.js`,{name:meta.metadata.name,type:meta.metadata.type,
typeArgumentCount:0,deps:reflectDependencies(type),target:compiler.FactoryTarget.Directive})}return ngFactoryDef},configurable:!!ngDevMode})}function extendsDirectlyFromObject(type){return Object.getPrototypeOf(type.prototype)===Object.prototype}function directiveMetadata(type,metadata){const reflect=getReflect();const propMetadata=reflect.ownPropMetadata(type);return{name:type.name,type:type,selector:metadata.selector!==undefined?metadata.selector:null,host:metadata.host||EMPTY_OBJ,propMetadata:propMetadata,
inputs:metadata.inputs||EMPTY_ARRAY,outputs:metadata.outputs||EMPTY_ARRAY,queries:extractQueriesMetadata(type,propMetadata,isContentQuery),lifecycle:{usesOnChanges:reflect.hasLifecycleHook(type,"ngOnChanges")},typeSourceSpan:null,usesInheritance:!extendsDirectlyFromObject(type),exportAs:extractExportAs(metadata.exportAs),providers:metadata.providers||null,viewQueries:extractQueriesMetadata(type,propMetadata,isViewQuery)}}function addDirectiveDefToUndecoratedParents(type){const objPrototype=Object.prototype;
let parent=Object.getPrototypeOf(type.prototype).constructor;while(parent&&parent!==objPrototype){if(!getDirectiveDef(parent)&&!getComponentDef(parent)&&shouldAddAbstractDirective(parent))compileDirective(parent,null);parent=Object.getPrototypeOf(parent)}}function convertToR3QueryPredicate(selector){return typeof selector==="string"?splitByComma(selector):resolveForwardRef(selector)}function convertToR3QueryMetadata(propertyName,ann){return{propertyName:propertyName,predicate:convertToR3QueryPredicate(ann.selector),
descendants:ann.descendants,first:ann.first,read:ann.read?ann.read:null,static:!!ann.static,emitDistinctChangesOnly:!!ann.emitDistinctChangesOnly}}function extractQueriesMetadata(type,propMetadata,isQueryAnn){const queriesMeta=[];for(const field in propMetadata)if(propMetadata.hasOwnProperty(field)){const annotations=propMetadata[field];annotations.forEach(ann=>{if(isQueryAnn(ann)){if(!ann.selector)throw new Error(`Can't construct a query for the property "${field}" of `+`"${stringifyForError(type)}" since the query selector wasn't defined.`);
if(annotations.some(isInputAnnotation))throw new Error(`Cannot combine @Input decorators with query decorators`);queriesMeta.push(convertToR3QueryMetadata(field,ann))}})}return queriesMeta}function extractExportAs(exportAs){return exportAs===undefined?null:splitByComma(exportAs)}function isContentQuery(value){const name=value.ngMetadataName;return name==="ContentChild"||name==="ContentChildren"}function isViewQuery(value){const name=value.ngMetadataName;return name==="ViewChild"||name==="ViewChildren"}
function isInputAnnotation(value){return value.ngMetadataName==="Input"}function splitByComma(value){return value.split(",").map(piece=>piece.trim())}const LIFECYCLE_HOOKS=["ngOnChanges","ngOnInit","ngOnDestroy","ngDoCheck","ngAfterViewInit","ngAfterViewChecked","ngAfterContentInit","ngAfterContentChecked"];function shouldAddAbstractDirective(type){const reflect=getReflect();if(LIFECYCLE_HOOKS.some(hookName=>reflect.hasLifecycleHook(type,hookName)))return true;const propMetadata=reflect.propMetadata(type);
for(const field in propMetadata){const annotations=propMetadata[field];for(let i=0;i<annotations.length;i++){const current=annotations[i];const metadataName=current.ngMetadataName;if(isInputAnnotation(current)||isContentQuery(current)||isViewQuery(current)||metadataName==="Output"||metadataName==="HostBinding"||metadataName==="HostListener")return true}}return false}function compilePipe(type,meta){let ngPipeDef=null;let ngFactoryDef=null;Object.defineProperty(type,NG_FACTORY_DEF,{get:()=>{if(ngFactoryDef===
null){const metadata=getPipeMetadata(type,meta);const compiler=getCompilerFacade({usage:0,kind:"pipe",type:metadata.type});ngFactoryDef=compiler.compileFactory(angularCoreEnv,`ng:///${metadata.name}/ɵfac.js`,{name:metadata.name,type:metadata.type,typeArgumentCount:0,deps:reflectDependencies(type),target:compiler.FactoryTarget.Pipe})}return ngFactoryDef},configurable:!!ngDevMode});Object.defineProperty(type,NG_PIPE_DEF,{get:()=>{if(ngPipeDef===null){const metadata=getPipeMetadata(type,meta);const compiler=
getCompilerFacade({usage:0,kind:"pipe",type:metadata.type});ngPipeDef=compiler.compilePipe(angularCoreEnv,`ng:///${metadata.name}/ɵpipe.js`,metadata)}return ngPipeDef},configurable:!!ngDevMode})}function getPipeMetadata(type,meta){return{type:type,name:type.name,pipeName:meta.name,pure:meta.pure!==undefined?meta.pure:true}}const Directive=makeDecorator("Directive",(dir={})=>dir,undefined,undefined,(type,meta)=>compileDirective(type,meta));const Component=makeDecorator("Component",(c={})=>Object.assign({changeDetection:exports.ChangeDetectionStrategy.Default},
c),Directive,undefined,(type,meta)=>compileComponent(type,meta));const Pipe=makeDecorator("Pipe",p=>Object.assign({pure:true},p),undefined,undefined,(type,meta)=>compilePipe(type,meta));const Input=makePropDecorator("Input",bindingPropertyName=>({bindingPropertyName}));const Output=makePropDecorator("Output",bindingPropertyName=>({bindingPropertyName}));const HostBinding=makePropDecorator("HostBinding",hostPropertyName=>({hostPropertyName}));const HostListener=makePropDecorator("HostListener",(eventName,
args)=>({eventName,args}));const NgModule=makeDecorator("NgModule",ngModule=>ngModule,undefined,undefined,(type,meta)=>compileNgModule(type,meta));function noop(...args){}const APP_INITIALIZER=new InjectionToken("Application Initializer");class ApplicationInitStatus{constructor(appInits){this.appInits=appInits;this.resolve=noop;this.reject=noop;this.initialized=false;this.done=false;this.donePromise=new Promise((res,rej)=>{this.resolve=res;this.reject=rej})}runInitializers(){if(this.initialized)return;
const asyncInitPromises=[];const complete=()=>{this.done=true;this.resolve()};if(this.appInits)for(let i=0;i<this.appInits.length;i++){const initResult=this.appInits[i]();if(isPromise(initResult))asyncInitPromises.push(initResult);else if(isObservable(initResult)){const observableAsPromise=new Promise((resolve,reject)=>{initResult.subscribe({complete:resolve,error:reject})});asyncInitPromises.push(observableAsPromise)}}Promise.all(asyncInitPromises).then(()=>{complete()}).catch(e=>{this.reject(e)});
if(asyncInitPromises.length===0)complete();this.initialized=true}}ApplicationInitStatus.\u0275fac=function ApplicationInitStatus_Factory(t){return new (t||ApplicationInitStatus)(\u0275\u0275inject(APP_INITIALIZER,8))};ApplicationInitStatus.\u0275prov=\u0275\u0275defineInjectable({token:ApplicationInitStatus,factory:ApplicationInitStatus.\u0275fac});(function(){(typeof ngDevMode==="undefined"||ngDevMode)&&setClassMetadata(ApplicationInitStatus,[{type:Injectable}],function(){return[{type:undefined,
decorators:[{type:Inject,args:[APP_INITIALIZER]},{type:Optional}]}]},null)})();const APP_ID=new InjectionToken("AppId");function _appIdRandomProviderFactory(){return`${_randomChar()}${_randomChar()}${_randomChar()}`}const APP_ID_RANDOM_PROVIDER={provide:APP_ID,useFactory:_appIdRandomProviderFactory,deps:[]};function _randomChar(){return String.fromCharCode(97+Math.floor(Math.random()*25))}const PLATFORM_INITIALIZER=new InjectionToken("Platform Initializer");const PLATFORM_ID=new InjectionToken("Platform ID");
const APP_BOOTSTRAP_LISTENER=new InjectionToken("appBootstrapListener");const PACKAGE_ROOT_URL=new InjectionToken("Application Packages Root URL");class Console{log(message){console.log(message)}warn(message){console.warn(message)}}Console.\u0275fac=function Console_Factory(t){return new (t||Console)};Console.\u0275prov=\u0275\u0275defineInjectable({token:Console,factory:Console.\u0275fac});(function(){(typeof ngDevMode==="undefined"||ngDevMode)&&setClassMetadata(Console,[{type:Injectable}],null,
null)})();const LOCALE_ID=new InjectionToken("LocaleId");const DEFAULT_CURRENCY_CODE=new InjectionToken("DefaultCurrencyCode");const TRANSLATIONS=new InjectionToken("Translations");const TRANSLATIONS_FORMAT=new InjectionToken("TranslationsFormat");exports.MissingTranslationStrategy=void 0;(function(MissingTranslationStrategy){MissingTranslationStrategy[MissingTranslationStrategy["Error"]=0]="Error";MissingTranslationStrategy[MissingTranslationStrategy["Warning"]=1]="Warning";MissingTranslationStrategy[MissingTranslationStrategy["Ignore"]=
2]="Ignore"})(exports.MissingTranslationStrategy||(exports.MissingTranslationStrategy={}));class ModuleWithComponentFactories{constructor(ngModuleFactory,componentFactories){this.ngModuleFactory=ngModuleFactory;this.componentFactories=componentFactories}}class Compiler{compileModuleSync(moduleType){return new NgModuleFactory(moduleType)}compileModuleAsync(moduleType){return Promise.resolve(this.compileModuleSync(moduleType))}compileModuleAndAllComponentsSync(moduleType){const ngModuleFactory=this.compileModuleSync(moduleType);
const moduleDef=getNgModuleDef(moduleType);const componentFactories=maybeUnwrapFn(moduleDef.declarations).reduce((factories,declaration)=>{const componentDef=getComponentDef(declaration);componentDef&&factories.push(new ComponentFactory(componentDef));return factories},[]);return new ModuleWithComponentFactories(ngModuleFactory,componentFactories)}compileModuleAndAllComponentsAsync(moduleType){return Promise.resolve(this.compileModuleAndAllComponentsSync(moduleType))}clearCache(){}clearCacheFor(type){}getModuleId(moduleType){return undefined}}
Compiler.\u0275fac=function Compiler_Factory(t){return new (t||Compiler)};Compiler.\u0275prov=\u0275\u0275defineInjectable({token:Compiler,factory:Compiler.\u0275fac});(function(){(typeof ngDevMode==="undefined"||ngDevMode)&&setClassMetadata(Compiler,[{type:Injectable}],null,null)})();const COMPILER_OPTIONS=new InjectionToken("compilerOptions");class CompilerFactory{}const promise=(()=>Promise.resolve(0))();function scheduleMicroTask(fn){if(typeof Zone==="undefined")promise.then(()=>{fn&&fn.apply(null,
null)});else Zone.current.scheduleMicroTask("scheduleMicrotask",fn)}function getNativeRequestAnimationFrame(){let nativeRequestAnimationFrame=_global["requestAnimationFrame"];let nativeCancelAnimationFrame=_global["cancelAnimationFrame"];if(typeof Zone!=="undefined"&&nativeRequestAnimationFrame&&nativeCancelAnimationFrame){const unpatchedRequestAnimationFrame=nativeRequestAnimationFrame[Zone.__symbol__("OriginalDelegate")];if(unpatchedRequestAnimationFrame)nativeRequestAnimationFrame=unpatchedRequestAnimationFrame;
const unpatchedCancelAnimationFrame=nativeCancelAnimationFrame[Zone.__symbol__("OriginalDelegate")];if(unpatchedCancelAnimationFrame)nativeCancelAnimationFrame=unpatchedCancelAnimationFrame}return{nativeRequestAnimationFrame,nativeCancelAnimationFrame}}class NgZone{constructor({enableLongStackTrace=false,shouldCoalesceEventChangeDetection=false,shouldCoalesceRunChangeDetection=false}){this.hasPendingMacrotasks=false;this.hasPendingMicrotasks=false;this.isStable=true;this.onUnstable=new EventEmitter(false);
this.onMicrotaskEmpty=new EventEmitter(false);this.onStable=new EventEmitter(false);this.onError=new EventEmitter(false);if(typeof Zone=="undefined")throw new Error(`In this configuration Angular requires Zone.js`);Zone.assertZonePatched();const self=this;self._nesting=0;self._outer=self._inner=Zone.current;if(Zone["TaskTrackingZoneSpec"])self._inner=self._inner.fork(new Zone["TaskTrackingZoneSpec"]);if(enableLongStackTrace&&Zone["longStackTraceZoneSpec"])self._inner=self._inner.fork(Zone["longStackTraceZoneSpec"]);
self.shouldCoalesceEventChangeDetection=!shouldCoalesceRunChangeDetection&&shouldCoalesceEventChangeDetection;self.shouldCoalesceRunChangeDetection=shouldCoalesceRunChangeDetection;self.lastRequestAnimationFrameId=-1;self.nativeRequestAnimationFrame=getNativeRequestAnimationFrame().nativeRequestAnimationFrame;forkInnerZoneWithAngularBehavior(self)}static isInAngularZone(){return Zone.current.get("isAngularZone")===true}static assertInAngularZone(){if(!NgZone.isInAngularZone())throw new Error("Expected to be in Angular Zone, but it is not!");
}static assertNotInAngularZone(){if(NgZone.isInAngularZone())throw new Error("Expected to not be in Angular Zone, but it is!");}run(fn,applyThis,applyArgs){return this._inner.run(fn,applyThis,applyArgs)}runTask(fn,applyThis,applyArgs,name){const zone=this._inner;const task=zone.scheduleEventTask("NgZoneEvent: "+name,fn,EMPTY_PAYLOAD,noop,noop);try{return zone.runTask(task,applyThis,applyArgs)}finally{zone.cancelTask(task)}}runGuarded(fn,applyThis,applyArgs){return this._inner.runGuarded(fn,applyThis,
applyArgs)}runOutsideAngular(fn){return this._outer.run(fn)}}const EMPTY_PAYLOAD={};function checkStable(zone){if(zone._nesting==0&&!zone.hasPendingMicrotasks&&!zone.isStable)try{zone._nesting++;zone.onMicrotaskEmpty.emit(null)}finally{zone._nesting--;if(!zone.hasPendingMicrotasks)try{zone.runOutsideAngular(()=>zone.onStable.emit(null))}finally{zone.isStable=true}}}function delayChangeDetectionForEvents(zone){if(zone.isCheckStableRunning||zone.lastRequestAnimationFrameId!==-1)return;zone.lastRequestAnimationFrameId=
zone.nativeRequestAnimationFrame.call(_global,()=>{if(!zone.fakeTopEventTask)zone.fakeTopEventTask=Zone.root.scheduleEventTask("fakeTopEventTask",()=>{zone.lastRequestAnimationFrameId=-1;updateMicroTaskStatus(zone);zone.isCheckStableRunning=true;checkStable(zone);zone.isCheckStableRunning=false},undefined,()=>{},()=>{});zone.fakeTopEventTask.invoke()});updateMicroTaskStatus(zone)}function forkInnerZoneWithAngularBehavior(zone){const delayChangeDetectionForEventsDelegate=()=>{delayChangeDetectionForEvents(zone)};
zone._inner=zone._inner.fork({name:"angular",properties:{"isAngularZone":true},onInvokeTask:(delegate,current,target,task,applyThis,applyArgs)=>{try{onEnter(zone);return delegate.invokeTask(target,task,applyThis,applyArgs)}finally{if(zone.shouldCoalesceEventChangeDetection&&task.type==="eventTask"||zone.shouldCoalesceRunChangeDetection)delayChangeDetectionForEventsDelegate();onLeave(zone)}},onInvoke:(delegate,current,target,callback,applyThis,applyArgs,source)=>{try{onEnter(zone);return delegate.invoke(target,
callback,applyThis,applyArgs,source)}finally{if(zone.shouldCoalesceRunChangeDetection)delayChangeDetectionForEventsDelegate();onLeave(zone)}},onHasTask:(delegate,current,target,hasTaskState)=>{delegate.hasTask(target,hasTaskState);if(current===target)if(hasTaskState.change=="microTask"){zone._hasPendingMicrotasks=hasTaskState.microTask;updateMicroTaskStatus(zone);checkStable(zone)}else if(hasTaskState.change=="macroTask")zone.hasPendingMacrotasks=hasTaskState.macroTask},onHandleError:(delegate,current,
target,error)=>{delegate.handleError(target,error);zone.runOutsideAngular(()=>zone.onError.emit(error));return false}})}function updateMicroTaskStatus(zone){if(zone._hasPendingMicrotasks||(zone.shouldCoalesceEventChangeDetection||zone.shouldCoalesceRunChangeDetection)&&zone.lastRequestAnimationFrameId!==-1)zone.hasPendingMicrotasks=true;else zone.hasPendingMicrotasks=false}function onEnter(zone){zone._nesting++;if(zone.isStable){zone.isStable=false;zone.onUnstable.emit(null)}}function onLeave(zone){zone._nesting--;
checkStable(zone)}class NoopNgZone{constructor(){this.hasPendingMicrotasks=false;this.hasPendingMacrotasks=false;this.isStable=true;this.onUnstable=new EventEmitter;this.onMicrotaskEmpty=new EventEmitter;this.onStable=new EventEmitter;this.onError=new EventEmitter}run(fn,applyThis,applyArgs){return fn.apply(applyThis,applyArgs)}runGuarded(fn,applyThis,applyArgs){return fn.apply(applyThis,applyArgs)}runOutsideAngular(fn){return fn()}runTask(fn,applyThis,applyArgs,name){return fn.apply(applyThis,applyArgs)}}
class Testability{constructor(_ngZone){this._ngZone=_ngZone;this._pendingCount=0;this._isZoneStable=true;this._didWork=false;this._callbacks=[];this.taskTrackingZone=null;this._watchAngularEvents();_ngZone.run(()=>{this.taskTrackingZone=typeof Zone=="undefined"?null:Zone.current.get("TaskTrackingZone")})}_watchAngularEvents(){this._ngZone.onUnstable.subscribe({next:()=>{this._didWork=true;this._isZoneStable=false}});this._ngZone.runOutsideAngular(()=>{this._ngZone.onStable.subscribe({next:()=>{NgZone.assertNotInAngularZone();
scheduleMicroTask(()=>{this._isZoneStable=true;this._runCallbacksIfReady()})}})})}increasePendingRequestCount(){this._pendingCount+=1;this._didWork=true;return this._pendingCount}decreasePendingRequestCount(){this._pendingCount-=1;if(this._pendingCount<0)throw new Error("pending async requests below zero");this._runCallbacksIfReady();return this._pendingCount}isStable(){return this._isZoneStable&&this._pendingCount===0&&!this._ngZone.hasPendingMacrotasks}_runCallbacksIfReady(){if(this.isStable())scheduleMicroTask(()=>
{while(this._callbacks.length!==0){let cb=this._callbacks.pop();clearTimeout(cb.timeoutId);cb.doneCb(this._didWork)}this._didWork=false});else{let pending=this.getPendingTasks();this._callbacks=this._callbacks.filter(cb=>{if(cb.updateCb&&cb.updateCb(pending)){clearTimeout(cb.timeoutId);return false}return true});this._didWork=true}}getPendingTasks(){if(!this.taskTrackingZone)return[];return this.taskTrackingZone.macroTasks.map(t=>{return{source:t.source,creationLocation:t.creationLocation,data:t.data}})}addCallback(cb,
timeout,updateCb){let timeoutId=-1;if(timeout&&timeout>0)timeoutId=setTimeout(()=>{this._callbacks=this._callbacks.filter(cb=>cb.timeoutId!==timeoutId);cb(this._didWork,this.getPendingTasks())},timeout);this._callbacks.push({doneCb:cb,timeoutId:timeoutId,updateCb:updateCb})}whenStable(doneCb,timeout,updateCb){if(updateCb&&!this.taskTrackingZone)throw new Error("Task tracking zone is required when passing an update callback to "+'whenStable(). Is "zone.js/plugins/task-tracking" loaded?');this.addCallback(doneCb,
timeout,updateCb);this._runCallbacksIfReady()}getPendingRequestCount(){return this._pendingCount}findProviders(using,provider,exactMatch){return[]}}Testability.\u0275fac=function Testability_Factory(t){return new (t||Testability)(\u0275\u0275inject(NgZone))};Testability.\u0275prov=\u0275\u0275defineInjectable({token:Testability,factory:Testability.\u0275fac});(function(){(typeof ngDevMode==="undefined"||ngDevMode)&&setClassMetadata(Testability,[{type:Injectable}],function(){return[{type:NgZone}]},
null)})();class TestabilityRegistry{constructor(){this._applications=new Map;_testabilityGetter.addToWindow(this)}registerApplication(token,testability){this._applications.set(token,testability)}unregisterApplication(token){this._applications.delete(token)}unregisterAllApplications(){this._applications.clear()}getTestability(elem){return this._applications.get(elem)||null}getAllTestabilities(){return Array.from(this._applications.values())}getAllRootElements(){return Array.from(this._applications.keys())}findTestabilityInTree(elem,
findInAncestors=true){return _testabilityGetter.findTestabilityInTree(this,elem,findInAncestors)}}TestabilityRegistry.\u0275fac=function TestabilityRegistry_Factory(t){return new (t||TestabilityRegistry)};TestabilityRegistry.\u0275prov=\u0275\u0275defineInjectable({token:TestabilityRegistry,factory:TestabilityRegistry.\u0275fac});(function(){(typeof ngDevMode==="undefined"||ngDevMode)&&setClassMetadata(TestabilityRegistry,[{type:Injectable}],function(){return[]},null)})();class _NoopGetTestability{addToWindow(registry){}findTestabilityInTree(registry,
elem,findInAncestors){return null}}function setTestabilityGetter(getter){_testabilityGetter=getter}let _testabilityGetter=new _NoopGetTestability;let _platform;function compileNgModuleFactory(injector,options,moduleType){ngDevMode&&assertNgModuleType(moduleType);const moduleFactory=new NgModuleFactory(moduleType);if(typeof ngJitMode!=="undefined"&&!ngJitMode)return Promise.resolve(moduleFactory);const compilerOptions=injector.get(COMPILER_OPTIONS,[]).concat(options);setJitOptions({defaultEncapsulation:_lastDefined(compilerOptions.map(opts=>
opts.defaultEncapsulation)),preserveWhitespaces:_lastDefined(compilerOptions.map(opts=>opts.preserveWhitespaces))});if(isComponentResourceResolutionQueueEmpty())return Promise.resolve(moduleFactory);const compilerProviders=_mergeArrays(compilerOptions.map(o=>o.providers));if(compilerProviders.length===0)return Promise.resolve(moduleFactory);const compiler=getCompilerFacade({usage:0,kind:"NgModule",type:moduleType});const compilerInjector=Injector.create({providers:compilerProviders});const resourceLoader=
compilerInjector.get(compiler.ResourceLoader);return resolveComponentResources(url=>Promise.resolve(resourceLoader.get(url))).then(()=>moduleFactory)}function publishDefaultGlobalUtils(){ngDevMode&&publishDefaultGlobalUtils$1()}function isBoundToModule(cf){return cf.isBoundToModule}const ALLOW_MULTIPLE_PLATFORMS=new InjectionToken("AllowMultipleToken");class NgProbeToken{constructor(name,token){this.name=name;this.token=token}}function createPlatform(injector){if(_platform&&!_platform.destroyed&&
!_platform.injector.get(ALLOW_MULTIPLE_PLATFORMS,false)){const errorMessage=typeof ngDevMode==="undefined"||ngDevMode?"There can be only one platform. Destroy the previous one to create a new one.":"";throw new RuntimeError(400,errorMessage);}publishDefaultGlobalUtils();_platform=injector.get(PlatformRef);const inits=injector.get(PLATFORM_INITIALIZER,null);if(inits)inits.forEach(init=>init());return _platform}function createPlatformFactory(parentPlatformFactory,name,providers=[]){const desc=`Platform: ${name}`;
const marker=new InjectionToken(desc);return(extraProviders=[])=>{let platform=getPlatform();if(!platform||platform.injector.get(ALLOW_MULTIPLE_PLATFORMS,false))if(parentPlatformFactory)parentPlatformFactory(providers.concat(extraProviders).concat({provide:marker,useValue:true}));else{const injectedProviders=providers.concat(extraProviders).concat({provide:marker,useValue:true},{provide:INJECTOR_SCOPE,useValue:"platform"});createPlatform(Injector.create({providers:injectedProviders,name:desc}))}return assertPlatform(marker)}}
function assertPlatform(requiredToken){const platform=getPlatform();if(!platform){const errorMessage=typeof ngDevMode==="undefined"||ngDevMode?"No platform exists!":"";throw new RuntimeError(401,errorMessage);}if((typeof ngDevMode==="undefined"||ngDevMode)&&!platform.injector.get(requiredToken,null))throw new RuntimeError(400,"A platform with a different configuration has been created. Please destroy it first.");return platform}function destroyPlatform(){if(_platform&&!_platform.destroyed)_platform.destroy()}
function getPlatform(){return _platform&&!_platform.destroyed?_platform:null}class PlatformRef{constructor(_injector){this._injector=_injector;this._modules=[];this._destroyListeners=[];this._destroyed=false}bootstrapModuleFactory(moduleFactory,options){const ngZoneOption=options?options.ngZone:undefined;const ngZoneEventCoalescing=options&&options.ngZoneEventCoalescing||false;const ngZoneRunCoalescing=options&&options.ngZoneRunCoalescing||false;const ngZone=getNgZone(ngZoneOption,{ngZoneEventCoalescing,
ngZoneRunCoalescing});const providers=[{provide:NgZone,useValue:ngZone}];return ngZone.run(()=>{const ngZoneInjector=Injector.create({providers:providers,parent:this.injector,name:moduleFactory.moduleType.name});const moduleRef=moduleFactory.create(ngZoneInjector);const exceptionHandler=moduleRef.injector.get(ErrorHandler,null);if(!exceptionHandler){const errorMessage=typeof ngDevMode==="undefined"||ngDevMode?"No ErrorHandler. Is platform module (BrowserModule) included?":"";throw new RuntimeError(402,
errorMessage);}ngZone.runOutsideAngular(()=>{const subscription=ngZone.onError.subscribe({next:error=>{exceptionHandler.handleError(error)}});moduleRef.onDestroy(()=>{remove(this._modules,moduleRef);subscription.unsubscribe()})});return _callAndReportToErrorHandler(exceptionHandler,ngZone,()=>{const initStatus=moduleRef.injector.get(ApplicationInitStatus);initStatus.runInitializers();return initStatus.donePromise.then(()=>{const localeId=moduleRef.injector.get(LOCALE_ID,DEFAULT_LOCALE_ID);setLocaleId(localeId||
DEFAULT_LOCALE_ID);this._moduleDoBootstrap(moduleRef);return moduleRef})})})}bootstrapModule(moduleType,compilerOptions=[]){const options=optionsReducer({},compilerOptions);return compileNgModuleFactory(this.injector,options,moduleType).then(moduleFactory=>this.bootstrapModuleFactory(moduleFactory,options))}_moduleDoBootstrap(moduleRef){const appRef=moduleRef.injector.get(ApplicationRef);if(moduleRef._bootstrapComponents.length>0)moduleRef._bootstrapComponents.forEach(f=>appRef.bootstrap(f));else if(moduleRef.instance.ngDoBootstrap)moduleRef.instance.ngDoBootstrap(appRef);
else{const errorMessage=typeof ngDevMode==="undefined"||ngDevMode?`The module ${stringify(moduleRef.instance.constructor)} was bootstrapped, `+`but it does not declare "@NgModule.bootstrap" components nor a "ngDoBootstrap" method. `+`Please define one of these.`:"";throw new RuntimeError(403,errorMessage);}this._modules.push(moduleRef)}onDestroy(callback){this._destroyListeners.push(callback)}get injector(){return this._injector}destroy(){if(this._destroyed){const errorMessage=typeof ngDevMode===
"undefined"||ngDevMode?"The platform has already been destroyed!":"";throw new RuntimeError(404,errorMessage);}this._modules.slice().forEach(module=>module.destroy());this._destroyListeners.forEach(listener=>listener());this._destroyed=true}get destroyed(){return this._destroyed}}PlatformRef.\u0275fac=function PlatformRef_Factory(t){return new (t||PlatformRef)(\u0275\u0275inject(Injector))};PlatformRef.\u0275prov=\u0275\u0275defineInjectable({token:PlatformRef,factory:PlatformRef.\u0275fac});(function(){(typeof ngDevMode===
"undefined"||ngDevMode)&&setClassMetadata(PlatformRef,[{type:Injectable}],function(){return[{type:Injector}]},null)})();function getNgZone(ngZoneOption,extra){let ngZone;if(ngZoneOption==="noop")ngZone=new NoopNgZone;else ngZone=(ngZoneOption==="zone.js"?undefined:ngZoneOption)||new NgZone({enableLongStackTrace:typeof ngDevMode==="undefined"?false:!!ngDevMode,shouldCoalesceEventChangeDetection:!!(extra===null||extra===void 0?void 0:extra.ngZoneEventCoalescing),shouldCoalesceRunChangeDetection:!!(extra===
null||extra===void 0?void 0:extra.ngZoneRunCoalescing)});return ngZone}function _callAndReportToErrorHandler(errorHandler,ngZone,callback){try{const result=callback();if(isPromise(result))return result.catch(e=>{ngZone.runOutsideAngular(()=>errorHandler.handleError(e));throw e;});return result}catch(e){ngZone.runOutsideAngular(()=>errorHandler.handleError(e));throw e;}}function optionsReducer(dst,objs){if(Array.isArray(objs))dst=objs.reduce(optionsReducer,dst);else dst=Object.assign(Object.assign({},
dst),objs);return dst}class ApplicationRef{constructor(_zone,_injector,_exceptionHandler,_componentFactoryResolver,_initStatus){this._zone=_zone;this._injector=_injector;this._exceptionHandler=_exceptionHandler;this._componentFactoryResolver=_componentFactoryResolver;this._initStatus=_initStatus;this._bootstrapListeners=[];this._views=[];this._runningTick=false;this._stable=true;this.componentTypes=[];this.components=[];this._onMicrotaskEmptySubscription=this._zone.onMicrotaskEmpty.subscribe({next:()=>
{this._zone.run(()=>{this.tick()})}});const isCurrentlyStable=new rxjs.Observable(observer=>{this._stable=this._zone.isStable&&!this._zone.hasPendingMacrotasks&&!this._zone.hasPendingMicrotasks;this._zone.runOutsideAngular(()=>{observer.next(this._stable);observer.complete()})});const isStable=new rxjs.Observable(observer=>{let stableSub;this._zone.runOutsideAngular(()=>{stableSub=this._zone.onStable.subscribe(()=>{NgZone.assertNotInAngularZone();scheduleMicroTask(()=>{if(!this._stable&&!this._zone.hasPendingMacrotasks&&
!this._zone.hasPendingMicrotasks){this._stable=true;observer.next(true)}})})});const unstableSub=this._zone.onUnstable.subscribe(()=>{NgZone.assertInAngularZone();if(this._stable){this._stable=false;this._zone.runOutsideAngular(()=>{observer.next(false)})}});return()=>{stableSub.unsubscribe();unstableSub.unsubscribe()}});this.isStable=rxjs.merge(isCurrentlyStable,isStable.pipe(operators.share()))}bootstrap(componentOrFactory,rootSelectorOrNode){if(!this._initStatus.done){const errorMessage=typeof ngDevMode===
"undefined"||ngDevMode?"Cannot bootstrap as there are still asynchronous initializers running. "+"Bootstrap components in the `ngDoBootstrap` method of the root module.":"";throw new RuntimeError(405,errorMessage);}let componentFactory;if(componentOrFactory instanceof ComponentFactory$1)componentFactory=componentOrFactory;else componentFactory=this._componentFactoryResolver.resolveComponentFactory(componentOrFactory);this.componentTypes.push(componentFactory.componentType);const ngModule=isBoundToModule(componentFactory)?
undefined:this._injector.get(NgModuleRef$1);const selectorOrNode=rootSelectorOrNode||componentFactory.selector;const compRef=componentFactory.create(Injector.NULL,[],selectorOrNode,ngModule);const nativeElement=compRef.location.nativeElement;const testability=compRef.injector.get(Testability,null);const testabilityRegistry=testability&&compRef.injector.get(TestabilityRegistry);if(testability&&testabilityRegistry)testabilityRegistry.registerApplication(nativeElement,testability);compRef.onDestroy(()=>
{this.detachView(compRef.hostView);remove(this.components,compRef);if(testabilityRegistry)testabilityRegistry.unregisterApplication(nativeElement)});this._loadComponent(compRef);if(typeof ngDevMode==="undefined"||ngDevMode){const _console=this._injector.get(Console);_console.log(`Angular is running in development mode. Call enableProdMode() to enable production mode.`)}return compRef}tick(){if(this._runningTick){const errorMessage=typeof ngDevMode==="undefined"||ngDevMode?"ApplicationRef.tick is called recursively":
"";throw new RuntimeError(101,errorMessage);}try{this._runningTick=true;for(let view of this._views)view.detectChanges();if(typeof ngDevMode==="undefined"||ngDevMode)for(let view of this._views)view.checkNoChanges()}catch(e){this._zone.runOutsideAngular(()=>this._exceptionHandler.handleError(e))}finally{this._runningTick=false}}attachView(viewRef){const view=viewRef;this._views.push(view);view.attachToAppRef(this)}detachView(viewRef){const view=viewRef;remove(this._views,view);view.detachFromAppRef()}_loadComponent(componentRef){this.attachView(componentRef.hostView);
this.tick();this.components.push(componentRef);const listeners=this._injector.get(APP_BOOTSTRAP_LISTENER,[]).concat(this._bootstrapListeners);listeners.forEach(listener=>listener(componentRef))}ngOnDestroy(){this._views.slice().forEach(view=>view.destroy());this._onMicrotaskEmptySubscription.unsubscribe()}get viewCount(){return this._views.length}}ApplicationRef.\u0275fac=function ApplicationRef_Factory(t){return new (t||ApplicationRef)(\u0275\u0275inject(NgZone),\u0275\u0275inject(Injector),\u0275\u0275inject(ErrorHandler),
\u0275\u0275inject(ComponentFactoryResolver$1),\u0275\u0275inject(ApplicationInitStatus))};ApplicationRef.\u0275prov=\u0275\u0275defineInjectable({token:ApplicationRef,factory:ApplicationRef.\u0275fac});(function(){(typeof ngDevMode==="undefined"||ngDevMode)&&setClassMetadata(ApplicationRef,[{type:Injectable}],function(){return[{type:NgZone},{type:Injector},{type:ErrorHandler},{type:ComponentFactoryResolver$1},{type:ApplicationInitStatus}]},null)})();function remove(list,el){const index=list.indexOf(el);
if(index>-1)list.splice(index,1)}function _lastDefined(args){for(let i=args.length-1;i>=0;i--)if(args[i]!==undefined)return args[i];return undefined}function _mergeArrays(parts){const result=[];parts.forEach(part=>part&&result.push(...part));return result}let _devMode=true;let _runModeLocked=false;function isDevMode(){_runModeLocked=true;return _devMode}function enableProdMode(){if(_runModeLocked)throw new Error("Cannot enable prod mode after platform setup.");if(typeof ngDevMode===undefined||!!ngDevMode)_global["ngDevMode"]=
false;_devMode=false}function getModuleFactory(id){const type=getRegisteredNgModuleType(id);if(!type)throw noModuleError(id);return new NgModuleFactory(type)}function getNgModuleById(id){const type=getRegisteredNgModuleType(id);if(!type)throw noModuleError(id);return type}function noModuleError(id){return new Error(`No module with ID ${id} loaded`)}class ChangeDetectorRef{}ChangeDetectorRef.__NG_ELEMENT_ID__=injectChangeDetectorRef;function injectChangeDetectorRef(flags){return createViewRef(getCurrentTNode(),
getLView(),(flags&16)===16)}function createViewRef(tNode,lView,isPipe){if(isComponentHost(tNode)&&!isPipe){const componentView=getComponentLViewByIndex(tNode.index,lView);return new ViewRef$1(componentView,componentView)}else if(tNode.type&(3|12|32)){const hostComponentView=lView[DECLARATION_COMPONENT_VIEW];return new ViewRef$1(hostComponentView,lView)}return null}class ViewRef extends ChangeDetectorRef{}class EmbeddedViewRef extends ViewRef{}class DebugEventListener{constructor(name,callback){this.name=
name;this.callback=callback}}function asNativeElements(debugEls){return debugEls.map(el=>el.nativeElement)}class DebugNode__POST_R3__{constructor(nativeNode){this.nativeNode=nativeNode}get parent(){const parent=this.nativeNode.parentNode;return parent?new DebugElement__POST_R3__(parent):null}get injector(){return getInjector(this.nativeNode)}get componentInstance(){const nativeElement=this.nativeNode;return nativeElement&&(getComponent$1(nativeElement)||getOwningComponent(nativeElement))}get context(){return getComponent$1(this.nativeNode)||
getContext(this.nativeNode)}get listeners(){return getListeners(this.nativeNode).filter(listener=>listener.type==="dom")}get references(){return getLocalRefs(this.nativeNode)}get providerTokens(){return getInjectionTokens(this.nativeNode)}}class DebugElement__POST_R3__ extends DebugNode__POST_R3__{constructor(nativeNode){ngDevMode&&assertDomNode(nativeNode);super(nativeNode)}get nativeElement(){return this.nativeNode.nodeType==Node.ELEMENT_NODE?this.nativeNode:null}get name(){const context=getLContext(this.nativeNode);
if(context!==null){const lView=context.lView;const tData=lView[TVIEW].data;const tNode=tData[context.nodeIndex];return tNode.value}else return this.nativeNode.nodeName}get properties(){const context=getLContext(this.nativeNode);if(context===null)return{};const lView=context.lView;const tData=lView[TVIEW].data;const tNode=tData[context.nodeIndex];const properties={};copyDomProperties(this.nativeElement,properties);collectPropertyBindings(properties,tNode,lView,tData);return properties}get attributes(){const attributes=
{};const element=this.nativeElement;if(!element)return attributes;const context=getLContext(element);if(context===null)return{};const lView=context.lView;const tNodeAttrs=lView[TVIEW].data[context.nodeIndex].attrs;const lowercaseTNodeAttrs=[];if(tNodeAttrs){let i=0;while(i<tNodeAttrs.length){const attrName=tNodeAttrs[i];if(typeof attrName!=="string")break;const attrValue=tNodeAttrs[i+1];attributes[attrName]=attrValue;lowercaseTNodeAttrs.push(attrName.toLowerCase());i+=2}}const eAttrs=element.attributes;
for(let i=0;i<eAttrs.length;i++){const attr=eAttrs[i];const lowercaseName=attr.name.toLowerCase();if(lowercaseTNodeAttrs.indexOf(lowercaseName)===-1)attributes[lowercaseName]=attr.value}return attributes}get styles(){if(this.nativeElement&&this.nativeElement.style)return this.nativeElement.style;return{}}get classes(){const result={};const element=this.nativeElement;const className=element.className;const classes=typeof className!=="string"?className.baseVal.split(" "):className.split(" ");classes.forEach(value=>
result[value]=true);return result}get childNodes(){const childNodes=this.nativeNode.childNodes;const children=[];for(let i=0;i<childNodes.length;i++){const element=childNodes[i];children.push(getDebugNode__POST_R3__(element))}return children}get children(){const nativeElement=this.nativeElement;if(!nativeElement)return[];const childNodes=nativeElement.children;const children=[];for(let i=0;i<childNodes.length;i++){const element=childNodes[i];children.push(getDebugNode__POST_R3__(element))}return children}query(predicate){const results=
this.queryAll(predicate);return results[0]||null}queryAll(predicate){const matches=[];_queryAllR3(this,predicate,matches,true);return matches}queryAllNodes(predicate){const matches=[];_queryAllR3(this,predicate,matches,false);return matches}triggerEventHandler(eventName,eventObj){const node=this.nativeNode;const invokedListeners=[];this.listeners.forEach(listener=>{if(listener.name===eventName){const callback=listener.callback;callback.call(node,eventObj);invokedListeners.push(callback)}});if(typeof node.eventListeners===
"function")node.eventListeners(eventName).forEach(listener=>{if(listener.toString().indexOf("__ngUnwrap__")!==-1){const unwrappedListener=listener("__ngUnwrap__");return invokedListeners.indexOf(unwrappedListener)===-1&&unwrappedListener.call(node,eventObj)}})}}function copyDomProperties(element,properties){if(element){let obj=Object.getPrototypeOf(element);const NodePrototype=Node.prototype;while(obj!==null&&obj!==NodePrototype){const descriptors=Object.getOwnPropertyDescriptors(obj);for(let key in descriptors)if(!key.startsWith("__")&&
!key.startsWith("on")){const value=element[key];if(isPrimitiveValue(value))properties[key]=value}obj=Object.getPrototypeOf(obj)}}}function isPrimitiveValue(value){return typeof value==="string"||typeof value==="boolean"||typeof value==="number"||value===null}function _queryAllR3(parentElement,predicate,matches,elementsOnly){const context=getLContext(parentElement.nativeNode);if(context!==null){const parentTNode=context.lView[TVIEW].data[context.nodeIndex];_queryNodeChildrenR3(parentTNode,context.lView,
predicate,matches,elementsOnly,parentElement.nativeNode)}else _queryNativeNodeDescendants(parentElement.nativeNode,predicate,matches,elementsOnly)}function _queryNodeChildrenR3(tNode,lView,predicate,matches,elementsOnly,rootNativeNode){ngDevMode&&assertTNodeForLView(tNode,lView);const nativeNode=getNativeByTNodeOrNull(tNode,lView);if(tNode.type&(3|8)){_addQueryMatchR3(nativeNode,predicate,matches,elementsOnly,rootNativeNode);if(isComponentHost(tNode)){const componentView=getComponentLViewByIndex(tNode.index,
lView);if(componentView&&componentView[TVIEW].firstChild)_queryNodeChildrenR3(componentView[TVIEW].firstChild,componentView,predicate,matches,elementsOnly,rootNativeNode)}else{if(tNode.child)_queryNodeChildrenR3(tNode.child,lView,predicate,matches,elementsOnly,rootNativeNode);nativeNode&&_queryNativeNodeDescendants(nativeNode,predicate,matches,elementsOnly)}const nodeOrContainer=lView[tNode.index];if(isLContainer(nodeOrContainer))_queryNodeChildrenInContainerR3(nodeOrContainer,predicate,matches,elementsOnly,
rootNativeNode)}else if(tNode.type&4){const lContainer=lView[tNode.index];_addQueryMatchR3(lContainer[NATIVE],predicate,matches,elementsOnly,rootNativeNode);_queryNodeChildrenInContainerR3(lContainer,predicate,matches,elementsOnly,rootNativeNode)}else if(tNode.type&16){const componentView=lView[DECLARATION_COMPONENT_VIEW];const componentHost=componentView[T_HOST];const head=componentHost.projection[tNode.projection];if(Array.isArray(head))for(let nativeNode of head)_addQueryMatchR3(nativeNode,predicate,
matches,elementsOnly,rootNativeNode);else if(head){const nextLView=componentView[PARENT];const nextTNode=nextLView[TVIEW].data[head.index];_queryNodeChildrenR3(nextTNode,nextLView,predicate,matches,elementsOnly,rootNativeNode)}}else if(tNode.child)_queryNodeChildrenR3(tNode.child,lView,predicate,matches,elementsOnly,rootNativeNode);if(rootNativeNode!==nativeNode){const nextTNode=tNode.flags&4?tNode.projectionNext:tNode.next;if(nextTNode)_queryNodeChildrenR3(nextTNode,lView,predicate,matches,elementsOnly,
rootNativeNode)}}function _queryNodeChildrenInContainerR3(lContainer,predicate,matches,elementsOnly,rootNativeNode){for(let i=CONTAINER_HEADER_OFFSET;i<lContainer.length;i++){const childView=lContainer[i];const firstChild=childView[TVIEW].firstChild;if(firstChild)_queryNodeChildrenR3(firstChild,childView,predicate,matches,elementsOnly,rootNativeNode)}}function _addQueryMatchR3(nativeNode,predicate,matches,elementsOnly,rootNativeNode){if(rootNativeNode!==nativeNode){const debugNode=getDebugNode(nativeNode);
if(!debugNode)return;if(elementsOnly&&debugNode instanceof DebugElement__POST_R3__&&predicate(debugNode)&&matches.indexOf(debugNode)===-1)matches.push(debugNode);else if(!elementsOnly&&predicate(debugNode)&&matches.indexOf(debugNode)===-1)matches.push(debugNode)}}function _queryNativeNodeDescendants(parentNode,predicate,matches,elementsOnly){const nodes=parentNode.childNodes;const length=nodes.length;for(let i=0;i<length;i++){const node=nodes[i];const debugNode=getDebugNode(node);if(debugNode){if(elementsOnly&&
debugNode instanceof DebugElement__POST_R3__&&predicate(debugNode)&&matches.indexOf(debugNode)===-1)matches.push(debugNode);else if(!elementsOnly&&predicate(debugNode)&&matches.indexOf(debugNode)===-1)matches.push(debugNode);_queryNativeNodeDescendants(node,predicate,matches,elementsOnly)}}}function collectPropertyBindings(properties,tNode,lView,tData){let bindingIndexes=tNode.propertyBindings;if(bindingIndexes!==null)for(let i=0;i<bindingIndexes.length;i++){const bindingIndex=bindingIndexes[i];const propMetadata=
tData[bindingIndex];const metadataParts=propMetadata.split(INTERPOLATION_DELIMITER);const propertyName=metadataParts[0];if(metadataParts.length>1){let value=metadataParts[1];for(let j=1;j<metadataParts.length-1;j++)value+=renderStringify(lView[bindingIndex+j-1])+metadataParts[j+1];properties[propertyName]=value}else properties[propertyName]=lView[bindingIndex]}}const NG_DEBUG_PROPERTY="__ng_debug__";function getDebugNode__POST_R3__(nativeNode){if(nativeNode instanceof Node){if(!nativeNode.hasOwnProperty(NG_DEBUG_PROPERTY))nativeNode[NG_DEBUG_PROPERTY]=
nativeNode.nodeType==Node.ELEMENT_NODE?new DebugElement__POST_R3__(nativeNode):new DebugNode__POST_R3__(nativeNode);return nativeNode[NG_DEBUG_PROPERTY]}return null}const getDebugNode=getDebugNode__POST_R3__;function getDebugNodeR2__POST_R3__(_nativeNode){return null}const getDebugNodeR2=getDebugNodeR2__POST_R3__;const DebugNode=DebugNode__POST_R3__;const DebugElement=DebugElement__POST_R3__;class DefaultIterableDifferFactory{constructor(){}supports(obj){return isListLikeIterable(obj)}create(trackByFn){return new DefaultIterableDiffer(trackByFn)}}
const trackByIdentity=(index,item)=>item;class DefaultIterableDiffer{constructor(trackByFn){this.length=0;this._linkedRecords=null;this._unlinkedRecords=null;this._previousItHead=null;this._itHead=null;this._itTail=null;this._additionsHead=null;this._additionsTail=null;this._movesHead=null;this._movesTail=null;this._removalsHead=null;this._removalsTail=null;this._identityChangesHead=null;this._identityChangesTail=null;this._trackByFn=trackByFn||trackByIdentity}forEachItem(fn){let record;for(record=
this._itHead;record!==null;record=record._next)fn(record)}forEachOperation(fn){let nextIt=this._itHead;let nextRemove=this._removalsHead;let addRemoveOffset=0;let moveOffsets=null;while(nextIt||nextRemove){const record=!nextRemove||nextIt&&nextIt.currentIndex<getPreviousIndex(nextRemove,addRemoveOffset,moveOffsets)?nextIt:nextRemove;const adjPreviousIndex=getPreviousIndex(record,addRemoveOffset,moveOffsets);const currentIndex=record.currentIndex;if(record===nextRemove){addRemoveOffset--;nextRemove=
nextRemove._nextRemoved}else{nextIt=nextIt._next;if(record.previousIndex==null)addRemoveOffset++;else{if(!moveOffsets)moveOffsets=[];const localMovePreviousIndex=adjPreviousIndex-addRemoveOffset;const localCurrentIndex=currentIndex-addRemoveOffset;if(localMovePreviousIndex!=localCurrentIndex){for(let i=0;i<localMovePreviousIndex;i++){const offset=i<moveOffsets.length?moveOffsets[i]:moveOffsets[i]=0;const index=offset+i;if(localCurrentIndex<=index&&index<localMovePreviousIndex)moveOffsets[i]=offset+
1}const previousIndex=record.previousIndex;moveOffsets[previousIndex]=localCurrentIndex-localMovePreviousIndex}}}if(adjPreviousIndex!==currentIndex)fn(record,adjPreviousIndex,currentIndex)}}forEachPreviousItem(fn){let record;for(record=this._previousItHead;record!==null;record=record._nextPrevious)fn(record)}forEachAddedItem(fn){let record;for(record=this._additionsHead;record!==null;record=record._nextAdded)fn(record)}forEachMovedItem(fn){let record;for(record=this._movesHead;record!==null;record=
record._nextMoved)fn(record)}forEachRemovedItem(fn){let record;for(record=this._removalsHead;record!==null;record=record._nextRemoved)fn(record)}forEachIdentityChange(fn){let record;for(record=this._identityChangesHead;record!==null;record=record._nextIdentityChange)fn(record)}diff(collection){if(collection==null)collection=[];if(!isListLikeIterable(collection)){const errorMessage=typeof ngDevMode==="undefined"||ngDevMode?`Error trying to diff '${stringify(collection)}'. Only arrays and iterables are allowed`:
"";throw new RuntimeError(900,errorMessage);}if(this.check(collection))return this;else return null}onDestroy(){}check(collection){this._reset();let record=this._itHead;let mayBeDirty=false;let index;let item;let itemTrackBy;if(Array.isArray(collection)){this.length=collection.length;for(let index=0;index<this.length;index++){item=collection[index];itemTrackBy=this._trackByFn(index,item);if(record===null||!Object.is(record.trackById,itemTrackBy)){record=this._mismatch(record,item,itemTrackBy,index);
mayBeDirty=true}else{if(mayBeDirty)record=this._verifyReinsertion(record,item,itemTrackBy,index);if(!Object.is(record.item,item))this._addIdentityChange(record,item)}record=record._next}}else{index=0;iterateListLike(collection,item=>{itemTrackBy=this._trackByFn(index,item);if(record===null||!Object.is(record.trackById,itemTrackBy)){record=this._mismatch(record,item,itemTrackBy,index);mayBeDirty=true}else{if(mayBeDirty)record=this._verifyReinsertion(record,item,itemTrackBy,index);if(!Object.is(record.item,
item))this._addIdentityChange(record,item)}record=record._next;index++});this.length=index}this._truncate(record);this.collection=collection;return this.isDirty}get isDirty(){return this._additionsHead!==null||this._movesHead!==null||this._removalsHead!==null||this._identityChangesHead!==null}_reset(){if(this.isDirty){let record;for(record=this._previousItHead=this._itHead;record!==null;record=record._next)record._nextPrevious=record._next;for(record=this._additionsHead;record!==null;record=record._nextAdded)record.previousIndex=
record.currentIndex;this._additionsHead=this._additionsTail=null;for(record=this._movesHead;record!==null;record=record._nextMoved)record.previousIndex=record.currentIndex;this._movesHead=this._movesTail=null;this._removalsHead=this._removalsTail=null;this._identityChangesHead=this._identityChangesTail=null}}_mismatch(record,item,itemTrackBy,index){let previousRecord;if(record===null)previousRecord=this._itTail;else{previousRecord=record._prev;this._remove(record)}record=this._unlinkedRecords===null?
null:this._unlinkedRecords.get(itemTrackBy,null);if(record!==null){if(!Object.is(record.item,item))this._addIdentityChange(record,item);this._reinsertAfter(record,previousRecord,index)}else{record=this._linkedRecords===null?null:this._linkedRecords.get(itemTrackBy,index);if(record!==null){if(!Object.is(record.item,item))this._addIdentityChange(record,item);this._moveAfter(record,previousRecord,index)}else record=this._addAfter(new IterableChangeRecord_(item,itemTrackBy),previousRecord,index)}return record}_verifyReinsertion(record,
item,itemTrackBy,index){let reinsertRecord=this._unlinkedRecords===null?null:this._unlinkedRecords.get(itemTrackBy,null);if(reinsertRecord!==null)record=this._reinsertAfter(reinsertRecord,record._prev,index);else if(record.currentIndex!=index){record.currentIndex=index;this._addToMoves(record,index)}return record}_truncate(record){while(record!==null){const nextRecord=record._next;this._addToRemovals(this._unlink(record));record=nextRecord}if(this._unlinkedRecords!==null)this._unlinkedRecords.clear();
if(this._additionsTail!==null)this._additionsTail._nextAdded=null;if(this._movesTail!==null)this._movesTail._nextMoved=null;if(this._itTail!==null)this._itTail._next=null;if(this._removalsTail!==null)this._removalsTail._nextRemoved=null;if(this._identityChangesTail!==null)this._identityChangesTail._nextIdentityChange=null}_reinsertAfter(record,prevRecord,index){if(this._unlinkedRecords!==null)this._unlinkedRecords.remove(record);const prev=record._prevRemoved;const next=record._nextRemoved;if(prev===
null)this._removalsHead=next;else prev._nextRemoved=next;if(next===null)this._removalsTail=prev;else next._prevRemoved=prev;this._insertAfter(record,prevRecord,index);this._addToMoves(record,index);return record}_moveAfter(record,prevRecord,index){this._unlink(record);this._insertAfter(record,prevRecord,index);this._addToMoves(record,index);return record}_addAfter(record,prevRecord,index){this._insertAfter(record,prevRecord,index);if(this._additionsTail===null)this._additionsTail=this._additionsHead=
record;else this._additionsTail=this._additionsTail._nextAdded=record;return record}_insertAfter(record,prevRecord,index){const next=prevRecord===null?this._itHead:prevRecord._next;record._next=next;record._prev=prevRecord;if(next===null)this._itTail=record;else next._prev=record;if(prevRecord===null)this._itHead=record;else prevRecord._next=record;if(this._linkedRecords===null)this._linkedRecords=new _DuplicateMap;this._linkedRecords.put(record);record.currentIndex=index;return record}_remove(record){return this._addToRemovals(this._unlink(record))}_unlink(record){if(this._linkedRecords!==
null)this._linkedRecords.remove(record);const prev=record._prev;const next=record._next;if(prev===null)this._itHead=next;else prev._next=next;if(next===null)this._itTail=prev;else next._prev=prev;return record}_addToMoves(record,toIndex){if(record.previousIndex===toIndex)return record;if(this._movesTail===null)this._movesTail=this._movesHead=record;else this._movesTail=this._movesTail._nextMoved=record;return record}_addToRemovals(record){if(this._unlinkedRecords===null)this._unlinkedRecords=new _DuplicateMap;
this._unlinkedRecords.put(record);record.currentIndex=null;record._nextRemoved=null;if(this._removalsTail===null){this._removalsTail=this._removalsHead=record;record._prevRemoved=null}else{record._prevRemoved=this._removalsTail;this._removalsTail=this._removalsTail._nextRemoved=record}return record}_addIdentityChange(record,item){record.item=item;if(this._identityChangesTail===null)this._identityChangesTail=this._identityChangesHead=record;else this._identityChangesTail=this._identityChangesTail._nextIdentityChange=
record;return record}}class IterableChangeRecord_{constructor(item,trackById){this.item=item;this.trackById=trackById;this.currentIndex=null;this.previousIndex=null;this._nextPrevious=null;this._prev=null;this._next=null;this._prevDup=null;this._nextDup=null;this._prevRemoved=null;this._nextRemoved=null;this._nextAdded=null;this._nextMoved=null;this._nextIdentityChange=null}}class _DuplicateItemRecordList{constructor(){this._head=null;this._tail=null}add(record){if(this._head===null){this._head=this._tail=
record;record._nextDup=null;record._prevDup=null}else{this._tail._nextDup=record;record._prevDup=this._tail;record._nextDup=null;this._tail=record}}get(trackById,atOrAfterIndex){let record;for(record=this._head;record!==null;record=record._nextDup)if((atOrAfterIndex===null||atOrAfterIndex<=record.currentIndex)&&Object.is(record.trackById,trackById))return record;return null}remove(record){const prev=record._prevDup;const next=record._nextDup;if(prev===null)this._head=next;else prev._nextDup=next;
if(next===null)this._tail=prev;else next._prevDup=prev;return this._head===null}}class _DuplicateMap{constructor(){this.map=new Map}put(record){const key=record.trackById;let duplicates=this.map.get(key);if(!duplicates){duplicates=new _DuplicateItemRecordList;this.map.set(key,duplicates)}duplicates.add(record)}get(trackById,atOrAfterIndex){const key=trackById;const recordList=this.map.get(key);return recordList?recordList.get(trackById,atOrAfterIndex):null}remove(record){const key=record.trackById;
const recordList=this.map.get(key);if(recordList.remove(record))this.map.delete(key);return record}get isEmpty(){return this.map.size===0}clear(){this.map.clear()}}function getPreviousIndex(item,addRemoveOffset,moveOffsets){const previousIndex=item.previousIndex;if(previousIndex===null)return previousIndex;let moveOffset=0;if(moveOffsets&&previousIndex<moveOffsets.length)moveOffset=moveOffsets[previousIndex];return previousIndex+addRemoveOffset+moveOffset}class DefaultKeyValueDifferFactory{constructor(){}supports(obj){return obj instanceof
Map||isJsObject(obj)}create(){return new DefaultKeyValueDiffer}}class DefaultKeyValueDiffer{constructor(){this._records=new Map;this._mapHead=null;this._appendAfter=null;this._previousMapHead=null;this._changesHead=null;this._changesTail=null;this._additionsHead=null;this._additionsTail=null;this._removalsHead=null;this._removalsTail=null}get isDirty(){return this._additionsHead!==null||this._changesHead!==null||this._removalsHead!==null}forEachItem(fn){let record;for(record=this._mapHead;record!==
null;record=record._next)fn(record)}forEachPreviousItem(fn){let record;for(record=this._previousMapHead;record!==null;record=record._nextPrevious)fn(record)}forEachChangedItem(fn){let record;for(record=this._changesHead;record!==null;record=record._nextChanged)fn(record)}forEachAddedItem(fn){let record;for(record=this._additionsHead;record!==null;record=record._nextAdded)fn(record)}forEachRemovedItem(fn){let record;for(record=this._removalsHead;record!==null;record=record._nextRemoved)fn(record)}diff(map){if(!map)map=
new Map;else if(!(map instanceof Map||isJsObject(map))){const errorMessage=typeof ngDevMode==="undefined"||ngDevMode?`Error trying to diff '${stringify(map)}'. Only maps and objects are allowed`:"";throw new RuntimeError(900,errorMessage);}return this.check(map)?this:null}onDestroy(){}check(map){this._reset();let insertBefore=this._mapHead;this._appendAfter=null;this._forEach(map,(value,key)=>{if(insertBefore&&insertBefore.key===key){this._maybeAddToChanges(insertBefore,value);this._appendAfter=insertBefore;
insertBefore=insertBefore._next}else{const record=this._getOrCreateRecordForKey(key,value);insertBefore=this._insertBeforeOrAppend(insertBefore,record)}});if(insertBefore){if(insertBefore._prev)insertBefore._prev._next=null;this._removalsHead=insertBefore;for(let record=insertBefore;record!==null;record=record._nextRemoved){if(record===this._mapHead)this._mapHead=null;this._records.delete(record.key);record._nextRemoved=record._next;record.previousValue=record.currentValue;record.currentValue=null;
record._prev=null;record._next=null}}if(this._changesTail)this._changesTail._nextChanged=null;if(this._additionsTail)this._additionsTail._nextAdded=null;return this.isDirty}_insertBeforeOrAppend(before,record){if(before){const prev=before._prev;record._next=before;record._prev=prev;before._prev=record;if(prev)prev._next=record;if(before===this._mapHead)this._mapHead=record;this._appendAfter=before;return before}if(this._appendAfter){this._appendAfter._next=record;record._prev=this._appendAfter}else this._mapHead=
record;this._appendAfter=record;return null}_getOrCreateRecordForKey(key,value){if(this._records.has(key)){const record=this._records.get(key);this._maybeAddToChanges(record,value);const prev=record._prev;const next=record._next;if(prev)prev._next=next;if(next)next._prev=prev;record._next=null;record._prev=null;return record}const record=new KeyValueChangeRecord_(key);this._records.set(key,record);record.currentValue=value;this._addToAdditions(record);return record}_reset(){if(this.isDirty){let record;
this._previousMapHead=this._mapHead;for(record=this._previousMapHead;record!==null;record=record._next)record._nextPrevious=record._next;for(record=this._changesHead;record!==null;record=record._nextChanged)record.previousValue=record.currentValue;for(record=this._additionsHead;record!=null;record=record._nextAdded)record.previousValue=record.currentValue;this._changesHead=this._changesTail=null;this._additionsHead=this._additionsTail=null;this._removalsHead=null}}_maybeAddToChanges(record,newValue){if(!Object.is(newValue,
record.currentValue)){record.previousValue=record.currentValue;record.currentValue=newValue;this._addToChanges(record)}}_addToAdditions(record){if(this._additionsHead===null)this._additionsHead=this._additionsTail=record;else{this._additionsTail._nextAdded=record;this._additionsTail=record}}_addToChanges(record){if(this._changesHead===null)this._changesHead=this._changesTail=record;else{this._changesTail._nextChanged=record;this._changesTail=record}}_forEach(obj,fn){if(obj instanceof Map)obj.forEach(fn);
else Object.keys(obj).forEach(k=>fn(obj[k],k))}}class KeyValueChangeRecord_{constructor(key){this.key=key;this.previousValue=null;this.currentValue=null;this._nextPrevious=null;this._next=null;this._prev=null;this._nextAdded=null;this._nextRemoved=null;this._nextChanged=null}}function defaultIterableDiffersFactory(){return new IterableDiffers([new DefaultIterableDifferFactory])}class IterableDiffers{constructor(factories){this.factories=factories}static create(factories,parent){if(parent!=null){const copied=
parent.factories.slice();factories=factories.concat(copied)}return new IterableDiffers(factories)}static extend(factories){return{provide:IterableDiffers,useFactory:parent=>{return IterableDiffers.create(factories,parent||defaultIterableDiffersFactory())},deps:[[IterableDiffers,new SkipSelf,new Optional]]}}find(iterable){const factory=this.factories.find(f=>f.supports(iterable));if(factory!=null)return factory;else{const errorMessage=typeof ngDevMode==="undefined"||ngDevMode?`Cannot find a differ supporting object '${iterable}' of type '${getTypeNameForDebugging(iterable)}'`:
"";throw new RuntimeError(901,errorMessage);}}}IterableDiffers.\u0275prov=\u0275\u0275defineInjectable({token:IterableDiffers,providedIn:"root",factory:defaultIterableDiffersFactory});function getTypeNameForDebugging(type){return type["name"]||typeof type}function defaultKeyValueDiffersFactory(){return new KeyValueDiffers([new DefaultKeyValueDifferFactory])}class KeyValueDiffers{constructor(factories){this.factories=factories}static create(factories,parent){if(parent){const copied=parent.factories.slice();
factories=factories.concat(copied)}return new KeyValueDiffers(factories)}static extend(factories){return{provide:KeyValueDiffers,useFactory:parent=>{return KeyValueDiffers.create(factories,parent||defaultKeyValueDiffersFactory())},deps:[[KeyValueDiffers,new SkipSelf,new Optional]]}}find(kv){const factory=this.factories.find(f=>f.supports(kv));if(factory)return factory;const errorMessage=typeof ngDevMode==="undefined"||ngDevMode?`Cannot find a differ supporting object '${kv}'`:"";throw new RuntimeError(901,
errorMessage);}}KeyValueDiffers.\u0275prov=\u0275\u0275defineInjectable({token:KeyValueDiffers,providedIn:"root",factory:defaultKeyValueDiffersFactory});const keyValDiff=[new DefaultKeyValueDifferFactory];const iterableDiff=[new DefaultIterableDifferFactory];const defaultIterableDiffers=new IterableDiffers(iterableDiff);const defaultKeyValueDiffers=new KeyValueDiffers(keyValDiff);const _CORE_PLATFORM_PROVIDERS=[{provide:PLATFORM_ID,useValue:"unknown"},{provide:PlatformRef,deps:[Injector]},{provide:TestabilityRegistry,
deps:[]},{provide:Console,deps:[]}];const platformCore=createPlatformFactory(null,"core",_CORE_PLATFORM_PROVIDERS);function _iterableDiffersFactory(){return defaultIterableDiffers}function _keyValueDiffersFactory(){return defaultKeyValueDiffers}function _localeFactory(locale){return locale||getGlobalLocale()}function getGlobalLocale(){if(typeof ngI18nClosureMode!=="undefined"&&ngI18nClosureMode&&typeof goog!=="undefined"&&goog.getLocale()!=="en")return goog.getLocale();else return typeof $localize!==
"undefined"&&$localize.locale||DEFAULT_LOCALE_ID}const APPLICATION_MODULE_PROVIDERS=[{provide:ApplicationRef,useClass:ApplicationRef,deps:[NgZone,Injector,ErrorHandler,ComponentFactoryResolver$1,ApplicationInitStatus]},{provide:SCHEDULER,deps:[NgZone],useFactory:zoneSchedulerFactory},{provide:ApplicationInitStatus,useClass:ApplicationInitStatus,deps:[[new Optional,APP_INITIALIZER]]},{provide:Compiler,useClass:Compiler,deps:[]},APP_ID_RANDOM_PROVIDER,{provide:IterableDiffers,useFactory:_iterableDiffersFactory,
deps:[]},{provide:KeyValueDiffers,useFactory:_keyValueDiffersFactory,deps:[]},{provide:LOCALE_ID,useFactory:_localeFactory,deps:[[new Inject(LOCALE_ID),new Optional,new SkipSelf]]},{provide:DEFAULT_CURRENCY_CODE,useValue:USD_CURRENCY_CODE}];function zoneSchedulerFactory(ngZone){let queue=[];ngZone.onStable.subscribe(()=>{while(queue.length)queue.pop()()});return function(fn){queue.push(fn)}}class ApplicationModule{constructor(appRef){}}ApplicationModule.\u0275fac=function ApplicationModule_Factory(t){return new (t||
ApplicationModule)(\u0275\u0275inject(ApplicationRef))};ApplicationModule.\u0275mod=\u0275\u0275defineNgModule({type:ApplicationModule});ApplicationModule.\u0275inj=\u0275\u0275defineInjector({providers:APPLICATION_MODULE_PROVIDERS});(function(){(typeof ngDevMode==="undefined"||ngDevMode)&&setClassMetadata(ApplicationModule,[{type:NgModule,args:[{providers:APPLICATION_MODULE_PROVIDERS}]}],function(){return[{type:ApplicationRef}]},null)})();const \u0275ivyEnabled=true;function \u0275\u0275ngDeclareDirective(decl){const compiler=
getCompilerFacade({usage:1,kind:"directive",type:decl.type});return compiler.compileDirectiveDeclaration(angularCoreEnv,`ng:///${decl.type.name}/ɵfac.js`,decl)}function \u0275\u0275ngDeclareClassMetadata(decl){var _a,_b;setClassMetadata(decl.type,decl.decorators,(_a=decl.ctorParameters)!==null&&_a!==void 0?_a:null,(_b=decl.propDecorators)!==null&&_b!==void 0?_b:null)}function \u0275\u0275ngDeclareComponent(decl){const compiler=getCompilerFacade({usage:1,kind:"component",type:decl.type});return compiler.compileComponentDeclaration(angularCoreEnv,
`ng:///${decl.type.name}/ɵcmp.js`,decl)}function \u0275\u0275ngDeclareFactory(decl){const compiler=getCompilerFacade({usage:1,kind:getFactoryKind(decl.target),type:decl.type});return compiler.compileFactoryDeclaration(angularCoreEnv,`ng:///${decl.type.name}/ɵfac.js`,decl)}function getFactoryKind(target){switch(target){case exports["ɵɵFactoryTarget"].Directive:return"directive";case exports["ɵɵFactoryTarget"].Component:return"component";case exports["ɵɵFactoryTarget"].Injectable:return"injectable";
case exports["ɵɵFactoryTarget"].Pipe:return"pipe";case exports["ɵɵFactoryTarget"].NgModule:return"NgModule"}}function \u0275\u0275ngDeclareInjectable(decl){const compiler=getCompilerFacade({usage:1,kind:"injectable",type:decl.type});return compiler.compileInjectableDeclaration(angularCoreEnv,`ng:///${decl.type.name}/ɵprov.js`,decl)}function \u0275\u0275ngDeclareInjector(decl){const compiler=getCompilerFacade({usage:1,kind:"NgModule",type:decl.type});return compiler.compileInjectorDeclaration(angularCoreEnv,
`ng:///${decl.type.name}/ɵinj.js`,decl)}function \u0275\u0275ngDeclareNgModule(decl){const compiler=getCompilerFacade({usage:1,kind:"NgModule",type:decl.type});return compiler.compileNgModuleDeclaration(angularCoreEnv,`ng:///${decl.type.name}/ɵmod.js`,decl)}function \u0275\u0275ngDeclarePipe(decl){const compiler=getCompilerFacade({usage:1,kind:"pipe",type:decl.type});return compiler.compilePipeDeclaration(angularCoreEnv,`ng:///${decl.type.name}/ɵpipe.js`,decl)}if(typeof ngDevMode!=="undefined"&&ngDevMode)_global.$localize=
_global.$localize||function(){throw new Error("It looks like your application or one of its dependencies is using i18n.\n"+"Angular 9 introduced a global `$localize()` function that needs to be loaded.\n"+"Please run `ng add @angular/localize` from the Angular CLI.\n"+"(For non-CLI projects, add `import '@angular/localize/init';` to your `polyfills.ts` file.\n"+"For server-side rendering applications add the import to your `main.server.ts` file.)");};exports.ANALYZE_FOR_ENTRY_COMPONENTS=ANALYZE_FOR_ENTRY_COMPONENTS;
exports.APP_BOOTSTRAP_LISTENER=APP_BOOTSTRAP_LISTENER;exports.APP_ID=APP_ID;exports.APP_INITIALIZER=APP_INITIALIZER;exports.ApplicationInitStatus=ApplicationInitStatus;exports.ApplicationModule=ApplicationModule;exports.ApplicationRef=ApplicationRef;exports.Attribute=Attribute;exports.COMPILER_OPTIONS=COMPILER_OPTIONS;exports.CUSTOM_ELEMENTS_SCHEMA=CUSTOM_ELEMENTS_SCHEMA;exports.ChangeDetectorRef=ChangeDetectorRef;exports.Compiler=Compiler;exports.CompilerFactory=CompilerFactory;exports.Component=
Component;exports.ComponentFactory=ComponentFactory$1;exports.ComponentFactoryResolver=ComponentFactoryResolver$1;exports.ComponentRef=ComponentRef$1;exports.ContentChild=ContentChild;exports.ContentChildren=ContentChildren;exports.DEFAULT_CURRENCY_CODE=DEFAULT_CURRENCY_CODE;exports.DebugElement=DebugElement;exports.DebugEventListener=DebugEventListener;exports.DebugNode=DebugNode;exports.DefaultIterableDiffer=DefaultIterableDiffer;exports.Directive=Directive;exports.ElementRef=ElementRef;exports.EmbeddedViewRef=
EmbeddedViewRef;exports.ErrorHandler=ErrorHandler;exports.EventEmitter=EventEmitter;exports.Host=Host;exports.HostBinding=HostBinding;exports.HostListener=HostListener;exports.INJECTOR=INJECTOR;exports.Inject=Inject;exports.Injectable=Injectable;exports.InjectionToken=InjectionToken;exports.Injector=Injector;exports.Input=Input;exports.IterableDiffers=IterableDiffers;exports.KeyValueDiffers=KeyValueDiffers;exports.LOCALE_ID=LOCALE_ID;exports.ModuleWithComponentFactories=ModuleWithComponentFactories;
exports.NO_ERRORS_SCHEMA=NO_ERRORS_SCHEMA;exports.NgModule=NgModule;exports.NgModuleFactory=NgModuleFactory$1;exports.NgModuleRef=NgModuleRef$1;exports.NgProbeToken=NgProbeToken;exports.NgZone=NgZone;exports.Optional=Optional;exports.Output=Output;exports.PACKAGE_ROOT_URL=PACKAGE_ROOT_URL;exports.PLATFORM_ID=PLATFORM_ID;exports.PLATFORM_INITIALIZER=PLATFORM_INITIALIZER;exports.Pipe=Pipe;exports.PlatformRef=PlatformRef;exports.Query=Query;exports.QueryList=QueryList;exports.ReflectiveInjector=ReflectiveInjector;
exports.ReflectiveKey=ReflectiveKey;exports.Renderer2=Renderer2;exports.RendererFactory2=RendererFactory2;exports.ResolvedReflectiveFactory=ResolvedReflectiveFactory;exports.Sanitizer=Sanitizer;exports.Self=Self;exports.SimpleChange=SimpleChange;exports.SkipSelf=SkipSelf;exports.TRANSLATIONS=TRANSLATIONS;exports.TRANSLATIONS_FORMAT=TRANSLATIONS_FORMAT;exports.TemplateRef=TemplateRef;exports.Testability=Testability;exports.TestabilityRegistry=TestabilityRegistry;exports.Type=Type;exports.VERSION=VERSION;
exports.Version=Version;exports.ViewChild=ViewChild;exports.ViewChildren=ViewChildren;exports.ViewContainerRef=ViewContainerRef;exports.ViewRef=ViewRef;exports.asNativeElements=asNativeElements;exports.assertPlatform=assertPlatform;exports.createNgModuleRef=createNgModuleRef;exports.createPlatform=createPlatform;exports.createPlatformFactory=createPlatformFactory;exports.defineInjectable=defineInjectable;exports.destroyPlatform=destroyPlatform;exports.enableProdMode=enableProdMode;exports.forwardRef=
forwardRef;exports.getDebugNode=getDebugNode;exports.getModuleFactory=getModuleFactory;exports.getNgModuleById=getNgModuleById;exports.getPlatform=getPlatform;exports.inject=inject;exports.isDevMode=isDevMode;exports.platformCore=platformCore;exports.resolveForwardRef=resolveForwardRef;exports.setTestabilityGetter=setTestabilityGetter;exports["ɵALLOW_MULTIPLE_PLATFORMS"]=ALLOW_MULTIPLE_PLATFORMS;exports["ɵAPP_ID_RANDOM_PROVIDER"]=APP_ID_RANDOM_PROVIDER;exports["ɵComponentFactory"]=ComponentFactory$1;
exports["ɵConsole"]=Console;exports["ɵDEFAULT_LOCALE_ID"]=DEFAULT_LOCALE_ID;exports["ɵINJECTOR_SCOPE"]=INJECTOR_SCOPE;exports["ɵLifecycleHooksFeature"]=LifecycleHooksFeature;exports["ɵNG_COMP_DEF"]=NG_COMP_DEF;exports["ɵNG_DIR_DEF"]=NG_DIR_DEF;exports["ɵNG_ELEMENT_ID"]=NG_ELEMENT_ID;exports["ɵNG_INJ_DEF"]=NG_INJ_DEF;exports["ɵNG_MOD_DEF"]=NG_MOD_DEF;exports["ɵNG_PIPE_DEF"]=NG_PIPE_DEF;exports["ɵNG_PROV_DEF"]=NG_PROV_DEF;exports["ɵNOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR"]=NOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR;
exports["ɵNO_CHANGE"]=NO_CHANGE;exports["ɵNgModuleFactory"]=NgModuleFactory;exports["ɵNoopNgZone"]=NoopNgZone;exports["ɵReflectionCapabilities"]=ReflectionCapabilities;exports["ɵRender3ComponentFactory"]=ComponentFactory;exports["ɵRender3ComponentRef"]=ComponentRef;exports["ɵRender3NgModuleRef"]=NgModuleRef;exports["ɵRuntimeError"]=RuntimeError;exports["ɵViewRef"]=ViewRef$1;exports["ɵ_sanitizeHtml"]=_sanitizeHtml;exports["ɵ_sanitizeUrl"]=_sanitizeUrl;exports["ɵallowSanitizationBypassAndThrow"]=allowSanitizationBypassAndThrow;
exports["ɵbypassSanitizationTrustHtml"]=bypassSanitizationTrustHtml;exports["ɵbypassSanitizationTrustResourceUrl"]=bypassSanitizationTrustResourceUrl;exports["ɵbypassSanitizationTrustScript"]=bypassSanitizationTrustScript;exports["ɵbypassSanitizationTrustStyle"]=bypassSanitizationTrustStyle;exports["ɵbypassSanitizationTrustUrl"]=bypassSanitizationTrustUrl;exports["ɵclearResolutionOfComponentResourcesQueue"]=clearResolutionOfComponentResourcesQueue;exports["ɵcompileComponent"]=compileComponent;exports["ɵcompileDirective"]=
compileDirective;exports["ɵcompileNgModule"]=compileNgModule;exports["ɵcompileNgModuleDefs"]=compileNgModuleDefs;exports["ɵcompileNgModuleFactory"]=compileNgModuleFactory;exports["ɵcompilePipe"]=compilePipe;exports["ɵcreateInjector"]=createInjector;exports["ɵdefaultIterableDiffers"]=defaultIterableDiffers;exports["ɵdefaultKeyValueDiffers"]=defaultKeyValueDiffers;exports["ɵdetectChanges"]=detectChanges;exports["ɵdevModeEqual"]=devModeEqual;exports["ɵfindLocaleData"]=findLocaleData;exports["ɵflushModuleScopingQueueAsMuchAsPossible"]=
flushModuleScopingQueueAsMuchAsPossible;exports["ɵgetDebugNode"]=getDebugNode;exports["ɵgetDebugNodeR2"]=getDebugNodeR2;exports["ɵgetDirectives"]=getDirectives;exports["ɵgetHostElement"]=getHostElement;exports["ɵgetInjectableDef"]=getInjectableDef;exports["ɵgetLContext"]=getLContext;exports["ɵgetLocaleCurrencyCode"]=getLocaleCurrencyCode;exports["ɵgetLocalePluralCase"]=getLocalePluralCase;exports["ɵgetSanitizationBypassType"]=getSanitizationBypassType;exports["ɵglobal"]=_global;exports["ɵinjectChangeDetectorRef"]=
injectChangeDetectorRef;exports["ɵisBoundToModule"]=isBoundToModule;exports["ɵisDefaultChangeDetectionStrategy"]=isDefaultChangeDetectionStrategy;exports["ɵisListLikeIterable"]=isListLikeIterable;exports["ɵisObservable"]=isObservable;exports["ɵisPromise"]=isPromise;exports["ɵisSubscribable"]=isSubscribable;exports["ɵivyEnabled"]=\u0275ivyEnabled;exports["ɵmakeDecorator"]=makeDecorator;exports["ɵmarkDirty"]=markDirty;exports["ɵnoSideEffects"]=noSideEffects;exports["ɵpatchComponentDefWithScope"]=patchComponentDefWithScope;
exports["ɵpublishDefaultGlobalUtils"]=publishDefaultGlobalUtils$1;exports["ɵpublishGlobalUtil"]=publishGlobalUtil;exports["ɵregisterLocaleData"]=registerLocaleData;exports["ɵregisterNgModuleType"]=registerNgModuleType;exports["ɵrenderComponent"]=renderComponent;exports["ɵresetCompiledComponents"]=resetCompiledComponents;exports["ɵresetJitOptions"]=resetJitOptions;exports["ɵresolveComponentResources"]=resolveComponentResources;exports["ɵsetClassMetadata"]=setClassMetadata;exports["ɵsetCurrentInjector"]=
setCurrentInjector;exports["ɵsetDocument"]=setDocument;exports["ɵsetLocaleId"]=setLocaleId;exports["ɵstore"]=store;exports["ɵstringify"]=stringify;exports["ɵtransitiveScopesFor"]=transitiveScopesFor;exports["ɵunregisterLocaleData"]=unregisterAllLocaleData;exports["ɵunwrapSafeValue"]=unwrapSafeValue;exports["ɵwhenRendered"]=whenRendered;exports["ɵɵCopyDefinitionFeature"]=\u0275\u0275CopyDefinitionFeature;exports["ɵɵInheritDefinitionFeature"]=\u0275\u0275InheritDefinitionFeature;exports["ɵɵNgOnChangesFeature"]=
\u0275\u0275NgOnChangesFeature;exports["ɵɵProvidersFeature"]=\u0275\u0275ProvidersFeature;exports["ɵɵadvance"]=\u0275\u0275advance;exports["ɵɵattribute"]=\u0275\u0275attribute;exports["ɵɵattributeInterpolate1"]=\u0275\u0275attributeInterpolate1;exports["ɵɵattributeInterpolate2"]=\u0275\u0275attributeInterpolate2;exports["ɵɵattributeInterpolate3"]=\u0275\u0275attributeInterpolate3;exports["ɵɵattributeInterpolate4"]=\u0275\u0275attributeInterpolate4;exports["ɵɵattributeInterpolate5"]=\u0275\u0275attributeInterpolate5;
exports["ɵɵattributeInterpolate6"]=\u0275\u0275attributeInterpolate6;exports["ɵɵattributeInterpolate7"]=\u0275\u0275attributeInterpolate7;exports["ɵɵattributeInterpolate8"]=\u0275\u0275attributeInterpolate8;exports["ɵɵattributeInterpolateV"]=\u0275\u0275attributeInterpolateV;exports["ɵɵclassMap"]=\u0275\u0275classMap;exports["ɵɵclassMapInterpolate1"]=\u0275\u0275classMapInterpolate1;exports["ɵɵclassMapInterpolate2"]=\u0275\u0275classMapInterpolate2;exports["ɵɵclassMapInterpolate3"]=\u0275\u0275classMapInterpolate3;
exports["ɵɵclassMapInterpolate4"]=\u0275\u0275classMapInterpolate4;exports["ɵɵclassMapInterpolate5"]=\u0275\u0275classMapInterpolate5;exports["ɵɵclassMapInterpolate6"]=\u0275\u0275classMapInterpolate6;exports["ɵɵclassMapInterpolate7"]=\u0275\u0275classMapInterpolate7;exports["ɵɵclassMapInterpolate8"]=\u0275\u0275classMapInterpolate8;exports["ɵɵclassMapInterpolateV"]=\u0275\u0275classMapInterpolateV;exports["ɵɵclassProp"]=\u0275\u0275classProp;exports["ɵɵcontentQuery"]=\u0275\u0275contentQuery;exports["ɵɵdefineComponent"]=
\u0275\u0275defineComponent;exports["ɵɵdefineDirective"]=\u0275\u0275defineDirective;exports["ɵɵdefineInjectable"]=\u0275\u0275defineInjectable;exports["ɵɵdefineInjector"]=\u0275\u0275defineInjector;exports["ɵɵdefineNgModule"]=\u0275\u0275defineNgModule;exports["ɵɵdefinePipe"]=\u0275\u0275definePipe;exports["ɵɵdirectiveInject"]=\u0275\u0275directiveInject;exports["ɵɵdisableBindings"]=\u0275\u0275disableBindings;exports["ɵɵelement"]=\u0275\u0275element;exports["ɵɵelementContainer"]=\u0275\u0275elementContainer;
exports["ɵɵelementContainerEnd"]=\u0275\u0275elementContainerEnd;exports["ɵɵelementContainerStart"]=\u0275\u0275elementContainerStart;exports["ɵɵelementEnd"]=\u0275\u0275elementEnd;exports["ɵɵelementStart"]=\u0275\u0275elementStart;exports["ɵɵenableBindings"]=\u0275\u0275enableBindings;exports["ɵɵgetCurrentView"]=\u0275\u0275getCurrentView;exports["ɵɵgetInheritedFactory"]=\u0275\u0275getInheritedFactory;exports["ɵɵhostProperty"]=\u0275\u0275hostProperty;exports["ɵɵi18n"]=\u0275\u0275i18n;exports["ɵɵi18nApply"]=
\u0275\u0275i18nApply;exports["ɵɵi18nAttributes"]=\u0275\u0275i18nAttributes;exports["ɵɵi18nEnd"]=\u0275\u0275i18nEnd;exports["ɵɵi18nExp"]=\u0275\u0275i18nExp;exports["ɵɵi18nPostprocess"]=\u0275\u0275i18nPostprocess;exports["ɵɵi18nStart"]=\u0275\u0275i18nStart;exports["ɵɵinject"]=\u0275\u0275inject;exports["ɵɵinjectAttribute"]=\u0275\u0275injectAttribute;exports["ɵɵinvalidFactory"]=\u0275\u0275invalidFactory;exports["ɵɵinvalidFactoryDep"]=\u0275\u0275invalidFactoryDep;exports["ɵɵlistener"]=\u0275\u0275listener;
exports["ɵɵloadQuery"]=\u0275\u0275loadQuery;exports["ɵɵnamespaceHTML"]=\u0275\u0275namespaceHTML;exports["ɵɵnamespaceMathML"]=\u0275\u0275namespaceMathML;exports["ɵɵnamespaceSVG"]=\u0275\u0275namespaceSVG;exports["ɵɵnextContext"]=\u0275\u0275nextContext;exports["ɵɵngDeclareClassMetadata"]=\u0275\u0275ngDeclareClassMetadata;exports["ɵɵngDeclareComponent"]=\u0275\u0275ngDeclareComponent;exports["ɵɵngDeclareDirective"]=\u0275\u0275ngDeclareDirective;exports["ɵɵngDeclareFactory"]=\u0275\u0275ngDeclareFactory;
exports["ɵɵngDeclareInjectable"]=\u0275\u0275ngDeclareInjectable;exports["ɵɵngDeclareInjector"]=\u0275\u0275ngDeclareInjector;exports["ɵɵngDeclareNgModule"]=\u0275\u0275ngDeclareNgModule;exports["ɵɵngDeclarePipe"]=\u0275\u0275ngDeclarePipe;exports["ɵɵpipe"]=\u0275\u0275pipe;exports["ɵɵpipeBind1"]=\u0275\u0275pipeBind1;exports["ɵɵpipeBind2"]=\u0275\u0275pipeBind2;exports["ɵɵpipeBind3"]=\u0275\u0275pipeBind3;exports["ɵɵpipeBind4"]=\u0275\u0275pipeBind4;exports["ɵɵpipeBindV"]=\u0275\u0275pipeBindV;exports["ɵɵprojection"]=
\u0275\u0275projection;exports["ɵɵprojectionDef"]=\u0275\u0275projectionDef;exports["ɵɵproperty"]=\u0275\u0275property;exports["ɵɵpropertyInterpolate"]=\u0275\u0275propertyInterpolate;exports["ɵɵpropertyInterpolate1"]=\u0275\u0275propertyInterpolate1;exports["ɵɵpropertyInterpolate2"]=\u0275\u0275propertyInterpolate2;exports["ɵɵpropertyInterpolate3"]=\u0275\u0275propertyInterpolate3;exports["ɵɵpropertyInterpolate4"]=\u0275\u0275propertyInterpolate4;exports["ɵɵpropertyInterpolate5"]=\u0275\u0275propertyInterpolate5;
exports["ɵɵpropertyInterpolate6"]=\u0275\u0275propertyInterpolate6;exports["ɵɵpropertyInterpolate7"]=\u0275\u0275propertyInterpolate7;exports["ɵɵpropertyInterpolate8"]=\u0275\u0275propertyInterpolate8;exports["ɵɵpropertyInterpolateV"]=\u0275\u0275propertyInterpolateV;exports["ɵɵpureFunction0"]=\u0275\u0275pureFunction0;exports["ɵɵpureFunction1"]=\u0275\u0275pureFunction1;exports["ɵɵpureFunction2"]=\u0275\u0275pureFunction2;exports["ɵɵpureFunction3"]=\u0275\u0275pureFunction3;exports["ɵɵpureFunction4"]=
\u0275\u0275pureFunction4;exports["ɵɵpureFunction5"]=\u0275\u0275pureFunction5;exports["ɵɵpureFunction6"]=\u0275\u0275pureFunction6;exports["ɵɵpureFunction7"]=\u0275\u0275pureFunction7;exports["ɵɵpureFunction8"]=\u0275\u0275pureFunction8;exports["ɵɵpureFunctionV"]=\u0275\u0275pureFunctionV;exports["ɵɵqueryRefresh"]=\u0275\u0275queryRefresh;exports["ɵɵreference"]=\u0275\u0275reference;exports["ɵɵresolveBody"]=\u0275\u0275resolveBody;exports["ɵɵresolveDocument"]=\u0275\u0275resolveDocument;exports["ɵɵresolveWindow"]=
\u0275\u0275resolveWindow;exports["ɵɵrestoreView"]=\u0275\u0275restoreView;exports["ɵɵsanitizeHtml"]=\u0275\u0275sanitizeHtml;exports["ɵɵsanitizeResourceUrl"]=\u0275\u0275sanitizeResourceUrl;exports["ɵɵsanitizeScript"]=\u0275\u0275sanitizeScript;exports["ɵɵsanitizeStyle"]=\u0275\u0275sanitizeStyle;exports["ɵɵsanitizeUrl"]=\u0275\u0275sanitizeUrl;exports["ɵɵsanitizeUrlOrResourceUrl"]=\u0275\u0275sanitizeUrlOrResourceUrl;exports["ɵɵsetComponentScope"]=\u0275\u0275setComponentScope;exports["ɵɵsetNgModuleScope"]=
\u0275\u0275setNgModuleScope;exports["ɵɵstyleMap"]=\u0275\u0275styleMap;exports["ɵɵstyleMapInterpolate1"]=\u0275\u0275styleMapInterpolate1;exports["ɵɵstyleMapInterpolate2"]=\u0275\u0275styleMapInterpolate2;exports["ɵɵstyleMapInterpolate3"]=\u0275\u0275styleMapInterpolate3;exports["ɵɵstyleMapInterpolate4"]=\u0275\u0275styleMapInterpolate4;exports["ɵɵstyleMapInterpolate5"]=\u0275\u0275styleMapInterpolate5;exports["ɵɵstyleMapInterpolate6"]=\u0275\u0275styleMapInterpolate6;exports["ɵɵstyleMapInterpolate7"]=
\u0275\u0275styleMapInterpolate7;exports["ɵɵstyleMapInterpolate8"]=\u0275\u0275styleMapInterpolate8;exports["ɵɵstyleMapInterpolateV"]=\u0275\u0275styleMapInterpolateV;exports["ɵɵstyleProp"]=\u0275\u0275styleProp;exports["ɵɵstylePropInterpolate1"]=\u0275\u0275stylePropInterpolate1;exports["ɵɵstylePropInterpolate2"]=\u0275\u0275stylePropInterpolate2;exports["ɵɵstylePropInterpolate3"]=\u0275\u0275stylePropInterpolate3;exports["ɵɵstylePropInterpolate4"]=\u0275\u0275stylePropInterpolate4;exports["ɵɵstylePropInterpolate5"]=
\u0275\u0275stylePropInterpolate5;exports["ɵɵstylePropInterpolate6"]=\u0275\u0275stylePropInterpolate6;exports["ɵɵstylePropInterpolate7"]=\u0275\u0275stylePropInterpolate7;exports["ɵɵstylePropInterpolate8"]=\u0275\u0275stylePropInterpolate8;exports["ɵɵstylePropInterpolateV"]=\u0275\u0275stylePropInterpolateV;exports["ɵɵsyntheticHostListener"]=\u0275\u0275syntheticHostListener;exports["ɵɵsyntheticHostProperty"]=\u0275\u0275syntheticHostProperty;exports["ɵɵtemplate"]=\u0275\u0275template;exports["ɵɵtemplateRefExtractor"]=
\u0275\u0275templateRefExtractor;exports["ɵɵtext"]=\u0275\u0275text;exports["ɵɵtextInterpolate"]=\u0275\u0275textInterpolate;exports["ɵɵtextInterpolate1"]=\u0275\u0275textInterpolate1;exports["ɵɵtextInterpolate2"]=\u0275\u0275textInterpolate2;exports["ɵɵtextInterpolate3"]=\u0275\u0275textInterpolate3;exports["ɵɵtextInterpolate4"]=\u0275\u0275textInterpolate4;exports["ɵɵtextInterpolate5"]=\u0275\u0275textInterpolate5;exports["ɵɵtextInterpolate6"]=\u0275\u0275textInterpolate6;exports["ɵɵtextInterpolate7"]=
\u0275\u0275textInterpolate7;exports["ɵɵtextInterpolate8"]=\u0275\u0275textInterpolate8;exports["ɵɵtextInterpolateV"]=\u0275\u0275textInterpolateV;exports["ɵɵtrustConstantHtml"]=\u0275\u0275trustConstantHtml;exports["ɵɵtrustConstantResourceUrl"]=\u0275\u0275trustConstantResourceUrl;exports["ɵɵviewQuery"]=\u0275\u0275viewQuery;Object.defineProperty(exports,"__esModule",{value:true})});

