/*

 Copyright Google LLC All Rights Reserved.

 Use of this source code is governed by an MIT-style license that can be
 found in the LICENSE file at https://angular.io/license
 Angular v13.1.3
 (c) 2010-2022 Google LLC. https://angular.io/
 License: MIT
*/
'use strict';(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports,require("@angular/core"),require("rxjs"),require("rxjs/operators"),require("@angular/common")):typeof define==="function"&&define.amd?define(["exports","@angular/core","rxjs","rxjs/operators","@angular/common"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory((global.ng=global.ng||{},global.ng.router={}),global.i0,global.rxjs,global.operators,global.i3))})(this,
function(exports,i0,rxjs,operators,i3){function _interopNamespace(e){if(e&&e.__esModule)return e;var n=Object.create(null);if(e)Object.keys(e).forEach(function(k){if(k!=="default"){var d=Object.getOwnPropertyDescriptor(e,k);Object.defineProperty(n,k,d.get?d:{enumerable:true,get:function(){return e[k]}})}});n["default"]=e;return Object.freeze(n)}var i0__namespace=_interopNamespace(i0);var i3__namespace=_interopNamespace(i3);class RouterEvent{constructor(id,url){this.id=id;this.url=url}}class NavigationStart extends RouterEvent{constructor(id,
url,navigationTrigger="imperative",restoredState=null){super(id,url);this.navigationTrigger=navigationTrigger;this.restoredState=restoredState}toString(){return`NavigationStart(id: ${this.id}, url: '${this.url}')`}}class NavigationEnd extends RouterEvent{constructor(id,url,urlAfterRedirects){super(id,url);this.urlAfterRedirects=urlAfterRedirects}toString(){return`NavigationEnd(id: ${this.id}, url: '${this.url}', urlAfterRedirects: '${this.urlAfterRedirects}')`}}class NavigationCancel extends RouterEvent{constructor(id,
url,reason){super(id,url);this.reason=reason}toString(){return`NavigationCancel(id: ${this.id}, url: '${this.url}')`}}class NavigationError extends RouterEvent{constructor(id,url,error){super(id,url);this.error=error}toString(){return`NavigationError(id: ${this.id}, url: '${this.url}', error: ${this.error})`}}class RoutesRecognized extends RouterEvent{constructor(id,url,urlAfterRedirects,state){super(id,url);this.urlAfterRedirects=urlAfterRedirects;this.state=state}toString(){return`RoutesRecognized(id: ${this.id}, url: '${this.url}', urlAfterRedirects: '${this.urlAfterRedirects}', state: ${this.state})`}}
class GuardsCheckStart extends RouterEvent{constructor(id,url,urlAfterRedirects,state){super(id,url);this.urlAfterRedirects=urlAfterRedirects;this.state=state}toString(){return`GuardsCheckStart(id: ${this.id}, url: '${this.url}', urlAfterRedirects: '${this.urlAfterRedirects}', state: ${this.state})`}}class GuardsCheckEnd extends RouterEvent{constructor(id,url,urlAfterRedirects,state,shouldActivate){super(id,url);this.urlAfterRedirects=urlAfterRedirects;this.state=state;this.shouldActivate=shouldActivate}toString(){return`GuardsCheckEnd(id: ${this.id}, url: '${this.url}', urlAfterRedirects: '${this.urlAfterRedirects}', state: ${this.state}, shouldActivate: ${this.shouldActivate})`}}
class ResolveStart extends RouterEvent{constructor(id,url,urlAfterRedirects,state){super(id,url);this.urlAfterRedirects=urlAfterRedirects;this.state=state}toString(){return`ResolveStart(id: ${this.id}, url: '${this.url}', urlAfterRedirects: '${this.urlAfterRedirects}', state: ${this.state})`}}class ResolveEnd extends RouterEvent{constructor(id,url,urlAfterRedirects,state){super(id,url);this.urlAfterRedirects=urlAfterRedirects;this.state=state}toString(){return`ResolveEnd(id: ${this.id}, url: '${this.url}', urlAfterRedirects: '${this.urlAfterRedirects}', state: ${this.state})`}}
class RouteConfigLoadStart{constructor(route){this.route=route}toString(){return`RouteConfigLoadStart(path: ${this.route.path})`}}class RouteConfigLoadEnd{constructor(route){this.route=route}toString(){return`RouteConfigLoadEnd(path: ${this.route.path})`}}class ChildActivationStart{constructor(snapshot){this.snapshot=snapshot}toString(){const path=this.snapshot.routeConfig&&this.snapshot.routeConfig.path||"";return`ChildActivationStart(path: '${path}')`}}class ChildActivationEnd{constructor(snapshot){this.snapshot=
snapshot}toString(){const path=this.snapshot.routeConfig&&this.snapshot.routeConfig.path||"";return`ChildActivationEnd(path: '${path}')`}}class ActivationStart{constructor(snapshot){this.snapshot=snapshot}toString(){const path=this.snapshot.routeConfig&&this.snapshot.routeConfig.path||"";return`ActivationStart(path: '${path}')`}}class ActivationEnd{constructor(snapshot){this.snapshot=snapshot}toString(){const path=this.snapshot.routeConfig&&this.snapshot.routeConfig.path||"";return`ActivationEnd(path: '${path}')`}}
class Scroll{constructor(routerEvent,position,anchor){this.routerEvent=routerEvent;this.position=position;this.anchor=anchor}toString(){const pos=this.position?`${this.position[0]}, ${this.position[1]}`:null;return`Scroll(anchor: '${this.anchor}', position: '${pos}')`}}const PRIMARY_OUTLET="primary";class ParamsAsMap{constructor(params){this.params=params||{}}has(name){return Object.prototype.hasOwnProperty.call(this.params,name)}get(name){if(this.has(name)){const v=this.params[name];return Array.isArray(v)?
v[0]:v}return null}getAll(name){if(this.has(name)){const v=this.params[name];return Array.isArray(v)?v:[v]}return[]}get keys(){return Object.keys(this.params)}}function convertToParamMap(params){return new ParamsAsMap(params)}const NAVIGATION_CANCELING_ERROR="ngNavigationCancelingError";function navigationCancelingError(message){const error=Error("NavigationCancelingError: "+message);error[NAVIGATION_CANCELING_ERROR]=true;return error}function isNavigationCancelingError(error){return error&&error[NAVIGATION_CANCELING_ERROR]}
function defaultUrlMatcher(segments,segmentGroup,route){const parts=route.path.split("/");if(parts.length>segments.length)return null;if(route.pathMatch==="full"&&(segmentGroup.hasChildren()||parts.length<segments.length))return null;const posParams={};for(let index=0;index<parts.length;index++){const part=parts[index];const segment=segments[index];const isParameter=part.startsWith(":");if(isParameter)posParams[part.substring(1)]=segment;else if(part!==segment.path)return null}return{consumed:segments.slice(0,
parts.length),posParams}}function shallowEqualArrays(a,b){if(a.length!==b.length)return false;for(let i=0;i<a.length;++i)if(!shallowEqual(a[i],b[i]))return false;return true}function shallowEqual(a,b){const k1=a?Object.keys(a):undefined;const k2=b?Object.keys(b):undefined;if(!k1||!k2||k1.length!=k2.length)return false;let key;for(let i=0;i<k1.length;i++){key=k1[i];if(!equalArraysOrString(a[key],b[key]))return false}return true}function equalArraysOrString(a,b){if(Array.isArray(a)&&Array.isArray(b)){if(a.length!==
b.length)return false;const aSorted=[...a].sort();const bSorted=[...b].sort();return aSorted.every((val,index)=>bSorted[index]===val)}else return a===b}function flatten(arr){return Array.prototype.concat.apply([],arr)}function last(a){return a.length>0?a[a.length-1]:null}function forEach(map,callback){for(const prop in map)if(map.hasOwnProperty(prop))callback(map[prop],prop)}function wrapIntoObservable(value){if(i0["ɵisObservable"](value))return value;if(i0["ɵisPromise"](value))return rxjs.from(Promise.resolve(value));
return rxjs.of(value)}function createEmptyUrlTree(){return new UrlTree(new UrlSegmentGroup([],{}),{},null)}const pathCompareMap={"exact":equalSegmentGroups,"subset":containsSegmentGroup};const paramCompareMap={"exact":equalParams,"subset":containsParams,"ignored":()=>true};function containsTree(container,containee,options){return pathCompareMap[options.paths](container.root,containee.root,options.matrixParams)&&paramCompareMap[options.queryParams](container.queryParams,containee.queryParams)&&!(options.fragment===
"exact"&&container.fragment!==containee.fragment)}function equalParams(container,containee){return shallowEqual(container,containee)}function equalSegmentGroups(container,containee,matrixParams){if(!equalPath(container.segments,containee.segments))return false;if(!matrixParamsMatch(container.segments,containee.segments,matrixParams))return false;if(container.numberOfChildren!==containee.numberOfChildren)return false;for(const c in containee.children){if(!container.children[c])return false;if(!equalSegmentGroups(container.children[c],
containee.children[c],matrixParams))return false}return true}function containsParams(container,containee){return Object.keys(containee).length<=Object.keys(container).length&&Object.keys(containee).every(key=>equalArraysOrString(container[key],containee[key]))}function containsSegmentGroup(container,containee,matrixParams){return containsSegmentGroupHelper(container,containee,containee.segments,matrixParams)}function containsSegmentGroupHelper(container,containee,containeePaths,matrixParams){if(container.segments.length>
containeePaths.length){const current=container.segments.slice(0,containeePaths.length);if(!equalPath(current,containeePaths))return false;if(containee.hasChildren())return false;if(!matrixParamsMatch(current,containeePaths,matrixParams))return false;return true}else if(container.segments.length===containeePaths.length){if(!equalPath(container.segments,containeePaths))return false;if(!matrixParamsMatch(container.segments,containeePaths,matrixParams))return false;for(const c in containee.children){if(!container.children[c])return false;
if(!containsSegmentGroup(container.children[c],containee.children[c],matrixParams))return false}return true}else{const current=containeePaths.slice(0,container.segments.length);const next=containeePaths.slice(container.segments.length);if(!equalPath(container.segments,current))return false;if(!matrixParamsMatch(container.segments,current,matrixParams))return false;if(!container.children[PRIMARY_OUTLET])return false;return containsSegmentGroupHelper(container.children[PRIMARY_OUTLET],containee,next,
matrixParams)}}function matrixParamsMatch(containerPaths,containeePaths,options){return containeePaths.every((containeeSegment,i)=>{return paramCompareMap[options](containerPaths[i].parameters,containeeSegment.parameters)})}class UrlTree{constructor(root,queryParams,fragment){this.root=root;this.queryParams=queryParams;this.fragment=fragment}get queryParamMap(){if(!this._queryParamMap)this._queryParamMap=convertToParamMap(this.queryParams);return this._queryParamMap}toString(){return DEFAULT_SERIALIZER.serialize(this)}}
class UrlSegmentGroup{constructor(segments,children){this.segments=segments;this.children=children;this.parent=null;forEach(children,(v,k)=>v.parent=this)}hasChildren(){return this.numberOfChildren>0}get numberOfChildren(){return Object.keys(this.children).length}toString(){return serializePaths(this)}}class UrlSegment{constructor(path,parameters){this.path=path;this.parameters=parameters}get parameterMap(){if(!this._parameterMap)this._parameterMap=convertToParamMap(this.parameters);return this._parameterMap}toString(){return serializePath(this)}}
function equalSegments(as,bs){return equalPath(as,bs)&&as.every((a,i)=>shallowEqual(a.parameters,bs[i].parameters))}function equalPath(as,bs){if(as.length!==bs.length)return false;return as.every((a,i)=>a.path===bs[i].path)}function mapChildrenIntoArray(segment,fn){let res=[];forEach(segment.children,(child,childOutlet)=>{if(childOutlet===PRIMARY_OUTLET)res=res.concat(fn(child,childOutlet))});forEach(segment.children,(child,childOutlet)=>{if(childOutlet!==PRIMARY_OUTLET)res=res.concat(fn(child,childOutlet))});
return res}class UrlSerializer{}class DefaultUrlSerializer{parse(url){const p=new UrlParser(url);return new UrlTree(p.parseRootSegment(),p.parseQueryParams(),p.parseFragment())}serialize(tree){const segment=`/${serializeSegment(tree.root,true)}`;const query=serializeQueryParams(tree.queryParams);const fragment=typeof tree.fragment===`string`?`#${encodeUriFragment(tree.fragment)}`:"";return`${segment}${query}${fragment}`}}const DEFAULT_SERIALIZER=new DefaultUrlSerializer;function serializePaths(segment){return segment.segments.map(p=>
serializePath(p)).join("/")}function serializeSegment(segment,root){if(!segment.hasChildren())return serializePaths(segment);if(root){const primary=segment.children[PRIMARY_OUTLET]?serializeSegment(segment.children[PRIMARY_OUTLET],false):"";const children=[];forEach(segment.children,(v,k)=>{if(k!==PRIMARY_OUTLET)children.push(`${k}:${serializeSegment(v,false)}`)});return children.length>0?`${primary}(${children.join("//")})`:primary}else{const children=mapChildrenIntoArray(segment,(v,k)=>{if(k===
PRIMARY_OUTLET)return[serializeSegment(segment.children[PRIMARY_OUTLET],false)];return[`${k}:${serializeSegment(v,false)}`]});if(Object.keys(segment.children).length===1&&segment.children[PRIMARY_OUTLET]!=null)return`${serializePaths(segment)}/${children[0]}`;return`${serializePaths(segment)}/(${children.join("//")})`}}function encodeUriString(s){return encodeURIComponent(s).replace(/%40/g,"@").replace(/%3A/gi,":").replace(/%24/g,"$").replace(/%2C/gi,",")}function encodeUriQuery(s){return encodeUriString(s).replace(/%3B/gi,
";")}function encodeUriFragment(s){return encodeURI(s)}function encodeUriSegment(s){return encodeUriString(s).replace(/\(/g,"%28").replace(/\)/g,"%29").replace(/%26/gi,"&")}function decode(s){return decodeURIComponent(s)}function decodeQuery(s){return decode(s.replace(/\+/g,"%20"))}function serializePath(path){return`${encodeUriSegment(path.path)}${serializeMatrixParams(path.parameters)}`}function serializeMatrixParams(params){return Object.keys(params).map(key=>`;${encodeUriSegment(key)}=${encodeUriSegment(params[key])}`).join("")}
function serializeQueryParams(params){const strParams=Object.keys(params).map(name=>{const value=params[name];return Array.isArray(value)?value.map(v=>`${encodeUriQuery(name)}=${encodeUriQuery(v)}`).join("&"):`${encodeUriQuery(name)}=${encodeUriQuery(value)}`}).filter(s=>!!s);return strParams.length?`?${strParams.join("&")}`:""}const SEGMENT_RE=/^[^\/()?;=#]+/;function matchSegments(str){const match=str.match(SEGMENT_RE);return match?match[0]:""}const QUERY_PARAM_RE=/^[^=?&#]+/;function matchQueryParams(str){const match=
str.match(QUERY_PARAM_RE);return match?match[0]:""}const QUERY_PARAM_VALUE_RE=/^[^&#]+/;function matchUrlQueryParamValue(str){const match=str.match(QUERY_PARAM_VALUE_RE);return match?match[0]:""}class UrlParser{constructor(url){this.url=url;this.remaining=url}parseRootSegment(){this.consumeOptional("/");if(this.remaining===""||this.peekStartsWith("?")||this.peekStartsWith("#"))return new UrlSegmentGroup([],{});return new UrlSegmentGroup([],this.parseChildren())}parseQueryParams(){const params={};
if(this.consumeOptional("?")){do this.parseQueryParam(params);while(this.consumeOptional("&"))}return params}parseFragment(){return this.consumeOptional("#")?decodeURIComponent(this.remaining):null}parseChildren(){if(this.remaining==="")return{};this.consumeOptional("/");const segments=[];if(!this.peekStartsWith("("))segments.push(this.parseSegment());while(this.peekStartsWith("/")&&!this.peekStartsWith("//")&&!this.peekStartsWith("/(")){this.capture("/");segments.push(this.parseSegment())}let children=
{};if(this.peekStartsWith("/(")){this.capture("/");children=this.parseParens(true)}let res={};if(this.peekStartsWith("("))res=this.parseParens(false);if(segments.length>0||Object.keys(children).length>0)res[PRIMARY_OUTLET]=new UrlSegmentGroup(segments,children);return res}parseSegment(){const path=matchSegments(this.remaining);if(path===""&&this.peekStartsWith(";"))throw new Error(`Empty path url segment cannot have parameters: '${this.remaining}'.`);this.capture(path);return new UrlSegment(decode(path),
this.parseMatrixParams())}parseMatrixParams(){const params={};while(this.consumeOptional(";"))this.parseParam(params);return params}parseParam(params){const key=matchSegments(this.remaining);if(!key)return;this.capture(key);let value="";if(this.consumeOptional("=")){const valueMatch=matchSegments(this.remaining);if(valueMatch){value=valueMatch;this.capture(value)}}params[decode(key)]=decode(value)}parseQueryParam(params){const key=matchQueryParams(this.remaining);if(!key)return;this.capture(key);
let value="";if(this.consumeOptional("=")){const valueMatch=matchUrlQueryParamValue(this.remaining);if(valueMatch){value=valueMatch;this.capture(value)}}const decodedKey=decodeQuery(key);const decodedVal=decodeQuery(value);if(params.hasOwnProperty(decodedKey)){let currentVal=params[decodedKey];if(!Array.isArray(currentVal)){currentVal=[currentVal];params[decodedKey]=currentVal}currentVal.push(decodedVal)}else params[decodedKey]=decodedVal}parseParens(allowPrimary){const segments={};this.capture("(");
while(!this.consumeOptional(")")&&this.remaining.length>0){const path=matchSegments(this.remaining);const next=this.remaining[path.length];if(next!=="/"&&next!==")"&&next!==";")throw new Error(`Cannot parse url '${this.url}'`);let outletName=undefined;if(path.indexOf(":")>-1){outletName=path.substr(0,path.indexOf(":"));this.capture(outletName);this.capture(":")}else if(allowPrimary)outletName=PRIMARY_OUTLET;const children=this.parseChildren();segments[outletName]=Object.keys(children).length===1?
children[PRIMARY_OUTLET]:new UrlSegmentGroup([],children);this.consumeOptional("//")}return segments}peekStartsWith(str){return this.remaining.startsWith(str)}consumeOptional(str){if(this.peekStartsWith(str)){this.remaining=this.remaining.substring(str.length);return true}return false}capture(str){if(!this.consumeOptional(str))throw new Error(`Expected "${str}".`);}}class Tree{constructor(root){this._root=root}get root(){return this._root.value}parent(t){const p=this.pathFromRoot(t);return p.length>
1?p[p.length-2]:null}children(t){const n=findNode(t,this._root);return n?n.children.map(t=>t.value):[]}firstChild(t){const n=findNode(t,this._root);return n&&n.children.length>0?n.children[0].value:null}siblings(t){const p=findPath(t,this._root);if(p.length<2)return[];const c=p[p.length-2].children.map(c=>c.value);return c.filter(cc=>cc!==t)}pathFromRoot(t){return findPath(t,this._root).map(s=>s.value)}}function findNode(value,node){if(value===node.value)return node;for(const child of node.children){const node=
findNode(value,child);if(node)return node}return null}function findPath(value,node){if(value===node.value)return[node];for(const child of node.children){const path=findPath(value,child);if(path.length){path.unshift(node);return path}}return[]}class TreeNode{constructor(value,children){this.value=value;this.children=children}toString(){return`TreeNode(${this.value})`}}function nodeChildrenAsMap(node){const map={};if(node)node.children.forEach(child=>map[child.value.outlet]=child);return map}class RouterState extends Tree{constructor(root,
snapshot){super(root);this.snapshot=snapshot;setRouterState(this,root)}toString(){return this.snapshot.toString()}}function createEmptyState(urlTree,rootComponent){const snapshot=createEmptyStateSnapshot(urlTree,rootComponent);const emptyUrl=new rxjs.BehaviorSubject([new UrlSegment("",{})]);const emptyParams=new rxjs.BehaviorSubject({});const emptyData=new rxjs.BehaviorSubject({});const emptyQueryParams=new rxjs.BehaviorSubject({});const fragment=new rxjs.BehaviorSubject("");const activated=new ActivatedRoute(emptyUrl,
emptyParams,emptyQueryParams,fragment,emptyData,PRIMARY_OUTLET,rootComponent,snapshot.root);activated.snapshot=snapshot.root;return new RouterState(new TreeNode(activated,[]),snapshot)}function createEmptyStateSnapshot(urlTree,rootComponent){const emptyParams={};const emptyData={};const emptyQueryParams={};const fragment="";const activated=new ActivatedRouteSnapshot([],emptyParams,emptyQueryParams,fragment,emptyData,PRIMARY_OUTLET,rootComponent,null,urlTree.root,-1,{});return new RouterStateSnapshot("",
new TreeNode(activated,[]))}class ActivatedRoute{constructor(url,params,queryParams,fragment,data,outlet,component,futureSnapshot){this.url=url;this.params=params;this.queryParams=queryParams;this.fragment=fragment;this.data=data;this.outlet=outlet;this.component=component;this._futureSnapshot=futureSnapshot}get routeConfig(){return this._futureSnapshot.routeConfig}get root(){return this._routerState.root}get parent(){return this._routerState.parent(this)}get firstChild(){return this._routerState.firstChild(this)}get children(){return this._routerState.children(this)}get pathFromRoot(){return this._routerState.pathFromRoot(this)}get paramMap(){if(!this._paramMap)this._paramMap=
this.params.pipe(operators.map(p=>convertToParamMap(p)));return this._paramMap}get queryParamMap(){if(!this._queryParamMap)this._queryParamMap=this.queryParams.pipe(operators.map(p=>convertToParamMap(p)));return this._queryParamMap}toString(){return this.snapshot?this.snapshot.toString():`Future(${this._futureSnapshot})`}}function inheritedParamsDataResolve(route,paramsInheritanceStrategy="emptyOnly"){const pathFromRoot=route.pathFromRoot;let inheritingStartingFrom=0;if(paramsInheritanceStrategy!==
"always"){inheritingStartingFrom=pathFromRoot.length-1;while(inheritingStartingFrom>=1){const current=pathFromRoot[inheritingStartingFrom];const parent=pathFromRoot[inheritingStartingFrom-1];if(current.routeConfig&&current.routeConfig.path==="")inheritingStartingFrom--;else if(!parent.component)inheritingStartingFrom--;else break}}return flattenInherited(pathFromRoot.slice(inheritingStartingFrom))}function flattenInherited(pathFromRoot){return pathFromRoot.reduce((res,curr)=>{const params=Object.assign(Object.assign({},
res.params),curr.params);const data=Object.assign(Object.assign({},res.data),curr.data);const resolve=Object.assign(Object.assign({},res.resolve),curr._resolvedData);return{params,data,resolve}},{params:{},data:{},resolve:{}})}class ActivatedRouteSnapshot{constructor(url,params,queryParams,fragment,data,outlet,component,routeConfig,urlSegment,lastPathIndex,resolve){this.url=url;this.params=params;this.queryParams=queryParams;this.fragment=fragment;this.data=data;this.outlet=outlet;this.component=
component;this.routeConfig=routeConfig;this._urlSegment=urlSegment;this._lastPathIndex=lastPathIndex;this._resolve=resolve}get root(){return this._routerState.root}get parent(){return this._routerState.parent(this)}get firstChild(){return this._routerState.firstChild(this)}get children(){return this._routerState.children(this)}get pathFromRoot(){return this._routerState.pathFromRoot(this)}get paramMap(){if(!this._paramMap)this._paramMap=convertToParamMap(this.params);return this._paramMap}get queryParamMap(){if(!this._queryParamMap)this._queryParamMap=
convertToParamMap(this.queryParams);return this._queryParamMap}toString(){const url=this.url.map(segment=>segment.toString()).join("/");const matched=this.routeConfig?this.routeConfig.path:"";return`Route(url:'${url}', path:'${matched}')`}}class RouterStateSnapshot extends Tree{constructor(url,root){super(root);this.url=url;setRouterState(this,root)}toString(){return serializeNode(this._root)}}function setRouterState(state,node){node.value._routerState=state;node.children.forEach(c=>setRouterState(state,
c))}function serializeNode(node){const c=node.children.length>0?` { ${node.children.map(serializeNode).join(", ")} } `:"";return`${node.value}${c}`}function advanceActivatedRoute(route){if(route.snapshot){const currentSnapshot=route.snapshot;const nextSnapshot=route._futureSnapshot;route.snapshot=nextSnapshot;if(!shallowEqual(currentSnapshot.queryParams,nextSnapshot.queryParams))route.queryParams.next(nextSnapshot.queryParams);if(currentSnapshot.fragment!==nextSnapshot.fragment)route.fragment.next(nextSnapshot.fragment);
if(!shallowEqual(currentSnapshot.params,nextSnapshot.params))route.params.next(nextSnapshot.params);if(!shallowEqualArrays(currentSnapshot.url,nextSnapshot.url))route.url.next(nextSnapshot.url);if(!shallowEqual(currentSnapshot.data,nextSnapshot.data))route.data.next(nextSnapshot.data)}else{route.snapshot=route._futureSnapshot;route.data.next(route._futureSnapshot.data)}}function equalParamsAndUrlSegments(a,b){const equalUrlParams=shallowEqual(a.params,b.params)&&equalSegments(a.url,b.url);const parentsMismatch=
!a.parent!==!b.parent;return equalUrlParams&&!parentsMismatch&&(!a.parent||equalParamsAndUrlSegments(a.parent,b.parent))}function createRouterState(routeReuseStrategy,curr,prevState){const root=createNode(routeReuseStrategy,curr._root,prevState?prevState._root:undefined);return new RouterState(root,curr)}function createNode(routeReuseStrategy,curr,prevState){if(prevState&&routeReuseStrategy.shouldReuseRoute(curr.value,prevState.value.snapshot)){const value=prevState.value;value._futureSnapshot=curr.value;
const children=createOrReuseChildren(routeReuseStrategy,curr,prevState);return new TreeNode(value,children)}else{if(routeReuseStrategy.shouldAttach(curr.value)){const detachedRouteHandle=routeReuseStrategy.retrieve(curr.value);if(detachedRouteHandle!==null){const tree=detachedRouteHandle.route;tree.value._futureSnapshot=curr.value;tree.children=curr.children.map(c=>createNode(routeReuseStrategy,c));return tree}}const value=createActivatedRoute(curr.value);const children=curr.children.map(c=>createNode(routeReuseStrategy,
c));return new TreeNode(value,children)}}function createOrReuseChildren(routeReuseStrategy,curr,prevState){return curr.children.map(child=>{for(const p of prevState.children)if(routeReuseStrategy.shouldReuseRoute(child.value,p.value.snapshot))return createNode(routeReuseStrategy,child,p);return createNode(routeReuseStrategy,child)})}function createActivatedRoute(c){return new ActivatedRoute(new rxjs.BehaviorSubject(c.url),new rxjs.BehaviorSubject(c.params),new rxjs.BehaviorSubject(c.queryParams),
new rxjs.BehaviorSubject(c.fragment),new rxjs.BehaviorSubject(c.data),c.outlet,c.component,c)}function createUrlTree(route,urlTree,commands,queryParams,fragment){if(commands.length===0)return tree(urlTree.root,urlTree.root,urlTree,queryParams,fragment);const nav=computeNavigation(commands);if(nav.toRoot())return tree(urlTree.root,new UrlSegmentGroup([],{}),urlTree,queryParams,fragment);const startingPosition=findStartingPosition(nav,urlTree,route);const segmentGroup=startingPosition.processChildren?
updateSegmentGroupChildren(startingPosition.segmentGroup,startingPosition.index,nav.commands):updateSegmentGroup(startingPosition.segmentGroup,startingPosition.index,nav.commands);return tree(startingPosition.segmentGroup,segmentGroup,urlTree,queryParams,fragment)}function isMatrixParams(command){return typeof command==="object"&&command!=null&&!command.outlets&&!command.segmentPath}function isCommandWithOutlets(command){return typeof command==="object"&&command!=null&&command.outlets}function tree(oldSegmentGroup,
newSegmentGroup,urlTree,queryParams,fragment){let qp={};if(queryParams)forEach(queryParams,(value,name)=>{qp[name]=Array.isArray(value)?value.map(v=>`${v}`):`${value}`});if(urlTree.root===oldSegmentGroup)return new UrlTree(newSegmentGroup,qp,fragment);return new UrlTree(replaceSegment(urlTree.root,oldSegmentGroup,newSegmentGroup),qp,fragment)}function replaceSegment(current,oldSegment,newSegment){const children={};forEach(current.children,(c,outletName)=>{if(c===oldSegment)children[outletName]=newSegment;
else children[outletName]=replaceSegment(c,oldSegment,newSegment)});return new UrlSegmentGroup(current.segments,children)}class Navigation{constructor(isAbsolute,numberOfDoubleDots,commands){this.isAbsolute=isAbsolute;this.numberOfDoubleDots=numberOfDoubleDots;this.commands=commands;if(isAbsolute&&commands.length>0&&isMatrixParams(commands[0]))throw new Error("Root segment cannot have matrix parameters");const cmdWithOutlet=commands.find(isCommandWithOutlets);if(cmdWithOutlet&&cmdWithOutlet!==last(commands))throw new Error("{outlets:{}} has to be the last command");
}toRoot(){return this.isAbsolute&&this.commands.length===1&&this.commands[0]=="/"}}function computeNavigation(commands){if(typeof commands[0]==="string"&&commands.length===1&&commands[0]==="/")return new Navigation(true,0,commands);let numberOfDoubleDots=0;let isAbsolute=false;const res=commands.reduce((res,cmd,cmdIdx)=>{if(typeof cmd==="object"&&cmd!=null){if(cmd.outlets){const outlets={};forEach(cmd.outlets,(commands,name)=>{outlets[name]=typeof commands==="string"?commands.split("/"):commands});
return[...res,{outlets}]}if(cmd.segmentPath)return[...res,cmd.segmentPath]}if(!(typeof cmd==="string"))return[...res,cmd];if(cmdIdx===0){cmd.split("/").forEach((urlPart,partIndex)=>{if(partIndex==0&&urlPart===".");else if(partIndex==0&&urlPart==="")isAbsolute=true;else if(urlPart==="..")numberOfDoubleDots++;else if(urlPart!="")res.push(urlPart)});return res}return[...res,cmd]},[]);return new Navigation(isAbsolute,numberOfDoubleDots,res)}class Position{constructor(segmentGroup,processChildren,index){this.segmentGroup=
segmentGroup;this.processChildren=processChildren;this.index=index}}function findStartingPosition(nav,tree,route){if(nav.isAbsolute)return new Position(tree.root,true,0);if(route.snapshot._lastPathIndex===-1){const segmentGroup=route.snapshot._urlSegment;const processChildren=segmentGroup===tree.root;return new Position(segmentGroup,processChildren,0)}const modifier=isMatrixParams(nav.commands[0])?0:1;const index=route.snapshot._lastPathIndex+modifier;return createPositionApplyingDoubleDots(route.snapshot._urlSegment,
index,nav.numberOfDoubleDots)}function createPositionApplyingDoubleDots(group,index,numberOfDoubleDots){let g=group;let ci=index;let dd=numberOfDoubleDots;while(dd>ci){dd-=ci;g=g.parent;if(!g)throw new Error("Invalid number of '../'");ci=g.segments.length}return new Position(g,false,ci-dd)}function getOutlets(commands){if(isCommandWithOutlets(commands[0]))return commands[0].outlets;return{[PRIMARY_OUTLET]:commands}}function updateSegmentGroup(segmentGroup,startIndex,commands){if(!segmentGroup)segmentGroup=
new UrlSegmentGroup([],{});if(segmentGroup.segments.length===0&&segmentGroup.hasChildren())return updateSegmentGroupChildren(segmentGroup,startIndex,commands);const m=prefixedWith(segmentGroup,startIndex,commands);const slicedCommands=commands.slice(m.commandIndex);if(m.match&&m.pathIndex<segmentGroup.segments.length){const g=new UrlSegmentGroup(segmentGroup.segments.slice(0,m.pathIndex),{});g.children[PRIMARY_OUTLET]=new UrlSegmentGroup(segmentGroup.segments.slice(m.pathIndex),segmentGroup.children);
return updateSegmentGroupChildren(g,0,slicedCommands)}else if(m.match&&slicedCommands.length===0)return new UrlSegmentGroup(segmentGroup.segments,{});else if(m.match&&!segmentGroup.hasChildren())return createNewSegmentGroup(segmentGroup,startIndex,commands);else if(m.match)return updateSegmentGroupChildren(segmentGroup,0,slicedCommands);else return createNewSegmentGroup(segmentGroup,startIndex,commands)}function updateSegmentGroupChildren(segmentGroup,startIndex,commands){if(commands.length===0)return new UrlSegmentGroup(segmentGroup.segments,
{});else{const outlets=getOutlets(commands);const children={};forEach(outlets,(commands,outlet)=>{if(typeof commands==="string")commands=[commands];if(commands!==null)children[outlet]=updateSegmentGroup(segmentGroup.children[outlet],startIndex,commands)});forEach(segmentGroup.children,(child,childOutlet)=>{if(outlets[childOutlet]===undefined)children[childOutlet]=child});return new UrlSegmentGroup(segmentGroup.segments,children)}}function prefixedWith(segmentGroup,startIndex,commands){let currentCommandIndex=
0;let currentPathIndex=startIndex;const noMatch={match:false,pathIndex:0,commandIndex:0};while(currentPathIndex<segmentGroup.segments.length){if(currentCommandIndex>=commands.length)return noMatch;const path=segmentGroup.segments[currentPathIndex];const command=commands[currentCommandIndex];if(isCommandWithOutlets(command))break;const curr=`${command}`;const next=currentCommandIndex<commands.length-1?commands[currentCommandIndex+1]:null;if(currentPathIndex>0&&curr===undefined)break;if(curr&&next&&
typeof next==="object"&&next.outlets===undefined){if(!compare(curr,next,path))return noMatch;currentCommandIndex+=2}else{if(!compare(curr,{},path))return noMatch;currentCommandIndex++}currentPathIndex++}return{match:true,pathIndex:currentPathIndex,commandIndex:currentCommandIndex}}function createNewSegmentGroup(segmentGroup,startIndex,commands){const paths=segmentGroup.segments.slice(0,startIndex);let i=0;while(i<commands.length){const command=commands[i];if(isCommandWithOutlets(command)){const children=
createNewSegmentChildren(command.outlets);return new UrlSegmentGroup(paths,children)}if(i===0&&isMatrixParams(commands[0])){const p=segmentGroup.segments[startIndex];paths.push(new UrlSegment(p.path,stringify(commands[0])));i++;continue}const curr=isCommandWithOutlets(command)?command.outlets[PRIMARY_OUTLET]:`${command}`;const next=i<commands.length-1?commands[i+1]:null;if(curr&&next&&isMatrixParams(next)){paths.push(new UrlSegment(curr,stringify(next)));i+=2}else{paths.push(new UrlSegment(curr,{}));
i++}}return new UrlSegmentGroup(paths,{})}function createNewSegmentChildren(outlets){const children={};forEach(outlets,(commands,outlet)=>{if(typeof commands==="string")commands=[commands];if(commands!==null)children[outlet]=createNewSegmentGroup(new UrlSegmentGroup([],{}),0,commands)});return children}function stringify(params){const res={};forEach(params,(v,k)=>res[k]=`${v}`);return res}function compare(path,params,segment){return path==segment.path&&shallowEqual(params,segment.parameters)}const activateRoutes=
(rootContexts,routeReuseStrategy,forwardEvent)=>operators.map(t=>{(new ActivateRoutes(routeReuseStrategy,t.targetRouterState,t.currentRouterState,forwardEvent)).activate(rootContexts);return t});class ActivateRoutes{constructor(routeReuseStrategy,futureState,currState,forwardEvent){this.routeReuseStrategy=routeReuseStrategy;this.futureState=futureState;this.currState=currState;this.forwardEvent=forwardEvent}activate(parentContexts){const futureRoot=this.futureState._root;const currRoot=this.currState?
this.currState._root:null;this.deactivateChildRoutes(futureRoot,currRoot,parentContexts);advanceActivatedRoute(this.futureState.root);this.activateChildRoutes(futureRoot,currRoot,parentContexts)}deactivateChildRoutes(futureNode,currNode,contexts){const children=nodeChildrenAsMap(currNode);futureNode.children.forEach(futureChild=>{const childOutletName=futureChild.value.outlet;this.deactivateRoutes(futureChild,children[childOutletName],contexts);delete children[childOutletName]});forEach(children,
(v,childName)=>{this.deactivateRouteAndItsChildren(v,contexts)})}deactivateRoutes(futureNode,currNode,parentContext){const future=futureNode.value;const curr=currNode?currNode.value:null;if(future===curr)if(future.component){const context=parentContext.getContext(future.outlet);if(context)this.deactivateChildRoutes(futureNode,currNode,context.children)}else this.deactivateChildRoutes(futureNode,currNode,parentContext);else if(curr)this.deactivateRouteAndItsChildren(currNode,parentContext)}deactivateRouteAndItsChildren(route,
parentContexts){if(route.value.component&&this.routeReuseStrategy.shouldDetach(route.value.snapshot))this.detachAndStoreRouteSubtree(route,parentContexts);else this.deactivateRouteAndOutlet(route,parentContexts)}detachAndStoreRouteSubtree(route,parentContexts){const context=parentContexts.getContext(route.value.outlet);const contexts=context&&route.value.component?context.children:parentContexts;const children=nodeChildrenAsMap(route);for(const childOutlet of Object.keys(children))this.deactivateRouteAndItsChildren(children[childOutlet],
contexts);if(context&&context.outlet){const componentRef=context.outlet.detach();const contexts=context.children.onOutletDeactivated();this.routeReuseStrategy.store(route.value.snapshot,{componentRef,route,contexts})}}deactivateRouteAndOutlet(route,parentContexts){const context=parentContexts.getContext(route.value.outlet);const contexts=context&&route.value.component?context.children:parentContexts;const children=nodeChildrenAsMap(route);for(const childOutlet of Object.keys(children))this.deactivateRouteAndItsChildren(children[childOutlet],
contexts);if(context&&context.outlet){context.outlet.deactivate();context.children.onOutletDeactivated();context.attachRef=null;context.resolver=null;context.route=null}}activateChildRoutes(futureNode,currNode,contexts){const children=nodeChildrenAsMap(currNode);futureNode.children.forEach(c=>{this.activateRoutes(c,children[c.value.outlet],contexts);this.forwardEvent(new ActivationEnd(c.value.snapshot))});if(futureNode.children.length)this.forwardEvent(new ChildActivationEnd(futureNode.value.snapshot))}activateRoutes(futureNode,
currNode,parentContexts){const future=futureNode.value;const curr=currNode?currNode.value:null;advanceActivatedRoute(future);if(future===curr)if(future.component){const context=parentContexts.getOrCreateContext(future.outlet);this.activateChildRoutes(futureNode,currNode,context.children)}else this.activateChildRoutes(futureNode,currNode,parentContexts);else if(future.component){const context=parentContexts.getOrCreateContext(future.outlet);if(this.routeReuseStrategy.shouldAttach(future.snapshot)){const stored=
this.routeReuseStrategy.retrieve(future.snapshot);this.routeReuseStrategy.store(future.snapshot,null);context.children.onOutletReAttached(stored.contexts);context.attachRef=stored.componentRef;context.route=stored.route.value;if(context.outlet)context.outlet.attach(stored.componentRef,stored.route.value);advanceActivatedRoute(stored.route.value);this.activateChildRoutes(futureNode,null,context.children)}else{const config=parentLoadedConfig(future.snapshot);const cmpFactoryResolver=config?config.module.componentFactoryResolver:
null;context.attachRef=null;context.route=future;context.resolver=cmpFactoryResolver;if(context.outlet)context.outlet.activateWith(future,cmpFactoryResolver);this.activateChildRoutes(futureNode,null,context.children)}}else this.activateChildRoutes(futureNode,null,parentContexts)}}function parentLoadedConfig(snapshot){for(let s=snapshot.parent;s;s=s.parent){const route=s.routeConfig;if(route&&route._loadedConfig)return route._loadedConfig;if(route&&route.component)return null}return null}class LoadedRouterConfig{constructor(routes,
module){this.routes=routes;this.module=module}}function isFunction(v){return typeof v==="function"}function isBoolean(v){return typeof v==="boolean"}function isUrlTree(v){return v instanceof UrlTree}function isCanLoad(guard){return guard&&isFunction(guard.canLoad)}function isCanActivate(guard){return guard&&isFunction(guard.canActivate)}function isCanActivateChild(guard){return guard&&isFunction(guard.canActivateChild)}function isCanDeactivate(guard){return guard&&isFunction(guard.canDeactivate)}
const INITIAL_VALUE=Symbol("INITIAL_VALUE");function prioritizedGuardValue(){return operators.switchMap(obs=>{return rxjs.combineLatest(obs.map(o=>o.pipe(operators.take(1),operators.startWith(INITIAL_VALUE)))).pipe(operators.scan((acc,list)=>{let isPending=false;return list.reduce((innerAcc,val,i)=>{if(innerAcc!==INITIAL_VALUE)return innerAcc;if(val===INITIAL_VALUE)isPending=true;if(!isPending){if(val===false)return val;if(i===list.length-1||isUrlTree(val))return val}return innerAcc},acc)},INITIAL_VALUE),
operators.filter(item=>item!==INITIAL_VALUE),operators.map(item=>isUrlTree(item)?item:item===true),operators.take(1))})}class OutletContext{constructor(){this.outlet=null;this.route=null;this.resolver=null;this.children=new ChildrenOutletContexts;this.attachRef=null}}class ChildrenOutletContexts{constructor(){this.contexts=new Map}onChildOutletCreated(childName,outlet){const context=this.getOrCreateContext(childName);context.outlet=outlet;this.contexts.set(childName,context)}onChildOutletDestroyed(childName){const context=
this.getContext(childName);if(context){context.outlet=null;context.attachRef=null}}onOutletDeactivated(){const contexts=this.contexts;this.contexts=new Map;return contexts}onOutletReAttached(contexts){this.contexts=contexts}getOrCreateContext(childName){let context=this.getContext(childName);if(!context){context=new OutletContext;this.contexts.set(childName,context)}return context}getContext(childName){return this.contexts.get(childName)||null}}class RouterOutlet{constructor(parentContexts,location,
resolver,name,changeDetector){this.parentContexts=parentContexts;this.location=location;this.resolver=resolver;this.changeDetector=changeDetector;this.activated=null;this._activatedRoute=null;this.activateEvents=new i0.EventEmitter;this.deactivateEvents=new i0.EventEmitter;this.attachEvents=new i0.EventEmitter;this.detachEvents=new i0.EventEmitter;this.name=name||PRIMARY_OUTLET;parentContexts.onChildOutletCreated(this.name,this)}ngOnDestroy(){this.parentContexts.onChildOutletDestroyed(this.name)}ngOnInit(){if(!this.activated){const context=
this.parentContexts.getContext(this.name);if(context&&context.route)if(context.attachRef)this.attach(context.attachRef,context.route);else this.activateWith(context.route,context.resolver||null)}}get isActivated(){return!!this.activated}get component(){if(!this.activated)throw new Error("Outlet is not activated");return this.activated.instance}get activatedRoute(){if(!this.activated)throw new Error("Outlet is not activated");return this._activatedRoute}get activatedRouteData(){if(this._activatedRoute)return this._activatedRoute.snapshot.data;
return{}}detach(){if(!this.activated)throw new Error("Outlet is not activated");this.location.detach();const cmp=this.activated;this.activated=null;this._activatedRoute=null;this.detachEvents.emit(cmp.instance);return cmp}attach(ref,activatedRoute){this.activated=ref;this._activatedRoute=activatedRoute;this.location.insert(ref.hostView);this.attachEvents.emit(ref.instance)}deactivate(){if(this.activated){const c=this.component;this.activated.destroy();this.activated=null;this._activatedRoute=null;
this.deactivateEvents.emit(c)}}activateWith(activatedRoute,resolver){if(this.isActivated)throw new Error("Cannot activate an already activated outlet");this._activatedRoute=activatedRoute;const snapshot=activatedRoute._futureSnapshot;const component=snapshot.routeConfig.component;resolver=resolver||this.resolver;const factory=resolver.resolveComponentFactory(component);const childContexts=this.parentContexts.getOrCreateContext(this.name).children;const injector=new OutletInjector(activatedRoute,childContexts,
this.location.injector);this.activated=this.location.createComponent(factory,this.location.length,injector);this.changeDetector.markForCheck();this.activateEvents.emit(this.activated.instance)}}RouterOutlet.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:RouterOutlet,deps:[{token:ChildrenOutletContexts},{token:i0__namespace.ViewContainerRef},{token:i0__namespace.ComponentFactoryResolver},{token:"name",attribute:true},{token:i0__namespace.ChangeDetectorRef}],
target:i0__namespace.\u0275\u0275FactoryTarget.Directive});RouterOutlet.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.1.3",type:RouterOutlet,selector:"router-outlet",outputs:{activateEvents:"activate",deactivateEvents:"deactivate",attachEvents:"attach",detachEvents:"detach"},exportAs:["outlet"],ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:RouterOutlet,decorators:[{type:i0.Directive,
args:[{selector:"router-outlet",exportAs:"outlet"}]}],ctorParameters:function(){return[{type:ChildrenOutletContexts},{type:i0__namespace.ViewContainerRef},{type:i0__namespace.ComponentFactoryResolver},{type:undefined,decorators:[{type:i0.Attribute,args:["name"]}]},{type:i0__namespace.ChangeDetectorRef}]},propDecorators:{activateEvents:[{type:i0.Output,args:["activate"]}],deactivateEvents:[{type:i0.Output,args:["deactivate"]}],attachEvents:[{type:i0.Output,args:["attach"]}],detachEvents:[{type:i0.Output,
args:["detach"]}]}});class OutletInjector{constructor(route,childContexts,parent){this.route=route;this.childContexts=childContexts;this.parent=parent}get(token,notFoundValue){if(token===ActivatedRoute)return this.route;if(token===ChildrenOutletContexts)return this.childContexts;return this.parent.get(token,notFoundValue)}}class \u0275EmptyOutletComponent{}\u0275EmptyOutletComponent.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:\u0275EmptyOutletComponent,
deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.Component});\u0275EmptyOutletComponent.\u0275cmp=i0__namespace.\u0275\u0275ngDeclareComponent({minVersion:"12.0.0",version:"13.1.3",type:\u0275EmptyOutletComponent,selector:"ng-component",ngImport:i0__namespace,template:`<router-outlet></router-outlet>`,isInline:true,directives:[{type:RouterOutlet,selector:"router-outlet",outputs:["activate","deactivate","attach","detach"],exportAs:["outlet"]}]});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",
version:"13.1.3",ngImport:i0__namespace,type:\u0275EmptyOutletComponent,decorators:[{type:i0.Component,args:[{template:`<router-outlet></router-outlet>`}]}]});function validateConfig(config,parentPath=""){for(let i=0;i<config.length;i++){const route=config[i];const fullPath=getFullPath(parentPath,route);validateNode(route,fullPath)}}function validateNode(route,fullPath){if(typeof ngDevMode==="undefined"||ngDevMode){if(!route)throw new Error(`
      Invalid configuration of route '${fullPath}': Encountered undefined route.
      The reason might be an extra comma.

      Example:
      const routes: Routes = [
        { path: '', redirectTo: '/dashboard', pathMatch: 'full' },
        { path: 'dashboard',  component: DashboardComponent },, << two commas
        { path: 'detail/:id', component: HeroDetailComponent }
      ];
    `);if(Array.isArray(route))throw new Error(`Invalid configuration of route '${fullPath}': Array cannot be specified`);if(!route.component&&!route.children&&!route.loadChildren&&(route.outlet&&route.outlet!==PRIMARY_OUTLET))throw new Error(`Invalid configuration of route '${fullPath}': a componentless route without children or loadChildren cannot have a named outlet set`);if(route.redirectTo&&route.children)throw new Error(`Invalid configuration of route '${fullPath}': redirectTo and children cannot be used together`);
if(route.redirectTo&&route.loadChildren)throw new Error(`Invalid configuration of route '${fullPath}': redirectTo and loadChildren cannot be used together`);if(route.children&&route.loadChildren)throw new Error(`Invalid configuration of route '${fullPath}': children and loadChildren cannot be used together`);if(route.redirectTo&&route.component)throw new Error(`Invalid configuration of route '${fullPath}': redirectTo and component cannot be used together`);if(route.redirectTo&&route.canActivate)throw new Error(`Invalid configuration of route '${fullPath}': redirectTo and canActivate cannot be used together. Redirects happen before activation `+
`so canActivate will never be executed.`);if(route.path&&route.matcher)throw new Error(`Invalid configuration of route '${fullPath}': path and matcher cannot be used together`);if(route.redirectTo===void 0&&!route.component&&!route.children&&!route.loadChildren)throw new Error(`Invalid configuration of route '${fullPath}'. One of the following must be provided: component, redirectTo, children or loadChildren`);if(route.path===void 0&&route.matcher===void 0)throw new Error(`Invalid configuration of route '${fullPath}': routes must have either a path or a matcher specified`);
if(typeof route.path==="string"&&route.path.charAt(0)==="/")throw new Error(`Invalid configuration of route '${fullPath}': path cannot start with a slash`);if(route.path===""&&route.redirectTo!==void 0&&route.pathMatch===void 0){const exp=`The default value of 'pathMatch' is 'prefix', but often the intent is to use 'full'.`;throw new Error(`Invalid configuration of route '{path: "${fullPath}", redirectTo: "${route.redirectTo}"}': please provide 'pathMatch'. ${exp}`);}if(route.pathMatch!==void 0&&
route.pathMatch!=="full"&&route.pathMatch!=="prefix")throw new Error(`Invalid configuration of route '${fullPath}': pathMatch can only be set to 'prefix' or 'full'`);}if(route.children)validateConfig(route.children,fullPath)}function getFullPath(parentPath,currentRoute){if(!currentRoute)return parentPath;if(!parentPath&&!currentRoute.path)return"";else if(parentPath&&!currentRoute.path)return`${parentPath}/`;else if(!parentPath&&currentRoute.path)return currentRoute.path;else return`${parentPath}/${currentRoute.path}`}
function standardizeConfig(r){const children=r.children&&r.children.map(standardizeConfig);const c=children?Object.assign(Object.assign({},r),{children}):Object.assign({},r);if(!c.component&&(children||c.loadChildren)&&(c.outlet&&c.outlet!==PRIMARY_OUTLET))c.component=\u0275EmptyOutletComponent;return c}function getOutlet(route){return route.outlet||PRIMARY_OUTLET}function sortByMatchingOutlets(routes,outletName){const sortedConfig=routes.filter(r=>getOutlet(r)===outletName);sortedConfig.push(...routes.filter(r=>
getOutlet(r)!==outletName));return sortedConfig}const noMatch$1={matched:false,consumedSegments:[],lastChild:0,parameters:{},positionalParamSegments:{}};function match(segmentGroup,route,segments){var _a;if(route.path===""){if(route.pathMatch==="full"&&(segmentGroup.hasChildren()||segments.length>0))return Object.assign({},noMatch$1);return{matched:true,consumedSegments:[],lastChild:0,parameters:{},positionalParamSegments:{}}}const matcher=route.matcher||defaultUrlMatcher;const res=matcher(segments,
segmentGroup,route);if(!res)return Object.assign({},noMatch$1);const posParams={};forEach(res.posParams,(v,k)=>{posParams[k]=v.path});const parameters=res.consumed.length>0?Object.assign(Object.assign({},posParams),res.consumed[res.consumed.length-1].parameters):posParams;return{matched:true,consumedSegments:res.consumed,lastChild:res.consumed.length,parameters,positionalParamSegments:(_a=res.posParams)!==null&&_a!==void 0?_a:{}}}function split(segmentGroup,consumedSegments,slicedSegments,config,
relativeLinkResolution="corrected"){if(slicedSegments.length>0&&containsEmptyPathMatchesWithNamedOutlets(segmentGroup,slicedSegments,config)){const s=new UrlSegmentGroup(consumedSegments,createChildrenForEmptyPaths(segmentGroup,consumedSegments,config,new UrlSegmentGroup(slicedSegments,segmentGroup.children)));s._sourceSegment=segmentGroup;s._segmentIndexShift=consumedSegments.length;return{segmentGroup:s,slicedSegments:[]}}if(slicedSegments.length===0&&containsEmptyPathMatches(segmentGroup,slicedSegments,
config)){const s=new UrlSegmentGroup(segmentGroup.segments,addEmptyPathsToChildrenIfNeeded(segmentGroup,consumedSegments,slicedSegments,config,segmentGroup.children,relativeLinkResolution));s._sourceSegment=segmentGroup;s._segmentIndexShift=consumedSegments.length;return{segmentGroup:s,slicedSegments}}const s=new UrlSegmentGroup(segmentGroup.segments,segmentGroup.children);s._sourceSegment=segmentGroup;s._segmentIndexShift=consumedSegments.length;return{segmentGroup:s,slicedSegments}}function addEmptyPathsToChildrenIfNeeded(segmentGroup,
consumedSegments,slicedSegments,routes,children,relativeLinkResolution){const res={};for(const r of routes)if(emptyPathMatch(segmentGroup,slicedSegments,r)&&!children[getOutlet(r)]){const s=new UrlSegmentGroup([],{});s._sourceSegment=segmentGroup;if(relativeLinkResolution==="legacy")s._segmentIndexShift=segmentGroup.segments.length;else s._segmentIndexShift=consumedSegments.length;res[getOutlet(r)]=s}return Object.assign(Object.assign({},children),res)}function createChildrenForEmptyPaths(segmentGroup,
consumedSegments,routes,primarySegment){const res={};res[PRIMARY_OUTLET]=primarySegment;primarySegment._sourceSegment=segmentGroup;primarySegment._segmentIndexShift=consumedSegments.length;for(const r of routes)if(r.path===""&&getOutlet(r)!==PRIMARY_OUTLET){const s=new UrlSegmentGroup([],{});s._sourceSegment=segmentGroup;s._segmentIndexShift=consumedSegments.length;res[getOutlet(r)]=s}return res}function containsEmptyPathMatchesWithNamedOutlets(segmentGroup,slicedSegments,routes){return routes.some(r=>
emptyPathMatch(segmentGroup,slicedSegments,r)&&getOutlet(r)!==PRIMARY_OUTLET)}function containsEmptyPathMatches(segmentGroup,slicedSegments,routes){return routes.some(r=>emptyPathMatch(segmentGroup,slicedSegments,r))}function emptyPathMatch(segmentGroup,slicedSegments,r){if((segmentGroup.hasChildren()||slicedSegments.length>0)&&r.pathMatch==="full")return false;return r.path===""}function isImmediateMatch(route,rawSegment,segments,outlet){if(getOutlet(route)!==outlet&&(outlet===PRIMARY_OUTLET||!emptyPathMatch(rawSegment,
segments,route)))return false;if(route.path==="**")return true;return match(rawSegment,route,segments).matched}function noLeftoversInUrl(segmentGroup,segments,outlet){return segments.length===0&&!segmentGroup.children[outlet]}class NoMatch$1{constructor(segmentGroup){this.segmentGroup=segmentGroup||null}}class AbsoluteRedirect{constructor(urlTree){this.urlTree=urlTree}}function noMatch(segmentGroup){return new rxjs.Observable(obs=>obs.error(new NoMatch$1(segmentGroup)))}function absoluteRedirect(newTree){return new rxjs.Observable(obs=>
obs.error(new AbsoluteRedirect(newTree)))}function namedOutletsRedirect(redirectTo){return new rxjs.Observable(obs=>obs.error(new Error(`Only absolute redirects can have named outlets. redirectTo: '${redirectTo}'`)))}function canLoadFails(route){return new rxjs.Observable(obs=>obs.error(navigationCancelingError(`Cannot load children because the guard of the route "path: '${route.path}'" returned false`)))}function applyRedirects$1(moduleInjector,configLoader,urlSerializer,urlTree,config){return(new ApplyRedirects(moduleInjector,
configLoader,urlSerializer,urlTree,config)).apply()}class ApplyRedirects{constructor(moduleInjector,configLoader,urlSerializer,urlTree,config){this.configLoader=configLoader;this.urlSerializer=urlSerializer;this.urlTree=urlTree;this.config=config;this.allowRedirects=true;this.ngModule=moduleInjector.get(i0.NgModuleRef)}apply(){const splitGroup=split(this.urlTree.root,[],[],this.config).segmentGroup;const rootSegmentGroup=new UrlSegmentGroup(splitGroup.segments,splitGroup.children);const expanded$=
this.expandSegmentGroup(this.ngModule,this.config,rootSegmentGroup,PRIMARY_OUTLET);const urlTrees$=expanded$.pipe(operators.map(rootSegmentGroup=>{return this.createUrlTree(squashSegmentGroup(rootSegmentGroup),this.urlTree.queryParams,this.urlTree.fragment)}));return urlTrees$.pipe(operators.catchError(e=>{if(e instanceof AbsoluteRedirect){this.allowRedirects=false;return this.match(e.urlTree)}if(e instanceof NoMatch$1)throw this.noMatchError(e);throw e;}))}match(tree){const expanded$=this.expandSegmentGroup(this.ngModule,
this.config,tree.root,PRIMARY_OUTLET);const mapped$=expanded$.pipe(operators.map(rootSegmentGroup=>{return this.createUrlTree(squashSegmentGroup(rootSegmentGroup),tree.queryParams,tree.fragment)}));return mapped$.pipe(operators.catchError(e=>{if(e instanceof NoMatch$1)throw this.noMatchError(e);throw e;}))}noMatchError(e){return new Error(`Cannot match any routes. URL Segment: '${e.segmentGroup}'`)}createUrlTree(rootCandidate,queryParams,fragment){const root=rootCandidate.segments.length>0?new UrlSegmentGroup([],
{[PRIMARY_OUTLET]:rootCandidate}):rootCandidate;return new UrlTree(root,queryParams,fragment)}expandSegmentGroup(ngModule,routes,segmentGroup,outlet){if(segmentGroup.segments.length===0&&segmentGroup.hasChildren())return this.expandChildren(ngModule,routes,segmentGroup).pipe(operators.map(children=>new UrlSegmentGroup([],children)));return this.expandSegment(ngModule,segmentGroup,routes,segmentGroup.segments,outlet,true)}expandChildren(ngModule,routes,segmentGroup){const childOutlets=[];for(const child of Object.keys(segmentGroup.children))if(child===
"primary")childOutlets.unshift(child);else childOutlets.push(child);return rxjs.from(childOutlets).pipe(operators.concatMap(childOutlet=>{const child=segmentGroup.children[childOutlet];const sortedRoutes=sortByMatchingOutlets(routes,childOutlet);return this.expandSegmentGroup(ngModule,sortedRoutes,child,childOutlet).pipe(operators.map(s=>({segment:s,outlet:childOutlet})))}),operators.scan((children,expandedChild)=>{children[expandedChild.outlet]=expandedChild.segment;return children},{}),operators.last())}expandSegment(ngModule,
segmentGroup,routes,segments,outlet,allowRedirects){return rxjs.from(routes).pipe(operators.concatMap(r=>{const expanded$=this.expandSegmentAgainstRoute(ngModule,segmentGroup,routes,r,segments,outlet,allowRedirects);return expanded$.pipe(operators.catchError(e=>{if(e instanceof NoMatch$1)return rxjs.of(null);throw e;}))}),operators.first(s=>!!s),operators.catchError((e,_)=>{if(e instanceof rxjs.EmptyError||e.name==="EmptyError"){if(noLeftoversInUrl(segmentGroup,segments,outlet))return rxjs.of(new UrlSegmentGroup([],
{}));throw new NoMatch$1(segmentGroup);}throw e;}))}expandSegmentAgainstRoute(ngModule,segmentGroup,routes,route,paths,outlet,allowRedirects){if(!isImmediateMatch(route,segmentGroup,paths,outlet))return noMatch(segmentGroup);if(route.redirectTo===undefined)return this.matchSegmentAgainstRoute(ngModule,segmentGroup,route,paths,outlet);if(allowRedirects&&this.allowRedirects)return this.expandSegmentAgainstRouteUsingRedirect(ngModule,segmentGroup,routes,route,paths,outlet);return noMatch(segmentGroup)}expandSegmentAgainstRouteUsingRedirect(ngModule,
segmentGroup,routes,route,segments,outlet){if(route.path==="**")return this.expandWildCardWithParamsAgainstRouteUsingRedirect(ngModule,routes,route,outlet);return this.expandRegularSegmentAgainstRouteUsingRedirect(ngModule,segmentGroup,routes,route,segments,outlet)}expandWildCardWithParamsAgainstRouteUsingRedirect(ngModule,routes,route,outlet){const newTree=this.applyRedirectCommands([],route.redirectTo,{});if(route.redirectTo.startsWith("/"))return absoluteRedirect(newTree);return this.lineralizeSegments(route,
newTree).pipe(operators.mergeMap(newSegments=>{const group=new UrlSegmentGroup(newSegments,{});return this.expandSegment(ngModule,group,routes,newSegments,outlet,false)}))}expandRegularSegmentAgainstRouteUsingRedirect(ngModule,segmentGroup,routes,route,segments,outlet){const {matched,consumedSegments,lastChild,positionalParamSegments}=match(segmentGroup,route,segments);if(!matched)return noMatch(segmentGroup);const newTree=this.applyRedirectCommands(consumedSegments,route.redirectTo,positionalParamSegments);
if(route.redirectTo.startsWith("/"))return absoluteRedirect(newTree);return this.lineralizeSegments(route,newTree).pipe(operators.mergeMap(newSegments=>{return this.expandSegment(ngModule,segmentGroup,routes,newSegments.concat(segments.slice(lastChild)),outlet,false)}))}matchSegmentAgainstRoute(ngModule,rawSegmentGroup,route,segments,outlet){if(route.path==="**"){if(route.loadChildren){const loaded$=route._loadedConfig?rxjs.of(route._loadedConfig):this.configLoader.load(ngModule.injector,route);return loaded$.pipe(operators.map(cfg=>
{route._loadedConfig=cfg;return new UrlSegmentGroup(segments,{})}))}return rxjs.of(new UrlSegmentGroup(segments,{}))}const {matched,consumedSegments,lastChild}=match(rawSegmentGroup,route,segments);if(!matched)return noMatch(rawSegmentGroup);const rawSlicedSegments=segments.slice(lastChild);const childConfig$=this.getChildConfig(ngModule,route,segments);return childConfig$.pipe(operators.mergeMap(routerConfig=>{const childModule=routerConfig.module;const childConfig=routerConfig.routes;const {segmentGroup:splitSegmentGroup,
slicedSegments}=split(rawSegmentGroup,consumedSegments,rawSlicedSegments,childConfig);const segmentGroup=new UrlSegmentGroup(splitSegmentGroup.segments,splitSegmentGroup.children);if(slicedSegments.length===0&&segmentGroup.hasChildren()){const expanded$=this.expandChildren(childModule,childConfig,segmentGroup);return expanded$.pipe(operators.map(children=>new UrlSegmentGroup(consumedSegments,children)))}if(childConfig.length===0&&slicedSegments.length===0)return rxjs.of(new UrlSegmentGroup(consumedSegments,
{}));const matchedOnOutlet=getOutlet(route)===outlet;const expanded$=this.expandSegment(childModule,segmentGroup,childConfig,slicedSegments,matchedOnOutlet?PRIMARY_OUTLET:outlet,true);return expanded$.pipe(operators.map(cs=>new UrlSegmentGroup(consumedSegments.concat(cs.segments),cs.children)))}))}getChildConfig(ngModule,route,segments){if(route.children)return rxjs.of(new LoadedRouterConfig(route.children,ngModule));if(route.loadChildren){if(route._loadedConfig!==undefined)return rxjs.of(route._loadedConfig);
return this.runCanLoadGuards(ngModule.injector,route,segments).pipe(operators.mergeMap(shouldLoadResult=>{if(shouldLoadResult)return this.configLoader.load(ngModule.injector,route).pipe(operators.map(cfg=>{route._loadedConfig=cfg;return cfg}));return canLoadFails(route)}))}return rxjs.of(new LoadedRouterConfig([],ngModule))}runCanLoadGuards(moduleInjector,route,segments){const canLoad=route.canLoad;if(!canLoad||canLoad.length===0)return rxjs.of(true);const canLoadObservables=canLoad.map(injectionToken=>
{const guard=moduleInjector.get(injectionToken);let guardVal;if(isCanLoad(guard))guardVal=guard.canLoad(route,segments);else if(isFunction(guard))guardVal=guard(route,segments);else throw new Error("Invalid CanLoad guard");return wrapIntoObservable(guardVal)});return rxjs.of(canLoadObservables).pipe(prioritizedGuardValue(),operators.tap(result=>{if(!isUrlTree(result))return;const error=navigationCancelingError(`Redirecting to "${this.urlSerializer.serialize(result)}"`);error.url=result;throw error;
}),operators.map(result=>result===true))}lineralizeSegments(route,urlTree){let res=[];let c=urlTree.root;while(true){res=res.concat(c.segments);if(c.numberOfChildren===0)return rxjs.of(res);if(c.numberOfChildren>1||!c.children[PRIMARY_OUTLET])return namedOutletsRedirect(route.redirectTo);c=c.children[PRIMARY_OUTLET]}}applyRedirectCommands(segments,redirectTo,posParams){return this.applyRedirectCreatreUrlTree(redirectTo,this.urlSerializer.parse(redirectTo),segments,posParams)}applyRedirectCreatreUrlTree(redirectTo,
urlTree,segments,posParams){const newRoot=this.createSegmentGroup(redirectTo,urlTree.root,segments,posParams);return new UrlTree(newRoot,this.createQueryParams(urlTree.queryParams,this.urlTree.queryParams),urlTree.fragment)}createQueryParams(redirectToParams,actualParams){const res={};forEach(redirectToParams,(v,k)=>{const copySourceValue=typeof v==="string"&&v.startsWith(":");if(copySourceValue){const sourceName=v.substring(1);res[k]=actualParams[sourceName]}else res[k]=v});return res}createSegmentGroup(redirectTo,
group,segments,posParams){const updatedSegments=this.createSegments(redirectTo,group.segments,segments,posParams);let children={};forEach(group.children,(child,name)=>{children[name]=this.createSegmentGroup(redirectTo,child,segments,posParams)});return new UrlSegmentGroup(updatedSegments,children)}createSegments(redirectTo,redirectToSegments,actualSegments,posParams){return redirectToSegments.map(s=>s.path.startsWith(":")?this.findPosParam(redirectTo,s,posParams):this.findOrReturn(s,actualSegments))}findPosParam(redirectTo,
redirectToUrlSegment,posParams){const pos=posParams[redirectToUrlSegment.path.substring(1)];if(!pos)throw new Error(`Cannot redirect to '${redirectTo}'. Cannot find '${redirectToUrlSegment.path}'.`);return pos}findOrReturn(redirectToUrlSegment,actualSegments){let idx=0;for(const s of actualSegments){if(s.path===redirectToUrlSegment.path){actualSegments.splice(idx);return s}idx++}return redirectToUrlSegment}}function mergeTrivialChildren(s){if(s.numberOfChildren===1&&s.children[PRIMARY_OUTLET]){const c=
s.children[PRIMARY_OUTLET];return new UrlSegmentGroup(s.segments.concat(c.segments),c.children)}return s}function squashSegmentGroup(segmentGroup){const newChildren={};for(const childOutlet of Object.keys(segmentGroup.children)){const child=segmentGroup.children[childOutlet];const childCandidate=squashSegmentGroup(child);if(childCandidate.segments.length>0||childCandidate.hasChildren())newChildren[childOutlet]=childCandidate}const s=new UrlSegmentGroup(segmentGroup.segments,newChildren);return mergeTrivialChildren(s)}
function applyRedirects(moduleInjector,configLoader,urlSerializer,config){return operators.switchMap(t=>applyRedirects$1(moduleInjector,configLoader,urlSerializer,t.extractedUrl,config).pipe(operators.map(urlAfterRedirects=>Object.assign(Object.assign({},t),{urlAfterRedirects}))))}class CanActivate{constructor(path){this.path=path;this.route=this.path[this.path.length-1]}}class CanDeactivate{constructor(component,route){this.component=component;this.route=route}}function getAllRouteGuards(future,
curr,parentContexts){const futureRoot=future._root;const currRoot=curr?curr._root:null;return getChildRouteGuards(futureRoot,currRoot,parentContexts,[futureRoot.value])}function getCanActivateChild(p){const canActivateChild=p.routeConfig?p.routeConfig.canActivateChild:null;if(!canActivateChild||canActivateChild.length===0)return null;return{node:p,guards:canActivateChild}}function getToken(token,snapshot,moduleInjector){const config=getClosestLoadedConfig(snapshot);const injector=config?config.module.injector:
moduleInjector;return injector.get(token)}function getClosestLoadedConfig(snapshot){if(!snapshot)return null;for(let s=snapshot.parent;s;s=s.parent){const route=s.routeConfig;if(route&&route._loadedConfig)return route._loadedConfig}return null}function getChildRouteGuards(futureNode,currNode,contexts,futurePath,checks={canDeactivateChecks:[],canActivateChecks:[]}){const prevChildren=nodeChildrenAsMap(currNode);futureNode.children.forEach(c=>{getRouteGuards(c,prevChildren[c.value.outlet],contexts,
futurePath.concat([c.value]),checks);delete prevChildren[c.value.outlet]});forEach(prevChildren,(v,k)=>deactivateRouteAndItsChildren(v,contexts.getContext(k),checks));return checks}function getRouteGuards(futureNode,currNode,parentContexts,futurePath,checks={canDeactivateChecks:[],canActivateChecks:[]}){const future=futureNode.value;const curr=currNode?currNode.value:null;const context=parentContexts?parentContexts.getContext(futureNode.value.outlet):null;if(curr&&future.routeConfig===curr.routeConfig){const shouldRun=
shouldRunGuardsAndResolvers(curr,future,future.routeConfig.runGuardsAndResolvers);if(shouldRun)checks.canActivateChecks.push(new CanActivate(futurePath));else{future.data=curr.data;future._resolvedData=curr._resolvedData}if(future.component)getChildRouteGuards(futureNode,currNode,context?context.children:null,futurePath,checks);else getChildRouteGuards(futureNode,currNode,parentContexts,futurePath,checks);if(shouldRun&&context&&context.outlet&&context.outlet.isActivated)checks.canDeactivateChecks.push(new CanDeactivate(context.outlet.component,
curr))}else{if(curr)deactivateRouteAndItsChildren(currNode,context,checks);checks.canActivateChecks.push(new CanActivate(futurePath));if(future.component)getChildRouteGuards(futureNode,null,context?context.children:null,futurePath,checks);else getChildRouteGuards(futureNode,null,parentContexts,futurePath,checks)}return checks}function shouldRunGuardsAndResolvers(curr,future,mode){if(typeof mode==="function")return mode(curr,future);switch(mode){case "pathParamsChange":return!equalPath(curr.url,future.url);
case "pathParamsOrQueryParamsChange":return!equalPath(curr.url,future.url)||!shallowEqual(curr.queryParams,future.queryParams);case "always":return true;case "paramsOrQueryParamsChange":return!equalParamsAndUrlSegments(curr,future)||!shallowEqual(curr.queryParams,future.queryParams);case "paramsChange":default:return!equalParamsAndUrlSegments(curr,future)}}function deactivateRouteAndItsChildren(route,context,checks){const children=nodeChildrenAsMap(route);const r=route.value;forEach(children,(node,
childName)=>{if(!r.component)deactivateRouteAndItsChildren(node,context,checks);else if(context)deactivateRouteAndItsChildren(node,context.children.getContext(childName),checks);else deactivateRouteAndItsChildren(node,null,checks)});if(!r.component)checks.canDeactivateChecks.push(new CanDeactivate(null,r));else if(context&&context.outlet&&context.outlet.isActivated)checks.canDeactivateChecks.push(new CanDeactivate(context.outlet.component,r));else checks.canDeactivateChecks.push(new CanDeactivate(null,
r))}function checkGuards(moduleInjector,forwardEvent){return operators.mergeMap(t=>{const {targetSnapshot,currentSnapshot,guards:{canActivateChecks,canDeactivateChecks}}=t;if(canDeactivateChecks.length===0&&canActivateChecks.length===0)return rxjs.of(Object.assign(Object.assign({},t),{guardsResult:true}));return runCanDeactivateChecks(canDeactivateChecks,targetSnapshot,currentSnapshot,moduleInjector).pipe(operators.mergeMap(canDeactivate=>{return canDeactivate&&isBoolean(canDeactivate)?runCanActivateChecks(targetSnapshot,
canActivateChecks,moduleInjector,forwardEvent):rxjs.of(canDeactivate)}),operators.map(guardsResult=>Object.assign(Object.assign({},t),{guardsResult})))})}function runCanDeactivateChecks(checks,futureRSS,currRSS,moduleInjector){return rxjs.from(checks).pipe(operators.mergeMap(check=>runCanDeactivate(check.component,check.route,currRSS,futureRSS,moduleInjector)),operators.first(result=>{return result!==true},true))}function runCanActivateChecks(futureSnapshot,checks,moduleInjector,forwardEvent){return rxjs.from(checks).pipe(operators.concatMap(check=>
{return rxjs.concat(fireChildActivationStart(check.route.parent,forwardEvent),fireActivationStart(check.route,forwardEvent),runCanActivateChild(futureSnapshot,check.path,moduleInjector),runCanActivate(futureSnapshot,check.route,moduleInjector))}),operators.first(result=>{return result!==true},true))}function fireActivationStart(snapshot,forwardEvent){if(snapshot!==null&&forwardEvent)forwardEvent(new ActivationStart(snapshot));return rxjs.of(true)}function fireChildActivationStart(snapshot,forwardEvent){if(snapshot!==
null&&forwardEvent)forwardEvent(new ChildActivationStart(snapshot));return rxjs.of(true)}function runCanActivate(futureRSS,futureARS,moduleInjector){const canActivate=futureARS.routeConfig?futureARS.routeConfig.canActivate:null;if(!canActivate||canActivate.length===0)return rxjs.of(true);const canActivateObservables=canActivate.map(c=>{return rxjs.defer(()=>{const guard=getToken(c,futureARS,moduleInjector);let observable;if(isCanActivate(guard))observable=wrapIntoObservable(guard.canActivate(futureARS,
futureRSS));else if(isFunction(guard))observable=wrapIntoObservable(guard(futureARS,futureRSS));else throw new Error("Invalid CanActivate guard");return observable.pipe(operators.first())})});return rxjs.of(canActivateObservables).pipe(prioritizedGuardValue())}function runCanActivateChild(futureRSS,path,moduleInjector){const futureARS=path[path.length-1];const canActivateChildGuards=path.slice(0,path.length-1).reverse().map(p=>getCanActivateChild(p)).filter(_=>_!==null);const canActivateChildGuardsMapped=
canActivateChildGuards.map(d=>{return rxjs.defer(()=>{const guardsMapped=d.guards.map(c=>{const guard=getToken(c,d.node,moduleInjector);let observable;if(isCanActivateChild(guard))observable=wrapIntoObservable(guard.canActivateChild(futureARS,futureRSS));else if(isFunction(guard))observable=wrapIntoObservable(guard(futureARS,futureRSS));else throw new Error("Invalid CanActivateChild guard");return observable.pipe(operators.first())});return rxjs.of(guardsMapped).pipe(prioritizedGuardValue())})});
return rxjs.of(canActivateChildGuardsMapped).pipe(prioritizedGuardValue())}function runCanDeactivate(component,currARS,currRSS,futureRSS,moduleInjector){const canDeactivate=currARS&&currARS.routeConfig?currARS.routeConfig.canDeactivate:null;if(!canDeactivate||canDeactivate.length===0)return rxjs.of(true);const canDeactivateObservables=canDeactivate.map(c=>{const guard=getToken(c,currARS,moduleInjector);let observable;if(isCanDeactivate(guard))observable=wrapIntoObservable(guard.canDeactivate(component,
currARS,currRSS,futureRSS));else if(isFunction(guard))observable=wrapIntoObservable(guard(component,currARS,currRSS,futureRSS));else throw new Error("Invalid CanDeactivate guard");return observable.pipe(operators.first())});return rxjs.of(canDeactivateObservables).pipe(prioritizedGuardValue())}class NoMatch{}function newObservableError(e){return new rxjs.Observable(obs=>obs.error(e))}function recognize$1(rootComponentType,config,urlTree,url,paramsInheritanceStrategy="emptyOnly",relativeLinkResolution=
"legacy"){try{const result=(new Recognizer(rootComponentType,config,urlTree,url,paramsInheritanceStrategy,relativeLinkResolution)).recognize();if(result===null)return newObservableError(new NoMatch);else return rxjs.of(result)}catch(e){return newObservableError(e)}}class Recognizer{constructor(rootComponentType,config,urlTree,url,paramsInheritanceStrategy,relativeLinkResolution){this.rootComponentType=rootComponentType;this.config=config;this.urlTree=urlTree;this.url=url;this.paramsInheritanceStrategy=
paramsInheritanceStrategy;this.relativeLinkResolution=relativeLinkResolution}recognize(){const rootSegmentGroup=split(this.urlTree.root,[],[],this.config.filter(c=>c.redirectTo===undefined),this.relativeLinkResolution).segmentGroup;const children=this.processSegmentGroup(this.config,rootSegmentGroup,PRIMARY_OUTLET);if(children===null)return null;const root=new ActivatedRouteSnapshot([],Object.freeze({}),Object.freeze(Object.assign({},this.urlTree.queryParams)),this.urlTree.fragment,{},PRIMARY_OUTLET,
this.rootComponentType,null,this.urlTree.root,-1,{});const rootNode=new TreeNode(root,children);const routeState=new RouterStateSnapshot(this.url,rootNode);this.inheritParamsAndData(routeState._root);return routeState}inheritParamsAndData(routeNode){const route=routeNode.value;const i=inheritedParamsDataResolve(route,this.paramsInheritanceStrategy);route.params=Object.freeze(i.params);route.data=Object.freeze(i.data);routeNode.children.forEach(n=>this.inheritParamsAndData(n))}processSegmentGroup(config,
segmentGroup,outlet){if(segmentGroup.segments.length===0&&segmentGroup.hasChildren())return this.processChildren(config,segmentGroup);return this.processSegment(config,segmentGroup,segmentGroup.segments,outlet)}processChildren(config,segmentGroup){const children=[];for(const childOutlet of Object.keys(segmentGroup.children)){const child=segmentGroup.children[childOutlet];const sortedConfig=sortByMatchingOutlets(config,childOutlet);const outletChildren=this.processSegmentGroup(sortedConfig,child,childOutlet);
if(outletChildren===null)return null;children.push(...outletChildren)}const mergedChildren=mergeEmptyPathMatches(children);if(typeof ngDevMode==="undefined"||ngDevMode)checkOutletNameUniqueness(mergedChildren);sortActivatedRouteSnapshots(mergedChildren);return mergedChildren}processSegment(config,segmentGroup,segments,outlet){for(const r of config){const children=this.processSegmentAgainstRoute(r,segmentGroup,segments,outlet);if(children!==null)return children}if(noLeftoversInUrl(segmentGroup,segments,
outlet))return[];return null}processSegmentAgainstRoute(route,rawSegment,segments,outlet){if(route.redirectTo||!isImmediateMatch(route,rawSegment,segments,outlet))return null;let snapshot;let consumedSegments=[];let rawSlicedSegments=[];if(route.path==="**"){const params=segments.length>0?last(segments).parameters:{};snapshot=new ActivatedRouteSnapshot(segments,params,Object.freeze(Object.assign({},this.urlTree.queryParams)),this.urlTree.fragment,getData(route),getOutlet(route),route.component,route,
getSourceSegmentGroup(rawSegment),getPathIndexShift(rawSegment)+segments.length,getResolve(route))}else{const result=match(rawSegment,route,segments);if(!result.matched)return null;consumedSegments=result.consumedSegments;rawSlicedSegments=segments.slice(result.lastChild);snapshot=new ActivatedRouteSnapshot(consumedSegments,result.parameters,Object.freeze(Object.assign({},this.urlTree.queryParams)),this.urlTree.fragment,getData(route),getOutlet(route),route.component,route,getSourceSegmentGroup(rawSegment),
getPathIndexShift(rawSegment)+consumedSegments.length,getResolve(route))}const childConfig=getChildConfig(route);const {segmentGroup,slicedSegments}=split(rawSegment,consumedSegments,rawSlicedSegments,childConfig.filter(c=>c.redirectTo===undefined),this.relativeLinkResolution);if(slicedSegments.length===0&&segmentGroup.hasChildren()){const children=this.processChildren(childConfig,segmentGroup);if(children===null)return null;return[new TreeNode(snapshot,children)]}if(childConfig.length===0&&slicedSegments.length===
0)return[new TreeNode(snapshot,[])];const matchedOnOutlet=getOutlet(route)===outlet;const children=this.processSegment(childConfig,segmentGroup,slicedSegments,matchedOnOutlet?PRIMARY_OUTLET:outlet);if(children===null)return null;return[new TreeNode(snapshot,children)]}}function sortActivatedRouteSnapshots(nodes){nodes.sort((a,b)=>{if(a.value.outlet===PRIMARY_OUTLET)return-1;if(b.value.outlet===PRIMARY_OUTLET)return 1;return a.value.outlet.localeCompare(b.value.outlet)})}function getChildConfig(route){if(route.children)return route.children;
if(route.loadChildren)return route._loadedConfig.routes;return[]}function hasEmptyPathConfig(node){const config=node.value.routeConfig;return config&&config.path===""&&config.redirectTo===undefined}function mergeEmptyPathMatches(nodes){const result=[];const mergedNodes=new Set;for(const node of nodes){if(!hasEmptyPathConfig(node)){result.push(node);continue}const duplicateEmptyPathNode=result.find(resultNode=>node.value.routeConfig===resultNode.value.routeConfig);if(duplicateEmptyPathNode!==undefined){duplicateEmptyPathNode.children.push(...node.children);
mergedNodes.add(duplicateEmptyPathNode)}else result.push(node)}for(const mergedNode of mergedNodes){const mergedChildren=mergeEmptyPathMatches(mergedNode.children);result.push(new TreeNode(mergedNode.value,mergedChildren))}return result.filter(n=>!mergedNodes.has(n))}function checkOutletNameUniqueness(nodes){const names={};nodes.forEach(n=>{const routeWithSameOutletName=names[n.value.outlet];if(routeWithSameOutletName){const p=routeWithSameOutletName.url.map(s=>s.toString()).join("/");const c=n.value.url.map(s=>
s.toString()).join("/");throw new Error(`Two segments cannot have the same outlet name: '${p}' and '${c}'.`);}names[n.value.outlet]=n.value})}function getSourceSegmentGroup(segmentGroup){let s=segmentGroup;while(s._sourceSegment)s=s._sourceSegment;return s}function getPathIndexShift(segmentGroup){let s=segmentGroup;let res=s._segmentIndexShift?s._segmentIndexShift:0;while(s._sourceSegment){s=s._sourceSegment;res+=s._segmentIndexShift?s._segmentIndexShift:0}return res-1}function getData(route){return route.data||
{}}function getResolve(route){return route.resolve||{}}function recognize(rootComponentType,config,serializer,paramsInheritanceStrategy,relativeLinkResolution){return operators.mergeMap(t=>recognize$1(rootComponentType,config,t.urlAfterRedirects,serializer(t.urlAfterRedirects),paramsInheritanceStrategy,relativeLinkResolution).pipe(operators.map(targetSnapshot=>Object.assign(Object.assign({},t),{targetSnapshot}))))}function resolveData(paramsInheritanceStrategy,moduleInjector){return operators.mergeMap(t=>
{const {targetSnapshot,guards:{canActivateChecks}}=t;if(!canActivateChecks.length)return rxjs.of(t);let canActivateChecksResolved=0;return rxjs.from(canActivateChecks).pipe(operators.concatMap(check=>runResolve(check.route,targetSnapshot,paramsInheritanceStrategy,moduleInjector)),operators.tap(()=>canActivateChecksResolved++),operators.takeLast(1),operators.mergeMap(_=>canActivateChecksResolved===canActivateChecks.length?rxjs.of(t):rxjs.EMPTY))})}function runResolve(futureARS,futureRSS,paramsInheritanceStrategy,
moduleInjector){const resolve=futureARS._resolve;return resolveNode(resolve,futureARS,futureRSS,moduleInjector).pipe(operators.map(resolvedData=>{futureARS._resolvedData=resolvedData;futureARS.data=Object.assign(Object.assign({},futureARS.data),inheritedParamsDataResolve(futureARS,paramsInheritanceStrategy).resolve);return null}))}function resolveNode(resolve,futureARS,futureRSS,moduleInjector){const keys=Object.keys(resolve);if(keys.length===0)return rxjs.of({});const data={};return rxjs.from(keys).pipe(operators.mergeMap(key=>
getResolver(resolve[key],futureARS,futureRSS,moduleInjector).pipe(operators.tap(value=>{data[key]=value}))),operators.takeLast(1),operators.mergeMap(()=>{if(Object.keys(data).length===keys.length)return rxjs.of(data);return rxjs.EMPTY}))}function getResolver(injectionToken,futureARS,futureRSS,moduleInjector){const resolver=getToken(injectionToken,futureARS,moduleInjector);return resolver.resolve?wrapIntoObservable(resolver.resolve(futureARS,futureRSS)):wrapIntoObservable(resolver(futureARS,futureRSS))}
function switchTap(next){return operators.switchMap(v=>{const nextResult=next(v);if(nextResult)return rxjs.from(nextResult).pipe(operators.map(()=>v));return rxjs.of(v)})}class RouteReuseStrategy{}class BaseRouteReuseStrategy{shouldDetach(route){return false}store(route,detachedTree){}shouldAttach(route){return false}retrieve(route){return null}shouldReuseRoute(future,curr){return future.routeConfig===curr.routeConfig}}class DefaultRouteReuseStrategy extends BaseRouteReuseStrategy{}const ROUTES=new i0.InjectionToken("ROUTES");
class RouterConfigLoader{constructor(injector,compiler,onLoadStartListener,onLoadEndListener){this.injector=injector;this.compiler=compiler;this.onLoadStartListener=onLoadStartListener;this.onLoadEndListener=onLoadEndListener}load(parentInjector,route){if(route._loader$)return route._loader$;if(this.onLoadStartListener)this.onLoadStartListener(route);const moduleFactory$=this.loadModuleFactory(route.loadChildren);const loadRunner=moduleFactory$.pipe(operators.map(factory=>{if(this.onLoadEndListener)this.onLoadEndListener(route);
const module=factory.create(parentInjector);return new LoadedRouterConfig(flatten(module.injector.get(ROUTES,undefined,i0.InjectFlags.Self|i0.InjectFlags.Optional)).map(standardizeConfig),module)}),operators.catchError(err=>{route._loader$=undefined;throw err;}));route._loader$=(new rxjs.ConnectableObservable(loadRunner,()=>new rxjs.Subject)).pipe(operators.refCount());return route._loader$}loadModuleFactory(loadChildren){return wrapIntoObservable(loadChildren()).pipe(operators.mergeMap(t=>{if(t instanceof
i0.NgModuleFactory)return rxjs.of(t);else return rxjs.from(this.compiler.compileModuleAsync(t))}))}}class UrlHandlingStrategy{}class DefaultUrlHandlingStrategy{shouldProcessUrl(url){return true}extract(url){return url}merge(newUrlPart,wholeUrl){return newUrlPart}}function defaultErrorHandler(error){throw error;}function defaultMalformedUriErrorHandler(error,urlSerializer,url){return urlSerializer.parse("/")}function defaultRouterHook(snapshot,runExtras){return rxjs.of(null)}const exactMatchOptions=
{paths:"exact",fragment:"ignored",matrixParams:"ignored",queryParams:"exact"};const subsetMatchOptions={paths:"subset",fragment:"ignored",matrixParams:"ignored",queryParams:"subset"};class Router{constructor(rootComponentType,urlSerializer,rootContexts,location,injector,compiler,config){this.rootComponentType=rootComponentType;this.urlSerializer=urlSerializer;this.rootContexts=rootContexts;this.location=location;this.config=config;this.lastSuccessfulNavigation=null;this.currentNavigation=null;this.disposed=
false;this.navigationId=0;this.currentPageId=0;this.isNgZoneEnabled=false;this.events=new rxjs.Subject;this.errorHandler=defaultErrorHandler;this.malformedUriErrorHandler=defaultMalformedUriErrorHandler;this.navigated=false;this.lastSuccessfulId=-1;this.hooks={beforePreactivation:defaultRouterHook,afterPreactivation:defaultRouterHook};this.urlHandlingStrategy=new DefaultUrlHandlingStrategy;this.routeReuseStrategy=new DefaultRouteReuseStrategy;this.onSameUrlNavigation="ignore";this.paramsInheritanceStrategy=
"emptyOnly";this.urlUpdateStrategy="deferred";this.relativeLinkResolution="corrected";this.canceledNavigationResolution="replace";const onLoadStart=r=>this.triggerEvent(new RouteConfigLoadStart(r));const onLoadEnd=r=>this.triggerEvent(new RouteConfigLoadEnd(r));this.ngModule=injector.get(i0.NgModuleRef);this.console=injector.get(i0["ɵConsole"]);const ngZone=injector.get(i0.NgZone);this.isNgZoneEnabled=ngZone instanceof i0.NgZone&&i0.NgZone.isInAngularZone();this.resetConfig(config);this.currentUrlTree=
createEmptyUrlTree();this.rawUrlTree=this.currentUrlTree;this.browserUrlTree=this.currentUrlTree;this.configLoader=new RouterConfigLoader(injector,compiler,onLoadStart,onLoadEnd);this.routerState=createEmptyState(this.currentUrlTree,this.rootComponentType);this.transitions=new rxjs.BehaviorSubject({id:0,targetPageId:0,currentUrlTree:this.currentUrlTree,currentRawUrl:this.currentUrlTree,extractedUrl:this.urlHandlingStrategy.extract(this.currentUrlTree),urlAfterRedirects:this.urlHandlingStrategy.extract(this.currentUrlTree),
rawUrl:this.currentUrlTree,extras:{},resolve:null,reject:null,promise:Promise.resolve(true),source:"imperative",restoredState:null,currentSnapshot:this.routerState.snapshot,targetSnapshot:null,currentRouterState:this.routerState,targetRouterState:null,guards:{canActivateChecks:[],canDeactivateChecks:[]},guardsResult:null});this.navigations=this.setupNavigations(this.transitions);this.processNavigations()}get browserPageId(){var _a;return(_a=this.location.getState())===null||_a===void 0?void 0:_a.\u0275routerPageId}setupNavigations(transitions){const eventsSubject=
this.events;return transitions.pipe(operators.filter(t=>t.id!==0),operators.map(t=>Object.assign(Object.assign({},t),{extractedUrl:this.urlHandlingStrategy.extract(t.rawUrl)})),operators.switchMap(t=>{let completed=false;let errored=false;return rxjs.of(t).pipe(operators.tap(t=>{this.currentNavigation={id:t.id,initialUrl:t.currentRawUrl,extractedUrl:t.extractedUrl,trigger:t.source,extras:t.extras,previousNavigation:this.lastSuccessfulNavigation?Object.assign(Object.assign({},this.lastSuccessfulNavigation),
{previousNavigation:null}):null}}),operators.switchMap(t=>{const browserUrlTree=this.browserUrlTree.toString();const urlTransition=!this.navigated||t.extractedUrl.toString()!==browserUrlTree||browserUrlTree!==this.currentUrlTree.toString();const processCurrentUrl=(this.onSameUrlNavigation==="reload"?true:urlTransition)&&this.urlHandlingStrategy.shouldProcessUrl(t.rawUrl);if(processCurrentUrl){if(isBrowserTriggeredNavigation(t.source))this.browserUrlTree=t.extractedUrl;return rxjs.of(t).pipe(operators.switchMap(t=>
{const transition=this.transitions.getValue();eventsSubject.next(new NavigationStart(t.id,this.serializeUrl(t.extractedUrl),t.source,t.restoredState));if(transition!==this.transitions.getValue())return rxjs.EMPTY;return Promise.resolve(t)}),applyRedirects(this.ngModule.injector,this.configLoader,this.urlSerializer,this.config),operators.tap(t=>{this.currentNavigation=Object.assign(Object.assign({},this.currentNavigation),{finalUrl:t.urlAfterRedirects})}),recognize(this.rootComponentType,this.config,
url=>this.serializeUrl(url),this.paramsInheritanceStrategy,this.relativeLinkResolution),operators.tap(t=>{if(this.urlUpdateStrategy==="eager"){if(!t.extras.skipLocationChange){const rawUrl=this.urlHandlingStrategy.merge(t.urlAfterRedirects,t.rawUrl);this.setBrowserUrl(rawUrl,t)}this.browserUrlTree=t.urlAfterRedirects}const routesRecognized=new RoutesRecognized(t.id,this.serializeUrl(t.extractedUrl),this.serializeUrl(t.urlAfterRedirects),t.targetSnapshot);eventsSubject.next(routesRecognized)}))}else{const processPreviousUrl=
urlTransition&&this.rawUrlTree&&this.urlHandlingStrategy.shouldProcessUrl(this.rawUrlTree);if(processPreviousUrl){const {id,extractedUrl,source,restoredState,extras}=t;const navStart=new NavigationStart(id,this.serializeUrl(extractedUrl),source,restoredState);eventsSubject.next(navStart);const targetSnapshot=createEmptyState(extractedUrl,this.rootComponentType).snapshot;return rxjs.of(Object.assign(Object.assign({},t),{targetSnapshot,urlAfterRedirects:extractedUrl,extras:Object.assign(Object.assign({},
extras),{skipLocationChange:false,replaceUrl:false})}))}else{this.rawUrlTree=t.rawUrl;t.resolve(null);return rxjs.EMPTY}}}),switchTap(t=>{const {targetSnapshot,id:navigationId,extractedUrl:appliedUrlTree,rawUrl:rawUrlTree,extras:{skipLocationChange,replaceUrl}}=t;return this.hooks.beforePreactivation(targetSnapshot,{navigationId,appliedUrlTree,rawUrlTree,skipLocationChange:!!skipLocationChange,replaceUrl:!!replaceUrl})}),operators.tap(t=>{const guardsStart=new GuardsCheckStart(t.id,this.serializeUrl(t.extractedUrl),
this.serializeUrl(t.urlAfterRedirects),t.targetSnapshot);this.triggerEvent(guardsStart)}),operators.map(t=>Object.assign(Object.assign({},t),{guards:getAllRouteGuards(t.targetSnapshot,t.currentSnapshot,this.rootContexts)})),checkGuards(this.ngModule.injector,evt=>this.triggerEvent(evt)),operators.tap(t=>{if(isUrlTree(t.guardsResult)){const error=navigationCancelingError(`Redirecting to "${this.serializeUrl(t.guardsResult)}"`);error.url=t.guardsResult;throw error;}const guardsEnd=new GuardsCheckEnd(t.id,
this.serializeUrl(t.extractedUrl),this.serializeUrl(t.urlAfterRedirects),t.targetSnapshot,!!t.guardsResult);this.triggerEvent(guardsEnd)}),operators.filter(t=>{if(!t.guardsResult){this.restoreHistory(t);this.cancelNavigationTransition(t,"");return false}return true}),switchTap(t=>{if(t.guards.canActivateChecks.length)return rxjs.of(t).pipe(operators.tap(t=>{const resolveStart=new ResolveStart(t.id,this.serializeUrl(t.extractedUrl),this.serializeUrl(t.urlAfterRedirects),t.targetSnapshot);this.triggerEvent(resolveStart)}),
operators.switchMap(t=>{let dataResolved=false;return rxjs.of(t).pipe(resolveData(this.paramsInheritanceStrategy,this.ngModule.injector),operators.tap({next:()=>dataResolved=true,complete:()=>{if(!dataResolved){this.restoreHistory(t);this.cancelNavigationTransition(t,`At least one route resolver didn't emit any value.`)}}}))}),operators.tap(t=>{const resolveEnd=new ResolveEnd(t.id,this.serializeUrl(t.extractedUrl),this.serializeUrl(t.urlAfterRedirects),t.targetSnapshot);this.triggerEvent(resolveEnd)}));
return undefined}),switchTap(t=>{const {targetSnapshot,id:navigationId,extractedUrl:appliedUrlTree,rawUrl:rawUrlTree,extras:{skipLocationChange,replaceUrl}}=t;return this.hooks.afterPreactivation(targetSnapshot,{navigationId,appliedUrlTree,rawUrlTree,skipLocationChange:!!skipLocationChange,replaceUrl:!!replaceUrl})}),operators.map(t=>{const targetRouterState=createRouterState(this.routeReuseStrategy,t.targetSnapshot,t.currentRouterState);return Object.assign(Object.assign({},t),{targetRouterState})}),
operators.tap(t=>{this.currentUrlTree=t.urlAfterRedirects;this.rawUrlTree=this.urlHandlingStrategy.merge(t.urlAfterRedirects,t.rawUrl);this.routerState=t.targetRouterState;if(this.urlUpdateStrategy==="deferred"){if(!t.extras.skipLocationChange)this.setBrowserUrl(this.rawUrlTree,t);this.browserUrlTree=t.urlAfterRedirects}}),activateRoutes(this.rootContexts,this.routeReuseStrategy,evt=>this.triggerEvent(evt)),operators.tap({next(){completed=true},complete(){completed=true}}),operators.finalize(()=>
{var _a;if(!completed&&!errored){const cancelationReason=`Navigation ID ${t.id} is not equal to the current navigation id ${this.navigationId}`;this.cancelNavigationTransition(t,cancelationReason)}if(((_a=this.currentNavigation)===null||_a===void 0?void 0:_a.id)===t.id)this.currentNavigation=null}),operators.catchError(e=>{errored=true;if(isNavigationCancelingError(e)){const redirecting=isUrlTree(e.url);if(!redirecting){this.navigated=true;this.restoreHistory(t,true)}const navCancel=new NavigationCancel(t.id,
this.serializeUrl(t.extractedUrl),e.message);eventsSubject.next(navCancel);if(!redirecting)t.resolve(false);else setTimeout(()=>{const mergedTree=this.urlHandlingStrategy.merge(e.url,this.rawUrlTree);const extras={skipLocationChange:t.extras.skipLocationChange,replaceUrl:this.urlUpdateStrategy==="eager"||isBrowserTriggeredNavigation(t.source)};this.scheduleNavigation(mergedTree,"imperative",null,extras,{resolve:t.resolve,reject:t.reject,promise:t.promise})},0)}else{this.restoreHistory(t,true);const navError=
new NavigationError(t.id,this.serializeUrl(t.extractedUrl),e);eventsSubject.next(navError);try{t.resolve(this.errorHandler(e))}catch(ee){t.reject(ee)}}return rxjs.EMPTY}))}))}resetRootComponentType(rootComponentType){this.rootComponentType=rootComponentType;this.routerState.root.component=this.rootComponentType}setTransition(t){this.transitions.next(Object.assign(Object.assign({},this.transitions.value),t))}initialNavigation(){this.setUpLocationChangeListener();if(this.navigationId===0)this.navigateByUrl(this.location.path(true),
{replaceUrl:true})}setUpLocationChangeListener(){if(!this.locationSubscription)this.locationSubscription=this.location.subscribe(event=>{const source=event["type"]==="popstate"?"popstate":"hashchange";if(source==="popstate")setTimeout(()=>{var _a;const extras={replaceUrl:true};const state=((_a=event.state)===null||_a===void 0?void 0:_a.navigationId)?event.state:null;if(state){const stateCopy=Object.assign({},state);delete stateCopy.navigationId;delete stateCopy.\u0275routerPageId;if(Object.keys(stateCopy).length!==
0)extras.state=stateCopy}const urlTree=this.parseUrl(event["url"]);this.scheduleNavigation(urlTree,source,state,extras)},0)})}get url(){return this.serializeUrl(this.currentUrlTree)}getCurrentNavigation(){return this.currentNavigation}triggerEvent(event){this.events.next(event)}resetConfig(config){validateConfig(config);this.config=config.map(standardizeConfig);this.navigated=false;this.lastSuccessfulId=-1}ngOnDestroy(){this.dispose()}dispose(){this.transitions.complete();if(this.locationSubscription){this.locationSubscription.unsubscribe();
this.locationSubscription=undefined}this.disposed=true}createUrlTree(commands,navigationExtras={}){const {relativeTo,queryParams,fragment,queryParamsHandling,preserveFragment}=navigationExtras;const a=relativeTo||this.routerState.root;const f=preserveFragment?this.currentUrlTree.fragment:fragment;let q=null;switch(queryParamsHandling){case "merge":q=Object.assign(Object.assign({},this.currentUrlTree.queryParams),queryParams);break;case "preserve":q=this.currentUrlTree.queryParams;break;default:q=
queryParams||null}if(q!==null)q=this.removeEmptyProps(q);return createUrlTree(a,this.currentUrlTree,commands,q,f!==null&&f!==void 0?f:null)}navigateByUrl(url,extras={skipLocationChange:false}){if(typeof ngDevMode==="undefined"||ngDevMode&&this.isNgZoneEnabled&&!i0.NgZone.isInAngularZone())this.console.warn(`Navigation triggered outside Angular zone, did you forget to call 'ngZone.run()'?`);const urlTree=isUrlTree(url)?url:this.parseUrl(url);const mergedTree=this.urlHandlingStrategy.merge(urlTree,
this.rawUrlTree);return this.scheduleNavigation(mergedTree,"imperative",null,extras)}navigate(commands,extras={skipLocationChange:false}){validateCommands(commands);return this.navigateByUrl(this.createUrlTree(commands,extras),extras)}serializeUrl(url){return this.urlSerializer.serialize(url)}parseUrl(url){let urlTree;try{urlTree=this.urlSerializer.parse(url)}catch(e){urlTree=this.malformedUriErrorHandler(e,this.urlSerializer,url)}return urlTree}isActive(url,matchOptions){let options;if(matchOptions===
true)options=Object.assign({},exactMatchOptions);else if(matchOptions===false)options=Object.assign({},subsetMatchOptions);else options=matchOptions;if(isUrlTree(url))return containsTree(this.currentUrlTree,url,options);const urlTree=this.parseUrl(url);return containsTree(this.currentUrlTree,urlTree,options)}removeEmptyProps(params){return Object.keys(params).reduce((result,key)=>{const value=params[key];if(value!==null&&value!==undefined)result[key]=value;return result},{})}processNavigations(){this.navigations.subscribe(t=>
{this.navigated=true;this.lastSuccessfulId=t.id;this.currentPageId=t.targetPageId;this.events.next(new NavigationEnd(t.id,this.serializeUrl(t.extractedUrl),this.serializeUrl(this.currentUrlTree)));this.lastSuccessfulNavigation=this.currentNavigation;t.resolve(true)},e=>{this.console.warn(`Unhandled Navigation Error: ${e}`)})}scheduleNavigation(rawUrl,source,restoredState,extras,priorPromise){var _a,_b,_c;if(this.disposed)return Promise.resolve(false);const lastNavigation=this.transitions.value;const browserNavPrecededByRouterNav=
isBrowserTriggeredNavigation(source)&&lastNavigation&&!isBrowserTriggeredNavigation(lastNavigation.source);const navToSameUrl=lastNavigation.rawUrl.toString()===rawUrl.toString();const lastNavigationInProgress=lastNavigation.id===((_a=this.currentNavigation)===null||_a===void 0?void 0:_a.id);const isDuplicateNav=navToSameUrl&&lastNavigationInProgress;if(browserNavPrecededByRouterNav&&isDuplicateNav)return Promise.resolve(true);let resolve;let reject;let promise;if(priorPromise){resolve=priorPromise.resolve;
reject=priorPromise.reject;promise=priorPromise.promise}else promise=new Promise((res,rej)=>{resolve=res;reject=rej});const id=++this.navigationId;let targetPageId;if(this.canceledNavigationResolution==="computed"){const isInitialPage=this.currentPageId===0;if(isInitialPage)restoredState=this.location.getState();if(restoredState&&restoredState.\u0275routerPageId)targetPageId=restoredState.\u0275routerPageId;else if(extras.replaceUrl||extras.skipLocationChange)targetPageId=(_b=this.browserPageId)!==
null&&_b!==void 0?_b:0;else targetPageId=((_c=this.browserPageId)!==null&&_c!==void 0?_c:0)+1}else targetPageId=0;this.setTransition({id,targetPageId,source,restoredState,currentUrlTree:this.currentUrlTree,currentRawUrl:this.rawUrlTree,rawUrl,extras,resolve,reject,promise,currentSnapshot:this.routerState.snapshot,currentRouterState:this.routerState});return promise.catch(e=>{return Promise.reject(e)})}setBrowserUrl(url,t){const path=this.urlSerializer.serialize(url);const state=Object.assign(Object.assign({},
t.extras.state),this.generateNgRouterState(t.id,t.targetPageId));if(this.location.isCurrentPathEqualTo(path)||!!t.extras.replaceUrl)this.location.replaceState(path,"",state);else this.location.go(path,"",state)}restoreHistory(t,restoringFromCaughtError=false){var _a,_b;if(this.canceledNavigationResolution==="computed"){const targetPagePosition=this.currentPageId-t.targetPageId;const browserUrlUpdateOccurred=t.source==="popstate"||this.urlUpdateStrategy==="eager"||this.currentUrlTree===((_a=this.currentNavigation)===
null||_a===void 0?void 0:_a.finalUrl);if(browserUrlUpdateOccurred&&targetPagePosition!==0)this.location.historyGo(targetPagePosition);else if(this.currentUrlTree===((_b=this.currentNavigation)===null||_b===void 0?void 0:_b.finalUrl)&&targetPagePosition===0){this.resetState(t);this.browserUrlTree=t.currentUrlTree;this.resetUrlToCurrentUrlTree()}else;}else if(this.canceledNavigationResolution==="replace"){if(restoringFromCaughtError)this.resetState(t);this.resetUrlToCurrentUrlTree()}}resetState(t){this.routerState=
t.currentRouterState;this.currentUrlTree=t.currentUrlTree;this.rawUrlTree=this.urlHandlingStrategy.merge(this.currentUrlTree,t.rawUrl)}resetUrlToCurrentUrlTree(){this.location.replaceState(this.urlSerializer.serialize(this.rawUrlTree),"",this.generateNgRouterState(this.lastSuccessfulId,this.currentPageId))}cancelNavigationTransition(t,reason){const navCancel=new NavigationCancel(t.id,this.serializeUrl(t.extractedUrl),reason);this.triggerEvent(navCancel);t.resolve(false)}generateNgRouterState(navigationId,
routerPageId){if(this.canceledNavigationResolution==="computed")return{navigationId,"ɵrouterPageId":routerPageId};return{navigationId}}}Router.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:Router,deps:"invalid",target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});Router.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:Router});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",
version:"13.1.3",ngImport:i0__namespace,type:Router,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:i0__namespace.Type},{type:UrlSerializer},{type:ChildrenOutletContexts},{type:i3__namespace.Location},{type:i0__namespace.Injector},{type:i0__namespace.Compiler},{type:undefined}]}});function validateCommands(commands){for(let i=0;i<commands.length;i++){const cmd=commands[i];if(cmd==null)throw new Error(`The requested path contains ${cmd} segment at index ${i}`);}}function isBrowserTriggeredNavigation(source){return source!==
"imperative"}class RouterLink{constructor(router,route,tabIndexAttribute,renderer,el){this.router=router;this.route=route;this.tabIndexAttribute=tabIndexAttribute;this.renderer=renderer;this.el=el;this.commands=null;this.onChanges=new rxjs.Subject;this.setTabIndexIfNotOnNativeEl("0")}setTabIndexIfNotOnNativeEl(newTabIndex){if(this.tabIndexAttribute!=null)return;const renderer=this.renderer;const nativeElement=this.el.nativeElement;if(newTabIndex!==null)renderer.setAttribute(nativeElement,"tabindex",
newTabIndex);else renderer.removeAttribute(nativeElement,"tabindex")}ngOnChanges(changes){this.onChanges.next(this)}set routerLink(commands){if(commands!=null){this.commands=Array.isArray(commands)?commands:[commands];this.setTabIndexIfNotOnNativeEl("0")}else{this.commands=null;this.setTabIndexIfNotOnNativeEl(null)}}onClick(){if(this.urlTree===null)return true;const extras={skipLocationChange:attrBoolValue(this.skipLocationChange),replaceUrl:attrBoolValue(this.replaceUrl),state:this.state};this.router.navigateByUrl(this.urlTree,
extras);return true}get urlTree(){if(this.commands===null)return null;return this.router.createUrlTree(this.commands,{relativeTo:this.relativeTo!==undefined?this.relativeTo:this.route,queryParams:this.queryParams,fragment:this.fragment,queryParamsHandling:this.queryParamsHandling,preserveFragment:attrBoolValue(this.preserveFragment)})}}RouterLink.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:RouterLink,deps:[{token:Router},{token:ActivatedRoute},
{token:"tabindex",attribute:true},{token:i0__namespace.Renderer2},{token:i0__namespace.ElementRef}],target:i0__namespace.\u0275\u0275FactoryTarget.Directive});RouterLink.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.1.3",type:RouterLink,selector:":not(a):not(area)[routerLink]",inputs:{queryParams:"queryParams",fragment:"fragment",queryParamsHandling:"queryParamsHandling",preserveFragment:"preserveFragment",skipLocationChange:"skipLocationChange",replaceUrl:"replaceUrl",
state:"state",relativeTo:"relativeTo",routerLink:"routerLink"},host:{listeners:{"click":"onClick()"}},usesOnChanges:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:RouterLink,decorators:[{type:i0.Directive,args:[{selector:":not(a):not(area)[routerLink]"}]}],ctorParameters:function(){return[{type:Router},{type:ActivatedRoute},{type:undefined,decorators:[{type:i0.Attribute,args:["tabindex"]}]},{type:i0__namespace.Renderer2},
{type:i0__namespace.ElementRef}]},propDecorators:{queryParams:[{type:i0.Input}],fragment:[{type:i0.Input}],queryParamsHandling:[{type:i0.Input}],preserveFragment:[{type:i0.Input}],skipLocationChange:[{type:i0.Input}],replaceUrl:[{type:i0.Input}],state:[{type:i0.Input}],relativeTo:[{type:i0.Input}],routerLink:[{type:i0.Input}],onClick:[{type:i0.HostListener,args:["click"]}]}});class RouterLinkWithHref{constructor(router,route,locationStrategy){this.router=router;this.route=route;this.locationStrategy=
locationStrategy;this.commands=null;this.href=null;this.onChanges=new rxjs.Subject;this.subscription=router.events.subscribe(s=>{if(s instanceof NavigationEnd)this.updateTargetUrlAndHref()})}set routerLink(commands){if(commands!=null)this.commands=Array.isArray(commands)?commands:[commands];else this.commands=null}ngOnChanges(changes){this.updateTargetUrlAndHref();this.onChanges.next(this)}ngOnDestroy(){this.subscription.unsubscribe()}onClick(button,ctrlKey,shiftKey,altKey,metaKey){if(button!==0||
ctrlKey||shiftKey||altKey||metaKey)return true;if(typeof this.target==="string"&&this.target!="_self"||this.urlTree===null)return true;const extras={skipLocationChange:attrBoolValue(this.skipLocationChange),replaceUrl:attrBoolValue(this.replaceUrl),state:this.state};this.router.navigateByUrl(this.urlTree,extras);return false}updateTargetUrlAndHref(){this.href=this.urlTree!==null?this.locationStrategy.prepareExternalUrl(this.router.serializeUrl(this.urlTree)):null}get urlTree(){if(this.commands===
null)return null;return this.router.createUrlTree(this.commands,{relativeTo:this.relativeTo!==undefined?this.relativeTo:this.route,queryParams:this.queryParams,fragment:this.fragment,queryParamsHandling:this.queryParamsHandling,preserveFragment:attrBoolValue(this.preserveFragment)})}}RouterLinkWithHref.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:RouterLinkWithHref,deps:[{token:Router},{token:ActivatedRoute},{token:i3__namespace.LocationStrategy}],
target:i0__namespace.\u0275\u0275FactoryTarget.Directive});RouterLinkWithHref.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.1.3",type:RouterLinkWithHref,selector:"a[routerLink],area[routerLink]",inputs:{target:"target",queryParams:"queryParams",fragment:"fragment",queryParamsHandling:"queryParamsHandling",preserveFragment:"preserveFragment",skipLocationChange:"skipLocationChange",replaceUrl:"replaceUrl",state:"state",relativeTo:"relativeTo",routerLink:"routerLink"},
host:{listeners:{"click":"onClick($event.button,$event.ctrlKey,$event.shiftKey,$event.altKey,$event.metaKey)"},properties:{"attr.target":"this.target","attr.href":"this.href"}},usesOnChanges:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:RouterLinkWithHref,decorators:[{type:i0.Directive,args:[{selector:"a[routerLink],area[routerLink]"}]}],ctorParameters:function(){return[{type:Router},{type:ActivatedRoute},
{type:i3__namespace.LocationStrategy}]},propDecorators:{target:[{type:i0.HostBinding,args:["attr.target"]},{type:i0.Input}],queryParams:[{type:i0.Input}],fragment:[{type:i0.Input}],queryParamsHandling:[{type:i0.Input}],preserveFragment:[{type:i0.Input}],skipLocationChange:[{type:i0.Input}],replaceUrl:[{type:i0.Input}],state:[{type:i0.Input}],relativeTo:[{type:i0.Input}],href:[{type:i0.HostBinding,args:["attr.href"]}],routerLink:[{type:i0.Input}],onClick:[{type:i0.HostListener,args:["click",["$event.button",
"$event.ctrlKey","$event.shiftKey","$event.altKey","$event.metaKey"]]}]}});function attrBoolValue(s){return s===""||!!s}class RouterLinkActive{constructor(router,element,renderer,cdr,link,linkWithHref){this.router=router;this.element=element;this.renderer=renderer;this.cdr=cdr;this.link=link;this.linkWithHref=linkWithHref;this.classes=[];this.isActive=false;this.routerLinkActiveOptions={exact:false};this.isActiveChange=new i0.EventEmitter;this.routerEventsSubscription=router.events.subscribe(s=>{if(s instanceof
NavigationEnd)this.update()})}ngAfterContentInit(){rxjs.of(this.links.changes,this.linksWithHrefs.changes,rxjs.of(null)).pipe(operators.mergeAll()).subscribe(_=>{this.update();this.subscribeToEachLinkOnChanges()})}subscribeToEachLinkOnChanges(){var _a;(_a=this.linkInputChangesSubscription)===null||_a===void 0?void 0:_a.unsubscribe();const allLinkChanges=[...this.links.toArray(),...this.linksWithHrefs.toArray(),this.link,this.linkWithHref].filter(link=>!!link).map(link=>link.onChanges);this.linkInputChangesSubscription=
rxjs.from(allLinkChanges).pipe(operators.mergeAll()).subscribe(link=>{if(this.isActive!==this.isLinkActive(this.router)(link))this.update()})}set routerLinkActive(data){const classes=Array.isArray(data)?data:data.split(" ");this.classes=classes.filter(c=>!!c)}ngOnChanges(changes){this.update()}ngOnDestroy(){var _a;this.routerEventsSubscription.unsubscribe();(_a=this.linkInputChangesSubscription)===null||_a===void 0?void 0:_a.unsubscribe()}update(){if(!this.links||!this.linksWithHrefs||!this.router.navigated)return;
Promise.resolve().then(()=>{const hasActiveLinks=this.hasActiveLinks();if(this.isActive!==hasActiveLinks){this.isActive=hasActiveLinks;this.cdr.markForCheck();this.classes.forEach(c=>{if(hasActiveLinks)this.renderer.addClass(this.element.nativeElement,c);else this.renderer.removeClass(this.element.nativeElement,c)});this.isActiveChange.emit(hasActiveLinks)}})}isLinkActive(router){const options=isActiveMatchOptions(this.routerLinkActiveOptions)?this.routerLinkActiveOptions:this.routerLinkActiveOptions.exact||
false;return link=>link.urlTree?router.isActive(link.urlTree,options):false}hasActiveLinks(){const isActiveCheckFn=this.isLinkActive(this.router);return this.link&&isActiveCheckFn(this.link)||this.linkWithHref&&isActiveCheckFn(this.linkWithHref)||this.links.some(isActiveCheckFn)||this.linksWithHrefs.some(isActiveCheckFn)}}RouterLinkActive.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:RouterLinkActive,deps:[{token:Router},{token:i0__namespace.ElementRef},
{token:i0__namespace.Renderer2},{token:i0__namespace.ChangeDetectorRef},{token:RouterLink,optional:true},{token:RouterLinkWithHref,optional:true}],target:i0__namespace.\u0275\u0275FactoryTarget.Directive});RouterLinkActive.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.1.3",type:RouterLinkActive,selector:"[routerLinkActive]",inputs:{routerLinkActiveOptions:"routerLinkActiveOptions",routerLinkActive:"routerLinkActive"},outputs:{isActiveChange:"isActiveChange"},
queries:[{propertyName:"links",predicate:RouterLink,descendants:true},{propertyName:"linksWithHrefs",predicate:RouterLinkWithHref,descendants:true}],exportAs:["routerLinkActive"],usesOnChanges:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:RouterLinkActive,decorators:[{type:i0.Directive,args:[{selector:"[routerLinkActive]",exportAs:"routerLinkActive"}]}],ctorParameters:function(){return[{type:Router},
{type:i0__namespace.ElementRef},{type:i0__namespace.Renderer2},{type:i0__namespace.ChangeDetectorRef},{type:RouterLink,decorators:[{type:i0.Optional}]},{type:RouterLinkWithHref,decorators:[{type:i0.Optional}]}]},propDecorators:{links:[{type:i0.ContentChildren,args:[RouterLink,{descendants:true}]}],linksWithHrefs:[{type:i0.ContentChildren,args:[RouterLinkWithHref,{descendants:true}]}],routerLinkActiveOptions:[{type:i0.Input}],isActiveChange:[{type:i0.Output}],routerLinkActive:[{type:i0.Input}]}});
function isActiveMatchOptions(options){return!!options.paths}class PreloadingStrategy{}class PreloadAllModules{preload(route,fn){return fn().pipe(operators.catchError(()=>rxjs.of(null)))}}class NoPreloading{preload(route,fn){return rxjs.of(null)}}class RouterPreloader{constructor(router,compiler,injector,preloadingStrategy){this.router=router;this.injector=injector;this.preloadingStrategy=preloadingStrategy;const onStartLoad=r=>router.triggerEvent(new RouteConfigLoadStart(r));const onEndLoad=r=>router.triggerEvent(new RouteConfigLoadEnd(r));
this.loader=new RouterConfigLoader(injector,compiler,onStartLoad,onEndLoad)}setUpPreloading(){this.subscription=this.router.events.pipe(operators.filter(e=>e instanceof NavigationEnd),operators.concatMap(()=>this.preload())).subscribe(()=>{})}preload(){const ngModule=this.injector.get(i0.NgModuleRef);return this.processRoutes(ngModule,this.router.config)}ngOnDestroy(){if(this.subscription)this.subscription.unsubscribe()}processRoutes(ngModule,routes){const res=[];for(const route of routes)if(route.loadChildren&&
!route.canLoad&&route._loadedConfig){const childConfig=route._loadedConfig;res.push(this.processRoutes(childConfig.module,childConfig.routes))}else if(route.loadChildren&&!route.canLoad)res.push(this.preloadConfig(ngModule,route));else if(route.children)res.push(this.processRoutes(ngModule,route.children));return rxjs.from(res).pipe(operators.mergeAll(),operators.map(_=>void 0))}preloadConfig(ngModule,route){return this.preloadingStrategy.preload(route,()=>{const loaded$=route._loadedConfig?rxjs.of(route._loadedConfig):
this.loader.load(ngModule.injector,route);return loaded$.pipe(operators.mergeMap(config=>{route._loadedConfig=config;return this.processRoutes(config.module,config.routes)}))})}}RouterPreloader.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:RouterPreloader,deps:[{token:Router},{token:i0__namespace.Compiler},{token:i0__namespace.Injector},{token:PreloadingStrategy}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});RouterPreloader.\u0275prov=
i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:RouterPreloader});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:RouterPreloader,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:Router},{type:i0__namespace.Compiler},{type:i0__namespace.Injector},{type:PreloadingStrategy}]}});class RouterScroller{constructor(router,viewportScroller,options={}){this.router=
router;this.viewportScroller=viewportScroller;this.options=options;this.lastId=0;this.lastSource="imperative";this.restoredId=0;this.store={};options.scrollPositionRestoration=options.scrollPositionRestoration||"disabled";options.anchorScrolling=options.anchorScrolling||"disabled"}init(){if(this.options.scrollPositionRestoration!=="disabled")this.viewportScroller.setHistoryScrollRestoration("manual");this.routerEventsSubscription=this.createScrollEvents();this.scrollEventsSubscription=this.consumeScrollEvents()}createScrollEvents(){return this.router.events.subscribe(e=>
{if(e instanceof NavigationStart){this.store[this.lastId]=this.viewportScroller.getScrollPosition();this.lastSource=e.navigationTrigger;this.restoredId=e.restoredState?e.restoredState.navigationId:0}else if(e instanceof NavigationEnd){this.lastId=e.id;this.scheduleScrollEvent(e,this.router.parseUrl(e.urlAfterRedirects).fragment)}})}consumeScrollEvents(){return this.router.events.subscribe(e=>{if(!(e instanceof Scroll))return;if(e.position)if(this.options.scrollPositionRestoration==="top")this.viewportScroller.scrollToPosition([0,
0]);else{if(this.options.scrollPositionRestoration==="enabled")this.viewportScroller.scrollToPosition(e.position)}else if(e.anchor&&this.options.anchorScrolling==="enabled")this.viewportScroller.scrollToAnchor(e.anchor);else if(this.options.scrollPositionRestoration!=="disabled")this.viewportScroller.scrollToPosition([0,0])})}scheduleScrollEvent(routerEvent,anchor){this.router.triggerEvent(new Scroll(routerEvent,this.lastSource==="popstate"?this.store[this.restoredId]:null,anchor))}ngOnDestroy(){if(this.routerEventsSubscription)this.routerEventsSubscription.unsubscribe();
if(this.scrollEventsSubscription)this.scrollEventsSubscription.unsubscribe()}}RouterScroller.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:RouterScroller,deps:"invalid",target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});RouterScroller.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:RouterScroller});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",
version:"13.1.3",ngImport:i0__namespace,type:RouterScroller,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:Router},{type:i3__namespace.ViewportScroller},{type:undefined}]}});const ROUTER_DIRECTIVES=[RouterOutlet,RouterLink,RouterLinkWithHref,RouterLinkActive,\u0275EmptyOutletComponent];const ROUTER_CONFIGURATION=new i0.InjectionToken("ROUTER_CONFIGURATION");const ROUTER_FORROOT_GUARD=new i0.InjectionToken("ROUTER_FORROOT_GUARD");const ROUTER_PROVIDERS=[i3.Location,{provide:UrlSerializer,
useClass:DefaultUrlSerializer},{provide:Router,useFactory:setupRouter,deps:[UrlSerializer,ChildrenOutletContexts,i3.Location,i0.Injector,i0.Compiler,ROUTES,ROUTER_CONFIGURATION,[UrlHandlingStrategy,new i0.Optional],[RouteReuseStrategy,new i0.Optional]]},ChildrenOutletContexts,{provide:ActivatedRoute,useFactory:rootRoute,deps:[Router]},RouterPreloader,NoPreloading,PreloadAllModules,{provide:ROUTER_CONFIGURATION,useValue:{enableTracing:false}}];function routerNgProbeToken(){return new i0.NgProbeToken("Router",
Router)}class RouterModule{constructor(guard,router){}static forRoot(routes,config){return{ngModule:RouterModule,providers:[ROUTER_PROVIDERS,provideRoutes(routes),{provide:ROUTER_FORROOT_GUARD,useFactory:provideForRootGuard,deps:[[Router,new i0.Optional,new i0.SkipSelf]]},{provide:ROUTER_CONFIGURATION,useValue:config?config:{}},{provide:i3.LocationStrategy,useFactory:provideLocationStrategy,deps:[i3.PlatformLocation,[new i0.Inject(i3.APP_BASE_HREF),new i0.Optional],ROUTER_CONFIGURATION]},{provide:RouterScroller,
useFactory:createRouterScroller,deps:[Router,i3.ViewportScroller,ROUTER_CONFIGURATION]},{provide:PreloadingStrategy,useExisting:config&&config.preloadingStrategy?config.preloadingStrategy:NoPreloading},{provide:i0.NgProbeToken,multi:true,useFactory:routerNgProbeToken},provideRouterInitializer()]}}static forChild(routes){return{ngModule:RouterModule,providers:[provideRoutes(routes)]}}}RouterModule.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,
type:RouterModule,deps:[{token:ROUTER_FORROOT_GUARD,optional:true},{token:Router,optional:true}],target:i0__namespace.\u0275\u0275FactoryTarget.NgModule});RouterModule.\u0275mod=i0__namespace.\u0275\u0275ngDeclareNgModule({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:RouterModule,declarations:[RouterOutlet,RouterLink,RouterLinkWithHref,RouterLinkActive,\u0275EmptyOutletComponent],exports:[RouterOutlet,RouterLink,RouterLinkWithHref,RouterLinkActive,\u0275EmptyOutletComponent]});
RouterModule.\u0275inj=i0__namespace.\u0275\u0275ngDeclareInjector({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:RouterModule});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:RouterModule,decorators:[{type:i0.NgModule,args:[{declarations:ROUTER_DIRECTIVES,exports:ROUTER_DIRECTIVES}]}],ctorParameters:function(){return[{type:undefined,decorators:[{type:i0.Optional},{type:i0.Inject,args:[ROUTER_FORROOT_GUARD]}]},
{type:Router,decorators:[{type:i0.Optional}]}]}});function createRouterScroller(router,viewportScroller,config){if(config.scrollOffset)viewportScroller.setOffset(config.scrollOffset);return new RouterScroller(router,viewportScroller,config)}function provideLocationStrategy(platformLocationStrategy,baseHref,options={}){return options.useHash?new i3.HashLocationStrategy(platformLocationStrategy,baseHref):new i3.PathLocationStrategy(platformLocationStrategy,baseHref)}function provideForRootGuard(router){if((typeof ngDevMode===
"undefined"||ngDevMode)&&router)throw new Error(`RouterModule.forRoot() called twice. Lazy loaded modules should use RouterModule.forChild() instead.`);return"guarded"}function provideRoutes(routes){return[{provide:i0.ANALYZE_FOR_ENTRY_COMPONENTS,multi:true,useValue:routes},{provide:ROUTES,multi:true,useValue:routes}]}function setupRouter(urlSerializer,contexts,location,injector,compiler,config,opts={},urlHandlingStrategy,routeReuseStrategy){const router=new Router(null,urlSerializer,contexts,location,
injector,compiler,flatten(config));if(urlHandlingStrategy)router.urlHandlingStrategy=urlHandlingStrategy;if(routeReuseStrategy)router.routeReuseStrategy=routeReuseStrategy;assignExtraOptionsToRouter(opts,router);if(opts.enableTracing)router.events.subscribe(e=>{var _a,_b;(_a=console.group)===null||_a===void 0?void 0:_a.call(console,`Router Event: ${e.constructor.name}`);console.log(e.toString());console.log(e);(_b=console.groupEnd)===null||_b===void 0?void 0:_b.call(console)});return router}function assignExtraOptionsToRouter(opts,
router){if(opts.errorHandler)router.errorHandler=opts.errorHandler;if(opts.malformedUriErrorHandler)router.malformedUriErrorHandler=opts.malformedUriErrorHandler;if(opts.onSameUrlNavigation)router.onSameUrlNavigation=opts.onSameUrlNavigation;if(opts.paramsInheritanceStrategy)router.paramsInheritanceStrategy=opts.paramsInheritanceStrategy;if(opts.relativeLinkResolution)router.relativeLinkResolution=opts.relativeLinkResolution;if(opts.urlUpdateStrategy)router.urlUpdateStrategy=opts.urlUpdateStrategy;
if(opts.canceledNavigationResolution)router.canceledNavigationResolution=opts.canceledNavigationResolution}function rootRoute(router){return router.routerState.root}class RouterInitializer{constructor(injector){this.injector=injector;this.initNavigation=false;this.destroyed=false;this.resultOfPreactivationDone=new rxjs.Subject}appInitializer(){const p=this.injector.get(i3.LOCATION_INITIALIZED,Promise.resolve(null));return p.then(()=>{if(this.destroyed)return Promise.resolve(true);let resolve=null;
const res=new Promise(r=>resolve=r);const router=this.injector.get(Router);const opts=this.injector.get(ROUTER_CONFIGURATION);if(opts.initialNavigation==="disabled"){router.setUpLocationChangeListener();resolve(true)}else if(opts.initialNavigation==="enabled"||opts.initialNavigation==="enabledBlocking"){router.hooks.afterPreactivation=()=>{if(!this.initNavigation){this.initNavigation=true;resolve(true);return this.resultOfPreactivationDone}else return rxjs.of(null)};router.initialNavigation()}else resolve(true);
return res})}bootstrapListener(bootstrappedComponentRef){const opts=this.injector.get(ROUTER_CONFIGURATION);const preloader=this.injector.get(RouterPreloader);const routerScroller=this.injector.get(RouterScroller);const router=this.injector.get(Router);const ref=this.injector.get(i0.ApplicationRef);if(bootstrappedComponentRef!==ref.components[0])return;if(opts.initialNavigation==="enabledNonBlocking"||opts.initialNavigation===undefined)router.initialNavigation();preloader.setUpPreloading();routerScroller.init();
router.resetRootComponentType(ref.componentTypes[0]);this.resultOfPreactivationDone.next(null);this.resultOfPreactivationDone.complete()}ngOnDestroy(){this.destroyed=true}}RouterInitializer.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:RouterInitializer,deps:[{token:i0__namespace.Injector}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});RouterInitializer.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",
version:"13.1.3",ngImport:i0__namespace,type:RouterInitializer});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:RouterInitializer,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:i0__namespace.Injector}]}});function getAppInitializer(r){return r.appInitializer.bind(r)}function getBootstrapListener(r){return r.bootstrapListener.bind(r)}const ROUTER_INITIALIZER=new i0.InjectionToken("Router Initializer");function provideRouterInitializer(){return[RouterInitializer,
{provide:i0.APP_INITIALIZER,multi:true,useFactory:getAppInitializer,deps:[RouterInitializer]},{provide:ROUTER_INITIALIZER,useFactory:getBootstrapListener,deps:[RouterInitializer]},{provide:i0.APP_BOOTSTRAP_LISTENER,multi:true,useExisting:ROUTER_INITIALIZER}]}const VERSION=new i0.Version("13.1.3");exports.ActivatedRoute=ActivatedRoute;exports.ActivatedRouteSnapshot=ActivatedRouteSnapshot;exports.ActivationEnd=ActivationEnd;exports.ActivationStart=ActivationStart;exports.BaseRouteReuseStrategy=BaseRouteReuseStrategy;
exports.ChildActivationEnd=ChildActivationEnd;exports.ChildActivationStart=ChildActivationStart;exports.ChildrenOutletContexts=ChildrenOutletContexts;exports.DefaultUrlSerializer=DefaultUrlSerializer;exports.GuardsCheckEnd=GuardsCheckEnd;exports.GuardsCheckStart=GuardsCheckStart;exports.NavigationCancel=NavigationCancel;exports.NavigationEnd=NavigationEnd;exports.NavigationError=NavigationError;exports.NavigationStart=NavigationStart;exports.NoPreloading=NoPreloading;exports.OutletContext=OutletContext;
exports.PRIMARY_OUTLET=PRIMARY_OUTLET;exports.PreloadAllModules=PreloadAllModules;exports.PreloadingStrategy=PreloadingStrategy;exports.ROUTER_CONFIGURATION=ROUTER_CONFIGURATION;exports.ROUTER_INITIALIZER=ROUTER_INITIALIZER;exports.ROUTES=ROUTES;exports.ResolveEnd=ResolveEnd;exports.ResolveStart=ResolveStart;exports.RouteConfigLoadEnd=RouteConfigLoadEnd;exports.RouteConfigLoadStart=RouteConfigLoadStart;exports.RouteReuseStrategy=RouteReuseStrategy;exports.Router=Router;exports.RouterEvent=RouterEvent;
exports.RouterLink=RouterLink;exports.RouterLinkActive=RouterLinkActive;exports.RouterLinkWithHref=RouterLinkWithHref;exports.RouterModule=RouterModule;exports.RouterOutlet=RouterOutlet;exports.RouterPreloader=RouterPreloader;exports.RouterState=RouterState;exports.RouterStateSnapshot=RouterStateSnapshot;exports.RoutesRecognized=RoutesRecognized;exports.Scroll=Scroll;exports.UrlHandlingStrategy=UrlHandlingStrategy;exports.UrlSegment=UrlSegment;exports.UrlSegmentGroup=UrlSegmentGroup;exports.UrlSerializer=
UrlSerializer;exports.UrlTree=UrlTree;exports.VERSION=VERSION;exports.convertToParamMap=convertToParamMap;exports.provideRoutes=provideRoutes;exports["ɵEmptyOutletComponent"]=\u0275EmptyOutletComponent;exports["ɵROUTER_PROVIDERS"]=ROUTER_PROVIDERS;exports["ɵassignExtraOptionsToRouter"]=assignExtraOptionsToRouter;exports["ɵflatten"]=flatten;Object.defineProperty(exports,"__esModule",{value:true})});

