/*

 Copyright Google LLC All Rights Reserved.

 Use of this source code is governed by an MIT-style license that can be
 found in the LICENSE file at https://angular.io/license
 Angular v13.1.3
 (c) 2010-2022 Google LLC. https://angular.io/
 License: MIT
*/
'use strict';(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports,require("@angular/core"),require("tslib"),require("@angular/platform-browser-dynamic")):typeof define==="function"&&define.amd?define(["exports","@angular/core","tslib","@angular/platform-browser-dynamic"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory((global.ng=global.ng||{},global.ng.Upgrade={}),global.i0,global.tslib,global.platformBrowserDynamic))})(this,
function(exports,i0,tslib,platformBrowserDynamic){function _interopNamespace(e){if(e&&e.__esModule)return e;var n=Object.create(null);if(e)Object.keys(e).forEach(function(k){if(k!=="default"){var d=Object.getOwnPropertyDescriptor(e,k);Object.defineProperty(n,k,d.get?d:{enumerable:true,get:function(){return e[k]}})}});n["default"]=e;return Object.freeze(n)}var i0__namespace=_interopNamespace(i0);const VERSION=new i0.Version("13.1.3");function noNg(){throw new Error("AngularJS v1.x is not loaded!");
}const noNgElement=()=>noNg();noNgElement.cleanData=noNg;let angular={bootstrap:noNg,module:noNg,element:noNgElement,injector:noNg,version:undefined,resumeBootstrap:noNg,getTestability:noNg};try{if(window.hasOwnProperty("angular"))angular=window.angular}catch(_a){}const bootstrap=(e,modules,config)=>angular.bootstrap(e,modules,config);const module_=(prefix,dependencies)=>angular.module(prefix,dependencies);const element=e=>angular.element(e);element.cleanData=nodes=>angular.element.cleanData(nodes);
const $COMPILE="$compile";const $CONTROLLER="$controller";const $HTTP_BACKEND="$httpBackend";const $INJECTOR="$injector";const $PARSE="$parse";const $ROOT_ELEMENT="$rootElement";const $ROOT_SCOPE="$rootScope";const $SCOPE="$scope";const $TEMPLATE_CACHE="$templateCache";const $$TESTABILITY="$$testability";const COMPILER_KEY="$$angularCompiler";const DOWNGRADED_MODULE_COUNT_KEY="$$angularDowngradedModuleCount";const INJECTOR_KEY="$$angularInjector";const LAZY_MODULE_REF="$$angularLazyModuleRef";const NG_ZONE_KEY=
"$$angularNgZone";const UPGRADE_APP_TYPE_KEY="$$angularUpgradeAppType";const REQUIRE_INJECTOR="?^^"+INJECTOR_KEY;const REQUIRE_NG_MODEL="?ngModel";class PropertyBinding{constructor(prop,attr){this.prop=prop;this.attr=attr;this.parseBinding()}parseBinding(){this.bracketAttr=`[${this.attr}]`;this.parenAttr=`(${this.attr})`;this.bracketParenAttr=`[(${this.attr})]`;const capitalAttr=this.attr.charAt(0).toUpperCase()+this.attr.substr(1);this.onAttr=`on${capitalAttr}`;this.bindAttr=`bind${capitalAttr}`;
this.bindonAttr=`bindon${capitalAttr}`}}const DIRECTIVE_PREFIX_REGEXP=/^(?:x|data)[:\-_]/i;const DIRECTIVE_SPECIAL_CHARS_REGEXP=/[:\-_]+(.)/g;function onError(e){if(console.error)console.error(e,e.stack);else console.log(e,e.stack);throw e;}function cleanData(node){element.cleanData([node]);if(isParentNode(node))element.cleanData(node.querySelectorAll("*"))}function controllerKey(name){return"$"+name+"Controller"}function destroyApp($injector){const $rootElement=$injector.get($ROOT_ELEMENT);const $rootScope=
$injector.get($ROOT_SCOPE);$rootScope.$destroy();cleanData($rootElement[0])}function directiveNormalize(name){return name.replace(DIRECTIVE_PREFIX_REGEXP,"").replace(DIRECTIVE_SPECIAL_CHARS_REGEXP,(_,letter)=>letter.toUpperCase())}function getTypeName(type){return type.overriddenName||type.name||type.toString().split("\n")[0]}function getDowngradedModuleCount($injector){return $injector.has(DOWNGRADED_MODULE_COUNT_KEY)?$injector.get(DOWNGRADED_MODULE_COUNT_KEY):0}function getUpgradeAppType($injector){return $injector.has(UPGRADE_APP_TYPE_KEY)?
$injector.get(UPGRADE_APP_TYPE_KEY):0}function isFunction(value){return typeof value==="function"}function isParentNode(node){return isFunction(node.querySelectorAll)}function validateInjectionKey($injector,downgradedModule,injectionKey,attemptedAction){const upgradeAppType=getUpgradeAppType($injector);const downgradedModuleCount=getDowngradedModuleCount($injector);switch(upgradeAppType){case 1:case 2:if(downgradedModule)throw new Error(`Error while ${attemptedAction}: 'downgradedModule' unexpectedly specified.\n`+
"You should not specify a value for 'downgradedModule', unless you are downgrading "+"more than one Angular module (via 'downgradeModule()').");break;case 3:if(!downgradedModule&&downgradedModuleCount>=2)throw new Error(`Error while ${attemptedAction}: 'downgradedModule' not specified.\n`+"This application contains more than one downgraded Angular module, thus you need to "+"always specify 'downgradedModule' when downgrading components and injectables.");if(!$injector.has(injectionKey))throw new Error(`Error while ${attemptedAction}: Unable to find the specified downgraded module.\n`+
"Did you forget to downgrade an Angular module or include it in the AngularJS "+"application?");break;default:throw new Error(`Error while ${attemptedAction}: Not a valid '@angular/upgrade' application.\n`+"Did you forget to downgrade an Angular module or include it in the AngularJS "+"application?");}}class Deferred{constructor(){this.promise=new Promise((res,rej)=>{this.resolve=res;this.reject=rej})}}function supportsNgModel(component){return typeof component.writeValue==="function"&&typeof component.registerOnChange===
"function"}function hookupNgModel(ngModel,component){if(ngModel&&supportsNgModel(component)){ngModel.$render=()=>{component.writeValue(ngModel.$viewValue)};component.registerOnChange(ngModel.$setViewValue.bind(ngModel));if(typeof component.registerOnTouched==="function")component.registerOnTouched(ngModel.$setTouched.bind(ngModel))}}function strictEquals(val1,val2){return val1===val2||val1!==val1&&val2!==val2}const INITIAL_VALUE$1={__UNINITIALIZED__:true};class DowngradeComponentAdapter{constructor(element,
attrs,scope,ngModel,parentInjector,$compile,$parse,componentFactory,wrapCallback){this.element=element;this.attrs=attrs;this.scope=scope;this.ngModel=ngModel;this.parentInjector=parentInjector;this.$compile=$compile;this.$parse=$parse;this.componentFactory=componentFactory;this.wrapCallback=wrapCallback;this.implementsOnChanges=false;this.inputChangeCount=0;this.inputChanges={};this.componentScope=scope.$new()}compileContents(){const compiledProjectableNodes=[];const projectableNodes=this.groupProjectableNodes();
const linkFns=projectableNodes.map(nodes=>this.$compile(nodes));this.element.empty();linkFns.forEach(linkFn=>{linkFn(this.scope,clone=>{compiledProjectableNodes.push(clone);this.element.append(clone)})});return compiledProjectableNodes}createComponent(projectableNodes){const providers=[{provide:$SCOPE,useValue:this.componentScope}];const childInjector=i0.Injector.create({providers:providers,parent:this.parentInjector,name:"DowngradeComponentAdapter"});this.componentRef=this.componentFactory.create(childInjector,
projectableNodes,this.element[0]);this.viewChangeDetector=this.componentRef.injector.get(i0.ChangeDetectorRef);this.changeDetector=this.componentRef.changeDetectorRef;this.component=this.componentRef.instance;const testability=this.componentRef.injector.get(i0.Testability,null);if(testability)this.componentRef.injector.get(i0.TestabilityRegistry).registerApplication(this.componentRef.location.nativeElement,testability);hookupNgModel(this.ngModel,this.component)}setupInputs(manuallyAttachView,propagateDigest=
true){const attrs=this.attrs;const inputs=this.componentFactory.inputs||[];for(let i=0;i<inputs.length;i++){const input=new PropertyBinding(inputs[i].propName,inputs[i].templateName);let expr=null;if(attrs.hasOwnProperty(input.attr)){const observeFn=(prop=>{let prevValue=INITIAL_VALUE$1;return currValue=>{if(!strictEquals(prevValue,currValue)){if(prevValue===INITIAL_VALUE$1)prevValue=currValue;this.updateInput(prop,prevValue,currValue);prevValue=currValue}}})(input.prop);attrs.$observe(input.attr,
observeFn);let unwatch=this.componentScope.$watch(()=>{unwatch();unwatch=null;observeFn(attrs[input.attr])})}else if(attrs.hasOwnProperty(input.bindAttr))expr=attrs[input.bindAttr];else if(attrs.hasOwnProperty(input.bracketAttr))expr=attrs[input.bracketAttr];else if(attrs.hasOwnProperty(input.bindonAttr))expr=attrs[input.bindonAttr];else if(attrs.hasOwnProperty(input.bracketParenAttr))expr=attrs[input.bracketParenAttr];if(expr!=null){const watchFn=(prop=>(currValue,prevValue)=>this.updateInput(prop,
prevValue,currValue))(input.prop);this.componentScope.$watch(expr,watchFn)}}const detectChanges=()=>this.changeDetector.detectChanges();const prototype=this.componentFactory.componentType.prototype;this.implementsOnChanges=!!(prototype&&prototype.ngOnChanges);this.componentScope.$watch(()=>this.inputChangeCount,this.wrapCallback(()=>{if(this.implementsOnChanges){const inputChanges=this.inputChanges;this.inputChanges={};this.component.ngOnChanges(inputChanges)}this.viewChangeDetector.markForCheck();
if(!propagateDigest)detectChanges()}));if(propagateDigest)this.componentScope.$watch(this.wrapCallback(detectChanges));if(manuallyAttachView||!propagateDigest){let unwatch=this.componentScope.$watch(()=>{unwatch();unwatch=null;const appRef=this.parentInjector.get(i0.ApplicationRef);appRef.attachView(this.componentRef.hostView)})}}setupOutputs(){const attrs=this.attrs;const outputs=this.componentFactory.outputs||[];for(let j=0;j<outputs.length;j++){const output=new PropertyBinding(outputs[j].propName,
outputs[j].templateName);const bindonAttr=output.bindonAttr.substring(0,output.bindonAttr.length-6);const bracketParenAttr=`[(${output.bracketParenAttr.substring(2,output.bracketParenAttr.length-8)})]`;if(attrs.hasOwnProperty(bindonAttr))this.subscribeToOutput(output,attrs[bindonAttr],true);if(attrs.hasOwnProperty(bracketParenAttr))this.subscribeToOutput(output,attrs[bracketParenAttr],true);if(attrs.hasOwnProperty(output.onAttr))this.subscribeToOutput(output,attrs[output.onAttr]);if(attrs.hasOwnProperty(output.parenAttr))this.subscribeToOutput(output,
attrs[output.parenAttr])}}subscribeToOutput(output,expr,isAssignment=false){const getter=this.$parse(expr);const setter=getter.assign;if(isAssignment&&!setter)throw new Error(`Expression '${expr}' is not assignable!`);const emitter=this.component[output.prop];if(emitter)emitter.subscribe({next:isAssignment?v=>setter(this.scope,v):v=>getter(this.scope,{"$event":v})});else throw new Error(`Missing emitter '${output.prop}' on component '${getTypeName(this.componentFactory.componentType)}'!`);}registerCleanup(){const testabilityRegistry=
this.componentRef.injector.get(i0.TestabilityRegistry);const destroyComponentRef=this.wrapCallback(()=>this.componentRef.destroy());let destroyed=false;this.element.on("$destroy",()=>{if(!destroyed)this.componentScope.$destroy()});this.componentScope.$on("$destroy",()=>{if(!destroyed){destroyed=true;testabilityRegistry.unregisterApplication(this.componentRef.location.nativeElement);cleanData(this.element[0]);destroyComponentRef()}})}getInjector(){return this.componentRef.injector}updateInput(prop,
prevValue,currValue){if(this.implementsOnChanges)this.inputChanges[prop]=new i0.SimpleChange(prevValue,currValue,prevValue===currValue);this.inputChangeCount++;this.component[prop]=currValue}groupProjectableNodes(){let ngContentSelectors=this.componentFactory.ngContentSelectors;return groupNodesBySelector(ngContentSelectors,this.element.contents())}}function groupNodesBySelector(ngContentSelectors,nodes){const projectableNodes=[];for(let i=0,ii=ngContentSelectors.length;i<ii;++i)projectableNodes[i]=
[];for(let j=0,jj=nodes.length;j<jj;++j){const node=nodes[j];const ngContentIndex=findMatchingNgContentIndex(node,ngContentSelectors);if(ngContentIndex!=null)projectableNodes[ngContentIndex].push(node)}return projectableNodes}function findMatchingNgContentIndex(element,ngContentSelectors){const ngContentIndices=[];let wildcardNgContentIndex=-1;for(let i=0;i<ngContentSelectors.length;i++){const selector=ngContentSelectors[i];if(selector==="*")wildcardNgContentIndex=i;else if(matchesSelector(element,
selector))ngContentIndices.push(i)}ngContentIndices.sort();if(wildcardNgContentIndex!==-1)ngContentIndices.push(wildcardNgContentIndex);return ngContentIndices.length?ngContentIndices[0]:null}let _matches;function matchesSelector(el,selector){if(!_matches){const elProto=Element.prototype;_matches=elProto.matches||elProto.matchesSelector||elProto.mozMatchesSelector||elProto.msMatchesSelector||elProto.oMatchesSelector||elProto.webkitMatchesSelector}return el.nodeType===Node.ELEMENT_NODE?_matches.call(el,
selector):false}function isThenable(obj){return!!obj&&isFunction(obj.then)}class SyncPromise{constructor(){this.resolved=false;this.callbacks=[]}static all(valuesOrPromises){const aggrPromise=new SyncPromise;let resolvedCount=0;const results=[];const resolve=(idx,value)=>{results[idx]=value;if(++resolvedCount===valuesOrPromises.length)aggrPromise.resolve(results)};valuesOrPromises.forEach((p,idx)=>{if(isThenable(p))p.then(v=>resolve(idx,v));else resolve(idx,p)});return aggrPromise}resolve(value){if(this.resolved)return;
this.value=value;this.resolved=true;this.callbacks.forEach(callback=>callback(value));this.callbacks.length=0}then(callback){if(this.resolved)callback(this.value);else this.callbacks.push(callback)}}function downgradeComponent(info){const directiveFactory=function($compile,$injector,$parse){const isNgUpgradeLite=getUpgradeAppType($injector)===3;const wrapCallback=!isNgUpgradeLite?cb=>cb:cb=>()=>i0.NgZone.isInAngularZone()?cb():ngZone.run(cb);let ngZone;const hasMultipleDowngradedModules=isNgUpgradeLite&&
getDowngradedModuleCount($injector)>1;return{restrict:"E",terminal:true,require:[REQUIRE_INJECTOR,REQUIRE_NG_MODEL],link:(scope,element,attrs,required)=>{const ngModel=required[1];const parentInjector=required[0];let moduleInjector=undefined;let ranAsync=false;if(!parentInjector||hasMultipleDowngradedModules){const downgradedModule=info.downgradedModule||"";const lazyModuleRefKey=`${LAZY_MODULE_REF}${downgradedModule}`;const attemptedAction=`instantiating component '${getTypeName(info.component)}'`;
validateInjectionKey($injector,downgradedModule,lazyModuleRefKey,attemptedAction);const lazyModuleRef=$injector.get(lazyModuleRefKey);moduleInjector=lazyModuleRef.injector||lazyModuleRef.promise}const finalParentInjector=parentInjector||moduleInjector;const finalModuleInjector=moduleInjector||parentInjector;const doDowngrade=(injector,moduleInjector)=>{const componentFactoryResolver=moduleInjector.get(i0.ComponentFactoryResolver);const componentFactory=componentFactoryResolver.resolveComponentFactory(info.component);
if(!componentFactory)throw new Error(`Expecting ComponentFactory for: ${getTypeName(info.component)}`);const injectorPromise=new ParentInjectorPromise$1(element);const facade=new DowngradeComponentAdapter(element,attrs,scope,ngModel,injector,$compile,$parse,componentFactory,wrapCallback);const projectableNodes=facade.compileContents();facade.createComponent(projectableNodes);facade.setupInputs(isNgUpgradeLite,info.propagateDigest);facade.setupOutputs();facade.registerCleanup();injectorPromise.resolve(facade.getInjector());
if(ranAsync)scope.$evalAsync(()=>{})};const downgradeFn=!isNgUpgradeLite?doDowngrade:(pInjector,mInjector)=>{if(!ngZone)ngZone=pInjector.get(i0.NgZone);wrapCallback(()=>doDowngrade(pInjector,mInjector))()};SyncPromise.all([finalParentInjector,finalModuleInjector]).then(([pInjector,mInjector])=>downgradeFn(pInjector,mInjector));ranAsync=true}}};directiveFactory["$inject"]=[$COMPILE,$INJECTOR,$PARSE];return directiveFactory}class ParentInjectorPromise$1 extends SyncPromise{constructor(element){super();
this.element=element;this.injectorKey=controllerKey(INJECTOR_KEY);element.data(this.injectorKey,this)}resolve(injector){this.element.data(this.injectorKey,injector);this.element=null;super.resolve(injector)}}function downgradeInjectable(token,downgradedModule=""){const factory=function($injector){const injectorKey=`${INJECTOR_KEY}${downgradedModule}`;const injectableName=isFunction(token)?getTypeName(token):String(token);const attemptedAction=`instantiating injectable '${injectableName}'`;validateInjectionKey($injector,
downgradedModule,injectorKey,attemptedAction);try{const injector=$injector.get(injectorKey);return injector.get(token)}catch(err){throw new Error(`Error while ${attemptedAction}: ${err.message||err}`);}};factory["$inject"]=[$INJECTOR];return factory}const REQUIRE_PREFIX_RE=/^(\^\^?)?(\?)?(\^\^?)?/;class UpgradeHelper{constructor(injector,name,elementRef,directive){this.name=name;this.$injector=injector.get($INJECTOR);this.$compile=this.$injector.get($COMPILE);this.$controller=this.$injector.get($CONTROLLER);
this.element=elementRef.nativeElement;this.$element=element(this.element);this.directive=directive||UpgradeHelper.getDirective(this.$injector,name)}static getDirective($injector,name){const directives=$injector.get(name+"Directive");if(directives.length>1)throw new Error(`Only support single directive definition for: ${name}`);const directive=directives[0];if(directive.compile&&!directive.link)notSupported(name,"compile");if(directive.replace)notSupported(name,"replace");if(directive.terminal)notSupported(name,
"terminal");return directive}static getTemplate($injector,directive,fetchRemoteTemplate=false,$element){if(directive.template!==undefined)return getOrCall(directive.template,$element);else if(directive.templateUrl){const $templateCache=$injector.get($TEMPLATE_CACHE);const url=getOrCall(directive.templateUrl,$element);const template=$templateCache.get(url);if(template!==undefined)return template;else if(!fetchRemoteTemplate)throw new Error("loading directive templates asynchronously is not supported");
return new Promise((resolve,reject)=>{const $httpBackend=$injector.get($HTTP_BACKEND);$httpBackend("GET",url,null,(status,response)=>{if(status===200)resolve($templateCache.put(url,response));else reject(`GET component template from '${url}' returned '${status}: ${response}'`)})})}else throw new Error(`Directive '${directive.name}' is not a component, it is missing template.`);}buildController(controllerType,$scope){const locals={"$scope":$scope,"$element":this.$element};const controller=this.$controller(controllerType,
locals,null,this.directive.controllerAs);this.$element.data(controllerKey(this.directive.name),controller);return controller}compileTemplate(template){if(template===undefined)template=UpgradeHelper.getTemplate(this.$injector,this.directive,false,this.$element);return this.compileHtml(template)}onDestroy($scope,controllerInstance){if(controllerInstance&&isFunction(controllerInstance.$onDestroy))controllerInstance.$onDestroy();$scope.$destroy();cleanData(this.element)}prepareTransclusion(){const transclude=
this.directive.transclude;const contentChildNodes=this.extractChildNodes();const attachChildrenFn=(scope,cloneAttachFn)=>{scope=scope||{$destroy:()=>undefined};return cloneAttachFn($template,scope)};let $template=contentChildNodes;if(transclude){const slots=Object.create(null);if(typeof transclude==="object"){$template=[];const slotMap=Object.create(null);const filledSlots=Object.create(null);Object.keys(transclude).forEach(slotName=>{let selector=transclude[slotName];const optional=selector.charAt(0)===
"?";selector=optional?selector.substring(1):selector;slotMap[selector]=slotName;slots[slotName]=null;filledSlots[slotName]=optional});contentChildNodes.forEach(node=>{const slotName=slotMap[directiveNormalize(node.nodeName.toLowerCase())];if(slotName){filledSlots[slotName]=true;slots[slotName]=slots[slotName]||[];slots[slotName].push(node)}else $template.push(node)});Object.keys(filledSlots).forEach(slotName=>{if(!filledSlots[slotName])throw new Error(`Required transclusion slot '${slotName}' on directive: ${this.name}`);
});Object.keys(slots).filter(slotName=>slots[slotName]).forEach(slotName=>{const nodes=slots[slotName];slots[slotName]=(scope,cloneAttach)=>{return cloneAttach(nodes,scope)}})}attachChildrenFn.$$slots=slots;$template.forEach(node=>{if(node.nodeType===Node.TEXT_NODE&&!node.nodeValue)node.nodeValue="‌"})}return attachChildrenFn}resolveAndBindRequiredControllers(controllerInstance){const directiveRequire=this.getDirectiveRequire();const requiredControllers=this.resolveRequire(directiveRequire);if(controllerInstance&&
this.directive.bindToController&&isMap(directiveRequire)){const requiredControllersMap=requiredControllers;Object.keys(requiredControllersMap).forEach(key=>{controllerInstance[key]=requiredControllersMap[key]})}return requiredControllers}compileHtml(html){this.element.innerHTML=html;return this.$compile(this.element.childNodes)}extractChildNodes(){const childNodes=[];let childNode;while(childNode=this.element.firstChild){this.element.removeChild(childNode);childNodes.push(childNode)}return childNodes}getDirectiveRequire(){const require=
this.directive.require||this.directive.controller&&this.directive.name;if(isMap(require))Object.keys(require).forEach(key=>{const value=require[key];const match=value.match(REQUIRE_PREFIX_RE);const name=value.substring(match[0].length);if(!name)require[key]=match[0]+key});return require}resolveRequire(require,controllerInstance){if(!require)return null;else if(Array.isArray(require))return require.map(req=>this.resolveRequire(req));else if(typeof require==="object"){const value={};Object.keys(require).forEach(key=>
value[key]=this.resolveRequire(require[key]));return value}else if(typeof require==="string"){const match=require.match(REQUIRE_PREFIX_RE);const inheritType=match[1]||match[3];const name=require.substring(match[0].length);const isOptional=!!match[2];const searchParents=!!inheritType;const startOnParent=inheritType==="^^";const ctrlKey=controllerKey(name);const elem=startOnParent?this.$element.parent():this.$element;const value=searchParents?elem.inheritedData(ctrlKey):elem.data(ctrlKey);if(!value&&
!isOptional)throw new Error(`Unable to find required '${require}' in upgraded directive '${this.name}'.`);return value}else throw new Error(`Unrecognized 'require' syntax on upgraded directive '${this.name}': ${require}`);}}function getOrCall(property,...args){return isFunction(property)?property(...args):property}function isMap(value){return value&&!Array.isArray(value)&&typeof value==="object"}function notSupported(name,feature){throw new Error(`Upgraded directive '${name}' contains unsupported feature: '${feature}'.`);
}const CAMEL_CASE=/([A-Z])/g;const INITIAL_VALUE={__UNINITIALIZED__:true};const NOT_SUPPORTED="NOT_SUPPORTED";class UpgradeNg1ComponentAdapterBuilder{constructor(name){this.name=name;this.inputs=[];this.inputsRename=[];this.outputs=[];this.outputsRename=[];this.propertyOutputs=[];this.checkProperties=[];this.propertyMap={};this.directive=null;const selector=name.replace(CAMEL_CASE,(all,next)=>"-"+next.toLowerCase());const self=this;const directive={selector:selector,inputs:this.inputsRename,outputs:this.outputsRename};
let MyClass=class MyClass extends UpgradeNg1ComponentAdapter{constructor(scope,injector,elementRef){super(new UpgradeHelper(injector,name,elementRef,self.directive||undefined),scope,self.template,self.inputs,self.outputs,self.propertyOutputs,self.checkProperties,self.propertyMap)}};MyClass=tslib.__decorate([i0.Directive(Object.assign({jit:true},directive)),tslib.__param(0,i0.Inject($SCOPE)),tslib.__metadata("design:paramtypes",[Object,i0.Injector,i0.ElementRef])],MyClass);this.type=MyClass}extractBindings(){const btcIsObject=
typeof this.directive.bindToController==="object";if(btcIsObject&&Object.keys(this.directive.scope).length)throw new Error(`Binding definitions on scope and controller at the same time are not supported.`);const context=btcIsObject?this.directive.bindToController:this.directive.scope;if(typeof context=="object")Object.keys(context).forEach(propName=>{const definition=context[propName];const bindingType=definition.charAt(0);const bindingOptions=definition.charAt(1);const attrName=definition.substring(bindingOptions===
"?"?2:1)||propName;const inputName=`input_${attrName}`;const inputNameRename=`${inputName}: ${attrName}`;const outputName=`output_${attrName}`;const outputNameRename=`${outputName}: ${attrName}`;const outputNameRenameChange=`${outputNameRename}Change`;switch(bindingType){case "@":case "<":this.inputs.push(inputName);this.inputsRename.push(inputNameRename);this.propertyMap[inputName]=propName;break;case "=":this.inputs.push(inputName);this.inputsRename.push(inputNameRename);this.propertyMap[inputName]=
propName;this.outputs.push(outputName);this.outputsRename.push(outputNameRenameChange);this.propertyMap[outputName]=propName;this.checkProperties.push(propName);this.propertyOutputs.push(outputName);break;case "&":this.outputs.push(outputName);this.outputsRename.push(outputNameRename);this.propertyMap[outputName]=propName;break;default:let json=JSON.stringify(context);throw new Error(`Unexpected mapping '${bindingType}' in '${json}' in '${this.name}' directive.`);}})}static resolve(exportedComponents,
$injector){const promises=Object.keys(exportedComponents).map(name=>{const exportedComponent=exportedComponents[name];exportedComponent.directive=UpgradeHelper.getDirective($injector,name);exportedComponent.extractBindings();return Promise.resolve(UpgradeHelper.getTemplate($injector,exportedComponent.directive,true)).then(template=>exportedComponent.template=template)});return Promise.all(promises)}}class UpgradeNg1ComponentAdapter{constructor(helper,scope,template,inputs,outputs,propOuts,checkProperties,
propertyMap){this.helper=helper;this.template=template;this.inputs=inputs;this.outputs=outputs;this.propOuts=propOuts;this.checkProperties=checkProperties;this.propertyMap=propertyMap;this.controllerInstance=null;this.destinationObj=null;this.checkLastValues=[];this.$element=null;this.directive=helper.directive;this.element=helper.element;this.$element=helper.$element;this.componentScope=scope.$new(!!this.directive.scope);const controllerType=this.directive.controller;if(this.directive.bindToController&&
controllerType){this.controllerInstance=this.helper.buildController(controllerType,this.componentScope);this.destinationObj=this.controllerInstance}else this.destinationObj=this.componentScope;for(let i=0;i<inputs.length;i++)this[inputs[i]]=null;for(let j=0;j<outputs.length;j++){const emitter=this[outputs[j]]=new i0.EventEmitter;if(this.propOuts.indexOf(outputs[j])===-1)this.setComponentProperty(outputs[j],(emitter=>value=>emitter.emit(value))(emitter))}for(let k=0;k<propOuts.length;k++)this.checkLastValues.push(INITIAL_VALUE)}ngOnInit(){const attachChildNodes=
this.helper.prepareTransclusion();const linkFn=this.helper.compileTemplate(this.template);const controllerType=this.directive.controller;const bindToController=this.directive.bindToController;if(controllerType&&!bindToController)this.controllerInstance=this.helper.buildController(controllerType,this.componentScope);const requiredControllers=this.helper.resolveAndBindRequiredControllers(this.controllerInstance);if(this.controllerInstance&&isFunction(this.controllerInstance.$onInit))this.controllerInstance.$onInit();
const link=this.directive.link;const preLink=typeof link=="object"&&link.pre;const postLink=typeof link=="object"?link.post:link;const attrs=NOT_SUPPORTED;const transcludeFn=NOT_SUPPORTED;if(preLink)preLink(this.componentScope,this.$element,attrs,requiredControllers,transcludeFn);linkFn(this.componentScope,null,{parentBoundTranscludeFn:attachChildNodes});if(postLink)postLink(this.componentScope,this.$element,attrs,requiredControllers,transcludeFn);if(this.controllerInstance&&isFunction(this.controllerInstance.$postLink))this.controllerInstance.$postLink()}ngOnChanges(changes){const ng1Changes=
{};Object.keys(changes).forEach(name=>{const change=changes[name];this.setComponentProperty(name,change.currentValue);ng1Changes[this.propertyMap[name]]=change});if(isFunction(this.destinationObj.$onChanges))this.destinationObj.$onChanges(ng1Changes)}ngDoCheck(){const destinationObj=this.destinationObj;const lastValues=this.checkLastValues;const checkProperties=this.checkProperties;const propOuts=this.propOuts;checkProperties.forEach((propName,i)=>{const value=destinationObj[propName];const last=
lastValues[i];if(!strictEquals(last,value)){const eventEmitter=this[propOuts[i]];eventEmitter.emit(lastValues[i]=value)}});if(this.controllerInstance&&isFunction(this.controllerInstance.$doCheck))this.controllerInstance.$doCheck()}ngOnDestroy(){this.helper.onDestroy(this.componentScope,this.controllerInstance)}setComponentProperty(name,value){this.destinationObj[this.propertyMap[name]]=value}}UpgradeNg1ComponentAdapter.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.1.3",
ngImport:i0__namespace,type:UpgradeNg1ComponentAdapter,deps:"invalid",target:i0__namespace.\u0275\u0275FactoryTarget.Directive});UpgradeNg1ComponentAdapter.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.1.3",type:UpgradeNg1ComponentAdapter,usesOnChanges:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.1.3",ngImport:i0__namespace,type:UpgradeNg1ComponentAdapter,decorators:[{type:i0.Directive}],ctorParameters:function(){return[{type:UpgradeHelper},
{type:undefined},{type:undefined},{type:undefined},{type:undefined},{type:undefined},{type:undefined},{type:undefined}]}});let upgradeCount=0;class UpgradeAdapter{constructor(ng2AppModule,compilerOptions){this.ng2AppModule=ng2AppModule;this.compilerOptions=compilerOptions;this.idPrefix=`NG2_UPGRADE_${upgradeCount++}_`;this.downgradedComponents=[];this.ng1ComponentsToBeUpgraded={};this.upgradedProviders=[];this.moduleRef=null;if(!ng2AppModule)throw new Error("UpgradeAdapter cannot be instantiated without an NgModule of the Angular app.");
}downgradeNg2Component(component){this.downgradedComponents.push(component);return downgradeComponent({component})}upgradeNg1Component(name){if(this.ng1ComponentsToBeUpgraded.hasOwnProperty(name))return this.ng1ComponentsToBeUpgraded[name].type;else return(this.ng1ComponentsToBeUpgraded[name]=new UpgradeNg1ComponentAdapterBuilder(name)).type}registerForNg1Tests(modules){const windowNgMock=window["angular"].mock;if(!windowNgMock||!windowNgMock.module)throw new Error("Failed to find 'angular.mock.module'.");
this.declareNg1Module(modules);windowNgMock.module(this.ng1Module.name);const upgrade=new UpgradeAdapterRef;this.ng2BootstrapDeferred.promise.then(ng1Injector=>{upgrade._bootstrapDone(this.moduleRef,ng1Injector)},onError);return upgrade}bootstrap(element$1,modules,config){this.declareNg1Module(modules);const upgrade=new UpgradeAdapterRef;const windowAngular=window["angular"];windowAngular.resumeBootstrap=undefined;this.ngZone.run(()=>{bootstrap(element$1,[this.ng1Module.name],config)});const ng1BootstrapPromise=
new Promise(resolve=>{if(windowAngular.resumeBootstrap){const originalResumeBootstrap=windowAngular.resumeBootstrap;windowAngular.resumeBootstrap=function(){windowAngular.resumeBootstrap=originalResumeBootstrap;const r=windowAngular.resumeBootstrap.apply(this,arguments);resolve();return r}}else resolve()});Promise.all([this.ng2BootstrapDeferred.promise,ng1BootstrapPromise]).then(([ng1Injector])=>{element(element$1).data(controllerKey(INJECTOR_KEY),this.moduleRef.injector);this.moduleRef.injector.get(i0.NgZone).run(()=>
{upgrade._bootstrapDone(this.moduleRef,ng1Injector)})},onError);return upgrade}upgradeNg1Provider(name,options){const token=options&&options.asToken||name;this.upgradedProviders.push({provide:token,useFactory:$injector=>$injector.get(name),deps:[$INJECTOR]})}downgradeNg2Provider(token){return downgradeInjectable(token)}declareNg1Module(modules=[]){const delayApplyExps=[];let original$applyFn;let rootScopePrototype;const upgradeAdapter=this;const ng1Module=this.ng1Module=module_(this.idPrefix,modules);
const platformRef=platformBrowserDynamic.platformBrowserDynamic();this.ngZone=new i0.NgZone({enableLongStackTrace:Zone.hasOwnProperty("longStackTraceZoneSpec")});this.ng2BootstrapDeferred=new Deferred;ng1Module.constant(UPGRADE_APP_TYPE_KEY,1).factory(INJECTOR_KEY,()=>this.moduleRef.injector.get(i0.Injector)).factory(LAZY_MODULE_REF,[INJECTOR_KEY,injector=>({injector})]).constant(NG_ZONE_KEY,this.ngZone).factory(COMPILER_KEY,()=>this.moduleRef.injector.get(i0.Compiler)).config(["$provide","$injector",
(provide,ng1Injector)=>{provide.decorator($ROOT_SCOPE,["$delegate",function(rootScopeDelegate){rootScopePrototype=rootScopeDelegate.constructor.prototype;if(rootScopePrototype.hasOwnProperty("$apply")){original$applyFn=rootScopePrototype.$apply;rootScopePrototype.$apply=exp=>delayApplyExps.push(exp)}else throw new Error("Failed to find '$apply' on '$rootScope'!");return rootScopeDelegate}]);if(ng1Injector.has($$TESTABILITY))provide.decorator($$TESTABILITY,["$delegate",function(testabilityDelegate){const originalWhenStable=
testabilityDelegate.whenStable;const newWhenStable=function(callback){originalWhenStable.call(this,function(){const ng2Testability=upgradeAdapter.moduleRef.injector.get(i0.Testability);if(ng2Testability.isStable())callback.apply(this,arguments);else ng2Testability.whenStable(newWhenStable.bind(this,callback))})};testabilityDelegate.whenStable=newWhenStable;return testabilityDelegate}])}]);ng1Module.run(["$injector","$rootScope",(ng1Injector,rootScope)=>{UpgradeNg1ComponentAdapterBuilder.resolve(this.ng1ComponentsToBeUpgraded,
ng1Injector).then(()=>{const ngModule={providers:[{provide:$INJECTOR,useFactory:()=>ng1Injector},{provide:$COMPILE,useFactory:()=>ng1Injector.get($COMPILE)},this.upgradedProviders],imports:[i0.resolveForwardRef(this.ng2AppModule)],entryComponents:this.downgradedComponents};let DynamicNgUpgradeModule=class DynamicNgUpgradeModule{constructor(){}ngDoBootstrap(){}};DynamicNgUpgradeModule=tslib.__decorate([i0.NgModule(Object.assign({jit:true},ngModule)),tslib.__metadata("design:paramtypes",[])],DynamicNgUpgradeModule);
platformRef.bootstrapModule(DynamicNgUpgradeModule,[this.compilerOptions,{ngZone:this.ngZone}]).then(ref=>{this.moduleRef=ref;this.ngZone.run(()=>{if(rootScopePrototype){rootScopePrototype.$apply=original$applyFn;while(delayApplyExps.length)rootScope.$apply(delayApplyExps.shift());rootScopePrototype=null}})}).then(()=>this.ng2BootstrapDeferred.resolve(ng1Injector),onError).then(()=>{let subscription=this.ngZone.onMicrotaskEmpty.subscribe({next:()=>{if(rootScope.$$phase){if(typeof ngDevMode==="undefined"||
ngDevMode)console.warn("A digest was triggered while one was already in progress. This may mean that something is triggering digests outside the Angular zone.");return rootScope.$evalAsync(()=>{})}return rootScope.$digest()}});rootScope.$on("$destroy",()=>{subscription.unsubscribe()});platformRef.onDestroy(()=>destroyApp(ng1Injector))})}).catch(e=>this.ng2BootstrapDeferred.reject(e))}]);return ng1Module}}class UpgradeAdapterRef{constructor(){this._readyFn=null;this.ng1RootScope=null;this.ng1Injector=
null;this.ng2ModuleRef=null;this.ng2Injector=null}_bootstrapDone(ngModuleRef,ng1Injector){this.ng2ModuleRef=ngModuleRef;this.ng2Injector=ngModuleRef.injector;this.ng1Injector=ng1Injector;this.ng1RootScope=ng1Injector.get($ROOT_SCOPE);this._readyFn&&this._readyFn(this)}ready(fn){this._readyFn=fn}dispose(){this.ng1Injector.get($ROOT_SCOPE).$destroy();this.ng2ModuleRef.destroy()}}exports.UpgradeAdapter=UpgradeAdapter;exports.UpgradeAdapterRef=UpgradeAdapterRef;exports.VERSION=VERSION;Object.defineProperty(exports,
"__esModule",{value:true})});

