/*
 Angular v13.3.1
 (c) 2010-2022 Google LLC. https://angular.io/
 License: MIT

 Copyright Google LLC All Rights Reserved.

 Use of this source code is governed by an MIT-style license that can be
 found in the LICENSE file at https://angular.io/license
*/
'use strict';(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports,require("@angular/common/http"),require("@angular/core"),require("rxjs")):typeof define==="function"&&define.amd?define(["exports","@angular/common/http","@angular/core","rxjs"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory((global.ng=global.ng||{},global.ng.commonHttpTesting={}),global.http,global.i0,global.rxjs))})(this,function(exports,http,i0,rxjs){function _interopNamespace(e){if(e&&
e.__esModule)return e;var n=Object.create(null);if(e)Object.keys(e).forEach(function(k){if(k!=="default"){var d=Object.getOwnPropertyDescriptor(e,k);Object.defineProperty(n,k,d.get?d:{enumerable:true,get:function(){return e[k]}})}});n["default"]=e;return Object.freeze(n)}var i0__namespace=_interopNamespace(i0);class HttpTestingController{}class TestRequest{constructor(request,observer){this.request=request;this.observer=observer;this._cancelled=false}get cancelled(){return this._cancelled}flush(body,
opts={}){if(this.cancelled)throw new Error(`Cannot flush a cancelled request.`);const url=this.request.urlWithParams;const headers=opts.headers instanceof http.HttpHeaders?opts.headers:new http.HttpHeaders(opts.headers);body=_maybeConvertBody(this.request.responseType,body);let statusText=opts.statusText;let status=opts.status!==undefined?opts.status:200;if(opts.status===undefined)if(body===null){status=204;statusText=statusText||"No Content"}else statusText=statusText||"OK";if(statusText===undefined)throw new Error("statusText is required when setting a custom status.");
if(status>=200&&status<300){this.observer.next(new http.HttpResponse({body,headers,status,statusText,url}));this.observer.complete()}else this.observer.error(new http.HttpErrorResponse({error:body,headers,status,statusText,url}))}error(error,opts={}){if(this.cancelled)throw new Error(`Cannot return an error for a cancelled request.`);if(opts.status&&opts.status>=200&&opts.status<300)throw new Error(`error() called with a successful status.`);const headers=opts.headers instanceof http.HttpHeaders?
opts.headers:new http.HttpHeaders(opts.headers);this.observer.error(new http.HttpErrorResponse({error,headers,status:opts.status||0,statusText:opts.statusText||"",url:this.request.urlWithParams}))}event(event){if(this.cancelled)throw new Error(`Cannot send events to a cancelled request.`);this.observer.next(event)}}function _toArrayBufferBody(body){if(typeof ArrayBuffer==="undefined")throw new Error("ArrayBuffer responses are not supported on this platform.");if(body instanceof ArrayBuffer)return body;
throw new Error("Automatic conversion to ArrayBuffer is not supported for response type.");}function _toBlob(body){if(typeof Blob==="undefined")throw new Error("Blob responses are not supported on this platform.");if(body instanceof Blob)return body;if(ArrayBuffer&&body instanceof ArrayBuffer)return new Blob([body]);throw new Error("Automatic conversion to Blob is not supported for response type.");}function _toJsonBody(body,format="JSON"){if(typeof ArrayBuffer!=="undefined"&&body instanceof ArrayBuffer)throw new Error(`Automatic conversion to ${format} is not supported for ArrayBuffers.`);
if(typeof Blob!=="undefined"&&body instanceof Blob)throw new Error(`Automatic conversion to ${format} is not supported for Blobs.`);if(typeof body==="string"||typeof body==="number"||typeof body==="object"||typeof body==="boolean"||Array.isArray(body))return body;throw new Error(`Automatic conversion to ${format} is not supported for response type.`);}function _toTextBody(body){if(typeof body==="string")return body;if(typeof ArrayBuffer!=="undefined"&&body instanceof ArrayBuffer)throw new Error("Automatic conversion to text is not supported for ArrayBuffers.");
if(typeof Blob!=="undefined"&&body instanceof Blob)throw new Error("Automatic conversion to text is not supported for Blobs.");return JSON.stringify(_toJsonBody(body,"text"))}function _maybeConvertBody(responseType,body){if(body===null)return null;switch(responseType){case "arraybuffer":return _toArrayBufferBody(body);case "blob":return _toBlob(body);case "json":return _toJsonBody(body);case "text":return _toTextBody(body);default:throw new Error(`Unsupported responseType: ${responseType}`);}}class HttpClientTestingBackend{constructor(){this.open=
[]}handle(req){return new rxjs.Observable(observer=>{const testReq=new TestRequest(req,observer);this.open.push(testReq);observer.next({type:http.HttpEventType.Sent});return()=>{testReq._cancelled=true}})}_match(match){if(typeof match==="string")return this.open.filter(testReq=>testReq.request.urlWithParams===match);else if(typeof match==="function")return this.open.filter(testReq=>match(testReq.request));else return this.open.filter(testReq=>(!match.method||testReq.request.method===match.method.toUpperCase())&&
(!match.url||testReq.request.urlWithParams===match.url))}match(match){const results=this._match(match);results.forEach(result=>{const index=this.open.indexOf(result);if(index!==-1)this.open.splice(index,1)});return results}expectOne(match,description){description=description||this.descriptionFromMatcher(match);const matches=this.match(match);if(matches.length>1)throw new Error(`Expected one matching request for criteria "${description}", found ${matches.length} requests.`);if(matches.length===0){let message=
`Expected one matching request for criteria "${description}", found none.`;if(this.open.length>0){const requests=this.open.map(describeRequest).join(", ");message+=` Requests received are: ${requests}.`}throw new Error(message);}return matches[0]}expectNone(match,description){description=description||this.descriptionFromMatcher(match);const matches=this.match(match);if(matches.length>0)throw new Error(`Expected zero matching requests for criteria "${description}", found ${matches.length}.`);}verify(opts=
{}){let open=this.open;if(opts.ignoreCancelled)open=open.filter(testReq=>!testReq.cancelled);if(open.length>0){const requests=open.map(describeRequest).join(", ");throw new Error(`Expected no open requests, found ${open.length}: ${requests}`);}}descriptionFromMatcher(matcher){if(typeof matcher==="string")return`Match URL: ${matcher}`;else if(typeof matcher==="object"){const method=matcher.method||"(any)";const url=matcher.url||"(any)";return`Match method: ${method}, URL: ${url}`}else return`Match by function: ${matcher.name}`}}
HttpClientTestingBackend.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:HttpClientTestingBackend,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});HttpClientTestingBackend.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:HttpClientTestingBackend});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,
type:HttpClientTestingBackend,decorators:[{type:i0.Injectable}]});function describeRequest(testRequest){const url=testRequest.request.urlWithParams;const method=testRequest.request.method;return`${method} ${url}`}class HttpClientTestingModule{}HttpClientTestingModule.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:HttpClientTestingModule,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.NgModule});HttpClientTestingModule.\u0275mod=
i0__namespace.\u0275\u0275ngDeclareNgModule({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:HttpClientTestingModule,imports:[http.HttpClientModule]});HttpClientTestingModule.\u0275inj=i0__namespace.\u0275\u0275ngDeclareInjector({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:HttpClientTestingModule,providers:[HttpClientTestingBackend,{provide:http.HttpBackend,useExisting:HttpClientTestingBackend},{provide:HttpTestingController,useExisting:HttpClientTestingBackend}],
imports:[[http.HttpClientModule]]});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:HttpClientTestingModule,decorators:[{type:i0.NgModule,args:[{imports:[http.HttpClientModule],providers:[HttpClientTestingBackend,{provide:http.HttpBackend,useExisting:HttpClientTestingBackend},{provide:HttpTestingController,useExisting:HttpClientTestingBackend}]}]}]});exports.HttpClientTestingModule=HttpClientTestingModule;exports.HttpTestingController=
HttpTestingController;exports.TestRequest=TestRequest;Object.defineProperty(exports,"__esModule",{value:true})});

