/*

 Copyright Google LLC All Rights Reserved.

 Use of this source code is governed by an MIT-style license that can be
 found in the LICENSE file at https://angular.io/license
 Angular v13.3.1
 (c) 2010-2022 Google LLC. https://angular.io/
 License: MIT
*/
'use strict';(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports,require("@angular/core"),require("rxjs"),require("rxjs/operators")):typeof define==="function"&&define.amd?define(["exports","@angular/core","rxjs","rxjs/operators"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory((global.ng=global.ng||{},global.ng.elements={}),global.core,global.rxjs,global.operators))})(this,function(exports,core,rxjs,operators){const scheduler=
{schedule(taskFn,delay){const id=setTimeout(taskFn,delay);return()=>clearTimeout(id)},scheduleBeforeRender(taskFn){if(typeof window==="undefined")return scheduler.schedule(taskFn,0);if(typeof window.requestAnimationFrame==="undefined"){const frameMs=16;return scheduler.schedule(taskFn,frameMs)}const id=window.requestAnimationFrame(taskFn);return()=>window.cancelAnimationFrame(id)}};function camelToDashCase(input){return input.replace(/[A-Z]/g,char=>`-${char.toLowerCase()}`)}function isElement(node){return!!node&&
node.nodeType===Node.ELEMENT_NODE}function isFunction(value){return typeof value==="function"}let _matches;function matchesSelector(el,selector){if(!_matches){const elProto=Element.prototype;_matches=elProto.matches||elProto.matchesSelector||elProto.mozMatchesSelector||elProto.msMatchesSelector||elProto.oMatchesSelector||elProto.webkitMatchesSelector}return el.nodeType===Node.ELEMENT_NODE?_matches.call(el,selector):false}function strictEquals(value1,value2){return value1===value2||value1!==value1&&
value2!==value2}function getDefaultAttributeToPropertyInputs(inputs){const attributeToPropertyInputs={};inputs.forEach(({propName,templateName})=>{attributeToPropertyInputs[camelToDashCase(templateName)]=propName});return attributeToPropertyInputs}function getComponentInputs(component,injector){const componentFactoryResolver=injector.get(core.ComponentFactoryResolver);const componentFactory=componentFactoryResolver.resolveComponentFactory(component);return componentFactory.inputs}function extractProjectableNodes(host,
ngContentSelectors){const nodes=host.childNodes;const projectableNodes=ngContentSelectors.map(()=>[]);let wildcardIndex=-1;ngContentSelectors.some((selector,i)=>{if(selector==="*"){wildcardIndex=i;return true}return false});for(let i=0,ii=nodes.length;i<ii;++i){const node=nodes[i];const ngContentIndex=findMatchingIndex(node,ngContentSelectors,wildcardIndex);if(ngContentIndex!==-1)projectableNodes[ngContentIndex].push(node)}return projectableNodes}function findMatchingIndex(node,selectors,defaultIndex){let matchingIndex=
defaultIndex;if(isElement(node))selectors.some((selector,i)=>{if(selector!=="*"&&matchesSelector(node,selector)){matchingIndex=i;return true}return false});return matchingIndex}const DESTROY_DELAY=10;class ComponentNgElementStrategyFactory{constructor(component,injector){this.componentFactory=injector.get(core.ComponentFactoryResolver).resolveComponentFactory(component)}create(injector){return new ComponentNgElementStrategy(this.componentFactory,injector)}}class ComponentNgElementStrategy{constructor(componentFactory,
injector){this.componentFactory=componentFactory;this.injector=injector;this.eventEmitters=new rxjs.ReplaySubject(1);this.events=this.eventEmitters.pipe(operators.switchMap(emitters=>rxjs.merge(...emitters)));this.componentRef=null;this.viewChangeDetectorRef=null;this.inputChanges=null;this.hasInputChanges=false;this.implementsOnChanges=false;this.scheduledChangeDetectionFn=null;this.scheduledDestroyFn=null;this.initialInputValues=new Map;this.unchangedInputs=new Set(this.componentFactory.inputs.map(({propName})=>
propName));this.ngZone=this.injector.get(core.NgZone);this.elementZone=typeof Zone==="undefined"?null:this.ngZone.run(()=>Zone.current)}connect(element){this.runInZone(()=>{if(this.scheduledDestroyFn!==null){this.scheduledDestroyFn();this.scheduledDestroyFn=null;return}if(this.componentRef===null)this.initializeComponent(element)})}disconnect(){this.runInZone(()=>{if(this.componentRef===null||this.scheduledDestroyFn!==null)return;this.scheduledDestroyFn=scheduler.schedule(()=>{if(this.componentRef!==
null){this.componentRef.destroy();this.componentRef=null;this.viewChangeDetectorRef=null}},DESTROY_DELAY)})}getInputValue(property){return this.runInZone(()=>{if(this.componentRef===null)return this.initialInputValues.get(property);return this.componentRef.instance[property]})}setInputValue(property,value){this.runInZone(()=>{if(this.componentRef===null){this.initialInputValues.set(property,value);return}if(strictEquals(value,this.getInputValue(property))&&!(value===undefined&&this.unchangedInputs.has(property)))return;
this.recordInputChange(property,value);this.unchangedInputs.delete(property);this.hasInputChanges=true;this.componentRef.instance[property]=value;this.scheduleDetectChanges()})}initializeComponent(element){const childInjector=core.Injector.create({providers:[],parent:this.injector});const projectableNodes=extractProjectableNodes(element,this.componentFactory.ngContentSelectors);this.componentRef=this.componentFactory.create(childInjector,projectableNodes,element);this.viewChangeDetectorRef=this.componentRef.injector.get(core.ChangeDetectorRef);
this.implementsOnChanges=isFunction(this.componentRef.instance.ngOnChanges);this.initializeInputs();this.initializeOutputs(this.componentRef);this.detectChanges();const applicationRef=this.injector.get(core.ApplicationRef);applicationRef.attachView(this.componentRef.hostView)}initializeInputs(){this.componentFactory.inputs.forEach(({propName})=>{if(this.initialInputValues.has(propName))this.setInputValue(propName,this.initialInputValues.get(propName))});this.initialInputValues.clear()}initializeOutputs(componentRef){const eventEmitters=
this.componentFactory.outputs.map(({propName,templateName})=>{const emitter=componentRef.instance[propName];return emitter.pipe(operators.map(value=>({name:templateName,value})))});this.eventEmitters.next(eventEmitters)}callNgOnChanges(componentRef){if(!this.implementsOnChanges||this.inputChanges===null)return;const inputChanges=this.inputChanges;this.inputChanges=null;componentRef.instance.ngOnChanges(inputChanges)}markViewForCheck(viewChangeDetectorRef){if(this.hasInputChanges){this.hasInputChanges=
false;viewChangeDetectorRef.markForCheck()}}scheduleDetectChanges(){if(this.scheduledChangeDetectionFn)return;this.scheduledChangeDetectionFn=scheduler.scheduleBeforeRender(()=>{this.scheduledChangeDetectionFn=null;this.detectChanges()})}recordInputChange(property,currentValue){if(!this.implementsOnChanges)return;if(this.inputChanges===null)this.inputChanges={};const pendingChange=this.inputChanges[property];if(pendingChange){pendingChange.currentValue=currentValue;return}const isFirstChange=this.unchangedInputs.has(property);
const previousValue=isFirstChange?undefined:this.getInputValue(property);this.inputChanges[property]=new core.SimpleChange(previousValue,currentValue,isFirstChange)}detectChanges(){if(this.componentRef===null)return;this.callNgOnChanges(this.componentRef);this.markViewForCheck(this.viewChangeDetectorRef);this.componentRef.changeDetectorRef.detectChanges()}runInZone(fn){return this.elementZone&&Zone.current!==this.elementZone?this.ngZone.run(fn):fn()}}class NgElement extends HTMLElement{constructor(){super(...arguments);
this.ngElementEventsSubscription=null}}function createCustomElement(component,config){const inputs=getComponentInputs(component,config.injector);const strategyFactory=config.strategyFactory||new ComponentNgElementStrategyFactory(component,config.injector);const attributeToPropertyInputs=getDefaultAttributeToPropertyInputs(inputs);class NgElementImpl extends NgElement{constructor(injector){super();this.injector=injector}get ngElementStrategy(){if(!this._ngElementStrategy){const strategy=this._ngElementStrategy=
strategyFactory.create(this.injector||config.injector);inputs.forEach(({propName})=>{if(!this.hasOwnProperty(propName))return;const value=this[propName];delete this[propName];strategy.setInputValue(propName,value)})}return this._ngElementStrategy}attributeChangedCallback(attrName,oldValue,newValue,namespace){const propName=attributeToPropertyInputs[attrName];this.ngElementStrategy.setInputValue(propName,newValue)}connectedCallback(){let subscribedToEvents=false;if(this.ngElementStrategy.events){this.subscribeToEvents();
subscribedToEvents=true}this.ngElementStrategy.connect(this);if(!subscribedToEvents)this.subscribeToEvents()}disconnectedCallback(){if(this._ngElementStrategy)this._ngElementStrategy.disconnect();if(this.ngElementEventsSubscription){this.ngElementEventsSubscription.unsubscribe();this.ngElementEventsSubscription=null}}subscribeToEvents(){this.ngElementEventsSubscription=this.ngElementStrategy.events.subscribe(e=>{const customEvent=new CustomEvent(e.name,{detail:e.value});this.dispatchEvent(customEvent)})}}
NgElementImpl["observedAttributes"]=Object.keys(attributeToPropertyInputs);inputs.forEach(({propName})=>{Object.defineProperty(NgElementImpl.prototype,propName,{get(){return this.ngElementStrategy.getInputValue(propName)},set(newValue){this.ngElementStrategy.setInputValue(propName,newValue)},configurable:true,enumerable:true})});return NgElementImpl}const VERSION=new core.Version("13.3.1");exports.NgElement=NgElement;exports.VERSION=VERSION;exports.createCustomElement=createCustomElement;Object.defineProperty(exports,
"__esModule",{value:true})});

