/*

 Copyright Google LLC All Rights Reserved.

 Use of this source code is governed by an MIT-style license that can be
 found in the LICENSE file at https://angular.io/license
 Angular v13.3.1
 (c) 2010-2022 Google LLC. https://angular.io/
 License: MIT
*/
'use strict';(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports,require("@angular/core"),require("@angular/common"),require("rxjs"),require("rxjs/operators")):typeof define==="function"&&define.amd?define(["exports","@angular/core","@angular/common","rxjs","rxjs/operators"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory((global.ng=global.ng||{},global.ng.forms={}),global.i0,global.common,global.rxjs,global.operators))})(this,
function(exports,i0,common,rxjs,operators){function _interopNamespace(e){if(e&&e.__esModule)return e;var n=Object.create(null);if(e)Object.keys(e).forEach(function(k){if(k!=="default"){var d=Object.getOwnPropertyDescriptor(e,k);Object.defineProperty(n,k,d.get?d:{enumerable:true,get:function(){return e[k]}})}});n["default"]=e;return Object.freeze(n)}var i0__namespace=_interopNamespace(i0);class BaseControlValueAccessor{constructor(_renderer,_elementRef){this._renderer=_renderer;this._elementRef=_elementRef;
this.onChange=_=>{};this.onTouched=()=>{}}setProperty(key,value){this._renderer.setProperty(this._elementRef.nativeElement,key,value)}registerOnTouched(fn){this.onTouched=fn}registerOnChange(fn){this.onChange=fn}setDisabledState(isDisabled){this.setProperty("disabled",isDisabled)}}BaseControlValueAccessor.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:BaseControlValueAccessor,deps:[{token:i0__namespace.Renderer2},{token:i0__namespace.ElementRef}],
target:i0__namespace.\u0275\u0275FactoryTarget.Directive});BaseControlValueAccessor.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:BaseControlValueAccessor,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:BaseControlValueAccessor,decorators:[{type:i0.Directive}],ctorParameters:function(){return[{type:i0__namespace.Renderer2},{type:i0__namespace.ElementRef}]}});
class BuiltInControlValueAccessor extends BaseControlValueAccessor{}BuiltInControlValueAccessor.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:BuiltInControlValueAccessor,deps:null,target:i0__namespace.\u0275\u0275FactoryTarget.Directive});BuiltInControlValueAccessor.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:BuiltInControlValueAccessor,usesInheritance:true,ngImport:i0__namespace});
i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:BuiltInControlValueAccessor,decorators:[{type:i0.Directive}]});const NG_VALUE_ACCESSOR=new i0.InjectionToken("NgValueAccessor");const CHECKBOX_VALUE_ACCESSOR={provide:NG_VALUE_ACCESSOR,useExisting:i0.forwardRef(()=>CheckboxControlValueAccessor),multi:true};class CheckboxControlValueAccessor extends BuiltInControlValueAccessor{writeValue(value){this.setProperty("checked",value)}}CheckboxControlValueAccessor.\u0275fac=
i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:CheckboxControlValueAccessor,deps:null,target:i0__namespace.\u0275\u0275FactoryTarget.Directive});CheckboxControlValueAccessor.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:CheckboxControlValueAccessor,selector:"input[type=checkbox][formControlName],input[type=checkbox][formControl],input[type=checkbox][ngModel]",host:{listeners:{"change":"onChange($event.target.checked)",
"blur":"onTouched()"}},providers:[CHECKBOX_VALUE_ACCESSOR],usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:CheckboxControlValueAccessor,decorators:[{type:i0.Directive,args:[{selector:"input[type=checkbox][formControlName],input[type=checkbox][formControl],input[type=checkbox][ngModel]",host:{"(change)":"onChange($event.target.checked)","(blur)":"onTouched()"},providers:[CHECKBOX_VALUE_ACCESSOR]}]}]});
const DEFAULT_VALUE_ACCESSOR={provide:NG_VALUE_ACCESSOR,useExisting:i0.forwardRef(()=>DefaultValueAccessor),multi:true};function _isAndroid(){const userAgent=common["ɵgetDOM"]()?common["ɵgetDOM"]().getUserAgent():"";return/android (\d+)/.test(userAgent.toLowerCase())}const COMPOSITION_BUFFER_MODE=new i0.InjectionToken("CompositionEventMode");class DefaultValueAccessor extends BaseControlValueAccessor{constructor(renderer,elementRef,_compositionMode){super(renderer,elementRef);this._compositionMode=
_compositionMode;this._composing=false;if(this._compositionMode==null)this._compositionMode=!_isAndroid()}writeValue(value){const normalizedValue=value==null?"":value;this.setProperty("value",normalizedValue)}_handleInput(value){if(!this._compositionMode||this._compositionMode&&!this._composing)this.onChange(value)}_compositionStart(){this._composing=true}_compositionEnd(value){this._composing=false;this._compositionMode&&this.onChange(value)}}DefaultValueAccessor.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:DefaultValueAccessor,deps:[{token:i0__namespace.Renderer2},{token:i0__namespace.ElementRef},{token:COMPOSITION_BUFFER_MODE,optional:true}],target:i0__namespace.\u0275\u0275FactoryTarget.Directive});DefaultValueAccessor.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:DefaultValueAccessor,selector:"input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]",
host:{listeners:{"input":"$any(this)._handleInput($event.target.value)","blur":"onTouched()","compositionstart":"$any(this)._compositionStart()","compositionend":"$any(this)._compositionEnd($event.target.value)"}},providers:[DEFAULT_VALUE_ACCESSOR],usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:DefaultValueAccessor,decorators:[{type:i0.Directive,args:[{selector:"input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]",
host:{"(input)":"$any(this)._handleInput($event.target.value)","(blur)":"onTouched()","(compositionstart)":"$any(this)._compositionStart()","(compositionend)":"$any(this)._compositionEnd($event.target.value)"},providers:[DEFAULT_VALUE_ACCESSOR]}]}],ctorParameters:function(){return[{type:i0__namespace.Renderer2},{type:i0__namespace.ElementRef},{type:undefined,decorators:[{type:i0.Optional},{type:i0.Inject,args:[COMPOSITION_BUFFER_MODE]}]}]}});function isEmptyInputValue(value){return value==null||value.length===
0}function hasValidLength(value){return value!=null&&typeof value.length==="number"}const NG_VALIDATORS=new i0.InjectionToken("NgValidators");const NG_ASYNC_VALIDATORS=new i0.InjectionToken("NgAsyncValidators");const EMAIL_REGEXP=/^(?=.{1,254}$)(?=.{1,64}@)[a-zA-Z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-zA-Z0-9!#$%&'*+/=?^_`{|}~-]+)*@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/;class Validators{static min(min){return minValidator(min)}static max(max){return maxValidator(max)}static required(control){return requiredValidator(control)}static requiredTrue(control){return requiredTrueValidator(control)}static email(control){return emailValidator(control)}static minLength(minLength){return minLengthValidator(minLength)}static maxLength(maxLength){return maxLengthValidator(maxLength)}static pattern(pattern){return patternValidator(pattern)}static nullValidator(control){return nullValidator()}static compose(validators){return compose(validators)}static composeAsync(validators){return composeAsync(validators)}}
function minValidator(min){return control=>{if(isEmptyInputValue(control.value)||isEmptyInputValue(min))return null;const value=parseFloat(control.value);return!isNaN(value)&&value<min?{"min":{"min":min,"actual":control.value}}:null}}function maxValidator(max){return control=>{if(isEmptyInputValue(control.value)||isEmptyInputValue(max))return null;const value=parseFloat(control.value);return!isNaN(value)&&value>max?{"max":{"max":max,"actual":control.value}}:null}}function requiredValidator(control){return isEmptyInputValue(control.value)?
{"required":true}:null}function requiredTrueValidator(control){return control.value===true?null:{"required":true}}function emailValidator(control){if(isEmptyInputValue(control.value))return null;return EMAIL_REGEXP.test(control.value)?null:{"email":true}}function minLengthValidator(minLength){return control=>{if(isEmptyInputValue(control.value)||!hasValidLength(control.value))return null;return control.value.length<minLength?{"minlength":{"requiredLength":minLength,"actualLength":control.value.length}}:
null}}function maxLengthValidator(maxLength){return control=>{return hasValidLength(control.value)&&control.value.length>maxLength?{"maxlength":{"requiredLength":maxLength,"actualLength":control.value.length}}:null}}function patternValidator(pattern){if(!pattern)return nullValidator;let regex;let regexStr;if(typeof pattern==="string"){regexStr="";if(pattern.charAt(0)!=="^")regexStr+="^";regexStr+=pattern;if(pattern.charAt(pattern.length-1)!=="$")regexStr+="$";regex=new RegExp(regexStr)}else{regexStr=
pattern.toString();regex=pattern}return control=>{if(isEmptyInputValue(control.value))return null;const value=control.value;return regex.test(value)?null:{"pattern":{"requiredPattern":regexStr,"actualValue":value}}}}function nullValidator(control){return null}function isPresent(o){return o!=null}function toObservable(r){const obs=i0["ɵisPromise"](r)?rxjs.from(r):r;if(!i0["ɵisObservable"](obs)&&(typeof ngDevMode==="undefined"||ngDevMode))throw new Error(`Expected validator to return Promise or Observable.`);
return obs}function mergeErrors(arrayOfErrors){let res={};arrayOfErrors.forEach(errors=>{res=errors!=null?Object.assign(Object.assign({},res),errors):res});return Object.keys(res).length===0?null:res}function executeValidators(control,validators){return validators.map(validator=>validator(control))}function isValidatorFn(validator){return!validator.validate}function normalizeValidators(validators){return validators.map(validator=>{return isValidatorFn(validator)?validator:c=>validator.validate(c)})}
function compose(validators){if(!validators)return null;const presentValidators=validators.filter(isPresent);if(presentValidators.length==0)return null;return function(control){return mergeErrors(executeValidators(control,presentValidators))}}function composeValidators(validators){return validators!=null?compose(normalizeValidators(validators)):null}function composeAsync(validators){if(!validators)return null;const presentValidators=validators.filter(isPresent);if(presentValidators.length==0)return null;
return function(control){const observables=executeValidators(control,presentValidators).map(toObservable);return rxjs.forkJoin(observables).pipe(operators.map(mergeErrors))}}function composeAsyncValidators(validators){return validators!=null?composeAsync(normalizeValidators(validators)):null}function mergeValidators(controlValidators,dirValidator){if(controlValidators===null)return[dirValidator];return Array.isArray(controlValidators)?[...controlValidators,dirValidator]:[controlValidators,dirValidator]}
function getControlValidators(control){return control._rawValidators}function getControlAsyncValidators(control){return control._rawAsyncValidators}function makeValidatorsArray(validators){if(!validators)return[];return Array.isArray(validators)?validators:[validators]}function hasValidator(validators,validator){return Array.isArray(validators)?validators.includes(validator):validators===validator}function addValidators(validators,currentValidators){const current=makeValidatorsArray(currentValidators);
const validatorsToAdd=makeValidatorsArray(validators);validatorsToAdd.forEach(v=>{if(!hasValidator(current,v))current.push(v)});return current}function removeValidators(validators,currentValidators){return makeValidatorsArray(currentValidators).filter(v=>!hasValidator(validators,v))}class AbstractControlDirective{constructor(){this._rawValidators=[];this._rawAsyncValidators=[];this._onDestroyCallbacks=[]}get value(){return this.control?this.control.value:null}get valid(){return this.control?this.control.valid:
null}get invalid(){return this.control?this.control.invalid:null}get pending(){return this.control?this.control.pending:null}get disabled(){return this.control?this.control.disabled:null}get enabled(){return this.control?this.control.enabled:null}get errors(){return this.control?this.control.errors:null}get pristine(){return this.control?this.control.pristine:null}get dirty(){return this.control?this.control.dirty:null}get touched(){return this.control?this.control.touched:null}get status(){return this.control?
this.control.status:null}get untouched(){return this.control?this.control.untouched:null}get statusChanges(){return this.control?this.control.statusChanges:null}get valueChanges(){return this.control?this.control.valueChanges:null}get path(){return null}_setValidators(validators){this._rawValidators=validators||[];this._composedValidatorFn=composeValidators(this._rawValidators)}_setAsyncValidators(validators){this._rawAsyncValidators=validators||[];this._composedAsyncValidatorFn=composeAsyncValidators(this._rawAsyncValidators)}get validator(){return this._composedValidatorFn||
null}get asyncValidator(){return this._composedAsyncValidatorFn||null}_registerOnDestroy(fn){this._onDestroyCallbacks.push(fn)}_invokeOnDestroyCallbacks(){this._onDestroyCallbacks.forEach(fn=>fn());this._onDestroyCallbacks=[]}reset(value=undefined){if(this.control)this.control.reset(value)}hasError(errorCode,path){return this.control?this.control.hasError(errorCode,path):false}getError(errorCode,path){return this.control?this.control.getError(errorCode,path):null}}class NgControl extends AbstractControlDirective{constructor(){super(...arguments);
this._parent=null;this.name=null;this.valueAccessor=null}}class ControlContainer extends AbstractControlDirective{get formDirective(){return null}get path(){return null}}class AbstractControlStatus{constructor(cd){this._cd=cd}is(status){var _a,_b,_c;if(status==="submitted")return!!((_a=this._cd)===null||_a===void 0?void 0:_a.submitted);return!!((_c=(_b=this._cd)===null||_b===void 0?void 0:_b.control)===null||_c===void 0?void 0:_c[status])}}const ngControlStatusHost={"[class.ng-untouched]":'is("untouched")',
"[class.ng-touched]":'is("touched")',"[class.ng-pristine]":'is("pristine")',"[class.ng-dirty]":'is("dirty")',"[class.ng-valid]":'is("valid")',"[class.ng-invalid]":'is("invalid")',"[class.ng-pending]":'is("pending")'};const ngGroupStatusHost={"[class.ng-untouched]":'is("untouched")',"[class.ng-touched]":'is("touched")',"[class.ng-pristine]":'is("pristine")',"[class.ng-dirty]":'is("dirty")',"[class.ng-valid]":'is("valid")',"[class.ng-invalid]":'is("invalid")',"[class.ng-pending]":'is("pending")',"[class.ng-submitted]":'is("submitted")'};
class NgControlStatus extends AbstractControlStatus{constructor(cd){super(cd)}}NgControlStatus.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:NgControlStatus,deps:[{token:NgControl,self:true}],target:i0__namespace.\u0275\u0275FactoryTarget.Directive});NgControlStatus.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:NgControlStatus,selector:"[formControlName],[ngModel],[formControl]",
host:{properties:{"class.ng-untouched":'is("untouched")',"class.ng-touched":'is("touched")',"class.ng-pristine":'is("pristine")',"class.ng-dirty":'is("dirty")',"class.ng-valid":'is("valid")',"class.ng-invalid":'is("invalid")',"class.ng-pending":'is("pending")'}},usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:NgControlStatus,decorators:[{type:i0.Directive,args:[{selector:"[formControlName],[ngModel],[formControl]",
host:ngControlStatusHost}]}],ctorParameters:function(){return[{type:NgControl,decorators:[{type:i0.Self}]}]}});class NgControlStatusGroup extends AbstractControlStatus{constructor(cd){super(cd)}}NgControlStatusGroup.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:NgControlStatusGroup,deps:[{token:ControlContainer,optional:true,self:true}],target:i0__namespace.\u0275\u0275FactoryTarget.Directive});NgControlStatusGroup.\u0275dir=
i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:NgControlStatusGroup,selector:"[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]",host:{properties:{"class.ng-untouched":'is("untouched")',"class.ng-touched":'is("touched")',"class.ng-pristine":'is("pristine")',"class.ng-dirty":'is("dirty")',"class.ng-valid":'is("valid")',"class.ng-invalid":'is("invalid")',"class.ng-pending":'is("pending")',"class.ng-submitted":'is("submitted")'}},
usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:NgControlStatusGroup,decorators:[{type:i0.Directive,args:[{selector:"[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]",host:ngGroupStatusHost}]}],ctorParameters:function(){return[{type:ControlContainer,decorators:[{type:i0.Optional},{type:i0.Self}]}]}});const formControlNameExample=`
  <div [formGroup]="myGroup">
    <input formControlName="firstName">
  </div>

  In your class:

  this.myGroup = new FormGroup({
      firstName: new FormControl()
  });`;const formGroupNameExample=`
  <div [formGroup]="myGroup">
      <div formGroupName="person">
        <input formControlName="firstName">
      </div>
  </div>

  In your class:

  this.myGroup = new FormGroup({
      person: new FormGroup({ firstName: new FormControl() })
  });`;const formArrayNameExample=`
  <div [formGroup]="myGroup">
    <div formArrayName="cities">
      <div *ngFor="let city of cityArray.controls; index as i">
        <input [formControlName]="i">
      </div>
    </div>
  </div>

  In your class:

  this.cityArray = new FormArray([new FormControl('SF')]);
  this.myGroup = new FormGroup({
    cities: this.cityArray
  });`;const ngModelGroupExample=`
  <form>
      <div ngModelGroup="person">
        <input [(ngModel)]="person.name" name="firstName">
      </div>
  </form>`;const ngModelWithFormGroupExample=`
  <div [formGroup]="myGroup">
      <input formControlName="firstName">
      <input [(ngModel)]="showMoreControls" [ngModelOptions]="{standalone: true}">
  </div>
`;function controlParentException(){return new Error(`formControlName must be used with a parent formGroup directive.  You'll want to add a formGroup
      directive and pass it an existing FormGroup instance (you can create one in your class).

    Example:

    ${formControlNameExample}`)}function ngModelGroupException(){return new Error(`formControlName cannot be used with an ngModelGroup parent. It is only compatible with parents
      that also have a "form" prefix: formGroupName, formArrayName, or formGroup.

      Option 1:  Update the parent to be formGroupName (reactive form strategy)

      ${formGroupNameExample}

      Option 2: Use ngModel instead of formControlName (template-driven strategy)

      ${ngModelGroupExample}`)}function missingFormException(){return new Error(`formGroup expects a FormGroup instance. Please pass one in.

      Example:

      ${formControlNameExample}`)}function groupParentException(){return new Error(`formGroupName must be used with a parent formGroup directive.  You'll want to add a formGroup
    directive and pass it an existing FormGroup instance (you can create one in your class).

    Example:

    ${formGroupNameExample}`)}function arrayParentException(){return new Error(`formArrayName must be used with a parent formGroup directive.  You'll want to add a formGroup
      directive and pass it an existing FormGroup instance (you can create one in your class).

      Example:

      ${formArrayNameExample}`)}const disabledAttrWarning=`
  It looks like you're using the disabled attribute with a reactive form directive. If you set disabled to true
  when you set up this control in your component class, the disabled attribute will actually be set in the DOM for
  you. We recommend using this approach to avoid 'changed after checked' errors.

  Example:
  form = new FormGroup({
    first: new FormControl({value: 'Nancy', disabled: true}, Validators.required),
    last: new FormControl('Drew', Validators.required)
  });
`;function ngModelWarning(directiveName){return`
  It looks like you're using ngModel on the same form field as ${directiveName}.
  Support for using the ngModel input property and ngModelChange event with
  reactive form directives has been deprecated in Angular v6 and will be removed
  in a future version of Angular.

  For more information on this, see our API docs here:
  https://angular.io/api/forms/${directiveName==="formControl"?"FormControlDirective":"FormControlName"}#use-with-ngmodel
  `}function describeKey(isFormGroup,key){return isFormGroup?`with name: '${key}'`:`at index: ${key}`}function noControlsError(isFormGroup){return`
    There are no form controls registered with this ${isFormGroup?"group":"array"} yet. If you're using ngModel,
    you may want to check next tick (e.g. use setTimeout).
  `}function missingControlError(isFormGroup,key){return`Cannot find form control ${describeKey(isFormGroup,key)}`}function missingControlValueError(isFormGroup,key){return`Must supply a value for form control ${describeKey(isFormGroup,key)}`}function controlPath(name,parent){return[...parent.path,name]}function setUpControl(control,dir){if(typeof ngDevMode==="undefined"||ngDevMode){if(!control)_throwError(dir,"Cannot find control with");if(!dir.valueAccessor)_throwError(dir,"No value accessor for form control with")}setUpValidators(control,
dir);dir.valueAccessor.writeValue(control.value);setUpViewChangePipeline(control,dir);setUpModelChangePipeline(control,dir);setUpBlurPipeline(control,dir);setUpDisabledChangeHandler(control,dir)}function cleanUpControl(control,dir,validateControlPresenceOnChange=true){const noop=()=>{if(validateControlPresenceOnChange&&(typeof ngDevMode==="undefined"||ngDevMode))_noControlError(dir)};if(dir.valueAccessor){dir.valueAccessor.registerOnChange(noop);dir.valueAccessor.registerOnTouched(noop)}cleanUpValidators(control,
dir);if(control){dir._invokeOnDestroyCallbacks();control._registerOnCollectionChange(()=>{})}}function registerOnValidatorChange(validators,onChange){validators.forEach(validator=>{if(validator.registerOnValidatorChange)validator.registerOnValidatorChange(onChange)})}function setUpDisabledChangeHandler(control,dir){if(dir.valueAccessor.setDisabledState){const onDisabledChange=isDisabled=>{dir.valueAccessor.setDisabledState(isDisabled)};control.registerOnDisabledChange(onDisabledChange);dir._registerOnDestroy(()=>
{control._unregisterOnDisabledChange(onDisabledChange)})}}function setUpValidators(control,dir){const validators=getControlValidators(control);if(dir.validator!==null)control.setValidators(mergeValidators(validators,dir.validator));else if(typeof validators==="function")control.setValidators([validators]);const asyncValidators=getControlAsyncValidators(control);if(dir.asyncValidator!==null)control.setAsyncValidators(mergeValidators(asyncValidators,dir.asyncValidator));else if(typeof asyncValidators===
"function")control.setAsyncValidators([asyncValidators]);const onValidatorChange=()=>control.updateValueAndValidity();registerOnValidatorChange(dir._rawValidators,onValidatorChange);registerOnValidatorChange(dir._rawAsyncValidators,onValidatorChange)}function cleanUpValidators(control,dir){let isControlUpdated=false;if(control!==null){if(dir.validator!==null){const validators=getControlValidators(control);if(Array.isArray(validators)&&validators.length>0){const updatedValidators=validators.filter(validator=>
validator!==dir.validator);if(updatedValidators.length!==validators.length){isControlUpdated=true;control.setValidators(updatedValidators)}}}if(dir.asyncValidator!==null){const asyncValidators=getControlAsyncValidators(control);if(Array.isArray(asyncValidators)&&asyncValidators.length>0){const updatedAsyncValidators=asyncValidators.filter(asyncValidator=>asyncValidator!==dir.asyncValidator);if(updatedAsyncValidators.length!==asyncValidators.length){isControlUpdated=true;control.setAsyncValidators(updatedAsyncValidators)}}}}const noop=
()=>{};registerOnValidatorChange(dir._rawValidators,noop);registerOnValidatorChange(dir._rawAsyncValidators,noop);return isControlUpdated}function setUpViewChangePipeline(control,dir){dir.valueAccessor.registerOnChange(newValue=>{control._pendingValue=newValue;control._pendingChange=true;control._pendingDirty=true;if(control.updateOn==="change")updateControl(control,dir)})}function setUpBlurPipeline(control,dir){dir.valueAccessor.registerOnTouched(()=>{control._pendingTouched=true;if(control.updateOn===
"blur"&&control._pendingChange)updateControl(control,dir);if(control.updateOn!=="submit")control.markAsTouched()})}function updateControl(control,dir){if(control._pendingDirty)control.markAsDirty();control.setValue(control._pendingValue,{emitModelToViewChange:false});dir.viewToModelUpdate(control._pendingValue);control._pendingChange=false}function setUpModelChangePipeline(control,dir){const onChange=(newValue,emitModelEvent)=>{dir.valueAccessor.writeValue(newValue);if(emitModelEvent)dir.viewToModelUpdate(newValue)};
control.registerOnChange(onChange);dir._registerOnDestroy(()=>{control._unregisterOnChange(onChange)})}function setUpFormContainer(control,dir){if(control==null&&(typeof ngDevMode==="undefined"||ngDevMode))_throwError(dir,"Cannot find control with");setUpValidators(control,dir)}function cleanUpFormContainer(control,dir){return cleanUpValidators(control,dir)}function _noControlError(dir){return _throwError(dir,"There is no FormControl instance attached to form control element with")}function _throwError(dir,
message){const messageEnd=_describeControlLocation(dir);throw new Error(`${message} ${messageEnd}`);}function _describeControlLocation(dir){const path=dir.path;if(path&&path.length>1)return`path: '${path.join(" -> ")}'`;if(path===null||path===void 0?void 0:path[0])return`name: '${path}'`;return"unspecified name attribute"}function _throwInvalidValueAccessorError(dir){const loc=_describeControlLocation(dir);throw new Error(`Value accessor was not provided as an array for form control with ${loc}. `+
`Check that the \`NG_VALUE_ACCESSOR\` token is configured as a \`multi: true\` provider.`);}function isPropertyUpdated(changes,viewModel){if(!changes.hasOwnProperty("model"))return false;const change=changes["model"];if(change.isFirstChange())return true;return!Object.is(viewModel,change.currentValue)}function isBuiltInAccessor(valueAccessor){return Object.getPrototypeOf(valueAccessor.constructor)===BuiltInControlValueAccessor}function syncPendingControls(form,directives){form._syncPendingControls();
directives.forEach(dir=>{const control=dir.control;if(control.updateOn==="submit"&&control._pendingChange){dir.viewToModelUpdate(control._pendingValue);control._pendingChange=false}})}function selectValueAccessor(dir,valueAccessors){if(!valueAccessors)return null;if(!Array.isArray(valueAccessors)&&(typeof ngDevMode==="undefined"||ngDevMode))_throwInvalidValueAccessorError(dir);let defaultAccessor=undefined;let builtinAccessor=undefined;let customAccessor=undefined;valueAccessors.forEach(v=>{if(v.constructor===
DefaultValueAccessor)defaultAccessor=v;else if(isBuiltInAccessor(v)){if(builtinAccessor&&(typeof ngDevMode==="undefined"||ngDevMode))_throwError(dir,"More than one built-in value accessor matches form control with");builtinAccessor=v}else{if(customAccessor&&(typeof ngDevMode==="undefined"||ngDevMode))_throwError(dir,"More than one custom value accessor matches form control with");customAccessor=v}});if(customAccessor)return customAccessor;if(builtinAccessor)return builtinAccessor;if(defaultAccessor)return defaultAccessor;
if(typeof ngDevMode==="undefined"||ngDevMode)_throwError(dir,"No valid value accessor for form control with");return null}function removeListItem(list,el){const index=list.indexOf(el);if(index>-1)list.splice(index,1)}function _ngModelWarning(name,type,instance,warningConfig){if(warningConfig==="never")return;if((warningConfig===null||warningConfig==="once")&&!type._ngModelWarningSentOnce||warningConfig==="always"&&!instance._ngModelWarningSent){console.warn(ngModelWarning(name));type._ngModelWarningSentOnce=
true;instance._ngModelWarningSent=true}}const NG_DEV_MODE=typeof ngDevMode==="undefined"||!!ngDevMode;const VALID="VALID";const INVALID="INVALID";const PENDING="PENDING";const DISABLED="DISABLED";function _find(control,path,delimiter){if(path==null)return null;if(!Array.isArray(path))path=path.split(delimiter);if(Array.isArray(path)&&path.length===0)return null;let controlToFind=control;path.forEach(name=>{if(isFormGroup(controlToFind))controlToFind=controlToFind.controls.hasOwnProperty(name)?controlToFind.controls[name]:
null;else if(isFormArray(controlToFind))controlToFind=controlToFind.at(name)||null;else controlToFind=null});return controlToFind}function pickValidators(validatorOrOpts){return(isOptionsObj(validatorOrOpts)?validatorOrOpts.validators:validatorOrOpts)||null}function coerceToValidator(validator){return Array.isArray(validator)?composeValidators(validator):validator||null}function pickAsyncValidators(asyncValidator,validatorOrOpts){return(isOptionsObj(validatorOrOpts)?validatorOrOpts.asyncValidators:
asyncValidator)||null}function coerceToAsyncValidator(asyncValidator){return Array.isArray(asyncValidator)?composeAsyncValidators(asyncValidator):asyncValidator||null}function isOptionsObj(validatorOrOpts){return validatorOrOpts!=null&&!Array.isArray(validatorOrOpts)&&typeof validatorOrOpts==="object"}const isFormControl=control=>control instanceof FormControl;const isFormGroup=control=>control instanceof FormGroup;const isFormArray=control=>control instanceof FormArray;function getRawValue(control){return isFormControl(control)?
control.value:control.getRawValue()}function assertControlPresent(parent,key){const isGroup=isFormGroup(parent);const controls=parent.controls;const collection=isGroup?Object.keys(controls):controls;if(!collection.length)throw new i0["ɵRuntimeError"](1E3,NG_DEV_MODE?noControlsError(isGroup):"");if(!controls[key])throw new i0["ɵRuntimeError"](1001,NG_DEV_MODE?missingControlError(isGroup,key):"");}function assertAllValuesPresent(control,value){const isGroup=isFormGroup(control);control._forEachChild((_,
key)=>{if(value[key]===undefined)throw new i0["ɵRuntimeError"](1002,NG_DEV_MODE?missingControlValueError(isGroup,key):"");})}class AbstractControl{constructor(validators,asyncValidators){this._pendingDirty=false;this._hasOwnPendingAsyncValidator=false;this._pendingTouched=false;this._onCollectionChange=()=>{};this._parent=null;this.pristine=true;this.touched=false;this._onDisabledChange=[];this._rawValidators=validators;this._rawAsyncValidators=asyncValidators;this._composedValidatorFn=coerceToValidator(this._rawValidators);
this._composedAsyncValidatorFn=coerceToAsyncValidator(this._rawAsyncValidators)}get validator(){return this._composedValidatorFn}set validator(validatorFn){this._rawValidators=this._composedValidatorFn=validatorFn}get asyncValidator(){return this._composedAsyncValidatorFn}set asyncValidator(asyncValidatorFn){this._rawAsyncValidators=this._composedAsyncValidatorFn=asyncValidatorFn}get parent(){return this._parent}get valid(){return this.status===VALID}get invalid(){return this.status===INVALID}get pending(){return this.status==
PENDING}get disabled(){return this.status===DISABLED}get enabled(){return this.status!==DISABLED}get dirty(){return!this.pristine}get untouched(){return!this.touched}get updateOn(){return this._updateOn?this._updateOn:this.parent?this.parent.updateOn:"change"}setValidators(validators){this._rawValidators=validators;this._composedValidatorFn=coerceToValidator(validators)}setAsyncValidators(validators){this._rawAsyncValidators=validators;this._composedAsyncValidatorFn=coerceToAsyncValidator(validators)}addValidators(validators){this.setValidators(addValidators(validators,
this._rawValidators))}addAsyncValidators(validators){this.setAsyncValidators(addValidators(validators,this._rawAsyncValidators))}removeValidators(validators){this.setValidators(removeValidators(validators,this._rawValidators))}removeAsyncValidators(validators){this.setAsyncValidators(removeValidators(validators,this._rawAsyncValidators))}hasValidator(validator){return hasValidator(this._rawValidators,validator)}hasAsyncValidator(validator){return hasValidator(this._rawAsyncValidators,validator)}clearValidators(){this.validator=
null}clearAsyncValidators(){this.asyncValidator=null}markAsTouched(opts={}){this.touched=true;if(this._parent&&!opts.onlySelf)this._parent.markAsTouched(opts)}markAllAsTouched(){this.markAsTouched({onlySelf:true});this._forEachChild(control=>control.markAllAsTouched())}markAsUntouched(opts={}){this.touched=false;this._pendingTouched=false;this._forEachChild(control=>{control.markAsUntouched({onlySelf:true})});if(this._parent&&!opts.onlySelf)this._parent._updateTouched(opts)}markAsDirty(opts={}){this.pristine=
false;if(this._parent&&!opts.onlySelf)this._parent.markAsDirty(opts)}markAsPristine(opts={}){this.pristine=true;this._pendingDirty=false;this._forEachChild(control=>{control.markAsPristine({onlySelf:true})});if(this._parent&&!opts.onlySelf)this._parent._updatePristine(opts)}markAsPending(opts={}){this.status=PENDING;if(opts.emitEvent!==false)this.statusChanges.emit(this.status);if(this._parent&&!opts.onlySelf)this._parent.markAsPending(opts)}disable(opts={}){const skipPristineCheck=this._parentMarkedDirty(opts.onlySelf);
this.status=DISABLED;this.errors=null;this._forEachChild(control=>{control.disable(Object.assign(Object.assign({},opts),{onlySelf:true}))});this._updateValue();if(opts.emitEvent!==false){this.valueChanges.emit(this.value);this.statusChanges.emit(this.status)}this._updateAncestors(Object.assign(Object.assign({},opts),{skipPristineCheck}));this._onDisabledChange.forEach(changeFn=>changeFn(true))}enable(opts={}){const skipPristineCheck=this._parentMarkedDirty(opts.onlySelf);this.status=VALID;this._forEachChild(control=>
{control.enable(Object.assign(Object.assign({},opts),{onlySelf:true}))});this.updateValueAndValidity({onlySelf:true,emitEvent:opts.emitEvent});this._updateAncestors(Object.assign(Object.assign({},opts),{skipPristineCheck}));this._onDisabledChange.forEach(changeFn=>changeFn(false))}_updateAncestors(opts){if(this._parent&&!opts.onlySelf){this._parent.updateValueAndValidity(opts);if(!opts.skipPristineCheck)this._parent._updatePristine();this._parent._updateTouched()}}setParent(parent){this._parent=parent}updateValueAndValidity(opts=
{}){this._setInitialStatus();this._updateValue();if(this.enabled){this._cancelExistingSubscription();this.errors=this._runValidator();this.status=this._calculateStatus();if(this.status===VALID||this.status===PENDING)this._runAsyncValidator(opts.emitEvent)}if(opts.emitEvent!==false){this.valueChanges.emit(this.value);this.statusChanges.emit(this.status)}if(this._parent&&!opts.onlySelf)this._parent.updateValueAndValidity(opts)}_updateTreeValidity(opts={emitEvent:true}){this._forEachChild(ctrl=>ctrl._updateTreeValidity(opts));
this.updateValueAndValidity({onlySelf:true,emitEvent:opts.emitEvent})}_setInitialStatus(){this.status=this._allControlsDisabled()?DISABLED:VALID}_runValidator(){return this.validator?this.validator(this):null}_runAsyncValidator(emitEvent){if(this.asyncValidator){this.status=PENDING;this._hasOwnPendingAsyncValidator=true;const obs=toObservable(this.asyncValidator(this));this._asyncValidationSubscription=obs.subscribe(errors=>{this._hasOwnPendingAsyncValidator=false;this.setErrors(errors,{emitEvent})})}}_cancelExistingSubscription(){if(this._asyncValidationSubscription){this._asyncValidationSubscription.unsubscribe();
this._hasOwnPendingAsyncValidator=false}}setErrors(errors,opts={}){this.errors=errors;this._updateControlsErrors(opts.emitEvent!==false)}get(path){return _find(this,path,".")}getError(errorCode,path){const control=path?this.get(path):this;return control&&control.errors?control.errors[errorCode]:null}hasError(errorCode,path){return!!this.getError(errorCode,path)}get root(){let x=this;while(x._parent)x=x._parent;return x}_updateControlsErrors(emitEvent){this.status=this._calculateStatus();if(emitEvent)this.statusChanges.emit(this.status);
if(this._parent)this._parent._updateControlsErrors(emitEvent)}_initObservables(){this.valueChanges=new i0.EventEmitter;this.statusChanges=new i0.EventEmitter}_calculateStatus(){if(this._allControlsDisabled())return DISABLED;if(this.errors)return INVALID;if(this._hasOwnPendingAsyncValidator||this._anyControlsHaveStatus(PENDING))return PENDING;if(this._anyControlsHaveStatus(INVALID))return INVALID;return VALID}_anyControlsHaveStatus(status){return this._anyControls(control=>control.status===status)}_anyControlsDirty(){return this._anyControls(control=>
control.dirty)}_anyControlsTouched(){return this._anyControls(control=>control.touched)}_updatePristine(opts={}){this.pristine=!this._anyControlsDirty();if(this._parent&&!opts.onlySelf)this._parent._updatePristine(opts)}_updateTouched(opts={}){this.touched=this._anyControlsTouched();if(this._parent&&!opts.onlySelf)this._parent._updateTouched(opts)}_isBoxedValue(formState){return typeof formState==="object"&&formState!==null&&Object.keys(formState).length===2&&"value"in formState&&"disabled"in formState}_registerOnCollectionChange(fn){this._onCollectionChange=
fn}_setUpdateStrategy(opts){if(isOptionsObj(opts)&&opts.updateOn!=null)this._updateOn=opts.updateOn}_parentMarkedDirty(onlySelf){const parentDirty=this._parent&&this._parent.dirty;return!onlySelf&&!!parentDirty&&!this._parent._anyControlsDirty()}}class FormControl extends AbstractControl{constructor(formState=null,validatorOrOpts,asyncValidator){super(pickValidators(validatorOrOpts),pickAsyncValidators(asyncValidator,validatorOrOpts));this.defaultValue=null;this._onChange=[];this._pendingChange=false;
this._applyFormState(formState);this._setUpdateStrategy(validatorOrOpts);this._initObservables();this.updateValueAndValidity({onlySelf:true,emitEvent:!!this.asyncValidator});if(isOptionsObj(validatorOrOpts)&&validatorOrOpts.initialValueIsDefault)if(this._isBoxedValue(formState))this.defaultValue=formState.value;else this.defaultValue=formState}setValue(value,options={}){this.value=this._pendingValue=value;if(this._onChange.length&&options.emitModelToViewChange!==false)this._onChange.forEach(changeFn=>
changeFn(this.value,options.emitViewToModelChange!==false));this.updateValueAndValidity(options)}patchValue(value,options={}){this.setValue(value,options)}reset(formState=this.defaultValue,options={}){this._applyFormState(formState);this.markAsPristine(options);this.markAsUntouched(options);this.setValue(this.value,options);this._pendingChange=false}_updateValue(){}_anyControls(condition){return false}_allControlsDisabled(){return this.disabled}registerOnChange(fn){this._onChange.push(fn)}_unregisterOnChange(fn){removeListItem(this._onChange,
fn)}registerOnDisabledChange(fn){this._onDisabledChange.push(fn)}_unregisterOnDisabledChange(fn){removeListItem(this._onDisabledChange,fn)}_forEachChild(cb){}_syncPendingControls(){if(this.updateOn==="submit"){if(this._pendingDirty)this.markAsDirty();if(this._pendingTouched)this.markAsTouched();if(this._pendingChange){this.setValue(this._pendingValue,{onlySelf:true,emitModelToViewChange:false});return true}}return false}_applyFormState(formState){if(this._isBoxedValue(formState)){this.value=this._pendingValue=
formState.value;formState.disabled?this.disable({onlySelf:true,emitEvent:false}):this.enable({onlySelf:true,emitEvent:false})}else this.value=this._pendingValue=formState}}class FormGroup extends AbstractControl{constructor(controls,validatorOrOpts,asyncValidator){super(pickValidators(validatorOrOpts),pickAsyncValidators(asyncValidator,validatorOrOpts));this.controls=controls;this._initObservables();this._setUpdateStrategy(validatorOrOpts);this._setUpControls();this.updateValueAndValidity({onlySelf:true,
emitEvent:!!this.asyncValidator})}registerControl(name,control){if(this.controls[name])return this.controls[name];this.controls[name]=control;control.setParent(this);control._registerOnCollectionChange(this._onCollectionChange);return control}addControl(name,control,options={}){this.registerControl(name,control);this.updateValueAndValidity({emitEvent:options.emitEvent});this._onCollectionChange()}removeControl(name,options={}){if(this.controls[name])this.controls[name]._registerOnCollectionChange(()=>
{});delete this.controls[name];this.updateValueAndValidity({emitEvent:options.emitEvent});this._onCollectionChange()}setControl(name,control,options={}){if(this.controls[name])this.controls[name]._registerOnCollectionChange(()=>{});delete this.controls[name];if(control)this.registerControl(name,control);this.updateValueAndValidity({emitEvent:options.emitEvent});this._onCollectionChange()}contains(controlName){return this.controls.hasOwnProperty(controlName)&&this.controls[controlName].enabled}setValue(value,
options={}){assertAllValuesPresent(this,value);Object.keys(value).forEach(name=>{assertControlPresent(this,name);this.controls[name].setValue(value[name],{onlySelf:true,emitEvent:options.emitEvent})});this.updateValueAndValidity(options)}patchValue(value,options={}){if(value==null)return;Object.keys(value).forEach(name=>{if(this.controls[name])this.controls[name].patchValue(value[name],{onlySelf:true,emitEvent:options.emitEvent})});this.updateValueAndValidity(options)}reset(value={},options={}){this._forEachChild((control,
name)=>{control.reset(value[name],{onlySelf:true,emitEvent:options.emitEvent})});this._updatePristine(options);this._updateTouched(options);this.updateValueAndValidity(options)}getRawValue(){return this._reduceChildren({},(acc,control,name)=>{acc[name]=getRawValue(control);return acc})}_syncPendingControls(){let subtreeUpdated=this._reduceChildren(false,(updated,child)=>{return child._syncPendingControls()?true:updated});if(subtreeUpdated)this.updateValueAndValidity({onlySelf:true});return subtreeUpdated}_forEachChild(cb){Object.keys(this.controls).forEach(key=>
{const control=this.controls[key];control&&cb(control,key)})}_setUpControls(){this._forEachChild(control=>{control.setParent(this);control._registerOnCollectionChange(this._onCollectionChange)})}_updateValue(){this.value=this._reduceValue()}_anyControls(condition){for(const controlName of Object.keys(this.controls)){const control=this.controls[controlName];if(this.contains(controlName)&&condition(control))return true}return false}_reduceValue(){return this._reduceChildren({},(acc,control,name)=>{if(control.enabled||
this.disabled)acc[name]=control.value;return acc})}_reduceChildren(initValue,fn){let res=initValue;this._forEachChild((control,name)=>{res=fn(res,control,name)});return res}_allControlsDisabled(){for(const controlName of Object.keys(this.controls))if(this.controls[controlName].enabled)return false;return Object.keys(this.controls).length>0||this.disabled}}class FormArray extends AbstractControl{constructor(controls,validatorOrOpts,asyncValidator){super(pickValidators(validatorOrOpts),pickAsyncValidators(asyncValidator,
validatorOrOpts));this.controls=controls;this._initObservables();this._setUpdateStrategy(validatorOrOpts);this._setUpControls();this.updateValueAndValidity({onlySelf:true,emitEvent:!!this.asyncValidator})}at(index){return this.controls[index]}push(control,options={}){this.controls.push(control);this._registerControl(control);this.updateValueAndValidity({emitEvent:options.emitEvent});this._onCollectionChange()}insert(index,control,options={}){this.controls.splice(index,0,control);this._registerControl(control);
this.updateValueAndValidity({emitEvent:options.emitEvent})}removeAt(index,options={}){if(this.controls[index])this.controls[index]._registerOnCollectionChange(()=>{});this.controls.splice(index,1);this.updateValueAndValidity({emitEvent:options.emitEvent})}setControl(index,control,options={}){if(this.controls[index])this.controls[index]._registerOnCollectionChange(()=>{});this.controls.splice(index,1);if(control){this.controls.splice(index,0,control);this._registerControl(control)}this.updateValueAndValidity({emitEvent:options.emitEvent});
this._onCollectionChange()}get length(){return this.controls.length}setValue(value,options={}){assertAllValuesPresent(this,value);value.forEach((newValue,index)=>{assertControlPresent(this,index);this.at(index).setValue(newValue,{onlySelf:true,emitEvent:options.emitEvent})});this.updateValueAndValidity(options)}patchValue(value,options={}){if(value==null)return;value.forEach((newValue,index)=>{if(this.at(index))this.at(index).patchValue(newValue,{onlySelf:true,emitEvent:options.emitEvent})});this.updateValueAndValidity(options)}reset(value=
[],options={}){this._forEachChild((control,index)=>{control.reset(value[index],{onlySelf:true,emitEvent:options.emitEvent})});this._updatePristine(options);this._updateTouched(options);this.updateValueAndValidity(options)}getRawValue(){return this.controls.map(control=>getRawValue(control))}clear(options={}){if(this.controls.length<1)return;this._forEachChild(control=>control._registerOnCollectionChange(()=>{}));this.controls.splice(0);this.updateValueAndValidity({emitEvent:options.emitEvent})}_syncPendingControls(){let subtreeUpdated=
this.controls.reduce((updated,child)=>{return child._syncPendingControls()?true:updated},false);if(subtreeUpdated)this.updateValueAndValidity({onlySelf:true});return subtreeUpdated}_forEachChild(cb){this.controls.forEach((control,index)=>{cb(control,index)})}_updateValue(){this.value=this.controls.filter(control=>control.enabled||this.disabled).map(control=>control.value)}_anyControls(condition){return this.controls.some(control=>control.enabled&&condition(control))}_setUpControls(){this._forEachChild(control=>
this._registerControl(control))}_allControlsDisabled(){for(const control of this.controls)if(control.enabled)return false;return this.controls.length>0||this.disabled}_registerControl(control){control.setParent(this);control._registerOnCollectionChange(this._onCollectionChange)}}const formDirectiveProvider$1={provide:ControlContainer,useExisting:i0.forwardRef(()=>NgForm)};const resolvedPromise$1=(()=>Promise.resolve(null))();class NgForm extends ControlContainer{constructor(validators,asyncValidators){super();
this.submitted=false;this._directives=new Set;this.ngSubmit=new i0.EventEmitter;this.form=new FormGroup({},composeValidators(validators),composeAsyncValidators(asyncValidators))}ngAfterViewInit(){this._setUpdateStrategy()}get formDirective(){return this}get control(){return this.form}get path(){return[]}get controls(){return this.form.controls}addControl(dir){resolvedPromise$1.then(()=>{const container=this._findContainer(dir.path);dir.control=container.registerControl(dir.name,dir.control);setUpControl(dir.control,
dir);dir.control.updateValueAndValidity({emitEvent:false});this._directives.add(dir)})}getControl(dir){return this.form.get(dir.path)}removeControl(dir){resolvedPromise$1.then(()=>{const container=this._findContainer(dir.path);if(container)container.removeControl(dir.name);this._directives.delete(dir)})}addFormGroup(dir){resolvedPromise$1.then(()=>{const container=this._findContainer(dir.path);const group=new FormGroup({});setUpFormContainer(group,dir);container.registerControl(dir.name,group);group.updateValueAndValidity({emitEvent:false})})}removeFormGroup(dir){resolvedPromise$1.then(()=>
{const container=this._findContainer(dir.path);if(container)container.removeControl(dir.name)})}getFormGroup(dir){return this.form.get(dir.path)}updateModel(dir,value){resolvedPromise$1.then(()=>{const ctrl=this.form.get(dir.path);ctrl.setValue(value)})}setValue(value){this.control.setValue(value)}onSubmit($event){this.submitted=true;syncPendingControls(this.form,this._directives);this.ngSubmit.emit($event);return false}onReset(){this.resetForm()}resetForm(value=undefined){this.form.reset(value);
this.submitted=false}_setUpdateStrategy(){if(this.options&&this.options.updateOn!=null)this.form._updateOn=this.options.updateOn}_findContainer(path){path.pop();return path.length?this.form.get(path):this.form}}NgForm.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:NgForm,deps:[{token:NG_VALIDATORS,optional:true,self:true},{token:NG_ASYNC_VALIDATORS,optional:true,self:true}],target:i0__namespace.\u0275\u0275FactoryTarget.Directive});
NgForm.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:NgForm,selector:"form:not([ngNoForm]):not([formGroup]),ng-form,[ngForm]",inputs:{options:["ngFormOptions","options"]},outputs:{ngSubmit:"ngSubmit"},host:{listeners:{"submit":"onSubmit($event)","reset":"onReset()"}},providers:[formDirectiveProvider$1],exportAs:["ngForm"],usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",
ngImport:i0__namespace,type:NgForm,decorators:[{type:i0.Directive,args:[{selector:"form:not([ngNoForm]):not([formGroup]),ng-form,[ngForm]",providers:[formDirectiveProvider$1],host:{"(submit)":"onSubmit($event)","(reset)":"onReset()"},outputs:["ngSubmit"],exportAs:"ngForm"}]}],ctorParameters:function(){return[{type:undefined,decorators:[{type:i0.Optional},{type:i0.Self},{type:i0.Inject,args:[NG_VALIDATORS]}]},{type:undefined,decorators:[{type:i0.Optional},{type:i0.Self},{type:i0.Inject,args:[NG_ASYNC_VALIDATORS]}]}]},
propDecorators:{options:[{type:i0.Input,args:["ngFormOptions"]}]}});class AbstractFormGroupDirective extends ControlContainer{ngOnInit(){this._checkParentType();this.formDirective.addFormGroup(this)}ngOnDestroy(){if(this.formDirective)this.formDirective.removeFormGroup(this)}get control(){return this.formDirective.getFormGroup(this)}get path(){return controlPath(this.name==null?this.name:this.name.toString(),this._parent)}get formDirective(){return this._parent?this._parent.formDirective:null}_checkParentType(){}}
AbstractFormGroupDirective.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:AbstractFormGroupDirective,deps:null,target:i0__namespace.\u0275\u0275FactoryTarget.Directive});AbstractFormGroupDirective.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:AbstractFormGroupDirective,usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:AbstractFormGroupDirective,decorators:[{type:i0.Directive}]});function modelParentException(){return new Error(`
    ngModel cannot be used to register form controls with a parent formGroup directive.  Try using
    formGroup's partner directive "formControlName" instead.  Example:

    ${formControlNameExample}

    Or, if you'd like to avoid registering this form control, indicate that it's standalone in ngModelOptions:

    Example:

    ${ngModelWithFormGroupExample}`)}function formGroupNameException(){return new Error(`
    ngModel cannot be used to register form controls with a parent formGroupName or formArrayName directive.

    Option 1: Use formControlName instead of ngModel (reactive strategy):

    ${formGroupNameExample}

    Option 2:  Update ngModel's parent be ngModelGroup (template-driven strategy):

    ${ngModelGroupExample}`)}function missingNameException(){return new Error(`If ngModel is used within a form tag, either the name attribute must be set or the form
    control must be defined as 'standalone' in ngModelOptions.

    Example 1: <input [(ngModel)]="person.firstName" name="first">
    Example 2: <input [(ngModel)]="person.firstName" [ngModelOptions]="{standalone: true}">`)}function modelGroupParentException(){return new Error(`
    ngModelGroup cannot be used with a parent formGroup directive.

    Option 1: Use formGroupName instead of ngModelGroup (reactive strategy):

    ${formGroupNameExample}

    Option 2:  Use a regular form tag instead of the formGroup directive (template-driven strategy):

    ${ngModelGroupExample}`)}const modelGroupProvider={provide:ControlContainer,useExisting:i0.forwardRef(()=>NgModelGroup)};class NgModelGroup extends AbstractFormGroupDirective{constructor(parent,validators,asyncValidators){super();this._parent=parent;this._setValidators(validators);this._setAsyncValidators(asyncValidators)}_checkParentType(){if(!(this._parent instanceof NgModelGroup)&&!(this._parent instanceof NgForm)&&(typeof ngDevMode==="undefined"||ngDevMode))throw modelGroupParentException();
}}NgModelGroup.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:NgModelGroup,deps:[{token:ControlContainer,host:true,skipSelf:true},{token:NG_VALIDATORS,optional:true,self:true},{token:NG_ASYNC_VALIDATORS,optional:true,self:true}],target:i0__namespace.\u0275\u0275FactoryTarget.Directive});NgModelGroup.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:NgModelGroup,selector:"[ngModelGroup]",
inputs:{name:["ngModelGroup","name"]},providers:[modelGroupProvider],exportAs:["ngModelGroup"],usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:NgModelGroup,decorators:[{type:i0.Directive,args:[{selector:"[ngModelGroup]",providers:[modelGroupProvider],exportAs:"ngModelGroup"}]}],ctorParameters:function(){return[{type:ControlContainer,decorators:[{type:i0.Host},{type:i0.SkipSelf}]},{type:undefined,
decorators:[{type:i0.Optional},{type:i0.Self},{type:i0.Inject,args:[NG_VALIDATORS]}]},{type:undefined,decorators:[{type:i0.Optional},{type:i0.Self},{type:i0.Inject,args:[NG_ASYNC_VALIDATORS]}]}]},propDecorators:{name:[{type:i0.Input,args:["ngModelGroup"]}]}});const formControlBinding$1={provide:NgControl,useExisting:i0.forwardRef(()=>NgModel)};const resolvedPromise=(()=>Promise.resolve(null))();class NgModel extends NgControl{constructor(parent,validators,asyncValidators,valueAccessors,_changeDetectorRef){super();
this._changeDetectorRef=_changeDetectorRef;this.control=new FormControl;this._registered=false;this.update=new i0.EventEmitter;this._parent=parent;this._setValidators(validators);this._setAsyncValidators(asyncValidators);this.valueAccessor=selectValueAccessor(this,valueAccessors)}ngOnChanges(changes){this._checkForErrors();if(!this._registered||"name"in changes){if(this._registered){this._checkName();if(this.formDirective){const oldName=changes["name"].previousValue;this.formDirective.removeControl({name:oldName,
path:this._getPath(oldName)})}}this._setUpControl()}if("isDisabled"in changes)this._updateDisabled(changes);if(isPropertyUpdated(changes,this.viewModel)){this._updateValue(this.model);this.viewModel=this.model}}ngOnDestroy(){this.formDirective&&this.formDirective.removeControl(this)}get path(){return this._getPath(this.name)}get formDirective(){return this._parent?this._parent.formDirective:null}viewToModelUpdate(newValue){this.viewModel=newValue;this.update.emit(newValue)}_setUpControl(){this._setUpdateStrategy();
this._isStandalone()?this._setUpStandalone():this.formDirective.addControl(this);this._registered=true}_setUpdateStrategy(){if(this.options&&this.options.updateOn!=null)this.control._updateOn=this.options.updateOn}_isStandalone(){return!this._parent||!!(this.options&&this.options.standalone)}_setUpStandalone(){setUpControl(this.control,this);this.control.updateValueAndValidity({emitEvent:false})}_checkForErrors(){if(!this._isStandalone())this._checkParentType();this._checkName()}_checkParentType(){if(typeof ngDevMode===
"undefined"||ngDevMode)if(!(this._parent instanceof NgModelGroup)&&this._parent instanceof AbstractFormGroupDirective)throw formGroupNameException();else if(!(this._parent instanceof NgModelGroup)&&!(this._parent instanceof NgForm))throw modelParentException();}_checkName(){if(this.options&&this.options.name)this.name=this.options.name;if(!this._isStandalone()&&!this.name&&(typeof ngDevMode==="undefined"||ngDevMode))throw missingNameException();}_updateValue(value){resolvedPromise.then(()=>{var _a;
this.control.setValue(value,{emitViewToModelChange:false});(_a=this._changeDetectorRef)===null||_a===void 0?void 0:_a.markForCheck()})}_updateDisabled(changes){const disabledValue=changes["isDisabled"].currentValue;const isDisabled=disabledValue===""||disabledValue&&disabledValue!=="false";resolvedPromise.then(()=>{var _a;if(isDisabled&&!this.control.disabled)this.control.disable();else if(!isDisabled&&this.control.disabled)this.control.enable();(_a=this._changeDetectorRef)===null||_a===void 0?void 0:
_a.markForCheck()})}_getPath(controlName){return this._parent?controlPath(controlName,this._parent):[controlName]}}NgModel.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:NgModel,deps:[{token:ControlContainer,host:true,optional:true},{token:NG_VALIDATORS,optional:true,self:true},{token:NG_ASYNC_VALIDATORS,optional:true,self:true},{token:NG_VALUE_ACCESSOR,optional:true,self:true},{token:i0.ChangeDetectorRef,optional:true}],target:i0__namespace.\u0275\u0275FactoryTarget.Directive});
NgModel.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:NgModel,selector:"[ngModel]:not([formControlName]):not([formControl])",inputs:{name:"name",isDisabled:["disabled","isDisabled"],model:["ngModel","model"],options:["ngModelOptions","options"]},outputs:{update:"ngModelChange"},providers:[formControlBinding$1],exportAs:["ngModel"],usesInheritance:true,usesOnChanges:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:NgModel,decorators:[{type:i0.Directive,args:[{selector:"[ngModel]:not([formControlName]):not([formControl])",providers:[formControlBinding$1],exportAs:"ngModel"}]}],ctorParameters:function(){return[{type:ControlContainer,decorators:[{type:i0.Optional},{type:i0.Host}]},{type:undefined,decorators:[{type:i0.Optional},{type:i0.Self},{type:i0.Inject,args:[NG_VALIDATORS]}]},{type:undefined,decorators:[{type:i0.Optional},{type:i0.Self},{type:i0.Inject,args:[NG_ASYNC_VALIDATORS]}]},
{type:undefined,decorators:[{type:i0.Optional},{type:i0.Self},{type:i0.Inject,args:[NG_VALUE_ACCESSOR]}]},{type:i0__namespace.ChangeDetectorRef,decorators:[{type:i0.Optional},{type:i0.Inject,args:[i0.ChangeDetectorRef]}]}]},propDecorators:{name:[{type:i0.Input}],isDisabled:[{type:i0.Input,args:["disabled"]}],model:[{type:i0.Input,args:["ngModel"]}],options:[{type:i0.Input,args:["ngModelOptions"]}],update:[{type:i0.Output,args:["ngModelChange"]}]}});class \u0275NgNoValidate{}\u0275NgNoValidate.\u0275fac=
i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:\u0275NgNoValidate,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.Directive});\u0275NgNoValidate.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:\u0275NgNoValidate,selector:"form:not([ngNoForm]):not([ngNativeValidate])",host:{attributes:{"novalidate":""}},ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:\u0275NgNoValidate,decorators:[{type:i0.Directive,args:[{selector:"form:not([ngNoForm]):not([ngNativeValidate])",host:{"novalidate":""}}]}]});const NUMBER_VALUE_ACCESSOR={provide:NG_VALUE_ACCESSOR,useExisting:i0.forwardRef(()=>NumberValueAccessor),multi:true};class NumberValueAccessor extends BuiltInControlValueAccessor{writeValue(value){const normalizedValue=value==null?"":value;this.setProperty("value",normalizedValue)}registerOnChange(fn){this.onChange=
value=>{fn(value==""?null:parseFloat(value))}}}NumberValueAccessor.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:NumberValueAccessor,deps:null,target:i0__namespace.\u0275\u0275FactoryTarget.Directive});NumberValueAccessor.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:NumberValueAccessor,selector:"input[type=number][formControlName],input[type=number][formControl],input[type=number][ngModel]",
host:{listeners:{"input":"onChange($event.target.value)","blur":"onTouched()"}},providers:[NUMBER_VALUE_ACCESSOR],usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:NumberValueAccessor,decorators:[{type:i0.Directive,args:[{selector:"input[type=number][formControlName],input[type=number][formControl],input[type=number][ngModel]",host:{"(input)":"onChange($event.target.value)","(blur)":"onTouched()"},
providers:[NUMBER_VALUE_ACCESSOR]}]}]});const RADIO_VALUE_ACCESSOR={provide:NG_VALUE_ACCESSOR,useExisting:i0.forwardRef(()=>RadioControlValueAccessor),multi:true};function throwNameError(){throw new Error(`
      If you define both a name and a formControlName attribute on your radio button, their values
      must match. Ex: <input type="radio" formControlName="food" name="food">
    `);}class RadioControlRegistryModule{}RadioControlRegistryModule.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:RadioControlRegistryModule,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.NgModule});RadioControlRegistryModule.\u0275mod=i0__namespace.\u0275\u0275ngDeclareNgModule({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:RadioControlRegistryModule});RadioControlRegistryModule.\u0275inj=i0__namespace.\u0275\u0275ngDeclareInjector({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:RadioControlRegistryModule});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:RadioControlRegistryModule,decorators:[{type:i0.NgModule}]});class RadioControlRegistry{constructor(){this._accessors=[]}add(control,accessor){this._accessors.push([control,accessor])}remove(accessor){for(let i=this._accessors.length-1;i>=0;--i)if(this._accessors[i][1]===accessor){this._accessors.splice(i,1);return}}select(accessor){this._accessors.forEach(c=>
{if(this._isSameGroup(c,accessor)&&c[1]!==accessor)c[1].fireUncheck(accessor.value)})}_isSameGroup(controlPair,accessor){if(!controlPair[0].control)return false;return controlPair[0]._parent===accessor._control._parent&&controlPair[1].name===accessor.name}}RadioControlRegistry.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:RadioControlRegistry,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});RadioControlRegistry.\u0275prov=
i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:RadioControlRegistry,providedIn:RadioControlRegistryModule});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:RadioControlRegistry,decorators:[{type:i0.Injectable,args:[{providedIn:RadioControlRegistryModule}]}]});class RadioControlValueAccessor extends BuiltInControlValueAccessor{constructor(renderer,elementRef,_registry,
_injector){super(renderer,elementRef);this._registry=_registry;this._injector=_injector;this.onChange=()=>{}}ngOnInit(){this._control=this._injector.get(NgControl);this._checkName();this._registry.add(this._control,this)}ngOnDestroy(){this._registry.remove(this)}writeValue(value){this._state=value===this.value;this.setProperty("checked",this._state)}registerOnChange(fn){this._fn=fn;this.onChange=()=>{fn(this.value);this._registry.select(this)}}fireUncheck(value){this.writeValue(value)}_checkName(){if(this.name&&
this.formControlName&&this.name!==this.formControlName&&(typeof ngDevMode==="undefined"||ngDevMode))throwNameError();if(!this.name&&this.formControlName)this.name=this.formControlName}}RadioControlValueAccessor.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:RadioControlValueAccessor,deps:[{token:i0__namespace.Renderer2},{token:i0__namespace.ElementRef},{token:RadioControlRegistry},{token:i0__namespace.Injector}],target:i0__namespace.\u0275\u0275FactoryTarget.Directive});
RadioControlValueAccessor.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:RadioControlValueAccessor,selector:"input[type=radio][formControlName],input[type=radio][formControl],input[type=radio][ngModel]",inputs:{name:"name",formControlName:"formControlName",value:"value"},host:{listeners:{"change":"onChange()","blur":"onTouched()"}},providers:[RADIO_VALUE_ACCESSOR],usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:RadioControlValueAccessor,decorators:[{type:i0.Directive,args:[{selector:"input[type=radio][formControlName],input[type=radio][formControl],input[type=radio][ngModel]",host:{"(change)":"onChange()","(blur)":"onTouched()"},providers:[RADIO_VALUE_ACCESSOR]}]}],ctorParameters:function(){return[{type:i0__namespace.Renderer2},{type:i0__namespace.ElementRef},{type:RadioControlRegistry},{type:i0__namespace.Injector}]},propDecorators:{name:[{type:i0.Input}],formControlName:[{type:i0.Input}],
value:[{type:i0.Input}]}});const RANGE_VALUE_ACCESSOR={provide:NG_VALUE_ACCESSOR,useExisting:i0.forwardRef(()=>RangeValueAccessor),multi:true};class RangeValueAccessor extends BuiltInControlValueAccessor{writeValue(value){this.setProperty("value",parseFloat(value))}registerOnChange(fn){this.onChange=value=>{fn(value==""?null:parseFloat(value))}}}RangeValueAccessor.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:RangeValueAccessor,
deps:null,target:i0__namespace.\u0275\u0275FactoryTarget.Directive});RangeValueAccessor.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:RangeValueAccessor,selector:"input[type=range][formControlName],input[type=range][formControl],input[type=range][ngModel]",host:{listeners:{"change":"onChange($event.target.value)","input":"onChange($event.target.value)","blur":"onTouched()"}},providers:[RANGE_VALUE_ACCESSOR],usesInheritance:true,ngImport:i0__namespace});
i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:RangeValueAccessor,decorators:[{type:i0.Directive,args:[{selector:"input[type=range][formControlName],input[type=range][formControl],input[type=range][ngModel]",host:{"(change)":"onChange($event.target.value)","(input)":"onChange($event.target.value)","(blur)":"onTouched()"},providers:[RANGE_VALUE_ACCESSOR]}]}]});const NG_MODEL_WITH_FORM_CONTROL_WARNING=new i0.InjectionToken("NgModelWithFormControlWarning");
const formControlBinding={provide:NgControl,useExisting:i0.forwardRef(()=>FormControlDirective)};class FormControlDirective extends NgControl{constructor(validators,asyncValidators,valueAccessors,_ngModelWarningConfig){super();this._ngModelWarningConfig=_ngModelWarningConfig;this.update=new i0.EventEmitter;this._ngModelWarningSent=false;this._setValidators(validators);this._setAsyncValidators(asyncValidators);this.valueAccessor=selectValueAccessor(this,valueAccessors)}set isDisabled(isDisabled){if(typeof ngDevMode===
"undefined"||ngDevMode)console.warn(disabledAttrWarning)}ngOnChanges(changes){if(this._isControlChanged(changes)){const previousForm=changes["form"].previousValue;if(previousForm)cleanUpControl(previousForm,this,false);setUpControl(this.form,this);if(this.control.disabled&&this.valueAccessor.setDisabledState)this.valueAccessor.setDisabledState(true);this.form.updateValueAndValidity({emitEvent:false})}if(isPropertyUpdated(changes,this.viewModel)){if(typeof ngDevMode==="undefined"||ngDevMode)_ngModelWarning("formControl",
FormControlDirective,this,this._ngModelWarningConfig);this.form.setValue(this.model);this.viewModel=this.model}}ngOnDestroy(){if(this.form)cleanUpControl(this.form,this,false)}get path(){return[]}get control(){return this.form}viewToModelUpdate(newValue){this.viewModel=newValue;this.update.emit(newValue)}_isControlChanged(changes){return changes.hasOwnProperty("form")}}FormControlDirective._ngModelWarningSentOnce=false;FormControlDirective.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:FormControlDirective,deps:[{token:NG_VALIDATORS,optional:true,self:true},{token:NG_ASYNC_VALIDATORS,optional:true,self:true},{token:NG_VALUE_ACCESSOR,optional:true,self:true},{token:NG_MODEL_WITH_FORM_CONTROL_WARNING,optional:true}],target:i0__namespace.\u0275\u0275FactoryTarget.Directive});FormControlDirective.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:FormControlDirective,selector:"[formControl]",
inputs:{form:["formControl","form"],isDisabled:["disabled","isDisabled"],model:["ngModel","model"]},outputs:{update:"ngModelChange"},providers:[formControlBinding],exportAs:["ngForm"],usesInheritance:true,usesOnChanges:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:FormControlDirective,decorators:[{type:i0.Directive,args:[{selector:"[formControl]",providers:[formControlBinding],exportAs:"ngForm"}]}],
ctorParameters:function(){return[{type:undefined,decorators:[{type:i0.Optional},{type:i0.Self},{type:i0.Inject,args:[NG_VALIDATORS]}]},{type:undefined,decorators:[{type:i0.Optional},{type:i0.Self},{type:i0.Inject,args:[NG_ASYNC_VALIDATORS]}]},{type:undefined,decorators:[{type:i0.Optional},{type:i0.Self},{type:i0.Inject,args:[NG_VALUE_ACCESSOR]}]},{type:undefined,decorators:[{type:i0.Optional},{type:i0.Inject,args:[NG_MODEL_WITH_FORM_CONTROL_WARNING]}]}]},propDecorators:{form:[{type:i0.Input,args:["formControl"]}],
isDisabled:[{type:i0.Input,args:["disabled"]}],model:[{type:i0.Input,args:["ngModel"]}],update:[{type:i0.Output,args:["ngModelChange"]}]}});const formDirectiveProvider={provide:ControlContainer,useExisting:i0.forwardRef(()=>FormGroupDirective)};class FormGroupDirective extends ControlContainer{constructor(validators,asyncValidators){super();this.validators=validators;this.asyncValidators=asyncValidators;this.submitted=false;this._onCollectionChange=()=>this._updateDomValue();this.directives=[];this.form=
null;this.ngSubmit=new i0.EventEmitter;this._setValidators(validators);this._setAsyncValidators(asyncValidators)}ngOnChanges(changes){this._checkFormPresent();if(changes.hasOwnProperty("form")){this._updateValidators();this._updateDomValue();this._updateRegistrations();this._oldForm=this.form}}ngOnDestroy(){if(this.form){cleanUpValidators(this.form,this);if(this.form._onCollectionChange===this._onCollectionChange)this.form._registerOnCollectionChange(()=>{})}}get formDirective(){return this}get control(){return this.form}get path(){return[]}addControl(dir){const ctrl=
this.form.get(dir.path);setUpControl(ctrl,dir);ctrl.updateValueAndValidity({emitEvent:false});this.directives.push(dir);return ctrl}getControl(dir){return this.form.get(dir.path)}removeControl(dir){cleanUpControl(dir.control||null,dir,false);removeListItem(this.directives,dir)}addFormGroup(dir){this._setUpFormContainer(dir)}removeFormGroup(dir){this._cleanUpFormContainer(dir)}getFormGroup(dir){return this.form.get(dir.path)}addFormArray(dir){this._setUpFormContainer(dir)}removeFormArray(dir){this._cleanUpFormContainer(dir)}getFormArray(dir){return this.form.get(dir.path)}updateModel(dir,
value){const ctrl=this.form.get(dir.path);ctrl.setValue(value)}onSubmit($event){this.submitted=true;syncPendingControls(this.form,this.directives);this.ngSubmit.emit($event);return false}onReset(){this.resetForm()}resetForm(value=undefined){this.form.reset(value);this.submitted=false}_updateDomValue(){this.directives.forEach(dir=>{const oldCtrl=dir.control;const newCtrl=this.form.get(dir.path);if(oldCtrl!==newCtrl){cleanUpControl(oldCtrl||null,dir);if(isFormControl(newCtrl)){setUpControl(newCtrl,
dir);dir.control=newCtrl}}});this.form._updateTreeValidity({emitEvent:false})}_setUpFormContainer(dir){const ctrl=this.form.get(dir.path);setUpFormContainer(ctrl,dir);ctrl.updateValueAndValidity({emitEvent:false})}_cleanUpFormContainer(dir){if(this.form){const ctrl=this.form.get(dir.path);if(ctrl){const isControlUpdated=cleanUpFormContainer(ctrl,dir);if(isControlUpdated)ctrl.updateValueAndValidity({emitEvent:false})}}}_updateRegistrations(){this.form._registerOnCollectionChange(this._onCollectionChange);
if(this._oldForm)this._oldForm._registerOnCollectionChange(()=>{})}_updateValidators(){setUpValidators(this.form,this);if(this._oldForm)cleanUpValidators(this._oldForm,this)}_checkFormPresent(){if(!this.form&&(typeof ngDevMode==="undefined"||ngDevMode))throw missingFormException();}}FormGroupDirective.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:FormGroupDirective,deps:[{token:NG_VALIDATORS,optional:true,self:true},{token:NG_ASYNC_VALIDATORS,
optional:true,self:true}],target:i0__namespace.\u0275\u0275FactoryTarget.Directive});FormGroupDirective.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:FormGroupDirective,selector:"[formGroup]",inputs:{form:["formGroup","form"]},outputs:{ngSubmit:"ngSubmit"},host:{listeners:{"submit":"onSubmit($event)","reset":"onReset()"}},providers:[formDirectiveProvider],exportAs:["ngForm"],usesInheritance:true,usesOnChanges:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:FormGroupDirective,decorators:[{type:i0.Directive,args:[{selector:"[formGroup]",providers:[formDirectiveProvider],host:{"(submit)":"onSubmit($event)","(reset)":"onReset()"},exportAs:"ngForm"}]}],ctorParameters:function(){return[{type:undefined,decorators:[{type:i0.Optional},{type:i0.Self},{type:i0.Inject,args:[NG_VALIDATORS]}]},{type:undefined,decorators:[{type:i0.Optional},{type:i0.Self},{type:i0.Inject,args:[NG_ASYNC_VALIDATORS]}]}]},propDecorators:{form:[{type:i0.Input,
args:["formGroup"]}],ngSubmit:[{type:i0.Output}]}});const formGroupNameProvider={provide:ControlContainer,useExisting:i0.forwardRef(()=>FormGroupName)};class FormGroupName extends AbstractFormGroupDirective{constructor(parent,validators,asyncValidators){super();this._parent=parent;this._setValidators(validators);this._setAsyncValidators(asyncValidators)}_checkParentType(){if(_hasInvalidParent(this._parent)&&(typeof ngDevMode==="undefined"||ngDevMode))throw groupParentException();}}FormGroupName.\u0275fac=
i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:FormGroupName,deps:[{token:ControlContainer,host:true,optional:true,skipSelf:true},{token:NG_VALIDATORS,optional:true,self:true},{token:NG_ASYNC_VALIDATORS,optional:true,self:true}],target:i0__namespace.\u0275\u0275FactoryTarget.Directive});FormGroupName.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:FormGroupName,selector:"[formGroupName]",
inputs:{name:["formGroupName","name"]},providers:[formGroupNameProvider],usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:FormGroupName,decorators:[{type:i0.Directive,args:[{selector:"[formGroupName]",providers:[formGroupNameProvider]}]}],ctorParameters:function(){return[{type:ControlContainer,decorators:[{type:i0.Optional},{type:i0.Host},{type:i0.SkipSelf}]},{type:undefined,decorators:[{type:i0.Optional},
{type:i0.Self},{type:i0.Inject,args:[NG_VALIDATORS]}]},{type:undefined,decorators:[{type:i0.Optional},{type:i0.Self},{type:i0.Inject,args:[NG_ASYNC_VALIDATORS]}]}]},propDecorators:{name:[{type:i0.Input,args:["formGroupName"]}]}});const formArrayNameProvider={provide:ControlContainer,useExisting:i0.forwardRef(()=>FormArrayName)};class FormArrayName extends ControlContainer{constructor(parent,validators,asyncValidators){super();this._parent=parent;this._setValidators(validators);this._setAsyncValidators(asyncValidators)}ngOnInit(){this._checkParentType();
this.formDirective.addFormArray(this)}ngOnDestroy(){if(this.formDirective)this.formDirective.removeFormArray(this)}get control(){return this.formDirective.getFormArray(this)}get formDirective(){return this._parent?this._parent.formDirective:null}get path(){return controlPath(this.name==null?this.name:this.name.toString(),this._parent)}_checkParentType(){if(_hasInvalidParent(this._parent)&&(typeof ngDevMode==="undefined"||ngDevMode))throw arrayParentException();}}FormArrayName.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:FormArrayName,deps:[{token:ControlContainer,host:true,optional:true,skipSelf:true},{token:NG_VALIDATORS,optional:true,self:true},{token:NG_ASYNC_VALIDATORS,optional:true,self:true}],target:i0__namespace.\u0275\u0275FactoryTarget.Directive});FormArrayName.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:FormArrayName,selector:"[formArrayName]",inputs:{name:["formArrayName","name"]},providers:[formArrayNameProvider],
usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:FormArrayName,decorators:[{type:i0.Directive,args:[{selector:"[formArrayName]",providers:[formArrayNameProvider]}]}],ctorParameters:function(){return[{type:ControlContainer,decorators:[{type:i0.Optional},{type:i0.Host},{type:i0.SkipSelf}]},{type:undefined,decorators:[{type:i0.Optional},{type:i0.Self},{type:i0.Inject,args:[NG_VALIDATORS]}]},
{type:undefined,decorators:[{type:i0.Optional},{type:i0.Self},{type:i0.Inject,args:[NG_ASYNC_VALIDATORS]}]}]},propDecorators:{name:[{type:i0.Input,args:["formArrayName"]}]}});function _hasInvalidParent(parent){return!(parent instanceof FormGroupName)&&!(parent instanceof FormGroupDirective)&&!(parent instanceof FormArrayName)}const controlNameBinding={provide:NgControl,useExisting:i0.forwardRef(()=>FormControlName)};class FormControlName extends NgControl{constructor(parent,validators,asyncValidators,
valueAccessors,_ngModelWarningConfig){super();this._ngModelWarningConfig=_ngModelWarningConfig;this._added=false;this.update=new i0.EventEmitter;this._ngModelWarningSent=false;this._parent=parent;this._setValidators(validators);this._setAsyncValidators(asyncValidators);this.valueAccessor=selectValueAccessor(this,valueAccessors)}set isDisabled(isDisabled){if(typeof ngDevMode==="undefined"||ngDevMode)console.warn(disabledAttrWarning)}ngOnChanges(changes){if(!this._added)this._setUpControl();if(isPropertyUpdated(changes,
this.viewModel)){if(typeof ngDevMode==="undefined"||ngDevMode)_ngModelWarning("formControlName",FormControlName,this,this._ngModelWarningConfig);this.viewModel=this.model;this.formDirective.updateModel(this,this.model)}}ngOnDestroy(){if(this.formDirective)this.formDirective.removeControl(this)}viewToModelUpdate(newValue){this.viewModel=newValue;this.update.emit(newValue)}get path(){return controlPath(this.name==null?this.name:this.name.toString(),this._parent)}get formDirective(){return this._parent?
this._parent.formDirective:null}_checkParentType(){if(typeof ngDevMode==="undefined"||ngDevMode)if(!(this._parent instanceof FormGroupName)&&this._parent instanceof AbstractFormGroupDirective)throw ngModelGroupException();else if(!(this._parent instanceof FormGroupName)&&!(this._parent instanceof FormGroupDirective)&&!(this._parent instanceof FormArrayName))throw controlParentException();}_setUpControl(){this._checkParentType();this.control=this.formDirective.addControl(this);if(this.control.disabled&&
this.valueAccessor.setDisabledState)this.valueAccessor.setDisabledState(true);this._added=true}}FormControlName._ngModelWarningSentOnce=false;FormControlName.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:FormControlName,deps:[{token:ControlContainer,host:true,optional:true,skipSelf:true},{token:NG_VALIDATORS,optional:true,self:true},{token:NG_ASYNC_VALIDATORS,optional:true,self:true},{token:NG_VALUE_ACCESSOR,optional:true,self:true},
{token:NG_MODEL_WITH_FORM_CONTROL_WARNING,optional:true}],target:i0__namespace.\u0275\u0275FactoryTarget.Directive});FormControlName.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:FormControlName,selector:"[formControlName]",inputs:{name:["formControlName","name"],isDisabled:["disabled","isDisabled"],model:["ngModel","model"]},outputs:{update:"ngModelChange"},providers:[controlNameBinding],usesInheritance:true,usesOnChanges:true,ngImport:i0__namespace});
i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:FormControlName,decorators:[{type:i0.Directive,args:[{selector:"[formControlName]",providers:[controlNameBinding]}]}],ctorParameters:function(){return[{type:ControlContainer,decorators:[{type:i0.Optional},{type:i0.Host},{type:i0.SkipSelf}]},{type:undefined,decorators:[{type:i0.Optional},{type:i0.Self},{type:i0.Inject,args:[NG_VALIDATORS]}]},{type:undefined,decorators:[{type:i0.Optional},
{type:i0.Self},{type:i0.Inject,args:[NG_ASYNC_VALIDATORS]}]},{type:undefined,decorators:[{type:i0.Optional},{type:i0.Self},{type:i0.Inject,args:[NG_VALUE_ACCESSOR]}]},{type:undefined,decorators:[{type:i0.Optional},{type:i0.Inject,args:[NG_MODEL_WITH_FORM_CONTROL_WARNING]}]}]},propDecorators:{name:[{type:i0.Input,args:["formControlName"]}],isDisabled:[{type:i0.Input,args:["disabled"]}],model:[{type:i0.Input,args:["ngModel"]}],update:[{type:i0.Output,args:["ngModelChange"]}]}});const SELECT_VALUE_ACCESSOR=
{provide:NG_VALUE_ACCESSOR,useExisting:i0.forwardRef(()=>SelectControlValueAccessor),multi:true};function _buildValueString$1(id,value){if(id==null)return`${value}`;if(value&&typeof value==="object")value="Object";return`${id}: ${value}`.slice(0,50)}function _extractId$1(valueString){return valueString.split(":")[0]}class SelectControlValueAccessor extends BuiltInControlValueAccessor{constructor(){super(...arguments);this._optionMap=new Map;this._idCounter=0;this._compareWith=Object.is}set compareWith(fn){if(typeof fn!==
"function"&&(typeof ngDevMode==="undefined"||ngDevMode))throw new Error(`compareWith must be a function, but received ${JSON.stringify(fn)}`);this._compareWith=fn}writeValue(value){this.value=value;const id=this._getOptionId(value);const valueString=_buildValueString$1(id,value);this.setProperty("value",valueString)}registerOnChange(fn){this.onChange=valueString=>{this.value=this._getOptionValue(valueString);fn(this.value)}}_registerOption(){return(this._idCounter++).toString()}_getOptionId(value){for(const id of Array.from(this._optionMap.keys()))if(this._compareWith(this._optionMap.get(id),
value))return id;return null}_getOptionValue(valueString){const id=_extractId$1(valueString);return this._optionMap.has(id)?this._optionMap.get(id):valueString}}SelectControlValueAccessor.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:SelectControlValueAccessor,deps:null,target:i0__namespace.\u0275\u0275FactoryTarget.Directive});SelectControlValueAccessor.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",
version:"13.3.1",type:SelectControlValueAccessor,selector:"select:not([multiple])[formControlName],select:not([multiple])[formControl],select:not([multiple])[ngModel]",inputs:{compareWith:"compareWith"},host:{listeners:{"change":"onChange($event.target.value)","blur":"onTouched()"}},providers:[SELECT_VALUE_ACCESSOR],usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:SelectControlValueAccessor,
decorators:[{type:i0.Directive,args:[{selector:"select:not([multiple])[formControlName],select:not([multiple])[formControl],select:not([multiple])[ngModel]",host:{"(change)":"onChange($event.target.value)","(blur)":"onTouched()"},providers:[SELECT_VALUE_ACCESSOR]}]}],propDecorators:{compareWith:[{type:i0.Input}]}});class NgSelectOption{constructor(_element,_renderer,_select){this._element=_element;this._renderer=_renderer;this._select=_select;if(this._select)this.id=this._select._registerOption()}set ngValue(value){if(this._select==
null)return;this._select._optionMap.set(this.id,value);this._setElementValue(_buildValueString$1(this.id,value));this._select.writeValue(this._select.value)}set value(value){this._setElementValue(value);if(this._select)this._select.writeValue(this._select.value)}_setElementValue(value){this._renderer.setProperty(this._element.nativeElement,"value",value)}ngOnDestroy(){if(this._select){this._select._optionMap.delete(this.id);this._select.writeValue(this._select.value)}}}NgSelectOption.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:NgSelectOption,deps:[{token:i0__namespace.ElementRef},{token:i0__namespace.Renderer2},{token:SelectControlValueAccessor,host:true,optional:true}],target:i0__namespace.\u0275\u0275FactoryTarget.Directive});NgSelectOption.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:NgSelectOption,selector:"option",inputs:{ngValue:"ngValue",value:"value"},ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:NgSelectOption,decorators:[{type:i0.Directive,args:[{selector:"option"}]}],ctorParameters:function(){return[{type:i0__namespace.ElementRef},{type:i0__namespace.Renderer2},{type:SelectControlValueAccessor,decorators:[{type:i0.Optional},{type:i0.Host}]}]},propDecorators:{ngValue:[{type:i0.Input,args:["ngValue"]}],value:[{type:i0.Input,args:["value"]}]}});const SELECT_MULTIPLE_VALUE_ACCESSOR={provide:NG_VALUE_ACCESSOR,useExisting:i0.forwardRef(()=>SelectMultipleControlValueAccessor),
multi:true};function _buildValueString(id,value){if(id==null)return`${value}`;if(typeof value==="string")value=`'${value}'`;if(value&&typeof value==="object")value="Object";return`${id}: ${value}`.slice(0,50)}function _extractId(valueString){return valueString.split(":")[0]}class SelectMultipleControlValueAccessor extends BuiltInControlValueAccessor{constructor(){super(...arguments);this._optionMap=new Map;this._idCounter=0;this._compareWith=Object.is}set compareWith(fn){if(typeof fn!=="function"&&
(typeof ngDevMode==="undefined"||ngDevMode))throw new Error(`compareWith must be a function, but received ${JSON.stringify(fn)}`);this._compareWith=fn}writeValue(value){this.value=value;let optionSelectedStateSetter;if(Array.isArray(value)){const ids=value.map(v=>this._getOptionId(v));optionSelectedStateSetter=(opt,o)=>{opt._setSelected(ids.indexOf(o.toString())>-1)}}else optionSelectedStateSetter=(opt,o)=>{opt._setSelected(false)};this._optionMap.forEach(optionSelectedStateSetter)}registerOnChange(fn){this.onChange=
element=>{const selected=[];const selectedOptions=element.selectedOptions;if(selectedOptions!==undefined){const options=selectedOptions;for(let i=0;i<options.length;i++){const opt=options[i];const val=this._getOptionValue(opt.value);selected.push(val)}}else{const options=element.options;for(let i=0;i<options.length;i++){const opt=options[i];if(opt.selected){const val=this._getOptionValue(opt.value);selected.push(val)}}}this.value=selected;fn(selected)}}_registerOption(value){const id=(this._idCounter++).toString();
this._optionMap.set(id,value);return id}_getOptionId(value){for(const id of Array.from(this._optionMap.keys()))if(this._compareWith(this._optionMap.get(id)._value,value))return id;return null}_getOptionValue(valueString){const id=_extractId(valueString);return this._optionMap.has(id)?this._optionMap.get(id)._value:valueString}}SelectMultipleControlValueAccessor.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:SelectMultipleControlValueAccessor,
deps:null,target:i0__namespace.\u0275\u0275FactoryTarget.Directive});SelectMultipleControlValueAccessor.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:SelectMultipleControlValueAccessor,selector:"select[multiple][formControlName],select[multiple][formControl],select[multiple][ngModel]",inputs:{compareWith:"compareWith"},host:{listeners:{"change":"onChange($event.target)","blur":"onTouched()"}},providers:[SELECT_MULTIPLE_VALUE_ACCESSOR],usesInheritance:true,
ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:SelectMultipleControlValueAccessor,decorators:[{type:i0.Directive,args:[{selector:"select[multiple][formControlName],select[multiple][formControl],select[multiple][ngModel]",host:{"(change)":"onChange($event.target)","(blur)":"onTouched()"},providers:[SELECT_MULTIPLE_VALUE_ACCESSOR]}]}],propDecorators:{compareWith:[{type:i0.Input}]}});class \u0275NgSelectMultipleOption{constructor(_element,
_renderer,_select){this._element=_element;this._renderer=_renderer;this._select=_select;if(this._select)this.id=this._select._registerOption(this)}set ngValue(value){if(this._select==null)return;this._value=value;this._setElementValue(_buildValueString(this.id,value));this._select.writeValue(this._select.value)}set value(value){if(this._select){this._value=value;this._setElementValue(_buildValueString(this.id,value));this._select.writeValue(this._select.value)}else this._setElementValue(value)}_setElementValue(value){this._renderer.setProperty(this._element.nativeElement,
"value",value)}_setSelected(selected){this._renderer.setProperty(this._element.nativeElement,"selected",selected)}ngOnDestroy(){if(this._select){this._select._optionMap.delete(this.id);this._select.writeValue(this._select.value)}}}\u0275NgSelectMultipleOption.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:\u0275NgSelectMultipleOption,deps:[{token:i0__namespace.ElementRef},{token:i0__namespace.Renderer2},{token:SelectMultipleControlValueAccessor,
host:true,optional:true}],target:i0__namespace.\u0275\u0275FactoryTarget.Directive});\u0275NgSelectMultipleOption.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:\u0275NgSelectMultipleOption,selector:"option",inputs:{ngValue:"ngValue",value:"value"},ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:\u0275NgSelectMultipleOption,decorators:[{type:i0.Directive,args:[{selector:"option"}]}],
ctorParameters:function(){return[{type:i0__namespace.ElementRef},{type:i0__namespace.Renderer2},{type:SelectMultipleControlValueAccessor,decorators:[{type:i0.Optional},{type:i0.Host}]}]},propDecorators:{ngValue:[{type:i0.Input,args:["ngValue"]}],value:[{type:i0.Input,args:["value"]}]}});function toInteger(value){return typeof value==="number"?value:parseInt(value,10)}function toBoolean(input){return input!=null&&input!==false&&`${input}`!=="false"}function toFloat(value){return typeof value==="number"?
value:parseFloat(value)}class AbstractValidatorDirective{constructor(){this._validator=nullValidator}ngOnChanges(changes){if(this.inputName in changes){const input=this.normalizeInput(changes[this.inputName].currentValue);this._enabled=this.enabled(input);this._validator=this._enabled?this.createValidator(input):nullValidator;if(this._onChange)this._onChange()}}validate(control){return this._validator(control)}registerOnValidatorChange(fn){this._onChange=fn}enabled(input){return input!=null}}AbstractValidatorDirective.\u0275fac=
i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:AbstractValidatorDirective,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.Directive});AbstractValidatorDirective.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:AbstractValidatorDirective,usesOnChanges:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,
type:AbstractValidatorDirective,decorators:[{type:i0.Directive}]});const MAX_VALIDATOR={provide:NG_VALIDATORS,useExisting:i0.forwardRef(()=>MaxValidator),multi:true};class MaxValidator extends AbstractValidatorDirective{constructor(){super(...arguments);this.inputName="max";this.normalizeInput=input=>toFloat(input);this.createValidator=max=>maxValidator(max)}}MaxValidator.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:MaxValidator,
deps:null,target:i0__namespace.\u0275\u0275FactoryTarget.Directive});MaxValidator.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:MaxValidator,selector:"input[type=number][max][formControlName],input[type=number][max][formControl],input[type=number][max][ngModel]",inputs:{max:"max"},host:{properties:{"attr.max":"_enabled ? max : null"}},providers:[MAX_VALIDATOR],usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:MaxValidator,decorators:[{type:i0.Directive,args:[{selector:"input[type=number][max][formControlName],input[type=number][max][formControl],input[type=number][max][ngModel]",providers:[MAX_VALIDATOR],host:{"[attr.max]":"_enabled ? max : null"}}]}],propDecorators:{max:[{type:i0.Input}]}});const MIN_VALIDATOR={provide:NG_VALIDATORS,useExisting:i0.forwardRef(()=>MinValidator),multi:true};class MinValidator extends AbstractValidatorDirective{constructor(){super(...arguments);
this.inputName="min";this.normalizeInput=input=>toFloat(input);this.createValidator=min=>minValidator(min)}}MinValidator.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:MinValidator,deps:null,target:i0__namespace.\u0275\u0275FactoryTarget.Directive});MinValidator.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:MinValidator,selector:"input[type=number][min][formControlName],input[type=number][min][formControl],input[type=number][min][ngModel]",
inputs:{min:"min"},host:{properties:{"attr.min":"_enabled ? min : null"}},providers:[MIN_VALIDATOR],usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:MinValidator,decorators:[{type:i0.Directive,args:[{selector:"input[type=number][min][formControlName],input[type=number][min][formControl],input[type=number][min][ngModel]",providers:[MIN_VALIDATOR],host:{"[attr.min]":"_enabled ? min : null"}}]}],
propDecorators:{min:[{type:i0.Input}]}});const REQUIRED_VALIDATOR={provide:NG_VALIDATORS,useExisting:i0.forwardRef(()=>RequiredValidator),multi:true};const CHECKBOX_REQUIRED_VALIDATOR={provide:NG_VALIDATORS,useExisting:i0.forwardRef(()=>CheckboxRequiredValidator),multi:true};class RequiredValidator extends AbstractValidatorDirective{constructor(){super(...arguments);this.inputName="required";this.normalizeInput=input=>toBoolean(input);this.createValidator=input=>requiredValidator}enabled(input){return input}}
RequiredValidator.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:RequiredValidator,deps:null,target:i0__namespace.\u0275\u0275FactoryTarget.Directive});RequiredValidator.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:RequiredValidator,selector:":not([type=checkbox])[required][formControlName],:not([type=checkbox])[required][formControl],:not([type=checkbox])[required][ngModel]",
inputs:{required:"required"},host:{properties:{"attr.required":'_enabled ? "" : null'}},providers:[REQUIRED_VALIDATOR],usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:RequiredValidator,decorators:[{type:i0.Directive,args:[{selector:":not([type=checkbox])[required][formControlName],:not([type=checkbox])[required][formControl],:not([type=checkbox])[required][ngModel]",providers:[REQUIRED_VALIDATOR],
host:{"[attr.required]":'_enabled ? "" : null'}}]}],propDecorators:{required:[{type:i0.Input}]}});class CheckboxRequiredValidator extends RequiredValidator{constructor(){super(...arguments);this.createValidator=input=>requiredTrueValidator}}CheckboxRequiredValidator.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:CheckboxRequiredValidator,deps:null,target:i0__namespace.\u0275\u0275FactoryTarget.Directive});CheckboxRequiredValidator.\u0275dir=
i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:CheckboxRequiredValidator,selector:"input[type=checkbox][required][formControlName],input[type=checkbox][required][formControl],input[type=checkbox][required][ngModel]",host:{properties:{"attr.required":'_enabled ? "" : null'}},providers:[CHECKBOX_REQUIRED_VALIDATOR],usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,
type:CheckboxRequiredValidator,decorators:[{type:i0.Directive,args:[{selector:"input[type=checkbox][required][formControlName],input[type=checkbox][required][formControl],input[type=checkbox][required][ngModel]",providers:[CHECKBOX_REQUIRED_VALIDATOR],host:{"[attr.required]":'_enabled ? "" : null'}}]}]});const EMAIL_VALIDATOR={provide:NG_VALIDATORS,useExisting:i0.forwardRef(()=>EmailValidator),multi:true};class EmailValidator extends AbstractValidatorDirective{constructor(){super(...arguments);this.inputName=
"email";this.normalizeInput=input=>input===""||input===true||input==="true";this.createValidator=input=>emailValidator}enabled(input){return input}}EmailValidator.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:EmailValidator,deps:null,target:i0__namespace.\u0275\u0275FactoryTarget.Directive});EmailValidator.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:EmailValidator,selector:"[email][formControlName],[email][formControl],[email][ngModel]",
inputs:{email:"email"},providers:[EMAIL_VALIDATOR],usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:EmailValidator,decorators:[{type:i0.Directive,args:[{selector:"[email][formControlName],[email][formControl],[email][ngModel]",providers:[EMAIL_VALIDATOR]}]}],propDecorators:{email:[{type:i0.Input}]}});const MIN_LENGTH_VALIDATOR={provide:NG_VALIDATORS,useExisting:i0.forwardRef(()=>MinLengthValidator),
multi:true};class MinLengthValidator extends AbstractValidatorDirective{constructor(){super(...arguments);this.inputName="minlength";this.normalizeInput=input=>toInteger(input);this.createValidator=minlength=>minLengthValidator(minlength)}}MinLengthValidator.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:MinLengthValidator,deps:null,target:i0__namespace.\u0275\u0275FactoryTarget.Directive});MinLengthValidator.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",
version:"13.3.1",type:MinLengthValidator,selector:"[minlength][formControlName],[minlength][formControl],[minlength][ngModel]",inputs:{minlength:"minlength"},host:{properties:{"attr.minlength":"_enabled ? minlength : null"}},providers:[MIN_LENGTH_VALIDATOR],usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:MinLengthValidator,decorators:[{type:i0.Directive,args:[{selector:"[minlength][formControlName],[minlength][formControl],[minlength][ngModel]",
providers:[MIN_LENGTH_VALIDATOR],host:{"[attr.minlength]":"_enabled ? minlength : null"}}]}],propDecorators:{minlength:[{type:i0.Input}]}});const MAX_LENGTH_VALIDATOR={provide:NG_VALIDATORS,useExisting:i0.forwardRef(()=>MaxLengthValidator),multi:true};class MaxLengthValidator extends AbstractValidatorDirective{constructor(){super(...arguments);this.inputName="maxlength";this.normalizeInput=input=>toInteger(input);this.createValidator=maxlength=>maxLengthValidator(maxlength)}}MaxLengthValidator.\u0275fac=
i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:MaxLengthValidator,deps:null,target:i0__namespace.\u0275\u0275FactoryTarget.Directive});MaxLengthValidator.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:MaxLengthValidator,selector:"[maxlength][formControlName],[maxlength][formControl],[maxlength][ngModel]",inputs:{maxlength:"maxlength"},host:{properties:{"attr.maxlength":"_enabled ? maxlength : null"}},
providers:[MAX_LENGTH_VALIDATOR],usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:MaxLengthValidator,decorators:[{type:i0.Directive,args:[{selector:"[maxlength][formControlName],[maxlength][formControl],[maxlength][ngModel]",providers:[MAX_LENGTH_VALIDATOR],host:{"[attr.maxlength]":"_enabled ? maxlength : null"}}]}],propDecorators:{maxlength:[{type:i0.Input}]}});const PATTERN_VALIDATOR=
{provide:NG_VALIDATORS,useExisting:i0.forwardRef(()=>PatternValidator),multi:true};class PatternValidator extends AbstractValidatorDirective{constructor(){super(...arguments);this.inputName="pattern";this.normalizeInput=input=>input;this.createValidator=input=>patternValidator(input)}}PatternValidator.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:PatternValidator,deps:null,target:i0__namespace.\u0275\u0275FactoryTarget.Directive});
PatternValidator.\u0275dir=i0__namespace.\u0275\u0275ngDeclareDirective({minVersion:"12.0.0",version:"13.3.1",type:PatternValidator,selector:"[pattern][formControlName],[pattern][formControl],[pattern][ngModel]",inputs:{pattern:"pattern"},host:{properties:{"attr.pattern":"_enabled ? pattern : null"}},providers:[PATTERN_VALIDATOR],usesInheritance:true,ngImport:i0__namespace});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:PatternValidator,
decorators:[{type:i0.Directive,args:[{selector:"[pattern][formControlName],[pattern][formControl],[pattern][ngModel]",providers:[PATTERN_VALIDATOR],host:{"[attr.pattern]":"_enabled ? pattern : null"}}]}],propDecorators:{pattern:[{type:i0.Input}]}});const SHARED_FORM_DIRECTIVES=[\u0275NgNoValidate,NgSelectOption,\u0275NgSelectMultipleOption,DefaultValueAccessor,NumberValueAccessor,RangeValueAccessor,CheckboxControlValueAccessor,SelectControlValueAccessor,SelectMultipleControlValueAccessor,RadioControlValueAccessor,
NgControlStatus,NgControlStatusGroup,RequiredValidator,MinLengthValidator,MaxLengthValidator,PatternValidator,CheckboxRequiredValidator,EmailValidator,MinValidator,MaxValidator];const TEMPLATE_DRIVEN_DIRECTIVES=[NgModel,NgModelGroup,NgForm];const REACTIVE_DRIVEN_DIRECTIVES=[FormControlDirective,FormGroupDirective,FormControlName,FormGroupName,FormArrayName];class \u0275InternalFormsSharedModule{}\u0275InternalFormsSharedModule.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:\u0275InternalFormsSharedModule,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.NgModule});\u0275InternalFormsSharedModule.\u0275mod=i0__namespace.\u0275\u0275ngDeclareNgModule({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:\u0275InternalFormsSharedModule,declarations:[\u0275NgNoValidate,NgSelectOption,\u0275NgSelectMultipleOption,DefaultValueAccessor,NumberValueAccessor,RangeValueAccessor,CheckboxControlValueAccessor,SelectControlValueAccessor,
SelectMultipleControlValueAccessor,RadioControlValueAccessor,NgControlStatus,NgControlStatusGroup,RequiredValidator,MinLengthValidator,MaxLengthValidator,PatternValidator,CheckboxRequiredValidator,EmailValidator,MinValidator,MaxValidator],imports:[RadioControlRegistryModule],exports:[\u0275NgNoValidate,NgSelectOption,\u0275NgSelectMultipleOption,DefaultValueAccessor,NumberValueAccessor,RangeValueAccessor,CheckboxControlValueAccessor,SelectControlValueAccessor,SelectMultipleControlValueAccessor,RadioControlValueAccessor,
NgControlStatus,NgControlStatusGroup,RequiredValidator,MinLengthValidator,MaxLengthValidator,PatternValidator,CheckboxRequiredValidator,EmailValidator,MinValidator,MaxValidator]});\u0275InternalFormsSharedModule.\u0275inj=i0__namespace.\u0275\u0275ngDeclareInjector({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:\u0275InternalFormsSharedModule,imports:[[RadioControlRegistryModule]]});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,
type:\u0275InternalFormsSharedModule,decorators:[{type:i0.NgModule,args:[{declarations:SHARED_FORM_DIRECTIVES,imports:[RadioControlRegistryModule],exports:SHARED_FORM_DIRECTIVES}]}]});class FormsModule{}FormsModule.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:FormsModule,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.NgModule});FormsModule.\u0275mod=i0__namespace.\u0275\u0275ngDeclareNgModule({minVersion:"12.0.0",version:"13.3.1",
ngImport:i0__namespace,type:FormsModule,declarations:[NgModel,NgModelGroup,NgForm],exports:[\u0275InternalFormsSharedModule,NgModel,NgModelGroup,NgForm]});FormsModule.\u0275inj=i0__namespace.\u0275\u0275ngDeclareInjector({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:FormsModule,imports:[\u0275InternalFormsSharedModule]});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:FormsModule,decorators:[{type:i0.NgModule,args:[{declarations:TEMPLATE_DRIVEN_DIRECTIVES,
exports:[\u0275InternalFormsSharedModule,TEMPLATE_DRIVEN_DIRECTIVES]}]}]});class ReactiveFormsModule{static withConfig(opts){return{ngModule:ReactiveFormsModule,providers:[{provide:NG_MODEL_WITH_FORM_CONTROL_WARNING,useValue:opts.warnOnNgModelWithFormControl}]}}}ReactiveFormsModule.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:ReactiveFormsModule,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.NgModule});ReactiveFormsModule.\u0275mod=
i0__namespace.\u0275\u0275ngDeclareNgModule({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:ReactiveFormsModule,declarations:[FormControlDirective,FormGroupDirective,FormControlName,FormGroupName,FormArrayName],exports:[\u0275InternalFormsSharedModule,FormControlDirective,FormGroupDirective,FormControlName,FormGroupName,FormArrayName]});ReactiveFormsModule.\u0275inj=i0__namespace.\u0275\u0275ngDeclareInjector({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:ReactiveFormsModule,
imports:[\u0275InternalFormsSharedModule]});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:ReactiveFormsModule,decorators:[{type:i0.NgModule,args:[{declarations:[REACTIVE_DRIVEN_DIRECTIVES],exports:[\u0275InternalFormsSharedModule,REACTIVE_DRIVEN_DIRECTIVES]}]}]});function isAbstractControlOptions(options){return options.asyncValidators!==undefined||options.validators!==undefined||options.updateOn!==undefined}class FormBuilder{group(controlsConfig,
options=null){const controls=this._reduceControls(controlsConfig);let validators=null;let asyncValidators=null;let updateOn=undefined;if(options!=null)if(isAbstractControlOptions(options)){validators=options.validators!=null?options.validators:null;asyncValidators=options.asyncValidators!=null?options.asyncValidators:null;updateOn=options.updateOn!=null?options.updateOn:undefined}else{validators=options["validator"]!=null?options["validator"]:null;asyncValidators=options["asyncValidator"]!=null?options["asyncValidator"]:
null}return new FormGroup(controls,{asyncValidators,updateOn,validators})}control(formState,validatorOrOpts,asyncValidator){return new FormControl(formState,validatorOrOpts,asyncValidator)}array(controlsConfig,validatorOrOpts,asyncValidator){const controls=controlsConfig.map(c=>this._createControl(c));return new FormArray(controls,validatorOrOpts,asyncValidator)}_reduceControls(controlsConfig){const controls={};Object.keys(controlsConfig).forEach(controlName=>{controls[controlName]=this._createControl(controlsConfig[controlName])});
return controls}_createControl(controlConfig){if(isFormControl(controlConfig)||isFormGroup(controlConfig)||isFormArray(controlConfig))return controlConfig;else if(Array.isArray(controlConfig)){const value=controlConfig[0];const validator=controlConfig.length>1?controlConfig[1]:null;const asyncValidator=controlConfig.length>2?controlConfig[2]:null;return this.control(value,validator,asyncValidator)}else return this.control(controlConfig)}}FormBuilder.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:FormBuilder,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});FormBuilder.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:FormBuilder,providedIn:ReactiveFormsModule});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:FormBuilder,decorators:[{type:i0.Injectable,args:[{providedIn:ReactiveFormsModule}]}]});
const VERSION=new i0.Version("13.3.1");exports.AbstractControl=AbstractControl;exports.AbstractControlDirective=AbstractControlDirective;exports.AbstractFormGroupDirective=AbstractFormGroupDirective;exports.COMPOSITION_BUFFER_MODE=COMPOSITION_BUFFER_MODE;exports.CheckboxControlValueAccessor=CheckboxControlValueAccessor;exports.CheckboxRequiredValidator=CheckboxRequiredValidator;exports.ControlContainer=ControlContainer;exports.DefaultValueAccessor=DefaultValueAccessor;exports.EmailValidator=EmailValidator;
exports.FormArray=FormArray;exports.FormArrayName=FormArrayName;exports.FormBuilder=FormBuilder;exports.FormControl=FormControl;exports.FormControlDirective=FormControlDirective;exports.FormControlName=FormControlName;exports.FormGroup=FormGroup;exports.FormGroupDirective=FormGroupDirective;exports.FormGroupName=FormGroupName;exports.FormsModule=FormsModule;exports.MaxLengthValidator=MaxLengthValidator;exports.MaxValidator=MaxValidator;exports.MinLengthValidator=MinLengthValidator;exports.MinValidator=
MinValidator;exports.NG_ASYNC_VALIDATORS=NG_ASYNC_VALIDATORS;exports.NG_VALIDATORS=NG_VALIDATORS;exports.NG_VALUE_ACCESSOR=NG_VALUE_ACCESSOR;exports.NgControl=NgControl;exports.NgControlStatus=NgControlStatus;exports.NgControlStatusGroup=NgControlStatusGroup;exports.NgForm=NgForm;exports.NgModel=NgModel;exports.NgModelGroup=NgModelGroup;exports.NgSelectOption=NgSelectOption;exports.NumberValueAccessor=NumberValueAccessor;exports.PatternValidator=PatternValidator;exports.RadioControlValueAccessor=
RadioControlValueAccessor;exports.RangeValueAccessor=RangeValueAccessor;exports.ReactiveFormsModule=ReactiveFormsModule;exports.RequiredValidator=RequiredValidator;exports.SelectControlValueAccessor=SelectControlValueAccessor;exports.SelectMultipleControlValueAccessor=SelectMultipleControlValueAccessor;exports.VERSION=VERSION;exports.Validators=Validators;exports["ɵInternalFormsSharedModule"]=\u0275InternalFormsSharedModule;exports["ɵNgNoValidate"]=\u0275NgNoValidate;exports["ɵNgSelectMultipleOption"]=
\u0275NgSelectMultipleOption;Object.defineProperty(exports,"__esModule",{value:true})});

