/*

 Copyright Google LLC All Rights Reserved.

 Use of this source code is governed by an MIT-style license that can be
 found in the LICENSE file at https://angular.io/license
 Angular v13.3.1
 (c) 2010-2022 Google LLC. https://angular.io/
 License: MIT
*/
'use strict';(function(global,factory){typeof exports==="object"&&typeof module!=="undefined"?factory(exports,require("@angular/common"),require("@angular/core")):typeof define==="function"&&define.amd?define(["exports","@angular/common","@angular/core"],factory):(global=typeof globalThis!=="undefined"?globalThis:global||self,factory((global.ng=global.ng||{},global.ng.platformBrowser={}),global.common,global.i0))})(this,function(exports,common,i0){function _interopNamespace(e){if(e&&e.__esModule)return e;
var n=Object.create(null);if(e)Object.keys(e).forEach(function(k){if(k!=="default"){var d=Object.getOwnPropertyDescriptor(e,k);Object.defineProperty(n,k,d.get?d:{enumerable:true,get:function(){return e[k]}})}});n["default"]=e;return Object.freeze(n)}var i0__namespace=_interopNamespace(i0);class GenericBrowserDomAdapter extends common["ɵDomAdapter"]{constructor(){super(...arguments);this.supportsDOMEvents=true}}class BrowserDomAdapter extends GenericBrowserDomAdapter{static makeCurrent(){common["ɵsetRootDomAdapter"](new BrowserDomAdapter)}onAndCancel(el,
evt,listener){el.addEventListener(evt,listener,false);return()=>{el.removeEventListener(evt,listener,false)}}dispatchEvent(el,evt){el.dispatchEvent(evt)}remove(node){if(node.parentNode)node.parentNode.removeChild(node)}createElement(tagName,doc){doc=doc||this.getDefaultDocument();return doc.createElement(tagName)}createHtmlDocument(){return document.implementation.createHTMLDocument("fakeTitle")}getDefaultDocument(){return document}isElementNode(node){return node.nodeType===Node.ELEMENT_NODE}isShadowRoot(node){return node instanceof
DocumentFragment}getGlobalEventTarget(doc,target){if(target==="window")return window;if(target==="document")return doc;if(target==="body")return doc.body;return null}getBaseHref(doc){const href=getBaseElementHref();return href==null?null:relativePath(href)}resetBaseElement(){baseElement=null}getUserAgent(){return window.navigator.userAgent}getCookie(name){return common["ɵparseCookieValue"](document.cookie,name)}}let baseElement=null;function getBaseElementHref(){baseElement=baseElement||document.querySelector("base");
return baseElement?baseElement.getAttribute("href"):null}let urlParsingNode;function relativePath(url){urlParsingNode=urlParsingNode||document.createElement("a");urlParsingNode.setAttribute("href",url);const pathName=urlParsingNode.pathname;return pathName.charAt(0)==="/"?pathName:`/${pathName}`}const TRANSITION_ID=new i0.InjectionToken("TRANSITION_ID");function appInitializerFactory(transitionId,document,injector){return()=>{injector.get(i0.ApplicationInitStatus).donePromise.then(()=>{const dom=
common["ɵgetDOM"]();const styles=document.querySelectorAll(`style[ng-transition="${transitionId}"]`);for(let i=0;i<styles.length;i++)dom.remove(styles[i])})}}const SERVER_TRANSITION_PROVIDERS=[{provide:i0.APP_INITIALIZER,useFactory:appInitializerFactory,deps:[TRANSITION_ID,common.DOCUMENT,i0.Injector],multi:true}];class BrowserGetTestability{static init(){i0.setTestabilityGetter(new BrowserGetTestability)}addToWindow(registry){i0["ɵglobal"]["getAngularTestability"]=(elem,findInAncestors=true)=>{const testability=
registry.findTestabilityInTree(elem,findInAncestors);if(testability==null)throw new Error("Could not find testability for element.");return testability};i0["ɵglobal"]["getAllAngularTestabilities"]=()=>registry.getAllTestabilities();i0["ɵglobal"]["getAllAngularRootElements"]=()=>registry.getAllRootElements();const whenAllStable=callback=>{const testabilities=i0["ɵglobal"]["getAllAngularTestabilities"]();let count=testabilities.length;let didWork=false;const decrement=function(didWork_){didWork=didWork||
didWork_;count--;if(count==0)callback(didWork)};testabilities.forEach(function(testability){testability.whenStable(decrement)})};if(!i0["ɵglobal"]["frameworkStabilizers"])i0["ɵglobal"]["frameworkStabilizers"]=[];i0["ɵglobal"]["frameworkStabilizers"].push(whenAllStable)}findTestabilityInTree(registry,elem,findInAncestors){if(elem==null)return null;const t=registry.getTestability(elem);if(t!=null)return t;else if(!findInAncestors)return null;if(common["ɵgetDOM"]().isShadowRoot(elem))return this.findTestabilityInTree(registry,
elem.host,true);return this.findTestabilityInTree(registry,elem.parentElement,true)}}class BrowserXhr{build(){return new XMLHttpRequest}}BrowserXhr.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:BrowserXhr,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});BrowserXhr.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:BrowserXhr});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:BrowserXhr,decorators:[{type:i0.Injectable}]});const EVENT_MANAGER_PLUGINS=new i0.InjectionToken("EventManagerPlugins");class EventManager{constructor(plugins,_zone){this._zone=_zone;this._eventNameToPlugin=new Map;plugins.forEach(p=>p.manager=this);this._plugins=plugins.slice().reverse()}addEventListener(element,eventName,handler){const plugin=this._findPluginFor(eventName);return plugin.addEventListener(element,eventName,handler)}addGlobalEventListener(target,
eventName,handler){const plugin=this._findPluginFor(eventName);return plugin.addGlobalEventListener(target,eventName,handler)}getZone(){return this._zone}_findPluginFor(eventName){const plugin=this._eventNameToPlugin.get(eventName);if(plugin)return plugin;const plugins=this._plugins;for(let i=0;i<plugins.length;i++){const plugin=plugins[i];if(plugin.supports(eventName)){this._eventNameToPlugin.set(eventName,plugin);return plugin}}throw new Error(`No event manager plugin found for event ${eventName}`);
}}EventManager.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:EventManager,deps:[{token:EVENT_MANAGER_PLUGINS},{token:i0__namespace.NgZone}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});EventManager.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:EventManager});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",
ngImport:i0__namespace,type:EventManager,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:undefined,decorators:[{type:i0.Inject,args:[EVENT_MANAGER_PLUGINS]}]},{type:i0__namespace.NgZone}]}});class EventManagerPlugin{constructor(_doc){this._doc=_doc}addGlobalEventListener(element,eventName,handler){const target=common["ɵgetDOM"]().getGlobalEventTarget(this._doc,element);if(!target)throw new Error(`Unsupported event target ${target} for event ${eventName}`);return this.addEventListener(target,
eventName,handler)}}class SharedStylesHost{constructor(){this._stylesSet=new Set}addStyles(styles){const additions=new Set;styles.forEach(style=>{if(!this._stylesSet.has(style)){this._stylesSet.add(style);additions.add(style)}});this.onStylesAdded(additions)}onStylesAdded(additions){}getAllStyles(){return Array.from(this._stylesSet)}}SharedStylesHost.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:SharedStylesHost,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});
SharedStylesHost.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:SharedStylesHost});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:SharedStylesHost,decorators:[{type:i0.Injectable}]});class DomSharedStylesHost extends SharedStylesHost{constructor(_doc){super();this._doc=_doc;this._hostNodes=new Map;this._hostNodes.set(_doc.head,[])}_addStylesToHost(styles,
host,styleNodes){styles.forEach(style=>{const styleEl=this._doc.createElement("style");styleEl.textContent=style;styleNodes.push(host.appendChild(styleEl))})}addHost(hostNode){const styleNodes=[];this._addStylesToHost(this._stylesSet,hostNode,styleNodes);this._hostNodes.set(hostNode,styleNodes)}removeHost(hostNode){const styleNodes=this._hostNodes.get(hostNode);if(styleNodes)styleNodes.forEach(removeStyle);this._hostNodes.delete(hostNode)}onStylesAdded(additions){this._hostNodes.forEach((styleNodes,
hostNode)=>{this._addStylesToHost(additions,hostNode,styleNodes)})}ngOnDestroy(){this._hostNodes.forEach(styleNodes=>styleNodes.forEach(removeStyle))}}DomSharedStylesHost.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:DomSharedStylesHost,deps:[{token:common.DOCUMENT}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});DomSharedStylesHost.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.3.1",
ngImport:i0__namespace,type:DomSharedStylesHost});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:DomSharedStylesHost,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:undefined,decorators:[{type:i0.Inject,args:[common.DOCUMENT]}]}]}});function removeStyle(styleNode){common["ɵgetDOM"]().remove(styleNode)}const NAMESPACE_URIS={"svg":"http://www.w3.org/2000/svg","xhtml":"http://www.w3.org/1999/xhtml","xlink":"http://www.w3.org/1999/xlink",
"xml":"http://www.w3.org/XML/1998/namespace","xmlns":"http://www.w3.org/2000/xmlns/","math":"http://www.w3.org/1998/MathML/"};const COMPONENT_REGEX=/%COMP%/g;const NG_DEV_MODE=typeof ngDevMode==="undefined"||!!ngDevMode;const COMPONENT_VARIABLE="%COMP%";const HOST_ATTR=`_nghost-${COMPONENT_VARIABLE}`;const CONTENT_ATTR=`_ngcontent-${COMPONENT_VARIABLE}`;function shimContentAttribute(componentShortId){return CONTENT_ATTR.replace(COMPONENT_REGEX,componentShortId)}function shimHostAttribute(componentShortId){return HOST_ATTR.replace(COMPONENT_REGEX,
componentShortId)}function flattenStyles(compId,styles,target){for(let i=0;i<styles.length;i++){let style=styles[i];if(Array.isArray(style))flattenStyles(compId,style,target);else{style=style.replace(COMPONENT_REGEX,compId);target.push(style)}}return target}function decoratePreventDefault(eventHandler){return event=>{if(event==="__ngUnwrap__")return eventHandler;const allowDefaultBehavior=eventHandler(event);if(allowDefaultBehavior===false){event.preventDefault();event.returnValue=false}return undefined}}
let hasLoggedNativeEncapsulationWarning=false;class DomRendererFactory2{constructor(eventManager,sharedStylesHost,appId){this.eventManager=eventManager;this.sharedStylesHost=sharedStylesHost;this.appId=appId;this.rendererByCompId=new Map;this.defaultRenderer=new DefaultDomRenderer2(eventManager)}createRenderer(element,type){if(!element||!type)return this.defaultRenderer;switch(type.encapsulation){case i0.ViewEncapsulation.Emulated:{let renderer=this.rendererByCompId.get(type.id);if(!renderer){renderer=
new EmulatedEncapsulationDomRenderer2(this.eventManager,this.sharedStylesHost,type,this.appId);this.rendererByCompId.set(type.id,renderer)}renderer.applyToHost(element);return renderer}case 1:case i0.ViewEncapsulation.ShadowDom:if((typeof ngDevMode==="undefined"||ngDevMode)&&!hasLoggedNativeEncapsulationWarning&&type.encapsulation===1){hasLoggedNativeEncapsulationWarning=true;console.warn("ViewEncapsulation.Native is no longer supported. Falling back to ViewEncapsulation.ShadowDom. The fallback will be removed in v12.")}return new ShadowDomRenderer(this.eventManager,
this.sharedStylesHost,element,type);default:{if(!this.rendererByCompId.has(type.id)){const styles=flattenStyles(type.id,type.styles,[]);this.sharedStylesHost.addStyles(styles);this.rendererByCompId.set(type.id,this.defaultRenderer)}return this.defaultRenderer}}}begin(){}end(){}}DomRendererFactory2.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:DomRendererFactory2,deps:[{token:EventManager},{token:DomSharedStylesHost},{token:i0.APP_ID}],
target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});DomRendererFactory2.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:DomRendererFactory2});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:DomRendererFactory2,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:EventManager},{type:DomSharedStylesHost},{type:undefined,decorators:[{type:i0.Inject,
args:[i0.APP_ID]}]}]}});class DefaultDomRenderer2{constructor(eventManager){this.eventManager=eventManager;this.data=Object.create(null);this.destroyNode=null}destroy(){}createElement(name,namespace){if(namespace)return document.createElementNS(NAMESPACE_URIS[namespace]||namespace,name);return document.createElement(name)}createComment(value){return document.createComment(value)}createText(value){return document.createTextNode(value)}appendChild(parent,newChild){parent.appendChild(newChild)}insertBefore(parent,
newChild,refChild){if(parent)parent.insertBefore(newChild,refChild)}removeChild(parent,oldChild){if(parent)parent.removeChild(oldChild)}selectRootElement(selectorOrNode,preserveContent){let el=typeof selectorOrNode==="string"?document.querySelector(selectorOrNode):selectorOrNode;if(!el)throw new Error(`The selector "${selectorOrNode}" did not match any elements`);if(!preserveContent)el.textContent="";return el}parentNode(node){return node.parentNode}nextSibling(node){return node.nextSibling}setAttribute(el,
name,value,namespace){if(namespace){name=namespace+":"+name;const namespaceUri=NAMESPACE_URIS[namespace];if(namespaceUri)el.setAttributeNS(namespaceUri,name,value);else el.setAttribute(name,value)}else el.setAttribute(name,value)}removeAttribute(el,name,namespace){if(namespace){const namespaceUri=NAMESPACE_URIS[namespace];if(namespaceUri)el.removeAttributeNS(namespaceUri,name);else el.removeAttribute(`${namespace}:${name}`)}else el.removeAttribute(name)}addClass(el,name){el.classList.add(name)}removeClass(el,
name){el.classList.remove(name)}setStyle(el,style,value,flags){if(flags&(i0.RendererStyleFlags2.DashCase|i0.RendererStyleFlags2.Important))el.style.setProperty(style,value,flags&i0.RendererStyleFlags2.Important?"important":"");else el.style[style]=value}removeStyle(el,style,flags){if(flags&i0.RendererStyleFlags2.DashCase)el.style.removeProperty(style);else el.style[style]=""}setProperty(el,name,value){NG_DEV_MODE&&checkNoSyntheticProp(name,"property");el[name]=value}setValue(node,value){node.nodeValue=
value}listen(target,event,callback){NG_DEV_MODE&&checkNoSyntheticProp(event,"listener");if(typeof target==="string")return this.eventManager.addGlobalEventListener(target,event,decoratePreventDefault(callback));return this.eventManager.addEventListener(target,event,decoratePreventDefault(callback))}}const AT_CHARCODE=(()=>"@".charCodeAt(0))();function checkNoSyntheticProp(name,nameKind){if(name.charCodeAt(0)===AT_CHARCODE)throw new Error(`Unexpected synthetic ${nameKind} ${name} found. Please make sure that:
  - Either \`BrowserAnimationsModule\` or \`NoopAnimationsModule\` are imported in your application.
  - There is corresponding configuration for the animation named \`${name}\` defined in the \`animations\` field of the \`@Component\` decorator (see https://angular.io/api/core/Component#animations).`);}class EmulatedEncapsulationDomRenderer2 extends DefaultDomRenderer2{constructor(eventManager,sharedStylesHost,component,appId){super(eventManager);this.component=component;const styles=flattenStyles(appId+"-"+component.id,component.styles,[]);sharedStylesHost.addStyles(styles);this.contentAttr=shimContentAttribute(appId+
"-"+component.id);this.hostAttr=shimHostAttribute(appId+"-"+component.id)}applyToHost(element){super.setAttribute(element,this.hostAttr,"")}createElement(parent,name){const el=super.createElement(parent,name);super.setAttribute(el,this.contentAttr,"");return el}}class ShadowDomRenderer extends DefaultDomRenderer2{constructor(eventManager,sharedStylesHost,hostEl,component){super(eventManager);this.sharedStylesHost=sharedStylesHost;this.hostEl=hostEl;this.shadowRoot=hostEl.attachShadow({mode:"open"});
this.sharedStylesHost.addHost(this.shadowRoot);const styles=flattenStyles(component.id,component.styles,[]);for(let i=0;i<styles.length;i++){const styleEl=document.createElement("style");styleEl.textContent=styles[i];this.shadowRoot.appendChild(styleEl)}}nodeOrShadowRoot(node){return node===this.hostEl?this.shadowRoot:node}destroy(){this.sharedStylesHost.removeHost(this.shadowRoot)}appendChild(parent,newChild){return super.appendChild(this.nodeOrShadowRoot(parent),newChild)}insertBefore(parent,newChild,
refChild){return super.insertBefore(this.nodeOrShadowRoot(parent),newChild,refChild)}removeChild(parent,oldChild){return super.removeChild(this.nodeOrShadowRoot(parent),oldChild)}parentNode(node){return this.nodeOrShadowRoot(super.parentNode(this.nodeOrShadowRoot(node)))}}class DomEventsPlugin extends EventManagerPlugin{constructor(doc){super(doc)}supports(eventName){return true}addEventListener(element,eventName,handler){element.addEventListener(eventName,handler,false);return()=>this.removeEventListener(element,
eventName,handler)}removeEventListener(target,eventName,callback){return target.removeEventListener(eventName,callback)}}DomEventsPlugin.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:DomEventsPlugin,deps:[{token:common.DOCUMENT}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});DomEventsPlugin.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:DomEventsPlugin});
i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:DomEventsPlugin,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:undefined,decorators:[{type:i0.Inject,args:[common.DOCUMENT]}]}]}});const MODIFIER_KEYS=["alt","control","meta","shift"];const DOM_KEY_LOCATION_NUMPAD=3;const _keyMap={"\b":"Backspace","\t":"Tab","":"Delete","":"Escape","Del":"Delete","Esc":"Escape","Left":"ArrowLeft","Right":"ArrowRight","Up":"ArrowUp",
"Down":"ArrowDown","Menu":"ContextMenu","Scroll":"ScrollLock","Win":"OS"};const _chromeNumKeyPadMap={"A":"1","B":"2","C":"3","D":"4","E":"5","F":"6","G":"7","H":"8","I":"9","J":"*","K":"+","M":"-","N":".","O":"/","`":"0","":"NumLock"};const MODIFIER_KEY_GETTERS={"alt":event=>event.altKey,"control":event=>event.ctrlKey,"meta":event=>event.metaKey,"shift":event=>event.shiftKey};class KeyEventsPlugin extends EventManagerPlugin{constructor(doc){super(doc)}supports(eventName){return KeyEventsPlugin.parseEventName(eventName)!=
null}addEventListener(element,eventName,handler){const parsedEvent=KeyEventsPlugin.parseEventName(eventName);const outsideHandler=KeyEventsPlugin.eventCallback(parsedEvent["fullKey"],handler,this.manager.getZone());return this.manager.getZone().runOutsideAngular(()=>{return common["ɵgetDOM"]().onAndCancel(element,parsedEvent["domEventName"],outsideHandler)})}static parseEventName(eventName){const parts=eventName.toLowerCase().split(".");const domEventName=parts.shift();if(parts.length===0||!(domEventName===
"keydown"||domEventName==="keyup"))return null;const key=KeyEventsPlugin._normalizeKey(parts.pop());let fullKey="";MODIFIER_KEYS.forEach(modifierName=>{const index=parts.indexOf(modifierName);if(index>-1){parts.splice(index,1);fullKey+=modifierName+"."}});fullKey+=key;if(parts.length!=0||key.length===0)return null;const result={};result["domEventName"]=domEventName;result["fullKey"]=fullKey;return result}static getEventFullKey(event){let fullKey="";let key=getEventKey(event);key=key.toLowerCase();
if(key===" ")key="space";else if(key===".")key="dot";MODIFIER_KEYS.forEach(modifierName=>{if(modifierName!=key){const modifierGetter=MODIFIER_KEY_GETTERS[modifierName];if(modifierGetter(event))fullKey+=modifierName+"."}});fullKey+=key;return fullKey}static eventCallback(fullKey,handler,zone){return event=>{if(KeyEventsPlugin.getEventFullKey(event)===fullKey)zone.runGuarded(()=>handler(event))}}static _normalizeKey(keyName){switch(keyName){case "esc":return"escape";default:return keyName}}}KeyEventsPlugin.\u0275fac=
i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:KeyEventsPlugin,deps:[{token:common.DOCUMENT}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});KeyEventsPlugin.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:KeyEventsPlugin});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:KeyEventsPlugin,
decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:undefined,decorators:[{type:i0.Inject,args:[common.DOCUMENT]}]}]}});function getEventKey(event){let key=event.key;if(key==null){key=event.keyIdentifier;if(key==null)return"Unidentified";if(key.startsWith("U+")){key=String.fromCharCode(parseInt(key.substring(2),16));if(event.location===DOM_KEY_LOCATION_NUMPAD&&_chromeNumKeyPadMap.hasOwnProperty(key))key=_chromeNumKeyPadMap[key]}}return _keyMap[key]||key}function initDomAdapter(){BrowserDomAdapter.makeCurrent();
BrowserGetTestability.init()}function errorHandler(){return new i0.ErrorHandler}function _document(){i0["ɵsetDocument"](document);return document}const INTERNAL_BROWSER_PLATFORM_PROVIDERS=[{provide:i0.PLATFORM_ID,useValue:common["ɵPLATFORM_BROWSER_ID"]},{provide:i0.PLATFORM_INITIALIZER,useValue:initDomAdapter,multi:true},{provide:common.DOCUMENT,useFactory:_document,deps:[]}];const platformBrowser=i0.createPlatformFactory(i0.platformCore,"browser",INTERNAL_BROWSER_PLATFORM_PROVIDERS);const BROWSER_MODULE_PROVIDERS=
[{provide:i0["ɵINJECTOR_SCOPE"],useValue:"root"},{provide:i0.ErrorHandler,useFactory:errorHandler,deps:[]},{provide:EVENT_MANAGER_PLUGINS,useClass:DomEventsPlugin,multi:true,deps:[common.DOCUMENT,i0.NgZone,i0.PLATFORM_ID]},{provide:EVENT_MANAGER_PLUGINS,useClass:KeyEventsPlugin,multi:true,deps:[common.DOCUMENT]},{provide:DomRendererFactory2,useClass:DomRendererFactory2,deps:[EventManager,DomSharedStylesHost,i0.APP_ID]},{provide:i0.RendererFactory2,useExisting:DomRendererFactory2},{provide:SharedStylesHost,
useExisting:DomSharedStylesHost},{provide:DomSharedStylesHost,useClass:DomSharedStylesHost,deps:[common.DOCUMENT]},{provide:i0.Testability,useClass:i0.Testability,deps:[i0.NgZone]},{provide:EventManager,useClass:EventManager,deps:[EVENT_MANAGER_PLUGINS,i0.NgZone]},{provide:common.XhrFactory,useClass:BrowserXhr,deps:[]}];class BrowserModule{constructor(parentModule){if(parentModule)throw new Error(`BrowserModule has already been loaded. If you need access to common directives such as NgIf and NgFor from a lazy loaded module, import CommonModule instead.`);
}static withServerTransition(params){return{ngModule:BrowserModule,providers:[{provide:i0.APP_ID,useValue:params.appId},{provide:TRANSITION_ID,useExisting:i0.APP_ID},SERVER_TRANSITION_PROVIDERS]}}}BrowserModule.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:BrowserModule,deps:[{token:BrowserModule,optional:true,skipSelf:true}],target:i0__namespace.\u0275\u0275FactoryTarget.NgModule});BrowserModule.\u0275mod=i0__namespace.\u0275\u0275ngDeclareNgModule({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:BrowserModule,exports:[common.CommonModule,i0.ApplicationModule]});BrowserModule.\u0275inj=i0__namespace.\u0275\u0275ngDeclareInjector({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:BrowserModule,providers:BROWSER_MODULE_PROVIDERS,imports:[common.CommonModule,i0.ApplicationModule]});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:BrowserModule,decorators:[{type:i0.NgModule,
args:[{providers:BROWSER_MODULE_PROVIDERS,exports:[common.CommonModule,i0.ApplicationModule]}]}],ctorParameters:function(){return[{type:BrowserModule,decorators:[{type:i0.Optional},{type:i0.SkipSelf},{type:i0.Inject,args:[BrowserModule]}]}]}});function createMeta(){return new Meta(i0["ɵɵinject"](common.DOCUMENT))}class Meta{constructor(_doc){this._doc=_doc;this._dom=common["ɵgetDOM"]()}addTag(tag,forceCreation=false){if(!tag)return null;return this._getOrCreateElement(tag,forceCreation)}addTags(tags,
forceCreation=false){if(!tags)return[];return tags.reduce((result,tag)=>{if(tag)result.push(this._getOrCreateElement(tag,forceCreation));return result},[])}getTag(attrSelector){if(!attrSelector)return null;return this._doc.querySelector(`meta[${attrSelector}]`)||null}getTags(attrSelector){if(!attrSelector)return[];const list=this._doc.querySelectorAll(`meta[${attrSelector}]`);return list?[].slice.call(list):[]}updateTag(tag,selector){if(!tag)return null;selector=selector||this._parseSelector(tag);
const meta=this.getTag(selector);if(meta)return this._setMetaElementAttributes(tag,meta);return this._getOrCreateElement(tag,true)}removeTag(attrSelector){this.removeTagElement(this.getTag(attrSelector))}removeTagElement(meta){if(meta)this._dom.remove(meta)}_getOrCreateElement(meta,forceCreation=false){if(!forceCreation){const selector=this._parseSelector(meta);const elem=this.getTags(selector).filter(elem=>this._containsAttributes(meta,elem))[0];if(elem!==undefined)return elem}const element=this._dom.createElement("meta");
this._setMetaElementAttributes(meta,element);const head=this._doc.getElementsByTagName("head")[0];head.appendChild(element);return element}_setMetaElementAttributes(tag,el){Object.keys(tag).forEach(prop=>el.setAttribute(this._getMetaKeyMap(prop),tag[prop]));return el}_parseSelector(tag){const attr=tag.name?"name":"property";return`${attr}="${tag[attr]}"`}_containsAttributes(tag,elem){return Object.keys(tag).every(key=>elem.getAttribute(this._getMetaKeyMap(key))===tag[key])}_getMetaKeyMap(prop){return META_KEYS_MAP[prop]||
prop}}Meta.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:Meta,deps:[{token:common.DOCUMENT}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});Meta.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:Meta,providedIn:"root",useFactory:createMeta,deps:[]});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,
type:Meta,decorators:[{type:i0.Injectable,args:[{providedIn:"root",useFactory:createMeta,deps:[]}]}],ctorParameters:function(){return[{type:undefined,decorators:[{type:i0.Inject,args:[common.DOCUMENT]}]}]}});const META_KEYS_MAP={httpEquiv:"http-equiv"};function createTitle(){return new Title(i0["ɵɵinject"](common.DOCUMENT))}class Title{constructor(_doc){this._doc=_doc}getTitle(){return this._doc.title}setTitle(newTitle){this._doc.title=newTitle||""}}Title.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:Title,deps:[{token:common.DOCUMENT}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});Title.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:Title,providedIn:"root",useFactory:createTitle,deps:[]});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:Title,decorators:[{type:i0.Injectable,args:[{providedIn:"root",
useFactory:createTitle,deps:[]}]}],ctorParameters:function(){return[{type:undefined,decorators:[{type:i0.Inject,args:[common.DOCUMENT]}]}]}});function exportNgVar(name,value){if(typeof COMPILED==="undefined"||!COMPILED){const ng=i0["ɵglobal"]["ng"]=i0["ɵglobal"]["ng"]||{};ng[name]=value}}const win=typeof window!=="undefined"&&window||{};class ChangeDetectionPerfRecord{constructor(msPerTick,numTicks){this.msPerTick=msPerTick;this.numTicks=numTicks}}class AngularProfiler{constructor(ref){this.appRef=
ref.injector.get(i0.ApplicationRef)}timeChangeDetection(config){const record=config&&config["record"];const profileName="Change Detection";const isProfilerAvailable=win.console.profile!=null;if(record&&isProfilerAvailable)win.console.profile(profileName);const start=performanceNow();let numTicks=0;while(numTicks<5||performanceNow()-start<500){this.appRef.tick();numTicks++}const end=performanceNow();if(record&&isProfilerAvailable)win.console.profileEnd(profileName);const msPerTick=(end-start)/numTicks;
win.console.log(`ran ${numTicks} change detection cycles`);win.console.log(`${msPerTick.toFixed(2)} ms per check`);return new ChangeDetectionPerfRecord(msPerTick,numTicks)}}function performanceNow(){return win.performance&&win.performance.now?win.performance.now():(new Date).getTime()}const PROFILER_GLOBAL_NAME="profiler";function enableDebugTools(ref){exportNgVar(PROFILER_GLOBAL_NAME,new AngularProfiler(ref));return ref}function disableDebugTools(){exportNgVar(PROFILER_GLOBAL_NAME,null)}function escapeHtml(text){const escapedText=
{"&":"&a;",'"':"&q;","'":"&s;","<":"&l;",">":"&g;"};return text.replace(/[&"'<>]/g,s=>escapedText[s])}function unescapeHtml(text){const unescapedText={"&a;":"&","&q;":'"',"&s;":"'","&l;":"<","&g;":">"};return text.replace(/&[^;]+;/g,s=>unescapedText[s])}function makeStateKey(key){return key}class TransferState{constructor(){this.store={};this.onSerializeCallbacks={}}static init(initState){const transferState=new TransferState;transferState.store=initState;return transferState}get(key,defaultValue){return this.store[key]!==
undefined?this.store[key]:defaultValue}set(key,value){this.store[key]=value}remove(key){delete this.store[key]}hasKey(key){return this.store.hasOwnProperty(key)}onSerialize(key,callback){this.onSerializeCallbacks[key]=callback}toJson(){for(const key in this.onSerializeCallbacks)if(this.onSerializeCallbacks.hasOwnProperty(key))try{this.store[key]=this.onSerializeCallbacks[key]()}catch(e){console.warn("Exception in onSerialize callback: ",e)}return JSON.stringify(this.store)}}TransferState.\u0275fac=
i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:TransferState,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});TransferState.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:TransferState});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:TransferState,decorators:[{type:i0.Injectable}]});
function initTransferState(doc,appId){const script=doc.getElementById(appId+"-state");let initialState={};if(script&&script.textContent)try{initialState=JSON.parse(unescapeHtml(script.textContent))}catch(e){console.warn("Exception while restoring TransferState for app "+appId,e)}return TransferState.init(initialState)}class BrowserTransferStateModule{}BrowserTransferStateModule.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:BrowserTransferStateModule,
deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.NgModule});BrowserTransferStateModule.\u0275mod=i0__namespace.\u0275\u0275ngDeclareNgModule({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:BrowserTransferStateModule});BrowserTransferStateModule.\u0275inj=i0__namespace.\u0275\u0275ngDeclareInjector({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:BrowserTransferStateModule,providers:[{provide:TransferState,useFactory:initTransferState,deps:[common.DOCUMENT,
i0.APP_ID]}]});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:BrowserTransferStateModule,decorators:[{type:i0.NgModule,args:[{providers:[{provide:TransferState,useFactory:initTransferState,deps:[common.DOCUMENT,i0.APP_ID]}]}]}]});class By{static all(){return()=>true}static css(selector){return debugElement=>{return debugElement.nativeElement!=null?elementMatches(debugElement.nativeElement,selector):false}}static directive(type){return debugNode=>
debugNode.providerTokens.indexOf(type)!==-1}}function elementMatches(n,selector){if(common["ɵgetDOM"]().isElementNode(n))return n.matches&&n.matches(selector)||n.msMatchesSelector&&n.msMatchesSelector(selector)||n.webkitMatchesSelector&&n.webkitMatchesSelector(selector);return false}const EVENT_NAMES={"pan":true,"panstart":true,"panmove":true,"panend":true,"pancancel":true,"panleft":true,"panright":true,"panup":true,"pandown":true,"pinch":true,"pinchstart":true,"pinchmove":true,"pinchend":true,"pinchcancel":true,
"pinchin":true,"pinchout":true,"press":true,"pressup":true,"rotate":true,"rotatestart":true,"rotatemove":true,"rotateend":true,"rotatecancel":true,"swipe":true,"swipeleft":true,"swiperight":true,"swipeup":true,"swipedown":true,"tap":true,"doubletap":true};const HAMMER_GESTURE_CONFIG=new i0.InjectionToken("HammerGestureConfig");const HAMMER_LOADER=new i0.InjectionToken("HammerLoader");class HammerGestureConfig{constructor(){this.events=[];this.overrides={}}buildHammer(element){const mc=new Hammer(element,
this.options);mc.get("pinch").set({enable:true});mc.get("rotate").set({enable:true});for(const eventName in this.overrides)mc.get(eventName).set(this.overrides[eventName]);return mc}}HammerGestureConfig.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:HammerGestureConfig,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});HammerGestureConfig.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:HammerGestureConfig});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:HammerGestureConfig,decorators:[{type:i0.Injectable}]});class HammerGesturesPlugin extends EventManagerPlugin{constructor(doc,_config,console,loader){super(doc);this._config=_config;this.console=console;this.loader=loader;this._loaderPromise=null}supports(eventName){if(!EVENT_NAMES.hasOwnProperty(eventName.toLowerCase())&&
!this.isCustomEvent(eventName))return false;if(!window.Hammer&&!this.loader){if(typeof ngDevMode==="undefined"||ngDevMode)this.console.warn(`The "${eventName}" event cannot be bound because Hammer.JS is not `+`loaded and no custom loader has been specified.`);return false}return true}addEventListener(element,eventName,handler){const zone=this.manager.getZone();eventName=eventName.toLowerCase();if(!window.Hammer&&this.loader){this._loaderPromise=this._loaderPromise||this.loader();let cancelRegistration=
false;let deregister=()=>{cancelRegistration=true};this._loaderPromise.then(()=>{if(!window.Hammer){if(typeof ngDevMode==="undefined"||ngDevMode)this.console.warn(`The custom HAMMER_LOADER completed, but Hammer.JS is not present.`);deregister=()=>{};return}if(!cancelRegistration)deregister=this.addEventListener(element,eventName,handler)}).catch(()=>{if(typeof ngDevMode==="undefined"||ngDevMode)this.console.warn(`The "${eventName}" event cannot be bound because the custom `+`Hammer.JS loader failed.`);
deregister=()=>{}});return()=>{deregister()}}return zone.runOutsideAngular(()=>{const mc=this._config.buildHammer(element);const callback=function(eventObj){zone.runGuarded(function(){handler(eventObj)})};mc.on(eventName,callback);return()=>{mc.off(eventName,callback);if(typeof mc.destroy==="function")mc.destroy()}})}isCustomEvent(eventName){return this._config.events.indexOf(eventName)>-1}}HammerGesturesPlugin.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",
ngImport:i0__namespace,type:HammerGesturesPlugin,deps:[{token:common.DOCUMENT},{token:HAMMER_GESTURE_CONFIG},{token:i0__namespace.\u0275Console},{token:HAMMER_LOADER,optional:true}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});HammerGesturesPlugin.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:HammerGesturesPlugin});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,
type:HammerGesturesPlugin,decorators:[{type:i0.Injectable}],ctorParameters:function(){return[{type:undefined,decorators:[{type:i0.Inject,args:[common.DOCUMENT]}]},{type:HammerGestureConfig,decorators:[{type:i0.Inject,args:[HAMMER_GESTURE_CONFIG]}]},{type:i0__namespace.\u0275Console},{type:undefined,decorators:[{type:i0.Optional},{type:i0.Inject,args:[HAMMER_LOADER]}]}]}});class HammerModule{}HammerModule.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,
type:HammerModule,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.NgModule});HammerModule.\u0275mod=i0__namespace.\u0275\u0275ngDeclareNgModule({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:HammerModule});HammerModule.\u0275inj=i0__namespace.\u0275\u0275ngDeclareInjector({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:HammerModule,providers:[{provide:EVENT_MANAGER_PLUGINS,useClass:HammerGesturesPlugin,multi:true,deps:[common.DOCUMENT,HAMMER_GESTURE_CONFIG,
i0["ɵConsole"],[new i0.Optional,HAMMER_LOADER]]},{provide:HAMMER_GESTURE_CONFIG,useClass:HammerGestureConfig,deps:[]}]});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:HammerModule,decorators:[{type:i0.NgModule,args:[{providers:[{provide:EVENT_MANAGER_PLUGINS,useClass:HammerGesturesPlugin,multi:true,deps:[common.DOCUMENT,HAMMER_GESTURE_CONFIG,i0["ɵConsole"],[new i0.Optional,HAMMER_LOADER]]},{provide:HAMMER_GESTURE_CONFIG,useClass:HammerGestureConfig,
deps:[]}]}]}]});class DomSanitizer{}DomSanitizer.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:DomSanitizer,deps:[],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});DomSanitizer.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:DomSanitizer,providedIn:"root",useExisting:i0__namespace.forwardRef(function(){return DomSanitizerImpl})});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:DomSanitizer,decorators:[{type:i0.Injectable,args:[{providedIn:"root",useExisting:i0.forwardRef(()=>DomSanitizerImpl)}]}]});function domSanitizerImplFactory(injector){return new DomSanitizerImpl(injector.get(common.DOCUMENT))}class DomSanitizerImpl extends DomSanitizer{constructor(_doc){super();this._doc=_doc}sanitize(ctx,value){if(value==null)return null;switch(ctx){case i0.SecurityContext.NONE:return value;case i0.SecurityContext.HTML:if(i0["ɵallowSanitizationBypassAndThrow"](value,
"HTML"))return i0["ɵunwrapSafeValue"](value);return i0["ɵ_sanitizeHtml"](this._doc,String(value)).toString();case i0.SecurityContext.STYLE:if(i0["ɵallowSanitizationBypassAndThrow"](value,"Style"))return i0["ɵunwrapSafeValue"](value);return value;case i0.SecurityContext.SCRIPT:if(i0["ɵallowSanitizationBypassAndThrow"](value,"Script"))return i0["ɵunwrapSafeValue"](value);throw new Error("unsafe value used in a script context");case i0.SecurityContext.URL:i0["ɵgetSanitizationBypassType"](value);if(i0["ɵallowSanitizationBypassAndThrow"](value,
"URL"))return i0["ɵunwrapSafeValue"](value);return i0["ɵ_sanitizeUrl"](String(value));case i0.SecurityContext.RESOURCE_URL:if(i0["ɵallowSanitizationBypassAndThrow"](value,"ResourceURL"))return i0["ɵunwrapSafeValue"](value);throw new Error("unsafe value used in a resource URL context (see https://g.co/ng/security#xss)");default:throw new Error(`Unexpected SecurityContext ${ctx} (see https://g.co/ng/security#xss)`);}}bypassSecurityTrustHtml(value){return i0["ɵbypassSanitizationTrustHtml"](value)}bypassSecurityTrustStyle(value){return i0["ɵbypassSanitizationTrustStyle"](value)}bypassSecurityTrustScript(value){return i0["ɵbypassSanitizationTrustScript"](value)}bypassSecurityTrustUrl(value){return i0["ɵbypassSanitizationTrustUrl"](value)}bypassSecurityTrustResourceUrl(value){return i0["ɵbypassSanitizationTrustResourceUrl"](value)}}
DomSanitizerImpl.\u0275fac=i0__namespace.\u0275\u0275ngDeclareFactory({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:DomSanitizerImpl,deps:[{token:common.DOCUMENT}],target:i0__namespace.\u0275\u0275FactoryTarget.Injectable});DomSanitizerImpl.\u0275prov=i0__namespace.\u0275\u0275ngDeclareInjectable({minVersion:"12.0.0",version:"13.3.1",ngImport:i0__namespace,type:DomSanitizerImpl,providedIn:"root",useFactory:domSanitizerImplFactory,deps:[{token:i0.Injector}]});i0__namespace.\u0275\u0275ngDeclareClassMetadata({minVersion:"12.0.0",
version:"13.3.1",ngImport:i0__namespace,type:DomSanitizerImpl,decorators:[{type:i0.Injectable,args:[{providedIn:"root",useFactory:domSanitizerImplFactory,deps:[i0.Injector]}]}],ctorParameters:function(){return[{type:undefined,decorators:[{type:i0.Inject,args:[common.DOCUMENT]}]}]}});const VERSION=new i0.Version("13.3.1");Object.defineProperty(exports,"ɵgetDOM",{enumerable:true,get:function(){return common["ɵgetDOM"]}});exports.BrowserModule=BrowserModule;exports.BrowserTransferStateModule=BrowserTransferStateModule;
exports.By=By;exports.DomSanitizer=DomSanitizer;exports.EVENT_MANAGER_PLUGINS=EVENT_MANAGER_PLUGINS;exports.EventManager=EventManager;exports.HAMMER_GESTURE_CONFIG=HAMMER_GESTURE_CONFIG;exports.HAMMER_LOADER=HAMMER_LOADER;exports.HammerGestureConfig=HammerGestureConfig;exports.HammerModule=HammerModule;exports.Meta=Meta;exports.Title=Title;exports.TransferState=TransferState;exports.VERSION=VERSION;exports.disableDebugTools=disableDebugTools;exports.enableDebugTools=enableDebugTools;exports.makeStateKey=
makeStateKey;exports.platformBrowser=platformBrowser;exports["ɵBrowserDomAdapter"]=BrowserDomAdapter;exports["ɵBrowserGetTestability"]=BrowserGetTestability;exports["ɵDomEventsPlugin"]=DomEventsPlugin;exports["ɵDomRendererFactory2"]=DomRendererFactory2;exports["ɵDomSanitizerImpl"]=DomSanitizerImpl;exports["ɵDomSharedStylesHost"]=DomSharedStylesHost;exports["ɵHammerGesturesPlugin"]=HammerGesturesPlugin;exports["ɵINTERNAL_BROWSER_PLATFORM_PROVIDERS"]=INTERNAL_BROWSER_PLATFORM_PROVIDERS;exports["ɵKeyEventsPlugin"]=
KeyEventsPlugin;exports["ɵNAMESPACE_URIS"]=NAMESPACE_URIS;exports["ɵSharedStylesHost"]=SharedStylesHost;exports["ɵTRANSITION_ID"]=TRANSITION_ID;exports["ɵescapeHtml"]=escapeHtml;exports["ɵflattenStyles"]=flattenStyles;exports["ɵinitDomAdapter"]=initDomAdapter;exports["ɵshimContentAttribute"]=shimContentAttribute;exports["ɵshimHostAttribute"]=shimHostAttribute;Object.defineProperty(exports,"__esModule",{value:true})});

