(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/common'), require('@angular/common/testing'), require('@angular/core'), require('@angular/router')) :
    typeof define === 'function' && define.amd ? define(['exports', '@angular/common', '@angular/common/testing', '@angular/core', '@angular/router'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory((global.ng = global.ng || {}, global.ng.routerTesting = {}), global.common, global.testing, global.i0, global.router));
})(this, (function (exports, common, testing, i0, router) { 'use strict';

    function _interopNamespace(e) {
        if (e && e.__esModule) return e;
        var n = Object.create(null);
        if (e) {
            Object.keys(e).forEach(function (k) {
                if (k !== 'default') {
                    var d = Object.getOwnPropertyDescriptor(e, k);
                    Object.defineProperty(n, k, d.get ? d : {
                        enumerable: true,
                        get: function () { return e[k]; }
                    });
                }
            });
        }
        n["default"] = e;
        return Object.freeze(n);
    }

    var i0__namespace = /*#__PURE__*/_interopNamespace(i0);

    /**
     * @license Angular v13.3.1
     * (c) 2010-2022 Google LLC. https://angular.io/
     * License: MIT
     */

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    // This file exists to easily patch the SpyNgModuleFactoryLoader into g3
    const EXTRA_ROUTER_TESTING_PROVIDERS = [];

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    function isUrlHandlingStrategy(opts) {
        // This property check is needed because UrlHandlingStrategy is an interface and doesn't exist at
        // runtime.
        return 'shouldProcessUrl' in opts;
    }
    /**
     * Router setup factory function used for testing.
     *
     * @publicApi
     */
    function setupTestingRouter(urlSerializer, contexts, location, compiler, injector, routes, opts, urlHandlingStrategy, routeReuseStrategy) {
        const router$1 = new router.Router(null, urlSerializer, contexts, location, injector, compiler, router["ɵflatten"](routes));
        if (opts) {
            // Handle deprecated argument ordering.
            if (isUrlHandlingStrategy(opts)) {
                router$1.urlHandlingStrategy = opts;
            }
            else {
                // Handle ExtraOptions
                router["ɵassignExtraOptionsToRouter"](opts, router$1);
            }
        }
        if (urlHandlingStrategy) {
            router$1.urlHandlingStrategy = urlHandlingStrategy;
        }
        if (routeReuseStrategy) {
            router$1.routeReuseStrategy = routeReuseStrategy;
        }
        return router$1;
    }
    /**
     * @description
     *
     * Sets up the router to be used for testing.
     *
     * The modules sets up the router to be used for testing.
     * It provides spy implementations of `Location` and `LocationStrategy`.
     *
     * @usageNotes
     * ### Example
     *
     * ```
     * beforeEach(() => {
     *   TestBed.configureTestingModule({
     *     imports: [
     *       RouterTestingModule.withRoutes(
     *         [{path: '', component: BlankCmp}, {path: 'simple', component: SimpleCmp}]
     *       )
     *     ]
     *   });
     * });
     * ```
     *
     * @publicApi
     */
    class RouterTestingModule {
        static withRoutes(routes, config) {
            return {
                ngModule: RouterTestingModule,
                providers: [
                    router.provideRoutes(routes),
                    { provide: router.ROUTER_CONFIGURATION, useValue: config ? config : {} },
                ]
            };
        }
    }
    RouterTestingModule.ɵfac = i0__namespace.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "13.3.1", ngImport: i0__namespace, type: RouterTestingModule, deps: [], target: i0__namespace.ɵɵFactoryTarget.NgModule });
    RouterTestingModule.ɵmod = i0__namespace.ɵɵngDeclareNgModule({ minVersion: "12.0.0", version: "13.3.1", ngImport: i0__namespace, type: RouterTestingModule, exports: [router.RouterModule] });
    RouterTestingModule.ɵinj = i0__namespace.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "13.3.1", ngImport: i0__namespace, type: RouterTestingModule, providers: [
            router["ɵROUTER_PROVIDERS"],
            EXTRA_ROUTER_TESTING_PROVIDERS,
            { provide: common.Location, useClass: testing.SpyLocation },
            { provide: common.LocationStrategy, useClass: testing.MockLocationStrategy },
            {
                provide: router.Router,
                useFactory: setupTestingRouter,
                deps: [
                    router.UrlSerializer, router.ChildrenOutletContexts, common.Location, i0.Compiler, i0.Injector, router.ROUTES,
                    router.ROUTER_CONFIGURATION, [router.UrlHandlingStrategy, new i0.Optional()],
                    [router.RouteReuseStrategy, new i0.Optional()]
                ]
            },
            { provide: router.PreloadingStrategy, useExisting: router.NoPreloading },
            router.provideRoutes([]),
        ], imports: [router.RouterModule] });
    i0__namespace.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "13.3.1", ngImport: i0__namespace, type: RouterTestingModule, decorators: [{
                type: i0.NgModule,
                args: [{
                        exports: [router.RouterModule],
                        providers: [
                            router["ɵROUTER_PROVIDERS"],
                            EXTRA_ROUTER_TESTING_PROVIDERS,
                            { provide: common.Location, useClass: testing.SpyLocation },
                            { provide: common.LocationStrategy, useClass: testing.MockLocationStrategy },
                            {
                                provide: router.Router,
                                useFactory: setupTestingRouter,
                                deps: [
                                    router.UrlSerializer, router.ChildrenOutletContexts, common.Location, i0.Compiler, i0.Injector, router.ROUTES,
                                    router.ROUTER_CONFIGURATION, [router.UrlHandlingStrategy, new i0.Optional()],
                                    [router.RouteReuseStrategy, new i0.Optional()]
                                ]
                            },
                            { provide: router.PreloadingStrategy, useExisting: router.NoPreloading },
                            router.provideRoutes([]),
                        ]
                    }]
            }] });

    exports.RouterTestingModule = RouterTestingModule;
    exports.setupTestingRouter = setupTestingRouter;

    Object.defineProperty(exports, '__esModule', { value: true });

}));
