'use strict';function copyObj(obj,target,overwrite){if(!target)target={};for(var prop in obj)if(obj.hasOwnProperty(prop)&&(overwrite!==false||!target.hasOwnProperty(prop)))target[prop]=obj[prop];return target}
function countColumn(string,end,tabSize,startIndex,startValue){if(end==null){end=string.search(/[^\s\u00a0]/);if(end==-1)end=string.length}for(var i=startIndex||0,n=startValue||0;;){var nextTab=string.indexOf("\t",i);if(nextTab<0||nextTab>=end)return n+(end-i);n+=nextTab-i;n+=tabSize-n%tabSize;i=nextTab+1}}function nothing(){}function createObj(base,props){var inst;if(Object.create)inst=Object.create(base);else{nothing.prototype=base;inst=new nothing}if(props)copyObj(props,inst);return inst}
var StringStream=function(string,tabSize,lineOracle){this.pos=this.start=0;this.string=string;this.tabSize=tabSize||8;this.lastColumnPos=this.lastColumnValue=0;this.lineStart=0;this.lineOracle=lineOracle};StringStream.prototype.eol=function(){return this.pos>=this.string.length};StringStream.prototype.sol=function(){return this.pos==this.lineStart};StringStream.prototype.peek=function(){return this.string.charAt(this.pos)||undefined};StringStream.prototype.next=function(){if(this.pos<this.string.length)return this.string.charAt(this.pos++)};
StringStream.prototype.eat=function(match){var ch=this.string.charAt(this.pos);var ok;if(typeof match=="string")ok=ch==match;else ok=ch&&(match.test?match.test(ch):match(ch));if(ok){++this.pos;return ch}};StringStream.prototype.eatWhile=function(match){var start=this.pos;while(this.eat(match));return this.pos>start};StringStream.prototype.eatSpace=function(){var start=this.pos;while(/[\s\u00a0]/.test(this.string.charAt(this.pos)))++this.pos;return this.pos>start};
StringStream.prototype.skipToEnd=function(){this.pos=this.string.length};StringStream.prototype.skipTo=function(ch){var found=this.string.indexOf(ch,this.pos);if(found>-1){this.pos=found;return true}};StringStream.prototype.backUp=function(n){this.pos-=n};
StringStream.prototype.column=function(){if(this.lastColumnPos<this.start){this.lastColumnValue=countColumn(this.string,this.start,this.tabSize,this.lastColumnPos,this.lastColumnValue);this.lastColumnPos=this.start}return this.lastColumnValue-(this.lineStart?countColumn(this.string,this.lineStart,this.tabSize):0)};StringStream.prototype.indentation=function(){return countColumn(this.string,null,this.tabSize)-(this.lineStart?countColumn(this.string,this.lineStart,this.tabSize):0)};
StringStream.prototype.match=function(pattern,consume,caseInsensitive){if(typeof pattern=="string"){var cased=function(str){return caseInsensitive?str.toLowerCase():str};var substr=this.string.substr(this.pos,pattern.length);if(cased(substr)==cased(pattern)){if(consume!==false)this.pos+=pattern.length;return true}}else{var match=this.string.slice(this.pos).match(pattern);if(match&&match.index>0)return null;if(match&&consume!==false)this.pos+=match[0].length;return match}};
StringStream.prototype.current=function(){return this.string.slice(this.start,this.pos)};StringStream.prototype.hideFirstChars=function(n,inner){this.lineStart+=n;try{return inner()}finally{this.lineStart-=n}};StringStream.prototype.lookAhead=function(n){var oracle=this.lineOracle;return oracle&&oracle.lookAhead(n)};StringStream.prototype.baseToken=function(){var oracle=this.lineOracle;return oracle&&oracle.baseToken(this.pos)};var modes={},mimeModes={};
function defineMode(name,mode){if(arguments.length>2)mode.dependencies=Array.prototype.slice.call(arguments,2);modes[name]=mode}function defineMIME(mime,spec){mimeModes[mime]=spec}
function resolveMode(spec){if(typeof spec=="string"&&mimeModes.hasOwnProperty(spec))spec=mimeModes[spec];else if(spec&&typeof spec.name=="string"&&mimeModes.hasOwnProperty(spec.name)){var found=mimeModes[spec.name];if(typeof found=="string")found={name:found};spec=createObj(found,spec);spec.name=found.name}else if(typeof spec=="string"&&/^[\w\-]+\/[\w\-]+\+xml$/.test(spec))return resolveMode("application/xml");else if(typeof spec=="string"&&/^[\w\-]+\/[\w\-]+\+json$/.test(spec))return resolveMode("application/json");
if(typeof spec=="string")return{name:spec};else return spec||{name:"null"}}
function getMode(options,spec){spec=resolveMode(spec);var mfactory=modes[spec.name];if(!mfactory)return getMode(options,"text/plain");var modeObj=mfactory(options,spec);if(modeExtensions.hasOwnProperty(spec.name)){var exts=modeExtensions[spec.name];for(var prop in exts){if(!exts.hasOwnProperty(prop))continue;if(modeObj.hasOwnProperty(prop))modeObj["_"+prop]=modeObj[prop];modeObj[prop]=exts[prop]}}modeObj.name=spec.name;if(spec.helperType)modeObj.helperType=spec.helperType;if(spec.modeProps)for(var prop$1 in spec.modeProps)modeObj[prop$1]=
spec.modeProps[prop$1];return modeObj}var modeExtensions={};function extendMode(mode,properties){var exts=modeExtensions.hasOwnProperty(mode)?modeExtensions[mode]:modeExtensions[mode]={};copyObj(properties,exts)}function copyState(mode,state){if(state===true)return state;if(mode.copyState)return mode.copyState(state);var nstate={};for(var n in state){var val=state[n];if(val instanceof Array)val=val.concat([]);nstate[n]=val}return nstate}
function innerMode(mode,state){var info;while(mode.innerMode){info=mode.innerMode(state);if(!info||info.mode==mode)break;state=info.state;mode=info.mode}return info||{mode:mode,state:state}}function startState(mode,a1,a2){return mode.startState?mode.startState(a1,a2):true}
var modeMethods={__proto__:null,modes:modes,mimeModes:mimeModes,defineMode:defineMode,defineMIME:defineMIME,resolveMode:resolveMode,getMode:getMode,modeExtensions:modeExtensions,extendMode:extendMode,copyState:copyState,innerMode:innerMode,startState:startState};exports.StringStream=StringStream;exports.countColumn=countColumn;for(var exported in modeMethods)exports[exported]=modeMethods[exported];require.cache[require.resolve("../../lib/codemirror")]=require.cache[require.resolve("./runmode.node")];
require.cache[require.resolve("../../addon/runmode/runmode")]=require.cache[require.resolve("./runmode.node")];exports.defineMode("null",function(){return{token:function(stream){return stream.skipToEnd()}}});exports.defineMIME("text/plain","null");exports.registerHelper=exports.registerGlobalHelper=Math.min;exports.splitLines=function(string){return string.split(/\r?\n|\r/)};exports.defaults={indentUnit:2};
(function(mod){if(typeof exports=="object"&&typeof module=="object")mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){CodeMirror.runMode=function(string,modespec,callback,options){var mode=CodeMirror.getMode(CodeMirror.defaults,modespec);var tabSize=options&&options.tabSize||CodeMirror.defaults.tabSize;if(callback.appendChild){var ie=/MSIE \d/.test(navigator.userAgent);var ie_lt9=ie&&
(document.documentMode==null||document.documentMode<9);var node=callback,col=0;node.innerHTML="";callback=function(text,style){if(text=="\n"){node.appendChild(document.createTextNode(ie_lt9?"\r":text));col=0;return}var content="";for(var pos=0;;){var idx=text.indexOf("\t",pos);if(idx==-1){content+=text.slice(pos);col+=text.length-pos;break}else{col+=idx-pos;content+=text.slice(pos,idx);var size=tabSize-col%tabSize;col+=size;for(var i=0;i<size;++i)content+=" ";pos=idx+1}}if(style){var sp=node.appendChild(document.createElement("span"));
sp.className="cm-"+style.replace(/ +/g," cm-");sp.appendChild(document.createTextNode(content))}else node.appendChild(document.createTextNode(content))}}var lines=CodeMirror.splitLines(string),state=options&&options.state||CodeMirror.startState(mode);for(var i=0,e=lines.length;i<e;++i){if(i)callback("\n");var stream=new CodeMirror.StringStream(lines[i],null,{lookAhead:function(n){return lines[i+n]},baseToken:function(){}});if(!stream.string&&mode.blankLine)mode.blankLine(state);while(!stream.eol()){var style=
mode.token(stream,state);callback(stream.current(),style,i,stream.start,state);stream.start=stream.pos}}}});

