/*
 Highstock JS v10.0.0 (2022-03-07)

 Indicator series type for Highcharts Stock

 (c) 2010-2021 Sebastian Bochan

 License: www.highcharts.com/license
*/
(function(f){"object"===typeof module&&module.exports?(f["default"]=f,module.exports=f):"function"===typeof define&&define.amd?define("highcharts/indicators/ichimoku-kinko-hyo",["highcharts","highcharts/modules/stock"],function(m){f(m);f.Highcharts=m;return f}):f("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(f){function m(f,p,r,h){f.hasOwnProperty(p)||(f[p]=h.apply(null,r),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:p,
module:f[p]}})))}f=f?f._modules:{};m(f,"Stock/Indicators/IKH/IKHIndicator.js",[f["Core/Color/Color.js"],f["Core/Globals.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,p,r,h){function m(d){return d.reduce(function(b,a){return Math.max(b,a[1])},-Infinity)}function F(d){return d.reduce(function(b,a){return Math.min(b,a[2])},Infinity)}function x(d){return{high:m(d),low:F(d)}}function G(d){var b,a,n,c,q;d.series.forEach(function(d){if(d.xData)for(c=d.xData,q=a=d.xIncrement?
1:c.length-1;0<q;q--)if(n=c[q]-c[q-1],"undefined"===typeof b||n<b)b=n});return b}function H(d,b,a,n){if(d&&b&&a&&n){var c=b.plotX-d.plotX;b=b.plotY-d.plotY;var q=n.plotX-a.plotX;n=n.plotY-a.plotY;var f=d.plotX-a.plotX,z=d.plotY-a.plotY;a=(-b*f+c*z)/(-q*b+c*n);q=(q*z-n*f)/(-q*b+c*n);if(0<=a&&1>=a&&0<=q&&1>=q)return{plotX:d.plotX+q*c,plotY:d.plotY+q*b}}return!1}function C(d){var b=d.indicator;b.points=d.points;b.nextPoints=d.nextPoints;b.color=d.color;b.options=B(d.options.senkouSpan.styles,d.gap);
b.graph=d.graph;b.fillGraph=!0;r.seriesTypes.sma.prototype.drawGraph.call(b)}var I=this&&this.__extends||function(){var d=function(b,a){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return d(b,a)};return function(b,a){function n(){this.constructor=b}d(b,a);b.prototype=null===a?Object.create(a):(n.prototype=a.prototype,new n)}}(),w=f.parse,D=r.seriesTypes.sma,J=h.defined;f=h.extend;var K=h.isArray,
L=h.isNumber,B=h.merge,M=h.objectEach;p.approximations["ichimoku-averages"]=function(){var d=[],b;[].forEach.call(arguments,function(a,n){d.push(p.approximations.average(a));b=!b&&"undefined"===typeof d[n]});return b?void 0:d};h=function(d){function b(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;a.graphCollection=void 0;a.graphsenkouSpan=void 0;a.ikhMap=void 0;a.nextPoints=void 0;return a}I(b,d);b.prototype.init=function(){r.seriesTypes.sma.prototype.init.apply(this,
arguments);this.options=B({tenkanLine:{styles:{lineColor:this.color}},kijunLine:{styles:{lineColor:this.color}},chikouLine:{styles:{lineColor:this.color}},senkouSpanA:{styles:{lineColor:this.color,fill:w(this.color).setOpacity(.5).get()}},senkouSpanB:{styles:{lineColor:this.color,fill:w(this.color).setOpacity(.5).get()}},senkouSpan:{styles:{fill:w(this.color).setOpacity(.2).get()}}},this.options)};b.prototype.toYData=function(a){return[a.tenkanSen,a.kijunSen,a.chikouSpan,a.senkouSpanA,a.senkouSpanB]};
b.prototype.translate=function(){var a=this;r.seriesTypes.sma.prototype.translate.apply(a);a.points.forEach(function(b){a.pointArrayMap.forEach(function(c){var d=b[c];L(d)&&(b["plot"+c]=a.yAxis.toPixels(d,!0),b.plotY=b["plot"+c],b.tooltipPos=[b.plotX,b["plot"+c]],b.isNull=!1)})})};b.prototype.drawGraph=function(){var a=this,b=a.points,c=b.length,d=a.options,f=a.graph,z=a.color,h={options:{gapSize:d.gapSize}},l=a.pointArrayMap.length,t=[[],[],[],[],[],[]],e={tenkanLine:t[0],kijunLine:t[1],chikouLine:t[2],
senkouSpanA:t[3],senkouSpanB:t[4],senkouSpan:t[5]},y=[],g=a.options.senkouSpan,E=g.color||g.styles.fill,m=g.negativeColor,u=[[],[]],p=[[],[]],x=0,v,w,A;for(a.ikhMap=e;c--;){var k=b[c];for(v=0;v<l;v++)g=a.pointArrayMap[v],J(k[g])&&t[v].push({plotX:k.plotX,plotY:k["plot"+g],isNull:!1});m&&c!==b.length-1&&(g=e.senkouSpanB.length-1,k=H(e.senkouSpanA[g-1],e.senkouSpanA[g],e.senkouSpanB[g-1],e.senkouSpanB[g]),v={plotX:k.plotX,plotY:k.plotY,isNull:!1,intersectPoint:!0},k&&(e.senkouSpanA.splice(g,0,v),e.senkouSpanB.splice(g,
0,v),y.push(g)))}M(e,function(b,c){d[c]&&"senkouSpan"!==c&&(a.points=t[x],a.options=B(d[c].styles,h),a.graph=a["graph"+c],a.fillGraph=!1,a.color=z,r.seriesTypes.sma.prototype.drawGraph.call(a),a["graph"+c]=a.graph);x++});a.graphCollection&&a.graphCollection.forEach(function(c){a[c].destroy();delete a[c]});a.graphCollection=[];if(m&&e.senkouSpanA[0]&&e.senkouSpanB[0]){y.unshift(0);y.push(e.senkouSpanA.length-1);for(l=0;l<y.length-1;l++){g=y[l];k=y[l+1];c=e.senkouSpanB.slice(g,k+1);g=e.senkouSpanA.slice(g,
k+1);if(1<=Math.floor(c.length/2))if(k=Math.floor(c.length/2),c[k].plotY===g[k].plotY){for(A=v=k=0;A<c.length;A++)k+=c[A].plotY,v+=g[A].plotY;k=k>v?0:1}else k=c[k].plotY>g[k].plotY?0:1;else k=c[0].plotY>g[0].plotY?0:1;u[k]=u[k].concat(c);p[k]=p[k].concat(g)}["graphsenkouSpanColor","graphsenkouSpanNegativeColor"].forEach(function(c,b){u[b].length&&p[b].length&&(w=0===b?E:m,C({indicator:a,points:u[b],nextPoints:p[b],color:w,options:d,gap:h,graph:a[c]}),a[c]=a.graph,a.graphCollection.push(c))})}else C({indicator:a,
points:e.senkouSpanB,nextPoints:e.senkouSpanA,color:E,options:d,gap:h,graph:a.graphsenkouSpan}),a.graphsenkouSpan=a.graph;delete a.nextPoints;delete a.fillGraph;a.points=b;a.options=d;a.graph=f;a.color=z};b.prototype.getGraphPath=function(a){var b=[],c;a=a||this.points;if(this.fillGraph&&this.nextPoints){if((c=r.seriesTypes.sma.prototype.getGraphPath.call(this,this.nextPoints))&&c.length){c[0][0]="L";b=r.seriesTypes.sma.prototype.getGraphPath.call(this,a);c=c.slice(0,b.length);for(var d=c.length-
1;0<=d;d--)b.push(c[d])}}else b=r.seriesTypes.sma.prototype.getGraphPath.apply(this,arguments);return b};b.prototype.getValues=function(a,b){var c=b.period,d=b.periodTenkan;b=b.periodSenkouSpanB;var f=a.xData,h=a.yData,n=h&&h.length||0;a=G(a.xAxis);var l=[],t=[],e;if(!(f.length<=c)&&K(h[0])&&4===h[0].length){var p=f[0]-c*a;for(e=0;e<c;e++)t.push(p+e*a);for(e=0;e<n;e++){if(e>=d){var g=h.slice(e-d,e);g=x(g);g=(g.high+g.low)/2}if(e>=c){var m=h.slice(e-c,e);m=x(m);m=(m.high+m.low)/2;var r=(g+m)/2}if(e>=
b){var u=h.slice(e-b,e);u=x(u);u=(u.high+u.low)/2}p=h[e][3];var w=f[e];"undefined"===typeof l[e]&&(l[e]=[]);"undefined"===typeof l[e+c]&&(l[e+c]=[]);l[e+c][0]=g;l[e+c][1]=m;l[e+c][2]=void 0;l[e][2]=p;e<=c&&(l[e+c][3]=void 0,l[e+c][4]=void 0);"undefined"===typeof l[e+2*c]&&(l[e+2*c]=[]);l[e+2*c][3]=r;l[e+2*c][4]=u;t.push(w)}for(e=1;e<=c;e++)t.push(w+e*a);return{values:l,xData:t,yData:l}}};b.defaultOptions=B(D.defaultOptions,{params:{index:void 0,period:26,periodTenkan:9,periodSenkouSpanB:52},marker:{enabled:!1},
tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>TENKAN SEN: {point.tenkanSen:.3f}<br/>KIJUN SEN: {point.kijunSen:.3f}<br/>CHIKOU SPAN: {point.chikouSpan:.3f}<br/>SENKOU SPAN A: {point.senkouSpanA:.3f}<br/>SENKOU SPAN B: {point.senkouSpanB:.3f}<br/>'},tenkanLine:{styles:{lineWidth:1,lineColor:void 0}},kijunLine:{styles:{lineWidth:1,lineColor:void 0}},chikouLine:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanA:{styles:{lineWidth:1,lineColor:void 0}},
senkouSpanB:{styles:{lineWidth:1,lineColor:void 0}},senkouSpan:{styles:{fill:"rgba(255, 0, 0, 0.5)"}},dataGrouping:{approximation:"ichimoku-averages"}});return b}(D);f(h.prototype,{pointArrayMap:["tenkanSen","kijunSen","chikouSpan","senkouSpanA","senkouSpanB"],pointValKey:"tenkanSen",nameComponents:["periodSenkouSpanB","period","periodTenkan"]});r.registerSeriesType("ikh",h);"";return h});m(f,"masters/indicators/ichimoku-kinko-hyo.src.js",[],function(){})});
//# sourceMappingURL=ichimoku-kinko-hyo.js.map