/*
 Highstock JS v10.0.0 (2022-03-07)

 All technical indicators for Highcharts Stock

 (c) 2010-2021 Pawel Fus

 License: www.highcharts.com/license
*/
(function(f){"object"===typeof module&&module.exports?(f["default"]=f,module.exports=f):"function"===typeof define&&define.amd?define("highcharts/indicators/indicators-all",["highcharts","highcharts/modules/stock"],function(v){f(v);f.Highcharts=v;return f}):f("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(f){function v(f,e,g,m){f.hasOwnProperty(e)||(f[e]=m.apply(null,g),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:f[e]}})))}
f=f?f._modules:{};v(f,"Stock/Indicators/SMA/SMAComposition.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){});v(f,"Stock/Indicators/SMA/SMAIndicator.js",[f["Core/Chart/Chart.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var m=this&&this.__extends||function(){var c=function(b,a){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,b){c.__proto__=b}||function(c,b){for(var a in b)b.hasOwnProperty(a)&&(c[a]=b[a])};return c(b,
a)};return function(b,a){function l(){this.constructor=b}c(b,a);b.prototype=null===a?Object.create(a):(l.prototype=a.prototype,new l)}}(),k=e.seriesTypes.line,p=g.addEvent,t=g.error,h=g.extend,d=g.isArray,a=g.merge,b=g.pick,c=g.splat;g=function(l){function w(){var c=null!==l&&l.apply(this,arguments)||this;c.data=void 0;c.dataEventsToUnbind=void 0;c.linkedParent=void 0;c.options=void 0;c.points=void 0;return c}m(w,l);w.prototype.destroy=function(){this.dataEventsToUnbind.forEach(function(c){c()});
l.prototype.destroy.apply(this,arguments)};w.prototype.getName=function(){var c=this.name,a=[];c||((this.nameComponents||[]).forEach(function(c,l){a.push(this.options.params[c]+b(this.nameSuffixes[l],""))},this),c=(this.nameBase||this.type.toUpperCase())+(this.nameComponents?" ("+a.join(", ")+")":""));return c};w.prototype.getValues=function(c,b){var a=b.period,l=c.xData;c=c.yData;var w=c.length,A=0,z=0,h=[],e=[],g=[],f=-1;if(!(l.length<a)){for(d(c[0])&&(f=b.index?b.index:0);A<a-1;)z+=0>f?c[A]:c[A][f],
A++;for(b=A;b<w;b++){z+=0>f?c[b]:c[b][f];var t=[l[b],z/a];h.push(t);e.push(t[0]);g.push(t[1]);z-=0>f?c[b-A]:c[b-A][f]}return{values:h,xData:e,yData:g}}};w.prototype.init=function(c,b){var a=this;l.prototype.init.call(a,c,b);b=p(f,"afterLinkSeries",function(){var b=!!a.dataEventsToUnbind.length;if(a.linkedParent)if(b||(a.dataEventsToUnbind.push(p(a.linkedParent,"updatedData",function(){a.recalculateValues()})),a.calculateOn.xAxis&&a.dataEventsToUnbind.push(p(a.linkedParent.xAxis,a.calculateOn.xAxis,
function(){a.recalculateValues()}))),"init"===a.calculateOn.chart)a.processedYData||a.recalculateValues();else{if(!b)var l=p(a.chart,a.calculateOn.chart,function(){a.recalculateValues();l()})}else return t("Series "+a.options.linkedTo+" not found! Check `linkedTo`.",!1,c)},{order:0});a.dataEventsToUnbind=[];a.eventsToUnbind.push(b)};w.prototype.recalculateValues=function(){var a=this.points||[],b=(this.xData||[]).length,l={values:[],xData:[],yData:[]},d=[],w=!0;l=this.linkedParent.options?this.getValues(this.linkedParent,
this.options.params)||l:l;if(b&&!this.hasGroupedData&&this.visible&&this.points)if(this.cropped){if(this.xAxis){var n=this.xAxis.min;var h=this.xAxis.max}b=this.cropData(l.xData,l.yData,n,h);for(n=0;n<b.xData.length;n++)d.push([b.xData[n]].concat(c(b.yData[n])));b=l.xData.indexOf(this.xData[0]);n=l.xData.indexOf(this.xData[this.xData.length-1]);-1===b&&n===l.xData.length-2&&d[0][0]===a[0].x&&d.shift();this.updateData(d)}else l.xData.length!==b-1&&l.xData.length!==b+1&&(w=!1,this.updateData(l.values));
w&&(this.xData=l.xData,this.yData=l.yData,this.options.data=l.values);this.calculateOn.xAxis&&this.processedXData&&(delete this.processedXData,this.isDirty=!0,this.redraw());this.isDirtyData=!1};w.prototype.processData=function(){var c=this.options.compareToMain,b=this.linkedParent;l.prototype.processData.apply(this,arguments);this.dataModify&&b&&b.dataModify&&b.dataModify.compareValue&&c&&(this.dataModify.compareValue=b.dataModify.compareValue)};w.defaultOptions=a(k.defaultOptions,{name:void 0,tooltip:{valueDecimals:4},
linkedTo:void 0,compareToMain:!1,params:{index:3,period:14}});return w}(k);h(g.prototype,{calculateOn:{chart:"init"},hasDerivedData:!0,nameComponents:["period"],nameSuffixes:[],useCommonDataGrouping:!0});e.registerSeriesType("sma",g);"";return g});v(f,"Stock/Indicators/EMA/EMAIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var h=function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,c){b.__proto__=
c}||function(b,c){for(var a in c)c.hasOwnProperty(a)&&(b[a]=c[a])};return h(d,a)};return function(d,a){function b(){this.constructor=d}h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.sma,k=e.correctFloat,p=e.isArray,t=e.merge;e=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,h);d.prototype.accumulatePeriodPoints=function(a,b,c){for(var l=0,d=0,A;d<a;)A=0>b?c[d]:c[d][b],
l+=A,d++;return l};d.prototype.calculateEma=function(a,b,c,l,d,A,h){a=a[c-1];b=0>A?b[c-1]:b[c-1][A];l="undefined"===typeof d?h:k(b*l+d*(1-l));return[a,l]};d.prototype.getValues=function(a,b){var c=b.period,l=a.xData,d=(a=a.yData)?a.length:0,A=2/(c+1),h=[],e=[],g=[],r=-1;if(!(d<c)){p(a[0])&&(r=b.index?b.index:0);b=this.accumulatePeriodPoints(c,r,a);for(b/=c;c<d+1;c++){var n=this.calculateEma(l,a,c,A,n,r,b);h.push(n);e.push(n[0]);g.push(n[1]);n=n[1]}return{values:h,xData:e,yData:g}}};d.defaultOptions=
t(m.defaultOptions,{params:{index:3,period:9}});return d}(m);f.registerSeriesType("ema",e);"";return e});v(f,"Stock/Indicators/AD/ADIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var h=function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,c){b.__proto__=c}||function(b,c){for(var a in c)c.hasOwnProperty(a)&&(b[a]=c[a])};return h(d,a)};return function(d,a){function b(){this.constructor=d}h(d,
a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.sma,k=e.error,p=e.extend,t=e.merge;e=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,h);d.populateAverage=function(a,b,c,l,d){d=b[l][1];var w=b[l][2];b=b[l][3];c=c[l];return[a[l],b===d&&b===w||d===w?0:(2*b-w-d)/(d-w)*c]};d.prototype.getValues=function(a,b){var c=b.period,l=a.xData,w=a.yData,A=b.volumeSeriesID,h=a.chart.get(A);
b=h&&h.yData;var e=w?w.length:0,g=[],r=[],n=[];if(!(l.length<=c&&e&&4!==w[0].length)){if(h){for(A=c;A<e;A++)a=g.length,h=d.populateAverage(l,w,b,A,c),0<a&&(h[1]+=g[a-1][1]),g.push(h),r.push(h[0]),n.push(h[1]);return{values:g,xData:r,yData:n}}k("Series "+A+" not found! Check `volumeSeriesID`.",!0,a.chart)}};d.defaultOptions=t(m.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume"}});return d}(m);p(e.prototype,{nameComponents:!1,nameBase:"Accumulation/Distribution"});f.registerSeriesType("ad",
e);"";return e});v(f,"Stock/Indicators/AO/AOIndicator.js",[f["Core/Globals.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var m=this&&this.__extends||function(){var b=function(c,a){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,a){c.__proto__=a}||function(c,a){for(var b in a)a.hasOwnProperty(b)&&(c[b]=a[b])};return b(c,a)};return function(c,a){function l(){this.constructor=c}b(c,a);c.prototype=null===a?Object.create(a):(l.prototype=a.prototype,
new l)}}();f=f.noop;var k=e.seriesTypes,p=k.sma;k=k.column;var t=g.extend,h=g.merge,d=g.correctFloat,a=g.isArray;g=function(b){function c(){var c=null!==b&&b.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}m(c,b);c.prototype.drawGraph=function(){var c=this.options,a=this.points,b=c.greaterBarColor;c=c.lowerBarColor;var d=a[0];if(!this.userOptions.color&&d)for(d.color=b,d=1;d<a.length;d++)a[d].color=a[d].y>a[d-1].y?b:a[d].y<a[d-1].y?c:a[d-1].color};c.prototype.getValues=
function(c){var b=c.xData||[];c=c.yData||[];var l=c.length,h=[],e=[],g=[],r=0,n=0,B;if(!(34>=b.length)&&a(c[0])&&4===c[0].length){for(B=0;33>B;B++){var q=(c[B][1]+c[B][2])/2;29<=B&&(r=d(r+q));n=d(n+q)}for(B=33;B<l;B++){q=(c[B][1]+c[B][2])/2;r=d(r+q);n=d(n+q);q=r/5;var u=n/34;q=d(q-u);h.push([b[B],q]);e.push(b[B]);g.push(q);q=B+1-5;u=B+1-34;r=d(r-(c[q][1]+c[q][2])/2);n=d(n-(c[u][1]+c[u][2])/2)}return{values:h,xData:e,yData:g}}};c.defaultOptions=h(p.defaultOptions,{params:{index:void 0,period:void 0},
greaterBarColor:"#06b535",lowerBarColor:"#f21313",threshold:0,groupPadding:.2,pointPadding:.2,crisp:!1,states:{hover:{halo:{size:0}}}});return c}(p);t(g.prototype,{nameBase:"AO",nameComponents:!1,markerAttribs:f,getColumnMetrics:k.prototype.getColumnMetrics,crispCol:k.prototype.crispCol,translate:k.prototype.translate,drawPoints:k.prototype.drawPoints});e.registerSeriesType("ao",g);"";return g});v(f,"Stock/Indicators/MultipleLinesComposition.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],
function(f,e){var g=f.seriesTypes.sma,m=e.defined,k=e.error,p=e.merge,t;(function(h){function d(c){var a,b=[];c=c||this.points;if(this.fillGraph&&this.nextPoints){if((a=g.prototype.getGraphPath.call(this,this.nextPoints))&&a.length){a[0][0]="L";b=g.prototype.getGraphPath.call(this,c);a=a.slice(0,b.length);for(var l=a.length-1;0<=l;l--)b.push(a[l])}}else b=g.prototype.getGraphPath.apply(this,arguments);return b}function a(){var a=this,b=a.linesApiNames,l=a.areaLinesNames,d=a.points,w=a.options,h=a.graph,
A={options:{gapSize:w.gapSize}},e=[],z=a.getTranslatedLinesNames(a.pointValKey),y=d.length,L;z.forEach(function(a,c){for(e[c]=[];y--;)L=d[y],e[c].push({x:L.x,plotX:L.plotX,plotY:L[a],isNull:!m(L[a])});y=d.length});if(this.userOptions.fillColor&&l.length){var t=z.indexOf(c(l[0]));t=e[t];l=1===l.length?d:e[z.indexOf(c(l[1]))];z=a.color;a.points=l;a.nextPoints=t;a.color=this.userOptions.fillColor;a.options=p(d,A);a.graph=a.area;a.fillGraph=!0;f.seriesTypes.sma.prototype.drawGraph.call(a);a.area=a.graph;
delete a.nextPoints;delete a.fillGraph;a.color=z}b.forEach(function(c,b){e[b]?(a.points=e[b],w[c]?a.options=p(w[c].styles,A):k('Error: "There is no '+c+' in DOCS options declared. Check if linesApiNames are consistent with your DOCS line names." at mixin/multiple-line.js:34'),a.graph=a["graph"+c],g.prototype.drawGraph.call(a),a["graph"+c]=a.graph):k('Error: "'+c+" doesn't have equivalent in pointArrayMap. To many elements in linesApiNames relative to pointArrayMap.\"")});a.points=d;a.options=w;a.graph=
h;g.prototype.drawGraph.call(a)}function b(a){var b=[];(this.pointArrayMap||[]).forEach(function(l){l!==a&&b.push(c(l))});return b}function c(a){return"plot"+a.charAt(0).toUpperCase()+a.slice(1)}function l(a){var c=[];(this.pointArrayMap||[]).forEach(function(b){c.push(a[b])});return c}function w(){var a=this,c=a.pointArrayMap,b=[],l;b=a.getTranslatedLinesNames();g.prototype.translate.apply(a,arguments);a.points.forEach(function(d){c.forEach(function(c,w){l=d[c];a.dataModify&&(l=a.dataModify.modifyValue(l));
null!==l&&(d[b[w]]=a.yAxis.toPixels(l,!0))})})}var A=[],e=["bottomLine"],y=["top","bottom"],L=["top"];h.compose=function(c){if(-1===A.indexOf(c)){A.push(c);var h=c.prototype;h.linesApiNames=h.linesApiNames||e.slice();h.pointArrayMap=h.pointArrayMap||y.slice();h.pointValKey=h.pointValKey||"top";h.areaLinesNames=h.areaLinesNames||L.slice();h.drawGraph=a;h.getGraphPath=d;h.toYData=l;h.translate=w;h.getTranslatedLinesNames=b}return c}})(t||(t={}));return t});v(f,"Stock/Indicators/Aroon/AroonIndicator.js",
[f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){function m(a,b){var c=a[0],l=0,d;for(d=1;d<a.length;d++)if("max"===b&&a[d]>=c||"min"===b&&a[d]<=c)c=a[d],l=d;return l}var k=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(b,c)};return function(b,c){function l(){this.constructor=
b}a(b,c);b.prototype=null===c?Object.create(c):(l.prototype=c.prototype,new l)}}(),p=e.seriesTypes.sma,t=g.extend,h=g.merge,d=g.pick;g=function(a){function b(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}k(b,a);b.prototype.getValues=function(a,b){b=b.period;var c=a.xData,l=(a=a.yData)?a.length:0,h=[],e=[],g=[],r;for(r=b-1;r<l;r++){var n=a.slice(r-b+1,r+2);var B=m(n.map(function(a){return d(a[2],a)}),"min");n=m(n.map(function(a){return d(a[1],
a)}),"max");n=n/b*100;B=B/b*100;c[r+1]&&(h.push([c[r+1],n,B]),e.push(c[r+1]),g.push([n,B]))}return{values:h,xData:e,yData:g}};b.defaultOptions=h(p.defaultOptions,{params:{index:void 0,period:25},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Aroon Up: {point.y}<br/>Aroon Down: {point.aroonDown}<br/>'},aroonDown:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}});return b}(p);t(g.prototype,{areaLinesNames:[],
linesApiNames:["aroonDown"],nameBase:"Aroon",pointArrayMap:["y","aroonDown"],pointValKey:"y"});f.compose(g);e.registerSeriesType("aroon",g);"";return g});v(f,"Stock/Indicators/AroonOscillator/AroonOscillatorIndicator.js",[f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var m=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,
b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),k=e.seriesTypes.aroon,p=g.extend,t=g.merge,h=e.seriesTypes.aroon;g=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}m(a,d);a.prototype.getValues=function(a,c){var b=[],d=[],e=[];a=h.prototype.getValues.call(this,a,c);for(c=
0;c<a.yData.length;c++){var z=a.yData[c][0];var y=a.yData[c][1];z-=y;b.push([a.xData[c],z]);d.push(a.xData[c]);e.push(z)}return{values:b,xData:d,yData:e}};a.defaultOptions=t(k.defaultOptions,{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b>: {point.y}'}});return a}(k);p(g.prototype,{nameBase:"Aroon Oscillator",linesApiNames:[],pointArrayMap:["y"],pointValKey:"y"});f.compose(k);e.registerSeriesType("aroonoscillator",g);"";return g});v(f,"Stock/Indicators/ATR/ATRIndicator.js",
[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){function g(h,d){return Math.max(h[1]-h[2],"undefined"===typeof d?0:Math.abs(h[1]-d[3]),"undefined"===typeof d?0:Math.abs(h[2]-d[3]))}var m=this&&this.__extends||function(){var h=function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return h(d,a)};return function(d,a){function b(){this.constructor=d}h(d,a);d.prototype=
null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),k=f.seriesTypes.sma,p=e.isArray,t=e.merge;e=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.data=void 0;a.points=void 0;a.options=void 0;return a}m(d,h);d.prototype.getValues=function(a,b){b=b.period;var c=a.xData,l=(a=a.yData)?a.length:0,d=1,h=0,e=0,y=[],f=[],r=[],n;var B=[[c[0],a[0]]];if(!(c.length<=b)&&p(a[0])&&4===a[0].length){for(n=1;n<=l;n++)if(B.push([c[n],a[n]]),b<d){var q=b;var u=c[n-1],t=g(a[n-1],a[n-
2]);q=[u,(h*(q-1)+t)/q];h=q[1];y.push(q);f.push(q[0]);r.push(q[1])}else b===d?(h=e/(n-1),y.push([c[n-1],h]),f.push(c[n-1]),r.push(h)):e+=g(a[n-1],a[n-2]),d++;return{values:y,xData:f,yData:r}}};d.defaultOptions=t(k.defaultOptions,{params:{index:void 0}});return d}(k);f.registerSeriesType("atr",e);"";return e});v(f,"Stock/Indicators/BB/BBIndicator.js",[f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var m=this&&this.__extends||
function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),k=e.seriesTypes.sma,p=g.extend,t=g.isArray,h=g.merge;g=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;
return a}m(a,d);a.prototype.init=function(){e.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=h({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)};a.prototype.getValues=function(a,c){var b=c.period,d=c.standardDeviation,h=a.xData,z=(a=a.yData)?a.length:0,y=[],f=[],r=[],n;if(!(h.length<b)){var B=t(a[0]);for(n=b;n<=z;n++){var q=h.slice(n-b,n);var u=a.slice(n-b,n);var g=e.seriesTypes.sma.prototype.getValues.call(this,{xData:q,yData:u},
c);q=g.xData[0];g=g.yData[0];for(var m=0,k=u.length,p=0;p<k;p++){var x=(B?u[p][c.index]:u[p])-g;m+=x*x}x=Math.sqrt(m/(k-1));u=g+d*x;x=g-d*x;y.push([q,u,g,x]);f.push(q);r.push([u,g,x])}return{values:y,xData:f,yData:r}}};a.defaultOptions=h(k.defaultOptions,{params:{period:20,standardDeviation:2,index:3},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},
marker:{enabled:!1},dataGrouping:{approximation:"averages"}});return a}(k);p(g.prototype,{areaLinesNames:["top","bottom"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameComponents:["period","standardDeviation"],linesApiNames:["topLine","bottomLine"]});f.compose(g);e.registerSeriesType("bb",g);"";return g});v(f,"Stock/Indicators/CCI/CCIIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){function g(h){return h.reduce(function(d,a){return d+a},0)}
var m=this&&this.__extends||function(){var h=function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return h(d,a)};return function(d,a){function b(){this.constructor=d}h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),k=f.seriesTypes.sma,p=e.isArray,t=e.merge;e=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.data=void 0;a.points=void 0;
a.options=void 0;return a}m(d,h);d.prototype.getValues=function(a,b){b=b.period;var c=a.xData,l=(a=a.yData)?a.length:0,d=[],h=1,e=[],y=[],f=[];if(!(c.length<=b)&&p(a[0])&&4===a[0].length){for(;h<b;){var r=a[h-1];d.push((r[1]+r[2]+r[3])/3);h++}for(h=b;h<=l;h++){r=a[h-1];r=(r[1]+r[2]+r[3])/3;var n=d.push(r);var B=d.slice(n-b);n=g(B)/b;var q,u=B.length,t=0;for(q=0;q<u;q++)t+=Math.abs(n-B[q]);B=t/b;r=(r-n)/(.015*B);e.push([c[h-1],r]);y.push(c[h-1]);f.push(r)}return{values:e,xData:y,yData:f}}};d.defaultOptions=
t(k.defaultOptions,{params:{index:void 0}});return d}(k);f.registerSeriesType("cci",e);"";return e});v(f,"Stock/Indicators/CMF/CMFIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(f,h){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,a){d.__proto__=a}||function(d,a){for(var b in a)a.hasOwnProperty(b)&&(d[b]=a[b])};return e(f,h)};return function(f,h){function d(){this.constructor=f}e(f,h);
f.prototype=null===h?Object.create(h):(d.prototype=h.prototype,new d)}}(),m=f.seriesTypes.sma,k=e.merge;e=function(e){function f(){var h=null!==e&&e.apply(this,arguments)||this;h.data=void 0;h.options=void 0;h.points=void 0;h.volumeSeries=void 0;h.linkedParent=void 0;h.yData=void 0;h.nameBase="Chaikin Money Flow";return h}g(f,e);f.prototype.isValid=function(){var h=this.chart,d=this.options,a=this.linkedParent;h=this.volumeSeries||(this.volumeSeries=h.get(d.params.volumeSeriesID));var b=a&&a.yData&&
4===a.yData[0].length;return!!(a&&h&&a.xData&&a.xData.length>=d.params.period&&h.xData&&h.xData.length>=d.params.period&&b)};f.prototype.getValues=function(h,d){if(this.isValid())return this.getMoneyFlow(h.xData,h.yData,this.volumeSeries.yData,d.period)};f.prototype.getMoneyFlow=function(h,d,a,b){function c(a,c){var b=a[1],l=a[2];a=a[3];return null!==c&&null!==b&&null!==l&&null!==a&&b!==l?(a-l-(b-a))/(b-l)*c:(B=n,null)}var l=d.length,w=[],e=0,z=0,y=[],f=[],r=[],n,B=-1;if(0<b&&b<=l){for(n=0;n<b;n++)w[n]=
c(d[n],a[n]),e+=a[n],z+=w[n];y.push(h[n-1]);f.push(n-B>=b&&0!==e?z/e:null);for(r.push([y[0],f[0]]);n<l;n++){w[n]=c(d[n],a[n]);e-=a[n-b];e+=a[n];z-=w[n-b];z+=w[n];var q=[h[n],n-B>=b?z/e:null];y.push(q[0]);f.push(q[1]);r.push([q[0],q[1]])}}return{values:r,xData:y,yData:f}};f.defaultOptions=k(m.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume"}});return f}(m);f.registerSeriesType("cmf",e);"";return e});v(f,"Stock/Indicators/DMI/DMIIndicator.js",[f["Stock/Indicators/MultipleLinesComposition.js"],
f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var m=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(b,c)};return function(b,c){function l(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(l.prototype=c.prototype,new l)}}(),k=e.seriesTypes.sma,p=g.correctFloat,t=g.extend,h=g.isArray,d=g.merge;
g=function(a){function b(){var c=null!==a&&a.apply(this,arguments)||this;c.options=void 0;return c}m(b,a);b.prototype.calculateDM=function(a,b,d){var c=a[b][1],l=a[b][2],w=a[b-1][1];a=a[b-1][2];return p(c-w>a-l?d?Math.max(c-w,0):0:d?0:Math.max(a-l,0))};b.prototype.calculateDI=function(a,b){return a/b*100};b.prototype.calculateDX=function(a,b){return p(Math.abs(a-b)/Math.abs(a+b)*100)};b.prototype.smoothValues=function(a,b,d){return p(a-a/d+b)};b.prototype.getTR=function(a,b){return p(Math.max(a[1]-
a[2],b?Math.abs(a[1]-b[3]):0,b?Math.abs(a[2]-b[3]):0))};b.prototype.getValues=function(a,b){b=b.period;var c=a.xData,l=(a=a.yData)?a.length:0,d=[],e=[],f=[];if(!(c.length<=b)&&h(a[0])&&4===a[0].length){var r=0,n=0,B=0,q;for(q=1;q<l;q++)if(q<=b){var u=this.calculateDM(a,q,!0);var g=this.calculateDM(a,q);var m=this.getTR(a[q],a[q-1]);r+=u;n+=g;B+=m;q===b&&(m=this.calculateDI(r,B),g=this.calculateDI(n,B),u=this.calculateDX(r,n),d.push([c[q],u,m,g]),e.push(c[q]),f.push([u,m,g]))}else u=this.calculateDM(a,
q,!0),g=this.calculateDM(a,q),m=this.getTR(a[q],a[q-1]),r=this.smoothValues(r,u,b),n=this.smoothValues(n,g,b),B=this.smoothValues(B,m,b),m=this.calculateDI(r,B),g=this.calculateDI(n,B),u=this.calculateDX(r,n),d.push([c[q],u,m,g]),e.push(c[q]),f.push([u,m,g]);return{values:d,xData:e,yData:f}}};b.defaultOptions=d(k.defaultOptions,{params:{index:void 0},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color: {point.color}">\u25cf</span><b> {series.name}</b><br/><span style="color: {point.color}">DX</span>: {point.y}<br/><span style="color: {point.series.options.plusDILine.styles.lineColor}">+DI</span>: {point.plusDI}<br/><span style="color: {point.series.options.minusDILine.styles.lineColor}">-DI</span>: {point.minusDI}<br/>'},
plusDILine:{styles:{lineWidth:1,lineColor:"#06b535"}},minusDILine:{styles:{lineWidth:1,lineColor:"#f21313"}},dataGrouping:{approximation:"averages"}});return b}(k);t(g.prototype,{areaLinesNames:[],nameBase:"DMI",linesApiNames:["plusDILine","minusDILine"],pointArrayMap:["y","plusDI","minusDI"],parallelArrays:["x","y","plusDI","minusDI"],pointValKey:"y"});f.compose(g);e.registerSeriesType("dmi",g);"";return g});v(f,"Stock/Indicators/DPO/DPOIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],
function(f,e){function g(a,b,c,l,w){b=d(b[c][l],b[c]);return w?h(a-b):h(a+b)}var m=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function l(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(l.prototype=c.prototype,new l)}}(),k=f.seriesTypes.sma,p=e.extend,t=e.merge,h=e.correctFloat,d=e.pick;
e=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.options=void 0;b.data=void 0;b.points=void 0;return b}m(b,a);b.prototype.getValues=function(a,b){var c=b.period;b=b.index;var l=c+Math.floor(c/2+1),h=a.xData||[];a=a.yData||[];var e=a.length,f=[],r=[],n=[],B=0,q,u;if(!(h.length<=l)){for(q=0;q<c-1;q++)B=g(B,a,q,b);for(u=0;u<=e-l;u++){var m=u+c-1;q=u+l-1;B=g(B,a,m,b);m=d(a[q][b],a[q]);m-=B/c;B=g(B,a,u,b,!0);f.push([h[q],m]);r.push(h[q]);n.push(m)}return{values:f,xData:r,yData:n}}};
b.defaultOptions=t(k.defaultOptions,{params:{index:0,period:21}});return b}(k);p(e.prototype,{nameBase:"DPO"});f.registerSeriesType("dpo",e);"";return e});v(f,"Stock/Indicators/Chaikin/ChaikinIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};
return function(b,c){function l(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(l.prototype=c.prototype,new l)}}(),m=f.seriesTypes,k=m.ad,p=m.ema,t=e.correctFloat;m=e.extend;var h=e.merge,d=e.error;e=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}g(b,a);b.prototype.getValues=function(a,b){var c=b.periods,l=b.period,h=[],e=[],f=[],r;if(2!==c.length||c[1]<=c[0])d('Error: "Chaikin requires two periods. Notice, first period should be lower than the second one."');
else if(b=k.prototype.getValues.call(this,a,{volumeSeriesID:b.volumeSeriesID,period:l}))if(a=p.prototype.getValues.call(this,b,{period:c[0]}),b=p.prototype.getValues.call(this,b,{period:c[1]}),a&&b){c=c[1]-c[0];for(r=0;r<b.yData.length;r++)l=t(a.yData[r+c]-b.yData[r]),h.push([b.xData[r],l]),e.push(b.xData[r]),f.push(l);return{values:h,xData:e,yData:f}}};b.defaultOptions=h(p.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume",period:9,periods:[3,10]}});return b}(p);m(e.prototype,{nameBase:"Chaikin Osc",
nameComponents:["periods"]});f.registerSeriesType("chaikin",e);"";return e});v(f,"Stock/Indicators/CMO/CMOIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(h,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(h,d)};return function(h,d){function a(){this.constructor=h}e(h,d);h.prototype=null===d?Object.create(d):
(a.prototype=d.prototype,new a)}}(),m=f.seriesTypes.sma,k=e.isNumber,p=e.merge;e=function(e){function h(){var d=null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}g(h,e);h.prototype.getValues=function(d,a){var b=a.period,c=d.xData,l=d.yData;d=l?l.length:0;var h=[],e=[],f=[],y,g=a.index;if(!(c.length<b)){k(l[0])?a=l:(g=Math.min(g,l[0].length-1),a=l.map(function(a){return a[g]}));var r=0,n=l=0;for(y=b;0<y;y--)a[y]>a[y-1]?l+=a[y]-a[y-1]:a[y]<a[y-1]&&(n+=a[y-
1]-a[y]);r=0<l+n?100*(l-n)/(l+n):0;e.push(c[b]);f.push(r);h.push([c[b],r]);for(y=b+1;y<d;y++)r=Math.abs(a[y-b-1]-a[y-b]),a[y]>a[y-1]?l+=a[y]-a[y-1]:a[y]<a[y-1]&&(n+=a[y-1]-a[y]),a[y-b]>a[y-b-1]?l-=r:n-=r,r=0<l+n?100*(l-n)/(l+n):0,e.push(c[y]),f.push(r),h.push([c[y],r]);return{values:h,xData:e,yData:f}}};h.defaultOptions=p(m.defaultOptions,{params:{period:20,index:3}});return h}(m);f.registerSeriesType("cmo",e);"";return e});v(f,"Stock/Indicators/DEMA/DEMAIndicator.js",[f["Core/Series/SeriesRegistry.js"],
f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var h=function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return h(d,a)};return function(d,a){function b(){this.constructor=d}h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.ema,k=e.correctFloat,p=e.isArray,t=e.merge;e=function(h){function d(){var a=null!==h&&h.apply(this,
arguments)||this;a.EMApercent=void 0;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,h);d.prototype.getEMA=function(a,b,c,l,d,h){return m.prototype.calculateEma(h||[],a,"undefined"===typeof d?1:d,this.EMApercent,b,"undefined"===typeof l?-1:l,c)};d.prototype.getValues=function(a,b){var c=b.period,l=2*c,d=a.xData,h=(a=a.yData)?a.length:0,e=-1,f=[],g=[],r=[],n=0,B=[],q;this.EMApercent=2/(c+1);if(!(h<2*c-1)){p(a[0])&&(e=b.index?b.index:0);b=m.prototype.accumulatePeriodPoints(c,e,a);var u=
b/c;b=0;for(q=c;q<h+2;q++){q<h+1&&(n=this.getEMA(a,t,u,e,q)[1],B.push(n));var t=n;if(q<l)b+=n;else{q===l&&(u=b/c);n=B[q-c-1];var J=this.getEMA([n],J,u)[1];var x=[d[q-2],k(2*n-J)];f.push(x);g.push(x[0]);r.push(x[1])}}return{values:f,xData:g,yData:r}}};d.defaultOptions=t(m.defaultOptions);return d}(m);f.registerSeriesType("dema",e);"";return e});v(f,"Stock/Indicators/TEMA/TEMAIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var h=
function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return h(d,a)};return function(d,a){function b(){this.constructor=d}h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.ema,k=e.correctFloat,p=e.isArray,t=e.merge;e=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.EMApercent=void 0;a.data=void 0;a.options=void 0;a.points=
void 0;return a}g(d,h);d.prototype.getEMA=function(a,b,c,l,d,h){return m.prototype.calculateEma(h||[],a,"undefined"===typeof d?1:d,this.EMApercent,b,"undefined"===typeof l?-1:l,c)};d.prototype.getTemaPoint=function(a,b,c,l){return[a[l-3],k(3*c.level1-3*c.level2+c.level3)]};d.prototype.getValues=function(a,b){var c=b.period,l=2*c,d=3*c,h=a.xData,e=(a=a.yData)?a.length:0,f=-1,g=[],r=[],n=[],B=[],q=[],u,t,k={};this.EMApercent=2/(c+1);if(!(e<3*c-2)){p(a[0])&&(f=b.index?b.index:0);b=m.prototype.accumulatePeriodPoints(c,
f,a);var x=b/c;b=0;for(u=c;u<e+3;u++){u<e+1&&(k.level1=this.getEMA(a,F,x,f,u)[1],B.push(k.level1));var F=k.level1;if(u<l)b+=k.level1;else{u===l&&(x=b/c,b=0);k.level1=B[u-c-1];k.level2=this.getEMA([k.level1],Q,x)[1];q.push(k.level2);var Q=k.level2;if(u<d)b+=k.level2;else{u===d&&(x=b/c);u===e+1&&(k.level1=B[u-c-1],k.level2=this.getEMA([k.level1],Q,x)[1],q.push(k.level2));k.level1=B[u-c-2];k.level2=q[u-2*c-1];k.level3=this.getEMA([k.level2],k.prevLevel3,x)[1];if(t=this.getTemaPoint(h,d,k,u))g.push(t),
r.push(t[0]),n.push(t[1]);k.prevLevel3=k.level3}}}return{values:g,xData:r,yData:n}}};d.defaultOptions=t(m.defaultOptions);return d}(m);f.registerSeriesType("tema",e);"";return e});v(f,"Stock/Indicators/TRIX/TRIXIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(h,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=
b[c])};return e(h,d)};return function(h,d){function a(){this.constructor=h}e(h,d);h.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),m=f.seriesTypes.tema,k=e.correctFloat,p=e.merge;e=function(e){function h(){var d=null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}g(h,e);h.prototype.getTemaPoint=function(d,a,b,c){if(c>a)return[d[c-3],0!==b.prevLevel3?k(b.level3-b.prevLevel3)/b.prevLevel3*100:null]};h.defaultOptions=p(m.defaultOptions);
return h}(m);f.registerSeriesType("trix",e);"";return e});v(f,"Stock/Indicators/APO/APOIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var h=function(d,a){h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return h(d,a)};return function(d,a){function b(){this.constructor=d}h(d,a);d.prototype=null===a?Object.create(a):(b.prototype=
a.prototype,new b)}}(),m=f.seriesTypes.ema,k=e.extend,p=e.merge,t=e.error;e=function(h){function d(){var a=null!==h&&h.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,h);d.prototype.getValues=function(a,b){var c=b.periods,l=b.index;b=[];var d=[],h=[],e;if(2!==c.length||c[1]<=c[0])t('Error: "APO requires two periods. Notice, first period should be lower than the second one."');else{var f=m.prototype.getValues.call(this,a,{index:l,period:c[0]});a=m.prototype.getValues.call(this,
a,{index:l,period:c[1]});if(f&&a){c=c[1]-c[0];for(e=0;e<a.yData.length;e++)l=f.yData[e+c]-a.yData[e],b.push([a.xData[e],l]),d.push(a.xData[e]),h.push(l);return{values:b,xData:d,yData:h}}}};d.defaultOptions=p(m.defaultOptions,{params:{period:void 0,periods:[10,20]}});return d}(m);k(e.prototype,{nameBase:"APO",nameComponents:["periods"]});f.registerSeriesType("apo",e);"";return e});v(f,"Stock/Indicators/IKH/IKHIndicator.js",[f["Core/Color/Color.js"],f["Core/Globals.js"],f["Core/Series/SeriesRegistry.js"],
f["Core/Utilities.js"]],function(f,e,g,m){function k(a){return a.reduce(function(a,b){return Math.max(a,b[1])},-Infinity)}function p(a){return a.reduce(function(a,b){return Math.min(a,b[2])},Infinity)}function t(a){return{high:k(a),low:p(a)}}function h(a){var b,c,l,d,e;a.series.forEach(function(a){if(a.xData)for(d=a.xData,e=c=a.xIncrement?1:d.length-1;0<e;e--)if(l=d[e]-d[e-1],"undefined"===typeof b||l<b)b=l});return b}function d(a,b,c,l){if(a&&b&&c&&l){var d=b.plotX-a.plotX;b=b.plotY-a.plotY;var e=
l.plotX-c.plotX;l=l.plotY-c.plotY;var h=a.plotX-c.plotX,w=a.plotY-c.plotY;c=(-b*h+d*w)/(-e*b+d*l);e=(e*w-l*h)/(-e*b+d*l);if(0<=c&&1>=c&&0<=e&&1>=e)return{plotX:a.plotX+e*d,plotY:a.plotY+e*b}}return!1}function a(a){var b=a.indicator;b.points=a.points;b.nextPoints=a.nextPoints;b.color=a.color;b.options=y(a.options.senkouSpan.styles,a.gap);b.graph=a.graph;b.fillGraph=!0;g.seriesTypes.sma.prototype.drawGraph.call(b)}var b=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function l(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(l.prototype=c.prototype,new l)}}(),c=f.parse,l=g.seriesTypes.sma,w=m.defined;f=m.extend;var A=m.isArray,z=m.isNumber,y=m.merge,L=m.objectEach;e.approximations["ichimoku-averages"]=function(){var a=[],b;[].forEach.call(arguments,function(c,l){a.push(e.approximations.average(c));b=!b&&"undefined"===
typeof a[l]});return b?void 0:a};m=function(e){function f(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;a.graphCollection=void 0;a.graphsenkouSpan=void 0;a.ikhMap=void 0;a.nextPoints=void 0;return a}b(f,e);f.prototype.init=function(){g.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=y({tenkanLine:{styles:{lineColor:this.color}},kijunLine:{styles:{lineColor:this.color}},chikouLine:{styles:{lineColor:this.color}},senkouSpanA:{styles:{lineColor:this.color,
fill:c(this.color).setOpacity(.5).get()}},senkouSpanB:{styles:{lineColor:this.color,fill:c(this.color).setOpacity(.5).get()}},senkouSpan:{styles:{fill:c(this.color).setOpacity(.2).get()}}},this.options)};f.prototype.toYData=function(a){return[a.tenkanSen,a.kijunSen,a.chikouSpan,a.senkouSpanA,a.senkouSpanB]};f.prototype.translate=function(){var a=this;g.seriesTypes.sma.prototype.translate.apply(a);a.points.forEach(function(b){a.pointArrayMap.forEach(function(c){var l=b[c];z(l)&&(b["plot"+c]=a.yAxis.toPixels(l,
!0),b.plotY=b["plot"+c],b.tooltipPos=[b.plotX,b["plot"+c]],b.isNull=!1)})})};f.prototype.drawGraph=function(){var b=this,c=b.points,l=c.length,e=b.options,h=b.graph,f=b.color,A={options:{gapSize:e.gapSize}},n=b.pointArrayMap.length,r=[[],[],[],[],[],[]],z={tenkanLine:r[0],kijunLine:r[1],chikouLine:r[2],senkouSpanA:r[3],senkouSpanB:r[4],senkouSpan:r[5]},m=[],k=b.options.senkouSpan,t=k.color||k.styles.fill,p=k.negativeColor,x=[[],[]],v=[[],[]],R=0,K,S,O;for(b.ikhMap=z;l--;){var D=c[l];for(K=0;K<n;K++)k=
b.pointArrayMap[K],w(D[k])&&r[K].push({plotX:D.plotX,plotY:D["plot"+k],isNull:!1});p&&l!==c.length-1&&(k=z.senkouSpanB.length-1,D=d(z.senkouSpanA[k-1],z.senkouSpanA[k],z.senkouSpanB[k-1],z.senkouSpanB[k]),K={plotX:D.plotX,plotY:D.plotY,isNull:!1,intersectPoint:!0},D&&(z.senkouSpanA.splice(k,0,K),z.senkouSpanB.splice(k,0,K),m.push(k)))}L(z,function(a,c){e[c]&&"senkouSpan"!==c&&(b.points=r[R],b.options=y(e[c].styles,A),b.graph=b["graph"+c],b.fillGraph=!1,b.color=f,g.seriesTypes.sma.prototype.drawGraph.call(b),
b["graph"+c]=b.graph);R++});b.graphCollection&&b.graphCollection.forEach(function(a){b[a].destroy();delete b[a]});b.graphCollection=[];if(p&&z.senkouSpanA[0]&&z.senkouSpanB[0]){m.unshift(0);m.push(z.senkouSpanA.length-1);for(n=0;n<m.length-1;n++){k=m[n];D=m[n+1];l=z.senkouSpanB.slice(k,D+1);k=z.senkouSpanA.slice(k,D+1);if(1<=Math.floor(l.length/2))if(D=Math.floor(l.length/2),l[D].plotY===k[D].plotY){for(O=K=D=0;O<l.length;O++)D+=l[O].plotY,K+=k[O].plotY;D=D>K?0:1}else D=l[D].plotY>k[D].plotY?0:1;
else D=l[0].plotY>k[0].plotY?0:1;x[D]=x[D].concat(l);v[D]=v[D].concat(k)}["graphsenkouSpanColor","graphsenkouSpanNegativeColor"].forEach(function(c,l){x[l].length&&v[l].length&&(S=0===l?t:p,a({indicator:b,points:x[l],nextPoints:v[l],color:S,options:e,gap:A,graph:b[c]}),b[c]=b.graph,b.graphCollection.push(c))})}else a({indicator:b,points:z.senkouSpanB,nextPoints:z.senkouSpanA,color:t,options:e,gap:A,graph:b.graphsenkouSpan}),b.graphsenkouSpan=b.graph;delete b.nextPoints;delete b.fillGraph;b.points=
c;b.options=e;b.graph=h;b.color=f};f.prototype.getGraphPath=function(a){var b=[],c;a=a||this.points;if(this.fillGraph&&this.nextPoints){if((c=g.seriesTypes.sma.prototype.getGraphPath.call(this,this.nextPoints))&&c.length){c[0][0]="L";b=g.seriesTypes.sma.prototype.getGraphPath.call(this,a);c=c.slice(0,b.length);for(var l=c.length-1;0<=l;l--)b.push(c[l])}}else b=g.seriesTypes.sma.prototype.getGraphPath.apply(this,arguments);return b};f.prototype.getValues=function(a,b){var c=b.period,l=b.periodTenkan;
b=b.periodSenkouSpanB;var d=a.xData,e=a.yData,w=e&&e.length||0;a=h(a.xAxis);var f=[],z=[],n;if(!(d.length<=c)&&A(e[0])&&4===e[0].length){var r=d[0]-c*a;for(n=0;n<c;n++)z.push(r+n*a);for(n=0;n<w;n++){if(n>=l){var g=e.slice(n-l,n);g=t(g);g=(g.high+g.low)/2}if(n>=c){var y=e.slice(n-c,n);y=t(y);y=(y.high+y.low)/2;var q=(g+y)/2}if(n>=b){var k=e.slice(n-b,n);k=t(k);k=(k.high+k.low)/2}r=e[n][3];var m=d[n];"undefined"===typeof f[n]&&(f[n]=[]);"undefined"===typeof f[n+c]&&(f[n+c]=[]);f[n+c][0]=g;f[n+c][1]=
y;f[n+c][2]=void 0;f[n][2]=r;n<=c&&(f[n+c][3]=void 0,f[n+c][4]=void 0);"undefined"===typeof f[n+2*c]&&(f[n+2*c]=[]);f[n+2*c][3]=q;f[n+2*c][4]=k;z.push(m)}for(n=1;n<=c;n++)z.push(m+n*a);return{values:f,xData:z,yData:f}}};f.defaultOptions=y(l.defaultOptions,{params:{index:void 0,period:26,periodTenkan:9,periodSenkouSpanB:52},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>TENKAN SEN: {point.tenkanSen:.3f}<br/>KIJUN SEN: {point.kijunSen:.3f}<br/>CHIKOU SPAN: {point.chikouSpan:.3f}<br/>SENKOU SPAN A: {point.senkouSpanA:.3f}<br/>SENKOU SPAN B: {point.senkouSpanB:.3f}<br/>'},
tenkanLine:{styles:{lineWidth:1,lineColor:void 0}},kijunLine:{styles:{lineWidth:1,lineColor:void 0}},chikouLine:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanA:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanB:{styles:{lineWidth:1,lineColor:void 0}},senkouSpan:{styles:{fill:"rgba(255, 0, 0, 0.5)"}},dataGrouping:{approximation:"ichimoku-averages"}});return f}(l);f(m.prototype,{pointArrayMap:["tenkanSen","kijunSen","chikouSpan","senkouSpanA","senkouSpanB"],pointValKey:"tenkanSen",nameComponents:["periodSenkouSpanB",
"period","periodTenkan"]});g.registerSeriesType("ikh",m);"";return m});v(f,"Stock/Indicators/KeltnerChannels/KeltnerChannelsIndicator.js",[f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var m=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(a,b)};return function(a,
b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),k=e.seriesTypes.sma,p=g.correctFloat,t=g.extend,h=g.merge;g=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}m(a,d);a.prototype.init=function(){e.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=h({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)};
a.prototype.getValues=function(a,c){var b=c.period,d=c.periodATR,h=c.multiplierATR,f=a.yData;f=f?f.length:0;var g=[];c=e.seriesTypes.ema.prototype.getValues(a,{period:b,index:c.index});var k=e.seriesTypes.atr.prototype.getValues(a,{period:d}),r=[],n=[],m;if(!(f<b)){for(m=b;m<=f;m++){var q=c.values[m-b];var u=k.values[m-d];var t=q[0];a=p(q[1]+h*u[1]);u=p(q[1]-h*u[1]);q=q[1];g.push([t,a,q,u]);r.push(t);n.push([a,q,u])}return{values:g,xData:r,yData:n}}};a.defaultOptions=h(k.defaultOptions,{params:{index:0,
period:20,periodATR:10,multiplierATR:2},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Upper Channel: {point.top}<br/>EMA({series.options.params.period}): {point.middle}<br/>Lower Channel: {point.bottom}<br/>'},marker:{enabled:!1},dataGrouping:{approximation:"averages"},lineWidth:1});return a}(k);t(g.prototype,{nameBase:"Keltner Channels",areaLinesNames:["top",
"bottom"],nameComponents:["period","periodATR","multiplierATR"],linesApiNames:["topLine","bottomLine"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"});f.compose(g);e.registerSeriesType("keltnerchannels",g);"";return g});v(f,"Stock/Indicators/Klinger/KlingerIndicator.js",[f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var m=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function l(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(l.prototype=c.prototype,new l)}}(),k=e.seriesTypes,p=k.sma,t=k.ema,h=g.correctFloat,d=g.error;k=g.extend;var a=g.isArray,b=g.merge;g=function(c){function l(){var a=null!==c&&c.apply(this,arguments)||this;a.data=void 0;a.points=void 0;a.options=void 0;a.volumeSeries=void 0;return a}m(l,c);
l.prototype.calculateTrend=function(a,b){return a[b][1]+a[b][2]+a[b][3]>a[b-1][1]+a[b-1][2]+a[b-1][3]?1:-1};l.prototype.isValidData=function(b){var c=this.chart,l=this.options,e=this.linkedParent;b=a(b)&&4===b.length;(c=this.volumeSeries||(this.volumeSeries=c.get(l.params.volumeSeriesID)))||d("Series "+l.params.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,e.chart);return!(![e,c].every(function(a){return a&&a.xData&&a.xData.length>=l.params.slowAvgPeriod})||!b)};l.prototype.getCM=function(a,
b,c,l,d){return h(b+(c===l?a:d))};l.prototype.getDM=function(a,b){return h(a-b)};l.prototype.getVolumeForce=function(a){var b=[],c=1;var l=0;var d=a[0][1]-a[0][2];var e=0;for(c;c<a.length;c++){var h=this.calculateTrend(a,c);var f=this.getDM(a[c][1],a[c][2]);l=this.getCM(l,f,h,e,d);e=this.volumeSeries.yData[c]*h*Math.abs(2*(f/l-1))*100;b.push([e]);e=h;d=f}return b};l.prototype.getEMA=function(a,b,c,l,d,e,h){return t.prototype.calculateEma(h||[],a,"undefined"===typeof e?1:e,l,b,"undefined"===typeof d?
-1:d,c)};l.prototype.getSMA=function(a,b,c){return t.prototype.accumulatePeriodPoints(a,b,c)/a};l.prototype.getValues=function(a,b){var c=[],l=a.xData;a=a.yData;var d=[],e=[],f=[],w,g=0,A=0,k=void 0,m=void 0,t=null;if(this.isValidData(a[0])){var p=this.getVolumeForce(a),x=this.getSMA(b.fastAvgPeriod,0,p),C=this.getSMA(b.slowAvgPeriod,0,p),N=2/(b.fastAvgPeriod+1),v=2/(b.slowAvgPeriod+1);for(g;g<a.length;g++)g>=b.fastAvgPeriod&&(k=A=this.getEMA(p,k,x,N,0,g,l)[1]),g>=b.slowAvgPeriod&&(m=w=this.getEMA(p,
m,C,v,0,g,l)[1],w=h(A-w),f.push(w),f.length>=b.signalPeriod&&(t=f.slice(-b.signalPeriod).reduce(function(a,b){return a+b})/b.signalPeriod),c.push([l[g],w,t]),d.push(l[g]),e.push([w,t]));return{values:c,xData:d,yData:e}}};l.defaultOptions=b(p.defaultOptions,{params:{fastAvgPeriod:34,slowAvgPeriod:55,signalPeriod:13,volumeSeriesID:"volume"},signalLine:{styles:{lineWidth:1,lineColor:"#ff0000"}},dataGrouping:{approximation:"averages"},tooltip:{pointFormat:'<span style="color: {point.color}">\u25cf</span><b> {series.name}</b><br/><span style="color: {point.color}">Klinger</span>: {point.y}<br/><span style="color: {point.series.options.signalLine.styles.lineColor}">Signal</span>: {point.signal}<br/>'}});
return l}(p);k(g.prototype,{areaLinesNames:[],linesApiNames:["signalLine"],nameBase:"Klinger",nameComponents:["fastAvgPeriod","slowAvgPeriod"],pointArrayMap:["y","signal"],parallelArrays:["x","y","signal"],pointValKey:"y"});f.compose(g);e.registerSeriesType("klinger",g);"";return g});v(f,"Stock/Indicators/MACD/MACDIndicator.js",[f["Core/Globals.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var m=this&&this.__extends||function(){var a=function(b,l){a=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,l)};return function(b,l){function c(){this.constructor=b}a(b,l);b.prototype=null===l?Object.create(l):(c.prototype=l.prototype,new c)}}(),k=f.noop,p=e.seriesTypes.sma,t=g.extend,h=g.correctFloat,d=g.defined,a=g.merge;g=function(b){function c(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;a.currentLineZone=void 0;a.graphmacd=
void 0;a.graphsignal=void 0;a.macdZones=void 0;a.signalZones=void 0;return a}m(c,b);c.prototype.init=function(){e.seriesTypes.sma.prototype.init.apply(this,arguments);this.options&&(this.options=a({signalLine:{styles:{lineColor:this.color}},macdLine:{styles:{color:this.color}}},this.options),this.macdZones={zones:this.options.macdLine.zones,startIndex:0},this.signalZones={zones:this.macdZones.zones.concat(this.options.signalLine.zones),startIndex:this.macdZones.zones.length},this.resetZones=!0)};
c.prototype.toYData=function(a){return[a.y,a.signal,a.MACD]};c.prototype.translate=function(){var a=this,b=["plotSignal","plotMACD"];f.seriesTypes.column.prototype.translate.apply(a);a.points.forEach(function(c){[c.signal,c.MACD].forEach(function(l,d){null!==l&&(c[b[d]]=a.yAxis.toPixels(l,!0))})})};c.prototype.destroy=function(){this.graph=null;this.graphmacd=this.graphmacd&&this.graphmacd.destroy();this.graphsignal=this.graphsignal&&this.graphsignal.destroy();e.seriesTypes.sma.prototype.destroy.apply(this,
arguments)};c.prototype.drawGraph=function(){for(var b=this,c=b.points,h=c.length,f=b.options,g=b.zones,k={options:{gapSize:f.gapSize}},r=[[],[]],n;h--;)n=c[h],d(n.plotMACD)&&r[0].push({plotX:n.plotX,plotY:n.plotMACD,isNull:!d(n.plotMACD)}),d(n.plotSignal)&&r[1].push({plotX:n.plotX,plotY:n.plotSignal,isNull:!d(n.plotMACD)});["macd","signal"].forEach(function(c,l){b.points=r[l];b.options=a(f[c+"Line"].styles,k);b.graph=b["graph"+c];b.currentLineZone=c+"Zones";b.zones=b[b.currentLineZone].zones;e.seriesTypes.sma.prototype.drawGraph.call(b);
b["graph"+c]=b.graph});b.points=c;b.options=f;b.zones=g;b.currentLineZone=null};c.prototype.getZonesGraphs=function(a){var c=b.prototype.getZonesGraphs.call(this,a),l=c;this.currentLineZone&&(l=c.splice(this[this.currentLineZone].startIndex+1),l.length?l.splice(0,0,a[0]):l=[a[0]]);return l};c.prototype.applyZones=function(){var a=this.zones;this.zones=this.signalZones.zones;e.seriesTypes.sma.prototype.applyZones.call(this);this.graphmacd&&this.options.macdLine.zones.length&&this.graphmacd.hide();
this.zones=a};c.prototype.getValues=function(a,b){var c=b.longPeriod-b.shortPeriod,l=0,f=[],g=[],r=[];if(!(a.xData.length<b.longPeriod+b.signalPeriod)){var n=e.seriesTypes.ema.prototype.getValues(a,{period:b.shortPeriod,index:b.index});var w=e.seriesTypes.ema.prototype.getValues(a,{period:b.longPeriod,index:b.index});n=n.values;w=w.values;for(a=0;a<=n.length;a++)d(w[a])&&d(w[a][1])&&d(n[a+c])&&d(n[a+c][0])&&f.push([n[a+c][0],0,null,n[a+c][1]-w[a][1]]);for(a=0;a<f.length;a++)g.push(f[a][0]),r.push([0,
null,f[a][3]]);b=e.seriesTypes.ema.prototype.getValues({xData:g,yData:r},{period:b.signalPeriod,index:2});b=b.values;for(a=0;a<f.length;a++)f[a][0]>=b[0][0]&&(f[a][2]=b[l][1],r[a]=[0,b[l][1],f[a][3]],null===f[a][3]?(f[a][1]=0,r[a][0]=0):(f[a][1]=h(f[a][3]-b[l][1]),r[a][0]=h(f[a][3]-b[l][1])),l++);return{values:f,xData:g,yData:r}}};c.defaultOptions=a(p.defaultOptions,{params:{shortPeriod:12,longPeriod:26,signalPeriod:9,period:26},signalLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},macdLine:{zones:[],
styles:{lineWidth:1,lineColor:void 0}},threshold:0,groupPadding:.1,pointPadding:.1,crisp:!1,states:{hover:{halo:{size:0}}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Value: {point.MACD}<br/>Signal: {point.signal}<br/>Histogram: {point.y}<br/>'},dataGrouping:{approximation:"averages"},minPointLength:0});return c}(p);t(g.prototype,{nameComponents:["longPeriod","shortPeriod","signalPeriod"],pointArrayMap:["y","signal","MACD"],parallelArrays:["x","y",
"signal","MACD"],pointValKey:"y",markerAttribs:k,getColumnMetrics:f.seriesTypes.column.prototype.getColumnMetrics,crispCol:f.seriesTypes.column.prototype.crispCol,drawPoints:f.seriesTypes.column.prototype.drawPoints});e.registerSeriesType("macd",g);"";return g});v(f,"Stock/Indicators/MFI/MFIIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){function g(a){return a.reduce(function(a,b){return a+b})}function m(a){return(a[1]+a[2]+a[3])/3}var k=this&&this.__extends||
function(){var a=function(b,d){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,d)};return function(b,d){function c(){this.constructor=b}a(b,d);b.prototype=null===d?Object.create(d):(c.prototype=d.prototype,new c)}}(),p=f.seriesTypes.sma,t=e.extend,h=e.merge,d=e.error,a=e.isArray;e=function(b){function c(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=
void 0;return a}k(c,b);c.prototype.getValues=function(b,c){var l=c.period,e=b.xData,h=b.yData,f=h?h.length:0,r=c.decimals,n=1,w=b.chart.get(c.volumeSeriesID),q=w&&w.yData,k=[],t=[],p=[],x=[],F=[];if(!w)d("Series "+c.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,b.chart);else if(!(e.length<=l)&&a(h[0])&&4===h[0].length&&q){for(b=m(h[n]);n<l+1;)c=b,b=m(h[n]),c=b>=c,w=b*q[n],x.push(c?w:0),F.push(c?0:w),n++;for(l=n-1;l<f;l++)l>n-1&&(x.shift(),F.shift(),c=b,b=m(h[l]),c=b>c,w=b*q[l],x.push(c?
w:0),F.push(c?0:w)),c=g(F),w=g(x),c=w/c,c=parseFloat((100-100/(1+c)).toFixed(r)),k.push([e[l],c]),t.push(e[l]),p.push(c);return{values:k,xData:t,yData:p}}};c.defaultOptions=h(p.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume",decimals:4}});return c}(p);t(e.prototype,{nameBase:"Money Flow Index"});f.registerSeriesType("mfi",e);"";return e});v(f,"Stock/Indicators/Momentum/MomentumIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||
function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return e(d,a)};return function(d,a){function b(){this.constructor=d}e(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.sma,k=e.extend,p=e.isArray,t=e.merge;e=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;
return a}g(d,e);d.prototype.getValues=function(a,b){var c=b.period;b=b.index;var d=a.xData,e=(a=a.yData)?a.length:0,h=[],f=[],g=[],k;if(!(d.length<=c)&&p(a[0])){for(k=c+1;k<e;k++){var r=[d[k-1],a[k-1][b]-a[k-c-1][b]];h.push(r);f.push(r[0]);g.push(r[1])}r=[d[k-1],a[k-1][b]-a[k-c-1][b]];h.push(r);f.push(r[0]);g.push(r[1]);return{values:h,xData:f,yData:g}}};d.defaultOptions=t(m.defaultOptions,{params:{index:3}});return d}(m);k(e.prototype,{nameBase:"Momentum"});f.registerSeriesType("momentum",e);"";
return e});v(f,"Stock/Indicators/NATR/NATRIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(f,h){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,a){d.__proto__=a}||function(d,a){for(var b in a)a.hasOwnProperty(b)&&(d[b]=a[b])};return e(f,h)};return function(f,h){function d(){this.constructor=f}e(f,h);f.prototype=null===h?Object.create(h):(d.prototype=h.prototype,new d)}}(),m=f.seriesTypes.atr,
k=e.merge;e=function(e){function f(){var h=null!==e&&e.apply(this,arguments)||this;h.data=void 0;h.points=void 0;h.options=void 0;return h}g(f,e);f.prototype.getValues=function(e,d){var a=m.prototype.getValues.apply(this,arguments),b=a.values.length,c=d.period-1,l=e.yData,h=0;if(a){for(;h<b;h++)a.yData[h]=a.values[h][1]/l[c][3]*100,a.values[h][1]=a.yData[h],c++;return a}};f.defaultOptions=k(m.defaultOptions,{tooltip:{valueSuffix:"%"}});return f}(m);f.registerSeriesType("natr",e);"";return e});v(f,
"Stock/Indicators/OBV/OBVIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),m=f.seriesTypes.sma,k=e.isNumber,
p=e.error,t=e.extend,h=e.merge;e=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.points=void 0;a.options=void 0;return a}g(a,d);a.prototype.getValues=function(a,c){var b=a.chart.get(c.volumeSeriesID),d=a.xData,e=a.yData,h=[],f=[],g=[],r=!k(e[0]),n=1,m=0;if(b){b=b.yData;a=[d[0],m];var q=r?e[0][3]:e[0];h.push(a);f.push(d[0]);g.push(a[1]);for(n;n<e.length;n++)c=r?e[n][3]:e[n],m=c>q?m+b[n]:c===q?m:m-b[n],a=[d[n],m],q=c,h.push(a),f.push(d[n]),g.push(a[1]);return{values:h,
xData:f,yData:g}}p("Series "+c.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,a.chart)};a.defaultOptions=h(m.defaultOptions,{marker:{enabled:!1},params:{index:void 0,period:void 0,volumeSeriesID:"volume"},tooltip:{valueDecimals:0}});return a}(m);t(e.prototype,{nameComponents:void 0});f.registerSeriesType("obv",e);"";return e});v(f,"Stock/Indicators/PivotPoints/PivotPointsPoint.js",[f["Core/Series/SeriesRegistry.js"]],function(f){function e(e,g){var k=e.series.pointArrayMap,m=k.length;for(f.seriesTypes.sma.prototype.pointClass.prototype[g].call(e);m--;)g=
"dataLabel"+k[m],e[g]&&e[g].element&&e[g].destroy(),e[g]=null}var g=this&&this.__extends||function(){var e=function(f,g){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,h){e.__proto__=h}||function(e,h){for(var d in h)h.hasOwnProperty(d)&&(e[d]=h[d])};return e(f,g)};return function(f,g){function k(){this.constructor=f}e(f,g);f.prototype=null===g?Object.create(g):(k.prototype=g.prototype,new k)}}();return function(f){function k(){var e=null!==f&&f.apply(this,arguments)||this;e.P=
void 0;e.pivotLine=void 0;e.series=void 0;return e}g(k,f);k.prototype.destroyElements=function(){e(this,"destroyElements")};k.prototype.destroy=function(){e(this,"destroyElements")};return k}(f.seriesTypes.sma.prototype.pointClass)});v(f,"Stock/Indicators/PivotPoints/PivotPointsIndicator.js",[f["Stock/Indicators/PivotPoints/PivotPointsPoint.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var m=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),k=e.seriesTypes.sma,p=g.merge,t=g.extend,h=g.defined,d=g.isArray;g=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;b.endPoint=void 0;b.plotEndPoint=void 0;return b}
m(b,a);b.prototype.toYData=function(a){return[a.P]};b.prototype.translate=function(){var a=this;e.seriesTypes.sma.prototype.translate.apply(a);a.points.forEach(function(b){a.pointArrayMap.forEach(function(c){h(b[c])&&(b["plot"+c]=a.yAxis.toPixels(b[c],!0))})});a.plotEndPoint=a.xAxis.toPixels(a.endPoint,!0)};b.prototype.getGraphPath=function(a){for(var b=this,c=a.length,d=[[],[],[],[],[],[],[],[],[]],f=[],g=b.plotEndPoint,k=b.pointArrayMap.length,r,n,m;c--;){n=a[c];for(m=0;m<k;m++)r=b.pointArrayMap[m],
h(n[r])&&d[m].push({plotX:n.plotX,plotY:n["plot"+r],isNull:!1},{plotX:g,plotY:n["plot"+r],isNull:!1},{plotX:g,plotY:null,isNull:!0});g=n.plotX}d.forEach(function(a){f=f.concat(e.seriesTypes.sma.prototype.getGraphPath.call(b,a))});return f};b.prototype.drawDataLabels=function(){var a=this,b=a.pointArrayMap,d,f,h;if(a.options.dataLabels.enabled){var g=a.points.length;b.concat([!1]).forEach(function(c,l){for(h=g;h--;)f=a.points[h],c?(f.y=f[c],f.pivotLine=c,f.plotY=f["plot"+c],d=f["dataLabel"+c],l&&(f["dataLabel"+
b[l-1]]=f.dataLabel),f.dataLabels||(f.dataLabels=[]),f.dataLabels[0]=f.dataLabel=d=d&&d.element?d:null):f["dataLabel"+b[l-1]]=f.dataLabel;e.seriesTypes.sma.prototype.drawDataLabels.apply(a,arguments)})}};b.prototype.getValues=function(a,b){var c=b.period,l=a.xData,e=(a=a.yData)?a.length:0;b=this[b.algorithm+"Placement"];var f=[],h=[],g=[],n;if(!(l.length<c)&&d(a[0])&&4===a[0].length){for(n=c+1;n<=e+c;n+=c){var k=l.slice(n-c-1,n);var q=a.slice(n-c-1,n);var m=k.length;var t=k[m-1];q=this.getPivotAndHLC(q);
q=b(q);q=f.push([t].concat(q));h.push(t);g.push(f[q-1].slice(1))}this.endPoint=k[0]+(t-k[0])/m*c;return{values:f,xData:h,yData:g}}};b.prototype.getPivotAndHLC=function(a){var b=-Infinity,c=Infinity,d=a[a.length-1][3];a.forEach(function(a){b=Math.max(b,a[1]);c=Math.min(c,a[2])});return[(b+c+d)/3,b,c,d]};b.prototype.standardPlacement=function(a){var b=a[1]-a[2];return[null,null,a[0]+b,2*a[0]-a[2],a[0],2*a[0]-a[1],a[0]-b,null,null]};b.prototype.camarillaPlacement=function(a){var b=a[1]-a[2];return[a[3]+
1.5*b,a[3]+1.25*b,a[3]+1.1666*b,a[3]+1.0833*b,a[0],a[3]-1.0833*b,a[3]-1.1666*b,a[3]-1.25*b,a[3]-1.5*b]};b.prototype.fibonacciPlacement=function(a){var b=a[1]-a[2];return[null,a[0]+b,a[0]+.618*b,a[0]+.382*b,a[0],a[0]-.382*b,a[0]-.618*b,a[0]-b,null]};b.defaultOptions=p(k.defaultOptions,{params:{index:void 0,period:28,algorithm:"standard"},marker:{enabled:!1},enableMouseTracking:!1,dataLabels:{enabled:!0,format:"{point.pivotLine}"},dataGrouping:{approximation:"averages"}});return b}(k);t(g.prototype,
{nameBase:"Pivot Points",pointArrayMap:"R4 R3 R2 R1 P S1 S2 S3 S4".split(" "),pointValKey:"P",pointClass:f});e.registerSeriesType("pivotpoints",g);"";return g});v(f,"Stock/Indicators/PPO/PPOIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(a,b)};
return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),m=f.seriesTypes.ema,k=e.correctFloat,p=e.extend,t=e.merge,h=e.error;e=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(a,d);a.prototype.getValues=function(a,c){var b=c.periods,d=c.index;c=[];var e=[],f=[],g;if(2!==b.length||b[1]<=b[0])h('Error: "PPO requires two periods. Notice, first period should be lower than the second one."');
else{var t=m.prototype.getValues.call(this,a,{index:d,period:b[0]});a=m.prototype.getValues.call(this,a,{index:d,period:b[1]});if(t&&a){b=b[1]-b[0];for(g=0;g<a.yData.length;g++)d=k((t.yData[g+b]-a.yData[g])/a.yData[g]*100),c.push([a.xData[g],d]),e.push(a.xData[g]),f.push(d);return{values:c,xData:e,yData:f}}}};a.defaultOptions=t(m.defaultOptions,{params:{period:void 0,periods:[12,26]}});return a}(m);p(e.prototype,{nameBase:"PPO",nameComponents:["periods"]});f.registerSeriesType("ppo",e);"";return e});
v(f,"Stock/Indicators/ArrayUtilities.js",[],function(){return{getArrayExtremes:function(f,e,g){return f.reduce(function(f,k){return[Math.min(f[0],k[e]),Math.max(f[1],k[g])]},[Number.MAX_VALUE,-Number.MAX_VALUE])}}});v(f,"Stock/Indicators/PC/PCIndicator.js",[f["Stock/Indicators/ArrayUtilities.js"],f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Color/Palettes.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g,m,k){var p=this&&this.__extends||function(){var a=function(b,
c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),t=m.seriesTypes.sma,h=k.merge;k=k.extend;var d=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}p(b,a);b.prototype.getValues=
function(a,b){b=b.period;var c=a.xData,d=(a=a.yData)?a.length:0,e=[],l=[],h=[],g;if(!(d<b)){for(g=b;g<=d;g++){var n=c[g-1];var k=a.slice(g-b,g);var q=f.getArrayExtremes(k,2,1);k=q[1];var m=q[0];q=(k+m)/2;e.push([n,k,q,m]);l.push(n);h.push([k,q,m])}return{values:e,xData:l,yData:h}}};b.defaultOptions=h(t.defaultOptions,{params:{index:void 0,period:20},lineWidth:1,topLine:{styles:{lineColor:g.colors[2],lineWidth:1}},bottomLine:{styles:{lineColor:g.colors[8],lineWidth:1}},dataGrouping:{approximation:"averages"}});
return b}(t);k(d.prototype,{areaLinesNames:["top","bottom"],nameBase:"Price Channel",nameComponents:["period"],linesApiNames:["topLine","bottomLine"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"});e.compose(d);m.registerSeriesType("pc",d);"";return d});v(f,"Stock/Indicators/PriceEnvelopes/PriceEnvelopesIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return e(d,a)};return function(d,a){function b(){this.constructor=d}e(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.sma,k=e.extend,p=e.isArray,t=e.merge;e=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,e);d.prototype.init=function(){f.seriesTypes.sma.prototype.init.apply(this,
arguments);this.options=t({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)};d.prototype.toYData=function(a){return[a.top,a.middle,a.bottom]};d.prototype.translate=function(){var a=this,b=["plotTop","plotMiddle","plotBottom"];f.seriesTypes.sma.prototype.translate.apply(a);a.points.forEach(function(c){[c.top,c.middle,c.bottom].forEach(function(d,e){null!==d&&(c[b[e]]=a.yAxis.toPixels(d,!0))})})};d.prototype.drawGraph=function(){for(var a=this,b=a.points,
c=b.length,d=a.options,e=a.graph,h={options:{gapSize:d.gapSize}},g=[[],[]],k;c--;)k=b[c],g[0].push({plotX:k.plotX,plotY:k.plotTop,isNull:k.isNull}),g[1].push({plotX:k.plotX,plotY:k.plotBottom,isNull:k.isNull});["topLine","bottomLine"].forEach(function(b,c){a.points=g[c];a.options=t(d[b].styles,h);a.graph=a["graph"+b];f.seriesTypes.sma.prototype.drawGraph.call(a);a["graph"+b]=a.graph});a.points=b;a.options=d;a.graph=e;f.seriesTypes.sma.prototype.drawGraph.call(a)};d.prototype.getValues=function(a,
b){var c=b.period,d=b.topBand,e=b.bottomBand,h=a.xData,g=(a=a.yData)?a.length:0,k=[],m=[],r=[],n;if(!(h.length<c)&&p(a[0])&&4===a[0].length){for(n=c;n<=g;n++){var t=h.slice(n-c,n);var q=a.slice(n-c,n);q=f.seriesTypes.sma.prototype.getValues.call(this,{xData:t,yData:q},b);t=q.xData[0];q=q.yData[0];var u=q*(1+d);var P=q*(1-e);k.push([t,u,q,P]);m.push(t);r.push([u,q,P])}return{values:k,xData:m,yData:r}}};d.defaultOptions=t(m.defaultOptions,{marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},
params:{period:20,topBand:.1,bottomBand:.1},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}});return d}(m);k(e.prototype,{nameComponents:["period","topBand","bottomBand"],nameBase:"Price envelopes",pointArrayMap:["top","middle","bottom"],parallelArrays:["x","y","top","bottom"],pointValKey:"middle"});f.registerSeriesType("priceenvelopes",e);"";return e});v(f,"Stock/Indicators/PSAR/PSARIndicator.js",[f["Core/Series/SeriesRegistry.js"],
f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(f,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(f,d)};return function(f,d){function a(){this.constructor=f}e(f,d);f.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),m=f.seriesTypes.sma,k=e.merge;e=e.extend;var p=function(e){function f(){var d=null!==e&&e.apply(this,arguments)||
this;d.data=void 0;d.points=void 0;d.options=void 0;return d}g(f,e);f.prototype.getValues=function(d,a){var b=d.xData;d=d.yData;var c=d[0][1],e=a.maxAccelerationFactor,f=a.increment,h=a.initialAccelerationFactor,g=d[0][2],k=a.decimals,m=a.index,r=[],n=[],t=[],q=1,u;if(!(m>=d.length)){for(u=0;u<m;u++)c=Math.max(d[u][1],c),g=Math.min(d[u][2],parseFloat(g.toFixed(k)));var p=d[u][1]>g?1:-1;a=a.initialAccelerationFactor;var J=a*(c-g);r.push([b[m],g]);n.push(b[m]);t.push(parseFloat(g.toFixed(k)));for(u=
m+1;u<d.length;u++){m=d[u-1][2];var x=d[u-2][2];var F=d[u-1][1];var v=d[u-2][1];var C=d[u][1];var N=d[u][2];null!==x&&null!==v&&null!==m&&null!==F&&null!==C&&null!==N&&(g=p===q?1===p?g+J<Math.min(x,m)?g+J:Math.min(x,m):g+J>Math.max(v,F)?g+J:Math.max(v,F):c,m=1===p?C>c?C:c:N<c?N:c,C=1===q&&N>g||-1===q&&C>g?1:-1,q=C,J=m,N=f,x=e,F=h,a=q===p?1===q&&J>c?a===x?x:parseFloat((a+N).toFixed(2)):-1===q&&J<c?a===x?x:parseFloat((a+N).toFixed(2)):a:F,c=m-g,J=a*c,r.push([b[u],parseFloat(g.toFixed(k))]),n.push(b[u]),
t.push(parseFloat(g.toFixed(k))),q=p,p=C,c=m)}return{values:r,xData:n,yData:t}}};f.defaultOptions=k(m.defaultOptions,{lineWidth:0,marker:{enabled:!0},states:{hover:{lineWidthPlus:0}},params:{period:void 0,initialAccelerationFactor:.02,maxAccelerationFactor:.2,increment:.02,index:2,decimals:4}});return f}(m);e(p.prototype,{nameComponents:void 0});f.registerSeriesType("psar",p);"";return p});v(f,"Stock/Indicators/ROC/ROCIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,
e){var g=this&&this.__extends||function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return e(d,a)};return function(d,a){function b(){this.constructor=d}e(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.sma,k=e.isArray,p=e.merge;e=e.extend;var t=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;
a.options=void 0;a.points=void 0;return a}g(d,e);d.prototype.getValues=function(a,b){var c=b.period,d=a.xData,e=(a=a.yData)?a.length:0,f=[],h=[],g=[],m=-1;if(!(d.length<=c)){k(a[0])&&(m=b.index);for(b=c;b<e;b++){var r=0>m?(r=a[b-c])?(a[b]-r)/r*100:null:(r=a[b-c][m])?(a[b][m]-r)/r*100:null;r=[d[b],r];f.push(r);h.push(r[0]);g.push(r[1])}return{values:f,xData:h,yData:g}}};d.defaultOptions=p(m.defaultOptions,{params:{index:3,period:9}});return d}(m);e(t.prototype,{nameBase:"Rate of Change"});f.registerSeriesType("roc",
t);"";return t});v(f,"Stock/Indicators/RSI/RSIIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(f,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(f,d)};return function(f,d){function a(){this.constructor=f}e(f,d);f.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),m=f.seriesTypes.sma,
k=e.isNumber,p=e.merge;e=function(e){function f(){var d=null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.points=void 0;d.options=void 0;return d}g(f,e);f.prototype.getValues=function(d,a){var b=a.period,c=d.xData,e=d.yData;d=e?e.length:0;var f=a.decimals,h=1,g=[],m=[],t=[],r=a.index,n=a=0,p;if(!(c.length<b)){if(k(e[0]))var q=e;else r=Math.min(r,e[0].length-1),q=e.map(function(a){return a[r]});for(;h<b;){var u=parseFloat((q[h]-q[h-1]).toFixed(f));0<u?a+=u:n+=Math.abs(u);h++}e=parseFloat((a/
(b-1)).toFixed(f));for(p=parseFloat((n/(b-1)).toFixed(f));h<d;h++)u=parseFloat((q[h]-q[h-1]).toFixed(f)),0<u?(a=u,n=0):(a=0,n=Math.abs(u)),e=parseFloat(((e*(b-1)+a)/b).toFixed(f)),p=parseFloat(((p*(b-1)+n)/b).toFixed(f)),a=0===p?100:0===e?0:parseFloat((100-100/(1+e/p)).toFixed(f)),g.push([c[h],a]),m.push(c[h]),t.push(a);return{values:g,xData:m,yData:t}}};f.defaultOptions=p(m.defaultOptions,{params:{decimals:4,index:3}});return f}(m);f.registerSeriesType("rsi",e);"";return e});v(f,"Stock/Indicators/Stochastic/StochasticIndicator.js",
[f["Stock/Indicators/ArrayUtilities.js"],f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g,m){var k=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=
c.prototype,new d)}}(),p=g.seriesTypes.sma,t=m.extend,h=m.isArray,d=m.merge;m=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}k(b,a);b.prototype.init=function(){g.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=d({smoothedLine:{styles:{lineColor:this.color}}},this.options)};b.prototype.getValues=function(a,b){var c=b.periods[0];b=b.periods[1];var d=a.xData,e=(a=a.yData)?a.length:0,l=[],k=[],m=[],n=null,
t;if(!(e<c)&&h(a[0])&&4===a[0].length){for(t=c-1;t<e;t++){var q=a.slice(t-c+1,t+1);var u=f.getArrayExtremes(q,2,1);var p=u[0];q=a[t][3]-p;p=u[1]-p;q=q/p*100;k.push(d[t]);m.push([q,null]);t>=c-1+(b-1)&&(n=g.seriesTypes.sma.prototype.getValues.call(this,{xData:k.slice(-b),yData:m.slice(-b)},{period:b}),n=n.yData[0]);l.push([d[t],q,n]);m[m.length-1][1]=n}return{values:l,xData:k,yData:m}}};b.defaultOptions=d(p.defaultOptions,{params:{index:void 0,period:void 0,periods:[14,3]},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>%K: {point.y}<br/>%D: {point.smoothed}<br/>'},
smoothedLine:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}});return b}(p);t(m.prototype,{areaLinesNames:[],nameComponents:["periods"],nameBase:"Stochastic",pointArrayMap:["y","smoothed"],parallelArrays:["x","y","smoothed"],pointValKey:"y",linesApiNames:["smoothedLine"]});e.compose(m);g.registerSeriesType("stochastic",m);"";return m});v(f,"Stock/Indicators/SlowStochastic/SlowStochasticIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,
e){var g=this&&this.__extends||function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return e(d,a)};return function(d,a){function b(){this.constructor=d}e(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.stochastic,k=f.seriesTypes,p=e.extend,t=e.merge;e=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=
void 0;a.options=void 0;a.points=void 0;return a}g(d,e);d.prototype.getValues=function(a,b){var c=b.periods,d=k.stochastic.prototype.getValues.call(this,a,b);a={values:[],xData:[],yData:[]};b=0;if(d){a.xData=d.xData.slice(c[1]-1);d=d.yData.slice(c[1]-1);var e=k.sma.prototype.getValues.call(this,{xData:a.xData,yData:d},{index:1,period:c[2]});if(e){for(var f=a.xData.length;b<f;b++)a.yData[b]=[d[b][1],e.yData[b-c[2]+1]||null],a.values[b]=[a.xData[b],d[b][1],e.yData[b-c[2]+1]||null];return a}}};d.defaultOptions=
t(m.defaultOptions,{params:{periods:[14,3,3]}});return d}(m);p(e.prototype,{nameBase:"Slow Stochastic"});f.registerSeriesType("slowstochastic",e);"";return e});v(f,"Stock/Indicators/Supertrend/SupertrendIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"],f["Core/Chart/StockChart.js"]],function(f,e,g){function m(a,b,c){return{index:b,close:a.yData[b][c],x:a.xData[b]}}var k=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&
function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),p=f.seriesTypes,t=p.atr,h=p.sma,d=e.addEvent,a=e.correctFloat,b=e.isArray;p=e.extend;var c=e.merge,l=e.objectEach;e=function(e){function f(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.linkedParent=void 0;a.options=void 0;a.points=void 0;return a}
k(f,e);f.prototype.init=function(){var a;h.prototype.init.apply(this,arguments);var b=this,c=d(g,"afterLinkSeries",function(){if(b.options){var d=b.options;a=b.linkedParent.options;d.cropThreshold=a.cropThreshold-(d.params.period-1)}c()},{order:1})};f.prototype.drawGraph=function(){var a=this,b=a.options,d=a.linkedParent,e=d?d.points:[],f=a.points,g=a.graph,k=f.length,u=e.length-k;u=0<u?u:0;for(var t={options:{gapSize:b.gapSize}},p={top:[],bottom:[],intersect:[]},w={top:{styles:{lineWidth:b.lineWidth,
lineColor:b.fallingTrendColor||b.color,dashStyle:b.dashStyle}},bottom:{styles:{lineWidth:b.lineWidth,lineColor:b.risingTrendColor||b.color,dashStyle:b.dashStyle}},intersect:b.changeTrendLine},A,x,C,v,E,G,H,I;k--;)A=f[k],x=f[k-1],C=e[k-1+u],v=e[k-2+u],E=e[k+u],G=e[k+u+1],H=A.options.color,I={x:A.x,plotX:A.plotX,plotY:A.plotY,isNull:!1},!v&&C&&d.yData[C.index-1]&&(v=m(d,C.index-1,3)),!G&&E&&d.yData[E.index+1]&&(G=m(d,E.index+1,3)),!C&&v&&d.yData[v.index+1]?C=m(d,v.index+1,3):!C&&E&&d.yData[E.index-
1]&&(C=m(d,E.index-1,3)),A&&C&&E&&v&&A.x!==C.x&&(A.x===E.x?(v=C,C=E):A.x===v.x?(C=v,v={close:d.yData[C.index-1][3],x:d.xData[C.index-1]}):G&&A.x===G.x&&(C=G,v=E)),x&&v&&C?(E={x:x.x,plotX:x.plotX,plotY:x.plotY,isNull:!1},A.y>=C.close&&x.y>=v.close?(A.color=H||b.fallingTrendColor||b.color,p.top.push(I)):A.y<C.close&&x.y<v.close?(A.color=H||b.risingTrendColor||b.color,p.bottom.push(I)):(p.intersect.push(I),p.intersect.push(E),p.intersect.push(c(E,{isNull:!0})),A.y>=C.close&&x.y<v.close?(A.color=H||b.fallingTrendColor||
b.color,x.color=H||b.risingTrendColor||b.color,p.top.push(I),p.top.push(c(E,{isNull:!0}))):A.y<C.close&&x.y>=v.close&&(A.color=H||b.risingTrendColor||b.color,x.color=H||b.fallingTrendColor||b.color,p.bottom.push(I),p.bottom.push(c(E,{isNull:!0}))))):C&&(A.y>=C.close?(A.color=H||b.fallingTrendColor||b.color,p.top.push(I)):(A.color=H||b.risingTrendColor||b.color,p.bottom.push(I)));l(p,function(b,d){a.points=b;a.options=c(w[d].styles,t);a.graph=a["graph"+d+"Line"];h.prototype.drawGraph.call(a);a["graph"+
d+"Line"]=a.graph});a.points=f;a.options=b;a.graph=g};f.prototype.getValues=function(c,d){var e=d.period;d=d.multiplier;var f=c.xData,l=c.yData,h=[],g=[],k=[],m=0===e?0:e-1,p=[],w=[],z;if(!(f.length<=e||!b(l[0])||4!==l[0].length||0>e)){c=t.prototype.getValues.call(this,c,{period:e}).yData;for(z=0;z<c.length;z++){var y=l[m+z];var A=l[m+z-1]||[];var x=p[z-1];var v=w[z-1];var G=k[z-1];0===z&&(x=v=G=0);e=a((y[1]+y[2])/2+d*c[z]);var H=a((y[1]+y[2])/2-d*c[z]);p[z]=e<x||A[3]>x?e:x;w[z]=H>v||A[3]<v?H:v;if(G===
x&&y[3]<p[z]||G===v&&y[3]<w[z])var I=p[z];else if(G===x&&y[3]>p[z]||G===v&&y[3]>w[z])I=w[z];h.push([f[m+z],I]);g.push(f[m+z]);k.push(I)}return{values:h,xData:g,yData:k}}};f.defaultOptions=c(h.defaultOptions,{params:{index:void 0,multiplier:3,period:10},risingTrendColor:"#06b535",fallingTrendColor:"#f21313",changeTrendLine:{styles:{lineWidth:1,lineColor:"#333333",dashStyle:"LongDash"}}});return f}(h);p(e.prototype,{nameBase:"Supertrend",nameComponents:["multiplier","period"]});f.registerSeriesType("supertrend",
e);"";return e});v(f,"Stock/Indicators/VBP/VBPPoint.js",[f["Core/Series/Point.js"],f["Core/Series/SeriesRegistry.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(f,g){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,f){e.__proto__=f}||function(e,f){for(var d in f)f.hasOwnProperty(d)&&(e[d]=f[d])};return e(f,g)};return function(f,g){function k(){this.constructor=f}e(f,g);f.prototype=null===g?Object.create(g):(k.prototype=g.prototype,new k)}}();return function(e){function k(){return null!==
e&&e.apply(this,arguments)||this}g(k,e);k.prototype.destroy=function(){this.negativeGraphic&&(this.negativeGraphic=this.negativeGraphic.destroy());return f.prototype.destroy.apply(this,arguments)};return k}(e.seriesTypes.sma.prototype.pointClass)});v(f,"Stock/Indicators/VBP/VBPIndicator.js",[f["Stock/Indicators/VBP/VBPPoint.js"],f["Core/Animation/AnimationUtilities.js"],f["Core/Globals.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"],f["Core/Chart/StockChart.js"]],function(f,e,g,m,k,
p){var t=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),h=e.animObject;e=g.noop;var d=m.seriesTypes.sma,a=k.addEvent,b=k.arrayMax,c=k.arrayMin,l=k.correctFloat,w=k.defined,A=k.error,z=k.extend,y=k.isArray,
v=k.merge,r=Math.abs,n=m.seriesTypes.column.prototype;k=function(e){function f(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.negWidths=void 0;a.options=void 0;a.points=void 0;a.posWidths=void 0;a.priceZones=void 0;a.rangeStep=void 0;a.volumeDataArray=void 0;a.zoneStarts=void 0;a.zoneLinesSVG=void 0;return a}t(f,e);f.prototype.init=function(b){var c=this,d,e,f;g.seriesTypes.sma.prototype.init.apply(c,arguments);var l=a(p,"afterLinkSeries",function(){c.options&&(d=c.options.params,
e=c.linkedParent,f=b.get(d.volumeSeriesID),c.addCustomEvents(e,f));l()},{order:1});return c};f.prototype.addCustomEvents=function(b,c){function d(){e.chart.redraw();e.setData([]);e.zoneStarts=[];e.zoneLinesSVG&&(e.zoneLinesSVG=e.zoneLinesSVG.destroy())}var e=this;e.dataEventsToUnbind.push(a(b,"remove",function(){d()}));c&&e.dataEventsToUnbind.push(a(c,"remove",function(){d()}));return e};f.prototype.animate=function(a){var b=this,c=b.chart.inverted,d=b.group,e={};!a&&d&&(a=c?b.yAxis.top:b.xAxis.left,
c?(d["forceAnimate:translateY"]=!0,e.translateY=a):(d["forceAnimate:translateX"]=!0,e.translateX=a),d.animate(e,z(h(b.options.animation),{step:function(a,c){b.group.attr({scaleX:Math.max(.001,c.pos)})}})))};f.prototype.drawPoints=function(){this.options.volumeDivision.enabled&&(this.posNegVolume(!0,!0),n.drawPoints.apply(this,arguments),this.posNegVolume(!1,!1));n.drawPoints.apply(this,arguments)};f.prototype.posNegVolume=function(a,b){var c=b?["positive","negative"]:["negative","positive"],d=this.options.volumeDivision,
e=this.points.length,f=[],l=[],h=0,g;a?(this.posWidths=f,this.negWidths=l):(f=this.posWidths,l=this.negWidths);for(;h<e;h++){var n=this.points[h];n[c[0]+"Graphic"]=n.graphic;n.graphic=n[c[1]+"Graphic"];if(a){var k=n.shapeArgs.width;var m=this.priceZones[h];(g=m.wholeVolumeData)?(f.push(k/g*m.positiveVolumeData),l.push(k/g*m.negativeVolumeData)):(f.push(0),l.push(0))}n.color=b?d.styles.positiveColor:d.styles.negativeColor;n.shapeArgs.width=b?this.posWidths[h]:this.negWidths[h];n.shapeArgs.x=b?n.shapeArgs.x:
this.posWidths[h]}};f.prototype.translate=function(){var a=this,c=a.options,d=a.chart,e=a.yAxis,f=e.min,h=a.options.zoneLines,g=a.priceZones,k=0,m,q,t;n.translate.apply(a);var p=a.points;if(p.length){var w=.5>c.pointPadding?c.pointPadding:.1;c=a.volumeDataArray;var z=b(c);var y=d.plotWidth/2;var A=d.plotTop;var B=r(e.toPixels(f)-e.toPixels(f+a.rangeStep));var v=r(e.toPixels(f)-e.toPixels(f+a.rangeStep));w&&(f=r(B*(1-2*w)),k=r((B-f)/2),B=r(f));p.forEach(function(b,c){q=b.barX=b.plotX=0;t=b.plotY=e.toPixels(g[c].start)-
A-(e.reversed?B-v:B)-k;m=l(y*g[c].wholeVolumeData/z);b.pointWidth=m;b.shapeArgs=a.crispCol.apply(a,[q,t,m,B]);b.volumeNeg=g[c].negativeVolumeData;b.volumePos=g[c].positiveVolumeData;b.volumeAll=g[c].wholeVolumeData});h.enabled&&a.drawZones(d,e,a.zoneStarts,h.styles)}};f.prototype.getValues=function(a,b){var c=a.processedXData,d=a.processedYData,e=this.chart,f=b.ranges,l=[],h=[],g=[],n;if(a.chart)if(n=e.get(b.volumeSeriesID))if((b=y(d[0]))&&4!==d[0].length)A("Type of "+a.name+" series is different than line, OHLC or candlestick.",
!0,e);else return(this.priceZones=this.specifyZones(b,c,d,f,n)).forEach(function(a,b){l.push([a.x,a.end]);h.push(l[b][0]);g.push(l[b][1])}),{values:l,xData:h,yData:g};else A("Series "+b.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,e);else A("Base series not found! In case it has been removed, add a new one.",!0,e)};f.prototype.specifyZones=function(a,d,e,f,h){if(a){var g=e.length;for(var n=e[0][3],k=n,m=1,r;m<g;m++)r=e[m][3],r<n&&(n=r),r>k&&(k=r);g={min:n,max:k}}else g=!1;g=(n=g)?n.min:
c(e);r=n?n.max:b(e);n=this.zoneStarts=[];k=[];var q=0;m=1;var t=this.linkedParent;!this.options.compareToMain&&t.dataModify&&(g=t.dataModify.modifyValue(g),r=t.dataModify.modifyValue(r));if(!w(g)||!w(r))return this.points.length&&(this.setData([]),this.zoneStarts=[],this.zoneLinesSVG&&(this.zoneLinesSVG=this.zoneLinesSVG.destroy())),[];t=this.rangeStep=l(r-g)/f;for(n.push(g);q<f-1;q++)n.push(l(n[q]+t));n.push(r);for(f=n.length;m<f;m++)k.push({index:m-1,x:d[0],start:n[m-1],end:n[m]});return this.volumePerZone(a,
k,h,d,e)};f.prototype.volumePerZone=function(a,b,c,d,e){var f=this,l=c.processedXData,h=c.processedYData,g=b.length-1,n=e.length;c=h.length;var k,m,q,t,p;r(n-c)&&(d[0]!==l[0]&&h.unshift(0),d[n-1]!==l[c-1]&&h.push(0));f.volumeDataArray=[];b.forEach(function(b){b.wholeVolumeData=0;b.positiveVolumeData=0;for(p=b.negativeVolumeData=0;p<n;p++){q=m=!1;t=a?e[p][3]:e[p];k=p?a?e[p-1][3]:e[p-1]:t;var c=f.linkedParent;!f.options.compareToMain&&c.dataModify&&(t=c.dataModify.modifyValue(t),k=c.dataModify.modifyValue(k));
t<=b.start&&0===b.index&&(m=!0);t>=b.end&&b.index===g&&(q=!0);(t>b.start||m)&&(t<b.end||q)&&(b.wholeVolumeData+=h[p],k>t?b.negativeVolumeData+=h[p]:b.positiveVolumeData+=h[p])}f.volumeDataArray.push(b.wholeVolumeData)});return b};f.prototype.drawZones=function(a,b,c,d){var e=a.renderer,f=this.zoneLinesSVG,l=[],h=a.plotWidth,g=a.plotTop,n;c.forEach(function(c){n=b.toPixels(c)-g;l=l.concat(a.renderer.crispLine([["M",0,n],["L",h,n]],d.lineWidth))});f?f.animate({d:l}):f=this.zoneLinesSVG=e.path(l).attr({"stroke-width":d.lineWidth,
stroke:d.color,dashstyle:d.dashStyle,zIndex:this.group.zIndex+.1}).add(this.group)};f.defaultOptions=v(d.defaultOptions,{params:{index:void 0,period:void 0,ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,styles:{color:"#0A9AC9",dashStyle:"LongDash",lineWidth:1}},volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",negativeColor:"rgba(244, 91, 91, 0.8)"}},animationLimit:1E3,enableMouseTracking:!1,pointPadding:0,zIndex:-1,crisp:!0,dataGrouping:{enabled:!1},dataLabels:{allowOverlap:!0,
enabled:!0,format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",padding:0,style:{fontSize:"7px"},verticalAlign:"top"}});return f}(d);z(k.prototype,{nameBase:"Volume by Price",nameComponents:["ranges"],calculateOn:{chart:"render",xAxis:"afterSetExtremes"},pointClass:f,markerAttribs:e,drawGraph:e,getColumnMetrics:n.getColumnMetrics,crispCol:n.crispCol});m.registerSeriesType("vbp",k);"";return k});v(f,"Stock/Indicators/VWAP/VWAPIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],
function(f,e){var g=this&&this.__extends||function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return e(d,a)};return function(d,a){function b(){this.constructor=d}e(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.sma,k=e.error,p=e.isArray,t=e.merge;e=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=
void 0;a.points=void 0;a.options=void 0;return a}g(d,e);d.prototype.getValues=function(a,b){var c=a.chart,d=a.xData;a=a.yData;var e=b.period,f=!0,h;if(h=c.get(b.volumeSeriesID))return p(a[0])||(f=!1),this.calculateVWAPValues(f,d,a,h,e);k("Series "+b.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,c)};d.prototype.calculateVWAPValues=function(a,b,c,d,e){var f=d.yData,l=d.xData.length,h=b.length;d=[];var g=[],k=[],n=[],m=[],q;l=h<=l?h:l;for(q=h=0;h<l;h++){var t=a?(c[h][1]+c[h][2]+c[h][3])/3:
c[h];t*=f[h];t=q?d[h-1]+t:t;var p=q?g[h-1]+f[h]:f[h];d.push(t);g.push(p);m.push([b[h],t/p]);k.push(m[h][0]);n.push(m[h][1]);q++;q===e&&(q=0)}return{values:m,xData:k,yData:n}};d.defaultOptions=t(m.defaultOptions,{params:{index:void 0,period:30,volumeSeriesID:"volume"}});return d}(m);f.registerSeriesType("vwap",e);"";return e});v(f,"Stock/Indicators/WilliamsR/WilliamsRIndicator.js",[f["Stock/Indicators/ArrayUtilities.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var m=
this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),k=e.seriesTypes.sma,p=g.extend,t=g.isArray,h=g.merge;g=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=
void 0;a.points=void 0;return a}m(a,d);a.prototype.getValues=function(a,c){c=c.period;var b=a.xData,d=(a=a.yData)?a.length:0,e=[],h=[],g=[],k;if(!(b.length<c)&&t(a[0])&&4===a[0].length){for(k=c-1;k<d;k++){var m=a.slice(k-c+1,k+1);var n=f.getArrayExtremes(m,2,1);m=n[0];n=n[1];var p=a[k][3];m=(n-p)/(n-m)*-100;b[k]&&(e.push([b[k],m]),h.push(b[k]),g.push(m))}return{values:e,xData:h,yData:g}}};a.defaultOptions=h(k.defaultOptions,{params:{index:void 0,period:14}});return a}(k);p(g.prototype,{nameBase:"Williams %R"});
e.registerSeriesType("williamsr",g);"";return g});v(f,"Stock/Indicators/WMA/WMAIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){function g(d,a){a*=(a+1)/2;return d.reduce(function(a,c,d){return[null,a[1]+c[1]*(d+1)]})[1]/a}function m(d,a,b,c){b=g(d,d.length);a=a[c-1];d.shift();return[a,b]}var k=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&
(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),p=f.seriesTypes.sma,t=e.isArray,h=e.merge;e=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(a,d);a.prototype.getValues=function(a,c){var b=c.period,d=a.xData,e=(a=a.yData)?a.length:0,f=1,h=d[0],g=a[0],k=[],n=[],p=[],q=-1;if(!(d.length<b)){t(a[0])&&(q=c.index,
g=a[0][q]);for(c=[[h,g]];f!==b;)c.push([d[f],0>q?a[f]:a[f][q]]),f++;for(b=f;b<e;b++)f=m(c,d,a,b),k.push(f),n.push(f[0]),p.push(f[1]),c.push([d[b],0>q?a[b]:a[b][q]]);f=m(c,d,a,b);k.push(f);n.push(f[0]);p.push(f[1]);return{values:k,xData:n,yData:p}}};a.defaultOptions=h(p.defaultOptions,{params:{index:3,period:9}});return a}(p);f.registerSeriesType("wma",e);"";return e});v(f,"Stock/Indicators/Zigzag/ZigzagIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&
this.__extends||function(){var e=function(f,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(f,d)};return function(f,d){function a(){this.constructor=f}e(f,d);f.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),m=f.seriesTypes.sma,k=e.merge;e=e.extend;var p=function(e){function f(){var d=null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.points=void 0;d.options=
void 0;return d}g(f,e);f.prototype.getValues=function(d,a){var b=a.lowIndex,c=a.highIndex,e=a.deviation/100;a=1+e;var f=1-e;e=d.xData;var h=d.yData;d=h?h.length:0;var g=[],k=[],m=[],r,n,t=!1,q=!1;if(!(!e||1>=e.length||d&&("undefined"===typeof h[0][b]||"undefined"===typeof h[0][c]))){var p=h[0][b];var v=h[0][c];for(r=1;r<d;r++){if(h[r][b]<=v*f){g.push([e[0],v]);var x=[e[r],h[r][b]];t=n=!0}else h[r][c]>=p*a&&(g.push([e[0],p]),x=[e[r],h[r][c]],n=!1,t=!0);if(t){k.push(g[0][0]);m.push(g[0][1]);var M=r++;
r=d}}for(r=M;r<d;r++)n?(h[r][b]<=x[1]&&(x=[e[r],h[r][b]]),h[r][c]>=x[1]*a&&(q=c)):(h[r][c]>=x[1]&&(x=[e[r],h[r][c]]),h[r][b]<=x[1]*f&&(q=b)),!1!==q&&(g.push(x),k.push(x[0]),m.push(x[1]),x=[e[r],h[r][q]],n=!n,q=!1);b=g.length;0!==b&&g[b-1][0]<e[d-1]&&(g.push(x),k.push(x[0]),m.push(x[1]));return{values:g,xData:k,yData:m}}};f.defaultOptions=k(m.defaultOptions,{params:{index:void 0,period:void 0,lowIndex:2,highIndex:1,deviation:1}});return f}(m);e(p.prototype,{nameComponents:["deviation"],nameSuffixes:["%"],
nameBase:"Zig Zag"});f.registerSeriesType("zigzag",p);"";return p});v(f,"Stock/Indicators/LinearRegression/LinearRegression.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return e(d,a)};return function(d,a){function b(){this.constructor=d}e(d,a);d.prototype=null===
a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.sma,k=e.isArray,p=e.extend,t=e.merge;e=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,e);d.prototype.getRegressionLineParameters=function(a,b){var c=this.options.params.index,d=function(a,b){return k(a)?a[b]:a},e=a.reduce(function(a,b){return b+a},0),f=b.reduce(function(a,b){return d(b,c)+a},0);e/=a.length;f/=b.length;var h=0,g=0,m;for(m=0;m<a.length;m++){var r=
a[m]-e;var n=d(b[m],c)-f;h+=r*n;g+=Math.pow(r,2)}a=g?h/g:0;return{slope:a,intercept:f-a*e}};d.prototype.getEndPointY=function(a,b){return a.slope*b+a.intercept};d.prototype.transformXData=function(a,b){var c=a[0];return a.map(function(a){return(a-c)/b})};d.prototype.findClosestDistance=function(a){var b,c;for(c=1;c<a.length-1;c++){var d=a[c]-a[c-1];0<d&&("undefined"===typeof b||d<b)&&(b=d)}return b};d.prototype.getValues=function(a,b){var c=a.xData;a=a.yData;b=b.period;var d,e={xData:[],yData:[],
values:[]},f=this.options.params.xAxisUnit||this.findClosestDistance(c);for(d=b-1;d<=c.length-1;d++){var h=d-b+1;var g=d+1;var k=c[d];var m=c.slice(h,g);h=a.slice(h,g);g=this.transformXData(m,f);m=this.getRegressionLineParameters(g,h);h=this.getEndPointY(m,g[g.length-1]);e.values.push({regressionLineParameters:m,x:k,y:h});e.xData.push(k);e.yData.push(h)}return e};d.defaultOptions=t(m.defaultOptions,{params:{xAxisUnit:null},tooltip:{valueDecimals:4}});return d}(m);p(e.prototype,{nameBase:"Linear Regression Indicator"});
f.registerSeriesType("linearRegression",e);"";return e});v(f,"Stock/Indicators/LinearRegressionSlopes/LinearRegressionSlopes.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(f,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(f,d)};return function(f,d){function a(){this.constructor=f}e(f,d);f.prototype=null===
d?Object.create(d):(a.prototype=d.prototype,new a)}}(),m=f.seriesTypes.linearRegression,k=e.extend,p=e.merge;e=function(e){function f(){var d=null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}g(f,e);f.prototype.getEndPointY=function(d){return d.slope};f.defaultOptions=p(m.defaultOptions);return f}(m);k(e.prototype,{nameBase:"Linear Regression Slope Indicator"});f.registerSeriesType("linearRegressionSlope",e);"";return e});v(f,"Stock/Indicators/LinearRegressionIntercept/LinearRegressionIntercept.js",
[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(f,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(f,d)};return function(f,d){function a(){this.constructor=f}e(f,d);f.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),m=f.seriesTypes.linearRegression,k=e.extend,p=e.merge;e=function(e){function f(){var d=
null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}g(f,e);f.prototype.getEndPointY=function(d){return d.intercept};f.defaultOptions=p(m.defaultOptions);return f}(m);k(e.prototype,{nameBase:"Linear Regression Intercept Indicator"});f.registerSeriesType("linearRegressionIntercept",e);"";return e});v(f,"Stock/Indicators/LinearRegressionAngle/LinearRegressionAngle.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||
function(){var e=function(f,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(f,d)};return function(f,d){function a(){this.constructor=f}e(f,d);f.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),m=f.seriesTypes.linearRegression,k=e.extend,p=e.merge;e=function(e){function f(){var d=null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;
return d}g(f,e);f.prototype.slopeToAngle=function(d){return 180/Math.PI*Math.atan(d)};f.prototype.getEndPointY=function(d){return this.slopeToAngle(d.slope)};f.defaultOptions=p(m.defaultOptions,{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span>{series.name}: <b>{point.y}\u00b0</b><br/>'}});return f}(m);k(e.prototype,{nameBase:"Linear Regression Angle Indicator"});f.registerSeriesType("linearRegressionAngle",e);"";return e});v(f,"Stock/Indicators/ABands/ABandsIndicator.js",[f["Stock/Indicators/MultipleLinesComposition.js"],
f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,g){var m=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),k=e.seriesTypes.sma,p=g.correctFloat,t=g.extend,h=g.merge;g=function(d){function a(){var a=
null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}m(a,d);a.prototype.getValues=function(a,c){var b=c.period,e=c.factor;c=c.index;var f=a.xData,h=(a=a.yData)?a.length:0,g=[],k=[],m=[],n=[],t=[],q;if(!(h<b)){for(q=0;q<=h;q++){if(q<h){var u=a[q][2];var v=a[q][1];var x=e;u=p(v-u)/(p(v+u)/2)*1E3*x;g.push(a[q][1]*p(1+2*u));k.push(a[q][2]*p(1-2*u))}if(q>=b){u=f.slice(q-b,q);var M=a.slice(q-b,q);x=d.prototype.getValues.call(this,{xData:u,yData:g.slice(q-b,q)},
{period:b});v=d.prototype.getValues.call(this,{xData:u,yData:k.slice(q-b,q)},{period:b});M=d.prototype.getValues.call(this,{xData:u,yData:M},{period:b,index:c});u=M.xData[0];x=x.yData[0];v=v.yData[0];M=M.yData[0];m.push([u,x,M,v]);n.push(u);t.push([x,M,v])}}return{values:m,xData:n,yData:t}}};a.defaultOptions=h(k.defaultOptions,{params:{period:20,factor:.001,index:3},lineWidth:1,topLine:{styles:{lineWidth:1}},bottomLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}});return a}(k);
t(g.prototype,{areaLinesNames:["top","bottom"],linesApiNames:["topLine","bottomLine"],nameBase:"Acceleration Bands",nameComponents:["period","factor"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"});f.compose(g);e.registerSeriesType("abands",g);"";return g});v(f,"Stock/Indicators/TrendLine/TrendLineIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return e(d,a)};return function(d,a){function b(){this.constructor=d}e(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.sma,k=e.extend,p=e.merge,t=e.isArray;e=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}g(d,e);d.prototype.getValues=function(a,b){var c=a.xData,d=a.yData;a=[];
var e=[],f=[],g=0,h=0,k=0,m=0,n=c.length,p=b.index;for(b=0;b<n;b++){var q=c[b];var u=t(d[b])?d[b][p]:d[b];g+=q;h+=u;k+=q*u;m+=q*q}d=(n*k-g*h)/(n*m-g*g);isNaN(d)&&(d=0);g=(h-d*g)/n;for(b=0;b<n;b++)q=c[b],u=d*q+g,a[b]=[q,u],e[b]=q,f[b]=u;return{xData:e,yData:f,values:a}};d.defaultOptions=p(m.defaultOptions,{params:{period:void 0,index:3}});return d}(m);k(e.prototype,{nameBase:"Trendline",nameComponents:!1});f.registerSeriesType("trendline",e);"";return e});v(f,"Stock/Indicators/DisparityIndex/DisparityIndexIndicator.js",
[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var g=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),m=f.seriesTypes.sma,k=e.correctFloat,p=e.defined,t=e.extend,h=e.isArray,
d=e.merge;e=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.averageIndicator=void 0;b.data=void 0;b.options=void 0;b.points=void 0;return b}g(b,a);b.prototype.init=function(){var a=arguments,b=a[1].params;this.averageIndicator=f.seriesTypes[b&&b.average?b.average:void 0]||m;this.averageIndicator.prototype.init.apply(this,a)};b.prototype.calculateDisparityIndex=function(a,b){return k(a-b)/b*100};b.prototype.getValues=function(a,b){var c=b.index,d=a.xData,e=a.yData,f=e?e.length:
0,g=[],k=[],l=[],m=this.averageIndicator,q=h(e[0]);b=m.prototype.getValues(a,b);a=b.yData;b=d.indexOf(b.xData[0]);if(a&&0!==a.length&&p(c)&&!(e.length<=b)){for(m=b;m<f;m++){var t=this.calculateDisparityIndex(q?e[m][c]:e[m],a[m-b]);g.push([d[m],t]);k.push(d[m]);l.push(t)}return{values:g,xData:k,yData:l}}};b.defaultOptions=d(m.defaultOptions,{params:{average:"sma",index:3},marker:{enabled:!1},dataGrouping:{approximation:"averages"}});return b}(m);t(e.prototype,{nameBase:"Disparity Index",nameComponents:["period",
"average"]});f.registerSeriesType("disparityindex",e);"";return e});v(f,"masters/indicators/indicators-all.src.js",[],function(){})});
//# sourceMappingURL=indicators-all.js.map