/*
 Highcharts JS v10.0.0 (2022-03-07)

 Annotations module

 (c) 2009-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/annotations",["highcharts"],function(u){a(u);a.Highcharts=u;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function u(c,a,t,v){c.hasOwnProperty(a)||(c[a]=v.apply(null,t),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:a,module:c[a]}})))}a=a?a._modules:{};
u(a,"Extensions/Annotations/Mixins/EventEmitterMixin.js",[a["Core/Globals.js"],a["Core/Utilities.js"]],function(c,a){var h=a.addEvent,v=a.fireEvent,q=a.objectEach,l=a.pick,b=a.removeEvent;return{addEvents:function(){var b=this,d=function(d){h(d,c.isTouchDevice?"touchstart":"mousedown",function(d){b.onMouseDown(d)},{passive:!1})};d(this.graphic.element);(b.labels||[]).forEach(function(b){b.options.useHTML&&b.graphic.text&&d(b.graphic.text.element)});q(b.options.events,function(d,g){var f=function(f){"click"===
g&&b.cancelClick||d.call(b,b.chart.pointer.normalize(f),b.target)};if(-1===(b.nonDOMEvents||[]).indexOf(g))b.graphic.on(g,f);else h(b,g,f,{passive:!1})});if(b.options.draggable&&(h(b,"drag",b.onDrag),!b.graphic.renderer.styledMode)){var g={cursor:{x:"ew-resize",y:"ns-resize",xy:"move"}[b.options.draggable]};b.graphic.css(g);(b.labels||[]).forEach(function(d){d.options.useHTML&&d.graphic.text&&d.graphic.text.css(g)})}b.isUpdating||v(b,"add")},removeDocEvents:function(){this.removeDrag&&(this.removeDrag=
this.removeDrag());this.removeMouseUp&&(this.removeMouseUp=this.removeMouseUp())},onMouseDown:function(b){var d=this,g=d.chart.pointer;b.preventDefault&&b.preventDefault();if(2!==b.button){b=g.normalize(b);var f=b.chartX;var x=b.chartY;d.cancelClick=!1;d.chart.hasDraggedAnnotation=!0;d.removeDrag=h(c.doc,c.isTouchDevice?"touchmove":"mousemove",function(b){d.hasDragged=!0;b=g.normalize(b);b.prevChartX=f;b.prevChartY=x;v(d,"drag",b);f=b.chartX;x=b.chartY},c.isTouchDevice?{passive:!1}:void 0);d.removeMouseUp=
h(c.doc,c.isTouchDevice?"touchend":"mouseup",function(b){var g=l(d.target&&d.target.annotation,d.target);g&&(g.cancelClick=d.hasDragged);d.cancelClick=d.hasDragged;d.hasDragged=!1;d.chart.hasDraggedAnnotation=!1;v(l(g,d),"afterUpdate");d.onMouseUp(b)},c.isTouchDevice?{passive:!1}:void 0)}},onMouseUp:function(b){var d=this.chart;b=this.target||this;var g=d.options.annotations;d=d.annotations.indexOf(b);this.removeDocEvents();g[d]=b.options},onDrag:function(b){if(this.chart.isInsidePlot(b.chartX-this.chart.plotLeft,
b.chartY-this.chart.plotTop,{visiblePlotOnly:!0})){var d=this.mouseMoveToTranslation(b);"x"===this.options.draggable&&(d.y=0);"y"===this.options.draggable&&(d.x=0);this.points.length?this.translate(d.x,d.y):(this.shapes.forEach(function(b){b.translate(d.x,d.y)}),this.labels.forEach(function(b){b.translate(d.x,d.y)}));this.redraw(!1)}},mouseMoveToRadians:function(b,d,g){var f=b.prevChartY-g,c=b.prevChartX-d;g=b.chartY-g;b=b.chartX-d;this.chart.inverted&&(d=c,c=f,f=d,d=b,b=g,g=d);return Math.atan2(g,
b)-Math.atan2(f,c)},mouseMoveToTranslation:function(b){var d=b.chartX-b.prevChartX;b=b.chartY-b.prevChartY;if(this.chart.inverted){var g=b;b=d;d=g}return{x:d,y:b}},mouseMoveToScale:function(b,d,g){d=(b.chartX-d||1)/(b.prevChartX-d||1);b=(b.chartY-g||1)/(b.prevChartY-g||1);this.chart.inverted&&(g=b,b=d,d=g);return{x:d,y:b}},destroy:function(){this.removeDocEvents();b(this);this.hcEvents=null}}});u(a,"Extensions/Annotations/ControlPoint.js",[a["Core/Utilities.js"],a["Extensions/Annotations/Mixins/EventEmitterMixin.js"]],
function(c,a){var h=c.merge,v=c.pick;return function(){function c(c,b,x,d){this.addEvents=a.addEvents;this.graphic=void 0;this.mouseMoveToRadians=a.mouseMoveToRadians;this.mouseMoveToScale=a.mouseMoveToScale;this.mouseMoveToTranslation=a.mouseMoveToTranslation;this.onDrag=a.onDrag;this.onMouseDown=a.onMouseDown;this.onMouseUp=a.onMouseUp;this.removeDocEvents=a.removeDocEvents;this.nonDOMEvents=["drag"];this.chart=c;this.target=b;this.options=x;this.index=v(x.index,d)}c.prototype.setVisibility=function(c){this.graphic.attr("visibility",
c?"visible":"hidden");this.options.visible=c};c.prototype.render=function(){var c=this.chart,b=this.options;this.graphic=c.renderer.symbol(b.symbol,0,0,b.width,b.height).add(c.controlPointsGroup).css(b.style);this.setVisibility(b.visible);this.addEvents()};c.prototype.redraw=function(c){this.graphic[c?"animate":"attr"](this.options.positioner.call(this,this.target))};c.prototype.destroy=function(){a.destroy.call(this);this.graphic&&(this.graphic=this.graphic.destroy());this.options=this.target=this.chart=
null};c.prototype.update=function(c){var b=this.chart,a=this.target,d=this.index;c=h(!0,this.options,c);this.destroy();this.constructor(b,a,c,d);this.render(b.controlPointsGroup);this.redraw()};return c}()});u(a,"Extensions/Annotations/MockPoint.js",[a["Core/Series/Series.js"],a["Core/Utilities.js"],a["Core/Axis/Axis.js"]],function(c,a,t){var h=a.defined,q=a.fireEvent;return function(){function a(b,a,d){this.y=this.x=this.ttBelow=this.plotY=this.plotX=this.negative=this.isInside=void 0;this.mock=
!0;this.series={visible:!0,chart:b,getPlotBox:c.prototype.getPlotBox};this.target=a||null;this.options=d;this.applyOptions(this.getOptions())}a.fromPoint=function(b){return new a(b.series.chart,null,{x:b.x,y:b.y,xAxis:b.series.xAxis,yAxis:b.series.yAxis})};a.pointToPixels=function(b,c){var d=b.series,g=d.chart,f=b.plotX,a=b.plotY;g.inverted&&(b.mock?(f=b.plotY,a=b.plotX):(f=g.plotWidth-b.plotY,a=g.plotHeight-b.plotX));d&&!c&&(b=d.getPlotBox(),f+=b.translateX,a+=b.translateY);return{x:f,y:a}};a.pointToOptions=
function(b){return{x:b.x,y:b.y,xAxis:b.series.xAxis,yAxis:b.series.yAxis}};a.prototype.hasDynamicOptions=function(){return"function"===typeof this.options};a.prototype.getOptions=function(){return this.hasDynamicOptions()?this.options(this.target):this.options};a.prototype.applyOptions=function(b){this.command=b.command;this.setAxis(b,"x");this.setAxis(b,"y");this.refresh()};a.prototype.setAxis=function(b,c){c+="Axis";b=b[c];var d=this.series.chart;this.series[c]=b instanceof t?b:h(b)?d[c][b]||d.get(b):
null};a.prototype.toAnchor=function(){var b=[this.plotX,this.plotY,0,0];this.series.chart.inverted&&(b[0]=this.plotY,b[1]=this.plotX);return b};a.prototype.getLabelConfig=function(){return{x:this.x,y:this.y,point:this}};a.prototype.isInsidePlot=function(){var b=this.plotX,c=this.plotY,d=this.series.xAxis,g=this.series.yAxis,f={x:b,y:c,isInsidePlot:!0};d&&(f.isInsidePlot=h(b)&&0<=b&&b<=d.len);g&&(f.isInsidePlot=f.isInsidePlot&&h(c)&&0<=c&&c<=g.len);q(this.series.chart,"afterIsInsidePlot",f);return f.isInsidePlot};
a.prototype.refresh=function(){var b=this.series,c=b.xAxis;b=b.yAxis;var d=this.getOptions();c?(this.x=d.x,this.plotX=c.toPixels(d.x,!0)):(this.x=void 0,this.plotX=d.x);b?(this.y=d.y,this.plotY=b.toPixels(d.y,!0)):(this.y=null,this.plotY=d.y);this.isInside=this.isInsidePlot()};a.prototype.translate=function(b,c,d,g){this.hasDynamicOptions()||(this.plotX+=d,this.plotY+=g,this.refreshOptions())};a.prototype.scale=function(b,c,d,g){if(!this.hasDynamicOptions()){var f=this.plotY*g;this.plotX=(1-d)*b+
this.plotX*d;this.plotY=(1-g)*c+f;this.refreshOptions()}};a.prototype.rotate=function(b,c,d){if(!this.hasDynamicOptions()){var g=Math.cos(d);d=Math.sin(d);var f=this.plotX,a=this.plotY;f-=b;a-=c;this.plotX=f*g-a*d+b;this.plotY=f*d+a*g+c;this.refreshOptions()}};a.prototype.refreshOptions=function(){var b=this.series,c=b.xAxis;b=b.yAxis;this.x=this.options.x=c?this.options.x=c.toValue(this.plotX,!0):this.plotX;this.y=this.options.y=b?b.toValue(this.plotY,!0):this.plotY};return a}()});u(a,"Extensions/Annotations/Mixins/ControllableMixin.js",
[a["Extensions/Annotations/ControlPoint.js"],a["Extensions/Annotations/MockPoint.js"],a["Core/Tooltip.js"],a["Core/Utilities.js"]],function(c,a,t,v){var h=v.isObject,l=v.isString,b=v.merge,x=v.splat;return{init:function(b,c,f){this.annotation=b;this.chart=b.chart;this.options=c;this.points=[];this.controlPoints=[];this.index=f;this.linkPoints();this.addControlPoints()},attr:function(){this.graphic.attr.apply(this.graphic,arguments)},getPointsOptions:function(){var b=this.options;return b.points||
b.point&&x(b.point)},attrsFromOptions:function(b){var d=this.constructor.attrsMap,c={},a,r=this.chart.styledMode;for(a in b){var w=d[a];!w||r&&-1!==["fill","stroke","stroke-width"].indexOf(w)||(c[w]=b[a])}return c},anchor:function(c){var d=c.series.getPlotBox(),a=c.series.chart,k=c.mock?c.toAnchor():t.prototype.getAnchor.call({chart:c.series.chart},c);k={x:k[0]+(this.options.x||0),y:k[1]+(this.options.y||0),height:k[2]||0,width:k[3]||0};return{relativePosition:k,absolutePosition:b(k,{x:k.x+(c.mock?
d.translateX:a.plotLeft),y:k.y+(c.mock?d.translateY:a.plotTop)})}},point:function(b,c){if(b&&b.series)return b;c&&null!==c.series||(h(b)?c=new a(this.chart,this,b):l(b)?c=this.chart.get(b)||null:"function"===typeof b&&(c=b.call(c,this),c=c.series?c:new a(this.chart,this,b)));return c},linkPoints:function(){var b=this.getPointsOptions(),c=this.points,a=b&&b.length||0,k;for(k=0;k<a;k++){var r=this.point(b[k],c[k]);if(!r){c.length=0;return}r.mock&&r.refresh();c[k]=r}return c},addControlPoints:function(){var d=
this.options.controlPoints;(d||[]).forEach(function(a,f){a=b(this.options.controlPointOptions,a);a.index||(a.index=f);d[f]=a;this.controlPoints.push(new c(this.chart,this,a))},this)},shouldBeDrawn:function(){return!!this.points.length},render:function(b){this.controlPoints.forEach(function(b){b.render()})},redraw:function(b){this.controlPoints.forEach(function(c){c.redraw(b)})},transform:function(b,c,a,k,r){if(this.chart.inverted){var d=c;c=a;a=d}this.points.forEach(function(d,f){this.transformPoint(b,
c,a,k,r,f)},this)},transformPoint:function(b,c,f,k,r,w){var d=this.points[w];d.mock||(d=this.points[w]=a.fromPoint(d));d[b](c,f,k,r)},translate:function(b,c){this.transform("translate",null,null,b,c)},translatePoint:function(b,c,a){this.transformPoint("translate",null,null,b,c,a)},translateShape:function(b,c,a){var d=this.annotation.chart,f=this.annotation.userOptions,g=d.annotations.indexOf(this.annotation);d=d.options.annotations[g];this.translatePoint(b,c,0);a&&this.translatePoint(b,c,1);d[this.collection][this.index].point=
this.options.point;f[this.collection][this.index].point=this.options.point},rotate:function(b,c,a){this.transform("rotate",b,c,a)},scale:function(b,c,a,k){this.transform("scale",b,c,a,k)},setControlPointsVisibility:function(b){this.controlPoints.forEach(function(c){c.setVisibility(b)})},destroy:function(){this.graphic&&(this.graphic=this.graphic.destroy());this.tracker&&(this.tracker=this.tracker.destroy());this.controlPoints.forEach(function(b){b.destroy()});this.options=this.controlPoints=this.points=
this.chart=null;this.annotation&&(this.annotation=null)},update:function(c){var a=this.annotation;c=b(!0,this.options,c);var d=this.graphic.parentGroup;this.destroy();this.constructor(a,c,this.index);this.render(d);this.redraw()}}});u(a,"Extensions/Annotations/Mixins/MarkerMixin.js",[a["Core/Chart/Chart.js"],a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Utilities.js"]],function(c,a,t){function h(b){return function(c){this.attr(b,"url(#"+c+")")}}var q=t.addEvent,l=t.defined,b=t.merge,x=t.uniqueKey,
d={arrow:{tagName:"marker",attributes:{id:"arrow",refY:5,refX:9,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 0 L 10 5 L 0 10 Z","stroke-width":0}}]},"reverse-arrow":{tagName:"marker",attributes:{id:"reverse-arrow",refY:5,refX:1,markerWidth:10,markerHeight:10},children:[{tagName:"path",attributes:{d:"M 0 5 L 10 0 L 10 10 Z","stroke-width":0}}]}};a.prototype.addMarker=function(c,a){var d={attributes:{id:c}},f={stroke:a.color||"none",fill:a.color||"rgba(0, 0, 0, 0.75)"};
d.children=a.children&&a.children.map(function(c){return b(f,c)});a=b(!0,{attributes:{markerWidth:20,markerHeight:20,refX:0,refY:0,orient:"auto"}},a,d);a=this.definition(a);a.id=c;return a};a={markerEndSetter:h("marker-end"),markerStartSetter:h("marker-start"),setItemMarkers:function(c){var a=c.options,d=c.chart,r=d.options.defs,g=a.fill,h=l(g)&&"none"!==g?g:a.stroke;["markerStart","markerEnd"].forEach(function(f){var g=a[f],k;if(g){for(k in r){var w=r[k];if((g===(w.attributes&&w.attributes.id)||
g===w.id)&&"marker"===w.tagName){var l=w;break}}l&&(g=c[f]=d.renderer.addMarker((a.id||x())+"-"+g,b(l,{color:h})),c.attr(f,g.getAttribute("id")))}})}};q(c,"afterGetContainer",function(){this.options.defs=b(d,this.options.defs||{})});return a});u(a,"Extensions/Annotations/Controllables/ControllablePath.js",[a["Extensions/Annotations/Mixins/ControllableMixin.js"],a["Core/Globals.js"],a["Extensions/Annotations/Mixins/MarkerMixin.js"],a["Core/Utilities.js"]],function(c,a,t,v){var h=v.extend,l="rgba(192,192,192,"+
(a.svg?.0001:.002)+")";return function(){function b(b,a,g){this.addControlPoints=c.addControlPoints;this.anchor=c.anchor;this.attr=c.attr;this.attrsFromOptions=c.attrsFromOptions;this.destroy=c.destroy;this.getPointsOptions=c.getPointsOptions;this.init=c.init;this.linkPoints=c.linkPoints;this.point=c.point;this.rotate=c.rotate;this.scale=c.scale;this.setControlPointsVisibility=c.setControlPointsVisibility;this.setMarkers=t.setItemMarkers;this.transform=c.transform;this.transformPoint=c.transformPoint;
this.translate=c.translate;this.translatePoint=c.translatePoint;this.translateShape=c.translateShape;this.update=c.update;this.type="path";this.init(b,a,g);this.collection="shapes"}b.prototype.toD=function(){var b=this.options.d;if(b)return"function"===typeof b?b.call(this):b;b=this.points;var c=b.length,a=c,f=b[0],k=a&&this.anchor(f).absolutePosition,r=0,w=[];if(k)for(w.push(["M",k.x,k.y]);++r<c&&a;)f=b[r],a=f.command||"L",k=this.anchor(f).absolutePosition,"M"===a?w.push([a,k.x,k.y]):"L"===a?w.push([a,
k.x,k.y]):"Z"===a&&w.push([a]),a=f.series.visible;return a?this.chart.renderer.crispLine(w,this.graphic.strokeWidth()):null};b.prototype.shouldBeDrawn=function(){return c.shouldBeDrawn.call(this)||!!this.options.d};b.prototype.render=function(b){var a=this.options,g=this.attrsFromOptions(a);this.graphic=this.annotation.chart.renderer.path([["M",0,0]]).attr(g).add(b);a.className&&this.graphic.addClass(a.className);this.tracker=this.annotation.chart.renderer.path([["M",0,0]]).addClass("highcharts-tracker-line").attr({zIndex:2}).add(b);
this.annotation.chart.styledMode||this.tracker.attr({"stroke-linejoin":"round",stroke:l,fill:l,"stroke-width":this.graphic.strokeWidth()+2*a.snap});c.render.call(this);h(this.graphic,{markerStartSetter:t.markerStartSetter,markerEndSetter:t.markerEndSetter});this.setMarkers(this)};b.prototype.redraw=function(b){var a=this.toD(),g=b?"animate":"attr";a?(this.graphic[g]({d:a}),this.tracker[g]({d:a})):(this.graphic.attr({d:"M 0 -9000000000"}),this.tracker.attr({d:"M 0 -9000000000"}));this.graphic.placed=
this.tracker.placed=!!a;c.redraw.call(this,b)};b.attrsMap={dashStyle:"dashstyle",strokeWidth:"stroke-width",stroke:"stroke",fill:"fill",zIndex:"zIndex"};return b}()});u(a,"Extensions/Annotations/Controllables/ControllableRect.js",[a["Extensions/Annotations/Mixins/ControllableMixin.js"],a["Extensions/Annotations/Controllables/ControllablePath.js"],a["Core/Utilities.js"]],function(c,a,t){var h=t.merge;return function(){function q(a,b,h){this.addControlPoints=c.addControlPoints;this.anchor=c.anchor;
this.attr=c.attr;this.attrsFromOptions=c.attrsFromOptions;this.destroy=c.destroy;this.getPointsOptions=c.getPointsOptions;this.init=c.init;this.linkPoints=c.linkPoints;this.point=c.point;this.rotate=c.rotate;this.scale=c.scale;this.setControlPointsVisibility=c.setControlPointsVisibility;this.shouldBeDrawn=c.shouldBeDrawn;this.transform=c.transform;this.transformPoint=c.transformPoint;this.translatePoint=c.translatePoint;this.translateShape=c.translateShape;this.update=c.update;this.type="rect";this.translate=
c.translateShape;this.init(a,b,h);this.collection="shapes"}q.prototype.render=function(a){var b=this.attrsFromOptions(this.options);this.graphic=this.annotation.chart.renderer.rect(0,-9E9,0,0).attr(b).add(a);c.render.call(this)};q.prototype.redraw=function(a){var b=this.anchor(this.points[0]).absolutePosition;if(b)this.graphic[a?"animate":"attr"]({x:b.x,y:b.y,width:this.options.width,height:this.options.height});else this.attr({x:0,y:-9E9});this.graphic.placed=!!b;c.redraw.call(this,a)};q.attrsMap=
h(a.attrsMap,{width:"width",height:"height"});return q}()});u(a,"Extensions/Annotations/Controllables/ControllableCircle.js",[a["Extensions/Annotations/Mixins/ControllableMixin.js"],a["Extensions/Annotations/Controllables/ControllablePath.js"],a["Core/Utilities.js"]],function(c,a,t){var h=t.merge;return function(){function q(a,b,h){this.addControlPoints=c.addControlPoints;this.anchor=c.anchor;this.attr=c.attr;this.attrsFromOptions=c.attrsFromOptions;this.destroy=c.destroy;this.getPointsOptions=c.getPointsOptions;
this.init=c.init;this.linkPoints=c.linkPoints;this.point=c.point;this.rotate=c.rotate;this.scale=c.scale;this.setControlPointsVisibility=c.setControlPointsVisibility;this.shouldBeDrawn=c.shouldBeDrawn;this.transform=c.transform;this.transformPoint=c.transformPoint;this.translatePoint=c.translatePoint;this.translateShape=c.translateShape;this.update=c.update;this.type="circle";this.translate=c.translateShape;this.init(a,b,h);this.collection="shapes"}q.prototype.render=function(a){var b=this.attrsFromOptions(this.options);
this.graphic=this.annotation.chart.renderer.circle(0,-9E9,0).attr(b).add(a);c.render.call(this)};q.prototype.redraw=function(a){var b=this.anchor(this.points[0]).absolutePosition;if(b)this.graphic[a?"animate":"attr"]({x:b.x,y:b.y,r:this.options.r});else this.graphic.attr({x:0,y:-9E9});this.graphic.placed=!!b;c.redraw.call(this,a)};q.prototype.setRadius=function(c){this.options.r=c};q.attrsMap=h(a.attrsMap,{r:"r"});return q}()});u(a,"Extensions/Annotations/Controllables/ControllableEllipse.js",[a["Extensions/Annotations/Mixins/ControllableMixin.js"],
a["Extensions/Annotations/Controllables/ControllablePath.js"],a["Core/Utilities.js"]],function(c,a,t){var h=t.merge,q=t.defined;return function(){function l(b,a,d){this.addControlPoints=c.addControlPoints;this.anchor=c.anchor;this.attr=c.attr;this.attrsFromOptions=c.attrsFromOptions;this.destroy=c.destroy;this.getPointsOptions=c.getPointsOptions;this.linkPoints=c.linkPoints;this.point=c.point;this.scale=c.scale;this.setControlPointsVisibility=c.setControlPointsVisibility;this.shouldBeDrawn=c.shouldBeDrawn;
this.transform=c.transform;this.translatePoint=c.translatePoint;this.transformPoint=c.transformPoint;this.type="ellipse";this.init(b,a,d);this.collection="shapes"}l.prototype.init=function(b,a,d){q(a.yAxis)&&a.points.forEach(function(b){b.yAxis=a.yAxis});q(a.xAxis)&&a.points.forEach(function(b){b.xAxis=a.xAxis});c.init.call(this,b,a,d)};l.prototype.render=function(b){this.graphic=this.annotation.chart.renderer.createElement("ellipse").attr(this.attrsFromOptions(this.options)).add(b);c.render.call(this)};
l.prototype.translate=function(b,a){c.translateShape.call(this,b,a,!0)};l.prototype.getDistanceFromLine=function(b,c,a,g){return Math.abs((c.y-b.y)*a-(c.x-b.x)*g+c.x*b.y-c.y*b.x)/Math.sqrt((c.y-b.y)*(c.y-b.y)+(c.x-b.x)*(c.x-b.x))};l.prototype.getAttrs=function(b,c){var a=b.x,g=b.y,f=c.x,k=c.y;c=(a+f)/2;b=(g+k)/2;var r=Math.sqrt((a-f)*(a-f)/4+(g-k)*(g-k)/4);g=180*Math.atan((k-g)/(f-a))/Math.PI;c<a&&(g+=180);a=this.getRY();return{cx:c,cy:b,rx:r,ry:a,angle:g}};l.prototype.getRY=function(){var b=this.getYAxis();
return q(b)?Math.abs(b.toPixels(this.options.ry)-b.toPixels(0)):this.options.ry};l.prototype.getYAxis=function(){return this.chart.yAxis[this.options.yAxis]};l.prototype.getAbsolutePosition=function(b){return this.anchor(b).absolutePosition};l.prototype.redraw=function(b){var a=this.getAbsolutePosition(this.points[0]),d=this.getAbsolutePosition(this.points[1]);d=this.getAttrs(a,d);if(a)this.graphic[b?"animate":"attr"]({cx:d.cx,cy:d.cy,rx:d.rx,ry:d.ry,rotation:d.angle,rotationOriginX:d.cx,rotationOriginY:d.cy});
else this.graphic.attr({x:0,y:-9E9});this.graphic.placed=!!a;c.redraw.call(this,b)};l.prototype.setYRadius=function(b){this.options.ry=b;this.annotation.userOptions.shapes[0].ry=b;this.annotation.options.shapes[0].ry=b};l.attrsMap=h(a.attrsMap,{ry:"ry"});return l}()});u(a,"Extensions/Annotations/Controllables/ControllableLabel.js",[a["Extensions/Annotations/Mixins/ControllableMixin.js"],a["Core/FormatUtilities.js"],a["Extensions/Annotations/MockPoint.js"],a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Tooltip.js"],
a["Core/Utilities.js"]],function(c,a,t,v,q,l){var b=a.format;a=v.prototype.symbols;var h=l.extend,d=l.isNumber,g=l.pick;l=function(){function a(b,a,d){this.addControlPoints=c.addControlPoints;this.attr=c.attr;this.attrsFromOptions=c.attrsFromOptions;this.destroy=c.destroy;this.getPointsOptions=c.getPointsOptions;this.init=c.init;this.linkPoints=c.linkPoints;this.point=c.point;this.rotate=c.rotate;this.scale=c.scale;this.setControlPointsVisibility=c.setControlPointsVisibility;this.shouldBeDrawn=c.shouldBeDrawn;
this.transform=c.transform;this.transformPoint=c.transformPoint;this.translateShape=c.translateShape;this.update=c.update;this.init(b,a,d);this.collection="labels"}a.alignedPosition=function(b,a){var c=b.align,d=b.verticalAlign,f=(a.x||0)+(b.x||0),r=(a.y||0)+(b.y||0),g,k;"right"===c?g=1:"center"===c&&(g=2);g&&(f+=(a.width-(b.width||0))/g);"bottom"===d?k=1:"middle"===d&&(k=2);k&&(r+=(a.height-(b.height||0))/k);return{x:Math.round(f),y:Math.round(r)}};a.justifiedOptions=function(b,a,c,d){var f=c.align,
g=c.verticalAlign,k=a.box?0:a.padding||0,r=a.getBBox();a={align:f,verticalAlign:g,x:c.x,y:c.y,width:a.width,height:a.height};c=(d.x||0)-b.plotLeft;d=(d.y||0)-b.plotTop;var h=c+k;0>h&&("right"===f?a.align="left":a.x=(a.x||0)-h);h=c+r.width-k;h>b.plotWidth&&("left"===f?a.align="right":a.x=(a.x||0)+b.plotWidth-h);h=d+k;0>h&&("bottom"===g?a.verticalAlign="top":a.y=(a.y||0)-h);h=d+r.height-k;h>b.plotHeight&&("top"===g?a.verticalAlign="bottom":a.y=(a.y||0)+b.plotHeight-h);return a};a.prototype.translatePoint=
function(b,a){c.translatePoint.call(this,b,a,0)};a.prototype.translate=function(b,a){var c=this.annotation.chart,d=this.annotation.userOptions,f=c.annotations.indexOf(this.annotation);f=c.options.annotations[f];c.inverted&&(c=b,b=a,a=c);this.options.x+=b;this.options.y+=a;f[this.collection][this.index].x=this.options.x;f[this.collection][this.index].y=this.options.y;d[this.collection][this.index].x=this.options.x;d[this.collection][this.index].y=this.options.y};a.prototype.render=function(b){var d=
this.options,f=this.attrsFromOptions(d),g=d.style;this.graphic=this.annotation.chart.renderer.label("",0,-9999,d.shape,null,null,d.useHTML,null,"annotation-label").attr(f).add(b);this.annotation.chart.styledMode||("contrast"===g.color&&(g.color=this.annotation.chart.renderer.getContrast(-1<a.shapesWithoutBackground.indexOf(d.shape)?"#FFFFFF":d.backgroundColor)),this.graphic.css(d.style).shadow(d.shadow));d.className&&this.graphic.addClass(d.className);this.graphic.labelrank=d.labelrank;c.render.call(this)};
a.prototype.redraw=function(a){var d=this.options,f=this.text||d.format||d.text,g=this.graphic,h=this.points[0];g.attr({text:f?b(f,h.getLabelConfig(),this.annotation.chart):d.formatter.call(h,this)});d=this.anchor(h);(f=this.position(d))?(g.alignAttr=f,f.anchorX=d.absolutePosition.x,f.anchorY=d.absolutePosition.y,g[a?"animate":"attr"](f)):g.attr({x:0,y:-9999});g.placed=!!f;c.redraw.call(this,a)};a.prototype.anchor=function(b){var a=c.anchor.apply(this,arguments),d=this.options.x||0,f=this.options.y||
0;a.absolutePosition.x-=d;a.absolutePosition.y-=f;a.relativePosition.x-=d;a.relativePosition.y-=f;return a};a.prototype.position=function(b){var c=this.graphic,d=this.annotation.chart,f=this.points[0],k=this.options,l=b.absolutePosition,v=b.relativePosition,y=f.series.visible&&t.prototype.isInsidePlot.call(f);b=c.width;b=void 0===b?0:b;var u=c.height;u=void 0===u?0:u;if(y){if(k.distance)var x=q.prototype.getPosition.call({chart:d,distance:g(k.distance,16)},b,u,{plotX:v.x,plotY:v.y,negative:f.negative,
ttBelow:f.ttBelow,h:v.height||v.width});else k.positioner?x=k.positioner.call(this):(f={x:l.x,y:l.y,width:0,height:0},x=a.alignedPosition(h(k,{width:b,height:u}),f),"justify"===this.options.overflow&&(x=a.alignedPosition(a.justifiedOptions(d,c,k,x),f)));k.crop&&(c=x.x-d.plotLeft,k=x.y-d.plotTop,y=d.isInsidePlot(c,k)&&d.isInsidePlot(c+b,k+u))}return y?x:null};a.attrsMap={backgroundColor:"fill",borderColor:"stroke",borderWidth:"stroke-width",zIndex:"zIndex",borderRadius:"r",padding:"padding"};a.shapesWithoutBackground=
["connector"];return a}();a.connector=function(b,a,c,g,h){var f=h&&h.anchorX;h=h&&h.anchorY;var k=c/2;if(d(f)&&d(h)){var l=[["M",f,h]];var q=a-h;0>q&&(q=-g-q);q<c&&(k=f<b+c/2?q:c-q);h>a+g?l.push(["L",b+k,a+g]):h<a?l.push(["L",b+k,a]):f<b?l.push(["L",b,a+g/2]):f>b+c&&l.push(["L",b+c,a+g/2])}return l||[]};return l});u(a,"Extensions/Annotations/Controllables/ControllableImage.js",[a["Extensions/Annotations/Controllables/ControllableLabel.js"],a["Extensions/Annotations/Mixins/ControllableMixin.js"]],
function(a,h){return function(){function c(a,c,l){this.addControlPoints=h.addControlPoints;this.anchor=h.anchor;this.attr=h.attr;this.attrsFromOptions=h.attrsFromOptions;this.destroy=h.destroy;this.getPointsOptions=h.getPointsOptions;this.init=h.init;this.linkPoints=h.linkPoints;this.point=h.point;this.rotate=h.rotate;this.scale=h.scale;this.setControlPointsVisibility=h.setControlPointsVisibility;this.shouldBeDrawn=h.shouldBeDrawn;this.transform=h.transform;this.transformPoint=h.transformPoint;this.translatePoint=
h.translatePoint;this.translateShape=h.translateShape;this.update=h.update;this.type="image";this.translate=h.translateShape;this.init(a,c,l);this.collection="shapes"}c.prototype.render=function(a){var c=this.attrsFromOptions(this.options),l=this.options;this.graphic=this.annotation.chart.renderer.image(l.src,0,-9E9,l.width,l.height).attr(c).add(a);this.graphic.width=l.width;this.graphic.height=l.height;h.render.call(this)};c.prototype.redraw=function(c){var q=this.anchor(this.points[0]);if(q=a.prototype.position.call(this,
q))this.graphic[c?"animate":"attr"]({x:q.x,y:q.y});else this.graphic.attr({x:0,y:-9E9});this.graphic.placed=!!q;h.redraw.call(this,c)};c.attrsMap={width:"width",height:"height",zIndex:"zIndex"};return c}()});u(a,"Extensions/Annotations/Annotations.js",[a["Core/Animation/AnimationUtilities.js"],a["Core/Chart/Chart.js"],a["Extensions/Annotations/Mixins/ControllableMixin.js"],a["Extensions/Annotations/Controllables/ControllableRect.js"],a["Extensions/Annotations/Controllables/ControllableCircle.js"],
a["Extensions/Annotations/Controllables/ControllableEllipse.js"],a["Extensions/Annotations/Controllables/ControllablePath.js"],a["Extensions/Annotations/Controllables/ControllableImage.js"],a["Extensions/Annotations/Controllables/ControllableLabel.js"],a["Extensions/Annotations/ControlPoint.js"],a["Extensions/Annotations/Mixins/EventEmitterMixin.js"],a["Core/Globals.js"],a["Extensions/Annotations/MockPoint.js"],a["Core/Pointer.js"],a["Core/Utilities.js"]],function(a,h,t,v,q,l,b,u,d,g,f,k,r,w,z){var c=
a.getDeferredAnimation;a=h.prototype;var x=z.addEvent,E=z.defined,y=z.destroyObjectProperties,C=z.erase,G=z.extend,n=z.find,m=z.fireEvent,e=z.merge,p=z.pick,A=z.splat;z=z.wrap;var B=function(){function a(a,b){this.annotation=void 0;this.coll="annotations";this.shapesGroup=this.labelsGroup=this.labelCollector=this.group=this.graphic=this.animationConfig=this.collection=void 0;this.chart=a;this.points=[];this.controlPoints=[];this.coll="annotations";this.labels=[];this.shapes=[];this.options=e(this.defaultOptions,
b);this.userOptions=b;b=this.getLabelsAndShapesOptions(this.options,b);this.options.labels=b.labels;this.options.shapes=b.shapes;this.init(a,this.options)}a.prototype.init=function(){var a=this.chart,b=this.options.animation;this.linkPoints();this.addControlPoints();this.addShapes();this.addLabels();this.setLabelCollector();this.animationConfig=c(a,b)};a.prototype.getLabelsAndShapesOptions=function(a,b){var c={};["labels","shapes"].forEach(function(p){a[p]&&(c[p]=b[p]?A(b[p]).map(function(b,c){return e(a[p][c],
b)}):a[p])});return c};a.prototype.addShapes=function(){(this.options.shapes||[]).forEach(function(a,b){a=this.initShape(a,b);e(!0,this.options.shapes[b],a.options)},this)};a.prototype.addLabels=function(){(this.options.labels||[]).forEach(function(a,b){a=this.initLabel(a,b);e(!0,this.options.labels[b],a.options)},this)};a.prototype.addClipPaths=function(){this.setClipAxes();this.clipXAxis&&this.clipYAxis&&this.options.crop&&(this.clipRect=this.chart.renderer.clipRect(this.getClipBox()))};a.prototype.setClipAxes=
function(){var a=this.chart.xAxis,b=this.chart.yAxis,c=(this.options.labels||[]).concat(this.options.shapes||[]).reduce(function(c,e){e=e&&(e.point||e.points&&e.points[0]);return[a[e&&e.xAxis]||c[0],b[e&&e.yAxis]||c[1]]},[]);this.clipXAxis=c[0];this.clipYAxis=c[1]};a.prototype.getClipBox=function(){if(this.clipXAxis&&this.clipYAxis)return{x:this.clipXAxis.left,y:this.clipYAxis.top,width:this.clipXAxis.width,height:this.clipYAxis.height}};a.prototype.setLabelCollector=function(){var a=this;a.labelCollector=
function(){return a.labels.reduce(function(a,b){b.options.allowOverlap||a.push(b.graphic);return a},[])};a.chart.labelCollectors.push(a.labelCollector)};a.prototype.setOptions=function(a){this.options=e(this.defaultOptions,a)};a.prototype.redraw=function(a){this.linkPoints();this.graphic||this.render();this.clipRect&&this.clipRect.animate(this.getClipBox());this.redrawItems(this.shapes,a);this.redrawItems(this.labels,a);t.redraw.call(this,a)};a.prototype.redrawItems=function(a,b){for(var c=a.length;c--;)this.redrawItem(a[c],
b)};a.prototype.renderItems=function(a){for(var b=a.length;b--;)this.renderItem(a[b])};a.prototype.render=function(){var a=this.chart.renderer;this.graphic=a.g("annotation").attr({opacity:0,zIndex:this.options.zIndex,visibility:this.options.visible?"visible":"hidden"}).add();this.shapesGroup=a.g("annotation-shapes").add(this.graphic);this.options.crop&&this.shapesGroup.clip(this.chart.plotBoxClip);this.labelsGroup=a.g("annotation-labels").attr({translateX:0,translateY:0}).add(this.graphic);this.addClipPaths();
this.clipRect&&this.graphic.clip(this.clipRect);this.renderItems(this.shapes);this.renderItems(this.labels);this.addEvents();t.render.call(this)};a.prototype.setVisibility=function(a){var b=this.options,c=this.chart.navigationBindings;a=p(a,!b.visible);this.graphic.attr("visibility",a?"visible":"hidden");a||(this.setControlPointsVisibility(!1),c.activeAnnotation===this&&c.popup&&"annotation-toolbar"===c.popup.formType&&m(c,"closePopup"));b.visible=a};a.prototype.setControlPointsVisibility=function(a){var b=
function(b){b.setControlPointsVisibility(a)};t.setControlPointsVisibility.call(this,a);this.shapes.forEach(b);this.labels.forEach(b)};a.prototype.destroy=function(){var a=this.chart,b=function(a){a.destroy()};this.labels.forEach(b);this.shapes.forEach(b);this.clipYAxis=this.clipXAxis=null;C(a.labelCollectors,this.labelCollector);f.destroy.call(this);t.destroy.call(this);y(this,a)};a.prototype.remove=function(){return this.chart.removeAnnotation(this)};a.prototype.update=function(a,b){var c=this.chart,
d=this.getLabelsAndShapesOptions(this.userOptions,a),A=c.annotations.indexOf(this);a=e(!0,this.userOptions,a);a.labels=d.labels;a.shapes=d.shapes;this.destroy();this.constructor(c,a);c.options.annotations[A]=a;this.isUpdating=!0;p(b,!0)&&c.redraw();m(this,"afterUpdate");this.isUpdating=!1};a.prototype.initShape=function(b,c){b=e(this.options.shapeOptions,{controlPointOptions:this.options.controlPointOptions},b);c=new a.shapesMap[b.type](this,b,c);c.itemType="shape";this.shapes.push(c);return c};a.prototype.initLabel=
function(a,b){a=e(this.options.labelOptions,{controlPointOptions:this.options.controlPointOptions},a);b=new d(this,a,b);b.itemType="label";this.labels.push(b);return b};a.prototype.redrawItem=function(a,b){a.linkPoints();a.shouldBeDrawn()?(a.graphic||this.renderItem(a),a.redraw(p(b,!0)&&a.graphic.placed),a.points.length&&this.adjustVisibility(a)):this.destroyItem(a)};a.prototype.adjustVisibility=function(a){var b=!1,c=a.graphic;a.points.forEach(function(a){!1!==a.series.visible&&!1!==a.visible&&(b=
!0)});b?"hidden"===c.visibility&&c.show():c.hide()};a.prototype.destroyItem=function(a){C(this[a.itemType+"s"],a);a.destroy()};a.prototype.renderItem=function(a){a.render("label"===a.itemType?this.labelsGroup:this.shapesGroup)};a.ControlPoint=g;a.MockPoint=r;a.shapesMap={rect:v,circle:q,ellipse:l,path:b,image:u};a.types={};return a}();e(!0,B.prototype,t,f,e(B.prototype,{nonDOMEvents:["add","afterUpdate","drag","remove"],defaultOptions:{visible:!0,animation:{},crop:!0,draggable:"xy",labelOptions:{align:"center",
allowOverlap:!1,backgroundColor:"rgba(0, 0, 0, 0.75)",borderColor:"#000000",borderRadius:3,borderWidth:1,className:"highcharts-no-tooltip",crop:!1,formatter:function(){return E(this.y)?this.y:"Annotation label"},includeInDataExport:!0,overflow:"justify",padding:5,shadow:!1,shape:"callout",style:{fontSize:"11px",fontWeight:"normal",color:"contrast"},useHTML:!1,verticalAlign:"bottom",x:0,y:-16},shapeOptions:{stroke:"rgba(0, 0, 0, 0.75)",strokeWidth:1,fill:"rgba(0, 0, 0, 0.75)",r:0,snap:2},controlPointOptions:{symbol:"circle",
width:10,height:10,style:{cursor:"pointer",fill:"#ffffff",stroke:"#000000","stroke-width":2},visible:!1,events:{}},events:{},zIndex:6}}));k.extendAnnotation=function(a,b,c,p){b=b||B;G(a.prototype,e(b.prototype,c));a.prototype.defaultOptions=e(a.prototype.defaultOptions,p||{})};G(a,{initAnnotation:function(a){a=new (B.types[a.type]||B)(this,a);this.annotations.push(a);return a},addAnnotation:function(a,b){a=this.initAnnotation(a);this.options.annotations.push(a.options);p(b,!0)&&(a.redraw(),a.graphic.attr({opacity:1}));
return a},removeAnnotation:function(a){var b=this.annotations,c="annotations"===a.coll?a:n(b,function(b){return b.options.id===a});c&&(m(c,"remove"),C(this.options.annotations,c.options),C(b,c),c.destroy())},drawAnnotations:function(){this.plotBoxClip.attr(this.plotBox);this.annotations.forEach(function(a){a.redraw();a.graphic.animate({opacity:1},a.animationConfig)})}});a.collectionsWithUpdate.push("annotations");a.collectionsWithInit.annotations=[a.addAnnotation];x(h,"afterInit",function(){this.annotations=
[];this.options.annotations||(this.options.annotations=[])});a.callbacks.push(function(a){a.plotBoxClip=this.renderer.clipRect(this.plotBox);a.controlPointsGroup=a.renderer.g("control-points").attr({zIndex:99}).clip(a.plotBoxClip).add();a.options.annotations.forEach(function(b,c){if(!a.annotations.some(function(a){return a.options===b})){var e=a.initAnnotation(b);a.options.annotations[c]=e.options}});a.drawAnnotations();x(a,"redraw",a.drawAnnotations);x(a,"destroy",function(){a.plotBoxClip.destroy();
a.controlPointsGroup.destroy()});x(a,"exportData",function(b){var c=(this.options.exporting&&this.options.exporting.csv||{}).columnHeaderFormatter,e=!b.dataRows[1].xValues,p=a.options.lang&&a.options.lang.exportData&&a.options.lang.exportData.annotationHeader,d=function(a){if(c){var b=c(a);if(!1!==b)return b}b=p+" "+a;return e?{columnTitle:b,topLevelColumnTitle:b}:b},A=b.dataRows[0].length,B=a.options.exporting&&a.options.exporting.csv&&a.options.exporting.csv.annotations&&a.options.exporting.csv.annotations.itemDelimiter,
f=a.options.exporting&&a.options.exporting.csv&&a.options.exporting.csv.annotations&&a.options.exporting.csv.annotations.join;a.annotations.forEach(function(a){a.options.labelOptions.includeInDataExport&&a.labels.forEach(function(a){if(a.options.text){var c=a.options.text;a.points.forEach(function(a){var e=a.x,p=a.series.xAxis?a.series.xAxis.options.index:-1,d=!1;if(-1===p){a=b.dataRows[0].length;for(var m=Array(a),n=0;n<a;++n)m[n]="";m.push(c);m.xValues=[];m.xValues[p]=e;b.dataRows.push(m);d=!0}d||
b.dataRows.forEach(function(a){!d&&a.xValues&&void 0!==p&&e===a.xValues[p]&&(f&&a.length>A?a[a.length-1]+=B+c:a.push(c),d=!0)});if(!d){a=b.dataRows[0].length;m=Array(a);for(n=0;n<a;++n)m[n]="";m[0]=e;m.push(c);m.xValues=[];void 0!==p&&(m.xValues[p]=e);b.dataRows.push(m)}})}})});var m=0;b.dataRows.forEach(function(a){m=Math.max(m,a.length)});for(var n=m-b.dataRows[0].length,g=0;g<n;g++){var H=d(g+1);e?(b.dataRows[0].push(H.topLevelColumnTitle),b.dataRows[1].push(H.columnTitle)):b.dataRows[0].push(H)}})});
z(w.prototype,"onContainerMouseDown",function(a){this.chart.hasDraggedAnnotation||a.apply(this,Array.prototype.slice.call(arguments,1))});k.Annotation=B;"";return B});u(a,"Core/Chart/ChartNavigationComposition.js",[],function(){var a;(function(a){a.compose=function(a){a.navigation||(a.navigation=new c(a));return a};var c=function(){function a(a){this.updates=[];this.chart=a}a.prototype.addUpdate=function(a){this.chart.navigation.updates.push(a)};a.prototype.update=function(a,c){var b=this;this.updates.forEach(function(h){h.call(b.chart,
a,c)})};return a}();a.Additions=c})(a||(a={}));return a});u(a,"Extensions/Annotations/NavigationBindings.js",[a["Extensions/Annotations/Annotations.js"],a["Core/Chart/Chart.js"],a["Core/Chart/ChartNavigationComposition.js"],a["Core/FormatUtilities.js"],a["Core/Globals.js"],a["Core/DefaultOptions.js"],a["Core/Utilities.js"]],function(a,h,t,v,q,l,b){function c(a,b){var c=n.Element.prototype,e=c.matches||c.msMatchesSelector||c.webkitMatchesSelector,p=null;if(c.closest)p=c.closest.call(a,b);else{do{if(e.call(a,
b))return a;a=a.parentElement||a.parentNode}while(null!==a&&1===a.nodeType)}return p}function d(a){var b=a.prototype.defaultOptions.events&&a.prototype.defaultOptions.events.click;E(!0,a.prototype.defaultOptions.events,{click:function(a){var c=this,e=c.chart.navigationBindings,p=e.activeAnnotation;b&&b.call(c,a);p!==c?(e.deselectAnnotation(),e.activeAnnotation=c,c.setControlPointsVisibility(!0),r(e,"showPopup",{annotation:c,formType:"annotation-toolbar",options:e.annotationToFields(c),onSubmit:function(a){var b=
{};"remove"===a.actionType?(e.activeAnnotation=!1,e.chart.removeAnnotation(c)):(e.fieldsToOptions(a.fields,b),e.deselectAnnotation(),a=b.typeOptions,"measure"===c.options.type&&(a.crosshairY.enabled=0!==a.crosshairY.strokeWidth,a.crosshairX.enabled=0!==a.crosshairX.strokeWidth),c.update(b))}})):r(e,"closePopup");a.activeAnnotation=!0}})}var g=v.format;v=l.setOptions;var f=b.addEvent,k=b.attr,r=b.fireEvent,w=b.isArray,u=b.isFunction,D=b.isNumber,F=b.isObject,E=b.merge,y=b.objectEach,C=b.pick,G=q.doc,
n=q.win,m=function(){function a(a,b){this.selectedButton=this.boundClassNames=void 0;this.chart=a;this.options=b;this.eventsToUnbind=[];this.container=G.getElementsByClassName(this.options.bindingsClassName||"")}a.prototype.initEvents=function(){var a=this,b=a.chart,c=a.container,e=a.options;a.boundClassNames={};y(e.bindings||{},function(b){a.boundClassNames[b.className]=b});[].forEach.call(c,function(b){a.eventsToUnbind.push(f(b,"click",function(c){var e=a.getButtonEvents(b,c);e&&-1===e.button.className.indexOf("highcharts-disabled-btn")&&
a.bindingsButtonClick(e.button,e.events,c)}))});y(e.events||{},function(b,c){u(b)&&a.eventsToUnbind.push(f(a,c,b,{passive:!1}))});a.eventsToUnbind.push(f(b.container,"click",function(c){!b.cancelClick&&b.isInsidePlot(c.chartX-b.plotLeft,c.chartY-b.plotTop,{visiblePlotOnly:!0})&&a.bindingsChartClick(this,c)}));a.eventsToUnbind.push(f(b.container,q.isTouchDevice?"touchmove":"mousemove",function(b){a.bindingsContainerMouseMove(this,b)},q.isTouchDevice?{passive:!1}:void 0))};a.prototype.initUpdate=function(){var a=
this;t.compose(this.chart).navigation.addUpdate(function(b){a.update(b)})};a.prototype.bindingsButtonClick=function(a,b,c){var e=this.chart,d=e.renderer.boxWrapper,p=!0;this.selectedButtonElement&&(this.selectedButtonElement.classList===a.classList&&(p=!1),r(this,"deselectButton",{button:this.selectedButtonElement}),this.nextEvent&&(this.currentUserDetails&&"annotations"===this.currentUserDetails.coll&&e.removeAnnotation(this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1));p?(this.selectedButton=
b,this.selectedButtonElement=a,r(this,"selectButton",{button:a}),b.init&&b.init.call(this,a,c),(b.start||b.steps)&&e.renderer.boxWrapper.addClass("highcharts-draw-mode")):(e.stockTools&&e.stockTools.toggleButtonAciveClass(a),d.removeClass("highcharts-draw-mode"),this.mouseMoveEvent=this.nextEvent=!1,this.selectedButton=null)};a.prototype.bindingsChartClick=function(a,b){a=this.chart;var e=this.activeAnnotation,d=this.selectedButton;a=a.renderer.boxWrapper;e&&(e.cancelClick||b.activeAnnotation||!b.target.parentNode||
c(b.target,".highcharts-popup")?e.cancelClick&&setTimeout(function(){e.cancelClick=!1},0):r(this,"closePopup"));d&&d.start&&(this.nextEvent?(this.nextEvent(b,this.currentUserDetails),this.steps&&(this.stepIndex++,d.steps[this.stepIndex]?this.mouseMoveEvent=this.nextEvent=d.steps[this.stepIndex]:(r(this,"deselectButton",{button:this.selectedButtonElement}),a.removeClass("highcharts-draw-mode"),d.end&&d.end.call(this,b,this.currentUserDetails),this.mouseMoveEvent=this.nextEvent=!1,this.selectedButton=
null))):(this.currentUserDetails=d.start.call(this,b))&&d.steps?(this.stepIndex=0,this.steps=!0,this.mouseMoveEvent=this.nextEvent=d.steps[this.stepIndex]):(r(this,"deselectButton",{button:this.selectedButtonElement}),a.removeClass("highcharts-draw-mode"),this.steps=!1,this.selectedButton=null,d.end&&d.end.call(this,b,this.currentUserDetails)))};a.prototype.bindingsContainerMouseMove=function(a,b){this.mouseMoveEvent&&this.mouseMoveEvent(b,this.currentUserDetails)};a.prototype.fieldsToOptions=function(a,
b){y(a,function(a,c){var e=parseFloat(a),d=c.split("."),p=b,m=d.length-1;!D(e)||a.match(/px/g)||c.match(/format/g)||(a=e);""!==a&&"undefined"!==a&&d.forEach(function(b,c){var e=C(d[c+1],"");m===c?p[b]=a:(p[b]||(p[b]=e.match(/\d/g)?[]:{}),p=p[b])})});return b};a.prototype.deselectAnnotation=function(){this.activeAnnotation&&(this.activeAnnotation.setControlPointsVisibility(!1),this.activeAnnotation=!1)};a.prototype.annotationToFields=function(b){function c(a,e,d,n){if(d&&a&&-1===f.indexOf(e)&&(0<=
(d.indexOf&&d.indexOf(e))||d[e]||!0===d))if(w(a))n[e]=[],a.forEach(function(a,b){F(a)?(n[e][b]={},y(a,function(a,d){c(a,d,p[e],n[e][b])})):c(a,0,p[e],n[e])});else if(F(a)){var A={};w(n)?(n.push(A),A[e]={},A=A[e]):n[e]=A;y(a,function(a,b){c(a,b,0===e?d:p[e],A)})}else"format"===e?n[e]=[g(a,b.labels[0].points[0]).toString(),"text"]:w(n)?n.push([a,m(a)]):n[e]=[a,m(a)]}var e=b.options,d=a.annotationsEditable,p=d.nestedOptions,m=this.utils.getFieldType,n=C(e.type,e.shapes&&e.shapes[0]&&e.shapes[0].type,
e.labels&&e.labels[0]&&e.labels[0].itemType,"label"),f=a.annotationsNonEditable[e.langKey]||[],h={langKey:e.langKey,type:n};y(e,function(a,b){"typeOptions"===b?(h[b]={},y(e[b],function(a,e){c(a,e,p,h[b],!0)})):c(a,b,d[n],h)});return h};a.prototype.getClickedClassNames=function(a,b){var c=b.target;b=[];for(var e;c&&((e=k(c,"class"))&&(b=b.concat(e.split(" ").map(function(a){return[a,c]}))),c=c.parentNode,c!==a););return b};a.prototype.getButtonEvents=function(a,b){var c=this,e;this.getClickedClassNames(a,
b).forEach(function(a){c.boundClassNames[a[0]]&&!e&&(e={events:c.boundClassNames[a[0]],button:a[1]})});return e};a.prototype.update=function(a){this.options=E(!0,this.options,a);this.removeEvents();this.initEvents()};a.prototype.removeEvents=function(){this.eventsToUnbind.forEach(function(a){a()})};a.prototype.destroy=function(){this.removeEvents()};a.annotationsEditable={nestedOptions:{labelOptions:["style","format","backgroundColor"],labels:["style"],label:["style"],style:["fontSize","color"],background:["fill",
"strokeWidth","stroke"],innerBackground:["fill","strokeWidth","stroke"],outerBackground:["fill","strokeWidth","stroke"],shapeOptions:["fill","strokeWidth","stroke"],shapes:["fill","strokeWidth","stroke"],line:["strokeWidth","stroke"],backgroundColors:[!0],connector:["fill","strokeWidth","stroke"],crosshairX:["strokeWidth","stroke"],crosshairY:["strokeWidth","stroke"]},circle:["shapes"],ellipse:["shapes"],verticalLine:[],label:["labelOptions"],measure:["background","crosshairY","crosshairX"],fibonacci:[],
tunnel:["background","line","height"],pitchfork:["innerBackground","outerBackground"],rect:["shapes"],crookedLine:[],basicAnnotation:["shapes","labelOptions"]};a.annotationsNonEditable={rectangle:["crosshairX","crosshairY","labelOptions"],ellipse:["labelOptions"],circle:["labelOptions"]};return a}();m.prototype.utils={getFieldType:function(a){return{string:"text",number:"number","boolean":"checkbox"}[typeof a]},updateRectSize:function(a,b){var c=b.chart,e=b.options.typeOptions,d=D(e.xAxis)&&c.xAxis[e.xAxis],
p=D(e.yAxis)&&c.yAxis[e.yAxis];d&&p&&(d=d.toValue(a[d.horiz?"chartX":"chartY"]),a=p.toValue(a[p.horiz?"chartX":"chartY"]),p=d-e.point.x,e=e.point.y-a,b.update({typeOptions:{background:{width:c.inverted?e:p,height:c.inverted?p:e}}}))},getAssignedAxis:function(a){return a.filter(function(a){var b=a.axis.getExtremes(),c=b.min;b=b.max;var e=C(a.axis.minPointOffset,0);return D(c)&&D(b)&&a.value>=c-e&&a.value<=b+e&&!a.axis.options.isInternal})[0]}};h.prototype.initNavigationBindings=function(){var a=this.options;
a&&a.navigation&&a.navigation.bindings&&(this.navigationBindings=new m(this,a.navigation),this.navigationBindings.initEvents(),this.navigationBindings.initUpdate())};f(h,"load",function(){this.initNavigationBindings()});f(h,"destroy",function(){this.navigationBindings&&this.navigationBindings.destroy()});f(m,"deselectButton",function(){this.selectedButtonElement=null});f(a,"remove",function(){this.chart.navigationBindings&&this.chart.navigationBindings.deselectAnnotation()});q.Annotation&&(d(a),y(a.types,
function(a){d(a)}));v({lang:{navigation:{popup:{simpleShapes:"Simple shapes",lines:"Lines",circle:"Circle",ellipse:"Ellipse",rectangle:"Rectangle",label:"Label",shapeOptions:"Shape options",typeOptions:"Details",fill:"Fill",format:"Text",strokeWidth:"Line width",stroke:"Line color",title:"Title",name:"Name",labelOptions:"Label options",labels:"Labels",backgroundColor:"Background color",backgroundColors:"Background colors",borderColor:"Border color",borderRadius:"Border radius",borderWidth:"Border width",
style:"Style",padding:"Padding",fontSize:"Font size",color:"Color",height:"Height",shapes:"Shape options"}}},navigation:{bindingsClassName:"highcharts-bindings-container",bindings:{circleAnnotation:{className:"highcharts-circle-annotation",start:function(a){var b=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(b.xAxis);b=this.utils.getAssignedAxis(b.yAxis);var c=this.chart.options.navigation;if(a&&b)return this.chart.addAnnotation(E({langKey:"circle",type:"basicAnnotation",shapes:[{type:"circle",
point:{x:a.value,y:b.value,xAxis:a.axis.options.index,yAxis:b.axis.options.index},r:5}]},c.annotationsOptions,c.bindings.circleAnnotation.annotationsOptions))},steps:[function(a,b){var c=b.options.shapes[0].point;if(D(c.xAxis)&&D(c.yAxis)){var e=this.chart.inverted;var d=this.chart.xAxis[c.xAxis].toPixels(c.x);c=this.chart.yAxis[c.yAxis].toPixels(c.y);e=Math.max(Math.sqrt(Math.pow(e?c-a.chartX:d-a.chartX,2)+Math.pow(e?d-a.chartY:c-a.chartY,2)),5)}b.update({shapes:[{r:e}]})}]},ellipseAnnotation:{className:"highcharts-ellipse-annotation",
start:function(a){var b=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(b.xAxis);b=this.utils.getAssignedAxis(b.yAxis);var c=this.chart.options.navigation;if(a&&b)return this.chart.addAnnotation(E({langKey:"ellipse",type:"basicAnnotation",shapes:[{type:"ellipse",xAxis:a.axis.options.index,yAxis:b.axis.options.index,points:[{x:a.value,y:b.value},{x:a.value,y:b.value}],ry:1}]},c.annotationsOptions,c.bindings.ellipseAnnotation.annotationOptions))},steps:[function(a,b){b=b.shapes[0];
var c=b.getAbsolutePosition(b.points[1]);b.translatePoint(a.chartX-c.x,a.chartY-c.y,1);b.redraw(!1)},function(a,b){b=b.shapes[0];var c=b.getAbsolutePosition(b.points[0]),e=b.getAbsolutePosition(b.points[1]);a=b.getDistanceFromLine(c,e,a.chartX,a.chartY);c=b.getYAxis();a=Math.abs(c.toValue(0)-c.toValue(a));b.setYRadius(a);b.redraw(!1)}]},rectangleAnnotation:{className:"highcharts-rectangle-annotation",start:function(a){a=this.chart.pointer.getCoordinates(a);var b=this.utils.getAssignedAxis(a.xAxis),
c=this.utils.getAssignedAxis(a.yAxis);if(b&&c){a=b.value;var e=c.value;b=b.axis.options.index;c=c.axis.options.index;var d=this.chart.options.navigation;return this.chart.addAnnotation(E({langKey:"rectangle",type:"basicAnnotation",shapes:[{type:"path",points:[{xAxis:b,yAxis:c,x:a,y:e},{xAxis:b,yAxis:c,x:a,y:e},{xAxis:b,yAxis:c,x:a,y:e},{xAxis:b,yAxis:c,x:a,y:e},{command:"Z"}]}]},d.annotationsOptions,d.bindings.rectangleAnnotation.annotationsOptions))}},steps:[function(a,b){var c=b.options.shapes[0].points,
d=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(d.xAxis);d=this.utils.getAssignedAxis(d.yAxis);a&&d&&(a=a.value,d=d.value,c[1].x=a,c[2].x=a,c[2].y=d,c[3].y=d,b.update({shapes:[{points:c}]}))}]},labelAnnotation:{className:"highcharts-label-annotation",start:function(a){var b=this.chart.pointer.getCoordinates(a);a=this.utils.getAssignedAxis(b.xAxis);b=this.utils.getAssignedAxis(b.yAxis);var c=this.chart.options.navigation;if(a&&b)return this.chart.addAnnotation(E({langKey:"label",
type:"basicAnnotation",labelOptions:{format:"{y:.2f}"},labels:[{point:{xAxis:a.axis.options.index,yAxis:b.axis.options.index,x:a.value,y:b.value},overflow:"none",crop:!0}]},c.annotationsOptions,c.bindings.labelAnnotation.annotationsOptions))}}},events:{},annotationsOptions:{animation:{defer:0}}}});f(h,"render",function(){var a=this,b=a.navigationBindings;if(a&&b){var c=!1;a.series.forEach(function(a){!a.options.isInternal&&a.visible&&(c=!0)});y(b.boundClassNames,function(b,d){if(a.navigationBindings&&
a.navigationBindings.container&&a.navigationBindings.container[0]&&(d=a.navigationBindings.container[0].querySelectorAll("."+d)))for(var e=0;e<d.length;e++){var m=d[e],n=m.className;"normal"===b.noDataState?-1!==n.indexOf("highcharts-disabled-btn")&&m.classList.remove("highcharts-disabled-btn"):c?-1!==n.indexOf("highcharts-disabled-btn")&&m.classList.remove("highcharts-disabled-btn"):-1===n.indexOf("highcharts-disabled-btn")&&(m.className+=" highcharts-disabled-btn")}})}});f(m,"closePopup",function(){this.deselectAnnotation()});
return m});u(a,"Extensions/Annotations/Popup.js",[a["Core/Renderer/HTML/AST.js"],a["Core/Globals.js"],a["Extensions/Annotations/NavigationBindings.js"],a["Core/DefaultOptions.js"],a["Core/Pointer.js"],a["Core/Utilities.js"]],function(a,h,t,v,q,l){var b=h.doc,c=h.isFirefox,d=v.getOptions,g=l.addEvent,f=l.createElement,k=l.defined,r=l.fireEvent,u=l.isArray,z=l.isObject,D=l.objectEach,F=l.pick,E=l.stableSort;v=l.wrap;var y=/\d/g,C;(function(a){a[a["params.algorithm"]=0]="params.algorithm";a[a["params.average"]=
1]="params.average"})(C||(C={}));var G={"algorithm-pivotpoints":["standard","fibonacci","camarilla"],"average-disparityindex":["sma","ema","dema","tema","wma"]};v(q.prototype,"onContainerMouseDown",function(a,b){this.inClass(b.target,"highcharts-popup")||a.apply(this,Array.prototype.slice.call(arguments,1))});h.Popup=function(a,b,c){this.init(a,b,c)};h.Popup.prototype={init:function(a,b,c){this.chart=c;this.container=f("div",{className:"highcharts-popup highcharts-no-tooltip"},void 0,a);g(this.container,
"mousedown",function(){var a=c&&c.navigationBindings&&c.navigationBindings.activeAnnotation;if(a){a.cancelClick=!0;var b=g(h.doc,"click",function(){setTimeout(function(){a.cancelClick=!1},0);b()})}});this.lang=this.getLangpack();this.iconsURL=b;this.addCloseBtn()},addCloseBtn:function(){var a=this,b=this.iconsURL;var c=f("div",{className:"highcharts-popup-close"},void 0,this.container);c.style["background-image"]="url("+(b.match(/png|svg|jpeg|jpg|gif/ig)?b:b+"close.svg")+")";["click","touchstart"].forEach(function(b){g(c,
b,function(){a.chart?r(a.chart.navigationBindings,"closePopup"):a.closePopup()})})},addColsContainer:function(a){var b=f("div",{className:"highcharts-popup-lhs-col"},void 0,a);a=f("div",{className:"highcharts-popup-rhs-col"},void 0,a);f("div",{className:"highcharts-popup-rhs-col-wrapper"},void 0,a);return{lhsCol:b,rhsCol:a}},addInput:function(a,c,d,p){var e=a.split(".");e=e[e.length-1];var m=this.lang;c="highcharts-"+c+"-"+F(p.htmlFor,e);c.match(y)||f("label",{htmlFor:c,className:p.labelClassName},
void 0,d).appendChild(b.createTextNode(m[e]||e));d=f("input",{name:c,value:p.value,type:p.type,className:"highcharts-popup-field"},void 0,d);d.setAttribute("highcharts-data-name",a);return d},addButton:function(a,c,d,p,h){var e=this,m=this.closePopup,n=this.getFields;var k=f("button",void 0,void 0,a);k.appendChild(b.createTextNode(c));h&&["click","touchstart"].forEach(function(a){g(k,a,function(){m.call(e);return h(n(p,d))})});return k},getFields:function(a,b){var c=Array.prototype.slice.call(a.querySelectorAll("input")),
d=Array.prototype.slice.call(a.querySelectorAll("select")),m=a.querySelectorAll("#highcharts-select-series > option:checked")[0];a=a.querySelectorAll("#highcharts-select-volume > option:checked")[0];var f={actionType:b,linkedTo:m&&m.getAttribute("value")||"",fields:{}};c.forEach(function(a){var b=a.getAttribute("highcharts-data-name");a.getAttribute("highcharts-data-series-id")?f.seriesId=a.value:b?f.fields[b]=a.value:f.type=a.value});d.forEach(function(a){var b=a.id;"highcharts-select-series"!==
b&&"highcharts-select-volume"!==b&&(b=b.split("highcharts-select-")[1],f.fields[b]=a.value)});a&&(f.fields["params.volumeSeriesID"]=a.getAttribute("value")||"");return f},showPopup:function(){var b=this.container,c=b.querySelectorAll(".highcharts-popup-close")[0];this.formType=void 0;b.innerHTML=a.emptyHTML;0<=b.className.indexOf("highcharts-annotation-toolbar")&&(b.classList.remove("highcharts-annotation-toolbar"),b.removeAttribute("style"));b.appendChild(c);b.style.display="block";b.style.height=
""},closePopup:function(){F(this.popup&&this.popup.container,this.container).style.display="none"},showForm:function(a,b,c,d){b&&(this.popup=b.navigationBindings.popup,this.showPopup(),"indicators"===a&&this.indicators.addForm.call(this,b,c,d),"annotation-toolbar"===a&&this.annotations.addToolbar.call(this,b,c,d),"annotation-edit"===a&&this.annotations.addForm.call(this,b,c,d),"flag"===a&&this.annotations.addForm.call(this,b,c,d,!0),this.formType=a,this.container.style.height=this.container.offsetHeight+
"px")},getLangpack:function(){return d().lang.navigation.popup},annotations:{addToolbar:function(a,c,d){var e=this,m=this.lang,g=this.popup.container,h=this.showForm;-1===g.className.indexOf("highcharts-annotation-toolbar")&&(g.className+=" highcharts-annotation-toolbar");a&&(g.style.top=a.plotTop+10+"px");f("span",void 0,void 0,g).appendChild(b.createTextNode(F(m[c.langKey]||c.langKey,c.shapes&&c.shapes[0].type)));var n=this.addButton(g,m.removeButton||"remove","remove",g,d);n.className+=" highcharts-annotation-remove-button";
n.style["background-image"]="url("+this.iconsURL+"destroy.svg)";n=this.addButton(g,m.editButton||"edit","edit",g,function(){h.call(e,"annotation-edit",a,c,d)});n.className+=" highcharts-annotation-edit-button";n.style["background-image"]="url("+this.iconsURL+"edit.svg)"},addForm:function(a,c,d,g){var e=this.popup.container,m=this.lang;if(a){var n=f("h2",{className:"highcharts-popup-main-title"},void 0,e);n.appendChild(b.createTextNode(m[c.langKey]||c.langKey||""));n=f("div",{className:"highcharts-popup-lhs-col highcharts-popup-lhs-full"},
void 0,e);var p=f("div",{className:"highcharts-popup-bottom-row"},void 0,e);this.annotations.addFormFields.call(this,n,a,"",c,[],!0);this.addButton(p,g?m.addButton||"add":m.saveButton||"save",g?"add":"save",e,d)}},addFormFields:function(a,d,e,g,h,k){var m=this,n=this.annotations.addFormFields,p=this.addInput,l=this.lang,A,B;d&&(D(g,function(b,c){A=""!==e?e+"."+c:c;z(b)&&(!u(b)||u(b)&&z(b[0])?(B=l[c]||c,B.match(y)||h.push([!0,B,a]),n.call(m,a,d,A,b,h,!1)):h.push([m,A,"annotation",a,b]))}),k&&(E(h,
function(a){return a[1].match(/format/g)?-1:1}),c&&h.reverse(),h.forEach(function(a){!0===a[0]?f("span",{className:"highcharts-annotation-title"},void 0,a[2]).appendChild(b.createTextNode(a[1])):(a[4]={value:a[4][0],type:a[4][1]},p.apply(a[0],a.splice(1)))})))}},indicators:{addForm:function(a,b,c){var d=this.indicators,e=this.lang;if(a){this.tabs.init.call(this,a);b=this.popup.container.querySelectorAll(".highcharts-tab-item-content");this.addColsContainer(b[0]);d.addSearchBox.call(this,a,b[0]);d.addIndicatorList.call(this,
a,b[0],"add");var f=b[0].querySelectorAll(".highcharts-popup-rhs-col")[0];this.addButton(f,e.addButton||"add","add",f,c);this.addColsContainer(b[1]);d.addIndicatorList.call(this,a,b[1],"edit");f=b[1].querySelectorAll(".highcharts-popup-rhs-col")[0];this.addButton(f,e.saveButton||"save","edit",f,c);this.addButton(f,e.removeButton||"remove","remove",f,c)}},filterSeries:function(a,b){var c=this.indicators,d=this.chart&&this.chart.options.lang,f=d&&d.navigation&&d.navigation.popup&&d.navigation.popup.indicatorAliases,
g=[],m;D(a,function(a,d){var e=a.options;if(a.params||e&&e.params)if(e=c.getNameType(a,d),d=e.indicatorFullName,e=e.indicatorType,b){var h=b.replace(/[.*+?^${}()|[\]\\]/g,"\\$&");h=new RegExp(h,"i");var n=f&&f[e]&&f[e].join(" ")||"";if(d.match(h)||n.match(h))m={indicatorFullName:d,indicatorType:e,series:a},g.push(m)}else m={indicatorFullName:d,indicatorType:e,series:a},g.push(m)});return g},filterSeriesArray:function(a){var b=[],c;a.forEach(function(a){a.is("sma")&&(c={indicatorFullName:a.name,indicatorType:a.type,
series:a},b.push(c))});return b},addIndicatorList:function(c,d,e,h){var m=this,n=m.indicators,p=m.lang,k=d.querySelectorAll(".highcharts-popup-lhs-col")[0];d=d.querySelectorAll(".highcharts-popup-rhs-col")[0];var l="edit"===e,q=this.indicators.addFormFields;e=l?c.series:c.options.plotOptions||{};if(c||!e){var r,t=[];l||u(e)?u(e)&&(t=n.filterSeriesArray.call(this,e)):t=n.filterSeries.call(this,e,h);E(t,function(a,b){a=a.indicatorFullName.toLowerCase();b=b.indicatorFullName.toLowerCase();return a<b?
-1:a>b?1:0});k.children[1]&&k.children[1].remove();var v=f("ul",{className:"highcharts-indicator-list"},void 0,k);var w=d.querySelectorAll(".highcharts-popup-rhs-col-wrapper")[0];t.forEach(function(a){var d=a.indicatorFullName,e=a.indicatorType,h=a.series;r=f("li",{className:"highcharts-indicator-list"},void 0,v);r.appendChild(b.createTextNode(d));["click","touchstart"].forEach(function(a){g(r,a,function(){var a=w.parentNode.children[1];q.call(m,c,h,e,w);a&&(a.style.display="block");l&&h.options&&
f("input",{type:"hidden",name:"highcharts-id-"+e,value:h.options.id},void 0,w).setAttribute("highcharts-data-series-id",h.options.id)})})});0<v.childNodes.length?v.childNodes[0].click():l||(a.setElementHTML(w.parentNode.children[0],p.noFilterMatch||""),w.parentNode.children[1].style.display="none")}},addSearchBox:function(a,b){var c=this,d=b.querySelectorAll(".highcharts-popup-lhs-col")[0];b=this.lang.clearFilter;d=f("div",{className:"highcharts-input-wrapper"},void 0,d);var h=function(b){c.indicators.addIndicatorList.call(c,
a,c.container,"add",b)},m=this.addInput("searchIndicators","input",d,{value:"",type:"text",htmlFor:"search-indicators",labelClassName:"highcharts-input-search-indicators-label"}),n=f("a",{textContent:b},void 0,d);m.classList.add("highcharts-input-search-indicators");n.classList.add("clear-filter-button");g(m,"input",function(a){h(this.value);n.style.display=this.value.length?"inline-block":"none"});["click","touchstart"].forEach(function(a){g(n,a,function(){m.value="";h("");n.style.display="none"})})},
addSelection:function(a,c,d){var e=c.split(".");e=e[e.length-1];a="highcharts-"+c+"-type-"+a;var g=this.lang;f("label",{htmlFor:a},null,d).appendChild(b.createTextNode(g[e]||c));d=f("select",{name:a,className:"highcharts-popup-field",id:"highcharts-select-"+c},null,d);d.setAttribute("id","highcharts-select-"+c);return d},addSelectionOptions:function(a,c,d,g,h,l,q){"series"===c||"volume"===c?a.series.forEach(function(a){var e=a.options,g=e.name||e.params?a.name:e.id||"";"highcharts-navigator-series"!==
e.id&&e.id!==(q&&q.options&&q.options.id)&&(k(l)||"volume"!==c||"column"!==a.type||(l=e.id),f("option",{value:e.id},void 0,d).appendChild(b.createTextNode(g)))}):g&&h&&G[h+"-"+g].forEach(function(a){f("option",{value:a},void 0,d).appendChild(b.createTextNode(a))});k(l)&&(d.value=l)},getNameType:function(a,b){var c=a.options,d=h.seriesTypes;d=d[b]&&d[b].prototype.nameBase||b.toUpperCase();c&&c.type&&(b=a.options.type,d=a.name);return{indicatorFullName:d,indicatorType:b}},listAllSeries:function(a,b,
c,d,f,g){var e=this.indicators;c&&(a=e.addSelection.call(this,a,b,d),e.addSelectionOptions.call(this,c,b,a,void 0,void 0,void 0,f),k(g)&&(a.value=g))},addFormFields:function(c,d,e,g){var h=d.params||d.options.params,m=this.indicators.getNameType;g.innerHTML=a.emptyHTML;f("h3",{className:"highcharts-indicator-title"},void 0,g).appendChild(b.createTextNode(m(d,e).indicatorFullName));f("input",{type:"hidden",name:"highcharts-type-"+e,value:e},void 0,g);this.indicators.listAllSeries.call(this,e,"series",
c,g,d,d.linkedParent&&d.linkedParent.options.id);h.volumeSeriesID&&this.indicators.listAllSeries.call(this,e,"volume",c,g,d,d.linkedParent&&h.volumeSeriesID);this.indicators.addParamInputs.call(this,c,"params",h,e,g)},addParamInputs:function(a,b,c,d,f){var e=this,g=e.indicators,h=this.indicators.addParamInputs,m=this.addInput,n;a&&D(c,function(c,l){n=b+"."+l;if(k(c)&&n)if(z(c)&&(m.call(e,n,d,f,{}),h.call(e,a,n,c,d,f)),n in C){var p=g.addSelection.call(e,d,n,f);g.addSelectionOptions.call(e,a,b,p,d,
l,c)}else"params.volumeSeriesID"===n||u(c)||m.call(e,n,d,f,{value:c,type:"text"})})},getAmount:function(){var a=0;this.series.forEach(function(b){var c=b.options;(b.params||c&&c.params)&&a++});return a}},tabs:{init:function(a){var b=this.tabs,c=this.indicators.getAmount.call(a);a&&(a=b.addMenuItem.call(this,"add"),b.addMenuItem.call(this,"edit",c),b.addContentItem.call(this,"add"),b.addContentItem.call(this,"edit"),b.switchTabs.call(this,c),b.selectTab.call(this,a,0))},addMenuItem:function(a,c){var d=
this.popup.container,g="highcharts-tab-item",h=this.lang;0===c&&(g+=" highcharts-tab-disabled");c=f("span",{className:g},void 0,d);c.appendChild(b.createTextNode(h[a+"Button"]||a));c.setAttribute("highcharts-data-tab-type",a);return c},addContentItem:function(){return f("div",{className:"highcharts-tab-item-content highcharts-no-mousewheel"},void 0,this.popup.container)},switchTabs:function(a){var b=this,c;this.popup.container.querySelectorAll(".highcharts-tab-item").forEach(function(d,e){c=d.getAttribute("highcharts-data-tab-type");
"edit"===c&&0===a||["click","touchstart"].forEach(function(a){g(d,a,function(){b.tabs.deselectAll.call(b);b.tabs.selectTab.call(b,this,e)})})})},selectTab:function(a,b){var c=this.popup.container.querySelectorAll(".highcharts-tab-item-content");a.className+=" highcharts-tab-item-active";c[b].className+=" highcharts-tab-item-show"},deselectAll:function(){var a=this.popup.container,b=a.querySelectorAll(".highcharts-tab-item");a=a.querySelectorAll(".highcharts-tab-item-content");var c;for(c=0;c<b.length;c++)b[c].classList.remove("highcharts-tab-item-active"),
a[c].classList.remove("highcharts-tab-item-show")}}};g(t,"showPopup",function(a){this.popup||(this.popup=new h.Popup(this.chart.container,this.chart.options.navigation.iconsURL||this.chart.options.stockTools&&this.chart.options.stockTools.gui.iconsURL||"https://code.highcharts.com/10.0.0/gfx/stock-icons/",this.chart));this.popup.showForm(a.formType,this.chart,a.options,a.onSubmit)});g(t,"closePopup",function(){this.popup&&this.popup.closePopup()});return h.Popup});u(a,"masters/modules/annotations.src.js",
[],function(){})});
//# sourceMappingURL=annotations.js.map