/*
 Highstock JS v9.0.1 (2021-02-15)

 All technical indicators for Highstock

 (c) 2010-2021 Pawel Fus

 License: www.highcharts.com/license
*/
(function(d){"object"===typeof module&&module.exports?(d["default"]=d,module.exports=d):"function"===typeof define&&define.amd?define("highcharts/indicators/indicators-all",["highcharts","highcharts/modules/stock"],function(t){d(t);d.Highcharts=t;return d}):d("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(d){function t(d,f,g,h){d.hasOwnProperty(f)||(d[f]=h.apply(null,g))}d=d?d._modules:{};t(d,"Mixins/IndicatorRequired.js",[d["Core/Utilities.js"]],function(d){var f=d.error;return{isParentLoaded:function(g,
d,m,n,q){if(g)return n?n(g):!0;f(q||this.generateMessage(m,d));return!1},generateMessage:function(f,d){return'Error: "'+f+'" indicator type requires "'+d+'" indicator loaded before. Please read docs: https://api.highcharts.com/highstock/plotOptions.'+f}}});t(d,"Stock/Indicators/SMA/SMAComposition.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){var g=d.series,h=d.seriesTypes.ohlc.prototype;d=f.addEvent;var m=f.extend;d(g,"init",function(f){f=f.options;f.useOhlcData&&"highcharts-navigator-series"!==
f.id&&m(this,{pointValKey:h.pointValKey,keys:h.keys,pointArrayMap:h.pointArrayMap,toYData:h.toYData})});d(g,"afterSetOptions",function(f){f=f.options;var g=f.dataGrouping;g&&f.useOhlcData&&"highcharts-navigator-series"!==f.id&&(g.approximation="ohlc")})});t(d,"Stock/Indicators/SMA/SMAIndicator.js",[d["Mixins/IndicatorRequired.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f,g){var h=this&&this.__extends||function(){var a=function(c,k){a=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,c){a.__proto__=c}||function(a,c){for(var k in c)c.hasOwnProperty(k)&&(a[k]=c[k])};return a(c,k)};return function(c,k){function b(){this.constructor=c}a(c,k);c.prototype=null===k?Object.create(k):(b.prototype=k.prototype,new b)}}(),m=f.seriesTypes.line,n=g.addEvent,q=g.error,l=g.extend,e=g.isArray,b=g.merge,a=g.pick,c=g.splat,k=d.generateMessage;d=function(y){function v(){var a=null!==y&&y.apply(this,arguments)||this;a.data=void 0;a.dataEventsToUnbind=void 0;a.linkedParent=void 0;
a.options=void 0;a.points=void 0;return a}h(v,y);v.prototype.destroy=function(){this.dataEventsToUnbind.forEach(function(a){a()});y.prototype.destroy.apply(this,arguments)};v.prototype.getName=function(){var c=this.name,k=[];c||((this.nameComponents||[]).forEach(function(c,b){k.push(this.options.params[c]+a(this.nameSuffixes[b],""))},this),c=(this.nameBase||this.type.toUpperCase())+(this.nameComponents?" ("+k.join(", ")+")":""));return c};v.prototype.getValues=function(a,c){var k=c.period,b=a.xData;
a=a.yData;var y=a.length,v=0,A=0,l=[],f=[],g=[],J=-1;if(!(b.length<k)){for(e(a[0])&&(J=c.index?c.index:0);v<k-1;)A+=0>J?a[v]:a[v][J],v++;for(c=v;c<y;c++){A+=0>J?a[c]:a[c][J];var d=[b[c],A/k];l.push(d);f.push(d[0]);g.push(d[1]);A-=0>J?a[c-v]:a[c-v][J]}return{values:l,xData:f,yData:g}}};v.prototype.init=function(a,b){function e(){var a=v.points||[],k=(v.xData||[]).length,b=v.getValues(v.linkedParent,v.options.params)||{values:[],xData:[],yData:[]},e=[],y=!0;if(k&&!v.hasGroupedData&&v.visible&&v.points)if(v.cropped){if(v.xAxis){var p=
v.xAxis.min;var A=v.xAxis.max}k=v.cropData(b.xData,b.yData,p,A);for(p=0;p<k.xData.length;p++)e.push([k.xData[p]].concat(c(k.yData[p])));k=b.xData.indexOf(v.xData[0]);p=b.xData.indexOf(v.xData[v.xData.length-1]);-1===k&&p===b.xData.length-2&&e[0][0]===a[0].x&&e.shift();v.updateData(e)}else b.xData.length!==k-1&&b.xData.length!==k+1&&(y=!1,v.updateData(b.values));y&&(v.xData=b.xData,v.yData=b.yData,v.options.data=b.values);!1===v.bindTo.series&&(delete v.processedXData,v.isDirty=!0,v.redraw());v.isDirtyData=
!1}var v=this,p=v.requireIndicators();if(!p.allLoaded)return q(k(v.type,p.needed));y.prototype.init.call(v,a,b);a.linkSeries();v.dataEventsToUnbind=[];if(!v.linkedParent)return q("Series "+v.options.linkedTo+" not found! Check `linkedTo`.",!1,a);v.dataEventsToUnbind.push(n(v.bindTo.series?v.linkedParent:v.linkedParent.xAxis,v.bindTo.eventName,e));if("init"===v.calculateOn)e();else var A=n(v.chart,v.calculateOn,function(){e();A()})};v.prototype.processData=function(){var a=this.options.compareToMain,
c=this.linkedParent;y.prototype.processData.apply(this,arguments);c&&c.compareValue&&a&&(this.compareValue=c.compareValue)};v.prototype.requireIndicators=function(){var a={allLoaded:!0};this.requiredIndicators.forEach(function(c){f.seriesTypes[c]?f.seriesTypes[c].prototype.requireIndicators():(a.allLoaded=!1,a.needed=c)});return a};v.defaultOptions=b(m.defaultOptions,{name:void 0,tooltip:{valueDecimals:4},linkedTo:void 0,compareToMain:!1,params:{index:0,period:14}});return v}(m);l(d.prototype,{bindTo:{series:!0,
eventName:"updatedData"},calculateOn:"init",hasDerivedData:!0,nameComponents:["period"],nameSuffixes:[],requiredIndicators:[],useCommonDataGrouping:!0});f.registerSeriesType("sma",d);"";return d});t(d,"Stock/Indicators/AD/ADIndicator.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){var g=this&&this.__extends||function(){var l=function(e,b){l=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var k in c)c.hasOwnProperty(k)&&
(a[k]=c[k])};return l(e,b)};return function(e,b){function a(){this.constructor=e}l(e,b);e.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),h=d.seriesTypes.sma,m=f.error,n=f.extend,q=f.merge;f=function(l){function e(){var b=null!==l&&l.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}g(e,l);e.populateAverage=function(b,a,c,k,e){e=a[k][1];var y=a[k][2];a=a[k][3];c=c[k];return[b[k],a===e&&a===y||e===y?0:(2*a-y-e)/(e-y)*c]};e.prototype.getValues=
function(b,a){var c=a.period,k=b.xData,y=b.yData,v=a.volumeSeriesID,A=b.chart.get(v);a=A&&A.yData;var l=y?y.length:0,f=[],u=[],p=[];if(!(k.length<=c&&l&&4!==y[0].length)){if(A){for(v=c;v<l;v++)b=f.length,A=e.populateAverage(k,y,a,v,c),0<b&&(A[1]+=f[b-1][1]),f.push(A),u.push(A[0]),p.push(A[1]);return{values:f,xData:u,yData:p}}m("Series "+v+" not found! Check `volumeSeriesID`.",!0,b.chart)}};e.defaultOptions=q(h.defaultOptions,{params:{volumeSeriesID:"volume"}});return e}(h);n(f.prototype,{nameComponents:!1,
nameBase:"Accumulation/Distribution"});d.registerSeriesType("ad",f);"";return f});t(d,"Stock/Indicators/AO/AOIndicator.js",[d["Core/Globals.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f,g){var h=this&&this.__extends||function(){var a=function(c,k){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var k in c)c.hasOwnProperty(k)&&(a[k]=c[k])};return a(c,k)};return function(c,k){function b(){this.constructor=c}a(c,
k);c.prototype=null===k?Object.create(k):(b.prototype=k.prototype,new b)}}();d=d.noop;var m=f.seriesTypes,n=m.sma;m=m.column;var q=g.extend,l=g.merge,e=g.correctFloat,b=g.isArray;g=function(a){function c(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}h(c,a);c.prototype.drawGraph=function(){var a=this.options,c=this.points,b=a.greaterBarColor;a=a.lowerBarColor;var e=c[0];if(!this.userOptions.color&&e)for(e.color=b,e=1;e<c.length;e++)c[e].color=
c[e].y>c[e-1].y?b:c[e].y<c[e-1].y?a:c[e-1].color};c.prototype.getValues=function(c){var a=c.xData||[];c=c.yData||[];var k=c.length,A=[],f=[],l=[],u=0,p=0,w;if(!(34>=a.length)&&b(c[0])&&4===c[0].length){for(w=0;33>w;w++){var r=(c[w][1]+c[w][2])/2;29<=w&&(u=e(u+r));p=e(p+r)}for(w=33;w<k;w++){r=(c[w][1]+c[w][2])/2;u=e(u+r);p=e(p+r);r=u/5;var g=p/34;r=e(r-g);A.push([a[w],r]);f.push(a[w]);l.push(r);r=w+1-5;g=w+1-34;u=e(u-(c[r][1]+c[r][2])/2);p=e(p-(c[g][1]+c[g][2])/2)}return{values:A,xData:f,yData:l}}};
c.defaultOptions=l(n.defaultOptions,{greaterBarColor:"#06B535",lowerBarColor:"#F21313",threshold:0,groupPadding:.2,pointPadding:.2,crisp:!1,states:{hover:{halo:{size:0}}}});return c}(n);q(g.prototype,{nameBase:"AO",nameComponents:!1,markerAttribs:d,getColumnMetrics:m.prototype.getColumnMetrics,crispCol:m.prototype.crispCol,translate:m.prototype.translate,drawPoints:m.prototype.drawPoints});f.registerSeriesType("ao",g);"";return g});t(d,"Mixins/MultipleLines.js",[d["Core/Globals.js"],d["Core/Utilities.js"]],
function(d,f){var g=f.defined,h=f.error,m=f.merge,n=d.seriesTypes.sma;return{pointArrayMap:["top","bottom"],pointValKey:"top",linesApiNames:["bottomLine"],getTranslatedLinesNames:function(f){var l=[];(this.pointArrayMap||[]).forEach(function(e){e!==f&&l.push("plot"+e.charAt(0).toUpperCase()+e.slice(1))});return l},toYData:function(f){var l=[];(this.pointArrayMap||[]).forEach(function(e){l.push(f[e])});return l},translate:function(){var f=this,l=f.pointArrayMap,e=[],b;e=f.getTranslatedLinesNames();
n.prototype.translate.apply(f,arguments);f.points.forEach(function(a){l.forEach(function(c,k){b=a[c];null!==b&&(a[e[k]]=f.yAxis.toPixels(b,!0))})})},drawGraph:function(){var f=this,l=f.linesApiNames,e=f.points,b=e.length,a=f.options,c=f.graph,k={options:{gapSize:a.gapSize}},y=[],v;f.getTranslatedLinesNames(f.pointValKey).forEach(function(c,a){for(y[a]=[];b--;)v=e[b],y[a].push({x:v.x,plotX:v.plotX,plotY:v[c],isNull:!g(v[c])});b=e.length});l.forEach(function(c,b){y[b]?(f.points=y[b],a[c]?f.options=
m(a[c].styles,k):h('Error: "There is no '+c+' in DOCS options declared. Check if linesApiNames are consistent with your DOCS line names." at mixin/multiple-line.js:34'),f.graph=f["graph"+c],n.prototype.drawGraph.call(f),f["graph"+c]=f.graph):h('Error: "'+c+" doesn't have equivalent in pointArrayMap. To many elements in linesApiNames relative to pointArrayMap.\"")});f.points=e;f.options=a;f.graph=c;n.prototype.drawGraph.call(f)}}});t(d,"Stock/Indicators/Aroon/AroonIndicator.js",[d["Mixins/MultipleLines.js"],
d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f,g){function h(b,a){var c=b[0],k=0,e;for(e=1;e<b.length;e++)if("max"===a&&b[e]>=c||"min"===a&&b[e]<=c)c=b[e],k=e;return k}var m=this&&this.__extends||function(){var b=function(a,c){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,a){c.__proto__=a}||function(c,a){for(var k in a)a.hasOwnProperty(k)&&(c[k]=a[k])};return b(a,c)};return function(a,c){function k(){this.constructor=a}b(a,c);a.prototype=null===c?Object.create(c):
(k.prototype=c.prototype,new k)}}(),n=f.seriesTypes.sma,q=g.extend,l=g.merge,e=g.pick;g=function(b){function a(){var c=null!==b&&b.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}m(a,b);a.prototype.getValues=function(c,a){a=a.period;var k=c.xData,b=(c=c.yData)?c.length:0,f=[],l=[],g=[],u;for(u=a-1;u<b;u++){var p=c.slice(u-a+1,u+2);var w=h(p.map(function(c){return e(c[2],c)}),"min");p=h(p.map(function(c){return e(c[1],c)}),"max");p=p/a*100;w=w/a*100;k[u+1]&&(f.push([k[u+
1],p,w]),l.push(k[u+1]),g.push([p,w]))}return{values:f,xData:l,yData:g}};a.defaultOptions=l(n.defaultOptions,{params:{period:25},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Aroon Up: {point.y}<br/>Aroon Down: {point.aroonDown}<br/>'},aroonDown:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}});return a}(n);q(g.prototype,{linesApiNames:["aroonDown"],nameBase:"Aroon",pointArrayMap:["y","aroonDown"],
pointValKey:"y",drawGraph:d.drawGraph,getTranslatedLinesNames:d.getTranslatedLinesNames,toYData:d.toYData,translate:d.translate});f.registerSeriesType("aroon",g);"";return g});t(d,"Stock/Indicators/AroonOscillator/AroonOscillatorIndicator.js",[d["Mixins/MultipleLines.js"],d["Mixins/IndicatorRequired.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f,g,h){var m=this&&this.__extends||function(){var b=function(a,c){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,
a){c.__proto__=a}||function(c,a){for(var k in a)a.hasOwnProperty(k)&&(c[k]=a[k])};return b(a,c)};return function(a,c){function k(){this.constructor=a}b(a,c);a.prototype=null===c?Object.create(c):(k.prototype=c.prototype,new k)}}(),n=g.seriesTypes.aroon,q=h.extend,l=h.merge,e=g.seriesTypes.aroon;h=function(b){function a(){var c=null!==b&&b.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}m(a,b);a.prototype.getValues=function(c,a){var k=[],b=[],f=[];c=e.prototype.getValues.call(this,
c,a);for(a=0;a<c.yData.length;a++){var l=c.yData[a][0];var g=c.yData[a][1];l-=g;k.push([c.xData[a],l]);b.push(c.xData[a]);f.push(l)}return{values:k,xData:b,yData:f}};a.prototype.init=function(){var c=arguments,a=this;f.isParentLoaded(e,"aroon",a.type,function(k){k.prototype.init.apply(a,c)})};a.defaultOptions=l(n.defaultOptions,{params:{period:25},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b>: {point.y}'}});return a}(n);q(h.prototype,l(d,{nameBase:"Aroon Oscillator",
pointArrayMap:["y"],pointValKey:"y",linesApiNames:[]}));g.registerSeriesType("aroonoscillator",h);"";return h});t(d,"Stock/Indicators/ATR/ATRIndicator.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){function g(f,e){return Math.max(f[1]-f[2],"undefined"===typeof e?0:Math.abs(f[1]-e[3]),"undefined"===typeof e?0:Math.abs(f[2]-e[3]))}var h=this&&this.__extends||function(){var f=function(e,b){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=
c}||function(a,c){for(var k in c)c.hasOwnProperty(k)&&(a[k]=c[k])};return f(e,b)};return function(e,b){function a(){this.constructor=e}f(e,b);e.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),m=d.seriesTypes.sma,n=f.isArray,q=f.merge;f=function(f){function e(){var b=null!==f&&f.apply(this,arguments)||this;b.data=void 0;b.points=void 0;b.options=void 0;return b}h(e,f);e.prototype.getValues=function(b,a){a=a.period;var c=b.xData,k=(b=b.yData)?b.length:0,e=1,v=0,f=0,l=[],d=[],
u=[],p;var w=[[c[0],b[0]]];if(!(c.length<=a)&&n(b[0])&&4===b[0].length){for(p=1;p<=k;p++)if(w.push([c[p],b[p]]),a<e){var r=a;var O=c[p-1],h=g(b[p-1],b[p-2]);r=[O,(v*(r-1)+h)/r];v=r[1];l.push(r);d.push(r[0]);u.push(r[1])}else a===e?(v=f/(p-1),l.push([c[p-1],v]),d.push(c[p-1]),u.push(v)):f+=g(b[p-1],b[p-2]),e++;return{values:l,xData:d,yData:u}}};e.defaultOptions=q(m.defaultOptions,{params:{period:14}});return e}(m);d.registerSeriesType("atr",f);"";return f});t(d,"Stock/Indicators/BB/BBIndicator.js",
[d["Mixins/MultipleLines.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f,g){var h=this&&this.__extends||function(){var e=function(b,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,a){c.__proto__=a}||function(c,a){for(var b in a)a.hasOwnProperty(b)&&(c[b]=a[b])};return e(b,a)};return function(b,a){function c(){this.constructor=b}e(b,a);b.prototype=null===a?Object.create(a):(c.prototype=a.prototype,new c)}}(),m=f.seriesTypes.sma,n=g.extend,q=g.isArray,
l=g.merge;g=function(e){function b(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}h(b,e);b.prototype.init=function(){f.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=l({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)};b.prototype.getValues=function(a,c){var b=c.period,e=c.standardDeviation,v=a.xData,A=(a=a.yData)?a.length:0,l=[],g=[],u=[],p;if(!(v.length<b)){var w=q(a[0]);
for(p=b;p<=A;p++){var r=v.slice(p-b,p);var d=a.slice(p-b,p);var h=f.seriesTypes.sma.prototype.getValues.call(this,{xData:r,yData:d},c);r=h.xData[0];h=h.yData[0];for(var m=0,x=d.length,n=0;n<x;n++){var z=(w?d[n][c.index]:d[n])-h;m+=z*z}z=Math.sqrt(m/(x-1));d=h+e*z;z=h-e*z;l.push([r,d,h,z]);g.push(r);u.push([d,h,z])}return{values:l,xData:g,yData:u}}};b.defaultOptions=l(m.defaultOptions,{params:{period:20,standardDeviation:2,index:3},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,
lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},marker:{enabled:!1},dataGrouping:{approximation:"averages"}});return b}(m);n(g.prototype,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameComponents:["period","standardDeviation"],linesApiNames:["topLine","bottomLine"],drawGraph:d.drawGraph,getTranslatedLinesNames:d.getTranslatedLinesNames,translate:d.translate,
toYData:d.toYData});f.registerSeriesType("bb",g);"";return g});t(d,"Stock/Indicators/CCI/CCIIndicator.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){function g(f){return f.reduce(function(e,b){return e+b},0)}var h=this&&this.__extends||function(){var f=function(e,b){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return f(e,b)};return function(e,b){function a(){this.constructor=
e}f(e,b);e.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),m=d.seriesTypes.sma,n=f.isArray,q=f.merge;f=function(f){function e(){var b=null!==f&&f.apply(this,arguments)||this;b.data=void 0;b.points=void 0;b.options=void 0;return b}h(e,f);e.prototype.getValues=function(b,a){a=a.period;var c=b.xData,k=(b=b.yData)?b.length:0,e=[],v=1,f=[],l=[],d=[];if(!(c.length<=a)&&n(b[0])&&4===b[0].length){for(;v<a;){var u=b[v-1];e.push((u[1]+u[2]+u[3])/3);v++}for(v=a;v<=k;v++){u=b[v-1];u=(u[1]+
u[2]+u[3])/3;var p=e.push(u);var w=e.slice(p-a);p=g(w)/a;var r,O=w.length,h=0;for(r=0;r<O;r++)h+=Math.abs(p-w[r]);w=h/a;u=(u-p)/(.015*w);f.push([c[v-1],u]);l.push(c[v-1]);d.push(u)}return{values:f,xData:l,yData:d}}};e.defaultOptions=q(m.defaultOptions,{params:{period:14}});return e}(m);d.registerSeriesType("cci",f);"";return f});t(d,"Stock/Indicators/CMF/CMFIndicator.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){var g=this&&this.__extends||function(){var f=function(d,
l){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,b){e.__proto__=b}||function(e,b){for(var a in b)b.hasOwnProperty(a)&&(e[a]=b[a])};return f(d,l)};return function(d,l){function e(){this.constructor=d}f(d,l);d.prototype=null===l?Object.create(l):(e.prototype=l.prototype,new e)}}(),h=d.seriesTypes.sma,m=f.merge;f=function(f){function d(){var l=null!==f&&f.apply(this,arguments)||this;l.data=void 0;l.options=void 0;l.points=void 0;l.volumeSeries=void 0;l.linkedParent=void 0;l.yData=
void 0;l.nameBase="Chaikin Money Flow";return l}g(d,f);d.prototype.isValid=function(){var f=this.chart,e=this.options,b=this.linkedParent;f=this.volumeSeries||(this.volumeSeries=f.get(e.params.volumeSeriesID));var a=b&&b.yData&&4===b.yData[0].length;return!!(b&&f&&b.xData&&b.xData.length>=e.params.period&&f.xData&&f.xData.length>=e.params.period&&a)};d.prototype.getValues=function(f,e){if(this.isValid())return this.getMoneyFlow(f.xData,f.yData,this.volumeSeries.yData,e.period)};d.prototype.getMoneyFlow=
function(f,e,b,a){function c(a,c){var b=a[1],k=a[2];a=a[3];return null!==c&&null!==b&&null!==k&&null!==a&&b!==k?(a-k-(b-a))/(b-k)*c:(w=p,null)}var k=e.length,y=[],v=0,A=0,d=[],l=[],u=[],p,w=-1;if(0<a&&a<=k){for(p=0;p<a;p++)y[p]=c(e[p],b[p]),v+=b[p],A+=y[p];d.push(f[p-1]);l.push(p-w>=a&&0!==v?A/v:null);for(u.push([d[0],l[0]]);p<k;p++){y[p]=c(e[p],b[p]);v-=b[p-a];v+=b[p];A-=y[p-a];A+=y[p];var r=[f[p],p-w>=a?A/v:null];d.push(r[0]);l.push(r[1]);u.push([r[0],r[1]])}}return{values:u,xData:d,yData:l}};d.defaultOptions=
m(h.defaultOptions,{params:{period:14,volumeSeriesID:"volume"}});return d}(h);d.registerSeriesType("cmf",f);"";return f});t(d,"Stock/Indicators/DPO/DPOIndicator.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){function g(b,a,c,k,y){a=e(a[c][k],a[c]);return y?l(b-a):l(b+a)}var h=this&&this.__extends||function(){var b=function(a,c){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=
c[b])};return b(a,c)};return function(a,c){function k(){this.constructor=a}b(a,c);a.prototype=null===c?Object.create(c):(k.prototype=c.prototype,new k)}}(),m=d.seriesTypes.sma,n=f.extend,q=f.merge,l=f.correctFloat,e=f.pick;f=function(b){function a(){var a=null!==b&&b.apply(this,arguments)||this;a.options=void 0;a.data=void 0;a.points=void 0;return a}h(a,b);a.prototype.getValues=function(a,b){var c=b.period;b=b.index;var k=c+Math.floor(c/2+1),f=a.xData||[];a=a.yData||[];var d=a.length,l=[],u=[],p=
[],w=0,r,h;if(!(f.length<=k)){for(r=0;r<c-1;r++)w=g(w,a,r,b);for(h=0;h<=d-k;h++){var m=h+c-1;r=h+k-1;w=g(w,a,m,b);m=e(a[r][b],a[r]);m-=w/c;w=g(w,a,h,b,!0);l.push([f[r],m]);u.push(f[r]);p.push(m)}return{values:l,xData:u,yData:p}}};a.defaultOptions=q(m.defaultOptions,{params:{period:21}});return a}(m);n(f.prototype,{nameBase:"DPO"});d.registerSeriesType("dpo",f);"";return f});t(d,"Stock/Indicators/EMA/EMAIndicator.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){var g=this&&
this.__extends||function(){var f=function(e,b){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return f(e,b)};return function(e,b){function a(){this.constructor=e}f(e,b);e.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),h=d.seriesTypes.sma,m=f.correctFloat,n=f.isArray,q=f.merge;f=function(f){function e(){var b=null!==f&&f.apply(this,arguments)||this;b.data=void 0;b.options=
void 0;b.points=void 0;return b}g(e,f);e.prototype.accumulatePeriodPoints=function(b,a,c){for(var k=0,e=0,f;e<b;)f=0>a?c[e]:c[e][a],k+=f,e++;return k};e.prototype.calculateEma=function(b,a,c,k,e,f,d){b=b[c-1];a=0>f?a[c-1]:a[c-1][f];k="undefined"===typeof e?d:m(a*k+e*(1-k));return[b,k]};e.prototype.getValues=function(b,a){var c=a.period,k=b.xData,e=(b=b.yData)?b.length:0,f=2/(c+1),d=[],l=[],g=[],u=-1;if(!(e<c)){n(b[0])&&(u=a.index?a.index:0);a=this.accumulatePeriodPoints(c,u,b);for(a/=c;c<e+1;c++){var p=
this.calculateEma(k,b,c,f,p,u,a);d.push(p);l.push(p[0]);g.push(p[1]);p=p[1]}return{values:d,xData:l,yData:g}}};e.defaultOptions=q(h.defaultOptions,{params:{index:3,period:9}});return e}(h);d.registerSeriesType("ema",f);"";return f});t(d,"Stock/Indicators/Chaikin/ChaikinIndicator.js",[d["Mixins/IndicatorRequired.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f,g){var h=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(c,b)};return function(c,b){function k(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):(k.prototype=b.prototype,new k)}}(),m=f.seriesTypes,n=m.ad,q=m.ema,l=g.correctFloat;m=g.extend;var e=g.merge,b=g.error;g=function(a){function c(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}h(c,a);c.prototype.init=function(){var a=
arguments,c=this;d.isParentLoaded(q,"ema",c.type,function(b){b.prototype.init.apply(c,a)})};c.prototype.getValues=function(a,c){var k=c.periods,e=c.period,f=[],y=[],d=[],p;if(2!==k.length||k[1]<=k[0])b('Error: "Chaikin requires two periods. Notice, first period should be lower than the second one."');else if(c=n.prototype.getValues.call(this,a,{volumeSeriesID:c.volumeSeriesID,period:e}))if(a=q.prototype.getValues.call(this,c,{period:k[0]}),c=q.prototype.getValues.call(this,c,{period:k[1]}),a&&c){k=
k[1]-k[0];for(p=0;p<c.yData.length;p++)e=l(a.yData[p+k]-c.yData[p]),f.push([c.xData[p],e]),y.push(c.xData[p]),d.push(e);return{values:f,xData:y,yData:d}}};c.defaultOptions=e(q.defaultOptions,{params:{volumeSeriesID:"volume",periods:[3,10]}});return c}(q);m(g.prototype,{nameBase:"Chaikin Osc",nameComponents:["periods"]});f.registerSeriesType("chaikin",g);"";return g});t(d,"Stock/Indicators/DEMA/DEMAIndicator.js",[d["Mixins/IndicatorRequired.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],
function(d,f,g){var h=this&&this.__extends||function(){var e=function(b,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(b,a)};return function(b,a){function c(){this.constructor=b}e(b,a);b.prototype=null===a?Object.create(a):(c.prototype=a.prototype,new c)}}(),m=f.seriesTypes.ema,n=g.correctFloat,q=g.isArray,l=g.merge;g=function(e){function b(){var a=null!==e&&e.apply(this,arguments)||
this;a.EMApercent=void 0;a.data=void 0;a.options=void 0;a.points=void 0;return a}h(b,e);b.prototype.init=function(){var a=arguments,c=this;d.isParentLoaded(m,"ema",c.type,function(b){b.prototype.init.apply(c,a)})};b.prototype.getEMA=function(a,c,b,e,f,d){return m.prototype.calculateEma(d||[],a,"undefined"===typeof f?1:f,this.EMApercent,c,"undefined"===typeof e?-1:e,b)};b.prototype.getValues=function(a,c){var b=c.period,e=2*b,f=a.xData,d=(a=a.yData)?a.length:0,l=-1,g=[],u=[],p=[],w=0,r=[],h;this.EMApercent=
2/(b+1);if(!(d<2*b-1)){q(a[0])&&(l=c.index?c.index:0);c=m.prototype.accumulatePeriodPoints(b,l,a);var L=c/b;c=0;for(h=b;h<d+2;h++){h<d+1&&(w=this.getEMA(a,z,L,l,h)[1],r.push(w));var z=w;if(h<e)c+=w;else{h===e&&(L=c/b);w=r[h-b-1];var x=this.getEMA([w],x,L)[1];var C=[f[h-2],n(2*w-x)];g.push(C);u.push(C[0]);p.push(C[1])}}return{values:g,xData:u,yData:p}}};b.defaultOptions=l(m.defaultOptions);return b}(m);f.registerSeriesType("dema",g);"";return g});t(d,"Stock/Indicators/TEMA/TEMAIndicator.js",[d["Mixins/IndicatorRequired.js"],
d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f,g){var h=this&&this.__extends||function(){var e=function(b,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(b,a)};return function(b,a){function c(){this.constructor=b}e(b,a);b.prototype=null===a?Object.create(a):(c.prototype=a.prototype,new c)}}(),m=f.seriesTypes.ema,n=g.correctFloat,q=g.isArray,l=g.merge;g=function(e){function b(){var a=
null!==e&&e.apply(this,arguments)||this;a.EMApercent=void 0;a.data=void 0;a.options=void 0;a.points=void 0;return a}h(b,e);b.prototype.init=function(){var a=arguments,c=this;d.isParentLoaded(m,"ema",c.type,function(b){b.prototype.init.apply(c,a)})};b.prototype.getEMA=function(a,c,b,e,f,d){return m.prototype.calculateEma(d||[],a,"undefined"===typeof f?1:f,this.EMApercent,c,"undefined"===typeof e?-1:e,b)};b.prototype.getTemaPoint=function(a,c,b,e){return[a[e-3],n(3*b.level1-3*b.level2+b.level3)]};b.prototype.getValues=
function(a,c){var b=c.period,e=2*b,f=3*b,d=a.xData,l=(a=a.yData)?a.length:0,g=-1,u=[],p=[],w=[],r=[],h=[],n,z,x={};this.EMApercent=2/(b+1);if(!(l<3*b-2)){q(a[0])&&(g=c.index?c.index:0);c=m.prototype.accumulatePeriodPoints(b,g,a);var C=c/b;c=0;for(n=b;n<l+3;n++){n<l+1&&(x.level1=this.getEMA(a,R,C,g,n)[1],r.push(x.level1));var R=x.level1;if(n<e)c+=x.level1;else{n===e&&(C=c/b,c=0);x.level1=r[n-b-1];x.level2=this.getEMA([x.level1],D,C)[1];h.push(x.level2);var D=x.level2;if(n<f)c+=x.level2;else{n===f&&
(C=c/b);n===l+1&&(x.level1=r[n-b-1],x.level2=this.getEMA([x.level1],D,C)[1],h.push(x.level2));x.level1=r[n-b-2];x.level2=h[n-2*b-1];x.level3=this.getEMA([x.level2],x.prevLevel3,C)[1];if(z=this.getTemaPoint(d,f,x,n))u.push(z),p.push(z[0]),w.push(z[1]);x.prevLevel3=x.level3}}}return{values:u,xData:p,yData:w}}};b.defaultOptions=l(m.defaultOptions);return b}(m);f.registerSeriesType("tema",g);"";return g});t(d,"Stock/Indicators/TRIX/TRIXIndicator.js",[d["Mixins/IndicatorRequired.js"],d["Core/Series/SeriesRegistry.js"],
d["Core/Utilities.js"]],function(d,f,g){var h=this&&this.__extends||function(){var f=function(e,b){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return f(e,b)};return function(e,b){function a(){this.constructor=e}f(e,b);e.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),m=f.seriesTypes.tema,n=g.correctFloat,q=g.merge;g=function(l){function e(){var b=null!==l&&l.apply(this,
arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}h(e,l);e.prototype.init=function(){var b=arguments,a=this;d.isParentLoaded(f.seriesTypes.tema,"tema",a.type,function(c){c.prototype.init.apply(a,b)})};e.prototype.getTemaPoint=function(b,a,c,k){if(k>a)var e=[b[k-3],0!==c.prevLevel3?n(c.level3-c.prevLevel3)/c.prevLevel3*100:null];return e};e.defaultOptions=q(m.defaultOptions);return e}(m);f.registerSeriesType("trix",g);"";return g});t(d,"Stock/Indicators/APO/APOIndicator.js",
[d["Mixins/IndicatorRequired.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f,g){var h=this&&this.__extends||function(){var e=function(b,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(b,a)};return function(b,a){function c(){this.constructor=b}e(b,a);b.prototype=null===a?Object.create(a):(c.prototype=a.prototype,new c)}}(),m=f.seriesTypes.ema,n=g.extend,q=g.merge,
l=g.error;g=function(e){function b(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}h(b,e);b.prototype.getValues=function(a,c){var b=c.periods,e=c.index;c=[];var f=[],d=[],g;if(2!==b.length||b[1]<=b[0])l('Error: "APO requires two periods. Notice, first period should be lower than the second one."');else{var h=m.prototype.getValues.call(this,a,{index:e,period:b[0]});a=m.prototype.getValues.call(this,a,{index:e,period:b[1]});if(h&&a){b=b[1]-b[0];
for(g=0;g<a.yData.length;g++)e=h.yData[g+b]-a.yData[g],c.push([a.xData[g],e]),f.push(a.xData[g]),d.push(e);return{values:c,xData:f,yData:d}}}};b.prototype.init=function(){var a=arguments,c=this;d.isParentLoaded(m,"ema",c.type,function(b){b.prototype.init.apply(c,a)})};b.defaultOptions=q(m.defaultOptions,{params:{periods:[10,20]}});return b}(m);n(g.prototype,{nameBase:"APO",nameComponents:["periods"]});f.registerSeriesType("apo",g);"";return g});t(d,"Stock/Indicators/IKH/IKHIndicator.js",[d["Core/Color/Color.js"],
d["Core/Globals.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f,g,h){function m(a){return a.reduce(function(a,c){return Math.max(a,c[1])},-Infinity)}function n(a){return a.reduce(function(a,c){return Math.min(a,c[2])},Infinity)}function q(a){return{high:m(a),low:n(a)}}function l(a){var c,b,k,e,f;a.series.forEach(function(a){if(a.xData)for(e=a.xData,f=b=a.xIncrement?1:e.length-1;0<f;f--)if(k=e[f]-e[f-1],"undefined"===typeof c||k<c)c=k});return c}function e(a,c,b,k){if(a&&
c&&b&&k){var e=c.plotX-a.plotX;c=c.plotY-a.plotY;var f=k.plotX-b.plotX;k=k.plotY-b.plotY;var p=a.plotX-b.plotX,v=a.plotY-b.plotY;b=(-c*p+e*v)/(-f*c+e*k);f=(f*v-k*p)/(-f*c+e*k);if(0<=b&&1>=b&&0<=f&&1>=f)return{plotX:a.plotX+f*e,plotY:a.plotY+f*c}}return!1}function b(a){var c=a.indicator;c.points=a.points;c.nextPoints=a.nextPoints;c.color=a.color;c.options=A(a.options.senkouSpan.styles,a.gap);c.graph=a.graph;c.fillGraph=!0;g.seriesTypes.sma.prototype.drawGraph.call(c)}var a=this&&this.__extends||function(){var a=
function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(c,b)};return function(c,b){function k(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):(k.prototype=b.prototype,new k)}}(),c=d.parse,k=g.seriesTypes.sma,y=h.defined;d=h.extend;var v=h.isArray,A=h.merge,J=h.objectEach;f.approximations["ichimoku-averages"]=function(){var a=[],c;[].forEach.call(arguments,function(b,
k){a.push(f.approximations.average(b));c=!c&&"undefined"===typeof a[k]});return c?void 0:a};h=function(f){function d(){var a=null!==f&&f.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;a.graphCollection=void 0;a.graphsenkouSpan=void 0;a.ikhMap=void 0;a.nextPoints=void 0;return a}a(d,f);d.prototype.init=function(){g.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=A({tenkanLine:{styles:{lineColor:this.color}},kijunLine:{styles:{lineColor:this.color}},chikouLine:{styles:{lineColor:this.color}},
senkouSpanA:{styles:{lineColor:this.color,fill:c(this.color).setOpacity(.5).get()}},senkouSpanB:{styles:{lineColor:this.color,fill:c(this.color).setOpacity(.5).get()}},senkouSpan:{styles:{fill:c(this.color).setOpacity(.2).get()}}},this.options)};d.prototype.toYData=function(a){return[a.tenkanSen,a.kijunSen,a.chikouSpan,a.senkouSpanA,a.senkouSpanB]};d.prototype.translate=function(){var a=this;g.seriesTypes.sma.prototype.translate.apply(a);a.points.forEach(function(c){a.pointArrayMap.forEach(function(b){y(c[b])&&
(c["plot"+b]=a.yAxis.toPixels(c[b],!0),c.plotY=c["plot"+b],c.tooltipPos=[c.plotX,c["plot"+b]],c.isNull=!1)})})};d.prototype.drawGraph=function(){var a=this,c=a.points,k=c.length,f=a.options,d=a.graph,v=a.color,l={options:{gapSize:f.gapSize}},u=a.pointArrayMap.length,h=[[],[],[],[],[],[]],m={tenkanLine:h[0],kijunLine:h[1],chikouLine:h[2],senkouSpanA:h[3],senkouSpanB:h[4],senkouSpan:h[5]},n=[],q=a.options.senkouSpan,K=q.color||q.styles.fill,z=q.negativeColor,t=[[],[]],N=[[],[]],P=0,F,Q,M;for(a.ikhMap=
m;k--;){var E=c[k];for(F=0;F<u;F++)q=a.pointArrayMap[F],y(E[q])&&h[F].push({plotX:E.plotX,plotY:E["plot"+q],isNull:!1});z&&k!==c.length-1&&(q=m.senkouSpanB.length-1,E=e(m.senkouSpanA[q-1],m.senkouSpanA[q],m.senkouSpanB[q-1],m.senkouSpanB[q]),F={plotX:E.plotX,plotY:E.plotY,isNull:!1,intersectPoint:!0},E&&(m.senkouSpanA.splice(q,0,F),m.senkouSpanB.splice(q,0,F),n.push(q)))}J(m,function(c,b){f[b]&&"senkouSpan"!==b&&(a.points=h[P],a.options=A(f[b].styles,l),a.graph=a["graph"+b],a.fillGraph=!1,a.color=
v,g.seriesTypes.sma.prototype.drawGraph.call(a),a["graph"+b]=a.graph);P++});a.graphCollection&&a.graphCollection.forEach(function(c){a[c].destroy();delete a[c]});a.graphCollection=[];if(z&&m.senkouSpanA[0]&&m.senkouSpanB[0]){n.unshift(0);n.push(m.senkouSpanA.length-1);for(u=0;u<n.length-1;u++){q=n[u];E=n[u+1];k=m.senkouSpanB.slice(q,E+1);q=m.senkouSpanA.slice(q,E+1);if(1<=Math.floor(k.length/2))if(E=Math.floor(k.length/2),k[E].plotY===q[E].plotY){for(M=F=E=0;M<k.length;M++)E+=k[M].plotY,F+=q[M].plotY;
E=E>F?0:1}else E=k[E].plotY>q[E].plotY?0:1;else E=k[0].plotY>q[0].plotY?0:1;t[E]=t[E].concat(k);N[E]=N[E].concat(q)}["graphsenkouSpanColor","graphsenkouSpanNegativeColor"].forEach(function(c,k){t[k].length&&N[k].length&&(Q=0===k?K:z,b({indicator:a,points:t[k],nextPoints:N[k],color:Q,options:f,gap:l,graph:a[c]}),a[c]=a.graph,a.graphCollection.push(c))})}else b({indicator:a,points:m.senkouSpanB,nextPoints:m.senkouSpanA,color:K,options:f,gap:l,graph:a.graphsenkouSpan}),a.graphsenkouSpan=a.graph;delete a.nextPoints;
delete a.fillGraph;a.points=c;a.options=f;a.graph=d;a.color=v};d.prototype.getGraphPath=function(a){var c=[],b;a=a||this.points;if(this.fillGraph&&this.nextPoints){if((b=g.seriesTypes.sma.prototype.getGraphPath.call(this,this.nextPoints))&&b.length){b[0][0]="L";c=g.seriesTypes.sma.prototype.getGraphPath.call(this,a);b=b.slice(0,c.length);for(var k=b.length-1;0<=k;k--)c.push(b[k])}}else c=g.seriesTypes.sma.prototype.getGraphPath.apply(this,arguments);return c};d.prototype.getValues=function(a,c){var b=
c.period,k=c.periodTenkan;c=c.periodSenkouSpanB;var e=a.xData,f=a.yData,d=f&&f.length||0;a=l(a.xAxis);var y=[],p=[],g;if(!(e.length<=b)&&v(f[0])&&4===f[0].length){var A=e[0]-b*a;for(g=0;g<b;g++)p.push(A+g*a);for(g=0;g<d;g++){if(g>=k){var u=f.slice(g-k,g);u=q(u);u=(u.high+u.low)/2}if(g>=b){var h=f.slice(g-b,g);h=q(h);h=(h.high+h.low)/2;var w=(u+h)/2}if(g>=c){var m=f.slice(g-c,g);m=q(m);m=(m.high+m.low)/2}A=f[g][3];var n=e[g];"undefined"===typeof y[g]&&(y[g]=[]);"undefined"===typeof y[g+b]&&(y[g+b]=
[]);y[g+b][0]=u;y[g+b][1]=h;y[g+b][2]=void 0;y[g][2]=A;g<=b&&(y[g+b][3]=void 0,y[g+b][4]=void 0);"undefined"===typeof y[g+2*b]&&(y[g+2*b]=[]);y[g+2*b][3]=w;y[g+2*b][4]=m;p.push(n)}for(g=1;g<=b;g++)p.push(n+g*a);return{values:y,xData:p,yData:y}}};d.defaultOptions=A(k.defaultOptions,{params:{period:26,periodTenkan:9,periodSenkouSpanB:52},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>TENKAN SEN: {point.tenkanSen:.3f}<br/>KIJUN SEN: {point.kijunSen:.3f}<br/>CHIKOU SPAN: {point.chikouSpan:.3f}<br/>SENKOU SPAN A: {point.senkouSpanA:.3f}<br/>SENKOU SPAN B: {point.senkouSpanB:.3f}<br/>'},
tenkanLine:{styles:{lineWidth:1,lineColor:void 0}},kijunLine:{styles:{lineWidth:1,lineColor:void 0}},chikouLine:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanA:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanB:{styles:{lineWidth:1,lineColor:void 0}},senkouSpan:{styles:{fill:"rgba(255, 0, 0, 0.5)"}},dataGrouping:{approximation:"ichimoku-averages"}});return d}(k);d(h.prototype,{pointArrayMap:["tenkanSen","kijunSen","chikouSpan","senkouSpanA","senkouSpanB"],pointValKey:"tenkanSen",nameComponents:["periodSenkouSpanB",
"period","periodTenkan"]});g.registerSeriesType("ikh",h);"";return h});t(d,"Stock/Indicators/KeltnerChannels/KeltnerChannelsIndicator.js",[d["Mixins/MultipleLines.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f,g){var h=this&&this.__extends||function(){var e=function(b,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(b,a)};return function(b,a){function c(){this.constructor=
b}e(b,a);b.prototype=null===a?Object.create(a):(c.prototype=a.prototype,new c)}}(),m=f.seriesTypes.sma,n=g.correctFloat,q=g.extend,l=g.merge;g=function(e){function b(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}h(b,e);b.prototype.init=function(){f.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=l({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)};b.prototype.getValues=function(a,
c){var b=c.period,e=c.periodATR,d=c.multiplierATR,g=a.yData;g=g?g.length:0;var l=[];c=f.seriesTypes.ema.prototype.getValues(a,{period:b,index:c.index});var h=f.seriesTypes.atr.prototype.getValues(a,{period:e}),u=[],p=[],w;if(!(g<b)){for(w=b;w<=g;w++){var r=c.values[w-b];var m=h.values[w-e];var q=r[0];a=n(r[1]+d*m[1]);m=n(r[1]-d*m[1]);r=r[1];l.push([q,a,r,m]);u.push(q);p.push([a,r,m])}return{values:l,xData:u,yData:p}}};b.defaultOptions=l(m.defaultOptions,{params:{period:20,periodATR:10,multiplierATR:2},
bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Upper Channel: {point.top}<br/>EMA({series.options.params.period}): {point.middle}<br/>Lower Channel: {point.bottom}<br/>'},marker:{enabled:!1},dataGrouping:{approximation:"averages"},lineWidth:1});return b}(m);q(g.prototype,{pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameBase:"Keltner Channels",
nameComponents:["period","periodATR","multiplierATR"],linesApiNames:["topLine","bottomLine"],requiredIndicators:["ema","atr"],drawGraph:d.drawGraph,getTranslatedLinesNames:d.getTranslatedLinesNames,translate:d.translate,toYData:d.toYData});f.registerSeriesType("keltnerchannels",g);"";return g});t(d,"Stock/Indicators/MACD/MACDIndicator.js",[d["Core/Globals.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f,g){var h=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(c,b)};return function(c,b){function k(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):(k.prototype=b.prototype,new k)}}(),m=d.noop,n=f.seriesTypes.sma,q=g.extend,l=g.correctFloat,e=g.defined,b=g.merge;g=function(a){function c(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;c.currentLineZone=void 0;c.graphmacd=
void 0;c.graphsignal=void 0;c.macdZones=void 0;c.signalZones=void 0;return c}h(c,a);c.prototype.init=function(){f.seriesTypes.sma.prototype.init.apply(this,arguments);this.options&&(this.options=b({signalLine:{styles:{lineColor:this.color}},macdLine:{styles:{color:this.color}}},this.options),this.macdZones={zones:this.options.macdLine.zones,startIndex:0},this.signalZones={zones:this.macdZones.zones.concat(this.options.signalLine.zones),startIndex:this.macdZones.zones.length},this.resetZones=!0)};
c.prototype.toYData=function(a){return[a.y,a.signal,a.MACD]};c.prototype.translate=function(){var a=this,c=["plotSignal","plotMACD"];d.seriesTypes.column.prototype.translate.apply(a);a.points.forEach(function(b){[b.signal,b.MACD].forEach(function(k,e){null!==k&&(b[c[e]]=a.yAxis.toPixels(k,!0))})})};c.prototype.destroy=function(){this.graph=null;this.graphmacd=this.graphmacd&&this.graphmacd.destroy();this.graphsignal=this.graphsignal&&this.graphsignal.destroy();f.seriesTypes.sma.prototype.destroy.apply(this,
arguments)};c.prototype.drawGraph=function(){for(var a=this,c=a.points,d=c.length,g=a.options,l=a.zones,h={options:{gapSize:g.gapSize}},u=[[],[]],p;d--;)p=c[d],e(p.plotMACD)&&u[0].push({plotX:p.plotX,plotY:p.plotMACD,isNull:!e(p.plotMACD)}),e(p.plotSignal)&&u[1].push({plotX:p.plotX,plotY:p.plotSignal,isNull:!e(p.plotMACD)});["macd","signal"].forEach(function(c,e){a.points=u[e];a.options=b(g[c+"Line"].styles,h);a.graph=a["graph"+c];a.currentLineZone=c+"Zones";a.zones=a[a.currentLineZone].zones;f.seriesTypes.sma.prototype.drawGraph.call(a);
a["graph"+c]=a.graph});a.points=c;a.options=g;a.zones=l;a.currentLineZone=null};c.prototype.getZonesGraphs=function(c){var b=a.prototype.getZonesGraphs.call(this,c),e=b;this.currentLineZone&&(e=b.splice(this[this.currentLineZone].startIndex+1),e.length?e.splice(0,0,c[0]):e=[c[0]]);return e};c.prototype.applyZones=function(){var a=this.zones;this.zones=this.signalZones.zones;f.seriesTypes.sma.prototype.applyZones.call(this);this.graphmacd&&this.options.macdLine.zones.length&&this.graphmacd.hide();
this.zones=a};c.prototype.getValues=function(a,c){var b=0,k=[],d=[],g=[];if(!(a.xData.length<c.longPeriod+c.signalPeriod)){var y=f.seriesTypes.ema.prototype.getValues(a,{period:c.shortPeriod,index:c.index});var p=f.seriesTypes.ema.prototype.getValues(a,{period:c.longPeriod,index:c.index});y=y.values;p=p.values;for(a=1;a<=y.length;a++)e(p[a-1])&&e(p[a-1][1])&&e(y[a+c.shortPeriod+1])&&e(y[a+c.shortPeriod+1][0])&&k.push([y[a+c.shortPeriod+1][0],0,null,y[a+c.shortPeriod+1][1]-p[a-1][1]]);for(a=0;a<k.length;a++)d.push(k[a][0]),
g.push([0,null,k[a][3]]);c=f.seriesTypes.ema.prototype.getValues({xData:d,yData:g},{period:c.signalPeriod,index:2});c=c.values;for(a=0;a<k.length;a++)k[a][0]>=c[0][0]&&(k[a][2]=c[b][1],g[a]=[0,c[b][1],k[a][3]],null===k[a][3]?(k[a][1]=0,g[a][0]=0):(k[a][1]=l(k[a][3]-c[b][1]),g[a][0]=l(k[a][3]-c[b][1])),b++);return{values:k,xData:d,yData:g}}};c.defaultOptions=b(n.defaultOptions,{params:{shortPeriod:12,longPeriod:26,signalPeriod:9,period:26},signalLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},
macdLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},threshold:0,groupPadding:.1,pointPadding:.1,crisp:!1,states:{hover:{halo:{size:0}}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Value: {point.MACD}<br/>Signal: {point.signal}<br/>Histogram: {point.y}<br/>'},dataGrouping:{approximation:"averages"},minPointLength:0});return c}(n);q(g.prototype,{nameComponents:["longPeriod","shortPeriod","signalPeriod"],requiredIndicators:["ema"],pointArrayMap:["y",
"signal","MACD"],parallelArrays:["x","y","signal","MACD"],pointValKey:"y",markerAttribs:m,getColumnMetrics:d.seriesTypes.column.prototype.getColumnMetrics,crispCol:d.seriesTypes.column.prototype.crispCol,drawPoints:d.seriesTypes.column.prototype.drawPoints});f.registerSeriesType("macd",g);"";return g});t(d,"Stock/Indicators/MFI/MFIIndicator.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){function g(a){return a.reduce(function(a,b){return a+b})}function h(a){return(a[1]+
a[2]+a[3])/3}var m=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(c,b)};return function(c,b){function e(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):(e.prototype=b.prototype,new e)}}(),n=d.seriesTypes.sma,q=f.extend,l=f.merge,e=f.error,b=f.isArray;f=function(a){function c(){var c=null!==a&&a.apply(this,arguments)||
this;c.data=void 0;c.options=void 0;c.points=void 0;return c}m(c,a);c.prototype.getValues=function(a,c){var k=c.period,f=a.xData,d=a.yData,l=d?d.length:0,y=c.decimals,p=1,w=a.chart.get(c.volumeSeriesID),r=w&&w.yData,m=[],q=[],n=[],x=[],z=[];if(!w)e("Series "+c.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,a.chart);else if(!(f.length<=k)&&b(d[0])&&4===d[0].length&&r){for(a=h(d[p]);p<k+1;)c=a,a=h(d[p]),c=a>=c,w=a*r[p],x.push(c?w:0),z.push(c?0:w),p++;for(k=p-1;k<l;k++)k>p-1&&(x.shift(),z.shift(),
c=a,a=h(d[k]),c=a>c,w=a*r[k],x.push(c?w:0),z.push(c?0:w)),c=g(z),w=g(x),c=w/c,c=parseFloat((100-100/(1+c)).toFixed(y)),m.push([f[k],c]),q.push(f[k]),n.push(c);return{values:m,xData:q,yData:n}}};c.defaultOptions=l(n.defaultOptions,{params:{period:14,volumeSeriesID:"volume",decimals:4}});return c}(n);q(f.prototype,{nameBase:"Money Flow Index"});d.registerSeriesType("mfi",f);"";return f});t(d,"Stock/Indicators/Momentum/MomentumIndicator.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],
function(d,f){function g(e,b,a,c,k){a=a[c-1][3]-a[c-k-1][3];b=b[c-1];e.shift();return[b,a]}var h=this&&this.__extends||function(){var e=function(b,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(b,a)};return function(b,a){function c(){this.constructor=b}e(b,a);b.prototype=null===a?Object.create(a):(c.prototype=a.prototype,new c)}}(),m=d.seriesTypes.sma,n=f.extend,q=f.isArray,l=f.merge;
f=function(e){function b(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}h(b,e);b.prototype.getValues=function(a,c){c=c.period;var b=a.xData,e=(a=a.yData)?a.length:0,f=b[0],d=[],l=[],h=[];if(!(b.length<=c)&&q(a[0])){var u=a[0][3];u=[[f,u]];for(f=c+1;f<e;f++){var p=g(u,b,a,f,c,void 0);d.push(p);l.push(p[0]);h.push(p[1])}p=g(u,b,a,f,c,void 0);d.push(p);l.push(p[0]);h.push(p[1]);return{values:d,xData:l,yData:h}}};b.defaultOptions=l(m.defaultOptions,
{params:{period:14}});return b}(m);n(f.prototype,{nameBase:"Momentum"});d.registerSeriesType("momentum",f);"";return f});t(d,"Stock/Indicators/NATR/NATRIndicator.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){var g=this&&this.__extends||function(){var f=function(d,e){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,a){b.__proto__=a}||function(b,a){for(var c in a)a.hasOwnProperty(c)&&(b[c]=a[c])};return f(d,e)};return function(d,e){function b(){this.constructor=
d}f(d,e);d.prototype=null===e?Object.create(e):(b.prototype=e.prototype,new b)}}(),h=d.seriesTypes.atr,m=f.merge;f=f.extend;var n=function(f){function d(){var e=null!==f&&f.apply(this,arguments)||this;e.data=void 0;e.points=void 0;e.options=void 0;return e}g(d,f);d.prototype.getValues=function(e,b){var a=h.prototype.getValues.apply(this,arguments),c=a.values.length,k=b.period-1,f=e.yData,d=0;if(a){for(;d<c;d++)a.yData[d]=a.values[d][1]/f[k][3]*100,a.values[d][1]=a.yData[d],k++;return a}};d.defaultOptions=
m(h.defaultOptions,{tooltip:{valueSuffix:"%"}});return d}(h);f(n.prototype,{requiredIndicators:["atr"]});d.registerSeriesType("natr",n);"";return n});t(d,"Stock/Indicators/PivotPoints/PivotPointsPoint.js",[d["Core/Series/SeriesRegistry.js"]],function(d){function f(f,g){var h=f.series.pointArrayMap,m=h.length;for(d.seriesTypes.sma.prototype.pointClass.prototype[g].call(f);m--;)g="dataLabel"+h[m],f[g]&&f[g].element&&f[g].destroy(),f[g]=null}var g=this&&this.__extends||function(){var f=function(d,g){f=
Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(f,d){f.__proto__=d}||function(f,d){for(var e in d)d.hasOwnProperty(e)&&(f[e]=d[e])};return f(d,g)};return function(d,g){function h(){this.constructor=d}f(d,g);d.prototype=null===g?Object.create(g):(h.prototype=g.prototype,new h)}}();return function(d){function h(){var f=null!==d&&d.apply(this,arguments)||this;f.P=void 0;f.pivotLine=void 0;f.series=void 0;return f}g(h,d);h.prototype.destroyElements=function(){f(this,"destroyElements")};
h.prototype.destroy=function(){f(this,"destroyElements")};return h}(d.seriesTypes.sma.prototype.pointClass)});t(d,"Stock/Indicators/PivotPoints/PivotPointsIndicator.js",[d["Stock/Indicators/PivotPoints/PivotPointsPoint.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f,g){var h=this&&this.__extends||function(){var b=function(a,c){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=
c[b])};return b(a,c)};return function(a,c){function e(){this.constructor=a}b(a,c);a.prototype=null===c?Object.create(c):(e.prototype=c.prototype,new e)}}(),m=f.seriesTypes.sma,n=g.merge,q=g.extend,l=g.defined,e=g.isArray;g=function(b){function a(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;a.endPoint=void 0;a.plotEndPoint=void 0;return a}h(a,b);a.prototype.toYData=function(a){return[a.P]};a.prototype.translate=function(){var a=this;f.seriesTypes.sma.prototype.translate.apply(a);
a.points.forEach(function(c){a.pointArrayMap.forEach(function(b){l(c[b])&&(c["plot"+b]=a.yAxis.toPixels(c[b],!0))})});a.plotEndPoint=a.xAxis.toPixels(a.endPoint,!0)};a.prototype.getGraphPath=function(a){for(var c=this,b=a.length,e=[[],[],[],[],[],[],[],[],[]],d=[],g=c.plotEndPoint,h=c.pointArrayMap.length,u,p,m;b--;){p=a[b];for(m=0;m<h;m++)u=c.pointArrayMap[m],l(p[u])&&e[m].push({plotX:p.plotX,plotY:p["plot"+u],isNull:!1},{plotX:g,plotY:p["plot"+u],isNull:!1},{plotX:g,plotY:null,isNull:!0});g=p.plotX}e.forEach(function(a){d=
d.concat(f.seriesTypes.sma.prototype.getGraphPath.call(c,a))});return d};a.prototype.drawDataLabels=function(){var a=this,b=a.pointArrayMap,e,d,g;if(a.options.dataLabels.enabled){var l=a.points.length;b.concat([!1]).forEach(function(c,k){for(g=l;g--;)d=a.points[g],c?(d.y=d[c],d.pivotLine=c,d.plotY=d["plot"+c],e=d["dataLabel"+c],k&&(d["dataLabel"+b[k-1]]=d.dataLabel),d.dataLabels||(d.dataLabels=[]),d.dataLabels[0]=d.dataLabel=e=e&&e.element?e:null):d["dataLabel"+b[k-1]]=d.dataLabel;f.seriesTypes.sma.prototype.drawDataLabels.apply(a,
arguments)})}};a.prototype.getValues=function(a,b){var c=b.period,f=a.xData,k=(a=a.yData)?a.length:0;b=this[b.algorithm+"Placement"];var d=[],g=[],l=[],p;if(!(f.length<c)&&e(a[0])&&4===a[0].length){for(p=c+1;p<=k+c;p+=c){var h=f.slice(p-c-1,p);var r=a.slice(p-c-1,p);var m=h.length;var q=h[m-1];r=this.getPivotAndHLC(r);r=b(r);r=d.push([q].concat(r));g.push(q);l.push(d[r-1].slice(1))}this.endPoint=h[0]+(q-h[0])/m*c;return{values:d,xData:g,yData:l}}};a.prototype.getPivotAndHLC=function(a){var c=-Infinity,
b=Infinity,e=a[a.length-1][3];a.forEach(function(a){c=Math.max(c,a[1]);b=Math.min(b,a[2])});return[(c+b+e)/3,c,b,e]};a.prototype.standardPlacement=function(a){var c=a[1]-a[2];return[null,null,a[0]+c,2*a[0]-a[2],a[0],2*a[0]-a[1],a[0]-c,null,null]};a.prototype.camarillaPlacement=function(a){var c=a[1]-a[2];return[a[3]+1.5*c,a[3]+1.25*c,a[3]+1.1666*c,a[3]+1.0833*c,a[0],a[3]-1.0833*c,a[3]-1.1666*c,a[3]-1.25*c,a[3]-1.5*c]};a.prototype.fibonacciPlacement=function(a){var c=a[1]-a[2];return[null,a[0]+c,a[0]+
.618*c,a[0]+.382*c,a[0],a[0]-.382*c,a[0]-.618*c,a[0]-c,null]};a.defaultOptions=n(m.defaultOptions,{params:{period:28,algorithm:"standard"},marker:{enabled:!1},enableMouseTracking:!1,dataLabels:{enabled:!0,format:"{point.pivotLine}"},dataGrouping:{approximation:"averages"}});return a}(m);q(g.prototype,{nameBase:"Pivot Points",pointArrayMap:"R4 R3 R2 R1 P S1 S2 S3 S4".split(" "),pointValKey:"P",pointClass:d});f.registerSeriesType("pivotpoints",g);"";return g});t(d,"Stock/Indicators/PPO/PPOIndicator.js",
[d["Mixins/IndicatorRequired.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f,g){var h=this&&this.__extends||function(){var b=function(a,c){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return b(a,c)};return function(a,c){function e(){this.constructor=a}b(a,c);a.prototype=null===c?Object.create(c):(e.prototype=c.prototype,new e)}}(),m=f.seriesTypes.ema,n=g.correctFloat,
q=g.extend,l=g.merge,e=g.error;g=function(b){function a(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}h(a,b);a.prototype.init=function(){var a=arguments,b=this;d.isParentLoaded(m,"ema",b.type,function(c){c.prototype.init.apply(b,a)})};a.prototype.getValues=function(a,b){var c=b.periods,f=b.index;b=[];var d=[],k=[],g;if(2!==c.length||c[1]<=c[0])e('Error: "PPO requires two periods. Notice, first period should be lower than the second one."');
else{var l=m.prototype.getValues.call(this,a,{index:f,period:c[0]});a=m.prototype.getValues.call(this,a,{index:f,period:c[1]});if(l&&a){c=c[1]-c[0];for(g=0;g<a.yData.length;g++)f=n((l.yData[g+c]-a.yData[g])/a.yData[g]*100),b.push([a.xData[g],f]),d.push(a.xData[g]),k.push(f);return{values:b,xData:d,yData:k}}}};a.defaultOptions=l(m.defaultOptions,{params:{periods:[12,26]}});return a}(m);q(g.prototype,{nameBase:"PPO",nameComponents:["periods"]});f.registerSeriesType("ppo",g);"";return g});t(d,"Mixins/ReduceArray.js",
[],function(){return{minInArray:function(d,f){return d.reduce(function(d,h){return Math.min(d,h[f])},Number.MAX_VALUE)},maxInArray:function(d,f){return d.reduce(function(d,h){return Math.max(d,h[f])},-Number.MAX_VALUE)},getArrayExtremes:function(d,f,g){return d.reduce(function(d,m){return[Math.min(d[0],m[f]),Math.max(d[1],m[g])]},[Number.MAX_VALUE,-Number.MAX_VALUE])}}});t(d,"Stock/Indicators/PC/PCIndicator.js",[d["Core/Color/Palette.js"],d["Mixins/MultipleLines.js"],d["Mixins/ReduceArray.js"],d["Core/Series/SeriesRegistry.js"],
d["Core/Utilities.js"]],function(d,f,g,h,z){var m=this&&this.__extends||function(){var b=function(a,c){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return b(a,c)};return function(a,c){function e(){this.constructor=a}b(a,c);a.prototype=null===c?Object.create(c):(e.prototype=c.prototype,new e)}}(),q=h.seriesTypes.sma,l=z.merge;z=z.extend;var e=g.getArrayExtremes;g=function(b){function a(){var a=
null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}m(a,b);a.prototype.getValues=function(a,b){b=b.period;var c=a.xData,f=(a=a.yData)?a.length:0,d=[],k=[],g=[],l;if(!(f<b)){for(l=b;l<=f;l++){var p=c[l-1];var h=a.slice(l-b,l);var r=e(h,2,1);h=r[1];var m=r[0];r=(h+m)/2;d.push([p,h,r,m]);k.push(p);g.push([h,r,m])}return{values:d,xData:k,yData:g}}};a.defaultOptions=l(q.defaultOptions,{params:{period:20},lineWidth:1,topLine:{styles:{lineColor:d.colors[2],lineWidth:1}},
bottomLine:{styles:{lineColor:d.colors[8],lineWidth:1}},dataGrouping:{approximation:"averages"}});return a}(q);z(g.prototype,{getTranslatedLinesNames:f.getTranslatedLinesNames,drawGraph:f.drawGraph,toYData:f.toYData,pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameBase:"Price Channel",nameComponents:["period"],linesApiNames:["topLine","bottomLine"],translate:f.translate});h.registerSeriesType("pc",g);"";return g});t(d,"Stock/Indicators/PriceEnvelopes/PriceEnvelopesIndicator.js",[d["Core/Series/SeriesRegistry.js"],
d["Core/Utilities.js"]],function(d,f){var g=this&&this.__extends||function(){var f=function(e,b){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return f(e,b)};return function(e,b){function a(){this.constructor=e}f(e,b);e.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),h=d.seriesTypes.sma,m=f.extend,n=f.isArray,q=f.merge;f=function(f){function e(){var b=null!==f&&f.apply(this,
arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}g(e,f);e.prototype.init=function(){d.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=q({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)};e.prototype.toYData=function(b){return[b.top,b.middle,b.bottom]};e.prototype.translate=function(){var b=this,a=["plotTop","plotMiddle","plotBottom"];d.seriesTypes.sma.prototype.translate.apply(b);b.points.forEach(function(c){[c.top,
c.middle,c.bottom].forEach(function(e,f){null!==e&&(c[a[f]]=b.yAxis.toPixels(e,!0))})})};e.prototype.drawGraph=function(){for(var b=this,a=b.points,c=a.length,e=b.options,f=b.graph,g={options:{gapSize:e.gapSize}},l=[[],[]],h;c--;)h=a[c],l[0].push({plotX:h.plotX,plotY:h.plotTop,isNull:h.isNull}),l[1].push({plotX:h.plotX,plotY:h.plotBottom,isNull:h.isNull});["topLine","bottomLine"].forEach(function(a,c){b.points=l[c];b.options=q(e[a].styles,g);b.graph=b["graph"+a];d.seriesTypes.sma.prototype.drawGraph.call(b);
b["graph"+a]=b.graph});b.points=a;b.options=e;b.graph=f;d.seriesTypes.sma.prototype.drawGraph.call(b)};e.prototype.getValues=function(b,a){var c=a.period,e=a.topBand,f=a.bottomBand,g=b.xData,l=(b=b.yData)?b.length:0,h=[],m=[],u=[],p;if(!(g.length<c)&&n(b[0])&&4===b[0].length){for(p=c;p<=l;p++){var w=g.slice(p-c,p);var r=b.slice(p-c,p);r=d.seriesTypes.sma.prototype.getValues.call(this,{xData:w,yData:r},a);w=r.xData[0];r=r.yData[0];var q=r*(1+e);var L=r*(1-f);h.push([w,q,r,L]);m.push(w);u.push([q,r,
L])}return{values:h,xData:m,yData:u}}};e.defaultOptions=q(h.defaultOptions,{marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},params:{period:20,topBand:.1,bottomBand:.1},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}});return e}(h);m(f.prototype,{nameComponents:["period","topBand","bottomBand"],
nameBase:"Price envelopes",pointArrayMap:["top","middle","bottom"],parallelArrays:["x","y","top","bottom"],pointValKey:"middle"});d.registerSeriesType("priceenvelopes",f);"";return f});t(d,"Stock/Indicators/PSAR/PSARIndicator.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){var g=this&&this.__extends||function(){var f=function(d,e){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,a){b.__proto__=a}||function(b,a){for(var c in a)a.hasOwnProperty(c)&&(b[c]=
a[c])};return f(d,e)};return function(d,e){function b(){this.constructor=d}f(d,e);d.prototype=null===e?Object.create(e):(b.prototype=e.prototype,new b)}}(),h=d.seriesTypes.sma,m=f.merge;f=f.extend;var n=function(f){function d(){var e=null!==f&&f.apply(this,arguments)||this;e.data=void 0;e.points=void 0;e.options=void 0;return e}g(d,f);d.prototype.getValues=function(e,b){var a=e.xData;e=e.yData;var c=e[0][1],f=b.maxAccelerationFactor,d=b.increment,g=b.initialAccelerationFactor,l=e[0][2],h=b.decimals,
m=b.index,u=[],p=[],w=[],r=1,q;if(!(m>=e.length)){for(q=0;q<m;q++)c=Math.max(e[q][1],c),l=Math.min(e[q][2],parseFloat(l.toFixed(h)));var n=e[q][1]>l?1:-1;b=b.initialAccelerationFactor;var B=b*(c-l);u.push([a[m],l]);p.push(a[m]);w.push(parseFloat(l.toFixed(h)));for(q=m+1;q<e.length;q++){m=e[q-1][2];var x=e[q-2][2];var C=e[q-1][1];var z=e[q-2][1];var D=e[q][1];var t=e[q][2];null!==x&&null!==z&&null!==m&&null!==C&&null!==D&&null!==t&&(l=n===r?1===n?l+B<Math.min(x,m)?l+B:Math.min(x,m):l+B>Math.max(z,
C)?l+B:Math.max(z,C):c,m=1===n?D>c?D:c:t<c?t:c,D=1===r&&t>l||-1===r&&D>l?1:-1,r=D,B=m,t=d,x=f,C=g,b=r===n?1===r&&B>c?b===x?x:parseFloat((b+t).toFixed(2)):-1===r&&B<c?b===x?x:parseFloat((b+t).toFixed(2)):b:C,c=m-l,B=b*c,u.push([a[q],parseFloat(l.toFixed(h))]),p.push(a[q]),w.push(parseFloat(l.toFixed(h))),r=n,n=D,c=m)}return{values:u,xData:p,yData:w}}};d.defaultOptions=m(h.defaultOptions,{lineWidth:0,marker:{enabled:!0},states:{hover:{lineWidthPlus:0}},params:{initialAccelerationFactor:.02,maxAccelerationFactor:.2,
increment:.02,index:2,decimals:4}});return d}(h);f(n.prototype,{nameComponents:!1});d.registerSeriesType("psar",n);"";return n});t(d,"Stock/Indicators/ROC/ROCIndicator.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){var g=this&&this.__extends||function(){var f=function(e,b){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return f(e,b)};return function(e,b){function a(){this.constructor=
e}f(e,b);e.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),h=d.seriesTypes.sma,m=f.isArray,n=f.merge;f=f.extend;var q=function(f){function e(){var b=null!==f&&f.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}g(e,f);e.prototype.getValues=function(b,a){var c=a.period,e=b.xData,f=(b=b.yData)?b.length:0,d=[],g=[],l=[],h=-1;if(!(e.length<=c)){m(b[0])&&(h=a.index);for(a=c;a<f;a++){var u=0>h?(u=b[a-c])?(b[a]-u)/u*100:null:(u=b[a-c][h])?(b[a][h]-
u)/u*100:null;u=[e[a],u];d.push(u);g.push(u[0]);l.push(u[1])}return{values:d,xData:g,yData:l}}};e.defaultOptions=n(h.defaultOptions,{params:{index:3,period:9}});return e}(h);f(q.prototype,{nameBase:"Rate of Change"});d.registerSeriesType("roc",q);"";return q});t(d,"Stock/Indicators/RSI/RSIIndicator.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){var g=this&&this.__extends||function(){var f=function(d,e){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,
a){b.__proto__=a}||function(b,a){for(var c in a)a.hasOwnProperty(c)&&(b[c]=a[c])};return f(d,e)};return function(d,e){function b(){this.constructor=d}f(d,e);d.prototype=null===e?Object.create(e):(b.prototype=e.prototype,new b)}}(),h=d.seriesTypes.sma,m=f.isArray,n=f.merge;f=function(f){function d(){var e=null!==f&&f.apply(this,arguments)||this;e.data=void 0;e.points=void 0;e.options=void 0;return e}g(d,f);d.prototype.getValues=function(e,b){var a=b.period,c=e.xData,f=(e=e.yData)?e.length:0;b=b.decimals;
var d=1,g=[],l=[],h=[],q=0,u=0,p;if(!(c.length<a)&&m(e[0])&&4===e[0].length){for(;d<a;){var w=parseFloat((e[d][3]-e[d-1][3]).toFixed(b));0<w?q+=w:u+=Math.abs(w);d++}var r=parseFloat((q/(a-1)).toFixed(b));for(p=parseFloat((u/(a-1)).toFixed(b));d<f;d++)w=parseFloat((e[d][3]-e[d-1][3]).toFixed(b)),0<w?(q=w,u=0):(q=0,u=Math.abs(w)),r=parseFloat(((r*(a-1)+q)/a).toFixed(b)),p=parseFloat(((p*(a-1)+u)/a).toFixed(b)),q=0===p?100:0===r?0:parseFloat((100-100/(1+r/p)).toFixed(b)),g.push([c[d],q]),l.push(c[d]),
h.push(q);return{values:g,xData:l,yData:h}}};d.defaultOptions=n(h.defaultOptions,{params:{period:14,decimals:4}});return d}(h);d.registerSeriesType("rsi",f);"";return f});t(d,"Stock/Indicators/Stochastic/StochasticIndicator.js",[d["Mixins/MultipleLines.js"],d["Mixins/ReduceArray.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f,g,h){var m=this&&this.__extends||function(){var b=function(a,c){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=
c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return b(a,c)};return function(a,c){function e(){this.constructor=a}b(a,c);a.prototype=null===c?Object.create(c):(e.prototype=c.prototype,new e)}}(),n=g.seriesTypes.sma,q=h.extend,l=h.isArray,e=h.merge;h=function(b){function a(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}m(a,b);a.prototype.init=function(){g.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=
e({smoothedLine:{styles:{lineColor:this.color}}},this.options)};a.prototype.getValues=function(a,b){var c=b.periods[0];b=b.periods[1];var e=a.xData,d=(a=a.yData)?a.length:0,k=[],h=[],m=[],p=null,w;if(!(d<c)&&l(a[0])&&4===a[0].length){for(w=c-1;w<d;w++){var r=a.slice(w-c+1,w+1);var q=f.getArrayExtremes(r,2,1);var n=q[0];r=a[w][3]-n;n=q[1]-n;r=r/n*100;h.push(e[w]);m.push([r,null]);w>=c-1+(b-1)&&(p=g.seriesTypes.sma.prototype.getValues.call(this,{xData:h.slice(-b),yData:m.slice(-b)},{period:b}),p=p.yData[0]);
k.push([e[w],r,p]);m[m.length-1][1]=p}return{values:k,xData:h,yData:m}}};a.defaultOptions=e(n.defaultOptions,{params:{periods:[14,3]},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>%K: {point.y}<br/>%D: {point.smoothed}<br/>'},smoothedLine:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}});return a}(n);q(h.prototype,{nameComponents:["periods"],nameBase:"Stochastic",pointArrayMap:["y","smoothed"],parallelArrays:["x",
"y","smoothed"],pointValKey:"y",linesApiNames:["smoothedLine"],drawGraph:d.drawGraph,getTranslatedLinesNames:d.getTranslatedLinesNames,translate:d.translate,toYData:d.toYData});g.registerSeriesType("stochastic",h);"";return h});t(d,"Stock/Indicators/SlowStochastic/SlowStochasticIndicator.js",[d["Mixins/IndicatorRequired.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f,g){var h=this&&this.__extends||function(){var e=function(b,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(b,a)};return function(b,a){function c(){this.constructor=b}e(b,a);b.prototype=null===a?Object.create(a):(c.prototype=a.prototype,new c)}}(),m=f.seriesTypes.stochastic,n=f.seriesTypes,q=g.extend,l=g.merge;g=function(e){function b(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}h(b,e);b.prototype.init=function(){var a=arguments,b=this;d.isParentLoaded(n.stochastic,
"stochastic",b.type,function(c){c.prototype.init.apply(b,a)})};b.prototype.getValues=function(a,b){var c=b.periods,e=n.stochastic.prototype.getValues.call(this,a,b);a={values:[],xData:[],yData:[]};b=0;if(e){a.xData=e.xData.slice(c[1]-1);e=e.yData.slice(c[1]-1);var f=n.sma.prototype.getValues.call(this,{xData:a.xData,yData:e},{index:1,period:c[2]});if(f){for(var d=a.xData.length;b<d;b++)a.yData[b]=[e[b][1],f.yData[b-c[2]+1]||null],a.values[b]=[a.xData[b],e[b][1],f.yData[b-c[2]+1]||null];return a}}};
b.defaultOptions=l(m.defaultOptions,{params:{periods:[14,3,3]}});return b}(m);q(g.prototype,{nameBase:"Slow Stochastic"});f.registerSeriesType("slowstochastic",g);"";return g});t(d,"Stock/Indicators/Supertrend/SupertrendIndicator.js",[d["Core/Color/Palette.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f,g){function h(a,b,c){return{index:b,close:a.yData[b][c],x:a.xData[b]}}var m=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function e(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(e.prototype=c.prototype,new e)}}(),n=f.seriesTypes,q=n.atr,l=n.sma,e=g.correctFloat,b=g.isArray;n=g.extend;var a=g.merge,c=g.objectEach;g=function(f){function g(){var a=null!==f&&f.apply(this,arguments)||this;a.data=void 0;a.linkedParent=void 0;a.options=void 0;a.points=void 0;return a}
m(g,f);g.prototype.init=function(){l.prototype.init.apply(this,arguments);var a=this.options;a.cropThreshold=this.linkedParent.options.cropThreshold-(a.params.period-1)};g.prototype.drawGraph=function(){var b=this,e=b.options,f=b.linkedParent,d=f?f.points:[],g=b.points,k=b.graph,m=g.length,r=d.length-m;r=0<r?r:0;for(var q={options:{gapSize:e.gapSize}},n={top:[],bottom:[],intersect:[]},y={top:{styles:{lineWidth:e.lineWidth,lineColor:e.fallingTrendColor||e.color,dashStyle:e.dashStyle}},bottom:{styles:{lineWidth:e.lineWidth,
lineColor:e.risingTrendColor||e.color,dashStyle:e.dashStyle}},intersect:e.changeTrendLine},x,C,t,D,z,G,H,I;m--;)x=g[m],C=g[m-1],t=d[m-1+r],D=d[m-2+r],z=d[m+r],G=d[m+r+1],H=x.options.color,I={x:x.x,plotX:x.plotX,plotY:x.plotY,isNull:!1},!D&&t&&f.yData[t.index-1]&&(D=h(f,t.index-1,3)),!G&&z&&f.yData[z.index+1]&&(G=h(f,z.index+1,3)),!t&&D&&f.yData[D.index+1]?t=h(f,D.index+1,3):!t&&z&&f.yData[z.index-1]&&(t=h(f,z.index-1,3)),x&&t&&z&&D&&x.x!==t.x&&(x.x===z.x?(D=t,t=z):x.x===D.x?(t=D,D={close:f.yData[t.index-
1][3],x:f.xData[t.index-1]}):G&&x.x===G.x&&(t=G,D=z)),C&&D&&t?(z={x:C.x,plotX:C.plotX,plotY:C.plotY,isNull:!1},x.y>=t.close&&C.y>=D.close?(x.color=H||e.fallingTrendColor||e.color,n.top.push(I)):x.y<t.close&&C.y<D.close?(x.color=H||e.risingTrendColor||e.color,n.bottom.push(I)):(n.intersect.push(I),n.intersect.push(z),n.intersect.push(a(z,{isNull:!0})),x.y>=t.close&&C.y<D.close?(x.color=H||e.fallingTrendColor||e.color,C.color=H||e.risingTrendColor||e.color,n.top.push(I),n.top.push(a(z,{isNull:!0}))):
x.y<t.close&&C.y>=D.close&&(x.color=H||e.risingTrendColor||e.color,C.color=H||e.fallingTrendColor||e.color,n.bottom.push(I),n.bottom.push(a(z,{isNull:!0}))))):t&&(x.y>=t.close?(x.color=H||e.fallingTrendColor||e.color,n.top.push(I)):(x.color=H||e.risingTrendColor||e.color,n.bottom.push(I)));c(n,function(c,e){b.points=c;b.options=a(y[e].styles,q);b.graph=b["graph"+e+"Line"];l.prototype.drawGraph.call(b);b["graph"+e+"Line"]=b.graph});b.points=g;b.options=e;b.graph=k};g.prototype.getValues=function(a,
c){var f=c.period;c=c.multiplier;var d=a.xData,g=a.yData,k=[],h=[],l=[],m=0===f?0:f-1,n=[],v=[],x;if(!(d.length<=f||!b(g[0])||4!==g[0].length||0>f)){a=q.prototype.getValues.call(this,a,{period:f}).yData;for(x=0;x<a.length;x++){var y=g[m+x];var A=g[m+x-1]||[];var t=n[x-1];var z=v[x-1];var G=l[x-1];0===x&&(t=z=G=0);f=e((y[1]+y[2])/2+c*a[x]);var H=e((y[1]+y[2])/2-c*a[x]);n[x]=f<t||A[3]>t?f:t;v[x]=H>z||A[3]<z?H:z;if(G===t&&y[3]<n[x]||G===z&&y[3]<v[x])var I=n[x];else if(G===t&&y[3]>n[x]||G===z&&y[3]>v[x])I=
v[x];k.push([d[m+x],I]);h.push(d[m+x]);l.push(I)}return{values:k,xData:h,yData:l}}};g.defaultOptions=a(l.defaultOptions,{params:{multiplier:3,period:10},risingTrendColor:d.indicatorPositiveLine,fallingTrendColor:d.indicatorNegativeLine,changeTrendLine:{styles:{lineWidth:1,lineColor:d.neutralColor80,dashStyle:"LongDash"}}});return g}(l);n(g.prototype,{nameBase:"Supertrend",nameComponents:["multiplier","period"],requiredIndicators:["atr"]});f.registerSeriesType("supertrend",g);"";return g});t(d,"Stock/Indicators/VBP/VBPIndicator.js",
[d["Core/Animation/AnimationUtilities.js"],d["Core/Globals.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f,g,h){var m=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function e(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(e.prototype=c.prototype,new e)}}(),n=
d.animObject;d=f.noop;var q=g.seriesTypes.sma,l=h.addEvent,e=h.arrayMax,b=h.arrayMin,a=h.correctFloat,c=h.error,k=h.extend,y=h.isArray,v=h.merge,A=Math.abs,t=g.seriesTypes.column.prototype;h=function(d){function g(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.negWidths=void 0;a.options=void 0;a.points=void 0;a.posWidths=void 0;a.priceZones=void 0;a.rangeStep=void 0;a.volumeDataArray=void 0;a.zoneStarts=void 0;a.zoneLinesSVG=void 0;return a}m(g,d);g.prototype.init=function(a){f.seriesTypes.sma.prototype.init.apply(this,
arguments);var b=this.options.params;var c=this.linkedParent;b=a.get(b.volumeSeriesID);this.addCustomEvents(c,b);return this};g.prototype.addCustomEvents=function(a,b){function c(){e.chart.redraw();e.setData([]);e.zoneStarts=[];e.zoneLinesSVG&&(e.zoneLinesSVG.destroy(),delete e.zoneLinesSVG)}var e=this;e.dataEventsToUnbind.push(l(a,"remove",function(){c()}));b&&e.dataEventsToUnbind.push(l(b,"remove",function(){c()}));return e};g.prototype.animate=function(a){var b=this,c=b.chart.inverted,e=b.group,
f={};!a&&e&&(a=c?"translateY":"translateX",c=c?b.yAxis.top:b.xAxis.left,e["forceAnimate:"+a]=!0,f[a]=c,e.animate(f,k(n(b.options.animation),{step:function(a,c){b.group.attr({scaleX:Math.max(.001,c.pos)})}})))};g.prototype.drawPoints=function(){this.options.volumeDivision.enabled&&(this.posNegVolume(!0,!0),t.drawPoints.apply(this,arguments),this.posNegVolume(!1,!1));t.drawPoints.apply(this,arguments)};g.prototype.posNegVolume=function(a,b){var c=b?["positive","negative"]:["negative","positive"],e=
this.options.volumeDivision,f=this.points.length,d=[],g=[],k=0,h;a?(this.posWidths=d,this.negWidths=g):(d=this.posWidths,g=this.negWidths);for(;k<f;k++){var l=this.points[k];l[c[0]+"Graphic"]=l.graphic;l.graphic=l[c[1]+"Graphic"];if(a){var p=l.shapeArgs.width;var m=this.priceZones[k];(h=m.wholeVolumeData)?(d.push(p/h*m.positiveVolumeData),g.push(p/h*m.negativeVolumeData)):(d.push(0),g.push(0))}l.color=b?e.styles.positiveColor:e.styles.negativeColor;l.shapeArgs.width=b?this.posWidths[k]:this.negWidths[k];
l.shapeArgs.x=b?l.shapeArgs.x:this.posWidths[k]}};g.prototype.translate=function(){var b=this,c=b.options,f=b.chart,d=b.yAxis,g=d.min,k=b.options.zoneLines,l=b.priceZones,h=0,m,q,n;t.translate.apply(b);var u=b.points;if(u.length){var v=.5>c.pointPadding?c.pointPadding:.1;c=b.volumeDataArray;var y=e(c);var z=f.plotWidth/2;var J=f.plotTop;var K=A(d.toPixels(g)-d.toPixels(g+b.rangeStep));var F=A(d.toPixels(g)-d.toPixels(g+b.rangeStep));v&&(g=A(K*(1-2*v)),h=A((K-g)/2),K=A(g));u.forEach(function(c,e){q=
c.barX=c.plotX=0;n=c.plotY=d.toPixels(l[e].start)-J-(d.reversed?K-F:K)-h;m=a(z*l[e].wholeVolumeData/y);c.pointWidth=m;c.shapeArgs=b.crispCol.apply(b,[q,n,m,K]);c.volumeNeg=l[e].negativeVolumeData;c.volumePos=l[e].positiveVolumeData;c.volumeAll=l[e].wholeVolumeData});k.enabled&&b.drawZones(f,d,b.zoneStarts,k.styles)}};g.prototype.getValues=function(a,b){var e=a.processedXData,f=a.processedYData,d=this.chart,g=b.ranges,k=[],l=[],h=[],m;if(a.chart)if(m=d.get(b.volumeSeriesID))if((b=y(f[0]))&&4!==f[0].length)c("Type of "+
a.name+" series is different than line, OHLC or candlestick.",!0,d);else return(this.priceZones=this.specifyZones(b,e,f,g,m)).forEach(function(a,b){k.push([a.x,a.end]);l.push(k[b][0]);h.push(k[b][1])}),{values:k,xData:l,yData:h};else c("Series "+b.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,d);else c("Base series not found! In case it has been removed, add a new one.",!0,d)};g.prototype.specifyZones=function(c,f,d,g,k){if(c){var l=d.length;for(var h=d[0][3],m=h,p=1,q;p<l;p++)q=d[p][3],
q<h&&(h=q),q>m&&(m=q);l={min:h,max:m}}else l=!1;l=(h=l)?h.min:b(d);q=h?h.max:e(d);h=this.zoneStarts=[];m=[];var n=0;p=1;if(!l||!q)return this.points.length&&(this.setData([]),this.zoneStarts=[],this.zoneLinesSVG.destroy()),[];var r=this.rangeStep=a(q-l)/g;for(h.push(l);n<g-1;n++)h.push(a(h[n]+r));h.push(q);for(g=h.length;p<g;p++)m.push({index:p-1,x:f[0],start:h[p-1],end:h[p]});return this.volumePerZone(c,m,k,f,d)};g.prototype.volumePerZone=function(a,b,c,e,f){var d=this,g=c.processedXData,k=c.processedYData,
l=b.length-1,h=f.length;c=k.length;var m,p,q,n,r;A(h-c)&&(e[0]!==g[0]&&k.unshift(0),e[h-1]!==g[c-1]&&k.push(0));d.volumeDataArray=[];b.forEach(function(b){b.wholeVolumeData=0;b.positiveVolumeData=0;for(r=b.negativeVolumeData=0;r<h;r++)q=p=!1,n=a?f[r][3]:f[r],m=r?a?f[r-1][3]:f[r-1]:n,n<=b.start&&0===b.index&&(p=!0),n>=b.end&&b.index===l&&(q=!0),(n>b.start||p)&&(n<b.end||q)&&(b.wholeVolumeData+=k[r],m>n?b.negativeVolumeData+=k[r]:b.positiveVolumeData+=k[r]);d.volumeDataArray.push(b.wholeVolumeData)});
return b};g.prototype.drawZones=function(a,b,c,e){var f=a.renderer,d=this.zoneLinesSVG,g=[],k=a.plotWidth,h=a.plotTop,l;c.forEach(function(c){l=b.toPixels(c)-h;g=g.concat(a.renderer.crispLine([["M",0,l],["L",k,l]],e.lineWidth))});d?d.animate({d:g}):d=this.zoneLinesSVG=f.path(g).attr({"stroke-width":e.lineWidth,stroke:e.color,dashstyle:e.dashStyle,zIndex:this.group.zIndex+.1}).add(this.group)};g.defaultOptions=v(q.defaultOptions,{params:{ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,styles:{color:"#0A9AC9",
dashStyle:"LongDash",lineWidth:1}},volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",negativeColor:"rgba(244, 91, 91, 0.8)"}},animationLimit:1E3,enableMouseTracking:!1,pointPadding:0,zIndex:-1,crisp:!0,dataGrouping:{enabled:!1},dataLabels:{allowOverlap:!0,enabled:!0,format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",padding:0,style:{fontSize:"7px"},verticalAlign:"top"}});return g}(q);k(h.prototype,{nameBase:"Volume by Price",bindTo:{series:!1,eventName:"afterSetExtremes"},
calculateOn:"render",markerAttribs:d,drawGraph:d,getColumnMetrics:t.getColumnMetrics,crispCol:t.crispCol});g.registerSeriesType("vbp",h);"";return h});t(d,"Stock/Indicators/VWAP/VWAPIndicator.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){var g=this&&this.__extends||function(){var f=function(e,b){f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return f(e,b)};return function(e,
b){function a(){this.constructor=e}f(e,b);e.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),h=d.seriesTypes.sma,m=f.error,n=f.isArray,q=f.merge;f=function(f){function e(){var b=null!==f&&f.apply(this,arguments)||this;b.data=void 0;b.points=void 0;b.options=void 0;return b}g(e,f);e.prototype.getValues=function(b,a){var c=b.chart,e=b.xData;b=b.yData;var f=a.period,d=!0,g;if(g=c.get(a.volumeSeriesID))return n(b[0])||(d=!1),this.calculateVWAPValues(d,e,b,g,f);m("Series "+a.volumeSeriesID+
" not found! Check `volumeSeriesID`.",!0,c)};e.prototype.calculateVWAPValues=function(b,a,c,e,f){var d=e.yData,g=e.xData.length,k=a.length;e=[];var h=[],l=[],m=[],q=[],n;g=k<=g?k:g;for(n=k=0;k<g;k++){var y=b?(c[k][1]+c[k][2]+c[k][3])/3:c[k];y*=d[k];y=n?e[k-1]+y:y;var t=n?h[k-1]+d[k]:d[k];e.push(y);h.push(t);q.push([a[k],y/t]);l.push(q[k][0]);m.push(q[k][1]);n++;n===f&&(n=0)}return{values:q,xData:l,yData:m}};e.defaultOptions=q(h.defaultOptions,{params:{period:30,volumeSeriesID:"volume"}});return e}(h);
d.registerSeriesType("vwap",f);"";return f});t(d,"Stock/Indicators/WilliamsR/WilliamsRIndicator.js",[d["Mixins/ReduceArray.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f,g){var h=this&&this.__extends||function(){var e=function(b,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(b,a)};return function(b,a){function c(){this.constructor=b}e(b,a);b.prototype=null===
a?Object.create(a):(c.prototype=a.prototype,new c)}}(),m=d.getArrayExtremes,n=f.seriesTypes.sma;d=g.extend;var q=g.isArray,l=g.merge;g=function(e){function b(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}h(b,e);b.prototype.getValues=function(a,b){b=b.period;var c=a.xData,e=(a=a.yData)?a.length:0,f=[],d=[],g=[],h;if(!(c.length<b)&&q(a[0])&&4===a[0].length){for(h=b-1;h<e;h++){var l=a.slice(h-b+1,h+1);var p=m(l,2,1);l=p[0];p=p[1];var n=a[h][3];
l=(p-n)/(p-l)*-100;c[h]&&(f.push([c[h],l]),d.push(c[h]),g.push(l))}return{values:f,xData:d,yData:g}}};b.defaultOptions=l(n.defaultOptions,{params:{period:14}});return b}(n);d(g.prototype,{nameBase:"Williams %R"});f.registerSeriesType("williamsr",g);"";return g});t(d,"Stock/Indicators/WMA/WMAIndicator.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){function g(e,b){b*=(b+1)/2;return e.reduce(function(a,b,e){return[null,a[1]+b[1]*(e+1)]})[1]/b}function h(e,b,a,c){a=g(e,
e.length);b=b[c-1];e.shift();return[b,a]}var m=this&&this.__extends||function(){var e=function(b,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(b,a)};return function(b,a){function c(){this.constructor=b}e(b,a);b.prototype=null===a?Object.create(a):(c.prototype=a.prototype,new c)}}(),n=d.seriesTypes.sma,q=f.isArray,l=f.merge;f=function(e){function b(){var a=null!==e&&e.apply(this,arguments)||
this;a.data=void 0;a.options=void 0;a.points=void 0;return a}m(b,e);b.prototype.getValues=function(a,b){var c=b.period,e=a.xData,f=(a=a.yData)?a.length:0,d=1,g=e[0],l=a[0],m=[],p=[],n=[],r=-1;if(!(e.length<c)){q(a[0])&&(r=b.index,l=a[0][r]);for(b=[[g,l]];d!==c;)b.push([e[d],0>r?a[d]:a[d][r]]),d++;for(c=d;c<f;c++)d=h(b,e,a,c),m.push(d),p.push(d[0]),n.push(d[1]),b.push([e[c],0>r?a[c]:a[c][r]]);d=h(b,e,a,c);m.push(d);p.push(d[0]);n.push(d[1]);return{values:m,xData:p,yData:n}}};b.defaultOptions=l(n.defaultOptions,
{params:{index:3,period:9}});return b}(n);d.registerSeriesType("wma",f);"";return f});t(d,"Stock/Indicators/Zigzag/ZigzagIndicator.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){var g=this&&this.__extends||function(){var d=function(f,e){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,a){b.__proto__=a}||function(b,a){for(var c in a)a.hasOwnProperty(c)&&(b[c]=a[c])};return d(f,e)};return function(f,e){function b(){this.constructor=f}d(f,e);f.prototype=
null===e?Object.create(e):(b.prototype=e.prototype,new b)}}(),h=d.seriesTypes.sma,m=f.merge;f=f.extend;var n=function(d){function f(){var e=null!==d&&d.apply(this,arguments)||this;e.data=void 0;e.points=void 0;e.options=void 0;return e}g(f,d);f.prototype.getValues=function(e,b){var a=b.lowIndex,c=b.highIndex,d=b.deviation/100;b=1+d;var f=1-d;d=e.xData;var g=e.yData;e=g?g.length:0;var h=[],l=[],m=[],n,p,q=!1,r=!1;if(!(!d||1>=d.length||e&&("undefined"===typeof g[0][a]||"undefined"===typeof g[0][c]))){var t=
g[0][a];var z=g[0][c];for(n=1;n<e;n++){if(g[n][a]<=z*f){h.push([d[0],z]);var B=[d[n],g[n][a]];q=p=!0}else g[n][c]>=t*b&&(h.push([d[0],t]),B=[d[n],g[n][c]],p=!1,q=!0);if(q){l.push(h[0][0]);m.push(h[0][1]);var x=n++;n=e}}for(n=x;n<e;n++)p?(g[n][a]<=B[1]&&(B=[d[n],g[n][a]]),g[n][c]>=B[1]*b&&(r=c)):(g[n][c]>=B[1]&&(B=[d[n],g[n][c]]),g[n][a]<=B[1]*f&&(r=a)),!1!==r&&(h.push(B),l.push(B[0]),m.push(B[1]),B=[d[n],g[n][r]],p=!p,r=!1);a=h.length;0!==a&&h[a-1][0]<d[e-1]&&(h.push(B),l.push(B[0]),m.push(B[1]));
return{values:h,xData:l,yData:m}}};f.defaultOptions=m(h.defaultOptions,{params:{lowIndex:2,highIndex:1,deviation:1}});return f}(h);f(n.prototype,{nameComponents:["deviation"],nameSuffixes:["%"],nameBase:"Zig Zag"});d.registerSeriesType("zigzag",n);"";return n});t(d,"Stock/Indicators/LinearRegression/LinearRegression.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){var g=this&&this.__extends||function(){var d=function(e,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(e,b)};return function(e,b){function a(){this.constructor=e}d(e,b);e.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),h=d.seriesTypes.sma,m=f.isArray,n=f.extend,q=f.merge;f=function(d){function e(){var b=null!==d&&d.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}g(e,d);e.prototype.getRegressionLineParameters=function(b,a){var c=this.options.params.index,
e=function(a,b){return m(a)?a[b]:a},d=b.reduce(function(a,b){return b+a},0),f=a.reduce(function(a,b){return e(b,c)+a},0);d/=b.length;f/=a.length;var g=0,h=0,l;for(l=0;l<b.length;l++){var n=b[l]-d;var p=e(a[l],c)-f;g+=n*p;h+=Math.pow(n,2)}b=h?g/h:0;return{slope:b,intercept:f-b*d}};e.prototype.getEndPointY=function(b,a){return b.slope*a+b.intercept};e.prototype.transformXData=function(b,a){var c=b[0];return b.map(function(b){return(b-c)/a})};e.prototype.findClosestDistance=function(b){var a,c;for(c=
1;c<b.length-1;c++){var e=b[c]-b[c-1];0<e&&("undefined"===typeof a||e<a)&&(a=e)}return a};e.prototype.getValues=function(b,a){var c=b.xData;b=b.yData;a=a.period;var e,d={xData:[],yData:[],values:[]},f=this.options.params.xAxisUnit||this.findClosestDistance(c);for(e=a-1;e<=c.length-1;e++){var g=e-a+1;var h=e+1;var l=c[e];var m=c.slice(g,h);g=b.slice(g,h);h=this.transformXData(m,f);m=this.getRegressionLineParameters(h,g);g=this.getEndPointY(m,h[h.length-1]);d.values.push({regressionLineParameters:m,
x:l,y:g});d.xData.push(l);d.yData.push(g)}return d};e.defaultOptions=q(h.defaultOptions,{params:{xAxisUnit:void 0},tooltip:{valueDecimals:4}});return e}(h);n(f.prototype,{nameBase:"Linear Regression Indicator"});d.registerSeriesType("linearRegression",f);"";return f});t(d,"Stock/Indicators/LinearRegressionSlopes/LinearRegressionSlopes.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){var g=this&&this.__extends||function(){var d=function(f,e){d=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(b,a){b.__proto__=a}||function(b,a){for(var c in a)a.hasOwnProperty(c)&&(b[c]=a[c])};return d(f,e)};return function(f,e){function b(){this.constructor=f}d(f,e);f.prototype=null===e?Object.create(e):(b.prototype=e.prototype,new b)}}(),h=d.seriesTypes.linearRegression,m=f.extend,n=f.merge;f=function(d){function f(){var e=null!==d&&d.apply(this,arguments)||this;e.data=void 0;e.options=void 0;e.points=void 0;return e}g(f,d);f.prototype.getEndPointY=function(e){return e.slope};f.defaultOptions=
n(h.defaultOptions);return f}(h);m(f.prototype,{nameBase:"Linear Regression Slope Indicator"});d.registerSeriesType("linearRegressionSlope",f);"";return f});t(d,"Stock/Indicators/LinearRegressionIntercept/LinearRegressionIntercept.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){var g=this&&this.__extends||function(){var d=function(f,e){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,a){b.__proto__=a}||function(b,a){for(var c in a)a.hasOwnProperty(c)&&
(b[c]=a[c])};return d(f,e)};return function(f,e){function b(){this.constructor=f}d(f,e);f.prototype=null===e?Object.create(e):(b.prototype=e.prototype,new b)}}(),h=d.seriesTypes.linearRegression,m=f.extend,n=f.merge;f=function(d){function f(){var e=null!==d&&d.apply(this,arguments)||this;e.data=void 0;e.options=void 0;e.points=void 0;return e}g(f,d);f.prototype.getEndPointY=function(e){return e.intercept};f.defaultOptions=n(h.defaultOptions);return f}(h);m(f.prototype,{nameBase:"Linear Regression Intercept Indicator"});
d.registerSeriesType("linearRegressionIntercept",f);"";return f});t(d,"Stock/Indicators/LinearRegressionAngle/LinearRegressionAngle.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){var g=this&&this.__extends||function(){var d=function(e,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(e,b)};return function(e,b){function a(){this.constructor=e}d(e,b);e.prototype=
null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),h=d.seriesTypes,m=h.sma,n=f.extend,q=f.merge;f=function(d){function e(){var b=null!==d&&d.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}g(e,d);e.prototype.slopeToAngle=function(b){return 180/Math.PI*Math.atan(b)};e.prototype.getEndPointY=function(b){return this.slopeToAngle(b.slope)};e.defaultOptions=q(m.defaultOptions,{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span>{series.name}: <b>{point.y}\u00b0</b><br/>'}});
return e}(h.linearRegression);n(f.prototype,{nameBase:"Linear Regression Angle Indicator"});d.registerSeriesType("linearRegressionAngle",f);"";return f});t(d,"Stock/Indicators/ABands/ABandsIndicator.js",[d["Mixins/MultipleLines.js"],d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f,g){var h=this&&this.__extends||function(){var e=function(b,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&
(a[c]=b[c])};return e(b,a)};return function(b,a){function c(){this.constructor=b}e(b,a);b.prototype=null===a?Object.create(a):(c.prototype=a.prototype,new c)}}(),m=f.seriesTypes.sma,n=g.correctFloat,q=g.extend,l=g.merge;g=function(e){function b(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}h(b,e);b.prototype.getValues=function(a,b){var c=b.period,d=b.factor;b=b.index;var f=a.xData,g=(a=a.yData)?a.length:0,h=[],l=[],m=[],p=[],q=[],r;if(!(g<
c)){for(r=0;r<=g;r++){if(r<g){var t=a[r][2];var z=a[r][1];var B=d;t=n(z-t)/(n(z+t)/2)*1E3*B;h.push(a[r][1]*n(1+2*t));l.push(a[r][2]*n(1-2*t))}if(r>=c){t=f.slice(r-c,r);var x=a.slice(r-c,r);B=e.prototype.getValues.call(this,{xData:t,yData:h.slice(r-c,r)},{period:c});z=e.prototype.getValues.call(this,{xData:t,yData:l.slice(r-c,r)},{period:c});x=e.prototype.getValues.call(this,{xData:t,yData:x},{period:c,index:b});t=x.xData[0];B=B.yData[0];z=z.yData[0];x=x.yData[0];m.push([t,B,x,z]);p.push(t);q.push([B,
x,z])}}return{values:m,xData:p,yData:q}}};b.defaultOptions=l(m.defaultOptions,{params:{period:20,factor:.001,index:3},lineWidth:1,topLine:{styles:{lineWidth:1}},bottomLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}});return b}(m);q(g.prototype,{drawGraph:d.drawGraph,getTranslatedLinesNames:d.getTranslatedLinesNames,linesApiNames:["topLine","bottomLine"],nameBase:"Acceleration Bands",nameComponents:["period","factor"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle",
toYData:d.toYData,translate:d.translate});f.registerSeriesType("abands",g);"";return g});t(d,"Stock/Indicators/TrendLine/TrendLineIndicator.js",[d["Core/Series/SeriesRegistry.js"],d["Core/Utilities.js"]],function(d,f){var g=this&&this.__extends||function(){var d=function(e,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(e,b)};return function(e,b){function a(){this.constructor=e}d(e,b);
e.prototype=null===b?Object.create(b):(a.prototype=b.prototype,new a)}}(),h=d.seriesTypes.sma,m=f.extend,n=f.merge,q=f.isArray;f=function(d){function e(){var b=null!==d&&d.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}g(e,d);e.prototype.getValues=function(b,a){var c=b.xData,d=b.yData;b=[];var e=[],f=[],g=0,h=0,l=0,m=0,n=c.length,t=a.index;for(a=0;a<n;a++){var r=c[a];var z=q(d[a])?d[a][t]:d[a];g+=r;h+=z;l+=r*z;m+=r*r}d=(n*l-g*h)/(n*m-g*g);isNaN(d)&&(d=0);g=(h-
d*g)/n;for(a=0;a<n;a++)r=c[a],z=d*r+g,b[a]=[r,z],e[a]=r,f[a]=z;return{xData:e,yData:f,values:b}};e.defaultOptions=n(h.defaultOptions,{params:{index:3}});return e}(h);m(f.prototype,{nameBase:"Trendline",nameComponents:!1});d.registerSeriesType("trendline",f);"";return f});t(d,"masters/indicators/indicators-all.src.js",[],function(){})});
//# sourceMappingURL=indicators-all.js.map