/*
 Highstock JS v9.0.1 (2021-02-15)

 Indicator series type for Highstock

 (c) 2010-2021 Pawe Dalek

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/indicators/volume-by-price",["highcharts","highcharts/modules/stock"],function(n){a(n);a.Highcharts=n;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function n(a,n,q,l){a.hasOwnProperty(n)||(a[n]=l.apply(null,q))}a=a?a._modules:{};n(a,"Stock/Indicators/VBP/VBPIndicator.js",[a["Core/Animation/AnimationUtilities.js"],a["Core/Globals.js"],
a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,n,q,l){var E=this&&this.__extends||function(){var a=function(e,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,g){b.__proto__=g}||function(b,g){for(var d in g)g.hasOwnProperty(d)&&(b[d]=g[d])};return a(e,b)};return function(e,b){function c(){this.constructor=e}a(e,b);e.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),F=a.animObject;a=n.noop;var A=q.seriesTypes.sma,B=l.addEvent,C=l.arrayMax,
G=l.arrayMin,y=l.correctFloat,z=l.error,D=l.extend,H=l.isArray,I=l.merge,u=Math.abs,x=q.seriesTypes.column.prototype;l=function(a){function e(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.negWidths=void 0;b.options=void 0;b.points=void 0;b.posWidths=void 0;b.priceZones=void 0;b.rangeStep=void 0;b.volumeDataArray=void 0;b.zoneStarts=void 0;b.zoneLinesSVG=void 0;return b}E(e,a);e.prototype.init=function(b){n.seriesTypes.sma.prototype.init.apply(this,arguments);var c=this.options.params;
var g=this.linkedParent;c=b.get(c.volumeSeriesID);this.addCustomEvents(g,c);return this};e.prototype.addCustomEvents=function(b,c){function g(){d.chart.redraw();d.setData([]);d.zoneStarts=[];d.zoneLinesSVG&&(d.zoneLinesSVG.destroy(),delete d.zoneLinesSVG)}var d=this;d.dataEventsToUnbind.push(B(b,"remove",function(){g()}));c&&d.dataEventsToUnbind.push(B(c,"remove",function(){g()}));return d};e.prototype.animate=function(b){var c=this,g=c.chart.inverted,d=c.group,a={};!b&&d&&(b=g?"translateY":"translateX",
g=g?c.yAxis.top:c.xAxis.left,d["forceAnimate:"+b]=!0,a[b]=g,d.animate(a,D(F(c.options.animation),{step:function(b,d){c.group.attr({scaleX:Math.max(.001,d.pos)})}})))};e.prototype.drawPoints=function(){this.options.volumeDivision.enabled&&(this.posNegVolume(!0,!0),x.drawPoints.apply(this,arguments),this.posNegVolume(!1,!1));x.drawPoints.apply(this,arguments)};e.prototype.posNegVolume=function(b,c){var g=c?["positive","negative"]:["negative","positive"],d=this.options.volumeDivision,a=this.points.length,
r=[],f=[],k=0,m;b?(this.posWidths=r,this.negWidths=f):(r=this.posWidths,f=this.negWidths);for(;k<a;k++){var h=this.points[k];h[g[0]+"Graphic"]=h.graphic;h.graphic=h[g[1]+"Graphic"];if(b){var e=h.shapeArgs.width;var v=this.priceZones[k];(m=v.wholeVolumeData)?(r.push(e/m*v.positiveVolumeData),f.push(e/m*v.negativeVolumeData)):(r.push(0),f.push(0))}h.color=c?d.styles.positiveColor:d.styles.negativeColor;h.shapeArgs.width=c?this.posWidths[k]:this.negWidths[k];h.shapeArgs.x=c?h.shapeArgs.x:this.posWidths[k]}};
e.prototype.translate=function(){var b=this,c=b.options,g=b.chart,d=b.yAxis,a=d.min,r=b.options.zoneLines,f=b.priceZones,k=0,m,h,e;x.translate.apply(b);var v=b.points;if(v.length){var l=.5>c.pointPadding?c.pointPadding:.1;c=b.volumeDataArray;var n=C(c);var p=g.plotWidth/2;var J=g.plotTop;var w=u(d.toPixels(a)-d.toPixels(a+b.rangeStep));var q=u(d.toPixels(a)-d.toPixels(a+b.rangeStep));l&&(a=u(w*(1-2*l)),k=u((w-a)/2),w=u(a));v.forEach(function(a,c){h=a.barX=a.plotX=0;e=a.plotY=d.toPixels(f[c].start)-
J-(d.reversed?w-q:w)-k;m=y(p*f[c].wholeVolumeData/n);a.pointWidth=m;a.shapeArgs=b.crispCol.apply(b,[h,e,m,w]);a.volumeNeg=f[c].negativeVolumeData;a.volumePos=f[c].positiveVolumeData;a.volumeAll=f[c].wholeVolumeData});r.enabled&&b.drawZones(g,d,b.zoneStarts,r.styles)}};e.prototype.getValues=function(b,a){var c=b.processedXData,d=b.processedYData,e=this.chart,r=a.ranges,f=[],k=[],m=[],h;if(b.chart)if(h=e.get(a.volumeSeriesID))if((a=H(d[0]))&&4!==d[0].length)z("Type of "+b.name+" series is different than line, OHLC or candlestick.",
!0,e);else return(this.priceZones=this.specifyZones(a,c,d,r,h)).forEach(function(b,a){f.push([b.x,b.end]);k.push(f[a][0]);m.push(f[a][1])}),{values:f,xData:k,yData:m};else z("Series "+a.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,e);else z("Base series not found! In case it has been removed, add a new one.",!0,e)};e.prototype.specifyZones=function(b,a,g,d,e){if(b){var c=g.length;for(var f=g[0][3],k=f,m=1,h;m<c;m++)h=g[m][3],h<f&&(f=h),h>k&&(k=h);c={min:f,max:k}}else c=!1;c=(f=c)?f.min:
G(g);h=f?f.max:C(g);f=this.zoneStarts=[];k=[];var l=0;m=1;if(!c||!h)return this.points.length&&(this.setData([]),this.zoneStarts=[],this.zoneLinesSVG.destroy()),[];var n=this.rangeStep=y(h-c)/d;for(f.push(c);l<d-1;l++)f.push(y(f[l]+n));f.push(h);for(d=f.length;m<d;m++)k.push({index:m-1,x:a[0],start:f[m-1],end:f[m]});return this.volumePerZone(b,k,e,a,g)};e.prototype.volumePerZone=function(b,a,g,d,e){var c=this,f=g.processedXData,k=g.processedYData,m=a.length-1,h=e.length;g=k.length;var l,n,q,t,p;u(h-
g)&&(d[0]!==f[0]&&k.unshift(0),d[h-1]!==f[g-1]&&k.push(0));c.volumeDataArray=[];a.forEach(function(a){a.wholeVolumeData=0;a.positiveVolumeData=0;for(p=a.negativeVolumeData=0;p<h;p++)q=n=!1,t=b?e[p][3]:e[p],l=p?b?e[p-1][3]:e[p-1]:t,t<=a.start&&0===a.index&&(n=!0),t>=a.end&&a.index===m&&(q=!0),(t>a.start||n)&&(t<a.end||q)&&(a.wholeVolumeData+=k[p],l>t?a.negativeVolumeData+=k[p]:a.positiveVolumeData+=k[p]);c.volumeDataArray.push(a.wholeVolumeData)});return a};e.prototype.drawZones=function(a,c,e,d){var b=
a.renderer,g=this.zoneLinesSVG,f=[],k=a.plotWidth,l=a.plotTop,h;e.forEach(function(b){h=c.toPixels(b)-l;f=f.concat(a.renderer.crispLine([["M",0,h],["L",k,h]],d.lineWidth))});g?g.animate({d:f}):g=this.zoneLinesSVG=b.path(f).attr({"stroke-width":d.lineWidth,stroke:d.color,dashstyle:d.dashStyle,zIndex:this.group.zIndex+.1}).add(this.group)};e.defaultOptions=I(A.defaultOptions,{params:{ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,styles:{color:"#0A9AC9",dashStyle:"LongDash",lineWidth:1}},
volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",negativeColor:"rgba(244, 91, 91, 0.8)"}},animationLimit:1E3,enableMouseTracking:!1,pointPadding:0,zIndex:-1,crisp:!0,dataGrouping:{enabled:!1},dataLabels:{allowOverlap:!0,enabled:!0,format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",padding:0,style:{fontSize:"7px"},verticalAlign:"top"}});return e}(A);D(l.prototype,{nameBase:"Volume by Price",bindTo:{series:!1,eventName:"afterSetExtremes"},calculateOn:"render",markerAttribs:a,
drawGraph:a,getColumnMetrics:x.getColumnMetrics,crispCol:x.crispCol});q.registerSeriesType("vbp",l);"";return l});n(a,"masters/indicators/volume-by-price.src.js",[],function(){})});
//# sourceMappingURL=volume-by-price.js.map