/*
 Highmaps JS v9.0.1 (2021-02-15)

 Highmaps as a plugin for Highcharts or Highstock.

 (c) 2011-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/map",["highcharts"],function(x){a(x);a.Highcharts=x;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function x(a,l,n,p){a.hasOwnProperty(l)||(a[l]=p.apply(null,n))}a=a?a._modules:{};x(a,"Core/Axis/MapAxis.js",[a["Core/Axis/Axis.js"],a["Core/Utilities.js"]],function(a,l){var r=l.addEvent,p=l.pick,g=function(){return function(g){this.axis=
g}}();l=function(){function a(){}a.compose=function(f){f.keepProps.push("mapAxis");r(f,"init",function(){this.mapAxis||(this.mapAxis=new g(this))});r(f,"getSeriesExtremes",function(){if(this.mapAxis){var e=[];this.isXAxis&&(this.series.forEach(function(c,b){c.useMapGeometry&&(e[b]=c.xData,c.xData=[])}),this.mapAxis.seriesXData=e)}});r(f,"afterGetSeriesExtremes",function(){if(this.mapAxis){var e=this.mapAxis.seriesXData||[],c;if(this.isXAxis){var b=p(this.dataMin,Number.MAX_VALUE);var d=p(this.dataMax,
-Number.MAX_VALUE);this.series.forEach(function(f,g){f.useMapGeometry&&(b=Math.min(b,p(f.minX,b)),d=Math.max(d,p(f.maxX,d)),f.xData=e[g],c=!0)});c&&(this.dataMin=b,this.dataMax=d);this.mapAxis.seriesXData=void 0}}});r(f,"afterSetAxisTranslation",function(){if(this.mapAxis){var e=this.chart,c=e.plotWidth/e.plotHeight;e=e.xAxis[0];var b;"yAxis"===this.coll&&"undefined"!==typeof e.transA&&this.series.forEach(function(d){d.preserveAspectRatio&&(b=!0)});if(b&&(this.transA=e.transA=Math.min(this.transA,
e.transA),c/=(e.max-e.min)/(this.max-this.min),c=1>c?this:e,e=(c.max-c.min)*c.transA,c.mapAxis.pixelPadding=c.len-e,c.minPixelPadding=c.mapAxis.pixelPadding/2,e=c.mapAxis.fixTo)){e=e[1]-c.toValue(e[0],!0);e*=c.transA;if(Math.abs(e)>c.minPixelPadding||c.min===c.dataMin&&c.max===c.dataMax)e=0;c.minPixelPadding-=e}}});r(f,"render",function(){this.mapAxis&&(this.mapAxis.fixTo=void 0)})};return a}();l.compose(a);return l});x(a,"Mixins/ColorSeries.js",[],function(){return{colorPointMixin:{setVisible:function(a){var l=
this,r=a?"show":"hide";l.visible=l.options.visible=!!a;["graphic","dataLabel"].forEach(function(a){if(l[a])l[a][r]()});this.series.buildKDTree()}},colorSeriesMixin:{optionalAxis:"colorAxis",colorAxis:0,translateColors:function(){var a=this,l=this.options.nullColor,n=this.colorAxis,p=this.colorKey;(this.data.length?this.data:this.points).forEach(function(g){var k=g.getNestedProperty(p);(k=g.options.color||(g.isNull||null===g.value?l:n&&"undefined"!==typeof k?n.toColor(k,g):g.color||a.color))&&g.color!==
k&&(g.color=k,"point"===a.options.legendType&&g.legendItem&&a.chart.legend.colorizeItem(g,g.visible))})}}}});x(a,"Core/Axis/ColorAxis.js",[a["Core/Axis/Axis.js"],a["Core/Chart/Chart.js"],a["Core/Color/Color.js"],a["Mixins/ColorSeries.js"],a["Core/Animation/Fx.js"],a["Core/Globals.js"],a["Core/Legend.js"],a["Mixins/LegendSymbol.js"],a["Core/Color/Palette.js"],a["Core/Series/Point.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,l,n,p,g,k,f,e,c,b,d,m){var H=this&&this.__extends||function(){var b=
function(d,y){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(v,b){v.__proto__=b}||function(v,b){for(var d in b)b.hasOwnProperty(d)&&(v[d]=b[d])};return b(d,y)};return function(d,y){function v(){this.constructor=d}b(d,y);d.prototype=null===y?Object.create(y):(v.prototype=y.prototype,new v)}}(),E=n.parse;n=p.colorPointMixin;p=p.colorSeriesMixin;var r=k.noop,A=m.addEvent,B=m.erase,C=m.extend,D=m.isNumber,t=m.merge,u=m.pick,h=m.splat;"";C(d.prototype,p);C(b.prototype,n);l.prototype.collectionsWithUpdate.push("colorAxis");
l.prototype.collectionsWithInit.colorAxis=[l.prototype.addColorAxis];var q=function(b){function h(d,v){var h=b.call(this,d,v)||this;h.beforePadding=!1;h.chart=void 0;h.coll="colorAxis";h.dataClasses=void 0;h.legendItem=void 0;h.legendItems=void 0;h.name="";h.options=void 0;h.stops=void 0;h.visible=!0;h.init(d,v);return h}H(h,b);h.prototype.init=function(d,v){var y=d.options.legend||{},c=v.layout?"vertical"!==v.layout:"vertical"!==y.layout;y=t(h.defaultOptions,v,{showEmpty:!1,title:null,visible:y.enabled&&
(v?!1!==v.visible:!0)});this.coll="colorAxis";this.side=v.side||c?2:1;this.reversed=v.reversed||!c;this.opposite=!c;d.options[this.coll]=y;b.prototype.init.call(this,d,y);v.dataClasses&&this.initDataClasses(v);this.initStops();this.horiz=c;this.zoomEnabled=!1};h.prototype.initDataClasses=function(b){var v=this.chart,h,d=0,y=v.options.chart.colorCount,c=this.options,u=b.dataClasses.length;this.dataClasses=h=[];this.legendItems=[];b.dataClasses.forEach(function(b,G){b=t(b);h.push(b);if(v.styledMode||
!b.color)"category"===c.dataClassColor?(v.styledMode||(G=v.options.colors,y=G.length,b.color=G[d]),b.colorIndex=d,d++,d===y&&(d=0)):b.color=E(c.minColor).tweenTo(E(c.maxColor),2>u?.5:G/(u-1))})};h.prototype.hasData=function(){return!!(this.tickPositions||[]).length};h.prototype.setTickPositions=function(){if(!this.dataClasses)return b.prototype.setTickPositions.call(this)};h.prototype.initStops=function(){this.stops=this.options.stops||[[0,this.options.minColor],[1,this.options.maxColor]];this.stops.forEach(function(b){b.color=
E(b[1])})};h.prototype.setOptions=function(h){b.prototype.setOptions.call(this,h);this.options.crosshair=this.options.marker};h.prototype.setAxisSize=function(){var b=this.legendSymbol,v=this.chart,d=v.options.legend||{},c,u;b?(this.left=d=b.attr("x"),this.top=c=b.attr("y"),this.width=u=b.attr("width"),this.height=b=b.attr("height"),this.right=v.chartWidth-d-u,this.bottom=v.chartHeight-c-b,this.len=this.horiz?u:b,this.pos=this.horiz?d:c):this.len=(this.horiz?d.symbolWidth:d.symbolHeight)||h.defaultLegendLength};
h.prototype.normalizedValue=function(b){this.logarithmic&&(b=this.logarithmic.log2lin(b));return 1-(this.max-b)/(this.max-this.min||1)};h.prototype.toColor=function(b,v){var d=this.dataClasses,h=this.stops,c;if(d)for(c=d.length;c--;){var u=d[c];var y=u.from;h=u.to;if(("undefined"===typeof y||b>=y)&&("undefined"===typeof h||b<=h)){var e=u.color;v&&(v.dataClass=c,v.colorIndex=u.colorIndex);break}}else{b=this.normalizedValue(b);for(c=h.length;c--&&!(b>h[c][0]););y=h[c]||h[c+1];h=h[c+1]||y;b=1-(h[0]-
b)/(h[0]-y[0]||1);e=y.color.tweenTo(h.color,b)}return e};h.prototype.getOffset=function(){var h=this.legendGroup,d=this.chart.axisOffset[this.side];h&&(this.axisParent=h,b.prototype.getOffset.call(this),this.added||(this.added=!0,this.labelLeft=0,this.labelRight=this.width),this.chart.axisOffset[this.side]=d)};h.prototype.setLegendColor=function(){var b=this.reversed,h=b?1:0;b=b?0:1;h=this.horiz?[h,0,b,0]:[0,b,0,h];this.legendColor={linearGradient:{x1:h[0],y1:h[1],x2:h[2],y2:h[3]},stops:this.stops}};
h.prototype.drawLegendSymbol=function(b,d){var v=b.padding,c=b.options,e=this.horiz,y=u(c.symbolWidth,e?h.defaultLegendLength:12),q=u(c.symbolHeight,e?12:h.defaultLegendLength),a=u(c.labelPadding,e?16:30);c=u(c.itemDistance,10);this.setLegendColor();d.legendSymbol=this.chart.renderer.rect(0,b.baseline-11,y,q).attr({zIndex:1}).add(d.legendGroup);this.legendItemWidth=y+v+(e?c:a);this.legendItemHeight=q+v+(e?a:0)};h.prototype.setState=function(b){this.series.forEach(function(h){h.setState(b)})};h.prototype.setVisible=
function(){};h.prototype.getSeriesExtremes=function(){var b=this.series,h=b.length,c;this.dataMin=Infinity;for(this.dataMax=-Infinity;h--;){var e=b[h];var q=e.colorKey=u(e.options.colorKey,e.colorKey,e.pointValKey,e.zoneAxis,"y");var a=e.pointArrayMap;var f=e[q+"Min"]&&e[q+"Max"];if(e[q+"Data"])var t=e[q+"Data"];else if(a){t=[];a=a.indexOf(q);var w=e.yData;if(0<=a&&w)for(c=0;c<w.length;c++)t.push(u(w[c][a],w[c]))}else t=e.yData;f?(e.minColorValue=e[q+"Min"],e.maxColorValue=e[q+"Max"]):(t=d.prototype.getExtremes.call(e,
t),e.minColorValue=t.dataMin,e.maxColorValue=t.dataMax);"undefined"!==typeof e.minColorValue&&(this.dataMin=Math.min(this.dataMin,e.minColorValue),this.dataMax=Math.max(this.dataMax,e.maxColorValue));f||d.prototype.applyExtremes.call(e)}};h.prototype.drawCrosshair=function(h,d){var v=d&&d.plotX,c=d&&d.plotY,e=this.pos,u=this.len;if(d){var q=this.toPixels(d.getNestedProperty(d.series.colorKey));q<e?q=e-2:q>e+u&&(q=e+u+2);d.plotX=q;d.plotY=this.len-q;b.prototype.drawCrosshair.call(this,h,d);d.plotX=
v;d.plotY=c;this.cross&&!this.cross.addedToColorAxis&&this.legendGroup&&(this.cross.addClass("highcharts-coloraxis-marker").add(this.legendGroup),this.cross.addedToColorAxis=!0,!this.chart.styledMode&&this.crosshair&&this.cross.attr({fill:this.crosshair.color}))}};h.prototype.getPlotLinePath=function(h){var d=this.left,c=h.translatedValue,e=this.top;return D(c)?this.horiz?[["M",c-4,e-6],["L",c+4,e-6],["L",c,e],["Z"]]:[["M",d,c],["L",d-6,c+6],["L",d-6,c-6],["Z"]]:b.prototype.getPlotLinePath.call(this,
h)};h.prototype.update=function(h,d){var c=this.chart.legend;this.series.forEach(function(b){b.isDirtyData=!0});(h.dataClasses&&c.allItems||this.dataClasses)&&this.destroyItems();b.prototype.update.call(this,h,d);this.legendItem&&(this.setLegendColor(),c.colorizeItem(this,!0))};h.prototype.destroyItems=function(){var b=this.chart;this.legendItem?b.legend.destroyItem(this):this.legendItems&&this.legendItems.forEach(function(h){b.legend.destroyItem(h)});b.isDirtyLegend=!0};h.prototype.destroy=function(){this.chart.isDirtyLegend=
!0;this.destroyItems();b.prototype.destroy.apply(this,[].slice.call(arguments))};h.prototype.remove=function(h){this.destroyItems();b.prototype.remove.call(this,h)};h.prototype.getDataClassLegendSymbols=function(){var b=this,h=b.chart,d=b.legendItems,c=h.options.legend,u=c.valueDecimals,q=c.valueSuffix||"",a;d.length||b.dataClasses.forEach(function(c,v){var t=!0,f=c.from,w=c.to,g=h.numberFormatter;a="";"undefined"===typeof f?a="< ":"undefined"===typeof w&&(a="> ");"undefined"!==typeof f&&(a+=g(f,
u)+q);"undefined"!==typeof f&&"undefined"!==typeof w&&(a+=" - ");"undefined"!==typeof w&&(a+=g(w,u)+q);d.push(C({chart:h,name:a,options:{},drawLegendSymbol:e.drawRectangle,visible:!0,setState:r,isDataClass:!0,setVisible:function(){t=b.visible=!t;b.series.forEach(function(b){b.points.forEach(function(b){b.dataClass===v&&b.setVisible(t)})});h.legend.colorizeItem(this,t)}},c))});return d};h.defaultLegendLength=200;h.defaultOptions={lineWidth:0,minPadding:0,maxPadding:0,gridLineWidth:1,tickPixelInterval:72,
startOnTick:!0,endOnTick:!0,offset:0,marker:{animation:{duration:50},width:.01,color:c.neutralColor40},labels:{overflow:"justify",rotation:0},minColor:c.highlightColor10,maxColor:c.highlightColor100,tickLength:5,showInLegend:!0};h.keepProps=["legendGroup","legendItemHeight","legendItemWidth","legendItem","legendSymbol"];return h}(a);Array.prototype.push.apply(a.keepProps,q.keepProps);k.ColorAxis=q;["fill","stroke"].forEach(function(b){g.prototype[b+"Setter"]=function(){this.elem.attr(b,E(this.start).tweenTo(E(this.end),
this.pos),null,!0)}});A(l,"afterGetAxes",function(){var b=this,d=b.options;this.colorAxis=[];d.colorAxis&&(d.colorAxis=h(d.colorAxis),d.colorAxis.forEach(function(h,d){h.index=d;new q(b,h)}))});A(d,"bindAxes",function(){var b=this.axisTypes;b?-1===b.indexOf("colorAxis")&&b.push("colorAxis"):this.axisTypes=["colorAxis"]});A(f,"afterGetAllItems",function(b){var h=[],d,c;(this.chart.colorAxis||[]).forEach(function(c){(d=c.options)&&d.showInLegend&&(d.dataClasses&&d.visible?h=h.concat(c.getDataClassLegendSymbols()):
d.visible&&h.push(c),c.series.forEach(function(h){if(!h.options.showInLegend||d.dataClasses)"point"===h.options.legendType?h.points.forEach(function(h){B(b.allItems,h)}):B(b.allItems,h)}))});for(c=h.length;c--;)b.allItems.unshift(h[c])});A(f,"afterColorizeItem",function(b){b.visible&&b.item.legendColor&&b.item.legendSymbol.attr({fill:b.item.legendColor})});A(f,"afterUpdate",function(){var b=this.chart.colorAxis;b&&b.forEach(function(b,h,d){b.update({},d)})});A(d,"afterTranslate",function(){(this.chart.colorAxis&&
this.chart.colorAxis.length||this.colorAttribs)&&this.translateColors()});return q});x(a,"Mixins/ColorMapSeries.js",[a["Core/Globals.js"],a["Core/Series/Point.js"],a["Core/Utilities.js"]],function(a,l,n){var r=n.defined;return{colorMapPointMixin:{dataLabelOnNull:!0,isValid:function(){return null!==this.value&&Infinity!==this.value&&-Infinity!==this.value},setState:function(a){l.prototype.setState.call(this,a);this.graphic&&this.graphic.attr({zIndex:"hover"===a?1:0})}},colorMapSeriesMixin:{pointArrayMap:["value"],
axisTypes:["xAxis","yAxis","colorAxis"],trackerGroups:["group","markerGroup","dataLabelsGroup"],getSymbol:a.noop,parallelArrays:["x","y","value"],colorKey:"value",pointAttribs:a.seriesTypes.column.prototype.pointAttribs,colorAttribs:function(a){var g={};r(a.color)&&(g[this.colorProp||"fill"]=a.color);return g}}}});x(a,"Maps/MapNavigationOptionsDefault.js",[a["Core/Options.js"],a["Core/Utilities.js"]],function(a,l){l=l.extend;var r={buttonOptions:{alignTo:"plotBox",align:"left",verticalAlign:"top",
x:0,width:18,height:18,padding:5,style:{fontSize:"15px",fontWeight:"bold"},theme:{"stroke-width":1,"text-align":"center"}},buttons:{zoomIn:{onclick:function(){this.mapZoom(.5)},text:"+",y:0},zoomOut:{onclick:function(){this.mapZoom(2)},text:"-",y:28}},mouseWheelSensitivity:1.1};l(a.defaultOptions.lang,{zoomIn:"Zoom in",zoomOut:"Zoom out"});return a.defaultOptions.mapNavigation=r});x(a,"Maps/MapNavigation.js",[a["Core/Chart/Chart.js"],a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,l,n){function r(b){b&&
(b.preventDefault&&b.preventDefault(),b.stopPropagation&&b.stopPropagation(),b.cancelBubble=!0)}function g(b){this.init(b)}var k=l.doc,f=n.addEvent,e=n.extend,c=n.merge,b=n.objectEach,d=n.pick;g.prototype.init=function(b){this.chart=b;b.mapNavButtons=[]};g.prototype.update=function(a){var g=this.chart,k=g.options.mapNavigation,m,l,n,p,D,t=function(b){this.handler.call(g,b);r(b)},u=g.mapNavButtons;a&&(k=g.options.mapNavigation=c(g.options.mapNavigation,a));for(;u.length;)u.pop().destroy();d(k.enableButtons,
k.enabled)&&!g.renderer.forExport&&b(k.buttons,function(b,d){m=c(k.buttonOptions,b);g.styledMode||(l=m.theme,l.style=c(m.theme.style,m.style),p=(n=l.states)&&n.hover,D=n&&n.select);b=g.renderer.button(m.text,0,0,t,l,p,D,0,"zoomIn"===d?"topbutton":"bottombutton").addClass("highcharts-map-navigation highcharts-"+{zoomIn:"zoom-in",zoomOut:"zoom-out"}[d]).attr({width:m.width,height:m.height,title:g.options.lang[d],padding:m.padding,zIndex:5}).add();b.handler=m.onclick;f(b.element,"dblclick",r);u.push(b);
var h=m,a=f(g,"load",function(){b.align(e(h,{width:b.width,height:2*b.height}),null,h.alignTo);a()})});this.updateEvents(k)};g.prototype.updateEvents=function(b){var c=this.chart;d(b.enableDoubleClickZoom,b.enabled)||b.enableDoubleClickZoomTo?this.unbindDblClick=this.unbindDblClick||f(c.container,"dblclick",function(b){c.pointer.onContainerDblClick(b)}):this.unbindDblClick&&(this.unbindDblClick=this.unbindDblClick());d(b.enableMouseWheelZoom,b.enabled)?this.unbindMouseWheel=this.unbindMouseWheel||
f(c.container,"undefined"===typeof k.onmousewheel?"DOMMouseScroll":"mousewheel",function(b){c.pointer.onContainerMouseWheel(b);r(b);return!1}):this.unbindMouseWheel&&(this.unbindMouseWheel=this.unbindMouseWheel())};e(a.prototype,{fitToBox:function(b,d){[["x","width"],["y","height"]].forEach(function(c){var e=c[0];c=c[1];b[e]+b[c]>d[e]+d[c]&&(b[c]>d[c]?(b[c]=d[c],b[e]=d[e]):b[e]=d[e]+d[c]-b[c]);b[c]>d[c]&&(b[c]=d[c]);b[e]<d[e]&&(b[e]=d[e])});return b},mapZoom:function(b,c,e,a,f){var g=this.xAxis[0],
k=g.max-g.min,m=d(c,g.min+k/2),t=k*b;k=this.yAxis[0];var u=k.max-k.min,h=d(e,k.min+u/2);u*=b;m=this.fitToBox({x:m-t*(a?(a-g.pos)/g.len:.5),y:h-u*(f?(f-k.pos)/k.len:.5),width:t,height:u},{x:g.dataMin,y:k.dataMin,width:g.dataMax-g.dataMin,height:k.dataMax-k.dataMin});t=m.x<=g.dataMin&&m.width>=g.dataMax-g.dataMin&&m.y<=k.dataMin&&m.height>=k.dataMax-k.dataMin;a&&g.mapAxis&&(g.mapAxis.fixTo=[a-g.pos,c]);f&&k.mapAxis&&(k.mapAxis.fixTo=[f-k.pos,e]);"undefined"===typeof b||t?(g.setExtremes(void 0,void 0,
!1),k.setExtremes(void 0,void 0,!1)):(g.setExtremes(m.x,m.x+m.width,!1),k.setExtremes(m.y,m.y+m.height,!1));this.redraw()}});f(a,"beforeRender",function(){this.mapNavigation=new g(this);this.mapNavigation.update()});l.MapNavigation=g});x(a,"Maps/MapPointer.js",[a["Core/Pointer.js"],a["Core/Utilities.js"]],function(a,l){var r=l.extend,p=l.pick;l=l.wrap;r(a.prototype,{onContainerDblClick:function(a){var g=this.chart;a=this.normalize(a);g.options.mapNavigation.enableDoubleClickZoomTo?g.pointer.inClass(a.target,
"highcharts-tracker")&&g.hoverPoint&&g.hoverPoint.zoomTo():g.isInsidePlot(a.chartX-g.plotLeft,a.chartY-g.plotTop)&&g.mapZoom(.5,g.xAxis[0].toValue(a.chartX),g.yAxis[0].toValue(a.chartY),a.chartX,a.chartY)},onContainerMouseWheel:function(a){var g=this.chart;a=this.normalize(a);var f=a.detail||-(a.wheelDelta/120);g.isInsidePlot(a.chartX-g.plotLeft,a.chartY-g.plotTop)&&g.mapZoom(Math.pow(g.options.mapNavigation.mouseWheelSensitivity,f),g.xAxis[0].toValue(a.chartX),g.yAxis[0].toValue(a.chartY),a.chartX,
a.chartY)}});l(a.prototype,"zoomOption",function(a){var g=this.chart.options.mapNavigation;p(g.enableTouchZoom,g.enabled)&&(this.chart.options.chart.pinchType="xy");a.apply(this,[].slice.call(arguments,1))});l(a.prototype,"pinchTranslate",function(a,k,f,e,c,b,d){a.call(this,k,f,e,c,b,d);"map"===this.chart.options.chart.type&&this.hasZoom&&(a=e.scaleX>e.scaleY,this.pinchTranslateDirection(!a,k,f,e,c,b,d,a?e.scaleX:e.scaleY))})});x(a,"Maps/MapSymbols.js",[a["Core/Globals.js"],a["Core/Renderer/SVG/SVGRenderer.js"]],
function(a,l){function r(a,k,f,e,c,b,d,m){return[["M",a+c,k],["L",a+f-b,k],["C",a+f-b/2,k,a+f,k+b/2,a+f,k+b],["L",a+f,k+e-d],["C",a+f,k+e-d/2,a+f-d/2,k+e,a+f-d,k+e],["L",a+m,k+e],["C",a+m/2,k+e,a,k+e-m/2,a,k+e-m],["L",a,k+c],["C",a,k+c/2,a+c/2,k,a+c,k],["Z"]]}var p=a.Renderer;l.prototype.symbols.topbutton=function(a,k,f,e,c){c=c&&c.r||0;return r(a-1,k-1,f,e,c,c,0,0)};l.prototype.symbols.bottombutton=function(a,k,f,e,c){c=c&&c.r||0;return r(a-1,k-1,f,e,0,0,c,c)};p!==l&&["topbutton","bottombutton"].forEach(function(a){p.prototype.symbols[a]=
l.prototype.symbols[a]});return l.prototype.symbols});x(a,"Maps/Map.js",[a["Core/Chart/Chart.js"],a["Core/Globals.js"],a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Utilities.js"]],function(a,l,n,p){var g=p.getOptions,k=p.merge,f=p.pick,e;(function(c){c.maps={};c.mapChart=function(b,d,c){var e="string"===typeof b||b.nodeName,m=arguments[e?1:0],l=m,r={endOnTick:!1,visible:!1,minPadding:0,maxPadding:0,startOnTick:!1},n=g().credits;var p=m.series;m.series=null;m=k({chart:{panning:{enabled:!0,type:"xy"},
type:"map"},credits:{mapText:f(n.mapText,' \u00a9 <a href="{geojson.copyrightUrl}">{geojson.copyrightShort}</a>'),mapTextFull:f(n.mapTextFull,"{geojson.copyright}")},tooltip:{followTouchMove:!1},xAxis:r,yAxis:k(r,{reversed:!0})},m,{chart:{inverted:!1,alignTicks:!1}});m.series=l.series=p;return e?new a(b,m,c):new a(m,d)};c.splitPath=function(b){"string"===typeof b&&(b=b.replace(/([A-Za-z])/g," $1 ").replace(/^\s*/,"").replace(/\s*$/,""),b=b.split(/[ ,;]+/).map(function(b){return/[A-za-z]/.test(b)?
b:parseFloat(b)}));return n.prototype.pathToSegments(b)}})(e||(e={}));l.Map=e.mapChart;l.mapChart=e.mapChart;l.maps=e.maps;return e});x(a,"Series/Map/MapPoint.js",[a["Mixins/ColorMapSeries.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,l,n){var r=this&&this.__extends||function(){var a=function(f,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var d in b)b.hasOwnProperty(d)&&(a[d]=b[d])};return a(f,e)};return function(f,
e){function c(){this.constructor=f}a(f,e);f.prototype=null===e?Object.create(e):(c.prototype=e.prototype,new c)}}();a=a.colorMapPointMixin;var g=n.extend;l=function(a){function f(){var e=null!==a&&a.apply(this,arguments)||this;e.options=void 0;e.path=void 0;e.series=void 0;return e}r(f,a);f.prototype.applyOptions=function(e,c){var b=this.series;e=a.prototype.applyOptions.call(this,e,c);c=b.joinBy;b.mapData&&b.mapMap&&(c=a.prototype.getNestedProperty.call(e,c[1]),(c="undefined"!==typeof c&&b.mapMap[c])?
(b.xyFromShape&&(e.x=c._midX,e.y=c._midY),g(e,c)):e.value=e.value||null);return e};f.prototype.onMouseOver=function(e){n.clearTimeout(this.colorInterval);if(null!==this.value||this.series.options.nullInteraction)a.prototype.onMouseOver.call(this,e);else this.series.onMouseOut(e)};f.prototype.zoomTo=function(){var a=this.series;a.xAxis.setExtremes(this._minX,this._maxX,!1);a.yAxis.setExtremes(this._minY,this._maxY,!1);a.chart.redraw()};return f}(l.seriesTypes.scatter.prototype.pointClass);g(l.prototype,
{dataLabelOnNull:a.dataLabelOnNull,isValid:a.isValid,setState:a.setState});return l});x(a,"Series/Map/MapSeries.js",[a["Mixins/ColorMapSeries.js"],a["Core/Globals.js"],a["Mixins/LegendSymbol.js"],a["Maps/Map.js"],a["Series/Map/MapPoint.js"],a["Core/Color/Palette.js"],a["Core/Series/Series.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Utilities.js"]],function(a,l,n,p,g,k,f,e,c,b){var d=this&&this.__extends||function(){var b=function(d,a){b=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(b,d){b.__proto__=d}||function(b,d){for(var a in d)d.hasOwnProperty(a)&&(b[a]=d[a])};return b(d,a)};return function(d,a){function h(){this.constructor=d}b(d,a);d.prototype=null===a?Object.create(a):(h.prototype=a.prototype,new h)}}();a=a.colorMapSeriesMixin;var m=l.noop,r=p.maps,E=p.splitPath;p=e.seriesTypes;var z=p.column,A=p.scatter;p=b.extend;var B=b.fireEvent,C=b.getNestedProperty,D=b.isArray,t=b.isNumber,u=b.merge,h=b.objectEach,q=b.pick,w=b.splat;b=function(b){function a(){var a=
null!==b&&b.apply(this,arguments)||this;a.baseTrans=void 0;a.chart=void 0;a.data=void 0;a.group=void 0;a.joinBy=void 0;a.options=void 0;a.points=void 0;a.transformGroup=void 0;return a}d(a,b);a.prototype.animate=function(b){var a=this.options.animation,d=this.group,h=this.xAxis,c=this.yAxis,e=h.pos,u=c.pos;this.chart.renderer.isSVG&&(!0===a&&(a={duration:1E3}),b?d.attr({translateX:e+h.len/2,translateY:u+c.len/2,scaleX:.001,scaleY:.001}):d.animate({translateX:e,translateY:u,scaleX:1,scaleY:1},a))};
a.prototype.animateDrilldown=function(b){var a=this.chart.plotBox,d=this.chart.drilldownLevels[this.chart.drilldownLevels.length-1],h=d.bBox,c=this.chart.options.drilldown.animation;b||(b=Math.min(h.width/a.width,h.height/a.height),d.shapeArgs={scaleX:b,scaleY:b,translateX:h.x,translateY:h.y},this.points.forEach(function(b){b.graphic&&b.graphic.attr(d.shapeArgs).animate({scaleX:1,scaleY:1,translateX:0,translateY:0},c)}))};a.prototype.animateDrillupFrom=function(b){z.prototype.animateDrillupFrom.call(this,
b)};a.prototype.animateDrillupTo=function(b){z.prototype.animateDrillupTo.call(this,b)};a.prototype.doFullTranslate=function(){return this.isDirtyData||this.chart.isResizing||this.chart.renderer.isVML||!this.baseTrans};a.prototype.drawMapDataLabels=function(){f.prototype.drawDataLabels.call(this);this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)};a.prototype.drawPoints=function(){var b=this,a=b.xAxis,d=b.yAxis,h=b.group,c=b.chart,e=c.renderer,u=this.baseTrans;b.transformGroup||
(b.transformGroup=e.g().attr({scaleX:1,scaleY:1}).add(h),b.transformGroup.survive=!0);if(b.doFullTranslate())c.hasRendered&&!c.styledMode&&b.points.forEach(function(a){a.shapeArgs&&(a.shapeArgs.fill=b.pointAttribs(a,a.state).fill)}),b.group=b.transformGroup,z.prototype.drawPoints.apply(b),b.group=h,b.points.forEach(function(a){if(a.graphic){var d="";a.name&&(d+="highcharts-name-"+a.name.replace(/ /g,"-").toLowerCase());a.properties&&a.properties["hc-key"]&&(d+=" highcharts-key-"+a.properties["hc-key"].toLowerCase());
d&&a.graphic.addClass(d);c.styledMode&&a.graphic.css(b.pointAttribs(a,a.selected&&"select"||void 0))}}),this.baseTrans={originX:a.min-a.minPixelPadding/a.transA,originY:d.min-d.minPixelPadding/d.transA+(d.reversed?0:d.len/d.transA),transAX:a.transA,transAY:d.transA},this.transformGroup.animate({translateX:0,translateY:0,scaleX:1,scaleY:1});else{var f=a.transA/u.transAX;var t=d.transA/u.transAY;var g=a.toPixels(u.originX,!0);var m=d.toPixels(u.originY,!0);.99<f&&1.01>f&&.99<t&&1.01>t&&(t=f=1,g=Math.round(g),
m=Math.round(m));var w=this.transformGroup;if(c.renderer.globalAnimation){var k=w.attr("translateX");var l=w.attr("translateY");var F=w.attr("scaleX");var y=w.attr("scaleY");w.attr({animator:0}).animate({animator:1},{step:function(b,a){w.attr({translateX:k+(g-k)*a.pos,translateY:l+(m-l)*a.pos,scaleX:F+(f-F)*a.pos,scaleY:y+(t-y)*a.pos})}})}else w.attr({translateX:g,translateY:m,scaleX:f,scaleY:t})}c.styledMode||h.element.setAttribute("stroke-width",q(b.options[b.pointAttrToOptions&&b.pointAttrToOptions["stroke-width"]||
"borderWidth"],1)/(f||1));this.drawMapDataLabels()};a.prototype.getBox=function(b){var a=Number.MAX_VALUE,d=-a,h=a,e=-a,u=a,f=a,t=this.xAxis,g=this.yAxis,v;(b||[]).forEach(function(b){if(b.path){"string"===typeof b.path?b.path=E(b.path):"M"===b.path[0]&&(b.path=c.prototype.pathToSegments(b.path));var t=b.path||[],g=-a,w=a,m=-a,k=a,l=b.properties;b._foundBox||(t.forEach(function(b){var a=b[b.length-2];b=b[b.length-1];"number"===typeof a&&"number"===typeof b&&(w=Math.min(w,a),g=Math.max(g,a),k=Math.min(k,
b),m=Math.max(m,b))}),b._midX=w+(g-w)*q(b.middleX,l&&l["hc-middle-x"],.5),b._midY=k+(m-k)*q(b.middleY,l&&l["hc-middle-y"],.5),b._maxX=g,b._minX=w,b._maxY=m,b._minY=k,b.labelrank=q(b.labelrank,(g-w)*(m-k)),b._foundBox=!0);d=Math.max(d,b._maxX);h=Math.min(h,b._minX);e=Math.max(e,b._maxY);u=Math.min(u,b._minY);f=Math.min(b._maxX-b._minX,b._maxY-b._minY,f);v=!0}});v&&(this.minY=Math.min(u,q(this.minY,a)),this.maxY=Math.max(e,q(this.maxY,-a)),this.minX=Math.min(h,q(this.minX,a)),this.maxX=Math.max(d,q(this.maxX,
-a)),t&&"undefined"===typeof t.options.minRange&&(t.minRange=Math.min(5*f,(this.maxX-this.minX)/5,t.minRange||a)),g&&"undefined"===typeof g.options.minRange&&(g.minRange=Math.min(5*f,(this.maxY-this.minY)/5,g.minRange||a)))};a.prototype.getExtremes=function(){var b=f.prototype.getExtremes.call(this,this.valueData),a=b.dataMin;b=b.dataMax;this.chart.hasRendered&&this.isDirtyData&&this.getBox(this.options.data);t(a)&&(this.valueMin=a);t(b)&&(this.valueMax=b);return{dataMin:this.minY,dataMax:this.maxY}};
a.prototype.hasData=function(){return!!this.processedXData.length};a.prototype.pointAttribs=function(b,a){a=b.series.chart.styledMode?this.colorAttribs(b):z.prototype.pointAttribs.call(this,b,a);a["stroke-width"]=q(b.options[this.pointAttrToOptions&&this.pointAttrToOptions["stroke-width"]||"borderWidth"],"inherit");return a};a.prototype.render=function(){var b=this,a=f.prototype.render;b.chart.renderer.isVML&&3E3<b.data.length?setTimeout(function(){a.call(b)}):a.call(b)};a.prototype.setData=function(b,
a,d,c){var e=this.options,q=this.chart.options.chart,w=q&&q.map,m=e.mapData,k=this.joinBy,v=e.keys||this.pointArrayMap,F=[],y={},n=this.chart.mapTransforms;!m&&w&&(m="string"===typeof w?r[w]:w);b&&b.forEach(function(a,d){var h=0;if(t(a))b[d]={value:a};else if(D(a)){b[d]={};!e.keys&&a.length>v.length&&"string"===typeof a[0]&&(b[d]["hc-key"]=a[0],++h);for(var c=0;c<v.length;++c,++h)v[c]&&"undefined"!==typeof a[h]&&(0<v[c].indexOf(".")?g.prototype.setNestedProperty(b[d],a[h],v[c]):b[d][v[c]]=a[h])}k&&
"_i"===k[0]&&(b[d]._i=d)});this.getBox(b);(this.chart.mapTransforms=n=q&&q.mapTransforms||m&&m["hc-transform"]||n)&&h(n,function(b){b.rotation&&(b.cosAngle=Math.cos(b.rotation),b.sinAngle=Math.sin(b.rotation))});if(m){"FeatureCollection"===m.type&&(this.mapTitle=m.title,m=l.geojson(m,this.type,this));this.mapData=m;this.mapMap={};for(n=0;n<m.length;n++)q=m[n],w=q.properties,q._i=n,k[0]&&w&&w[k[0]]&&(q[k[0]]=w[k[0]]),y[q[k[0]]]=q;this.mapMap=y;if(b&&k[1]){var G=k[1];b.forEach(function(b){b=C(G,b);
y[b]&&F.push(y[b])})}if(e.allAreas){this.getBox(m);b=b||[];if(k[1]){var p=k[1];b.forEach(function(b){F.push(C(p,b))})}F="|"+F.map(function(b){return b&&b[k[0]]}).join("|")+"|";m.forEach(function(a){k[0]&&-1!==F.indexOf("|"+a[k[0]]+"|")||(b.push(u(a,{value:null})),c=!1)})}else this.getBox(F)}f.prototype.setData.call(this,b,a,d,c)};a.prototype.setOptions=function(b){b=f.prototype.setOptions.call(this,b);var a=b.joinBy;null===a&&(a="_i");a=this.joinBy=w(a);a[1]||(a[1]=a[0]);return b};a.prototype.translate=
function(){var b=this,a=b.xAxis,d=b.yAxis,h=b.doFullTranslate();b.generatePoints();b.data.forEach(function(c){t(c._midX)&&t(c._midY)&&(c.plotX=a.toPixels(c._midX,!0),c.plotY=d.toPixels(c._midY,!0));h&&(c.shapeType="path",c.shapeArgs={d:b.translatePath(c.path)})});B(b,"afterTranslate")};a.prototype.translatePath=function(b){var a=this.xAxis,d=this.yAxis,h=a.min,c=a.transA,e=a.minPixelPadding,u=d.min,q=d.transA,f=d.minPixelPadding,t=[];b&&b.forEach(function(b){"M"===b[0]?t.push(["M",(b[1]-(h||0))*c+
e,(b[2]-(u||0))*q+f]):"L"===b[0]?t.push(["L",(b[1]-(h||0))*c+e,(b[2]-(u||0))*q+f]):"C"===b[0]?t.push(["C",(b[1]-(h||0))*c+e,(b[2]-(u||0))*q+f,(b[3]-(h||0))*c+e,(b[4]-(u||0))*q+f,(b[5]-(h||0))*c+e,(b[6]-(u||0))*q+f]):"Q"===b[0]?t.push(["Q",(b[1]-(h||0))*c+e,(b[2]-(u||0))*q+f,(b[3]-(h||0))*c+e,(b[4]-(u||0))*q+f]):"Z"===b[0]&&t.push(["Z"])});return t};a.defaultOptions=u(A.defaultOptions,{animation:!1,dataLabels:{crop:!1,formatter:function(){return this.point.value},inside:!0,overflow:!1,padding:0,verticalAlign:"middle"},
marker:null,nullColor:k.neutralColor3,stickyTracking:!1,tooltip:{followPointer:!0,pointFormat:"{point.name}: {point.value}<br/>"},turboThreshold:0,allAreas:!0,borderColor:k.neutralColor20,borderWidth:1,joinBy:"hc-key",states:{hover:{halo:null,brightness:.2},normal:{animation:!0},select:{color:k.neutralColor20},inactive:{opacity:1}}});return a}(A);p(b.prototype,{type:"map",axisTypes:a.axisTypes,colorAttribs:a.colorAttribs,colorKey:a.colorKey,directTouch:!0,drawDataLabels:m,drawGraph:m,drawLegendSymbol:n.drawRectangle,
forceDL:!0,getExtremesFromAll:!0,getSymbol:a.getSymbol,parallelArrays:a.parallelArrays,pointArrayMap:a.pointArrayMap,pointClass:g,preserveAspectRatio:!0,searchPoint:m,trackerGroups:a.trackerGroups,useMapGeometry:!0});e.registerSeriesType("map",b);"";return b});x(a,"Series/MapLine/MapLineSeries.js",[a["Series/Map/MapSeries.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,l,n){var p=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(b,a){b.__proto__=a}||function(b,a){for(var d in a)a.hasOwnProperty(d)&&(b[d]=a[d])};return a(c,b)};return function(c,b){function d(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):(d.prototype=b.prototype,new d)}}(),g=l.series,k=n.extend,f=n.merge;n=function(e){function c(){var b=null!==e&&e.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}p(c,e);c.prototype.pointAttribs=function(b,d){b=a.prototype.pointAttribs.call(this,b,d);b.fill=
this.options.fillColor;return b};c.defaultOptions=f(a.defaultOptions,{lineWidth:1,fillColor:"none"});return c}(a);k(n.prototype,{type:"mapline",colorProp:"stroke",drawLegendSymbol:g.prototype.drawLegendSymbol,pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"}});l.registerSeriesType("mapline",n);"";return n});x(a,"Series/MapPoint/MapPointPoint.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,l){var n=this&&this.__extends||function(){var a=function(g,f){a=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(g,f)};return function(g,f){function e(){this.constructor=g}a(g,f);g.prototype=null===f?Object.create(f):(e.prototype=f.prototype,new e)}}(),p=l.merge;return function(a){function g(){var f=null!==a&&a.apply(this,arguments)||this;f.options=void 0;f.series=void 0;return f}n(g,a);g.prototype.applyOptions=function(f,e){f="undefined"!==typeof f.lat&&"undefined"!==typeof f.lon?
p(f,this.series.chart.fromLatLonToPoint(f)):f;return a.prototype.applyOptions.call(this,f,e)};return g}(a.seriesTypes.scatter.prototype.pointClass)});x(a,"Series/MapPoint/MapPointSeries.js",[a["Series/MapPoint/MapPointPoint.js"],a["Core/Color/Palette.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,l,n,p){var g=this&&this.__extends||function(){var a=function(b,d){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,a){b.__proto__=a}||function(b,a){for(var d in a)a.hasOwnProperty(d)&&
(b[d]=a[d])};return a(b,d)};return function(b,d){function c(){this.constructor=b}a(b,d);b.prototype=null===d?Object.create(d):(c.prototype=d.prototype,new c)}}(),k=n.seriesTypes.scatter,f=p.extend,e=p.merge;p=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}g(b,a);b.prototype.drawDataLabels=function(){a.prototype.drawDataLabels.call(this);this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)};b.defaultOptions=
e(k.defaultOptions,{dataLabels:{crop:!1,defer:!1,enabled:!0,formatter:function(){return this.point.name},overflow:!1,style:{color:l.neutralColor100}}});return b}(k);f(p.prototype,{type:"mappoint",forceDL:!0,pointClass:a});n.registerSeriesType("mappoint",p);"";return p});x(a,"Series/Bubble/BubblePoint.js",[a["Core/Series/Point.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,l,n){var p=this&&this.__extends||function(){var a=function(g,f){a=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(g,f)};return function(g,f){function e(){this.constructor=g}a(g,f);g.prototype=null===f?Object.create(f):(e.prototype=f.prototype,new e)}}();n=n.extend;l=function(g){function k(){var a=null!==g&&g.apply(this,arguments)||this;a.options=void 0;a.series=void 0;return a}p(k,g);k.prototype.haloPath=function(f){return a.prototype.haloPath.call(this,0===f?0:(this.marker?this.marker.radius||0:0)+f)};
return k}(l.seriesTypes.scatter.prototype.pointClass);n(l.prototype,{ttBelow:!1});return l});x(a,"Series/Bubble/BubbleLegend.js",[a["Core/Chart/Chart.js"],a["Core/Color/Color.js"],a["Core/Globals.js"],a["Core/Legend.js"],a["Core/Color/Palette.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,l,n,p,g,k,f){var e=l.parse,c=n.noop;l=f.addEvent;var b=f.arrayMax,d=f.arrayMin,m=f.isNumber,r=f.merge,E=f.objectEach,z=f.pick,A=f.setOptions,B=f.stableSort,C=f.wrap;"";A({legend:{bubbleLegend:{borderColor:void 0,
borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,connectorWidth:1,enabled:!1,labels:{className:void 0,allowOverlap:!1,format:"",formatter:void 0,align:"right",style:{fontSize:10,color:void 0},x:0,y:0},maxSize:60,minSize:10,legendIndex:0,ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0}}});A=function(){function a(b,a){this.options=this.symbols=this.visible=
this.ranges=this.movementX=this.maxLabel=this.legendSymbol=this.legendItemWidth=this.legendItemHeight=this.legendItem=this.legendGroup=this.legend=this.fontMetrics=this.chart=void 0;this.setState=c;this.init(b,a)}a.prototype.init=function(b,a){this.options=b;this.visible=!0;this.chart=a.chart;this.legend=a};a.prototype.addToLegend=function(b){b.splice(this.options.legendIndex,0,this)};a.prototype.drawLegendSymbol=function(b){var a=this.chart,d=this.options,c=z(b.options.itemDistance,20),e=d.ranges;
var f=d.connectorDistance;this.fontMetrics=a.renderer.fontMetrics(d.labels.style.fontSize.toString()+"px");e&&e.length&&m(e[0].value)?(B(e,function(b,a){return a.value-b.value}),this.ranges=e,this.setOptions(),this.render(),a=this.getMaxLabelSize(),e=this.ranges[0].radius,b=2*e,f=f-e+a.width,f=0<f?f:0,this.maxLabel=a,this.movementX="left"===d.labels.align?f:0,this.legendItemWidth=b+f+c,this.legendItemHeight=b+this.fontMetrics.h/2):b.options.bubbleLegend.autoRanges=!0};a.prototype.setOptions=function(){var b=
this.ranges,a=this.options,d=this.chart.series[a.seriesIndex],c=this.legend.baseline,f={"z-index":a.zIndex,"stroke-width":a.borderWidth},g={"z-index":a.zIndex,"stroke-width":a.connectorWidth},m=this.getLabelStyles(),k=d.options.marker.fillOpacity,l=this.chart.styledMode;b.forEach(function(h,q){l||(f.stroke=z(h.borderColor,a.borderColor,d.color),f.fill=z(h.color,a.color,1!==k?e(d.color).setOpacity(k).get("rgba"):d.color),g.stroke=z(h.connectorColor,a.connectorColor,d.color));b[q].radius=this.getRangeRadius(h.value);
b[q]=r(b[q],{center:b[0].radius-b[q].radius+c});l||r(!0,b[q],{bubbleStyle:r(!1,f),connectorStyle:r(!1,g),labelStyle:m})},this)};a.prototype.getLabelStyles=function(){var b=this.options,a={},d="left"===b.labels.align,c=this.legend.options.rtl;E(b.labels.style,function(b,d){"color"!==d&&"fontSize"!==d&&"z-index"!==d&&(a[d]=b)});return r(!1,a,{"font-size":b.labels.style.fontSize,fill:z(b.labels.style.color,g.neutralColor100),"z-index":b.zIndex,align:c||d?"right":"left"})};a.prototype.getRangeRadius=
function(b){var a=this.options;return this.chart.series[this.options.seriesIndex].getRadius.call(this,a.ranges[a.ranges.length-1].value,a.ranges[0].value,a.minSize,a.maxSize,b)};a.prototype.render=function(){var b=this.chart.renderer,a=this.options.zThreshold;this.symbols||(this.symbols={connectors:[],bubbleItems:[],labels:[]});this.legendSymbol=b.g("bubble-legend");this.legendItem=b.g("bubble-legend-item");this.legendSymbol.translateX=0;this.legendSymbol.translateY=0;this.ranges.forEach(function(b){b.value>=
a&&this.renderRange(b)},this);this.legendSymbol.add(this.legendItem);this.legendItem.add(this.legendGroup);this.hideOverlappingLabels()};a.prototype.renderRange=function(b){var a=this.options,d=a.labels,c=this.chart.renderer,e=this.symbols,f=e.labels,g=b.center,m=Math.abs(b.radius),t=a.connectorDistance||0,k=d.align,l=d.style.fontSize;t=this.legend.options.rtl||"left"===k?-t:t;d=a.connectorWidth;var n=this.ranges[0].radius||0,p=g-m-a.borderWidth/2+d/2;l=l/2-(this.fontMetrics.h-l)/2;var r=c.styledMode;
"center"===k&&(t=0,a.connectorDistance=0,b.labelStyle.align="center");k=p+a.labels.y;var D=n+t+a.labels.x;e.bubbleItems.push(c.circle(n,g+((p%1?1:.5)-(d%2?0:.5)),m).attr(r?{}:b.bubbleStyle).addClass((r?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-symbol "+(a.className||"")).add(this.legendSymbol));e.connectors.push(c.path(c.crispLine([["M",n,p],["L",n+t,p]],a.connectorWidth)).attr(r?{}:b.connectorStyle).addClass((r?"highcharts-color-"+this.options.seriesIndex+" ":
"")+"highcharts-bubble-legend-connectors "+(a.connectorClassName||"")).add(this.legendSymbol));b=c.text(this.formatLabel(b),D,k+l).attr(r?{}:b.labelStyle).addClass("highcharts-bubble-legend-labels "+(a.labels.className||"")).add(this.legendSymbol);f.push(b);b.placed=!0;b.alignAttr={x:D,y:k+l}};a.prototype.getMaxLabelSize=function(){var b,a;this.symbols.labels.forEach(function(d){a=d.getBBox(!0);b=b?a.width>b.width?a:b:a});return b||{}};a.prototype.formatLabel=function(b){var a=this.options,d=a.labels.formatter;
a=a.labels.format;var c=this.chart.numberFormatter;return a?f.format(a,b):d?d.call(b):c(b.value,1)};a.prototype.hideOverlappingLabels=function(){var b=this.chart,a=this.symbols;!this.options.labels.allowOverlap&&a&&(b.hideOverlappingLabels(a.labels),a.labels.forEach(function(b,d){b.newOpacity?b.newOpacity!==b.oldOpacity&&a.connectors[d].show():a.connectors[d].hide()}))};a.prototype.getRanges=function(){var a=this.legend.bubbleLegend,c=a.options.ranges,h,e=Number.MAX_VALUE,f=-Number.MAX_VALUE;a.chart.series.forEach(function(a){a.isBubble&&
!a.ignoreSeries&&(h=a.zData.filter(m),h.length&&(e=z(a.options.zMin,Math.min(e,Math.max(d(h),!1===a.options.displayNegative?a.options.zThreshold:-Number.MAX_VALUE))),f=z(a.options.zMax,Math.max(f,b(h)))))});var g=e===f?[{value:f}]:[{value:e},{value:(e+f)/2},{value:f,autoRanges:!0}];c.length&&c[0].radius&&g.reverse();g.forEach(function(b,a){c&&c[a]&&(g[a]=r(!1,c[a],b))});return g};a.prototype.predictBubbleSizes=function(){var b=this.chart,a=this.fontMetrics,d=b.legend.options,c="horizontal"===d.layout,
e=c?b.legend.lastLineHeight:0,f=b.plotSizeX,g=b.plotSizeY,m=b.series[this.options.seriesIndex];b=Math.ceil(m.minPxSize);var k=Math.ceil(m.maxPxSize);m=m.options.maxSize;var l=Math.min(g,f);if(d.floating||!/%$/.test(m))a=k;else if(m=parseFloat(m),a=(l+e-a.h/2)*m/100/(m/100+1),c&&g-a>=f||!c&&f-a>=g)a=k;return[b,Math.ceil(a)]};a.prototype.updateRanges=function(b,a){var d=this.legend.options.bubbleLegend;d.minSize=b;d.maxSize=a;d.ranges=this.getRanges()};a.prototype.correctSizes=function(){var b=this.legend,
a=this.chart.series[this.options.seriesIndex];1<Math.abs(Math.ceil(a.maxPxSize)-this.options.maxSize)&&(this.updateRanges(this.options.minSize,a.maxPxSize),b.render())};return a}();l(p,"afterGetAllItems",function(b){var a=this.bubbleLegend,d=this.options,c=d.bubbleLegend,e=this.chart.getVisibleBubbleSeriesIndex();a&&a.ranges&&a.ranges.length&&(c.ranges.length&&(c.autoRanges=!!c.ranges[0].autoRanges),this.destroyItem(a));0<=e&&d.enabled&&c.enabled&&(c.seriesIndex=e,this.bubbleLegend=new n.BubbleLegend(c,
this),this.bubbleLegend.addToLegend(b.allItems))});a.prototype.getVisibleBubbleSeriesIndex=function(){for(var b=this.series,a=0;a<b.length;){if(b[a]&&b[a].isBubble&&b[a].visible&&b[a].zData.length)return a;a++}return-1};p.prototype.getLinesHeights=function(){var b=this.allItems,a=[],d=b.length,c,e=0;for(c=0;c<d;c++)if(b[c].legendItemHeight&&(b[c].itemHeight=b[c].legendItemHeight),b[c]===b[d-1]||b[c+1]&&b[c]._legendItemPos[1]!==b[c+1]._legendItemPos[1]){a.push({height:0});var f=a[a.length-1];for(e;e<=
c;e++)b[e].itemHeight>f.height&&(f.height=b[e].itemHeight);f.step=c}return a};p.prototype.retranslateItems=function(b){var a,d,c,e=this.options.rtl,f=0;this.allItems.forEach(function(h,g){a=h.legendGroup.translateX;d=h._legendItemPos[1];if((c=h.movementX)||e&&h.ranges)c=e?a-h.options.maxSize/2:a+c,h.legendGroup.attr({translateX:c});g>b[f].step&&f++;h.legendGroup.attr({translateY:Math.round(d+b[f].height/2)});h._legendItemPos[1]=d+b[f].height/2})};l(k,"legendItemClick",function(){var b=this.chart,
a=this.visible,d=this.chart.legend;d&&d.bubbleLegend&&(this.visible=!a,this.ignoreSeries=a,b=0<=b.getVisibleBubbleSeriesIndex(),d.bubbleLegend.visible!==b&&(d.update({bubbleLegend:{enabled:b}}),d.bubbleLegend.visible=b),this.visible=a)});C(a.prototype,"drawChartBox",function(b,a,d){var c=this.legend,e=0<=this.getVisibleBubbleSeriesIndex();if(c&&c.options.enabled&&c.bubbleLegend&&c.options.bubbleLegend.autoRanges&&e){var f=c.bubbleLegend.options;e=c.bubbleLegend.predictBubbleSizes();c.bubbleLegend.updateRanges(e[0],
e[1]);f.placed||(c.group.placed=!1,c.allItems.forEach(function(b){b.legendGroup.translateY=null}));c.render();this.getMargins();this.axes.forEach(function(b){b.visible&&b.render();f.placed||(b.setScale(),b.updateNames(),E(b.ticks,function(b){b.isNew=!0;b.isNewLabel=!0}))});f.placed=!0;this.getMargins();b.call(this,a,d);c.bubbleLegend.correctSizes();c.retranslateItems(c.getLinesHeights())}else b.call(this,a,d),c&&c.options.enabled&&c.bubbleLegend&&(c.render(),c.retranslateItems(c.getLinesHeights()))});
n.BubbleLegend=A;return n.BubbleLegend});x(a,"Series/Bubble/BubbleSeries.js",[a["Core/Axis/Axis.js"],a["Series/Bubble/BubblePoint.js"],a["Core/Color/Color.js"],a["Core/Globals.js"],a["Core/Series/Series.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,l,n,p,g,k,f){var e=this&&this.__extends||function(){var b=function(a,d){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,a){b.__proto__=a}||function(b,a){for(var d in a)a.hasOwnProperty(d)&&(b[d]=a[d])};return b(a,
d)};return function(a,d){function c(){this.constructor=a}b(a,d);a.prototype=null===d?Object.create(d):(c.prototype=d.prototype,new c)}}(),c=n.parse;n=p.noop;var b=k.seriesTypes;p=b.column;var d=b.scatter,m=f.arrayMax,r=f.arrayMin,E=f.clamp,z=f.extend,A=f.isNumber,B=f.merge,C=f.pick,D=f.pInt;f=function(b){function a(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.maxPxSize=void 0;a.minPxSize=void 0;a.options=void 0;a.points=void 0;a.radii=void 0;a.yData=void 0;a.zData=void 0;return a}
e(a,b);a.prototype.animate=function(b){!b&&this.points.length<this.options.animationLimit&&this.points.forEach(function(b){var a=b.graphic;a&&a.width&&(this.hasRendered||a.attr({x:b.plotX,y:b.plotY,width:1,height:1}),a.animate(this.markerAttribs(b),this.options.animation))},this)};a.prototype.getRadii=function(b,a,d){var c=this.zData,e=this.yData,h=d.minPxSize,f=d.maxPxSize,g=[];var m=0;for(d=c.length;m<d;m++){var k=c[m];g.push(this.getRadius(b,a,h,f,k,e[m]))}this.radii=g};a.prototype.getRadius=function(b,
a,d,c,e,f){var h=this.options,g="width"!==h.sizeBy,m=h.zThreshold,k=a-b,q=.5;if(null===f||null===e)return null;if(A(e)){h.sizeByAbsoluteValue&&(e=Math.abs(e-m),k=Math.max(a-m,Math.abs(b-m)),b=0);if(e<b)return d/2-1;0<k&&(q=(e-b)/k)}g&&0<=q&&(q=Math.sqrt(q));return Math.ceil(d+q*(c-d))/2};a.prototype.hasData=function(){return!!this.processedXData.length};a.prototype.pointAttribs=function(b,a){var d=this.options.marker.fillOpacity;b=g.prototype.pointAttribs.call(this,b,a);1!==d&&(b.fill=c(b.fill).setOpacity(d).get("rgba"));
return b};a.prototype.translate=function(){var a,d=this.data,c=this.radii;b.prototype.translate.call(this);for(a=d.length;a--;){var e=d[a];var f=c?c[a]:0;A(f)&&f>=this.minPxSize/2?(e.marker=z(e.marker,{radius:f,width:2*f,height:2*f}),e.dlBox={x:e.plotX-f,y:e.plotY-f,width:2*f,height:2*f}):e.shapeArgs=e.plotY=e.dlBox=void 0}};a.defaultOptions=B(d.defaultOptions,{dataLabels:{formatter:function(){return this.point.z},inside:!0,verticalAlign:"middle"},animationLimit:250,marker:{lineColor:null,lineWidth:1,
fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},turboThreshold:0,zThreshold:0,zoneAxis:"z"});return a}(d);z(f.prototype,{alignDataLabel:p.prototype.alignDataLabel,applyZones:n,bubblePadding:!0,buildKDTree:n,directTouch:!0,isBubble:!0,pointArrayMap:["y","z"],pointClass:l,parallelArrays:["x","y","z"],trackerGroups:["group","dataLabelsGroup"],
specialGroup:"group",zoneAxis:"z"});a.prototype.beforePadding=function(){var b=this,a=this.len,d=this.chart,c=0,e=a,f=this.isXAxis,g=f?"xData":"yData",k=this.min,l={},n=Math.min(d.plotWidth,d.plotHeight),p=Number.MAX_VALUE,z=-Number.MAX_VALUE,H=this.max-k,B=a/H,x=[];this.series.forEach(function(a){var c=a.options;!a.bubblePadding||!a.visible&&d.options.chart.ignoreHiddenSeries||(b.allowZoomOutside=!0,x.push(a),f&&(["minSize","maxSize"].forEach(function(b){var a=c[b],d=/%$/.test(a);a=D(a);l[b]=d?n*
a/100:a}),a.minPxSize=l.minSize,a.maxPxSize=Math.max(l.maxSize,l.minSize),a=a.zData.filter(A),a.length&&(p=C(c.zMin,E(r(a),!1===c.displayNegative?c.zThreshold:-Number.MAX_VALUE,p)),z=C(c.zMax,Math.max(z,m(a))))))});x.forEach(function(a){var d=a[g],h=d.length;f&&a.getRadii(p,z,a);if(0<H)for(;h--;)if(A(d[h])&&b.dataMin<=d[h]&&d[h]<=b.max){var m=a.radii?a.radii[h]:0;c=Math.min((d[h]-k)*B-m,c);e=Math.max((d[h]-k)*B+m,e)}});x.length&&0<H&&!this.logarithmic&&(e-=a,B*=(a+Math.max(0,c)-Math.min(e,a))/a,[["min",
"userMin",c],["max","userMax",e]].forEach(function(a){"undefined"===typeof C(b.options[a[0]],b[a[1]])&&(b[a[0]]+=a[2]/B)}))};k.registerSeriesType("bubble",f);"";"";return f});x(a,"Series/MapBubble/MapBubblePoint.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,l){var n=this&&this.__extends||function(){var a=function(e,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,a){b.__proto__=a}||function(b,a){for(var d in a)a.hasOwnProperty(d)&&(b[d]=a[d])};return a(e,
c)};return function(e,c){function b(){this.constructor=e}a(e,c);e.prototype=null===c?Object.create(c):(b.prototype=c.prototype,new b)}}(),p=a.seriesTypes,g=p.map;a=l.extend;var k=l.merge;l=function(a){function e(){return null!==a&&a.apply(this,arguments)||this}n(e,a);e.prototype.applyOptions=function(c,b){return c&&"undefined"!==typeof c.lat&&"undefined"!==typeof c.lon?a.prototype.applyOptions.call(this,k(c,this.series.chart.fromLatLonToPoint(c)),b):g.prototype.pointClass.prototype.applyOptions.call(this,
c,b)};e.prototype.isValid=function(){return"number"===typeof this.z};return e}(p.bubble.prototype.pointClass);a(l.prototype,{ttBelow:!1});return l});x(a,"Series/MapBubble/MapBubbleSeries.js",[a["Series/Bubble/BubbleSeries.js"],a["Series/MapBubble/MapBubblePoint.js"],a["Series/Map/MapSeries.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,l,n,p,g){var k=this&&this.__extends||function(){var a=function(b,d){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,
a){b.__proto__=a}||function(b,a){for(var d in a)a.hasOwnProperty(d)&&(b[d]=a[d])};return a(b,d)};return function(b,d){function c(){this.constructor=b}a(b,d);b.prototype=null===d?Object.create(d):(c.prototype=d.prototype,new c)}}(),f=g.extend,e=g.merge;g=function(c){function b(){var a=null!==c&&c.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}k(b,c);b.defaultOptions=e(a.defaultOptions,{animationLimit:500,tooltip:{pointFormat:"{point.name}: {point.z}"}});return b}(a);
f(g.prototype,{type:"mapbubble",getBox:n.prototype.getBox,pointArrayMap:["z"],pointClass:l,setData:n.prototype.setData,setOptions:n.prototype.setOptions,xyFromShape:!0});p.registerSeriesType("mapbubble",g);"";return g});x(a,"Series/Heatmap/HeatmapPoint.js",[a["Mixins/ColorMapSeries.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,l,n){var p=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=
b}||function(a,b){for(var d in b)b.hasOwnProperty(d)&&(a[d]=b[d])};return a(c,b)};return function(c,b){function d(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):(d.prototype=b.prototype,new d)}}();a=a.colorMapPointMixin;var g=n.clamp,k=n.extend,f=n.pick;l=function(a){function c(){var b=null!==a&&a.apply(this,arguments)||this;b.options=void 0;b.series=void 0;b.value=void 0;b.x=void 0;b.y=void 0;return b}p(c,a);c.prototype.applyOptions=function(b,d){b=a.prototype.applyOptions.call(this,
b,d);b.formatPrefix=b.isNull||null===b.value?"null":"point";return b};c.prototype.getCellAttributes=function(){var a=this.series,d=a.options,c=(d.colsize||1)/2,e=(d.rowsize||1)/2,k=a.xAxis,l=a.yAxis,n=this.options.marker||a.options.marker;a=a.pointPlacementToXValue();var p=f(this.pointPadding,d.pointPadding,0),r={x1:g(Math.round(k.len-(k.translate(this.x-c,!1,!0,!1,!0,-a)||0)),-k.len,2*k.len),x2:g(Math.round(k.len-(k.translate(this.x+c,!1,!0,!1,!0,-a)||0)),-k.len,2*k.len),y1:g(Math.round(l.translate(this.y-
e,!1,!0,!1,!0)||0),-l.len,2*l.len),y2:g(Math.round(l.translate(this.y+e,!1,!0,!1,!0)||0),-l.len,2*l.len)};[["width","x"],["height","y"]].forEach(function(a){var b=a[0];a=a[1];var d=a+"1",c=a+"2",e=Math.abs(r[d]-r[c]),f=n&&n.lineWidth||0,g=Math.abs(r[d]+r[c])/2;n[b]&&n[b]<e&&(r[d]=g-n[b]/2-f/2,r[c]=g+n[b]/2+f/2);p&&("y"===a&&(d=c,c=a+"1"),r[d]+=p,r[c]-=p)});return r};c.prototype.haloPath=function(a){if(!a)return[];var b=this.shapeArgs;return["M",b.x-a,b.y-a,"L",b.x-a,b.y+b.height+a,b.x+b.width+a,b.y+
b.height+a,b.x+b.width+a,b.y-a,"Z"]};c.prototype.isValid=function(){return Infinity!==this.value&&-Infinity!==this.value};return c}(l.seriesTypes.scatter.prototype.pointClass);k(l.prototype,{dataLabelOnNull:a.dataLabelOnNull,setState:a.setState});return l});x(a,"Series/Heatmap/HeatmapSeries.js",[a["Mixins/ColorMapSeries.js"],a["Core/Globals.js"],a["Series/Heatmap/HeatmapPoint.js"],a["Mixins/LegendSymbol.js"],a["Core/Color/Palette.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Renderer/SVG/SVGRenderer.js"],
a["Core/Utilities.js"]],function(a,l,n,p,g,k,f,e){var c=this&&this.__extends||function(){var a=function(b,d){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var d in b)b.hasOwnProperty(d)&&(a[d]=b[d])};return a(b,d)};return function(b,d){function c(){this.constructor=b}a(b,d);b.prototype=null===d?Object.create(d):(c.prototype=d.prototype,new c)}}();a=a.colorMapSeriesMixin;var b=l.noop,d=k.series,m=k.seriesTypes,r=m.column,x=m.scatter,z=f.prototype.symbols,
A=e.extend,B=e.fireEvent,C=e.isNumber,D=e.merge,t=e.pick;f=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.colorAxis=void 0;b.data=void 0;b.options=void 0;b.points=void 0;b.valueMax=NaN;b.valueMin=NaN;return b}c(b,a);b.prototype.drawPoints=function(){var a=this;if((this.options.marker||{}).enabled||this._hasPointMarkers)d.prototype.drawPoints.call(this),this.points.forEach(function(b){b.graphic&&b.graphic[a.chart.styledMode?"css":"animate"](a.colorAttribs(b))})};b.prototype.getExtremes=
function(){var a=d.prototype.getExtremes.call(this,this.valueData),b=a.dataMin;a=a.dataMax;C(b)&&(this.valueMin=b);C(a)&&(this.valueMax=a);return d.prototype.getExtremes.call(this)};b.prototype.getValidPoints=function(a,b){return d.prototype.getValidPoints.call(this,a,b,!0)};b.prototype.hasData=function(){return!!this.processedXData.length};b.prototype.init=function(){d.prototype.init.apply(this,arguments);var a=this.options;a.pointRange=t(a.pointRange,a.colsize||1);this.yAxis.axisPointRange=a.rowsize||
1;A(z,{ellipse:z.circle,rect:z.square})};b.prototype.markerAttribs=function(a,b){var d=a.marker||{},c=this.options.marker||{},e=a.shapeArgs||{},f={};if(a.hasImage)return{x:a.plotX,y:a.plotY};if(b){var h=c.states[b]||{};var g=d.states&&d.states[b]||{};[["width","x"],["height","y"]].forEach(function(a){f[a[0]]=(g[a[0]]||h[a[0]]||e[a[0]])+(g[a[0]+"Plus"]||h[a[0]+"Plus"]||0);f[a[1]]=e[a[1]]+(e[a[0]]-f[a[0]])/2})}return b?f:e};b.prototype.pointAttribs=function(a,b){var c=d.prototype.pointAttribs.call(this,
a,b),e=this.options||{},f=this.chart.options.plotOptions||{},h=f.series||{},g=f.heatmap||{};f=e.borderColor||g.borderColor||h.borderColor;h=e.borderWidth||g.borderWidth||h.borderWidth||c["stroke-width"];c.stroke=a&&a.marker&&a.marker.lineColor||e.marker&&e.marker.lineColor||f||this.color;c["stroke-width"]=h;b&&(a=D(e.states[b],e.marker&&e.marker.states[b],a&&a.options.states&&a.options.states[b]||{}),b=a.brightness,c.fill=a.color||l.color(c.fill).brighten(b||0).get(),c.stroke=a.lineColor);return c};
b.prototype.setClip=function(a){var b=this.chart;d.prototype.setClip.apply(this,arguments);(!1!==this.options.clip||a)&&this.markerGroup.clip((a||this.clipBox)&&this.sharedClipKey?b[this.sharedClipKey]:b.clipRect)};b.prototype.translate=function(){var a=this.options,b=a.marker&&a.marker.symbol||"",d=z[b]?b:"rect";a=this.options;var c=-1!==["circle","square"].indexOf(d);this.generatePoints();this.points.forEach(function(a){var e=a.getCellAttributes(),f={x:Math.min(e.x1,e.x2),y:Math.min(e.y1,e.y2),
width:Math.max(Math.abs(e.x2-e.x1),0),height:Math.max(Math.abs(e.y2-e.y1),0)};var h=a.hasImage=0===(a.marker&&a.marker.symbol||b||"").indexOf("url");if(c){var g=Math.abs(f.width-f.height);f.x=Math.min(e.x1,e.x2)+(f.width<f.height?0:g/2);f.y=Math.min(e.y1,e.y2)+(f.width<f.height?g/2:0);f.width=f.height=Math.min(f.width,f.height)}g={plotX:(e.x1+e.x2)/2,plotY:(e.y1+e.y2)/2,clientX:(e.x1+e.x2)/2,shapeType:"path",shapeArgs:D(!0,f,{d:z[d](f.x,f.y,f.width,f.height)})};h&&(a.marker={width:f.width,height:f.height});
A(a,g)});B(this,"afterTranslate")};b.defaultOptions=D(x.defaultOptions,{animation:!1,borderWidth:0,nullColor:g.neutralColor3,dataLabels:{formatter:function(){return this.point.value},inside:!0,verticalAlign:"middle",crop:!1,overflow:!1,padding:0},marker:{symbol:"rect",radius:0,lineColor:void 0,states:{hover:{lineWidthPlus:0},select:{}}},clip:!0,pointRange:null,tooltip:{pointFormat:"{point.x}, {point.y}: {point.value}<br/>"},states:{hover:{halo:!1,brightness:.2}}});return b}(x);A(f.prototype,{alignDataLabel:r.prototype.alignDataLabel,
axisTypes:a.axisTypes,colorAttribs:a.colorAttribs,colorKey:a.colorKey,directTouch:!0,drawLegendSymbol:p.drawRectangle,getBox:b,getExtremesFromAll:!0,getSymbol:d.prototype.getSymbol,hasPointSpecificOptions:!0,parallelArrays:a.parallelArrays,pointArrayMap:["y","value"],pointClass:n,trackerGroups:a.trackerGroups});k.registerSeriesType("heatmap",f);"";"";return f});x(a,"Extensions/GeoJSON.js",[a["Core/Chart/Chart.js"],a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,l,n){function p(a,d){var b,
c=!1,e=a.x,f=a.y;a=0;for(b=d.length-1;a<d.length;b=a++){var g=d[a][1]>f;var k=d[b][1]>f;g!==k&&e<(d[b][0]-d[a][0])*(f-d[a][1])/(d[b][1]-d[a][1])+d[a][0]&&(c=!c)}return c}var g=l.win,k=n.error,f=n.extend,e=n.format,c=n.merge;n=n.wrap;"";a.prototype.transformFromLatLon=function(a,d){var b,c=(null===(b=this.userOptions.chart)||void 0===b?void 0:b.proj4)||g.proj4;if(!c)return k(21,!1,this),{x:0,y:null};a=c(d.crs,[a.lon,a.lat]);b=d.cosAngle||d.rotation&&Math.cos(d.rotation);c=d.sinAngle||d.rotation&&Math.sin(d.rotation);
a=d.rotation?[a[0]*b+a[1]*c,-a[0]*c+a[1]*b]:a;return{x:((a[0]-(d.xoffset||0))*(d.scale||1)+(d.xpan||0))*(d.jsonres||1)+(d.jsonmarginX||0),y:(((d.yoffset||0)-a[1])*(d.scale||1)+(d.ypan||0))*(d.jsonres||1)-(d.jsonmarginY||0)}};a.prototype.transformToLatLon=function(a,d){if("undefined"===typeof g.proj4)k(21,!1,this);else{a={x:((a.x-(d.jsonmarginX||0))/(d.jsonres||1)-(d.xpan||0))/(d.scale||1)+(d.xoffset||0),y:((-a.y-(d.jsonmarginY||0))/(d.jsonres||1)+(d.ypan||0))/(d.scale||1)+(d.yoffset||0)};var b=d.cosAngle||
d.rotation&&Math.cos(d.rotation),c=d.sinAngle||d.rotation&&Math.sin(d.rotation);d=g.proj4(d.crs,"WGS84",d.rotation?{x:a.x*b+a.y*-c,y:a.x*c+a.y*b}:a);return{lat:d.y,lon:d.x}}};a.prototype.fromPointToLatLon=function(a){var b=this.mapTransforms,c;if(b){for(c in b)if(Object.hasOwnProperty.call(b,c)&&b[c].hitZone&&p({x:a.x,y:-a.y},b[c].hitZone.coordinates[0]))return this.transformToLatLon(a,b[c]);return this.transformToLatLon(a,b["default"])}k(22,!1,this)};a.prototype.fromLatLonToPoint=function(a){var b=
this.mapTransforms,c;if(!b)return k(22,!1,this),{x:0,y:null};for(c in b)if(Object.hasOwnProperty.call(b,c)&&b[c].hitZone){var e=this.transformFromLatLon(a,b[c]);if(p({x:e.x,y:-e.y},b[c].hitZone.coordinates[0]))return e}return this.transformFromLatLon(a,b["default"])};l.geojson=function(a,d,c){var b=[],g=[],k=function(a){a.forEach(function(a,b){0===b?g.push(["M",a[0],-a[1]]):g.push(["L",a[0],-a[1]])})};d=d||"map";a.features.forEach(function(a){var c=a.geometry,e=c.type;c=c.coordinates;a=a.properties;
var l;g=[];"map"===d||"mapbubble"===d?("Polygon"===e?(c.forEach(k),g.push(["Z"])):"MultiPolygon"===e&&(c.forEach(function(a){a.forEach(k)}),g.push(["Z"])),g.length&&(l={path:g})):"mapline"===d?("LineString"===e?k(c):"MultiLineString"===e&&c.forEach(k),g.length&&(l={path:g})):"mappoint"===d&&"Point"===e&&(l={x:c[0],y:-c[1]});l&&b.push(f(l,{name:a.name||a.NAME,properties:a}))});c&&a.copyrightShort&&(c.chart.mapCredits=e(c.chart.options.credits.mapText,{geojson:a}),c.chart.mapCreditsFull=e(c.chart.options.credits.mapTextFull,
{geojson:a}));return b};n(a.prototype,"addCredits",function(a,d){d=c(!0,this.options.credits,d);this.mapCredits&&(d.href=null);a.call(this,d);this.credits&&this.mapCreditsFull&&this.credits.attr({title:this.mapCreditsFull})})});x(a,"masters/modules/map.src.js",[],function(){})});
//# sourceMappingURL=map.js.map