/*
 Highstock JS v9.0.1 (2021-02-15)

 Indicator series type for Highstock

 (c) 2010-2021 Sebastian Bochan

 License: www.highcharts.com/license
*/
(function(f){"object"===typeof module&&module.exports?(f["default"]=f,module.exports=f):"function"===typeof define&&define.amd?define("highcharts/indicators/ichimoku-kinko-hyo",["highcharts","highcharts/modules/stock"],function(m){f(m);f.Highcharts=m;return f}):f("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(f){function m(f,m,p,h){f.hasOwnProperty(m)||(f[m]=h.apply(null,p))}f=f?f._modules:{};m(f,"Stock/Indicators/IKH/IKHIndicator.js",[f["Core/Color/Color.js"],f["Core/Globals.js"],
f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,m,p,h){function G(d){return d.reduce(function(b,a){return Math.max(b,a[1])},-Infinity)}function H(d){return d.reduce(function(b,a){return Math.min(b,a[2])},Infinity)}function y(d){return{high:G(d),low:H(d)}}function I(d){var b,a,n,c,q;d.series.forEach(function(d){if(d.xData)for(c=d.xData,q=a=d.xIncrement?1:c.length-1;0<q;q--)if(n=c[q]-c[q-1],"undefined"===typeof b||n<b)b=n});return b}function J(d,b,a,n){if(d&&b&&a&&n){var c=b.plotX-
d.plotX;b=b.plotY-d.plotY;var q=n.plotX-a.plotX;n=n.plotY-a.plotY;var f=d.plotX-a.plotX,z=d.plotY-a.plotY;a=(-b*f+c*z)/(-q*b+c*n);q=(q*z-n*f)/(-q*b+c*n);if(0<=a&&1>=a&&0<=q&&1>=q)return{plotX:d.plotX+q*c,plotY:d.plotY+q*b}}return!1}function D(d){var b=d.indicator;b.points=d.points;b.nextPoints=d.nextPoints;b.color=d.color;b.options=B(d.options.senkouSpan.styles,d.gap);b.graph=d.graph;b.fillGraph=!0;p.seriesTypes.sma.prototype.drawGraph.call(b)}var K=this&&this.__extends||function(){var d=function(b,
a){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return d(b,a)};return function(b,a){function n(){this.constructor=b}d(b,a);b.prototype=null===a?Object.create(a):(n.prototype=a.prototype,new n)}}(),v=f.parse,E=p.seriesTypes.sma,F=h.defined;f=h.extend;var L=h.isArray,B=h.merge,M=h.objectEach;m.approximations["ichimoku-averages"]=function(){var d=[],b;[].forEach.call(arguments,function(a,n){d.push(m.approximations.average(a));
b=!b&&"undefined"===typeof d[n]});return b?void 0:d};h=function(d){function b(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;a.graphCollection=void 0;a.graphsenkouSpan=void 0;a.ikhMap=void 0;a.nextPoints=void 0;return a}K(b,d);b.prototype.init=function(){p.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=B({tenkanLine:{styles:{lineColor:this.color}},kijunLine:{styles:{lineColor:this.color}},chikouLine:{styles:{lineColor:this.color}},
senkouSpanA:{styles:{lineColor:this.color,fill:v(this.color).setOpacity(.5).get()}},senkouSpanB:{styles:{lineColor:this.color,fill:v(this.color).setOpacity(.5).get()}},senkouSpan:{styles:{fill:v(this.color).setOpacity(.2).get()}}},this.options)};b.prototype.toYData=function(a){return[a.tenkanSen,a.kijunSen,a.chikouSpan,a.senkouSpanA,a.senkouSpanB]};b.prototype.translate=function(){var a=this;p.seriesTypes.sma.prototype.translate.apply(a);a.points.forEach(function(b){a.pointArrayMap.forEach(function(c){F(b[c])&&
(b["plot"+c]=a.yAxis.toPixels(b[c],!0),b.plotY=b["plot"+c],b.tooltipPos=[b.plotX,b["plot"+c]],b.isNull=!1)})})};b.prototype.drawGraph=function(){var a=this,b=a.points,c=b.length,d=a.options,f=a.graph,z=a.color,m={options:{gapSize:d.gapSize}},l=a.pointArrayMap.length,w=[[],[],[],[],[],[]],e={tenkanLine:w[0],kijunLine:w[1],chikouLine:w[2],senkouSpanA:w[3],senkouSpanB:w[4],senkouSpan:w[5]},h=[],g=a.options.senkouSpan,u=g.color||g.styles.fill,C=g.negativeColor,r=[[],[]],x=[[],[]],y=0,t,v,A;for(a.ikhMap=
e;c--;){var k=b[c];for(t=0;t<l;t++)g=a.pointArrayMap[t],F(k[g])&&w[t].push({plotX:k.plotX,plotY:k["plot"+g],isNull:!1});C&&c!==b.length-1&&(g=e.senkouSpanB.length-1,k=J(e.senkouSpanA[g-1],e.senkouSpanA[g],e.senkouSpanB[g-1],e.senkouSpanB[g]),t={plotX:k.plotX,plotY:k.plotY,isNull:!1,intersectPoint:!0},k&&(e.senkouSpanA.splice(g,0,t),e.senkouSpanB.splice(g,0,t),h.push(g)))}M(e,function(b,c){d[c]&&"senkouSpan"!==c&&(a.points=w[y],a.options=B(d[c].styles,m),a.graph=a["graph"+c],a.fillGraph=!1,a.color=
z,p.seriesTypes.sma.prototype.drawGraph.call(a),a["graph"+c]=a.graph);y++});a.graphCollection&&a.graphCollection.forEach(function(c){a[c].destroy();delete a[c]});a.graphCollection=[];if(C&&e.senkouSpanA[0]&&e.senkouSpanB[0]){h.unshift(0);h.push(e.senkouSpanA.length-1);for(l=0;l<h.length-1;l++){g=h[l];k=h[l+1];c=e.senkouSpanB.slice(g,k+1);g=e.senkouSpanA.slice(g,k+1);if(1<=Math.floor(c.length/2))if(k=Math.floor(c.length/2),c[k].plotY===g[k].plotY){for(A=t=k=0;A<c.length;A++)k+=c[A].plotY,t+=g[A].plotY;
k=k>t?0:1}else k=c[k].plotY>g[k].plotY?0:1;else k=c[0].plotY>g[0].plotY?0:1;r[k]=r[k].concat(c);x[k]=x[k].concat(g)}["graphsenkouSpanColor","graphsenkouSpanNegativeColor"].forEach(function(c,b){r[b].length&&x[b].length&&(v=0===b?u:C,D({indicator:a,points:r[b],nextPoints:x[b],color:v,options:d,gap:m,graph:a[c]}),a[c]=a.graph,a.graphCollection.push(c))})}else D({indicator:a,points:e.senkouSpanB,nextPoints:e.senkouSpanA,color:u,options:d,gap:m,graph:a.graphsenkouSpan}),a.graphsenkouSpan=a.graph;delete a.nextPoints;
delete a.fillGraph;a.points=b;a.options=d;a.graph=f;a.color=z};b.prototype.getGraphPath=function(a){var b=[],c;a=a||this.points;if(this.fillGraph&&this.nextPoints){if((c=p.seriesTypes.sma.prototype.getGraphPath.call(this,this.nextPoints))&&c.length){c[0][0]="L";b=p.seriesTypes.sma.prototype.getGraphPath.call(this,a);c=c.slice(0,b.length);for(var d=c.length-1;0<=d;d--)b.push(c[d])}}else b=p.seriesTypes.sma.prototype.getGraphPath.apply(this,arguments);return b};b.prototype.getValues=function(a,b){var c=
b.period,d=b.periodTenkan;b=b.periodSenkouSpanB;var f=a.xData,h=a.yData,n=h&&h.length||0;a=I(a.xAxis);var l=[],m=[],e;if(!(f.length<=c)&&L(h[0])&&4===h[0].length){var p=f[0]-c*a;for(e=0;e<c;e++)m.push(p+e*a);for(e=0;e<n;e++){if(e>=d){var g=h.slice(e-d,e);g=y(g);g=(g.high+g.low)/2}if(e>=c){var u=h.slice(e-c,e);u=y(u);u=(u.high+u.low)/2;var v=(g+u)/2}if(e>=b){var r=h.slice(e-b,e);r=y(r);r=(r.high+r.low)/2}p=h[e][3];var x=f[e];"undefined"===typeof l[e]&&(l[e]=[]);"undefined"===typeof l[e+c]&&(l[e+c]=
[]);l[e+c][0]=g;l[e+c][1]=u;l[e+c][2]=void 0;l[e][2]=p;e<=c&&(l[e+c][3]=void 0,l[e+c][4]=void 0);"undefined"===typeof l[e+2*c]&&(l[e+2*c]=[]);l[e+2*c][3]=v;l[e+2*c][4]=r;m.push(x)}for(e=1;e<=c;e++)m.push(x+e*a);return{values:l,xData:m,yData:l}}};b.defaultOptions=B(E.defaultOptions,{params:{period:26,periodTenkan:9,periodSenkouSpanB:52},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>TENKAN SEN: {point.tenkanSen:.3f}<br/>KIJUN SEN: {point.kijunSen:.3f}<br/>CHIKOU SPAN: {point.chikouSpan:.3f}<br/>SENKOU SPAN A: {point.senkouSpanA:.3f}<br/>SENKOU SPAN B: {point.senkouSpanB:.3f}<br/>'},
tenkanLine:{styles:{lineWidth:1,lineColor:void 0}},kijunLine:{styles:{lineWidth:1,lineColor:void 0}},chikouLine:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanA:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanB:{styles:{lineWidth:1,lineColor:void 0}},senkouSpan:{styles:{fill:"rgba(255, 0, 0, 0.5)"}},dataGrouping:{approximation:"ichimoku-averages"}});return b}(E);f(h.prototype,{pointArrayMap:["tenkanSen","kijunSen","chikouSpan","senkouSpanA","senkouSpanB"],pointValKey:"tenkanSen",nameComponents:["periodSenkouSpanB",
"period","periodTenkan"]});p.registerSeriesType("ikh",h);"";return h});m(f,"masters/indicators/ichimoku-kinko-hyo.src.js",[],function(){})});
//# sourceMappingURL=ichimoku-kinko-hyo.js.map