/*
 Highstock JS v9.1.1 (2021-06-03)

 Indicator series type for Highcharts Stock

 (c) 2010-2021 Pawel Fus, Sebastian Bochan

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/indicators/indicators",["highcharts","highcharts/modules/stock"],function(b){a(b);a.Highcharts=b;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function b(a,f,e,r){a.hasOwnProperty(f)||(a[f]=r.apply(null,e))}a=a?a._modules:{};b(a,"Mixins/IndicatorRequired.js",[a["Core/Utilities.js"]],function(a){var f=a.error;
return{isParentLoaded:function(a,h,b,l,m){if(a)return l?l(a):!0;f(m||this.generateMessage(b,h));return!1},generateMessage:function(a,h){return'Error: "'+a+'" indicator type requires "'+h+'" indicator loaded before. Please read docs: https://api.highcharts.com/highstock/plotOptions.'+a}}});b(a,"Stock/Indicators/SMA/SMAComposition.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,f){var e=a.series,b=a.seriesTypes.ohlc.prototype;a=f.addEvent;var h=f.extend;a(e,"init",function(a){a=
a.options;a.useOhlcData&&"highcharts-navigator-series"!==a.id&&h(this,{pointValKey:b.pointValKey,pointArrayMap:b.pointArrayMap,toYData:b.toYData})});a(e,"afterSetOptions",function(a){a=a.options;var b=a.dataGrouping;b&&a.useOhlcData&&"highcharts-navigator-series"!==a.id&&(b.approximation="ohlc")})});b(a,"Stock/Indicators/SMA/SMAIndicator.js",[a["Mixins/IndicatorRequired.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,b,e){var f=this&&this.__extends||function(){var a=function(b,
d){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,d){a.__proto__=d}||function(a,d){for(var c in d)d.hasOwnProperty(c)&&(a[c]=d[c])};return a(b,d)};return function(b,d){function g(){this.constructor=b}a(b,d);b.prototype=null===d?Object.create(d):(g.prototype=d.prototype,new g)}}(),h=b.seriesTypes.line,l=e.addEvent,m=e.error,t=e.extend,u=e.isArray,v=e.merge,w=e.pick,x=e.splat,y=a.generateMessage;a=function(a){function e(){var d=null!==a&&a.apply(this,arguments)||this;d.data=void 0;
d.dataEventsToUnbind=void 0;d.linkedParent=void 0;d.options=void 0;d.points=void 0;return d}f(e,a);e.prototype.destroy=function(){this.dataEventsToUnbind.forEach(function(a){a()});a.prototype.destroy.apply(this,arguments)};e.prototype.getName=function(){var a=this.name,b=[];a||((this.nameComponents||[]).forEach(function(a,c){b.push(this.options.params[a]+w(this.nameSuffixes[c],""))},this),a=(this.nameBase||this.type.toUpperCase())+(this.nameComponents?" ("+b.join(", ")+")":""));return a};e.prototype.getValues=
function(a,b){var d=b.period,c=a.xData;a=a.yData;var e=a.length,g=0,f=0,p=[],q=[],h=[],k=-1;if(!(c.length<d)){for(u(a[0])&&(k=b.index?b.index:0);g<d-1;)f+=0>k?a[g]:a[g][k],g++;for(b=g;b<e;b++){f+=0>k?a[b]:a[b][k];var n=[c[b],f/d];p.push(n);q.push(n[0]);h.push(n[1]);f-=0>k?a[b-g]:a[b-g][k]}return{values:p,xData:q,yData:h}}};e.prototype.init=function(b,e){function d(){var a=c.points||[],b=(c.xData||[]).length,d=c.getValues(c.linkedParent,c.options.params)||{values:[],xData:[],yData:[]},e=[],g=!0;if(b&&
!c.hasGroupedData&&c.visible&&c.points)if(c.cropped){if(c.xAxis){var f=c.xAxis.min;var h=c.xAxis.max}b=c.cropData(d.xData,d.yData,f,h);for(f=0;f<b.xData.length;f++)e.push([b.xData[f]].concat(x(b.yData[f])));b=d.xData.indexOf(c.xData[0]);f=d.xData.indexOf(c.xData[c.xData.length-1]);-1===b&&f===d.xData.length-2&&e[0][0]===a[0].x&&e.shift();c.updateData(e)}else d.xData.length!==b-1&&d.xData.length!==b+1&&(g=!1,c.updateData(d.values));g&&(c.xData=d.xData,c.yData=d.yData,c.options.data=d.values);!1===
c.bindTo.series&&(delete c.processedXData,c.isDirty=!0,c.redraw());c.isDirtyData=!1}var c=this,g=c.requireIndicators();if(!g.allLoaded)return m(y(c.type,g.needed));a.prototype.init.call(c,b,e);b.linkSeries();c.dataEventsToUnbind=[];if(!c.linkedParent)return m("Series "+c.options.linkedTo+" not found! Check `linkedTo`.",!1,b);c.dataEventsToUnbind.push(l(c.bindTo.series?c.linkedParent:c.linkedParent.xAxis,c.bindTo.eventName,d));if("init"===c.calculateOn)d();else var f=l(c.chart,c.calculateOn,function(){d();
f()})};e.prototype.processData=function(){var b=this.options.compareToMain,e=this.linkedParent;a.prototype.processData.apply(this,arguments);e&&e.compareValue&&b&&(this.compareValue=e.compareValue)};e.prototype.requireIndicators=function(){var a={allLoaded:!0};this.requiredIndicators.forEach(function(d){b.seriesTypes[d]?b.seriesTypes[d].prototype.requireIndicators():(a.allLoaded=!1,a.needed=d)});return a};e.defaultOptions=v(h.defaultOptions,{name:void 0,tooltip:{valueDecimals:4},linkedTo:void 0,compareToMain:!1,
params:{index:0,period:14}});return e}(h);t(a.prototype,{bindTo:{series:!0,eventName:"updatedData"},calculateOn:"init",hasDerivedData:!0,nameComponents:["period"],nameSuffixes:[],requiredIndicators:[],useCommonDataGrouping:!0});b.registerSeriesType("sma",a);"";return a});b(a,"masters/indicators/indicators.src.js",[],function(){})});
//# sourceMappingURL=indicators.js.map