/*
 Highmaps JS v9.1.1 (2021-06-03)

 Highmaps as a plugin for Highcharts or Highcharts Stock.

 (c) 2011-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
'use strict';(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/modules/map",["highcharts"],function(u){b(u);b.Highcharts=u;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function u(b,d,k,n){b.hasOwnProperty(d)||(b[d]=n.apply(null,k))}b=b?b._modules:{};u(b,"Core/Axis/MapAxis.js",[b["Core/Axis/Axis.js"],b["Core/Utilities.js"]],function(b,d){var k=d.addEvent,n=d.pick,h=function(){return function(b){this.axis=
b}}();d=function(){function b(){}b.compose=function(a){a.keepProps.push("mapAxis");k(a,"init",function(){this.mapAxis||(this.mapAxis=new h(this))});k(a,"getSeriesExtremes",function(){if(this.mapAxis){var a=[];this.isXAxis&&(this.series.forEach(function(f,c){f.useMapGeometry&&(a[c]=f.xData,f.xData=[])}),this.mapAxis.seriesXData=a)}});k(a,"afterGetSeriesExtremes",function(){if(this.mapAxis){var a=this.mapAxis.seriesXData||[],f;if(this.isXAxis){var c=n(this.dataMin,Number.MAX_VALUE);var l=n(this.dataMax,
-Number.MAX_VALUE);this.series.forEach(function(e,m){e.useMapGeometry&&(c=Math.min(c,n(e.minX,c)),l=Math.max(l,n(e.maxX,l)),e.xData=a[m],f=!0)});f&&(this.dataMin=c,this.dataMax=l);this.mapAxis.seriesXData=void 0}}});k(a,"afterSetAxisTranslation",function(){if(this.mapAxis){var a=this.chart,f=a.plotWidth/a.plotHeight;a=a.xAxis[0];var c;"yAxis"===this.coll&&"undefined"!==typeof a.transA&&this.series.forEach(function(a){a.preserveAspectRatio&&(c=!0)});if(c&&(this.transA=a.transA=Math.min(this.transA,
a.transA),f/=(a.max-a.min)/(this.max-this.min),f=1>f?this:a,a=(f.max-f.min)*f.transA,f.mapAxis.pixelPadding=f.len-a,f.minPixelPadding=f.mapAxis.pixelPadding/2,a=f.mapAxis.fixTo)){a=a[1]-f.toValue(a[0],!0);a*=f.transA;if(Math.abs(a)>f.minPixelPadding||f.min===f.dataMin&&f.max===f.dataMax)a=0;f.minPixelPadding-=a}}});k(a,"render",function(){this.mapAxis&&(this.mapAxis.fixTo=void 0)})};return b}();d.compose(b);return d});u(b,"Mixins/ColorSeries.js",[],function(){return{colorPointMixin:{setVisible:function(b){var d=
this,k=b?"show":"hide";d.visible=d.options.visible=!!b;["graphic","dataLabel"].forEach(function(b){if(d[b])d[b][k]()});this.series.buildKDTree()}},colorSeriesMixin:{optionalAxis:"colorAxis",colorAxis:0,translateColors:function(){var b=this,d=this.options.nullColor,k=this.colorAxis,n=this.colorKey;(this.data.length?this.data:this.points).forEach(function(h){var p=h.getNestedProperty(n);(p=h.options.color||(h.isNull||null===h.value?d:k&&"undefined"!==typeof p?k.toColor(p,h):h.color||b.color))&&h.color!==
p&&(h.color=p,"point"===b.options.legendType&&h.legendItem&&b.chart.legend.colorizeItem(h,h.visible))})}}}});u(b,"Core/Axis/ColorAxis.js",[b["Core/Axis/Axis.js"],b["Core/Chart/Chart.js"],b["Core/Color/Color.js"],b["Mixins/ColorSeries.js"],b["Core/Animation/Fx.js"],b["Core/Globals.js"],b["Core/Legend.js"],b["Mixins/LegendSymbol.js"],b["Core/Color/Palette.js"],b["Core/Series/Point.js"],b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,d,k,n,h,p,a,m,f,c,l,e){var C=this&&this.__extends||function(){var g=
function(a,e){g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(g,t){g.__proto__=t}||function(g,t){for(var a in t)t.hasOwnProperty(a)&&(g[a]=t[a])};return g(a,e)};return function(a,e){function c(){this.constructor=a}g(a,e);a.prototype=null===e?Object.create(e):(c.prototype=e.prototype,new c)}}(),A=k.parse;k=n.colorPointMixin;n=n.colorSeriesMixin;var z=p.noop,D=e.addEvent,B=e.extend,x=e.isNumber,E=e.merge,r=e.pick,q=e.splat;"";B(l.prototype,n);B(c.prototype,k);d.prototype.collectionsWithUpdate.push("colorAxis");
d.prototype.collectionsWithInit.colorAxis=[d.prototype.addColorAxis];var g=function(g){function a(a,e){var t=g.call(this,a,e)||this;t.beforePadding=!1;t.chart=void 0;t.coll="colorAxis";t.dataClasses=void 0;t.legendItem=void 0;t.legendItems=void 0;t.name="";t.options=void 0;t.stops=void 0;t.visible=!0;t.init(a,e);return t}C(a,g);a.prototype.init=function(e,c){var t=e.options.legend||{},y=c.layout?"vertical"!==c.layout:"vertical"!==t.layout;t=E(a.defaultColorAxisOptions,c,{showEmpty:!1,title:null,visible:t.enabled&&
(c?!1!==c.visible:!0)});this.coll="colorAxis";this.side=c.side||y?2:1;this.reversed=c.reversed||!y;this.opposite=!y;g.prototype.init.call(this,e,t);c.dataClasses&&this.initDataClasses(c);this.initStops();this.horiz=y;this.zoomEnabled=!1};a.prototype.initDataClasses=function(a){var g=this.chart,t,e=0,c=g.options.chart.colorCount,q=this.options,f=a.dataClasses.length;this.dataClasses=t=[];this.legendItems=[];a.dataClasses.forEach(function(a,y){a=E(a);t.push(a);if(g.styledMode||!a.color)"category"===
q.dataClassColor?(g.styledMode||(y=g.options.colors,c=y.length,a.color=y[e]),a.colorIndex=e,e++,e===c&&(e=0)):a.color=A(q.minColor).tweenTo(A(q.maxColor),2>f?.5:y/(f-1))})};a.prototype.hasData=function(){return!!(this.tickPositions||[]).length};a.prototype.setTickPositions=function(){if(!this.dataClasses)return g.prototype.setTickPositions.call(this)};a.prototype.initStops=function(){this.stops=this.options.stops||[[0,this.options.minColor],[1,this.options.maxColor]];this.stops.forEach(function(a){a.color=
A(a[1])})};a.prototype.setOptions=function(a){g.prototype.setOptions.call(this,a);this.options.crosshair=this.options.marker};a.prototype.setAxisSize=function(){var g=this.legendSymbol,e=this.chart,t=e.options.legend||{},c,q;g?(this.left=t=g.attr("x"),this.top=c=g.attr("y"),this.width=q=g.attr("width"),this.height=g=g.attr("height"),this.right=e.chartWidth-t-q,this.bottom=e.chartHeight-c-g,this.len=this.horiz?q:g,this.pos=this.horiz?t:c):this.len=(this.horiz?t.symbolWidth:t.symbolHeight)||a.defaultLegendLength};
a.prototype.normalizedValue=function(a){this.logarithmic&&(a=this.logarithmic.log2lin(a));return 1-(this.max-a)/(this.max-this.min||1)};a.prototype.toColor=function(a,g){var t=this.dataClasses,e=this.stops,c;if(t)for(c=t.length;c--;){var q=t[c];var f=q.from;e=q.to;if(("undefined"===typeof f||a>=f)&&("undefined"===typeof e||a<=e)){var l=q.color;g&&(g.dataClass=c,g.colorIndex=q.colorIndex);break}}else{a=this.normalizedValue(a);for(c=e.length;c--&&!(a>e[c][0]););f=e[c]||e[c+1];e=e[c+1]||f;a=1-(e[0]-
a)/(e[0]-f[0]||1);l=f.color.tweenTo(e.color,a)}return l};a.prototype.getOffset=function(){var a=this.legendGroup,e=this.chart.axisOffset[this.side];a&&(this.axisParent=a,g.prototype.getOffset.call(this),this.added||(this.added=!0,this.labelLeft=0,this.labelRight=this.width),this.chart.axisOffset[this.side]=e)};a.prototype.setLegendColor=function(){var a=this.reversed,g=a?1:0;a=a?0:1;g=this.horiz?[g,0,a,0]:[0,a,0,g];this.legendColor={linearGradient:{x1:g[0],y1:g[1],x2:g[2],y2:g[3]},stops:this.stops}};
a.prototype.drawLegendSymbol=function(g,e){var t=g.padding,c=g.options,q=this.horiz,f=r(c.symbolWidth,q?a.defaultLegendLength:12),l=r(c.symbolHeight,q?12:a.defaultLegendLength),v=r(c.labelPadding,q?16:30);c=r(c.itemDistance,10);this.setLegendColor();e.legendSymbol=this.chart.renderer.rect(0,g.baseline-11,f,l).attr({zIndex:1}).add(e.legendGroup);this.legendItemWidth=f+t+(q?c:v);this.legendItemHeight=l+t+(q?v:0)};a.prototype.setState=function(a){this.series.forEach(function(g){g.setState(a)})};a.prototype.setVisible=
function(){};a.prototype.getSeriesExtremes=function(){var a=this.series,g=a.length,e;this.dataMin=Infinity;for(this.dataMax=-Infinity;g--;){var c=a[g];var q=c.colorKey=r(c.options.colorKey,c.colorKey,c.pointValKey,c.zoneAxis,"y");var f=c.pointArrayMap;var v=c[q+"Min"]&&c[q+"Max"];if(c[q+"Data"])var b=c[q+"Data"];else if(f){b=[];f=f.indexOf(q);var m=c.yData;if(0<=f&&m)for(e=0;e<m.length;e++)b.push(r(m[e][f],m[e]))}else b=c.yData;v?(c.minColorValue=c[q+"Min"],c.maxColorValue=c[q+"Max"]):(b=l.prototype.getExtremes.call(c,
b),c.minColorValue=b.dataMin,c.maxColorValue=b.dataMax);"undefined"!==typeof c.minColorValue&&(this.dataMin=Math.min(this.dataMin,c.minColorValue),this.dataMax=Math.max(this.dataMax,c.maxColorValue));v||l.prototype.applyExtremes.call(c)}};a.prototype.drawCrosshair=function(a,c){var e=c&&c.plotX,q=c&&c.plotY,f=this.pos,l=this.len;if(c){var b=this.toPixels(c.getNestedProperty(c.series.colorKey));b<f?b=f-2:b>f+l&&(b=f+l+2);c.plotX=b;c.plotY=this.len-b;g.prototype.drawCrosshair.call(this,a,c);c.plotX=
e;c.plotY=q;this.cross&&!this.cross.addedToColorAxis&&this.legendGroup&&(this.cross.addClass("highcharts-coloraxis-marker").add(this.legendGroup),this.cross.addedToColorAxis=!0,this.chart.styledMode||"object"!==typeof this.crosshair||this.cross.attr({fill:this.crosshair.color}))}};a.prototype.getPlotLinePath=function(a){var c=this.left,e=a.translatedValue,q=this.top;return x(e)?this.horiz?[["M",e-4,q-6],["L",e+4,q-6],["L",e,q],["Z"]]:[["M",c,e],["L",c-6,e+6],["L",c-6,e-6],["Z"]]:g.prototype.getPlotLinePath.call(this,
a)};a.prototype.update=function(a,c){var e=this.chart.legend;this.series.forEach(function(a){a.isDirtyData=!0});(a.dataClasses&&e.allItems||this.dataClasses)&&this.destroyItems();g.prototype.update.call(this,a,c);this.legendItem&&(this.setLegendColor(),e.colorizeItem(this,!0))};a.prototype.destroyItems=function(){var a=this.chart;this.legendItem?a.legend.destroyItem(this):this.legendItems&&this.legendItems.forEach(function(c){a.legend.destroyItem(c)});a.isDirtyLegend=!0};a.prototype.destroy=function(){this.chart.isDirtyLegend=
!0;this.destroyItems();g.prototype.destroy.apply(this,[].slice.call(arguments))};a.prototype.remove=function(a){this.destroyItems();g.prototype.remove.call(this,a)};a.prototype.getDataClassLegendSymbols=function(){var a=this,c=a.chart,g=a.legendItems,e=c.options.legend,q=e.valueDecimals,f=e.valueSuffix||"",l;g.length||a.dataClasses.forEach(function(e,t){var b=!0,v=e.from,r=e.to,y=c.numberFormatter;l="";"undefined"===typeof v?l="< ":"undefined"===typeof r&&(l="> ");"undefined"!==typeof v&&(l+=y(v,
q)+f);"undefined"!==typeof v&&"undefined"!==typeof r&&(l+=" - ");"undefined"!==typeof r&&(l+=y(r,q)+f);g.push(B({chart:c,name:l,options:{},drawLegendSymbol:m.drawRectangle,visible:!0,setState:z,isDataClass:!0,setVisible:function(){b=a.visible=!b;a.series.forEach(function(a){a.points.forEach(function(a){a.dataClass===t&&a.setVisible(b)})});c.legend.colorizeItem(this,b)}},e))});return g};a.defaultLegendLength=200;a.defaultColorAxisOptions={lineWidth:0,minPadding:0,maxPadding:0,gridLineWidth:1,tickPixelInterval:72,
startOnTick:!0,endOnTick:!0,offset:0,marker:{animation:{duration:50},width:.01,color:f.neutralColor40},labels:{overflow:"justify",rotation:0},minColor:f.highlightColor10,maxColor:f.highlightColor100,tickLength:5,showInLegend:!0};a.keepProps=["legendGroup","legendItemHeight","legendItemWidth","legendItem","legendSymbol"];return a}(b);Array.prototype.push.apply(b.keepProps,g.keepProps);p.ColorAxis=g;["fill","stroke"].forEach(function(a){h.prototype[a+"Setter"]=function(){this.elem.attr(a,A(this.start).tweenTo(A(this.end),
this.pos),null,!0)}});D(d,"afterGetAxes",function(){var a=this,c=a.options;this.colorAxis=[];c.colorAxis&&(c.colorAxis=q(c.colorAxis),c.colorAxis.forEach(function(c,e){c.index=e;new g(a,c)}))});D(l,"bindAxes",function(){var a=this.axisTypes;a?-1===a.indexOf("colorAxis")&&a.push("colorAxis"):this.axisTypes=["colorAxis"]});D(a,"afterGetAllItems",function(a){var c=this,g=[],e,q,f=function(g){g=a.allItems.indexOf(g);-1!==g&&(c.destroyItem(a.allItems[g]),a.allItems.splice(g,1))};(this.chart.colorAxis||
[]).forEach(function(a){(e=a.options)&&e.showInLegend&&(e.dataClasses&&e.visible?g=g.concat(a.getDataClassLegendSymbols()):e.visible&&g.push(a),a.series.forEach(function(a){if(!a.options.showInLegend||e.dataClasses)"point"===a.options.legendType?a.points.forEach(function(a){f(a)}):f(a)}))});for(q=g.length;q--;)a.allItems.unshift(g[q])});D(a,"afterColorizeItem",function(a){a.visible&&a.item.legendColor&&a.item.legendSymbol.attr({fill:a.item.legendColor})});D(a,"afterUpdate",function(){var a=this.chart.colorAxis;
a&&a.forEach(function(a,c,g){a.update({},g)})});D(l,"afterTranslate",function(){(this.chart.colorAxis&&this.chart.colorAxis.length||this.colorAttribs)&&this.translateColors()});return g});u(b,"Mixins/ColorMapSeries.js",[b["Core/Globals.js"],b["Core/Series/Point.js"],b["Core/Utilities.js"]],function(b,d,k){var n=k.defined;k=k.addEvent;var h=b.noop;b=b.seriesTypes;k(d,"afterSetState",function(b){this.moveToTopOnHover&&this.graphic&&this.graphic.attr({zIndex:b&&"hover"===b.state?1:0})});return{colorMapPointMixin:{dataLabelOnNull:!0,
moveToTopOnHover:!0,isValid:function(){return null!==this.value&&Infinity!==this.value&&-Infinity!==this.value}},colorMapSeriesMixin:{pointArrayMap:["value"],axisTypes:["xAxis","yAxis","colorAxis"],trackerGroups:["group","markerGroup","dataLabelsGroup"],getSymbol:h,parallelArrays:["x","y","value"],colorKey:"value",pointAttribs:b.column.prototype.pointAttribs,colorAttribs:function(b){var a={};!n(b.color)||b.state&&"normal"!==b.state||(a[this.colorProp||"fill"]=b.color);return a}}}});u(b,"Maps/MapNavigationOptionsDefault.js",
[b["Core/DefaultOptions.js"],b["Core/Utilities.js"]],function(b,d){d=d.extend;var k={buttonOptions:{alignTo:"plotBox",align:"left",verticalAlign:"top",x:0,width:18,height:18,padding:5,style:{fontSize:"15px",fontWeight:"bold"},theme:{"stroke-width":1,"text-align":"center"}},buttons:{zoomIn:{onclick:function(){this.mapZoom(.5)},text:"+",y:0},zoomOut:{onclick:function(){this.mapZoom(2)},text:"-",y:28}},mouseWheelSensitivity:1.1};d(b.defaultOptions.lang,{zoomIn:"Zoom in",zoomOut:"Zoom out"});return b.defaultOptions.mapNavigation=
k});u(b,"Maps/MapNavigation.js",[b["Core/Chart/Chart.js"],b["Core/Globals.js"],b["Core/Utilities.js"]],function(b,d,k){function n(a){a&&(a.preventDefault&&a.preventDefault(),a.stopPropagation&&a.stopPropagation(),a.cancelBubble=!0)}function h(a){this.init(a)}var p=d.doc,a=k.addEvent,m=k.extend,f=k.merge,c=k.objectEach,l=k.pick;h.prototype.init=function(a){this.chart=a;a.mapNavButtons=[]};h.prototype.update=function(e){var b=this.chart,k=b.options.mapNavigation,d,h,p,z,E=function(a){this.handler.call(b,
a);n(a)},r=b.mapNavButtons;e&&(k=b.options.mapNavigation=f(b.options.mapNavigation,e));for(;r.length;)r.pop().destroy();l(k.enableButtons,k.enabled)&&!b.renderer.forExport&&c(k.buttons,function(c,g){c=f(k.buttonOptions,c);!b.styledMode&&c.theme&&(d=c.theme,d.style=f(c.theme.style,c.style),p=(h=d.states)&&h.hover,z=h&&h.select,delete d.states);var e=b.renderer.button(c.text||"",0,0,E,d,p,z,void 0,"zoomIn"===g?"topbutton":"bottombutton").addClass("highcharts-map-navigation highcharts-"+{zoomIn:"zoom-in",
zoomOut:"zoom-out"}[g]).attr({width:c.width,height:c.height,title:b.options.lang[g],padding:c.padding,zIndex:5}).add();e.handler=c.onclick;a(e.element,"dblclick",n);r.push(e);m(c,{width:e.width,height:2*e.height});if(b.hasLoaded)e.align(c,!1,c.alignTo);else var q=a(b,"load",function(){e.element&&e.align(c,!1,c.alignTo);q()})});this.updateEvents(k)};h.prototype.updateEvents=function(c){var e=this.chart;l(c.enableDoubleClickZoom,c.enabled)||c.enableDoubleClickZoomTo?this.unbindDblClick=this.unbindDblClick||
a(e.container,"dblclick",function(a){e.pointer.onContainerDblClick(a)}):this.unbindDblClick&&(this.unbindDblClick=this.unbindDblClick());l(c.enableMouseWheelZoom,c.enabled)?this.unbindMouseWheel=this.unbindMouseWheel||a(e.container,void 0!==p.onwheel?"wheel":void 0!==p.onmousewheel?"mousewheel":"DOMMouseScroll",function(a){e.pointer.inClass(a.target,"highcharts-no-mousewheel")||(e.pointer.onContainerMouseWheel(a),n(a));return!1}):this.unbindMouseWheel&&(this.unbindMouseWheel=this.unbindMouseWheel())};
m(b.prototype,{fitToBox:function(a,c){[["x","width"],["y","height"]].forEach(function(e){var b=e[0];e=e[1];a[b]+a[e]>c[b]+c[e]&&(a[e]>c[e]?(a[e]=c[e],a[b]=c[b]):a[b]=c[b]+c[e]-a[e]);a[e]>c[e]&&(a[e]=c[e]);a[b]<c[b]&&(a[b]=c[b])});return a},mapZoom:function(a,c,b,f,m,k){var e=this.xAxis[0],d=e.max-e.min,r=l(c,e.min+d/2),q=d*a;d=this.yAxis[0];var g=d.max-d.min,v=l(b,d.min+g/2);g*=a;r=this.fitToBox({x:r-q*(f?(f-e.pos)/e.len:.5),y:v-g*(m?(m-d.pos)/d.len:.5),width:q,height:g},{x:e.dataMin,y:d.dataMin,
width:e.dataMax-e.dataMin,height:d.dataMax-d.dataMin});q=r.x<=e.dataMin&&r.width>=e.dataMax-e.dataMin&&r.y<=d.dataMin&&r.height>=d.dataMax-d.dataMin;f&&e.mapAxis&&(e.mapAxis.fixTo=[f-e.pos,c]);m&&d.mapAxis&&(d.mapAxis.fixTo=[m-d.pos,b]);"undefined"===typeof a||q?(e.setExtremes(void 0,void 0,!1),d.setExtremes(void 0,void 0,!1)):(e.setExtremes(r.x,r.x+r.width,!1),d.setExtremes(r.y,r.y+r.height,!1));this.redraw(k)}});a(b,"beforeRender",function(){this.mapNavigation=new h(this);this.mapNavigation.update()});
d.MapNavigation=h});u(b,"Maps/MapPointer.js",[b["Core/Pointer.js"],b["Core/Utilities.js"]],function(b,d){var k=d.extend,n=d.pick;d=d.wrap;var h=0,p;k(b.prototype,{onContainerDblClick:function(a){var b=this.chart;a=this.normalize(a);b.options.mapNavigation.enableDoubleClickZoomTo?b.pointer.inClass(a.target,"highcharts-tracker")&&b.hoverPoint&&b.hoverPoint.zoomTo():b.isInsidePlot(a.chartX-b.plotLeft,a.chartY-b.plotTop)&&b.mapZoom(.5,b.xAxis[0].toValue(a.chartX),b.yAxis[0].toValue(a.chartY),a.chartX,
a.chartY)},onContainerMouseWheel:function(a){var b=this.chart;a=this.normalize(a);var f=a.deltaY||a.detail||-(a.wheelDelta/120);1<=Math.abs(f)&&(h+=Math.abs(f),p&&clearTimeout(p),p=setTimeout(function(){h=0},50));10>h&&b.isInsidePlot(a.chartX-b.plotLeft,a.chartY-b.plotTop)&&b.mapZoom(Math.pow(b.options.mapNavigation.mouseWheelSensitivity,f),b.xAxis[0].toValue(a.chartX),b.yAxis[0].toValue(a.chartY),a.chartX,a.chartY,1>Math.abs(f)?!1:void 0)}});d(b.prototype,"zoomOption",function(a){var b=this.chart.options.mapNavigation;
n(b.enableTouchZoom,b.enabled)&&(this.chart.options.chart.pinchType="xy");a.apply(this,[].slice.call(arguments,1))});d(b.prototype,"pinchTranslate",function(a,b,f,c,l,e,d){a.call(this,b,f,c,l,e,d);"map"===this.chart.options.chart.type&&this.hasZoom&&(a=c.scaleX>c.scaleY,this.pinchTranslateDirection(!a,b,f,c,l,e,d,a?c.scaleX:c.scaleY))})});u(b,"Maps/MapSymbols.js",[b["Core/Renderer/SVG/SVGRenderer.js"]],function(b){function d(b,d,h,p,a,m,f,c){return[["M",b+a,d],["L",b+h-m,d],["C",b+h-m/2,d,b+h,d+m/
2,b+h,d+m],["L",b+h,d+p-f],["C",b+h,d+p-f/2,b+h-f/2,d+p,b+h-f,d+p],["L",b+c,d+p],["C",b+c/2,d+p,b,d+p-c/2,b,d+p-c],["L",b,d+a],["C",b,d+a/2,b+a/2,d,b+a,d],["Z"]]}b=b.prototype.symbols;b.bottombutton=function(b,n,h,p,a){a=a&&a.r||0;return d(b-1,n-1,h,p,0,0,a,a)};b.topbutton=function(b,n,h,p,a){a=a&&a.r||0;return d(b-1,n-1,h,p,a,a,0,0)};return b});u(b,"Core/Chart/MapChart.js",[b["Core/Chart/Chart.js"],b["Core/DefaultOptions.js"],b["Core/Renderer/SVG/SVGRenderer.js"],b["Core/Utilities.js"]],function(b,
d,k,n){var h=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(c,b)};return function(c,b){function e(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):(e.prototype=b.prototype,new e)}}(),p=d.getOptions,a=n.merge,m=n.pick;b=function(b){function c(){return null!==b&&b.apply(this,arguments)||this}h(c,b);c.prototype.init=function(c,
e){var f={endOnTick:!1,visible:!1,minPadding:0,maxPadding:0,startOnTick:!1},l=p().credits;c=a({chart:{panning:{enabled:!0,type:"xy"},type:"map"},credits:{mapText:m(l.mapText,' \u00a9 <a href="{geojson.copyrightUrl}">{geojson.copyrightShort}</a>'),mapTextFull:m(l.mapTextFull,"{geojson.copyright}")},tooltip:{followTouchMove:!1},xAxis:f,yAxis:a(f,{reversed:!0})},c,{chart:{inverted:!1,alignTicks:!1}});b.prototype.init.call(this,c,e)};return c}(b);(function(a){a.maps={};a.mapChart=function(c,b,e){return new a(c,
b,e)};a.splitPath=function(a){"string"===typeof a&&(a=a.replace(/([A-Za-z])/g," $1 ").replace(/^\s*/,"").replace(/\s*$/,""),a=a.split(/[ ,;]+/).map(function(a){return/[A-za-z]/.test(a)?a:parseFloat(a)}));return k.prototype.pathToSegments(a)}})(b||(b={}));return b});u(b,"Series/Map/MapPoint.js",[b["Mixins/ColorMapSeries.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,d,k){var n=this&&this.__extends||function(){var b=function(a,d){b=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return b(a,d)};return function(a,d){function f(){this.constructor=a}b(a,d);a.prototype=null===d?Object.create(d):(f.prototype=d.prototype,new f)}}();b=b.colorMapPointMixin;var h=k.extend;d=function(b){function a(){var a=null!==b&&b.apply(this,arguments)||this;a.options=void 0;a.path=void 0;a.series=void 0;return a}n(a,b);a.prototype.applyOptions=function(a,f){var c=this.series;a=b.prototype.applyOptions.call(this,
a,f);f=c.joinBy;c.mapData&&c.mapMap&&(f=b.prototype.getNestedProperty.call(a,f[1]),(f="undefined"!==typeof f&&c.mapMap[f])?(c.xyFromShape&&(a.x=f._midX,a.y=f._midY),h(a,f)):a.value=a.value||null);return a};a.prototype.onMouseOver=function(a){k.clearTimeout(this.colorInterval);if(null!==this.value||this.series.options.nullInteraction)b.prototype.onMouseOver.call(this,a);else this.series.onMouseOut(a)};a.prototype.zoomTo=function(){var a=this.series;a.xAxis.setExtremes(this._minX,this._maxX,!1);a.yAxis.setExtremes(this._minY,
this._maxY,!1);a.chart.redraw()};return a}(d.seriesTypes.scatter.prototype.pointClass);h(d.prototype,{dataLabelOnNull:b.dataLabelOnNull,isValid:b.isValid,moveToTopOnHover:b.moveToTopOnHover});return d});u(b,"Series/Map/MapSeries.js",[b["Mixins/ColorMapSeries.js"],b["Core/Globals.js"],b["Mixins/LegendSymbol.js"],b["Core/Chart/MapChart.js"],b["Series/Map/MapPoint.js"],b["Core/Color/Palette.js"],b["Core/Series/Series.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Renderer/SVG/SVGRenderer.js"],b["Core/Utilities.js"]],
function(b,d,k,n,h,p,a,m,f,c){var l=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function g(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(g.prototype=c.prototype,new g)}}();b=b.colorMapSeriesMixin;var e=d.noop,C=n.maps,A=n.splitPath;n=m.seriesTypes;var z=n.column,D=n.scatter;n=c.extend;
var B=c.fireEvent,x=c.getNestedProperty,E=c.isArray,r=c.isNumber,q=c.merge,g=c.objectEach,v=c.pick,w=c.splat;c=function(b){function c(){var a=null!==b&&b.apply(this,arguments)||this;a.baseTrans=void 0;a.chart=void 0;a.data=void 0;a.group=void 0;a.joinBy=void 0;a.options=void 0;a.points=void 0;a.transformGroup=void 0;return a}l(c,b);c.prototype.animate=function(a){var c=this.options.animation,b=this.group,g=this.xAxis,e=this.yAxis,q=g.pos,f=e.pos;this.chart.renderer.isSVG&&(!0===c&&(c={duration:1E3}),
a?b.attr({translateX:q+g.len/2,translateY:f+e.len/2,scaleX:.001,scaleY:.001}):b.animate({translateX:q,translateY:f,scaleX:1,scaleY:1},c))};c.prototype.animateDrilldown=function(a){var c=this.chart.plotBox,b=this.chart.drilldownLevels[this.chart.drilldownLevels.length-1],g=b.bBox,e=this.chart.options.drilldown.animation;a||(a=Math.min(g.width/c.width,g.height/c.height),b.shapeArgs={scaleX:a,scaleY:a,translateX:g.x,translateY:g.y},this.points.forEach(function(a){a.graphic&&a.graphic.attr(b.shapeArgs).animate({scaleX:1,
scaleY:1,translateX:0,translateY:0},e)}))};c.prototype.animateDrillupFrom=function(a){z.prototype.animateDrillupFrom.call(this,a)};c.prototype.animateDrillupTo=function(a){z.prototype.animateDrillupTo.call(this,a)};c.prototype.doFullTranslate=function(){return this.isDirtyData||this.chart.isResizing||this.chart.renderer.isVML||!this.baseTrans};c.prototype.drawMapDataLabels=function(){a.prototype.drawDataLabels.call(this);this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)};c.prototype.drawPoints=
function(){var a=this,c=a.xAxis,b=a.yAxis,g=a.group,e=a.chart,q=e.renderer,f=this.baseTrans;a.transformGroup||(a.transformGroup=q.g().attr({scaleX:1,scaleY:1}).add(g),a.transformGroup.survive=!0);if(a.doFullTranslate())e.hasRendered&&!e.styledMode&&a.points.forEach(function(c){c.shapeArgs&&(c.shapeArgs.fill=a.pointAttribs(c,c.state).fill)}),a.group=a.transformGroup,z.prototype.drawPoints.apply(a),a.group=g,a.points.forEach(function(c){if(c.graphic){var b="";c.name&&(b+="highcharts-name-"+c.name.replace(/ /g,
"-").toLowerCase());c.properties&&c.properties["hc-key"]&&(b+=" highcharts-key-"+c.properties["hc-key"].toLowerCase());b&&c.graphic.addClass(b);e.styledMode&&c.graphic.css(a.pointAttribs(c,c.selected&&"select"||void 0))}}),this.baseTrans={originX:c.min-c.minPixelPadding/c.transA,originY:b.min-b.minPixelPadding/b.transA+(b.reversed?0:b.len/b.transA),transAX:c.transA,transAY:b.transA},this.transformGroup.animate({translateX:0,translateY:0,scaleX:1,scaleY:1});else{var r=c.transA/f.transAX;var l=b.transA/
f.transAY;var d=c.toPixels(f.originX,!0);var h=b.toPixels(f.originY,!0);.99<r&&1.01>r&&.99<l&&1.01>l&&(l=r=1,d=Math.round(d),h=Math.round(h));var w=this.transformGroup;if(e.renderer.globalAnimation){var m=w.attr("translateX");var k=w.attr("translateY");var F=w.attr("scaleX");var p=w.attr("scaleY");w.attr({animator:0}).animate({animator:1},{step:function(a,c){w.attr({translateX:m+(d-m)*c.pos,translateY:k+(h-k)*c.pos,scaleX:F+(r-F)*c.pos,scaleY:p+(l-p)*c.pos})}})}else w.attr({translateX:d,translateY:h,
scaleX:r,scaleY:l})}e.styledMode||g.element.setAttribute("stroke-width",v(a.options[a.pointAttrToOptions&&a.pointAttrToOptions["stroke-width"]||"borderWidth"],1)/(r||1));this.drawMapDataLabels()};c.prototype.getBox=function(a){var c=Number.MAX_VALUE,b=-c,g=c,e=-c,q=c,r=c,l=this.xAxis,d=this.yAxis,t;(a||[]).forEach(function(a){if(a.path){"string"===typeof a.path?a.path=A(a.path):"M"===a.path[0]&&(a.path=f.prototype.pathToSegments(a.path));var l=a.path||[],d=-c,h=c,w=-c,m=c,y=a.properties;a._foundBox||
(l.forEach(function(a){var c=a[a.length-2];a=a[a.length-1];"number"===typeof c&&"number"===typeof a&&(h=Math.min(h,c),d=Math.max(d,c),m=Math.min(m,a),w=Math.max(w,a))}),a._midX=h+(d-h)*v(a.middleX,y&&y["hc-middle-x"],.5),a._midY=m+(w-m)*v(a.middleY,y&&y["hc-middle-y"],.5),a._maxX=d,a._minX=h,a._maxY=w,a._minY=m,a.labelrank=v(a.labelrank,(d-h)*(w-m)),a._foundBox=!0);b=Math.max(b,a._maxX);g=Math.min(g,a._minX);e=Math.max(e,a._maxY);q=Math.min(q,a._minY);r=Math.min(a._maxX-a._minX,a._maxY-a._minY,r);
t=!0}});t&&(this.minY=Math.min(q,v(this.minY,c)),this.maxY=Math.max(e,v(this.maxY,-c)),this.minX=Math.min(g,v(this.minX,c)),this.maxX=Math.max(b,v(this.maxX,-c)),l&&"undefined"===typeof l.options.minRange&&(l.minRange=Math.min(5*r,(this.maxX-this.minX)/5,l.minRange||c)),d&&"undefined"===typeof d.options.minRange&&(d.minRange=Math.min(5*r,(this.maxY-this.minY)/5,d.minRange||c)))};c.prototype.getExtremes=function(){var c=a.prototype.getExtremes.call(this,this.valueData),b=c.dataMin;c=c.dataMax;this.chart.hasRendered&&
this.isDirtyData&&this.getBox(this.options.data);r(b)&&(this.valueMin=b);r(c)&&(this.valueMax=c);return{dataMin:this.minY,dataMax:this.maxY}};c.prototype.hasData=function(){return!!this.processedXData.length};c.prototype.pointAttribs=function(a,c){c=a.series.chart.styledMode?this.colorAttribs(a):z.prototype.pointAttribs.call(this,a,c);c["stroke-width"]=v(a.options[this.pointAttrToOptions&&this.pointAttrToOptions["stroke-width"]||"borderWidth"],"inherit");return c};c.prototype.render=function(){var c=
this,b=a.prototype.render;c.chart.renderer.isVML&&3E3<c.data.length?setTimeout(function(){b.call(c)}):b.call(c)};c.prototype.setData=function(c,b,e,f){var l=this.options,v=this.chart.options.chart,t=v&&v.map,w=l.mapData,m=this.joinBy,k=l.keys||this.pointArrayMap,F=[],p={},y=this.chart.mapTransforms;!w&&t&&(w="string"===typeof t?C[t]:t);c&&c.forEach(function(a,b){var g=0;if(r(a))c[b]={value:a};else if(E(a)){c[b]={};!l.keys&&a.length>k.length&&"string"===typeof a[0]&&(c[b]["hc-key"]=a[0],++g);for(var e=
0;e<k.length;++e,++g)k[e]&&"undefined"!==typeof a[g]&&(0<k[e].indexOf(".")?h.prototype.setNestedProperty(c[b],a[g],k[e]):c[b][k[e]]=a[g])}m&&"_i"===m[0]&&(c[b]._i=b)});this.getBox(c);(this.chart.mapTransforms=y=v.mapTransforms||w&&w["hc-transform"]||y)&&g(y,function(a){a.rotation&&(a.cosAngle=Math.cos(a.rotation),a.sinAngle=Math.sin(a.rotation))});if(w){"FeatureCollection"===w.type&&(this.mapTitle=w.title,w=d.geojson(w,this.type,this));this.mapData=w;this.mapMap={};for(y=0;y<w.length;y++)v=w[y],t=
v.properties,v._i=y,m[0]&&t&&t[m[0]]&&(v[m[0]]=t[m[0]]),p[v[m[0]]]=v;this.mapMap=p;if(c&&m[1]){var n=m[1];c.forEach(function(a){a=x(n,a);p[a]&&F.push(p[a])})}if(l.allAreas){this.getBox(w);c=c||[];if(m[1]){var H=m[1];c.forEach(function(a){F.push(x(H,a))})}F="|"+F.map(function(a){return a&&a[m[0]]}).join("|")+"|";w.forEach(function(a){m[0]&&-1!==F.indexOf("|"+a[m[0]]+"|")||(c.push(q(a,{value:null})),f=!1)})}else this.getBox(F)}a.prototype.setData.call(this,c,b,e,f)};c.prototype.setOptions=function(c){c=
a.prototype.setOptions.call(this,c);var b=c.joinBy;null===b&&(b="_i");b=this.joinBy=w(b);b[1]||(b[1]=b[0]);return c};c.prototype.translate=function(){var a=this,c=a.xAxis,b=a.yAxis,g=a.doFullTranslate();a.generatePoints();a.data.forEach(function(e){r(e._midX)&&r(e._midY)&&(e.plotX=c.toPixels(e._midX,!0),e.plotY=b.toPixels(e._midY,!0));g&&(e.shapeType="path",e.shapeArgs={d:a.translatePath(e.path)})});B(a,"afterTranslate")};c.prototype.translatePath=function(a){var c=this.xAxis,b=this.yAxis,e=c.min,
g=c.transA,q=c.minPixelPadding,f=b.min,l=b.transA,r=b.minPixelPadding,d=[];a&&a.forEach(function(a){"M"===a[0]?d.push(["M",(a[1]-(e||0))*g+q,(a[2]-(f||0))*l+r]):"L"===a[0]?d.push(["L",(a[1]-(e||0))*g+q,(a[2]-(f||0))*l+r]):"C"===a[0]?d.push(["C",(a[1]-(e||0))*g+q,(a[2]-(f||0))*l+r,(a[3]-(e||0))*g+q,(a[4]-(f||0))*l+r,(a[5]-(e||0))*g+q,(a[6]-(f||0))*l+r]):"Q"===a[0]?d.push(["Q",(a[1]-(e||0))*g+q,(a[2]-(f||0))*l+r,(a[3]-(e||0))*g+q,(a[4]-(f||0))*l+r]):"Z"===a[0]&&d.push(["Z"])});return d};c.defaultOptions=
q(D.defaultOptions,{animation:!1,dataLabels:{crop:!1,formatter:function(){return this.point.value},inside:!0,overflow:!1,padding:0,verticalAlign:"middle"},marker:null,nullColor:p.neutralColor3,stickyTracking:!1,tooltip:{followPointer:!0,pointFormat:"{point.name}: {point.value}<br/>"},turboThreshold:0,allAreas:!0,borderColor:p.neutralColor20,borderWidth:1,joinBy:"hc-key",states:{hover:{halo:null,brightness:.2},normal:{animation:!0},select:{color:p.neutralColor20},inactive:{opacity:1}}});return c}(D);
n(c.prototype,{type:"map",axisTypes:b.axisTypes,colorAttribs:b.colorAttribs,colorKey:b.colorKey,directTouch:!0,drawDataLabels:e,drawGraph:e,drawLegendSymbol:k.drawRectangle,forceDL:!0,getExtremesFromAll:!0,getSymbol:b.getSymbol,parallelArrays:b.parallelArrays,pointArrayMap:b.pointArrayMap,pointClass:h,preserveAspectRatio:!0,searchPoint:e,trackerGroups:b.trackerGroups,useMapGeometry:!0});m.registerSeriesType("map",c);"";return c});u(b,"Series/MapLine/MapLineSeries.js",[b["Series/Map/MapSeries.js"],
b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,d,k){var n=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(b,c)};return function(b,c){function f(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(f.prototype=c.prototype,new f)}}(),h=d.series,p=k.extend,a=k.merge;k=function(d){function f(){var a=null!==
d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}n(f,d);f.prototype.pointAttribs=function(a,f){a=b.prototype.pointAttribs.call(this,a,f);a.fill=this.options.fillColor;return a};f.defaultOptions=a(b.defaultOptions,{lineWidth:1,fillColor:"none"});return f}(b);p(k.prototype,{type:"mapline",colorProp:"stroke",drawLegendSymbol:h.prototype.drawLegendSymbol,pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"}});d.registerSeriesType("mapline",k);"";return k});
u(b,"Series/MapPoint/MapPointPoint.js",[b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,d){var k=this&&this.__extends||function(){var b=function(d,a){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return b(d,a)};return function(d,a){function h(){this.constructor=d}b(d,a);d.prototype=null===a?Object.create(a):(h.prototype=a.prototype,new h)}}(),n=d.merge;return function(b){function d(){var a=
null!==b&&b.apply(this,arguments)||this;a.options=void 0;a.series=void 0;return a}k(d,b);d.prototype.applyOptions=function(a,d){a="undefined"!==typeof a.lat&&"undefined"!==typeof a.lon?n(a,this.series.chart.fromLatLonToPoint(a)):a;return b.prototype.applyOptions.call(this,a,d)};return d}(b.seriesTypes.scatter.prototype.pointClass)});u(b,"Series/MapPoint/MapPointSeries.js",[b["Series/MapPoint/MapPointPoint.js"],b["Core/Color/Palette.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,
d,k,n){var h=this&&this.__extends||function(){var a=function(c,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(c,b)};return function(c,b){function e(){this.constructor=c}a(c,b);c.prototype=null===b?Object.create(b):(e.prototype=b.prototype,new e)}}(),p=k.seriesTypes.scatter,a=n.extend,m=n.merge;n=function(a){function c(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=
void 0;c.points=void 0;return c}h(c,a);c.prototype.drawDataLabels=function(){a.prototype.drawDataLabels.call(this);this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)};c.defaultOptions=m(p.defaultOptions,{dataLabels:{crop:!1,defer:!1,enabled:!0,formatter:function(){return this.point.name},overflow:!1,style:{color:d.neutralColor100}}});return c}(p);a(n.prototype,{type:"mappoint",forceDL:!0,pointClass:b});k.registerSeriesType("mappoint",n);"";return n});u(b,"Series/Bubble/BubblePoint.js",
[b["Core/Series/Point.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,d,k){var n=this&&this.__extends||function(){var b=function(d,a){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return b(d,a)};return function(d,a){function h(){this.constructor=d}b(d,a);d.prototype=null===a?Object.create(a):(h.prototype=a.prototype,new h)}}();k=k.extend;d=function(d){function h(){var a=
null!==d&&d.apply(this,arguments)||this;a.options=void 0;a.series=void 0;return a}n(h,d);h.prototype.haloPath=function(a){return b.prototype.haloPath.call(this,0===a?0:(this.marker?this.marker.radius||0:0)+a)};return h}(d.seriesTypes.scatter.prototype.pointClass);k(d.prototype,{ttBelow:!1});return d});u(b,"Series/Bubble/BubbleLegend.js",[b["Core/Chart/Chart.js"],b["Core/Color/Color.js"],b["Core/FormatUtilities.js"],b["Core/Globals.js"],b["Core/Legend.js"],b["Core/DefaultOptions.js"],b["Core/Color/Palette.js"],
b["Core/Series/Series.js"],b["Core/Utilities.js"]],function(b,d,k,n,h,p,a,m,f){var c=d.parse,l=n.noop;p=p.setOptions;d=f.addEvent;var e=f.arrayMax,C=f.arrayMin,A=f.isNumber,z=f.merge,D=f.objectEach,B=f.pick,x=f.stableSort;f=f.wrap;"";p({legend:{bubbleLegend:{borderColor:void 0,borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,connectorWidth:1,enabled:!1,labels:{className:void 0,allowOverlap:!1,format:"",formatter:void 0,align:"right",
style:{fontSize:"10px",color:a.neutralColor100},x:0,y:0},maxSize:60,minSize:10,legendIndex:0,ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0}}});a=function(){function a(a,b){this.options=this.symbols=this.visible=this.ranges=this.movementX=this.maxLabel=this.legendSymbol=this.legendItemWidth=this.legendItemHeight=this.legendItem=this.legendGroup=this.legend=this.fontMetrics=this.chart=void 0;this.setState=l;this.init(a,
b)}a.prototype.init=function(a,b){this.options=a;this.visible=!0;this.chart=b.chart;this.legend=b};a.prototype.addToLegend=function(a){a.splice(this.options.legendIndex,0,this)};a.prototype.drawLegendSymbol=function(a){var b=this.chart,c=this.options,e=B(a.options.itemDistance,20),d=c.ranges;var f=c.connectorDistance;this.fontMetrics=b.renderer.fontMetrics(c.labels.style.fontSize);d&&d.length&&A(d[0].value)?(x(d,function(a,b){return b.value-a.value}),this.ranges=d,this.setOptions(),this.render(),
b=this.getMaxLabelSize(),d=this.ranges[0].radius,a=2*d,f=f-d+b.width,f=0<f?f:0,this.maxLabel=b,this.movementX="left"===c.labels.align?f:0,this.legendItemWidth=a+f+e,this.legendItemHeight=a+this.fontMetrics.h/2):a.options.bubbleLegend.autoRanges=!0};a.prototype.setOptions=function(){var a=this.ranges,b=this.options,g=this.chart.series[b.seriesIndex],e=this.legend.baseline,d={zIndex:b.zIndex,"stroke-width":b.borderWidth},f={zIndex:b.zIndex,"stroke-width":b.connectorWidth},l={align:this.legend.options.rtl||
"left"===b.labels.align?"right":"left",zIndex:b.zIndex},t=g.options.marker.fillOpacity,h=this.chart.styledMode;a.forEach(function(q,r){h||(d.stroke=B(q.borderColor,b.borderColor,g.color),d.fill=B(q.color,b.color,1!==t?c(g.color).setOpacity(t).get("rgba"):g.color),f.stroke=B(q.connectorColor,b.connectorColor,g.color));a[r].radius=this.getRangeRadius(q.value);a[r]=z(a[r],{center:a[0].radius-a[r].radius+e});h||z(!0,a[r],{bubbleAttribs:z(d),connectorAttribs:z(f),labelAttribs:l})},this)};a.prototype.getRangeRadius=
function(a){var b=this.options;return this.chart.series[this.options.seriesIndex].getRadius.call(this,b.ranges[b.ranges.length-1].value,b.ranges[0].value,b.minSize,b.maxSize,a)};a.prototype.render=function(){var a=this.chart.renderer,b=this.options.zThreshold;this.symbols||(this.symbols={connectors:[],bubbleItems:[],labels:[]});this.legendSymbol=a.g("bubble-legend");this.legendItem=a.g("bubble-legend-item");this.legendSymbol.translateX=0;this.legendSymbol.translateY=0;this.ranges.forEach(function(a){a.value>=
b&&this.renderRange(a)},this);this.legendSymbol.add(this.legendItem);this.legendItem.add(this.legendGroup);this.hideOverlappingLabels()};a.prototype.renderRange=function(a){var b=this.options,c=b.labels,e=this.chart,d=e.series[b.seriesIndex],f=e.renderer,l=this.symbols;e=l.labels;var r=a.center,h=Math.abs(a.radius),k=b.connectorDistance||0,m=c.align;k=this.legend.options.rtl||"left"===m?-k:k;var n=b.connectorWidth,p=this.ranges[0].radius||0,E=r-h-b.borderWidth/2+n/2,C=this.fontMetrics;C=C.f/2-(C.h-
C.f)/2;var A=f.styledMode;"center"===m&&(k=0,b.connectorDistance=0,a.labelAttribs.align="center");m=E+b.labels.y;var x=p+k+b.labels.x;l.bubbleItems.push(f.circle(p,r+((E%1?1:.5)-(n%2?0:.5)),h).attr(A?{}:a.bubbleAttribs).addClass((A?"highcharts-color-"+d.colorIndex+" ":"")+"highcharts-bubble-legend-symbol "+(b.className||"")).add(this.legendSymbol));l.connectors.push(f.path(f.crispLine([["M",p,E],["L",p+k,E]],b.connectorWidth)).attr(A?{}:a.connectorAttribs).addClass((A?"highcharts-color-"+this.options.seriesIndex+
" ":"")+"highcharts-bubble-legend-connectors "+(b.connectorClassName||"")).add(this.legendSymbol));a=f.text(this.formatLabel(a),x,m+C).attr(A?{}:a.labelAttribs).css(A?{}:c.style).addClass("highcharts-bubble-legend-labels "+(b.labels.className||"")).add(this.legendSymbol);e.push(a);a.placed=!0;a.alignAttr={x:x,y:m+C}};a.prototype.getMaxLabelSize=function(){var a,b;this.symbols.labels.forEach(function(c){b=c.getBBox(!0);a=a?b.width>a.width?b:a:b});return a||{}};a.prototype.formatLabel=function(a){var b=
this.options,c=b.labels.formatter;b=b.labels.format;var e=this.chart.numberFormatter;return b?k.format(b,a):c?c.call(a):e(a.value,1)};a.prototype.hideOverlappingLabels=function(){var a=this.chart,b=this.symbols;!this.options.labels.allowOverlap&&b&&(a.hideOverlappingLabels(b.labels),b.labels.forEach(function(a,c){a.newOpacity?a.newOpacity!==a.oldOpacity&&b.connectors[c].show():b.connectors[c].hide()}))};a.prototype.getRanges=function(){var a=this.legend.bubbleLegend,b=a.options.ranges,c,d=Number.MAX_VALUE,
f=-Number.MAX_VALUE;a.chart.series.forEach(function(a){a.isBubble&&!a.ignoreSeries&&(c=a.zData.filter(A),c.length&&(d=B(a.options.zMin,Math.min(d,Math.max(C(c),!1===a.options.displayNegative?a.options.zThreshold:-Number.MAX_VALUE))),f=B(a.options.zMax,Math.max(f,e(c)))))});var l=d===f?[{value:f}]:[{value:d},{value:(d+f)/2},{value:f,autoRanges:!0}];b.length&&b[0].radius&&l.reverse();l.forEach(function(a,c){b&&b[c]&&(l[c]=z(b[c],a))});return l};a.prototype.predictBubbleSizes=function(){var a=this.chart,
b=this.fontMetrics,c=a.legend.options,e="horizontal"===c.layout,d=e?a.legend.lastLineHeight:0,f=a.plotSizeX,l=a.plotSizeY,h=a.series[this.options.seriesIndex];a=Math.ceil(h.minPxSize);var k=Math.ceil(h.maxPxSize);h=h.options.maxSize;var m=Math.min(l,f);if(c.floating||!/%$/.test(h))b=k;else if(h=parseFloat(h),b=(m+d-b.h/2)*h/100/(h/100+1),e&&l-b>=f||!e&&f-b>=l)b=k;return[a,Math.ceil(b)]};a.prototype.updateRanges=function(a,b){var c=this.legend.options.bubbleLegend;c.minSize=a;c.maxSize=b;c.ranges=
this.getRanges()};a.prototype.correctSizes=function(){var a=this.legend,b=this.chart.series[this.options.seriesIndex];1<Math.abs(Math.ceil(b.maxPxSize)-this.options.maxSize)&&(this.updateRanges(this.options.minSize,b.maxPxSize),a.render())};return a}();d(h,"afterGetAllItems",function(a){var b=this.bubbleLegend,c=this.options,e=c.bubbleLegend,d=this.chart.getVisibleBubbleSeriesIndex();b&&b.ranges&&b.ranges.length&&(e.ranges.length&&(e.autoRanges=!!e.ranges[0].autoRanges),this.destroyItem(b));0<=d&&
c.enabled&&e.enabled&&(e.seriesIndex=d,this.bubbleLegend=new n.BubbleLegend(e,this),this.bubbleLegend.addToLegend(a.allItems))});b.prototype.getVisibleBubbleSeriesIndex=function(){for(var a=this.series,b=0;b<a.length;){if(a[b]&&a[b].isBubble&&a[b].visible&&a[b].zData.length)return b;b++}return-1};h.prototype.getLinesHeights=function(){var a=this.allItems,b=[],c=a.length,e,d=0;for(e=0;e<c;e++)if(a[e].legendItemHeight&&(a[e].itemHeight=a[e].legendItemHeight),a[e]===a[c-1]||a[e+1]&&a[e]._legendItemPos[1]!==
a[e+1]._legendItemPos[1]){b.push({height:0});var f=b[b.length-1];for(d;d<=e;d++)a[d].itemHeight>f.height&&(f.height=a[d].itemHeight);f.step=e}return b};h.prototype.retranslateItems=function(a){var b,c,e,d=this.options.rtl,f=0;this.allItems.forEach(function(g,l){b=g.legendGroup.translateX;c=g._legendItemPos[1];if((e=g.movementX)||d&&g.ranges)e=d?b-g.options.maxSize/2:b+e,g.legendGroup.attr({translateX:e});l>a[f].step&&f++;g.legendGroup.attr({translateY:Math.round(c+a[f].height/2)});g._legendItemPos[1]=
c+a[f].height/2})};d(m,"legendItemClick",function(){var a=this.chart,b=this.visible,c=this.chart.legend;c&&c.bubbleLegend&&(this.visible=!b,this.ignoreSeries=b,a=0<=a.getVisibleBubbleSeriesIndex(),c.bubbleLegend.visible!==a&&(c.update({bubbleLegend:{enabled:a}}),c.bubbleLegend.visible=a),this.visible=b)});f(b.prototype,"drawChartBox",function(a,b,c){var e=this.legend,d=0<=this.getVisibleBubbleSeriesIndex();if(e&&e.options.enabled&&e.bubbleLegend&&e.options.bubbleLegend.autoRanges&&d){var f=e.bubbleLegend.options;
d=e.bubbleLegend.predictBubbleSizes();e.bubbleLegend.updateRanges(d[0],d[1]);f.placed||(e.group.placed=!1,e.allItems.forEach(function(a){a.legendGroup.translateY=null}));e.render();this.getMargins();this.axes.forEach(function(a){a.visible&&a.render();f.placed||(a.setScale(),a.updateNames(),D(a.ticks,function(a){a.isNew=!0;a.isNewLabel=!0}))});f.placed=!0;this.getMargins();a.call(this,b,c);e.bubbleLegend.correctSizes();e.retranslateItems(e.getLinesHeights())}else a.call(this,b,c),e&&e.options.enabled&&
e.bubbleLegend&&(e.render(),e.retranslateItems(e.getLinesHeights()))});n.BubbleLegend=a;return n.BubbleLegend});u(b,"Series/Bubble/BubbleSeries.js",[b["Core/Axis/Axis.js"],b["Series/Bubble/BubblePoint.js"],b["Core/Color/Color.js"],b["Core/Globals.js"],b["Core/Series/Series.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,d,k,n,h,p,a){var m=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=
b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function e(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(e.prototype=c.prototype,new e)}}(),f=k.parse;k=n.noop;var c=p.seriesTypes;n=c.column;var l=c.scatter,e=a.arrayMax,C=a.arrayMin,A=a.clamp,z=a.extend,D=a.isNumber,B=a.merge,x=a.pick,E=a.pInt;a=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.maxPxSize=void 0;b.minPxSize=void 0;b.options=
void 0;b.points=void 0;b.radii=void 0;b.yData=void 0;b.zData=void 0;return b}m(b,a);b.prototype.animate=function(a){!a&&this.points.length<this.options.animationLimit&&this.points.forEach(function(a){var b=a.graphic;b&&b.width&&(this.hasRendered||b.attr({x:a.plotX,y:a.plotY,width:1,height:1}),b.animate(this.markerAttribs(a),this.options.animation))},this)};b.prototype.getRadii=function(a,b,c){var e=this.zData,d=this.yData,f=c.minPxSize,g=c.maxPxSize,l=[];var h=0;for(c=e.length;h<c;h++){var q=e[h];
l.push(this.getRadius(a,b,f,g,q,d[h]))}this.radii=l};b.prototype.getRadius=function(a,b,c,e,d,f){var g=this.options,l="width"!==g.sizeBy,h=g.zThreshold,q=b-a,k=.5;if(null===f||null===d)return null;if(D(d)){g.sizeByAbsoluteValue&&(d=Math.abs(d-h),q=Math.max(b-h,Math.abs(a-h)),a=0);if(d<a)return c/2-1;0<q&&(k=(d-a)/q)}l&&0<=k&&(k=Math.sqrt(k));return Math.ceil(c+k*(e-c))/2};b.prototype.hasData=function(){return!!this.processedXData.length};b.prototype.pointAttribs=function(a,b){var c=this.options.marker.fillOpacity;
a=h.prototype.pointAttribs.call(this,a,b);1!==c&&(a.fill=f(a.fill).setOpacity(c).get("rgba"));return a};b.prototype.translate=function(){var b,c=this.data,e=this.radii;a.prototype.translate.call(this);for(b=c.length;b--;){var d=c[b];var f=e?e[b]:0;D(f)&&f>=this.minPxSize/2?(d.marker=z(d.marker,{radius:f,width:2*f,height:2*f}),d.dlBox={x:d.plotX-f,y:d.plotY-f,width:2*f,height:2*f}):d.shapeArgs=d.plotY=d.dlBox=void 0}};b.defaultOptions=B(l.defaultOptions,{dataLabels:{formatter:function(){return this.point.z},
inside:!0,verticalAlign:"middle"},animationLimit:250,marker:{lineColor:null,lineWidth:1,fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},turboThreshold:0,zThreshold:0,zoneAxis:"z"});return b}(l);z(a.prototype,{alignDataLabel:n.prototype.alignDataLabel,applyZones:k,bubblePadding:!0,buildKDTree:k,directTouch:!0,isBubble:!0,pointArrayMap:["y",
"z"],pointClass:d,parallelArrays:["x","y","z"],trackerGroups:["group","dataLabelsGroup"],specialGroup:"group",zoneAxis:"z"});b.prototype.beforePadding=function(){var a=this,b=this.len,c=this.chart,d=0,f=b,l=this.isXAxis,h=l?"xData":"yData",k=this.min,m={},n=Math.min(c.plotWidth,c.plotHeight),p=Number.MAX_VALUE,z=-Number.MAX_VALUE,B=this.max-k,u=b/B,G=[];this.series.forEach(function(b){var d=b.options;!b.bubblePadding||!b.visible&&c.options.chart.ignoreHiddenSeries||(a.allowZoomOutside=!0,G.push(b),
l&&(["minSize","maxSize"].forEach(function(a){var b=d[a],c=/%$/.test(b);b=E(b);m[a]=c?n*b/100:b}),b.minPxSize=m.minSize,b.maxPxSize=Math.max(m.maxSize,m.minSize),b=b.zData.filter(D),b.length&&(p=x(d.zMin,A(C(b),!1===d.displayNegative?d.zThreshold:-Number.MAX_VALUE,p)),z=x(d.zMax,Math.max(z,e(b))))))});G.forEach(function(b){var c=b[h],e=c.length;l&&b.getRadii(p,z,b);if(0<B)for(;e--;)if(D(c[e])&&a.dataMin<=c[e]&&c[e]<=a.max){var g=b.radii?b.radii[e]:0;d=Math.min((c[e]-k)*u-g,d);f=Math.max((c[e]-k)*
u+g,f)}});G.length&&0<B&&!this.logarithmic&&(f-=b,u*=(b+Math.max(0,d)-Math.min(f,b))/b,[["min","userMin",d],["max","userMax",f]].forEach(function(b){"undefined"===typeof x(a.options[b[0]],a[b[1]])&&(a[b[0]]+=b[2]/u)}))};p.registerSeriesType("bubble",a);"";"";return a});u(b,"Series/MapBubble/MapBubblePoint.js",[b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,d){var k=this&&this.__extends||function(){var a=function(b,d){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&
function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,d)};return function(b,d){function c(){this.constructor=b}a(b,d);b.prototype=null===d?Object.create(d):(c.prototype=d.prototype,new c)}}(),n=b.seriesTypes,h=n.map;b=d.extend;var p=d.merge;d=function(a){function b(){return null!==a&&a.apply(this,arguments)||this}k(b,a);b.prototype.applyOptions=function(b,c){return b&&"undefined"!==typeof b.lat&&"undefined"!==typeof b.lon?a.prototype.applyOptions.call(this,
p(b,this.series.chart.fromLatLonToPoint(b)),c):h.prototype.pointClass.prototype.applyOptions.call(this,b,c)};b.prototype.isValid=function(){return"number"===typeof this.z};return b}(n.bubble.prototype.pointClass);b(d.prototype,{ttBelow:!1});return d});u(b,"Series/MapBubble/MapBubbleSeries.js",[b["Series/Bubble/BubbleSeries.js"],b["Series/MapBubble/MapBubblePoint.js"],b["Series/Map/MapSeries.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,d,k,n,h){var p=this&&this.__extends||
function(){var a=function(b,d){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,d)};return function(b,d){function c(){this.constructor=b}a(b,d);b.prototype=null===d?Object.create(d):(c.prototype=d.prototype,new c)}}(),a=h.extend,m=h.merge;h=function(a){function c(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}p(c,a);c.defaultOptions=
m(b.defaultOptions,{animationLimit:500,tooltip:{pointFormat:"{point.name}: {point.z}"}});return c}(b);a(h.prototype,{type:"mapbubble",getBox:k.prototype.getBox,pointArrayMap:["z"],pointClass:d,setData:k.prototype.setData,setOptions:k.prototype.setOptions,xyFromShape:!0});n.registerSeriesType("mapbubble",h);"";return h});u(b,"Series/Heatmap/HeatmapPoint.js",[b["Mixins/ColorMapSeries.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Utilities.js"]],function(b,d,k){var n=this&&this.__extends||function(){var a=
function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}();b=b.colorMapPointMixin;var h=k.clamp,p=k.extend,a=k.pick;d=function(b){function d(){var a=null!==b&&b.apply(this,arguments)||this;a.options=void 0;a.series=void 0;a.value=void 0;a.x=void 0;
a.y=void 0;return a}n(d,b);d.prototype.applyOptions=function(a,d){a=b.prototype.applyOptions.call(this,a,d);a.formatPrefix=a.isNull||null===a.value?"null":"point";return a};d.prototype.getCellAttributes=function(){var b=this.series,d=b.options,e=(d.colsize||1)/2,f=(d.rowsize||1)/2,k=b.xAxis,m=b.yAxis,n=this.options.marker||b.options.marker;b=b.pointPlacementToXValue();var p=a(this.pointPadding,d.pointPadding,0),x={x1:h(Math.round(k.len-(k.translate(this.x-e,!1,!0,!1,!0,-b)||0)),-k.len,2*k.len),x2:h(Math.round(k.len-
(k.translate(this.x+e,!1,!0,!1,!0,-b)||0)),-k.len,2*k.len),y1:h(Math.round(m.translate(this.y-f,!1,!0,!1,!0)||0),-m.len,2*m.len),y2:h(Math.round(m.translate(this.y+f,!1,!0,!1,!0)||0),-m.len,2*m.len)};[["width","x"],["height","y"]].forEach(function(a){var b=a[0];a=a[1];var c=a+"1",e=a+"2",d=Math.abs(x[c]-x[e]),f=n&&n.lineWidth||0,l=Math.abs(x[c]+x[e])/2;n[b]&&n[b]<d&&(x[c]=l-n[b]/2-f/2,x[e]=l+n[b]/2+f/2);p&&("y"===a&&(c=e,e=a+"1"),x[c]+=p,x[e]-=p)});return x};d.prototype.haloPath=function(a){if(!a)return[];
var b=this.shapeArgs;return["M",b.x-a,b.y-a,"L",b.x-a,b.y+b.height+a,b.x+b.width+a,b.y+b.height+a,b.x+b.width+a,b.y-a,"Z"]};d.prototype.isValid=function(){return Infinity!==this.value&&-Infinity!==this.value};return d}(d.seriesTypes.scatter.prototype.pointClass);p(d.prototype,{dataLabelOnNull:b.dataLabelOnNull,moveToTopOnHover:b.moveToTopOnHover});return d});u(b,"Series/Heatmap/HeatmapSeries.js",[b["Core/Color/Color.js"],b["Mixins/ColorMapSeries.js"],b["Series/Heatmap/HeatmapPoint.js"],b["Mixins/LegendSymbol.js"],
b["Core/Color/Palette.js"],b["Core/Series/SeriesRegistry.js"],b["Core/Renderer/SVG/SVGRenderer.js"],b["Core/Utilities.js"]],function(b,d,k,n,h,p,a,m){var f=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function e(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(e.prototype=c.prototype,new e)}}();
d=d.colorMapSeriesMixin;var c=p.series,l=p.seriesTypes,e=l.column,C=l.scatter,A=a.prototype.symbols,z=m.extend,u=m.fireEvent,B=m.isNumber,x=m.merge,E=m.pick;a=function(a){function e(){var b=null!==a&&a.apply(this,arguments)||this;b.colorAxis=void 0;b.data=void 0;b.options=void 0;b.points=void 0;b.valueMax=NaN;b.valueMin=NaN;return b}f(e,a);e.prototype.drawPoints=function(){var a=this;if((this.options.marker||{}).enabled||this._hasPointMarkers)c.prototype.drawPoints.call(this),this.points.forEach(function(b){b.graphic&&
(b.graphic[a.chart.styledMode?"css":"animate"](a.colorAttribs(b)),a.options.borderRadius&&b.graphic.attr({r:a.options.borderRadius}),null===b.value&&b.graphic.addClass("highcharts-null-point"))})};e.prototype.getExtremes=function(){var a=c.prototype.getExtremes.call(this,this.valueData),b=a.dataMin;a=a.dataMax;B(b)&&(this.valueMin=b);B(a)&&(this.valueMax=a);return c.prototype.getExtremes.call(this)};e.prototype.getValidPoints=function(a,b){return c.prototype.getValidPoints.call(this,a,b,!0)};e.prototype.hasData=
function(){return!!this.processedXData.length};e.prototype.init=function(){c.prototype.init.apply(this,arguments);var a=this.options;a.pointRange=E(a.pointRange,a.colsize||1);this.yAxis.axisPointRange=a.rowsize||1;A.ellipse=A.circle};e.prototype.markerAttribs=function(a,b){var c=a.marker||{},e=this.options.marker||{},d=a.shapeArgs||{},f={};if(a.hasImage)return{x:a.plotX,y:a.plotY};if(b){var g=e.states[b]||{};var l=c.states&&c.states[b]||{};[["width","x"],["height","y"]].forEach(function(a){f[a[0]]=
(l[a[0]]||g[a[0]]||d[a[0]])+(l[a[0]+"Plus"]||g[a[0]+"Plus"]||0);f[a[1]]=d[a[1]]+(d[a[0]]-f[a[0]])/2})}return b?f:d};e.prototype.pointAttribs=function(a,e){var d=c.prototype.pointAttribs.call(this,a,e),f=this.options||{},g=this.chart.options.plotOptions||{},l=g.series||{},h=g.heatmap||{};g=f.borderColor||h.borderColor||l.borderColor;l=f.borderWidth||h.borderWidth||l.borderWidth||d["stroke-width"];d.stroke=a&&a.marker&&a.marker.lineColor||f.marker&&f.marker.lineColor||g||this.color;d["stroke-width"]=
l;e&&(a=x(f.states[e],f.marker&&f.marker.states[e],a&&a.options.states&&a.options.states[e]||{}),e=a.brightness,d.fill=a.color||b.parse(d.fill).brighten(e||0).get(),d.stroke=a.lineColor);return d};e.prototype.setClip=function(a){var b=this.chart;c.prototype.setClip.apply(this,arguments);(!1!==this.options.clip||a)&&this.markerGroup.clip((a||this.clipBox)&&this.sharedClipKey?b.sharedClips[this.sharedClipKey]:b.clipRect)};e.prototype.translate=function(){var a=this.options,b=a.marker&&a.marker.symbol||
"rect",c=A[b]?b:"rect",e=-1!==["circle","square"].indexOf(c);this.generatePoints();this.points.forEach(function(a){var d=a.getCellAttributes(),f={};f.x=Math.min(d.x1,d.x2);f.y=Math.min(d.y1,d.y2);f.width=Math.max(Math.abs(d.x2-d.x1),0);f.height=Math.max(Math.abs(d.y2-d.y1),0);var l=a.hasImage=0===(a.marker&&a.marker.symbol||b||"").indexOf("url");if(e){var g=Math.abs(f.width-f.height);f.x=Math.min(d.x1,d.x2)+(f.width<f.height?0:g/2);f.y=Math.min(d.y1,d.y2)+(f.width<f.height?g/2:0);f.width=f.height=
Math.min(f.width,f.height)}g={plotX:(d.x1+d.x2)/2,plotY:(d.y1+d.y2)/2,clientX:(d.x1+d.x2)/2,shapeType:"path",shapeArgs:x(!0,f,{d:A[c](f.x,f.y,f.width,f.height)})};l&&(a.marker={width:f.width,height:f.height});z(a,g)});u(this,"afterTranslate")};e.defaultOptions=x(C.defaultOptions,{animation:!1,borderRadius:0,borderWidth:0,nullColor:h.neutralColor3,dataLabels:{formatter:function(){return this.point.value},inside:!0,verticalAlign:"middle",crop:!1,overflow:!1,padding:0},marker:{symbol:"rect",radius:0,
lineColor:void 0,states:{hover:{lineWidthPlus:0},select:{}}},clip:!0,pointRange:null,tooltip:{pointFormat:"{point.x}, {point.y}: {point.value}<br/>"},states:{hover:{halo:!1,brightness:.2}}});return e}(C);z(a.prototype,{alignDataLabel:e.prototype.alignDataLabel,axisTypes:d.axisTypes,colorAttribs:d.colorAttribs,colorKey:d.colorKey,directTouch:!0,drawLegendSymbol:n.drawRectangle,getExtremesFromAll:!0,getSymbol:c.prototype.getSymbol,parallelArrays:d.parallelArrays,pointArrayMap:["y","value"],pointClass:k,
trackerGroups:d.trackerGroups});p.registerSeriesType("heatmap",a);"";"";return a});u(b,"Extensions/GeoJSON.js",[b["Core/Chart/Chart.js"],b["Core/FormatUtilities.js"],b["Core/Globals.js"],b["Core/Utilities.js"]],function(b,d,k,n){function h(a,b){var c,e=!1,d=a.x,f=a.y;a=0;for(c=b.length-1;a<b.length;c=a++){var l=b[a][1]>f;var h=b[c][1]>f;l!==h&&d<(b[c][0]-b[a][0])*(f-b[a][1])/(b[c][1]-b[a][1])+b[a][0]&&(e=!e)}return e}var p=d.format,a=k.win,m=n.error,f=n.extend,c=n.merge;d=n.wrap;"";b.prototype.transformFromLatLon=
function(b,c){var e=this.userOptions.chart&&this.userOptions.chart.proj4||a.proj4;if(!e)return m(21,!1,this),{x:0,y:null};b=e(c.crs,[b.lon,b.lat]);e=c.cosAngle||c.rotation&&Math.cos(c.rotation);var d=c.sinAngle||c.rotation&&Math.sin(c.rotation);b=c.rotation?[b[0]*e+b[1]*d,-b[0]*d+b[1]*e]:b;return{x:((b[0]-(c.xoffset||0))*(c.scale||1)+(c.xpan||0))*(c.jsonres||1)+(c.jsonmarginX||0),y:(((c.yoffset||0)-b[1])*(c.scale||1)+(c.ypan||0))*(c.jsonres||1)-(c.jsonmarginY||0)}};b.prototype.transformToLatLon=function(b,
c){if("undefined"===typeof a.proj4)m(21,!1,this);else{b={x:((b.x-(c.jsonmarginX||0))/(c.jsonres||1)-(c.xpan||0))/(c.scale||1)+(c.xoffset||0),y:((-b.y-(c.jsonmarginY||0))/(c.jsonres||1)+(c.ypan||0))/(c.scale||1)+(c.yoffset||0)};var e=c.cosAngle||c.rotation&&Math.cos(c.rotation),d=c.sinAngle||c.rotation&&Math.sin(c.rotation);c=a.proj4(c.crs,"WGS84",c.rotation?{x:b.x*e+b.y*-d,y:b.x*d+b.y*e}:b);return{lat:c.y,lon:c.x}}};b.prototype.fromPointToLatLon=function(a){var b=this.mapTransforms,c;if(b){for(c in b)if(Object.hasOwnProperty.call(b,
c)&&b[c].hitZone&&h({x:a.x,y:-a.y},b[c].hitZone.coordinates[0]))return this.transformToLatLon(a,b[c]);return this.transformToLatLon(a,b["default"])}m(22,!1,this)};b.prototype.fromLatLonToPoint=function(a){var b=this.mapTransforms,c;if(!b)return m(22,!1,this),{x:0,y:null};for(c in b)if(Object.hasOwnProperty.call(b,c)&&b[c].hitZone){var d=this.transformFromLatLon(a,b[c]);if(h({x:d.x,y:-d.y},b[c].hitZone.coordinates[0]))return d}return this.transformFromLatLon(a,b["default"])};k.geojson=function(a,b,
c){var d=[],e=[],h=function(a){a.forEach(function(a,b){0===b?e.push(["M",a[0],-a[1]]):e.push(["L",a[0],-a[1]])})};b=b||"map";a.features.forEach(function(a){var c=a.geometry,k=c.type;c=c.coordinates;a=a.properties;var l;e=[];"map"===b||"mapbubble"===b?("Polygon"===k?(c.forEach(h),e.push(["Z"])):"MultiPolygon"===k&&(c.forEach(function(a){a.forEach(h)}),e.push(["Z"])),e.length&&(l={path:e})):"mapline"===b?("LineString"===k?h(c):"MultiLineString"===k&&c.forEach(h),e.length&&(l={path:e})):"mappoint"===
b&&"Point"===k&&(l={x:c[0],y:-c[1]});l&&d.push(f(l,{name:a.name||a.NAME,properties:a}))});c&&a.copyrightShort&&(c.chart.mapCredits=p(c.chart.options.credits.mapText,{geojson:a}),c.chart.mapCreditsFull=p(c.chart.options.credits.mapTextFull,{geojson:a}));return d};d(b.prototype,"addCredits",function(a,b){b=c(!0,this.options.credits,b);this.mapCredits&&(b.href=null);a.call(this,b);this.credits&&this.mapCreditsFull&&this.credits.attr({title:this.mapCreditsFull})})});u(b,"masters/modules/map.src.js",[b["Core/Globals.js"],
b["Core/Chart/MapChart.js"]],function(b,d){b.MapChart=d;b.mapChart=b.Map=d.mapChart;b.maps=d.maps})});
//# sourceMappingURL=map.js.map