/*
 Highstock JS v9.1.1 (2021-06-03)

 Highcharts Stock as a plugin for Highcharts

 (c) 2010-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
'use strict';(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(I){a(I);a.Highcharts=I;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function I(a,v,x,r){a.hasOwnProperty(v)||(a[v]=r.apply(null,x))}a=a?a._modules:{};I(a,"Core/Axis/NavigatorAxis.js",[a["Core/Globals.js"],a["Core/Utilities.js"]],function(a,v){var x=a.isTouchDevice,r=v.addEvent,
n=v.correctFloat,H=v.defined,w=v.isNumber,D=v.pick,d=function(){function b(b){this.axis=b}b.prototype.destroy=function(){this.axis=void 0};b.prototype.toFixedRange=function(b,d,a,P){var J=this.axis,g=J.chart;g=g&&g.fixedRange;var Q=(J.pointRange||0)/2;b=D(a,J.translate(b,!0,!J.horiz));d=D(P,J.translate(d,!0,!J.horiz));J=g&&(d-b)/g;H(a)||(b=n(b+Q));H(P)||(d=n(d-Q));.7<J&&1.3>J&&(P?b=d-g:d=b+g);w(b)&&w(d)||(b=d=void 0);return{min:b,max:d}};return b}();return function(){function b(){}b.compose=function(b){b.keepProps.push("navigatorAxis");
r(b,"init",function(){this.navigatorAxis||(this.navigatorAxis=new d(this))});r(b,"zoom",function(b){var d=this.chart.options,a=d.navigator,J=this.navigatorAxis,g=d.chart.pinchType,Q=d.rangeSelector;d=d.chart.zoomType;this.isXAxis&&(a&&a.enabled||Q&&Q.enabled)&&("y"===d?b.zoomed=!1:(!x&&"xy"===d||x&&"xy"===g)&&this.options.range&&(a=J.previousZoom,H(b.newMin)?J.previousZoom=[this.min,this.max]:a&&(b.newMin=a[0],b.newMax=a[1],J.previousZoom=void 0)));"undefined"!==typeof b.zoomed&&b.preventDefault()})};
b.AdditionsClass=d;return b}()});I(a,"Core/Axis/ScrollbarAxis.js",[a["Core/Utilities.js"]],function(a){var v=a.addEvent,x=a.defined,r=a.pick;return function(){function a(){}a.compose=function(a,n){var w=function(d){var b=r(d.options&&d.options.min,d.min),a=r(d.options&&d.options.max,d.max);return{axisMin:b,axisMax:a,scrollMin:x(d.dataMin)?Math.min(b,d.min,d.dataMin,r(d.threshold,Infinity)):b,scrollMax:x(d.dataMax)?Math.max(a,d.max,d.dataMax,r(d.threshold,-Infinity)):a}};v(a,"afterInit",function(){var d=
this;d.options&&d.options.scrollbar&&d.options.scrollbar.enabled&&(d.options.scrollbar.vertical=!d.horiz,d.options.startOnTick=d.options.endOnTick=!1,d.scrollbar=new n(d.chart.renderer,d.options.scrollbar,d.chart),v(d.scrollbar,"changed",function(b){var a=w(d),l=a.axisMax,A=a.scrollMin,n=a.scrollMax-A;x(a.axisMin)&&x(l)&&(d.horiz&&!d.reversed||!d.horiz&&d.reversed?(a=A+n*this.to,A+=n*this.from):(a=A+n*(1-this.from),A+=n*(1-this.to)),this.shouldUpdateExtremes(b.DOMType)?d.setExtremes(A,a,!0,"mousemove"!==
b.DOMType&&"touchmove"!==b.DOMType,b):this.setRange(this.from,this.to))}))});v(a,"afterRender",function(){var d=w(this),b=d.scrollMin,a=d.scrollMax;d=this.scrollbar;var l=this.axisTitleMargin+(this.titleOffset||0),A=this.chart.scrollbarsOffsets,n=this.options.margin||0;d&&(this.horiz?(this.opposite||(A[1]+=l),d.position(this.left,this.top+this.height+2+A[1]-(this.opposite?n:0),this.width,this.height),this.opposite||(A[1]+=n),l=1):(this.opposite&&(A[0]+=l),d.position(this.left+this.width+2+A[0]-(this.opposite?
0:n),this.top,this.width,this.height),this.opposite&&(A[0]+=n),l=0),A[l]+=d.size+d.options.margin,isNaN(b)||isNaN(a)||!x(this.min)||!x(this.max)||this.min===this.max?d.setRange(0,1):(A=(this.min-b)/(a-b),b=(this.max-b)/(a-b),this.horiz&&!this.reversed||!this.horiz&&this.reversed?d.setRange(A,b):d.setRange(1-b,1-A)))});v(a,"afterGetOffset",function(){var d=this.horiz?2:1,b=this.scrollbar;b&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[d]+=b.size+b.options.margin)});return a};return a}()});
I(a,"Core/ScrollbarDefaults.js",[a["Core/Globals.js"],a["Core/Color/Palette.js"]],function(a,v){return{height:a.isTouchDevice?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,step:.2,zIndex:3,barBackgroundColor:v.neutralColor20,barBorderWidth:1,barBorderColor:v.neutralColor20,buttonArrowColor:v.neutralColor80,buttonBackgroundColor:v.neutralColor10,buttonBorderColor:v.neutralColor20,buttonBorderWidth:1,rifleColor:v.neutralColor80,trackBackgroundColor:v.neutralColor5,
trackBorderColor:v.neutralColor5,trackBorderWidth:1}});I(a,"Core/Scrollbar.js",[a["Core/DefaultOptions.js"],a["Core/Globals.js"],a["Core/Axis/ScrollbarAxis.js"],a["Core/ScrollbarDefaults.js"],a["Core/Utilities.js"]],function(a,v,x,r,n){var H=a.defaultOptions,w=n.addEvent,D=n.correctFloat,d=n.defined,b=n.destroyObjectProperties,F=n.fireEvent,l=n.merge,A=n.pick,P=n.removeEvent;a=function(){function a(g,a,b){this._events=[];this.chart=void 0;this.from=this.chartY=this.chartX=0;this.scrollbar=this.renderer=
this.options=this.group=void 0;this.scrollbarButtons=[];this.scrollbarGroup=void 0;this.scrollbarLeft=0;this.scrollbarRifles=void 0;this.scrollbarStrokeWidth=1;this.to=this.size=this.scrollbarTop=0;this.track=void 0;this.trackBorderWidth=1;this.userOptions=void 0;this.y=this.x=0;this.init(g,a,b)}a.compose=function(g){x.compose(g,a)};a.swapXY=function(g,a){a&&g.forEach(function(g){for(var a=g.length,b,p=0;p<a;p+=2)b=g[p+1],"number"===typeof b&&(g[p+1]=g[p+2],g[p+2]=b)});return g};a.prototype.addEvents=
function(){var g=this.options.inverted?[1,0]:[0,1],a=this.scrollbarButtons,b=this.scrollbarGroup.element,d=this.track.element,h=this.mouseDownHandler.bind(this),q=this.mouseMoveHandler.bind(this),E=this.mouseUpHandler.bind(this);g=[[a[g[0]].element,"click",this.buttonToMinClick.bind(this)],[a[g[1]].element,"click",this.buttonToMaxClick.bind(this)],[d,"click",this.trackClick.bind(this)],[b,"mousedown",h],[b.ownerDocument,"mousemove",q],[b.ownerDocument,"mouseup",E]];v.hasTouch&&g.push([b,"touchstart",
h],[b.ownerDocument,"touchmove",q],[b.ownerDocument,"touchend",E]);g.forEach(function(g){w.apply(null,g)});this._events=g};a.prototype.buttonToMaxClick=function(g){var a=(this.to-this.from)*A(this.options.step,.2);this.updatePosition(this.from+a,this.to+a);F(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:g})};a.prototype.buttonToMinClick=function(g){var a=D(this.to-this.from)*A(this.options.step,.2);this.updatePosition(D(this.from-a),D(this.to-a));F(this,"changed",{from:this.from,
to:this.to,trigger:"scrollbar",DOMEvent:g})};a.prototype.cursorToScrollbarPosition=function(g){var a=this.options;a=a.minWidth>this.calculatedWidth?a.minWidth:0;return{chartX:(g.chartX-this.x-this.xOffset)/(this.barWidth-a),chartY:(g.chartY-this.y-this.yOffset)/(this.barWidth-a)}};a.prototype.destroy=function(){var a=this,d=a.chart.scroller;a.removeEvents();["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(g){a[g]&&a[g].destroy&&(a[g]=a[g].destroy())});d&&a===d.scrollbar&&
(d.scrollbar=null,b(d.scrollbarButtons))};a.prototype.drawScrollbarButton=function(g){var b=this.renderer,d=this.scrollbarButtons,C=this.options,h=this.size,q=b.g().add(this.group);d.push(q);q=b.rect().addClass("highcharts-scrollbar-button").add(q);this.chart.styledMode||q.attr({stroke:C.buttonBorderColor,"stroke-width":C.buttonBorderWidth,fill:C.buttonBackgroundColor});q.attr(q.crisp({x:-.5,y:-.5,width:h+1,height:h+1,r:C.buttonBorderRadius},q.strokeWidth()));q=b.path(a.swapXY([["M",h/2+(g?-1:1),
h/2-3],["L",h/2+(g?-1:1),h/2+3],["L",h/2+(g?2:-2),h/2]],C.vertical)).addClass("highcharts-scrollbar-arrow").add(d[g]);this.chart.styledMode||q.attr({fill:C.buttonArrowColor})};a.prototype.init=function(a,b,d){this.scrollbarButtons=[];this.renderer=a;this.userOptions=b;this.options=l(r,H.scrollbar,b);this.chart=d;this.size=A(this.options.size,this.options.height);b.enabled&&(this.render(),this.addEvents())};a.prototype.mouseDownHandler=function(a){a=this.chart.pointer.normalize(a);a=this.cursorToScrollbarPosition(a);
this.chartX=a.chartX;this.chartY=a.chartY;this.initPositions=[this.from,this.to];this.grabbedCenter=!0};a.prototype.mouseMoveHandler=function(a){var b=this.chart.pointer.normalize(a),g=this.options.vertical?"chartY":"chartX",d=this.initPositions||[];!this.grabbedCenter||a.touches&&0===a.touches[0][g]||(b=this.cursorToScrollbarPosition(b)[g],g=this[g],g=b-g,this.hasDragged=!0,this.updatePosition(d[0]+g,d[1]+g),this.hasDragged&&F(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,
DOMEvent:a}))};a.prototype.mouseUpHandler=function(a){this.hasDragged&&F(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:a.type,DOMEvent:a});this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null};a.prototype.position=function(a,b,d,C){var g=this.options.vertical,p=this.rendered?"animate":"attr",E=0;this.x=a;this.y=b+this.trackBorderWidth;this.width=d;this.xOffset=this.height=C;this.yOffset=E;g?(this.width=this.yOffset=d=E=this.size,this.xOffset=b=0,this.barWidth=C-
2*d,this.x=a+=this.options.margin):(this.height=this.xOffset=C=b=this.size,this.barWidth=d-2*C,this.y+=this.options.margin);this.group[p]({translateX:a,translateY:this.y});this.track[p]({width:d,height:C});this.scrollbarButtons[1][p]({translateX:g?0:d-b,translateY:g?C-E:0})};a.prototype.removeEvents=function(){this._events.forEach(function(a){P.apply(null,a)});this._events.length=0};a.prototype.render=function(){var b=this.renderer,d=this.options,p=this.size,C=this.chart.styledMode,h=b.g("scrollbar").attr({zIndex:d.zIndex,
translateY:-99999}).add();this.group=h;this.track=b.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:d.trackBorderRadius||0,height:p,width:p}).add(h);C||this.track.attr({fill:d.trackBackgroundColor,stroke:d.trackBorderColor,"stroke-width":d.trackBorderWidth});this.trackBorderWidth=this.track.strokeWidth();this.track.attr({y:-this.trackBorderWidth%2/2});this.scrollbarGroup=b.g().add(h);this.scrollbar=b.rect().addClass("highcharts-scrollbar-thumb").attr({height:p,width:p,r:d.barBorderRadius||
0}).add(this.scrollbarGroup);this.scrollbarRifles=b.path(a.swapXY([["M",-3,p/4],["L",-3,2*p/3],["M",0,p/4],["L",0,2*p/3],["M",3,p/4],["L",3,2*p/3]],d.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);C||(this.scrollbar.attr({fill:d.barBackgroundColor,stroke:d.barBorderColor,"stroke-width":d.barBorderWidth}),this.scrollbarRifles.attr({stroke:d.rifleColor,"stroke-width":1}));this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%
2/2,-this.scrollbarStrokeWidth%2/2);this.drawScrollbarButton(0);this.drawScrollbarButton(1)};a.prototype.setRange=function(a,b){var g=this.options,C=g.vertical,h=g.minWidth,q=this.barWidth,E=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(d(q)){var y=q*Math.min(b,1);a=Math.max(a,0);var G=Math.ceil(q*a);this.calculatedWidth=y=D(y-G);y<h&&(G=(q-h+y)*a,y=h);h=Math.floor(G+this.xOffset+this.yOffset);q=y/2-.5;this.from=a;this.to=b;C?(this.scrollbarGroup[E]({translateY:h}),
this.scrollbar[E]({height:y}),this.scrollbarRifles[E]({translateY:q}),this.scrollbarTop=h,this.scrollbarLeft=0):(this.scrollbarGroup[E]({translateX:h}),this.scrollbar[E]({width:y}),this.scrollbarRifles[E]({translateX:q}),this.scrollbarLeft=h,this.scrollbarTop=0);12>=y?this.scrollbarRifles.hide():this.scrollbarRifles.show(!0);!1===g.showFull&&(0>=a&&1<=b?this.group.hide():this.group.show());this.rendered=!0}};a.prototype.shouldUpdateExtremes=function(a){return A(this.options.liveRedraw,v.svg&&!v.isTouchDevice&&
!this.chart.isBoosting)||"mouseup"===a||"touchend"===a||!d(a)};a.prototype.trackClick=function(a){var b=this.chart.pointer.normalize(a),d=this.to-this.from,g=this.y+this.scrollbarTop,h=this.x+this.scrollbarLeft;this.options.vertical&&b.chartY>g||!this.options.vertical&&b.chartX>h?this.updatePosition(this.from+d,this.to+d):this.updatePosition(this.from-d,this.to-d);F(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:a})};a.prototype.update=function(a){this.destroy();this.init(this.chart.renderer,
l(!0,this.options,a),this.chart)};a.prototype.updatePosition=function(a,b){1<b&&(a=D(1-D(b-a)),b=1);0>a&&(b=D(b-a),a=0);this.from=a;this.to=b};a.defaultOptions=r;return a}();H.scrollbar=l(!0,a.defaultOptions,H.scrollbar);return a});I(a,"Core/Navigator.js",[a["Core/Axis/Axis.js"],a["Core/Chart/Chart.js"],a["Core/Color/Color.js"],a["Core/Globals.js"],a["Core/Axis/NavigatorAxis.js"],a["Core/DefaultOptions.js"],a["Core/Color/Palette.js"],a["Core/Renderer/RendererRegistry.js"],a["Core/Scrollbar.js"],a["Core/Series/Series.js"],
a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,v,x,r,n,H,w,D,d,b,F,l){x=x.parse;var A=r.hasTouch,P=r.isTouchDevice,J=H.defaultOptions,g=l.addEvent,Q=l.clamp,p=l.correctFloat,C=l.defined,h=l.destroyObjectProperties,q=l.erase,E=l.extend,y=l.find,G=l.isArray,M=l.isNumber,B=l.merge,L=l.pick,t=l.removeEvent,u=l.splat,k=function(f){for(var c=[],e=1;e<arguments.length;e++)c[e-1]=arguments[e];c=[].filter.call(c,M);if(c.length)return Math[f].apply(0,c)};H="undefined"===typeof F.seriesTypes.areaspline?
"line":"areaspline";E(J,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:w.neutralColor5,borderColor:w.neutralColor40},maskFill:x(w.highlightColor60).setOpacity(.3).get(),outlineColor:w.neutralColor20,outlineWidth:1,series:{type:H,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",
units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:w.neutralColor10,gridLineWidth:1,tickPixelInterval:200,
labels:{align:"left",style:{color:w.neutralColor40},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});D.getRendererType().prototype.symbols["navigator-handle"]=function(f,c,e,k,m){f=(m&&m.width||0)/2;c=Math.round(f/3)+.5;m=m&&m.height||0;return[["M",-f-1,.5],["L",f,.5],["L",f,m+.5],["L",-f-1,m+.5],["L",-f-1,.5],["M",-c,4],["L",
-c,m-3],["M",c-1,4],["L",c-1,m-3]]};var m=function(){function f(c){this.zoomedMin=this.zoomedMax=this.yAxis=this.xAxis=this.top=this.size=this.shades=this.rendered=this.range=this.outlineHeight=this.outline=this.opposite=this.navigatorSize=this.navigatorSeries=this.navigatorOptions=this.navigatorGroup=this.navigatorEnabled=this.left=this.height=this.handles=this.chart=this.baseSeries=void 0;this.init(c)}f.prototype.drawHandle=function(c,e,f,k){var z=this.navigatorOptions.handles.height;this.handles[e][k](f?
{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(c,10)+.5-z)}:{translateX:Math.round(this.left+parseInt(c,10)),translateY:Math.round(this.top+this.height/2-z/2-1)})};f.prototype.drawOutline=function(c,e,f,k){var m=this.navigatorOptions.maskInside,z=this.outline.strokeWidth(),a=z/2,b=z%2/2;z=this.outlineHeight;var K=this.scrollbarHeight||0,u=this.size,d=this.left-K,t=this.top;f?(d-=a,f=t+e+b,e=t+c+b,b=[["M",d+z,t-K-b],["L",d+z,f],["L",d,f],["L",d,e],["L",d+z,
e],["L",d+z,t+u+K]],m&&b.push(["M",d+z,f-a],["L",d+z,e+a])):(c+=d+K-b,e+=d+K-b,t+=a,b=[["M",d,t],["L",c,t],["L",c,t+z],["L",e,t+z],["L",e,t],["L",d+u+2*K,t]],m&&b.push(["M",c-a,t],["L",e+a,t]));this.outline[k]({d:b})};f.prototype.drawMasks=function(c,e,f,k){var z=this.left,m=this.top,a=this.height;if(f){var b=[z,z,z];var K=[m,m+c,m+e];var d=[a,a,a];var u=[c,e-c,this.size-e]}else b=[z,z+c,z+e],K=[m,m,m],d=[c,e-c,this.size-e],u=[a,a,a];this.shades.forEach(function(c,e){c[k]({x:b[e],y:K[e],width:d[e],
height:u[e]})})};f.prototype.renderElements=function(){var c=this,e=c.navigatorOptions,f=e.maskInside,k=c.chart,m=k.renderer,a,b={cursor:k.inverted?"ns-resize":"ew-resize"};c.navigatorGroup=a=m.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();[!f,f,!f].forEach(function(f,z){c.shades[z]=m.rect().addClass("highcharts-navigator-mask"+(1===z?"-inside":"-outside")).add(a);k.styledMode||c.shades[z].attr({fill:f?e.maskFill:"rgba(0,0,0,0)"}).css(1===z&&b)});c.outline=m.path().addClass("highcharts-navigator-outline").add(a);
k.styledMode||c.outline.attr({"stroke-width":e.outlineWidth,stroke:e.outlineColor});e.handles.enabled&&[0,1].forEach(function(f){e.handles.inverted=k.inverted;c.handles[f]=m.symbol(e.handles.symbols[f],-e.handles.width/2-1,0,e.handles.width,e.handles.height,e.handles);c.handles[f].attr({zIndex:7-f}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][f]).add(a);if(!k.styledMode){var z=e.handles;c.handles[f].attr({fill:z.backgroundColor,stroke:z.borderColor,"stroke-width":z.lineWidth}).css(b)}})};
f.prototype.update=function(c){(this.series||[]).forEach(function(c){c.baseSeries&&delete c.baseSeries.navigatorSeries});this.destroy();B(!0,this.chart.options.navigator,this.options,c);this.init(this.chart)};f.prototype.render=function(c,e,f,k){var m=this.chart,z=this.scrollbarHeight,a,b=this.xAxis,d=b.pointRange||0;var u=b.navigatorAxis.fake?m.xAxis[0]:b;var K=this.navigatorEnabled,t,g=this.rendered;var B=m.inverted;var h=m.xAxis[0].minRange,y=m.xAxis[0].options.maxRange;if(!this.hasDragged||C(f)){c=
p(c-d/2);e=p(e+d/2);if(!M(c)||!M(e))if(g)f=0,k=L(b.width,u.width);else return;this.left=L(b.left,m.plotLeft+z+(B?m.plotWidth:0));this.size=t=a=L(b.len,(B?m.plotHeight:m.plotWidth)-2*z);m=B?z:a+2*z;f=L(f,b.toPixels(c,!0));k=L(k,b.toPixels(e,!0));M(f)&&Infinity!==Math.abs(f)||(f=0,k=m);c=b.toValue(f,!0);e=b.toValue(k,!0);var E=Math.abs(p(e-c));E<h?this.grabbedLeft?f=b.toPixels(e-h-d,!0):this.grabbedRight&&(k=b.toPixels(c+h+d,!0)):C(y)&&p(E-d)>y&&(this.grabbedLeft?f=b.toPixels(e-y-d,!0):this.grabbedRight&&
(k=b.toPixels(c+y+d,!0)));this.zoomedMax=Q(Math.max(f,k),0,t);this.zoomedMin=Q(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(f,k),0,t);this.range=this.zoomedMax-this.zoomedMin;t=Math.round(this.zoomedMax);f=Math.round(this.zoomedMin);K&&(this.navigatorGroup.attr({visibility:"visible"}),g=g&&!this.hasDragged?"animate":"attr",this.drawMasks(f,t,B,g),this.drawOutline(f,t,B,g),this.navigatorOptions.handles.enabled&&(this.drawHandle(f,0,B,g),this.drawHandle(t,1,B,g)));this.scrollbar&&(B?(B=this.top-
z,u=this.left-z+(K||!u.opposite?0:(u.titleOffset||0)+u.axisTitleMargin),z=a+2*z):(B=this.top+(K?this.height:-z),u=this.left-z),this.scrollbar.position(u,B,m,z),this.scrollbar.setRange(this.zoomedMin/(a||1),this.zoomedMax/(a||1)));this.rendered=!0}};f.prototype.addMouseEvents=function(){var c=this,e=c.chart,f=e.container,k=[],m,a;c.mouseMoveHandler=m=function(e){c.onMouseMove(e)};c.mouseUpHandler=a=function(e){c.onMouseUp(e)};k=c.getPartsEvents("mousedown");k.push(g(e.renderTo,"mousemove",m),g(f.ownerDocument,
"mouseup",a));A&&(k.push(g(e.renderTo,"touchmove",m),g(f.ownerDocument,"touchend",a)),k.concat(c.getPartsEvents("touchstart")));c.eventsToUnbind=k;c.series&&c.series[0]&&k.push(g(c.series[0].xAxis,"foundExtremes",function(){e.navigator.modifyNavigatorAxisExtremes()}))};f.prototype.getPartsEvents=function(c){var e=this,f=[];["shades","handles"].forEach(function(k){e[k].forEach(function(m,z){f.push(g(m.element,c,function(c){e[k+"Mousedown"](c,z)}))})});return f};f.prototype.shadesMousedown=function(c,
e){c=this.chart.pointer.normalize(c);var f=this.chart,k=this.xAxis,m=this.zoomedMin,a=this.left,b=this.size,d=this.range,u=c.chartX;f.inverted&&(u=c.chartY,a=this.top);if(1===e)this.grabbedCenter=u,this.fixedWidth=d,this.dragOffset=u-m;else{c=u-a-d/2;if(0===e)c=Math.max(0,c);else if(2===e&&c+d>=b)if(c=b-d,this.reversedExtremes){c-=d;var t=this.getUnionExtremes().dataMin}else var g=this.getUnionExtremes().dataMax;c!==m&&(this.fixedWidth=d,e=k.navigatorAxis.toFixedRange(c,c+d,t,g),C(e.min)&&f.xAxis[0].setExtremes(Math.min(e.min,
e.max),Math.max(e.min,e.max),!0,null,{trigger:"navigator"}))}};f.prototype.handlesMousedown=function(c,e){this.chart.pointer.normalize(c);c=this.chart;var f=c.xAxis[0],k=this.reversedExtremes;0===e?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=k?f.min:f.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=k?f.max:f.min);c.fixedRange=null};f.prototype.onMouseMove=function(c){var e=this,f=e.chart,k=e.left,m=e.navigatorSize,a=e.range,b=e.dragOffset,
d=f.inverted;c.touches&&0===c.touches[0].pageX||(c=f.pointer.normalize(c),f=c.chartX,d&&(k=e.top,f=c.chartY),e.grabbedLeft?(e.hasDragged=!0,e.render(0,0,f-k,e.otherHandlePos)):e.grabbedRight?(e.hasDragged=!0,e.render(0,0,e.otherHandlePos,f-k)):e.grabbedCenter&&(e.hasDragged=!0,f<b?f=b:f>m+b-a&&(f=m+b-a),e.render(0,0,f-b,f-b+a)),e.hasDragged&&e.scrollbar&&L(e.scrollbar.options.liveRedraw,r.svg&&!P&&!this.chart.isBoosting)&&(c.DOMType=c.type,setTimeout(function(){e.onMouseUp(c)},0)))};f.prototype.onMouseUp=
function(c){var e=this.chart,f=this.xAxis,k=this.scrollbar,m=c.DOMEvent||c,a=e.inverted,b=this.rendered&&!this.hasDragged?"animate":"attr";if(this.hasDragged&&(!k||!k.hasDragged)||"scrollbar"===c.trigger){k=this.getUnionExtremes();if(this.zoomedMin===this.otherHandlePos)var d=this.fixedExtreme;else if(this.zoomedMax===this.otherHandlePos)var u=this.fixedExtreme;this.zoomedMax===this.size&&(u=this.reversedExtremes?k.dataMin:k.dataMax);0===this.zoomedMin&&(d=this.reversedExtremes?k.dataMax:k.dataMin);
f=f.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,d,u);C(f.min)&&e.xAxis[0].setExtremes(Math.min(f.min,f.max),Math.max(f.min,f.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:m})}"mousemove"!==c.DOMType&&"touchmove"!==c.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null);this.navigatorEnabled&&M(this.zoomedMin)&&M(this.zoomedMax)&&(e=Math.round(this.zoomedMin),
c=Math.round(this.zoomedMax),this.shades&&this.drawMasks(e,c,a,b),this.outline&&this.drawOutline(e,c,a,b),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(e,0,a,b),this.drawHandle(c,1,a,b)))};f.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(c){c()}),this.eventsToUnbind=void 0);this.removeBaseSeriesEvents()};f.prototype.removeBaseSeriesEvents=function(){var c=this.baseSeries||[];this.navigatorEnabled&&
c[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&c.forEach(function(c){t(c,"updatedData",this.updatedDataHandler)},this),c[0].xAxis&&t(c[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))};f.prototype.init=function(c){var e=c.options,f=e.navigator,m=f.enabled,b=e.scrollbar,u=b.enabled;e=m?f.height:0;var t=u?b.height:0;this.handles=[];this.shades=[];this.chart=c;this.setBaseSeries();this.height=e;this.scrollbarHeight=t;this.scrollbarEnabled=u;this.navigatorEnabled=m;this.navigatorOptions=
f;this.scrollbarOptions=b;this.outlineHeight=e+t;this.opposite=L(f.opposite,!(m||!c.inverted));var h=this;m=h.baseSeries;b=c.xAxis.length;u=c.yAxis.length;var y=m&&m[0]&&m[0].xAxis||c.xAxis[0]||{options:{}};c.isDirtyBox=!0;h.navigatorEnabled?(h.xAxis=new a(c,B({breaks:y.options.breaks,ordinal:y.options.ordinal},f.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:b,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},
c.inverted?{offsets:[t,0,-t,0],width:e}:{offsets:[0,-t,0,t],height:e})),h.yAxis=new a(c,B(f.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:u,isInternal:!0,reversed:L(f.yAxis&&f.yAxis.reversed,c.yAxis[0]&&c.yAxis[0].reversed,!1),zoomEnabled:!1},c.inverted?{width:e}:{height:e})),m||f.series.data?h.updateNavigatorSeries(!1):0===c.series.length&&(h.unbindRedraw=g(c,"beforeRedraw",function(){0<c.series.length&&!h.series&&(h.setBaseSeries(),h.unbindRedraw())})),h.reversedExtremes=c.inverted&&
!h.xAxis.reversed||!c.inverted&&h.xAxis.reversed,h.renderElements(),h.addMouseEvents()):(h.xAxis={chart:c,navigatorAxis:{fake:!0},translate:function(e,f){var m=c.xAxis[0],a=m.getExtremes(),z=m.len-2*t,b=k("min",m.options.min,a.dataMin);m=k("max",m.options.max,a.dataMax)-b;return f?e*m/z+b:z*(e-b)/m},toPixels:function(c){return this.translate(c)},toValue:function(c){return this.translate(c,!0)}},h.xAxis.navigatorAxis.axis=h.xAxis,h.xAxis.navigatorAxis.toFixedRange=n.AdditionsClass.prototype.toFixedRange.bind(h.xAxis.navigatorAxis));
c.options.scrollbar.enabled&&(c.scrollbar=h.scrollbar=new d(c.renderer,B(c.options.scrollbar,{margin:h.navigatorEnabled?0:10,vertical:c.inverted}),c),g(h.scrollbar,"changed",function(c){var e=h.size,f=e*this.to;e*=this.from;h.hasDragged=h.scrollbar.hasDragged;h.render(0,0,e,f);this.shouldUpdateExtremes(c.DOMType)&&setTimeout(function(){h.onMouseUp(c)})}));h.addBaseSeriesEvents();h.addChartEvents()};f.prototype.getUnionExtremes=function(c){var e=this.chart.xAxis[0],f=this.xAxis,m=f.options,a=e.options,
b;c&&null===e.dataMin||(b={dataMin:L(m&&m.min,k("min",a.min,e.dataMin,f.dataMin,f.min)),dataMax:L(m&&m.max,k("max",a.max,e.dataMax,f.dataMax,f.max))});return b};f.prototype.setBaseSeries=function(c,e){var f=this.chart,m=this.baseSeries=[];c=c||f.options&&f.options.navigator.baseSeries||(f.series.length?y(f.series,function(c){return!c.options.isInternal}).index:0);(f.series||[]).forEach(function(e,f){e.options.isInternal||!e.options.showInNavigator&&(f!==c&&e.options.id!==c||!1===e.options.showInNavigator)||
m.push(e)});this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,e)};f.prototype.updateNavigatorSeries=function(c,e){var f=this,m=f.chart,k=f.baseSeries,a,b,d=f.navigatorOptions.series,h,g={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},y=f.series=(f.series||[]).filter(function(c){var e=c.baseSeries;return 0>k.indexOf(e)?(e&&(t(e,
"updatedData",f.updatedDataHandler),delete e.navigatorSeries),c.chart&&c.destroy(),!1):!0});k&&k.length&&k.forEach(function(c){var z=c.navigatorSeries,t=E({color:c.color,visible:c.visible},G(d)?J.navigator.series:d);z&&!1===f.navigatorOptions.adaptToUpdatedData||(g.name="Navigator "+k.length,a=c.options||{},h=a.navigatorOptions||{},t.dataLabels=u(t.dataLabels),b=B(a,g,t,h),b.pointRange=L(t.pointRange,h.pointRange,J.plotOptions[b.type||"line"].pointRange),t=h.data||t.data,f.hasNavigatorData=f.hasNavigatorData||
!!t,b.data=t||a.data&&a.data.slice(0),z&&z.options?z.update(b,e):(c.navigatorSeries=m.initSeries(b),c.navigatorSeries.baseSeries=c,y.push(c.navigatorSeries)))});if(d.data&&(!k||!k.length)||G(d))f.hasNavigatorData=!1,d=u(d),d.forEach(function(c,e){g.name="Navigator "+(y.length+1);b=B(J.navigator.series,{color:m.series[e]&&!m.series[e].options.isInternal&&m.series[e].color||m.options.colors[e]||m.options.colors[0]},g,c);b.data=c.data;b.data&&(f.hasNavigatorData=!0,y.push(m.initSeries(b)))});c&&this.addBaseSeriesEvents()};
f.prototype.addBaseSeriesEvents=function(){var c=this,e=c.baseSeries||[];e[0]&&e[0].xAxis&&e[0].eventsToUnbind.push(g(e[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes));e.forEach(function(e){e.eventsToUnbind.push(g(e,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)}));e.eventsToUnbind.push(g(e,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)}));!1!==this.navigatorOptions.adaptToUpdatedData&&e.xAxis&&e.eventsToUnbind.push(g(e,"updatedData",
this.updatedDataHandler));e.eventsToUnbind.push(g(e,"remove",function(){this.navigatorSeries&&(q(c.series,this.navigatorSeries),C(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))},this)};f.prototype.getBaseSeriesMin=function(c){return this.baseSeries.reduce(function(c,f){return Math.min(c,f.xData?f.xData[0]:c)},c)};f.prototype.modifyNavigatorAxisExtremes=function(){var c=this.xAxis,e;"undefined"!==typeof c.getExtremes&&(!(e=this.getUnionExtremes(!0))||
e.dataMin===c.min&&e.dataMax===c.max||(c.min=e.dataMin,c.max=e.dataMax))};f.prototype.modifyBaseAxisExtremes=function(){var c=this.chart.navigator,e=this.getExtremes(),f=e.dataMin,m=e.dataMax;e=e.max-e.min;var k=c.stickToMin,a=c.stickToMax,b=L(this.options.overscroll,0),d=c.series&&c.series[0],u=!!this.setExtremes;if(!this.eventArgs||"rangeSelectorButton"!==this.eventArgs.trigger){if(k){var t=f;var h=t+e}a&&(h=m+b,k||(t=Math.max(f,h-e,c.getBaseSeriesMin(d&&d.xData?d.xData[0]:-Number.MAX_VALUE))));
u&&(k||a)&&M(t)&&(this.min=this.userMin=t,this.max=this.userMax=h)}c.stickToMin=c.stickToMax=null};f.prototype.updatedDataHandler=function(){var c=this.chart.navigator,e=this.navigatorSeries;c.stickToMax=c.reversedExtremes?0===Math.round(c.zoomedMin):Math.round(c.zoomedMax)>=Math.round(c.size);c.stickToMin=c.shouldStickToMin(this,c);e&&!c.hasNavigatorData&&(e.options.pointStart=this.xData[0],e.setData(this.options.data,!1,null,!1))};f.prototype.shouldStickToMin=function(c,e){e=e.getBaseSeriesMin(c.xData[0]);
var f=c.xAxis;c=f.max;var m=f.min;f=f.options.range;var k=!0;M(c)&&M(m)&&(k=f&&0<c-e?c-e<f&&!this.chart.fixedRange:m<=e);return k};f.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]);this.eventsToUnbind.push(g(this.chart,"redraw",function(){var c=this.navigator,e=c&&(c.baseSeries&&c.baseSeries[0]&&c.baseSeries[0].xAxis||this.xAxis[0]);e&&c.render(e.min,e.max)}),g(this.chart,"getMargins",function(){var c=this.navigator,e=c.opposite?"plotTop":"marginBottom";this.inverted&&
(e=c.opposite?"marginRight":"plotLeft");this[e]=(this[e]||0)+(c.navigatorEnabled||!this.inverted?c.outlineHeight:0)+c.navigatorOptions.margin}))};f.prototype.destroy=function(){this.removeEvents();this.xAxis&&(q(this.chart.xAxis,this.xAxis),q(this.chart.axes,this.xAxis));this.yAxis&&(q(this.chart.yAxis,this.yAxis),q(this.chart.axes,this.yAxis));(this.series||[]).forEach(function(c){c.destroy&&c.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(function(c){this[c]&&
this[c].destroy&&this[c].destroy();this[c]=null},this);[this.handles].forEach(function(c){h(c)},this)};return f}();r.Navigator||(r.Navigator=m,n.compose(a),g(v,"beforeShowResetZoom",function(){var f=this.options,c=f.navigator,e=f.rangeSelector;if((c&&c.enabled||e&&e.enabled)&&(!P&&"x"===f.chart.zoomType||P&&"x"===f.chart.pinchType))return!1}),g(v,"beforeRender",function(){var f=this.options;if(f.navigator.enabled||f.scrollbar.enabled)this.scroller=this.navigator=new m(this)}),g(v,"afterSetChartSize",
function(){var f=this.legend,c=this.navigator;if(c){var e=f&&f.options;var m=c.xAxis;var k=c.yAxis;var a=c.scrollbarHeight;this.inverted?(c.left=c.opposite?this.chartWidth-a-c.height:this.spacing[3]+a,c.top=this.plotTop+a):(c.left=L(m.left,this.plotLeft+a),c.top=c.navigatorOptions.top||this.chartHeight-c.height-a-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(e&&"bottom"===e.verticalAlign&&"proximate"!==e.layout&&e.enabled&&!e.floating?f.legendHeight+
L(e.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0));m&&k&&(this.inverted?m.options.left=k.options.left=c.left:m.options.top=k.options.top=c.top,m.setAxisSize(),k.setAxisSize())}}),g(v,"update",function(f){var c=f.options.navigator||{},e=f.options.scrollbar||{};this.navigator||this.scroller||!c.enabled&&!e.enabled||(B(!0,this.options.navigator,c),B(!0,this.options.scrollbar,e),delete f.options.navigator,delete f.options.scrollbar)}),g(v,"afterUpdate",function(f){this.navigator||this.scroller||
!this.options.navigator.enabled&&!this.options.scrollbar.enabled||(this.scroller=this.navigator=new m(this),L(f.redraw,!0)&&this.redraw(f.animation))}),g(v,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),g(b,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),v.prototype.callbacks.push(function(f){var c=f.navigator;c&&f.xAxis[0]&&(f=f.xAxis[0].getExtremes(),c.render(f.min,f.max))}));r.Navigator=
m;return r.Navigator});I(a,"Core/Axis/OrdinalAxis.js",[a["Core/Axis/Axis.js"],a["Core/Chart/Chart.js"],a["Core/Globals.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,v,x,r,n){var H=n.addEvent,w=n.css,D=n.defined,d=n.error,b=n.pick,F=n.timeUnits,l;(function(a){var l=function(){function a(a){this.index={};this.axis=a}a.prototype.beforeSetTickPositions=function(){var a=this.axis,d=a.ordinal,p=[],C,h=!1,q=a.getExtremes(),E=q.min,y=q.max,G,l=a.isXAxis&&!!a.options.breaks;q=a.options.ordinal;
var B=Number.MAX_VALUE,L=a.chart.options.chart.ignoreHiddenSeries,t;if(q||l){a.series.forEach(function(m,f){C=[];if(!(L&&!1===m.visible||!1===m.takeOrdinalPosition&&!l)&&(p=p.concat(m.processedXData),u=p.length,p.sort(function(c,e){return c-e}),B=Math.min(B,b(m.closestPointRange,B)),u)){for(f=0;f<u-1;)p[f]!==p[f+1]&&C.push(p[f+1]),f++;C[0]!==p[0]&&C.unshift(p[0]);p=C}m.isSeriesBoosting&&(t=!0)});t&&(p.length=0);var u=p.length;if(2<u){var k=p[1]-p[0];for(G=u-1;G--&&!h;)p[G+1]-p[G]!==k&&(h=!0);!a.options.keepOrdinalPadding&&
(p[0]-E>k||y-p[p.length-1]>k)&&(h=!0)}else a.options.overscroll&&(2===u?B=p[1]-p[0]:1===u?(B=a.options.overscroll,p=[p[0],p[0]+B]):B=d.overscrollPointsRange);h||a.forceOrdinal?(a.options.overscroll&&(d.overscrollPointsRange=B,p=p.concat(d.getOverscrollPositions())),d.positions=p,k=a.ordinal2lin(Math.max(E,p[0]),!0),G=Math.max(a.ordinal2lin(Math.min(y,p[p.length-1]),!0),1),d.slope=y=(y-E)/(G-k),d.offset=E-k*y):(d.overscrollPointsRange=b(a.closestPointRange,d.overscrollPointsRange),d.positions=a.ordinal.slope=
d.offset=void 0)}a.isOrdinal=q&&h;d.groupIntervalFactor=null};a.prototype.getExtendedPositions=function(){var a=this,b=a.axis,d=b.constructor.prototype,C=b.chart,h=b.series[0].currentDataGrouping,q=a.index,E=h?h.count+h.unitName:"raw",y=b.options.overscroll,G=b.getExtremes(),l;q||(q=a.index={});if(!q[E]){var B={series:[],chart:C,forceOrdinal:!1,getExtremes:function(){return{min:G.dataMin,max:G.dataMax+y}},getGroupPixelWidth:d.getGroupPixelWidth,getTimeTicks:d.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},
ordinal2lin:d.ordinal2lin,val2lin:d.val2lin};B.ordinal.axis=B;b.series.forEach(function(b){l={xAxis:B,xData:b.xData.slice(),chart:C,destroyGroupedData:x.noop,getProcessedData:r.prototype.getProcessedData};l.xData=l.xData.concat(a.getOverscrollPositions());l.options={dataGrouping:h?{enabled:!0,forced:!0,approximation:"open",units:[[h.unitName,[h.count]]]}:{enabled:!1}};B.series.push(l);b.processData.apply(l);l.closestPointRange!==l.basePointRange&&l.currentDataGrouping&&(B.forceOrdinal=!0)});b.ordinal.beforeSetTickPositions.apply({axis:B});
q[E]=B.ordinal.positions}return q[E]};a.prototype.getGroupIntervalFactor=function(a,b,d){d=d.processedXData;var g=d.length,h=[];var q=this.groupIntervalFactor;if(!q){for(q=0;q<g-1;q++)h[q]=d[q+1]-d[q];h.sort(function(a,b){return a-b});h=h[Math.floor(g/2)];a=Math.max(a,d[0]);b=Math.min(b,d[g-1]);this.groupIntervalFactor=q=g*h/(b-a)}return q};a.prototype.getOverscrollPositions=function(){var a=this.axis,b=a.options.overscroll,d=this.overscrollPointsRange,l=[],h=a.dataMax;if(D(d))for(l.push(h);h<=a.dataMax+
b;)h+=d,l.push(h);return l};a.prototype.postProcessTickInterval=function(a){var b=this.axis,d=this.slope;return d?b.options.breaks?b.closestPointRange||a:a/(d/b.closestPointRange):a};return a}();a.Composition=l;a.compose=function(b,g,l){b.keepProps.push("ordinal");var p=b.prototype;b.prototype.getTimeTicks=function(a,b,g,E,y,l,p){void 0===y&&(y=[]);void 0===l&&(l=0);var h=0,q,t,u={},k=[],m=-Number.MAX_VALUE,f=this.options.tickPixelInterval,c=this.chart.time,e=[];if(!this.options.ordinal&&!this.options.breaks||
!y||3>y.length||"undefined"===typeof b)return c.getTimeTicks.apply(c,arguments);var z=y.length;for(q=0;q<z;q++){var K=q&&y[q-1]>g;y[q]<b&&(h=q);if(q===z-1||y[q+1]-y[q]>5*l||K){if(y[q]>m){for(t=c.getTimeTicks(a,y[h],y[q],E);t.length&&t[0]<=m;)t.shift();t.length&&(m=t[t.length-1]);e.push(k.length);k=k.concat(t)}h=q+1}if(K)break}if(t){t=t.info;if(p&&t.unitRange<=F.hour){q=k.length-1;for(h=1;h<q;h++)if(c.dateFormat("%d",k[h])!==c.dateFormat("%d",k[h-1])){u[k[h]]="day";var G=!0}G&&(u[k[0]]="day");t.higherRanks=
u}t.segmentStarts=e;k.info=t}else d(12,!1,this.chart);if(p&&D(f)){h=t=k.length;G=[];c=void 0;for(e=[];h--;)q=this.translate(k[h]),c&&(e[h]=c-q),G[h]=c=q;e.sort();e=e[Math.floor(e.length/2)];e<.6*f&&(e=null);h=k[t-1]>g?t-1:t;for(c=void 0;h--;)q=G[h],t=Math.abs(c-q),c&&t<.8*f&&(null===e||t<.8*e)?(u[k[h]]&&!u[k[h+1]]?(t=h+1,c=q):t=h,k.splice(t,1)):c=q}return k};p.lin2val=function(a,b){var d=this.ordinal,h=d.positions;if(h){var y=d.slope,g=d.offset;d=h.length-1;var l=void 0;if(b)0>a?a=h[0]:a>d?a=h[d]:
(d=Math.floor(a),l=a-d);else for(;d--;)if(b=y*d+g,a>=b){y=y*(d+1)+g;l=(a-b)/(y-b);break}return"undefined"!==typeof l&&"undefined"!==typeof h[d]?h[d]+(l?l*(h[d+1]-h[d]):0):a}return a};p.val2lin=function(a,b){var d=this.ordinal,h=d.positions;if(h){var g=h.length,l,p=void 0;for(l=g;l--;)if(h[l]===a){p=l;break}for(l=g-1;l--;)if(a>h[l]||0===l){a=(a-h[l])/(h[l+1]-h[l]);p=l+a;break}b=b?p:d.slope*(p||0)+d.offset}else b=a;return b};p.ordinal2lin=p.val2lin;H(b,"afterInit",function(){this.ordinal||(this.ordinal=
new a.Composition(this))});H(b,"foundExtremes",function(){this.isXAxis&&D(this.options.overscroll)&&this.max===this.dataMax&&(!this.chart.mouseIsDown||this.isInternal)&&(!this.eventArgs||this.eventArgs&&"navigator"!==this.eventArgs.trigger)&&(this.max+=this.options.overscroll,!this.isInternal&&D(this.userMin)&&(this.min+=this.options.overscroll))});H(b,"afterSetScale",function(){this.horiz&&!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)});
H(b,"initialAxisTranslation",function(){this.ordinal&&(this.ordinal.beforeSetTickPositions(),this.tickInterval=this.ordinal.postProcessTickInterval(this.tickInterval))});H(g,"pan",function(a){var b=this.xAxis[0],d=b.options.overscroll,g=a.originalEvent.chartX,y=this.options.chart.panning,l=!1;if(y&&"y"!==y.type&&b.options.ordinal&&b.series.length){var p=this.mouseDownX,B=b.getExtremes(),n=B.dataMax,t=B.min,u=B.max,k=void 0;k=this.hoverPoints;var m=b.closestPointRange||b.ordinal&&b.ordinal.overscrollPointsRange;
p=(p-g)/(b.translationSlope*(b.ordinal.slope||m));m={ordinal:{positions:b.ordinal.getExtendedPositions()}};var f=void 0,c=void 0,e=b.lin2val,z=b.val2lin,K=void 0;m.ordinal.positions?1<Math.abs(p)&&(k&&k.forEach(function(c){c.setState()}),0>p?(c=m,K=b.ordinal.positions?b:m):(c=b.ordinal.positions?b:m,K=m),f=K.ordinal.positions,n>f[f.length-1]&&f.push(n),this.fixedRange=u-t,k=b.navigatorAxis.toFixedRange(null,null,e.apply(c,[z.apply(c,[t,!0])+p,!0]),e.apply(K,[z.apply(K,[u,!0])+p,!0])),k.min>=Math.min(B.dataMin,
t)&&k.max<=Math.max(n,u)+d&&b.setExtremes(k.min,k.max,!0,!1,{trigger:"pan"}),this.mouseDownX=g,w(this.container,{cursor:"move"})):l=!0}else l=!0;l||y&&/y/.test(y.type)?d&&(b.max=b.dataMax+d):a.preventDefault()});H(l,"updatedData",function(){var a=this.xAxis;a&&a.options.ordinal&&delete a.ordinal.index})}})(l||(l={}));l.compose(a,v,r);return l});I(a,"Core/Axis/BrokenAxis.js",[a["Core/Axis/Axis.js"],a["Core/Series/Series.js"],a["Extensions/Stacking.js"],a["Core/Utilities.js"]],function(a,v,x,r){var n=
r.addEvent,H=r.find,w=r.fireEvent,D=r.isArray,d=r.isNumber,b=r.pick,F;(function(l){function A(){"undefined"!==typeof this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function F(){this.brokenAxis&&this.brokenAxis.hasBreaks&&(this.options.ordinal=!1)}function r(){var a=this.brokenAxis;if(a&&a.hasBreaks){for(var b=this.tickPositions,d=this.tickPositions.info,h=[],g=0;g<b.length;g++)a.isInAnyBreak(b[g])||h.push(b[g]);this.tickPositions=h;this.tickPositions.info=d}}function g(){this.brokenAxis||
(this.brokenAxis=new q(this))}function O(){var a=this.options.connectNulls,b=this.points,d=this.xAxis,h=this.yAxis;if(this.isDirty)for(var g=b.length;g--;){var l=b[g],t=!(null===l.y&&!1===a)&&(d&&d.brokenAxis&&d.brokenAxis.isInAnyBreak(l.x,!0)||h&&h.brokenAxis&&h.brokenAxis.isInAnyBreak(l.y,!0));l.visible=t?!1:!1!==l.options.visible}}function p(){this.drawBreaks(this.xAxis,["x"]);this.drawBreaks(this.yAxis,b(this.pointArrayMap,["y"]))}function C(a,h){var g=this,l=g.points,y,q,t,u;if(a&&a.brokenAxis&&
a.brokenAxis.hasBreaks){var k=a.brokenAxis;h.forEach(function(m){y=k&&k.breakArray||[];q=a.isXAxis?a.min:b(g.options.threshold,a.min);l.forEach(function(f){u=b(f["stack"+m.toUpperCase()],f[m]);y.forEach(function(c){if(d(q)&&d(u)){t=!1;if(q<c.from&&u>c.to||q>c.from&&u<c.from)t="pointBreak";else if(q<c.from&&u>c.from&&u<c.to||q>c.from&&u>c.to&&u<c.from)t="pointInBreak";t&&w(a,t,{point:f,brk:c})}})})})}}function h(){var a=this.currentDataGrouping,b=a&&a.gapSize;a=this.points.slice();var d=this.yAxis,
h=this.options.gapSize,g=a.length-1,l;if(h&&0<g)for("value"!==this.options.gapUnit&&(h*=this.basePointRange),b&&b>h&&b>=this.basePointRange&&(h=b),l=void 0;g--;)l&&!1!==l.visible||(l=a[g+1]),b=a[g],!1!==l.visible&&!1!==b.visible&&(l.x-b.x>h&&(l=(b.x+l.x)/2,a.splice(g+1,0,{isNull:!0,x:l}),d.stacking&&this.options.stacking&&(l=d.stacking.stacks[this.stackKey][l]=new x(d,d.options.stackLabels,!1,l,this.stack),l.total=0)),l=b);return this.getGraphPath(a)}l.compose=function(a,b){if(-1===a.keepProps.indexOf("brokenAxis")){a.keepProps.push("brokenAxis");
var d=v.prototype;d.drawBreaks=C;d.gappedPath=h;n(a,"init",g);n(a,"afterInit",A);n(a,"afterSetTickPositions",r);n(a,"afterSetOptions",F);n(b,"afterGeneratePoints",O);n(b,"afterRender",p)}return a};var q=function(){function h(a){this.hasBreaks=!1;this.axis=a}h.isInBreak=function(a,b){var d=a.repeat||Infinity,h=a.from,g=a.to-a.from;b=b>=h?(b-h)%d:d-(h-b)%d;return a.inclusive?b<=g:b<g&&0!==b};h.lin2Val=function(a){var b=this.brokenAxis;b=b&&b.breakArray;if(!b||!d(a))return a;var g;for(g=0;g<b.length;g++){var l=
b[g];if(l.from>=a)break;else l.to<a?a+=l.len:h.isInBreak(l,a)&&(a+=l.len)}return a};h.val2Lin=function(a){var b=this.brokenAxis;b=b&&b.breakArray;if(!b||!d(a))return a;var g=a,l;for(l=0;l<b.length;l++){var q=b[l];if(q.to<=a)g-=q.len;else if(q.from>=a)break;else if(h.isInBreak(q,a)){g-=a-q.from;break}}return g};h.prototype.findBreakAt=function(a,b){return H(b,function(b){return b.from<a&&a<b.to})};h.prototype.isInAnyBreak=function(a,g){var l=this.axis,q=l.options.breaks||[],p=q.length,t;if(p&&d(a)){for(;p--;)if(h.isInBreak(q[p],
a)){var u=!0;t||(t=b(q[p].showPoints,!l.isXAxis))}var k=u&&g?u&&!t:u}return k};h.prototype.setBreaks=function(g,l){var q=this,p=q.axis,n=D(g)&&!!g.length;p.isDirty=q.hasBreaks!==n;q.hasBreaks=n;p.options.breaks=p.userOptions.breaks=g;p.forceRedraw=!0;p.series.forEach(function(a){a.isDirty=!0});n||p.val2lin!==h.val2Lin||(delete p.val2lin,delete p.lin2val);n&&(p.userOptions.ordinal=!1,p.lin2val=h.lin2Val,p.val2lin=h.val2Lin,p.setExtremes=function(b,d,k,m,f){if(q.hasBreaks){for(var c=this.options.breaks||
[],e;e=q.findBreakAt(b,c);)b=e.to;for(;e=q.findBreakAt(d,c);)d=e.from;d<b&&(d=b)}a.prototype.setExtremes.call(this,b,d,k,m,f)},p.setAxisTranslation=function(){a.prototype.setAxisTranslation.call(this);q.unitLength=void 0;if(q.hasBreaks){var t=p.options.breaks||[],u=[],k=[],m=b(p.pointRangePadding,0),f=0,c,e=p.userMin||p.min,z=p.userMax||p.max,g;t.forEach(function(a){c=a.repeat||Infinity;d(e)&&d(z)&&(h.isInBreak(a,e)&&(e+=a.to%c-e%c),h.isInBreak(a,z)&&(z-=z%c-a.from%c))});t.forEach(function(a){N=a.from;
c=a.repeat||Infinity;if(d(e)&&d(z)){for(;N-c>e;)N-=c;for(;N<e;)N+=c;for(g=N;g<z;g+=c)u.push({value:g,move:"in"}),u.push({value:g+a.to-a.from,move:"out",size:a.breakSize})}});u.sort(function(c,a){return c.value===a.value?("in"===c.move?0:1)-("in"===a.move?0:1):c.value-a.value});var l=0;var N=e;u.forEach(function(c){l+="in"===c.move?1:-1;1===l&&"in"===c.move&&(N=c.value);0===l&&d(N)&&(k.push({from:N,to:c.value,len:c.value-N-(c.size||0)}),f+=c.value-N-(c.size||0))});q.breakArray=k;d(e)&&d(z)&&d(p.min)&&
(q.unitLength=z-e-f+m,w(p,"afterBreaks"),p.staticScale?p.transA=p.staticScale:q.unitLength&&(p.transA*=(z-p.min+m)/q.unitLength),m&&(p.minPixelPadding=p.transA*(p.minPointOffset||0)),p.min=e,p.max=z)}});b(l,!0)&&p.chart.redraw()};return h}();l.Additions=q})(F||(F={}));return F});I(a,"masters/modules/broken-axis.src.js",[a["Core/Globals.js"],a["Core/Axis/BrokenAxis.js"]],function(a,v){v.compose(a.Axis,a.Series)});I(a,"Extensions/DataGrouping.js",[a["Core/Axis/Axis.js"],a["Core/Axis/DateTimeAxis.js"],
a["Core/FormatUtilities.js"],a["Core/Globals.js"],a["Core/Series/Point.js"],a["Core/Series/Series.js"],a["Core/Tooltip.js"],a["Core/DefaultOptions.js"],a["Core/Utilities.js"]],function(a,v,x,r,n,H,w,D,d){var b=x.format,F=H.prototype;x=d.addEvent;var l=d.arrayMax,A=d.arrayMin,P=d.correctFloat,J=d.defined,g=d.error,O=d.extend,p=d.isNumber,C=d.merge,h=d.pick;"";var q=r.approximations={sum:function(a){var b=a.length;if(!b&&a.hasNulls)var k=null;else if(b)for(k=0;b--;)k+=a[b];return k},average:function(a){var b=
a.length;a=q.sum(a);p(a)&&b&&(a=P(a/b));return a},averages:function(){var a=[];[].forEach.call(arguments,function(b){a.push(q.average(b))});return"undefined"===typeof a[0]?void 0:a},open:function(a){return a.length?a[0]:a.hasNulls?null:void 0},high:function(a){return a.length?l(a):a.hasNulls?null:void 0},low:function(a){return a.length?A(a):a.hasNulls?null:void 0},close:function(a){return a.length?a[a.length-1]:a.hasNulls?null:void 0},ohlc:function(a,b,k,m){a=q.open(a);b=q.high(b);k=q.low(k);m=q.close(m);
if(p(a)||p(b)||p(k)||p(m))return[a,b,k,m]},range:function(a,b){a=q.low(a);b=q.high(b);if(p(a)||p(b))return[a,b];if(null===a&&null===b)return null}};d=function(a,b,k,m){var f=this,c=f.data,e=f.options&&f.options.data,d=[],h=[],u=[],g=a.length,l=!!b,t=[],n=f.pointArrayMap,y=n&&n.length,A=["x"].concat(n||["y"]),w=this.options.dataGrouping&&this.options.dataGrouping.groupAll,F=0,B=0,D;m="function"===typeof m?m:q[m]?q[m]:q[f.getDGApproximation&&f.getDGApproximation()||"average"];y?n.forEach(function(){t.push([])}):
t.push([]);var v=y||1;for(D=0;D<=g&&!(a[D]>=k[0]);D++);for(D;D<=g;D++){for(;"undefined"!==typeof k[F+1]&&a[D]>=k[F+1]||D===g;){var r=k[F];f.dataGroupInfo={start:w?B:f.cropStart+B,length:t[0].length};var x=m.apply(f,t);f.pointClass&&!J(f.dataGroupInfo.options)&&(f.dataGroupInfo.options=C(f.pointClass.prototype.optionsToObject.call({series:f},f.options.data[f.cropStart+B])),A.forEach(function(c){delete f.dataGroupInfo.options[c]}));"undefined"!==typeof x&&(d.push(r),h.push(x),u.push(f.dataGroupInfo));
B=D;for(r=0;r<v;r++)t[r].length=0,t[r].hasNulls=!1;F+=1;if(D===g)break}if(D===g)break;if(n){r=f.options.dataGrouping&&f.options.dataGrouping.groupAll?D:f.cropStart+D;x=c&&c[r]||f.pointClass.prototype.applyOptions.apply({series:f},[e[r]]);var E=void 0;for(r=0;r<y;r++)E=x[n[r]],p(E)?t[r].push(E):null===E&&(t[r].hasNulls=!0)}else r=l?b[D]:null,p(r)?t[0].push(r):null===r&&(t[0].hasNulls=!0)}return{groupedXData:d,groupedYData:h,groupMap:u}};var E={approximations:q,groupData:d},y=F.processData,G=F.generatePoints,
M={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S","%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},B={line:{},spline:{},area:{},areaspline:{},
arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5}},L=r.defaultDataGroupingUnits=[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]];F.getDGApproximation=function(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("column")?"sum":"average"};F.groupData=d;F.processData=
function(){var a=this.chart,b=this.options.dataGrouping,k=!1!==this.allowDG&&b&&h(b.enabled,a.options.isStock),m=this.visible||!a.options.chart.ignoreHiddenSeries,f,c=this.currentDataGrouping,e=!1;this.forceCrop=k;this.groupPixelWidth=null;this.hasProcessed=!0;k&&!this.requireSorting&&(this.requireSorting=e=!0);k=!1===y.apply(this,arguments)||!k;e&&(this.requireSorting=!1);if(!k){this.destroyGroupedData();var d=b.groupAll?this.xData:this.processedXData,l=b.groupAll?this.yData:this.processedYData;
k=a.plotSizeX;e=this.xAxis;var q=e.options.ordinal,N=this.groupPixelWidth=e.getGroupPixelWidth&&e.getGroupPixelWidth();if(N&&d&&d.length){this.isDirty=f=!0;this.points=null;var n=e.getExtremes();var A=n.min;n=n.max;q=q&&e.ordinal&&e.ordinal.getGroupIntervalFactor(A,n,this)||1;k=e.getTimeTicks(v.AdditionsClass.prototype.normalizeTimeTickInterval(N*(n-A)/k*q,b.units||L),Math.min(A,d[0]),Math.max(n,d[d.length-1]),e.options.startOfWeek,d,this.closestPointRange);N=F.groupData.apply(this,[d,l,k,b.approximation]);
d=N.groupedXData;l=N.groupedYData;q=0;b&&b.smoothed&&d.length&&(b.firstAnchor="firstPoint",b.anchor="middle",b.lastAnchor="lastPoint",g(32,!1,a,{"dataGrouping.smoothed":"use dataGrouping.anchor"}));a=d;var r=this.options.dataGrouping;A=this.currentDataGrouping&&this.currentDataGrouping.gapSize;if(r&&this.xData&&A&&this.groupMap){var D=a.length-1;var w=r.anchor;var B=h(r.firstAnchor,w);r=h(r.lastAnchor,w);if(w&&"start"!==w){var C=A*{middle:.5,end:1}[w];for(w=a.length-1;w--&&0<w;)a[w]+=C}if(B&&"start"!==
B&&this.xData[0]>=a[0]){w=this.groupMap[0].start;C=this.groupMap[0].length;var x=void 0;p(w)&&p(C)&&(x=w+(C-1));a[0]={middle:a[0]+.5*A,end:a[0]+A,firstPoint:this.xData[0],lastPoint:x&&this.xData[x]}[B]}r&&"start"!==r&&A&&a[D]>=n-A&&(n=this.groupMap[this.groupMap.length-1].start,a[D]={middle:a[D]+.5*A,end:a[D]+A,firstPoint:n&&this.xData[n],lastPoint:this.xData[this.xData.length-1]}[r])}for(n=1;n<k.length;n++)k.info.segmentStarts&&-1!==k.info.segmentStarts.indexOf(n)||(q=Math.max(k[n]-k[n-1],q));n=
k.info;n.gapSize=q;this.closestPointRange=k.info.totalRange;this.groupMap=N.groupMap;if(m){m=d;if(J(m[0])&&p(e.min)&&p(e.dataMin)&&m[0]<e.min){if(!J(e.options.min)&&e.min<=e.dataMin||e.min===e.dataMin)e.min=Math.min(m[0],e.min);e.dataMin=Math.min(m[0],e.dataMin)}if(J(m[m.length-1])&&p(e.max)&&p(e.dataMax)&&m[m.length-1]>e.max){if(!J(e.options.max)&&p(e.dataMax)&&e.max>=e.dataMax||e.max===e.dataMax)e.max=Math.max(m[m.length-1],e.max);e.dataMax=Math.max(m[m.length-1],e.dataMax)}}b.groupAll&&(b=this.cropData(d,
l,e.min,e.max,1),d=b.xData,l=b.yData,this.cropStart=b.start);this.processedXData=d;this.processedYData=l}else this.groupMap=null;this.hasGroupedData=f;this.currentDataGrouping=n;this.preventGraphAnimation=(c&&c.totalRange)!==(n&&n.totalRange)}};F.destroyGroupedData=function(){this.groupedData&&(this.groupedData.forEach(function(a,b){a&&(this.groupedData[b]=a.destroy?a.destroy():null)},this),this.groupedData.length=0)};F.generatePoints=function(){G.apply(this);this.destroyGroupedData();this.groupedData=
this.hasGroupedData?this.points:null};x(n,"update",function(){if(this.dataGroup)return g(24,!1,this.series.chart),!1});x(w,"headerFormatter",function(a){var d=this.chart,k=d.time,m=a.labelConfig,f=m.series,c=f.tooltipOptions,e=f.options.dataGrouping,h=c.xDateFormat,g=f.xAxis,l=c[(a.isFooter?"footer":"header")+"Format"];if(g&&"datetime"===g.options.type&&e&&p(m.key)){var q=f.currentDataGrouping;e=e.dateTimeLabelFormats||M.dateTimeLabelFormats;if(q)if(c=e[q.unitName],1===q.count)h=c[0];else{h=c[1];
var t=c[2]}else!h&&e&&(h=this.getXDateFormat(m,c,g));h=k.dateFormat(h,m.key);t&&(h+=k.dateFormat(t,m.key+q.totalRange-1));f.chart.styledMode&&(l=this.styledModeFormat(l));a.text=b(l,{point:O(m.point,{key:h}),series:f},d);a.preventDefault()}});x(H,"destroy",F.destroyGroupedData);x(H,"afterSetOptions",function(a){a=a.options;var b=this.type,k=this.chart.options.plotOptions,m=D.defaultOptions.plotOptions[b].dataGrouping,f=this.useCommonDataGrouping&&M;if(B[b]||f){m||(m=C(M,B[b]));var c=this.chart.rangeSelector;
a.dataGrouping=C(f,m,k.series&&k.series.dataGrouping,k[b].dataGrouping,this.userOptions.dataGrouping,!a.isInternal&&c&&p(c.selected)&&c.buttonOptions[c.selected].dataGrouping)}});x(a,"afterSetScale",function(){this.series.forEach(function(a){a.hasProcessed=!1})});a.prototype.getGroupPixelWidth=function(){var a=this.series,b=a.length,k,m=0,f=!1,c;for(k=b;k--;)(c=a[k].options.dataGrouping)&&(m=Math.max(m,h(c.groupPixelWidth,M.groupPixelWidth)));for(k=b;k--;)(c=a[k].options.dataGrouping)&&a[k].hasProcessed&&
(b=(a[k].processedXData||a[k].data).length,a[k].groupPixelWidth||b>this.chart.plotSizeX/m||b&&c.forced)&&(f=!0);return f?m:0};a.prototype.setDataGrouping=function(b,d){var k;d=h(d,!0);b||(b={forced:!1,units:null});if(this instanceof a)for(k=this.series.length;k--;)this.series[k].update({dataGrouping:b},!1);else this.chart.options.series.forEach(function(a){a.dataGrouping=b},!1);this.ordinal&&(this.ordinal.slope=void 0);d&&this.chart.redraw()};r.dataGrouping=E;"";return E});I(a,"Series/OHLC/OHLCPoint.js",
[a["Core/Series/SeriesRegistry.js"]],function(a){var v=this&&this.__extends||function(){var a=function(r,n){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,n){a.__proto__=n}||function(a,n){for(var r in n)n.hasOwnProperty(r)&&(a[r]=n[r])};return a(r,n)};return function(r,n){function v(){this.constructor=r}a(r,n);r.prototype=null===n?Object.create(n):(v.prototype=n.prototype,new v)}}();return function(a){function r(){var n=null!==a&&a.apply(this,arguments)||this;n.close=void 0;n.high=
void 0;n.low=void 0;n.open=void 0;n.options=void 0;n.plotClose=void 0;n.plotOpen=void 0;n.series=void 0;return n}v(r,a);r.prototype.getClassName=function(){return a.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")};r.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)};r.prototype.resolveColor=function(){a.prototype.resolveColor.call(this);this.resolveUpColor()};
r.prototype.getZone=function(){var n=a.prototype.getZone.call(this);this.resolveUpColor();return n};return r}(a.seriesTypes.column.prototype.pointClass)});I(a,"Series/OHLC/OHLCSeries.js",[a["Series/OHLC/OHLCPoint.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,v,x){var r=this&&this.__extends||function(){var a=function(d,b){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var d in b)b.hasOwnProperty(d)&&(a[d]=b[d])};
return a(d,b)};return function(d,b){function n(){this.constructor=d}a(d,b);d.prototype=null===b?Object.create(b):(n.prototype=b.prototype,new n)}}(),n=v.seriesTypes.column,H=x.extend,w=x.merge;x=function(a){function d(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;b.yData=void 0;return b}r(d,a);d.prototype.drawPoints=function(){var a=this,d=a.chart,l=function(a,b,d){var g=a[0];a=a[1];"number"===typeof g[2]&&(g[2]=Math.max(d+b,g[2]));"number"===typeof a[2]&&
(a[2]=Math.min(d-b,a[2]))};a.points.forEach(function(b){var n=b.graphic,r=!n;if("undefined"!==typeof b.plotY){n||(b.graphic=n=d.renderer.path().add(a.group));d.styledMode||n.attr(a.pointAttribs(b,b.selected&&"select"));var g=n.strokeWidth();var w=g%2/2;var p=Math.round(b.plotX)-w;var C=Math.round(b.shapeArgs.width/2);var h=[["M",p,Math.round(b.yBottom)],["L",p,Math.round(b.plotHigh)]];if(null!==b.open){var q=Math.round(b.plotOpen)+w;h.push(["M",p,q],["L",p-C,q]);l(h,g/2,q)}null!==b.close&&(q=Math.round(b.plotClose)+
w,h.push(["M",p,q],["L",p+C,q]),l(h,g/2,q));n[r?"attr":"animate"]({d:h}).addClass(b.getClassName(),!0)}})};d.prototype.init=function(){a.prototype.init.apply(this,arguments);this.options.stacking=void 0};d.prototype.pointAttribs=function(b,d){d=a.prototype.pointAttribs.call(this,b,d);var l=this.options;delete d.fill;!b.options.color&&l.upColor&&b.open<b.close&&(d.stroke=l.upColor);return d};d.prototype.toYData=function(a){return[a.open,a.high,a.low,a.close]};d.prototype.translate=function(){var b=
this,d=b.yAxis,l=!!b.modifyValue,n=["plotOpen","plotHigh","plotLow","plotClose","yBottom"];a.prototype.translate.apply(b);b.points.forEach(function(a){[a.open,a.high,a.low,a.close,a.low].forEach(function(r,g){null!==r&&(l&&(r=b.modifyValue(r)),a[n[g]]=d.toPixels(r,!0))});a.tooltipPos[1]=a.plotHigh+d.pos-b.chart.plotTop})};d.defaultOptions=w(n.defaultOptions,{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},
threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0});return d}(n);H(x.prototype,{animate:null,directTouch:!1,pointArrayMap:["open","high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"});x.prototype.pointClass=a;v.registerSeriesType("ohlc",x);"";return x});I(a,"Series/Candlestick/CandlestickSeries.js",[a["Core/DefaultOptions.js"],a["Core/Color/Palette.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,v,x,r){var n=
this&&this.__extends||function(){var a=function(b,d){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var d in b)b.hasOwnProperty(d)&&(a[d]=b[d])};return a(b,d)};return function(b,d){function l(){this.constructor=b}a(b,d);b.prototype=null===d?Object.create(d):(l.prototype=d.prototype,new l)}}(),H=a.defaultOptions;a=x.seriesTypes;var w=a.column,D=a.ohlc,d=r.merge;r=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.data=
void 0;b.options=void 0;b.points=void 0;return b}n(b,a);b.prototype.pointAttribs=function(a,b){var d=w.prototype.pointAttribs.call(this,a,b),l=this.options,g=a.open<a.close,n=l.lineColor||this.color,p=a.color||this.color;d["stroke-width"]=l.lineWidth;d.fill=a.options.color||(g?l.upColor||p:p);d.stroke=a.options.lineColor||(g?l.upLineColor||n:n);b&&(a=l.states[b],d.fill=a.color||d.fill,d.stroke=a.lineColor||d.stroke,d["stroke-width"]=a.lineWidth||d["stroke-width"]);return d};b.prototype.drawPoints=
function(){var a=this,b=a.chart,d=a.yAxis.reversed;a.points.forEach(function(l){var g=l.graphic,n=!g;if("undefined"!==typeof l.plotY){g||(l.graphic=g=b.renderer.path().add(a.group));a.chart.styledMode||g.attr(a.pointAttribs(l,l.selected&&"select")).shadow(a.options.shadow);var p=g.strokeWidth()%2/2;var r=Math.round(l.plotX)-p;var h=l.plotOpen;var q=l.plotClose;var w=Math.min(h,q);h=Math.max(h,q);var y=Math.round(l.shapeArgs.width/2);q=d?h!==l.yBottom:Math.round(w)!==Math.round(l.plotHigh);var D=d?
Math.round(w)!==Math.round(l.plotHigh):h!==l.yBottom;w=Math.round(w)+p;h=Math.round(h)+p;p=[];p.push(["M",r-y,h],["L",r-y,w],["L",r+y,w],["L",r+y,h],["Z"],["M",r,w],["L",r,q?Math.round(d?l.yBottom:l.plotHigh):w],["M",r,h],["L",r,D?Math.round(d?l.plotHigh:l.yBottom):h]);g[n?"attr":"animate"]({d:p}).addClass(l.getClassName(),!0)}})};b.defaultOptions=d(D.defaultOptions,H.plotOptions,{states:{hover:{lineWidth:2}},tooltip:H.plotOptions.ohlc.tooltip,threshold:null,lineColor:v.neutralColor100,lineWidth:1,
upColor:v.backgroundColor,stickyTracking:!0});return b}(D);x.registerSeriesType("candlestick",r);"";return r});I(a,"Series/Flags/FlagsPoint.js",[a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"]],function(a,v){var x=this&&this.__extends||function(){var a=function(n,r){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,d){a.__proto__=d}||function(a,d){for(var b in d)d.hasOwnProperty(b)&&(a[b]=d[b])};return a(n,r)};return function(n,r){function w(){this.constructor=n}a(n,r);
n.prototype=null===r?Object.create(r):(w.prototype=r.prototype,new w)}}(),r=v.isNumber;return function(a){function n(){var n=null!==a&&a.apply(this,arguments)||this;n.options=void 0;n.series=void 0;return n}x(n,a);n.prototype.isValid=function(){return r(this.y)||"undefined"===typeof this.y};n.prototype.hasNewShapeType=function(){var a=this.options.shape||this.series.options.shape;return this.graphic&&a&&a!==this.graphic.symbolKey};return n}(a.seriesTypes.column.prototype.pointClass)});I(a,"Mixins/OnSeries.js",
[a["Series/Column/ColumnSeries.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,v,x){var r=a.prototype,n=v.prototype,H=x.defined,w=x.stableSort;return{getPlotBox:function(){return n.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)},translate:function(){r.translate.apply(this);var a=this,d=a.options,b=a.chart,n=a.points,l=n.length-1,v,x=d.onSeries;x=x&&b.get(x);d=d.onKey||"y";var O=x&&x.options.step,g=x&&x.points,I=g&&g.length,p=b.inverted,C=a.xAxis,
h=a.yAxis,q=0,E;if(x&&x.visible&&I){q=(x.pointXOffset||0)+(x.barW||0)/2;b=x.currentDataGrouping;var y=g[I-1].x+(b?b.totalRange:0);w(n,function(a,b){return a.x-b.x});for(d="plot"+d[0].toUpperCase()+d.substr(1);I--&&n[l];){var G=g[I];b=n[l];b.y=G.y;if(G.x<=b.x&&"undefined"!==typeof G[d]){if(b.x<=y&&(b.plotY=G[d],G.x<b.x&&!O&&(E=g[I+1])&&"undefined"!==typeof E[d])){var M=(b.x-G.x)/(E.x-G.x);b.plotY+=M*(E[d]-G[d]);b.y+=M*(E.y-G.y)}l--;I++;if(0>l)break}}}n.forEach(function(b,d){b.plotX+=q;if("undefined"===
typeof b.plotY||p)0<=b.plotX&&b.plotX<=C.len?p?(b.plotY=C.translate(b.x,0,1,0,1),b.plotX=H(b.y)?h.translate(b.y,0,0,0,1):0):b.plotY=(C.opposite?0:a.yAxis.len)+C.offset:b.shapeArgs={};if((v=n[d-1])&&v.plotX===b.plotX){"undefined"===typeof v.stackIndex&&(v.stackIndex=0);var g=v.stackIndex+1}b.stackIndex=g});this.onSeries=x}}});I(a,"Series/Flags/FlagsSymbols.js",[a["Core/Renderer/RendererRegistry.js"],a["Core/Renderer/SVG/SVGRenderer.js"]],function(a,v){function x(a){r[a+"pin"]=function(n,w,v,d,b){var x=
b&&b.anchorX;b=b&&b.anchorY;"circle"===a&&d>v&&(n-=Math.round((d-v)/2),v=d);var l=r[a](n,w,v,d);if(x&&b){var A=x;"circle"===a?A=n+v/2:(n=l[0],v=l[1],"M"===n[0]&&"L"===v[0]&&(A=(n[1]+v[1])/2));l.push(["M",A,w>b?w:w+d],["L",x,b]);l=l.concat(r.circle(x-1,b-1,2,2))}return l}}var r=v.prototype.symbols;r.flag=function(a,v,w,x,d){var b=d&&d.anchorX||a;d=d&&d.anchorY||v;var n=r.circle(b-1,d-1,2,2);n.push(["M",b,d],["L",a,v+x],["L",a,v],["L",a+w,v],["L",a+w,v+x],["L",a,v+x],["Z"]);return n};x("circle");x("square");
a=a.getRendererType();a!==v&&(a.prototype.symbols.circlepin=r.circlepin,a.prototype.symbols.flag=r.flag,a.prototype.symbols.squarepin=r.squarepin);return r});I(a,"Series/Flags/FlagsSeries.js",[a["Series/Flags/FlagsPoint.js"],a["Core/Globals.js"],a["Mixins/OnSeries.js"],a["Core/Color/Palette.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Utilities.js"]],function(a,v,x,r,n,H,w){var D=this&&this.__extends||function(){var a=function(b,d){a=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var d in b)b.hasOwnProperty(d)&&(a[d]=b[d])};return a(b,d)};return function(b,d){function h(){this.constructor=b}a(b,d);b.prototype=null===d?Object.create(d):(h.prototype=d.prototype,new h)}}(),d=v.noop,b=n.series,F=n.seriesTypes.column,l=w.addEvent,A=w.defined,I=w.extend,J=w.merge,g=w.objectEach,O=w.wrap;w=function(a){function d(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;
return b}D(d,a);d.prototype.animate=function(a){a&&this.setClip()};d.prototype.drawPoints=function(){var a=this.points,b=this.chart,d=b.renderer,l=b.inverted,n=this.options,p=n.y,r,w=this.yAxis,t={},u=[];for(r=a.length;r--;){var k=a[r];var m=(l?k.plotY:k.plotX)>this.xAxis.len;var f=k.plotX;var c=k.stackIndex;var e=k.options.shape||n.shape;var z=k.plotY;"undefined"!==typeof z&&(z=k.plotY+p-("undefined"!==typeof c&&c*n.stackDistance));k.anchorX=c?void 0:k.plotX;var K=c?void 0:k.plotY;var x="flag"!==
e;c=k.graphic;"undefined"!==typeof z&&0<=f&&!m?(c&&k.hasNewShapeType()&&(c=c.destroy()),c||(c=k.graphic=d.label("",null,null,e,null,null,n.useHTML).addClass("highcharts-point").add(this.markerGroup),k.graphic.div&&(k.graphic.div.point=k),c.isNew=!0),c.attr({align:x?"center":"left",width:n.width,height:n.height,"text-align":n.textAlign}),b.styledMode||c.attr(this.pointAttribs(k)).css(J(n.style,k.style)).shadow(n.shadow),0<f&&(f-=c.strokeWidth()%2),e={y:z,anchorY:K},n.allowOverlapX&&(e.x=f,e.anchorX=
k.anchorX),c.attr({text:k.options.title||n.title||"A"})[c.isNew?"attr":"animate"](e),n.allowOverlapX||(t[k.plotX]?t[k.plotX].size=Math.max(t[k.plotX].size,c.width):t[k.plotX]={align:x?.5:0,size:c.width,target:f,anchorX:f}),k.tooltipPos=[f,z+w.pos-b.plotTop]):c&&(k.graphic=c.destroy())}n.allowOverlapX||(g(t,function(a){a.plotX=a.anchorX;u.push(a)}),v.distribute(u,l?w.len:this.xAxis.len,100),a.forEach(function(a){var c=a.graphic&&t[a.plotX];c&&(a.graphic[a.graphic.isNew?"attr":"animate"]({x:c.pos+c.align*
c.size,anchorX:a.anchorX}),A(c.pos)?a.graphic.isNew=!1:(a.graphic.attr({x:-9999,anchorX:-9999}),a.graphic.isNew=!0))}));n.useHTML&&O(this.markerGroup,"on",function(a){return H.prototype.on.apply(a.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})};d.prototype.drawTracker=function(){var b=this.points;a.prototype.drawTracker.call(this);b.forEach(function(a){var d=a.graphic;d&&(a.unbindMouseOver&&a.unbindMouseOver(),a.unbindMouseOver=l(d.element,"mouseover",function(){0<a.stackIndex&&
!a.raised&&(a._y=d.y,d.attr({y:a._y-8}),a.raised=!0);b.forEach(function(b){b!==a&&b.raised&&b.graphic&&(b.graphic.attr({y:b._y}),b.raised=!1)})}))})};d.prototype.pointAttribs=function(a,b){var d=this.options,h=a&&a.color||this.color,g=d.lineColor,l=a&&a.lineWidth;a=a&&a.fillColor||d.fillColor;b&&(a=d.states[b].fillColor,g=d.states[b].lineColor,l=d.states[b].lineWidth);return{fill:a||h,stroke:g||h,"stroke-width":l||d.lineWidth||0}};d.prototype.setClip=function(){b.prototype.setClip.apply(this,arguments);
!1!==this.options.clip&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])};d.defaultOptions=J(F.defaultOptions,{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:r.backgroundColor,lineWidth:1,states:{hover:{lineColor:r.neutralColor100,fillColor:r.highlightColor20}},style:{fontSize:"11px",fontWeight:"bold"}});return d}(F);I(w.prototype,{allowDG:!1,buildKDTree:d,
forceCrop:!0,getPlotBox:x.getPlotBox,init:b.prototype.init,invertGroups:d,invertible:!1,noSharedTooltip:!0,pointClass:a,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],translate:x.translate});n.registerSeriesType("flags",w);"";"";return w});I(a,"Extensions/RangeSelector.js",[a["Core/Axis/Axis.js"],a["Core/Chart/Chart.js"],a["Core/Globals.js"],a["Core/DefaultOptions.js"],a["Core/Color/Palette.js"],a["Core/Renderer/SVG/SVGElement.js"],a["Core/Utilities.js"]],function(a,v,x,r,n,H,w){function D(a){if(-1!==
a.indexOf("%L"))return"text";var b="aAdewbBmoyY".split("").some(function(b){return-1!==a.indexOf("%"+b)}),d="HkIlMS".split("").some(function(b){return-1!==a.indexOf("%"+b)});return b&&d?"datetime-local":b?"date":d?"time":"text"}var d=r.defaultOptions,b=w.addEvent,F=w.createElement,l=w.css,A=w.defined,I=w.destroyObjectProperties,J=w.discardElement,g=w.extend,O=w.find,p=w.fireEvent,C=w.isNumber,h=w.merge,q=w.objectEach,E=w.pad,y=w.pick,G=w.pInt,M=w.splat;g(d,{rangeSelector:{allButtonsEnabled:!1,buttons:void 0,
buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%b %e, %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:n.highlightColor80,cursor:"pointer"},labelStyle:{color:n.neutralColor60}}});
g(d.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"\u2192"});var B=function(){function u(a){this.buttons=void 0;this.buttonOptions=u.prototype.defaultButtons;this.initialButtonGroupWidth=0;this.options=void 0;this.chart=a;this.init(a)}u.prototype.clickButton=function(d,m){var f=this.chart,c=this.buttonOptions[d],e=f.xAxis[0],k=f.scroller&&f.scroller.getUnionExtremes()||e||{},h=k.dataMin,g=k.dataMax,l=e&&Math.round(Math.min(e.max,y(g,e.max))),n=c.type;k=c._range;var u,q=c.dataGrouping;
if(null!==h&&null!==g){f.fixedRange=k;this.setSelected(d);q&&(this.forcedDataGrouping=!0,a.prototype.setDataGrouping.call(e||{chart:this.chart},q,!1),this.frozenStates=c.preserveDataGrouping);if("month"===n||"year"===n)if(e){n={range:c,max:l,chart:f,dataMin:h,dataMax:g};var r=e.minFromRange.call(n);C(n.newMax)&&(l=n.newMax)}else k=c;else if(k)r=Math.max(l-k,h),l=Math.min(r+k,g);else if("ytd"===n)if(e)"undefined"===typeof g&&(h=Number.MAX_VALUE,g=Number.MIN_VALUE,f.series.forEach(function(a){a=a.xData;
h=Math.min(a[0],h);g=Math.max(a[a.length-1],g)}),m=!1),l=this.getYTDExtremes(g,h,f.time.useUTC),r=u=l.min,l=l.max;else{this.deferredYTDClick=d;return}else"all"===n&&e&&(f.navigator&&f.navigator.baseSeries[0]&&(f.navigator.baseSeries[0].xAxis.options.range=void 0),r=h,l=g);A(r)&&(r+=c._offsetMin);A(l)&&(l+=c._offsetMax);this.dropdown&&(this.dropdown.selectedIndex=d+1);if(e)e.setExtremes(r,l,y(m,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:c});else{var t=M(f.options.xAxis)[0];var v=
t.range;t.range=k;var w=t.min;t.min=u;b(f,"load",function(){t.range=v;t.min=w})}p(this,"afterBtnClick")}};u.prototype.setSelected=function(a){this.selected=this.options.selected=a};u.prototype.init=function(a){var d=this,f=a.options.rangeSelector,c=f.buttons||d.defaultButtons.slice(),e=f.selected,k=function(){var a=d.minInput,c=d.maxInput;a&&a.blur&&p(a,"blur");c&&c.blur&&p(c,"blur")};d.chart=a;d.options=f;d.buttons=[];d.buttonOptions=c;this.eventsToUnbind=[];this.eventsToUnbind.push(b(a.container,
"mousedown",k));this.eventsToUnbind.push(b(a,"resize",k));c.forEach(d.computeButtonRange);"undefined"!==typeof e&&c[e]&&this.clickButton(e,!1);this.eventsToUnbind.push(b(a,"load",function(){a.xAxis&&a.xAxis[0]&&b(a.xAxis[0],"setExtremes",function(c){this.max-this.min!==a.fixedRange&&"rangeSelectorButton"!==c.trigger&&"updatedData"!==c.trigger&&d.forcedDataGrouping&&!d.frozenStates&&this.setDataGrouping(!1,!1)})}))};u.prototype.updateButtonStates=function(){var a=this,b=this.chart,d=this.dropdown,
c=b.xAxis[0],e=Math.round(c.max-c.min),h=!c.hasVisibleSeries,g=b.scroller&&b.scroller.getUnionExtremes()||c,l=g.dataMin,n=g.dataMax;b=a.getYTDExtremes(n,l,b.time.useUTC);var u=b.min,p=b.max,q=a.selected,r=C(q),t=a.options.allButtonsEnabled,v=a.buttons;a.buttonOptions.forEach(function(b,f){var k=b._range,m=b.type,g=b.count||1,z=v[f],K=0,w=b._offsetMax-b._offsetMin;b=f===q;var x=k>n-l,y=k<c.minRange,N=!1,B=!1;k=k===e;("month"===m||"year"===m)&&e+36E5>=864E5*{month:28,year:365}[m]*g-w&&e-36E5<=864E5*
{month:31,year:366}[m]*g+w?k=!0:"ytd"===m?(k=p-u+w===e,N=!b):"all"===m&&(k=c.max-c.min>=n-l,B=!b&&r&&k);m=!t&&(x||y||B||h);g=b&&k||k&&!r&&!N||b&&a.frozenStates;m?K=3:g&&(r=!0,K=2);z.state!==K&&(z.setState(K),d&&(d.options[f+1].disabled=m,2===K&&(d.selectedIndex=f+1)),0===K&&q===f&&a.setSelected())})};u.prototype.computeButtonRange=function(a){var b=a.type,d=a.count||1,c={millisecond:1,second:1E3,minute:6E4,hour:36E5,day:864E5,week:6048E5};if(c[b])a._range=c[b]*d;else if("month"===b||"year"===b)a._range=
864E5*{month:30,year:365}[b]*d;a._offsetMin=y(a.offsetMin,0);a._offsetMax=y(a.offsetMax,0);a._range+=a._offsetMax-a._offsetMin};u.prototype.getInputValue=function(a){a="min"===a?this.minInput:this.maxInput;var b=this.chart.options.rangeSelector,d=this.chart.time;return a?("text"===a.type&&b.inputDateParser||this.defaultInputDateParser)(a.value,d.useUTC,d):0};u.prototype.setInputValue=function(a,b){var d=this.options,c=this.chart.time,e="min"===a?this.minInput:this.maxInput;a="min"===a?this.minDateBox:
this.maxDateBox;if(e){var m=e.getAttribute("data-hc-time");m=A(m)?Number(m):void 0;A(b)&&(A(m)&&e.setAttribute("data-hc-time-previous",m),e.setAttribute("data-hc-time",b),m=b);e.value=c.dateFormat(this.inputTypeFormats[e.type]||d.inputEditDateFormat,m);a&&a.attr({text:c.dateFormat(d.inputDateFormat,m)})}};u.prototype.setInputExtremes=function(a,b,d){if(a="min"===a?this.minInput:this.maxInput){var c=this.inputTypeFormats[a.type],e=this.chart.time;c&&(b=e.dateFormat(c,b),a.min!==b&&(a.min=b),d=e.dateFormat(c,
d),a.max!==d&&(a.max=d))}};u.prototype.showInput=function(a){var b="min"===a?this.minDateBox:this.maxDateBox;if((a="min"===a?this.minInput:this.maxInput)&&b&&this.inputGroup){var d="text"===a.type,c=this.inputGroup,e=c.translateX;c=c.translateY;var k=this.options.inputBoxWidth;l(a,{width:d?b.width+(k?-2:20)+"px":"auto",height:d?b.height-2+"px":"auto",border:"2px solid silver"});d&&k?l(a,{left:e+b.x+"px",top:c+"px"}):l(a,{left:Math.min(Math.round(b.x+e-(a.offsetWidth-b.width)/2),this.chart.chartWidth-
a.offsetWidth)+"px",top:c-(a.offsetHeight-b.height)/2+"px"})}};u.prototype.hideInput=function(a){(a="min"===a?this.minInput:this.maxInput)&&l(a,{top:"-9999em",border:0,width:"1px",height:"1px"})};u.prototype.defaultInputDateParser=function(a,b,d){var c=a.split("/").join("-").split(" ").join("T");-1===c.indexOf("T")&&(c+="T00:00");if(b)c+="Z";else{var e;if(e=x.isSafari)e=c,e=!(6<e.length&&(e.lastIndexOf("-")===e.length-6||e.lastIndexOf("+")===e.length-6));e&&(e=(new Date(c)).getTimezoneOffset()/60,
c+=0>=e?"+"+E(-e)+":00":"-"+E(e)+":00")}c=Date.parse(c);C(c)||(a=a.split("-"),c=Date.UTC(G(a[0]),G(a[1])-1,G(a[2])));d&&b&&C(c)&&(c+=d.getTimezoneOffset(c));return c};u.prototype.drawInput=function(a){function b(){var b=k.getInputValue(a),c=f.xAxis[0],d=f.scroller&&f.scroller.xAxis?f.scroller.xAxis:c,e=d.dataMin;d=d.dataMax;var m=k.maxInput,g=k.minInput;b!==Number(v.getAttribute("data-hc-time-previous"))&&C(b)&&(v.setAttribute("data-hc-time-previous",b),r&&m&&C(e)?b>Number(m.getAttribute("data-hc-time"))?
b=void 0:b<e&&(b=e):g&&C(d)&&(b<Number(g.getAttribute("data-hc-time"))?b=void 0:b>d&&(b=d)),"undefined"!==typeof b&&c.setExtremes(r?b:c.min,r?c.max:b,void 0,void 0,{trigger:"rangeSelectorInput"}))}var f=this.chart,c=this.div,e=this.inputGroup,k=this,u=f.renderer.style||{},p=f.renderer,q=f.options.rangeSelector,r="min"===a,t=d.lang[r?"rangeSelectorFrom":"rangeSelectorTo"];t=p.label(t,0).addClass("highcharts-range-label").attr({padding:t?2:0,height:t?q.inputBoxHeight:0}).add(e);p=p.label("",0).addClass("highcharts-range-input").attr({padding:2,
width:q.inputBoxWidth,height:q.inputBoxHeight,"text-align":"center"}).on("click",function(){k.showInput(a);k[a+"Input"].focus()});f.styledMode||p.attr({stroke:q.inputBoxBorderColor,"stroke-width":1});p.add(e);var v=F("input",{name:a,className:"highcharts-range-selector"},void 0,c);v.setAttribute("type",D(q.inputDateFormat||"%b %e, %Y"));f.styledMode||(t.css(h(u,q.labelStyle)),p.css(h({color:n.neutralColor80},u,q.inputStyle)),l(v,g({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",
width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:u.fontSize,fontFamily:u.fontFamily,top:"-9999em"},q.inputStyle)));v.onfocus=function(){k.showInput(a)};v.onblur=function(){v===x.doc.activeElement&&b();k.hideInput(a);k.setInputValue(a);v.blur()};var w=!1;v.onchange=function(){w||(b(),k.hideInput(a),v.blur())};v.onkeypress=function(a){13===a.keyCode&&b()};v.onkeydown=function(a){w=!0;38!==a.keyCode&&40!==a.keyCode||b()};v.onkeyup=function(){w=!1};return{dateBox:p,input:v,label:t}};u.prototype.getPosition=
function(){var a=this.chart,b=a.options.rangeSelector;a="top"===b.verticalAlign?a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+b.buttonPosition.y,inputTop:a+b.inputPosition.y-10}};u.prototype.getYTDExtremes=function(a,b,d){var c=this.chart.time,e=new c.Date(a),f=c.get("FullYear",e);d=d?c.Date.UTC(f,0,1):+new c.Date(f,0,1);b=Math.max(b,d);e=e.getTime();return{max:Math.min(a||e,e),min:b}};u.prototype.render=function(a,b){var d=this.chart,c=d.renderer,e=d.container,m=d.options,k=m.rangeSelector,g=y(m.chart.style&&
m.chart.style.zIndex,0)+1;m=k.inputEnabled;if(!1!==k.enabled){this.rendered||(this.group=c.g("range-selector-group").attr({zIndex:7}).add(),this.div=F("div",void 0,{position:"relative",height:0,zIndex:g}),this.buttonOptions.length&&this.renderButtons(),e.parentNode&&e.parentNode.insertBefore(this.div,e),m&&(this.inputGroup=c.g("input-group").add(this.group),c=this.drawInput("min"),this.minDateBox=c.dateBox,this.minLabel=c.label,this.minInput=c.input,c=this.drawInput("max"),this.maxDateBox=c.dateBox,
this.maxLabel=c.label,this.maxInput=c.input));if(m&&(this.setInputValue("min",a),this.setInputValue("max",b),a=d.scroller&&d.scroller.getUnionExtremes()||d.xAxis[0]||{},A(a.dataMin)&&A(a.dataMax)&&(d=d.xAxis[0].minRange||0,this.setInputExtremes("min",a.dataMin,Math.min(a.dataMax,this.getInputValue("max"))-d),this.setInputExtremes("max",Math.max(a.dataMin,this.getInputValue("min"))+d,a.dataMax)),this.inputGroup)){var h=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(a){if(a){var b=
a.getBBox().width;b&&(a.attr({x:h}),h+=b+k.inputSpacing)}})}this.alignElements();this.rendered=!0}};u.prototype.renderButtons=function(){var a=this,m=this.buttons,f=this.options,c=d.lang,e=this.chart.renderer,g=h(f.buttonTheme),l=g&&g.states,n=g.width||28;delete g.width;delete g.states;this.buttonGroup=e.g("range-selector-buttons").add(this.group);var u=this.dropdown=F("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:.0001},this.div);
b(u,"touchstart",function(){u.style.fontSize="16px"});[[x.isMS?"mouseover":"mouseenter"],[x.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(c){var d=c[0],e=c[1];b(u,d,function(){var b=m[a.currentButtonIndex()];b&&p(b.element,e||d)})});this.zoomText=e.label(c&&c.rangeSelectorZoom||"",0).attr({padding:f.buttonTheme.padding,height:f.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup);this.chart.styledMode||(this.zoomText.css(f.labelStyle),g["stroke-width"]=y(g["stroke-width"],
0));F("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,u);this.buttonOptions.forEach(function(b,c){F("option",{textContent:b.title||b.text},void 0,u);m[c]=e.button(b.text,0,0,function(d){var e=b.events&&b.events.click,f;e&&(f=e.call(b,d));!1!==f&&a.clickButton(c);a.isActive=!0},g,l&&l.hover,l&&l.select,l&&l.disabled).attr({"text-align":"center",width:n}).add(a.buttonGroup);b.title&&m[c].attr("title",b.title)})};u.prototype.alignElements=function(){var a=this,b=this.buttonGroup,d=this.buttons,
c=this.chart,e=this.group,g=this.inputGroup,h=this.options,l=this.zoomText,n=c.options,u=n.exporting&&!1!==n.exporting.enabled&&n.navigation&&n.navigation.buttonOptions;n=h.buttonPosition;var p=h.inputPosition,q=h.verticalAlign,r=function(b,d){return u&&a.titleCollision(c)&&"top"===q&&"right"===d.align&&d.y-b.getBBox().height-12<(u.y||0)+(u.height||0)+c.spacing[0]?-40:0},t=c.plotLeft;if(e&&n&&p){var v=n.x-c.spacing[3];if(b){this.positionButtons();if(!this.initialButtonGroupWidth){var w=0;l&&(w+=l.getBBox().width+
5);d.forEach(function(a,b){w+=a.width;b!==d.length-1&&(w+=h.buttonSpacing)});this.initialButtonGroupWidth=w}t-=c.spacing[3];this.updateButtonStates();l=r(b,n);this.alignButtonGroup(l);e.placed=b.placed=c.hasLoaded}b=0;g&&(b=r(g,p),"left"===p.align?v=t:"right"===p.align&&(v=-Math.max(c.axisOffset[1],-b)),g.align({y:p.y,width:g.getBBox().width,align:p.align,x:p.x+v-2},!0,c.spacingBox),g.placed=c.hasLoaded);this.handleCollision(b);e.align({verticalAlign:q},!0,c.spacingBox);g=e.alignAttr.translateY;b=
e.getBBox().height+20;r=0;"bottom"===q&&(r=(r=c.legend&&c.legend.options)&&"bottom"===r.verticalAlign&&r.enabled&&!r.floating?c.legend.legendHeight+y(r.margin,10):0,b=b+r-20,r=g-b-(h.floating?0:h.y)-(c.titleOffset?c.titleOffset[2]:0)-10);if("top"===q)h.floating&&(r=0),c.titleOffset&&c.titleOffset[0]&&(r=c.titleOffset[0]),r+=c.margin[0]-c.spacing[0]||0;else if("middle"===q)if(p.y===n.y)r=g;else if(p.y||n.y)r=0>p.y||0>n.y?r-Math.min(p.y,n.y):g-b;e.translate(h.x,h.y+Math.floor(r));n=this.minInput;p=
this.maxInput;g=this.dropdown;h.inputEnabled&&n&&p&&(n.style.marginTop=e.translateY+"px",p.style.marginTop=e.translateY+"px");g&&(g.style.marginTop=e.translateY+"px")}};u.prototype.alignButtonGroup=function(a,b){var d=this.chart,c=this.buttonGroup,e=this.options.buttonPosition,m=d.plotLeft-d.spacing[3],k=e.x-d.spacing[3];"right"===e.align?k+=a-m:"center"===e.align&&(k-=m/2);c&&c.align({y:e.y,width:y(b,this.initialButtonGroupWidth),align:e.align,x:k},!0,d.spacingBox)};u.prototype.positionButtons=function(){var a=
this.buttons,b=this.chart,d=this.options,c=this.zoomText,e=b.hasLoaded?"animate":"attr",g=d.buttonPosition,h=b.plotLeft,l=h;c&&"hidden"!==c.visibility&&(c[e]({x:y(h+g.x,h)}),l+=g.x+c.getBBox().width+5);this.buttonOptions.forEach(function(b,c){if("hidden"!==a[c].visibility)a[c][e]({x:l}),l+=a[c].width+d.buttonSpacing;else a[c][e]({x:h})})};u.prototype.handleCollision=function(a){var b=this,d=this.chart,c=this.buttonGroup,e=this.inputGroup,k=this.options,g=k.buttonPosition,h=k.dropdown,l=k.inputPosition;
k=function(){var a=0;b.buttons.forEach(function(b){b=b.getBBox();b.width>a&&(a=b.width)});return a};var n=function(b){if(e&&c){var d=e.alignAttr.translateX+e.alignOptions.x-a+e.getBBox().x+2,f=e.alignOptions.width,m=c.alignAttr.translateX+c.getBBox().x;return m+b>d&&d+f>m&&g.y<l.y+e.getBBox().height}return!1},p=function(){e&&c&&e.attr({translateX:e.alignAttr.translateX+(d.axisOffset[1]>=-a?0:-a),translateY:e.alignAttr.translateY+c.getBBox().height+10})};if(c){if("always"===h){this.collapseButtons(a);
n(k())&&p();return}"never"===h&&this.expandButtons()}e&&c?l.align===g.align||n(this.initialButtonGroupWidth+20)?"responsive"===h?(this.collapseButtons(a),n(k())&&p()):p():"responsive"===h&&this.expandButtons():c&&"responsive"===h&&(this.initialButtonGroupWidth>d.plotWidth?this.collapseButtons(a):this.expandButtons())};u.prototype.collapseButtons=function(a){var b=this.buttons,d=this.buttonOptions,c=this.chart,e=this.dropdown,k=this.options,g=this.zoomText,h=c.userOptions.rangeSelector&&c.userOptions.rangeSelector.buttonTheme||
{},l=function(a){return{text:a?a+" \u25be":"\u25be",width:"auto",paddingLeft:y(k.buttonTheme.paddingLeft,h.padding,8),paddingRight:y(k.buttonTheme.paddingRight,h.padding,8)}};g&&g.hide();var n=!1;d.forEach(function(a,c){c=b[c];2!==c.state?c.hide():(c.show(),c.attr(l(a.text)),n=!0)});n||(e&&(e.selectedIndex=0),b[0].show(),b[0].attr(l(this.zoomText&&this.zoomText.textStr)));d=k.buttonPosition.align;this.positionButtons();"right"!==d&&"center"!==d||this.alignButtonGroup(a,b[this.currentButtonIndex()].getBBox().width);
this.showDropdown()};u.prototype.expandButtons=function(){var a=this.buttons,b=this.buttonOptions,d=this.options,c=this.zoomText;this.hideDropdown();c&&c.show();b.forEach(function(b,c){c=a[c];c.show();c.attr({text:b.text,width:d.buttonTheme.width||28,paddingLeft:y(d.buttonTheme.paddingLeft,"unset"),paddingRight:y(d.buttonTheme.paddingRight,"unset")});2>c.state&&c.setState(0)});this.positionButtons()};u.prototype.currentButtonIndex=function(){var a=this.dropdown;return a&&0<a.selectedIndex?a.selectedIndex-
1:0};u.prototype.showDropdown=function(){var a=this.buttonGroup,b=this.buttons,d=this.chart,c=this.dropdown;if(a&&c){var e=a.translateX;a=a.translateY;b=b[this.currentButtonIndex()].getBBox();l(c,{left:d.plotLeft+e+"px",top:a+.5+"px",width:b.width+"px",height:b.height+"px"});this.hasVisibleDropdown=!0}};u.prototype.hideDropdown=function(){var a=this.dropdown;a&&(l(a,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)};u.prototype.getHeight=function(){var a=this.options,b=this.group,
d=a.y,c=a.buttonPosition.y,e=a.inputPosition.y;if(a.height)return a.height;this.alignElements();a=b?b.getBBox(!0).height+13+d:0;b=Math.min(e,c);if(0>e&&0>c||0<e&&0<c)a+=Math.abs(b);return a};u.prototype.titleCollision=function(a){return!(a.options.title.text||a.options.subtitle.text)};u.prototype.update=function(a){var b=this.chart;h(!0,b.options.rangeSelector,a);this.destroy();this.init(b);this.render()};u.prototype.destroy=function(){var a=this,b=a.minInput,d=a.maxInput;a.eventsToUnbind&&(a.eventsToUnbind.forEach(function(a){return a()}),
a.eventsToUnbind=void 0);I(a.buttons);b&&(b.onfocus=b.onblur=b.onchange=null);d&&(d.onfocus=d.onblur=d.onchange=null);q(a,function(b,d){b&&"chart"!==d&&(b instanceof H?b.destroy():b instanceof window.HTMLElement&&J(b));b!==u.prototype[d]&&(a[d]=null)},this)};return u}();B.prototype.defaultButtons=[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},
{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}];B.prototype.inputTypeFormats={"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"};a.prototype.minFromRange=function(){var a=this.range,b=a.type,d=this.max,f=this.chart.time,c=function(a,c){var d="year"===b?"FullYear":"Month",e=new f.Date(a),m=f.get(d,e);f.set(d,e,m+c);m===f.get(d,e)&&f.set("Date",e,0);return e.getTime()-a};if(C(a)){var e=d-a;var g=a}else e=d+c(d,-a.count),this.chart&&(this.chart.fixedRange=
d-e);var h=y(this.dataMin,Number.MIN_VALUE);C(e)||(e=h);e<=h&&(e=h,"undefined"===typeof g&&(g=c(e,a.count)),this.newMax=Math.min(e+g,this.dataMax));C(d)||(e=void 0);return e};if(!x.RangeSelector){var L=[],t=function(a){function d(){f&&(m=a.xAxis[0].getExtremes(),c=a.legend,g=f&&f.options.verticalAlign,C(m.min)&&f.render(m.min,m.max),c.display&&"top"===g&&g===c.options.verticalAlign&&(e=h(a.spacingBox),e.y="vertical"===c.options.layout?a.plotTop:e.y+f.getHeight(),c.group.placed=!1,c.align(e)))}var m,
f=a.rangeSelector,c,e,g;f&&(O(L,function(b){return b[0]===a})||L.push([a,[b(a.xAxis[0],"afterSetExtremes",function(a){f&&f.render(a.min,a.max)}),b(a,"redraw",d)]]),d())};b(v,"afterGetContainer",function(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new B(this))});b(v,"beforeRender",function(){var a=this.axes,b=this.rangeSelector;b&&(C(b.deferredYTDClick)&&(b.clickButton(b.deferredYTDClick),delete b.deferredYTDClick),a.forEach(function(a){a.updateNames();a.setScale()}),
this.getAxisMargins(),b.render(),a=b.options.verticalAlign,b.options.floating||("bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0)))});b(v,"update",function(a){var b=a.options.rangeSelector;a=this.rangeSelector;var d=this.extraBottomMargin,f=this.extraTopMargin;b&&b.enabled&&!A(a)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=a=new B(this));this.extraTopMargin=this.extraBottomMargin=!1;a&&(t(this),b=b&&b.verticalAlign||a.options&&
a.options.verticalAlign,a.options.floating||("bottom"===b?this.extraBottomMargin=!0:"middle"!==b&&(this.extraTopMargin=!0)),this.extraBottomMargin!==d||this.extraTopMargin!==f)&&(this.isDirtyBox=!0)});b(v,"render",function(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,"bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))});b(v,"getMargins",function(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=
a),this.extraBottomMargin&&(this.marginBottom+=a))});v.prototype.callbacks.push(t);b(v,"destroy",function(){for(var a=0;a<L.length;a++){var b=L[a];if(b[0]===this){b[1].forEach(function(a){return a()});L.splice(a,1);break}}});x.RangeSelector=B}return B});I(a,"Core/Chart/StockChart.js",[a["Core/Animation/AnimationUtilities.js"],a["Core/Axis/Axis.js"],a["Core/Chart/Chart.js"],a["Core/FormatUtilities.js"],a["Core/DefaultOptions.js"],a["Core/Color/Palette.js"],a["Core/Series/Point.js"],a["Core/Series/Series.js"],
a["Core/Renderer/SVG/SVGRenderer.js"],a["Core/Utilities.js"]],function(a,v,x,r,n,H,w,D,d,b){function F(a,b){return"xAxis"===a?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:"yAxis"===a?{labels:{y:-2},opposite:u(b.opposite,!0),showLastLabel:!(!b.categories&&"category"!==b.type),title:{text:null}}:{}}function l(a,b){if("xAxis"===a){a=g();var c={type:"datetime",categories:void 0};u(b.navigator&&b.navigator.enabled,a.navigator.enabled,
!0)&&(c.startOnTick=!1,c.endOnTick=!1);return c}return{}}var A=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),I=a.animObject,J=r.format,g=n.getOptions,O=w.prototype.tooltipFormatter;a=D.prototype;
var p=a.init,C=a.processData;a=b.addEvent;var h=b.arrayMax,q=b.arrayMin,E=b.clamp,y=b.defined,G=b.extend,M=b.find,B=b.isNumber,L=b.isString,t=b.merge,u=b.pick,k=b.splat;b=function(a){function b(){return null!==a&&a.apply(this,arguments)||this}A(b,a);b.prototype.init=function(b,d){var c=g(),e=b.xAxis,f=b.yAxis,m=u(b.navigator&&b.navigator.enabled,c.navigator.enabled,!0);b.xAxis=b.yAxis=void 0;m=t({chart:{panning:{enabled:!0,type:"x"},pinchType:"x"},navigator:{enabled:m},scrollbar:{enabled:u(c.scrollbar&&
c.scrollbar.enabled,!0)},rangeSelector:{enabled:u(c.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:u(c.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},b,{isStock:!0});b.xAxis=e;b.yAxis=f;m.xAxis=k(b.xAxis||{}).map(function(a,d){return t(F("xAxis",a),c.xAxis,c.xAxis&&c.xAxis[d],a,l("xAxis",b))});m.yAxis=k(b.yAxis||{}).map(function(a,b){return t(F("yAxis",a),c.yAxis,c.yAxis&&c.yAxis[b],a)});a.prototype.init.call(this,m,d)};b.prototype.createAxis=function(b,d){d.axis=t(F(b,d.axis),
d.axis,l(b,this.userOptions));return a.prototype.createAxis.call(this,b,d)};return b}(x);(function(a){a.stockChart=function(b,c,d){return new a(b,c,d)}})(b||(b={}));a(D,"setOptions",function(a){var b;this.chart.options.isStock&&(this.is("column")||this.is("columnrange")?b={borderWidth:0,shadow:!1}:this.is("scatter")||this.is("sma")||(b={marker:{enabled:!1,radius:2}}),b&&(a.plotOptions[this.type]=t(a.plotOptions[this.type],b)))});a(v,"autoLabelAlign",function(a){var b=this.chart,c=this.options;b=b._labelPanes=
b._labelPanes||{};var d=this.options.labels;this.chart.options.isStock&&"yAxis"===this.coll&&(c=c.top+","+c.height,!b[c]&&d.enabled&&(15===d.x&&(d.x=0),"undefined"===typeof d.align&&(d.align="right"),b[c]=this,a.align="right",a.preventDefault()))});a(v,"destroy",function(){var a=this.chart,b=this.options&&this.options.top+","+this.options.height;b&&a._labelPanes&&a._labelPanes[b]===this&&delete a._labelPanes[b]});a(v,"getPlotLinePath",function(a){function b(a){var b="xAxis"===a?"yAxis":"xAxis";a=
c.options[b];return B(a)?[m[b][a]]:L(a)?[m.get(a)]:d.map(function(a){return a[b]})}var c=this,d=this.isLinked&&!this.series?this.linkedParent.series:this.series,m=c.chart,g=m.renderer,h=c.left,k=c.top,l,n,p,r,q=[],t=[],v=a.translatedValue,w=a.value,x=a.force;if(m.options.isStock&&!1!==a.acrossPanes&&"xAxis"===c.coll||"yAxis"===c.coll){a.preventDefault();t=b(c.coll);var C=c.isXAxis?m.yAxis:m.xAxis;C.forEach(function(a){if(y(a.options.id)?-1===a.options.id.indexOf("navigator"):1){var b=a.isXAxis?"yAxis":
"xAxis";b=y(a.options[b])?m[b][a.options[b]]:m[b][0];c===b&&t.push(a)}});var A=t.length?[]:[c.isXAxis?m.yAxis[0]:m.xAxis[0]];t.forEach(function(a){-1!==A.indexOf(a)||M(A,function(b){return b.pos===a.pos&&b.len===a.len})||A.push(a)});var D=u(v,c.translate(w,null,null,a.old));B(D)&&(c.horiz?A.forEach(function(a){var b;n=a.pos;r=n+a.len;l=p=Math.round(D+c.transB);"pass"!==x&&(l<h||l>h+c.width)&&(x?l=p=E(l,h,h+c.width):b=!0);b||q.push(["M",l,n],["L",p,r])}):A.forEach(function(a){var b;l=a.pos;p=l+a.len;
n=r=Math.round(k+c.height-D);"pass"!==x&&(n<k||n>k+c.height)&&(x?n=r=E(n,k,k+c.height):b=!0);b||q.push(["M",l,n],["L",p,r])}));a.path=0<q.length?g.crispPolyLine(q,a.lineWidth||1):null}});d.prototype.crispPolyLine=function(a,b){for(var c=0;c<a.length;c+=2){var d=a[c],f=a[c+1];d[1]===f[1]&&(d[1]=f[1]=Math.round(d[1])-b%2/2);d[2]===f[2]&&(d[2]=f[2]=Math.round(d[2])+b%2/2)}return a};a(v,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});a(v,"afterDrawCrosshair",
function(a){var b,c;if(this.crosshair&&this.crosshair.label&&this.crosshair.label.enabled&&this.cross&&B(this.min)&&B(this.max)){var d=this.chart,g=this.logarithmic,m=this.crosshair.label,h=this.horiz,k=this.opposite,l=this.left,n=this.top,p=this.crossLabel,r=m.format,q="",t="inside"===this.options.tickPosition,v=!1!==this.crosshair.snap,w=0,x=a.e||this.cross&&this.cross.e;a=a.point;var y=this.min,A=this.max;g&&(y=g.lin2log(y),A=g.lin2log(A));g=h?"center":k?"right"===this.labelAlign?"right":"left":
"left"===this.labelAlign?"left":"center";p||(p=this.crossLabel=d.renderer.label("",0,void 0,m.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(a?a.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:m.align||g,padding:u(m.padding,8),r:u(m.borderRadius,3),zIndex:2}).add(this.labelGroup),d.styledMode||p.attr({fill:m.backgroundColor||a&&a.series&&a.series.color||H.neutralColor60,stroke:m.borderColor||"","stroke-width":m.borderWidth||0}).css(G({color:H.backgroundColor,
fontWeight:"normal",fontSize:"11px",textAlign:"center"},m.style||{})));h?(g=v?(a.plotX||0)+l:x.chartX,n+=k?0:this.height):(g=k?this.width+l:0,n=v?(a.plotY||0)+n:x.chartY);r||m.formatter||(this.dateTime&&(q="%b %d, %Y"),r="{value"+(q?":"+q:"")+"}");q=v?this.isXAxis?a.x:a.y:this.toValue(h?x.chartX:x.chartY);v=a?a.series.isPointInside(a):B(q)&&q>y&&q<A;x="";r?x=J(r,{value:q},d):m.formatter&&B(q)&&(x=m.formatter.call(this,q));p.attr({text:x,x:g,y:n,visibility:v?"visible":"hidden"});m=p.getBBox();if(B(p.y))if(h){if(t&&
!k||!t&&k)n=p.y-m.height}else n=p.y-m.height/2;h?(b=l-m.x,c=l+this.width-m.x):(b="left"===this.labelAlign?l:0,c="right"===this.labelAlign?l+this.width:d.chartWidth);p.translateX<b&&(w=b-p.translateX);p.translateX+m.width>=c&&(w=-(p.translateX+m.width-c));p.attr({x:g+w,y:n,anchorX:h?g:this.opposite?0:d.chartWidth,anchorY:h?this.opposite?d.chartHeight:0:n+m.height/2})}});D.prototype.init=function(){p.apply(this,arguments);this.initCompare(this.options.compare)};D.prototype.setCompare=function(a){this.initCompare(a);
this.userOptions.compare=a};D.prototype.initCompare=function(a){this.modifyValue="value"===a||"percent"===a?function(b,c){var d=this.compareValue;return"undefined"!==typeof b&&"undefined"!==typeof d?(b="value"===a?b-d:b/d*100-(100===this.options.compareBase?0:100),c&&(c.change=b),b):0}:null;this.chart.hasRendered&&(this.isDirty=!0)};D.prototype.processData=function(a){var b,c=-1,d=!0===this.options.compareStart?0:1;C.apply(this,arguments);if(this.xAxis&&this.processedYData){var g=this.processedXData;
var m=this.processedYData;var h=m.length;this.pointArrayMap&&(c=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y"));for(b=0;b<h-d;b++){var k=m[b]&&-1<c?m[b][c]:m[b];if(B(k)&&g[b+d]>=this.xAxis.min&&0!==k){this.compareValue=k;break}}}};a(D,"afterGetExtremes",function(a){a=a.dataExtremes;if(this.modifyValue&&a){var b=[this.modifyValue(a.dataMin),this.modifyValue(a.dataMax)];a.dataMin=q(b);a.dataMax=h(b)}});v.prototype.setCompare=function(a,b){this.isXAxis||(this.series.forEach(function(b){b.setCompare(a)}),
u(b,!0)&&this.chart.redraw())};w.prototype.tooltipFormatter=function(a){var b=this.series.chart.numberFormatter;a=a.replace("{point.change}",(0<this.change?"+":"")+b(this.change,u(this.series.tooltipOptions.changeDecimals,2)));return O.apply(this,[a])};a(D,"render",function(){var a=this.chart;if(!(a.is3d&&a.is3d()||a.polar)&&this.xAxis&&!this.xAxis.isRadial&&!1!==this.options.clip){var b=this.yAxis.len;if(this.xAxis.axisLine){var c=a.plotTop+a.plotHeight-this.yAxis.pos-this.yAxis.len,d=Math.floor(this.xAxis.axisLine.strokeWidth()/
2);0<=c&&(b-=Math.max(d-c,0))}if(!a.hasLoaded||!this.clipBox&&this.isDirty&&!this.isDirtyData)this.clipBox=this.clipBox||t(a.clipBox),this.clipBox.width=this.xAxis.len,this.clipBox.height=b;a.hasRendered&&(c=I(this.options.animation),c=this.getSharedClipKey(c),d=a.sharedClips[c])&&(d.animate({width:this.xAxis.len,height:b}),(a=a.sharedClips[c+"m"])&&a.animate({width:this.xAxis.len}))}});a(x,"update",function(a){a=a.options;"scrollbar"in a&&this.navigator&&(t(!0,this.options.scrollbar,a.scrollbar),
this.navigator.update({},!1),delete a.scrollbar)});"";return b});I(a,"masters/modules/stock.src.js",[a["Core/Globals.js"],a["Core/Scrollbar.js"],a["Core/Chart/StockChart.js"]],function(a,v,x){a.Scrollbar=v;a.StockChart=a.stockChart=x.stockChart;v.compose(a.Axis)})});
//# sourceMappingURL=stock.js.map