'use strict';Object.defineProperty(exports,"__esModule",{value:true});var empty_1=require("./observable/empty");var of_1=require("./observable/of");var throwError_1=require("./observable/throwError");var NotificationKind;(function(NotificationKind){NotificationKind["NEXT"]="N";NotificationKind["ERROR"]="E";NotificationKind["COMPLETE"]="C"})(NotificationKind=exports.NotificationKind||(exports.NotificationKind={}));
var Notification=function(){function Notification(kind,value,error){this.kind=kind;this.value=value;this.error=error;this.hasValue=kind==="N"}Notification.prototype.observe=function(observer){switch(this.kind){case "N":return observer.next&&observer.next(this.value);case "E":return observer.error&&observer.error(this.error);case "C":return observer.complete&&observer.complete()}};Notification.prototype.do=function(next,error,complete){var kind=this.kind;switch(kind){case "N":return next&&next(this.value);
case "E":return error&&error(this.error);case "C":return complete&&complete()}};Notification.prototype.accept=function(nextOrObserver,error,complete){if(nextOrObserver&&typeof nextOrObserver.next==="function")return this.observe(nextOrObserver);else return this.do(nextOrObserver,error,complete)};Notification.prototype.toObservable=function(){var kind=this.kind;switch(kind){case "N":return of_1.of(this.value);case "E":return throwError_1.throwError(this.error);case "C":return empty_1.empty()}throw new Error("unexpected notification kind value");
};Notification.createNext=function(value){if(typeof value!=="undefined")return new Notification("N",value);return Notification.undefinedValueNotification};Notification.createError=function(err){return new Notification("E",undefined,err)};Notification.createComplete=function(){return Notification.completeNotification};Notification.completeNotification=new Notification("C");Notification.undefinedValueNotification=new Notification("N",undefined);return Notification}();exports.Notification=Notification;

