/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.fulib.fx.annotation.Route;
import org.fulib.fx.annotation.controller.Component;
import org.fulib.fx.annotation.controller.Controller;
import org.fulib.fx.annotation.controller.Resource;
import org.fulib.fx.annotation.controller.SubComponent;
import org.fulib.fx.annotation.controller.Title;
import org.fulib.fx.annotation.event.onKey;
import org.fulib.fx.annotation.param.Params;
import org.fulib.fx.annotation.param.ParamsMap;
import org.fulib.fx.util.ControllerUtil;
import org.fulib.fx.util.FrameworkUtil;

@SupportedAnnotationTypes(value={"org.fulib.fx.annotation.controller.*", "org.fulib.fx.annotation.Route", "org.fulib.fx.annotation.param.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@AutoService(value={Processor.class})
public class ControllerAnnotationProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Component.class)) {
            this.checkComponent(element);
            this.checkDoubleAnnotation(element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Controller.class)) {
            this.checkController(element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(SubComponent.class)) {
            this.checkSubComponentElement(element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Route.class)) {
            this.checkRoute(element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(ParamsMap.class)) {
            this.checkParamsMap(element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Params.class)) {
            this.checkParams(element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Resource.class)) {
            this.checkResources(element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Title.class)) {
            this.checkTitle(element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(onKey.class)) {
            this.checkOnKey(element);
        }
        return true;
    }

    private void checkOnKey(Element element) {
        ExecutableElement method;
        if (!(!(element instanceof ExecutableElement) || (method = (ExecutableElement)element).getParameters().isEmpty() || method.getParameters().size() == 1 && this.processingEnv.getTypeUtils().isAssignable(method.getParameters().get(0).asType(), this.processingEnv.getElementUtils().getTypeElement("javafx.scene.input.KeyEvent").asType()))) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)1010).formatted(method.getSimpleName(), method.getEnclosingElement().asType().toString()), method);
        }
    }

    private void checkResources(Element element) {
        String elementType = element.asType().toString();
        if (!this.processingEnv.getTypeUtils().isSubtype(element.asType(), this.processingEnv.getElementUtils().getTypeElement("java.util.ResourceBundle").asType())) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)2004).formatted(element.getSimpleName(), element.getEnclosingElement().getSimpleName()), element);
        }
    }

    private void checkTitle(Element element) {
        if (!this.isComponent(element.asType()) && !this.isController(element.asType())) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)1009), element);
        }
    }

    private void checkParams(Element element) {
        if (element instanceof ExecutableElement) {
            ExecutableElement method = (ExecutableElement)element;
            Params annotation = method.getAnnotation(Params.class);
            if (method.getParameters().size() != annotation.value().length) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)4006).formatted(method.getSimpleName(), method.getEnclosingElement().asType().toString()), method);
            }
        }
    }

    private void checkParamsMap(Element element) {
        ExecutableElement method;
        if (element instanceof ExecutableElement && (method = (ExecutableElement)element).getParameters().size() != 1) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)4003).formatted(method.getSimpleName(), method.getEnclosingElement().asType().toString()), method);
        }
    }

    private void checkRoute(Element element) {
        if (!element.asType().toString().startsWith("javax.inject.Provider")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)3004).formatted(element.getSimpleName(), element.asType().toString()), element);
            return;
        }
        for (TypeMirror typeMirror : ((DeclaredType)element.asType()).getTypeArguments()) {
            if (this.isController(typeMirror) || this.isComponent(typeMirror)) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)3003).formatted(element.getSimpleName(), element.asType().toString()), element);
        }
    }

    private void checkController(Element element) {
        String view = element.getAnnotation(Controller.class).view();
        if (!view.isEmpty()) {
            if (view.startsWith("#")) {
                this.checkViewMethod(element, view);
            } else {
                this.checkViewResource(element, view);
            }
        } else {
            this.checkViewResource(element, ControllerUtil.transform((String)element.getSimpleName().toString()) + ".fxml");
        }
    }

    private void checkComponent(Element element) {
        String view = element.getAnnotation(Component.class).view();
        if (!view.isEmpty()) {
            this.checkViewResource(element, view);
        }
        if (!this.processingEnv.getTypeUtils().isAssignable(element.asType(), this.processingEnv.getElementUtils().getTypeElement("javafx.scene.Parent").asType())) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)1006), element);
        }
    }

    private void checkDoubleAnnotation(Element element) {
        if (element.getAnnotation(Controller.class) != null && element.getAnnotation(Component.class) != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)1007), element);
        }
    }

    private void checkViewResource(Element element, String view) {
        try {
            FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, this.processingEnv.getElementUtils().getPackageOf(element).getQualifiedName().toString(), view);
        }
        catch (IOException e) {
            String viewPath = this.processingEnv.getElementUtils().getPackageOf(element).getQualifiedName().toString().replace('.', '/') + "/" + view;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)2000).formatted(viewPath), element);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, FrameworkUtil.note((int)2000));
        }
    }

    private void checkViewMethod(Element element, String view) {
        String methodName = view.substring(1);
        this.processingEnv.getElementUtils().getAllMembers((TypeElement)element).stream().filter(elem -> elem.getKind() == ElementKind.METHOD).filter(elem -> elem.getSimpleName().toString().equals(methodName)).map(elem -> (ExecutableElement)elem).findFirst().ifPresentOrElse(method -> {
            if (!method.getParameters().isEmpty()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)1008).formatted(method.getSimpleName(), method.getEnclosingElement().asType().toString()), (Element)method);
            }
            TypeMirror parent = this.processingEnv.getElementUtils().getTypeElement("javafx.scene.Parent").asType();
            if (!this.processingEnv.getTypeUtils().isAssignable(method.getReturnType(), parent)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)1002), (Element)method);
            }
        }, () -> this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)1003).formatted(methodName), element));
    }

    private void checkSubComponentElement(Element element) {
        DeclaredType type;
        TypeMirror componentType;
        TypeMirror typeMirror;
        if (this.isComponent(element.asType())) {
            return;
        }
        if (this.isProvider(element.asType()) && (typeMirror = element.asType()) instanceof DeclaredType && this.isComponent(componentType = (type = (DeclaredType)typeMirror).getTypeArguments().get(0))) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)6005).formatted(element.getSimpleName(), element.getEnclosingElement().asType().toString()), element);
    }

    private boolean isComponent(TypeMirror typeMirror) {
        DeclaredType declaredType = (DeclaredType)typeMirror;
        return declaredType.asElement().getAnnotation(Component.class) != null;
    }

    private boolean isController(TypeMirror typeMirror) {
        DeclaredType declaredType = (DeclaredType)typeMirror;
        return declaredType.asElement().getAnnotation(Controller.class) != null;
    }

    private boolean isProvider(TypeMirror typeMirror) {
        return typeMirror.toString().startsWith("javax.inject.Provider");
    }
}

