/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx;

import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class ProcessingHelper {
    private final ProcessingEnvironment processingEnv;

    public ProcessingHelper(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    Stream<TypeElement> streamSuperClasses(TypeElement clazz) {
        return Stream.iterate(clazz, Objects::nonNull, e -> (TypeElement)this.processingEnv.getTypeUtils().asElement(e.getSuperclass()));
    }

    Stream<ExecutableElement> streamAllMethods(TypeElement clazz, Class<? extends Annotation> annotation) {
        return this.streamAllMethods(clazz).filter(element -> element.getAnnotationsByType(annotation).length > 0);
    }

    Stream<ExecutableElement> streamAllMethods(TypeElement clazz) {
        return this.streamSuperClasses(clazz).flatMap(this::streamMethods);
    }

    Stream<ExecutableElement> streamMethods(TypeElement clazz, Class<? extends Annotation> annotation) {
        return this.streamMethods(clazz).filter(element -> element.getAnnotationsByType(annotation).length > 0);
    }

    Stream<ExecutableElement> streamMethods(TypeElement clazz) {
        return clazz.getEnclosedElements().stream().filter(element -> element instanceof ExecutableElement).map(element -> (ExecutableElement)element);
    }

    Stream<VariableElement> streamAllFields(TypeElement clazz, Class<? extends Annotation> annotation) {
        return this.streamAllFields(clazz).filter(element -> element.getAnnotationsByType(annotation).length > 0);
    }

    Stream<VariableElement> streamAllFields(TypeElement clazz) {
        return this.streamSuperClasses(clazz).flatMap(this::streamFields);
    }

    Stream<VariableElement> streamFields(TypeElement clazz, Class<? extends Annotation> annotation) {
        return this.streamFields(clazz).filter(element -> element.getAnnotationsByType(annotation).length > 0);
    }

    Stream<VariableElement> streamFields(TypeElement clazz) {
        return clazz.getEnclosedElements().stream().filter(element -> element instanceof VariableElement).map(element -> (VariableElement)element);
    }

    String stringLiteral(String value) {
        return this.processingEnv.getElementUtils().getConstantExpression(value);
    }

    boolean isProvider(TypeMirror typeMirror) {
        return typeMirror.toString().startsWith("javax.inject.Provider");
    }
}

