/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.fulib.fx.FxClassGenerator;
import org.fulib.fx.ProcessingHelper;
import org.fulib.fx.annotation.Route;
import org.fulib.fx.annotation.controller.Component;
import org.fulib.fx.annotation.controller.Controller;
import org.fulib.fx.annotation.controller.Resource;
import org.fulib.fx.annotation.controller.SubComponent;
import org.fulib.fx.annotation.controller.Title;
import org.fulib.fx.annotation.event.OnKey;
import org.fulib.fx.annotation.param.Params;
import org.fulib.fx.annotation.param.ParamsMap;
import org.fulib.fx.util.ControllerUtil;
import org.fulib.fx.util.FrameworkUtil;

@SupportedAnnotationTypes(value={"org.fulib.fx.annotation.controller.*", "org.fulib.fx.annotation.Route", "org.fulib.fx.annotation.param.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@AutoService(value={Processor.class})
public class FulibFxProcessor
extends AbstractProcessor {
    private FxClassGenerator generator;
    private ProcessingHelper helper;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.helper = new ProcessingHelper(processingEnv);
        this.generator = new FxClassGenerator(this.helper, processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        TypeElement typeElement;
        for (Element element : roundEnv.getElementsAnnotatedWith(Component.class)) {
            this.checkComponent(element);
            this.checkDoubleAnnotation(element);
            if (!(element instanceof TypeElement)) continue;
            typeElement = (TypeElement)element;
            this.checkEventModifiers(typeElement);
            this.generator.generateSidecar(typeElement);
            this.checkOverrides(typeElement);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Controller.class)) {
            this.checkController(element);
            if (!(element instanceof TypeElement)) continue;
            typeElement = (TypeElement)element;
            this.checkEventModifiers(typeElement);
            this.generator.generateSidecar(typeElement);
            this.checkOverrides(typeElement);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(SubComponent.class)) {
            this.checkSubComponentElement(element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Route.class)) {
            this.checkRoute(element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(ParamsMap.class)) {
            this.checkParamsMap(element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Params.class)) {
            this.checkParams(element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Resource.class)) {
            this.checkResources(element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Title.class)) {
            this.checkTitle(element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(OnKey.class)) {
            this.checkOnKey(element);
        }
        return true;
    }

    private void checkOverrides(TypeElement typeElement) {
        Map<String, List<ExecutableElement>> eventMethods = this.helper.streamAllMethods((TypeElement)this.processingEnv.getTypeUtils().asElement(typeElement.getSuperclass())).filter(this::isEventElement).collect(Collectors.groupingBy(method -> method.getSimpleName().toString()));
        typeElement.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD).map(e -> (ExecutableElement)e).filter(this::isEventElement).forEach(e -> this.checkOverrides((ExecutableElement)e, eventMethods));
    }

    private void checkOnKey(Element element) {
        ExecutableElement method;
        if (!(!(element instanceof ExecutableElement) || (method = (ExecutableElement)element).getParameters().isEmpty() || method.getParameters().size() == 1 && this.processingEnv.getTypeUtils().isAssignable(method.getParameters().get(0).asType(), this.processingEnv.getElementUtils().getTypeElement("javafx.scene.input.KeyEvent").asType()))) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)1010).formatted(method.getSimpleName(), method.getEnclosingElement().asType().toString()), method);
        }
    }

    private void checkResources(Element element) {
        String elementType = element.asType().toString();
        if (!this.processingEnv.getTypeUtils().isSubtype(element.asType(), this.processingEnv.getElementUtils().getTypeElement("java.util.ResourceBundle").asType())) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)2004).formatted(element.getSimpleName(), element.getEnclosingElement().getSimpleName()), element);
        }
    }

    private void checkTitle(Element element) {
        if (!this.isComponent(element.asType()) && !this.isController(element.asType())) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)1009), element);
        }
    }

    private void checkParams(Element element) {
        if (element instanceof ExecutableElement) {
            ExecutableElement method = (ExecutableElement)element;
            Params annotation = method.getAnnotation(Params.class);
            if (method.getParameters().size() != annotation.value().length) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)4006).formatted(method.getSimpleName(), method.getEnclosingElement().asType().toString()), method);
            }
        }
    }

    private void checkParamsMap(Element element) {
        ExecutableElement method;
        if (element instanceof ExecutableElement && (method = (ExecutableElement)element).getParameters().size() != 1) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)4003).formatted(method.getSimpleName(), method.getEnclosingElement().asType().toString()), method);
        }
    }

    private void checkRoute(Element element) {
        if (!element.asType().toString().startsWith("javax.inject.Provider")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)3004).formatted(element.getSimpleName(), element.asType().toString()), element);
            return;
        }
        for (TypeMirror typeMirror : ((DeclaredType)element.asType()).getTypeArguments()) {
            if (this.isController(typeMirror) || this.isComponent(typeMirror)) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)3003).formatted(element.getSimpleName(), element.asType().toString()), element);
        }
    }

    private void checkController(Element element) {
        String view = element.getAnnotation(Controller.class).view();
        if (!view.isEmpty()) {
            if (view.startsWith("#")) {
                this.checkViewMethod(element, view);
            } else {
                this.checkViewResource(element, view);
            }
        } else {
            this.checkViewResource(element, ControllerUtil.transform((String)element.getSimpleName().toString()) + ".fxml");
        }
    }

    private void checkComponent(Element element) {
        String view = element.getAnnotation(Component.class).view();
        if (!view.isEmpty()) {
            this.checkViewResource(element, view);
        }
        if (!this.processingEnv.getTypeUtils().isAssignable(element.asType(), this.processingEnv.getElementUtils().getTypeElement("javafx.scene.Node").asType())) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)1006), element);
        }
    }

    private void checkDoubleAnnotation(Element element) {
        if (element.getAnnotation(Controller.class) != null && element.getAnnotation(Component.class) != null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)1007), element);
        }
    }

    private void checkViewResource(Element element, String view) {
        String packageName = this.processingEnv.getElementUtils().getPackageOf(element).getQualifiedName().toString();
        while (view.startsWith("../")) {
            int index = packageName.lastIndexOf(46);
            if (index == -1) {
                String viewPath = packageName + "/" + view;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)2000).formatted(viewPath), element);
                return;
            }
            packageName = packageName.substring(0, index);
            view = view.substring(3);
        }
        try {
            FileObject index = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, packageName, view);
        }
        catch (IOException e) {
            String viewPath = packageName.replace('.', '/') + "/" + view;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)2000).formatted(viewPath), element);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, FrameworkUtil.note((int)2000));
        }
    }

    private void checkViewMethod(Element element, String view) {
        String methodName = view.substring(1);
        this.processingEnv.getElementUtils().getAllMembers((TypeElement)element).stream().filter(elem -> elem.getKind() == ElementKind.METHOD).filter(elem -> elem.getSimpleName().toString().equals(methodName)).map(elem -> (ExecutableElement)elem).findFirst().ifPresentOrElse(method -> {
            if (!method.getParameters().isEmpty()) {
                Name methodSimpleName = method.getSimpleName();
                String className = method.getEnclosingElement().asType().toString();
                String error = FrameworkUtil.error((int)1008).formatted(methodSimpleName, className);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error, (Element)method);
            }
            TypeMirror parent = this.processingEnv.getElementUtils().getTypeElement("javafx.scene.Parent").asType();
            if (!this.processingEnv.getTypeUtils().isAssignable(method.getReturnType(), parent)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)1002), (Element)method);
            }
        }, () -> this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)1003).formatted(methodName), element));
    }

    private void checkSubComponentElement(Element element) {
        DeclaredType type;
        TypeMirror componentType;
        TypeMirror typeMirror;
        if (this.isComponent(element.asType())) {
            return;
        }
        if (this.helper.isProvider(element.asType()) && (typeMirror = element.asType()) instanceof DeclaredType && this.isComponent(componentType = (type = (DeclaredType)typeMirror).getTypeArguments().get(0))) {
            return;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, FrameworkUtil.error((int)6005).formatted(element.getSimpleName(), element.getEnclosingElement().asType().toString()), element);
    }

    private boolean isComponent(TypeMirror typeMirror) {
        DeclaredType declaredType = (DeclaredType)typeMirror;
        return declaredType.asElement().getAnnotation(Component.class) != null;
    }

    private boolean isController(TypeMirror typeMirror) {
        DeclaredType declaredType = (DeclaredType)typeMirror;
        return declaredType.asElement().getAnnotation(Controller.class) != null;
    }

    private boolean isEventElement(Element element) {
        for (Class eventAnnotation : ControllerUtil.EVENT_ANNOTATIONS) {
            if (element.getAnnotation(eventAnnotation) == null) continue;
            return true;
        }
        return false;
    }

    private void checkOverrides(ExecutableElement method, Map<String, List<ExecutableElement>> eventMethods) {
        TypeElement element = (TypeElement)this.processingEnv.getTypeUtils().asElement(method.getEnclosingElement().asType());
        if (element.getSuperclass().getKind() == TypeKind.NONE) {
            return;
        }
        String methodName = method.getSimpleName().toString();
        if (!eventMethods.containsKey(methodName)) {
            return;
        }
        for (ExecutableElement parentMethod : eventMethods.get(methodName)) {
            if (!this.sameMethodSignature(method, parentMethod)) continue;
            Name className = element.getQualifiedName();
            Name parentClassName = ((TypeElement)parentMethod.getEnclosingElement()).getQualifiedName();
            String error = FrameworkUtil.error((int)1013).formatted(method, className, parentClassName);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error, method);
            break;
        }
    }

    private boolean sameMethodSignature(ExecutableElement method, ExecutableElement otherMethod) {
        ExecutableType methodType = (ExecutableType)method.asType();
        ExecutableType otherMethodType = (ExecutableType)otherMethod.asType();
        return method.getSimpleName().equals(otherMethod.getSimpleName()) && method.getParameters().size() == otherMethod.getParameters().size() && this.processingEnv.getTypeUtils().isSubsignature(methodType, otherMethodType);
    }

    private void checkEventModifiers(TypeElement clazz) {
        Stream.concat(this.helper.streamAllMethods(clazz), this.helper.streamAllFields(clazz)).filter(this::isEventElement).filter(element -> element.getModifiers().contains((Object)Modifier.PRIVATE)).forEach(element -> {
            String kind = element.getKind() == ElementKind.METHOD ? "method" : "field";
            Name name = element.getSimpleName();
            Name clazzName = clazz.getQualifiedName();
            String error = FrameworkUtil.error((int)1012).formatted(kind, name, clazzName);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error, (Element)element);
        });
    }
}

