/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.scene.input.KeyCode;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;
import org.fulib.fx.ProcessingHelper;
import org.fulib.fx.annotation.controller.Component;
import org.fulib.fx.annotation.controller.Controller;
import org.fulib.fx.annotation.controller.Resource;
import org.fulib.fx.annotation.controller.SubComponent;
import org.fulib.fx.annotation.controller.Title;
import org.fulib.fx.annotation.event.OnDestroy;
import org.fulib.fx.annotation.event.OnInit;
import org.fulib.fx.annotation.event.OnKey;
import org.fulib.fx.annotation.event.OnRender;
import org.fulib.fx.annotation.param.Param;
import org.fulib.fx.annotation.param.Params;
import org.fulib.fx.annotation.param.ParamsMap;
import org.fulib.fx.util.ControllerUtil;

public class FxClassGenerator {
    private static final String CLASS_SUFFIX = "_Fx";
    private final ProcessingEnvironment processingEnv;
    private final ProcessingHelper helper;
    private final TypeMirror parent;
    private final TypeMirror pane;

    public FxClassGenerator(ProcessingHelper helper, ProcessingEnvironment processingEnv) {
        this.helper = helper;
        this.processingEnv = processingEnv;
        this.parent = processingEnv.getElementUtils().getTypeElement("javafx.scene.Parent").asType();
        this.pane = processingEnv.getElementUtils().getTypeElement("javafx.scene.layout.Pane").asType();
    }

    public void generateSidecar(TypeElement componentClass) {
        try {
            JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(String.valueOf(componentClass.getQualifiedName()) + CLASS_SUFFIX, new Element[0]);
            try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
                this.generateSidecar(out, componentClass);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void generateSidecar(PrintWriter out, TypeElement componentClass) throws IOException {
        String className = componentClass.getQualifiedName().toString();
        String packageName = null;
        int lastDot = className.lastIndexOf(46);
        if (lastDot > 0) {
            packageName = className.substring(0, lastDot);
        }
        String simpleClassName = className.substring(lastDot + 1);
        String builderClassName = className + CLASS_SUFFIX;
        String builderSimpleClassName = builderClassName.substring(lastDot + 1);
        if (packageName != null) {
            out.println("package " + packageName + ";");
            out.println();
        }
        out.println("import java.util.Map;");
        out.println("import java.util.ResourceBundle;");
        out.println("import javafx.scene.Node;");
        out.println("import org.fulib.fx.annotation.event.OnKey;");
        out.println("import org.fulib.fx.controller.ControllerManager;");
        out.println("import org.fulib.fx.controller.internal.FxSidecar;");
        out.println();
        out.printf("public class %s implements FxSidecar<%s> {%n", builderSimpleClassName, simpleClassName);
        out.println("  private final ControllerManager controllerManager;");
        out.printf("  public %s(ControllerManager cm) {%n", builderSimpleClassName);
        out.println("    this.controllerManager = cm;");
        out.println("  }");
        out.println("  @Override");
        out.printf("  public void init(%s instance, Map<String, Object> params) {%n", simpleClassName);
        this.generateSidecarInit(out, componentClass);
        out.println("  }");
        out.println("  @Override");
        out.printf("  public Node render(%s instance, Map<String, Object> params) {%n", simpleClassName);
        this.generateSidecarRender(out, componentClass);
        out.println("  }");
        out.println("  @Override");
        out.printf("  public void destroy(%s instance) {%n", simpleClassName);
        this.generateSidecarDestroy(out, componentClass);
        out.println("  }");
        out.println("  @Override");
        out.printf("  public ResourceBundle getResources(%s instance) {%n", simpleClassName);
        this.generateSidecarResources(out, componentClass);
        out.println("  }");
        out.println("  @Override");
        out.printf("  public String getTitle(%s instance) {%n", simpleClassName);
        this.generateSidecarTitle(out, componentClass);
        out.println("  }");
        out.println("}");
    }

    private void generateSidecarInit(PrintWriter out, TypeElement componentClass) {
        this.generateParametersIntoFields(out, componentClass);
        this.generateCallParamMethods(out, componentClass, Param.class);
        this.generateCallParamMethods(out, componentClass, Params.class);
        this.generateCallParamMethods(out, componentClass, ParamsMap.class);
        this.generateCallInitMethods(out, componentClass);
        this.generateCallSubComponents(out, componentClass, "init");
    }

    private void generateParametersIntoFields(PrintWriter out, TypeElement componentClass) {
        this.helper.streamAllFields(componentClass, Param.class).forEach(field -> {
            Param param = field.getAnnotation(Param.class);
            String fieldName = field.getSimpleName().toString();
            String fieldType = field.asType().toString();
            String paramNameLiteral = this.helper.stringLiteral(param.value());
            out.printf("    if (params.containsKey(%s)) {%n", paramNameLiteral);
            String methodName = param.method();
            if (methodName != null && !methodName.isEmpty()) {
                AnnotationMirror paramMirror = field.getAnnotationMirrors().stream().filter(a -> "org.fulib.fx.annotation.param.Param".equals(a.getAnnotationType().toString())).findFirst().orElseThrow();
                String methodParamType = paramMirror.getElementValues().values().stream().map(Object::toString).filter(s -> s.endsWith(".class")).map(s -> s.substring(0, s.length() - 6)).findFirst().orElse("Object");
                out.printf("      instance.%s.%s((%s) params.get(%s));%n", fieldName, methodName, methodParamType, paramNameLiteral);
            } else {
                out.printf("      instance.%s = (%s) params.get(%s);%n", fieldName, fieldType, paramNameLiteral);
            }
            out.println("    }");
        });
        this.helper.streamAllFields(componentClass, ParamsMap.class).forEach(field -> {
            String fieldName = field.getSimpleName().toString();
            if (field.getModifiers().contains((Object)Modifier.FINAL)) {
                out.printf("    instance.%s.clear();%n", fieldName);
                out.printf("    instance.%s.putAll(params);%n", fieldName);
            } else {
                out.printf("    instance.%s = params;%n", fieldName);
            }
        });
    }

    private void generateCallInitMethods(PrintWriter out, TypeElement componentClass) {
        this.helper.streamAllMethods(componentClass, OnInit.class).sorted(Comparator.comparingInt(a -> a.getAnnotation(OnInit.class).value())).forEach(methodElement -> this.generateCall(out, (ExecutableElement)methodElement));
    }

    private void generateCallParamMethods(PrintWriter out, TypeElement componentClass, Class<? extends Annotation> annotation) {
        this.helper.streamAllMethods(componentClass, annotation).forEach(methodElement -> this.generateCall(out, (ExecutableElement)methodElement));
    }

    private void generateCall(PrintWriter out, ExecutableElement methodElement) {
        List<? extends VariableElement> parameters = methodElement.getParameters();
        List<String> arguments = Arrays.asList(new String[parameters.size()]);
        this.fillMethodArguments(methodElement, arguments, parameters);
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement parameter = parameters.get(i);
            Param paramAnnotation = parameter.getAnnotation(Param.class);
            if (paramAnnotation != null) {
                arguments.set(i, "(%s) params.get(%s)".formatted(parameter.asType(), this.helper.stringLiteral(paramAnnotation.value())));
                continue;
            }
            ParamsMap paramsMapAnnotation = parameter.getAnnotation(ParamsMap.class);
            if (paramsMapAnnotation == null) continue;
            arguments.set(i, "params");
        }
        out.printf("    instance.%s(%s);%n", methodElement.getSimpleName(), String.join((CharSequence)", ", arguments));
    }

    private void fillMethodArguments(ExecutableElement methodElement, List<String> arguments, List<? extends VariableElement> parameters) {
        ParamsMap paramsMapAnnotation;
        Params paramsAnnotation;
        Param paramAnnotation = methodElement.getAnnotation(Param.class);
        if (paramAnnotation != null) {
            arguments.set(0, "(%s) params.get(%s)".formatted(parameters.get(0).asType(), this.helper.stringLiteral(paramAnnotation.value())));
        }
        if ((paramsAnnotation = methodElement.getAnnotation(Params.class)) != null) {
            String[] paramNames = paramsAnnotation.value();
            for (int i = 0; i < paramNames.length; ++i) {
                VariableElement parameter = parameters.get(i);
                arguments.set(i, "(%s) params.get(%s)".formatted(parameter.asType(), this.helper.stringLiteral(paramNames[i])));
            }
        }
        if ((paramsMapAnnotation = methodElement.getAnnotation(ParamsMap.class)) != null) {
            arguments.set(0, "params");
        }
    }

    private void generateCallSubComponents(PrintWriter out, TypeElement componentClass, String method) {
        this.helper.streamAllFields(componentClass, SubComponent.class).forEach(field -> {
            if (field.asType().toString().startsWith("javax.inject.Provider")) {
                return;
            }
            String fieldName = field.getSimpleName().toString();
            out.printf("    this.controllerManager.%s(instance.%s, params);%n", method, fieldName);
        });
    }

    private void generateSidecarDestroy(PrintWriter out, TypeElement componentClass) {
        this.generateDestroySubComponents(out, componentClass);
        this.generateCallDestroyMethods(out, componentClass);
    }

    private void generateCallDestroyMethods(PrintWriter out, TypeElement componentClass) {
        this.helper.streamAllMethods(componentClass, OnDestroy.class).sorted(Comparator.comparingInt(a -> a.getAnnotation(OnDestroy.class).value())).forEach(element -> this.generateCall(out, (ExecutableElement)element));
    }

    private void generateDestroySubComponents(PrintWriter out, TypeElement componentClass) {
        ArrayList fieldNames = new ArrayList();
        this.helper.streamAllFields(componentClass, SubComponent.class).forEach(field -> {
            if (field.asType().toString().startsWith("javax.inject.Provider")) {
                return;
            }
            String fieldName = field.getSimpleName().toString();
            fieldNames.add(fieldName);
        });
        Collections.reverse(fieldNames);
        for (String fieldName : fieldNames) {
            out.printf("    this.controllerManager.destroy(instance.%s);%n", fieldName);
        }
    }

    private void generateSidecarRender(PrintWriter out, TypeElement componentClass) {
        this.generateCallSubComponents(out, componentClass, "render");
        this.generateRenderResult(out, componentClass);
        this.generateCallRenderMethods(out, componentClass);
        this.generateRegisterKeyEventHandlers(out, componentClass);
        out.println("    return result;");
    }

    private void generateRenderResult(PrintWriter out, TypeElement componentClass) {
        Component component = componentClass.getAnnotation(Component.class);
        Controller controller = componentClass.getAnnotation(Controller.class);
        if (component != null) {
            String view = component.view();
            if (view.isEmpty()) {
                out.println("    final Node result = instance;");
            } else {
                this.generateClearChildren(out, componentClass);
                out.printf("    final Node result = this.controllerManager.loadFXML(%s, instance, true);%n", this.helper.stringLiteral(view));
            }
        } else if (controller != null) {
            String view = controller.view();
            if (view.startsWith("#")) {
                out.printf("    final Node result = instance.%s();%n", view.substring(1));
            } else {
                String inferredView = view.isEmpty() ? ControllerUtil.transform((String)componentClass.getSimpleName().toString()) + ".fxml" : view;
                out.printf("    final Node result = this.controllerManager.loadFXML(%s, instance, false);%n", this.helper.stringLiteral(inferredView));
            }
        }
    }

    private void generateClearChildren(PrintWriter out, TypeElement componentClass) {
        if (this.processingEnv.getTypeUtils().isAssignable(componentClass.asType(), this.pane)) {
            out.println("    instance.getChildren().clear();");
        } else if (this.processingEnv.getTypeUtils().isAssignable(componentClass.asType(), this.parent)) {
            out.println("    org.fulib.fx.util.ReflectionUtil.getChildrenList(instance.getClass(), instance).clear();");
        }
    }

    private void generateCallRenderMethods(PrintWriter out, TypeElement componentClass) {
        this.helper.streamAllMethods(componentClass, OnRender.class).sorted(Comparator.comparingInt(a -> a.getAnnotation(OnRender.class).value())).forEach(element -> this.generateCall(out, (ExecutableElement)element));
    }

    private void generateRegisterKeyEventHandlers(PrintWriter out, TypeElement componentClass) {
        this.helper.streamAllMethods(componentClass, OnKey.class).forEach(method -> this.generateRegisterKeyEventHandler(out, componentClass, (ExecutableElement)method));
    }

    private void generateRegisterKeyEventHandler(PrintWriter out, TypeElement componentClass, ExecutableElement method) {
        for (OnKey onKey : (OnKey[])method.getAnnotationsByType(OnKey.class)) {
            out.printf("    controllerManager.addKeyEventHandler(instance, OnKey.Target.%s, OnKey.Type.%s.asEventType(), event -> {%n", onKey.target(), onKey.type());
            if (onKey.control()) {
                out.printf("      if (!event.isControlDown()) return;%n", new Object[0]);
            } else if (onKey.strict()) {
                out.printf("      if (event.isControlDown()) return;%n", new Object[0]);
            }
            if (onKey.shift()) {
                out.printf("      if (!event.isShiftDown()) return;%n", new Object[0]);
            } else if (onKey.strict()) {
                out.printf("      if (event.isShiftDown()) return;%n", new Object[0]);
            }
            if (onKey.alt()) {
                out.printf("      if (!event.isAltDown()) return;%n", new Object[0]);
            } else if (onKey.strict()) {
                out.printf("      if (event.isAltDown()) return;%n", new Object[0]);
            }
            if (onKey.meta()) {
                out.printf("      if (!event.isMetaDown()) return;%n", new Object[0]);
            } else if (onKey.strict()) {
                out.printf("      if (event.isMetaDown()) return;%n", new Object[0]);
            }
            if (onKey.code() != KeyCode.UNDEFINED) {
                out.printf("      if (event.getCode() != javafx.scene.input.KeyCode.%s) return;%n", new Object[]{onKey.code()});
            }
            if (!onKey.text().isEmpty()) {
                out.printf("      if (!%s.equals(event.getText())) return;%n", this.helper.stringLiteral(onKey.text()));
            }
            if (!"\u0000".equals(onKey.character())) {
                out.printf("      if (!%s.equals(event.getCharacter())) return;%n", this.helper.stringLiteral(onKey.character()));
            }
            out.printf("      instance.%s(%s);%n", method.getSimpleName(), method.getParameters().size() == 1 ? "event" : "");
            out.printf("    });%n", new Object[0]);
        }
    }

    private void generateSidecarResources(PrintWriter out, TypeElement componentClass) {
        this.helper.streamAllFields(componentClass, Resource.class).findFirst().ifPresentOrElse(field -> out.printf("    return instance.%s;%n", field.getSimpleName()), () -> out.println("    return controllerManager.getDefaultResourceBundle();"));
    }

    private void generateSidecarTitle(PrintWriter out, TypeElement componentClass) {
        Title title = componentClass.getAnnotation(Title.class);
        if (title == null) {
            out.println("    return null;");
            return;
        }
        if (title.value().startsWith("%")) {
            out.printf("    return getResources(instance).getString(%s);%n", this.helper.stringLiteral(title.value().substring(1)));
        } else if ("$name".equals(title.value())) {
            out.printf("    return %s;%n", this.helper.stringLiteral(ControllerUtil.transform((String)componentClass.getSimpleName().toString())));
        } else {
            out.printf("    return %s;%n", this.helper.stringLiteral(title.value()));
        }
    }
}

