/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx;

import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.disposables.DisposableContainer;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.util.Pair;
import org.fulib.fx.controller.AutoRefresher;
import org.fulib.fx.dagger.DaggerFrameworkComponent;
import org.fulib.fx.dagger.FrameworkComponent;
import org.fulib.fx.data.Either;
import org.fulib.fx.data.TraversableNodeTree;
import org.fulib.fx.util.ControllerUtil;
import org.fulib.fx.util.FrameworkUtil;
import org.fulib.fx.util.ReflectionUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FulibFxApp
extends Application {
    public static final Scheduler FX_SCHEDULER = Schedulers.from(Platform::runLater);
    public static final Logger LOGGER = Logger.getLogger(FulibFxApp.class.getName());
    private static Path resourcesPath = Path.of("src/main/resources", new String[0]);
    private FrameworkComponent frameworkComponent;
    private Stage stage;
    private Function<String, String> titlePattern = s -> s;
    private Object currentMainController;

    @NotNull
    public static Path resourcesPath() {
        return resourcesPath;
    }

    public static void setResourcesPath(@NotNull Path path) {
        resourcesPath = path;
    }

    @NotNull
    public <T extends Parent> T initAndRender(@NotNull String route) {
        return (T)this.initAndRender((T)route, Map.of());
    }

    @NotNull
    public <T extends Parent> T initAndRender(@NotNull T component) {
        return this.initAndRender(component, Map.of());
    }

    @NotNull
    public <T extends Parent> T initAndRender(@NotNull String route, @NotNull @NotNull Map<@NotNull String, @Nullable Object> params) {
        return (T)this.initAndRender((T)route, params, null);
    }

    @NotNull
    public <T extends Parent> T initAndRender(@NotNull T component, @NotNull @NotNull Map<@NotNull String, @Nullable Object> params) {
        return this.initAndRender(component, params, null);
    }

    @NotNull
    public <T extends Parent> T initAndRender(@NotNull String route, @NotNull @NotNull Map<@NotNull String, @Nullable Object> params, @Nullable DisposableContainer onDestroy2) {
        Object component = this.frameworkComponent.router().getController(route);
        if (!ControllerUtil.isComponent(component)) {
            throw new IllegalArgumentException(FrameworkUtil.error(1000).formatted(component.getClass().getName()));
        }
        return (T)this.initAndRender((Parent)component, params, onDestroy2);
    }

    @NotNull
    public <T extends Parent> T initAndRender(@NotNull T component, @NotNull @NotNull Map<@NotNull String, @Nullable Object> params, @Nullable DisposableContainer onDestroy2) {
        if (!ControllerUtil.isComponent(component)) {
            throw new IllegalArgumentException(FrameworkUtil.error(1000).formatted(component.getClass().getName()));
        }
        Disposable disposable = this.frameworkComponent.controllerManager().init(component, params, false);
        if (onDestroy2 != null) {
            onDestroy2.add(disposable);
        }
        Parent rendered = this.frameworkComponent().controllerManager().render(component, params);
        return (T)rendered;
    }

    @NotNull
    public <T extends Parent> T destroy(@NotNull T rendered) {
        this.frameworkComponent().controllerManager().destroy(rendered);
        return rendered;
    }

    @MustBeInvokedByOverriders
    public void start(Stage primaryStage) {
        this.stage = primaryStage;
        this.frameworkComponent = DaggerFrameworkComponent.builder().framework(this).build();
        Scene scene = new Scene((Parent)new Pane());
        this.stage.setScene(scene);
        this.stage.show();
    }

    public void stop() {
        this.cleanup();
        this.autoRefresher().close();
        System.exit(0);
    }

    @NotNull
    public Parent show(@NotNull String route) {
        return this.show(route, Map.of());
    }

    @NotNull
    public Parent show(@NotNull Object controller) {
        return this.show(controller, Map.of());
    }

    @NotNull
    public Parent show(@NotNull Object controller, @NotNull Map<String, Object> params) {
        if (!ControllerUtil.isController(controller)) {
            throw new IllegalArgumentException(FrameworkUtil.error(1001).formatted(controller.getClass().getName()));
        }
        this.cleanup();
        Parent renderedParent = this.frameworkComponent().controllerManager().initAndRender(controller, params);
        this.currentMainController = controller;
        this.frameworkComponent.router().addToHistory((Pair<Either<TraversableNodeTree.Node<Field>, Object>, Map<String, Object>>)new Pair(Either.right(controller), params));
        this.onShow(Optional.empty(), controller, renderedParent, params);
        this.display(renderedParent);
        this.getTitle(controller).ifPresent(title -> this.stage.setTitle(this.formatTitle((String)title)));
        return renderedParent;
    }

    @NotNull
    public Parent show(@NotNull String route, @NotNull @NotNull Map<@NotNull String, @Nullable Object> params) {
        Object controller;
        this.cleanup();
        Pair<Object, Parent> rendered = this.frameworkComponent.router().renderRoute(route, params);
        this.currentMainController = controller = rendered.getKey();
        this.display((Parent)rendered.getValue());
        this.getTitle(this.currentMainController).ifPresent(title -> this.stage.setTitle(this.formatTitle((String)title)));
        this.onShow(Optional.of(route), rendered.getKey(), (Parent)rendered.getValue(), params);
        return (Parent)rendered.getValue();
    }

    protected void display(@NotNull Parent parent) {
        this.stage.getScene().setRoot(parent);
    }

    protected void cleanup() {
        this.frameworkComponent.controllerManager().cleanup();
    }

    protected void onShow(Optional<String> route, Object controller, Parent rendered, Map<String, Object> params) {
    }

    public Stage stage() {
        return this.stage;
    }

    @ApiStatus.Internal
    public FrameworkComponent frameworkComponent() {
        return this.frameworkComponent;
    }

    public void registerRoutes(Object routes) {
        this.frameworkComponent.router().registerRoutes(routes);
    }

    public void setDefaultResourceBundle(ResourceBundle resourceBundle) {
        this.frameworkComponent.controllerManager().setDefaultResourceBundle(resourceBundle);
    }

    public AutoRefresher autoRefresher() {
        return this.frameworkComponent.autoRefresher();
    }

    public void back() {
        this.cleanup();
        Pair<Object, Parent> back = this.frameworkComponent.router().back();
        if (back != null) {
            this.currentMainController = back.getKey();
            this.display((Parent)back.getValue());
        }
    }

    public void forward() {
        this.cleanup();
        Pair<Object, Parent> forward = this.frameworkComponent.router().forward();
        if (forward != null) {
            this.currentMainController = forward.getKey();
            this.display((Parent)forward.getValue());
        }
    }

    public void refresh() {
        this.cleanup();
        Object controller = this.currentMainController;
        Map params = (Map)this.frameworkComponent.router().current().getValue();
        this.frameworkComponent.controllerManager().init(controller, params, true);
        Parent parent = this.frameworkComponent.controllerManager().render(controller, params);
        ReflectionUtil.resetMouseHandler(this.stage());
        this.display(parent);
    }

    public void setTitlePattern(Function<String, String> titlePattern) {
        this.titlePattern = titlePattern;
    }

    public void setTitlePattern(String titlePattern) {
        this.titlePattern = xva$0 -> titlePattern.formatted(xva$0);
    }

    public String formatTitle(String title) {
        return this.titlePattern.apply(title);
    }

    public Optional<String> getTitle(Object controller) {
        return this.frameworkComponent.controllerManager().getTitle(controller);
    }

    public void setHistorySize(int size) {
        this.frameworkComponent.router().setHistorySize(size);
    }
}

