/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.fulib.fx.data.SizeableTraversableQueue;
import org.fulib.fx.util.FrameworkUtil;

public class EvictingQueue<T>
implements SizeableTraversableQueue<T> {
    private int size;
    private final ArrayList<T> list;
    private int currentIndex = 0;

    public EvictingQueue(int size) {
        this.size = size;
        this.list = new ArrayList();
    }

    @Override
    public void insert(T value) {
        if (this.currentIndex < this.list.size() - 1) {
            this.list.subList(this.currentIndex + 1, this.list.size()).clear();
        }
        this.list.add(value);
        this.currentIndex = this.list.size() - 1;
        if (this.list.size() > this.size) {
            this.list.remove(0);
            --this.currentIndex;
        }
    }

    @Override
    public T peek() {
        return this.list.get(this.list.size() - 1);
    }

    @Override
    public T back() {
        if (this.currentIndex > 0) {
            return this.list.get(--this.currentIndex);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public T forward() {
        if (this.currentIndex < this.list.size() - 1) {
            return this.list.get(++this.currentIndex);
        }
        throw new IndexOutOfBoundsException(FrameworkUtil.error(5000));
    }

    @Override
    public T current() {
        if (this.list.isEmpty()) {
            throw new IndexOutOfBoundsException(FrameworkUtil.error(5001));
        }
        return this.list.get(this.currentIndex);
    }

    @Override
    public List<T> entries() {
        return Collections.unmodifiableList(this.list);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvictingQueue that = (EvictingQueue)o;
        return Objects.equals(this.list, that.list);
    }

    public int hashCode() {
        return Objects.hash(this.list, this.currentIndex, this.size);
    }

    @Override
    public int length() {
        return this.list.size();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void setSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Size must be at least 1");
        }
        if (size == this.size) {
            return;
        }
        if (this.currentIndex < this.list.size() - size) {
            throw new IllegalArgumentException("Cannot update size while the current index is outside the new bounds");
        }
        this.size = size;
        if (this.list.size() > size) {
            this.list.subList(0, this.list.size() - size).clear();
            this.currentIndex -= this.list.size() - size;
        }
    }
}

