/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.util;

import java.lang.reflect.Field;
import javafx.scene.Parent;
import org.fulib.fx.annotation.controller.Component;
import org.fulib.fx.annotation.controller.Controller;
import org.fulib.fx.controller.exception.InvalidRouteFieldException;
import org.fulib.fx.util.ReflectionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControllerUtil {
    private ControllerUtil() {
    }

    public static boolean isComponent(@Nullable Object instance) {
        return instance != null && instance.getClass().isAnnotationPresent(Component.class) && Parent.class.isAssignableFrom(instance.getClass());
    }

    public static boolean isController(@Nullable Object instance) {
        if (instance == null) {
            return false;
        }
        if (instance.getClass().isAnnotationPresent(Controller.class) && instance.getClass().isAnnotationPresent(Component.class)) {
            return false;
        }
        return instance.getClass().isAnnotationPresent(Controller.class) || ControllerUtil.isComponent(instance);
    }

    public static boolean canProvideSubComponent(Field field) {
        if (field.getType().isAnnotationPresent(Component.class) && Parent.class.isAssignableFrom(field.getType())) {
            return true;
        }
        Class<?> providedClass = ReflectionUtil.getProvidedClass(field);
        return providedClass != null && providedClass.isAnnotationPresent(Component.class) && Parent.class.isAssignableFrom(providedClass);
    }

    @NotNull
    public static String transform(@NotNull String className) {
        String[] classes = className.split("\\.");
        return classes[classes.length - 1].replace("Controller", "").replace("Component", "");
    }

    public static void requireControllerProvider(@NotNull Field field) {
        Class<?> providedClass = ReflectionUtil.getProvidedClass(field);
        if (providedClass == null || !providedClass.isAnnotationPresent(Controller.class) && !providedClass.isAnnotationPresent(Component.class)) {
            throw new InvalidRouteFieldException(field);
        }
    }
}

