/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.constructs;

import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javax.inject.Provider;
import org.fulib.fx.controller.ControllerManager;
import org.fulib.fx.util.ControllerUtil;
import org.fulib.fx.util.FrameworkUtil;
import org.fulib.fx.util.ReflectionUtil;
import org.jetbrains.annotations.NotNull;

public class For<Node extends Node, Item> {
    private Map<Item, Node> itemsToNodes;
    private CompositeDisposable disposable;
    private final ControllerManager controllerManager;
    private ObservableList<Item> items;
    private Provider<Node> provider;
    private Map<String, Object> params;
    private BiConsumer<Node, Item> beforeInit;
    private Parent container;
    private ObservableList<Node> children;
    private final ListChangeListener<Item> listChangeListener = change -> {
        while (change.next()) {
            int i;
            if (change.wasPermutated()) {
                for (i = change.getFrom(); i < change.getTo(); ++i) {
                    this.children.set(i, (Object)((Node)this.children.set(change.getPermutation(i), (Object)((Node)this.children.get(i)))));
                }
            }
            if (change.wasRemoved()) {
                for (Object item : change.getRemoved()) {
                    this.remove(item);
                }
            }
            if (!change.wasAdded()) continue;
            i = 0;
            for (Object item : change.getAddedSubList()) {
                this.add(item, change.getFrom() + i++);
            }
        }
    };

    protected For(ControllerManager controllerManager) {
        this.controllerManager = controllerManager;
        this.disposable().add(Disposable.fromRunnable(this::cleanup));
    }

    private void cleanup() {
        if (this.items != null) {
            this.items.removeListener(this.listChangeListener);
            this.items.forEach(this::remove);
        }
        this.children = null;
        this.itemsToNodes.clear();
        this.children = null;
        this.items = null;
        this.provider = null;
        this.params = null;
        this.container = null;
    }

    protected void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public Parent getContainer() {
        return this.container;
    }

    protected void setContainer(Parent container) {
        this.container = container;
        this.children = ReflectionUtil.getChildrenList(container.getClass(), container);
        this.init();
    }

    public ObservableList<Item> getItems() {
        return FXCollections.unmodifiableObservableList(this.items);
    }

    protected void setItems(ObservableList<Item> list) {
        this.items = list;
    }

    public Provider<Node> getProvider() {
        return this.provider;
    }

    protected void setProvider(Provider<Node> node) {
        this.provider = node;
    }

    protected void setBeforeInit(BiConsumer<Node, Item> beforeInit) {
        this.beforeInit = beforeInit;
    }

    protected void init() {
        if (this.container == null || this.provider == null || this.items == null) {
            return;
        }
        if (this.itemsToNodes != null) {
            throw new IllegalStateException(FrameworkUtil.error(7000));
        }
        this.itemsToNodes = new HashMap<Item, Node>();
        this.items.addListener(this.listChangeListener);
        this.clearUnused();
        for (int i = 0; i < this.items.size(); ++i) {
            this.add(this.items.get(i), i);
        }
    }

    private void remove(Item item) {
        Node node = (Node)this.itemsToNodes.get(item);
        if (ControllerUtil.isComponent(node)) {
            this.controllerManager.destroy(node);
        }
        this.itemsToNodes.remove(item);
        this.children.remove((Object)node);
    }

    private void add(Item item, int index) {
        if (this.itemsToNodes.containsKey(item)) {
            throw new IllegalArgumentException(FrameworkUtil.error(7001).formatted(item));
        }
        Node node = (Node)this.provider.get();
        if (this.beforeInit != null) {
            this.beforeInit.accept(node, item);
        }
        if (ControllerUtil.isComponent(node)) {
            this.controllerManager.init(node, this.params);
            this.controllerManager.render(node, this.params);
        }
        this.itemsToNodes.put(item, node);
        this.children.add(index, (Object)node);
    }

    private void clearUnused() {
        for (Object item : this.items) {
            if (this.itemsToNodes.containsKey(item)) continue;
            this.children.remove(this.itemsToNodes.get(item));
            this.itemsToNodes.remove(item);
        }
    }

    @NotNull
    public CompositeDisposable disposable() {
        if (this.disposable == null || this.disposable.isDisposed()) {
            this.disposable = new CompositeDisposable();
        }
        return this.disposable;
    }

    public void dispose() {
        if (this.disposable != null) {
            this.disposable.dispose();
        }
    }
}

