/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.util;

import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapUtil {
    private MapUtil() {
    }

    @Nullable
    public static <T, E> T keyForValue(@NotNull @NotNull Map<@NotNull T, @NotNull E> map, @NotNull E value) {
        Map.Entry keyEntry = map.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), value)).findFirst().orElse(null);
        return keyEntry == null ? null : (T)keyEntry.getKey();
    }

    @NotNull
    public static <T, E> E putIfNull(@NotNull @NotNull Map<@NotNull T, @NotNull E> map, @NotNull T key, @NotNull E value) {
        if (map.containsKey(key) && map.get(key) != null) {
            return map.get(key);
        }
        map.put(key, value);
        return value;
    }

    public static boolean isMapWithTypes(@NotNull Parameter parameter, @NotNull Class<?> key, @NotNull Class<?> value) {
        if (Map.class.isAssignableFrom(parameter.getType())) {
            Type genericType = parameter.getParameterizedType();
            return MapUtil.isMapWithTypes(genericType, key, value);
        }
        return false;
    }

    public static boolean isMapWithTypes(@NotNull Field field, @NotNull Class<?> key, @NotNull Class<?> value) {
        if (Map.class.isAssignableFrom(field.getType())) {
            Type genericType = field.getGenericType();
            return MapUtil.isMapWithTypes(genericType, key, value);
        }
        return false;
    }

    private static boolean isMapWithTypes(@NotNull Type type, @NotNull Class<?> key, @NotNull Class<?> value) {
        Type type2;
        ParameterizedType parameterizedType;
        Type[] typeArguments;
        if (type instanceof ParameterizedType && (typeArguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length == 2 && (type2 = typeArguments[0]) instanceof Class) {
            Class genericKey = (Class)type2;
            type2 = typeArguments[1];
            if (type2 instanceof Class) {
                Class genericValue = (Class)type2;
                return genericKey == key && genericValue == value;
            }
        }
        return false;
    }
}

