/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.util.reflection;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.fulib.fx.util.FrameworkUtil;
import org.jetbrains.annotations.NotNull;

public class Reflection {
    private Reflection() {
    }

    public static Stream<Field> getFieldsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(annotation));
    }

    public static void callMethodsForFieldInstances(Object instance, Collection<Field> fields, Consumer<Object> method) {
        for (Field field : fields) {
            try {
                boolean accessible = field.canAccess(instance);
                field.setAccessible(true);
                Object component = field.get(instance);
                field.setAccessible(accessible);
                method.accept(component);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(FrameworkUtil.error(9000).formatted(field.getName(), instance.getClass().getName()), e);
            }
        }
    }

    public static Stream<Field> getFieldsOfType(Class<?> clazz, Class<?> type) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.getType().equals(type));
    }

    public static Stream<Method> getMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        return Arrays.stream(clazz.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(annotation));
    }

    public static boolean canBeAssigned(Class<?> type, Object value) {
        if (value == null) {
            return !type.isPrimitive();
        }
        Class<?> valueType = value.getClass();
        return Reflection.getWrapperType(type).isAssignableFrom(valueType);
    }

    @NotNull
    public static Set<Field> getAllFields(@NotNull Class<?> clazz) {
        HashSet<Field> fields = new HashSet<Field>(Arrays.asList(clazz.getDeclaredFields()));
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            fields.addAll(Reflection.getAllFields(superClass));
        }
        return fields;
    }

    public static Class<?> getWrapperType(Class<?> type) {
        return type.isPrimitive() ? Reflection.wrap(type) : type;
    }

    public static <T> Class<T> wrap(Class<T> unwrapped) {
        return MethodType.methodType(unwrapped).wrap().returnType();
    }

    public static <T> Class<T> unwrap(Class<T> wrapped) {
        return MethodType.methodType(wrapped).unwrap().returnType();
    }
}

