/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.controller;

import dagger.Lazy;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.fulib.fx.FulibFxApp;
import org.fulib.fx.util.FileUtil;
import org.fulib.fx.util.FrameworkUtil;

@Singleton
public class AutoRefresher {
    private static final String FX_CONTROLLER_STRING = "fx:controller=\"%s\"";
    @Inject
    Lazy<FulibFxApp> framework;
    WatchService watchService;
    Disposable disposable;
    private boolean enabled = false;

    @Inject
    public AutoRefresher() {
    }

    public void setup(Path directory) {
        if (!FrameworkUtil.runningInDev()) {
            FulibFxApp.LOGGER.warning("AutoRefresher is only meant to be used in development mode! Not starting.");
            return;
        }
        this.enabled = true;
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
            WatchKey key = directory.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            AtomicLong lastModified = new AtomicLong(-1L);
            this.disposable = Schedulers.newThread().scheduleDirect(() -> {
                while (this.enabled) {
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path file = directory.resolve((Path)event.context());
                        if (file.toFile().lastModified() == lastModified.get()) continue;
                        lastModified.set(file.toFile().lastModified());
                        if (!file.getFileName().toString().contains(".fxml") || !FileUtil.getContent(file.toFile()).contains(String.format(FX_CONTROLLER_STRING, ((FulibFxApp)((Object)((Object)this.framework.get()))).frameworkComponent().router().current().getKey().getClass().getName()))) continue;
                        FulibFxApp.FX_SCHEDULER.scheduleDirect(() -> {
                            FulibFxApp.LOGGER.info("Reloading " + file.getFileName() + " because it was modified.");
                            ((FulibFxApp)((Object)((Object)((Object)this.framework.get())))).refresh();
                        });
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(FrameworkUtil.error(9004), e);
        }
    }

    public void close() {
        try {
            this.enabled = false;
            if (this.watchService != null) {
                this.watchService.close();
            }
            if (this.disposable != null) {
                this.disposable.dispose();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(FrameworkUtil.error(9005), e);
        }
    }
}

