/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.controller;

import dagger.Lazy;
import io.reactivex.rxjava3.disposables.Disposable;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.BuilderFactory;
import javafx.util.Pair;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.fulib.fx.FulibFxApp;
import org.fulib.fx.annotation.controller.Component;
import org.fulib.fx.annotation.controller.Controller;
import org.fulib.fx.annotation.controller.Resource;
import org.fulib.fx.annotation.controller.SubComponent;
import org.fulib.fx.annotation.controller.Title;
import org.fulib.fx.annotation.event.onDestroy;
import org.fulib.fx.annotation.event.onInit;
import org.fulib.fx.annotation.event.onKey;
import org.fulib.fx.annotation.event.onRender;
import org.fulib.fx.annotation.param.Param;
import org.fulib.fx.annotation.param.Params;
import org.fulib.fx.annotation.param.ParamsMap;
import org.fulib.fx.controller.Subscriber;
import org.fulib.fx.controller.building.ControllerBuildFactory;
import org.fulib.fx.controller.exception.IllegalControllerException;
import org.fulib.fx.data.disposable.RefreshableCompositeDisposable;
import org.fulib.fx.util.ControllerUtil;
import org.fulib.fx.util.FileUtil;
import org.fulib.fx.util.FrameworkUtil;
import org.fulib.fx.util.KeyEventHolder;
import org.fulib.fx.util.MapUtil;
import org.fulib.fx.util.ReflectionUtil;
import org.fulib.fx.util.reflection.Reflection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@Singleton
@ApiStatus.Internal
public class ControllerManager {
    private final RefreshableCompositeDisposable cleanup = new RefreshableCompositeDisposable();
    private static ResourceBundle defaultResourceBundle;
    private final Map<Object, Collection<KeyEventHolder>> keyEventHandlers = new HashMap<Object, Collection<KeyEventHolder>>();
    @Inject
    Lazy<FulibFxApp> app;

    @Inject
    public ControllerManager() {
    }

    public Node initAndRender(Object instance, Map<String, Object> parameters) {
        this.init(instance, parameters, true);
        return this.render(instance, parameters);
    }

    public Disposable init(@NotNull Object instance, @NotNull @NotNull Map<@NotNull String, @Nullable Object> parameters, boolean disposeOnNewMainController) {
        Disposable disposable = Disposable.fromRunnable(() -> this.destroy(instance));
        this.init(instance, parameters);
        if (disposeOnNewMainController) {
            this.cleanup.add(disposable);
        }
        return disposable;
    }

    public void init(@NotNull Object instance, @NotNull @NotNull Map<@NotNull String, @Nullable Object> parameters) {
        if (!ControllerUtil.isController(instance)) {
            throw new IllegalControllerException(FrameworkUtil.error(1001).formatted(instance.getClass().getName()));
        }
        this.fillParametersIntoFields(instance, parameters);
        this.callParamMethods(instance, parameters);
        this.callParamsMethods(instance, parameters);
        this.callParamsMapMethods(instance, parameters);
        this.callMethodsWithAnnotation(instance, onInit.class, parameters);
        Reflection.callMethodsForFieldInstances(instance, this.getSubComponentFields(instance), subController -> this.init(subController, parameters));
    }

    public Node render(Object instance, Map<String, Object> parameters) {
        Node node;
        String view;
        boolean component;
        boolean bl = component = instance.getClass().isAnnotationPresent(Component.class) && ControllerUtil.isComponent(instance);
        if (!component && !instance.getClass().isAnnotationPresent(Controller.class)) {
            throw new IllegalArgumentException(FrameworkUtil.error(1001).formatted(instance.getClass().getName()));
        }
        Reflection.callMethodsForFieldInstances(instance, this.getSubComponentFields(instance), subController -> this.render(subController, parameters));
        String string = view = component ? instance.getClass().getAnnotation(Component.class).view() : instance.getClass().getAnnotation(Controller.class).view();
        if (component) {
            if (view.isEmpty()) {
                node = (Node)instance;
            } else {
                Node root = (Node)instance;
                if (root instanceof Parent) {
                    Parent parent = (Parent)root;
                    ReflectionUtil.getChildrenList(instance.getClass(), parent).clear();
                }
                node = this.loadFXML(view, instance, true);
            }
        } else if (view.startsWith("#")) {
            String methodName = view.substring(1);
            try {
                Method method = instance.getClass().getDeclaredMethod(methodName, new Class[0]);
                if (method.getParameterCount() != 0) {
                    throw new RuntimeException(FrameworkUtil.error(1008).formatted(methodName, instance.getClass().getName()));
                }
                if (!Parent.class.isAssignableFrom(method.getReturnType())) {
                    throw new RuntimeException(FrameworkUtil.error(1002).formatted(methodName, instance.getClass().getName()));
                }
                method.setAccessible(true);
                node = (Parent)method.invoke(instance, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(FrameworkUtil.error(1003).formatted(methodName, instance.getClass().getName()), e);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(FrameworkUtil.error(1004).formatted(methodName, instance.getClass().getName()), e);
            }
        } else {
            String fxmlPath = view.isEmpty() ? ControllerUtil.transform(instance.getClass().getSimpleName()) + ".fxml" : view;
            node = this.loadFXML(fxmlPath, instance, false);
        }
        this.callMethodsWithAnnotation(instance, onRender.class, parameters);
        this.registerKeyEvents(instance);
        return node;
    }

    private void registerKeyEvents(Object instance) {
        Reflection.getMethodsWithAnnotation(instance.getClass(), onKey.class).forEach(method -> {
            onKey annotation = method.getAnnotation(onKey.class);
            EventType<KeyEvent> type = annotation.type().asEventType();
            EventHandler<KeyEvent> handler = this.createKeyEventHandler((Method)method, instance, annotation);
            this.keyEventHandlers.computeIfAbsent(instance, k -> new HashSet()).add(new KeyEventHolder(annotation.target(), type, handler));
            switch (annotation.target()) {
                case SCENE: {
                    ((FulibFxApp)((Object)((Object)this.app.get()))).stage().getScene().addEventFilter(type, handler);
                    break;
                }
                case STAGE: {
                    ((FulibFxApp)((Object)((Object)this.app.get()))).stage().addEventFilter(type, handler);
                }
            }
        });
    }

    public void destroy(@NotNull Object instance) {
        if (!ControllerUtil.isController(instance)) {
            throw new IllegalArgumentException(FrameworkUtil.error(1001).formatted(instance.getClass().getName()));
        }
        ArrayList<Field> subComponentFields = new ArrayList<Field>(this.getSubComponentFields(instance));
        Collections.reverse(subComponentFields);
        Reflection.callMethodsForFieldInstances(instance, subComponentFields, this::destroy);
        this.callMethodsWithAnnotation(instance, onDestroy.class, Map.of());
        this.cleanUpListeners(instance);
        if (FrameworkUtil.runningInDev()) {
            Reflection.getFieldsOfType(instance.getClass(), Subscriber.class).map(field -> {
                try {
                    field.setAccessible(true);
                    return new Pair(field, (Object)((Subscriber)field.get(instance)));
                }
                catch (IllegalAccessException e) {
                    return null;
                }
            }).filter(Objects::nonNull).filter(pair -> pair.getKey() != null).filter(pair -> !((Subscriber)pair.getValue()).isDisposed()).forEach(pair -> FulibFxApp.LOGGER.warning("Found undestroyed subscriber '%s' in class '%s'.".formatted(((Field)pair.getKey()).getName(), instance.getClass().getName())));
        }
    }

    public void cleanup() {
        this.cleanup.dispose();
        this.cleanup.refresh();
    }

    @NotNull
    private Node loadFXML(@NotNull String fileName, @NotNull Object instance, boolean setRoot) {
        URL url = instance.getClass().getResource(fileName);
        if (url == null) {
            String urlPath = instance.getClass().getPackageName().replace(".", "/") + "/" + fileName;
            throw new RuntimeException(FrameworkUtil.error(2000).formatted(urlPath));
        }
        File file = FileUtil.getResourceAsLocalFile(FulibFxApp.resourcesPath(), instance.getClass(), fileName);
        if (file.exists()) {
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(FrameworkUtil.error(2001).formatted(file.getAbsolutePath()), e);
            }
        }
        ControllerBuildFactory builderFactory = new ControllerBuildFactory(instance);
        FXMLLoader loader = new FXMLLoader(url);
        loader.setControllerFactory(c -> instance);
        loader.setBuilderFactory((BuilderFactory)builderFactory);
        ResourceBundle resourceBundle = ControllerManager.getResourceBundle(instance);
        if (resourceBundle != null) {
            loader.setResources(resourceBundle);
        }
        if (setRoot) {
            loader.setRoot(instance);
        }
        try {
            return (Node)loader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(FrameworkUtil.error(2002).formatted(instance.getClass()), exception);
        }
    }

    @Nullable
    private static ResourceBundle getResourceBundle(@NotNull Object instance) {
        List<Field> fields = Reflection.getAllFieldsWithAnnotation(instance.getClass(), Resource.class).toList();
        if (fields.isEmpty()) {
            return defaultResourceBundle;
        }
        if (fields.size() > 1) {
            throw new RuntimeException(FrameworkUtil.error(2003).formatted(instance.getClass().getName()));
        }
        return fields.stream().filter(field -> {
            if (field.getType().isAssignableFrom(ResourceBundle.class)) {
                return true;
            }
            throw new RuntimeException(FrameworkUtil.error(2004).formatted(field.getName(), instance.getClass().getName()));
        }).map(field -> {
            try {
                field.setAccessible(true);
                return (ResourceBundle)field.get(instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(FrameworkUtil.error(2005).formatted(field.getName(), instance.getClass().getName()), e);
            }
        }).filter(Objects::nonNull).findFirst().orElse(defaultResourceBundle);
    }

    private @Unmodifiable List<Field> getSubComponentFields(Object instance) {
        return Reflection.getAllFieldsWithAnnotation(instance.getClass(), SubComponent.class).filter(field -> {
            if (ControllerUtil.isComponent(field.getType())) {
                return true;
            }
            if (!ControllerUtil.canProvideSubComponent(field)) {
                FulibFxApp.LOGGER.warning(FrameworkUtil.error(6005).formatted(field.getName(), instance.getClass().getName()));
            }
            return false;
        }).toList();
    }

    private static Comparator<Method> annotationComparator(@NotNull Class<? extends Annotation> annotation) {
        return (m1, m2) -> {
            Object event1 = m1.getAnnotation(annotation);
            Object event2 = m2.getAnnotation(annotation);
            try {
                Method value = annotation.getDeclaredMethod("value", new Class[0]);
                return Integer.compare((Integer)value.invoke(event1, new Object[0]), (Integer)value.invoke(event2, new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                return 0;
            }
        };
    }

    private void callMethodsWithAnnotation(@NotNull Object instance, @NotNull Class<? extends Annotation> annotation, @NotNull @NotNull Map<@NotNull String, @Nullable Object> parameters) {
        for (Method method : Reflection.getAllMethodsWithAnnotation(instance.getClass(), annotation).sorted(ControllerManager.annotationComparator(annotation)).toList()) {
            try {
                method.setAccessible(true);
                method.invoke(instance, this.getApplicableParameters(method, parameters));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(FrameworkUtil.error(1005).formatted(method.getName(), annotation.getName(), instance.getClass().getName()), e);
            }
        }
    }

    private void fillParametersIntoFields(@NotNull Object instance, @NotNull @NotNull Map<@NotNull String, @Nullable Object> parameters) {
        for (Field field : Reflection.getAllFieldsWithAnnotation(instance.getClass(), Param.class).toList()) {
            Param paramAnnotation = field.getAnnotation(Param.class);
            String param = paramAnnotation.value();
            if (!parameters.containsKey(param)) continue;
            Class<?> fieldType = field.getType();
            try {
                field.setAccessible(true);
                Object value = parameters.get(param);
                Object fieldValue = field.get(instance);
                if (WritableValue.class.isAssignableFrom(fieldType) && !(value instanceof WritableValue)) {
                    if (fieldValue == null) {
                        throw new RuntimeException(FrameworkUtil.error(4001).formatted(param, field.getName(), instance.getClass().getName()));
                    }
                    try {
                        ((WritableValue)field.get(instance)).setValue(value);
                        continue;
                    }
                    catch (ClassCastException e) {
                        throw new RuntimeException(FrameworkUtil.error(4007).formatted(param, field.getName(), instance.getClass().getName(), fieldType.getName(), value == null ? "null" : value.getClass().getName()));
                    }
                }
                if (value == null) {
                    if (fieldType.isPrimitive()) {
                        throw new RuntimeException(FrameworkUtil.error(4007).formatted(param, field.getName(), instance.getClass().getName(), fieldType.getName(), "null"));
                    }
                    field.set(instance, null);
                    continue;
                }
                if (Reflection.canBeAssigned(fieldType, value)) {
                    field.set(instance, value);
                    continue;
                }
                throw new RuntimeException(FrameworkUtil.error(4007).formatted(param, field.getName(), instance.getClass().getName(), fieldType.getName(), value.getClass().getName()));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(FrameworkUtil.error(4000).formatted(param, field.getName(), instance.getClass().getName()), e);
            }
        }
        for (Field field : Reflection.getFieldsWithAnnotation(instance.getClass(), ParamsMap.class).toList()) {
            if (!MapUtil.isMapWithTypes(field, String.class, Object.class)) {
                throw new RuntimeException(FrameworkUtil.error(4002).formatted(field.getName(), instance.getClass().getName()));
            }
            try {
                field.setAccessible(true);
                if (Modifier.isFinal(field.getModifiers())) {
                    Map map = (Map)field.get(instance);
                    map.clear();
                    map.putAll(parameters);
                    continue;
                }
                field.set(instance, parameters);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(FrameworkUtil.error(4010).formatted(field.getName(), instance.getClass().getName()), e);
            }
        }
    }

    private void callParamMethods(Object instance, Map<String, Object> parameters) {
        Reflection.getAllMethodsWithAnnotation(instance.getClass(), Param.class).forEach(method -> {
            try {
                method.setAccessible(true);
                Object value = parameters.get(method.getAnnotation(Param.class).value());
                if (value == null) {
                    method.invoke(instance, new Object[]{null});
                    return;
                }
                if (!Reflection.canBeAssigned(method.getParameterTypes()[0], value)) {
                    throw new RuntimeException(FrameworkUtil.error(4008).formatted(method.getAnnotation(Param.class).value(), method.getName(), instance.getClass().getName(), method.getParameterTypes()[0].getName(), value.getClass().getName()));
                }
                method.invoke(instance, value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(FrameworkUtil.error(4005).formatted(method.getAnnotation(Param.class).value(), method.getName(), instance.getClass().getName()), e);
            }
        });
    }

    private void callParamsMethods(Object instance, Map<String, Object> parameters) {
        Reflection.getAllMethodsWithAnnotation(instance.getClass(), Params.class).forEach(method -> {
            try {
                method.setAccessible(true);
                String[] paramNames = method.getAnnotation(Params.class).value();
                if (method.getParameters().length != paramNames.length) {
                    throw new RuntimeException(FrameworkUtil.error(4006).formatted(method.getName(), instance.getClass().getName()));
                }
                Object[] methodParams = new Object[paramNames.length];
                for (int i = 0; i < paramNames.length; ++i) {
                    Object value = parameters.get(paramNames[i]);
                    if (!Reflection.canBeAssigned(method.getParameterTypes()[i], value)) {
                        throw new RuntimeException(FrameworkUtil.error(4008).formatted(paramNames[i], method.getName(), instance.getClass().getName(), method.getParameterTypes()[i].getName(), value.getClass().getName()));
                    }
                    methodParams[i] = value;
                }
                method.invoke(instance, methodParams);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(FrameworkUtil.error(4011).formatted(method.getName(), instance.getClass().getName()), e);
            }
        });
    }

    private void callParamsMapMethods(Object instance, Map<String, Object> parameters) {
        Reflection.getAllMethodsWithAnnotation(instance.getClass(), ParamsMap.class).forEach(method -> {
            if (method.getParameterCount() != 1 || !MapUtil.isMapWithTypes(method.getParameters()[0], String.class, Object.class)) {
                throw new RuntimeException(FrameworkUtil.error(4003).formatted(method.getName(), instance.getClass().getName()));
            }
            try {
                method.setAccessible(true);
                method.invoke(instance, parameters);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(FrameworkUtil.error(4010).formatted(method.getName(), instance.getClass().getName()), e);
            }
        });
    }

    private @Nullable Object @NotNull [] getApplicableParameters(@NotNull Method method, @NotNull Map<String, Object> parameters) {
        return Arrays.stream(method.getParameters()).map(parameter -> {
            Param param = parameter.getAnnotation(Param.class);
            ParamsMap paramsMap = parameter.getAnnotation(ParamsMap.class);
            if (param != null && paramsMap != null) {
                throw new RuntimeException(FrameworkUtil.error(4009).formatted(parameter.getName(), method.getName(), method.getDeclaringClass().getName()));
            }
            if (param != null) {
                if (parameters.containsKey(param.value()) && !Reflection.canBeAssigned(parameter.getType(), parameters.get(param.value()))) {
                    throw new RuntimeException(FrameworkUtil.error(4008).formatted(param.value(), method.getName(), method.getDeclaringClass().getName(), parameter.getType().getName(), parameters.get(param.value()).getClass().getName()));
                }
                return parameters.get(param.value());
            }
            if (paramsMap != null) {
                if (!MapUtil.isMapWithTypes(parameter, String.class, Object.class)) {
                    throw new RuntimeException(FrameworkUtil.error(4004).formatted(parameter.getName(), method.getName(), method.getDeclaringClass().getName()));
                }
                return parameters;
            }
            return null;
        }).toArray();
    }

    public void setDefaultResourceBundle(ResourceBundle resourceBundle) {
        defaultResourceBundle = resourceBundle;
    }

    private EventHandler<KeyEvent> createKeyEventHandler(Method method, Object instance, onKey annotation) {
        boolean hasEventParameter;
        boolean bl = hasEventParameter = method.getParameterCount() == 1 && method.getParameterTypes()[0].isAssignableFrom(KeyEvent.class);
        if (!hasEventParameter && method.getParameterCount() != 0) {
            throw new RuntimeException(FrameworkUtil.error(1010).formatted(method.getName(), instance.getClass().getName()));
        }
        method.setAccessible(true);
        return event -> {
            if (this.keyEventMatchesAnnotation((KeyEvent)event, annotation)) {
                try {
                    if (hasEventParameter) {
                        method.invoke(instance, event);
                    } else {
                        method.invoke(instance, new Object[0]);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(FrameworkUtil.error(1005).formatted(method.getName(), annotation.getClass().getSimpleName(), method.getClass()), e);
                }
            }
        };
    }

    private boolean keyEventMatchesAnnotation(KeyEvent event, onKey annotation) {
        return !(annotation.code() != KeyCode.UNDEFINED && event.getCode() != annotation.code() || !annotation.character().isEmpty() && !event.getCharacter().equals(annotation.character()) || !annotation.text().isEmpty() && !event.getText().equals(annotation.text()) || !event.isShiftDown() && annotation.shift() || !event.isControlDown() && annotation.control() || !event.isAltDown() && annotation.alt() || !event.isMetaDown() && annotation.meta());
    }

    private void cleanUpListeners(Object instance) {
        Collection<KeyEventHolder> handlers = this.keyEventHandlers.get(instance);
        if (handlers != null) {
            for (KeyEventHolder holder : handlers) {
                switch (holder.target()) {
                    case SCENE: {
                        ((FulibFxApp)((Object)this.app.get())).stage().getScene().removeEventFilter(holder.type(), holder.handler());
                        break;
                    }
                    case STAGE: {
                        ((FulibFxApp)((Object)this.app.get())).stage().removeEventFilter(holder.type(), holder.handler());
                    }
                }
            }
            this.keyEventHandlers.remove(instance);
        }
    }

    public Optional<String> getTitle(@NotNull Object instance) {
        if (!instance.getClass().isAnnotationPresent(Title.class)) {
            return Optional.empty();
        }
        String title = instance.getClass().getAnnotation(Title.class).value();
        if (title.startsWith("%")) {
            title = title.substring(1);
            ResourceBundle resourceBundle = ControllerManager.getResourceBundle(instance);
            if (resourceBundle != null) {
                return Optional.of(resourceBundle.getString(title));
            }
            throw new RuntimeException(FrameworkUtil.error(2006).formatted(title, instance.getClass().getName()));
        }
        if (title.equals("$name")) {
            return Optional.of(ControllerUtil.transform(instance.getClass().getSimpleName()));
        }
        return Optional.of(title);
    }
}

