/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.controller.building;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.util.Builder;
import javafx.util.BuilderFactory;
import javax.inject.Provider;
import org.fulib.fx.annotation.controller.Component;
import org.fulib.fx.annotation.controller.SubComponent;
import org.fulib.fx.controller.building.ControllerProxyBuilder;
import org.fulib.fx.util.FrameworkUtil;
import org.fulib.fx.util.ReflectionUtil;
import org.fulib.fx.util.reflection.Reflection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ControllerBuildFactory
implements BuilderFactory {
    private final Object instance;
    private final Map<Class<?>, List<Object>> subControllerInstances;
    private final Map<Class<?>, Provider<?>> subControllerProviders;

    public ControllerBuildFactory(@NotNull Object instance) {
        this.instance = instance;
        this.subControllerInstances = new HashMap();
        this.subControllerProviders = new HashMap();
        this.initSubControllers();
    }

    private void initSubControllers() {
        Reflection.getAllFieldsWithAnnotation(this.instance.getClass(), SubComponent.class).forEach(field -> {
            if (field.getType() == Provider.class) {
                field.setAccessible(true);
                try {
                    Class<?> type = ReflectionUtil.getProvidedClass(field);
                    if (type == null) {
                        throw new RuntimeException(FrameworkUtil.error(6006).formatted(field.getName(), field.getClass().getName()));
                    }
                    if (this.subControllerProviders.containsKey(type)) {
                        throw new RuntimeException(FrameworkUtil.error(6000).formatted(type.getName(), this.instance.getClass()));
                    }
                    this.subControllerProviders.put(type, (Provider)field.get(this.instance));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(FrameworkUtil.error(6001).formatted(field.getName(), field.getClass().getName()), e);
                }
                return;
            }
            if (!this.subControllerInstances.containsKey(field.getType())) {
                this.subControllerInstances.put(field.getType(), new ArrayList());
            }
            try {
                field.setAccessible(true);
                this.subControllerInstances.get(field.getType()).add(field.get(this.instance));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(FrameworkUtil.error(6002).formatted(field.getName(), field.getClass().getName()), e);
            }
        });
    }

    public Builder<?> getBuilder(Class<?> type) {
        if (type.isAnnotationPresent(Component.class)) {
            return new ControllerProxyBuilder(this, type);
        }
        return null;
    }

    public Object getProvidedInstance(Class<?> type) {
        if (this.subControllerInstances.containsKey(type)) {
            if (!this.subControllerInstances.get(type).isEmpty()) {
                Object instance = this.subControllerInstances.get(type).get(0);
                this.subControllerInstances.get(type).remove(0);
                return instance;
            }
            throw new RuntimeException(FrameworkUtil.error(6003).formatted(type.getName(), this.instance.getClass()));
        }
        if (this.subControllerProviders.containsKey(type)) {
            return this.subControllerProviders.get(type).get();
        }
        throw new RuntimeException(FrameworkUtil.error(6004).formatted(type.getName(), this.instance.getClass()));
    }
}

