/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.data;

import java.util.ArrayList;
import java.util.Collection;
import org.fulib.fx.data.TraversableTree;
import org.fulib.fx.util.FrameworkUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraversableNodeTree<E>
implements TraversableTree<E> {
    @NotNull
    private final Node<E> root = new Node<Object>("", null, null, null);
    @NotNull
    private Node<E> current = this.root;

    @Override
    @Nullable
    public E root() {
        return this.root.value();
    }

    @Override
    public E traverse(String path) {
        return this.follow(path, true);
    }

    @Override
    @Nullable
    public E get(String path) {
        return this.follow(path, false);
    }

    @Override
    public boolean containsPath(String path) {
        return this.follow(path, false) != null;
    }

    @Override
    @Nullable
    public E current() {
        return this.current.value();
    }

    @Override
    public void insert(@NotNull String path, @NotNull E value) {
        Node node = path.startsWith("/") ? this.root : this.current;
        for (String element : path.split("/")) {
            if (element.isBlank()) continue;
            if (element.equals("..")) {
                if (node.parent == null) {
                    throw new IllegalArgumentException(FrameworkUtil.error(3006));
                }
                node = node.parent;
                continue;
            }
            Node traversed = node;
            node = node.children().parallelStream().filter(child -> child.id().equals(element)).findAny().orElseGet(() -> {
                Node<Object> newChild = new Node<Object>(element, null, null, null);
                traversed.addChild(newChild);
                return newChild;
            });
        }
        node.value(value);
    }

    public Node<E> currentNode() {
        return this.current;
    }

    public void setCurrentNode(Node<E> node) {
        this.current = node;
    }

    private E follow(String path, boolean navigate) {
        Node node = path.startsWith("/") ? this.root : this.current;
        for (String element : path.split("/")) {
            if (element.isBlank()) continue;
            if (node == null) {
                return null;
            }
            if (element.equals("..")) {
                if (node.parent == null) continue;
                node = node.parent;
                continue;
            }
            node = node.children().parallelStream().filter(child -> child.id().equals(element)).findAny().orElse(null);
        }
        if (navigate && node != null) {
            this.current = node;
        }
        return node == null ? null : (E)node.value();
    }

    public static class Node<E> {
        @NotNull
        private final String id;
        @Nullable
        private E value;
        @Nullable
        private Node<E> parent;
        @Nullable
        private Collection<Node<E>> children;

        public Node(@NotNull String id, @Nullable E value, @Nullable Node<E> parent, @Nullable Collection<Node<E>> children) {
            this.id = id;
            this.value = value;
            this.parent = parent;
            this.children = children;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        @Nullable
        public E value() {
            return this.value;
        }

        @Nullable
        public Node<E> parent() {
            return this.parent;
        }

        @NotNull
        public Collection<Node<E>> children() {
            if (this.children == null) {
                this.children = new ArrayList<Node<E>>();
            }
            return this.children;
        }

        public void value(@Nullable E value) {
            this.value = value;
        }

        public void addChild(Node<E> child) {
            this.children().add(child);
            if (child.parent != null) {
                child.parent.removeChild(child);
            }
            child.parent = this;
        }

        public void removeChild(Node<E> child) {
            child.parent = null;
            if (this.children == null) {
                return;
            }
            this.children.remove(child);
        }
    }
}

