/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.fx.controller;

import dagger.Lazy;
import io.reactivex.rxjava3.disposables.Disposable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.BuilderFactory;
import javafx.util.Pair;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.fulib.fx.FulibFxApp;
import org.fulib.fx.annotation.controller.Component;
import org.fulib.fx.annotation.controller.Controller;
import org.fulib.fx.annotation.event.OnKey;
import org.fulib.fx.controller.Subscriber;
import org.fulib.fx.controller.building.ControllerBuildFactory;
import org.fulib.fx.controller.exception.IllegalControllerException;
import org.fulib.fx.controller.internal.FxSidecar;
import org.fulib.fx.controller.internal.ReflectionSidecar;
import org.fulib.fx.data.disposable.RefreshableCompositeDisposable;
import org.fulib.fx.util.ControllerUtil;
import org.fulib.fx.util.FileUtil;
import org.fulib.fx.util.FrameworkUtil;
import org.fulib.fx.util.KeyEventHolder;
import org.fulib.fx.util.ReflectionUtil;
import org.fulib.fx.util.reflection.Reflection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@ApiStatus.Internal
public class ControllerManager {
    private final RefreshableCompositeDisposable cleanup = new RefreshableCompositeDisposable();
    private static ResourceBundle defaultResourceBundle;
    private final Map<Class<?>, FxSidecar<?>> sidecars = new IdentityHashMap();
    private final Map<Object, Collection<KeyEventHolder>> keyEventHandlers = new HashMap<Object, Collection<KeyEventHolder>>();
    @Inject
    Lazy<FulibFxApp> app;

    @Inject
    public ControllerManager() {
    }

    public Node initAndRender(Object instance, Map<String, Object> parameters) {
        this.init(instance, parameters, true);
        return this.render(instance, parameters);
    }

    public Disposable init(@NotNull Object instance, @NotNull @NotNull Map<@NotNull String, @Nullable Object> parameters, boolean disposeOnNewMainController) {
        Disposable disposable = Disposable.fromRunnable(() -> this.destroy(instance));
        this.init(instance, parameters);
        if (disposeOnNewMainController) {
            this.cleanup.add(disposable);
        }
        return disposable;
    }

    public void init(@NotNull Object instance, @NotNull @NotNull Map<@NotNull String, @Nullable Object> parameters) {
        if (!ControllerUtil.isController(instance)) {
            throw new IllegalControllerException(FrameworkUtil.error(1001).formatted(instance.getClass().getName()));
        }
        this.getSidecar(instance).init(instance, parameters);
    }

    @NotNull
    private <T> FxSidecar<T> getSidecar(@NotNull T instance) {
        Class<?> instanceClass = instance.getClass();
        if (this.sidecars.containsKey(instanceClass)) {
            return this.sidecars.get(instanceClass);
        }
        FxSidecar<?> sidecar = this.createSidecar(instanceClass);
        this.sidecars.put(instanceClass, sidecar);
        return sidecar;
    }

    @NotNull
    private <T> FxSidecar<T> createSidecar(Class<T> componentClass) {
        Class<?> sidecarClass = Class.forName(componentClass.getModule(), componentClass.getName() + "_Fx");
        if (sidecarClass == null) {
            return new ReflectionSidecar<T>(this, componentClass);
        }
        try {
            return (FxSidecar)sidecarClass.getDeclaredConstructor(ControllerManager.class).newInstance(this);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public Node render(Object instance, Map<String, Object> parameters) {
        boolean component;
        boolean bl = component = instance.getClass().isAnnotationPresent(Component.class) && ControllerUtil.isComponent(instance);
        if (!component && !instance.getClass().isAnnotationPresent(Controller.class)) {
            throw new IllegalArgumentException(FrameworkUtil.error(1001).formatted(instance.getClass().getName()));
        }
        Node node = this.getSidecar(instance).render(instance, parameters);
        this.registerKeyEvents(instance);
        return node;
    }

    private void registerKeyEvents(Object instance) {
        ReflectionUtil.getAllNonPrivateMethodsOrThrow(instance.getClass(), OnKey.class).forEach(method -> {
            OnKey annotation = method.getAnnotation(OnKey.class);
            EventType<KeyEvent> type = annotation.type().asEventType();
            EventHandler<KeyEvent> handler = this.createKeyEventHandler((Method)method, instance, annotation);
            this.keyEventHandlers.computeIfAbsent(instance, k -> new HashSet()).add(new KeyEventHolder(annotation.target(), type, handler));
            switch (annotation.target()) {
                case SCENE: {
                    ((FulibFxApp)((Object)((Object)this.app.get()))).stage().getScene().addEventFilter(type, handler);
                    break;
                }
                case STAGE: {
                    ((FulibFxApp)((Object)((Object)this.app.get()))).stage().addEventFilter(type, handler);
                }
            }
        });
    }

    public void destroy(@NotNull Object instance) {
        if (!ControllerUtil.isController(instance)) {
            throw new IllegalArgumentException(FrameworkUtil.error(1001).formatted(instance.getClass().getName()));
        }
        this.getSidecar(instance).destroy(instance);
        this.cleanUpListeners(instance);
        if (FrameworkUtil.runningInDev()) {
            Reflection.getFieldsOfType(instance.getClass(), Subscriber.class).map(field -> {
                try {
                    field.setAccessible(true);
                    return new Pair(field, (Object)((Subscriber)field.get(instance)));
                }
                catch (IllegalAccessException e) {
                    return null;
                }
            }).filter(Objects::nonNull).filter(pair -> pair.getKey() != null).filter(pair -> !((Subscriber)pair.getValue()).isDisposed()).forEach(pair -> FulibFxApp.LOGGER.warning("Found undestroyed subscriber '%s' in class '%s'.".formatted(((Field)pair.getKey()).getName(), instance.getClass().getName())));
        }
    }

    public void cleanup() {
        this.cleanup.dispose();
        this.cleanup.refresh();
    }

    @ApiStatus.Internal
    @NotNull
    public Node loadFXML(@NotNull String fileName, @NotNull Object instance, boolean setRoot) {
        URL url = instance.getClass().getResource(fileName);
        if (url == null) {
            String urlPath = instance.getClass().getPackageName().replace(".", "/") + "/" + fileName;
            throw new RuntimeException(FrameworkUtil.error(2000).formatted(urlPath));
        }
        File file = FileUtil.getResourceAsLocalFile(FulibFxApp.resourcesPath(), instance.getClass(), fileName);
        if (file.exists()) {
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(FrameworkUtil.error(2001).formatted(file.getAbsolutePath()), e);
            }
        }
        ControllerBuildFactory builderFactory = new ControllerBuildFactory(instance);
        FXMLLoader loader = new FXMLLoader(url);
        loader.setControllerFactory(c -> instance);
        loader.setBuilderFactory((BuilderFactory)builderFactory);
        ResourceBundle resourceBundle = this.getResourceBundle(instance);
        if (resourceBundle != null) {
            loader.setResources(resourceBundle);
        }
        if (setRoot) {
            loader.setRoot(instance);
        }
        try {
            return (Node)loader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(FrameworkUtil.error(2002).formatted(instance.getClass()), exception);
        }
    }

    @Nullable
    private ResourceBundle getResourceBundle(@NotNull Object instance) {
        return this.getSidecar(instance).getResources(instance);
    }

    @Nullable
    public ResourceBundle getDefaultResourceBundle() {
        return defaultResourceBundle;
    }

    public void setDefaultResourceBundle(ResourceBundle resourceBundle) {
        defaultResourceBundle = resourceBundle;
    }

    private EventHandler<KeyEvent> createKeyEventHandler(Method method, Object instance, OnKey annotation) {
        boolean hasEventParameter;
        boolean bl = hasEventParameter = method.getParameterCount() == 1 && method.getParameterTypes()[0].isAssignableFrom(KeyEvent.class);
        if (!hasEventParameter && method.getParameterCount() != 0) {
            throw new RuntimeException(FrameworkUtil.error(1010).formatted(method.getName(), instance.getClass().getName()));
        }
        method.setAccessible(true);
        return event -> {
            if (this.keyEventMatchesAnnotation((KeyEvent)event, annotation)) {
                try {
                    if (hasEventParameter) {
                        method.invoke(instance, event);
                    } else {
                        method.invoke(instance, new Object[0]);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(FrameworkUtil.error(1005).formatted(method.getName(), annotation.getClass().getSimpleName(), method.getClass()), e);
                }
            }
        };
    }

    private boolean keyEventMatchesAnnotation(KeyEvent event, OnKey annotation) {
        return !(annotation.code() != KeyCode.UNDEFINED && event.getCode() != annotation.code() || !annotation.character().isEmpty() && !event.getCharacter().equals(annotation.character()) || !annotation.text().isEmpty() && !event.getText().equals(annotation.text()) || !event.isShiftDown() && annotation.shift() || !event.isControlDown() && annotation.control() || !event.isAltDown() && annotation.alt() || !event.isMetaDown() && annotation.meta());
    }

    private void cleanUpListeners(Object instance) {
        Collection<KeyEventHolder> handlers = this.keyEventHandlers.remove(instance);
        if (handlers == null) {
            return;
        }
        for (KeyEventHolder holder : handlers) {
            switch (holder.target()) {
                case SCENE: {
                    ((FulibFxApp)((Object)this.app.get())).stage().getScene().removeEventFilter(holder.type(), holder.handler());
                    break;
                }
                case STAGE: {
                    ((FulibFxApp)((Object)this.app.get())).stage().removeEventFilter(holder.type(), holder.handler());
                }
            }
        }
    }

    public Optional<String> getTitle(@NotNull Object instance) {
        return Optional.ofNullable(this.getSidecar(instance).getTitle(instance));
    }
}

